VERSION 5.00
Begin VB.Form frmMain 
   Caption         =   "PortNumExample"
   ClientHeight    =   4950
   ClientLeft      =   60
   ClientTop       =   375
   ClientWidth     =   6285
   LinkTopic       =   "Form1"
   ScaleHeight     =   4950
   ScaleWidth      =   6285
   StartUpPosition =   3  'Windows Default
   Begin VB.TextBox txtData 
      Height          =   4695
      Left            =   120
      MultiLine       =   -1  'True
      ScrollBars      =   2  'Vertical
      TabIndex        =   2
      Top             =   120
      Width           =   4695
   End
   Begin VB.CommandButton cmdQuit 
      Caption         =   "Quit"
      Height          =   375
      Left            =   5040
      TabIndex        =   1
      Top             =   840
      Width           =   1095
   End
   Begin VB.CommandButton cmdRefresh 
      Caption         =   "Refresh"
      Height          =   375
      Left            =   5040
      TabIndex        =   0
      Top             =   240
      Width           =   1095
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False

Option Explicit

Private Sub cmdQuit_Click()

    End
    
End Sub

Private Sub cmdRefresh_Click()

    FillDeviceList
    
End Sub

Private Sub Form_Load()

    hUSBDevice = INVALID_HANDLE_VALUE
    Call FillDeviceList
    
End Sub

Public Sub FillDeviceList()

    Call EnumDevices
    Call GetDeviceData
    
End Sub

Public Sub EnumDevices()

    Status = CP210x_GetNumDevices(devNum)
    
End Sub

Public Sub GetDeviceData()

    'Variable for carriage returns
    Dim CR As String
    CR = Chr(13) + Chr(10)
    
    'Variables for the Vid, Pid and Serial Number (SN is a String of chars of length SerialLength)
    Dim Vid As Long
    Dim Pid As Long
    Dim SerialString(CP210x_MAX_SERIAL_STRLEN) As Byte
    Dim SerialLength As Long
        
    'String to hold all our current data to display
    Dim TempString As String
    TempString = ""
    Dim i
    
    For i = 0 To devNum - 1
        Status = CP210x_Open(i, hUSBDevice)
        If Status = CP210x_SUCCESS Then
            Status = CP210x_GetDeviceVid(hUSBDevice, Vid)
            If Status = CP210x_SUCCESS Then
                Status = CP210x_GetDevicePid(hUSBDevice, Pid)
                If Status = CP210x_SUCCESS Then
                    Status = CP210x_GetDeviceSerialNumber(hUSBDevice, SerialString(0), SerialLength, True)
                    If Status = CP210x_SUCCESS Then
                        CP210x_Close (hUSBDevice)
                        TempString = TempString + "Found Device: VID=" + Hex(Vid) + ", PID=" + Hex(Pid) + CR
                        TempString = TempString + "           Serial Num=" + ConvertToString(SerialString(), SerialLength) + CR
                    End If
                    CP210x_Close (hUSBDevice)
                End If
                CP210x_Close (hUSBDevice)
            End If
            CP210x_Close (hUSBDevice)
        End If
        
        Dim Port As Integer
        Dim WinVersion As Long
        WinVersion = GetVersion() And VERSION_MASK
        If WinVersion = VERSION_WINXP2000 Or WinVersion = VERSION_WINVISTA Then
            Port = GetPortNumXP2000Vista(Vid, Pid, SerialString(), SerialLength)
        ElseIf WinVersion = VERSION_WIN98 Then
            Port = GetPortNum98(Vid, Pid, SerialString(), SerialLength)
        End If
        
        TempString = TempString + "This device is on COM Port: " + Str(Port) + CR + CR
         
        CP210x_Close (hUSBDevice)
    Next
    
    txtData = TempString + CR + CR
    
End Sub

Private Sub Form_Unload(Cancel As Integer)

    CP210x_Close (hUSBDevice)
    
End Sub

Public Function ConvertToString(ConvertArray() As Byte, ConvertLength As Long) As String

    Dim ConvertString As String
    ConvertString = ""
    
    Dim i
    
    For i = 0 To ConvertLength - 1
        ConvertString = ConvertString + Chr(ConvertArray(i))
    Next
    
    ConvertToString = ConvertString
    
End Function


Public Function GetPortNumXP2000Vista(Vid As Long, Pid As Long, SerialString() As Byte, SerialLength As Long) As Integer

        Dim HKLMKey As Long
        Dim EnumKey As Long
        Dim VidPidKey As Long
        Dim PortKey As Long
        Dim Length As Long
        Dim Valtype As Long
        Dim TmpStr(101) As Byte
        Length = 100
        Dim PortNum As Integer
        Dim VidPidString As String
               
        PortNum = -1
        
        Dim i
        
        If ERROR_SUCCESS = RegOpenKeyEx(HKEY_LOCAL_MACHINE, "SYSTEM\CurrentControlSet\", 0, KEY_READ, HKLMKey) Then
            If ERROR_SUCCESS = RegOpenKey(HKLMKey, "Enum\USB\", EnumKey) Then
                For i = 0 To SerialLength
                    If SerialString(i) = 32 Then
                        SerialString(i) = 95
                    End If
                Next
                VidPidString = "Vid_" + Right("0000" & LCase(Hex(Vid)), 4) + "&Pid_" + Right("0000" & LCase(Hex(Pid)), 4) + "&Mi_00\" + ConvertToString(SerialString(), SerialLength) + "_00"
                If ERROR_SUCCESS = RegOpenKey(EnumKey, VidPidString, VidPidKey) Then
                    If ERROR_SUCCESS = RegOpenKey(VidPidKey, "Device Parameters", PortKey) Then
                        If ERROR_SUCCESS = RegQueryValueEx(PortKey, "PortName", 0, Valtype, TmpStr(0), Length) Then
                            TmpStr(0) = 48
                            TmpStr(1) = 48
                            TmpStr(2) = 48
                            PortNum = Val(ConvertToString(TmpStr(), Length - 1))
                        End If
                        RegCloseKey (PortKey)
                    End If
                    RegCloseKey (VidPidKey)
                Else
                    VidPidString = "Vid_" + Right("0000" & LCase(Hex(Vid)), 4) + "&Pid_" + Right("0000" & LCase(Hex(Pid)), 4) + "\" + ConvertToString(SerialString(), SerialLength)
                    If ERROR_SUCCESS = RegOpenKey(EnumKey, VidPidString, VidPidKey) Then
                        If ERROR_SUCCESS = RegOpenKey(VidPidKey, "Device Parameters", PortKey) Then
                            If ERROR_SUCCESS = RegQueryValueEx(PortKey, "PortName", 0, Valtype, TmpStr(0), Length) Then
                                TmpStr(0) = 48
                                TmpStr(1) = 48
                                TmpStr(2) = 48
                                PortNum = Val(ConvertToString(TmpStr(), Length - 1))
                            End If
                            RegCloseKey (PortKey)
                        End If
                        RegCloseKey (VidPidKey)
                    End If
                End If
                RegCloseKey (EnumKey)
            End If
            RegCloseKey (HKLMKey)
        End If
        RegCloseKey (HKEY_LOCAL_MACHINE)
        
        GetPortNumXP2000Vista = PortNum
        
End Function


Public Function GetPortNum98(Vid As Long, Pid As Long, SerialString() As Byte, SerialLength As Long) As Integer

    Dim PortKey As Long
    Dim Length As Long
    Dim Valtype As Long
    Dim TmpStr(101) As Byte
    Length = 100
    Dim PortNum As Integer
    Dim VidPidString As String
    Dim SerialIndex As Integer
    Dim SerialKeyString As String
    Dim Status As Long
           
    PortNum = -1
    
    SerialIndex = 0
    SerialKeyString = "Enum\SLABCR\guid\000" + Trim(Str(SerialIndex))
    
    Dim i
    
    For i = 0 To SerialLength
        If SerialString(i) = 32 Then
            SerialString(i) = 95
        ElseIf ((SerialString(i) >= &H61) And (SerialString(i) <= &H7A)) Then
            SerialString(i) = SerialString(i) - 32
        End If
    Next
    
    VidPidString = "USB\VID_" + UCase(Hex(Vid)) + "&PID_" + UCase(Hex(Pid)) + "&MI_00\" + ConvertToString(SerialString, SerialLength) + "_00"
    
    Do While ERROR_SUCCESS = RegOpenKey(HKEY_LOCAL_MACHINE, SerialKeyString, PortKey)
        Status = RegQueryValueEx(PortKey, "CRLowerDeviceID", 0, Valtype, TmpStr(0), Length)
        If Status = ERROR_MORE_DATA Then
            SerialIndex = SerialIndex - 1
        ElseIf Status = ERROR_SUCCESS Then
            If VidPidString = ConvertToString(TmpStr(), Length - 1) Then
                If ERROR_SUCCESS = RegQueryValueEx(PortKey, "PortName", 0, Valtype, TmpStr(0), Length) Then
                    TmpStr(0) = 48
                    TmpStr(1) = 48
                    TmpStr(2) = 48
                    PortNum = Val(ConvertToString(TmpStr(), Length - 1))
                End If
            End If
        End If
        
        SerialIndex = SerialIndex + 1
        SerialKeyString = "Enum\SLABCR\guid\000" + Trim(Str(SerialIndex))
        
        RegCloseKey (PortKey)
    Loop
    RegCloseKey (HKEY_LOCAL_MACHINE)
        
    GetPortNum98 = PortNum

End Function

