Attribute VB_Name = "modCP210x"
Option Explicit

' Declare statements for all the functions in the CP210x DLL
' NOTE: These statements assume that the DLL file is located in
'       the same directory as this project.
'       If you change the location of the DLL, be sure to change the location
'       in the declare statements also.
Public Declare Function CP210x_GetNumDevices Lib "CP210xManufacturing.dll" (ByRef lpwdNumDevices As Long) As Integer
Public Declare Function CP210x_GetProductString Lib "CP210xManufacturing.dll" (ByVal dwDeviceNum As Long, ByRef lpvDeviceString As Byte, ByVal dwFlags As Long) As Integer
Public Declare Function CP210x_Open Lib "CP210xManufacturing.dll" (ByVal dwDevice As Long, ByRef cyHandle As Long) As Integer
Public Declare Function CP210x_Close Lib "CP210xManufacturing.dll" (ByVal cyHandle As Long) As Integer
Public Declare Function CP210x_Reset Lib "CP210xManufacturing.dll" (ByVal cyHandle As Long) As Integer

Public Declare Function CP210x_SetVid Lib "CP210xManufacturing.dll" (ByVal cyHandle As Long, wVid As Long) As Integer
Public Declare Function CP210x_SetPid Lib "CP210xManufacturing.dll" (ByVal cyHandle As Long, wPid As Long) As Integer
Public Declare Function CP210x_SetProductString Lib "CP210xManufacturing.dll" (ByVal cyHandle As Long, ByRef lpProduct As Byte, bLength As Long) As Integer
Public Declare Function CP210x_SetSerialNumber Lib "CP210xManufacturing.dll" (ByVal cyHandle As Long, ByRef lpSerialNumber As Byte, bLength As Long) As Integer
Public Declare Function CP210x_SetSelfPower Lib "CP210xManufacturing.dll" (ByVal cyHandle As Long, bSelfPower As Boolean) As Integer
Public Declare Function CP210x_SetMaxPower Lib "CP210xManufacturing.dll" (ByVal cyHandle As Long, bMaxPower As Long) As Integer
Public Declare Function CP210x_SetDeviceVersion Lib "CP210xManufacturing.dll" (ByVal cyHandle As Long, wVersion As Long) As Integer

Public Declare Function CP210x_GetDeviceVid Lib "CP210xManufacturing.dll" (ByVal cyHandle As Long, ByRef wVid As Long) As Integer
Public Declare Function CP210x_GetDevicePid Lib "CP210xManufacturing.dll" (ByVal cyHandle As Long, ByRef wPid As Long) As Integer
Public Declare Function CP210x_GetDeviceProductString Lib "CP210xManufacturing.dll" (ByVal cyHandle As Long, ByRef lpProduct As Byte, ByRef bLength As Long) As Integer
Public Declare Function CP210x_GetDeviceSerialNumber Lib "CP210xManufacturing.dll" (ByVal cyHandle As Long, ByRef lpSerialNumber As Byte, ByRef bLength As Long, bConvertToUnicode As Boolean) As Integer
Public Declare Function CP210x_GetSelfPower Lib "CP210xManufacturing.dll" (ByVal cyHandle As Long, ByRef bSelfPower As Boolean) As Integer
Public Declare Function CP210x_GetMaxPower Lib "CP210xManufacturing.dll" (ByVal cyHandle As Long, ByRef bMaxPower As Long) As Integer
Public Declare Function CP210x_GetDeviceVersion Lib "CP210xManufacturing.dll" (ByVal cyHandle As Long, ByRef wVersion As Long) As Integer


'Masks for the serial number and description
Public Const CP210x_RETURN_SERIAL_NUMBER = &H0
Public Const CP210x_RETURN_DESCRIPTION = &H1
Public Const CP210x_RETURN_FULL_PATH = &H2

'Masks for return values from the device
Public Const CP210x_SUCCESS = &H0
Public Const CP210x_DEVICE_NOT_FOUND = &HFF
Public Const CP210x_INVALID_HANDLE = &H1
Public Const CP210x_INVALID_PARAMETER = &H2
Public Const CP210x_DEVICE_IO_FAILED = &H3

'Maximum Length of Strings
Public Const CP210x_MAX_DEVICE_STRLEN = 256
Public Const CP210x_MAX_PRODUCT_STRLEN = 126
Public Const CP210x_MAX_SERIAL_STRLEN = 63
Public Const CP210x_MAX_MAXPOWER = 250

Public Const INVALID_HANDLE_VALUE = &H1


