// PortNumExampleDlg.cpp : implementation file
//

#include "stdafx.h"
#include "PortNumExample.h"
#include "PortNumExampleDlg.h"
#include "CP210xManufacturingDLL.h"
#include <string.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPortNumExampleDlg dialog

CPortNumExampleDlg::CPortNumExampleDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CPortNumExampleDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CPortNumExampleDlg)
	m_Data = _T("");
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CPortNumExampleDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPortNumExampleDlg)
	DDX_Text(pDX, IDC_EDIT_DATA, m_Data);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CPortNumExampleDlg, CDialog)
	//{{AFX_MSG_MAP(CPortNumExampleDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_REFRESH, OnRefresh)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPortNumExampleDlg message handlers

BOOL CPortNumExampleDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		if (strAboutMenu.LoadString(IDS_ABOUTBOX) && !strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// Init. member variables
	m_hUSBDevice = INVALID_HANDLE_VALUE;
	
	// Get devices, init. combo box with their names
	FillDeviceList();

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CPortNumExampleDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CPortNumExampleDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CPortNumExampleDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}


void CPortNumExampleDlg::FillDeviceList()
{
	EnumDevices();
	GetDeviceData();
}


void CPortNumExampleDlg::EnumDevices()
{
	//Obtain the number of connected devices
	const CP210x_STATUS status = CP210x_GetNumDevices(&m_dwNumDevices);
	if (CP210x_SUCCESS != status)
	{
		// TODO: Do What?
	}

	return;	// void
}


void CPortNumExampleDlg::GetDeviceData()
{
	UpdateData(TRUE);

	//Variables to store Vid, Pid and SerialNumbers
	BYTE PartNum;
	WORD Vid, Pid;
	CP210x_SERIAL_STRING serialNum;

	//Reset m_Data to blank since we are retrieving new device data
	//Whenever we have new information to show, the string will be
	//added onto this variable.
	m_Data = "";

	DWORD i = 0;

	//Loop through and display data for each connected device
	for (i = 0; i < m_dwNumDevices; i++)
	{
		// Query the Vid, Pid and Serial number of each device.
		// We will use this information to look up the device
		// in the registry to find the port number. There are also
		// examples of displaying other items in the registry as well.

		// Open device
		CP210x_STATUS status = CP210x_Open(i, &m_hUSBDevice);
		if (status == CP210x_SUCCESS)
		{
			// Get Vid
			status = CP210x_GetDeviceVid(m_hUSBDevice, &Vid);
			if (status == CP210x_SUCCESS)
			{
				// Get Pid
				status = CP210x_GetDevicePid(m_hUSBDevice, &Pid);
				if (status == CP210x_SUCCESS)
				{
					BYTE bLength = 0;

					// Get Serial Number
					status = CP210x_GetDeviceSerialNumber(m_hUSBDevice, serialNum, &bLength);

					// Null terminate to make it a string
					serialNum[bLength] = '\0';

					if (status == CP210x_SUCCESS)
					{
						status = CP210x_GetPartNumber(m_hUSBDevice, &PartNum);
					}
				}
			}
		}

		if (CP210x_SUCCESS != status)
		{
			continue;	// Open, GetDeviceVid, GetDevicePid, GetDeviceSerialNumber or GetPartNumber failed. Don't carry on.
		}

		// This is a function call to obtain the port number
		// by passing the Vid, Pid, and SN of the device in
		// question. An integer value with the port is passed back
		int Port;
		CString tmpDevStr;
		wchar_t* tmpPortString;
		tmpPortString = new wchar_t[10];

		// Get the port number for interface 0
		Port = GetPortNum(Vid, Pid, serialNum, 0);

		//Display our current information about the device we found
		tmpDevStr.Format(L"Found Device: VID=%04X, PID=%04X", Vid, Pid);

		m_Data += tmpDevStr;
		m_Data += (wchar_t)0xD;
		m_Data += (wchar_t)0xA;
		m_Data += L"           Serial Num=";
		m_Data += serialNum;
		m_Data += (wchar_t)0xD;
		m_Data += (wchar_t)0xA;
		m_Data += L"  Interface=0";
		m_Data += (wchar_t)0xD;
		m_Data += (wchar_t)0xA;

		// Text formatting for display of the com port
		m_Data += L"This device is on COM Port: ";
		_itow_s(Port, tmpPortString, 10, 10);
		m_Data += (CString)tmpPortString;
		m_Data += (wchar_t)0xD;
		m_Data += (wchar_t)0xA;

		if (PartNum == CP210x_CP2105_VERSION)
		{
			Port = GetPortNum(Vid, Pid, serialNum, 1);

			//Display our current information about the device we found
			m_Data += L"  Interface=1";
			m_Data += (wchar_t)0xD;
			m_Data += (wchar_t)0xA;

			// Text formatting for display of the com port
			m_Data += L"This device is on COM Port: ";
			_itow_s(Port, tmpPortString, 10, 10);
			m_Data += (CString)tmpPortString;
			m_Data += (wchar_t)0xD;
			m_Data += (wchar_t)0xA;

			// Since we've listed both CP2105 ports increment
			// the device num to get at the next true device
			i++;
		}

        if (PartNum == CP210x_CP2108_VERSION)
		{
            for (int j = 1; j < 4; j++)
            {
			    Port = GetPortNum(Vid, Pid, serialNum, SILABS_CONVERT_INT_TO_BYTE(j));

			    //Display our current information about the device we found
			    m_Data += L"  Interface=";
                _itow_s(j, tmpPortString, 10, 10);
			    m_Data += (CString)tmpPortString;
			    m_Data += (wchar_t)0xD;
			    m_Data += (wchar_t)0xA;

			    // Text formatting for display of the com port
			    m_Data += L"This device is on COM Port: ";
			    _itow_s(Port, tmpPortString, 10, 10);
			    m_Data += (CString)tmpPortString;
			    m_Data += (wchar_t)0xD;
			    m_Data += (wchar_t)0xA;
            }

		    // Since we've listed all CP2108 ports increment
		    // the device num by 3 to get at the next true device
		    i+=3;
		}
		
		delete [] tmpPortString;

		//Close the USB Device
		CP210x_Close(m_hUSBDevice);

		m_Data += (wchar_t)0xD;
		m_Data += (wchar_t)0xA;
		m_Data += (wchar_t)0xD;
		m_Data += (wchar_t)0xA;
	}

	UpdateData(FALSE);
}


// GetPortNum functions takes the Vid, Pid, and SerialNumber and
// returns an integer containing the COM port that the device is
// connected to (different functions for Win98/WinXP2000Vista)

_Use_decl_annotations_
int CPortNumExampleDlg::GetPortNum(const WORD vid, const WORD pid, char* ser, const BYTE ifc)
{
	//Variables used for Registry access
	HKEY hkeyCurrentControlSet;
	DWORD valtype;
	wchar_t* portString;
	wchar_t* parentIdString;
	DWORD length = 100;
	portString = new wchar_t[101];
	parentIdString = new wchar_t[101];
	wchar_t tmpPortString[10];

	//Set portnum to -1, so if there is an error we will
	//know by returning a negative port value
	int portNum = -1;

	//  Open keys to get to the key where the port number is located. This key is:
	if (ERROR_SUCCESS == RegOpenKeyEx(HKEY_LOCAL_MACHINE, L"SYSTEM\\CurrentControlSet\\", 0, KEY_READ, &hkeyCurrentControlSet))
	{
		HKEY hkeyEnumUSB;

		if (ERROR_SUCCESS == RegOpenKey(hkeyCurrentControlSet, L"Enum\\USB\\", &hkeyEnumUSB))
		{
			HKEY tmpPortKey;
			CString portKeyString;

			//Loop through and replace spaces for WinXP2000Vista
			int i = 0;
			while (ser[i] != '\0')
			{
				if (ser[i] == 0x20)
					ser[i] = '_';
				i++;
			}

			//The portkey string should look like this
			//"Vid_XXXX&Pid_XXXX\\XXXX" where the XXXX's are Vid, Pid and serial string
			portKeyString = L"Vid_";
			_itow_s((int)vid, tmpPortString, 10, 16);
			portKeyString += tmpPortString;
			portKeyString += L"&Pid_";
			_itow_s((int)pid, tmpPortString, 10, 16);
			portKeyString += tmpPortString;
			portKeyString += L"\\";
			portKeyString += ser;
			portKeyString += L"\\Device Parameters\\";

			//If the portkey string is in the registry, then go ahead and open the portname
			if (ERROR_SUCCESS == RegOpenKeyEx(hkeyEnumUSB, portKeyString, 0, KEY_READ, &tmpPortKey))
			{
				// CP2101/2/3/4
				// This will only work for single interface devices, if it fails
				// we then look to see if it is a multi interface device
				if (ERROR_SUCCESS == RegQueryValueEx(tmpPortKey, L"PortName", NULL, &valtype, (unsigned char *)portString, &length))
				{
					// When we obtain this key, it will be in string format of
					// "COMXX" where XX is the port. Simply make the first three
					// elements of the string 0, and call the atoi function to obtain
					// the number of the port.
					portString[0] = '0';
					portString[1] = '0';
					portString[2] = '0';
					portNum = _wtoi(portString);
				}
				else
				{
					//Close the original port key
					RegCloseKey(tmpPortKey);
				
					// Reset our port key string to not include device paramaters
					portKeyString = L"Vid_";
					_itow_s((int)vid, tmpPortString, 10, 16);
					portKeyString += tmpPortString;
					portKeyString += L"&Pid_";
					_itow_s((int)pid, tmpPortString, 10, 16);
					portKeyString += tmpPortString;
					portKeyString += L"\\";
					portKeyString += ser;

					//If the portkey string is in the registry, then get the parent ID to start looking at
					//the multi interface devices
					if (ERROR_SUCCESS == RegOpenKeyEx(hkeyEnumUSB, portKeyString, 0, KEY_READ, &tmpPortKey))
					{
						if (ERROR_SUCCESS == RegQueryValueEx(tmpPortKey, L"ParentIdPrefix", NULL, &valtype, (unsigned char *)parentIdString, &length))
						{
							//Close the original port key, reopen the multi interface
							//devices
							RegCloseKey(tmpPortKey);
						
							// Reset our port key string to not include device paramaters and
							// the parent ID string, as well as interface info
							portKeyString = L"Vid_";
							_itow_s((int)vid, tmpPortString, 10, 16);
							portKeyString += tmpPortString;
							portKeyString += L"&Pid_";
							_itow_s((int)pid, tmpPortString, 10, 16);
							portKeyString += tmpPortString;
							portKeyString += L"&MI_";
							_itow_s((int)ifc, tmpPortString, 10, 16);
							if (ifc <= 0x0F)
							{
								portKeyString += L"0";
							}
							portKeyString += tmpPortString;
							portKeyString += L"\\";
							portKeyString += parentIdString;
							portKeyString += L"&00";
							if (ifc <= 0x0F)
							{
								portKeyString += L"0";
							}
							portKeyString += tmpPortString;
							portKeyString += "\\Device Parameters\\";

							if (ERROR_SUCCESS == RegOpenKeyEx(hkeyEnumUSB, portKeyString, 0, KEY_READ, &tmpPortKey))
							{
								if (ERROR_SUCCESS == RegQueryValueEx(tmpPortKey, L"PortName", NULL, &valtype, (unsigned char *)portString, &length))
								{
									// When we obtain this key, it will be in string format of
									// "COMXX" where XX is the port. Simply make the first three
									// elements of the string 0, and call the atoi function to obtain
									// the number of the port.
									portString[0] = '0';
									portString[1] = '0';
									portString[2] = '0';
									portNum = _wtoi(portString);
								}
							}
						}
					}
				}
				//Make sure to close all open keys for cleanup
				RegCloseKey(tmpPortKey);
			}

			RegCloseKey(hkeyEnumUSB);
		}
		RegCloseKey(hkeyCurrentControlSet);
	}
	RegCloseKey(HKEY_LOCAL_MACHINE);

	delete [] portString;
	delete [] parentIdString;

	// Return the number of the port the device is connected too
	return portNum;
}

void CPortNumExampleDlg::OnRefresh() 
{
	FillDeviceList();	
}
