// CP210xSerialTestDlg.cpp : implementation file
//

#include "stdafx.h"
#include "CP210xSerialTest.h"
#include "CP210xSerialTestDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CCP210xSerialTestDlg dialog

CCP210xSerialTestDlg::CCP210xSerialTestDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CCP210xSerialTestDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CCP210xSerialTestDlg)
	m_MasterPort = 0;
	m_SlavePort = 0;
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CCP210xSerialTestDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CCP210xSerialTestDlg)
	DDX_Text(pDX, IDC_PORT1, m_MasterPort);
	DDV_MinMaxByte(pDX, m_MasterPort, 1, 255);
	DDX_Text(pDX, IDC_PORT2, m_SlavePort);
	DDV_MinMaxByte(pDX, m_SlavePort, 1, 255);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CCP210xSerialTestDlg, CDialog)
	//{{AFX_MSG_MAP(CCP210xSerialTestDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_START, OnStart)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCP210xSerialTestDlg message handlers

BOOL CCP210xSerialTestDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here

	m_hMaster	= INVALID_HANDLE_VALUE;
	m_hSlave	= INVALID_HANDLE_VALUE;
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CCP210xSerialTestDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CCP210xSerialTestDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CCP210xSerialTestDlg::OnStart() 
{
	// TODO: Add your control notification handler code here
	
	UpdateData(TRUE);

	BOOL transferSuccess = true;

	CString masterString, slaveString;

	masterString.Format("\\\\.\\COM%d", m_MasterPort);
	slaveString.Format("\\\\.\\COM%d", m_SlavePort);

	m_hMaster	= CreateFile(masterString, GENERIC_READ | GENERIC_WRITE, 0, 0, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL | FILE_FLAG_OVERLAPPED, 0);
	m_hSlave	= CreateFile(slaveString, GENERIC_READ | GENERIC_WRITE, 0, 0, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL | FILE_FLAG_OVERLAPPED, 0);

	if (m_hMaster != INVALID_HANDLE_VALUE)
	{
		if (m_hSlave != INVALID_HANDLE_VALUE)
		{
			if (PurgeComm(m_hMaster, PURGE_TXABORT | PURGE_RXABORT | PURGE_TXCLEAR | PURGE_RXCLEAR))
			{
				if (PurgeComm(m_hSlave, PURGE_TXABORT | PURGE_RXABORT | PURGE_TXCLEAR | PURGE_RXCLEAR))
				{
					if (GetCommState(m_hMaster, &m_DCBMasterInitState))
					{
						if (GetCommState(m_hSlave, &m_DCBSlaveInitState))
						{
							DCB dcbMaster = m_DCBMasterInitState;
							DCB dcbSlave = m_DCBSlaveInitState;

							dcbMaster.BaudRate= 57600;
							dcbMaster.Parity= NOPARITY;
							dcbMaster.ByteSize= 8;
							dcbMaster.StopBits= ONESTOPBIT;

							dcbSlave.BaudRate= 57600;
							dcbSlave.Parity= NOPARITY;
							dcbSlave.ByteSize= 8;
							dcbSlave.StopBits= ONESTOPBIT;

							COMMTIMEOUTS ctM, ctS;

							GetCommTimeouts(m_hMaster, &ctM);
							GetCommTimeouts(m_hSlave, &ctS);

							ctM.ReadTotalTimeoutConstant = 10000;
							ctS.ReadTotalTimeoutConstant = 10000;

							SetCommTimeouts(m_hMaster, &ctM);
							SetCommTimeouts(m_hSlave, &ctS);

							if (SetCommState(m_hMaster, &dcbMaster))
							{
								Sleep(60);

								if (SetCommState(m_hSlave, &dcbSlave))
								{
									Sleep(60);

									DWORD bytesWritten = 0, bytesRead = 0;

									BYTE sampleMasterData[64];
									BYTE sampleSlaveData[64];

									for (BYTE i = 0; i < 64; i++)
									{
										sampleMasterData[i] = i;
										sampleSlaveData[i] = 0;
									}

									if (WriteData(m_hMaster, sampleMasterData, 64, &bytesWritten))
									{
										if (ReadData(m_hSlave, sampleSlaveData, 64, &bytesRead, 1000))
										{
											transferSuccess = true;

											for (int i = 0; i < 64; i++)
												if (sampleMasterData[i] != sampleSlaveData[i]) transferSuccess = false;

											if (transferSuccess)
											{
												for (BYTE i = 0; i < 64; i++)
												{
													sampleMasterData[i] = 0;
													sampleSlaveData[i] = i;
												}

												if (WriteData(m_hMaster, sampleMasterData, 64, &bytesWritten))
												{
													if (ReadData(m_hSlave, sampleSlaveData, 64, &bytesRead, 1000))
													{
														transferSuccess = true;

														for (int i = 0; i < 64; i++)
														{
															if (sampleMasterData[i] != sampleSlaveData[i])
															{
																transferSuccess = false;
															}
														}

														if (transferSuccess)
															MessageBox("Test Successful!", "Success", MB_OK | MB_ICONERROR);
														else
															MessageBox("Error in data on Slave to Master transfer", "Error", MB_OK | MB_ICONERROR);
													}
													else
														MessageBox("Error reading data from Master COM port", "Error", MB_OK | MB_ICONERROR);
												}
												else
													MessageBox("Error writing data to Slave COM port", "Error", MB_OK | MB_ICONERROR);
											}
											else
												MessageBox("Error in data on Master to Slave transfer", "Error", MB_OK | MB_ICONERROR);
										}
										else
											MessageBox("Error reading data from Slave COM port", "Error", MB_OK | MB_ICONERROR);
									}
									else
										MessageBox("Error writing data to Master COM port", "Error", MB_OK | MB_ICONERROR);

									SetCommState(m_hSlave, &m_DCBSlaveInitState);
								}
								else
									MessageBox("Error setting Slave COM port state", "Error", MB_OK | MB_ICONERROR);
							
								SetCommState(m_hMaster, &m_DCBMasterInitState);
							}
							else
								MessageBox("Error setting Master COM port state", "Error", MB_OK | MB_ICONERROR);
						}
						else
							MessageBox("Error getting Slave COM port state", "Error", MB_OK | MB_ICONERROR);
					}
					else
						MessageBox("Error getting Master COM port state", "Error", MB_OK | MB_ICONERROR);
				}
				else
					MessageBox("Error purging Slave COM port", "Error", MB_OK | MB_ICONERROR);
			}
			else
				MessageBox("Error purging Master COM port", "Error", MB_OK | MB_ICONERROR);
			
			CloseHandle(m_hSlave);
			m_hSlave = INVALID_HANDLE_VALUE;
		}
		else
			MessageBox("Error opening Slave COM port", "Error", MB_OK | MB_ICONERROR);

		CloseHandle(m_hMaster);
		m_hMaster = INVALID_HANDLE_VALUE;
	}
	else
		MessageBox("Error opening Master COM port", "Error", MB_OK | MB_ICONERROR);
}

bool CCP210xSerialTestDlg::WriteData(HANDLE handle, BYTE* data, DWORD length, DWORD* dwWritten)
{
	bool success = false;
	OVERLAPPED o = {0};

	o.hEvent = CreateEvent(NULL, FALSE, FALSE, NULL);
	if (NULL != o.hEvent)
	{
		if (!WriteFile(handle, (LPCVOID)data, length, dwWritten, &o))
		{
			if (GetLastError() == ERROR_IO_PENDING)
				if (WaitForSingleObject(o.hEvent, INFINITE) == WAIT_OBJECT_0)
					if (GetOverlappedResult(handle, &o, dwWritten, FALSE))
						success = true;
		}
		else
			success = true;

		if (*dwWritten != length)
			success = false;

		CloseHandle(o.hEvent);
		o.hEvent = (HANDLE) NULL;
	}
	
	return success;
}

bool CCP210xSerialTestDlg::ReadData(HANDLE handle, BYTE* data, DWORD length, DWORD* dwRead, UINT timeout)
{
	bool success = false;
	OVERLAPPED o = {0};
	
	o.hEvent = CreateEvent(NULL, FALSE, FALSE, NULL);
	if (NULL != o.hEvent)
	{
		if (!ReadFile(handle, data, length, dwRead, &o))
		{
			if (GetLastError() == ERROR_IO_PENDING)
				if (WaitForSingleObject(o.hEvent, timeout) == WAIT_OBJECT_0)
					success = true;
			GetOverlappedResult(handle, &o, dwRead, FALSE);
		}
		else
			success = true;

		CloseHandle(o.hEvent);
	}
	
	return success;
}

