//-----------------------------------------------------------------------------
// F580_FlashUtils.h
//-----------------------------------------------------------------------------
// Copyright 2008 Silicon Laboratories, Inc.
//
// This program contains several useful utilities for writing and updating
// FLASH memory.
//
// Target:         C8051F580
// Tool chain:     Raisonance / Keil / SDCC
// Command Line:   None
//
// Release 1.2 / 26 AUG 2014 (ST)
//    -Added Flash_Test.c
//    -Removed references to scratchpad memory/SFLE bit
//    -Corrected FLASH_TEMP and FLASH_LAST addresses for 96kB flash size
//
// Release 1.1 / 11 MAR 2010 (GP)
//    -Tested with Raisonance
//    -Updated to meet new data sheet guidelines for writing/erasing
//
// Release 1.0 / 23 OCT 2008 (GP)
//    -Initial Revision
//

#ifndef F580_FLASHUTILS_H
#define F580_FLASHUTILS_H

//-----------------------------------------------------------------------------
// Includes
//-----------------------------------------------------------------------------

#include "si_toolchain.h"
#include "F580_FlashPrimitives.h"

//-----------------------------------------------------------------------------
// Structures, Unions, Enumerations, and Type Definitions
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Global Constants
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Exported Function Prototypes
//-----------------------------------------------------------------------------

// FLASH read/write/erase routines
extern void FLASH_Write (FLADDR dest, uint8_t *src, uint16_t numbytes);
extern uint8_t * FLASH_Read  (uint8_t *dest, FLADDR src, uint16_t numbytes);
extern void FLASH_Clear (FLADDR addr, uint16_t numbytes);

// FLASH update/copy routines
extern void FLASH_Update (FLADDR dest, uint8_t *src, uint16_t numbytes);
extern void FLASH_Copy   (FLADDR dest, FLADDR src, uint16_t numbytes);

// FLASH test routines
extern void FLASH_Fill (FLADDR addr, uint32_t length, uint8_t fill);

#endif // F580_FLASHUTILS_H


//-----------------------------------------------------------------------------
// End Of File
//-----------------------------------------------------------------------------