//-----------------------------------------------------------------------------
// Si1000_FlashPrimitives.h
//-----------------------------------------------------------------------------
// Copyright 2012 Silicon Laboratories, Inc.
//
// This program contains several useful utilities for writing and updating
// FLASH memory.
//
// Target:         Si100x
// Tool chain:     Raisonance / Keil / SDCC
// Command Line:   None
//
// Release 1.0 / 15 JUN 2012 (ST)
//    -Initial Revision
//

#ifndef Si1000_FLASHPRIMITIVES_H
#define Si1000_FLASHPRIMITIVES_H

//-----------------------------------------------------------------------------
// Includes
//-----------------------------------------------------------------------------

#include "si_toolchain.h"

//-----------------------------------------------------------------------------
// Global Constants
//-----------------------------------------------------------------------------

#define FLASH_SIZE  64                 // 64K or 32K

#ifndef FLASH_PAGESIZE
#define FLASH_PAGESIZE 1024L
#endif

#ifndef FLASH_SCRATCHSIZE
#define FLASH_SCRATCHSIZE 1024
#endif

//---------------------

#if (FLASH_SIZE == 64)

#ifndef FLASH_TEMP                     // Address of temp page
#define FLASH_TEMP 0x0F800L            // For 64K devices
#endif

#ifndef FLASH_LAST                     // Last page of FLASH
#define FLASH_LAST 0x0FC00L            // For 64K devices
#endif

#endif

//---------------------

#if (FLASH_SIZE == 32)

#ifndef FLASH_TEMP                     // Address of temp page
#define FLASH_TEMP 0x07800L            // For 32K devices
#endif

#ifndef FLASH_LAST                     // Last page of FLASH
#define FLASH_LAST 0x07C00L            // For 32K devices
#endif

#endif

//---------------------

typedef uint16_t FLADDR;                    


//-----------------------------------------------------------------------------
// Exported Function Prototypes
//-----------------------------------------------------------------------------

// FLASH read/write/erase routines

uint8_t   FLASH_ByteWrite (FLADDR addr, uint8_t byte, bit SFLE);
uint8_t   FLASH_ByteRead  (FLADDR addr, bit SFLE);
uint8_t   FLASH_PageErase (FLADDR addr, bit SFLE);

#endif // Si1000_FLASHPRIMITIVES_H


//-----------------------------------------------------------------------------
// End Of File
//-----------------------------------------------------------------------------