//-----------------------------------------------------------------------------
// Si1010_FlashUtils.h
//-----------------------------------------------------------------------------
// Copyright 2012 Silicon Laboratories, Inc.
// http://www.silabs.com
//
// Program Description:
//
// This program contains several useful utilities for writing and updating
// FLASH memory.
//
// Target:         Si101x
// Tool chain:     Raisonance / Keil / SDCC
// Command Line:   None
//
// Release 1.0 / 15 JUN 2012 (ST)
//    -Initial Revision
//

//-----------------------------------------------------------------------------
// Open Header #define
//-----------------------------------------------------------------------------

#ifndef _Si1010_FLASHUTILS_H_
#define _Si1010_FLASHUTILS_H_

//-----------------------------------------------------------------------------
// Includes
//-----------------------------------------------------------------------------

#include "Si1010_FlashPrimitives.h"

//-----------------------------------------------------------------------------
// Exported Function Prototypes
//-----------------------------------------------------------------------------

// FLASH read/write/erase routines
extern void FLASH_Write (FLADDR dest, uint8_t *src, uint16_t numbytes, bit SFLE);
extern uint8_t * FLASH_Read  (uint8_t *dest, FLADDR src, uint16_t numbytes, bit SFLE);
extern void FLASH_Clear (FLADDR addr, uint16_t numbytes, bit SFLE);

// FLASH update/copy routines
extern void FLASH_Update (FLADDR dest, uint8_t *src, uint16_t numbytes, bit SFLE);
extern void FLASH_Copy   (FLADDR dest, bit destSFLE, FLADDR src, bit srcSFLE,
                          uint16_t numbytes);

// FLASH test routines
extern void FLASH_Fill (FLADDR addr, uint16_t length, uint8_t fill, bit SFLE);

//-----------------------------------------------------------------------------
// Close Header #define
//-----------------------------------------------------------------------------

#endif    // _Si1010_FLASHUTILS_H_

//-----------------------------------------------------------------------------
// End Of File
//-----------------------------------------------------------------------------