//-----------------------------------------------------------------------------
// F580_FlashPrimitives.h
//-----------------------------------------------------------------------------
// Copyright 2004 Silicon Laboratories, Inc.
//
// This program contains several useful utilities for writing and updating
// FLASH memory.
//
// Target:         C8051F580
// Tool chain:     Raisonance / Keil / SDCC
// Command Line:   None
//
// Release 1.2 / 26 AUG 2014 (ST)
//    -Added Flash_Test.c
//    -Removed references to scratchpad memory/SFLE bit
//    -Corrected FLASH_TEMP and FLASH_LAST addresses for 96kB flash size
//
// Release 1.1 / 11 MAR 2010 (GP)
//    -Tested with Raisonance
//    -Updated to meet new data sheet guidelines for writing/erasing
//
// Release 1.0 / 23 OCT 2008 (GP)
//    -Initial Revision
//


#ifndef F580_FLASHPRIMITIVES_H
#define F580_FLASHPRIMITIVES_H

//-----------------------------------------------------------------------------
// Includes
//-----------------------------------------------------------------------------

#include "si_toolchain.h"

//-----------------------------------------------------------------------------
// Global Constants
//-----------------------------------------------------------------------------

#define FLASH_SIZE  128                // 128K or 96K

#ifndef FLASH_PAGESIZE
#define FLASH_PAGESIZE 512L
#endif

//---------------------

#if (FLASH_SIZE == 128)

#ifndef FLASH_TEMP                     // Address of temp page
#define FLASH_TEMP 0x1F800L            // For 128K devices
#endif

#ifndef FLASH_LAST                     // Last page of FLASH
#define FLASH_LAST 0x1FA00L            // For 128K devices
#endif

#endif

//---------------------

#if (FLASH_SIZE == 96)

#ifndef FLASH_TEMP                     // Address of temp page
#define FLASH_TEMP 0x17C00L            // For 96K devices
#endif

#ifndef FLASH_LAST                     // Last page of FLASH
#define FLASH_LAST 0x17E00L            // For 96K devices
#endif

#endif

//---------------------

typedef uint32_t FLADDR;                    // Allows for 17-bit address


//-----------------------------------------------------------------------------
// Exported Function Prototypes
//-----------------------------------------------------------------------------

// FLASH read/write/erase routines

uint8_t   FLASH_ByteWrite (FLADDR addr, uint8_t byte);
uint8_t   FLASH_ByteRead  (FLADDR addr);
uint8_t   FLASH_PageErase (FLADDR addr);

#endif // F580_FLASHPRIMITIVES_H


//-----------------------------------------------------------------------------
// End Of File
//-----------------------------------------------------------------------------