//-----------------------------------------------------------------------------
// F930_FlashUtils.h
//-----------------------------------------------------------------------------
// Copyright 2012 Silicon Laboratories, Inc.
//
// This program contains several useful utilities for writing and updating
// FLASH memory.
//
// Target:         C8051F930
// Tool chain:     Raisonance / Keil / SDCC
// Command Line:   None
//
// Release 1.0 / 15 JUN 2012 (ST)
//    -Initial Revision
//

#ifndef F930_FLASHUTILS_H
#define F930_FLASHUTILS_H

//-----------------------------------------------------------------------------
// Includes
//-----------------------------------------------------------------------------

#include "si_toolchain.h"
#include "F930_FlashPrimitives.h"

//-----------------------------------------------------------------------------
// Structures, Unions, Enumerations, and Type Definitions
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Global Constants
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Exported Function Prototypes
//-----------------------------------------------------------------------------

// FLASH read/write/erase routines
extern void FLASH_Write (FLADDR dest, uint8_t *src, uint16_t numbytes, bit SFLE);
extern uint8_t * FLASH_Read  (uint8_t *dest, FLADDR src, uint16_t numbytes, bit SFLE);
extern void FLASH_Clear (FLADDR addr, uint16_t numbytes, bit SFLE);

// FLASH update/copy routines
extern void FLASH_Update (FLADDR dest, uint8_t *src, uint16_t numbytes, bit SFLE);
extern void FLASH_Copy   (FLADDR dest, bit destSFLE, FLADDR src, bit srcSFLE,
                          uint16_t numbytes);

// FLASH test routines
extern void FLASH_Fill (FLADDR addr, uint16_t length, uint8_t fill, bit SFLE);

#endif // F930_FLASHUTILS_H


//-----------------------------------------------------------------------------
// End Of File
//-----------------------------------------------------------------------------