//-----------------------------------------------------------------------------
// F320_SineWaveGenerator.c
//-----------------------------------------------------------------------------
// Copyright 2005 Silicon Laboratories, Inc.
// http://www.silabs.com
//
// Program Description:
//
// This is the main project module.  It initializes all system hardware, and
// then enables interrupts.  All further processing is done in the various
// interrupt handlers.
//
// Linker options are used to absolutely locate code to specific locations.
//
// The linker option can be viewed from the Tool Chain Integration window
// Project -> Tool Chain Integration -> Linker (tab)
//
// FID:            32X000066
// Target:         C8051F320
// Tool chain:     KEIL C51 7.0.0.1
//                 Silicon Laboratories IDE version 2.3
// Command Line:   See Readme.txt
// Project Name:   F320_TONE_GENERATOR
//
// Release 1.0
//    -Initial Revision (PD)
//    -05 JUL 2006
//

//-----------------------------------------------------------------------------
// Includes
//-----------------------------------------------------------------------------

#include <c8051F320.h>
#include "F320_USB_Register.h"
#include "F320_USB_Descriptor.h"

//-----------------------------------------------------------------------------
// Local Variables
//-----------------------------------------------------------------------------

sbit LED1 = P2^3;
sbit LED2 = P2^2;

sbit SWITCH1 = P2^0;
sbit SWITCH2 = P2^1;

//-----------------------------------------------------------------------------
// Local Constants
//-----------------------------------------------------------------------------

int code SINE_TABLE[256] = {

   0x0000, 0x0324, 0x0647, 0x096a, 0x0c8b, 0x0fab, 0x12c8, 0x15e2, 
   0x18f8, 0x1c0b, 0x1f19, 0x2223, 0x2528, 0x2826, 0x2b1f, 0x2e11,
   0x30fb, 0x33de, 0x36ba, 0x398c, 0x3c56, 0x3f17, 0x41ce, 0x447a, 
   0x471c, 0x49b4, 0x4c3f, 0x4ebf, 0x5133, 0x539b, 0x55f5, 0x5842,
   0x5a82, 0x5cb4, 0x5ed7, 0x60ec, 0x62f2, 0x64e8, 0x66cf, 0x68a6, 
   0x6a6d, 0x6c24, 0x6dca, 0x6f5f, 0x70e2, 0x7255, 0x73b5, 0x7504,
   0x7641, 0x776c, 0x7884, 0x798a, 0x7a7d, 0x7b5d, 0x7c29, 0x7ce3, 
   0x7d8a, 0x7e1d, 0x7e9d, 0x7f09, 0x7f62, 0x7fa7, 0x7fd8, 0x7ff6,
   0x7fff, 0x7ff6, 0x7fd8, 0x7fa7, 0x7f62, 0x7f09, 0x7e9d, 0x7e1d, 
   0x7d8a, 0x7ce3, 0x7c29, 0x7b5d, 0x7a7d, 0x798a, 0x7884, 0x776c,
   0x7641, 0x7504, 0x73b5, 0x7255, 0x70e2, 0x6f5f, 0x6dca, 0x6c24, 
   0x6a6d, 0x68a6, 0x66cf, 0x64e8, 0x62f2, 0x60ec, 0x5ed7, 0x5cb4,
   0x5a82, 0x5842, 0x55f5, 0x539b, 0x5133, 0x4ebf, 0x4c3f, 0x49b4, 
   0x471c, 0x447a, 0x41ce, 0x3f17, 0x3c56, 0x398c, 0x36ba, 0x33de,
   0x30fb, 0x2e11, 0x2b1f, 0x2826, 0x2528, 0x2223, 0x1f19, 0x1c0b, 
   0x18f8, 0x15e2, 0x12c8, 0x0fab, 0x0c8b, 0x096a, 0x0647, 0x0324,
   0x0000, 0xfcdc, 0xf9b9, 0xf696, 0xf375, 0xf055, 0xed38, 0xea1e, 
   0xe708, 0xe3f5, 0xe0e7, 0xdddd, 0xdad8, 0xd7da, 0xd4e1, 0xd1ef,
   0xcf05, 0xcc22, 0xc946, 0xc674, 0xc3aa, 0xc0e9, 0xbe32, 0xbb86, 
   0xb8e4, 0xb64c, 0xb3c1, 0xb141, 0xaecd, 0xac65, 0xaa0b, 0xa7be,
   0xa57e, 0xa34c, 0xa129, 0x9f14, 0x9d0e, 0x9b18, 0x9931, 0x975a, 
   0x9593, 0x93dc, 0x9236, 0x90a1, 0x8f1e, 0x8dab, 0x8c4b, 0x8afc,
   0x89bf, 0x8894, 0x877c, 0x8676, 0x8583, 0x84a3, 0x83d7, 0x831d, 
   0x8276, 0x81e3, 0x8163, 0x80f7, 0x809e, 0x8059, 0x8028, 0x800a,
   0x8000, 0x800a, 0x8028, 0x8059, 0x809e, 0x80f7, 0x8163, 0x81e3, 
   0x8276, 0x831d, 0x83d7, 0x84a3, 0x8583, 0x8676, 0x877c, 0x8894,
   0x89bf, 0x8afc, 0x8c4b, 0x8dab, 0x8f1e, 0x90a1, 0x9236, 0x93dc, 
   0x9593, 0x975a, 0x9931, 0x9b18, 0x9d0e, 0x9f14, 0xa129, 0xa34c,
   0xa57e, 0xa7be, 0xaa0b, 0xac65, 0xaecd, 0xb141, 0xb3c1, 0xb64c, 
   0xb8e4, 0xbb86, 0xbe32, 0xc0e9, 0xc3aa, 0xc674, 0xc946, 0xcc22,
   0xcf05, 0xd1ef, 0xd4e1, 0xd7da, 0xdad8, 0xdddd, 0xe0e7, 0xe3f5, 
   0xe708, 0xea1e, 0xed38, 0xf055, 0xf375, 0xf696, 0xf9b9, 0xfcdc,
};

//-----------------------------------------------------------------------------
// Local Variables
//-----------------------------------------------------------------------------

xdata unsigned int FIFO_INDEX;
xdata unsigned char SINE_TABLE_INDEX;
xdata unsigned char LED2_Blink;


//-----------------------------------------------------------------------------
// Handle_In3
//
// Return Value : None
// Parameters   : None
//
// Called from the USB Interrupt Service Routne whenever the host transmits
// an Endpoint 3 token packet.
//
//-----------------------------------------------------------------------------
void Handle_In3(void)
{
   
   FIFO_INDEX = 0;

   USB0ADR = FIFO_EP3;

   while(FIFO_INDEX < (48*4))
   {
      USB0DAT = SINE_TABLE[SINE_TABLE_INDEX]>>8;
      FIFO_INDEX++;
               while (USB0ADR & 0x80); // Wait for BUSY->'0' (data ready)

      USB0DAT = SINE_TABLE[SINE_TABLE_INDEX];
      FIFO_INDEX++;
         while (USB0ADR & 0x80);       // Wait for BUSY->'0' (data ready)

      USB0DAT = SINE_TABLE[SINE_TABLE_INDEX]>>8;
      FIFO_INDEX++;
         while (USB0ADR & 0x80);       // Wait for BUSY->'0' (data ready)

      USB0DAT = SINE_TABLE[SINE_TABLE_INDEX];
      FIFO_INDEX++;
         while (USB0ADR & 0x80);       // Wait for BUSY->'0' (data ready)

      SINE_TABLE_INDEX++;
      SINE_TABLE_INDEX++;
   }


   // Set rbInINPRDY to send data to host
   POLL_WRITE_BYTE (EINCSR1, rbInINPRDY);
}

//-----------------------------------------------------------------------------
// End Of File
//-----------------------------------------------------------------------------