//-----------------------------------------------------------------------------
// F320_Tone_Generator_Main.c
//-----------------------------------------------------------------------------
// Copyright 2005 Silicon Laboratories, Inc.
// http://www.silabs.com
//
// Program Description:
//
// This is the main project module.  It initializes all system hardware, and
// then enables interrupts.  All further processing is done in the various
// interrupt handlers.
//
// Linker options are used to absolutely locate code to specific locations.
//
// The linker option can be viewed from the Tool Chain Integration window
// Project -> Tool Chain Integration -> Linker (tab)
//
// FID:            32X000068
// Target:         C8051F320
// Tool chain:     KEIL C51 7.0.0.1
//                 Silicon Laboratories IDE version 2.3
// Command Line:   See Readme.txt
// Project Name:   F320_TONE_GENERATOR
//
// Release 1.0
//    -Initial Revision (PD)
//    -05 JUL 2006
//

//-----------------------------------------------------------------------------
// Includes
//-----------------------------------------------------------------------------

#include "c8051f320.h"                 // SFR declarations
#include "F320_Tone_Generator_Main.h"  // Main project header
#include "F320_USB_Register.h"         // USB core register header


//-----------------------------------------------------------------------------
// main
//
// Return Value : None
// Parameters   : None
//
// Main program routine.
//
//-----------------------------------------------------------------------------
void main (void)
{
   PCA0MD &= ~0x40;                    // Disable Watchdog timer
   VDM0CN |= 0x80;                     // Enable the VDD Monitor

   Port_Init ();                       // Initialize crossbar and GPIO
   Oscillator_Init ();                 // Initialize oscillator

   // Select VDD Monitor as a Reset Source
   RSTSRC = 0x02;

   USB0_Init ();                       // Initialize USB0

   EA = 1;                             // Global Interrupt enable

   while (1)
   {
   }
}

//-----------------------------------------------------------------------------
// Initialization Subroutines
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Oscillator_Init
//-----------------------------------------------------------------------------
//
// Return Value : None
// Parameters   : None
//
// This function initializes the clock multiplier and selects it as the system
// clock.
//
//-----------------------------------------------------------------------------
void Oscillator_Init (void)
{
   // Configure internal oscillator for its maximum frequency and enable
   // missing clock detector
   OSCICN |= 0x03;

   // Select internal oscillator as input to clock multiplier
   CLKMUL = 0x00;

   CLKMUL |= 0x80;                     // Enable clock multiplier
   CLKMUL |= 0xC0;                     // Initialize the clock multiplier
   Delay_Main ();                      // Delay for clock multiplier

   while (!(CLKMUL & 0x20));           // Wait for multiplier to lock
   CLKSEL = SYS_4X_DIV_2;              // Select 24 MHz clock as sysclock
}



//-----------------------------------------------------------------------------
// Port_Init
//-----------------------------------------------------------------------------
//
// Return Value : None
// Parameters   : None
//
// This function configures the Crossbar and GPIO ports.
//
//
//
//-----------------------------------------------------------------------------
void Port_Init (void)
{
   P2MDOUT |= 0x0C;                    // set LED1 and LED2 to push-pull
   XBR1 = 0x40;
}


//-----------------------------------------------------------------------------
// USB0_Init
//-----------------------------------------------------------------------------
//
// Return Value : None
// Parameters   : None
//
// Initializes USB0, enable transceiver and USB0 interrupts.
//
//-----------------------------------------------------------------------------
void USB0_Init (void)
{
   POLL_WRITE_BYTE (POWER,  0x08);     // Force Asynchronous USB Reset
   POLL_WRITE_BYTE (IN1IE,  0x01);     // Enable Endpoint 0 in interrupts
   POLL_WRITE_BYTE (OUT1IE, 0x04);     // Enable Endpoint 2 out interrupts

   // Enable SOF, Reset, and Suspend interrupt
   POLL_WRITE_BYTE (CMIE, rbSOFE | rbRSTINTE | rbSUSINTE);

   USB0XCN = 0xE0;                     // Enable transceiver; select full speed

   // Enable clock recovery, single-step mode disabled
   POLL_WRITE_BYTE (CLKREC, 0x80);

   EIE1 |= 0x02;                       // Enable USB0 Interrupts

   // Enable USB0 by clearing the USB Inhibit bit, and enable suspend detection
   POLL_WRITE_BYTE (POWER,  0x01);
}


//-----------------------------------------------------------------------------
// Delay_Main
//-----------------------------------------------------------------------------
//
// Return Value : None
// Parameters   : None
//
// Used for a 500 microsecond pause during hardware configuration.
// There are two identical versions of this routine, one for the main program
// and another for the USB interrupt.  This version is for the main program.
// (assuming 24 MHz system clock)
//
//-----------------------------------------------------------------------------
void Delay_Main (void)
{
   data volatile int x;
   for (x = 0;x < 500;x)
      x++;
}

//-----------------------------------------------------------------------------
// End Of File
//-----------------------------------------------------------------------------