//-----------------------------------------------------------------------------
// F320_Tone_Generator_Main.h
//-----------------------------------------------------------------------------
// Copyright 2005 Silicon Laboratories, Inc.
// http://www.silabs.com
//
// Program Description:
//
// This is the header file for Tone Generator project.
//
// FID:            32X000075
// Target:         C8051F320
// Tool chain:     KEIL C51 7.0.0.1
//                 Silicon Laboratories IDE version 2.3
// Command Line:   See Readme.txt
// Project Name:   F320_TONE_GENERATOR
//
// Release 1.0
//    -Initial Revision (PD)
//    -05 JUL 2006
//

#ifndef F320_TONE_GENERATORMain_H_
#define F320_TONE_GENERATORMain_H_
//-----------------------------------------------------------------------------
// Other SFR Definitions
//-----------------------------------------------------------------------------

sfr16 TMR2RL = 0xca;                   // Timer2 reload value
sfr16 TMR2 = 0xcc;                     // Timer2 counter

//-----------------------------------------------------------------------------
// Global Constants
//-----------------------------------------------------------------------------

enum { OFF, ON };                      // ON and OFF constants

#define SYSCLK 24000000                // SYSCLK frequency in Hz

#define USB_REGISTER_BANK 1

// USB clock selections (SFR CLKSEL)
#define USB_4X_CLOCK       0x00        // Select 4x clock multiplier, for USB
#define USB_INT_OSC_DIV_2  0x10        // Full Speed See Data Sheet section
#define USB_EXT_OSC        0x20        // 13. Oscillators
#define USB_EXT_OSC_DIV_2  0x30
#define USB_EXT_OSC_DIV_3  0x40
#define USB_EXT_OSC_DIV_4  0x50

// System clock selections (SFR CLKSEL)
#define SYS_INT_OSC  0x00              // Select to use internal oscillator
#define SYS_EXT_OSC  0x01              // Select to use an external oscillator
#define SYS_4X_DIV_2 0x02

//-----------------------------------------------------------------------------
// Type Definitions
//-----------------------------------------------------------------------------

// BYTE type definition
#ifndef BYTE_DEF_
#define BYTE_DEF_
typedef unsigned char BYTE;
#endif // BYTE_DEF_

// UINT type definition
#ifndef UINT_DEF_
#define UINT_DEF_
typedef unsigned int UINT;
#endif // UINT_DEF_

// WORD type definition, for KEIL Compiler
#ifndef WORD_DEF_
#define WORD_DEF_
typedef union {unsigned int i; unsigned char c[2];} WORD;
#define LSB 1
#define MSB 0
#endif // WORD_DEF_

//-----------------------------------------------------------------------------
// Function Prototypes
//-----------------------------------------------------------------------------

void Oscillator_Init (void);           // Initialize the system clock
void Port_Init (void);                 // Configure ports
void USB0_Init (void);                 // Configure USB core
void Delay_Main (void);                // Approximately 500 uS (24 Mhz sysclk)

#endif // F320_TONE_GENERATORMain
//-----------------------------------------------------------------------------
// End Of File
//-----------------------------------------------------------------------------