//-----------------------------------------------------------------------------
// F320_USB_Class_Specific_Requests.c
//-----------------------------------------------------------------------------
// Copyright 2005 Silicon Laboratories, Inc.
// http://www.silabs.com
//
// Program Description:
//
// This module handles all human interface device (HID) and audio USB
// class-specific requests.
//
// FID:            32X000069
// Target:         C8051F320
// Tool chain:     KEIL C51 7.0.0.1 / KEIL A51 7.0.0.1
//                 Silicon Laboratories IDE version 2.3
// Command Line:   See Readme.txt
// Project Name:   F320_TONE_GENERATOR
//
// Release 1.0
//    -Initial Revision (PD)
//    -05 JUL 2006
//
//

//-----------------------------------------------------------------------------
// Includes
//-----------------------------------------------------------------------------

#include "c8051f320.h"                 // SFR declarations
#include "F320_Tone_Generator_Main.h"  // Main project header
#include "F320_USB_Register.h"         // USB core register header
#include "F320_USB_Common.h"           // USB protocol header
#include "F320_USB_Descriptor.h"       // USB descriptor definitions

//-----------------------------------------------------------------------------
// Variable Declaration
//-----------------------------------------------------------------------------

idata BYTE ReturnBuffer[64];

//-----------------------------------------------------------------------------
// Get_Cur
//
// Return Value : None
// Parameters   : None
//
// Retrieves the current setting for a given audio control.  Audio
// class-specific request.
//
//-----------------------------------------------------------------------------
void Get_Cur (void) using USB_REGISTER_BANK
{
   DataPtr = ZERO_PACKET;
   DataSize = Setup.wLength.i;

   if (Ep_Status[0] != EP_STALL)
   {
      // Set serviced setup packet bit, put endpoint in transmit mode and reset
      // data sent counter
      POLL_WRITE_BYTE (E0CSR, rbSOPRDY);
      Ep_Status[0] = EP_TX;
      DataSent = 0;
   }
}

//-----------------------------------------------------------------------------
// Set_Cur
//-----------------------------------------------------------------------------
//
// Return Value : None
// Parameters   : None
//
// Sets current value for a given audio control.  Audio class-specific request.
//
//-----------------------------------------------------------------------------
void Set_Cur (void) using USB_REGISTER_BANK
{
   DataPtr = (BYTE *)&ReturnBuffer;    // Write data to dummy location
   DataSize = Setup.wLength.i;

   if (Ep_Status[0] != EP_STALL)
   {
      // Set serviced setup packet bit, put endpoint in receive mode and reset
      // data sent counter
      POLL_WRITE_BYTE (E0CSR, rbSOPRDY);
      Ep_Status[0] = EP_RX;
      DataSent = 0;
   }
}

//-----------------------------------------------------------------------------
// Set_Idle
//-----------------------------------------------------------------------------
//
// Return Value : None
// Parameters   : None
//
// Sets the idle feature on interrupt in endpoint.
//
//-----------------------------------------------------------------------------
void Set_Idle (void) using USB_REGISTER_BANK
{
   // Indicate setup packet has been serviced
   if (Ep_Status[0] != EP_STALL) POLL_WRITE_BYTE (E0CSR, rbSOPRDY);
}

//-----------------------------------------------------------------------------
// Get_Report
//-----------------------------------------------------------------------------
//
// Return Value : None
// Parameters   : None
//
// Sends a given report type to the host.
//
//-----------------------------------------------------------------------------
void Get_Report (void) using USB_REGISTER_BANK
{
   ReturnBuffer[0] = Setup.wValue.c[LSB];
   DataPtr = (BYTE*)&ReturnBuffer;

   switch (ReturnBuffer[0])
   {
   }

   if (Ep_Status[0] != EP_STALL)
   {
      // Set serviced setup packet bit, put endpoint in transmit mode and reset
      // data sent counter
      POLL_WRITE_BYTE (E0CSR, rbSOPRDY);
      Ep_Status[0] = EP_TX;
      DataSent = 0;
   }
}

//-----------------------------------------------------------------------------
// Set_Report
//-----------------------------------------------------------------------------
//
// Return Value : None
// Parameters   : None
//
// Receives a report sent from the host.
//
//-----------------------------------------------------------------------------
void Set_Report (void) using USB_REGISTER_BANK
{
   DataPtr = (BYTE*)&ReturnBuffer;
   DataSize = Setup.wLength.i;

   if (Ep_Status[0] != EP_STALL)
   {
      // Set serviced setup packet bit, put endpoint in receive mode and reset
      // data sent counter
      POLL_WRITE_BYTE (E0CSR, rbSOPRDY);
      Ep_Status[0] = EP_RX;
      DataSent = 0;
   }
}

//-----------------------------------------------------------------------------
// Handle_Set_Report
//-----------------------------------------------------------------------------
//
// Return Value : None
// Parameters   : None
//
// Takes appropriate action based on report content, most commands are sent
// from the host directly to the Si470x.
//
//-----------------------------------------------------------------------------
void Handle_Set_Report (void) using USB_REGISTER_BANK
{
   switch (ReturnBuffer[0])
   {
   }
}
//-----------------------------------------------------------------------------
// End Of File
//-----------------------------------------------------------------------------