//-----------------------------------------------------------------------------
// Fxxx_Target_Config.h
//-----------------------------------------------------------------------------
// Copyright (C) 2014 Silicon Laboratories, Inc.
// http://www.silabs.com
//
// Program Description:
//
// Configures options that are shared between the target BL & App.
//
// Target:         Any Silicon Labs C8051 MCU
// Tool chain:     Generic
// Command Line:   None
//
//
// Release 1.0 / 22Sept2014 (SHY)
//    -Ported from F330
//
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Header file include-once preprocessor directive
//-----------------------------------------------------------------------------

#ifndef _FXXX_TARGET_CONFIG_H_
#define _FXXX_TARGET_CONFIG_H_

//-----------------------------------------------------------------------------
// Global CONSTANTS - Available to all modules
//-----------------------------------------------------------------------------
// Signature Bytes
#define SIG_BYTE0             0x3D
#define SIG_BYTE1             0xC2
#define SIG_BYTE2             0xA5
#define SIG_BYTE3             0x1B

// ------------------------------------------
// Target Config Options (common to BL & App)
// ------------------------------------------

#define TGT_MCU_CODE             0x85  // Company-specific product ID
#define TGT_BL_TYPE              0x1  // BL Type = UART
// => "Fxxx_BL132_SMB0_Interface.h" should be included.

#define TGT_FLASH_PAGE_SIZE      512   // Number of bytes per flash page
#define TGT_FLASH_PAGE_SIZE_CODE 1     // Flash Page Size Code: 1 => 512 bytes


// Note: For serial streams like UART where "packets" are not applicable, the packet size 
// should be set to be equal to the BL buffer size.

#define TGT_BL_BUFF_SIZE_CODE             4
#define TGT_BL_PACKETS_FOR_GET_PAGE       (1<<TGT_BL_BUFF_SIZE_CODE)

// Buffer size is Page_Size/(2^size_code). For page size 51, 
//     buffer size code             buffer size          equation
//     4                            32                   =512/2^4
//     0                            512                  =512/2^0
#define TGT_BL_BUFF_SIZE            (TGT_FLASH_PAGE_SIZE/TGT_BL_PACKETS_FOR_GET_PAGE)


// Mask to clear out address bits within a page (useful for page boundary check)
// Example: For 512-byte pages, the lower 9 address bits [8:0] represent the bytes within
// a Flash page; so this mask's lower 9 bits would be set => 0x000001FF
#define TGT_FLASH_PAGE_ADDR_MASK 0x01FF

// Specify 24-bit linear addresses here (do not use banked 16-bit addresses)
#define APP_FW_START_ADDR        0x0400
#define APP_FW_END_ADDR          0x1DFF

#define APP_FW_SIG0_ADDR         APP_FW_END_ADDR
#define APP_FW_SIG3_ADDR         (APP_FW_END_ADDR - 3)

// Target Serial Number (for multi-drop buses)
#define DEV_SERIAL_NUMBYTES      0     // 0=Disabled; Max: 7
// ** Ensure a UNIQUE Serial Number for each device on the same bus **
// - These are "don't care" if DEV_SERIAL_NUMBYTES is set to 0.
// - These need not be used if device addressing on a bus is handled 
//   at the comm protocol level. 
#define TGT_DEVICE_SERIAL0       0x01     
#define TGT_DEVICE_SERIAL1       0x00        



//-----------------------------------------------------------------------------
// Header file include-once preprocessor directive
//-----------------------------------------------------------------------------

#endif // #ifndef _FXXX_TARGET_CONFIG_H_
//-----------------------------------------------------------------------------
// End Of File
//-----------------------------------------------------------------------------
