//-----------------------------------------------------------------------------
// F85x_CRC.c 
//-----------------------------------------------------------------------------
// Copyright (C) 2014 Silicon Laboratories, Inc.
// http://www.silabs.com
//
//
//
// Target:         C8051F850 
// Tool chain:     Keil C51 9.02 / Keil EVAL C51
// Command Line:   None
//
//
// Release 1.0 / 22Sept2014 (SHY)
//    -Ported from F330
//
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Includes
//-----------------------------------------------------------------------------
#include <si_toolchain.h>
#include "F85x_CRC.h"

//=============================================================================
// Function Definitions
//=============================================================================

//-----------------------------------------------------------------------------
// Get_Buf_CRC
//-----------------------------------------------------------------------------
//
// Return Value:  None
// Parameters:    None
//
// Returns a 16-bit CRC of the contents of a buffer.
//
//-----------------------------------------------------------------------------
uint16_t Get_Buf_CRC(uint8_t *ptr, uint16_t numbytes)
{
    uint16_t i, CRC;

    CRC = 0x0000;

    // Process each byte in the buffer into the running CRC
    for (i = 0; i < numbytes; i++)
    {
        CRC = Update_CRC(CRC, *ptr++);
    }

    return CRC;
}

//-----------------------------------------------------------------------------
// Update_CRC
//-----------------------------------------------------------------------------
//
// Return Value:  None
// Parameters:    None
//
// This function accepts a CRC argument and a <newbyte> and returns an
// updated CRC value; Does not use a CRC Lookup Table.
//
//-----------------------------------------------------------------------------
uint16_t Update_CRC(uint16_t crc, uint8_t newbyte)
{
    uint8_t i; // loop counter

#define POLY 0x8408                 // CRC16-CCITT FCS (X^16+X^12+X^5+1)
    crc = crc ^ newbyte;

    for (i = 0; i < 8; i++)
    {
        if (crc & 0x01)
        {
            crc = crc >> 1;
            crc ^= POLY;
        }
        else
        {
            crc = crc >> 1;
        }
    }
    return crc;
}

//-----------------------------------------------------------------------------
// End Of File
//-----------------------------------------------------------------------------
