/*********************************************************************
*                SEGGER Microcontroller GmbH & Co. KG                *
*        Solutions for real time microcontroller applications        *
**********************************************************************
*                                                                    *
*        (c) 1996 - 2016  SEGGER Microcontroller GmbH & Co. KG       *
*                                                                    *
*        Internet: www.segger.com    Support:  support@segger.com    *
*                                                                    *
**********************************************************************

** emWin V5.34 - Graphical user interface for embedded applications **
All  Intellectual Property rights  in the Software belongs to  SEGGER.
emWin is protected by  international copyright laws.  Knowledge of the
source code may not be used to write a similar product.  This file may
only be used in accordance with the following terms:

The  software has  been licensed  to Silicon Labs Norway, a subsidiary
of Silicon Labs Inc. whose registered office is 400 West Cesar Chavez,
Austin,  TX 78701, USA solely for  the purposes of creating  libraries 
for its  ARM Cortex-M3, M4F  processor-based devices,  sublicensed and 
distributed  under the  terms and conditions  of the  End User License  
Agreement supplied by Silicon Labs.
Full source code is available at: www.segger.com

We appreciate your understanding and fairness.
----------------------------------------------------------------------
Licensing information

Licensor:                 SEGGER Software GmbH
Licensed to:              Silicon Laboratories Norway
Licensed SEGGER software: emWin
License number:           GUI-00140
License model:            See Agreement, dated 20th April 2012
Licensed product:         - 
Licensed platform:        Cortex M3, Cortex M4F
Licensed number of seats: -
----------------------------------------------------------------------
File        : GUIDEMO_Resource.c
Purpose     : Contains fonts and bitmaps used in the demo.
---------------------------END-OF-HEADER------------------------------
*/

#include "GUI.h"
#include "GUIDEMO.h"

#ifndef GUI_CONST_STORAGE
  #define GUI_CONST_STORAGE const
#endif

/*********************************************************************
*                                                                    *
*       Fonts                                                        *
*                                                                    *
**********************************************************************
*/
/*********************************************************************
*                                                                    *
*       GUI_FontD6x8                                                 *
*                                                                    *
**********************************************************************
*/
static GUI_CONST_STORAGE unsigned char acFontD6x8[16][8] = {
  {
    _XXX____,
    X___X___,
    X___X___,
    X___X___,
    X___X___,
    X___X___,
    X___X___,
    _XXX____,
  },{
    __X_____,
    _XX_____,
    __X_____,
    __X_____,
    __X_____,
    __X_____,
    __X_____,
    _XXX____,
  },{
    _XXX____,
    X___X___,
    ____X___,
    ___X____,
    __X_____,
    _X______,
    X_______,
    XXXXX___,
  },{
    _XXX____,
    X___X___,
    ____X___,
    ___X____,
    ___X____,
    ____X___,
    X___X___,
    _XXX____,
  },{
    ___X____,
    __XX____,
    _X_X____,
    X__X____,
    XXXXX___,
    ___X____,
    ___X____,
    ___X____,
  },{
    XXXXX___,
    X_______,
    X_______,
    XXXX____,
    ____X___,
    ____X___,
    X___X___,
    _XXX____,
  },{
    __XX____,
    _X______,
    X_______,
    XXXX____,
    X___X___,
    X___X___,
    X___X___,
    _XXX____,
  },{
    XXXXX___,
    ____X___,
    ____X___,
    ___X____,
    __X_____,
    _X______,
    _X______,
    _X______,
  },{
    _XXX____,
    X___X___,
    X___X___,
    _XXX____,
    X___X___,
    X___X___,
    X___X___,
    _XXX____,
  },{
    _XXX____,
    X___X___,
    X___X___,
    _XXXX___,
    ____X___,
    ____X___,
    ___X____,
    _XX_____,
  },{
    ________,
    ________,
    __X_____,
    __X_____,
    XXXXX___,
    __X_____,
    __X_____,
    ________,
  },{
    ________,
    ________,
    ________,
    ________,
    XXXXX___,
    ________,
    ________,
    ________,
  },{
    ________,
    ________,
    ________,
    ________,
    ________,
    ________,
    ________,
    ________,
  },{
    ________,
    ________,
    ________,
    ________,
    ________,
    ________,
    _XX_____,
    _XX_____,
  },{
    ________,
    ________,
    _XX_____,
    _XX_____,
    ________,
    _XX_____,
    _XX_____,
    ________
  },{
    ________,
    _XX___X_,
    _XX__X__,
    ____X___,
    ___X____,
    __X__XX_,
    _X___XX_,
    ________}

};

static GUI_CONST_STORAGE GUI_CHARINFO GUI_FontD6x8_CharInfo[16] = {
   {  6,  6,  1, acFontD6x8[12] } /* code 0020 ' ' */
  ,{  6,  6,  1, acFontD6x8[15] } /* code 0025 '%' */
  ,{  6,  6,  1, acFontD6x8[10] } /* code 002B '+' */
  ,{  6,  6,  1, acFontD6x8[11] } /* code 002D '-' */
  ,{  6,  6,  1, acFontD6x8[13] } /* code 002E '.' */
  ,{  6,  6,  1, acFontD6x8[0]  } /* code 0030 '0' */
  ,{  6,  6,  1, acFontD6x8[1]  } /* code 0031 '1' */
  ,{  6,  6,  1, acFontD6x8[2]  } /* code 0032 '2' */
  ,{  6,  6,  1, acFontD6x8[3]  } /* code 0033 '3' */
  ,{  6,  6,  1, acFontD6x8[4]  } /* code 0034 '4' */
  ,{  6,  6,  1, acFontD6x8[5]  } /* code 0035 '5' */
  ,{  6,  6,  1, acFontD6x8[6]  } /* code 0036 '6' */
  ,{  6,  6,  1, acFontD6x8[7]  } /* code 0037 '7' */
  ,{  6,  6,  1, acFontD6x8[8]  } /* code 0038 '8' */
  ,{  6,  6,  1, acFontD6x8[9]  } /* code 0039 '9' */
  ,{  6,  6,  1, acFontD6x8[14] } /* code 003A ':' */
};

static GUI_CONST_STORAGE GUI_FONT_PROP GUI_FontD6x8_Prop5 = {
   0x0030 /* first character */
  ,0x003A /* last character  */
  ,&GUI_FontD6x8_CharInfo[  5] /* address of first character */
  ,(GUI_CONST_STORAGE GUI_FONT_PROP*)0 /* pointer to next GUI_FONT_PROP */
};

static GUI_CONST_STORAGE GUI_FONT_PROP GUI_FontD6x8_Prop4 = {
   0x002D /* first character */
  ,0x002E /* last character  */
  ,&GUI_FontD6x8_CharInfo[  3] /* address of first character */
  ,&GUI_FontD6x8_Prop5 /* pointer to next GUI_FONT_PROP */
};

static GUI_CONST_STORAGE GUI_FONT_PROP GUI_FontD6x8_Prop3 = {
   0x002B /* first character */
  ,0x002B /* last character  */
  ,&GUI_FontD6x8_CharInfo[  2] /* address of first character */
  ,&GUI_FontD6x8_Prop4 /* pointer to next GUI_FONT_PROP */
};

static GUI_CONST_STORAGE GUI_FONT_PROP GUI_FontD6x8_Prop2 = {
   0x0025 /* first character */
  ,0x0025 /* last character  */
  ,&GUI_FontD6x8_CharInfo[  1] /* address of first character */
  ,&GUI_FontD6x8_Prop3 /* pointer to next GUI_FONT_PROP */
};

static GUI_CONST_STORAGE GUI_FONT_PROP GUI_FontD6x8_Prop1 = {
   0x0020 /* first character */
  ,0x0020 /* last character  */
  ,&GUI_FontD6x8_CharInfo[  0] /* address of first character */
  ,&GUI_FontD6x8_Prop2 /* pointer to next GUI_FONT_PROP */
};

GUI_CONST_STORAGE GUI_FONT GUI_FontD6x8 = {
   GUI_FONTTYPE_PROP /* type of font    */
  ,8 /* height of font  */
  ,8 /* space of font y */
  ,1 /* magnification x */
  ,1 /* magnification y */
  ,{&GUI_FontD6x8_Prop1}
  ,8 /* Baseline */
  ,0 /* LHeight */
  ,8 /* CHeight */
};

/*********************************************************************
*                                                                    *
*       GUI_FontRounded16                                            *
*                                                                    *
**********************************************************************
*/
GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0020[  1] = { /* code 0020, SPACE */
  0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0021[ 22] = { /* code 0021, EXCLAMATION MARK */
  0x56, 0x00,
  0xFF, 0x10,
  0xFF, 0x20,
  0xEF, 0x10,
  0xCE, 0x00,
  0xAC, 0x00,
  0x89, 0x00,
  0x01, 0x00,
  0xCD, 0x10,
  0xCE, 0x10,
  0x01, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0022[ 15] = { /* code 0022, QUOTATION MARK */
  0x36, 0x07, 0x30,
  0x9F, 0x3F, 0x90,
  0x9F, 0x4F, 0x90,
  0x9F, 0x3F, 0x90,
  0x24, 0x05, 0x20
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0023[ 44] = { /* code 0023, NUMBER SIGN */
  0x00, 0x03, 0x02, 0x10,
  0x00, 0x5E, 0x0D, 0x60,
  0x00, 0x8C, 0x0F, 0x40,
  0x07, 0xDE, 0xAF, 0xA1,
  0x09, 0xFD, 0xDF, 0xB2,
  0x00, 0xE6, 0x7D, 0x00,
  0x3B, 0xFC, 0xDE, 0x90,
  0x19, 0xF8, 0xDC, 0x50,
  0x05, 0xF0, 0xD7, 0x00,
  0x07, 0xC0, 0xF4, 0x00,
  0x00, 0x10, 0x10, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0024[ 48] = { /* code 0024, DOLLAR SIGN */
  0x00, 0x17, 0x71, 0x00,
  0x08, 0xFF, 0xFF, 0x91,
  0x4F, 0x87, 0x79, 0xF7,
  0x7F, 0x36, 0x60, 0x62,
  0x3F, 0xEC, 0x92, 0x00,
  0x05, 0xCF, 0xFF, 0xB1,
  0x00, 0x06, 0x9B, 0xF7,
  0x9E, 0x06, 0x60, 0xF9,
  0x7F, 0x97, 0x78, 0xF6,
  0x09, 0xFF, 0xFF, 0x80,
  0x00, 0x17, 0x70, 0x00,
  0x00, 0x02, 0x20, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0025[ 66] = { /* code 0025, PERCENT SIGN */
  0x02, 0x30, 0x00, 0x04, 0x30, 0x00,
  0x6F, 0xDC, 0x00, 0x1E, 0x30, 0x00,
  0xD8, 0x2F, 0x50, 0x79, 0x00, 0x00,
  0xF7, 0x0F, 0x61, 0xE2, 0x00, 0x00,
  0xBB, 0x7F, 0x28, 0x90, 0x00, 0x00,
  0x19, 0xB5, 0x2E, 0x16, 0xBA, 0x20,
  0x00, 0x00, 0x98, 0x3F, 0x6B, 0xB0,
  0x00, 0x02, 0xE1, 0x6F, 0x07, 0xF0,
  0x00, 0x0A, 0x70, 0x4F, 0x28, 0xD0,
  0x00, 0x3E, 0x00, 0x0B, 0xEF, 0x60,
  0x00, 0x24, 0x00, 0x00, 0x21, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0026[ 55] = { /* code 0026, AMPERSAND */
  0x00, 0x05, 0x74, 0x00, 0x00,
  0x00, 0xCF, 0xEF, 0x80, 0x00,
  0x03, 0xF8, 0x0B, 0xF0, 0x00,
  0x02, 0xFB, 0x2D, 0xD0, 0x00,
  0x00, 0xAF, 0xFE, 0x40, 0x00,
  0x08, 0xFF, 0xFB, 0x07, 0x50,
  0x3F, 0xD2, 0xBF, 0xBF, 0x90,
  0x6F, 0x70, 0x1D, 0xFE, 0x20,
  0x3F, 0xD6, 0x7E, 0xFF, 0x50,
  0x08, 0xFF, 0xFB, 0x4E, 0x90,
  0x00, 0x12, 0x10, 0x01, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0027[  5] = { /* code 0027, APOSTROPHE */
  0x45,
  0xBD,
  0xBD,
  0xBD,
  0x33
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0028[ 26] = { /* code 0028, LEFT PARENTHESIS */
  0x00, 0x37,
  0x00, 0xCB,
  0x04, 0xF7,
  0x09, 0xF2,
  0x0D, 0xD0,
  0x1F, 0xB0,
  0x2F, 0xB0,
  0x1F, 0xB0,
  0x0D, 0xD0,
  0x09, 0xF2,
  0x04, 0xF6,
  0x00, 0xCB,
  0x00, 0x37
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0029[ 26] = { /* code 0029, RIGHT PARENTHESIS */
  0x36, 0x00,
  0x6F, 0x20,
  0x2F, 0x90,
  0x0C, 0xE0,
  0x08, 0xF3,
  0x06, 0xF6,
  0x06, 0xF7,
  0x06, 0xF6,
  0x08, 0xF3,
  0x0C, 0xE0,
  0x2F, 0x90,
  0x6F, 0x30,
  0x47, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_002A[ 18] = { /* code 002A, ASTERISK */
  0x00, 0x33, 0x00,
  0x12, 0x79, 0x21,
  0x4F, 0xEE, 0xF5,
  0x02, 0xFE, 0x30,
  0x0A, 0x98, 0xA0,
  0x01, 0x00, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_002B[ 32] = { /* code 002B, PLUS SIGN */
  0x00, 0x03, 0x20, 0x00,
  0x00, 0x0D, 0xA0, 0x00,
  0x00, 0x0D, 0xB0, 0x00,
  0x37, 0x7E, 0xD7, 0x72,
  0xAF, 0xFF, 0xFF, 0xF7,
  0x02, 0x2D, 0xC2, 0x20,
  0x00, 0x0D, 0xB0, 0x00,
  0x00, 0x0B, 0x80, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_002C[  8] = { /* code 002C, COMMA */
  0x0D, 0xD0,
  0x0E, 0xF3,
  0x01, 0xD1,
  0x0B, 0x50
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_002D[  9] = { /* code 002D, HYPHEN-MINUS */
  0x17, 0x77, 0x30,
  0x7F, 0xFF, 0xB0,
  0x04, 0x65, 0x20
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_002E[  6] = { /* code 002E, FULL STOP */
  0x0D, 0xD0,
  0x0D, 0xD0,
  0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_002F[ 33] = { /* code 002F, SOLIDUS */
  0x00, 0x04, 0x50,
  0x00, 0x0D, 0x90,
  0x00, 0x4F, 0x30,
  0x00, 0xAD, 0x00,
  0x01, 0xF7, 0x00,
  0x06, 0xF2, 0x00,
  0x0C, 0xB0, 0x00,
  0x3F, 0x50, 0x00,
  0x8E, 0x00, 0x00,
  0xD9, 0x00, 0x00,
  0x20, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0030[ 44] = { /* code 0030, DIGIT ZERO */
  0x00, 0x03, 0x30, 0x00,
  0x03, 0xDF, 0xFD, 0x30,
  0x0D, 0xF7, 0x7F, 0xD0,
  0x4F, 0xA0, 0x0B, 0xF4,
  0x7F, 0x70, 0x07, 0xF6,
  0x7F, 0x60, 0x07, 0xF7,
  0x6F, 0x70, 0x07, 0xF6,
  0x4F, 0xA0, 0x0B, 0xF3,
  0x0D, 0xF7, 0x8F, 0xC0,
  0x02, 0xDF, 0xFC, 0x20,
  0x00, 0x02, 0x20, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0031[ 33] = { /* code 0031, DIGIT ONE */
  0x00, 0x00, 0x30,
  0x00, 0x07, 0xF3,
  0x04, 0x8F, 0xF4,
  0x1F, 0xFF, 0xF4,
  0x01, 0x2C, 0xF4,
  0x00, 0x0B, 0xF4,
  0x00, 0x0B, 0xF4,
  0x00, 0x0B, 0xF4,
  0x00, 0x0B, 0xF4,
  0x00, 0x0A, 0xF2,
  0x00, 0x00, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0032[ 40] = { /* code 0032, DIGIT TWO */
  0x00, 0x13, 0x30, 0x00,
  0x06, 0xEF, 0xFE, 0x50,
  0x4F, 0xD6, 0x7F, 0xF1,
  0x7F, 0x50, 0x0B, 0xF4,
  0x25, 0x00, 0x1E, 0xF1,
  0x00, 0x05, 0xEF, 0x70,
  0x01, 0xBF, 0xC4, 0x00,
  0x1D, 0xF7, 0x00, 0x00,
  0x7F, 0xD9, 0x99, 0x92,
  0x6F, 0xFF, 0xFF, 0xF3
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0033[ 44] = { /* code 0033, DIGIT THREE */
  0x00, 0x13, 0x30, 0x00,
  0x08, 0xFF, 0xFD, 0x20,
  0x4F, 0xC6, 0x8F, 0xB0,
  0x3B, 0x20, 0x0F, 0xC0,
  0x00, 0x07, 0xAF, 0x60,
  0x00, 0x1E, 0xFF, 0x70,
  0x00, 0x00, 0x3F, 0xF1,
  0x7E, 0x20, 0x0E, 0xF1,
  0x7F, 0xC6, 0xAF, 0xC0,
  0x09, 0xFF, 0xFB, 0x20,
  0x00, 0x12, 0x10, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0034[ 44] = { /* code 0034, DIGIT FOUR */
  0x00, 0x00, 0x13, 0x00,
  0x00, 0x01, 0xCF, 0x30,
  0x00, 0x0A, 0xFF, 0x40,
  0x00, 0x7E, 0xBF, 0x40,
  0x03, 0xF5, 0x9F, 0x40,
  0x1E, 0x90, 0x9F, 0x40,
  0xAF, 0xA9, 0xDF, 0xB4,
  0x9D, 0xDD, 0xEF, 0xE7,
  0x00, 0x00, 0x9F, 0x40,
  0x00, 0x00, 0x8F, 0x30,
  0x00, 0x00, 0x02, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0035[ 44] = { /* code 0035, DIGIT FIVE */
  0x00, 0x22, 0x22, 0x00,
  0x0C, 0xFF, 0xFF, 0x90,
  0x1F, 0xC9, 0x99, 0x40,
  0x3F, 0x50, 0x00, 0x00,
  0x6F, 0xCF, 0xFB, 0x10,
  0x5F, 0xA6, 0xBF, 0xB0,
  0x00, 0x00, 0x0E, 0xF1,
  0x37, 0x00, 0x0E, 0xF0,
  0x8F, 0xB6, 0xAF, 0xB0,
  0x1B, 0xFF, 0xFA, 0x10,
  0x00, 0x12, 0x10, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0036[ 44] = { /* code 0036, DIGIT SIX */
  0x00, 0x03, 0x41, 0x00,
  0x02, 0xCF, 0xFF, 0x80,
  0x0C, 0xF5, 0x3D, 0xF0,
  0x3F, 0x90, 0x01, 0x30,
  0x6F, 0x9B, 0xDB, 0x40,
  0x7F, 0xF9, 0x8E, 0xE2,
  0x7F, 0x90, 0x08, 0xF6,
  0x5F, 0x90, 0x08, 0xF6,
  0x0D, 0xE7, 0x6E, 0xF2,
  0x03, 0xDF, 0xFE, 0x50,
  0x00, 0x02, 0x20, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0037[ 44] = { /* code 0037, DIGIT SEVEN */
  0x02, 0x22, 0x22, 0x10,
  0xCF, 0xFF, 0xFF, 0xF1,
  0x59, 0x99, 0xAF, 0xD0,
  0x00, 0x00, 0xAE, 0x20,
  0x00, 0x05, 0xF6, 0x00,
  0x00, 0x0D, 0xD0, 0x00,
  0x00, 0x6F, 0x70, 0x00,
  0x00, 0xCF, 0x20, 0x00,
  0x02, 0xFD, 0x00, 0x00,
  0x03, 0xF9, 0x00, 0x00,
  0x00, 0x20, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0038[ 44] = { /* code 0038, DIGIT EIGHT */
  0x00, 0x13, 0x31, 0x00,
  0x06, 0xFF, 0xFE, 0x60,
  0x2F, 0xD3, 0x4D, 0xF1,
  0x3F, 0xA0, 0x0A, 0xF2,
  0x0B, 0xE8, 0x8F, 0xB0,
  0x09, 0xFD, 0xDF, 0x90,
  0x6F, 0xA0, 0x0B, 0xF5,
  0x7F, 0x60, 0x08, 0xF7,
  0x3F, 0xE6, 0x6E, 0xF3,
  0x06, 0xEF, 0xFE, 0x60,
  0x00, 0x02, 0x20, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0039[ 44] = { /* code 0039, DIGIT NINE */
  0x00, 0x13, 0x30, 0x00,
  0x06, 0xFF, 0xFD, 0x30,
  0x3F, 0xD5, 0x5E, 0xD0,
  0x7F, 0x70, 0x0A, 0xF4,
  0x7F, 0x80, 0x0B, 0xF7,
  0x2E, 0xF9, 0xAF, 0xF7,
  0x03, 0xBD, 0xAA, 0xF5,
  0x04, 0x10, 0x0A, 0xF2,
  0x0F, 0xD4, 0x7F, 0xB0,
  0x07, 0xFF, 0xFB, 0x10,
  0x00, 0x12, 0x10, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_003A[ 16] = { /* code 003A, COLON */
  0x09, 0x90,
  0x1F, 0xF0,
  0x03, 0x30,
  0x00, 0x00,
  0x00, 0x00,
  0x0D, 0xD0,
  0x0D, 0xD0,
  0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_003B[ 18] = { /* code 003B, SEMICOLON */
  0x09, 0x90,
  0x1F, 0xF0,
  0x03, 0x30,
  0x00, 0x00,
  0x00, 0x00,
  0x0D, 0xD0,
  0x0E, 0xF3,
  0x01, 0xD1,
  0x0B, 0x50
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_003C[ 28] = { /* code 003C, LESS-THAN SIGN */
  0x00, 0x00, 0x28, 0xF6,
  0x00, 0x3A, 0xFF, 0xA2,
  0x3B, 0xFE, 0x82, 0x00,
  0x9F, 0xF5, 0x00, 0x00,
  0x06, 0xDF, 0xD7, 0x10,
  0x00, 0x05, 0xCF, 0xE4,
  0x00, 0x00, 0x03, 0x94
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_003D[ 20] = { /* code 003D, EQUALS SIGN */
  0xAF, 0xFF, 0xFF, 0xF7,
  0x49, 0x99, 0x99, 0x93,
  0x00, 0x00, 0x00, 0x00,
  0x8D, 0xDD, 0xDD, 0xD6,
  0x59, 0x99, 0x99, 0x93
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_003E[ 28] = { /* code 003E, GREATER-THAN SIGN */
  0x9E, 0x71, 0x00, 0x00,
  0x3B, 0xFF, 0x82, 0x00,
  0x00, 0x39, 0xFF, 0xA2,
  0x00, 0x00, 0x8F, 0xF7,
  0x02, 0x8E, 0xFB, 0x50,
  0x7F, 0xFA, 0x30, 0x00,
  0x58, 0x20, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_003F[ 44] = { /* code 003F, QUESTION MARK */
  0x00, 0x57, 0x72, 0x00,
  0x0B, 0xFF, 0xFF, 0x50,
  0x5F, 0x90, 0x4F, 0xC0,
  0x39, 0x10, 0x3F, 0xD0,
  0x00, 0x03, 0xEF, 0x50,
  0x00, 0x2E, 0xE4, 0x00,
  0x00, 0x4F, 0x50, 0x00,
  0x00, 0x01, 0x00, 0x00,
  0x00, 0x5F, 0x60, 0x00,
  0x00, 0x5F, 0x70, 0x00,
  0x00, 0x01, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0040[ 55] = { /* code 0040, COMMERCIAL AT */
  0x00, 0x03, 0x79, 0x73, 0x00,
  0x01, 0xBF, 0xB9, 0xBF, 0x90,
  0x0B, 0xE3, 0x13, 0x03, 0xE7,
  0x3F, 0x46, 0xFF, 0xCE, 0x6E,
  0x8E, 0x1F, 0x94, 0xDC, 0x2F,
  0x9C, 0x5F, 0x20, 0xAA, 0x3D,
  0x7E, 0x4F, 0x75, 0xE9, 0xB7,
  0x2F, 0x7B, 0xFD, 0xFF, 0x80,
  0x06, 0xF7, 0x30, 0x27, 0x80,
  0x00, 0x5D, 0xFF, 0xFC, 0x30,
  0x00, 0x00, 0x24, 0x10, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0041[ 55] = { /* code 0041, LATIN CAPITAL LETTER A */
  0x00, 0x05, 0x73, 0x00, 0x00,
  0x00, 0x1F, 0xFD, 0x00, 0x00,
  0x00, 0x7F, 0xFF, 0x30, 0x00,
  0x00, 0xCF, 0x7F, 0x90, 0x00,
  0x03, 0xFB, 0x1F, 0xE0, 0x00,
  0x09, 0xF7, 0x0B, 0xF4, 0x00,
  0x0E, 0xF9, 0x7B, 0xFA, 0x00,
  0x5F, 0xFF, 0xFF, 0xFF, 0x10,
  0xBF, 0x70, 0x00, 0xCF, 0x60,
  0xCF, 0x10, 0x00, 0x6F, 0x70,
  0x11, 0x00, 0x00, 0x02, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0042[ 40] = { /* code 0042, LATIN CAPITAL LETTER B */
  0x36, 0x66, 0x63, 0x00,
  0xFF, 0xFF, 0xFF, 0xC1,
  0xFF, 0x54, 0x5E, 0xF6,
  0xFF, 0x20, 0x0A, 0xF6,
  0xFF, 0x87, 0x9F, 0xC1,
  0xFF, 0xDD, 0xEF, 0xD3,
  0xFF, 0x20, 0x08, 0xFB,
  0xFF, 0x20, 0x06, 0xFB,
  0xFF, 0xA9, 0xAF, 0xF7,
  0xCF, 0xFF, 0xFD, 0x80
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0043[ 55] = { /* code 0043, LATIN CAPITAL LETTER C */
  0x00, 0x04, 0x89, 0x61, 0x00,
  0x01, 0xBF, 0xFF, 0xFE, 0x50,
  0x09, 0xFD, 0x42, 0x8F, 0xE0,
  0x1F, 0xF3, 0x00, 0x09, 0xA0,
  0x3F, 0xE0, 0x00, 0x00, 0x00,
  0x4F, 0xD0, 0x00, 0x00, 0x00,
  0x3F, 0xE0, 0x00, 0x02, 0x20,
  0x0E, 0xF6, 0x00, 0x1E, 0xF0,
  0x07, 0xFF, 0xA8, 0xDF, 0xB0,
  0x00, 0x7E, 0xFF, 0xFA, 0x10,
  0x00, 0x00, 0x33, 0x10, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0044[ 50] = { /* code 0044, LATIN CAPITAL LETTER D */
  0x36, 0x66, 0x52, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xB1, 0x00,
  0xFF, 0x76, 0x7D, 0xFA, 0x00,
  0xFF, 0x20, 0x03, 0xFF, 0x10,
  0xFF, 0x20, 0x00, 0xEF, 0x40,
  0xFF, 0x20, 0x00, 0xDF, 0x40,
  0xFF, 0x20, 0x00, 0xFF, 0x30,
  0xFF, 0x20, 0x07, 0xFE, 0x00,
  0xFF, 0xCB, 0xCF, 0xF5, 0x00,
  0xCF, 0xFF, 0xFB, 0x40, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0045[ 40] = { /* code 0045, LATIN CAPITAL LETTER E */
  0x26, 0x66, 0x66, 0x51,
  0xEF, 0xFF, 0xFF, 0xF5,
  0xFF, 0x76, 0x66, 0x50,
  0xFF, 0x20, 0x00, 0x00,
  0xFF, 0xA9, 0x99, 0x50,
  0xFF, 0xFF, 0xFF, 0xA0,
  0xFF, 0x20, 0x00, 0x00,
  0xFF, 0x20, 0x00, 0x00,
  0xFF, 0xCB, 0xBB, 0xB3,
  0xBF, 0xFF, 0xFF, 0xF5
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0046[ 44] = { /* code 0046, LATIN CAPITAL LETTER F */
  0x26, 0x66, 0x66, 0x40,
  0xEF, 0xFF, 0xFF, 0xF0,
  0xFF, 0x76, 0x66, 0x40,
  0xFF, 0x20, 0x00, 0x00,
  0xFF, 0x87, 0x77, 0x10,
  0xFF, 0xFF, 0xFF, 0x50,
  0xFF, 0x32, 0x22, 0x00,
  0xFF, 0x20, 0x00, 0x00,
  0xFF, 0x20, 0x00, 0x00,
  0xDF, 0x10, 0x00, 0x00,
  0x11, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0047[ 55] = { /* code 0047, LATIN CAPITAL LETTER G */
  0x00, 0x03, 0x79, 0x73, 0x00,
  0x01, 0xBF, 0xFF, 0xFF, 0x80,
  0x09, 0xFD, 0x52, 0x5E, 0xF2,
  0x1F, 0xF3, 0x00, 0x04, 0x80,
  0x4F, 0xE0, 0x00, 0x00, 0x00,
  0x4F, 0xD0, 0x08, 0xFF, 0xF8,
  0x3F, 0xE0, 0x04, 0x9B, 0xF9,
  0x0E, 0xF6, 0x00, 0x09, 0xF9,
  0x07, 0xFF, 0x96, 0xAF, 0xF9,
  0x00, 0x7E, 0xFF, 0xF7, 0xC9,
  0x00, 0x00, 0x33, 0x10, 0x11
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0048[ 55] = { /* code 0048, LATIN CAPITAL LETTER H */
  0x56, 0x00, 0x00, 0x56, 0x00,
  0xFF, 0x20, 0x00, 0xFF, 0x20,
  0xFF, 0x20, 0x00, 0xFF, 0x20,
  0xFF, 0x20, 0x00, 0xFF, 0x20,
  0xFF, 0xDD, 0xDD, 0xFF, 0x20,
  0xFF, 0xFF, 0xFF, 0xFF, 0x20,
  0xFF, 0x20, 0x00, 0xFF, 0x20,
  0xFF, 0x20, 0x00, 0xFF, 0x20,
  0xFF, 0x20, 0x00, 0xFF, 0x20,
  0xDE, 0x10, 0x00, 0xDE, 0x10,
  0x11, 0x00, 0x00, 0x11, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0049[ 22] = { /* code 0049, LATIN CAPITAL LETTER I */
  0x56, 0x00,
  0xFF, 0x20,
  0xFF, 0x20,
  0xFF, 0x20,
  0xFF, 0x20,
  0xFF, 0x20,
  0xFF, 0x20,
  0xFF, 0x20,
  0xFF, 0x20,
  0xDE, 0x10,
  0x11, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_004A[ 44] = { /* code 004A, LATIN CAPITAL LETTER J */
  0x00, 0x00, 0x27, 0x10,
  0x00, 0x00, 0x9F, 0x70,
  0x00, 0x00, 0x9F, 0x70,
  0x00, 0x00, 0x9F, 0x70,
  0x00, 0x00, 0x9F, 0x70,
  0x00, 0x00, 0x9F, 0x70,
  0x4A, 0x00, 0x9F, 0x70,
  0xBF, 0x30, 0xAF, 0x70,
  0x9F, 0xB7, 0xFF, 0x30,
  0x1C, 0xFF, 0xF8, 0x00,
  0x00, 0x33, 0x10, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_004B[ 44] = { /* code 004B, LATIN CAPITAL LETTER K */
  0x56, 0x00, 0x02, 0x71,
  0xFF, 0x20, 0x2E, 0xF4,
  0xFF, 0x21, 0xDF, 0x80,
  0xFF, 0x3C, 0xF9, 0x00,
  0xFF, 0xDF, 0xE1, 0x00,
  0xFF, 0xFF, 0xF8, 0x00,
  0xFF, 0x84, 0xFF, 0x30,
  0xFF, 0x20, 0x9F, 0xD0,
  0xFF, 0x20, 0x1D, 0xF8,
  0xDE, 0x10, 0x05, 0xFA,
  0x11, 0x00, 0x00, 0x20
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_004C[ 40] = { /* code 004C, LATIN CAPITAL LETTER L */
  0x56, 0x00, 0x00, 0x00,
  0xFF, 0x20, 0x00, 0x00,
  0xFF, 0x20, 0x00, 0x00,
  0xFF, 0x20, 0x00, 0x00,
  0xFF, 0x20, 0x00, 0x00,
  0xFF, 0x20, 0x00, 0x00,
  0xFF, 0x20, 0x00, 0x00,
  0xFF, 0x20, 0x00, 0x00,
  0xFF, 0xCB, 0xBB, 0x70,
  0xCF, 0xFF, 0xFF, 0x90
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_004D[ 55] = { /* code 004D, LATIN CAPITAL LETTER M */
  0x67, 0x40, 0x00, 0x07, 0x72,
  0xFF, 0xE0, 0x00, 0x5F, 0xF9,
  0xFF, 0xF4, 0x00, 0xAF, 0xF9,
  0xFE, 0xF8, 0x00, 0xED, 0xF9,
  0xFD, 0xBD, 0x04, 0xF8, 0xF9,
  0xFD, 0x7F, 0x39, 0xE4, 0xF9,
  0xFD, 0x2F, 0x7D, 0xA4, 0xF9,
  0xFD, 0x0C, 0xEF, 0x54, 0xF9,
  0xFD, 0x07, 0xFF, 0x14, 0xF9,
  0xEB, 0x02, 0xFA, 0x03, 0xF8,
  0x11, 0x00, 0x10, 0x00, 0x20
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_004E[ 55] = { /* code 004E, LATIN CAPITAL LETTER N */
  0x57, 0x10, 0x00, 0x57, 0x00,
  0xFF, 0xA0, 0x00, 0xDF, 0x20,
  0xFF, 0xF4, 0x00, 0xDF, 0x20,
  0xFF, 0xFD, 0x00, 0xDF, 0x20,
  0xFF, 0x7F, 0x70, 0xDF, 0x20,
  0xFF, 0x0D, 0xF2, 0xDF, 0x20,
  0xFF, 0x03, 0xFB, 0xDF, 0x20,
  0xFF, 0x00, 0x9F, 0xFF, 0x20,
  0xFF, 0x00, 0x1D, 0xFF, 0x20,
  0xEE, 0x00, 0x05, 0xFE, 0x10,
  0x11, 0x00, 0x00, 0x11, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_004F[ 55] = { /* code 004F, LATIN CAPITAL LETTER O */
  0x00, 0x04, 0x89, 0x72, 0x00,
  0x01, 0xCF, 0xFF, 0xFF, 0x80,
  0x0B, 0xFC, 0x42, 0x6E, 0xF5,
  0x3F, 0xF1, 0x00, 0x07, 0xFB,
  0x6F, 0xB0, 0x00, 0x02, 0xFF,
  0x6F, 0xB0, 0x00, 0x02, 0xFF,
  0x5F, 0xD0, 0x00, 0x04, 0xFD,
  0x1F, 0xF4, 0x00, 0x0A, 0xF9,
  0x07, 0xFF, 0x97, 0xCF, 0xE2,
  0x00, 0x7E, 0xFF, 0xFB, 0x20,
  0x00, 0x00, 0x33, 0x10, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0050[ 44] = { /* code 0050, LATIN CAPITAL LETTER P */
  0x36, 0x66, 0x63, 0x00,
  0xFF, 0xFF, 0xFF, 0xC1,
  0xFF, 0x54, 0x5D, 0xF8,
  0xFF, 0x20, 0x06, 0xFB,
  0xFF, 0x32, 0x2B, 0xF9,
  0xFF, 0xFF, 0xFF, 0xE2,
  0xFF, 0xA9, 0x87, 0x10,
  0xFF, 0x20, 0x00, 0x00,
  0xFF, 0x20, 0x00, 0x00,
  0xDE, 0x10, 0x00, 0x00,
  0x11, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0051[ 55] = { /* code 0051, LATIN CAPITAL LETTER Q */
  0x00, 0x04, 0x89, 0x72, 0x00,
  0x01, 0xCF, 0xFF, 0xFF, 0x80,
  0x0B, 0xFC, 0x42, 0x6E, 0xF5,
  0x3F, 0xF1, 0x00, 0x07, 0xFB,
  0x6F, 0xB0, 0x00, 0x02, 0xFF,
  0x6F, 0xB0, 0x00, 0x02, 0xFF,
  0x5F, 0xD0, 0x03, 0x34, 0xFE,
  0x1F, 0xF4, 0x09, 0xFC, 0xF9,
  0x07, 0xFF, 0x98, 0xFF, 0xE2,
  0x00, 0x7E, 0xFF, 0xFD, 0xF6,
  0x00, 0x00, 0x33, 0x10, 0x76
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0052[ 44] = { /* code 0052, LATIN CAPITAL LETTER R */
  0x36, 0x66, 0x65, 0x10,
  0xFF, 0xFF, 0xFF, 0xF5,
  0xFF, 0x54, 0x4A, 0xFD,
  0xFF, 0x20, 0x02, 0xFF,
  0xFF, 0x54, 0x49, 0xFA,
  0xFF, 0xFF, 0xFF, 0xD1,
  0xFF, 0x76, 0x6D, 0xF8,
  0xFF, 0x20, 0x06, 0xFA,
  0xFF, 0x20, 0x05, 0xFC,
  0xDE, 0x10, 0x02, 0xFD,
  0x11, 0x00, 0x00, 0x11
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0053[ 55] = { /* code 0053, LATIN CAPITAL LETTER S */
  0x00, 0x48, 0x97, 0x10, 0x00,
  0x0A, 0xFF, 0xFF, 0xF6, 0x00,
  0x4F, 0xD3, 0x26, 0xFE, 0x00,
  0x6F, 0xC0, 0x00, 0x44, 0x00,
  0x2F, 0xFE, 0xB8, 0x30, 0x00,
  0x03, 0xBF, 0xFF, 0xFA, 0x00,
  0x00, 0x00, 0x48, 0xFF, 0x30,
  0x4F, 0x50, 0x00, 0xCF, 0x50,
  0x3F, 0xF8, 0x69, 0xFE, 0x10,
  0x06, 0xEF, 0xFF, 0xD4, 0x00,
  0x00, 0x02, 0x42, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0054[ 55] = { /* code 0054, LATIN CAPITAL LETTER T */
  0x26, 0x66, 0x66, 0x65, 0x10,
  0xCF, 0xFF, 0xFF, 0xFF, 0x70,
  0x37, 0x7D, 0xFA, 0x76, 0x10,
  0x00, 0x0B, 0xF6, 0x00, 0x00,
  0x00, 0x0B, 0xF6, 0x00, 0x00,
  0x00, 0x0B, 0xF6, 0x00, 0x00,
  0x00, 0x0B, 0xF6, 0x00, 0x00,
  0x00, 0x0B, 0xF6, 0x00, 0x00,
  0x00, 0x0B, 0xF6, 0x00, 0x00,
  0x00, 0x09, 0xF4, 0x00, 0x00,
  0x00, 0x00, 0x20, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0055[ 55] = { /* code 0055, LATIN CAPITAL LETTER U */
  0x56, 0x00, 0x00, 0x56, 0x00,
  0xFF, 0x20, 0x00, 0xFF, 0x20,
  0xFF, 0x20, 0x00, 0xFF, 0x20,
  0xFF, 0x20, 0x00, 0xFF, 0x20,
  0xFF, 0x20, 0x00, 0xFF, 0x20,
  0xFF, 0x20, 0x00, 0xFF, 0x20,
  0xFF, 0x20, 0x00, 0xFF, 0x20,
  0xEF, 0x40, 0x02, 0xFF, 0x10,
  0x8F, 0xE8, 0x8D, 0xFA, 0x00,
  0x09, 0xFF, 0xFF, 0xA1, 0x00,
  0x00, 0x13, 0x31, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0056[ 55] = { /* code 0056, LATIN CAPITAL LETTER V */
  0x57, 0x00, 0x00, 0x37, 0x10,
  0xDF, 0x50, 0x00, 0xCF, 0x40,
  0x9F, 0x90, 0x02, 0xFE, 0x10,
  0x3F, 0xE0, 0x07, 0xFA, 0x00,
  0x0D, 0xF3, 0x0B, 0xF4, 0x00,
  0x08, 0xF8, 0x1F, 0xD0, 0x00,
  0x02, 0xFC, 0x6F, 0x80, 0x00,
  0x00, 0xCF, 0xCF, 0x30, 0x00,
  0x00, 0x7F, 0xFC, 0x00, 0x00,
  0x00, 0x2E, 0xF6, 0x00, 0x00,
  0x00, 0x01, 0x20, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0057[ 66] = { /* code 0057, LATIN CAPITAL LETTER W */
  0x46, 0x00, 0x06, 0x70, 0x00, 0x64,
  0xDF, 0x20, 0x2F, 0xF3, 0x01, 0xFD,
  0xAF, 0x60, 0x6F, 0xF7, 0x05, 0xFA,
  0x6F, 0x90, 0x9E, 0xEA, 0x08, 0xF7,
  0x2F, 0xC0, 0xDB, 0xAE, 0x0B, 0xF3,
  0x0E, 0xF2, 0xF7, 0x7F, 0x2E, 0xE0,
  0x09, 0xF7, 0xF4, 0x3F, 0x7F, 0xA0,
  0x06, 0xFE, 0xF0, 0x0E, 0xEF, 0x60,
  0x02, 0xFF, 0xB0, 0x0B, 0xFF, 0x20,
  0x00, 0xCF, 0x70, 0x06, 0xFD, 0x00,
  0x00, 0x12, 0x00, 0x00, 0x21, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0058[ 44] = { /* code 0058, LATIN CAPITAL LETTER X */
  0x27, 0x10, 0x02, 0x71,
  0x8F, 0xA0, 0x0B, 0xF6,
  0x2F, 0xF3, 0x6F, 0xD1,
  0x07, 0xFC, 0xEF, 0x30,
  0x00, 0xCF, 0xF8, 0x00,
  0x00, 0x8F, 0xF5, 0x00,
  0x04, 0xFF, 0xFD, 0x10,
  0x1D, 0xF6, 0xBF, 0x90,
  0x9F, 0xC0, 0x2F, 0xF4,
  0xBF, 0x30, 0x08, 0xF7,
  0x11, 0x00, 0x00, 0x20
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0059[ 44] = { /* code 0059, LATIN CAPITAL LETTER Y */
  0x47, 0x00, 0x00, 0x74,
  0xDF, 0x60, 0x06, 0xFC,
  0x6F, 0xD0, 0x0D, 0xF5,
  0x0C, 0xF7, 0x7F, 0xB0,
  0x03, 0xFE, 0xEF, 0x30,
  0x00, 0x9F, 0xF8, 0x00,
  0x00, 0x2F, 0xF1, 0x00,
  0x00, 0x2F, 0xF0, 0x00,
  0x00, 0x2F, 0xF0, 0x00,
  0x00, 0x1E, 0xE0, 0x00,
  0x00, 0x01, 0x10, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_005A[ 50] = { /* code 005A, LATIN CAPITAL LETTER Z */
  0x04, 0x66, 0x66, 0x65, 0x10,
  0x3F, 0xFF, 0xFF, 0xFF, 0x60,
  0x05, 0x77, 0x7D, 0xFE, 0x20,
  0x00, 0x00, 0x5F, 0xF3, 0x00,
  0x00, 0x03, 0xFF, 0x60, 0x00,
  0x00, 0x2E, 0xF8, 0x00, 0x00,
  0x01, 0xDF, 0xA0, 0x00, 0x00,
  0x0B, 0xFC, 0x10, 0x00, 0x00,
  0x7F, 0xFC, 0xBB, 0xBB, 0x40,
  0x7F, 0xFF, 0xFF, 0xFF, 0x50
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_005B[ 26] = { /* code 005B, LEFT SQUARE BRACKET */
  0x36, 0x62,
  0xDF, 0xF7,
  0xDD, 0x00,
  0xDD, 0x00,
  0xDD, 0x00,
  0xDD, 0x00,
  0xDD, 0x00,
  0xDD, 0x00,
  0xDD, 0x00,
  0xDD, 0x00,
  0xDD, 0x00,
  0xDF, 0xF7,
  0x36, 0x62
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_005C[ 33] = { /* code 005C, REVERSE SOLIDUS */
  0x73, 0x00, 0x00,
  0xCB, 0x00, 0x00,
  0x6F, 0x20, 0x00,
  0x1F, 0x70, 0x00,
  0x0A, 0xD0, 0x00,
  0x04, 0xF3, 0x00,
  0x00, 0xD9, 0x00,
  0x00, 0x8E, 0x00,
  0x00, 0x2F, 0x60,
  0x00, 0x0B, 0xA0,
  0x00, 0x01, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_005D[ 26] = { /* code 005D, RIGHT SQUARE BRACKET */
  0x46, 0x51,
  0xEF, 0xF6,
  0x04, 0xF7,
  0x04, 0xF7,
  0x04, 0xF7,
  0x04, 0xF7,
  0x04, 0xF7,
  0x04, 0xF7,
  0x04, 0xF7,
  0x04, 0xF7,
  0x04, 0xF7,
  0xEF, 0xF6,
  0x46, 0x51
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_005E[ 28] = { /* code 005E, CIRCUMFLEX ACCENT */
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x1D, 0xB0, 0x00,
  0x00, 0x7F, 0xF5, 0x00,
  0x01, 0xF9, 0xCD, 0x00,
  0x09, 0xF1, 0x4F, 0x60,
  0x1F, 0x70, 0x0A, 0xD0,
  0x02, 0x00, 0x00, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_005F[  4] = { /* code 005F, LOW LINE */
  0x39, 0x99, 0x99, 0x98
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0060[  6] = { /* code 0060, GRAVE ACCENT */
  0xC7, 0x00,
  0x8F, 0xA0,
  0x03, 0x60
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0061[ 32] = { /* code 0061, LATIN SMALL LETTER A */
  0x03, 0xBE, 0xEC, 0x40,
  0x0E, 0xE8, 0x8F, 0xE0,
  0x06, 0x20, 0x2E, 0xF2,
  0x07, 0xCF, 0xFF, 0xF2,
  0x5F, 0xB3, 0x1D, 0xF2,
  0x7F, 0xA2, 0x6F, 0xF2,
  0x1C, 0xFF, 0xAA, 0xF3,
  0x00, 0x21, 0x00, 0x20
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0062[ 44] = { /* code 0062, LATIN SMALL LETTER B */
  0x07, 0x30, 0x00, 0x00,
  0x4F, 0x90, 0x00, 0x00,
  0x4F, 0x90, 0x00, 0x00,
  0x4F, 0xBB, 0xFC, 0x30,
  0x4F, 0xFA, 0x9F, 0xE1,
  0x4F, 0xB0, 0x09, 0xF5,
  0x4F, 0x80, 0x06, 0xF7,
  0x4F, 0xA0, 0x08, 0xF6,
  0x4F, 0xF7, 0x7E, 0xF2,
  0x3F, 0xAE, 0xFE, 0x50,
  0x02, 0x00, 0x20, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0063[ 32] = { /* code 0063, LATIN SMALL LETTER C */
  0x03, 0xBE, 0xE9, 0x10,
  0x1E, 0xF9, 0xAF, 0xA0,
  0x7F, 0x80, 0x07, 0x50,
  0x9F, 0x40, 0x00, 0x00,
  0x8F, 0x60, 0x05, 0x40,
  0x3F, 0xE6, 0x7F, 0xA0,
  0x06, 0xEF, 0xFC, 0x20,
  0x00, 0x02, 0x20, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0064[ 44] = { /* code 0064, LATIN SMALL LETTER D */
  0x00, 0x00, 0x03, 0x70,
  0x00, 0x00, 0x0B, 0xF3,
  0x00, 0x00, 0x0B, 0xF4,
  0x04, 0xCF, 0xAC, 0xF4,
  0x1E, 0xF9, 0xAF, 0xF4,
  0x6F, 0x90, 0x0C, 0xF4,
  0x7F, 0x60, 0x09, 0xF4,
  0x7F, 0x70, 0x0B, 0xF4,
  0x2F, 0xE7, 0x7F, 0xF4,
  0x06, 0xFF, 0xEA, 0xF2,
  0x00, 0x12, 0x00, 0x20
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0065[ 32] = { /* code 0065, LATIN SMALL LETTER E */
  0x02, 0xAE, 0xEB, 0x20,
  0x0D, 0xE7, 0x7E, 0xE1,
  0x6F, 0x82, 0x28, 0xF6,
  0x7F, 0xFF, 0xFF, 0xF6,
  0x7F, 0x70, 0x00, 0x30,
  0x2E, 0xE7, 0x6C, 0xF1,
  0x04, 0xDF, 0xFE, 0x70,
  0x00, 0x02, 0x20, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0066[ 33] = { /* code 0066, LATIN SMALL LETTER F */
  0x00, 0x69, 0x30,
  0x07, 0xFF, 0x90,
  0x09, 0xF4, 0x00,
  0x9E, 0xFC, 0x70,
  0x4C, 0xF9, 0x30,
  0x09, 0xF4, 0x00,
  0x09, 0xF4, 0x00,
  0x09, 0xF4, 0x00,
  0x09, 0xF4, 0x00,
  0x08, 0xF3, 0x00,
  0x00, 0x10, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0067[ 40] = { /* code 0067, LATIN SMALL LETTER G */
  0x03, 0xCF, 0xB7, 0xE1,
  0x1E, 0xF9, 0xAF, 0xF4,
  0x6F, 0x80, 0x0C, 0xF4,
  0x7F, 0x60, 0x09, 0xF4,
  0x7F, 0x80, 0x0C, 0xF4,
  0x1E, 0xFA, 0xBF, 0xF4,
  0x03, 0xAB, 0x8A, 0xF3,
  0x08, 0x30, 0x0C, 0xF1,
  0x0E, 0xFA, 0xCF, 0x90,
  0x02, 0x9B, 0xB7, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0068[ 44] = { /* code 0068, LATIN SMALL LETTER H */
  0x07, 0x30, 0x00, 0x00,
  0x4F, 0x90, 0x00, 0x00,
  0x4F, 0x90, 0x00, 0x00,
  0x4F, 0xAA, 0xED, 0x50,
  0x4F, 0xFB, 0xAF, 0xF1,
  0x4F, 0xC0, 0x0C, 0xF3,
  0x4F, 0x90, 0x0B, 0xF4,
  0x4F, 0x90, 0x0B, 0xF4,
  0x4F, 0x90, 0x0B, 0xF4,
  0x3F, 0x90, 0x0A, 0xF2,
  0x02, 0x00, 0x00, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0069[ 22] = { /* code 0069, LATIN SMALL LETTER I */
  0x07, 0x40,
  0x2F, 0xB0,
  0x04, 0x20,
  0x1E, 0x80,
  0x2F, 0xB0,
  0x2F, 0xB0,
  0x2F, 0xB0,
  0x2F, 0xB0,
  0x2F, 0xB0,
  0x1F, 0xA0,
  0x01, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_006A[ 26] = { /* code 006A, LATIN SMALL LETTER J */
  0x00, 0x74,
  0x02, 0xFB,
  0x00, 0x42,
  0x01, 0xE8,
  0x02, 0xFB,
  0x02, 0xFB,
  0x02, 0xFB,
  0x02, 0xFB,
  0x02, 0xFB,
  0x02, 0xFB,
  0x02, 0xFB,
  0x2C, 0xFA,
  0x19, 0x92
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_006B[ 44] = { /* code 006B, LATIN SMALL LETTER K */
  0x07, 0x30, 0x00, 0x00,
  0x4F, 0x90, 0x00, 0x00,
  0x4F, 0x90, 0x00, 0x00,
  0x4F, 0x90, 0x5E, 0x30,
  0x4F, 0x94, 0xFE, 0x20,
  0x4F, 0xCE, 0xE3, 0x00,
  0x4F, 0xFF, 0xE2, 0x00,
  0x4F, 0xD8, 0xFC, 0x00,
  0x4F, 0x90, 0xBF, 0x80,
  0x3F, 0x90, 0x2E, 0xB0,
  0x01, 0x00, 0x01, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_006C[ 22] = { /* code 006C, LATIN SMALL LETTER L */
  0x07, 0x40,
  0x2F, 0xB0,
  0x2F, 0xB0,
  0x2F, 0xB0,
  0x2F, 0xB0,
  0x2F, 0xB0,
  0x2F, 0xB0,
  0x2F, 0xB0,
  0x2F, 0xB0,
  0x1F, 0xA0,
  0x01, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_006D[ 48] = { /* code 006D, LATIN SMALL LETTER M */
  0x2E, 0x69, 0xED, 0x38, 0xEE, 0x70,
  0x4F, 0xEB, 0xBF, 0xED, 0xAF, 0xF3,
  0x4F, 0xC0, 0x0F, 0xF2, 0x0A, 0xF4,
  0x4F, 0x90, 0x0F, 0xF0, 0x09, 0xF4,
  0x4F, 0x90, 0x0F, 0xF0, 0x09, 0xF4,
  0x4F, 0x90, 0x0F, 0xF0, 0x09, 0xF4,
  0x3F, 0x90, 0x0D, 0xE0, 0x08, 0xF3,
  0x02, 0x00, 0x01, 0x10, 0x00, 0x20
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_006E[ 32] = { /* code 006E, LATIN SMALL LETTER N */
  0x2E, 0x6A, 0xED, 0x50,
  0x4F, 0xFB, 0xAF, 0xF1,
  0x4F, 0xC0, 0x0C, 0xF3,
  0x4F, 0x90, 0x0B, 0xF4,
  0x4F, 0x90, 0x0B, 0xF4,
  0x4F, 0x90, 0x0B, 0xF4,
  0x3F, 0x90, 0x0A, 0xF2,
  0x02, 0x00, 0x00, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_006F[ 32] = { /* code 006F, LATIN SMALL LETTER O */
  0x02, 0xBE, 0xEA, 0x20,
  0x1D, 0xF8, 0x8F, 0xD0,
  0x6F, 0x80, 0x09, 0xF5,
  0x7F, 0x60, 0x06, 0xF7,
  0x7F, 0x70, 0x08, 0xF6,
  0x2F, 0xE5, 0x5E, 0xF2,
  0x05, 0xEF, 0xFE, 0x40,
  0x00, 0x02, 0x20, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0070[ 40] = { /* code 0070, LATIN SMALL LETTER P */
  0x2E, 0x7B, 0xFC, 0x30,
  0x4F, 0xFA, 0x9F, 0xE1,
  0x4F, 0xB0, 0x0A, 0xF5,
  0x4F, 0x80, 0x06, 0xF7,
  0x4F, 0xA0, 0x08, 0xF6,
  0x4F, 0xF7, 0x7E, 0xF2,
  0x4F, 0xBD, 0xFF, 0x50,
  0x4F, 0x90, 0x21, 0x00,
  0x4F, 0x90, 0x00, 0x00,
  0x19, 0x40, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0071[ 40] = { /* code 0071, LATIN SMALL LETTER Q */
  0x03, 0xCF, 0xB7, 0xE1,
  0x1E, 0xF9, 0xAF, 0xF4,
  0x6F, 0x90, 0x0C, 0xF4,
  0x7F, 0x60, 0x09, 0xF4,
  0x7F, 0x70, 0x0B, 0xF4,
  0x3F, 0xE6, 0x7F, 0xF4,
  0x06, 0xFF, 0xDD, 0xF4,
  0x00, 0x12, 0x0B, 0xF4,
  0x00, 0x00, 0x0B, 0xF3,
  0x00, 0x00, 0x05, 0x90
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0072[ 24] = { /* code 0072, LATIN SMALL LETTER R */
  0x1E, 0x7B, 0xE1,
  0x2F, 0xEE, 0xC1,
  0x2F, 0xE1, 0x00,
  0x2F, 0xB0, 0x00,
  0x2F, 0xB0, 0x00,
  0x2F, 0xB0, 0x00,
  0x1F, 0xA0, 0x00,
  0x01, 0x10, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0073[ 32] = { /* code 0073, LATIN SMALL LETTER S */
  0x08, 0xDF, 0xC7, 0x00,
  0x6F, 0xB7, 0xCF, 0x20,
  0x7F, 0xB4, 0x13, 0x00,
  0x2C, 0xFF, 0xFA, 0x10,
  0x13, 0x36, 0xCF, 0x70,
  0x7F, 0x72, 0x9F, 0x60,
  0x1B, 0xFF, 0xFA, 0x00,
  0x00, 0x12, 0x10, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0074[ 30] = { /* code 0074, LATIN SMALL LETTER T */
  0x08, 0xC1, 0x00,
  0x0B, 0xF2, 0x00,
  0x9E, 0xFC, 0x60,
  0x4D, 0xF8, 0x30,
  0x0B, 0xF2, 0x00,
  0x0B, 0xF2, 0x00,
  0x0B, 0xF2, 0x00,
  0x0B, 0xF7, 0x20,
  0x07, 0xFF, 0x70,
  0x00, 0x12, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0075[ 32] = { /* code 0075, LATIN SMALL LETTER U */
  0x2E, 0x70, 0x08, 0xE1,
  0x4F, 0x90, 0x0B, 0xF4,
  0x4F, 0x90, 0x0B, 0xF4,
  0x4F, 0x90, 0x0B, 0xF4,
  0x4F, 0xA0, 0x0C, 0xF4,
  0x2F, 0xF7, 0x9F, 0xF4,
  0x08, 0xFF, 0xC8, 0xF2,
  0x00, 0x12, 0x00, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0076[ 32] = { /* code 0076, LATIN SMALL LETTER V */
  0xBB, 0x00, 0x4E, 0x30,
  0xCF, 0x20, 0xAF, 0x40,
  0x7F, 0x70, 0xEE, 0x00,
  0x1F, 0xB4, 0xF9, 0x00,
  0x0B, 0xF9, 0xF3, 0x00,
  0x05, 0xFF, 0xD0, 0x00,
  0x01, 0xEF, 0x70, 0x00,
  0x00, 0x12, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0077[ 40] = { /* code 0077, LATIN SMALL LETTER W */
  0x9C, 0x00, 0xCD, 0x10, 0xBB,
  0xBF, 0x23, 0xFF, 0x51, 0xFC,
  0x7F, 0x66, 0xFE, 0x84, 0xF8,
  0x2F, 0xA9, 0xCA, 0xC7, 0xF3,
  0x0C, 0xDC, 0x87, 0xFB, 0xE0,
  0x08, 0xFF, 0x43, 0xFF, 0x90,
  0x03, 0xFE, 0x10, 0xDF, 0x40,
  0x00, 0x11, 0x00, 0x12, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0078[ 24] = { /* code 0078, LATIN SMALL LETTER X */
  0x6E, 0x20, 0xAC,
  0x6F, 0xB5, 0xFB,
  0x0B, 0xFE, 0xE2,
  0x03, 0xFF, 0x80,
  0x0B, 0xFF, 0xE2,
  0x6F, 0xA7, 0xFB,
  0xBE, 0x20, 0xCE,
  0x01, 0x00, 0x11
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0079[ 40] = { /* code 0079, LATIN SMALL LETTER Y */
  0xAC, 0x00, 0x5E, 0x30,
  0xBF, 0x40, 0xBF, 0x30,
  0x6F, 0x80, 0xED, 0x00,
  0x1F, 0xC4, 0xF7, 0x00,
  0x0A, 0xF9, 0xF2, 0x00,
  0x05, 0xFF, 0xC0, 0x00,
  0x00, 0xEF, 0x70, 0x00,
  0x00, 0xBF, 0x10, 0x00,
  0x4F, 0xFA, 0x00, 0x00,
  0x19, 0x81, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_007A[ 28] = { /* code 007A, LATIN SMALL LETTER Z */
  0x2B, 0xBB, 0xBB, 0x70,
  0x2A, 0xBB, 0xFF, 0x90,
  0x00, 0x08, 0xFA, 0x00,
  0x00, 0x7F, 0xB1, 0x00,
  0x06, 0xFD, 0x10, 0x00,
  0x4F, 0xF9, 0x77, 0x50,
  0x7F, 0xFF, 0xFF, 0xB0
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_007B[ 39] = { /* code 007B, LEFT CURLY BRACKET */
  0x00, 0x46, 0x20,
  0x08, 0xFE, 0x50,
  0x0B, 0xF0, 0x00,
  0x0B, 0xF0, 0x00,
  0x0B, 0xF0, 0x00,
  0x1C, 0xF0, 0x00,
  0xEF, 0x70, 0x00,
  0x1C, 0xF0, 0x00,
  0x0B, 0xF0, 0x00,
  0x0B, 0xF0, 0x00,
  0x0B, 0xF0, 0x00,
  0x08, 0xFC, 0x50,
  0x00, 0x56, 0x20
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_007C[ 22] = { /* code 007C, VERTICAL LINE */
  0x18, 0x00,
  0x6F, 0x40,
  0x6F, 0x40,
  0x6F, 0x40,
  0x6F, 0x40,
  0x6F, 0x40,
  0x6F, 0x40,
  0x6F, 0x40,
  0x6F, 0x40,
  0x5F, 0x30,
  0x03, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_007D[ 39] = { /* code 007D, RIGHT CURLY BRACKET */
  0x46, 0x30, 0x00,
  0xBE, 0xF2, 0x00,
  0x08, 0xF4, 0x00,
  0x07, 0xF4, 0x00,
  0x07, 0xF4, 0x00,
  0x06, 0xF6, 0x00,
  0x00, 0xCF, 0x70,
  0x06, 0xF7, 0x00,
  0x07, 0xF4, 0x00,
  0x07, 0xF4, 0x00,
  0x07, 0xF4, 0x00,
  0xAE, 0xF2, 0x00,
  0x56, 0x30, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_007E[ 12] = { /* code 007E, TILDE */
  0x0A, 0xDA, 0x41, 0xA2,
  0x6F, 0xAE, 0xFF, 0xE2,
  0x23, 0x00, 0x67, 0x30
};

GUI_CONST_STORAGE GUI_CHARINFO_EXT GUI_FontRounded16_CharInfo[95] = {
   {   1,   1,   0,  13,   4, acGUI_FontRounded16_0020 } /* code 0020, SPACE */
  ,{   3,  11,   1,   3,   4, acGUI_FontRounded16_0021 } /* code 0021, EXCLAMATION MARK */
  ,{   5,   5,   1,   3,   7, acGUI_FontRounded16_0022 } /* code 0022, QUOTATION MARK */
  ,{   8,  11,   0,   3,   8, acGUI_FontRounded16_0023 } /* code 0023, NUMBER SIGN */
  ,{   8,  12,   0,   3,   8, acGUI_FontRounded16_0024 } /* code 0024, DOLLAR SIGN */
  ,{  11,  11,   1,   3,  13, acGUI_FontRounded16_0025 } /* code 0025, PERCENT SIGN */
  ,{   9,  11,   0,   3,   9, acGUI_FontRounded16_0026 } /* code 0026, AMPERSAND */
  ,{   2,   5,   1,   3,   4, acGUI_FontRounded16_0027 } /* code 0027, APOSTROPHE */
  ,{   4,  13,   0,   3,   4, acGUI_FontRounded16_0028 } /* code 0028, LEFT PARENTHESIS */
  ,{   4,  13,   0,   3,   4, acGUI_FontRounded16_0029 } /* code 0029, RIGHT PARENTHESIS */
  ,{   6,   6,   0,   3,   6, acGUI_FontRounded16_002A } /* code 002A, ASTERISK */
  ,{   8,   8,   0,   5,   8, acGUI_FontRounded16_002B } /* code 002B, PLUS SIGN */
  ,{   4,   4,   0,  11,   4, acGUI_FontRounded16_002C } /* code 002C, COMMA */
  ,{   5,   3,   0,   8,   5, acGUI_FontRounded16_002D } /* code 002D, HYPHEN-MINUS */
  ,{   4,   3,   0,  11,   4, acGUI_FontRounded16_002E } /* code 002E, FULL STOP */
  ,{   5,  11,   0,   3,   5, acGUI_FontRounded16_002F } /* code 002F, SOLIDUS */
  ,{   8,  11,   0,   3,   8, acGUI_FontRounded16_0030 } /* code 0030, DIGIT ZERO */
  ,{   6,  11,  -1,   3,   5, acGUI_FontRounded16_0031 } /* code 0031, DIGIT ONE */
  ,{   8,  10,   0,   3,   8, acGUI_FontRounded16_0032 } /* code 0032, DIGIT TWO */
  ,{   8,  11,   0,   3,   8, acGUI_FontRounded16_0033 } /* code 0033, DIGIT THREE */
  ,{   8,  11,   0,   3,   8, acGUI_FontRounded16_0034 } /* code 0034, DIGIT FOUR */
  ,{   8,  11,   0,   3,   8, acGUI_FontRounded16_0035 } /* code 0035, DIGIT FIVE */
  ,{   8,  11,   0,   3,   8, acGUI_FontRounded16_0036 } /* code 0036, DIGIT SIX */
  ,{   8,  11,   0,   3,   7, acGUI_FontRounded16_0037 } /* code 0037, DIGIT SEVEN */
  ,{   8,  11,   0,   3,   8, acGUI_FontRounded16_0038 } /* code 0038, DIGIT EIGHT */
  ,{   8,  11,   0,   3,   8, acGUI_FontRounded16_0039 } /* code 0039, DIGIT NINE */
  ,{   4,   8,   0,   6,   4, acGUI_FontRounded16_003A } /* code 003A, COLON */
  ,{   4,   9,   0,   6,   4, acGUI_FontRounded16_003B } /* code 003B, SEMICOLON */
  ,{   8,   7,   0,   6,   8, acGUI_FontRounded16_003C } /* code 003C, LESS-THAN SIGN */
  ,{   8,   5,   0,   7,   8, acGUI_FontRounded16_003D } /* code 003D, EQUALS SIGN */
  ,{   8,   7,   0,   6,   8, acGUI_FontRounded16_003E } /* code 003E, GREATER-THAN SIGN */
  ,{   7,  11,   0,   3,   7, acGUI_FontRounded16_003F } /* code 003F, QUESTION MARK */
  ,{  10,  11,   0,   3,  10, acGUI_FontRounded16_0040 } /* code 0040, COMMERCIAL AT */
  ,{   9,  11,   0,   3,   9, acGUI_FontRounded16_0041 } /* code 0041, LATIN CAPITAL LETTER A */
  ,{   8,  10,   1,   3,   9, acGUI_FontRounded16_0042 } /* code 0042, LATIN CAPITAL LETTER B */
  ,{   9,  11,   0,   3,   9, acGUI_FontRounded16_0043 } /* code 0043, LATIN CAPITAL LETTER C */
  ,{   9,  10,   1,   3,  10, acGUI_FontRounded16_0044 } /* code 0044, LATIN CAPITAL LETTER D */
  ,{   8,  10,   1,   3,   9, acGUI_FontRounded16_0045 } /* code 0045, LATIN CAPITAL LETTER E */
  ,{   8,  11,   1,   3,   8, acGUI_FontRounded16_0046 } /* code 0046, LATIN CAPITAL LETTER F */
  ,{  10,  11,   0,   3,  11, acGUI_FontRounded16_0047 } /* code 0047, LATIN CAPITAL LETTER G */
  ,{   9,  11,   1,   3,  10, acGUI_FontRounded16_0048 } /* code 0048, LATIN CAPITAL LETTER H */
  ,{   3,  11,   1,   3,   4, acGUI_FontRounded16_0049 } /* code 0049, LATIN CAPITAL LETTER I */
  ,{   7,  11,   0,   3,   7, acGUI_FontRounded16_004A } /* code 004A, LATIN CAPITAL LETTER J */
  ,{   8,  11,   1,   3,   9, acGUI_FontRounded16_004B } /* code 004B, LATIN CAPITAL LETTER K */
  ,{   7,  10,   1,   3,   8, acGUI_FontRounded16_004C } /* code 004C, LATIN CAPITAL LETTER L */
  ,{  10,  11,   1,   3,  12, acGUI_FontRounded16_004D } /* code 004D, LATIN CAPITAL LETTER M */
  ,{   9,  11,   1,   3,  10, acGUI_FontRounded16_004E } /* code 004E, LATIN CAPITAL LETTER N */
  ,{  10,  11,   0,   3,  11, acGUI_FontRounded16_004F } /* code 004F, LATIN CAPITAL LETTER O */
  ,{   8,  11,   1,   3,   9, acGUI_FontRounded16_0050 } /* code 0050, LATIN CAPITAL LETTER P */
  ,{  10,  11,   0,   3,  11, acGUI_FontRounded16_0051 } /* code 0051, LATIN CAPITAL LETTER Q */
  ,{   8,  11,   1,   3,  10, acGUI_FontRounded16_0052 } /* code 0052, LATIN CAPITAL LETTER R */
  ,{   9,  11,   0,   3,   9, acGUI_FontRounded16_0053 } /* code 0053, LATIN CAPITAL LETTER S */
  ,{   9,  11,   0,   3,   9, acGUI_FontRounded16_0054 } /* code 0054, LATIN CAPITAL LETTER T */
  ,{   9,  11,   1,   3,  10, acGUI_FontRounded16_0055 } /* code 0055, LATIN CAPITAL LETTER U */
  ,{   9,  11,   0,   3,   8, acGUI_FontRounded16_0056 } /* code 0056, LATIN CAPITAL LETTER V */
  ,{  12,  11,   0,   3,  12, acGUI_FontRounded16_0057 } /* code 0057, LATIN CAPITAL LETTER W */
  ,{   8,  11,   0,   3,   8, acGUI_FontRounded16_0058 } /* code 0058, LATIN CAPITAL LETTER X */
  ,{   8,  11,   0,   3,   8, acGUI_FontRounded16_0059 } /* code 0059, LATIN CAPITAL LETTER Y */
  ,{   9,  10,   0,   3,   9, acGUI_FontRounded16_005A } /* code 005A, LATIN CAPITAL LETTER Z */
  ,{   4,  13,   1,   3,   5, acGUI_FontRounded16_005B } /* code 005B, LEFT SQUARE BRACKET */
  ,{   5,  11,   0,   3,   5, acGUI_FontRounded16_005C } /* code 005C, REVERSE SOLIDUS */
  ,{   4,  13,   0,   3,   5, acGUI_FontRounded16_005D } /* code 005D, RIGHT SQUARE BRACKET */
  ,{   7,   7,   0,   3,   8, acGUI_FontRounded16_005E } /* code 005E, CIRCUMFLEX ACCENT */
  ,{   8,   1,  -1,  14,   7, acGUI_FontRounded16_005F } /* code 005F, LOW LINE */
  ,{   3,   3,   0,   3,   4, acGUI_FontRounded16_0060 } /* code 0060, GRAVE ACCENT */
  ,{   8,   8,   0,   6,   8, acGUI_FontRounded16_0061 } /* code 0061, LATIN SMALL LETTER A */
  ,{   8,  11,   0,   3,   8, acGUI_FontRounded16_0062 } /* code 0062, LATIN SMALL LETTER B */
  ,{   7,   8,   0,   6,   7, acGUI_FontRounded16_0063 } /* code 0063, LATIN SMALL LETTER C */
  ,{   8,  11,   0,   3,   8, acGUI_FontRounded16_0064 } /* code 0064, LATIN SMALL LETTER D */
  ,{   8,   8,   0,   6,   8, acGUI_FontRounded16_0065 } /* code 0065, LATIN SMALL LETTER E */
  ,{   5,  11,   0,   3,   5, acGUI_FontRounded16_0066 } /* code 0066, LATIN SMALL LETTER F */
  ,{   8,  10,   0,   6,   8, acGUI_FontRounded16_0067 } /* code 0067, LATIN SMALL LETTER G */
  ,{   8,  11,   0,   3,   8, acGUI_FontRounded16_0068 } /* code 0068, LATIN SMALL LETTER H */
  ,{   3,  11,   0,   3,   4, acGUI_FontRounded16_0069 } /* code 0069, LATIN SMALL LETTER I */
  ,{   4,  13,  -1,   3,   4, acGUI_FontRounded16_006A } /* code 006A, LATIN SMALL LETTER J */
  ,{   7,  11,   0,   3,   7, acGUI_FontRounded16_006B } /* code 006B, LATIN SMALL LETTER K */
  ,{   3,  11,   0,   3,   4, acGUI_FontRounded16_006C } /* code 006C, LATIN SMALL LETTER L */
  ,{  12,   8,   0,   6,  12, acGUI_FontRounded16_006D } /* code 006D, LATIN SMALL LETTER M */
  ,{   8,   8,   0,   6,   8, acGUI_FontRounded16_006E } /* code 006E, LATIN SMALL LETTER N */
  ,{   8,   8,   0,   6,   8, acGUI_FontRounded16_006F } /* code 006F, LATIN SMALL LETTER O */
  ,{   8,  10,   0,   6,   8, acGUI_FontRounded16_0070 } /* code 0070, LATIN SMALL LETTER P */
  ,{   8,  10,   0,   6,   8, acGUI_FontRounded16_0071 } /* code 0071, LATIN SMALL LETTER Q */
  ,{   6,   8,   0,   6,   5, acGUI_FontRounded16_0072 } /* code 0072, LATIN SMALL LETTER R */
  ,{   7,   8,   0,   6,   7, acGUI_FontRounded16_0073 } /* code 0073, LATIN SMALL LETTER S */
  ,{   5,  10,   0,   4,   5, acGUI_FontRounded16_0074 } /* code 0074, LATIN SMALL LETTER T */
  ,{   8,   8,   0,   6,   8, acGUI_FontRounded16_0075 } /* code 0075, LATIN SMALL LETTER U */
  ,{   7,   8,   0,   6,   7, acGUI_FontRounded16_0076 } /* code 0076, LATIN SMALL LETTER V */
  ,{  10,   8,   0,   6,  10, acGUI_FontRounded16_0077 } /* code 0077, LATIN SMALL LETTER W */
  ,{   6,   8,   0,   6,   6, acGUI_FontRounded16_0078 } /* code 0078, LATIN SMALL LETTER X */
  ,{   7,  10,   0,   6,   7, acGUI_FontRounded16_0079 } /* code 0079, LATIN SMALL LETTER Y */
  ,{   7,   7,   0,   6,   7, acGUI_FontRounded16_007A } /* code 007A, LATIN SMALL LETTER Z */
  ,{   5,  13,   0,   3,   5, acGUI_FontRounded16_007B } /* code 007B, LEFT CURLY BRACKET */
  ,{   3,  11,   0,   3,   3, acGUI_FontRounded16_007C } /* code 007C, VERTICAL LINE */
  ,{   5,  13,   0,   3,   5, acGUI_FontRounded16_007D } /* code 007D, RIGHT CURLY BRACKET */
  ,{   8,   3,   0,   8,   8, acGUI_FontRounded16_007E } /* code 007E, TILDE */
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_FontRounded16_Prop1 = {
   0x0020 /* first character */
  ,0x007E /* last character  */
  ,&GUI_FontRounded16_CharInfo[  0] /* address of first character */
  ,(GUI_CONST_STORAGE GUI_FONT_PROP_EXT *)0 /* pointer to next GUI_FONT_PROP_EXT */
};

GUI_CONST_STORAGE GUI_FONT GUI_FontRounded16 = {
   GUI_FONTTYPE_PROP_AA4_EXT /* type of font    */
  ,16 /* height of font  */
  ,16 /* space of font y */
  ,1 /* magnification x */
  ,1 /* magnification y */
  ,{&GUI_FontRounded16_Prop1}
  ,16 /* Baseline */
  ,8 /* Height of lowercase characters */
  ,11 /* Height of capital characters */
};

/*********************************************************************
*                                                                    *
*       GUI_FontRounded22                                            *
*                                                                    *
**********************************************************************
*/
GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0020[  1] = { /* code 0020, SPACE */
  0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0021[ 30] = { /* code 0021, EXCLAMATION MARK */
  0x02, 0x10,
  0x6F, 0xE2,
  0x9F, 0xF4,
  0x9F, 0xF4,
  0x9F, 0xF4,
  0x7F, 0xF2,
  0x5F, 0xF0,
  0x3F, 0xD0,
  0x1F, 0xB0,
  0x0D, 0x80,
  0x00, 0x00,
  0x2B, 0xA0,
  0x9F, 0xF4,
  0x5F, 0xE1,
  0x01, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0022[ 28] = { /* code 0022, QUOTATION MARK */
  0x01, 0x10, 0x02, 0x00,
  0x0E, 0xF2, 0x7F, 0x90,
  0x2F, 0xF4, 0x9F, 0xB0,
  0x2F, 0xF4, 0x9F, 0xB0,
  0x2F, 0xF4, 0x9F, 0xB0,
  0x1E, 0xF2, 0x8F, 0xA0,
  0x02, 0x20, 0x03, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0023[ 84] = { /* code 0023, NUMBER SIGN */
  0x00, 0x02, 0xB4, 0x08, 0x90, 0x00,
  0x00, 0x06, 0xF7, 0x0F, 0xD0, 0x00,
  0x00, 0x08, 0xF5, 0x2F, 0xB0, 0x00,
  0x00, 0x2B, 0xF4, 0x5F, 0xA1, 0x00,
  0x07, 0xFF, 0xFF, 0xFF, 0xFE, 0x10,
  0x03, 0x9F, 0xE9, 0xDF, 0xB8, 0x00,
  0x00, 0x1F, 0xB0, 0xAF, 0x30, 0x00,
  0x02, 0x6F, 0xB4, 0xDF, 0x40, 0x00,
  0x0F, 0xFF, 0xFF, 0xFF, 0xF7, 0x00,
  0x06, 0xBF, 0x98, 0xFD, 0x72, 0x00,
  0x00, 0xAF, 0x33, 0xF9, 0x00, 0x00,
  0x00, 0xCF, 0x15, 0xF7, 0x00, 0x00,
  0x00, 0xDD, 0x07, 0xF4, 0x00, 0x00,
  0x00, 0x22, 0x00, 0x30, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0024[ 96] = { /* code 0024, DOLLAR SIGN */
  0x00, 0x00, 0x0B, 0x10, 0x00, 0x00,
  0x00, 0x28, 0xBF, 0xC8, 0x30, 0x00,
  0x05, 0xFF, 0xFF, 0xFF, 0xF9, 0x00,
  0x1E, 0xF9, 0x2F, 0x39, 0xFF, 0x50,
  0x3F, 0xF0, 0x0F, 0x20, 0x9E, 0x30,
  0x3F, 0xF6, 0x0F, 0x20, 0x00, 0x00,
  0x0D, 0xFF, 0xDF, 0x73, 0x00, 0x00,
  0x02, 0xCF, 0xFF, 0xFF, 0xC3, 0x00,
  0x00, 0x04, 0x8F, 0xEF, 0xFE, 0x10,
  0x03, 0x00, 0x0F, 0x25, 0xFF, 0x70,
  0x7F, 0xA0, 0x0F, 0x20, 0xBF, 0x80,
  0x7F, 0xF3, 0x0F, 0x21, 0xEF, 0x60,
  0x1D, 0xFE, 0xAF, 0xBE, 0xFD, 0x10,
  0x01, 0xAF, 0xFF, 0xFF, 0xA2, 0x00,
  0x00, 0x01, 0x3F, 0x41, 0x00, 0x00,
  0x00, 0x00, 0x0D, 0x10, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0025[120] = { /* code 0025, PERCENT SIGN */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00,
  0x03, 0xAB, 0xA2, 0x00, 0x00, 0x7F, 0x00, 0x00,
  0x2E, 0xEA, 0xFE, 0x10, 0x01, 0xE8, 0x00, 0x00,
  0x7F, 0x70, 0x9F, 0x50, 0x08, 0xE1, 0x00, 0x00,
  0x9F, 0x60, 0x7F, 0x70, 0x2F, 0x70, 0x00, 0x00,
  0x7F, 0x60, 0x8F, 0x60, 0x9E, 0x10, 0x00, 0x00,
  0x3F, 0xD6, 0xEF, 0x22, 0xF7, 0x00, 0x00, 0x00,
  0x07, 0xEF, 0xE6, 0x0A, 0xE0, 0x17, 0x98, 0x20,
  0x00, 0x01, 0x00, 0x3F, 0x60, 0xCF, 0xCF, 0xE1,
  0x00, 0x00, 0x00, 0xBD, 0x04, 0xFA, 0x09, 0xF6,
  0x00, 0x00, 0x04, 0xF5, 0x07, 0xF7, 0x06, 0xF9,
  0x00, 0x00, 0x0C, 0xC0, 0x06, 0xF8, 0x06, 0xF8,
  0x00, 0x00, 0x5F, 0x40, 0x03, 0xFC, 0x3B, 0xF4,
  0x00, 0x00, 0xCB, 0x00, 0x00, 0x8F, 0xFF, 0x90,
  0x00, 0x00, 0x93, 0x00, 0x00, 0x01, 0x42, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0026[105] = { /* code 0026, AMPERSAND */
  0x00, 0x00, 0x01, 0x10, 0x00, 0x00, 0x00,
  0x00, 0x04, 0xDF, 0xFD, 0x50, 0x00, 0x00,
  0x00, 0x3F, 0xFD, 0xCF, 0xF4, 0x00, 0x00,
  0x00, 0x9F, 0xD0, 0x0B, 0xFA, 0x00, 0x00,
  0x00, 0x9F, 0xD0, 0x0B, 0xFA, 0x00, 0x00,
  0x00, 0x4F, 0xF9, 0x8F, 0xF5, 0x00, 0x00,
  0x00, 0x0A, 0xFF, 0xFF, 0x80, 0x00, 0x00,
  0x00, 0x9F, 0xFF, 0xFB, 0x00, 0x54, 0x00,
  0x09, 0xFF, 0xBA, 0xFF, 0x74, 0xFF, 0x00,
  0x1F, 0xFB, 0x00, 0xBF, 0xFE, 0xFC, 0x00,
  0x3F, 0xF7, 0x00, 0x1D, 0xFF, 0xE3, 0x00,
  0x1F, 0xFB, 0x00, 0x2C, 0xFF, 0xE3, 0x00,
  0x0A, 0xFF, 0xED, 0xFF, 0xEE, 0xFD, 0x00,
  0x01, 0xAF, 0xFF, 0xFB, 0x24, 0xFD, 0x00,
  0x00, 0x01, 0x43, 0x10, 0x00, 0x10, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0027[ 14] = { /* code 0027, APOSTROPHE */
  0x01, 0x10,
  0x3F, 0xD0,
  0x6F, 0xF0,
  0x6F, 0xF0,
  0x6F, 0xF0,
  0x3F, 0xE0,
  0x03, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0028[ 54] = { /* code 0028, LEFT PARENTHESIS */
  0x00, 0x03, 0x00,
  0x00, 0x9F, 0x40,
  0x02, 0xFF, 0x20,
  0x08, 0xFB, 0x00,
  0x0E, 0xF7, 0x00,
  0x4F, 0xF3, 0x00,
  0x7F, 0xE0, 0x00,
  0xAF, 0xC0, 0x00,
  0xBF, 0xB0, 0x00,
  0xBF, 0xB0, 0x00,
  0xBF, 0xB0, 0x00,
  0x8F, 0xE0, 0x00,
  0x5F, 0xF2, 0x00,
  0x1F, 0xF5, 0x00,
  0x0A, 0xFA, 0x00,
  0x04, 0xFE, 0x10,
  0x00, 0xCF, 0x50,
  0x00, 0x29, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0029[ 54] = { /* code 0029, RIGHT PARENTHESIS */
  0x03, 0x00, 0x00,
  0x5F, 0x90, 0x00,
  0x2F, 0xF2, 0x00,
  0x0B, 0xF8, 0x00,
  0x07, 0xFE, 0x00,
  0x03, 0xFF, 0x30,
  0x00, 0xFF, 0x70,
  0x00, 0xCF, 0xA0,
  0x00, 0xBF, 0xB0,
  0x00, 0xBF, 0xB0,
  0x00, 0xCF, 0xB0,
  0x00, 0xEF, 0x80,
  0x02, 0xFF, 0x50,
  0x05, 0xFF, 0x10,
  0x0A, 0xFA, 0x00,
  0x1E, 0xF4, 0x00,
  0x5F, 0xC0, 0x00,
  0x19, 0x20, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_002A[ 32] = { /* code 002A, ASTERISK */
  0x00, 0x00, 0x10, 0x00,
  0x00, 0x08, 0xE0, 0x00,
  0x05, 0x29, 0xF0, 0x51,
  0x2F, 0xFE, 0xFE, 0xF7,
  0x02, 0x7F, 0xFB, 0x40,
  0x00, 0xAF, 0xCE, 0x20,
  0x03, 0xF7, 0x2F, 0x90,
  0x00, 0x30, 0x03, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_002B[ 66] = { /* code 002B, PLUS SIGN */
  0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x8F, 0x50, 0x00, 0x00,
  0x00, 0x00, 0xBF, 0x70, 0x00, 0x00,
  0x00, 0x00, 0xBF, 0x70, 0x00, 0x00,
  0x02, 0x22, 0xCF, 0x82, 0x22, 0x00,
  0x8F, 0xFF, 0xFF, 0xFF, 0xFF, 0x60,
  0x6F, 0xFF, 0xFF, 0xFF, 0xFE, 0x40,
  0x00, 0x00, 0xBF, 0x70, 0x00, 0x00,
  0x00, 0x00, 0xBF, 0x70, 0x00, 0x00,
  0x00, 0x00, 0xBF, 0x70, 0x00, 0x00,
  0x00, 0x00, 0x7F, 0x40, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_002C[ 12] = { /* code 002C, COMMA */
  0x3C, 0x90,
  0xBF, 0xF5,
  0x6F, 0xF7,
  0x01, 0xE5,
  0x4C, 0xC0,
  0x67, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_002D[ 16] = { /* code 002D, HYPHEN-MINUS */
  0x01, 0x44, 0x42, 0x00,
  0x2F, 0xFF, 0xFF, 0x70,
  0x3F, 0xFF, 0xFF, 0x80,
  0x02, 0x44, 0x43, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_002E[  8] = { /* code 002E, FULL STOP */
  0x3C, 0x90,
  0xBF, 0xF3,
  0x6F, 0xD1,
  0x01, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_002F[ 60] = { /* code 002F, SOLIDUS */
  0x00, 0x00, 0x03, 0x00,
  0x00, 0x00, 0x6F, 0x70,
  0x00, 0x00, 0xCF, 0x40,
  0x00, 0x03, 0xFD, 0x00,
  0x00, 0x08, 0xF8, 0x00,
  0x00, 0x0E, 0xF2, 0x00,
  0x00, 0x5F, 0xB0, 0x00,
  0x00, 0xBF, 0x60, 0x00,
  0x01, 0xFE, 0x10, 0x00,
  0x07, 0xF9, 0x00, 0x00,
  0x0D, 0xF3, 0x00, 0x00,
  0x3F, 0xD0, 0x00, 0x00,
  0x9F, 0x70, 0x00, 0x00,
  0xCF, 0x20, 0x00, 0x00,
  0x23, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0030[ 84] = { /* code 0030, DIGIT ZERO */
  0x00, 0x05, 0xBB, 0xB6, 0x00, 0x00,
  0x00, 0xAF, 0xFF, 0xFF, 0xA0, 0x00,
  0x06, 0xFF, 0xA6, 0xAF, 0xF7, 0x00,
  0x0D, 0xFC, 0x00, 0x0C, 0xFD, 0x00,
  0x2F, 0xF8, 0x00, 0x08, 0xFF, 0x20,
  0x4F, 0xF6, 0x00, 0x06, 0xFF, 0x40,
  0x4F, 0xF6, 0x00, 0x06, 0xFF, 0x40,
  0x4F, 0xF6, 0x00, 0x06, 0xFF, 0x40,
  0x2F, 0xF7, 0x00, 0x06, 0xFF, 0x30,
  0x0E, 0xFA, 0x00, 0x0A, 0xFE, 0x00,
  0x09, 0xFF, 0x40, 0x4F, 0xF9, 0x00,
  0x02, 0xEF, 0xFE, 0xFF, 0xE2, 0x00,
  0x00, 0x3C, 0xFF, 0xFC, 0x30, 0x00,
  0x00, 0x00, 0x24, 0x20, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0031[ 56] = { /* code 0031, DIGIT ONE */
  0x00, 0x00, 0x2B, 0x70,
  0x00, 0x00, 0xAF, 0xC0,
  0x01, 0x49, 0xFF, 0xD0,
  0x1E, 0xFF, 0xFF, 0xD0,
  0x1B, 0xDD, 0xFF, 0xD0,
  0x00, 0x00, 0xDF, 0xD0,
  0x00, 0x00, 0xDF, 0xD0,
  0x00, 0x00, 0xDF, 0xD0,
  0x00, 0x00, 0xDF, 0xD0,
  0x00, 0x00, 0xDF, 0xD0,
  0x00, 0x00, 0xDF, 0xD0,
  0x00, 0x00, 0xDF, 0xC0,
  0x00, 0x00, 0xBF, 0xA0,
  0x00, 0x00, 0x13, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0032[ 78] = { /* code 0032, DIGIT TWO */
  0x00, 0x17, 0xBB, 0xB6, 0x00, 0x00,
  0x03, 0xEF, 0xFF, 0xFF, 0xD1, 0x00,
  0x0D, 0xFE, 0x86, 0xAF, 0xFB, 0x00,
  0x5F, 0xF6, 0x00, 0x0D, 0xFF, 0x00,
  0x4F, 0xE1, 0x00, 0x0B, 0xFF, 0x00,
  0x03, 0x20, 0x00, 0x3F, 0xFB, 0x00,
  0x00, 0x00, 0x07, 0xEF, 0xF3, 0x00,
  0x00, 0x03, 0xCF, 0xFD, 0x30, 0x00,
  0x00, 0x6F, 0xFE, 0x70, 0x00, 0x00,
  0x06, 0xFF, 0xA2, 0x00, 0x00, 0x00,
  0x2F, 0xFC, 0x44, 0x44, 0x42, 0x00,
  0x6F, 0xFF, 0xFF, 0xFF, 0xFF, 0x10,
  0x3E, 0xFF, 0xFF, 0xFF, 0xFD, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0033[ 70] = { /* code 0033, DIGIT THREE */
  0x00, 0x28, 0xBB, 0xA5, 0x00,
  0x05, 0xFF, 0xFF, 0xFF, 0xA0,
  0x1F, 0xFE, 0x76, 0xCF, 0xF4,
  0x2F, 0xF4, 0x00, 0x2F, 0xF7,
  0x04, 0x40, 0x00, 0x2F, 0xF5,
  0x00, 0x00, 0x5A, 0xEF, 0xB0,
  0x00, 0x00, 0xFF, 0xFF, 0x90,
  0x00, 0x00, 0x38, 0xCF, 0xF8,
  0x01, 0x00, 0x00, 0x1E, 0xFC,
  0x3F, 0xC0, 0x00, 0x0E, 0xFD,
  0x5F, 0xF8, 0x00, 0x7F, 0xF9,
  0x1D, 0xFF, 0xFE, 0xFF, 0xE2,
  0x02, 0xBF, 0xFF, 0xFB, 0x30,
  0x00, 0x01, 0x33, 0x10, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0034[ 84] = { /* code 0034, DIGIT FOUR */
  0x00, 0x00, 0x00, 0x9B, 0x40, 0x00,
  0x00, 0x00, 0x07, 0xFF, 0x90, 0x00,
  0x00, 0x00, 0x4F, 0xFF, 0x90, 0x00,
  0x00, 0x02, 0xEE, 0xEF, 0x90, 0x00,
  0x00, 0x0C, 0xF4, 0xDF, 0x90, 0x00,
  0x00, 0x9F, 0x80, 0xDF, 0x90, 0x00,
  0x06, 0xFB, 0x00, 0xDF, 0x90, 0x00,
  0x3F, 0xE2, 0x00, 0xDF, 0x90, 0x00,
  0xBF, 0xFF, 0xFF, 0xFF, 0xFE, 0x50,
  0x8F, 0xFF, 0xFF, 0xFF, 0xFF, 0x60,
  0x02, 0x22, 0x22, 0xDF, 0xA2, 0x00,
  0x00, 0x00, 0x00, 0xDF, 0x90, 0x00,
  0x00, 0x00, 0x00, 0xBF, 0x80, 0x00,
  0x00, 0x00, 0x00, 0x13, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0035[ 70] = { /* code 0035, DIGIT FIVE */
  0x01, 0x89, 0x99, 0x99, 0x70,
  0x07, 0xFF, 0xFF, 0xFF, 0xF3,
  0x0A, 0xFD, 0xBB, 0xBB, 0x90,
  0x0C, 0xF5, 0x00, 0x00, 0x00,
  0x0F, 0xF3, 0x46, 0x51, 0x00,
  0x3F, 0xFD, 0xFF, 0xFE, 0x60,
  0x3F, 0xFE, 0xAB, 0xFF, 0xF3,
  0x06, 0x60, 0x00, 0x4F, 0xFA,
  0x00, 0x00, 0x00, 0x0D, 0xFB,
  0x17, 0x40, 0x00, 0x0E, 0xFB,
  0x5F, 0xF4, 0x00, 0x8F, 0xF7,
  0x3F, 0xFF, 0xDE, 0xFF, 0xD1,
  0x04, 0xCF, 0xFF, 0xFA, 0x10,
  0x00, 0x02, 0x43, 0x10, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0036[ 84] = { /* code 0036, DIGIT SIX */
  0x00, 0x04, 0x9B, 0xB9, 0x30, 0x00,
  0x00, 0x8F, 0xFF, 0xFF, 0xF4, 0x00,
  0x04, 0xFF, 0x93, 0x4E, 0xFB, 0x00,
  0x0B, 0xFC, 0x00, 0x02, 0x93, 0x00,
  0x1F, 0xF7, 0x02, 0x31, 0x00, 0x00,
  0x3F, 0xF9, 0xDF, 0xFF, 0x91, 0x00,
  0x4F, 0xFF, 0xEB, 0xDF, 0xFA, 0x00,
  0x4F, 0xFD, 0x10, 0x0B, 0xFF, 0x20,
  0x3F, 0xF8, 0x00, 0x06, 0xFF, 0x40,
  0x1F, 0xF8, 0x00, 0x06, 0xFF, 0x40,
  0x0B, 0xFE, 0x20, 0x1C, 0xFF, 0x10,
  0x03, 0xEF, 0xFD, 0xEF, 0xF7, 0x00,
  0x00, 0x3C, 0xFF, 0xFE, 0x70, 0x00,
  0x00, 0x00, 0x24, 0x30, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0037[ 70] = { /* code 0037, DIGIT SEVEN */
  0x49, 0x99, 0x99, 0x99, 0x94,
  0xBF, 0xFF, 0xFF, 0xFF, 0xFD,
  0x5B, 0xBB, 0xBB, 0xBF, 0xF9,
  0x00, 0x00, 0x00, 0x9F, 0xC0,
  0x00, 0x00, 0x05, 0xFE, 0x20,
  0x00, 0x00, 0x1E, 0xF6, 0x00,
  0x00, 0x00, 0x9F, 0xD0, 0x00,
  0x00, 0x02, 0xFF, 0x70, 0x00,
  0x00, 0x08, 0xFF, 0x10, 0x00,
  0x00, 0x0E, 0xFB, 0x00, 0x00,
  0x00, 0x4F, 0xF7, 0x00, 0x00,
  0x00, 0x7F, 0xF3, 0x00, 0x00,
  0x00, 0x6F, 0xD0, 0x00, 0x00,
  0x00, 0x03, 0x10, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0038[ 84] = { /* code 0038, DIGIT EIGHT */
  0x00, 0x17, 0xBB, 0xB8, 0x10, 0x00,
  0x02, 0xEF, 0xFF, 0xFF, 0xE3, 0x00,
  0x0B, 0xFE, 0x62, 0x6E, 0xFB, 0x00,
  0x0D, 0xFA, 0x00, 0x0A, 0xFF, 0x00,
  0x0C, 0xFB, 0x00, 0x0B, 0xFC, 0x00,
  0x04, 0xFF, 0xB8, 0xBF, 0xF4, 0x00,
  0x02, 0xBF, 0xFF, 0xFF, 0xB2, 0x00,
  0x0C, 0xFE, 0x64, 0x6E, 0xFD, 0x00,
  0x3F, 0xF7, 0x00, 0x07, 0xFF, 0x30,
  0x4F, 0xF6, 0x00, 0x06, 0xFF, 0x40,
  0x2F, 0xFC, 0x10, 0x1B, 0xFF, 0x20,
  0x09, 0xFF, 0xED, 0xEF, 0xF9, 0x00,
  0x00, 0x7E, 0xFF, 0xFE, 0x80, 0x00,
  0x00, 0x00, 0x24, 0x30, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0039[ 84] = { /* code 0039, DIGIT NINE */
  0x00, 0x17, 0xBB, 0xB6, 0x00, 0x00,
  0x03, 0xEF, 0xFF, 0xFF, 0xB0, 0x00,
  0x0C, 0xFE, 0x74, 0x8F, 0xF8, 0x00,
  0x3F, 0xF8, 0x00, 0x0A, 0xFE, 0x00,
  0x4F, 0xF6, 0x00, 0x07, 0xFF, 0x30,
  0x3F, 0xF7, 0x00, 0x0A, 0xFF, 0x40,
  0x0D, 0xFF, 0x74, 0x9F, 0xFF, 0x40,
  0x03, 0xEF, 0xFF, 0xFD, 0xFF, 0x40,
  0x00, 0x17, 0x99, 0x56, 0xFF, 0x20,
  0x00, 0x30, 0x00, 0x09, 0xFD, 0x00,
  0x09, 0xFA, 0x00, 0x3F, 0xF8, 0x00,
  0x08, 0xFF, 0xDB, 0xFF, 0xD1, 0x00,
  0x01, 0x9F, 0xFF, 0xFA, 0x20, 0x00,
  0x00, 0x01, 0x33, 0x10, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_003A[ 22] = { /* code 003A, COLON */
  0x05, 0x30,
  0x9F, 0xF2,
  0x9F, 0xF2,
  0x17, 0x40,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x3C, 0x90,
  0xBF, 0xF3,
  0x6F, 0xD1,
  0x01, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_003B[ 26] = { /* code 003B, SEMICOLON */
  0x05, 0x30,
  0x9F, 0xF2,
  0x9F, 0xF2,
  0x17, 0x40,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x3C, 0x90,
  0xBF, 0xF5,
  0x6F, 0xF7,
  0x01, 0xE5,
  0x4C, 0xC0,
  0x67, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_003C[ 60] = { /* code 003C, LESS-THAN SIGN */
  0x00, 0x00, 0x00, 0x01, 0x8B, 0x20,
  0x00, 0x00, 0x02, 0x9F, 0xFF, 0x50,
  0x00, 0x03, 0xAF, 0xFF, 0xC6, 0x00,
  0x05, 0xCF, 0xFF, 0xB4, 0x00, 0x00,
  0x7F, 0xFF, 0x92, 0x00, 0x00, 0x00,
  0x5F, 0xFF, 0xB5, 0x00, 0x00, 0x00,
  0x02, 0x9F, 0xFF, 0xD7, 0x10, 0x00,
  0x00, 0x01, 0x7E, 0xFF, 0xF8, 0x10,
  0x00, 0x00, 0x00, 0x7D, 0xFF, 0x50,
  0x00, 0x00, 0x00, 0x00, 0x57, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_003D[ 48] = { /* code 003D, EQUALS SIGN */
  0x04, 0x44, 0x44, 0x44, 0x43, 0x00,
  0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0x70,
  0x5D, 0xDD, 0xDD, 0xDD, 0xDC, 0x30,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0x50,
  0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0x50,
  0x02, 0x22, 0x22, 0x22, 0x21, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_003E[ 60] = { /* code 003E, GREATER-THAN SIGN */
  0x4B, 0x70, 0x00, 0x00, 0x00, 0x00,
  0x8F, 0xFE, 0x81, 0x00, 0x00, 0x00,
  0x17, 0xEF, 0xFF, 0x92, 0x00, 0x00,
  0x00, 0x05, 0xCF, 0xFF, 0xA3, 0x00,
  0x00, 0x00, 0x03, 0xAF, 0xFF, 0x40,
  0x00, 0x00, 0x06, 0xDF, 0xFE, 0x30,
  0x00, 0x28, 0xEF, 0xFE, 0x71, 0x00,
  0x1A, 0xFF, 0xFD, 0x60, 0x00, 0x00,
  0x9F, 0xFC, 0x50, 0x00, 0x00, 0x00,
  0x27, 0x30, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_003F[ 75] = { /* code 003F, QUESTION MARK */
  0x00, 0x00, 0x22, 0x00, 0x00,
  0x00, 0x7E, 0xFF, 0xFA, 0x20,
  0x09, 0xFF, 0xEE, 0xFF, 0xE1,
  0x2F, 0xFA, 0x00, 0x7F, 0xF7,
  0x2F, 0xE2, 0x00, 0x3F, 0xF7,
  0x02, 0x20, 0x00, 0xAF, 0xF5,
  0x00, 0x00, 0x1B, 0xFF, 0xA0,
  0x00, 0x00, 0xCF, 0xF7, 0x00,
  0x00, 0x05, 0xFF, 0x50, 0x00,
  0x00, 0x02, 0xEC, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x02, 0xBA, 0x10, 0x00,
  0x00, 0x08, 0xFF, 0x50, 0x00,
  0x00, 0x04, 0xFE, 0x20, 0x00,
  0x00, 0x00, 0x11, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0040[105] = { /* code 0040, COMMERCIAL AT */
  0x00, 0x00, 0x00, 0x34, 0x31, 0x00, 0x00,
  0x00, 0x02, 0x9E, 0xFF, 0xFF, 0xA2, 0x00,
  0x00, 0x3E, 0xFB, 0x76, 0x7A, 0xFE, 0x50,
  0x02, 0xEF, 0x50, 0x00, 0x00, 0x3E, 0xE2,
  0x0B, 0xF6, 0x07, 0xEE, 0x96, 0xB5, 0xF8,
  0x2F, 0xD0, 0x7F, 0xFF, 0xFF, 0xF0, 0xEC,
  0x5F, 0x91, 0xEF, 0x40, 0x8F, 0xC0, 0xBD,
  0x7F, 0x74, 0xFA, 0x00, 0x4F, 0x90, 0xCB,
  0x6F, 0x85, 0xFB, 0x00, 0x6F, 0x71, 0xF7,
  0x3F, 0xC2, 0xFF, 0x98, 0xEF, 0xAC, 0xD1,
  0x0C, 0xF4, 0x9F, 0xFF, 0xEF, 0xFB, 0x20,
  0x03, 0xFE, 0x45, 0x73, 0x37, 0x57, 0x00,
  0x00, 0x5E, 0xFB, 0x66, 0x69, 0xEE, 0x10,
  0x00, 0x02, 0x9F, 0xFF, 0xFF, 0xA2, 0x00,
  0x00, 0x00, 0x01, 0x34, 0x31, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0041[ 90] = { /* code 0041, LATIN CAPITAL LETTER A */
  0x00, 0x00, 0x02, 0x30, 0x00, 0x00,
  0x00, 0x00, 0x9F, 0xFB, 0x00, 0x00,
  0x00, 0x01, 0xFF, 0xFF, 0x30, 0x00,
  0x00, 0x06, 0xFF, 0xFF, 0x80, 0x00,
  0x00, 0x0C, 0xFD, 0xCF, 0xE0, 0x00,
  0x00, 0x3F, 0xF8, 0x7F, 0xF4, 0x00,
  0x00, 0x8F, 0xF3, 0x2F, 0xFA, 0x00,
  0x00, 0xEF, 0xD0, 0x0D, 0xFF, 0x10,
  0x04, 0xFF, 0x80, 0x08, 0xFF, 0x60,
  0x0A, 0xFF, 0xCB, 0xBC, 0xFF, 0xB0,
  0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF2,
  0x7F, 0xF9, 0x44, 0x44, 0x9F, 0xF7,
  0xCF, 0xF3, 0x00, 0x00, 0x3F, 0xFC,
  0xAF, 0xC0, 0x00, 0x00, 0x0C, 0xFA,
  0x03, 0x10, 0x00, 0x00, 0x01, 0x30
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0042[ 78] = { /* code 0042, LATIN CAPITAL LETTER B */
  0x3D, 0xFF, 0xFF, 0xED, 0xA3, 0x00,
  0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0x30,
  0x9F, 0xF8, 0x44, 0x4C, 0xFF, 0xA0,
  0x9F, 0xF6, 0x00, 0x04, 0xFF, 0xB0,
  0x9F, 0xF6, 0x00, 0x06, 0xFF, 0x70,
  0x9F, 0xFB, 0x99, 0xBF, 0xFB, 0x10,
  0x9F, 0xFF, 0xFF, 0xFF, 0xFB, 0x20,
  0x9F, 0xF8, 0x44, 0x4A, 0xFF, 0xD0,
  0x9F, 0xF6, 0x00, 0x00, 0xCF, 0xF2,
  0x9F, 0xF6, 0x00, 0x00, 0xCF, 0xF3,
  0x9F, 0xF8, 0x44, 0x5A, 0xFF, 0xE0,
  0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0x60,
  0x4E, 0xFF, 0xFF, 0xFE, 0xB4, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0043[ 90] = { /* code 0043, LATIN CAPITAL LETTER C */
  0x00, 0x00, 0x13, 0x43, 0x00, 0x00,
  0x00, 0x2A, 0xFF, 0xFF, 0xE7, 0x00,
  0x03, 0xEF, 0xFF, 0xFF, 0xFF, 0xB0,
  0x1E, 0xFF, 0xB3, 0x25, 0xEF, 0xF6,
  0x7F, 0xFB, 0x00, 0x00, 0x4F, 0xF7,
  0xCF, 0xF3, 0x00, 0x00, 0x03, 0x61,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xD0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xDF, 0xF3, 0x00, 0x00, 0x05, 0x71,
  0x9F, 0xFA, 0x00, 0x00, 0x4F, 0xF7,
  0x3F, 0xFF, 0x93, 0x25, 0xEF, 0xF5,
  0x06, 0xFF, 0xFF, 0xFF, 0xFF, 0xA0,
  0x00, 0x4C, 0xFF, 0xFF, 0xE7, 0x00,
  0x00, 0x00, 0x24, 0x43, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0044[ 78] = { /* code 0044, LATIN CAPITAL LETTER D */
  0x3D, 0xFF, 0xFF, 0xEC, 0x71, 0x00,
  0x9F, 0xFF, 0xFF, 0xFF, 0xFE, 0x30,
  0x9F, 0xF9, 0x66, 0x7D, 0xFF, 0xD0,
  0x9F, 0xF6, 0x00, 0x01, 0xCF, 0xF6,
  0x9F, 0xF6, 0x00, 0x00, 0x5F, 0xFA,
  0x9F, 0xF6, 0x00, 0x00, 0x2F, 0xFD,
  0x9F, 0xF6, 0x00, 0x00, 0x2F, 0xFD,
  0x9F, 0xF6, 0x00, 0x00, 0x2F, 0xFC,
  0x9F, 0xF6, 0x00, 0x00, 0x6F, 0xFA,
  0x9F, 0xF6, 0x00, 0x01, 0xDF, 0xF5,
  0x9F, 0xF9, 0x66, 0x7D, 0xFF, 0xC0,
  0x9F, 0xFF, 0xFF, 0xFF, 0xFD, 0x20,
  0x4E, 0xFF, 0xFF, 0xFC, 0x71, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0045[ 78] = { /* code 0045, LATIN CAPITAL LETTER E */
  0x3D, 0xFF, 0xFF, 0xFF, 0xFE, 0x50,
  0x8F, 0xFF, 0xFF, 0xFF, 0xFF, 0x80,
  0x9F, 0xF9, 0x66, 0x66, 0x65, 0x10,
  0x9F, 0xF6, 0x00, 0x00, 0x00, 0x00,
  0x9F, 0xF6, 0x00, 0x00, 0x00, 0x00,
  0x9F, 0xFD, 0xBB, 0xBB, 0xB6, 0x00,
  0x9F, 0xFF, 0xFF, 0xFF, 0xFB, 0x00,
  0x9F, 0xFA, 0x77, 0x77, 0x73, 0x00,
  0x9F, 0xF6, 0x00, 0x00, 0x00, 0x00,
  0x9F, 0xF6, 0x00, 0x00, 0x00, 0x00,
  0x9F, 0xF9, 0x66, 0x66, 0x65, 0x10,
  0x8F, 0xFF, 0xFF, 0xFF, 0xFF, 0xA0,
  0x3D, 0xFF, 0xFF, 0xFF, 0xFF, 0x70
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0046[ 84] = { /* code 0046, LATIN CAPITAL LETTER F */
  0x3D, 0xFF, 0xFF, 0xFF, 0xFB, 0x10,
  0x8F, 0xFF, 0xFF, 0xFF, 0xFF, 0x10,
  0x9F, 0xF9, 0x66, 0x66, 0x64, 0x00,
  0x9F, 0xF6, 0x00, 0x00, 0x00, 0x00,
  0x9F, 0xF6, 0x00, 0x00, 0x00, 0x00,
  0x9F, 0xFB, 0x99, 0x99, 0x70, 0x00,
  0x9F, 0xFF, 0xFF, 0xFF, 0xF3, 0x00,
  0x9F, 0xFD, 0xBB, 0xBB, 0x90, 0x00,
  0x9F, 0xF6, 0x00, 0x00, 0x00, 0x00,
  0x9F, 0xF6, 0x00, 0x00, 0x00, 0x00,
  0x9F, 0xF6, 0x00, 0x00, 0x00, 0x00,
  0x9F, 0xF6, 0x00, 0x00, 0x00, 0x00,
  0x5F, 0xF3, 0x00, 0x00, 0x00, 0x00,
  0x03, 0x20, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0047[105] = { /* code 0047, LATIN CAPITAL LETTER G */
  0x00, 0x00, 0x03, 0x43, 0x10, 0x00, 0x00,
  0x00, 0x2A, 0xFF, 0xFF, 0xFA, 0x20, 0x00,
  0x03, 0xEF, 0xFF, 0xFF, 0xFF, 0xE2, 0x00,
  0x1E, 0xFF, 0xB4, 0x23, 0xAF, 0xFA, 0x00,
  0x8F, 0xFB, 0x00, 0x00, 0x0B, 0xF8, 0x00,
  0xCF, 0xF3, 0x00, 0x00, 0x00, 0x20, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xD0, 0x00, 0x5D, 0xDD, 0xDD, 0x30,
  0xFF, 0xE0, 0x00, 0x8F, 0xFF, 0xFF, 0x60,
  0xDF, 0xF2, 0x00, 0x15, 0x69, 0xFF, 0x60,
  0x9F, 0xF9, 0x00, 0x00, 0x0B, 0xFF, 0x60,
  0x2F, 0xFF, 0x82, 0x02, 0x9F, 0xFF, 0x60,
  0x06, 0xFF, 0xFF, 0xFF, 0xFE, 0xEF, 0x60,
  0x00, 0x4C, 0xFF, 0xFF, 0xD3, 0x9F, 0x50,
  0x00, 0x00, 0x24, 0x43, 0x00, 0x03, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0048[ 90] = { /* code 0048, LATIN CAPITAL LETTER H */
  0x02, 0x10, 0x00, 0x00, 0x01, 0x20,
  0x6F, 0xE2, 0x00, 0x00, 0x2E, 0xF6,
  0x9F, 0xF5, 0x00, 0x00, 0x5F, 0xF9,
  0x9F, 0xF6, 0x00, 0x00, 0x6F, 0xF9,
  0x9F, 0xF6, 0x00, 0x00, 0x6F, 0xF9,
  0x9F, 0xF6, 0x00, 0x00, 0x6F, 0xF9,
  0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF9,
  0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF9,
  0x9F, 0xFA, 0x77, 0x77, 0xAF, 0xF9,
  0x9F, 0xF6, 0x00, 0x00, 0x6F, 0xF9,
  0x9F, 0xF6, 0x00, 0x00, 0x6F, 0xF9,
  0x9F, 0xF6, 0x00, 0x00, 0x6F, 0xF9,
  0x9F, 0xF5, 0x00, 0x00, 0x5F, 0xF9,
  0x6F, 0xE2, 0x00, 0x00, 0x2E, 0xF7,
  0x03, 0x20, 0x00, 0x00, 0x02, 0x30
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0049[ 30] = { /* code 0049, LATIN CAPITAL LETTER I */
  0x02, 0x10,
  0x6F, 0xE2,
  0x9F, 0xF5,
  0x9F, 0xF6,
  0x9F, 0xF6,
  0x9F, 0xF6,
  0x9F, 0xF6,
  0x9F, 0xF6,
  0x9F, 0xF6,
  0x9F, 0xF6,
  0x9F, 0xF6,
  0x9F, 0xF6,
  0x9F, 0xF5,
  0x6F, 0xE2,
  0x03, 0x20
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_004A[ 75] = { /* code 004A, LATIN CAPITAL LETTER J */
  0x00, 0x00, 0x00, 0x02, 0x00,
  0x00, 0x00, 0x00, 0xBF, 0xB0,
  0x00, 0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0x00, 0xFF, 0xF0,
  0x01, 0x00, 0x00, 0xFF, 0xF0,
  0x5F, 0xC0, 0x00, 0xFF, 0xF0,
  0x9F, 0xF1, 0x00, 0xFF, 0xE0,
  0x9F, 0xF6, 0x07, 0xFF, 0xB0,
  0x3F, 0xFF, 0xFF, 0xFF, 0x50,
  0x05, 0xEF, 0xFF, 0xF7, 0x00,
  0x00, 0x03, 0x43, 0x10, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_004B[ 90] = { /* code 004B, LATIN CAPITAL LETTER K */
  0x02, 0x10, 0x00, 0x00, 0x11, 0x00,
  0x6F, 0xE2, 0x00, 0x02, 0xEF, 0x50,
  0x9F, 0xF5, 0x00, 0x1D, 0xFF, 0x60,
  0x9F, 0xF6, 0x01, 0xDF, 0xF8, 0x00,
  0x9F, 0xF6, 0x1B, 0xFF, 0x90, 0x00,
  0x9F, 0xF6, 0xAF, 0xFA, 0x00, 0x00,
  0x9F, 0xFE, 0xFF, 0xF4, 0x00, 0x00,
  0x9F, 0xFF, 0xFF, 0xFD, 0x00, 0x00,
  0x9F, 0xFF, 0xAD, 0xFF, 0x80, 0x00,
  0x9F, 0xFA, 0x03, 0xFF, 0xF3, 0x00,
  0x9F, 0xF6, 0x00, 0x9F, 0xFD, 0x00,
  0x9F, 0xF6, 0x00, 0x1D, 0xFF, 0x70,
  0x9F, 0xF5, 0x00, 0x04, 0xFF, 0xF1,
  0x6F, 0xE2, 0x00, 0x00, 0x9F, 0xE1,
  0x03, 0x20, 0x00, 0x00, 0x03, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_004C[ 70] = { /* code 004C, LATIN CAPITAL LETTER L */
  0x02, 0x10, 0x00, 0x00, 0x00,
  0x6F, 0xE2, 0x00, 0x00, 0x00,
  0x9F, 0xF5, 0x00, 0x00, 0x00,
  0x9F, 0xF6, 0x00, 0x00, 0x00,
  0x9F, 0xF6, 0x00, 0x00, 0x00,
  0x9F, 0xF6, 0x00, 0x00, 0x00,
  0x9F, 0xF6, 0x00, 0x00, 0x00,
  0x9F, 0xF6, 0x00, 0x00, 0x00,
  0x9F, 0xF6, 0x00, 0x00, 0x00,
  0x9F, 0xF6, 0x00, 0x00, 0x00,
  0x9F, 0xF6, 0x00, 0x00, 0x00,
  0x9F, 0xFA, 0x77, 0x77, 0x72,
  0x9F, 0xFF, 0xFF, 0xFF, 0xFB,
  0x4E, 0xFF, 0xFF, 0xFF, 0xF7
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_004D[105] = { /* code 004D, LATIN CAPITAL LETTER M */
  0x02, 0x31, 0x00, 0x00, 0x00, 0x13, 0x20,
  0x7F, 0xFE, 0x30, 0x00, 0x02, 0xEF, 0xF7,
  0xBF, 0xFF, 0x80, 0x00, 0x08, 0xFF, 0xF9,
  0xBF, 0xFF, 0xD0, 0x00, 0x0C, 0xFF, 0xF9,
  0xBF, 0xFF, 0xF2, 0x00, 0x2F, 0xFF, 0xF9,
  0xBF, 0xFB, 0xF7, 0x00, 0x7F, 0xBF, 0xF9,
  0xBF, 0xF7, 0xFC, 0x00, 0xBF, 0x7F, 0xF9,
  0xBF, 0xF2, 0xFF, 0x21, 0xFF, 0x2F, 0xF9,
  0xBF, 0xF0, 0xCF, 0x65, 0xFC, 0x0F, 0xF9,
  0xBF, 0xF0, 0x8F, 0xBA, 0xF7, 0x0F, 0xF9,
  0xBF, 0xF0, 0x3F, 0xFE, 0xF3, 0x0F, 0xF9,
  0xBF, 0xF0, 0x0D, 0xFF, 0xD0, 0x0F, 0xF9,
  0xBF, 0xF0, 0x08, 0xFF, 0x80, 0x0F, 0xF9,
  0x8F, 0xB0, 0x03, 0xFF, 0x30, 0x0B, 0xF7,
  0x03, 0x10, 0x00, 0x22, 0x00, 0x01, 0x30
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_004E[ 90] = { /* code 004E, LATIN CAPITAL LETTER N */
  0x01, 0x20, 0x00, 0x00, 0x01, 0x20,
  0x6F, 0xF8, 0x00, 0x00, 0x1E, 0xF8,
  0xAF, 0xFF, 0x30, 0x00, 0x2F, 0xFB,
  0xBF, 0xFF, 0xC0, 0x00, 0x2F, 0xFB,
  0xBF, 0xFF, 0xF7, 0x00, 0x2F, 0xFB,
  0xBF, 0xFC, 0xFE, 0x20, 0x2F, 0xFB,
  0xBF, 0xF4, 0xEF, 0xB0, 0x2F, 0xFB,
  0xBF, 0xF2, 0x7F, 0xF5, 0x2F, 0xFB,
  0xBF, 0xF2, 0x0C, 0xFD, 0x3F, 0xFB,
  0xBF, 0xF2, 0x03, 0xFF, 0xAF, 0xFB,
  0xBF, 0xF2, 0x00, 0x8F, 0xFF, 0xFB,
  0xBF, 0xF2, 0x00, 0x0D, 0xFF, 0xFB,
  0xBF, 0xF2, 0x00, 0x04, 0xFF, 0xFA,
  0x8F, 0xE1, 0x00, 0x00, 0x9F, 0xF6,
  0x03, 0x10, 0x00, 0x00, 0x03, 0x30
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_004F[105] = { /* code 004F, LATIN CAPITAL LETTER O */
  0x00, 0x00, 0x01, 0x34, 0x30, 0x00, 0x00,
  0x00, 0x03, 0xBF, 0xFF, 0xFE, 0x91, 0x00,
  0x00, 0x6F, 0xFF, 0xFF, 0xFF, 0xFE, 0x20,
  0x03, 0xFF, 0xF9, 0x32, 0x4B, 0xFF, 0xD0,
  0x0B, 0xFF, 0x80, 0x00, 0x00, 0xCF, 0xF6,
  0x0F, 0xFF, 0x10, 0x00, 0x00, 0x5F, 0xFA,
  0x2F, 0xFC, 0x00, 0x00, 0x00, 0x2F, 0xFD,
  0x4F, 0xFB, 0x00, 0x00, 0x00, 0x2F, 0xFD,
  0x2F, 0xFC, 0x00, 0x00, 0x00, 0x2F, 0xFC,
  0x0F, 0xFF, 0x10, 0x00, 0x00, 0x5F, 0xF9,
  0x0A, 0xFF, 0x70, 0x00, 0x00, 0xCF, 0xF4,
  0x03, 0xFF, 0xF8, 0x22, 0x3B, 0xFF, 0xC0,
  0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xFD, 0x20,
  0x00, 0x05, 0xDF, 0xFF, 0xFF, 0x91, 0x00,
  0x00, 0x00, 0x02, 0x44, 0x31, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0050[ 84] = { /* code 0050, LATIN CAPITAL LETTER P */
  0x3D, 0xFF, 0xFF, 0xFD, 0xA3, 0x00,
  0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0x40,
  0x9F, 0xF9, 0x66, 0x6B, 0xFF, 0xC0,
  0x9F, 0xF6, 0x00, 0x00, 0xEF, 0xF1,
  0x9F, 0xF6, 0x00, 0x00, 0xEF, 0xF1,
  0x9F, 0xF6, 0x00, 0x18, 0xFF, 0xD0,
  0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0x60,
  0x9F, 0xFF, 0xFF, 0xFF, 0xE6, 0x00,
  0x9F, 0xF8, 0x44, 0x43, 0x00, 0x00,
  0x9F, 0xF6, 0x00, 0x00, 0x00, 0x00,
  0x9F, 0xF6, 0x00, 0x00, 0x00, 0x00,
  0x9F, 0xF5, 0x00, 0x00, 0x00, 0x00,
  0x6F, 0xE2, 0x00, 0x00, 0x00, 0x00,
  0x03, 0x20, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0051[105] = { /* code 0051, LATIN CAPITAL LETTER Q */
  0x00, 0x00, 0x01, 0x34, 0x30, 0x00, 0x00,
  0x00, 0x03, 0xBF, 0xFF, 0xFE, 0x91, 0x00,
  0x00, 0x6F, 0xFF, 0xFF, 0xFF, 0xFE, 0x20,
  0x03, 0xFF, 0xF9, 0x32, 0x4B, 0xFF, 0xD0,
  0x0B, 0xFF, 0x80, 0x00, 0x00, 0xCF, 0xF6,
  0x0F, 0xFF, 0x10, 0x00, 0x00, 0x5F, 0xFA,
  0x2F, 0xFC, 0x00, 0x00, 0x00, 0x2F, 0xFD,
  0x4F, 0xFB, 0x00, 0x00, 0x00, 0x2F, 0xFD,
  0x2F, 0xFC, 0x00, 0x00, 0x00, 0x2F, 0xFC,
  0x0F, 0xFF, 0x10, 0x04, 0xB2, 0x5F, 0xF9,
  0x0A, 0xFF, 0x70, 0x09, 0xFE, 0xCF, 0xF4,
  0x03, 0xFF, 0xF8, 0x23, 0xCF, 0xFF, 0xC0,
  0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0x60,
  0x00, 0x05, 0xDF, 0xFF, 0xFF, 0xBF, 0xF4,
  0x00, 0x00, 0x02, 0x44, 0x30, 0x08, 0xF4
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0052[ 84] = { /* code 0052, LATIN CAPITAL LETTER R */
  0x3D, 0xFF, 0xFF, 0xFE, 0xC7, 0x10,
  0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xB0,
  0x9F, 0xF9, 0x66, 0x67, 0xEF, 0xF4,
  0x9F, 0xF6, 0x00, 0x00, 0x9F, 0xF7,
  0x9F, 0xF6, 0x00, 0x00, 0x8F, 0xF5,
  0x9F, 0xF8, 0x44, 0x46, 0xEF, 0xD0,
  0x9F, 0xFF, 0xFF, 0xFF, 0xFC, 0x20,
  0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0x70,
  0x9F, 0xF6, 0x00, 0x06, 0xFF, 0xE0,
  0x9F, 0xF6, 0x00, 0x00, 0xDF, 0xF0,
  0x9F, 0xF6, 0x00, 0x00, 0xBF, 0xF1,
  0x9F, 0xF5, 0x00, 0x00, 0xBF, 0xF5,
  0x6F, 0xE2, 0x00, 0x00, 0x5F, 0xF4,
  0x03, 0x20, 0x00, 0x00, 0x03, 0x20
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0053[ 90] = { /* code 0053, LATIN CAPITAL LETTER S */
  0x00, 0x00, 0x24, 0x41, 0x00, 0x00,
  0x00, 0x5D, 0xFF, 0xFF, 0xC4, 0x00,
  0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0x70,
  0x0E, 0xFE, 0x40, 0x16, 0xEF, 0xF0,
  0x2F, 0xFA, 0x00, 0x00, 0x4D, 0x90,
  0x1F, 0xFF, 0x72, 0x00, 0x00, 0x00,
  0x0B, 0xFF, 0xFF, 0xDA, 0x61, 0x00,
  0x01, 0xAF, 0xFF, 0xFF, 0xFE, 0x50,
  0x00, 0x01, 0x69, 0xDF, 0xFF, 0xF2,
  0x01, 0x10, 0x00, 0x02, 0xCF, 0xF7,
  0x2E, 0xF4, 0x00, 0x00, 0x6F, 0xF7,
  0x2F, 0xFE, 0x40, 0x02, 0xDF, 0xF5,
  0x09, 0xFF, 0xFE, 0xDF, 0xFF, 0xC0,
  0x00, 0x6D, 0xFF, 0xFF, 0xF9, 0x10,
  0x00, 0x00, 0x34, 0x43, 0x10, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0054[ 84] = { /* code 0054, LATIN CAPITAL LETTER T */
  0x6E, 0xFF, 0xFF, 0xFF, 0xFF, 0xE7,
  0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB,
  0x27, 0x77, 0xBF, 0xFB, 0x77, 0x72,
  0x00, 0x00, 0x7F, 0xF7, 0x00, 0x00,
  0x00, 0x00, 0x7F, 0xF7, 0x00, 0x00,
  0x00, 0x00, 0x7F, 0xF7, 0x00, 0x00,
  0x00, 0x00, 0x7F, 0xF7, 0x00, 0x00,
  0x00, 0x00, 0x7F, 0xF7, 0x00, 0x00,
  0x00, 0x00, 0x7F, 0xF7, 0x00, 0x00,
  0x00, 0x00, 0x7F, 0xF7, 0x00, 0x00,
  0x00, 0x00, 0x7F, 0xF7, 0x00, 0x00,
  0x00, 0x00, 0x7F, 0xF7, 0x00, 0x00,
  0x00, 0x00, 0x4F, 0xF4, 0x00, 0x00,
  0x00, 0x00, 0x02, 0x20, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0055[ 90] = { /* code 0055, LATIN CAPITAL LETTER U */
  0x02, 0x10, 0x00, 0x00, 0x01, 0x20,
  0x6F, 0xE2, 0x00, 0x00, 0x2E, 0xF6,
  0x9F, 0xF5, 0x00, 0x00, 0x5F, 0xF9,
  0x9F, 0xF6, 0x00, 0x00, 0x6F, 0xF9,
  0x9F, 0xF6, 0x00, 0x00, 0x6F, 0xF9,
  0x9F, 0xF6, 0x00, 0x00, 0x6F, 0xF9,
  0x9F, 0xF6, 0x00, 0x00, 0x6F, 0xF9,
  0x9F, 0xF6, 0x00, 0x00, 0x6F, 0xF9,
  0x9F, 0xF6, 0x00, 0x00, 0x6F, 0xF9,
  0x9F, 0xF6, 0x00, 0x00, 0x6F, 0xF9,
  0x7F, 0xF7, 0x00, 0x00, 0x7F, 0xF8,
  0x3F, 0xFE, 0x62, 0x26, 0xEF, 0xF3,
  0x0A, 0xFF, 0xFF, 0xFF, 0xFF, 0xA0,
  0x00, 0x7E, 0xFF, 0xFF, 0xE7, 0x00,
  0x00, 0x00, 0x34, 0x43, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0056[ 90] = { /* code 0056, LATIN CAPITAL LETTER V */
  0x02, 0x00, 0x00, 0x00, 0x01, 0x10,
  0xAF, 0xC0, 0x00, 0x00, 0x2E, 0xF5,
  0xCF, 0xF4, 0x00, 0x00, 0x7F, 0xF7,
  0x7F, 0xF9, 0x00, 0x00, 0xCF, 0xF2,
  0x2F, 0xFD, 0x00, 0x02, 0xFF, 0xB0,
  0x0B, 0xFF, 0x30, 0x07, 0xFF, 0x60,
  0x06, 0xFF, 0x70, 0x0B, 0xFF, 0x10,
  0x01, 0xFF, 0xB0, 0x1F, 0xFA, 0x00,
  0x00, 0xAF, 0xF1, 0x6F, 0xF5, 0x00,
  0x00, 0x5F, 0xF6, 0xBF, 0xE0, 0x00,
  0x00, 0x0E, 0xFB, 0xFF, 0x80, 0x00,
  0x00, 0x09, 0xFF, 0xFF, 0x30, 0x00,
  0x00, 0x04, 0xFF, 0xFD, 0x00, 0x00,
  0x00, 0x00, 0xCF, 0xF6, 0x00, 0x00,
  0x00, 0x00, 0x03, 0x20, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0057[135] = { /* code 0057, LATIN CAPITAL LETTER W */
  0x02, 0x00, 0x00, 0x01, 0x20, 0x00, 0x00, 0x11, 0x00,
  0xAF, 0xC0, 0x00, 0x2E, 0xFB, 0x00, 0x01, 0xEF, 0x50,
  0xCF, 0xF1, 0x00, 0x6F, 0xFF, 0x10, 0x05, 0xFF, 0x70,
  0x8F, 0xF4, 0x00, 0x9F, 0xFF, 0x40, 0x08, 0xFF, 0x30,
  0x4F, 0xF7, 0x00, 0xCF, 0xFF, 0x80, 0x0B, 0xFE, 0x00,
  0x1F, 0xFA, 0x01, 0xFF, 0xAF, 0xB0, 0x0E, 0xFB, 0x00,
  0x0C, 0xFD, 0x05, 0xFE, 0x4F, 0xF0, 0x3F, 0xF7, 0x00,
  0x08, 0xFF, 0x18, 0xFA, 0x0F, 0xF3, 0x6F, 0xF3, 0x00,
  0x04, 0xFF, 0x4B, 0xF7, 0x0B, 0xF7, 0x9F, 0xE0, 0x00,
  0x00, 0xFF, 0x8F, 0xF3, 0x08, 0xFA, 0xCF, 0xA0, 0x00,
  0x00, 0xBF, 0xDF, 0xE0, 0x04, 0xFE, 0xFF, 0x70, 0x00,
  0x00, 0x7F, 0xFF, 0xA0, 0x01, 0xFF, 0xFF, 0x20, 0x00,
  0x00, 0x4F, 0xFF, 0x70, 0x00, 0xCF, 0xFE, 0x00, 0x00,
  0x00, 0x0C, 0xFE, 0x20, 0x00, 0x6F, 0xF8, 0x00, 0x00,
  0x00, 0x01, 0x41, 0x00, 0x00, 0x03, 0x30, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0058[ 90] = { /* code 0058, LATIN CAPITAL LETTER X */
  0x01, 0x10, 0x00, 0x00, 0x11, 0x00,
  0x3F, 0xF3, 0x00, 0x04, 0xFF, 0x20,
  0x5F, 0xFC, 0x00, 0x0D, 0xFF, 0x30,
  0x0D, 0xFF, 0x60, 0x8F, 0xFA, 0x00,
  0x03, 0xFF, 0xE3, 0xFF, 0xD1, 0x00,
  0x00, 0x8F, 0xFF, 0xFF, 0x40, 0x00,
  0x00, 0x0D, 0xFF, 0xF9, 0x00, 0x00,
  0x00, 0x07, 0xFF, 0xF3, 0x00, 0x00,
  0x00, 0x2F, 0xFF, 0xFC, 0x00, 0x00,
  0x00, 0xCF, 0xFD, 0xFF, 0x70, 0x00,
  0x07, 0xFF, 0xB2, 0xFF, 0xF3, 0x00,
  0x3F, 0xFF, 0x20, 0x8F, 0xFC, 0x00,
  0xAF, 0xF7, 0x00, 0x0D, 0xFF, 0x60,
  0xAF, 0xC0, 0x00, 0x05, 0xFF, 0x40,
  0x03, 0x10, 0x00, 0x00, 0x32, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0059[ 90] = { /* code 0059, LATIN CAPITAL LETTER Y */
  0x02, 0x10, 0x00, 0x00, 0x02, 0x00,
  0x9F, 0xC0, 0x00, 0x00, 0xBF, 0x90,
  0xBF, 0xF7, 0x00, 0x05, 0xFF, 0xC0,
  0x4F, 0xFE, 0x10, 0x0D, 0xFF, 0x40,
  0x0A, 0xFF, 0x80, 0x6F, 0xFA, 0x00,
  0x01, 0xEF, 0xF2, 0xEF, 0xE2, 0x00,
  0x00, 0x7F, 0xFE, 0xFF, 0x70, 0x00,
  0x00, 0x0C, 0xFF, 0xFD, 0x00, 0x00,
  0x00, 0x03, 0xFF, 0xF4, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0xCF, 0xC0, 0x00, 0x00,
  0x00, 0x00, 0x03, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_005A[ 78] = { /* code 005A, LATIN CAPITAL LETTER Z */
  0x09, 0xFF, 0xFF, 0xFF, 0xFF, 0xE6,
  0x0E, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA,
  0x03, 0x77, 0x77, 0x7B, 0xFF, 0xF4,
  0x00, 0x00, 0x00, 0x3E, 0xFF, 0x60,
  0x00, 0x00, 0x01, 0xDF, 0xF8, 0x00,
  0x00, 0x00, 0x0C, 0xFF, 0xB0, 0x00,
  0x00, 0x00, 0xAF, 0xFC, 0x10, 0x00,
  0x00, 0x07, 0xFF, 0xE2, 0x00, 0x00,
  0x00, 0x5F, 0xFF, 0x30, 0x00, 0x00,
  0x03, 0xFF, 0xF5, 0x00, 0x00, 0x00,
  0x2E, 0xFF, 0xD7, 0x77, 0x77, 0x72,
  0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB,
  0x3D, 0xFF, 0xFF, 0xFF, 0xFF, 0xF7
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_005B[ 51] = { /* code 005B, LEFT SQUARE BRACKET */
  0x3D, 0xFF, 0xE2,
  0x7F, 0xFF, 0xE2,
  0x7F, 0xF0, 0x00,
  0x7F, 0xF0, 0x00,
  0x7F, 0xF0, 0x00,
  0x7F, 0xF0, 0x00,
  0x7F, 0xF0, 0x00,
  0x7F, 0xF0, 0x00,
  0x7F, 0xF0, 0x00,
  0x7F, 0xF0, 0x00,
  0x7F, 0xF0, 0x00,
  0x7F, 0xF0, 0x00,
  0x7F, 0xF0, 0x00,
  0x7F, 0xF0, 0x00,
  0x7F, 0xF9, 0x91,
  0x4F, 0xFF, 0xF3,
  0x03, 0x66, 0x40
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_005C[ 60] = { /* code 005C, REVERSE SOLIDUS */
  0x12, 0x00, 0x00, 0x00,
  0xCF, 0x10, 0x00, 0x00,
  0x9F, 0x70, 0x00, 0x00,
  0x4F, 0xC0, 0x00, 0x00,
  0x0D, 0xF3, 0x00, 0x00,
  0x07, 0xF9, 0x00, 0x00,
  0x02, 0xFE, 0x00, 0x00,
  0x00, 0xBF, 0x50, 0x00,
  0x00, 0x5F, 0xB0, 0x00,
  0x00, 0x0E, 0xF2, 0x00,
  0x00, 0x09, 0xF7, 0x00,
  0x00, 0x03, 0xFD, 0x00,
  0x00, 0x00, 0xCF, 0x40,
  0x00, 0x00, 0x6F, 0x70,
  0x00, 0x00, 0x04, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_005D[ 51] = { /* code 005D, RIGHT SQUARE BRACKET */
  0xBF, 0xFE, 0x60,
  0xCF, 0xFF, 0xB0,
  0x00, 0x9F, 0xB0,
  0x00, 0x9F, 0xB0,
  0x00, 0x9F, 0xB0,
  0x00, 0x9F, 0xB0,
  0x00, 0x9F, 0xB0,
  0x00, 0x9F, 0xB0,
  0x00, 0x9F, 0xB0,
  0x00, 0x9F, 0xB0,
  0x00, 0x9F, 0xB0,
  0x00, 0x9F, 0xB0,
  0x00, 0x9F, 0xB0,
  0x00, 0x9F, 0xB0,
  0x79, 0xDF, 0xB0,
  0xEF, 0xFF, 0x90,
  0x25, 0x64, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_005E[ 40] = { /* code 005E, CIRCUMFLEX ACCENT */
  0x00, 0x03, 0x72, 0x00, 0x00,
  0x00, 0x0E, 0xFB, 0x00, 0x00,
  0x00, 0x7F, 0xFF, 0x50, 0x00,
  0x01, 0xEF, 0xAF, 0xD0, 0x00,
  0x09, 0xFB, 0x0D, 0xF6, 0x00,
  0x2F, 0xF3, 0x06, 0xFE, 0x10,
  0xAF, 0x90, 0x00, 0xCF, 0x70,
  0x69, 0x10, 0x00, 0x39, 0x50
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_005F[ 12] = { /* code 005F, LOW LINE */
  0x49, 0x99, 0x99, 0x99, 0x99, 0x40,
  0x14, 0x44, 0x44, 0x44, 0x44, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0060[  8] = { /* code 0060, GRAVE ACCENT */
  0x78, 0x00,
  0xEF, 0xC2,
  0x3C, 0xFE,
  0x00, 0x78
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0061[ 55] = { /* code 0061, LATIN SMALL LETTER A */
  0x00, 0x05, 0x99, 0x96, 0x10,
  0x02, 0xDF, 0xFF, 0xFF, 0xE3,
  0x09, 0xFE, 0x74, 0x8F, 0xFB,
  0x04, 0xB3, 0x00, 0x0E, 0xFB,
  0x00, 0x15, 0x79, 0xCF, 0xFB,
  0x06, 0xFF, 0xFF, 0xDE, 0xFB,
  0x2F, 0xFC, 0x41, 0x0D, 0xFB,
  0x4F, 0xF6, 0x00, 0x3F, 0xFB,
  0x2F, 0xFE, 0x89, 0xEE, 0xFD,
  0x05, 0xEF, 0xFE, 0x67, 0xFE,
  0x00, 0x13, 0x30, 0x00, 0x31
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0062[ 75] = { /* code 0062, LATIN SMALL LETTER B */
  0x02, 0x00, 0x00, 0x00, 0x00,
  0xCF, 0x80, 0x00, 0x00, 0x00,
  0xFF, 0x90, 0x00, 0x00, 0x00,
  0xFF, 0x90, 0x00, 0x00, 0x00,
  0xFF, 0x92, 0x89, 0x71, 0x00,
  0xFF, 0xCE, 0xFF, 0xFE, 0x20,
  0xFF, 0xFB, 0x69, 0xFF, 0xB0,
  0xFF, 0xE0, 0x00, 0xAF, 0xF2,
  0xFF, 0x90, 0x00, 0x5F, 0xF4,
  0xFF, 0x80, 0x00, 0x4F, 0xF6,
  0xFF, 0xB0, 0x00, 0x7F, 0xF3,
  0xFF, 0xF3, 0x02, 0xDF, 0xE0,
  0xFF, 0xEF, 0xDF, 0xFF, 0x70,
  0xDF, 0x6C, 0xFF, 0xF7, 0x00,
  0x13, 0x00, 0x33, 0x10, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0063[ 55] = { /* code 0063, LATIN SMALL LETTER C */
  0x00, 0x05, 0x99, 0x83, 0x00,
  0x01, 0xCF, 0xFF, 0xFF, 0xA0,
  0x0B, 0xFF, 0xA6, 0xBF, 0xF3,
  0x3F, 0xF9, 0x00, 0x0B, 0xD2,
  0x6F, 0xF4, 0x00, 0x00, 0x00,
  0x7F, 0xF2, 0x00, 0x00, 0x00,
  0x5F, 0xF4, 0x00, 0x04, 0x70,
  0x2F, 0xFC, 0x10, 0x3F, 0xF4,
  0x09, 0xFF, 0xED, 0xFF, 0xE1,
  0x00, 0x8E, 0xFF, 0xFC, 0x30,
  0x00, 0x00, 0x34, 0x20, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0064[ 75] = { /* code 0064, LATIN SMALL LETTER D */
  0x00, 0x00, 0x00, 0x00, 0x20,
  0x00, 0x00, 0x00, 0x08, 0xFC,
  0x00, 0x00, 0x00, 0x09, 0xFF,
  0x00, 0x00, 0x00, 0x09, 0xFF,
  0x00, 0x17, 0x98, 0x29, 0xFF,
  0x02, 0xEF, 0xFF, 0xEC, 0xFF,
  0x0B, 0xFF, 0x96, 0xBF, 0xFF,
  0x2F, 0xFA, 0x00, 0x0E, 0xFF,
  0x5F, 0xF5, 0x00, 0x09, 0xFF,
  0x6F, 0xF4, 0x00, 0x08, 0xFF,
  0x4F, 0xF7, 0x00, 0x0B, 0xFF,
  0x1E, 0xFD, 0x20, 0x3F, 0xFF,
  0x07, 0xFF, 0xFD, 0xFE, 0xFF,
  0x00, 0x7F, 0xFF, 0xC6, 0xFD,
  0x00, 0x01, 0x32, 0x00, 0x31
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0065[ 66] = { /* code 0065, LATIN SMALL LETTER E */
  0x00, 0x03, 0x89, 0x95, 0x00, 0x00,
  0x00, 0xAF, 0xFF, 0xFF, 0xC1, 0x00,
  0x09, 0xFF, 0x74, 0x6E, 0xFB, 0x00,
  0x1F, 0xF8, 0x00, 0x05, 0xFF, 0x30,
  0x4F, 0xFC, 0xBB, 0xBC, 0xFF, 0x60,
  0x6F, 0xFC, 0xBB, 0xBB, 0xBB, 0x30,
  0x4F, 0xF6, 0x00, 0x00, 0x10, 0x00,
  0x0E, 0xFD, 0x20, 0x06, 0xFA, 0x00,
  0x05, 0xFF, 0xFD, 0xEF, 0xFA, 0x00,
  0x00, 0x5D, 0xFF, 0xFE, 0x91, 0x00,
  0x00, 0x00, 0x24, 0x30, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0066[ 60] = { /* code 0066, LATIN SMALL LETTER F */
  0x00, 0x01, 0x42, 0x00,
  0x00, 0x6F, 0xFF, 0x50,
  0x01, 0xFF, 0xFD, 0x40,
  0x02, 0xFF, 0x80, 0x00,
  0x37, 0xFF, 0xA6, 0x10,
  0xBF, 0xFF, 0xFF, 0x70,
  0x26, 0xFF, 0xA4, 0x10,
  0x02, 0xFF, 0x70, 0x00,
  0x02, 0xFF, 0x70, 0x00,
  0x02, 0xFF, 0x70, 0x00,
  0x02, 0xFF, 0x70, 0x00,
  0x02, 0xFF, 0x70, 0x00,
  0x02, 0xFF, 0x70, 0x00,
  0x01, 0xEF, 0x60, 0x00,
  0x00, 0x13, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0067[ 70] = { /* code 0067, LATIN SMALL LETTER G */
  0x00, 0x16, 0x98, 0x31, 0x96,
  0x02, 0xDF, 0xFF, 0xFA, 0xFE,
  0x0B, 0xFF, 0xA6, 0xBF, 0xFF,
  0x2F, 0xF9, 0x00, 0x0C, 0xFF,
  0x5F, 0xF5, 0x00, 0x09, 0xFF,
  0x6F, 0xF4, 0x00, 0x09, 0xFF,
  0x3F, 0xF8, 0x00, 0x0C, 0xFF,
  0x0E, 0xFF, 0x64, 0x8F, 0xFF,
  0x04, 0xFF, 0xFF, 0xFE, 0xFF,
  0x00, 0x38, 0xBA, 0x49, 0xFF,
  0x01, 0x61, 0x00, 0x0B, 0xFC,
  0x09, 0xFD, 0x32, 0x6F, 0xF7,
  0x05, 0xFF, 0xFF, 0xFF, 0xB1,
  0x00, 0x39, 0xCD, 0xB7, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0068[ 75] = { /* code 0068, LATIN SMALL LETTER H */
  0x02, 0x00, 0x00, 0x00, 0x00,
  0xCF, 0x80, 0x00, 0x00, 0x00,
  0xFF, 0x90, 0x00, 0x00, 0x00,
  0xFF, 0x90, 0x00, 0x00, 0x00,
  0xFF, 0x91, 0x79, 0x83, 0x00,
  0xFF, 0xBE, 0xFF, 0xFF, 0x40,
  0xFF, 0xFD, 0x8B, 0xFF, 0xB0,
  0xFF, 0xE1, 0x00, 0xDF, 0xE0,
  0xFF, 0xA0, 0x00, 0x9F, 0xF0,
  0xFF, 0x90, 0x00, 0x9F, 0xF0,
  0xFF, 0x90, 0x00, 0x9F, 0xF0,
  0xFF, 0x90, 0x00, 0x9F, 0xF0,
  0xFF, 0x90, 0x00, 0x9F, 0xF0,
  0xCF, 0x80, 0x00, 0x8F, 0xC0,
  0x13, 0x00, 0x00, 0x03, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0069[ 30] = { /* code 0069, LATIN SMALL LETTER I */
  0x04, 0x00,
  0xAF, 0xB0,
  0xCF, 0xC0,
  0x27, 0x20,
  0x49, 0x40,
  0xCF, 0xC0,
  0xDF, 0xD0,
  0xDF, 0xD0,
  0xDF, 0xD0,
  0xDF, 0xD0,
  0xDF, 0xD0,
  0xDF, 0xD0,
  0xDF, 0xD0,
  0xAF, 0xA0,
  0x04, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_006A[ 54] = { /* code 006A, LATIN SMALL LETTER J */
  0x00, 0x04, 0x00,
  0x00, 0xAF, 0xB0,
  0x00, 0xCF, 0xC0,
  0x00, 0x27, 0x20,
  0x00, 0x49, 0x40,
  0x00, 0xCF, 0xC0,
  0x00, 0xDF, 0xD0,
  0x00, 0xDF, 0xD0,
  0x00, 0xDF, 0xD0,
  0x00, 0xDF, 0xD0,
  0x00, 0xDF, 0xD0,
  0x00, 0xDF, 0xD0,
  0x00, 0xDF, 0xD0,
  0x00, 0xDF, 0xD0,
  0x00, 0xDF, 0xD0,
  0x05, 0xEF, 0xB0,
  0x4F, 0xFF, 0x80,
  0x1A, 0xB7, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_006B[ 75] = { /* code 006B, LATIN SMALL LETTER K */
  0x02, 0x00, 0x00, 0x00, 0x00,
  0xCF, 0x80, 0x00, 0x00, 0x00,
  0xFF, 0x90, 0x00, 0x00, 0x00,
  0xFF, 0x90, 0x00, 0x00, 0x00,
  0xFF, 0x90, 0x02, 0x93, 0x00,
  0xFF, 0x90, 0x1D, 0xFC, 0x00,
  0xFF, 0x91, 0xDF, 0xF5, 0x00,
  0xFF, 0xAB, 0xFF, 0x60, 0x00,
  0xFF, 0xFF, 0xFB, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0x40, 0x00,
  0xFF, 0xE6, 0xFF, 0xE2, 0x00,
  0xFF, 0x90, 0x6F, 0xFB, 0x00,
  0xFF, 0x90, 0x0B, 0xFF, 0x60,
  0xCF, 0x80, 0x01, 0xEF, 0x50,
  0x13, 0x00, 0x00, 0x13, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_006C[ 30] = { /* code 006C, LATIN SMALL LETTER L */
  0x02, 0x00,
  0xAF, 0xA0,
  0xDF, 0xD0,
  0xDF, 0xD0,
  0xDF, 0xD0,
  0xDF, 0xD0,
  0xDF, 0xD0,
  0xDF, 0xD0,
  0xDF, 0xD0,
  0xDF, 0xD0,
  0xDF, 0xD0,
  0xDF, 0xD0,
  0xDF, 0xD0,
  0xAF, 0xA0,
  0x03, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_006D[ 88] = { /* code 006D, LATIN SMALL LETTER M */
  0x59, 0x11, 0x79, 0x82, 0x03, 0x89, 0x72, 0x00,
  0xEF, 0x9D, 0xFF, 0xFE, 0x6F, 0xFF, 0xFE, 0x20,
  0xFF, 0xFC, 0x8C, 0xFF, 0xFC, 0x8C, 0xFF, 0x70,
  0xFF, 0xE1, 0x02, 0xFF, 0xD1, 0x02, 0xFF, 0x90,
  0xFF, 0xA0, 0x00, 0xFF, 0xA0, 0x00, 0xFF, 0x90,
  0xFF, 0x90, 0x00, 0xFF, 0x90, 0x00, 0xFF, 0x90,
  0xFF, 0x90, 0x00, 0xFF, 0x90, 0x00, 0xFF, 0x90,
  0xFF, 0x90, 0x00, 0xFF, 0x90, 0x00, 0xFF, 0x90,
  0xFF, 0x90, 0x00, 0xFF, 0x90, 0x00, 0xFF, 0x90,
  0xCF, 0x80, 0x00, 0xDF, 0x80, 0x00, 0xDF, 0x70,
  0x13, 0x00, 0x00, 0x13, 0x00, 0x00, 0x13, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_006E[ 55] = { /* code 006E, LATIN SMALL LETTER N */
  0x59, 0x11, 0x79, 0x83, 0x00,
  0xEF, 0x8E, 0xFF, 0xFF, 0x40,
  0xFF, 0xFD, 0x8B, 0xFF, 0xB0,
  0xFF, 0xE1, 0x00, 0xDF, 0xE0,
  0xFF, 0xA0, 0x00, 0x9F, 0xF0,
  0xFF, 0x90, 0x00, 0x9F, 0xF0,
  0xFF, 0x90, 0x00, 0x9F, 0xF0,
  0xFF, 0x90, 0x00, 0x9F, 0xF0,
  0xFF, 0x90, 0x00, 0x9F, 0xF0,
  0xCF, 0x80, 0x00, 0x8F, 0xC0,
  0x13, 0x00, 0x00, 0x03, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_006F[ 66] = { /* code 006F, LATIN SMALL LETTER O */
  0x00, 0x04, 0x89, 0x84, 0x00, 0x00,
  0x01, 0xBF, 0xFF, 0xFF, 0xB1, 0x00,
  0x0A, 0xFF, 0x95, 0x8F, 0xFA, 0x00,
  0x1F, 0xFA, 0x00, 0x0A, 0xFF, 0x20,
  0x5F, 0xF5, 0x00, 0x05, 0xFF, 0x50,
  0x6F, 0xF4, 0x00, 0x04, 0xFF, 0x60,
  0x4F, 0xF7, 0x00, 0x06, 0xFF, 0x40,
  0x0E, 0xFD, 0x10, 0x1D, 0xFE, 0x10,
  0x07, 0xFF, 0xEB, 0xEF, 0xF7, 0x00,
  0x00, 0x6E, 0xFF, 0xFE, 0x60, 0x00,
  0x00, 0x00, 0x34, 0x30, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0070[ 70] = { /* code 0070, LATIN SMALL LETTER P */
  0x69, 0x13, 0x99, 0x61, 0x00,
  0xEF, 0xAF, 0xFF, 0xFD, 0x20,
  0xFF, 0xFB, 0x6A, 0xFF, 0xB0,
  0xFF, 0xD0, 0x00, 0xAF, 0xF2,
  0xFF, 0x90, 0x00, 0x5F, 0xF4,
  0xFF, 0x80, 0x00, 0x4F, 0xF6,
  0xFF, 0xB0, 0x00, 0x7F, 0xF3,
  0xFF, 0xF3, 0x01, 0xDF, 0xE1,
  0xFF, 0xFF, 0xDE, 0xFF, 0x80,
  0xFF, 0xAB, 0xFF, 0xF9, 0x00,
  0xFF, 0x90, 0x24, 0x10, 0x00,
  0xFF, 0x90, 0x00, 0x00, 0x00,
  0xEF, 0x90, 0x00, 0x00, 0x00,
  0x6B, 0x30, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0071[ 70] = { /* code 0071, LATIN SMALL LETTER Q */
  0x00, 0x16, 0x99, 0x31, 0x96,
  0x02, 0xDF, 0xFF, 0xFA, 0xFE,
  0x0B, 0xFF, 0xA6, 0xBF, 0xFF,
  0x2F, 0xFA, 0x00, 0x0D, 0xFF,
  0x5F, 0xF5, 0x00, 0x09, 0xFF,
  0x6F, 0xF4, 0x00, 0x08, 0xFF,
  0x4F, 0xF7, 0x00, 0x0B, 0xFF,
  0x1F, 0xFD, 0x10, 0x3F, 0xFF,
  0x08, 0xFF, 0xED, 0xFF, 0xFF,
  0x00, 0x9F, 0xFF, 0xBA, 0xFF,
  0x00, 0x01, 0x42, 0x09, 0xFF,
  0x00, 0x00, 0x00, 0x09, 0xFF,
  0x00, 0x00, 0x00, 0x09, 0xFE,
  0x00, 0x00, 0x00, 0x03, 0xB6
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0072[ 44] = { /* code 0072, LATIN SMALL LETTER R */
  0x49, 0x22, 0x97, 0x00,
  0xCF, 0x9E, 0xFF, 0x30,
  0xDF, 0xFF, 0xFB, 0x10,
  0xDF, 0xF5, 0x00, 0x00,
  0xDF, 0xE0, 0x00, 0x00,
  0xDF, 0xD0, 0x00, 0x00,
  0xDF, 0xD0, 0x00, 0x00,
  0xDF, 0xD0, 0x00, 0x00,
  0xDF, 0xD0, 0x00, 0x00,
  0xAF, 0xA0, 0x00, 0x00,
  0x04, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0073[ 55] = { /* code 0073, LATIN SMALL LETTER S */
  0x00, 0x48, 0x99, 0x61, 0x00,
  0x0A, 0xFF, 0xFF, 0xFE, 0x30,
  0x4F, 0xFA, 0x46, 0xEF, 0x80,
  0x6F, 0xF7, 0x00, 0x27, 0x10,
  0x2F, 0xFF, 0xFB, 0x82, 0x00,
  0x04, 0xCF, 0xFF, 0xFF, 0x50,
  0x03, 0x01, 0x59, 0xEF, 0xE0,
  0x4F, 0xC1, 0x00, 0xAF, 0xF0,
  0x3F, 0xFE, 0xAB, 0xFF, 0xA0,
  0x04, 0xCF, 0xFF, 0xF9, 0x10,
  0x00, 0x01, 0x33, 0x10, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0074[ 56] = { /* code 0074, LATIN SMALL LETTER T */
  0x00, 0x33, 0x00, 0x00,
  0x02, 0xFF, 0x40, 0x00,
  0x04, 0xFF, 0x60, 0x00,
  0x38, 0xFF, 0x95, 0x10,
  0xBF, 0xFF, 0xFF, 0x50,
  0x27, 0xFF, 0x94, 0x00,
  0x04, 0xFF, 0x60, 0x00,
  0x04, 0xFF, 0x60, 0x00,
  0x04, 0xFF, 0x60, 0x00,
  0x04, 0xFF, 0x60, 0x00,
  0x04, 0xFF, 0x60, 0x00,
  0x03, 0xFF, 0xEC, 0x30,
  0x00, 0xBF, 0xFF, 0x30,
  0x00, 0x02, 0x41, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0075[ 55] = { /* code 0075, LATIN SMALL LETTER U */
  0x59, 0x30, 0x00, 0x39, 0x50,
  0xEF, 0x90, 0x00, 0x9F, 0xE0,
  0xFF, 0x90, 0x00, 0x9F, 0xF0,
  0xFF, 0x90, 0x00, 0x9F, 0xF0,
  0xFF, 0x90, 0x00, 0x9F, 0xF0,
  0xFF, 0x90, 0x00, 0x9F, 0xF0,
  0xFF, 0xA0, 0x00, 0xBF, 0xF0,
  0xEF, 0xE2, 0x06, 0xFF, 0xF0,
  0x9F, 0xFF, 0xEF, 0xEF, 0xF0,
  0x1C, 0xFF, 0xF9, 0x5F, 0xD0,
  0x00, 0x24, 0x10, 0x03, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0076[ 55] = { /* code 0076, LATIN SMALL LETTER V */
  0x49, 0x20, 0x00, 0x29, 0x40,
  0xDF, 0xB0, 0x00, 0xBF, 0xD0,
  0xAF, 0xF1, 0x01, 0xFF, 0xA0,
  0x5F, 0xF5, 0x05, 0xFF, 0x50,
  0x0E, 0xF9, 0x09, 0xFE, 0x00,
  0x09, 0xFE, 0x0E, 0xF9, 0x00,
  0x03, 0xFF, 0x7F, 0xF3, 0x00,
  0x00, 0xDF, 0xEF, 0xD0, 0x00,
  0x00, 0x8F, 0xFF, 0x80, 0x00,
  0x00, 0x2F, 0xFF, 0x20, 0x00,
  0x00, 0x02, 0x42, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0077[ 77] = { /* code 0077, LATIN SMALL LETTER W */
  0x39, 0x40, 0x01, 0x89, 0x10, 0x04, 0x93,
  0xBF, 0xB0, 0x07, 0xFF, 0x80, 0x0B, 0xFB,
  0x9F, 0xF1, 0x0B, 0xFF, 0xC0, 0x0F, 0xF9,
  0x4F, 0xF4, 0x0E, 0xFF, 0xF1, 0x3F, 0xF4,
  0x0E, 0xF7, 0x2F, 0xCC, 0xF3, 0x7F, 0xE0,
  0x0A, 0xFB, 0x5F, 0x88, 0xF7, 0xAF, 0xA0,
  0x06, 0xFE, 0x9F, 0x44, 0xFA, 0xDF, 0x60,
  0x01, 0xFF, 0xEF, 0x11, 0xFE, 0xFF, 0x10,
  0x00, 0xBF, 0xFC, 0x00, 0xCF, 0xFB, 0x00,
  0x00, 0x6F, 0xF7, 0x00, 0x7F, 0xF6, 0x00,
  0x00, 0x03, 0x30, 0x00, 0x03, 0x30, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0078[ 55] = { /* code 0078, LATIN SMALL LETTER X */
  0x18, 0x70, 0x00, 0x78, 0x00,
  0x7F, 0xF4, 0x05, 0xFF, 0x30,
  0x2F, 0xFD, 0x1E, 0xFD, 0x00,
  0x07, 0xFF, 0xDF, 0xF3, 0x00,
  0x00, 0xCF, 0xFF, 0x80, 0x00,
  0x00, 0x8F, 0xFF, 0x50, 0x00,
  0x04, 0xFF, 0xFF, 0xD1, 0x00,
  0x1D, 0xFE, 0x6F, 0xF9, 0x00,
  0x8F, 0xF5, 0x0B, 0xFF, 0x30,
  0x8F, 0xB0, 0x02, 0xEF, 0x30,
  0x03, 0x00, 0x00, 0x22, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0079[ 70] = { /* code 0079, LATIN SMALL LETTER Y */
  0x39, 0x40, 0x00, 0x39, 0x30,
  0xBF, 0xD0, 0x00, 0xCF, 0xB0,
  0x8F, 0xF2, 0x01, 0xFF, 0x80,
  0x3F, 0xF7, 0x05, 0xFF, 0x30,
  0x0D, 0xFB, 0x09, 0xFD, 0x00,
  0x08, 0xFE, 0x0D, 0xF7, 0x00,
  0x03, 0xFF, 0x6F, 0xF2, 0x00,
  0x00, 0xCF, 0xEF, 0xB0, 0x00,
  0x00, 0x7F, 0xFF, 0x70, 0x00,
  0x00, 0x2F, 0xFF, 0x10, 0x00,
  0x00, 0x0C, 0xFB, 0x00, 0x00,
  0x06, 0x8F, 0xF5, 0x00, 0x00,
  0x1F, 0xFF, 0xC0, 0x00, 0x00,
  0x07, 0xB8, 0x10, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_007A[ 50] = { /* code 007A, LATIN SMALL LETTER Z */
  0x03, 0x66, 0x66, 0x66, 0x50,
  0x0F, 0xFF, 0xFF, 0xFF, 0xF5,
  0x07, 0x99, 0x9B, 0xFF, 0xE1,
  0x00, 0x00, 0x1D, 0xFE, 0x30,
  0x00, 0x01, 0xDF, 0xF4, 0x00,
  0x00, 0x1B, 0xFF, 0x50, 0x00,
  0x00, 0xBF, 0xF7, 0x00, 0x00,
  0x0A, 0xFF, 0x80, 0x00, 0x00,
  0x5F, 0xFF, 0xFF, 0xFF, 0xF5,
  0x4F, 0xFF, 0xFF, 0xFF, 0xF4
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_007B[ 68] = { /* code 007B, LEFT CURLY BRACKET */
  0x00, 0x6D, 0xFE, 0x30,
  0x01, 0xFF, 0xC9, 0x20,
  0x03, 0xFF, 0x40, 0x00,
  0x04, 0xFF, 0x40, 0x00,
  0x04, 0xFF, 0x40, 0x00,
  0x04, 0xFF, 0x40, 0x00,
  0x04, 0xFF, 0x30, 0x00,
  0x8D, 0xFB, 0x00, 0x00,
  0xDF, 0xE7, 0x00, 0x00,
  0x06, 0xFF, 0x10, 0x00,
  0x04, 0xFF, 0x40, 0x00,
  0x04, 0xFF, 0x40, 0x00,
  0x04, 0xFF, 0x40, 0x00,
  0x03, 0xFF, 0x40, 0x00,
  0x02, 0xFF, 0x95, 0x00,
  0x00, 0xBF, 0xFF, 0x40,
  0x00, 0x03, 0x55, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_007C[ 30] = { /* code 007C, VERTICAL LINE */
  0x02, 0x20,
  0x1E, 0xE1,
  0x2F, 0xF2,
  0x2F, 0xF2,
  0x2F, 0xF2,
  0x2F, 0xF2,
  0x2F, 0xF2,
  0x2F, 0xF2,
  0x2F, 0xF2,
  0x2F, 0xF2,
  0x2F, 0xF2,
  0x2F, 0xF2,
  0x2F, 0xF2,
  0x1F, 0xF1,
  0x02, 0x20
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_007D[ 68] = { /* code 007D, RIGHT CURLY BRACKET */
  0xCF, 0xEA, 0x00, 0x00,
  0x8B, 0xFF, 0x60, 0x00,
  0x00, 0xDF, 0x70, 0x00,
  0x00, 0xDF, 0x70, 0x00,
  0x00, 0xDF, 0x70, 0x00,
  0x00, 0xDF, 0x70, 0x00,
  0x00, 0xDF, 0x80, 0x00,
  0x00, 0x7F, 0xEA, 0x10,
  0x00, 0x3C, 0xFF, 0x30,
  0x00, 0xCF, 0xA0, 0x00,
  0x00, 0xDF, 0x70, 0x00,
  0x00, 0xDF, 0x70, 0x00,
  0x00, 0xDF, 0x70, 0x00,
  0x00, 0xDF, 0x70, 0x00,
  0x36, 0xFF, 0x70, 0x00,
  0xEF, 0xFE, 0x20, 0x00,
  0x36, 0x41, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_007E[ 24] = { /* code 007E, TILDE */
  0x02, 0xAB, 0x83, 0x00, 0x38, 0x00,
  0x0D, 0xFF, 0xFF, 0xBA, 0xFF, 0x00,
  0x4F, 0xC6, 0xAF, 0xFF, 0xF9, 0x00,
  0x06, 0x10, 0x01, 0x79, 0x50, 0x00
};

GUI_CONST_STORAGE GUI_CHARINFO_EXT GUI_FontRounded22_CharInfo[95] = {
   {   1,   1,   0,  18,   6, acGUI_FontRounded22_0020 } /* code 0020, SPACE */
  ,{   4,  15,   1,   4,   6, acGUI_FontRounded22_0021 } /* code 0021, EXCLAMATION MARK */
  ,{   7,   7,   1,   4,  10, acGUI_FontRounded22_0022 } /* code 0022, QUOTATION MARK */
  ,{  11,  14,   0,   5,  11, acGUI_FontRounded22_0023 } /* code 0023, NUMBER SIGN */
  ,{  11,  16,   0,   4,  11, acGUI_FontRounded22_0024 } /* code 0024, DOLLAR SIGN */
  ,{  16,  15,   1,   4,  18, acGUI_FontRounded22_0025 } /* code 0025, PERCENT SIGN */
  ,{  13,  15,   0,   4,  13, acGUI_FontRounded22_0026 } /* code 0026, AMPERSAND */
  ,{   3,   7,   1,   4,   6, acGUI_FontRounded22_0027 } /* code 0027, APOSTROPHE */
  ,{   5,  18,   1,   4,   6, acGUI_FontRounded22_0028 } /* code 0028, LEFT PARENTHESIS */
  ,{   5,  18,   0,   4,   6, acGUI_FontRounded22_0029 } /* code 0029, RIGHT PARENTHESIS */
  ,{   8,   8,   0,   4,   8, acGUI_FontRounded22_002A } /* code 002A, ASTERISK */
  ,{  11,  11,   0,   7,  11, acGUI_FontRounded22_002B } /* code 002B, PLUS SIGN */
  ,{   4,   6,   1,  15,   6, acGUI_FontRounded22_002C } /* code 002C, COMMA */
  ,{   7,   4,   0,  11,   7, acGUI_FontRounded22_002D } /* code 002D, HYPHEN-MINUS */
  ,{   4,   4,   1,  15,   6, acGUI_FontRounded22_002E } /* code 002E, FULL STOP */
  ,{   7,  15,   0,   4,   7, acGUI_FontRounded22_002F } /* code 002F, SOLIDUS */
  ,{  11,  14,   0,   5,  11, acGUI_FontRounded22_0030 } /* code 0030, DIGIT ZERO */
  ,{   7,  14,  -1,   5,   7, acGUI_FontRounded22_0031 } /* code 0031, DIGIT ONE */
  ,{  11,  13,   0,   5,  11, acGUI_FontRounded22_0032 } /* code 0032, DIGIT TWO */
  ,{  10,  14,   0,   5,  11, acGUI_FontRounded22_0033 } /* code 0033, DIGIT THREE */
  ,{  11,  14,   0,   5,  11, acGUI_FontRounded22_0034 } /* code 0034, DIGIT FOUR */
  ,{  10,  14,   0,   5,  11, acGUI_FontRounded22_0035 } /* code 0035, DIGIT FIVE */
  ,{  11,  14,   0,   5,  11, acGUI_FontRounded22_0036 } /* code 0036, DIGIT SIX */
  ,{  10,  14,   0,   5,  10, acGUI_FontRounded22_0037 } /* code 0037, DIGIT SEVEN */
  ,{  11,  14,   0,   5,  11, acGUI_FontRounded22_0038 } /* code 0038, DIGIT EIGHT */
  ,{  11,  14,   0,   5,  11, acGUI_FontRounded22_0039 } /* code 0039, DIGIT NINE */
  ,{   4,  11,   1,   8,   6, acGUI_FontRounded22_003A } /* code 003A, COLON */
  ,{   4,  13,   1,   8,   6, acGUI_FontRounded22_003B } /* code 003B, SEMICOLON */
  ,{  11,  10,   0,   8,  11, acGUI_FontRounded22_003C } /* code 003C, LESS-THAN SIGN */
  ,{  11,   8,   0,   9,  11, acGUI_FontRounded22_003D } /* code 003D, EQUALS SIGN */
  ,{  11,  10,   0,   8,  11, acGUI_FontRounded22_003E } /* code 003E, GREATER-THAN SIGN */
  ,{  10,  15,   0,   4,  10, acGUI_FontRounded22_003F } /* code 003F, QUESTION MARK */
  ,{  14,  15,   0,   4,  14, acGUI_FontRounded22_0040 } /* code 0040, COMMERCIAL AT */
  ,{  12,  15,   0,   4,  12, acGUI_FontRounded22_0041 } /* code 0041, LATIN CAPITAL LETTER A */
  ,{  12,  13,   1,   5,  13, acGUI_FontRounded22_0042 } /* code 0042, LATIN CAPITAL LETTER B */
  ,{  12,  15,   1,   4,  13, acGUI_FontRounded22_0043 } /* code 0043, LATIN CAPITAL LETTER C */
  ,{  12,  13,   1,   5,  14, acGUI_FontRounded22_0044 } /* code 0044, LATIN CAPITAL LETTER D */
  ,{  11,  13,   1,   5,  12, acGUI_FontRounded22_0045 } /* code 0045, LATIN CAPITAL LETTER E */
  ,{  11,  14,   1,   5,  11, acGUI_FontRounded22_0046 } /* code 0046, LATIN CAPITAL LETTER F */
  ,{  13,  15,   1,   4,  15, acGUI_FontRounded22_0047 } /* code 0047, LATIN CAPITAL LETTER G */
  ,{  12,  15,   1,   4,  14, acGUI_FontRounded22_0048 } /* code 0048, LATIN CAPITAL LETTER H */
  ,{   4,  15,   1,   4,   6, acGUI_FontRounded22_0049 } /* code 0049, LATIN CAPITAL LETTER I */
  ,{   9,  15,   0,   4,  10, acGUI_FontRounded22_004A } /* code 004A, LATIN CAPITAL LETTER J */
  ,{  12,  15,   1,   4,  12, acGUI_FontRounded22_004B } /* code 004B, LATIN CAPITAL LETTER K */
  ,{  10,  14,   1,   4,  11, acGUI_FontRounded22_004C } /* code 004C, LATIN CAPITAL LETTER L */
  ,{  14,  15,   1,   4,  16, acGUI_FontRounded22_004D } /* code 004D, LATIN CAPITAL LETTER M */
  ,{  12,  15,   1,   4,  14, acGUI_FontRounded22_004E } /* code 004E, LATIN CAPITAL LETTER N */
  ,{  14,  15,   0,   4,  15, acGUI_FontRounded22_004F } /* code 004F, LATIN CAPITAL LETTER O */
  ,{  12,  14,   1,   5,  13, acGUI_FontRounded22_0050 } /* code 0050, LATIN CAPITAL LETTER P */
  ,{  14,  15,   0,   4,  15, acGUI_FontRounded22_0051 } /* code 0051, LATIN CAPITAL LETTER Q */
  ,{  12,  14,   1,   5,  13, acGUI_FontRounded22_0052 } /* code 0052, LATIN CAPITAL LETTER R */
  ,{  12,  15,   0,   4,  12, acGUI_FontRounded22_0053 } /* code 0053, LATIN CAPITAL LETTER S */
  ,{  12,  14,   0,   5,  12, acGUI_FontRounded22_0054 } /* code 0054, LATIN CAPITAL LETTER T */
  ,{  12,  15,   1,   4,  14, acGUI_FontRounded22_0055 } /* code 0055, LATIN CAPITAL LETTER U */
  ,{  12,  15,   0,   4,  12, acGUI_FontRounded22_0056 } /* code 0056, LATIN CAPITAL LETTER V */
  ,{  17,  15,   0,   4,  17, acGUI_FontRounded22_0057 } /* code 0057, LATIN CAPITAL LETTER W */
  ,{  11,  15,   0,   4,  11, acGUI_FontRounded22_0058 } /* code 0058, LATIN CAPITAL LETTER X */
  ,{  11,  15,   0,   4,  11, acGUI_FontRounded22_0059 } /* code 0059, LATIN CAPITAL LETTER Y */
  ,{  12,  13,   0,   5,  12, acGUI_FontRounded22_005A } /* code 005A, LATIN CAPITAL LETTER Z */
  ,{   6,  17,   1,   5,   6, acGUI_FontRounded22_005B } /* code 005B, LEFT SQUARE BRACKET */
  ,{   7,  15,   0,   4,   7, acGUI_FontRounded22_005C } /* code 005C, REVERSE SOLIDUS */
  ,{   5,  17,   0,   5,   6, acGUI_FontRounded22_005D } /* code 005D, RIGHT SQUARE BRACKET */
  ,{   9,   8,   1,   5,  11, acGUI_FontRounded22_005E } /* code 005E, CIRCUMFLEX ACCENT */
  ,{  11,   2,  -1,  19,   9, acGUI_FontRounded22_005F } /* code 005F, LOW LINE */
  ,{   4,   4,   0,   4,   5, acGUI_FontRounded22_0060 } /* code 0060, GRAVE ACCENT */
  ,{  10,  11,   0,   8,  11, acGUI_FontRounded22_0061 } /* code 0061, LATIN SMALL LETTER A */
  ,{  10,  15,   1,   4,  11, acGUI_FontRounded22_0062 } /* code 0062, LATIN SMALL LETTER B */
  ,{  10,  11,   0,   8,  10, acGUI_FontRounded22_0063 } /* code 0063, LATIN SMALL LETTER C */
  ,{  10,  15,   0,   4,  11, acGUI_FontRounded22_0064 } /* code 0064, LATIN SMALL LETTER D */
  ,{  11,  11,   0,   8,  11, acGUI_FontRounded22_0065 } /* code 0065, LATIN SMALL LETTER E */
  ,{   7,  15,   0,   4,   7, acGUI_FontRounded22_0066 } /* code 0066, LATIN SMALL LETTER F */
  ,{  10,  14,   0,   8,  11, acGUI_FontRounded22_0067 } /* code 0067, LATIN SMALL LETTER G */
  ,{   9,  15,   1,   4,  11, acGUI_FontRounded22_0068 } /* code 0068, LATIN SMALL LETTER H */
  ,{   3,  15,   1,   4,   5, acGUI_FontRounded22_0069 } /* code 0069, LATIN SMALL LETTER I */
  ,{   5,  18,  -1,   4,   5, acGUI_FontRounded22_006A } /* code 006A, LATIN SMALL LETTER J */
  ,{   9,  15,   1,   4,  10, acGUI_FontRounded22_006B } /* code 006B, LATIN SMALL LETTER K */
  ,{   3,  15,   1,   4,   5, acGUI_FontRounded22_006C } /* code 006C, LATIN SMALL LETTER L */
  ,{  15,  11,   1,   8,  17, acGUI_FontRounded22_006D } /* code 006D, LATIN SMALL LETTER M */
  ,{   9,  11,   1,   8,  11, acGUI_FontRounded22_006E } /* code 006E, LATIN SMALL LETTER N */
  ,{  11,  11,   0,   8,  11, acGUI_FontRounded22_006F } /* code 006F, LATIN SMALL LETTER O */
  ,{  10,  14,   1,   8,  11, acGUI_FontRounded22_0070 } /* code 0070, LATIN SMALL LETTER P */
  ,{  10,  14,   0,   8,  11, acGUI_FontRounded22_0071 } /* code 0071, LATIN SMALL LETTER Q */
  ,{   7,  11,   1,   8,   7, acGUI_FontRounded22_0072 } /* code 0072, LATIN SMALL LETTER R */
  ,{   9,  11,   0,   8,  10, acGUI_FontRounded22_0073 } /* code 0073, LATIN SMALL LETTER S */
  ,{   7,  14,   0,   5,   7, acGUI_FontRounded22_0074 } /* code 0074, LATIN SMALL LETTER T */
  ,{   9,  11,   1,   8,  11, acGUI_FontRounded22_0075 } /* code 0075, LATIN SMALL LETTER U */
  ,{   9,  11,   0,   8,   9, acGUI_FontRounded22_0076 } /* code 0076, LATIN SMALL LETTER V */
  ,{  14,  11,   0,   8,  14, acGUI_FontRounded22_0077 } /* code 0077, LATIN SMALL LETTER W */
  ,{   9,  11,   0,   8,   9, acGUI_FontRounded22_0078 } /* code 0078, LATIN SMALL LETTER X */
  ,{   9,  14,   0,   8,   9, acGUI_FontRounded22_0079 } /* code 0079, LATIN SMALL LETTER Y */
  ,{  10,  10,   0,   8,  10, acGUI_FontRounded22_007A } /* code 007A, LATIN SMALL LETTER Z */
  ,{   7,  17,   0,   5,   6, acGUI_FontRounded22_007B } /* code 007B, LEFT CURLY BRACKET */
  ,{   4,  15,   0,   4,   4, acGUI_FontRounded22_007C } /* code 007C, VERTICAL LINE */
  ,{   7,  17,   0,   5,   6, acGUI_FontRounded22_007D } /* code 007D, RIGHT CURLY BRACKET */
  ,{  11,   4,   0,  11,  11, acGUI_FontRounded22_007E } /* code 007E, TILDE */
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_FontRounded22_Prop1 = {
   0x0020 /* first character */
  ,0x007E /* last character  */
  ,&GUI_FontRounded22_CharInfo[  0] /* address of first character */
  ,(GUI_CONST_STORAGE GUI_FONT_PROP_EXT *)0 /* pointer to next GUI_FONT_PROP_EXT */
};

GUI_CONST_STORAGE GUI_FONT GUI_FontRounded22 = {
   GUI_FONTTYPE_PROP_AA4_EXT /* type of font    */
  ,22 /* height of font  */
  ,22 /* space of font y */
  ,1 /* magnification x */
  ,1 /* magnification y */
  ,{&GUI_FontRounded22_Prop1}
  ,22 /* Baseline */
  ,11 /* Height of lowercase characters */
  ,15 /* Height of capital characters */
};

/*********************************************************************
*                                                                    *
*       Souvenir18                                                   *
*                                                                    *
**********************************************************************
*/
GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0020[  1] = { /* code 0020, SPACE */
  0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0021[ 11] = { /* code 0021, EXCLAMATION MARK */
  0xCB,
  0xED,
  0xDC,
  0xBB,
  0xA9,
  0x97,
  0x76,
  0x54,
  0x00,
  0xCC,
  0xCC
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0022[  8] = { /* code 0022, QUOTATION MARK */
  0xE0, 0xE0,
  0xC0, 0xC0,
  0x80, 0x80,
  0x50, 0x50
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0023[ 55] = { /* code 0023, NUMBER SIGN */
  0x00, 0x00, 0x3B, 0x02, 0xC0,
  0x00, 0x00, 0x87, 0x07, 0x80,
  0x00, 0x00, 0xC2, 0x0B, 0x30,
  0x00, 0x02, 0xC0, 0x1D, 0x00,
  0x0E, 0xFF, 0xFF, 0xFF, 0xFD,
  0x00, 0x0C, 0x30, 0xA4, 0x00,
  0x00, 0x2C, 0x01, 0xD0, 0x00,
  0xDF, 0xFF, 0xFF, 0xFF, 0xE0,
  0x00, 0xC2, 0x0C, 0x30, 0x00,
  0x03, 0xB0, 0x3C, 0x00, 0x00,
  0x0A, 0x50, 0x96, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0024[ 60] = { /* code 0024, DOLLAR SIGN */
  0x00, 0x01, 0x00, 0x00,
  0x00, 0x0F, 0x00, 0x00,
  0x03, 0xDF, 0xE7, 0x00,
  0x0C, 0x5F, 0x1C, 0x30,
  0x0F, 0x0F, 0x05, 0x30,
  0x0E, 0x3F, 0x00, 0x00,
  0x07, 0xEF, 0x30, 0x00,
  0x00, 0x6F, 0xFA, 0x10,
  0x00, 0x0F, 0x4C, 0xA0,
  0x00, 0x0F, 0x02, 0xF0,
  0xD0, 0x0F, 0x01, 0xE0,
  0x99, 0x1F, 0x2A, 0x70,
  0x08, 0xEF, 0xC6, 0x00,
  0x00, 0x0F, 0x00, 0x00,
  0x00, 0x09, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0025[ 78] = { /* code 0025, PERCENT SIGN */
  0x00, 0x00, 0x00, 0x00, 0x10, 0x00,
  0x2C, 0xFC, 0x61, 0x06, 0xC0, 0x00,
  0xC6, 0x06, 0xEE, 0xED, 0x40, 0x00,
  0xF0, 0x00, 0xF0, 0x19, 0x00, 0x00,
  0xC6, 0x06, 0xD0, 0x82, 0x00, 0x00,
  0x3C, 0xFC, 0x33, 0x70, 0x00, 0x00,
  0x00, 0x00, 0x0A, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x74, 0x2C, 0xFC, 0x20,
  0x00, 0x02, 0x90, 0xC6, 0x06, 0xC0,
  0x00, 0x0A, 0x20, 0xF0, 0x00, 0xF0,
  0x00, 0x57, 0x00, 0xC6, 0x06, 0xC0,
  0x00, 0xA0, 0x00, 0x2C, 0xFC, 0x20,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0026[ 66] = { /* code 0026, AMPERSAND */
  0x01, 0xBF, 0xD3, 0x00, 0x00, 0x00,
  0x0B, 0x70, 0x6D, 0x00, 0x00, 0x00,
  0x0F, 0x00, 0x0F, 0x00, 0x00, 0x00,
  0x0D, 0x40, 0x79, 0x00, 0x00, 0x00,
  0x08, 0xCA, 0xA0, 0x00, 0x00, 0x00,
  0x05, 0xFA, 0x00, 0x8F, 0xFC, 0x20,
  0x5B, 0x7F, 0x40, 0x09, 0x90, 0x00,
  0xD2, 0x08, 0xE2, 0x2B, 0x00, 0x00,
  0xF1, 0x00, 0x9E, 0xC1, 0x00, 0x00,
  0xB9, 0x11, 0x7D, 0xF9, 0x32, 0x30,
  0x1B, 0xFE, 0x80, 0x4A, 0xDC, 0x80
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0027[  4] = { /* code 0027, APOSTROPHE */
  0xE0,
  0xC0,
  0x80,
  0x50
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0028[ 26] = { /* code 0028, LEFT PARENTHESIS */
  0x02, 0xC0,
  0x0A, 0x40,
  0x3C, 0x00,
  0x87, 0x00,
  0xC3, 0x00,
  0xE1, 0x00,
  0xF0, 0x00,
  0xE1, 0x00,
  0xC3, 0x00,
  0x87, 0x00,
  0x3C, 0x00,
  0x0A, 0x40,
  0x02, 0xB0
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0029[ 26] = { /* code 0029, RIGHT PARENTHESIS */
  0xC2, 0x00,
  0x5A, 0x00,
  0x0C, 0x30,
  0x07, 0x80,
  0x03, 0xC0,
  0x01, 0xE0,
  0x00, 0xF0,
  0x01, 0xE0,
  0x03, 0xC0,
  0x07, 0x80,
  0x0C, 0x30,
  0x5A, 0x00,
  0xB2, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_002A[ 18] = { /* code 002A, ASTERISK */
  0x00, 0xE0, 0x00,
  0xB3, 0x93, 0xB0,
  0x68, 0x77, 0x60,
  0x68, 0x78, 0x60,
  0xB3, 0x93, 0xB0,
  0x00, 0xE0, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_002B[ 45] = { /* code 002B, PLUS SIGN */
  0x00, 0x00, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0xF0, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0x00, 0x00, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0xF0, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_002C[  4] = { /* code 002C, COMMA */
  0xCB,
  0xDF,
  0x07,
  0x52
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_002D[  2] = { /* code 002D, HYPHEN-MINUS */
  0xFF, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_002E[  2] = { /* code 002E, FULL STOP */
  0xCC,
  0xCC
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_002F[ 24] = { /* code 002F, SOLIDUS */
  0x00, 0x09,
  0x00, 0x09,
  0x00, 0x45,
  0x00, 0x81,
  0x00, 0x90,
  0x03, 0x70,
  0x07, 0x20,
  0x09, 0x00,
  0x18, 0x00,
  0x54, 0x00,
  0x90, 0x00,
  0x90, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0030[ 44] = { /* code 0030, DIGIT ZERO */
  0x04, 0xCF, 0xC4, 0x00,
  0x2D, 0x30, 0x3D, 0x20,
  0x95, 0x00, 0x05, 0x90,
  0xC2, 0x00, 0x02, 0xC0,
  0xF0, 0x00, 0x00, 0xF0,
  0xF0, 0x00, 0x00, 0xF0,
  0xF0, 0x00, 0x00, 0xF0,
  0xC2, 0x00, 0x02, 0xC0,
  0x95, 0x00, 0x05, 0x90,
  0x2D, 0x30, 0x3D, 0x20,
  0x04, 0xCF, 0xC4, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0031[ 33] = { /* code 0031, DIGIT ONE */
  0x14, 0xC0, 0x00,
  0xEE, 0xF0, 0x00,
  0x01, 0xF0, 0x00,
  0x00, 0xF0, 0x00,
  0x00, 0xF0, 0x00,
  0x00, 0xF0, 0x00,
  0x00, 0xF0, 0x00,
  0x00, 0xF0, 0x00,
  0x00, 0xF0, 0x00,
  0x03, 0xF4, 0x00,
  0xAF, 0xFF, 0xD0
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0032[ 44] = { /* code 0032, DIGIT TWO */
  0x00, 0x6D, 0xFE, 0x91,
  0x09, 0xA2, 0x02, 0x9A,
  0x0F, 0x10, 0x00, 0x0F,
  0x0C, 0x60, 0x00, 0x2E,
  0x00, 0x00, 0x00, 0xB7,
  0x00, 0x00, 0x2C, 0x80,
  0x00, 0x04, 0xE6, 0x00,
  0x00, 0x5D, 0x30, 0x00,
  0x03, 0xD2, 0x00, 0x00,
  0x0D, 0x30, 0x00, 0x2D,
  0x5F, 0xFF, 0xFF, 0xFB
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0033[ 44] = { /* code 0033, DIGIT THREE */
  0x02, 0xAF, 0xFA, 0x10,
  0x0C, 0x60, 0x19, 0xA0,
  0x0E, 0x10, 0x01, 0xF0,
  0x00, 0x00, 0x01, 0xE0,
  0x00, 0x00, 0x1A, 0x60,
  0x00, 0x6D, 0xF7, 0x00,
  0x00, 0x00, 0x2A, 0x80,
  0x00, 0x00, 0x01, 0xE0,
  0xD0, 0x00, 0x01, 0xE0,
  0xD7, 0x10, 0x3B, 0x80,
  0x2B, 0xFF, 0xC7, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0034[ 44] = { /* code 0034, DIGIT FOUR */
  0x00, 0x00, 0x8E, 0x00,
  0x00, 0x08, 0xBF, 0x00,
  0x00, 0x6C, 0x1F, 0x00,
  0x02, 0xD2, 0x0F, 0x00,
  0x0B, 0x50, 0x0F, 0x00,
  0x4C, 0x00, 0x0F, 0x00,
  0xA5, 0x00, 0x0F, 0x00,
  0xEF, 0xFF, 0xFF, 0xFE,
  0x00, 0x00, 0x0F, 0x00,
  0x00, 0x00, 0x0F, 0x10,
  0x00, 0x00, 0xCF, 0xE0
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0035[ 44] = { /* code 0035, DIGIT FIVE */
  0x0F, 0xFF, 0xD9, 0x00,
  0x0E, 0x00, 0x00, 0x00,
  0x0D, 0x00, 0x00, 0x00,
  0x0B, 0x00, 0x00, 0x00,
  0x0C, 0xBF, 0xE8, 0x00,
  0x0B, 0x50, 0x1A, 0x90,
  0x00, 0x00, 0x02, 0xE0,
  0x00, 0x00, 0x00, 0xF0,
  0xD0, 0x00, 0x04, 0xC0,
  0xC6, 0x00, 0x4E, 0x50,
  0x2B, 0xFF, 0xC5, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0036[ 44] = { /* code 0036, DIGIT SIX */
  0x00, 0x06, 0xBF, 0x50,
  0x01, 0xCB, 0x41, 0x00,
  0x0C, 0x70, 0x00, 0x00,
  0x6A, 0x00, 0x00, 0x00,
  0xB6, 0xBF, 0xE9, 0x00,
  0xE9, 0x20, 0x2B, 0x80,
  0xF0, 0x00, 0x02, 0xE0,
  0xE1, 0x00, 0x00, 0xF0,
  0xB5, 0x00, 0x03, 0xD0,
  0x4E, 0x40, 0x2B, 0x60,
  0x05, 0xDF, 0xD6, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0037[ 44] = { /* code 0037, DIGIT SEVEN */
  0xEF, 0xFF, 0xFF, 0xE0,
  0xE1, 0x00, 0x07, 0x80,
  0x30, 0x00, 0x0D, 0x20,
  0x00, 0x00, 0x5B, 0x00,
  0x00, 0x00, 0xC4, 0x00,
  0x00, 0x04, 0xD0, 0x00,
  0x00, 0x0B, 0x80, 0x00,
  0x00, 0x2F, 0x30, 0x00,
  0x00, 0x9C, 0x00, 0x00,
  0x00, 0xE8, 0x00, 0x00,
  0x03, 0xF3, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0038[ 44] = { /* code 0038, DIGIT EIGHT */
  0x19, 0xDF, 0xEB, 0x20,
  0xB8, 0x20, 0x18, 0xD0,
  0xF1, 0x00, 0x01, 0xE0,
  0x9C, 0x51, 0x3A, 0x30,
  0x07, 0xFF, 0xF5, 0x00,
  0x1B, 0x43, 0xAF, 0x50,
  0xA6, 0x00, 0x07, 0xD0,
  0xF0, 0x00, 0x00, 0xF0,
  0xE2, 0x00, 0x02, 0xD0,
  0x9B, 0x20, 0x3C, 0x60,
  0x08, 0xEF, 0xC6, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0039[ 44] = { /* code 0039, DIGIT NINE */
  0x06, 0xDF, 0xD5, 0x00,
  0x6B, 0x20, 0x4E, 0x40,
  0xD3, 0x00, 0x05, 0xB0,
  0xF0, 0x00, 0x01, 0xE0,
  0xE2, 0x00, 0x00, 0xF0,
  0x8B, 0x20, 0x29, 0xE0,
  0x09, 0xEF, 0xB6, 0xB0,
  0x00, 0x00, 0x09, 0x60,
  0x00, 0x00, 0x7B, 0x00,
  0x01, 0x4B, 0xB1, 0x00,
  0x5F, 0xB6, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_003A[  7] = { /* code 003A, COLON */
  0xCC,
  0xCC,
  0x00,
  0x00,
  0x00,
  0xCC,
  0xCC
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_003B[  9] = { /* code 003B, SEMICOLON */
  0xCC,
  0xCC,
  0x00,
  0x00,
  0x00,
  0xCB,
  0xDF,
  0x05,
  0x42
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_003C[ 40] = { /* code 003C, LESS-THAN SIGN */
  0x00, 0x00, 0x00, 0x16, 0xC0,
  0x00, 0x00, 0x39, 0xD8, 0x20,
  0x01, 0x6C, 0xB5, 0x00, 0x00,
  0x9D, 0x82, 0x00, 0x00, 0x00,
  0x9D, 0x82, 0x00, 0x00, 0x00,
  0x01, 0x6C, 0xB5, 0x00, 0x00,
  0x00, 0x00, 0x39, 0xD9, 0x30,
  0x00, 0x00, 0x00, 0x16, 0xC0
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_003D[ 20] = { /* code 003D, EQUALS SIGN */
  0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_003E[ 40] = { /* code 003E, GREATER-THAN SIGN */
  0xC6, 0x10, 0x00, 0x00, 0x00,
  0x28, 0xD9, 0x30, 0x00, 0x00,
  0x00, 0x05, 0xBC, 0x61, 0x00,
  0x00, 0x00, 0x02, 0x8D, 0x90,
  0x00, 0x00, 0x02, 0x8D, 0x90,
  0x00, 0x05, 0xBC, 0x61, 0x00,
  0x39, 0xD9, 0x30, 0x00, 0x00,
  0xC6, 0x10, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_003F[ 33] = { /* code 003F, QUESTION MARK */
  0x2A, 0xFF, 0xA1,
  0xCE, 0x21, 0x9B,
  0xDD, 0x00, 0x1F,
  0x00, 0x00, 0x1E,
  0x00, 0x00, 0x78,
  0x00, 0x4A, 0x90,
  0x00, 0xF2, 0x00,
  0x00, 0xE0, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0xCC, 0x00,
  0x00, 0xCC, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0040[ 91] = { /* code 0040, COMMERCIAL AT */
  0x00, 0x01, 0x8C, 0xFF, 0xEA, 0x40, 0x00,
  0x00, 0x5D, 0x83, 0x00, 0x27, 0xE8, 0x00,
  0x05, 0xC2, 0x00, 0x00, 0x00, 0x2D, 0x50,
  0x2D, 0x20, 0x2B, 0xF8, 0x55, 0x05, 0xB0,
  0x88, 0x01, 0xE7, 0x07, 0xC4, 0x01, 0xF0,
  0xD3, 0x09, 0xB0, 0x03, 0xE0, 0x00, 0xF0,
  0xF0, 0x0E, 0x40, 0x06, 0xB0, 0x03, 0xC0,
  0xF0, 0x0F, 0x00, 0x0D, 0x60, 0x0B, 0x70,
  0xC3, 0x0C, 0x41, 0x9B, 0x41, 0xAC, 0x00,
  0x7A, 0x03, 0xEE, 0x33, 0xDE, 0x91, 0x00,
  0x0C, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x01, 0xCB, 0x51, 0x00, 0x26, 0x50, 0x00,
  0x00, 0x06, 0xBE, 0xFE, 0xA4, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0041[ 55] = { /* code 0041, LATIN CAPITAL LETTER A */
  0x00, 0x00, 0x87, 0x00, 0x00,
  0x00, 0x02, 0xEF, 0x10, 0x00,
  0x00, 0x09, 0x4C, 0x80, 0x00,
  0x00, 0x1B, 0x05, 0xF1, 0x00,
  0x00, 0x75, 0x00, 0xD7, 0x00,
  0x00, 0xC0, 0x00, 0x7D, 0x00,
  0x04, 0xFF, 0xFF, 0xFF, 0x30,
  0x0A, 0x40, 0x00, 0x0B, 0x80,
  0x1E, 0x00, 0x00, 0x07, 0xD0,
  0x5C, 0x00, 0x00, 0x03, 0xF3,
  0xDF, 0x50, 0x00, 0x0B, 0xFC
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0042[ 55] = { /* code 0042, LATIN CAPITAL LETTER B */
  0xBF, 0xFF, 0xFF, 0xC3, 0x00,
  0x0F, 0x20, 0x02, 0x8D, 0x00,
  0x0F, 0x00, 0x00, 0x0F, 0x00,
  0x0F, 0x00, 0x00, 0x79, 0x00,
  0x0F, 0x14, 0x7D, 0x90, 0x00,
  0x0F, 0xDA, 0x66, 0xBB, 0x10,
  0x0F, 0x00, 0x00, 0x07, 0xA0,
  0x0F, 0x00, 0x00, 0x00, 0xF0,
  0x0F, 0x00, 0x00, 0x02, 0xE0,
  0x0F, 0x30, 0x01, 0x5D, 0x80,
  0xCF, 0xFF, 0xFF, 0xD8, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0043[ 55] = { /* code 0043, LATIN CAPITAL LETTER C */
  0x00, 0x3A, 0xEF, 0xEB, 0x40,
  0x07, 0xC4, 0x00, 0x4C, 0xE0,
  0x3D, 0x10, 0x00, 0x01, 0xC0,
  0xA6, 0x00, 0x00, 0x00, 0x00,
  0xE1, 0x00, 0x00, 0x00, 0x00,
  0xF0, 0x00, 0x00, 0x00, 0x00,
  0xE1, 0x00, 0x00, 0x00, 0x00,
  0xB5, 0x00, 0x00, 0x00, 0x00,
  0x5C, 0x10, 0x00, 0x00, 0x85,
  0x09, 0xC4, 0x00, 0x3A, 0xC1,
  0x00, 0x6C, 0xFF, 0xC7, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0044[ 55] = { /* code 0044, LATIN CAPITAL LETTER D */
  0xCF, 0xFF, 0xFD, 0x93, 0x00,
  0x1F, 0x30, 0x03, 0x7E, 0x60,
  0x0F, 0x00, 0x00, 0x02, 0xD3,
  0x0F, 0x00, 0x00, 0x00, 0x6A,
  0x0F, 0x00, 0x00, 0x00, 0x1E,
  0x0F, 0x00, 0x00, 0x00, 0x0F,
  0x0F, 0x00, 0x00, 0x00, 0x1E,
  0x0F, 0x00, 0x00, 0x00, 0x6A,
  0x0F, 0x00, 0x00, 0x02, 0xE3,
  0x1F, 0x40, 0x03, 0x8E, 0x60,
  0xCF, 0xFF, 0xFD, 0x93, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0045[ 55] = { /* code 0045, LATIN CAPITAL LETTER E */
  0xBF, 0xFF, 0xFF, 0xFF, 0x40,
  0x0F, 0x20, 0x00, 0x39, 0x50,
  0x0F, 0x00, 0x00, 0x00, 0x00,
  0x0F, 0x00, 0x00, 0x00, 0x00,
  0x0F, 0x00, 0x01, 0xB0, 0x00,
  0x0F, 0xFF, 0xFF, 0xF0, 0x00,
  0x0F, 0x00, 0x01, 0xB0, 0x00,
  0x0F, 0x00, 0x00, 0x00, 0x00,
  0x0F, 0x00, 0x00, 0x00, 0x00,
  0x0F, 0x20, 0x00, 0x16, 0xD0,
  0xBF, 0xFF, 0xFF, 0xFF, 0xB0
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0046[ 44] = { /* code 0046, LATIN CAPITAL LETTER F */
  0xBF, 0xFF, 0xFF, 0xFC,
  0x0F, 0x20, 0x02, 0x5D,
  0x0F, 0x00, 0x00, 0x00,
  0x0F, 0x00, 0x00, 0x00,
  0x0F, 0x00, 0x01, 0xA0,
  0x0F, 0xFF, 0xFF, 0xF0,
  0x0F, 0x00, 0x02, 0xA0,
  0x0F, 0x00, 0x00, 0x00,
  0x0F, 0x00, 0x00, 0x00,
  0x0F, 0x00, 0x00, 0x00,
  0xCF, 0xB0, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0047[ 66] = { /* code 0047, LATIN CAPITAL LETTER G */
  0x00, 0x28, 0xDF, 0xFC, 0x81, 0x00,
  0x03, 0xE7, 0x20, 0x14, 0xC8, 0x00,
  0x2E, 0x30, 0x00, 0x00, 0x19, 0x00,
  0x98, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xD2, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xF0, 0x00, 0x00, 0x7F, 0xFE, 0x00,
  0xE1, 0x00, 0x00, 0x00, 0x3F, 0x00,
  0xB6, 0x00, 0x00, 0x00, 0x0F, 0x00,
  0x4E, 0x20, 0x00, 0x00, 0x1F, 0x10,
  0x07, 0xE7, 0x30, 0x03, 0xBC, 0x10,
  0x00, 0x4B, 0xEF, 0xEB, 0x60, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0048[ 66] = { /* code 0048, LATIN CAPITAL LETTER H */
  0xCF, 0xC0, 0x00, 0x00, 0xCF, 0xC0,
  0x1F, 0x10, 0x00, 0x00, 0x0F, 0x10,
  0x0F, 0x00, 0x00, 0x00, 0x0F, 0x00,
  0x0F, 0x00, 0x00, 0x00, 0x0F, 0x00,
  0x0F, 0x00, 0x00, 0x00, 0x0F, 0x00,
  0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0x00,
  0x0F, 0x00, 0x00, 0x00, 0x0F, 0x00,
  0x0F, 0x00, 0x00, 0x00, 0x0F, 0x00,
  0x0F, 0x00, 0x00, 0x00, 0x0F, 0x00,
  0x1F, 0x00, 0x00, 0x00, 0x1F, 0x00,
  0xCF, 0xB0, 0x00, 0x00, 0xCF, 0xB0
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0049[ 22] = { /* code 0049, LATIN CAPITAL LETTER I */
  0xBF, 0xC0,
  0x0F, 0x10,
  0x0F, 0x00,
  0x0F, 0x00,
  0x0F, 0x00,
  0x0F, 0x00,
  0x0F, 0x00,
  0x0F, 0x00,
  0x0F, 0x00,
  0x1F, 0x00,
  0xCF, 0xB0
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_004A[ 44] = { /* code 004A, LATIN CAPITAL LETTER J */
  0x00, 0x00, 0xEF, 0xC0,
  0x00, 0x00, 0x2F, 0x00,
  0x00, 0x00, 0x0F, 0x00,
  0x00, 0x00, 0x0F, 0x00,
  0x00, 0x00, 0x0F, 0x00,
  0x00, 0x00, 0x0F, 0x00,
  0x00, 0x00, 0x0F, 0x00,
  0x6E, 0x90, 0x0F, 0x00,
  0xF3, 0x00, 0x0F, 0x00,
  0xD6, 0x01, 0x8B, 0x00,
  0x3B, 0xFF, 0xB1, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_004B[ 55] = { /* code 004B, LATIN CAPITAL LETTER K */
  0xBF, 0xC0, 0x05, 0xFF, 0x40,
  0x0F, 0x10, 0x01, 0xE4, 0x00,
  0x0F, 0x00, 0x0B, 0x70, 0x00,
  0x0F, 0x00, 0xA9, 0x00, 0x00,
  0x0F, 0x09, 0xE1, 0x00, 0x00,
  0x0F, 0xAA, 0xDB, 0x00, 0x00,
  0x0F, 0x80, 0x2E, 0x60, 0x00,
  0x0F, 0x00, 0x06, 0xE1, 0x00,
  0x0F, 0x00, 0x00, 0xC9, 0x00,
  0x1F, 0x00, 0x00, 0x5F, 0x20,
  0xCF, 0xB0, 0x00, 0xAF, 0xC0
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_004C[ 44] = { /* code 004C, LATIN CAPITAL LETTER L */
  0xBF, 0xC0, 0x00, 0x00,
  0x0F, 0x10, 0x00, 0x00,
  0x0F, 0x00, 0x00, 0x00,
  0x0F, 0x00, 0x00, 0x00,
  0x0F, 0x00, 0x00, 0x00,
  0x0F, 0x00, 0x00, 0x00,
  0x0F, 0x00, 0x00, 0x00,
  0x0F, 0x00, 0x00, 0x00,
  0x0F, 0x00, 0x00, 0x00,
  0x0F, 0x20, 0x01, 0x5D,
  0xBF, 0xFF, 0xFF, 0xFC
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_004D[ 66] = { /* code 004D, LATIN CAPITAL LETTER M */
  0xAF, 0xE1, 0x00, 0x00, 0x09, 0xFC,
  0x0C, 0xF7, 0x00, 0x00, 0x1F, 0xE0,
  0x0C, 0xAD, 0x00, 0x00, 0x7C, 0xD0,
  0x0D, 0x4F, 0x50, 0x00, 0xD6, 0xF0,
  0x0D, 0x2A, 0xB0, 0x06, 0xC2, 0xF0,
  0x0D, 0x23, 0xF3, 0x0D, 0x50, 0xF0,
  0x0E, 0x00, 0xBA, 0x6C, 0x00, 0xF0,
  0x0F, 0x00, 0x4F, 0xE5, 0x00, 0xF0,
  0x0F, 0x00, 0x0B, 0xC0, 0x00, 0xF0,
  0x1F, 0x00, 0x02, 0x20, 0x00, 0xF1,
  0xCF, 0xC0, 0x00, 0x00, 0x0B, 0xFB
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_004E[ 60] = { /* code 004E, LATIN CAPITAL LETTER N */
  0xEF, 0xB0, 0x00, 0x0B, 0xFB,
  0x1F, 0xF8, 0x00, 0x00, 0xF0,
  0x0F, 0x5F, 0x40, 0x00, 0xF0,
  0x0F, 0x08, 0xE2, 0x00, 0xF0,
  0x0F, 0x00, 0xCB, 0x00, 0xF0,
  0x0F, 0x00, 0x2E, 0x60, 0xF0,
  0x0F, 0x00, 0x06, 0xE2, 0xF0,
  0x0F, 0x00, 0x00, 0xBA, 0xF0,
  0x0F, 0x00, 0x00, 0x2F, 0xF0,
  0x1F, 0x10, 0x00, 0x07, 0xF0,
  0xCF, 0xD0, 0x00, 0x00, 0xC0,
  0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_004F[ 55] = { /* code 004F, LATIN CAPITAL LETTER O */
  0x00, 0x5B, 0xFF, 0xB5, 0x00,
  0x08, 0xC3, 0x00, 0x3C, 0x80,
  0x4C, 0x10, 0x00, 0x01, 0xC4,
  0xB5, 0x00, 0x00, 0x00, 0x5B,
  0xE1, 0x00, 0x00, 0x00, 0x1E,
  0xF0, 0x00, 0x00, 0x00, 0x0F,
  0xE1, 0x00, 0x00, 0x00, 0x1E,
  0xB5, 0x00, 0x00, 0x00, 0x5B,
  0x4C, 0x10, 0x00, 0x01, 0xC4,
  0x08, 0xC3, 0x00, 0x3C, 0x80,
  0x00, 0x5B, 0xFF, 0xB5, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0050[ 55] = { /* code 0050, LATIN CAPITAL LETTER P */
  0xCF, 0xFF, 0xFE, 0xB6, 0x00,
  0x1F, 0x50, 0x02, 0x5D, 0x80,
  0x0F, 0x00, 0x00, 0x02, 0xE0,
  0x0F, 0x00, 0x00, 0x01, 0xE0,
  0x0F, 0x00, 0x00, 0x09, 0x90,
  0x0F, 0x01, 0x37, 0xCB, 0x10,
  0x0F, 0xFE, 0xC9, 0x30, 0x00,
  0x0F, 0x00, 0x00, 0x00, 0x00,
  0x0F, 0x00, 0x00, 0x00, 0x00,
  0x0F, 0x10, 0x00, 0x00, 0x00,
  0xBF, 0xE0, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0051[ 65] = { /* code 0051, LATIN CAPITAL LETTER Q */
  0x00, 0x5B, 0xFF, 0xB5, 0x00,
  0x08, 0xC3, 0x00, 0x3C, 0x80,
  0x4C, 0x10, 0x00, 0x01, 0xC4,
  0xB5, 0x00, 0x00, 0x00, 0x5B,
  0xE1, 0x00, 0x00, 0x00, 0x1E,
  0xF0, 0x00, 0x00, 0x00, 0x0F,
  0xE1, 0x00, 0x00, 0x00, 0x1E,
  0xB5, 0x00, 0x00, 0x00, 0x5B,
  0x4C, 0x10, 0x38, 0x01, 0xC4,
  0x08, 0xC3, 0x1C, 0x4C, 0x80,
  0x00, 0x5B, 0xFF, 0xE5, 0x00,
  0x00, 0x00, 0x01, 0xC6, 0x00,
  0x00, 0x00, 0x00, 0x19, 0xFC
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0052[ 55] = { /* code 0052, LATIN CAPITAL LETTER R */
  0xBF, 0xFF, 0xFF, 0xDA, 0x20,
  0x0F, 0x20, 0x01, 0x3A, 0xD0,
  0x0F, 0x00, 0x00, 0x00, 0xF0,
  0x0F, 0x00, 0x00, 0x07, 0xB0,
  0x0F, 0x02, 0x47, 0xCB, 0x10,
  0x0F, 0xEC, 0xAE, 0xE1, 0x00,
  0x0F, 0x00, 0x03, 0xE9, 0x00,
  0x0F, 0x00, 0x00, 0x5F, 0x20,
  0x0F, 0x00, 0x00, 0x0B, 0x90,
  0x1F, 0x20, 0x00, 0x04, 0xE1,
  0xCF, 0xE0, 0x00, 0x2D, 0xFC
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0053[ 55] = { /* code 0053, LATIN CAPITAL LETTER S */
  0x00, 0x5B, 0xFF, 0xDA, 0x30,
  0x07, 0xA2, 0x03, 0xAF, 0xE0,
  0x0E, 0x10, 0x00, 0x05, 0xE0,
  0x0F, 0x20, 0x00, 0x00, 0x00,
  0x0A, 0xD7, 0x30, 0x00, 0x00,
  0x01, 0x8D, 0xFF, 0xC7, 0x00,
  0x00, 0x00, 0x24, 0x8E, 0xA0,
  0x00, 0x00, 0x00, 0x02, 0xF0,
  0xE5, 0x00, 0x00, 0x02, 0xD0,
  0x6F, 0x82, 0x01, 0x4C, 0x60,
  0x04, 0xBE, 0xFE, 0xB4, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0054[ 55] = { /* code 0054, LATIN CAPITAL LETTER T */
  0xCF, 0xFF, 0xFF, 0xFF, 0xC0,
  0xF7, 0x11, 0xF1, 0x17, 0xF0,
  0x20, 0x00, 0xF0, 0x00, 0x20,
  0x00, 0x00, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0xF0, 0x00, 0x00,
  0x00, 0x0D, 0xFB, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0055[ 66] = { /* code 0055, LATIN CAPITAL LETTER U */
  0xCF, 0xD0, 0x00, 0x00, 0xCF, 0xA0,
  0x0D, 0x40, 0x00, 0x00, 0x3C, 0x00,
  0x0D, 0x20, 0x00, 0x00, 0x2D, 0x00,
  0x0E, 0x10, 0x00, 0x00, 0x0E, 0x00,
  0x0F, 0x00, 0x00, 0x00, 0x0F, 0x00,
  0x0F, 0x00, 0x00, 0x00, 0x0F, 0x00,
  0x0F, 0x00, 0x00, 0x00, 0x0F, 0x00,
  0x0E, 0x20, 0x00, 0x00, 0x2D, 0x00,
  0x0A, 0x70, 0x00, 0x00, 0x7A, 0x00,
  0x03, 0xF7, 0x10, 0x27, 0xE2, 0x00,
  0x00, 0x3B, 0xEF, 0xEA, 0x20, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0056[ 55] = { /* code 0056, LATIN CAPITAL LETTER V */
  0xDF, 0xC0, 0x00, 0x07, 0xFD,
  0x6F, 0x30, 0x00, 0x00, 0xD5,
  0x2F, 0x30, 0x00, 0x01, 0xF1,
  0x0C, 0x70, 0x00, 0x05, 0xB0,
  0x08, 0xC0, 0x00, 0x0A, 0x60,
  0x02, 0xF2, 0x00, 0x1E, 0x10,
  0x00, 0xB8, 0x00, 0x6A, 0x00,
  0x00, 0x5F, 0x10, 0xD3, 0x00,
  0x00, 0x0D, 0x96, 0xB0, 0x00,
  0x00, 0x05, 0xFE, 0x30, 0x00,
  0x00, 0x00, 0xA8, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0057[ 77] = { /* code 0057, LATIN CAPITAL LETTER W */
  0xCF, 0xB0, 0x02, 0xEF, 0x70, 0x07, 0xFC,
  0x5F, 0x10, 0x00, 0x7C, 0x00, 0x00, 0xB4,
  0x1F, 0x30, 0x00, 0xAC, 0x00, 0x00, 0xC1,
  0x0D, 0x60, 0x00, 0xDF, 0x10, 0x01, 0xC0,
  0x0A, 0x90, 0x03, 0xCE, 0x50, 0x04, 0x90,
  0x06, 0xE0, 0x07, 0x7A, 0xB0, 0x08, 0x50,
  0x02, 0xF3, 0x0D, 0x24, 0xF1, 0x0D, 0x10,
  0x00, 0xD8, 0x4C, 0x00, 0xD8, 0x3B, 0x00,
  0x00, 0x8D, 0xB6, 0x00, 0x7E, 0xA7, 0x00,
  0x00, 0x3F, 0xE1, 0x00, 0x1F, 0xF1, 0x00,
  0x00, 0x0B, 0x60, 0x00, 0x07, 0x90, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0058[ 55] = { /* code 0058, LATIN CAPITAL LETTER X */
  0xBF, 0xD1, 0x00, 0x6F, 0xF3,
  0x1D, 0xA0, 0x00, 0x0E, 0x60,
  0x04, 0xF4, 0x00, 0x79, 0x00,
  0x00, 0x9E, 0x14, 0xC1, 0x00,
  0x00, 0x0C, 0xCC, 0x20, 0x00,
  0x00, 0x03, 0xFB, 0x00, 0x00,
  0x00, 0x0B, 0x6D, 0x90, 0x00,
  0x00, 0x79, 0x02, 0xE6, 0x00,
  0x02, 0xD1, 0x00, 0x3E, 0x20,
  0x0C, 0x70, 0x00, 0x0B, 0xC0,
  0xBF, 0xB0, 0x00, 0x1F, 0xFB
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0059[ 55] = { /* code 0059, LATIN CAPITAL LETTER Y */
  0xDF, 0xE3, 0x00, 0x05, 0xFC,
  0x1D, 0xD0, 0x00, 0x00, 0xC2,
  0x04, 0xF6, 0x00, 0x02, 0x80,
  0x00, 0x8E, 0x20, 0x09, 0x10,
  0x00, 0x0B, 0xB0, 0x64, 0x00,
  0x00, 0x01, 0xD9, 0xA0, 0x00,
  0x00, 0x00, 0x3F, 0x10, 0x00,
  0x00, 0x00, 0x0F, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0x00, 0x00,
  0x00, 0x00, 0x1F, 0x00, 0x00,
  0x00, 0x00, 0xCF, 0xB0, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_005A[ 44] = { /* code 005A, LATIN CAPITAL LETTER Z */
  0x3F, 0xFF, 0xFF, 0xFB,
  0x6B, 0x30, 0x00, 0xD7,
  0x10, 0x00, 0x08, 0xD1,
  0x00, 0x00, 0x4F, 0x40,
  0x00, 0x02, 0xE8, 0x00,
  0x00, 0x0C, 0xB0, 0x00,
  0x00, 0x9D, 0x10, 0x00,
  0x06, 0xF3, 0x00, 0x00,
  0x2E, 0x70, 0x00, 0x02,
  0xAD, 0x00, 0x02, 0x7E,
  0xEF, 0xFF, 0xFF, 0xFC
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_005B[ 26] = { /* code 005B, LEFT SQUARE BRACKET */
  0xFF, 0xF0,
  0xF0, 0x00,
  0xF0, 0x00,
  0xF0, 0x00,
  0xF0, 0x00,
  0xF0, 0x00,
  0xF0, 0x00,
  0xF0, 0x00,
  0xF0, 0x00,
  0xF0, 0x00,
  0xF0, 0x00,
  0xF0, 0x00,
  0xFF, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_005C[ 24] = { /* code 005C, REVERSE SOLIDUS */
  0x90, 0x00,
  0x90, 0x00,
  0x63, 0x00,
  0x18, 0x00,
  0x09, 0x00,
  0x07, 0x20,
  0x03, 0x60,
  0x00, 0xA0,
  0x00, 0x91,
  0x00, 0x55,
  0x00, 0x19,
  0x00, 0x09
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_005D[ 26] = { /* code 005D, RIGHT SQUARE BRACKET */
  0xFF, 0xF0,
  0x00, 0xF0,
  0x00, 0xF0,
  0x00, 0xF0,
  0x00, 0xF0,
  0x00, 0xF0,
  0x00, 0xF0,
  0x00, 0xF0,
  0x00, 0xF0,
  0x00, 0xF0,
  0x00, 0xF0,
  0x00, 0xF0,
  0xFF, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_005E[ 20] = { /* code 005E, CIRCUMFLEX ACCENT */
  0x00, 0x0A, 0xFA, 0x00, 0x00,
  0x00, 0x8B, 0x1B, 0x80, 0x00,
  0x08, 0x80, 0x00, 0x88, 0x00,
  0x85, 0x00, 0x00, 0x05, 0x80
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_005F[  4] = { /* code 005F, LOW LINE */
  0xFF, 0xFF, 0xFF, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0060[  6] = { /* code 0060, GRAVE ACCENT */
  0xD2, 0x00,
  0x5C, 0x10,
  0x03, 0x70
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0061[ 28] = { /* code 0061, LATIN SMALL LETTER A */
  0xBE, 0xFE, 0x80, 0x00,
  0x00, 0x03, 0xD7, 0x00,
  0x00, 0x00, 0x4C, 0x00,
  0x18, 0xCF, 0xFF, 0x00,
  0xC8, 0x31, 0x0F, 0x00,
  0xF3, 0x01, 0x7F, 0x00,
  0x6E, 0xFC, 0x4B, 0x90
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0062[ 44] = { /* code 0062, LATIN SMALL LETTER B */
  0x8E, 0x00, 0x00, 0x00,
  0x0F, 0x00, 0x00, 0x00,
  0x0F, 0x00, 0x00, 0x00,
  0x0F, 0x00, 0x00, 0x00,
  0x0F, 0x4C, 0xFE, 0x80,
  0x0F, 0x92, 0x03, 0xB8,
  0x0F, 0x00, 0x00, 0x2E,
  0x0F, 0x00, 0x00, 0x0F,
  0x0F, 0x10, 0x00, 0x3C,
  0x0B, 0xA1, 0x03, 0xD5,
  0x02, 0xBF, 0xFC, 0x50
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0063[ 28] = { /* code 0063, LATIN SMALL LETTER C */
  0x05, 0xCF, 0xD6, 0x00,
  0x5C, 0x20, 0x8D, 0x00,
  0xC3, 0x00, 0x00, 0x00,
  0xF0, 0x00, 0x00, 0x00,
  0xE2, 0x00, 0x00, 0x00,
  0x8B, 0x20, 0x3C, 0x20,
  0x08, 0xEF, 0xC4, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0064[ 44] = { /* code 0064, LATIN SMALL LETTER D */
  0x00, 0x00, 0x09, 0xE0,
  0x00, 0x00, 0x01, 0xF0,
  0x00, 0x00, 0x00, 0xF0,
  0x00, 0x00, 0x00, 0xF0,
  0x05, 0xCF, 0xE8, 0xF0,
  0x5D, 0x40, 0x16, 0xF0,
  0xC3, 0x00, 0x00, 0xF0,
  0xF0, 0x00, 0x00, 0xF0,
  0xE2, 0x00, 0x00, 0xF0,
  0x7C, 0x30, 0x15, 0xF0,
  0x07, 0xDF, 0xD7, 0xBB
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0065[ 28] = { /* code 0065, LATIN SMALL LETTER E */
  0x04, 0xCF, 0xD5, 0x00,
  0x4E, 0x30, 0x4E, 0x00,
  0xC4, 0x00, 0x2E, 0x00,
  0xF1, 0x37, 0xD6, 0x00,
  0xEE, 0xC8, 0x30, 0x00,
  0x88, 0x10, 0x4B, 0x00,
  0x08, 0xEF, 0xB3, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0066[ 33] = { /* code 0066, LATIN SMALL LETTER F */
  0x00, 0x3E, 0xC0,
  0x00, 0xB6, 0xD0,
  0x00, 0xE1, 0x00,
  0x00, 0xF0, 0x00,
  0x2F, 0xFF, 0x00,
  0x00, 0xF0, 0x00,
  0x00, 0xF0, 0x00,
  0x00, 0xF0, 0x00,
  0x00, 0xF0, 0x00,
  0x00, 0xF0, 0x00,
  0x0D, 0xFB, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0067[ 40] = { /* code 0067, LATIN SMALL LETTER G */
  0x09, 0xFF, 0xFF, 0x20,
  0x8A, 0x11, 0xA6, 0x00,
  0xE2, 0x00, 0x2D, 0x00,
  0xF0, 0x00, 0x0F, 0x00,
  0xD2, 0x00, 0x2D, 0x00,
  0x8A, 0x11, 0xA7, 0x00,
  0x09, 0xEE, 0xE6, 0x00,
  0x00, 0x00, 0x2E, 0x00,
  0xC2, 0x01, 0x6D, 0x00,
  0x8E, 0xFE, 0xB2, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0068[ 44] = { /* code 0068, LATIN SMALL LETTER H */
  0x5E, 0x00, 0x00, 0x00,
  0x0F, 0x00, 0x00, 0x00,
  0x0F, 0x00, 0x00, 0x00,
  0x0F, 0x00, 0x00, 0x00,
  0x0F, 0x5D, 0xFC, 0x30,
  0x0F, 0x81, 0x08, 0xB0,
  0x0F, 0x00, 0x01, 0xF0,
  0x0F, 0x00, 0x00, 0xF0,
  0x0F, 0x00, 0x00, 0xF0,
  0x0F, 0x00, 0x00, 0xF0,
  0xAF, 0xC0, 0x0A, 0xFC
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0069[ 20] = { /* code 0069, LATIN SMALL LETTER I */
  0x0C, 0x00,
  0x0C, 0x00,
  0x00, 0x00,
  0x8E, 0x00,
  0x1F, 0x00,
  0x0F, 0x00,
  0x0F, 0x00,
  0x0F, 0x00,
  0x0F, 0x00,
  0xBF, 0xC0
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_006A[ 26] = { /* code 006A, LATIN SMALL LETTER J */
  0x00, 0xC0,
  0x00, 0xC0,
  0x00, 0x00,
  0x09, 0xE0,
  0x00, 0xF0,
  0x00, 0xF0,
  0x00, 0xF0,
  0x00, 0xF0,
  0x00, 0xF0,
  0x00, 0xF0,
  0x00, 0xE0,
  0x04, 0xB0,
  0xDE, 0x30
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_006B[ 44] = { /* code 006B, LATIN SMALL LETTER K */
  0x8E, 0x00, 0x00, 0x00,
  0x0F, 0x00, 0x00, 0x00,
  0x0F, 0x00, 0x00, 0x00,
  0x0F, 0x00, 0x00, 0x00,
  0x0F, 0x00, 0x5F, 0xB0,
  0x0F, 0x00, 0x7B, 0x00,
  0x0F, 0x09, 0xB0, 0x00,
  0x0F, 0xCA, 0xE2, 0x00,
  0x0F, 0x20, 0x6B, 0x00,
  0x0F, 0x00, 0x0B, 0x40,
  0x9F, 0xC0, 0x0C, 0xD0
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_006C[ 22] = { /* code 006C, LATIN SMALL LETTER L */
  0x9E, 0x00,
  0x1F, 0x00,
  0x0F, 0x00,
  0x0F, 0x00,
  0x0F, 0x00,
  0x0F, 0x00,
  0x0F, 0x00,
  0x0F, 0x00,
  0x0F, 0x00,
  0x0F, 0x00,
  0xBF, 0xC0
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_006D[ 42] = { /* code 006D, LATIN SMALL LETTER M */
  0x9B, 0x9E, 0xE6, 0x8E, 0xE5, 0x00,
  0x0F, 0x60, 0x4F, 0x60, 0x4E, 0x00,
  0x0F, 0x00, 0x0F, 0x00, 0x0F, 0x00,
  0x0F, 0x00, 0x0F, 0x00, 0x0F, 0x00,
  0x0F, 0x00, 0x0F, 0x00, 0x0F, 0x00,
  0x0F, 0x00, 0x0F, 0x00, 0x0F, 0x00,
  0xBF, 0xC0, 0xBF, 0xC0, 0xBF, 0xC0
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_006E[ 28] = { /* code 006E, LATIN SMALL LETTER N */
  0xAA, 0x7D, 0xFC, 0x30,
  0x1F, 0x71, 0x07, 0xC0,
  0x0F, 0x00, 0x00, 0xF0,
  0x0F, 0x00, 0x00, 0xF0,
  0x0F, 0x00, 0x00, 0xF0,
  0x0F, 0x00, 0x00, 0xF0,
  0xBF, 0xC0, 0x0B, 0xFC
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_006F[ 28] = { /* code 006F, LATIN SMALL LETTER O */
  0x06, 0xDF, 0xD7, 0x00,
  0x6D, 0x30, 0x3D, 0x70,
  0xD3, 0x00, 0x03, 0xD0,
  0xF0, 0x00, 0x00, 0xF0,
  0xD3, 0x00, 0x03, 0xD0,
  0x7C, 0x30, 0x3C, 0x70,
  0x07, 0xDF, 0xD7, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0070[ 40] = { /* code 0070, LATIN SMALL LETTER P */
  0xBB, 0x6D, 0xFD, 0x70,
  0x1F, 0x71, 0x03, 0xC7,
  0x0F, 0x00, 0x00, 0x2D,
  0x0F, 0x00, 0x00, 0x0F,
  0x0F, 0x00, 0x00, 0x3D,
  0x0F, 0x22, 0x03, 0xD6,
  0x0F, 0x6E, 0xFC, 0x60,
  0x0F, 0x00, 0x00, 0x00,
  0x1F, 0x10, 0x00, 0x00,
  0xDF, 0xC0, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0071[ 40] = { /* code 0071, LATIN SMALL LETTER Q */
  0x05, 0xCF, 0xE7, 0xB0,
  0x5D, 0x30, 0x2A, 0xF0,
  0xC3, 0x00, 0x01, 0xF0,
  0xF0, 0x00, 0x00, 0xF0,
  0xE2, 0x00, 0x00, 0xF0,
  0x8B, 0x30, 0x29, 0xF0,
  0x08, 0xEF, 0xC5, 0xF0,
  0x00, 0x00, 0x00, 0xF0,
  0x00, 0x00, 0x00, 0xF0,
  0x00, 0x00, 0x0D, 0xFC
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0072[ 21] = { /* code 0072, LATIN SMALL LETTER R */
  0xB8, 0x5D, 0xD0,
  0x2E, 0xA0, 0x00,
  0x0F, 0x20, 0x00,
  0x0F, 0x00, 0x00,
  0x0F, 0x00, 0x00,
  0x0F, 0x00, 0x00,
  0xCF, 0xB0, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0073[ 21] = { /* code 0073, LATIN SMALL LETTER S */
  0x3C, 0xFE, 0x80,
  0xE4, 0x04, 0xD0,
  0xE6, 0x10, 0x00,
  0x4C, 0xFD, 0x50,
  0x00, 0x16, 0xE0,
  0xD4, 0x04, 0xD0,
  0x4C, 0xFC, 0x30
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0074[ 20] = { /* code 0074, LATIN SMALL LETTER T */
  0x09, 0x00,
  0x0B, 0x00,
  0x0E, 0x00,
  0xDF, 0xFE,
  0x0F, 0x00,
  0x0F, 0x00,
  0x0F, 0x00,
  0x0F, 0x00,
  0x0F, 0x10,
  0x0E, 0xEB
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0075[ 28] = { /* code 0075, LATIN SMALL LETTER U */
  0xBE, 0x00, 0x0B, 0xE0,
  0x1F, 0x00, 0x01, 0xF0,
  0x0F, 0x00, 0x00, 0xF0,
  0x0F, 0x00, 0x00, 0xF0,
  0x0F, 0x10, 0x00, 0xF0,
  0x0B, 0x80, 0x18, 0xF2,
  0x03, 0xCF, 0xD5, 0xBB
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0076[ 28] = { /* code 0076, LATIN SMALL LETTER V */
  0xCF, 0x30, 0x0F, 0xD0,
  0x4C, 0x00, 0x08, 0x60,
  0x1E, 0x10, 0x0A, 0x20,
  0x0A, 0x60, 0x1B, 0x00,
  0x03, 0xC0, 0x75, 0x00,
  0x00, 0xB8, 0xC0, 0x00,
  0x00, 0x2E, 0x30, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0077[ 42] = { /* code 0077, LATIN SMALL LETTER W */
  0xCF, 0x40, 0x4F, 0x80, 0x0B, 0xD0,
  0x6B, 0x00, 0x0D, 0x40, 0x04, 0x80,
  0x3D, 0x00, 0x1F, 0x70, 0x07, 0x40,
  0x0D, 0x30, 0x6C, 0xD0, 0x0C, 0x10,
  0x08, 0x90, 0xC2, 0xE5, 0x59, 0x00,
  0x02, 0xFA, 0x70, 0x7D, 0xC2, 0x00,
  0x00, 0x7B, 0x00, 0x0C, 0x70, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0078[ 28] = { /* code 0078, LATIN SMALL LETTER X */
  0xBF, 0x40, 0x7F, 0x30,
  0x0C, 0x60, 0x86, 0x00,
  0x02, 0xE7, 0xA0, 0x00,
  0x00, 0x7F, 0x30, 0x00,
  0x02, 0xB6, 0xE2, 0x00,
  0x0B, 0x20, 0x8C, 0x10,
  0xBF, 0x30, 0x6F, 0xC0
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_0079[ 40] = { /* code 0079, LATIN SMALL LETTER Y */
  0xCF, 0x40, 0x0C, 0xD0,
  0x6C, 0x00, 0x06, 0x80,
  0x4B, 0x00, 0x06, 0x60,
  0x2E, 0x00, 0x09, 0x30,
  0x0D, 0x40, 0x0C, 0x00,
  0x07, 0xC1, 0x68, 0x00,
  0x00, 0xBF, 0xE1, 0x00,
  0x00, 0x05, 0x70, 0x00,
  0x00, 0x5A, 0x00, 0x00,
  0x9E, 0x80, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_007A[ 21] = { /* code 007A, LATIN SMALL LETTER Z */
  0x7F, 0xFF, 0xD0,
  0x82, 0x08, 0x80,
  0x00, 0x4C, 0x00,
  0x01, 0xD3, 0x00,
  0x0B, 0x60, 0x00,
  0x79, 0x02, 0xB0,
  0xEF, 0xFF, 0xC0
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_007B[ 39] = { /* code 007B, LEFT CURLY BRACKET */
  0x00, 0x4C, 0xF0,
  0x00, 0xD6, 0x00,
  0x00, 0xF0, 0x00,
  0x00, 0xF0, 0x00,
  0x00, 0xE0, 0x00,
  0x17, 0xA0, 0x00,
  0xFB, 0x10, 0x00,
  0x17, 0xA0, 0x00,
  0x00, 0xE0, 0x00,
  0x00, 0xF0, 0x00,
  0x00, 0xF0, 0x00,
  0x00, 0xD6, 0x00,
  0x00, 0x4C, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_007C[ 15] = { /* code 007C, VERTICAL LINE */
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_007D[ 39] = { /* code 007D, RIGHT CURLY BRACKET */
  0xFC, 0x40, 0x00,
  0x06, 0xD0, 0x00,
  0x00, 0xF0, 0x00,
  0x00, 0xF0, 0x00,
  0x00, 0xE0, 0x00,
  0x00, 0xA7, 0x10,
  0x00, 0x1B, 0xF0,
  0x00, 0xA7, 0x10,
  0x00, 0xE0, 0x00,
  0x00, 0xF0, 0x00,
  0x00, 0xF0, 0x00,
  0x06, 0xD0, 0x00,
  0xFC, 0x40, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontSouvenir18_007E[ 15] = { /* code 007E, TILDE */
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x4C, 0xFD, 0x83, 0x03, 0xC0,
  0xA3, 0x02, 0x7D, 0xFC, 0x40
};

GUI_CONST_STORAGE GUI_CHARINFO_EXT GUI_FontSouvenir18_CharInfo[95] = {
   {   1,   1,   0,  14,   4, acGUI_FontSouvenir18_0020 } /* code 0020, SPACE */
  ,{   2,  11,   1,   3,   4, acGUI_FontSouvenir18_0021 } /* code 0021, EXCLAMATION MARK */
  ,{   3,   4,   1,   3,   5, acGUI_FontSouvenir18_0022 } /* code 0022, QUOTATION MARK */
  ,{  10,  11,   1,   3,  11, acGUI_FontSouvenir18_0023 } /* code 0023, NUMBER SIGN */
  ,{   7,  15,   0,   1,   8, acGUI_FontSouvenir18_0024 } /* code 0024, DOLLAR SIGN */
  ,{  11,  13,   1,   2,  13, acGUI_FontSouvenir18_0025 } /* code 0025, PERCENT SIGN */
  ,{  11,  11,   1,   3,  11, acGUI_FontSouvenir18_0026 } /* code 0026, AMPERSAND */
  ,{   1,   4,   1,   3,   3, acGUI_FontSouvenir18_0027 } /* code 0027, APOSTROPHE */
  ,{   3,  13,   1,   3,   5, acGUI_FontSouvenir18_0028 } /* code 0028, LEFT PARENTHESIS */
  ,{   3,  13,   1,   3,   5, acGUI_FontSouvenir18_0029 } /* code 0029, RIGHT PARENTHESIS */
  ,{   5,   6,   1,   3,   7, acGUI_FontSouvenir18_002A } /* code 002A, ASTERISK */
  ,{   9,   9,   2,   5,  12, acGUI_FontSouvenir18_002B } /* code 002B, PLUS SIGN */
  ,{   2,   4,   1,  12,   4, acGUI_FontSouvenir18_002C } /* code 002C, COMMA */
  ,{   4,   1,   1,  10,   5, acGUI_FontSouvenir18_002D } /* code 002D, HYPHEN-MINUS */
  ,{   2,   2,   1,  12,   4, acGUI_FontSouvenir18_002E } /* code 002E, FULL STOP */
  ,{   4,  12,   0,   3,   4, acGUI_FontSouvenir18_002F } /* code 002F, SOLIDUS */
  ,{   7,  11,   0,   3,   8, acGUI_FontSouvenir18_0030 } /* code 0030, DIGIT ZERO */
  ,{   5,  11,   2,   3,   8, acGUI_FontSouvenir18_0031 } /* code 0031, DIGIT ONE */
  ,{   8,  11,  -1,   3,   8, acGUI_FontSouvenir18_0032 } /* code 0032, DIGIT TWO */
  ,{   7,  11,   0,   3,   8, acGUI_FontSouvenir18_0033 } /* code 0033, DIGIT THREE */
  ,{   8,  11,   0,   3,   8, acGUI_FontSouvenir18_0034 } /* code 0034, DIGIT FOUR */
  ,{   7,  11,   0,   3,   8, acGUI_FontSouvenir18_0035 } /* code 0035, DIGIT FIVE */
  ,{   7,  11,   0,   3,   8, acGUI_FontSouvenir18_0036 } /* code 0036, DIGIT SIX */
  ,{   7,  11,   1,   3,   8, acGUI_FontSouvenir18_0037 } /* code 0037, DIGIT SEVEN */
  ,{   7,  11,   0,   3,   8, acGUI_FontSouvenir18_0038 } /* code 0038, DIGIT EIGHT */
  ,{   7,  11,   0,   3,   8, acGUI_FontSouvenir18_0039 } /* code 0039, DIGIT NINE */
  ,{   2,   7,   1,   7,   4, acGUI_FontSouvenir18_003A } /* code 003A, COLON */
  ,{   2,   9,   1,   7,   4, acGUI_FontSouvenir18_003B } /* code 003B, SEMICOLON */
  ,{   9,   8,   2,   5,  12, acGUI_FontSouvenir18_003C } /* code 003C, LESS-THAN SIGN */
  ,{   9,   4,   2,   7,  12, acGUI_FontSouvenir18_003D } /* code 003D, EQUALS SIGN */
  ,{   9,   8,   2,   5,  12, acGUI_FontSouvenir18_003E } /* code 003E, GREATER-THAN SIGN */
  ,{   6,  11,   1,   3,   7, acGUI_FontSouvenir18_003F } /* code 003F, QUESTION MARK */
  ,{  13,  13,   1,   3,  15, acGUI_FontSouvenir18_0040 } /* code 0040, COMMERCIAL AT */
  ,{  10,  11,   0,   3,  10, acGUI_FontSouvenir18_0041 } /* code 0041, LATIN CAPITAL LETTER A */
  ,{   9,  11,   0,   3,  10, acGUI_FontSouvenir18_0042 } /* code 0042, LATIN CAPITAL LETTER B */
  ,{  10,  11,   1,   3,  10, acGUI_FontSouvenir18_0043 } /* code 0043, LATIN CAPITAL LETTER C */
  ,{  10,  11,   0,   3,  11, acGUI_FontSouvenir18_0044 } /* code 0044, LATIN CAPITAL LETTER D */
  ,{   9,  11,   0,   3,   9, acGUI_FontSouvenir18_0045 } /* code 0045, LATIN CAPITAL LETTER E */
  ,{   8,  11,   0,   3,   8, acGUI_FontSouvenir18_0046 } /* code 0046, LATIN CAPITAL LETTER F */
  ,{  11,  11,   1,   3,  12, acGUI_FontSouvenir18_0047 } /* code 0047, LATIN CAPITAL LETTER G */
  ,{  11,  11,   0,   3,  12, acGUI_FontSouvenir18_0048 } /* code 0048, LATIN CAPITAL LETTER H */
  ,{   3,  11,   0,   3,   4, acGUI_FontSouvenir18_0049 } /* code 0049, LATIN CAPITAL LETTER I */
  ,{   7,  11,   0,   3,   7, acGUI_FontSouvenir18_004A } /* code 004A, LATIN CAPITAL LETTER J */
  ,{   9,  11,   0,   3,   9, acGUI_FontSouvenir18_004B } /* code 004B, LATIN CAPITAL LETTER K */
  ,{   8,  11,   0,   3,   9, acGUI_FontSouvenir18_004C } /* code 004C, LATIN CAPITAL LETTER L */
  ,{  12,  11,   0,   3,  12, acGUI_FontSouvenir18_004D } /* code 004D, LATIN CAPITAL LETTER M */
  ,{  10,  12,   0,   3,  11, acGUI_FontSouvenir18_004E } /* code 004E, LATIN CAPITAL LETTER N */
  ,{  10,  11,   1,   3,  11, acGUI_FontSouvenir18_004F } /* code 004F, LATIN CAPITAL LETTER O */
  ,{   9,  11,   0,   3,   9, acGUI_FontSouvenir18_0050 } /* code 0050, LATIN CAPITAL LETTER P */
  ,{  10,  13,   1,   3,  11, acGUI_FontSouvenir18_0051 } /* code 0051, LATIN CAPITAL LETTER Q */
  ,{  10,  11,   0,   3,  10, acGUI_FontSouvenir18_0052 } /* code 0052, LATIN CAPITAL LETTER R */
  ,{   9,  11,   0,   3,   9, acGUI_FontSouvenir18_0053 } /* code 0053, LATIN CAPITAL LETTER S */
  ,{   9,  11,   0,   3,   9, acGUI_FontSouvenir18_0054 } /* code 0054, LATIN CAPITAL LETTER T */
  ,{  11,  11,   0,   3,  11, acGUI_FontSouvenir18_0055 } /* code 0055, LATIN CAPITAL LETTER U */
  ,{  10,  11,   0,   3,  10, acGUI_FontSouvenir18_0056 } /* code 0056, LATIN CAPITAL LETTER V */
  ,{  14,  11,   0,   3,  14, acGUI_FontSouvenir18_0057 } /* code 0057, LATIN CAPITAL LETTER W */
  ,{  10,  11,   0,   3,  10, acGUI_FontSouvenir18_0058 } /* code 0058, LATIN CAPITAL LETTER X */
  ,{  10,  11,   0,   3,  10, acGUI_FontSouvenir18_0059 } /* code 0059, LATIN CAPITAL LETTER Y */
  ,{   8,  11,   0,   3,   8, acGUI_FontSouvenir18_005A } /* code 005A, LATIN CAPITAL LETTER Z */
  ,{   3,  13,   1,   3,   5, acGUI_FontSouvenir18_005B } /* code 005B, LEFT SQUARE BRACKET */
  ,{   4,  12,   0,   3,   4, acGUI_FontSouvenir18_005C } /* code 005C, REVERSE SOLIDUS */
  ,{   3,  13,   0,   3,   5, acGUI_FontSouvenir18_005D } /* code 005D, RIGHT SQUARE BRACKET */
  ,{   9,   4,   3,   3,  15, acGUI_FontSouvenir18_005E } /* code 005E, CIRCUMFLEX ACCENT */
  ,{   8,   1,   0,  17,   7, acGUI_FontSouvenir18_005F } /* code 005F, LOW LINE */
  ,{   3,   3,   2,   3,   7, acGUI_FontSouvenir18_0060 } /* code 0060, GRAVE ACCENT */
  ,{   7,   7,   0,   7,   8, acGUI_FontSouvenir18_0061 } /* code 0061, LATIN SMALL LETTER A */
  ,{   8,  11,   0,   3,   8, acGUI_FontSouvenir18_0062 } /* code 0062, LATIN SMALL LETTER B */
  ,{   7,   7,   0,   7,   7, acGUI_FontSouvenir18_0063 } /* code 0063, LATIN SMALL LETTER C */
  ,{   8,  11,   0,   3,   8, acGUI_FontSouvenir18_0064 } /* code 0064, LATIN SMALL LETTER D */
  ,{   7,   7,   0,   7,   7, acGUI_FontSouvenir18_0065 } /* code 0065, LATIN SMALL LETTER E */
  ,{   5,  11,  -1,   3,   4, acGUI_FontSouvenir18_0066 } /* code 0066, LATIN SMALL LETTER F */
  ,{   7,  10,   0,   7,   7, acGUI_FontSouvenir18_0067 } /* code 0067, LATIN SMALL LETTER G */
  ,{   8,  11,   0,   3,   8, acGUI_FontSouvenir18_0068 } /* code 0068, LATIN SMALL LETTER H */
  ,{   3,  10,   0,   4,   4, acGUI_FontSouvenir18_0069 } /* code 0069, LATIN SMALL LETTER I */
  ,{   3,  13,  -1,   4,   4, acGUI_FontSouvenir18_006A } /* code 006A, LATIN SMALL LETTER J */
  ,{   7,  11,   0,   3,   7, acGUI_FontSouvenir18_006B } /* code 006B, LATIN SMALL LETTER K */
  ,{   3,  11,   0,   3,   3, acGUI_FontSouvenir18_006C } /* code 006C, LATIN SMALL LETTER L */
  ,{  11,   7,   0,   7,  12, acGUI_FontSouvenir18_006D } /* code 006D, LATIN SMALL LETTER M */
  ,{   8,   7,   0,   7,   8, acGUI_FontSouvenir18_006E } /* code 006E, LATIN SMALL LETTER N */
  ,{   7,   7,   0,   7,   8, acGUI_FontSouvenir18_006F } /* code 006F, LATIN SMALL LETTER O */
  ,{   8,  10,   0,   7,   8, acGUI_FontSouvenir18_0070 } /* code 0070, LATIN SMALL LETTER P */
  ,{   8,  10,   0,   7,   8, acGUI_FontSouvenir18_0071 } /* code 0071, LATIN SMALL LETTER Q */
  ,{   5,   7,   0,   7,   5, acGUI_FontSouvenir18_0072 } /* code 0072, LATIN SMALL LETTER R */
  ,{   5,   7,   0,   7,   6, acGUI_FontSouvenir18_0073 } /* code 0073, LATIN SMALL LETTER S */
  ,{   4,  10,   0,   4,   4, acGUI_FontSouvenir18_0074 } /* code 0074, LATIN SMALL LETTER T */
  ,{   8,   7,   0,   7,   8, acGUI_FontSouvenir18_0075 } /* code 0075, LATIN SMALL LETTER U */
  ,{   7,   7,   0,   7,   7, acGUI_FontSouvenir18_0076 } /* code 0076, LATIN SMALL LETTER V */
  ,{  11,   7,   0,   7,  11, acGUI_FontSouvenir18_0077 } /* code 0077, LATIN SMALL LETTER W */
  ,{   7,   7,   0,   7,   7, acGUI_FontSouvenir18_0078 } /* code 0078, LATIN SMALL LETTER X */
  ,{   7,  10,   0,   7,   7, acGUI_FontSouvenir18_0079 } /* code 0079, LATIN SMALL LETTER Y */
  ,{   5,   7,   0,   7,   6, acGUI_FontSouvenir18_007A } /* code 007A, LATIN SMALL LETTER Z */
  ,{   5,  13,   1,   3,   7, acGUI_FontSouvenir18_007B } /* code 007B, LEFT CURLY BRACKET */
  ,{   1,  15,   3,   3,   7, acGUI_FontSouvenir18_007C } /* code 007C, VERTICAL LINE */
  ,{   5,  13,   1,   3,   7, acGUI_FontSouvenir18_007D } /* code 007D, RIGHT CURLY BRACKET */
  ,{   9,   3,   1,   7,  12, acGUI_FontSouvenir18_007E } /* code 007E, TILDE */
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_FontSouvenir18_Prop1 = {
   0x0020 /* first character */
  ,0x007E /* last character  */
  ,&GUI_FontSouvenir18_CharInfo[  0] /* address of first character */
  ,(GUI_CONST_STORAGE GUI_FONT_PROP_EXT *)0 /* pointer to next GUI_FONT_PROP_EXT */
};

GUI_CONST_STORAGE GUI_FONT GUI_FontSouvenir18 = {
   GUI_FONTTYPE_PROP_AA4_EXT /* type of font    */
  ,18 /* height of font  */
  ,18 /* space of font y */
  ,1 /* magnification x */
  ,1 /* magnification y */
  ,{&GUI_FontSouvenir18_Prop1}
  ,18 /* Baseline */
  ,7 /* Height of lowercase characters */
  ,11 /* Height of capital characters */
};

/*********************************************************************
*                                                                    *
*       Bitmaps                                                      *
*                                                                    *
**********************************************************************
*/
/*********************************************************************
*                                                                    *
*       SeggerLogo                                                   *
*                                                                    *
**********************************************************************
*/
static GUI_CONST_STORAGE GUI_COLOR ColorsSeggerLogo[] = {
     0x00FF00,0xFEFEFE,0x201F23,0xA02020
    ,0xE6E6E6,0xBB6060,0xE2BCBC,0xDEDEDE
    ,0x000000,0xFAFAFA,0x212024,0xD3D3D4
    ,0xD5D4D5,0xF1DEDE,0xE0E0E1,0xFCFCFC
    ,0xF1F1F1,0xFCF8F8,0xFEFCFC,0x424145
    ,0xC3C3C4,0xA12222,0xC1C1C2,0x808082
    ,0x444346,0x606062,0xA22626,0xEDEDED
    ,0xA73030,0x000000,0x252528,0x363539
    ,0xB1B0B2,0xE4E4E4,0xF8EEEE,0xB24A4A
    ,0xB34C4C,0x88888A,0xCF8E8E,0xEAEAEA
    ,0xF6F6F6,0x18171A,0x18181B,0x2A292D
    ,0x39383C,0x6C6C6E,0xA22424,0xAA3636
    ,0xCDCDCE,0xF2E0E0,0xF7ECEC,0xFDFAFA
    ,0x28272A,0x2E2D31,0x454448,0xA62E2E
    ,0xB95B5B,0xC47676,0x8E8E90,0xD09090
    ,0xC7C7C8,0xCACACB,0xD9D9DA,0xE5C2C2
    ,0xE6C4C4,0xF3E2E2,0x0D0C0E,0x1E1E21
    ,0x1F1E22,0x222222,0x3C3B3E,0x404043
    ,0x48474A,0x49484C,0xA52B2B,0xAC3B3B
    ,0xAC3D3D,0xBB5E5E,0xC67A7A,0x848385
    ,0xA5A5A6,0xA7A6A8,0xE3BEBE,0xC5C4C5
    ,0xDCDCDC,0xE4C0C0,0xEBD1D1,0xECD3D3
    ,0xF0DCDC,0xF4E4E4,0xF6E9E9,0xF4F4F4
    ,0xFBF6F6,0x242327,0x2C2B2E,0x2D2C2F
    ,0x323135,0x353436,0x555558,0x666568
    ,0x6A6A6C,0x727174,0x7C7B7E,0x7D7C7F
    ,0xA83232,0xA83434,0xB14848,0xB44E4E
    ,0xBC6161,0xBE6767,0x8A8A8C,0x8D8C8F
    ,0x909092,0x949496,0xADACAE,0xAEAEAE
    ,0xB5B5B6,0xB7B7B8,0xBABABB,0xCD8A8A
    ,0xDEB2B2,0xE2BBBB,0xD2D1D2,0xD7D7D8
    ,0xEACECE,0xF3E4E4,0x020202,0x191919
    ,0x343336,0x38373A,0x4F4E51,0x525255
    ,0x59585B,0x59585C,0x5E5D60,0x605F62
    ,0x646467,0x7A7A7C,0xA32828,0xA42929
    ,0xAB3939,0xAB3A3A,0xAF4444,0xB45050
    ,0xB75656,0xB85858,0xBA5D5D,0xBF6868
    ,0xC16E6E,0xC26F6F,0xC27070,0xC47373
    ,0xC57878,0xC77C7C,0xC87E7E,0x7E7E80
    ,0x848486,0x878688,0x8C8B8D,0x908F91
    ,0x9A9A9C,0x9D9C9E,0x9F9EA0,0xA1A1A2
    ,0xA4A3A5,0xA9A9AA,0xB4B3B5,0xBAB9BB
    ,0xC98080,0xCA8383,0xCE8C8C,0xD7A2A2
    ,0xD9A5A5,0xD9A6A6,0xDAA9A9,0xDBABAB
    ,0xDCACAC,0xDDAFAF,0xE0B6B6,0xE1B9B9
    ,0xE4BFBF,0xCFCFD0,0xE7C6C6,0xE8C8C8
    ,0xEDD5D5,0xEED6D6,0xEFD9D9,0xEFDADA
    ,0xF4E6E6,0xF5E8E8,0xF7EBEB,0xF9F1F1
    ,0xFAF3F3,0xFBF5F5,0xFCF7F7,0x0B0B0D
    ,0x0C0B0D,0x171717,0x252427,0x302F33
    ,0x313033,0x4C4B4E,0x4D4C4F,0x545356
    ,0x58575A,0x5C5C5F,0x636265,0x646366
    ,0x6C6B6E,0x706F71,0x78787A,0xA52D2D
    ,0xA62D2D,0xB14747,0xB55252,0xB65353
    ,0xB65454,0xB95C5C,0xBE6565,0xC47575
    ,0x838284,0x888789,0x929294,0x949395
    ,0x989799,0x98989A,0x9C9C9D,0x9E9D9F
    ,0xA3A2A4,0xABABAC,0xAFAEB0,0xB3B3B4
    ,0xB8B7B9,0xB9B8BA,0xBBBBBC,0xBCBBBC
    ,0xBDBDBE,0xCB8686,0xCC8686,0xCD8989
    ,0xD29595,0xD29696,0xD49B9B,0xD59C9C
    ,0xDEB0B0,0xC8C7C8,0xC9C8C9,0xCBCBCC
    ,0xD4D3D4,0xDBDBDC,0xEACDCD,0xE3E3E4
    ,0xEBEBEC,0xEFEFF0,0xF3F3F4,0xFBFBFC
};

static GUI_CONST_STORAGE GUI_LOGPALETTE PalSeggerLogo = {
  256,	/* number of entries */
  1, 	/* Has transparency */
  &ColorsSeggerLogo[0]
};

static GUI_CONST_STORAGE unsigned char acSeggerLogo[] = {
  0x00, 0x00, 0x08, 0x42, 0x2A, 0x44, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x44, 0x2A, 0x42, /**/0x42, 0x00, 0x00,
  0x00, 0x7E, 0x2A, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x34, 0x7F, 0x00,
  0x08, 0x29, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x29, 0x08,
  0xC3, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0xC4,
  0x29, 0x02, 0x02, 0x02, 0x46, 0x3C, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3C, 0x46, 0x02, 0x02, 0x02, 0x29,
  0x43, 0x02, 0x02, 0x02, 0xA7, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x76, 0x02, 0x02, 0x02, 0x43,
  0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
  0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
  0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
  0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
  0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x01, 0xB1, 0x4C, 0x23, 0x57, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x5A, 0x38, 0x2F, 0x26, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
  0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0xBF, 0x1A, 0x03, 0x03, 0x2F, 0x32, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x98, 0x03, 0x03, 0x03, 0xAB, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
  0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x32, 0x15, 0x03, 0x03, 0x03, 0x92, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x94, 0x03, 0x03, 0x03, 0x1A, 0x7C, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
  0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x01, 0x9A, 0x03, 0x03, 0x03, 0x03, 0x3B, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xB9, 0x8A, 0x03, 0x03, 0x03, 0x8C, 0x32, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
  0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x01, 0x11, 0x24, 0x03, 0x03, 0x03, 0x15, 0x40, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xAF, 0x03, 0x03, 0x03, 0x03, 0x38, 0x12, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
  0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x01, 0x01, 0x31, 0x37, 0x03, 0x03, 0x03, 0x2F, 0x5A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x4E, 0x03, 0x03, 0x03, 0x03, 0x77, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
  0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x01, 0x01, 0x01, 0xB3, 0x03, 0x03, 0x03, 0x03, 0x91, 0x12, 0x01, 0x01, 0x01, 0x01, 0x01, 0x11, 0x6B, 0x03, 0x03, 0x03, 0x03, 0x79, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
  0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xA9, 0x03, 0x03, 0x03, 0x03, 0xAA, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x7D, 0x1C, 0x03, 0x03, 0x03, 0x37, 0x31, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
  0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x33, 0xD6, 0x03, 0x03, 0x03, 0x15, 0x55, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x55, 0x15, 0x03, 0x03, 0x03, 0x23, 0xC2, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
  0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x59, 0x1C, 0x03, 0x03, 0x03, 0x68, 0xBC, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x3B, 0x03, 0x03, 0x03, 0x03, 0x97, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
  0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x52, 0x15, 0x03, 0x03, 0x03, 0xD8, 0x33, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x6C, 0x03, 0x03, 0x03, 0x03, 0xAC, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
  0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xEF, 0x03, 0x03, 0x03, 0x03, 0xEE, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x22, 0x4C, 0x03, 0x03, 0x03, 0x1A, 0x56, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
  0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x12, 0x90, 0x03, 0x03, 0x03, 0x03, 0x06, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x57, 0x8A, 0x03, 0x03, 0x03, 0x4B, 0x22, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
  0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0xC0, 0x11, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xBD, 0x68, 0x03, 0x03, 0x03, 0x1C, 0x7D, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xAE, 0x03, 0x03, 0x03, 0x03, 0x4D, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
  0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x0D, 0x99, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x3F, 0x15, 0x03, 0x03, 0x03, 0x8F, 0x33, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x98, 0x03, 0x03, 0x03, 0x03, 0x26, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
  0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x0D, 0x03, 0x78, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x26, 0x03, 0x03, 0x03, 0x03, 0xA8, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x11, 0x24, 0x03, 0x03, 0x03, 0x15, 0xB4, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
  0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x0D, 0x03, 0x4A, 0x0D, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x38, 0x03, 0x03, 0x03, 0x03, 0xB2, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x41, 0x1C, 0x03, 0x03, 0x03, 0x1C, 0x41, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
  0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x0D, 0x03, 0x03, 0x6A, 0xC2, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xBE, 0x2F, 0x03, 0x03, 0x03, 0xD4, 0x31, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x52, 0x15, 0x03, 0x03, 0x03, 0x24, 0x11, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
  0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x0D, 0x03, 0x03, 0x03, 0x39, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xB7, 0x15, 0x03, 0x03, 0x03, 0x24, 0x11, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x26, 0x03, 0x03, 0x03, 0x03, 0x95, 0x06, 0x06, 0x06, 0x06,
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
        0x06, 0x06, 0x06, 0x06, 0x06, 0x3F, 0x11, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
  0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x0D, 0x03, 0x03, 0x03, 0x03, 0xB0, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xF0, 0x03, 0x03, 0x03, 0x03, 0x99, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x4D, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x23, 0x11, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
  0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x0D, 0x03, 0x03, 0x03, 0x03, 0x8B, 0xBA, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x03, 0x03, 0x03, 0x03, 0x78, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x22, 0x4B, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0xB6, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
  0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x0D, 0x03, 0x03, 0x03, 0x03, 0x03, 0x8E, 0xC1, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x22, 0x8D, 0x03, 0x03, 0x03, 0x4A, 0x0D, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x56, 0x1A, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x1A, 0x59, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
  0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x0D, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x96, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xFA, 0x2E, 0x03, 0x03, 0x03, 0x6A, 0xC2, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x40, 0x93, 0x05, 0x05, 0x05, 0x05, 0x05,
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
        0x05, 0x05, 0x05, 0x05, 0x05, 0x6D, 0x3F, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
  0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x0D, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0xAD, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xF2, 0x03, 0x03, 0x03, 0x03, 0x39, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
  0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x0D, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x8A, 0xB8, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xDA, 0x03, 0x03, 0x03, 0x03, 0xBB, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
  0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x0D, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x8A, 0xB8, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x6D, 0x03, 0x03, 0x03, 0x03, 0xBB, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
  0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x0D, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0xAD, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xF3, 0x03, 0x03, 0x03, 0x03, 0xDB, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
  0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x0D, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x96, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x7C, 0x1A, 0x03, 0x03, 0x03, 0xD5, 0x5C, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x40, 0x93, 0x05, 0x05, 0x05, 0x05, 0x05,
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
        0x05, 0x05, 0x05, 0x05, 0x05, 0x6D, 0x3F, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
  0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x0D, 0x03, 0x03, 0x03, 0x03, 0x03, 0x8E, 0xC1, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x22, 0x8D, 0x03, 0x03, 0x03, 0x4A, 0x58, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x56, 0x1A, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x1A, 0x59, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
  0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x0D, 0x03, 0x03, 0x03, 0x03, 0x8B, 0xBA, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x6C, 0x03, 0x03, 0x03, 0x03, 0xF4, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x22, 0x4B, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0xB6, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
  0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x0D, 0x03, 0x03, 0x03, 0x03, 0xB0, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xF1, 0x03, 0x03, 0x03, 0x03, 0x4E, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x4D, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x23, 0x11, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
  0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x0D, 0x03, 0x03, 0x03, 0x39, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xB7, 0x15, 0x03, 0x03, 0x03, 0x23, 0x11, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x26, 0x03, 0x03, 0x03, 0x03, 0x95, 0x06, 0x06, 0x06, 0x06,
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
        0x06, 0x06, 0x06, 0x06, 0x06, 0x3F, 0x11, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
  0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x0D, 0x03, 0x03, 0x6A, 0xC2, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xBE, 0x2F, 0x03, 0x03, 0x03, 0xD3, 0x31, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x52, 0x15, 0x03, 0x03, 0x03, 0x24, 0x11, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
  0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x0D, 0x03, 0x4A, 0x0D, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xD9, 0x03, 0x03, 0x03, 0x03, 0xB2, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x41, 0x1C, 0x03, 0x03, 0x03, 0x1C, 0x41, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
  0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x0D, 0x03, 0x78, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x3B, 0x03, 0x03, 0x03, 0x03, 0xA8, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x11, 0x24, 0x03, 0x03, 0x03, 0x15, 0xB4, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
  0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x0D, 0x99, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x40, 0x15, 0x03, 0x03, 0x03, 0x6B, 0x33, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x98, 0x03, 0x03, 0x03, 0x03, 0x26, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
  0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0xC0, 0x11, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xBD, 0x69, 0x03, 0x03, 0x03, 0x37, 0x41, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xAE, 0x03, 0x03, 0x03, 0x03, 0x4D, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x28, 0xEC,
        0xE0, 0x25, 0x25, 0xA1, 0xF6, 0x0F, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0E, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x3E, 0x0F, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x04, 0xE6, 0x9F, 0x9D, 0x70, 0x72, 0x0E, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x10, 0x75, 0x71, 0x9D, 0x6F, 0x51, 0x0C, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x3E, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x07, 0x01, 0x01, 0x01, 0x01, 0xFC, 0xF8, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B,
        0x0C, 0x21, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
  0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x12, 0x90, 0x03, 0x03, 0x03, 0x03, 0x79, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x57, 0x8A, 0x03, 0x03, 0x03, 0x4B, 0x22, 0x01, 0x01, 0x01, 0x01, 0x01, 0x71, 0x5E, 0x02,
        0x02, 0x02, 0x02, 0x02, 0x02, 0x2C, 0x20, 0x01, 0x01, 0x01, 0x01, 0xDD, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x84, 0x01, 0x01, 0x01, 0x01, 0xFB, 0x63, 0x0A, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x83, 0x3D, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x10, 0x66, 0x1E, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x47, 0x20, 0x01, 0x01, 0x01, 0x01, 0x01, 0x87, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x17, 0x01, 0x01, 0x16, 0x5D, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
        0x02, 0x02, 0xC8, 0x4F, 0x28, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
  0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x77, 0x03, 0x03, 0x03, 0x03, 0xED, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x22, 0x4C, 0x03, 0x03, 0x03, 0x1A, 0x56, 0x01, 0x01, 0x01, 0x01, 0x01, 0x70, 0x02, 0x02, 0x02,
        0x18, 0xCE, 0x85, 0x5E, 0x02, 0x02, 0x02, 0x72, 0x01, 0x01, 0x01, 0x48, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x19, 0x01, 0x01, 0x01, 0x30, 0x35, 0x02, 0x02, 0x02, 0x35, 0x36, 0x61, 0x02, 0x02, 0x02, 0x0A, 0xE7, 0x01, 0x01,
        0x01, 0x01, 0x04, 0x47, 0x02, 0x02, 0x02, 0x34, 0x18, 0x46, 0x02, 0x02, 0x02, 0x02, 0x6E, 0x01, 0x01, 0x01, 0x01, 0x0A, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x25, 0x01, 0x01, 0x9C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
        0x02, 0x02, 0x02, 0x02, 0x88, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
  0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x52, 0x15, 0x03, 0x03, 0x03, 0xD7, 0x33, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x6C, 0x03, 0x03, 0x03, 0x03, 0xAC, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0F, 0x5F, 0x02, 0x02, 0xA4,
        0x01, 0x01, 0x01, 0x5B, 0x63, 0x02, 0x02, 0x84, 0x01, 0x01, 0x01, 0x18, 0x02, 0x02, 0x71, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x04, 0x01, 0x01, 0x01, 0x1B, 0x80, 0x02, 0x02, 0x1F, 0xEB, 0x01, 0x01, 0x01, 0x3C, 0x2C, 0x02, 0x02, 0x36, 0x01, 0x01,
        0x01, 0x01, 0x82, 0x02, 0x02, 0x34, 0xA4, 0x09, 0x01, 0x01, 0xF9, 0x82, 0x02, 0x02, 0x5D, 0x28, 0x01, 0x01, 0x09, 0x02, 0x02, 0x02, 0x74, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0xFC, 0x01, 0x01, 0x01, 0x17, 0x02, 0x02, 0x85, 0x04, 0x04, 0x04, 0x21,
        0x7A, 0x63, 0x02, 0x02, 0x02, 0xFB, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
  0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x59, 0x1C, 0x03, 0x03, 0x03, 0x68, 0xBC, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x3B, 0x03, 0x03, 0x03, 0x03, 0x97, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1B, 0x02, 0x02, 0x02, 0xF9,
        0x01, 0x01, 0x01, 0x01, 0x09, 0x3A, 0x19, 0x14, 0x01, 0x01, 0x01, 0x18, 0x02, 0x02, 0x51, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x6E, 0x02, 0x02, 0x1E, 0x3E, 0x01, 0x01, 0x01, 0x01, 0x01, 0xFB, 0xC9, 0x0A, 0x25, 0x01, 0x01,
        0x01, 0xA6, 0x02, 0x02, 0x02, 0xA6, 0x01, 0x01, 0x01, 0x01, 0x01, 0xFE, 0xCF, 0x0A, 0x19, 0x01, 0x01, 0x01, 0x09, 0x02, 0x02, 0x02, 0x30, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x17, 0x02, 0x02, 0x19, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x1B, 0x02, 0x02, 0x02, 0x3C, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
  0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x33, 0xD6, 0x03, 0x03, 0x03, 0x15, 0x55, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x55, 0x15, 0x03, 0x03, 0x03, 0x23, 0xC2, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0F, 0x5E, 0x02, 0x02, 0x2C,
        0xA0, 0x3E, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x18, 0x02, 0x02, 0xA4, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x0F, 0x01, 0x01, 0x01, 0x01, 0x47, 0x02, 0x02, 0x65, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xFF, 0x01, 0x01, 0x01,
        0x01, 0x64, 0x02, 0x02, 0x48, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xFF, 0x01, 0x01, 0x01, 0x01, 0x09, 0x02, 0x02, 0x02, 0x3D, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x01, 0x01, 0x01, 0x01, 0x01, 0x17, 0x02, 0x02, 0x19, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x0E, 0x02, 0x02, 0x02, 0x54, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
  0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xA9, 0x03, 0x03, 0x03, 0x03, 0xAA, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x7D, 0x1C, 0x03, 0x03, 0x03, 0x37, 0x31, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x70, 0x02, 0x02, 0x02,
        0x02, 0x02, 0x5E, 0xCC, 0x6E, 0x53, 0x0F, 0x01, 0x01, 0x01, 0x01, 0x18, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x36, 0xFD, 0x01, 0x09, 0x0A, 0x02, 0x02, 0xA5, 0x01, 0x01, 0x01, 0x01, 0x01, 0x10, 0x10, 0x10, 0x10, 0xFF, 0x01, 0x01,
        0x01, 0x18, 0x02, 0x02, 0x67, 0x01, 0x01, 0x01, 0x01, 0x01, 0xFE, 0x10, 0x10, 0x10, 0x09, 0x01, 0x01, 0x01, 0x09, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x0A, 0x86, 0x01, 0x01, 0x01, 0x17, 0x02, 0x02, 0x49, 0x20, 0x20, 0x20, 0x20,
        0xE3, 0x18, 0x02, 0x02, 0xCD, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
  0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x01, 0x01, 0x01, 0xB3, 0x03, 0x03, 0x03, 0x03, 0x91, 0x12, 0x01, 0x01, 0x01, 0x01, 0x01, 0x11, 0x6B, 0x03, 0x03, 0x03, 0x03, 0x79, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x73, 0x49, 0x02,
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x2C, 0x76, 0x01, 0x01, 0x01, 0x18, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x1E, 0x21, 0x01, 0x1B, 0x02, 0x02, 0x02, 0x75, 0x01, 0x01, 0x01, 0x10, 0x2C, 0x02, 0x02, 0x02, 0x02, 0xC6, 0xE4, 0x01,
        0x01, 0x81, 0x02, 0x02, 0x9E, 0x01, 0x01, 0x01, 0x01, 0x62, 0x02, 0x02, 0x02, 0x02, 0x0A, 0x66, 0x01, 0x01, 0x09, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x1F, 0x01, 0x01, 0x01, 0x17, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
        0x02, 0x02, 0x0A, 0x89, 0x5B, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
  0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x01, 0x01, 0x31, 0x37, 0x03, 0x03, 0x03, 0x69, 0x5A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x4E, 0x03, 0x03, 0x03, 0x03, 0x77, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0E,
        0xE5, 0x9B, 0xCA, 0x0A, 0x02, 0x02, 0x02, 0x5D, 0x7A, 0x01, 0x01, 0x18, 0x02, 0x02, 0xDC, 0x16, 0x16, 0x16, 0x16, 0x16, 0x14, 0x04, 0x01, 0x01, 0x09, 0x0A, 0x02, 0x02, 0x50, 0x01, 0x01, 0x01, 0xFC, 0x2B, 0x02, 0x02, 0x02, 0x02, 0x02, 0x2D, 0x01,
        0x01, 0x18, 0x02, 0x02, 0x89, 0x01, 0x01, 0x01, 0x01, 0x13, 0x02, 0x02, 0x02, 0x02, 0x02, 0x18, 0x01, 0x01, 0x09, 0x02, 0x02, 0x02, 0xE3, 0x16, 0x16, 0x16, 0x16, 0x16, 0x53, 0xFD, 0x01, 0x01, 0x01, 0x17, 0x02, 0x02, 0x0A, 0x1E, 0x1E, 0x1E, 0x0A,
        0x02, 0x02, 0x02, 0x35, 0xB5, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
  0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x01, 0x11, 0x24, 0x03, 0x03, 0x03, 0x15, 0x40, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xAF, 0x03, 0x03, 0x03, 0x03, 0x38, 0x12, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x28, 0x7B, 0x0F, 0x01,
        0x01, 0x01, 0x01, 0x27, 0x9F, 0x5D, 0x02, 0x02, 0x9C, 0x01, 0x01, 0x18, 0x02, 0x02, 0x51, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x13, 0x02, 0x02, 0xD0, 0x01, 0x01, 0x01, 0x01, 0x27, 0x3D, 0x3D, 0x17, 0x02, 0x02, 0x2D, 0x01,
        0x01, 0x2D, 0x02, 0x02, 0x13, 0x01, 0x01, 0x01, 0x01, 0xFE, 0xF7, 0x3D, 0xA3, 0x02, 0x02, 0x18, 0x01, 0x01, 0x09, 0x02, 0x02, 0x02, 0x30, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x17, 0x02, 0x02, 0x19, 0x01, 0x01, 0x01, 0x01,
        0x7B, 0x1F, 0x02, 0x02, 0x19, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
  0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x01, 0x9A, 0x03, 0x03, 0x03, 0x03, 0x3B, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xB9, 0x8A, 0x03, 0x03, 0x03, 0x8C, 0x32, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x36, 0x02, 0x83, 0x28,
        0x01, 0x01, 0x01, 0x01, 0x01, 0xD1, 0x02, 0x02, 0xD2, 0x01, 0x01, 0x18, 0x02, 0x02, 0x51, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x3A, 0x02, 0x02, 0x5D, 0x30, 0x01, 0x01, 0x01, 0x01, 0x01, 0x09, 0x48, 0x02, 0x02, 0x2D, 0x01,
        0x01, 0xE8, 0x02, 0x02, 0x02, 0x50, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xD0, 0x02, 0x02, 0x18, 0x01, 0x01, 0x09, 0x02, 0x02, 0x02, 0x30, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x17, 0x02, 0x02, 0x19, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x67, 0x02, 0x02, 0x47, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
  0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x32, 0x15, 0x03, 0x03, 0x03, 0x92, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x94, 0x03, 0x03, 0x03, 0x1A, 0x7C, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xFF, 0x2B, 0x02, 0x02, 0x87,
        0xFC, 0x01, 0x01, 0x01, 0x54, 0x81, 0x02, 0x02, 0xE4, 0x01, 0x01, 0x18, 0x02, 0x02, 0xDC, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0E, 0x01, 0x01, 0x10, 0x81, 0x02, 0x02, 0x5F, 0x51, 0x28, 0x01, 0x01, 0x0C, 0xCC, 0x02, 0x02, 0x02, 0x2D, 0x01,
        0x01, 0x01, 0xCB, 0x02, 0x02, 0x5D, 0x3A, 0x1B, 0x01, 0x01, 0xFB, 0x65, 0x02, 0x02, 0x02, 0x18, 0x01, 0x01, 0x09, 0x02, 0x02, 0x02, 0xA2, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x53, 0xFC, 0x01, 0x01, 0x17, 0x02, 0x02, 0x19, 0x01, 0x01, 0x01, 0x01,
        0x01, 0xA0, 0x02, 0x02, 0x60, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
  0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0xBF, 0x1A, 0x03, 0x03, 0x2F, 0x32, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x98, 0x03, 0x03, 0x03, 0xAB, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xE1, 0x02, 0x02, 0x02,
        0x5D, 0x49, 0x62, 0x18, 0x0A, 0x02, 0x02, 0x36, 0x28, 0x01, 0x01, 0x48, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x0A, 0xB5, 0x01, 0x01, 0x7A, 0xC7, 0x02, 0x02, 0x02, 0x5D, 0x81, 0x35, 0x02, 0x02, 0x5E, 0x2B, 0x02, 0x2D, 0x01,
        0x01, 0x01, 0x27, 0x18, 0x02, 0x02, 0x02, 0x0A, 0x1F, 0x80, 0x02, 0x02, 0x0A, 0x60, 0x02, 0x18, 0x01, 0x01, 0x01, 0x0A, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x5E, 0xFD, 0x01, 0x17, 0x02, 0x02, 0x19, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x74, 0x02, 0x02, 0x02, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
  0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x01, 0xB1, 0x4C, 0x23, 0x57, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x5A, 0x38, 0x2F, 0x26, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xA6, 0x47, 0x02,
        0x02, 0x02, 0x02, 0x02, 0x02, 0x0A, 0xD0, 0x1B, 0x01, 0x01, 0x01, 0x25, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x34, 0x7B, 0x01, 0x01, 0x01, 0xFB, 0x88, 0x0A, 0x02, 0x02, 0x02, 0x02, 0x02, 0x18, 0x0B, 0x86, 0x02, 0x65, 0x01,
        0x01, 0x01, 0x01, 0x10, 0x66, 0x1E, 0x02, 0x02, 0x02, 0x02, 0x02, 0x80, 0xE9, 0x25, 0x02, 0x49, 0x01, 0x01, 0x01, 0x19, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x61, 0xFE, 0x01, 0xE2, 0x02, 0x02, 0x67, 0x01, 0x01, 0x01, 0x01,
        0x01, 0xFC, 0x34, 0x02, 0x5D, 0x07, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
  0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x30,
        0xA2, 0x25, 0x4F, 0x3A, 0x72, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xFB, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0xFD, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x21, 0xA5, 0x9E, 0x4F, 0xDF, 0x14, 0x0F, 0x01, 0x07, 0x9F, 0x54, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0xFD, 0xE7, 0x9F, 0x4F, 0x3A, 0x75, 0x28, 0x01, 0xFD, 0xDE, 0xF5, 0x01, 0x01, 0x01, 0x01, 0x54, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x7B, 0x28, 0x01, 0x01, 0x01, 0x16, 0xEA, 0x09, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x07, 0x20, 0x7B, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
  0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
  0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
  0x02, 0x02, 0x02, 0x02, 0x07, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02, 0x02, 0x02,
  0x43, 0x02, 0x02, 0x02, 0xA7, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x76, 0x02, 0x02, 0x02, 0x43,
  0x81, 0x02, 0x02, 0x02, 0x46, 0x3C, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x3C, 0x46, 0x02, 0x02, 0x02, 0x81,
  0x5F, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x5F,
  0x45, 0x29, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x29, 0x45,
  0x00, 0x7E, 0x2A, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x34, 0x7F, 0x00,
  0x00, 0x00, 0x08, 0x42, 0x2A, 0x44, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x44, 0x2A, 0x42, /**/0x42, 0x00, 0x00
};

GUI_CONST_STORAGE GUI_BITMAP bmSeggerLogo = {
  140, /* XSize */
  70, /* YSize */
  140, /* BytesPerLine */
  8, /* BitsPerPixel */
  acSeggerLogo,  /* Pointer to picture data (indices) */
  &PalSeggerLogo, /* Pointer to palette */
  NULL,  /* Pointer to methods */
};

/*********************************************************************
*                                                                    *
*       SeggerLogo70x35                                              *
*                                                                    *
**********************************************************************
*/
static GUI_CONST_STORAGE GUI_COLOR ColorsSeggerLogo70x35[] = {
     0x00FF00,0xFFFFFF,0x201F23,0xA02020
    ,0xF3F3F3,0xC16E6E,0xDDAFAF,0xEFEFEF
    ,0xE0E0E0,0xF8EEEE,0xFDFDFD,0x7A797B
    ,0xEAEAEA,0xA22424,0xFAFAFA,0x212024
    ,0xFDFAFA,0x262528,0x504F52,0x808082
    ,0x88888A,0xA0A0A2,0xF6EAEA,0xF8F8F8
    ,0xFEFEFE,0xFFFEFE,0x1E1D21,0x2A292D
    ,0xA42A2A,0xAFAFB0,0xD59D9D,0xDEB1B1
    ,0xFDFBFB,0xFCFCFC,0xFEFCFC,0x222124
    ,0x28272B,0x6A6A6D,0xAF4343,0xC57777
    ,0xC87D7D,0x828183,0x9A999B,0xEFDADA
    ,0xF0DBDB,0xF6F6F6,0x111013,0x111113
    ,0x1E1D20,0x29282C,0x2B2A2E,0x2C2B2E
    ,0x313034,0x3F3E42,0x403F43,0x414042
    ,0x474649,0x48474A,0x57565A,0x69686B
    ,0x747476,0x7C7B7D,0xA02121,0xA12323
    ,0xA22525,0xA52B2B,0xA52C2C,0xA62E2E
    ,0xA83434,0xA93535,0xAA3636,0xAA3838
    ,0xAB3B3B,0xAD3E3E,0xAE4141,0xAF4444
    ,0xB34C4C,0xB34D4D,0xB65353,0xB65555
    ,0xB85959,0xBA5D5D,0xBC6262,0xBD6363
    ,0xBF6A6A,0xC06B6B,0xC27070,0xC77C7C
    ,0x7F7F81,0x828284,0x8A8A8C,0x8D8D8F
    ,0x969597,0xA2A1A3,0xBABABB,0xCA8282
    ,0xCA8383,0xCF8D8D,0xD19393,0xD39797
    ,0xD59B9B,0xD8A3A3,0xDEB2B2,0xDFB3B3
    ,0xDFB4B4,0xC4C4C5,0xC5C5C6,0xC8C8C9
    ,0xD5D5D6,0xD7D7D8,0xE7C7C7,0xE8C9C9
    ,0xE8CACA,0xE9CACA,0xEACECE,0xEACFCF
    ,0xECD3D3,0xF1DEDE,0xE1E1E2,0xE2E1E2
    ,0xE8E8E8,0xEBEBEC,0xECECED,0xF5E8E8
    ,0xF8EFEF,0xF4F4F4,0xF8F0F0,0xF9F0F0
    ,0xF9F1F1,0xFAF3F3,0xFAF4F4,0xFCF7F7
    ,0xFCF9F9,0xFEFDFD,0x010101,0x121212
    ,0x232226,0x242327,0x252428,0x2E2D31
    ,0x2F2E31,0x302F33,0x313033,0x323134
    ,0x363539,0x373639,0x38373B,0x3B3A3E
    ,0x3C3B3F,0x3D3C3F,0x3F3E41,0x414043
    ,0x434246,0x464548,0x47464A,0x4C4B4E
    ,0x4F4E52,0x515054,0x525154,0x525155
    ,0x535256,0x545356,0x555457,0x565558
    ,0x575659,0x58575A,0x5A595C,0x5D5C5F
    ,0x5E5D60,0x605F62,0x616163,0x646366
    ,0x6D6D6F,0x6F6F71,0x727274,0x737375
    ,0x767578,0x79787B,0x7A797C,0x7B7A7D
    ,0x7D7C7F,0xA32626,0xA32727,0xB14949
    ,0xB24949,0xBE6767,0xBE6868,0xC57878
    ,0x7E7E80,0x878789,0x8C8C8C,0x919092
    ,0x929193,0x939393,0x969697,0x979698
    ,0x989799,0x99989A,0x9B9A9C,0x9B9B9D
    ,0x9C9C9D,0x9C9C9E,0x9E9D9F,0x9E9EA0
    ,0x9F9EA0,0x9F9FA1,0xA2A2A3,0xA3A2A4
    ,0xA4A3A5,0xA5A4A6,0xA9A9AA,0xACACAD
    ,0xB0B0B1,0xB2B2B3,0xB3B3B4,0xB4B4B5
    ,0xB9B9BA,0xBCBBBD,0xBDBDBE,0xC98080
    ,0xC98181,0xDCAEAE,0xDDAEAE,0xE1B8B8
    ,0xE1B9B9,0xC0C0C1,0xC4C3C5,0xC6C6C7
    ,0xC7C6C7,0xC9C9CA,0xCAC9CA,0xCACACB
    ,0xCBCBCC,0xCCCCCD,0xCDCDCE,0xD1D1D1
    ,0xD1D1D2,0xD4D3D4,0xD5D4D5,0xDADADB
    ,0xDBDBDB,0xDDDCDD,0xDEDEDF,0xDFDFE0
    ,0xE3E3E4,0xE4E4E4,0xE4E4E5,0xE6E6E7
    ,0xECECEC,0xEDEDED,0xF2E1E1,0xF2E2E2
    ,0xEFEFF0,0xF1F1F1,0xF3F2F3,0xF8F7F8
};

static GUI_CONST_STORAGE GUI_LOGPALETTE PalSeggerLogo70x35 = {
  256,	/* number of entries */
  1, 	/* Has transparency */
  &ColorsSeggerLogo70x35[0]
};

static GUI_CONST_STORAGE unsigned char acSeggerLogo70x35[] = {
  0x86, 0x2F, 0x1A, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x1A, 0x86, 0x86,
  0x2E, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x2E,
  0x30, 0x02, 0x1D, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x1D, 0x02, 0x30,
  0x02, 0x02, 0x07, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02,
  0x02, 0x02, 0x07, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02,
  0x02, 0x02, 0x07, 0x20, 0x4C, 0x51, 0x10, 0x01, 0x01, 0x01, 0x27, 0x4A, 0x7B, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02,
  0x02, 0x02, 0x07, 0x10, 0x47, 0x03, 0x60, 0x01, 0x01, 0x01, 0x53, 0x03, 0x4E, 0x10, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02,
  0x02, 0x02, 0x07, 0x01, 0x70, 0x0D, 0x3E, 0xE0, 0x01, 0x01, 0x16, 0x46, 0x03, 0xDC, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02,
  0x02, 0x02, 0x07, 0x01, 0x01, 0x63, 0x03, 0x43, 0xFB, 0x01, 0x01, 0x71, 0x0D, 0x03, 0x66, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02,
  0x02, 0x02, 0x07, 0x01, 0x01, 0x19, 0x52, 0x03, 0x4D, 0x84, 0x01, 0x01, 0x1E, 0x03, 0x1C, 0x2B, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02,
  0x02, 0x02, 0x07, 0x01, 0x01, 0x01, 0x7C, 0x48, 0x03, 0x28, 0x01, 0x01, 0x01, 0x55, 0x03, 0x26, 0x81, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02,
  0x02, 0x02, 0x07, 0x22, 0x85, 0x01, 0x01, 0x72, 0x40, 0x03, 0x67, 0x01, 0x01, 0x82, 0x4B, 0x03, 0x54, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02,
  0x02, 0x02, 0x07, 0x09, 0x62, 0x01, 0x01, 0x01, 0x1E, 0x03, 0x42, 0x75, 0x01, 0x01, 0x2C, 0x41, 0x03, 0x64, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02,
  0x02, 0x02, 0x07, 0x09, 0x3F, 0x6E, 0x01, 0x01, 0x19, 0xB9, 0x03, 0xB8, 0x83, 0x01, 0x01, 0x68, 0x03, 0x0D, 0x6F, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02,
  0x02, 0x02, 0x07, 0x09, 0x03, 0x45, 0x16, 0x01, 0x01, 0x80, 0x49, 0x03, 0xBB, 0x01, 0x01, 0x01, 0x5F, 0x03, 0x44, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x56, 0x73, 0x01, 0x07, 0x02, 0x02,
  0x02, 0x02, 0x07, 0x09, 0x03, 0x03, 0x50, 0x22, 0x01, 0x01, 0x74, 0xB5, 0x03, 0xDE, 0x01, 0x01, 0x20, 0x4F, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x57, 0x01, 0x07, 0x02, 0x02,
  0x02, 0x02, 0x07, 0x09, 0x03, 0x03, 0x03, 0x61, 0x01, 0x01, 0x01, 0x65, 0x03, 0x1C, 0x2C, 0x01, 0x01, 0x7F, 0x1F, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x1F, 0x7E, 0x01, 0x07, 0x02, 0x02,
  0x02, 0x02, 0x07, 0x09, 0x03, 0x03, 0x03, 0x0D, 0x16, 0x01, 0x01, 0x01, 0x26, 0x03, 0x28, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02,
  0x02, 0x02, 0x07, 0x09, 0x03, 0x03, 0x03, 0x61, 0x01, 0x01, 0x01, 0x65, 0x03, 0x1C, 0x2B, 0x01, 0x01, 0x7F, 0x1F, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x1F, 0x7E, 0x01, 0x07, 0x02, 0x02,
  0x02, 0x02, 0x07, 0x09, 0x03, 0x03, 0x50, 0x22, 0x01, 0x01, 0x74, 0xB6, 0x03, 0xDD, 0x01, 0x01, 0x20, 0x4F, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x57, 0x01, 0x07, 0x02, 0x02,
  0x02, 0x02, 0x07, 0x09, 0x03, 0x45, 0x16, 0x01, 0x01, 0x80, 0x49, 0x03, 0x27, 0x01, 0x01, 0x01, 0x5F, 0x03, 0x44, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x56, 0x73, 0x01, 0x07, 0x02, 0x02,
  0x02, 0x02, 0x07, 0x09, 0x3F, 0x6E, 0x01, 0x01, 0x19, 0xBA, 0x03, 0xB7, 0x83, 0x01, 0x01, 0x68, 0x03, 0x0D, 0x6F, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02,
  0x02, 0x02, 0x07, 0x09, 0x62, 0x01, 0x01, 0x01, 0x1E, 0x03, 0x42, 0x75, 0x01, 0x01, 0x2C, 0x41, 0x03, 0x64, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02,
  0x02, 0x02, 0x07, 0x22, 0x85, 0x01, 0x01, 0x72, 0x40, 0x03, 0x67, 0x01, 0x01, 0x82, 0x4B, 0x03, 0x54, 0x19, 0x01, 0xF6, 0x58, 0xA5, 0xA6, 0xBD, 0x79, 0x01, 0x76, 0xB4, 0x0B, 0x0B, 0x0B, 0xB3, 0xEE, 0x01, 0x17, 0xC7, 0xA9, 0xA3, 0xAF, 0xE4, 0x01, 0x01,
        0x01, 0xF0, 0x3D, 0xA4, 0xA7, 0x5B, 0xF8, 0x01, 0x01, 0x5C, 0x0B, 0x0B, 0x0B, 0x0B, 0xCD, 0x01, 0xD6, 0xB2, 0x0B, 0x0B, 0xBC, 0xD3, 0x0A, 0x01, 0x01, 0x07, 0x02, 0x02,
  0x02, 0x02, 0x07, 0x01, 0x01, 0x01, 0x7C, 0x48, 0x03, 0x28, 0x01, 0x01, 0x01, 0x55, 0x03, 0x26, 0x81, 0x01, 0x18, 0x35, 0x97, 0xD2, 0xCB, 0x8F, 0x9E, 0x01, 0xCE, 0x02, 0xAC, 0x13, 0x13, 0x29, 0x6D, 0x0E, 0xA1, 0x11, 0x29, 0xCA, 0x12, 0x0F, 0xDA, 0x01,
        0xE9, 0x24, 0x98, 0xC5, 0x5B, 0x33, 0x93, 0x0A, 0x0A, 0x0F, 0x99, 0x13, 0x13, 0x13, 0xD1, 0x01, 0x9D, 0x8B, 0x59, 0x59, 0xA8, 0x02, 0x2A, 0x01, 0x01, 0x07, 0x02, 0x02,
  0x02, 0x02, 0x07, 0x01, 0x01, 0x19, 0x52, 0x03, 0x4D, 0x84, 0x01, 0x01, 0x1E, 0x03, 0x1C, 0x2B, 0x01, 0x01, 0x0E, 0x88, 0xA2, 0xF1, 0x18, 0x77, 0x6B, 0x01, 0x15, 0x02, 0xEB, 0x0A, 0x0A, 0x18, 0x01, 0xD5, 0x02, 0xC9, 0x01, 0x01, 0x17, 0x2A, 0x77, 0x01,
        0x3A, 0x1B, 0x7A, 0x01, 0x01, 0x6C, 0xCC, 0x01, 0x21, 0x02, 0xB0, 0x0A, 0x0A, 0x0A, 0x01, 0x01, 0x12, 0x36, 0x01, 0x01, 0x04, 0x02, 0xB1, 0x01, 0x01, 0x07, 0x02, 0x02,
  0x02, 0x02, 0x07, 0x01, 0x01, 0x63, 0x03, 0x43, 0xFA, 0x01, 0x01, 0x71, 0x0D, 0x03, 0x66, 0x01, 0x01, 0x01, 0x01, 0xC4, 0x1B, 0x02, 0x8E, 0xAB, 0xD9, 0x01, 0x15, 0x02, 0x02, 0x02, 0x02, 0x32, 0x7D, 0x14, 0x02, 0x6D, 0x01, 0xE6, 0x14, 0x14, 0xD4, 0x01,
        0x8C, 0x9F, 0x01, 0x01, 0x2A, 0x14, 0x5A, 0xF2, 0x21, 0x02, 0x02, 0x02, 0x02, 0x02, 0xD0, 0x01, 0x12, 0x1B, 0x3B, 0x3B, 0x39, 0x91, 0xED, 0x01, 0x01, 0x07, 0x02, 0x02,
  0x02, 0x02, 0x07, 0x01, 0x70, 0x0D, 0x3E, 0xDF, 0x01, 0x01, 0x16, 0x46, 0x03, 0xDB, 0x01, 0x01, 0x01, 0x01, 0x01, 0x04, 0xFF, 0xE7, 0xC2, 0x95, 0x0F, 0x6C, 0x15, 0x02, 0x5E, 0x08, 0x08, 0x0C, 0x01, 0xC3, 0x02, 0xE2, 0x01, 0xE1, 0x3C, 0x92, 0x38, 0x01,
        0x94, 0x35, 0x01, 0x01, 0x14, 0x25, 0x02, 0x5D, 0x21, 0x02, 0x25, 0x08, 0x08, 0x76, 0x0E, 0x01, 0x12, 0x8D, 0xC0, 0xBF, 0xA0, 0x89, 0xE8, 0x01, 0x01, 0x07, 0x02, 0x02,
  0x02, 0x02, 0x07, 0x10, 0x47, 0x03, 0x60, 0x01, 0x01, 0x01, 0x53, 0x03, 0x4E, 0x10, 0x01, 0x01, 0x01, 0x01, 0x18, 0x33, 0xAE, 0x0E, 0x01, 0x15, 0x02, 0xE3, 0x15, 0x02, 0x5E, 0x76, 0x76, 0x76, 0xFF, 0xF3, 0x11, 0x9C, 0xF7, 0x01, 0x6B, 0x1B, 0x38, 0x01,
        0x5A, 0x02, 0x5C, 0x0E, 0x17, 0x58, 0x02, 0x5D, 0x21, 0x02, 0x25, 0x76, 0x76, 0x76, 0x79, 0x01, 0x12, 0x36, 0x01, 0x01, 0x6A, 0x02, 0xC8, 0x01, 0x01, 0x07, 0x02, 0x02,
  0x02, 0x02, 0x07, 0x20, 0x4C, 0x51, 0x10, 0x01, 0x01, 0x01, 0x27, 0x4A, 0x7B, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xC6, 0x24, 0x32, 0x90, 0x0F, 0xAD, 0x0A, 0xD7, 0x02, 0x02, 0x02, 0x02, 0x02, 0x3D, 0x01, 0xD8, 0x34, 0x0F, 0x31, 0x31, 0xAA, 0x39, 0x01,
        0x0E, 0x3C, 0x0F, 0x11, 0x8A, 0x9B, 0x96, 0xCF, 0x18, 0x34, 0x02, 0x02, 0x02, 0x02, 0x24, 0x17, 0x3A, 0x9A, 0x01, 0x01, 0x78, 0x23, 0x29, 0x01, 0x01, 0x07, 0x02, 0x02,
  0x02, 0x02, 0x07, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xFE, 0xE5, 0x69, 0xF5, 0x01, 0x01, 0x01, 0xF9, 0x0C, 0x0C, 0x0C, 0x0C, 0x0E, 0x01, 0x01, 0x17, 0xEA, 0x6A, 0xFC, 0xFF, 0xEF, 0x01,
        0x01, 0x01, 0x78, 0x69, 0xEC, 0x0A, 0x08, 0xFD, 0x01, 0x2D, 0x0C, 0x0C, 0x0C, 0x0C, 0x04, 0x01, 0x07, 0x7A, 0x01, 0x01, 0x01, 0xF4, 0x2D, 0x01, 0x01, 0x07, 0x02, 0x02,
  0x02, 0x02, 0x07, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x07, 0x02, 0x02,
  0x11, 0x02, 0x1D, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x1D, 0x02, 0x11,
  0x23, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23,
  0x87, 0x2F, 0x1A, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x1A, 0x86, 0x86
};

GUI_CONST_STORAGE GUI_BITMAP bmSeggerLogo70x35 = {
  70, /* XSize */
  35, /* YSize */
  70, /* BytesPerLine */
  8, /* BitsPerPixel */
  acSeggerLogo70x35,  /* Pointer to picture data (indices) */
  &PalSeggerLogo70x35, /* Pointer to palette */
  NULL,  /* Pointer to methods */
};

/*************************** End of file ****************************/
