/*********************************************************************
*                SEGGER Microcontroller GmbH & Co. KG                *
*        Solutions for real time microcontroller applications        *
**********************************************************************
*                                                                    *
*        (c) 1996 - 2016  SEGGER Microcontroller GmbH & Co. KG       *
*                                                                    *
*        Internet: www.segger.com    Support:  support@segger.com    *
*                                                                    *
**********************************************************************

** emWin V5.34 - Graphical user interface for embedded applications **
All  Intellectual Property rights  in the Software belongs to  SEGGER.
emWin is protected by  international copyright laws.  Knowledge of the
source code may not be used to write a similar product.  This file may
only be used in accordance with the following terms:

The  software has  been licensed  to Silicon Labs Norway, a subsidiary
of Silicon Labs Inc. whose registered office is 400 West Cesar Chavez,
Austin,  TX 78701, USA solely for  the purposes of creating  libraries 
for its  ARM Cortex-M3, M4F  processor-based devices,  sublicensed and 
distributed  under the  terms and conditions  of the  End User License  
Agreement supplied by Silicon Labs.
Full source code is available at: www.segger.com

We appreciate your understanding and fairness.
----------------------------------------------------------------------
Licensing information

Licensor:                 SEGGER Software GmbH
Licensed to:              Silicon Laboratories Norway
Licensed SEGGER software: emWin
License number:           GUI-00140
License model:            See Agreement, dated 20th April 2012
Licensed product:         - 
Licensed platform:        Cortex M3, Cortex M4F
Licensed number of seats: -
----------------------------------------------------------------------
File        : VSCREEN_RealTime.c
Purpose     : Demonstrates how to use virtual screens.

              The sample requires a display size of 320 x 240 and at
              least a virtual Y size of 480 pixels. The reccomended
              color depth is 8bpp.

              Required configuration:

              #define LCD_XSIZE        320
              #define LCD_YSIZE        240
              #define LCD_VYSIZE       480

              To find the part of the code, which switches between the
              screens, please search the function GUI_SetOrg().
----------------------------------------------------------------------
*/

#include <stddef.h>
#include <stdlib.h>
#include <string.h>

#include "DIALOG.h"
#include "PROGBAR.h"
#include "LCDConf.h"
#include "touch.h"

/*********************************************************************
*
*       Defines
*
**********************************************************************
*/
#define ID_TEMPERATURE (GUI_ID_USER + 0)

#define ID_WINDOW_0 (GUI_ID_USER + 1)
#define ID_TEXT_0 (GUI_ID_USER + 2)

/*********************************************************************
*
*          Static data
*
**********************************************************************
*/

/* Calibration screen */
static const GUI_WIDGET_CREATE_INFO _aDialogCreate[] = {
  { WINDOW_CreateIndirect, "Calibration", ID_WINDOW_0, 0, 0, 320, 240, 0, 0, 0 },
  { TEXT_CreateIndirect, "Instruction", ID_TEXT_0, 22, 62, 270, 20, 0, 100, 0 },
};

/* Logo bitmap: colors */
static GUI_CONST_STORAGE GUI_COLOR _ColorsLogoSegger[] = {
   0x0000FF,0x280000,0x500000,0x780000
  ,0xA00000,0xCCCDCD,0xF4F4F4,0xFFFFFF
  ,0xFFCACA,0xFF0000,0xFF9191,0xFF5656
  ,0x9FA0A2,0x606264,0x000000,0x1F1F1F
};

/* Logo bitmap: palette */
static GUI_CONST_STORAGE GUI_LOGPALETTE _PalLogoSegger = {
  16,	/* number of entries */
  1, 	/* Has transparency */
  &_ColorsLogoSegger[0]
};

/* Logo bitmap: pixel data */
static GUI_CONST_STORAGE unsigned char _acLogoSegger[] = {
  0x00, 0x12, 0x34, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x43, 0x21, 0x00,
  0x02, 0x34, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x43, 0x20,
  0x13, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x31,
  0x24, 0x44, 0x56, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x65, 0x44, 0x42,
  0x34, 0x45, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x54, 0x43,
  0x44, 0x46, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x77, 0x76, 0x67, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x67, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x77, 0x89, 0x9A, 0x77, 0x77, 0x77, 0x77, 0x77, 0x69, 0x9A, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x76, 0x99, 0x99, 0x87, 0x77, 0x77, 0x77, 0x77, 0x99, 0x99, 0xA7, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x76, 0x99, 0x99, 0x96, 0x77, 0x77, 0x77, 0x77, 0x99, 0x99, 0x98, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x77, 0xA9, 0x99, 0x9B, 0x77, 0x77, 0x77, 0x77, 0x89, 0x99, 0x99, 0x67, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x77, 0x7B, 0x99, 0x99, 0xA7, 0x77, 0x77, 0x77, 0x7A, 0x99, 0x99, 0xA7, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x77, 0x76, 0x99, 0x99, 0x98, 0x77, 0x77, 0x77, 0x77, 0xB9, 0x99, 0x98, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x77, 0x77, 0x89, 0x99, 0x99, 0x67, 0x77, 0x77, 0x77, 0x89, 0x99, 0x99, 0x67, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x77, 0x77, 0x7A, 0x99, 0x99, 0xB7, 0x77, 0x77, 0x77, 0x7A, 0x99, 0x99, 0xB7, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x77, 0x77, 0x77, 0xB9, 0x99, 0x9A, 0x77, 0x77, 0x77, 0x77, 0xB9, 0x99, 0x9A, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x77, 0x77, 0x77, 0x69, 0x99, 0x99, 0x87, 0x77, 0x77, 0x77, 0x69, 0x99, 0x99, 0x87, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x77, 0x77, 0x77, 0x78, 0x99, 0x99, 0x96, 0x77, 0x77, 0x77, 0x78, 0x99, 0x99, 0xB6, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x77, 0x77, 0x77, 0x77, 0xA9, 0x99, 0x9A, 0x77, 0x77, 0x77, 0x77, 0xA9, 0x99, 0x9A, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x77, 0x77, 0x77, 0x77, 0x6B, 0x99, 0x99, 0xA7, 0x77, 0x77, 0x77, 0x6B, 0x99, 0x99, 0x87, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x66, 0x77, 0x77, 0x77, 0x76, 0x99, 0x99, 0x98, 0x77, 0x77, 0x77, 0x78, 0x99, 0x99, 0x96, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x6B, 0x67, 0x77, 0x77, 0x77, 0x89, 0x99, 0x99, 0x67, 0x77, 0x77, 0x77, 0xA9, 0x99, 0x9B, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x69, 0xB6, 0x77, 0x77, 0x77, 0x7A, 0x99, 0x99, 0xB7, 0x77, 0x77, 0x77, 0x7B, 0x99, 0x99, 0xA7, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x79, 0x9A, 0x77, 0x77, 0x77, 0x76, 0xB9, 0x99, 0x9A, 0x77, 0x77, 0x77, 0x76, 0x99, 0x99, 0x98, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x69, 0x99, 0x87, 0x77, 0x77, 0x77, 0x69, 0x99, 0x99, 0x87, 0x77, 0x77, 0x77, 0x89, 0x99, 0x9B, 0x67, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x79, 0x99, 0x96, 0x77, 0x77, 0x77, 0x78, 0x99, 0x99, 0x96, 0x77, 0x77, 0x77, 0x7A, 0x99, 0x99, 0xA7, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x69, 0x99, 0x9B, 0x77, 0x77, 0x77, 0x77, 0xA9, 0x99, 0x9B, 0x77, 0x77, 0x77, 0x76, 0xB9, 0x99, 0x98, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x79, 0x99, 0x99, 0xA7, 0x77, 0x77, 0x77, 0x6B, 0x99, 0x99, 0xA7, 0x77, 0x77, 0x77, 0x89, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x98, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x69, 0x99, 0x99, 0x98, 0x77, 0x77, 0x77, 0x76, 0x99, 0x99, 0x98, 0x77, 0x77, 0x77, 0x7A, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x67, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x79, 0x99, 0x99, 0x99, 0x67, 0x77, 0x77, 0x77, 0x89, 0x99, 0x99, 0x67, 0x77, 0x77, 0x77, 0xB9, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x67, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x69, 0x99, 0x99, 0x99, 0xB7, 0x77, 0x77, 0x77, 0x7A, 0x99, 0x99, 0xB7, 0x77, 0x77, 0x77, 0x69, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x9A, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x79, 0x99, 0x99, 0x99, 0x9A, 0x77, 0x77, 0x77, 0x76, 0xB9, 0x99, 0x98, 0x77, 0x77, 0x77, 0x77, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x67, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x69, 0x99, 0x99, 0x99, 0x9A, 0x77, 0x77, 0x77, 0x77, 0xB9, 0x99, 0x98, 0x77, 0x77, 0x77, 0x77, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x87, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x79, 0x99, 0x99, 0x99, 0xB7, 0x77, 0x77, 0x77, 0x7A, 0x99, 0x99, 0xB7, 0x77, 0x77, 0x77, 0x6B, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x9A, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x69, 0x99, 0x99, 0x99, 0x67, 0x77, 0x77, 0x77, 0x89, 0x99, 0x99, 0x77, 0x77, 0x77, 0x77, 0xB9, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x67, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x79, 0x99, 0x99, 0x98, 0x77, 0x77, 0x77, 0x76, 0x99, 0x99, 0x98, 0x77, 0x77, 0x77, 0x7A, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x67, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x69, 0x99, 0x99, 0xA7, 0x77, 0x77, 0x77, 0x7B, 0x99, 0x99, 0xA7, 0x77, 0x77, 0x77, 0x89, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x98, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x79, 0x99, 0x9B, 0x77, 0x77, 0x77, 0x77, 0xA9, 0x99, 0x9B, 0x77, 0x77, 0x77, 0x76, 0xB9, 0x99, 0x98, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x69, 0x99, 0x96, 0x77, 0x77, 0x77, 0x78, 0x99, 0x99, 0x97, 0x77, 0x77, 0x77, 0x7A, 0x99, 0x99, 0xA7, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x79, 0x99, 0x87, 0x77, 0x77, 0x77, 0x69, 0x99, 0x99, 0x87, 0x77, 0x77, 0x77, 0x89, 0x99, 0x9B, 0x67, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x69, 0x9A, 0x77, 0x77, 0x77, 0x77, 0xB9, 0x99, 0x9A, 0x77, 0x77, 0x77, 0x76, 0x99, 0x99, 0x98, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x79, 0xB7, 0x77, 0x77, 0x77, 0x7A, 0x99, 0x99, 0xB7, 0x77, 0x77, 0x77, 0x7B, 0x99, 0x99, 0xA7, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x6B, 0x67, 0x77, 0x77, 0x77, 0x89, 0x99, 0x99, 0x67, 0x77, 0x77, 0x77, 0xA9, 0x99, 0x9B, 0x77, 0x77, 0x77, 0x75, 0xCC, 0xDC, 0xC6, 0x77, 0x77, 0x77, 0x55, 0x55, 0x55, 0x55, 0x55, 0x67, 0x77, 0x77, 0x75, 0xCC, 0xDC, 0xC6, 0x77, 0x77, 0x77, 0x77, 0x76, 0x5C, 0xDC, 0xCC, 0x67, 0x77, 0x77, 0x77, 0x55, 0x55, 0x55, 0x55, 0x55, 0x77, 0x77, 0x55, 0x55, 0x55, 0x55, 0x67, 0x77, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x66, 0x77, 0x77, 0x77, 0x76, 0x99, 0x99, 0x98, 0x77, 0x77, 0x77, 0x78, 0x99, 0x99, 0x96, 0x77, 0x77, 0x75, 0xDE, 0xEE, 0xEE, 0xEE, 0xC6, 0x77, 0x7C, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xD7, 0x77, 0x75, 0xDE, 0xEE, 0xEE, 0xEE, 0xD6, 0x77, 0x77, 0x77, 0xCE, 0xEE, 0xEE, 0xEE, 0xEC, 0x77, 0x77, 0x7D, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xC7, 0x7C, 0xEE, 0xEE, 0xEE, 0xEE, 0xED, 0x57, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x77, 0x77, 0x77, 0x77, 0x7B, 0x99, 0x99, 0xA7, 0x77, 0x77, 0x77, 0x6B, 0x99, 0x99, 0x87, 0x77, 0x77, 0x6E, 0xEE, 0xED, 0xDD, 0xEE, 0xED, 0x77, 0x7D, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xD7, 0x77, 0xCE, 0xEE, 0xED, 0xDE, 0xEE, 0xED, 0x67, 0x77, 0x7D, 0xEE, 0xEE, 0xDD, 0xEE, 0xEE, 0xD7, 0x77, 0x6F, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xC7, 0x7D, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xE5, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x77, 0x77, 0x77, 0x77, 0xA9, 0x99, 0x9B, 0x77, 0x77, 0x77, 0x77, 0xA9, 0x99, 0x9A, 0x77, 0x77, 0x77, 0xCE, 0xED, 0x67, 0x76, 0xCE, 0xEE, 0x67, 0x7D, 0xEE, 0xD5, 0x55, 0x55, 0x55, 0x77, 0x75, 0xEE, 0xED, 0x56, 0x76, 0xCE, 0xEE, 0xC7, 0x77, 0xCE, 0xEE, 0xD6, 0x67, 0x6C, 0xEE, 0xE5, 0x77, 0x6D, 0xEE, 0xC5, 0x55, 0x55, 0x56, 0x77, 0x6D, 0xEE, 0xC5, 0x55, 0x5C, 0xEE, 0xED, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x77, 0x77, 0x77, 0x78, 0x99, 0x99, 0x96, 0x77, 0x77, 0x77, 0x78, 0x99, 0x99, 0xB6, 0x77, 0x77, 0x77, 0xDE, 0xED, 0x77, 0x77, 0x75, 0xDC, 0x77, 0x7D, 0xEE, 0xC7, 0x77, 0x77, 0x77, 0x77, 0x7D, 0xEE, 0xD7, 0x77, 0x77, 0x7C, 0xED, 0x57, 0x76, 0xDE, 0xED, 0x77, 0x77, 0x77, 0xCE, 0xD6, 0x77, 0x6F, 0xEE, 0x57, 0x77, 0x77, 0x77, 0x77, 0x7D, 0xEE, 0xC7, 0x77, 0x77, 0xCE, 0xED, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x77, 0x77, 0x77, 0x69, 0x99, 0x99, 0x87, 0x77, 0x77, 0x77, 0x69, 0x99, 0x99, 0x87, 0x77, 0x77, 0x77, 0xCE, 0xEE, 0xDC, 0x56, 0x77, 0x77, 0x77, 0x7D, 0xEE, 0xC6, 0x66, 0x66, 0x67, 0x77, 0x6E, 0xEE, 0xC7, 0x77, 0x77, 0x77, 0x77, 0x77, 0x75, 0xEE, 0xE5, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x7F, 0xEE, 0xC6, 0x66, 0x66, 0x67, 0x77, 0x6D, 0xEE, 0xC7, 0x77, 0x77, 0xDE, 0xED, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x77, 0x77, 0x77, 0xB9, 0x99, 0x9A, 0x77, 0x77, 0x77, 0x77, 0xB9, 0x99, 0x9A, 0x77, 0x77, 0x77, 0x77, 0x6D, 0xEE, 0xEE, 0xED, 0xDC, 0x67, 0x77, 0x7D, 0xEE, 0xEE, 0xEE, 0xEE, 0xED, 0x67, 0x5E, 0xEE, 0x67, 0x77, 0x76, 0x66, 0x66, 0x67, 0x7C, 0xEE, 0xE7, 0x77, 0x77, 0x66, 0x66, 0x67, 0x77, 0x6D, 0xEE, 0xEE, 0xEE, 0xEE, 0xEC, 0x67, 0x7D, 0xEE, 0xDC, 0xCC, 0xCD, 0xEE, 0xE5, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x77, 0x77, 0x7A, 0x99, 0x99, 0xB7, 0x77, 0x77, 0x77, 0x7A, 0x99, 0x99, 0xB7, 0x77, 0x77, 0x77, 0x77, 0x75, 0xCE, 0xEE, 0xEE, 0xEE, 0xEC, 0x77, 0x7D, 0xEE, 0xEE, 0xEE, 0xEE, 0xEF, 0x67, 0xCE, 0xEE, 0x67, 0x77, 0x5E, 0xEE, 0xEE, 0xD6, 0x7C, 0xEE, 0xD7, 0x77, 0x7C, 0xEE, 0xEE, 0xED, 0x67, 0x6F, 0xEE, 0xEE, 0xEE, 0xEE, 0xED, 0x77, 0x6D, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0x57, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x77, 0x77, 0x89, 0x99, 0x99, 0x67, 0x77, 0x77, 0x77, 0x89, 0x99, 0x99, 0x67, 0x77, 0x77, 0x77, 0x77, 0x77, 0x76, 0x5C, 0xDE, 0xEE, 0xEE, 0xC7, 0x7D, 0xEE, 0xD5, 0xC5, 0xC5, 0x55, 0x77, 0x5E, 0xEE, 0x57, 0x77, 0xCE, 0xEE, 0xEE, 0xE5, 0x7C, 0xEE, 0xE6, 0x77, 0x7C, 0xEE, 0xEE, 0xEE, 0x67, 0x6F, 0xEE, 0xCC, 0x55, 0xC5, 0x56, 0x77, 0x7D, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xC6, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x77, 0x76, 0x99, 0x99, 0x98, 0x77, 0x77, 0x77, 0x77, 0xB9, 0x99, 0x98, 0x77, 0x77, 0x77, 0x77, 0x77, 0x75, 0x57, 0x77, 0x77, 0xCE, 0xEE, 0xD7, 0x7D, 0xEE, 0xC7, 0x77, 0x77, 0x77, 0x77, 0x6E, 0xEE, 0xC7, 0x77, 0x75, 0x55, 0xDE, 0xE5, 0x75, 0xEE, 0xE5, 0x77, 0x76, 0x55, 0x5F, 0xEE, 0x67, 0x6D, 0xEE, 0x57, 0x77, 0x77, 0x77, 0x77, 0x6D, 0xEE, 0xC6, 0x66, 0x6C, 0xEE, 0xE5, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x77, 0x7B, 0x99, 0x99, 0xA7, 0x77, 0x77, 0x77, 0x7A, 0x99, 0x99, 0xA7, 0x77, 0x77, 0x77, 0x77, 0x77, 0xCE, 0xEC, 0x77, 0x77, 0x7C, 0xEE, 0xD6, 0x7D, 0xEE, 0xC7, 0x77, 0x77, 0x77, 0x77, 0x7D, 0xEE, 0xD6, 0x77, 0x77, 0x75, 0xEE, 0xE5, 0x77, 0xDE, 0xED, 0x67, 0x77, 0x77, 0xCE, 0xEE, 0x67, 0x6F, 0xEE, 0x57, 0x77, 0x77, 0x77, 0x77, 0x7D, 0xEE, 0xC7, 0x77, 0x76, 0xEE, 0xEC, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x77, 0xA9, 0x99, 0x9B, 0x77, 0x77, 0x77, 0x77, 0x89, 0x99, 0x99, 0x67, 0x77, 0x77, 0x77, 0x77, 0x77, 0xCE, 0xEE, 0xC6, 0x76, 0x5D, 0xEE, 0xD7, 0x7D, 0xEE, 0xDC, 0xCC, 0xCC, 0xCC, 0x57, 0x75, 0xEE, 0xED, 0xC6, 0x66, 0xCE, 0xEE, 0xE5, 0x77, 0x5E, 0xEE, 0xD5, 0x66, 0x5C, 0xEE, 0xEE, 0x67, 0x7F, 0xEE, 0xCC, 0xCC, 0xCC, 0xCC, 0x67, 0x6D, 0xEE, 0xC7, 0x77, 0x77, 0xEE, 0xEC, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x76, 0x99, 0x99, 0x96, 0x77, 0x77, 0x77, 0x77, 0xB9, 0x99, 0x98, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x6D, 0xEE, 0xEE, 0xDE, 0xEE, 0xEE, 0x67, 0x7D, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xF5, 0x77, 0x5E, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xE5, 0x77, 0x7C, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0x67, 0x6D, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xF7, 0x7F, 0xEE, 0xC7, 0x77, 0x77, 0xDE, 0xED, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x76, 0x99, 0x99, 0x87, 0x77, 0x77, 0x77, 0x77, 0xB9, 0x99, 0xA7, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x76, 0xCE, 0xEE, 0xEE, 0xEE, 0xD5, 0x77, 0x75, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xF5, 0x77, 0x75, 0xDE, 0xEE, 0xEE, 0xEC, 0x5E, 0xE5, 0x77, 0x77, 0xCD, 0xEE, 0xEE, 0xEE, 0xC5, 0xEE, 0x67, 0x7D, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xD7, 0x7D, 0xEE, 0x57, 0x77, 0x77, 0xCE, 0xEC, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x77, 0x89, 0x9A, 0x77, 0x77, 0x77, 0x77, 0x77, 0x6B, 0x9B, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x76, 0xCC, 0xCC, 0xC5, 0x77, 0x77, 0x77, 0x65, 0x55, 0x55, 0x55, 0x55, 0x67, 0x77, 0x77, 0x75, 0xCC, 0xCC, 0x67, 0x75, 0xC7, 0x77, 0x77, 0x77, 0x5C, 0xCC, 0xC6, 0x76, 0xC5, 0x77, 0x77, 0x65, 0x55, 0x55, 0x55, 0x55, 0x77, 0x76, 0x55, 0x77, 0x77, 0x77, 0x65, 0x56, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x77, 0x76, 0x67, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x67, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x34, 0x45, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x54, 0x43,
  0x24, 0x44, 0x56, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x65, 0x44, 0x42,
  0x13, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x31,
  0x02, 0x34, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x43, 0x20,
  0x00, 0x12, 0x34, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x43, 0x21, 0x00
};

/* Logo bitmap */
static GUI_CONST_STORAGE GUI_BITMAP _bmLogoBitmap = {
  140, /* XSize */
  66,  /* YSize */
  70,  /* BytesPerLine */
  4,   /* BitsPerPixel */
  _acLogoSegger,   /* Pointer to picture data (indices) */
  &_PalLogoSegger,  /* Pointer to palette */
  NULL,  /* Pointer to methods */
};

/* Resource for DialogIntro (0, 0) - (319, 239) */
static const GUI_WIDGET_CREATE_INFO _aDialogIntro[] = {
  { WINDOW_CreateIndirect,    "",                    0,                0,   0,   320, 240, 0, 0, 0},
  { BUTTON_CreateIndirect,    "Start",               GUI_ID_BUTTON0,   30,  210, 120, 20,  0, 0, 0},
  { BUTTON_CreateIndirect,    "Calibrate",           GUI_ID_BUTTON1,   170, 210, 120, 20,  0, 0, 0}
};

/* Resource for DialogMain (0, 0) - (319, 239) */
static const GUI_WIDGET_CREATE_INFO _aDialogMain[] = {
  { WINDOW_CreateIndirect,    "",                    0,                  0,   0, 320, 240, 0, 0, 0},
  { FRAMEWIN_CreateIndirect,  "Temperature",         ID_TEMPERATURE,     5,   5, 310, 145, 0, 0, 0},
  { TEXT_CreateIndirect,      "Temperature 1:",      GUI_ID_TEXT0,      10, 162,  80,   0, 0, 0, 0},
  { TEXT_CreateIndirect,      "Temperature 2:",      GUI_ID_TEXT1,      10, 187,  80,   0, 0, 0, 0},
  { TEXT_CreateIndirect,      "Min:",                GUI_ID_TEXT2,      10, 210,  50,   0, 0, 0, 0},
  { TEXT_CreateIndirect,      "Max:",                GUI_ID_TEXT3,     110, 210,  50,   0, 0, 0, 0},
  { PROGBAR_CreateIndirect,   "",                    GUI_ID_PROGBAR0,   90, 160, 100,  18, 0, 0, 0},
  { PROGBAR_CreateIndirect,   "",                    GUI_ID_PROGBAR1,   90, 185, 100,  18, 0, 0, 0},
  { EDIT_CreateIndirect,      "",                    GUI_ID_EDIT0,      50, 210,  40,  18, 3, 3, 0},
  { EDIT_CreateIndirect,      "",                    GUI_ID_EDIT1,     150, 210,  40,  18, 3, 3, 0},
  { BUTTON_CreateIndirect,    "Set color",           GUI_ID_BUTTON0,   210, 185, 100,  20, 0, 0, 0},
  { BUTTON_CreateIndirect,    "Start",               GUI_ID_BUTTON1,   210, 210, 100,  20, 0, 0, 0},
};

/* Resource for DialogColor (0, 240) - (319, 479) */
static const GUI_WIDGET_CREATE_INFO _aDialogColor[] = {
  { FRAMEWIN_CreateIndirect, "Adjust color",         0,                 10, 260, 300, 200, 0, 0, 0},
  { TEXT_CreateIndirect,     "Color to be changed:", 0,                  5,  15, 100,  20, TEXT_CF_LEFT, 0, 0},
  { DROPDOWN_CreateIndirect,  "",                    GUI_ID_DROPDOWN0, 120,  15, 150,  60, 0, 0, 0},
  { TEXT_CreateIndirect,     "Red:" ,                0,                  5,  60,  35,  20, TEXT_CF_LEFT, 0, 0 },
  { TEXT_CreateIndirect,     "Green:",               0,                  5,  90,  35,  20, TEXT_CF_LEFT, 0, 0 },
  { TEXT_CreateIndirect,     "Blue:",                0,                  5, 120,  35,  20, TEXT_CF_LEFT, 0, 0 },
  { TEXT_CreateIndirect,     "Preview",              0,                205,  44,  81,  15, TEXT_CF_HCENTER, 0, 0 },
  { SLIDER_CreateIndirect,   NULL,                   GUI_ID_SLIDER0,    40,  60, 100,  20, 0, 0, 0 },
  { SLIDER_CreateIndirect,   NULL,                   GUI_ID_SLIDER1,    40,  90, 100,  20, 0, 0, 0 },
  { SLIDER_CreateIndirect,   NULL,                   GUI_ID_SLIDER2,    40, 120, 100,  20, 0, 0, 0 },
  { EDIT_CreateIndirect,     NULL,                   GUI_ID_EDIT0,     145,  60,  30,  20, 0, 3, 0 },
  { EDIT_CreateIndirect,     NULL,                   GUI_ID_EDIT1,     145,  90,  30,  20, 0, 3, 0 },
  { EDIT_CreateIndirect,     NULL,                   GUI_ID_EDIT2,     145, 120,  30,  20, 0, 3, 0 },
  { BUTTON_CreateIndirect,   "Ok",                   GUI_ID_OK,         90, 150, 120,  20, 0, 0, 0 },
};

/* Text shown in the DialogIntro dialog */
static const char * _apDialogIntro[] = {
  "This sample demonstrates how to use virtual screens.",
  "Virtual screens require additional video memory and",
  "and allow instantanious switching between different",
  "screens, even on slow CPUs.",
  "Press the <Start> button to run example,",
  "or <Calibrate> to calibrate touch panel."
};

/* Dialog handles */
WM_HWIN _hDialogMain, _hDialogColor;

/* Red, green and blue components of color dialog */
static U8 _aColorSep[3] = {255, 127, 0};

/* Pointer to original callback routine of the temperature window */
static WM_CALLBACK * _pcbCallbackTemperature;

/* Maximum ranges of temperature */
static int _TempMin = 120, _TempMax = 220;

/* Colors to be used in temperature window */
GUI_COLOR _ColorBackGround = GUI_RED;
GUI_COLOR _ColorGrid       = GUI_DARKGRAY;
GUI_COLOR _ColorLabel      = GUI_WHITE;
GUI_COLOR _ColorTemp1      = GUI_DARKGREEN;
GUI_COLOR _ColorTemp2      = GUI_BLUE;

/* Index of color modified in color dialog */
static int _ColorIndex;

/* Arrays of temperature values */
static I16 _aTemp1[277], _aTemp2[277];

/*********************************************************************
*
*          Static code
*
**********************************************************************
*/
static I16 _GetRandomValue(I16 Old) {
  int MaxValue, yD, MaxDiff = 2;
  I16 yNew;
  MaxValue = _TempMax - _TempMin;
  yD = MaxDiff - (rand() % MaxDiff);
  if (rand() & 128) {
    yNew = Old + yD;
  } else {
    yNew = Old - yD;
  }
  if (yNew > MaxValue) {
    yNew -= yD;
  } else { if (yNew < 0)
    yNew += yD;
  }
  return yNew;
}

static void _SelectScreen(int screen)
{
  GUI_PID_STATE curPos;
  
  /* set origin according to required screen */
  GUI_SetOrg(0, 240*screen);
  /* this operation is done to simply redraw curor */
  GUI_PID_GetState(&curPos);
  GUI_PID_StoreState(&curPos);
}

/*********************************************************************
*
*       _InitRandomData
*/
static void _InitRandomData(I16 * paY, int n) {
  int i, MaxValue;
  MaxValue = _TempMax - _TempMin;
  for (i = 0; i < n; i++) {
    if (!i) {
      paY[i] = rand() % MaxValue;
    } else {
      paY[i] = _GetRandomValue(paY[i-1]);
    }
  }
}

/*********************************************************************
*
*       _SaveColorSep
*/
static void _SaveCurrentColor(void) {
  GUI_COLOR Color = _aColorSep[0] | (((U32)_aColorSep[1]) << 8) | (((U32)_aColorSep[2]) << 16);
  switch (_ColorIndex) {
  case 0: _ColorBackGround = Color; break;
  case 1: _ColorGrid       = Color; break;
  case 2: _ColorLabel      = Color; break;
  case 3: _ColorTemp1      = Color; break;
  case 4: _ColorTemp2      = Color; break;
  }
}

/*********************************************************************
*
*       _cbDialog
*/
static void _cbDialog(WM_MESSAGE * pMsg) {
  WM_HWIN hItem;
  static int point = 0;
  static U8 PressedPrev = 0;
  const POINT Points[3] = { {40, 40}, {280, 120}, {160, 200} }; /* calibration points on screen */
  static POINT PointsScr[3];

  // USER START (Optionally insert additional variables)
  // USER END

  switch (pMsg->MsgId) {
  case WM_INIT_DIALOG:
    //
    // Initialization of 'Calibration'
    //
    hItem = pMsg->hWin;
    WINDOW_SetBkColor(hItem, 0x00000000);
    //
    // Initialization of 'Instruction'
    //
    hItem = WM_GetDialogItem(pMsg->hWin, ID_TEXT_0);
    TEXT_SetText(hItem, "Press calibration point");
    TEXT_SetTextColor(hItem, 0x0080FFFF);
    TEXT_SetTextAlign(hItem, GUI_TA_HCENTER | GUI_TA_VCENTER);
    TEXT_SetFont(hItem, GUI_FONT_16_1);
    GUI_CURSOR_Select(&GUI_CursorCrossM);
    GUI_CURSOR_SetPosition(Points[0].x, Points[0].y);
    GUI_CURSOR_Show();
    point = 0;
    PressedPrev = 0;
    /* draw first cross here */
    // USER START (Optionally insert additional code for further widget initialization)
  case WM_TOUCH:
  case WM_TOUCH_CHILD:
    { TOUCH_Pos_TypeDef *pos = TOUCH_GetPos();  /* get information from touchpanel */
      GUI_PID_STATE *pInfo;
      pInfo = (GUI_PID_STATE *)pMsg->Data.p;
      switch(point)
      { case 0:
        case 1:
        case 2: GUI_CURSOR_SetPosition(Points[point].x, Points[point].y); break;
       default: GUI_CURSOR_Select(&GUI_CursorArrowM);
                GUI_EndDialog(pMsg->hWin, 0);
      }
      if(pInfo->Layer==0)
      {
        if( (pos->pen == 1) && (PressedPrev==0) )
        {
          PointsScr[point].x = pos->adcx;
          PointsScr[point].y = pos->adcy;
          if(point==2)
          {
            TOUCH_CalibrationTable((POINT *)Points, PointsScr);
          }
          point++;
        }
        PressedPrev = pos->pen;
      }
    }

    // USER END
    break;
  // USER START (Optionally insert additional message handling)
  // USER END
  default:
    WM_DefaultProc(pMsg);
    break;
  }
}

/*********************************************************************
*
*       _UpdateTextColors
*/
static void _UpdateTextColors(WM_HWIN hDlg) {
  WM_HWIN hItem;
  hItem = WM_GetDialogItem(hDlg, GUI_ID_TEXT0);
  TEXT_SetTextColor(hItem, _ColorTemp1);
  hItem = WM_GetDialogItem(hDlg, GUI_ID_TEXT1);
  TEXT_SetTextColor(hItem, _ColorTemp2);
}

/*******************************************************************
*
*       _DrawGraph
*/
static void _DrawGraph(void) {
  GUI_RECT Rect;
  int xSize, ySize, x, y;
  WM_GetClientRect(&Rect);
  xSize = Rect.x1;
  ySize = Rect.y1;
  GUI_SetBkColor(GUI_BLACK);
  GUI_ClearRect(26, 1, 302, ySize - 21);
  GUI_SetColor(_ColorGrid);
  for (y = 20; y < (ySize - 21); y += 20) {
    int yPos = ySize - 20 - y;
    GUI_DrawHLine(yPos, 26, 302);
  }
  for (x = 40; x < (xSize - 25); x += 40) {
    int xPos = x + 25;
    GUI_DrawVLine(xPos, 1, ySize - 21);
  }
  GUI_SetColor(_ColorTemp1);
  GUI_DrawGraph(_aTemp1, GUI_COUNTOF(_aTemp1), 26, ySize - 121);
  GUI_SetColor(_ColorTemp2);
  GUI_DrawGraph(_aTemp2, GUI_COUNTOF(_aTemp2), 26, ySize - 121);
}

/*********************************************************************
*
*       _LabelGraph
*/
static void _LabelGraph(void) {
  GUI_RECT Rect;
  int x, y, xSize, ySize;
  WM_GetClientRect(&Rect);
  xSize = Rect.x1;
  ySize = Rect.y1;
  GUI_SetBkColor(_ColorBackGround);
  GUI_Clear();
  GUI_SetColor(_ColorLabel);
  GUI_SetPenSize(1);
  GUI_ClearRect(0, (ySize - 21) - ySize, (xSize - 1), (ySize - 1));
  GUI_DrawRect(25, 0, xSize, ySize - 20);
  GUI_SetFont(&GUI_Font6x8);
  for (x = 0; x < (xSize - 20); x += 40) {
    int xPos = x + 25;
    GUI_DrawVLine(xPos, (ySize - 20), (ySize - 14));
    GUI_DispDecAt(x / 40, xPos - 2, (ySize - 9), 1);
  }
  for (y = 0; y < ySize - 20; y += 20) {
    int yPos = ySize - 20 - y;
    GUI_DrawHLine(yPos, 20, 25);
    GUI_GotoXY(1, yPos - 4);
    GUI_DispDecSpace(_TempMin + y, 3);
  }
}

/*********************************************************************
*
*       _SetProgbarValue
*/
static void _SetProgbarValue(int Id, I16 Value) {
  char acBuffer[6] = {"   "};
  WM_HWIN hItem;
  hItem = WM_GetDialogItem(_hDialogMain, Id);
  PROGBAR_SetValue(hItem, 100 - Value);
  Value = 100 - Value + _TempMin;
  acBuffer[2] = '0' + Value % 10;
  acBuffer[1] = (Value >=  10) ? '0' + (Value % 100) /  10 : ' ';
  acBuffer[0] = (Value >= 100) ? '0' + Value / 100 : ' ';
  PROGBAR_SetText(hItem, acBuffer);
}

/*********************************************************************
*
*       _cbDialogIntro
*
* Purpose:
*   Callback routine of DialogIntro
*/
static void _cbDialogIntro(WM_MESSAGE * pMsg) {
  WM_HWIN hDlg;
  GUI_RECT Rect;
  int Id, i, ySizeText, yPos = 40;
  hDlg = pMsg->hWin;
  switch (pMsg->MsgId) {
  case WM_PAINT:
    WM_GetClientRect(&Rect);
    GUI_SetBkColor(GUI_WHITE);
    GUI_SetColor(GUI_BLACK);
    GUI_Clear();
    GUI_SetFont(&GUI_Font24_ASCII);
    GUI_DispStringHCenterAt("Virtual screens", 160, 5);
    GUI_SetFont(&GUI_Font13B_ASCII);
    GUI_DrawBitmap(&_bmLogoBitmap, (Rect.x1 - _bmLogoBitmap.XSize) / 2, yPos);
    ySizeText = GUI_GetFontSizeY();
    yPos += _bmLogoBitmap.YSize + 15;
    for (i = 0; i < (int)GUI_COUNTOF(_apDialogIntro); i++) {
      GUI_DispStringHCenterAt(_apDialogIntro[i], Rect.x1 / 2, yPos);
      yPos += ySizeText;
    }
    break;
  case WM_NOTIFY_PARENT:
    if (pMsg->Data.v == WM_NOTIFICATION_RELEASED) {
      Id = WM_GetId(pMsg->hWinSrc);      /* Id of widget */
      if (Id == GUI_ID_BUTTON0) {
        GUI_EndDialog(hDlg, 0);
      }
      if (Id == GUI_ID_BUTTON1) {
        GUI_ExecDialogBox(_aDialogCreate, GUI_COUNTOF(_aDialogCreate), &_cbDialog, WM_HBKWIN, 0, 0);
      }
    }
    break;
  default:
    WM_DefaultProc(pMsg);
  }
}

/*********************************************************************
*
*       _cbDialogColor
*
* Purpose:
*   Callback routine of DialogColor
*/
static void _cbDialogColor(WM_MESSAGE * pMsg) {
  GUI_COLOR Color = _ColorBackGround;
  int i;
  int NCode, Id;
  WM_HWIN hDlg, hItem;
  hDlg = pMsg->hWin;
  switch (pMsg->MsgId) {
  case WM_PAINT:
    /* Draw RGB values */
    GUI_SetColor(_aColorSep[0]);
    GUI_FillRect(180,  60, 199,  79);
    GUI_SetColor(_aColorSep[1] << 8);
    GUI_FillRect(180,  90, 199, 109);
    GUI_SetColor(((U32)_aColorSep[2]) << 16);
    GUI_FillRect(180, 120, 199, 139);
    /* Draw resulting color */
    GUI_SetColor(_aColorSep[0] | (((U32)_aColorSep[1]) << 8) | (((U32)_aColorSep[2]) << 16));
    GUI_FillRect(205,  60, 285, 139);
    return;
  case WM_INIT_DIALOG:
    _ColorIndex = 0;
    for (i = 0; i < 3; i++) {
      hItem = WM_GetDialogItem(hDlg, GUI_ID_SLIDER0 + i);
      _aColorSep[i] = (_ColorBackGround & (0xff << (i * 8))) >> (i * 8);
      SLIDER_SetRange(hItem, 0, 255);
      SLIDER_SetValue(hItem, _aColorSep[i]);
      /* Init EDIT-widgets */
      hItem = WM_GetDialogItem(hDlg, GUI_ID_EDIT0 + i);
      EDIT_SetDecMode(hItem, _aColorSep[i],   0, 255, 0, 0);
    }
    /* Init dropdown widgets */
    hItem = WM_GetDialogItem(hDlg, GUI_ID_DROPDOWN0);
    DROPDOWN_SetAutoScroll(hItem, 1);
    DROPDOWN_AddString(hItem, "Background");
    DROPDOWN_AddString(hItem, "Grid");
    DROPDOWN_AddString(hItem, "Label");
    DROPDOWN_AddString(hItem, "Temperature 1");
    DROPDOWN_AddString(hItem, "Temperature 2");
    break;
  case WM_NOTIFY_PARENT:
    Id    = WM_GetId(pMsg->hWinSrc);    /* Id of widget */
    NCode = pMsg->Data.v;               /* Notification code */
    switch (NCode) {
    case WM_NOTIFICATION_RELEASED:      /* React only if released */
      if (Id == GUI_ID_OK) {            /* OK Button */
        _SaveCurrentColor();
        _UpdateTextColors(_hDialogMain);
        hItem = WM_GetClientWindow(WM_GetDialogItem(_hDialogMain, ID_TEMPERATURE));
        WM_InvalidateWindow(hItem);
        WM_SetFocus(WM_GetDialogItem(_hDialogMain, ID_TEMPERATURE));
        _SelectScreen(0);
      }
      break;
    case WM_NOTIFICATION_SEL_CHANGED:
      _SaveCurrentColor();
      if (Id == GUI_ID_DROPDOWN0) {
        for (i = 0; i < 3; i++) {
          hItem = WM_GetDialogItem(hDlg, GUI_ID_DROPDOWN0);
          _ColorIndex = DROPDOWN_GetSel(hItem);
          hItem = WM_GetDialogItem(hDlg, GUI_ID_SLIDER0 + i);
          switch (_ColorIndex) {
          case 0: Color = _ColorBackGround; break;
          case 1: Color = _ColorGrid;       break;
          case 2: Color = _ColorLabel;      break;
          case 3: Color = _ColorTemp1;      break;
          case 4: Color = _ColorTemp2;      break;
          }
          _aColorSep[i] = (Color & (0xff << (i * 8))) >> (i * 8);
          SLIDER_SetRange(hItem, 0, 255);
          SLIDER_SetValue(hItem, _aColorSep[i]);
          /* Init EDIT-widgets */
          hItem = WM_GetDialogItem(hDlg, GUI_ID_EDIT0 + i);
          EDIT_SetDecMode(hItem, _aColorSep[i],   0, 255, 0, 0);
        }
      }
      break;
    case WM_NOTIFICATION_VALUE_CHANGED: /* Value has changed */
      {
        unsigned Index = 0, v = 0;
        WM_HWIN hSlider, hEdit;
        if ((Id >= GUI_ID_SLIDER0) && (Id <= GUI_ID_SLIDER2)) {
          Index = Id - GUI_ID_SLIDER0;
          /* SLIDER-widget has changed, update EDIT-widget */
          hSlider = WM_GetDialogItem(hDlg, GUI_ID_SLIDER0 + Index);
          hEdit   = WM_GetDialogItem(hDlg, GUI_ID_EDIT0 + Index);
          v = SLIDER_GetValue(hSlider);
          EDIT_SetValue(hEdit, v);
        } else if ((Id >= GUI_ID_EDIT0) && (Id <= GUI_ID_EDIT2)) {
          Index = Id - GUI_ID_EDIT0;
          /* If EDIT-widget has changed, update SLIDER-widget */
          hSlider = WM_GetDialogItem(hDlg, GUI_ID_SLIDER0 + Index);
          hEdit   = WM_GetDialogItem(hDlg, GUI_ID_EDIT0 + Index);
          v = EDIT_GetValue(hEdit);
          SLIDER_SetValue(hSlider, v);
        }
        _aColorSep[Index] = v;
        /* At last invalidate dialog client window */
        WM_InvalidateWindow(WM_GetClientWindow(hDlg));
      }
      break;
    }
    break;
  default:
    WM_DefaultProc(pMsg);
  }
}

/*********************************************************************
*
*       _cbTemperature
*
* Purpose:
*   Callback routine of temperature window
*/
static void _cbTemperature(WM_MESSAGE * pMsg) {
  //WM_HWIN hDlg;
  //hDlg = pMsg->hWin;
  switch (pMsg->MsgId) {
  case WM_PAINT:
    _LabelGraph();
    _DrawGraph();
    return;
  }
  if (_pcbCallbackTemperature) {
    _pcbCallbackTemperature(pMsg);
  }
}

/*********************************************************************
*
*       _cbDialogMain
*
* Purpose:
*   Callback routine of DialogMain
*/
static void _cbDialogMain(WM_MESSAGE * pMsg) {
  int Id;
  WM_HWIN hDlg, hItem;
  hDlg = pMsg->hWin;
  switch (pMsg->MsgId) {
  case WM_PAINT:
    break;
  case WM_INIT_DIALOG:
    /* Init progress bars */
    hItem = WM_GetDialogItem(hDlg, GUI_ID_PROGBAR0);
    WIDGET_SetEffect(hItem, &WIDGET_Effect_3D);
    _SetProgbarValue(GUI_ID_PROGBAR0, _aTemp1[GUI_COUNTOF(_aTemp1) - 1]);
    hItem = WM_GetDialogItem(hDlg, GUI_ID_PROGBAR1);
    WIDGET_SetEffect(hItem, &WIDGET_Effect_3D);
    _SetProgbarValue(GUI_ID_PROGBAR1, _aTemp2[GUI_COUNTOF(_aTemp2) - 1]);
    /* Init edit widgets */
    hItem = WM_GetDialogItem(hDlg, GUI_ID_EDIT0);
    EDIT_SetDecMode(hItem, _TempMin, 0, 999, 0, 0);
    WM_DisableWindow(hItem);
    hItem = WM_GetDialogItem(hDlg, GUI_ID_EDIT1);
    EDIT_SetDecMode(hItem, _TempMax, 0, 999, 0, 0);
    WM_DisableWindow(hItem);
    /* Init temperature window */
    hItem = WM_GetClientWindow(WM_GetDialogItem(hDlg, ID_TEMPERATURE));
    _pcbCallbackTemperature = WM_SetCallback(hItem, _cbTemperature);
    _UpdateTextColors(hDlg);
    break;
  case WM_NOTIFY_PARENT:
    if (pMsg->Data.v == WM_NOTIFICATION_RELEASED) {
      Id = WM_GetId(pMsg->hWinSrc);      /* Id of widget */
      switch (Id) {
      case GUI_ID_BUTTON0:
        WM_SetFocus(_hDialogColor);
        _SelectScreen(1);
        break;
      }
    }
    break;
  default:
    WM_DefaultProc(pMsg);
  }
}

/*********************************************************************
*
*          Public code
*
**********************************************************************
*/
/*********************************************************************
*
*          MainTask
*/
void MainTask(void) {
  int Index;
  GUI_Init();
  LCD_SetVSizeEx(0, 320, 480);
  #if GUI_SUPPORT_MEMDEV
    WM_SetCreateFlags(WM_CF_MEMDEV);
  #endif
  WM_SetDesktopColor(GUI_BLACK);
  GUI_CURSOR_Select(&GUI_CursorArrowM);
  GUI_CURSOR_Show();
  /* Initialize the temperature arrays */
  _InitRandomData(_aTemp1, GUI_COUNTOF(_aTemp1));
  _InitRandomData(_aTemp2, GUI_COUNTOF(_aTemp2));
  /* Execute the intro dialog */
  GUI_ExecDialogBox(_aDialogIntro, GUI_COUNTOF(_aDialogIntro), _cbDialogIntro, WM_HBKWIN, 0, 0);
  /* Execute the color and the temperature dialog */
  _hDialogColor = GUI_CreateDialogBox(_aDialogColor, GUI_COUNTOF(_aDialogColor), _cbDialogColor, WM_HBKWIN, 0, 0);
  _hDialogMain  = GUI_CreateDialogBox(_aDialogMain,  GUI_COUNTOF(_aDialogMain),  _cbDialogMain,  WM_HBKWIN, 0, 0);
  /* Add new temperatures... */
  Index = GUI_COUNTOF(_aTemp1) - 1;
  while (1) {
    WM_HWIN hItem;
    GUI_Delay(100); /* Wait a while */
    /* Shift the color arrays */
    memmove(_aTemp1, _aTemp1 + 1, sizeof(_aTemp1) - 2);
    memmove(_aTemp2, _aTemp2 + 1, sizeof(_aTemp2) - 2);
    /* Add new values */
    _aTemp1[Index] = _GetRandomValue(_aTemp1[Index - 1]);
    _aTemp2[Index] = _GetRandomValue(_aTemp2[Index - 1]);
    /* Update windows */
    hItem = WM_GetClientWindow(WM_GetDialogItem(_hDialogMain, ID_TEMPERATURE));
    WM_InvalidateWindow(hItem);
    _SetProgbarValue(GUI_ID_PROGBAR0, _aTemp1[Index]);
    _SetProgbarValue(GUI_ID_PROGBAR1, _aTemp2[Index]);
  }
}

int main(void)
{
    MainTask();
    return(0);
}
/*************************** End of file ****************************/

