/*********************************************************************
*                SEGGER Microcontroller GmbH & Co. KG                *
*        Solutions for real time microcontroller applications        *
**********************************************************************
*                                                                    *
*        (c) 1996 - 2016  SEGGER Microcontroller GmbH & Co. KG       *
*                                                                    *
*        Internet: www.segger.com    Support:  support@segger.com    *
*                                                                    *
**********************************************************************

** emWin V5.34 - Graphical user interface for embedded applications **
All  Intellectual Property rights  in the Software belongs to  SEGGER.
emWin is protected by  international copyright laws.  Knowledge of the
source code may not be used to write a similar product.  This file may
only be used in accordance with the following terms:

The  software has  been licensed  to Silicon Labs Norway, a subsidiary
of Silicon Labs Inc. whose registered office is 400 West Cesar Chavez,
Austin,  TX 78701, USA solely for  the purposes of creating  libraries 
for its  ARM Cortex-M3, M4F  processor-based devices,  sublicensed and 
distributed  under the  terms and conditions  of the  End User License  
Agreement supplied by Silicon Labs.
Full source code is available at: www.segger.com

We appreciate your understanding and fairness.
----------------------------------------------------------------------
Licensing information

Licensor:                 SEGGER Software GmbH
Licensed to:              Silicon Laboratories Norway
Licensed SEGGER software: emWin
License number:           GUI-00140
License model:            See Agreement, dated 20th April 2012
Licensed product:         - 
Licensed platform:        Cortex M3, Cortex M4F
Licensed number of seats: -
----------------------------------------------------------------------
File        : reversi.c
Purpose     : Simple 'reversi' game.
----------------------------------------------------------------------
*/

#include <string.h>
#include <stdio.h>

#include "GUI.h"
#include "DIALOG.h"
#include "MENU.h"
#include "touch.h"

#include "AI.h"

/*********************************************************************
*
*       Defines
*
**********************************************************************
*/
#define AA_USE_HIRES      0
#define AA_FACTOR         0

#if AA_USE_HIRES
  #define AA_CALCFACTOR   AA_FACTOR
#else
  #define AA_CALCFACTOR   1
#endif

#define DESKTOP_COLOR     GUI_DARKGREEN
#define CLIENT_COLOR      GUI_DARKGRAY
#define GRID_COLOR        GUI_BROWN

#define ID_MENU_NEW       (GUI_ID_USER +  0)
#define ID_MENU_PASS      (GUI_ID_USER +  1)
#define ID_MENU_EXIT      (GUI_ID_USER +  2)
#define ID_MENU_SETTINGS  (GUI_ID_USER +  3)
#define ID_MENU_ABOUT     (GUI_ID_USER +  4)

#define ID_MENU_TEST      (GUI_ID_USER +  5)
#define ID_MENU_CALIBRATION (GUI_ID_USER + 6)

#define ID_WINDOW_0 (GUI_ID_USER + 10)
#define ID_TEXT_0 (GUI_ID_USER + 11)

#define DO_DELAY          0

/*********************************************************************
*
*       Static data
*
**********************************************************************
*/

/* Global data */
static WM_HWIN  _hContextMenu;
static WM_HWIN  _hFrame;

static REVERSI_AI_Func* _pPlayerAI[2];

static BOARD  _Board;
static int    _GameOver;
static int    _BoardX0;
static int    _BoardY0;
static int    _CellSize;

static const GUI_WIDGET_CREATE_INFO _aDialogCreate[] = {
  { WINDOW_CreateIndirect, "Calibration", ID_WINDOW_0, 0, 0, 320, 240, 0, 0, 0 },
  { TEXT_CreateIndirect, "Instruction", ID_TEXT_0, 22, 62, 270, 20, 0, 100, 0 },
  // USER START (Optionally insert additional widgets)
  // USER END
};

/* Game settings */
static int      _ShowPossibleMoves = 1;

/*********************************************************************
*
*       Static data, SEGGER logo (65% size)
*
**********************************************************************
*/

static GUI_CONST_STORAGE GUI_COLOR _ColorsSeggerLogo[] = {
     0xFFFFFF,0xEEEEEE,0x777777,0x555555
    ,0x444444,0x000000,0x333333,0xDDDDDD
    ,0xCCCCCC,0x666666,0xFF9966,0xFF3333
    ,0xFFCCCC,0xFF6633,0xFF3300,0xFF9999
    ,0xFFCC99,0xFF6666,0xFF0000,0x888888
    ,0x222222,0x111111,0x999999,0xAAAAAA
    ,0xBBBBBB
};

static GUI_CONST_STORAGE GUI_LOGPALETTE _PalSeggerLogo = {
  25,	/* number of entries */
  0, 	/* No transparency */
  &_ColorsSeggerLogo[0]
};

static GUI_CONST_STORAGE unsigned char _acSeggerLogo[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x01, 0x04, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x06, 0x07, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x02, 0x05, 0x03, 0x08, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x09, 0x05, 0x09, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x03, 0x05, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x05, 0x04, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x03, 0x05, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x05, 0x04, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x03, 0x05, 0x07, 0x00, 0x00, 0x0A, 0x0B, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x0D, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x05, 0x04, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x03, 0x05, 0x07, 0x00, 0x00, 0x0B, 0x0E, 0x0D, 0x01, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x0E, 0x0E, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x05, 0x04, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x03, 0x05, 0x07, 0x00, 0x00, 0x10, 0x0E, 0x0E, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0D, 0x0E, 0x0E, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x05, 0x04, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x03, 0x05, 0x07, 0x00, 0x00, 0x00, 0x0A, 0x0E, 0x0E, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x0E, 0x0E, 0x0D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x05, 0x04, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x03, 0x05, 0x07, 0x00, 0x00, 0x00, 0x01, 0x0D, 0x0E, 0x0E, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x0E, 0x0E, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x05, 0x04, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x03, 0x05, 0x07, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x0E, 0x0E, 0x0D, 0x01, 0x00, 0x00, 0x00, 0x00, 0x11, 0x0E, 0x0E, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x05, 0x04, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x03, 0x05, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x0E, 0x0E, 0x11, 0x00, 0x00, 0x00, 0x00, 0x01, 0x0B, 0x0E, 0x0B, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x05, 0x04, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x03, 0x05, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x0E, 0x0E, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x0E, 0x0E, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x05, 0x04, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x03, 0x05, 0x07, 0x00, 0x0C, 0x01, 0x00, 0x00, 0x00, 0x00, 0x0D, 0x0E, 0x0E, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x0E, 0x0E, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x05, 0x04, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x03, 0x05, 0x07, 0x00, 0x0F, 0x0D, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x0E, 0x0E, 0x0D, 0x01, 0x00, 0x00, 0x00, 0x00, 0x0D, 0x0E, 0x0E, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x05, 0x04, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x03, 0x05, 0x07, 0x00, 0x0F, 0x0E, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x10, 0x0E, 0x0E, 0x11, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x0E, 0x0E, 0x0D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x05, 0x04, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x03, 0x05, 0x07, 0x00, 0x0F, 0x0E, 0x0E, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x0E, 0x0E, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x0E, 0x0E, 0x0A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x01, 0x05, 0x04, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x03, 0x05, 0x07, 0x00, 0x0F, 0x0E, 0x0E, 0x0D, 0x01, 0x00, 0x00, 0x00, 0x01, 0x0D, 0x0E, 0x0E, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x11, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x11, 0x00, 0x00, 0x01, 0x05, 0x04, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x03, 0x05, 0x07, 0x00, 0x0F, 0x0E, 0x0E, 0x0E, 0x11, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x0E, 0x0E, 0x0D, 0x01, 0x00, 0x00, 0x00, 0x01, 0x0B, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x00, 0x00, 0x01, 0x05, 0x04, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x03, 0x05, 0x07, 0x00, 0x0F, 0x0E, 0x0E, 0x0E, 0x0E, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x10, 0x0E, 0x0E, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0C, 0x00, 0x00, 0x01, 0x05, 0x04, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x03, 0x05, 0x07, 0x00, 0x0F, 0x0E, 0x0E, 0x0E, 0x0E, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x10, 0x0E, 0x0E, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0C, 0x00, 0x00, 0x01, 0x05, 0x04, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x03, 0x05, 0x07, 0x00, 0x0F, 0x0E, 0x0E, 0x0E, 0x11, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x0E, 0x0E, 0x0D, 0x01, 0x00, 0x00, 0x00, 0x0C, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x12, 0x0E, 0x00, 0x00, 0x01, 0x05, 0x04, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x03, 0x05, 0x07, 0x00, 0x0F, 0x0E, 0x0E, 0x0D, 0x00, 0x00, 0x00, 0x00, 0x01, 0x0D, 0x0E, 0x0E, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x0D, 0x0E, 0x0E, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0A, 0x00, 0x00, 0x01, 0x05, 0x04, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x03, 0x05, 0x07, 0x00, 0x0F, 0x0E, 0x0E, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x11, 0x0E, 0x0E, 0x10, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x0E, 0x0E, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x05, 0x04, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x03, 0x05, 0x07, 0x00, 0x0F, 0x0E, 0x10, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x0E, 0x0E, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x0E, 0x0E, 0x0D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x05, 0x04, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x03, 0x05, 0x07, 0x00, 0x0F, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x0E, 0x0E, 0x0D, 0x00, 0x00, 0x00, 0x00, 0x01, 0x0B, 0x0E, 0x0B, 0x0C, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x05, 0x04, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x03, 0x05, 0x07, 0x00, 0x0C, 0x01, 0x00, 0x00, 0x00, 0x01, 0x0D, 0x0E, 0x0E, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x11, 0x0E, 0x0E, 0x10, 0x00, 0x00, 0x00, 0x13, 0x14, 0x15, 0x05, 0x14, 0x13, 0x00, 0x00, 0x16, 0x04, 0x06, 0x06, 0x06, 0x06, 0x04, 0x01, 0x00, 0x07, 0x09, 0x15, 0x15, 0x05, 0x06, 0x17, 0x00, 0x00, 0x00, 0x07, 0x09, 0x15, 0x15, 0x05, 0x06, 0x16, 0x00, 0x00, 0x07, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x17, 0x00, 0x13, 0x04, 0x06, 0x06, 0x06, 0x04, 0x13, 0x01, 0x00, 0x00, 0x00, 0x01, 0x05, 0x04, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x03, 0x05, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x0E, 0x0E, 0x10, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x0E, 0x0E, 0x0A, 0x00, 0x00, 0x00, 0x16, 0x05, 0x04, 0x17, 0x16, 0x14, 0x05, 0x17, 0x00, 0x04, 0x05, 0x04, 0x09, 0x09, 0x09, 0x02, 0x01, 0x01, 0x06, 0x05, 0x09, 0x17, 0x02, 0x05, 0x05, 0x17, 0x00, 0x01, 0x06, 0x05, 0x09, 0x17, 0x02, 0x05, 0x05, 0x16, 0x00, 0x17, 0x05, 0x14, 0x09, 0x09, 0x09, 0x09, 0x18, 0x00, 0x06, 0x05, 0x03, 0x09, 0x03, 0x14, 0x05, 0x13, 0x00, 0x00, 0x00, 0x01, 0x05, 0x04, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x03, 0x05, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x0E, 0x0E, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x0E, 0x0E, 0x0D, 0x01, 0x00, 0x00, 0x00, 0x09, 0x05, 0x13, 0x00, 0x00, 0x01, 0x16, 0x07, 0x00, 0x03, 0x05, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0x05, 0x02, 0x00, 0x00, 0x00, 0x17, 0x03, 0x08, 0x00, 0x16, 0x05, 0x09, 0x00, 0x00, 0x00, 0x18, 0x03, 0x18, 0x00, 0x17, 0x05, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x05, 0x00, 0x00, 0x00, 0x18, 0x05, 0x03, 0x00, 0x00, 0x00, 0x01, 0x05, 0x04, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x03, 0x05, 0x07, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x0E, 0x0E, 0x0D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0D, 0x0E, 0x0E, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x18, 0x15, 0x05, 0x15, 0x04, 0x13, 0x07, 0x00, 0x00, 0x03, 0x05, 0x14, 0x06, 0x06, 0x06, 0x13, 0x00, 0x04, 0x05, 0x08, 0x00, 0x00, 0x07, 0x07, 0x07, 0x01, 0x00, 0x03, 0x05, 0x08, 0x00, 0x00, 0x07, 0x07, 0x07, 0x01, 0x00, 0x17, 0x05, 0x15, 0x06, 0x06, 0x06, 0x04, 0x07, 0x00, 0x06, 0x05, 0x16, 0x17, 0x17, 0x03, 0x15, 0x16, 0x00, 0x00, 0x00, 0x01, 0x05, 0x04, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x03, 0x05, 0x07, 0x00, 0x00, 0x00, 0x01, 0x0D, 0x0E, 0x0E, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x0E, 0x0E, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x13, 0x04, 0x15, 0x05, 0x15, 0x16, 0x00, 0x03, 0x05, 0x04, 0x09, 0x09, 0x09, 0x16, 0x00, 0x04, 0x05, 0x07, 0x00, 0x08, 0x15, 0x15, 0x15, 0x04, 0x00, 0x03, 0x05, 0x08, 0x00, 0x07, 0x15, 0x05, 0x15, 0x06, 0x00, 0x17, 0x05, 0x14, 0x09, 0x09, 0x09, 0x09, 0x01, 0x00, 0x06, 0x05, 0x05, 0x05, 0x05, 0x05, 0x06, 0x01, 0x00, 0x00, 0x00, 0x01, 0x05, 0x04, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x03, 0x05, 0x07, 0x00, 0x00, 0x00, 0x11, 0x0E, 0x0E, 0x10, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x0E, 0x0E, 0x0D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x17, 0x00, 0x00, 0x01, 0x16, 0x05, 0x14, 0x00, 0x03, 0x05, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x05, 0x16, 0x00, 0x00, 0x18, 0x13, 0x05, 0x14, 0x00, 0x02, 0x05, 0x16, 0x00, 0x00, 0x18, 0x16, 0x05, 0x14, 0x00, 0x17, 0x05, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x05, 0x08, 0x07, 0x08, 0x04, 0x05, 0x17, 0x00, 0x00, 0x00, 0x01, 0x05, 0x04, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x03, 0x05, 0x07, 0x00, 0x00, 0x0F, 0x0E, 0x0E, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x01, 0x0D, 0x0E, 0x0E, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x05, 0x03, 0x07, 0x01, 0x17, 0x05, 0x04, 0x00, 0x03, 0x05, 0x16, 0x18, 0x18, 0x18, 0x08, 0x01, 0x08, 0x15, 0x15, 0x17, 0x01, 0x07, 0x03, 0x05, 0x14, 0x00, 0x07, 0x15, 0x15, 0x17, 0x01, 0x07, 0x09, 0x05, 0x14, 0x00, 0x17, 0x05, 0x04, 0x18, 0x18, 0x18, 0x18, 0x07, 0x00, 0x06, 0x05, 0x01, 0x00, 0x00, 0x16, 0x05, 0x02, 0x00, 0x00, 0x00, 0x01, 0x05, 0x04, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x03, 0x05, 0x07, 0x00, 0x00, 0x0B, 0x12, 0x0D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x0E, 0x0E, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x03, 0x05, 0x05, 0x05, 0x05, 0x06, 0x08, 0x00, 0x09, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x17, 0x00, 0x18, 0x14, 0x05, 0x05, 0x05, 0x06, 0x04, 0x14, 0x00, 0x00, 0x18, 0x14, 0x05, 0x05, 0x05, 0x06, 0x04, 0x15, 0x00, 0x08, 0x15, 0x05, 0x05, 0x05, 0x05, 0x05, 0x03, 0x00, 0x06, 0x15, 0x01, 0x00, 0x00, 0x18, 0x05, 0x09, 0x00, 0x00, 0x00, 0x01, 0x05, 0x04, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x03, 0x05, 0x07, 0x00, 0x00, 0x0F, 0x11, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x11, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x16, 0x16, 0x17, 0x01, 0x00, 0x00, 0x01, 0x08, 0x18, 0x18, 0x18, 0x18, 0x08, 0x01, 0x00, 0x00, 0x01, 0x17, 0x16, 0x17, 0x00, 0x07, 0x18, 0x00, 0x00, 0x00, 0x01, 0x17, 0x16, 0x17, 0x01, 0x07, 0x17, 0x00, 0x00, 0x08, 0x18, 0x18, 0x18, 0x18, 0x18, 0x07, 0x00, 0x08, 0x18, 0x00, 0x00, 0x00, 0x00, 0x18, 0x07, 0x00, 0x00, 0x00, 0x01, 0x05, 0x04, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x03, 0x05, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x05, 0x04, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x03, 0x05, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x05, 0x04, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x16, 0x05, 0x04, 0x17, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x17, 0x03, 0x05, 0x13, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x03, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x04, 0x01, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x02, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x02, 0x16, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

static GUI_CONST_STORAGE GUI_BITMAP _Logo = {
 90, /* XSize */
 46, /* YSize */
 90, /* BytesPerLine */
 8, /* BitsPerPixel */
 _acSeggerLogo,  /* Pointer to picture data (indices) */
 &_PalSeggerLogo,  /* Pointer to palette */
 NULL,  /* Pointer to methods */
};

/*********************************************************************
*
*       Static code, player AIs
*
**********************************************************************
*/
/*********************************************************************
*
*       _PlayerAI_FirstValid
*/
char _PlayerAI_FirstValid(const BOARD* pBoard, int* px, int* py) {
  int x, y;
  for (y = 0; y < NUM_CELL_Y; y++) {
    for (x = 0; x < NUM_CELL_X; x++) {
      if (pBoard->aMoves[x][y]) {
        goto End;
      }
    }
  }
End:
  *px = x;
  *py = y;
  return 1;
}

/*********************************************************************
*
*       Static code, helper functions
*
**********************************************************************
*/
/*********************************************************************
*
*       _Delay
*/
static void _Delay(int Period) {
  if (!DO_DELAY) Period = 0;
  int EndTime = GUI_GetTime() + Period;
  int tRem; /* remaining Time */
  while (tRem = EndTime - GUI_GetTime(), tRem > 0) {
    GUI_Exec();
    GUI_X_Delay((tRem > 5) ? 5 : tRem);
  }
}


/*********************************************************************
*
*       _cbDialog
*/
static void _cbDialog(WM_MESSAGE * pMsg) {
  WM_HWIN hItem;
  static int point = 0;
  static U8 PressedPrev = 0;
  const POINT Points[3] = { {40, 40}, {280, 120}, {160, 200} }; /* calibration points on screen */
  static POINT PointsScr[3];

  // USER START (Optionally insert additional variables)
  // USER END

  switch (pMsg->MsgId) {
  case WM_INIT_DIALOG:
    //
    // Initialization of 'Calibration'
    //
    hItem = pMsg->hWin;
    WINDOW_SetBkColor(hItem, 0x00000000);
    //
    // Initialization of 'Instruction'
    //
    hItem = WM_GetDialogItem(pMsg->hWin, ID_TEXT_0);
    TEXT_SetText(hItem, "Press calibration point");
    TEXT_SetTextColor(hItem, 0x0080FFFF);
    TEXT_SetTextAlign(hItem, GUI_TA_HCENTER | GUI_TA_VCENTER);
    TEXT_SetFont(hItem, GUI_FONT_16_1);
    GUI_CURSOR_Select(&GUI_CursorCrossM);
    GUI_CURSOR_SetPosition(Points[0].x, Points[0].y);
    GUI_CURSOR_Show();
    point = 0;
    PressedPrev = 0;
    /* draw first cross here */
    // USER START (Optionally insert additional code for further widget initialization)
  case WM_TOUCH:
  case WM_TOUCH_CHILD:
    { TOUCH_Pos_TypeDef *pos = TOUCH_GetPos();  /* get information from touchpanel */
      GUI_PID_STATE *pInfo;
      pInfo = (GUI_PID_STATE *)pMsg->Data.p;
      switch(point)
      { case 0:
        case 1:
        case 2: GUI_CURSOR_SetPosition(Points[point].x, Points[point].y); break;
       default: GUI_CURSOR_Select(&GUI_CursorArrowM);
                GUI_EndDialog(pMsg->hWin, 0);
      }
      if(pInfo->Layer==0)
      {
        if( (pos->pen == 1) && (PressedPrev==0) )
        {
          PointsScr[point].x = pos->adcx;
          PointsScr[point].y = pos->adcy;
          if(point==2)
          {
            TOUCH_CalibrationTable((POINT *)Points, PointsScr);
          }
          point++;
        }
        PressedPrev = pos->pen;
      }
    }

    // USER END
    break;
  // USER START (Optionally insert additional message handling)
  // USER END
  default:
    WM_DefaultProc(pMsg);
    break;
  }
}

/*******************************************************************
*
*       _AddMenuItem
*/
static void _AddMenuItem(MENU_Handle hMenu, MENU_Handle hSubmenu, const char* pText, U16 Id, U16 Flags) {
  MENU_ITEM_DATA Item;
  Item.pText    = pText;
  Item.hSubmenu = hSubmenu;
  Item.Flags    = Flags;
  Item.Id       = Id;
  MENU_AddItem(hMenu, &Item);
}

/*******************************************************************
*
*       _CreateMenu
*/
static void _CreateMenu(WM_HWIN hWin) {
  MENU_Handle hMenu, hMenuGame, hMenuOptions, hMenuHelp;
  MENU_SetDefaultFont(&GUI_Font10_1);
  /* Create menu 'Game' */
  hMenuGame = MENU_CreateEx(0, 0, 0, 0, WM_UNATTACHED, 0, MENU_CF_VERTICAL, 0);
  _AddMenuItem(hMenuGame, 0, "New game", ID_MENU_NEW,  0);
  _AddMenuItem(hMenuGame, 0, "Pass",     ID_MENU_PASS, 0);
  _AddMenuItem(hMenuGame, 0, 0,          0,            MENU_IF_SEPARATOR);
  _AddMenuItem(hMenuGame, 0, "Exit",     ID_MENU_EXIT, 0);
  /* Create menu 'Options' */
  hMenuOptions = MENU_CreateEx(0, 0, 0, 0, WM_UNATTACHED, 0, MENU_CF_VERTICAL, 0);
  _AddMenuItem(hMenuOptions, 0, "Game settings...", ID_MENU_SETTINGS, 0);
  _AddMenuItem(hMenuOptions, 0, "Touch panel calibration", ID_MENU_CALIBRATION, 0);
  /* Create menu 'Help' */
  hMenuHelp = MENU_CreateEx(0, 0, 0, 0, WM_UNATTACHED, 0, MENU_CF_VERTICAL, 0);
  _AddMenuItem(hMenuHelp, 0, "About Reversi...", ID_MENU_ABOUT, 0);
  /* Create main menu */
  hMenu = MENU_CreateEx(0, 0, 0, 0, WM_UNATTACHED, 0, MENU_CF_HORIZONTAL, 0);
  _AddMenuItem(hMenu, hMenuGame,    "Game",    0, 0);
  _AddMenuItem(hMenu, hMenuOptions, "Options", 0, 0);
  _AddMenuItem(hMenu, hMenuHelp,    "Help",    0, 0);
  /* Attach menu to framewin */
  FRAMEWIN_AddMenu(hWin, hMenu);
}

/*******************************************************************
*
*       _CalcBoardDimensions
*/
static void _CalcBoardDimensions(void) {
  GUI_RECT r;
  WM_GetClientRectEx(WM_GetClientWindow(_hFrame), &r);
  _CellSize  = ((r.x1 > r.y1) ? r.y1 : r.x1) >> 3;
  _BoardX0   = (r.x1 - (_CellSize << 3)) >> 1;
  _BoardY0   = (r.y1 - (_CellSize << 3)) >> 1;
}

/*******************************************************************
*
*       _InvalidateBoard
*/
static void _InvalidateBoard(void) {
  WM_InvalidateWindow(WM_GetClientWindow(_hFrame));
}

/*******************************************************************
*
*       _InvalidateCell
*/
static void _InvalidateCell(int x, int y) {
  GUI_RECT r;
  r.x0 = _BoardX0 + (x * _CellSize);
  r.y0 = _BoardY0 + (y * _CellSize);
  r.x1 = r.x0 + _CellSize - 1;
  r.y1 = r.y0 + _CellSize - 1;
  WM_InvalidateRect(WM_GetClientWindow(_hFrame), &r);
}

/*********************************************************************
*
*       _SetCapture
*/
static void _SetCapture(void) {
#if (GUI_SUPPORT_MOUSE & GUI_SUPPORT_CURSOR)
  WM_HWIN hWin;
  hWin = WM_GetClientWindow(_hFrame);
  if (WM_HasCaptured(hWin) == 0) {
    WM_SetCapture(hWin, 0);
    GUI_CURSOR_Select(&GUI_CursorCrossS);
  }
#endif
}

/*********************************************************************
*
*       _ReleaseCapture
*/
static void _ReleaseCapture(void) {
#if (GUI_SUPPORT_MOUSE & GUI_SUPPORT_CURSOR)
  WM_HWIN hWin;
  hWin = WM_GetClientWindow(_hFrame);
  if (WM_HasCaptured(hWin)) {
    WM_ReleaseCapture();
    GUI_CURSOR_Select(&GUI_CursorArrowM);
  }
#endif
}

/*********************************************************************
*
*       Static code, game API routines
*
**********************************************************************
*/
/*******************************************************************
*
*       _GetStone
*/
static char _GetStone(const BOARD* pBoard, int x, int y) {
  char r = 0;
  if ((x >= 0) && (y >= 0) && (x < NUM_CELL_X) && (y < NUM_CELL_Y)) {
    r = pBoard->aCells[x][y];
  }
  return r;
}

/*******************************************************************
*
*       _SetStone
*/
static void _SetStone(BOARD* pBoard, int x, int y) {
  if ((x >= 0) && (y >= 0) && (x < NUM_CELL_X) && (y < NUM_CELL_Y)) {
    pBoard->aCells[x][y] = pBoard->ActPlayer;
    if (pBoard == &_Board) _InvalidateCell(x, y);
  }
}

/*******************************************************************
*
*       _IsValidMove
*/
static char _IsValidMove(BOARD* pBoard, int x, int y) {
  char r = 0;
  if ((x >= 0) && (y >= 0) && (x < NUM_CELL_X) && (y < NUM_CELL_Y)) {
    r = ((pBoard->aMoves[x][y]) ? 1 : 0);
  }
  return r;
}

/*******************************************************************
*
*       _CheckDirection
*/
static char _CheckDirection(const BOARD* pBoard, int x, int y, int dx, int dy) {
  char Cell;
  x += dx;
  y += dy;
  Cell = _GetStone(pBoard, x, y);
  if ((Cell != pBoard->ActPlayer) && (Cell != 0)) {
    do {
      x += dx;
      y += dy;
      Cell = _GetStone(pBoard, x, y);
    } while ((Cell != pBoard->ActPlayer) && (Cell != 0));
    return ((Cell == pBoard->ActPlayer) ? 1 : 0);
  }
  return 0;
}

/*******************************************************************
*
*       _CalcValidMoves
*/
int _CalcValidMoves(BOARD* pBoard) {
  int x, y, r = 0;
  U8 Valid;
  for (y = 0; y < NUM_CELL_Y; y++) {
    for (x = 0; x < NUM_CELL_X; x++) {
      Valid = 0;
      if (pBoard->aCells[x][y] == 0) {
        Valid |= _CheckDirection(pBoard, x, y, -1, -1) << 0;
        Valid |= _CheckDirection(pBoard, x, y,  0, -1) << 1;
        Valid |= _CheckDirection(pBoard, x, y,  1, -1) << 2;
        Valid |= _CheckDirection(pBoard, x, y,  1,  0) << 3;
        Valid |= _CheckDirection(pBoard, x, y,  1,  1) << 4;
        Valid |= _CheckDirection(pBoard, x, y,  0,  1) << 5;
        Valid |= _CheckDirection(pBoard, x, y, -1,  1) << 6;
        Valid |= _CheckDirection(pBoard, x, y, -1,  0) << 7;
        if (Valid) {
          r++;
        }
      }
      if (Valid != pBoard->aMoves[x][y]) {
        pBoard->aMoves[x][y] = Valid;
        if (pBoard == &_Board) _InvalidateCell(x, y);
      }
    }
  }
  return r;
}

/*******************************************************************
*
*       _DoDirection
*/
static void _DoDirection(BOARD* pBoard, int x, int y, int dx, int dy) {
  do {
    _SetStone(pBoard, x, y);
    x += dx;
    y += dy;
  } while (_GetStone(pBoard, x, y) != pBoard->ActPlayer);
}

/*******************************************************************
*
*       _MakeMove
*/
void _MakeMove(BOARD* pBoard, int x, int y) {
  U8 Valid;
  _SetStone(pBoard, x, y);
  if (pBoard == &_Board) _Delay(100);
  Valid = pBoard->aMoves[x][y];
  if (Valid & (U8)(1 << 0)) { _DoDirection(pBoard, x, y, -1, -1); }
  if (Valid & (U8)(1 << 1)) { _DoDirection(pBoard, x, y,  0, -1); }
  if (Valid & (U8)(1 << 2)) { _DoDirection(pBoard, x, y,  1, -1); }
  if (Valid & (U8)(1 << 3)) { _DoDirection(pBoard, x, y,  1,  0); }
  if (Valid & (U8)(1 << 4)) { _DoDirection(pBoard, x, y,  1,  1); }
  if (Valid & (U8)(1 << 5)) { _DoDirection(pBoard, x, y,  0,  1); }
  if (Valid & (U8)(1 << 6)) { _DoDirection(pBoard, x, y, -1,  1); }
  if (Valid & (U8)(1 << 7)) { _DoDirection(pBoard, x, y, -1,  0); }
}

/*******************************************************************
*
*       _CalcScore
*/
int _CalcScore(const BOARD* pBoard) {
  int x, y, r = 0;
  char Cell;
  for (y = 0; y < NUM_CELL_Y; y++) {
    for (x = 0; x < NUM_CELL_X; x++) {
      Cell = pBoard->aCells[x][y];
      if (Cell) {
        r += (Cell == pBoard->ActPlayer) ? (1) : (-1);
      }
    }
  }
  return r;
}





/*********************************************************************
*
*       Static code, about box
*
**********************************************************************
*/
/*******************************************************************
*
*       _cbAboutBox
*/
static void _cbAboutBox(WM_MESSAGE* pMsg) {
  WM_HWIN hWin = pMsg->hWin;
  switch (pMsg->MsgId) {
  case WM_PAINT:
    {
      char acText[16] = "V";
      strcat(acText, GUI_GetVersionString());
      GUI_SetColor(GUI_BLACK);
      GUI_SetFont(&GUI_Font10_1);
      GUI_SetTextMode(GUI_TM_TRANS);
      GUI_DrawBitmap(&_Logo, 4, 4);
      GUI_DispStringHCenterAt("Reversi V1.0", 49, 48);
      GUI_DispStringHCenterAt("emWin", 138, 38);
      GUI_DispStringHCenterAt(acText,  138, 48);
      GUI_DispStringHCenterAt("Compiled " __DATE__ " "__TIME__, 88, 68);
      GUI_DispStringHCenterAt("(c) 1998-2004 Segger", 88, 87);
      GUI_DispStringHCenterAt("Microcontroller Systeme GmbH", 88, 97);
      GUI_DispStringHCenterAt("www.segger.com", 88, 107);
      GUI_DispStringHCenterAt("Programmed by Tobias Quecke", 88, 126);
    }
    break;
  case WM_NOTIFY_PARENT:
    if (pMsg->Data.v == WM_NOTIFICATION_RELEASED) {
      GUI_EndDialog(hWin, 1);
    }
    break;
  default:
    WM_DefaultProc(pMsg);
  }
}

/*********************************************************************
*
*       _ShowAboutBox
*/
static void _ShowAboutBox(void) {
  WM_HWIN hFrame, hItem;
  /* Create framewin */
  hFrame = FRAMEWIN_CreateEx(70, 40, 180, 160, WM_HBKWIN, WM_CF_SHOW, FRAMEWIN_CF_MOVEABLE, 0, "About Reversi", &_cbAboutBox);
  FRAMEWIN_SetClientColor   (hFrame, GUI_WHITE);
  FRAMEWIN_SetFont          (hFrame, &GUI_Font10_1);
  FRAMEWIN_SetTextAlign     (hFrame, GUI_TA_HCENTER);
  /* Create dialog items */
  hItem = BUTTON_CreateEx(111, 7, 55, 18, WM_GetClientWindow(hFrame), WM_CF_SHOW, 0, GUI_ID_OK);
  BUTTON_SetText         (hItem, "Ok");
  /* Exec modal dialog */
  WM_SetFocus(hFrame);
  WM_MakeModal(hFrame);
  GUI_ExecCreatedDialog(hFrame);
  WM_SetFocus(_hFrame);
}

/*********************************************************************
*
*       Static code, message box
*
**********************************************************************
*/
/*******************************************************************
*
*       _cbMessageBox
*/
static void _cbMessageBox(WM_MESSAGE* pMsg) {
  WM_HWIN hWin = pMsg->hWin;
  switch (pMsg->MsgId) {
  case WM_NOTIFY_PARENT:
    if (pMsg->Data.v == WM_NOTIFICATION_RELEASED) {
      int Id = WM_GetId(pMsg->hWinSrc);
      GUI_EndDialog(hWin, (Id == GUI_ID_OK) ? 1 : 0);
    }
    break;
  default:
    WM_DefaultProc(pMsg);
  }
}

/*********************************************************************
*
*       _ShowMessageBox
*/
static int _ShowMessageBox(const char* pTitle, const char* pText, int YesNo) {
  WM_HWIN hFrame, hClient, hBut;
  int r;
  /* Create framewin */
  hFrame = FRAMEWIN_CreateEx(65, 75, 190, 90, WM_HBKWIN, WM_CF_SHOW, FRAMEWIN_CF_MOVEABLE, 0, pTitle, &_cbMessageBox);
  FRAMEWIN_SetClientColor   (hFrame, GUI_WHITE);
  FRAMEWIN_SetFont          (hFrame, &GUI_Font10_1);
  FRAMEWIN_SetTextAlign     (hFrame, GUI_TA_HCENTER);
  /* Create dialog items */
  hClient = WM_GetClientWindow(hFrame);
  TEXT_CreateEx(10, 7, 170, 30, hClient, WM_CF_SHOW, GUI_TA_HCENTER, 0, pText);
  if (YesNo) {
    hBut = BUTTON_CreateEx(97, 45, 55, 18, hClient, WM_CF_SHOW, 0, GUI_ID_CANCEL);
    BUTTON_SetText        (hBut, "No");
    hBut = BUTTON_CreateEx(32, 45, 55, 18, hClient, WM_CF_SHOW, 0, GUI_ID_OK);
    BUTTON_SetText        (hBut, "Yes");
  } else {
    hBut = BUTTON_CreateEx(64, 45, 55, 18, hClient, WM_CF_SHOW, 0, GUI_ID_OK);
    BUTTON_SetText        (hBut, "Ok");
  }
  /* Exec modal dialog */
  WM_SetFocus(hFrame);
  WM_MakeModal(hFrame);
  r = GUI_ExecCreatedDialog(hFrame);
  WM_SetFocus(_hFrame);
  return r;
}

/*********************************************************************
*
*       Static code, dialog settings
*
**********************************************************************
*/
/*******************************************************************
*
*       _cbDialogSettings
*/
static void _cbDialogSettings(WM_MESSAGE* pMsg) {
  WM_HWIN hWin = pMsg->hWin;
  switch (pMsg->MsgId) {
  case WM_NOTIFY_PARENT:
    if (pMsg->Data.v == WM_NOTIFICATION_RELEASED) {
      WM_HWIN hItem = pMsg->hWinSrc;
      switch (WM_GetId(hItem)) {
      case GUI_ID_OK:
        GUI_EndDialog(hWin, 1);
        break;
      case GUI_ID_CHECK0:
        _ShowPossibleMoves = CHECKBOX_GetState(hItem);
        _InvalidateBoard();
        break;
      }
    }
    break;
  default:
    WM_DefaultProc(pMsg);
  }
}

/*********************************************************************
*
*       _ShowDialogSettings
*/
static void _ShowDialogSettings(void) {
  WM_HWIN hFrame, hClient, hItem;
  /* Create framewin */
  hFrame = FRAMEWIN_CreateEx(70, 75, 180, 90, WM_HBKWIN, WM_CF_SHOW, FRAMEWIN_CF_MOVEABLE, 0, "Game settings", &_cbDialogSettings);
  FRAMEWIN_SetClientColor   (hFrame, GUI_WHITE);
  FRAMEWIN_SetFont          (hFrame, &GUI_Font10_1);
  FRAMEWIN_SetTextAlign     (hFrame, GUI_TA_HCENTER);
  /* Create dialog items */
  hClient = WM_GetClientWindow(hFrame);
  /* Create button */
  hItem = BUTTON_CreateEx(59, 46, 55, 18, hClient, WM_CF_SHOW, 0, GUI_ID_OK);
  BUTTON_SetText         (hItem, "Ok");
  /* Create checkbox */
  hItem = CHECKBOX_CreateEx(10, 10, 140, 0, hClient, WM_CF_SHOW, 0, GUI_ID_CHECK0);
  CHECKBOX_SetText         (hItem, "Show possible moves");
  CHECKBOX_SetBkColor      (hItem, GUI_INVALID_COLOR);
  CHECKBOX_SetState        (hItem, _ShowPossibleMoves);
  /* Exec modal dialog */
  WM_SetFocus(hFrame);
  WM_MakeModal(hFrame);
  GUI_ExecCreatedDialog(hFrame);
  WM_SetFocus(_hFrame);
}

/*********************************************************************
*
*       Static code
*
**********************************************************************
*/
/*******************************************************************
*
*       _SetPlayer
*/
static void _SetPlayer(int Player) {
  int PossibleMoves;
  _Board.ActPlayer = Player;
  if (Player == 1) {
    FRAMEWIN_SetText(_hFrame, "Reversi - Player 1");
  } else {
    FRAMEWIN_SetText(_hFrame, "Reversi - Player 2");
  }
  FRAMEWIN_SetBarColor(_hFrame, 1, (Player == 1) ? GUI_RED : GUI_BLUE);
  PossibleMoves = _CalcValidMoves(&_Board);
  GUI_Exec();

  if (!PossibleMoves) {
    int ValidMoves;
    GUI_Exec();
    _Board.ActPlayer = 3 - Player;
    ValidMoves = _CalcValidMoves(&_Board);
    _Board.ActPlayer = Player;
    _CalcValidMoves(&_Board);
    if (ValidMoves) {   /* No valid moves, player must pass */
      if (_pPlayerAI[_Board.ActPlayer - 1] == NULL) {
        _ShowMessageBox("Reversi", "No possible moves.\nYou have to pass!", 0);
      } else {
        /* Pass ai player */
      }
      _SetPlayer(3 - _Board.ActPlayer);
    } else {            /* No valid moves for all players, game is over */
      char ac[256];
      int Score;
      _GameOver = 1;
      _Board.ActPlayer = 1;
      Score = _CalcScore(&_Board);
      if (Score < 0) {
        sprintf(ac, "Blue wins by %d stones!\nDo you want to start a new game?", -Score);
      } else if (Score) {
        sprintf(ac, "Red wins by %d stones!\nDo you want to start a new game?", Score);
      } else {
        strcpy(ac, "The game ends in a draw!\nDo you want to start a new game?");
      }
      if (_ShowMessageBox("Reversi", ac, 1)) {
        _StartNewGame();
      }
    }
  }
}

/*******************************************************************
*
*       _NextPlayer
*/
static void _NextPlayer(void) {
  do {
    _SetPlayer(3 - _Board.ActPlayer);
    if (_pPlayerAI[_Board.ActPlayer - 1]&& !_GameOver) {
      int x, y;
      char DoMove;
      DoMove = (*_pPlayerAI[_Board.ActPlayer - 1])(&_Board, &x, &y);
      _Delay(100);
      if (DoMove) {
        _MakeMove(&_Board, x, y);
      }
    }
  } while (_pPlayerAI[_Board.ActPlayer - 1] && !_GameOver);
}

/*******************************************************************
*
*       _StartNewGame
*/
void _StartNewGame(void) {
  memset(&_Board, 0, sizeof(BOARD));
  _Board.aCells[3][3] = 1;
  _Board.aCells[4][4] = 1;
  _Board.aCells[3][4] = 2;
  _Board.aCells[4][3] = 2;
  _GameOver    = 0;
  _SetPlayer(1);
  _InvalidateBoard();
}

/*******************************************************************
*
*       _HandlePID
*/
static void _HandlePID(int x, int y, int Pressed) {
  static int _IsInHandlePID = 0;
  if (_IsInHandlePID++ == 0) {
    _CalcBoardDimensions();
    x -= _BoardX0;
    y -= _BoardY0;
    if ((x >= 0) && (y >= 0)) {
      x /= _CellSize;
      y /= _CellSize;
      if ((x < 8) && (y < 8)) {
        if (_IsValidMove(&_Board, x, y)) {
          if (Pressed == 0) {
            _ReleaseCapture();
            _MakeMove(&_Board, x, y);
            _NextPlayer();
          } else {
            _SetCapture();
          }
          goto EndHandlePID;
        }
      }
    }
    _ReleaseCapture();
  }
EndHandlePID:
  _IsInHandlePID--;
}

/*********************************************************************
*
*       _OnTouch
*/
static void _OnTouch(WM_MESSAGE* pMsg) {
  const GUI_PID_STATE* pState = (const GUI_PID_STATE*)pMsg->Data.p;
  if (pState) {  /* Something happened in our area (pressed or released) */
    _HandlePID(pState->x, pState->y, pState->Pressed);
  }
}

/*********************************************************************
*
*       _OnMouseOver
*/
#if (GUI_SUPPORT_MOUSE & GUI_SUPPORT_CURSOR)
static void _OnMouseOver(WM_MESSAGE* pMsg) {
  const GUI_PID_STATE* pState = (const GUI_PID_STATE *)pMsg->Data.p;
  if (pState) {
    _HandlePID(pState->x, pState->y, -1);
  }
}
#endif

/*******************************************************************
*
*       _OnMenu
*/
static void _OnMenu(WM_MESSAGE* pMsg) {
  MENU_MSG_DATA* pData = (MENU_MSG_DATA*)pMsg->Data.p;
  MENU_Handle    hMenu = pMsg->hWinSrc;
  switch (pData->MsgType) {
  case MENU_ON_INITMENU:
    if (_GameOver) {
      MENU_DisableItem(hMenu, ID_MENU_PASS);
    } else {
      MENU_EnableItem(hMenu, ID_MENU_PASS);
    }
    break;
  case MENU_ON_ITEMSELECT:
    switch (pData->ItemId) {
    case ID_MENU_NEW:
      _StartNewGame();
      break;
    case ID_MENU_PASS:
      _NextPlayer();
      break;
    case ID_MENU_EXIT:
      WM_DeleteWindow(_hFrame);
      break;
    case ID_MENU_SETTINGS:
      _ShowDialogSettings();
      break;
    case ID_MENU_ABOUT:
      _ShowAboutBox();
      break;
    case ID_MENU_TEST:
      WM_ReleaseCapture();
      WM_DetachWindow(_hContextMenu);
      break;
    case ID_MENU_CALIBRATION:
      GUI_ExecDialogBox(_aDialogCreate, GUI_COUNTOF(_aDialogCreate), &_cbDialog, WM_HBKWIN, 0, 0);
      break;
    }
    break;
  default:
    WM_DefaultProc(pMsg);
  }
}

/*******************************************************************
*
*       _OnPaint
*/
static void _OnPaint(WM_HWIN hWin) {
  GUI_COLOR Color;
  GUI_RECT  r;
  int x, y, xPos, yPos;
  int CellSize, rStone, rMove;
  char Cell, IsValidMove;
  _CalcBoardDimensions();
  GUI_AA_SetFactor(AA_FACTOR);
  #if AA_USE_HIRES
    GUI_AA_EnableHiRes();
  #endif
  LCD_SetBkColor(CLIENT_COLOR);
  WM_GetClientRectEx(hWin, &r);
  GUI_ClearRect(r.x0, r.y0, r.x1, _BoardY0 - 1);
  GUI_ClearRect(r.x0, _BoardY0, _BoardX0 - 1, _BoardY0 + (8 * _CellSize));
  GUI_ClearRect(_BoardX0 + (8 * _CellSize) + 1, _BoardY0, r.x1, _BoardY0 + (8 * _CellSize));
  GUI_ClearRect(r.x0, _BoardY0 + (8 * _CellSize) + 1, r.x1, r.y1);
  CellSize = _CellSize - 1;
  rStone = ((CellSize - 3) * AA_CALCFACTOR) >> 1;
  rMove  = ((CellSize - 2) * AA_CALCFACTOR) >> 3;
  if (rStone < AA_CALCFACTOR) {
    rStone = AA_CALCFACTOR;
  }
  if (rMove < (AA_CALCFACTOR >> AA_USE_HIRES)) {
    rMove = (AA_CALCFACTOR >> AA_USE_HIRES);
  }
  for (yPos = _BoardY0, y = 0; y < 8; y++) {
    for (xPos = _BoardX0, x = 0; x < 8; x++) {
      Color = ((x + (y & 1)) & 1) ? (GUI_LIGHTGRAY) : (GUI_WHITE);
      LCD_SetColor(Color);
      GUI_FillRect(xPos + 1, yPos + 1, xPos + CellSize, yPos + CellSize);
      Cell        = _GetStone(&_Board, x, y);
      IsValidMove = (_ShowPossibleMoves) ? _IsValidMove(&_Board, x, y) : 0;
      if (_pPlayerAI[_Board.ActPlayer - 1]) {
        IsValidMove = 0;
      }
      if (Cell || IsValidMove) {
        int xCircle, yCircle;
        xCircle = (xPos + 1) * AA_CALCFACTOR + ((CellSize * AA_CALCFACTOR) >> 1);
        yCircle = (yPos + 1) * AA_CALCFACTOR + ((CellSize * AA_CALCFACTOR) >> 1);
        if (Cell) {
          Color = (Cell == 1) ? (GUI_RED) : (GUI_BLUE);
          LCD_SetColor(Color);
          #if (AA_FACTOR > 1)
            GUI_AA_FillCircle(xCircle, yCircle, rStone);
          #else
            GUI_FillCircle(xCircle, yCircle, rStone);
          #endif
        } else {
          LCD_SetColor(GUI_BLACK);
          #if (AA_FACTOR > 1)
            GUI_AA_FillCircle(xCircle, yCircle, rMove);
          #else
            GUI_FillCircle(xCircle, yCircle, rMove);
          #endif
        }
      }
      LCD_SetColor(GRID_COLOR);
      GUI_DrawVLine(xPos, yPos + 1, yPos + CellSize);
      xPos += _CellSize;
    }
    GUI_DrawVLine(xPos, yPos + 1, yPos + CellSize);
    GUI_DrawHLine(yPos, _BoardX0, _BoardX0 + (_CellSize << 3));
    yPos += _CellSize;
  }
  GUI_DrawHLine(yPos, _BoardX0, _BoardX0 + (_CellSize << 3));
}

/*******************************************************************
*
*       _cbReversiWin
*/
static void _cbReversiWin(WM_MESSAGE* pMsg) {
  WM_HWIN hWin = pMsg->hWin;
  switch (pMsg->MsgId) {
  case WM_PAINT:
    _OnPaint(hWin);
    break;
  case WM_TOUCH:
    _OnTouch(pMsg);
    break;
#if (GUI_SUPPORT_MOUSE & GUI_SUPPORT_CURSOR)
  case WM_MOUSEOVER:
    _OnMouseOver(pMsg);
    break;
#endif
  case WM_MENU:
    _OnMenu(pMsg);
    break;
  case WM_DELETE:
    _hFrame = 0;
    break;
  default:
    WM_DefaultProc(pMsg);
  }
}

/*********************************************************************
*
*       _StartReversi
*/
static void _StartReversi(void) {
  _hFrame = FRAMEWIN_CreateEx(64, 11, 191, 218, WM_HBKWIN, WM_CF_SHOW, FRAMEWIN_CF_MOVEABLE, 0, NULL, &_cbReversiWin);
  FRAMEWIN_SetClientColor(_hFrame, GUI_INVALID_COLOR);
  FRAMEWIN_SetFont       (_hFrame, &GUI_Font10_1);
  FRAMEWIN_SetTextAlign  (_hFrame, GUI_TA_HCENTER);
  FRAMEWIN_AddCloseButton(_hFrame, FRAMEWIN_BUTTON_LEFT,  0);
  FRAMEWIN_AddMaxButton  (_hFrame, FRAMEWIN_BUTTON_RIGHT, 0);
  FRAMEWIN_AddMinButton  (_hFrame, FRAMEWIN_BUTTON_RIGHT, 1);
  FRAMEWIN_SetResizeable (_hFrame, 1);
  _CreateMenu(_hFrame);
  _StartNewGame();
  WM_SetFocus(_hFrame);
  if (_pPlayerAI[0] != NULL)
    _NextPlayer();
  while (_hFrame) {
    GUI_Delay(10);
  }
}

/*********************************************************************
*
*       Public code
*
**********************************************************************
*/
/*********************************************************************
*
*       MainTask
*/
int main(void);
int main(void) {
  GUI_Init();
  GUI_CURSOR_Select(&GUI_CursorArrowM);
  GUI_CURSOR_Show();
  WM_SetDesktopColor(DESKTOP_COLOR);
  WM_SetCreateFlags(WM_CF_MEMDEV);  /* Use memory devices on all windows to avoid flicker */
//  _pPlayerAI[0] = &_PlayerAI_FirstValid;
  _pPlayerAI[1] = &_PlayerAI_SmartGecko;
  while (1) {
    _StartReversi();
    GUI_Delay(1000);
  }
}

/*************************** End of file ****************************/

