/*********************************************************************
*                SEGGER Microcontroller GmbH & Co. KG                *
*        Solutions for real time microcontroller applications        *
**********************************************************************
*                                                                    *
*        (c) 1996 - 2016  SEGGER Microcontroller GmbH & Co. KG       *
*                                                                    *
*        Internet: www.segger.com    Support:  support@segger.com    *
*                                                                    *
**********************************************************************

** emWin V5.34 - Graphical user interface for embedded applications **
All  Intellectual Property rights  in the Software belongs to  SEGGER.
emWin is protected by  international copyright laws.  Knowledge of the
source code may not be used to write a similar product.  This file may
only be used in accordance with the following terms:

The  software has  been licensed  to Silicon Labs Norway, a subsidiary
of Silicon Labs Inc. whose registered office is 400 West Cesar Chavez,
Austin,  TX 78701, USA solely for  the purposes of creating  libraries 
for its  ARM Cortex-M3, M4F  processor-based devices,  sublicensed and 
distributed  under the  terms and conditions  of the  End User License  
Agreement supplied by Silicon Labs.
Full source code is available at: www.segger.com

We appreciate your understanding and fairness.
----------------------------------------------------------------------
Licensing information

Licensor:                 SEGGER Software GmbH
Licensed to:              Silicon Laboratories Norway
Licensed SEGGER software: emWin
License number:           GUI-00140
License model:            See Agreement, dated 20th April 2012
Licensed product:         - 
Licensed platform:        Cortex M3, Cortex M4F
Licensed number of seats: -
----------------------------------------------------------------------
File        : WIDGET_GraphXY.c
Purpose     : Demonstrates the use of the GRAPH widget
----------------------------------------------------------------------
*/

#include <stdlib.h>
#include <string.h>
#include <math.h>

#include "DIALOG.h"
#include "GRAPH.h"
#include "LCDConf.h"
#include "touch.h"

/*********************************************************************
*
*       Defines
*
**********************************************************************
*/
#define PI 3.1415926f
#define DEG2RAD (PI / 180)

#define ID_WINDOW_0 (GUI_ID_USER + 100)
#define ID_TEXT_0 (GUI_ID_USER + 101)

#define DO_DELAY          1

#define SHORT_DELAY 10
#define LONG_DELAY 100

/*********************************************************************
*
*       Static data
*
**********************************************************************
*/

/* Calibration screen */
static const GUI_WIDGET_CREATE_INFO _aCalCreate[] = {
  { WINDOW_CreateIndirect, "Calibration", ID_WINDOW_0, 0, 0, 320, 240, 0, 0, 0 },
  { TEXT_CreateIndirect, "Instruction", ID_TEXT_0, 22, 62, 270, 20, 0, 100, 0 },
};

static GUI_CONST_STORAGE GUI_COLOR Colors[] = {
     0xFFFFFF,0x0000AA
};

static GUI_CONST_STORAGE GUI_LOGPALETTE Pal = {
  2,	/* number of entries */
  1, 	/* Has transparency */
  &Colors[0]
};

static GUI_CONST_STORAGE unsigned char acEnlarge[] = {
  _______X, X_______,
  ______XX, XX______,
  _____XXX, XXX_____,
  _______X, X_______,
  __X____X, X____X__,
  _XX_____, _____XX_,
  XXXXX___, ___XXXXX,
  XXXXX___, ___XXXXX,
  _XX_____, _____XX_,
  __X____X, X____X__,
  _______X, X_______,
  _____XXX, XXX_____,
  ______XX, XX______,
  _______X, X_______
};

static GUI_CONST_STORAGE unsigned char acShrink[] = {
  _______X, X_______,
  _______X, X_______,
  _____XXX, XXX_____,
  ______XX, XX______,
  __X____X, X____X__,
  __XX____, ____XX__,
  XXXXX___, ___XXXXX,
  XXXXX___, ___XXXXX,
  __XX____, ____XX__,
  __X____X, X____X__,
  ______XX, XX______,
  _____XXX, XXX_____,
  _______X, X_______,
  _______X, X_______
};

static GUI_CONST_STORAGE GUI_BITMAP _bmEnlarge = {
  16, /* XSize */
  14, /* YSize */
  2, /* BytesPerLine */
  1, /* BitsPerPixel */
  acEnlarge,  /* Pointer to picture data (indices) */
  &Pal,  /* Pointer to palette */
  NULL,  /* Pointer to methods */
};

static GUI_CONST_STORAGE GUI_BITMAP _bmShrink = {
  16, /* XSize */
  14, /* YSize */
  2, /* BytesPerLine */
  1, /* BitsPerPixel */
  acShrink,  /* Pointer to picture data (indices) */
  &Pal,  /* Pointer to palette */
  NULL,  /* Pointer to methods */
};

/* Logo bitmap: colors */
static GUI_CONST_STORAGE GUI_COLOR _ColorsLogoSegger[] = {
   0x0000FF,0x280000,0x500000,0x780000
  ,0xA00000,0xCCCDCD,0xF4F4F4,0xFFFFFF
  ,0xFFCACA,0xFF0000,0xFF9191,0xFF5656
  ,0x9FA0A2,0x606264,0x000000,0x1F1F1F
};

/* Logo bitmap: palette */
static GUI_CONST_STORAGE GUI_LOGPALETTE _PalLogoSegger = {
  16,	/* number of entries */
  1, 	/* Has transparency */
  &_ColorsLogoSegger[0]
};

/* Logo bitmap: pixel data */
static GUI_CONST_STORAGE unsigned char _acLogoSegger[] = {
  0x00, 0x12, 0x34, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x43, 0x21, 0x00,
  0x02, 0x34, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x43, 0x20,
  0x13, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x31,
  0x24, 0x44, 0x56, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x65, 0x44, 0x42,
  0x34, 0x45, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x54, 0x43,
  0x44, 0x46, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x77, 0x76, 0x67, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x67, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x77, 0x89, 0x9A, 0x77, 0x77, 0x77, 0x77, 0x77, 0x69, 0x9A, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x76, 0x99, 0x99, 0x87, 0x77, 0x77, 0x77, 0x77, 0x99, 0x99, 0xA7, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x76, 0x99, 0x99, 0x96, 0x77, 0x77, 0x77, 0x77, 0x99, 0x99, 0x98, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x77, 0xA9, 0x99, 0x9B, 0x77, 0x77, 0x77, 0x77, 0x89, 0x99, 0x99, 0x67, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x77, 0x7B, 0x99, 0x99, 0xA7, 0x77, 0x77, 0x77, 0x7A, 0x99, 0x99, 0xA7, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x77, 0x76, 0x99, 0x99, 0x98, 0x77, 0x77, 0x77, 0x77, 0xB9, 0x99, 0x98, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x77, 0x77, 0x89, 0x99, 0x99, 0x67, 0x77, 0x77, 0x77, 0x89, 0x99, 0x99, 0x67, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x77, 0x77, 0x7A, 0x99, 0x99, 0xB7, 0x77, 0x77, 0x77, 0x7A, 0x99, 0x99, 0xB7, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x77, 0x77, 0x77, 0xB9, 0x99, 0x9A, 0x77, 0x77, 0x77, 0x77, 0xB9, 0x99, 0x9A, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x77, 0x77, 0x77, 0x69, 0x99, 0x99, 0x87, 0x77, 0x77, 0x77, 0x69, 0x99, 0x99, 0x87, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x77, 0x77, 0x77, 0x78, 0x99, 0x99, 0x96, 0x77, 0x77, 0x77, 0x78, 0x99, 0x99, 0xB6, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x77, 0x77, 0x77, 0x77, 0xA9, 0x99, 0x9A, 0x77, 0x77, 0x77, 0x77, 0xA9, 0x99, 0x9A, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x77, 0x77, 0x77, 0x77, 0x6B, 0x99, 0x99, 0xA7, 0x77, 0x77, 0x77, 0x6B, 0x99, 0x99, 0x87, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x66, 0x77, 0x77, 0x77, 0x76, 0x99, 0x99, 0x98, 0x77, 0x77, 0x77, 0x78, 0x99, 0x99, 0x96, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x6B, 0x67, 0x77, 0x77, 0x77, 0x89, 0x99, 0x99, 0x67, 0x77, 0x77, 0x77, 0xA9, 0x99, 0x9B, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x69, 0xB6, 0x77, 0x77, 0x77, 0x7A, 0x99, 0x99, 0xB7, 0x77, 0x77, 0x77, 0x7B, 0x99, 0x99, 0xA7, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x79, 0x9A, 0x77, 0x77, 0x77, 0x76, 0xB9, 0x99, 0x9A, 0x77, 0x77, 0x77, 0x76, 0x99, 0x99, 0x98, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x69, 0x99, 0x87, 0x77, 0x77, 0x77, 0x69, 0x99, 0x99, 0x87, 0x77, 0x77, 0x77, 0x89, 0x99, 0x9B, 0x67, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x79, 0x99, 0x96, 0x77, 0x77, 0x77, 0x78, 0x99, 0x99, 0x96, 0x77, 0x77, 0x77, 0x7A, 0x99, 0x99, 0xA7, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x69, 0x99, 0x9B, 0x77, 0x77, 0x77, 0x77, 0xA9, 0x99, 0x9B, 0x77, 0x77, 0x77, 0x76, 0xB9, 0x99, 0x98, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x79, 0x99, 0x99, 0xA7, 0x77, 0x77, 0x77, 0x6B, 0x99, 0x99, 0xA7, 0x77, 0x77, 0x77, 0x89, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x98, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x69, 0x99, 0x99, 0x98, 0x77, 0x77, 0x77, 0x76, 0x99, 0x99, 0x98, 0x77, 0x77, 0x77, 0x7A, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x67, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x79, 0x99, 0x99, 0x99, 0x67, 0x77, 0x77, 0x77, 0x89, 0x99, 0x99, 0x67, 0x77, 0x77, 0x77, 0xB9, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x67, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x69, 0x99, 0x99, 0x99, 0xB7, 0x77, 0x77, 0x77, 0x7A, 0x99, 0x99, 0xB7, 0x77, 0x77, 0x77, 0x69, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x9A, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x79, 0x99, 0x99, 0x99, 0x9A, 0x77, 0x77, 0x77, 0x76, 0xB9, 0x99, 0x98, 0x77, 0x77, 0x77, 0x77, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x67, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x69, 0x99, 0x99, 0x99, 0x9A, 0x77, 0x77, 0x77, 0x77, 0xB9, 0x99, 0x98, 0x77, 0x77, 0x77, 0x77, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x87, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x79, 0x99, 0x99, 0x99, 0xB7, 0x77, 0x77, 0x77, 0x7A, 0x99, 0x99, 0xB7, 0x77, 0x77, 0x77, 0x6B, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x9A, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x69, 0x99, 0x99, 0x99, 0x67, 0x77, 0x77, 0x77, 0x89, 0x99, 0x99, 0x77, 0x77, 0x77, 0x77, 0xB9, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x67, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x79, 0x99, 0x99, 0x98, 0x77, 0x77, 0x77, 0x76, 0x99, 0x99, 0x98, 0x77, 0x77, 0x77, 0x7A, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x67, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x69, 0x99, 0x99, 0xA7, 0x77, 0x77, 0x77, 0x7B, 0x99, 0x99, 0xA7, 0x77, 0x77, 0x77, 0x89, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x98, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x79, 0x99, 0x9B, 0x77, 0x77, 0x77, 0x77, 0xA9, 0x99, 0x9B, 0x77, 0x77, 0x77, 0x76, 0xB9, 0x99, 0x98, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x69, 0x99, 0x96, 0x77, 0x77, 0x77, 0x78, 0x99, 0x99, 0x97, 0x77, 0x77, 0x77, 0x7A, 0x99, 0x99, 0xA7, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x79, 0x99, 0x87, 0x77, 0x77, 0x77, 0x69, 0x99, 0x99, 0x87, 0x77, 0x77, 0x77, 0x89, 0x99, 0x9B, 0x67, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x69, 0x9A, 0x77, 0x77, 0x77, 0x77, 0xB9, 0x99, 0x9A, 0x77, 0x77, 0x77, 0x76, 0x99, 0x99, 0x98, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x79, 0xB7, 0x77, 0x77, 0x77, 0x7A, 0x99, 0x99, 0xB7, 0x77, 0x77, 0x77, 0x7B, 0x99, 0x99, 0xA7, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x6B, 0x67, 0x77, 0x77, 0x77, 0x89, 0x99, 0x99, 0x67, 0x77, 0x77, 0x77, 0xA9, 0x99, 0x9B, 0x77, 0x77, 0x77, 0x75, 0xCC, 0xDC, 0xC6, 0x77, 0x77, 0x77, 0x55, 0x55, 0x55, 0x55, 0x55, 0x67, 0x77, 0x77, 0x75, 0xCC, 0xDC, 0xC6, 0x77, 0x77, 0x77, 0x77, 0x76, 0x5C, 0xDC, 0xCC, 0x67, 0x77, 0x77, 0x77, 0x55, 0x55, 0x55, 0x55, 0x55, 0x77, 0x77, 0x55, 0x55, 0x55, 0x55, 0x67, 0x77, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x66, 0x77, 0x77, 0x77, 0x76, 0x99, 0x99, 0x98, 0x77, 0x77, 0x77, 0x78, 0x99, 0x99, 0x96, 0x77, 0x77, 0x75, 0xDE, 0xEE, 0xEE, 0xEE, 0xC6, 0x77, 0x7C, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xD7, 0x77, 0x75, 0xDE, 0xEE, 0xEE, 0xEE, 0xD6, 0x77, 0x77, 0x77, 0xCE, 0xEE, 0xEE, 0xEE, 0xEC, 0x77, 0x77, 0x7D, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xC7, 0x7C, 0xEE, 0xEE, 0xEE, 0xEE, 0xED, 0x57, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x77, 0x77, 0x77, 0x77, 0x7B, 0x99, 0x99, 0xA7, 0x77, 0x77, 0x77, 0x6B, 0x99, 0x99, 0x87, 0x77, 0x77, 0x6E, 0xEE, 0xED, 0xDD, 0xEE, 0xED, 0x77, 0x7D, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xD7, 0x77, 0xCE, 0xEE, 0xED, 0xDE, 0xEE, 0xED, 0x67, 0x77, 0x7D, 0xEE, 0xEE, 0xDD, 0xEE, 0xEE, 0xD7, 0x77, 0x6F, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xC7, 0x7D, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xE5, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x77, 0x77, 0x77, 0x77, 0xA9, 0x99, 0x9B, 0x77, 0x77, 0x77, 0x77, 0xA9, 0x99, 0x9A, 0x77, 0x77, 0x77, 0xCE, 0xED, 0x67, 0x76, 0xCE, 0xEE, 0x67, 0x7D, 0xEE, 0xD5, 0x55, 0x55, 0x55, 0x77, 0x75, 0xEE, 0xED, 0x56, 0x76, 0xCE, 0xEE, 0xC7, 0x77, 0xCE, 0xEE, 0xD6, 0x67, 0x6C, 0xEE, 0xE5, 0x77, 0x6D, 0xEE, 0xC5, 0x55, 0x55, 0x56, 0x77, 0x6D, 0xEE, 0xC5, 0x55, 0x5C, 0xEE, 0xED, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x77, 0x77, 0x77, 0x78, 0x99, 0x99, 0x96, 0x77, 0x77, 0x77, 0x78, 0x99, 0x99, 0xB6, 0x77, 0x77, 0x77, 0xDE, 0xED, 0x77, 0x77, 0x75, 0xDC, 0x77, 0x7D, 0xEE, 0xC7, 0x77, 0x77, 0x77, 0x77, 0x7D, 0xEE, 0xD7, 0x77, 0x77, 0x7C, 0xED, 0x57, 0x76, 0xDE, 0xED, 0x77, 0x77, 0x77, 0xCE, 0xD6, 0x77, 0x6F, 0xEE, 0x57, 0x77, 0x77, 0x77, 0x77, 0x7D, 0xEE, 0xC7, 0x77, 0x77, 0xCE, 0xED, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x77, 0x77, 0x77, 0x69, 0x99, 0x99, 0x87, 0x77, 0x77, 0x77, 0x69, 0x99, 0x99, 0x87, 0x77, 0x77, 0x77, 0xCE, 0xEE, 0xDC, 0x56, 0x77, 0x77, 0x77, 0x7D, 0xEE, 0xC6, 0x66, 0x66, 0x67, 0x77, 0x6E, 0xEE, 0xC7, 0x77, 0x77, 0x77, 0x77, 0x77, 0x75, 0xEE, 0xE5, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x7F, 0xEE, 0xC6, 0x66, 0x66, 0x67, 0x77, 0x6D, 0xEE, 0xC7, 0x77, 0x77, 0xDE, 0xED, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x77, 0x77, 0x77, 0xB9, 0x99, 0x9A, 0x77, 0x77, 0x77, 0x77, 0xB9, 0x99, 0x9A, 0x77, 0x77, 0x77, 0x77, 0x6D, 0xEE, 0xEE, 0xED, 0xDC, 0x67, 0x77, 0x7D, 0xEE, 0xEE, 0xEE, 0xEE, 0xED, 0x67, 0x5E, 0xEE, 0x67, 0x77, 0x76, 0x66, 0x66, 0x67, 0x7C, 0xEE, 0xE7, 0x77, 0x77, 0x66, 0x66, 0x67, 0x77, 0x6D, 0xEE, 0xEE, 0xEE, 0xEE, 0xEC, 0x67, 0x7D, 0xEE, 0xDC, 0xCC, 0xCD, 0xEE, 0xE5, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x77, 0x77, 0x7A, 0x99, 0x99, 0xB7, 0x77, 0x77, 0x77, 0x7A, 0x99, 0x99, 0xB7, 0x77, 0x77, 0x77, 0x77, 0x75, 0xCE, 0xEE, 0xEE, 0xEE, 0xEC, 0x77, 0x7D, 0xEE, 0xEE, 0xEE, 0xEE, 0xEF, 0x67, 0xCE, 0xEE, 0x67, 0x77, 0x5E, 0xEE, 0xEE, 0xD6, 0x7C, 0xEE, 0xD7, 0x77, 0x7C, 0xEE, 0xEE, 0xED, 0x67, 0x6F, 0xEE, 0xEE, 0xEE, 0xEE, 0xED, 0x77, 0x6D, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0x57, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x77, 0x77, 0x89, 0x99, 0x99, 0x67, 0x77, 0x77, 0x77, 0x89, 0x99, 0x99, 0x67, 0x77, 0x77, 0x77, 0x77, 0x77, 0x76, 0x5C, 0xDE, 0xEE, 0xEE, 0xC7, 0x7D, 0xEE, 0xD5, 0xC5, 0xC5, 0x55, 0x77, 0x5E, 0xEE, 0x57, 0x77, 0xCE, 0xEE, 0xEE, 0xE5, 0x7C, 0xEE, 0xE6, 0x77, 0x7C, 0xEE, 0xEE, 0xEE, 0x67, 0x6F, 0xEE, 0xCC, 0x55, 0xC5, 0x56, 0x77, 0x7D, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xC6, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x77, 0x76, 0x99, 0x99, 0x98, 0x77, 0x77, 0x77, 0x77, 0xB9, 0x99, 0x98, 0x77, 0x77, 0x77, 0x77, 0x77, 0x75, 0x57, 0x77, 0x77, 0xCE, 0xEE, 0xD7, 0x7D, 0xEE, 0xC7, 0x77, 0x77, 0x77, 0x77, 0x6E, 0xEE, 0xC7, 0x77, 0x75, 0x55, 0xDE, 0xE5, 0x75, 0xEE, 0xE5, 0x77, 0x76, 0x55, 0x5F, 0xEE, 0x67, 0x6D, 0xEE, 0x57, 0x77, 0x77, 0x77, 0x77, 0x6D, 0xEE, 0xC6, 0x66, 0x6C, 0xEE, 0xE5, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x77, 0x7B, 0x99, 0x99, 0xA7, 0x77, 0x77, 0x77, 0x7A, 0x99, 0x99, 0xA7, 0x77, 0x77, 0x77, 0x77, 0x77, 0xCE, 0xEC, 0x77, 0x77, 0x7C, 0xEE, 0xD6, 0x7D, 0xEE, 0xC7, 0x77, 0x77, 0x77, 0x77, 0x7D, 0xEE, 0xD6, 0x77, 0x77, 0x75, 0xEE, 0xE5, 0x77, 0xDE, 0xED, 0x67, 0x77, 0x77, 0xCE, 0xEE, 0x67, 0x6F, 0xEE, 0x57, 0x77, 0x77, 0x77, 0x77, 0x7D, 0xEE, 0xC7, 0x77, 0x76, 0xEE, 0xEC, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x77, 0xA9, 0x99, 0x9B, 0x77, 0x77, 0x77, 0x77, 0x89, 0x99, 0x99, 0x67, 0x77, 0x77, 0x77, 0x77, 0x77, 0xCE, 0xEE, 0xC6, 0x76, 0x5D, 0xEE, 0xD7, 0x7D, 0xEE, 0xDC, 0xCC, 0xCC, 0xCC, 0x57, 0x75, 0xEE, 0xED, 0xC6, 0x66, 0xCE, 0xEE, 0xE5, 0x77, 0x5E, 0xEE, 0xD5, 0x66, 0x5C, 0xEE, 0xEE, 0x67, 0x7F, 0xEE, 0xCC, 0xCC, 0xCC, 0xCC, 0x67, 0x6D, 0xEE, 0xC7, 0x77, 0x77, 0xEE, 0xEC, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x76, 0x99, 0x99, 0x96, 0x77, 0x77, 0x77, 0x77, 0xB9, 0x99, 0x98, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x6D, 0xEE, 0xEE, 0xDE, 0xEE, 0xEE, 0x67, 0x7D, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xF5, 0x77, 0x5E, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xE5, 0x77, 0x7C, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0x67, 0x6D, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xF7, 0x7F, 0xEE, 0xC7, 0x77, 0x77, 0xDE, 0xED, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x76, 0x99, 0x99, 0x87, 0x77, 0x77, 0x77, 0x77, 0xB9, 0x99, 0xA7, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x76, 0xCE, 0xEE, 0xEE, 0xEE, 0xD5, 0x77, 0x75, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xF5, 0x77, 0x75, 0xDE, 0xEE, 0xEE, 0xEC, 0x5E, 0xE5, 0x77, 0x77, 0xCD, 0xEE, 0xEE, 0xEE, 0xC5, 0xEE, 0x67, 0x7D, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xD7, 0x7D, 0xEE, 0x57, 0x77, 0x77, 0xCE, 0xEC, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x77, 0x89, 0x9A, 0x77, 0x77, 0x77, 0x77, 0x77, 0x6B, 0x9B, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x76, 0xCC, 0xCC, 0xC5, 0x77, 0x77, 0x77, 0x65, 0x55, 0x55, 0x55, 0x55, 0x67, 0x77, 0x77, 0x75, 0xCC, 0xCC, 0x67, 0x75, 0xC7, 0x77, 0x77, 0x77, 0x5C, 0xCC, 0xC6, 0x76, 0xC5, 0x77, 0x77, 0x65, 0x55, 0x55, 0x55, 0x55, 0x77, 0x76, 0x55, 0x77, 0x77, 0x77, 0x65, 0x56, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x77, 0x76, 0x67, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x67, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x44, 0x46, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x64, 0x44,
  0x34, 0x45, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x54, 0x43,
  0x24, 0x44, 0x56, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x65, 0x44, 0x42,
  0x13, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x31,
  0x02, 0x34, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x43, 0x20,
  0x00, 0x12, 0x34, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x43, 0x21, 0x00
};

/* Logo bitmap */
static GUI_CONST_STORAGE GUI_BITMAP _bmLogoBitmap = {
  140, /* XSize */
  66,  /* YSize */
  70,  /* BytesPerLine */
  4,   /* BitsPerPixel */
  _acLogoSegger,   /* Pointer to picture data (indices) */
  &_PalLogoSegger, /* Pointer to palette */
  NULL,  /* Pointer to methods */
};

/* Resource for DialogIntro (0, 0) - (319, 239) */
static const GUI_WIDGET_CREATE_INFO _aDialogIntro[] = {
  { WINDOW_CreateIndirect,    "",                    0,                0,   0,   320, 240, 0,0,0},
  { BUTTON_CreateIndirect,    "Start",               GUI_ID_BUTTON0,   30,  210, 120, 20,  0,0,0},
  { BUTTON_CreateIndirect,    "Calibrate",           GUI_ID_BUTTON1,   170, 210, 120, 20,  0,0,0}
};

/* Text shown in the DialogIntro dialog */
static const char * _apDialogIntro[] = {
  "This sample demonstrates GRAPH widget usage.",
  "Press the <Start> button to run example,",
  "or <Calibrate> to calibrate touch panel."
};

static GRAPH_SCALE_Handle _hScaleV;   /* Handle of vertical scale */
static GRAPH_SCALE_Handle _hScaleH;   /* Handle of horizontal scale */

static const GUI_COLOR _aColor[3] = {GUI_RED, GUI_DARKGREEN, GUI_MAGENTA};
static const U8 _aLStyle[3] = {GUI_LS_SOLID, GUI_LS_DOT, GUI_LS_DASH};

/* Dialog ressource */
static const GUI_WIDGET_CREATE_INFO _aDialogCreate[] = {
  { FRAMEWIN_CreateIndirect, "GRAPH_DATA_XY demo", 0                ,   0,   0, 320, 240, FRAMEWIN_CF_MOVEABLE, 0, 0 },
  { GRAPH_CreateIndirect,     0,                   GUI_ID_GRAPH0    ,   5,   5, 270, 175, 0,0,0 },
  { TEXT_CreateIndirect,      "Spacing X:",        0                ,   5, 185,  50,  20, 0,0,0 },
  { TEXT_CreateIndirect,      "Spacing Y:",        0                ,   5, 205,  50,  20, 0,0,0 },
  { SLIDER_CreateIndirect,    0,                   GUI_ID_SLIDER0   ,  55, 185,  60,  16, 0,0,0 },
  { SLIDER_CreateIndirect,    0,                   GUI_ID_SLIDER1   ,  55, 205,  60,  16, 0,0,0 },
  { CHECKBOX_CreateIndirect,  0,                   GUI_ID_CHECK8    , 120, 185,  50,   0, 0,0,0 },
  { CHECKBOX_CreateIndirect,  0,                   GUI_ID_CHECK9    , 120, 205,  50,   0, 0,0,0 },
  { RADIO_CreateIndirect,     0,                   GUI_ID_RADIO1    , 170, 180,  40,   0, 0, (13 << 8) | 3, 0 },
  { TEXT_CreateIndirect,      "Border",            0                , 280,   5,  35,  15, 0,0,0 },
  { CHECKBOX_CreateIndirect,  0,                   GUI_ID_CHECK2    , 280,  20,  35,   0, 0,0,0 },
  { CHECKBOX_CreateIndirect,  0,                   GUI_ID_CHECK3    , 280,  40,  35,   0, 0,0,0 },
  { CHECKBOX_CreateIndirect,  0,                   GUI_ID_CHECK4    , 280,  60,  35,   0, 0,0,0 },
  { CHECKBOX_CreateIndirect,  0,                   GUI_ID_CHECK5    , 280,  80,  35,   0, 0,0,0 },
  { TEXT_CreateIndirect,      "Effect",            0                , 280, 100,  35,  15, 0,0,0 },
  { RADIO_CreateIndirect,     0,                   GUI_ID_RADIO0    , 275, 115,  35,   0, 0, (20 << 8) | 3, 0 },
  { CHECKBOX_CreateIndirect,  0,                   GUI_ID_CHECK6    , 215, 185,  50,   0, 0,0,0 },
  { CHECKBOX_CreateIndirect,  0,                   GUI_ID_CHECK7    , 215, 205,  50,   0, 0,0,0 },
  { BUTTON_CreateIndirect,    "",                  GUI_ID_BUTTON0   , 270, 185,  40,  18, 0,0,0 },
  { CHECKBOX_CreateIndirect,  0,                   GUI_ID_CHECK1    , 270, 205,  40,   0, 0,0,0 },
};

/* Misc. */
static int         _NumPoints;
static const int   _aNumPoints[] = { 46, 25, 13 };
static GUI_POINT   _aPoint[3][46];
GRAPH_DATA_Handle  _ahDataXY[3];

/*********************************************************************
*
*       Static code
*
**********************************************************************
*/

static void _Delay(int Period) {
  if (!DO_DELAY) Period = 0;
  int EndTime = GUI_GetTime() + Period;
  int tRem; /* remaining Time */
  int delay;

  while (tRem = EndTime - GUI_GetTime(), tRem > 0)
  {
    if( GUI_Exec() )
      delay = SHORT_DELAY;
    else
      delay = LONG_DELAY;
    if(tRem < delay)
      delay = tRem;
    GUI_X_Delay(delay);
  }
}

/*********************************************************************
*
*       _cbDialog
*/
static void _cbDialog(WM_MESSAGE * pMsg) {
  WM_HWIN hItem;
  static int point = 0;
  static U8 PressedPrev = 0;
  const POINT Points[3] = { {40, 40}, {280, 120}, {160, 200} }; /* calibration points on screen */
  static POINT PointsScr[3];

  // USER START (Optionally insert additional variables)
  // USER END

  switch (pMsg->MsgId) {
  case WM_INIT_DIALOG:
    //
    // Initialization of 'Calibration'
    //
    hItem = pMsg->hWin;
    WINDOW_SetBkColor(hItem, 0x00000000);
    //
    // Initialization of 'Instruction'
    //
    hItem = WM_GetDialogItem(pMsg->hWin, ID_TEXT_0);
    TEXT_SetText(hItem, "Press calibration point");
    TEXT_SetTextColor(hItem, 0x0080FFFF);
    TEXT_SetTextAlign(hItem, GUI_TA_HCENTER | GUI_TA_VCENTER);
    TEXT_SetFont(hItem, GUI_FONT_16_1);
    GUI_CURSOR_Select(&GUI_CursorCrossM);
    GUI_CURSOR_SetPosition(Points[0].x, Points[0].y);
    GUI_CURSOR_Show();
    point = 0;
    PressedPrev = 0;
    /* draw first cross here */
    // USER START (Optionally insert additional code for further widget initialization)
  case WM_TOUCH:
  case WM_TOUCH_CHILD:
    { TOUCH_Pos_TypeDef *pos = TOUCH_GetPos();  /* get information from touchpanel */
      GUI_PID_STATE *pInfo;
      pInfo = (GUI_PID_STATE *)pMsg->Data.p;
      switch(point)
      { case 0:
        case 1:
        case 2: GUI_CURSOR_SetPosition(Points[point].x, Points[point].y); break;
       default: GUI_CURSOR_Select(&GUI_CursorArrowM);
                GUI_EndDialog(pMsg->hWin, 0);
      }
      if(pInfo->Layer==0)
      {
        if( (pos->pen == 1) && (PressedPrev==0) )
        {
          PointsScr[point].x = pos->adcx;
          PointsScr[point].y = pos->adcy;
          if(point==2)
          {
            TOUCH_CalibrationTable((POINT *)Points, PointsScr);
          }
          point++;
        }
        PressedPrev = pos->pen;
      }
    }

    // USER END
    break;
  // USER START (Optionally insert additional message handling)
  // USER END
  default:
    WM_DefaultProc(pMsg);
    break;
  }
}

/*********************************************************************
*
*       _cbDialogIntro
*
* Purpose:
*   Callback routine of DialogIntro
*/
static void _cbDialogIntro(WM_MESSAGE * pMsg) {
  WM_HWIN hDlg;
  GUI_RECT Rect;
  int Id, i, ySizeText, yPos = 40;
  hDlg = pMsg->hWin;
  switch (pMsg->MsgId) {
  case WM_PAINT:
    WM_GetClientRect(&Rect);
    GUI_SetBkColor(GUI_WHITE);
    GUI_SetColor(GUI_BLACK);
    GUI_Clear();
    GUI_SetFont(&GUI_Font24_ASCII);
    GUI_DispStringHCenterAt("GRAPH Widget", 160, 5);
    GUI_SetFont(&GUI_Font13B_ASCII);
    GUI_DrawBitmap(&_bmLogoBitmap, (Rect.x1 - _bmLogoBitmap.XSize) / 2, yPos);
    ySizeText = GUI_GetFontSizeY();
    yPos += _bmLogoBitmap.YSize + 15;
    for (i = 0; i < (int)GUI_COUNTOF(_apDialogIntro); i++) {
      GUI_DispStringHCenterAt(_apDialogIntro[i], Rect.x1 / 2, yPos);
      yPos += ySizeText;
    }
    break;
  case WM_NOTIFY_PARENT:
    if (pMsg->Data.v == WM_NOTIFICATION_RELEASED) {
      Id = WM_GetId(pMsg->hWinSrc);      /* Id of widget */
      if (Id == GUI_ID_BUTTON0) {
        GUI_EndDialog(hDlg, 0);
      }
      if (Id == GUI_ID_BUTTON1) {
        GUI_ExecDialogBox(_aCalCreate, GUI_COUNTOF(_aCalCreate), &_cbDialog, hDlg, 0, 0);
      }
    }
    break;
  default:
    WM_DefaultProc(pMsg);
  }
}

/*********************************************************************
*
*       _InitPoints
*/
static void _InitPoints(int NumPoints) {
  int i, r, m;

  _NumPoints = NumPoints;
  m = 360 / (_NumPoints - 1);
  r = 95;
  for (i = 0; i <= _NumPoints - 1; i++) {
    float Rad;
    int Deg;
    Deg = i * m;
    Rad = Deg * DEG2RAD;
    _aPoint[0][i].x = (int)(100 - r * cos(Rad));
    _aPoint[0][i].y = (int)(100 + r * sin(Rad) * Deg / 360);
    _aPoint[1][i].x = (int)(100 - r * cos(Rad));
    _aPoint[1][i].y = (int)(100 + r * sin(Rad) * Deg / 300);
    _aPoint[2][i].x = (int)(100 - r * cos(Rad) * 0.9);
    _aPoint[2][i].y = (int)(100 + r * sin(Rad) * Deg / 320);
  }
}

/*********************************************************************
*
*       _OwnerDraw
*/
static int _OwnerDraw(const WIDGET_ITEM_DRAW_INFO * pDrawItemInfo) {
  switch (pDrawItemInfo->Cmd) {
  case WIDGET_ITEM_DRAW:
    GUI_DrawRect(pDrawItemInfo->x0 - 3, pDrawItemInfo->y0 - 3, pDrawItemInfo->x0 + 3, pDrawItemInfo->y0 + 3);
    break;
  }
  return 0;
}

/*********************************************************************
*
*       _UserDraw
*
* Purpose:
*   This routine is called by the GRAPH object before anything is drawn
*   and after the last drawing operation.
*/
static void _UserDraw(WM_HWIN hWin, int Stage) {
  if (Stage == GRAPH_DRAW_LAST) {
    char acText[] = "Flow Rate L/s";
    GUI_RECT Rect, RectInvalid;
    int FontSizeY;
    GUI_SetFont(&GUI_Font13_ASCII);
    FontSizeY = GUI_GetFontSizeY();
    WM_GetInsideRect(&Rect);
    WM_GetInvalidRect(hWin, &RectInvalid);
    Rect.x1 = Rect.x0 + FontSizeY;
    GUI_SetColor(GUI_RED);
    GUI_DispStringInRectEx(acText, &Rect, GUI_TA_HCENTER, strlen(acText), GUI_ROTATE_CCW);
  }
}

/*********************************************************************
*
*       _ForEach
*
* Purpose:
*   This routine hides/shows all windows except the button, graph and scroll bar widgets
*/
static void _ForEach(WM_HWIN hWin, void * pData) {
  int Id, FullScreenMode;
  FullScreenMode = *(int *)pData;
  Id = WM_GetId(hWin);
  if ((Id == GUI_ID_GRAPH0) || (Id == GUI_ID_BUTTON0) || (Id == GUI_ID_VSCROLL) || (Id == GUI_ID_HSCROLL)) {
    return;
  }
  if (FullScreenMode) {
    WM_HideWindow(hWin);
  } else {
    WM_ShowWindow(hWin);
  }
}

/*********************************************************************
*
*       _ToggleFullScreenMode
*
* Purpose:
*   This routine switches between full screen mode and normal mode by hiding or showing the
*   widgets of the dialog, enlarging/shrinking the graph widget and modifying some other
*   attributes of the dialog widgets.
*/
static void _ToggleFullScreenMode(WM_HWIN hDlg) {
  static int FullScreenMode;
  static GUI_RECT Rect;
  static unsigned ScalePos;
  WM_HWIN hGraph, hButton;
  hGraph  = WM_GetDialogItem(hDlg, GUI_ID_GRAPH0);
  hButton = WM_GetDialogItem(hDlg, GUI_ID_BUTTON0);
  FullScreenMode ^= 1;
  if (FullScreenMode) {
    /* Enter the full screen mode */
    WM_HWIN hClient;
    GUI_RECT RectInside;
    hClient = WM_GetClientWindow(hDlg);
    BUTTON_SetBitmapEx(hButton, BUTTON_BI_PRESSED,   &_bmShrink, 12, 2);
    BUTTON_SetBitmapEx(hButton, BUTTON_BI_UNPRESSED, &_bmShrink, 12, 2);
    WM_MoveWindow(hButton, 0, 11);
    FRAMEWIN_SetTitleVis(hDlg, 0);
    WM_GetInsideRectEx(hClient, &RectInside);
    WM_GetWindowRectEx(hGraph, &Rect);
    WM_ForEachDesc(hClient, _ForEach, &FullScreenMode); /* Hide all descendants */
    WM_SetWindowPos(hGraph, WM_GetWindowOrgX(hClient), WM_GetWindowOrgX(hClient), RectInside.x1, RectInside.y1);
    ScalePos = GRAPH_SCALE_SetPos(_hScaleH, RectInside.y1 - 105);
  } else {
    /* Return to normal mode */
    BUTTON_SetBitmapEx(hButton, BUTTON_BI_PRESSED,   &_bmEnlarge, 12, 2);
    BUTTON_SetBitmapEx(hButton, BUTTON_BI_UNPRESSED, &_bmEnlarge, 12, 2);
    WM_MoveWindow(hButton, 0, -11);
    WM_ForEachDesc(WM_GetClientWindow(hDlg), _ForEach, &FullScreenMode); /* Show all descendants */
    WM_SetWindowPos(hGraph, Rect.x0, Rect.y0, Rect.x1 - Rect.x0 + 1, Rect.y1 - Rect.y0 + 1);
    FRAMEWIN_SetTitleVis(hDlg, 1);
    GRAPH_SCALE_SetPos(_hScaleH, ScalePos);
  }
}

/*********************************************************************
*
*       _cbCallback
*
* Purpose:
*   Callback function of the dialog
*/
static void _cbCallback(WM_MESSAGE * pMsg) {
  int NCode, Id, Value, i, j;
  WM_HWIN hDlg, hItem;
  hDlg = pMsg->hWin;
  switch (pMsg->MsgId) {
  case WM_INIT_DIALOG:
    hItem = WM_GetDialogItem(hDlg, GUI_ID_GRAPH0);
    _InitPoints(_aNumPoints[0]);
    /* Add graphs */
    for (i = 0; i < 3; i++) {
      _ahDataXY[i] = GRAPH_DATA_XY_Create(_aColor[i], _NumPoints, _aPoint[i], _NumPoints);
      GRAPH_DATA_XY_SetLineStyle(_ahDataXY[i], _aLStyle[i]);
      GRAPH_AttachData(hItem, _ahDataXY[i]);
      GRAPH_DATA_XY_SetOwnerDraw(_ahDataXY[i], _OwnerDraw);
    }
    /* Set graph attributes */
    GRAPH_SetGridDistY(hItem, 25);
    GRAPH_SetGridVis(hItem, 1);
    GRAPH_SetUserDraw(hItem, _UserDraw);
    /* Create and add vertical scale */
    _hScaleV = GRAPH_SCALE_Create( 35, GUI_TA_RIGHT, GRAPH_SCALE_CF_VERTICAL, 25);
    GRAPH_SCALE_SetOff(_hScaleV, 100);
    GRAPH_SCALE_SetFactor(_hScaleV, 0.04f);
    GRAPH_SCALE_SetTextColor(_hScaleV, GUI_RED);
    GRAPH_AttachScale(hItem, _hScaleV);
    /* Create and add horizontal scale */
    _hScaleH = GRAPH_SCALE_Create(70, GUI_TA_HCENTER, GRAPH_SCALE_CF_HORIZONTAL, 50);
    GRAPH_SCALE_SetFactor(_hScaleH, 0.02f);
    GRAPH_SCALE_SetTextColor(_hScaleH, GUI_DARKGREEN);
    GRAPH_AttachScale(hItem, _hScaleH);
    /* Init check boxes */
    hItem = WM_GetDialogItem(hDlg, GUI_ID_CHECK2);
    CHECKBOX_SetText(hItem, "L");
    CHECKBOX_SetState(hItem, 1);
    hItem = WM_GetDialogItem(hDlg, GUI_ID_CHECK3);
    CHECKBOX_SetText(hItem, "T");
    hItem = WM_GetDialogItem(hDlg, GUI_ID_CHECK4);
    CHECKBOX_SetText(hItem, "R");
    hItem = WM_GetDialogItem(hDlg, GUI_ID_CHECK5);
    CHECKBOX_SetText(hItem, "B");
    hItem = WM_GetDialogItem(hDlg, GUI_ID_CHECK1);
    CHECKBOX_SetText(hItem, "Grid");
    CHECKBOX_SetState(hItem, 1);
    hItem = WM_GetDialogItem(hDlg, GUI_ID_CHECK6);
    CHECKBOX_SetText(hItem, "HScroll");
    hItem = WM_GetDialogItem(hDlg, GUI_ID_CHECK7);
    CHECKBOX_SetText(hItem, "VScroll");
    hItem = WM_GetDialogItem(hDlg, GUI_ID_CHECK8);
    CHECKBOX_SetText(hItem, "Lines");
    CHECKBOX_SetState(hItem, 1);
    hItem = WM_GetDialogItem(hDlg, GUI_ID_CHECK9);
    CHECKBOX_SetText(hItem, "Points");
    CHECKBOX_SetState(hItem, 1);
    /* Init slider widgets */
    hItem = WM_GetDialogItem(hDlg, GUI_ID_SLIDER0);
    SLIDER_SetRange(hItem, 0, 10);
    SLIDER_SetValue(hItem, 5);
    SLIDER_SetNumTicks(hItem, 6);
    hItem = WM_GetDialogItem(hDlg, GUI_ID_SLIDER1);
    SLIDER_SetRange(hItem, 0, 20);
    SLIDER_SetValue(hItem, 5);
    SLIDER_SetNumTicks(hItem, 6);
    /* Init radio widget */
    hItem = WM_GetDialogItem(hDlg, GUI_ID_RADIO0);
    RADIO_SetText(hItem, "3D", 0);
    RADIO_SetText(hItem, "flat", 1);
    RADIO_SetText(hItem, "-", 2);
    hItem = WM_GetDialogItem(hDlg, GUI_ID_RADIO1);
    RADIO_SetFont(hItem, &GUI_Font10_ASCII);
    RADIO_SetText(hItem, "fine", 0);
    RADIO_SetText(hItem, "med.", 1);
    RADIO_SetText(hItem, "raw",  2);
    RADIO_SetValue(hItem, 2);
    /* Init button widget */
    hItem = WM_GetDialogItem(hDlg, GUI_ID_BUTTON0);
    BUTTON_SetBitmapEx(hItem, BUTTON_BI_PRESSED,   &_bmEnlarge, 12, 2);
    BUTTON_SetBitmapEx(hItem, BUTTON_BI_UNPRESSED, &_bmEnlarge, 12, 2);
    WM_SetStayOnTop(hItem, 1);
    break;
  case WM_NOTIFY_PARENT:
    Id    = WM_GetId(pMsg->hWinSrc);      /* Id of widget */
    NCode = pMsg->Data.v;                 /* Notification code */
    switch (NCode) {
    case WM_NOTIFICATION_CLICKED:
      switch (Id) {
      case GUI_ID_BUTTON0:
        _ToggleFullScreenMode(hDlg);
        break;
      }
      break;
    case WM_NOTIFICATION_VALUE_CHANGED:
      switch (Id) {
      case GUI_ID_CHECK1:
        /* Toggle grid */
        hItem = WM_GetDialogItem(hDlg, GUI_ID_GRAPH0);
        GRAPH_SetGridVis(hItem, CHECKBOX_IsChecked(WM_GetDialogItem(hDlg, GUI_ID_CHECK1)));
        break;
      case GUI_ID_CHECK2:
      case GUI_ID_CHECK3:
      case GUI_ID_CHECK4:
      case GUI_ID_CHECK5:
        /* Toggle border */
        hItem = WM_GetDialogItem(hDlg, GUI_ID_GRAPH0);
        GRAPH_SetBorder(hItem,
                        CHECKBOX_IsChecked(WM_GetDialogItem(hDlg, GUI_ID_CHECK2)) * 40,
                        CHECKBOX_IsChecked(WM_GetDialogItem(hDlg, GUI_ID_CHECK3)) * 5,
                        CHECKBOX_IsChecked(WM_GetDialogItem(hDlg, GUI_ID_CHECK4)) * 5,
                        CHECKBOX_IsChecked(WM_GetDialogItem(hDlg, GUI_ID_CHECK5)) * 5);
        break;
      case GUI_ID_CHECK6:
        /* Toggle horizontal scroll bar */
        hItem = WM_GetDialogItem(hDlg, GUI_ID_GRAPH0);
        if (CHECKBOX_IsChecked(WM_GetDialogItem(hDlg, GUI_ID_CHECK6))) {
          GRAPH_SetVSizeX(hItem, 500);
        } else {
          GRAPH_SetVSizeX(hItem, 0);
        }
        break;
      case GUI_ID_CHECK7:
        /* Toggle vertical scroll bar */
        hItem = WM_GetDialogItem(hDlg, GUI_ID_GRAPH0);
        if (CHECKBOX_IsChecked(WM_GetDialogItem(hDlg, GUI_ID_CHECK7))) {
          GRAPH_SetVSizeY(hItem, 300);
        } else {
          GRAPH_SetVSizeY(hItem, 0);
        }
        break;
      case GUI_ID_CHECK8:
        Value = CHECKBOX_IsChecked(WM_GetDialogItem(hDlg, Id));
        for (i = 0; i < 3; i++) {
          GRAPH_DATA_XY_SetLineVis(_ahDataXY[i], Value);
        }
        break;
      case GUI_ID_CHECK9:
        Value = CHECKBOX_IsChecked(WM_GetDialogItem(hDlg, Id));
        for (i = 0; i < 3; i++) {
          GRAPH_DATA_XY_SetPointVis(_ahDataXY[i], Value);
        }
        break;
      case GUI_ID_SLIDER0:
        /* Set horizontal grid spacing */
        hItem = WM_GetDialogItem(hDlg, GUI_ID_GRAPH0);
        Value = SLIDER_GetValue(pMsg->hWinSrc) * 10;
        GRAPH_SetGridDistX(hItem, Value);
        GRAPH_SCALE_SetTickDist(_hScaleH, Value);
        if (Value != 50) {
          GRAPH_SCALE_SetNumDecs(_hScaleH, 1);
        } else {
          GRAPH_SCALE_SetNumDecs(_hScaleH, 0);
        }
        break;
      case GUI_ID_SLIDER1:
        /* Set vertical grid spacing */
        hItem = WM_GetDialogItem(hDlg, GUI_ID_GRAPH0);
        Value = SLIDER_GetValue(pMsg->hWinSrc) * 5;
        GRAPH_SetGridDistY(hItem, Value);
        GRAPH_SCALE_SetTickDist(_hScaleV, Value);
        if (Value != 25) {
          GRAPH_SCALE_SetNumDecs(_hScaleV, 1);
        } else {
          GRAPH_SCALE_SetNumDecs(_hScaleV, 0);
        }
        break;
      case GUI_ID_RADIO0:
        /* Set the widget effect */
        hItem = WM_GetDialogItem(hDlg, GUI_ID_GRAPH0);
        switch (RADIO_GetValue(pMsg->hWinSrc)) {
        case 0:
          WIDGET_SetEffect(hItem, &WIDGET_Effect_3D);
          break;
        case 1:
          WIDGET_SetEffect(hItem, &WIDGET_Effect_Simple);
          break;
        case 2:
          WIDGET_SetEffect(hItem, &WIDGET_Effect_None);
          break;
        }
        break;
      case GUI_ID_RADIO1:
        /* Set number of points */
        Value = _aNumPoints[RADIO_GetValue(pMsg->hWinSrc)];
        _InitPoints(Value);
        for (i = 0; i < 3; i++) {
          GRAPH_DATA_XY_Clear(_ahDataXY[i]);
          for (j = 0; j < _NumPoints; j++) {
            GRAPH_DATA_XY_AddPoint(_ahDataXY[i], &_aPoint[i][j]);
          }
        }
        break;
      }
      break;
    }
    break;
  default:
    WM_DefaultProc(pMsg);
  }
}

/*********************************************************************
*
*       Public code
*
**********************************************************************
*/
/*********************************************************************
*
*       MainTask
*/
int main(void) {

  GUI_Init();
  GUI_CURSOR_Show();
  WM_SetDesktopColor(GUI_BLACK);
  #if GUI_SUPPORT_MEMDEV
    WM_SetCreateFlags(WM_CF_MEMDEV);
  #endif
    /* Execute the intro dialog */
  GUI_ExecDialogBox(_aDialogIntro, GUI_COUNTOF(_aDialogIntro), _cbDialogIntro, WM_HBKWIN, 0, 0);

  /* Execute main application window */
  GUI_CreateDialogBox(_aDialogCreate, GUI_COUNTOF(_aDialogCreate), &_cbCallback, 0, 0, 0);
  while (1) {
    _Delay(100);
  }
}

/*************************** End of file ****************************/
