/*********************************************************************
*                SEGGER Microcontroller GmbH & Co. KG                *
*        Solutions for real time microcontroller applications        *
**********************************************************************
*                                                                    *
*        (c) 1996 - 2016  SEGGER Microcontroller GmbH & Co. KG       *
*                                                                    *
*        Internet: www.segger.com    Support:  support@segger.com    *
*                                                                    *
**********************************************************************

** emWin V5.34 - Graphical user interface for embedded applications **
All  Intellectual Property rights  in the Software belongs to  SEGGER.
emWin is protected by  international copyright laws.  Knowledge of the
source code may not be used to write a similar product.  This file may
only be used in accordance with the following terms:

The  software has  been licensed  to Silicon Labs Norway, a subsidiary
of Silicon Labs Inc. whose registered office is 400 West Cesar Chavez,
Austin,  TX 78701, USA solely for  the purposes of creating  libraries 
for its  ARM Cortex-M3, M4F  processor-based devices,  sublicensed and 
distributed  under the  terms and conditions  of the  End User License  
Agreement supplied by Silicon Labs.
Full source code is available at: www.segger.com

We appreciate your understanding and fairness.
----------------------------------------------------------------------
Licensing information

Licensor:                 SEGGER Software GmbH
Licensed to:              Silicon Laboratories Norway
Licensed SEGGER software: emWin
License number:           GUI-00140
License model:            See Agreement, dated 20th April 2012
Licensed product:         - 
Licensed platform:        Cortex M3, Cortex M4F
Licensed number of seats: -
----------------------------------------------------------------------
File        : GUIResource.c
Purpose     : Contains fonts and bitmaps used in the example.
---------------------------END-OF-HEADER------------------------------
*/

#include <stddef.h>
#include "GUI.h"

#ifndef GUI_CONST_STORAGE
  #define GUI_CONST_STORAGE const
#endif

/*********************************************************************
*                                                                    *
*       Fonts                                                        *
*                                                                    *
**********************************************************************
*/
/*********************************************************************
*
*       Antialiased digit font for labeling
*/
GUI_CONST_STORAGE unsigned char acGUI_FontD9_AA4_0030[ 36] = { /* code 0030, DIGIT ZERO */
  0x07, 0xEF, 0x91, 0x00,
  0x4F, 0xCA, 0xF7, 0x00,
  0x8F, 0x20, 0xDC, 0x00,
  0xBF, 0x00, 0xBF, 0x00,
  0xBF, 0x00, 0xBF, 0x00,
  0xBF, 0x00, 0xBF, 0x00,
  0x7F, 0x41, 0xEB, 0x00,
  0x2F, 0xED, 0xF6, 0x00,
  0x04, 0xAB, 0x60, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontD9_AA4_0031[ 27] = { /* code 0031, DIGIT ONE */
  0x00, 0xAF, 0x00,
  0x19, 0xFF, 0x00,
  0xEE, 0xDF, 0x00,
  0x82, 0xBF, 0x00,
  0x00, 0xBF, 0x00,
  0x00, 0xBF, 0x00,
  0x00, 0xBF, 0x00,
  0x00, 0xBF, 0x00,
  0x00, 0x8B, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontD9_AA4_0032[ 36] = { /* code 0032, DIGIT TWO */
  0x06, 0xEF, 0xC3, 0x00,
  0x3F, 0xC8, 0xFD, 0x00,
  0x5B, 0x30, 0xBF, 0x00,
  0x00, 0x01, 0xEB, 0x00,
  0x00, 0x1C, 0xE3, 0x00,
  0x01, 0xCE, 0x30, 0x00,
  0x0B, 0xE3, 0x00, 0x00,
  0x6F, 0xFF, 0xFF, 0x00,
  0x8B, 0xBB, 0xBB, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontD9_AA4_0033[ 36] = { /* code 0033, DIGIT THREE */
  0x3B, 0xFD, 0x30, 0x00,
  0xAF, 0x8E, 0xD0, 0x00,
  0x46, 0x0C, 0xE0, 0x00,
  0x00, 0xBE, 0x50, 0x00,
  0x00, 0x7C, 0xC1, 0x00,
  0x00, 0x05, 0xF7, 0x00,
  0xB9, 0x06, 0xF7, 0x00,
  0xAF, 0xCF, 0xE1, 0x00,
  0x18, 0xB9, 0x20, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontD9_AA4_0034[ 36] = { /* code 0034, DIGIT FOUR */
  0x00, 0x0C, 0xF0, 0x00,
  0x00, 0x7F, 0xF0, 0x00,
  0x04, 0xFE, 0xF0, 0x00,
  0x1D, 0x8B, 0xF0, 0x00,
  0x8D, 0x1B, 0xF0, 0x00,
  0xBA, 0x7D, 0xF7, 0x00,
  0xBF, 0xFF, 0xFF, 0x00,
  0x00, 0x0B, 0xF0, 0x00,
  0x00, 0x08, 0xB0, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontD9_AA4_0035[ 36] = { /* code 0035, DIGIT FIVE */
  0x05, 0xFF, 0xFB, 0x00,
  0x07, 0xFC, 0xB8, 0x00,
  0x0B, 0xF0, 0x00, 0x00,
  0x0E, 0xFE, 0xD5, 0x00,
  0x2F, 0xD7, 0xEE, 0x10,
  0x02, 0x10, 0x7F, 0x40,
  0x5F, 0x60, 0x9F, 0x30,
  0x2E, 0xFB, 0xFB, 0x00,
  0x03, 0x9B, 0x71, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontD9_AA4_0036[ 36] = { /* code 0036, DIGIT SIX */
  0x05, 0xDF, 0xB1, 0x00,
  0x2F, 0xCA, 0xF7, 0x00,
  0x8F, 0x10, 0x74, 0x00,
  0xBE, 0x7B, 0x70, 0x00,
  0xBF, 0xDC, 0xF8, 0x00,
  0xBF, 0x10, 0xCF, 0x00,
  0x7F, 0x20, 0xCF, 0x00,
  0x2E, 0xEC, 0xF8, 0x00,
  0x03, 0xAB, 0x70, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontD9_AA4_0037[ 36] = { /* code 0037, DIGIT SEVEN */
  0xBF, 0xFF, 0xFB, 0x00,
  0x8B, 0xBC, 0xF8, 0x00,
  0x00, 0x0C, 0xB0, 0x00,
  0x00, 0x7F, 0x20, 0x00,
  0x00, 0xE9, 0x00, 0x00,
  0x06, 0xF5, 0x00, 0x00,
  0x0A, 0xF1, 0x00, 0x00,
  0x0D, 0xC0, 0x00, 0x00,
  0x0B, 0x80, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontD9_AA4_0038[ 36] = { /* code 0038, DIGIT EIGHT */
  0x08, 0xEF, 0xA1, 0x00,
  0x6F, 0x97, 0xF9, 0x00,
  0x7F, 0x40, 0xFB, 0x00,
  0x2D, 0xCA, 0xE5, 0x00,
  0x1B, 0xDC, 0xD3, 0x00,
  0x9F, 0x20, 0xDD, 0x00,
  0xBF, 0x10, 0xCF, 0x00,
  0x5F, 0xB8, 0xF9, 0x00,
  0x05, 0xAB, 0x70, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontD9_AA4_0039[ 36] = { /* code 0039, DIGIT NINE */
  0x08, 0xFF, 0x80, 0x00,
  0x7F, 0xA9, 0xF7, 0x00,
  0xBF, 0x00, 0xCC, 0x00,
  0xAF, 0x31, 0xDF, 0x00,
  0x3E, 0xFF, 0xEF, 0x00,
  0x02, 0x76, 0xBF, 0x00,
  0x4B, 0x40, 0xDA, 0x00,
  0x3F, 0xED, 0xF5, 0x00,
  0x05, 0xBA, 0x40, 0x00
};

GUI_CONST_STORAGE GUI_CHARINFO GUI_FontD9_AA4_CharInfo[10] = {
   {   7,   7,  4, acGUI_FontD9_AA4_0030 } /* code 0030 */
  ,{   5,   5,  3, acGUI_FontD9_AA4_0031 } /* code 0031 */
  ,{   7,   7,  4, acGUI_FontD9_AA4_0032 } /* code 0032 */
  ,{   7,   7,  4, acGUI_FontD9_AA4_0033 } /* code 0033 */
  ,{   7,   7,  4, acGUI_FontD9_AA4_0034 } /* code 0034 */
  ,{   7,   7,  4, acGUI_FontD9_AA4_0035 } /* code 0035 */
  ,{   7,   7,  4, acGUI_FontD9_AA4_0036 } /* code 0036 */
  ,{   7,   7,  4, acGUI_FontD9_AA4_0037 } /* code 0037 */
  ,{   7,   7,  4, acGUI_FontD9_AA4_0038 } /* code 0038 */
  ,{   7,   7,  4, acGUI_FontD9_AA4_0039 } /* code 0039 */
};

GUI_CONST_STORAGE GUI_FONT_PROP GUI_FontD9_AA4_Prop1 = {
   0x0030 /* first character */
  ,0x0039 /* last character  */
  ,&GUI_FontD9_AA4_CharInfo[  0] /* address of first character */
  ,(GUI_CONST_STORAGE GUI_FONT_PROP *)0 /* pointer to next GUI_FONT_PROP */
};

GUI_CONST_STORAGE GUI_FONT GUI_FontD9_AA4 = {
   GUI_FONTTYPE_PROP_AA4 /* type of font    */
  ,9 /* height of font  */
  ,9 /* space of font y */
  ,1 /* magnification x */
  ,1 /* magnification y */
  ,{&GUI_FontD9_AA4_Prop1}
  ,0 /* Baseline */
  ,0 /* Height of lowercase characters */
  ,0 /* Height of capital characters */
};

/*********************************************************************
*
*       Alpha bitmap for the orange dot at the left of the diagramm
*/
static GUI_CONST_STORAGE unsigned long _acCircleOrange_14x14[] = {
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFA0094F3, 0x860094F3, 0x790094F3, 0x140094F3, 0x140094F3, 0x790094F3, 0x860094F3, 0xFA0094F3, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xB90094F3, 0x450094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x450094F3, 0xB90094F3, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xC10094F3, 0x050094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x050094F3, 0xC10094F3, 0xFFFFFFFF,
  0xF10094F3, 0x3E0094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x3E0094F3, 0xF10094F3,
  0x870094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x870094F3,
  0x760094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x760094F3,
  0x140094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x140094F3,
  0x140094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x140094F3,
  0x760094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x760094F3,
  0x870094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x870094F3,
  0xF10094F3, 0x3E0094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x3E0094F3, 0xF10094F3,
  0xFFFFFFFF, 0xC10094F3, 0x050094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x050094F3, 0xC10094F3, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xB90094F3, 0x450094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x000094F3, 0x450094F3, 0xB90094F3, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFA0094F3, 0x860094F3, 0x790094F3, 0x140094F3, 0x140094F3, 0x790094F3, 0x860094F3, 0xFA0094F3, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF
};

GUI_CONST_STORAGE GUI_BITMAP GUI_bmCircleOrange_14x14 = {
  14, /* XSize */
  14, /* YSize */
  56, /* BytesPerLine */
  32, /* BitsPerPixel */
  (unsigned char *)_acCircleOrange_14x14,  /* Pointer to picture data */
  NULL  /* Pointer to palette */
 ,GUI_DRAW_BMP8888
};

/*************************** End of file ****************************/
