/*********************************************************************
*                SEGGER Microcontroller GmbH & Co. KG                *
*        Solutions for real time microcontroller applications        *
**********************************************************************
*                                                                    *
*        (c) 1996 - 2016  SEGGER Microcontroller GmbH & Co. KG       *
*                                                                    *
*        Internet: www.segger.com    Support:  support@segger.com    *
*                                                                    *
**********************************************************************

** emWin V5.34 - Graphical user interface for embedded applications **
All  Intellectual Property rights  in the Software belongs to  SEGGER.
emWin is protected by  international copyright laws.  Knowledge of the
source code may not be used to write a similar product.  This file may
only be used in accordance with the following terms:

The  software has  been licensed  to Silicon Labs Norway, a subsidiary
of Silicon Labs Inc. whose registered office is 400 West Cesar Chavez,
Austin,  TX 78701, USA solely for  the purposes of creating  libraries 
for its  ARM Cortex-M3, M4F  processor-based devices,  sublicensed and 
distributed  under the  terms and conditions  of the  End User License  
Agreement supplied by Silicon Labs.
Full source code is available at: www.segger.com

We appreciate your understanding and fairness.
----------------------------------------------------------------------
Licensing information

Licensor:                 SEGGER Software GmbH
Licensed to:              Silicon Laboratories Norway
Licensed SEGGER software: emWin
License number:           GUI-00140
License model:            See Agreement, dated 20th April 2012
Licensed product:         - 
Licensed platform:        Cortex M3, Cortex M4F
Licensed number of seats: -
----------------------------------------------------------------------
File        : WM_RadialMenu.c
Purpose     : Shows how to create a radial menu with motion support
----------------------------------------------------------------------
*/

/*********************************************************************
*
*       Includes
*
**********************************************************************
*/
#include "DIALOG.h"
#include "bsp.h"
#include "touch.h"
#include "em_ebi.h"
#include "em_dma.h"
#include "em_emu.h"
#include "em_common.h"

/*********************************************************************
*
*       Defines
*
**********************************************************************
*/

#define ID_WINDOW_0 (GUI_ID_USER + 0x00)
#define ID_TEXT_0 (GUI_ID_USER + 0x01)
#define TRANSP 0xF801

#define CHECBOX_BUTTON_SIZE 20

#define DELAY(ms) if (_Delay(ms, &Para)) break;
//#define DELAY(ms) GUI_Delay(ms)

#define JOYSTICK_DOWN  (1uL << 0)
#define JOYSTICK_RIGHT (1uL << 1)
#define JOYSTICK_UP    (1uL << 2)
#define JOYSTICK_LEFT  (1uL << 3)
#define JOYSTICK_ENTER (1uL << 4)

#define KEY_PB1        (1uL << 0)
#define KEY_PB2        (1uL << 1)
#define KEY_PB3        (1uL << 2)
#define KEY_PB4        (1uL << 3)

#define XSIZE 320
#define YSIZE 240
#define BITSPERPIXEL 16

/*********************************************************************
*
*       Types
*
**********************************************************************
*/
typedef struct {
  const GUI_BITMAP * pBitmap;
  const char       * pText;
  const char       * pExplanation;
} BITMAP_ITEM;

typedef struct {
  int xPos;
  int yPos;
  int Index;
} ITEM_INFO;

typedef struct {
  int                 DoAnimation;
  int                 Pos;
  int                 NumItems;
  int                 xSizeItem, ySizeItem;
  int                 xSizeWindow, ySizeWindow;
  int                 rx, ry, mx, my;
  int                 FinalMove;
  const BITMAP_ITEM * pBitmapItem;
   WM_HWIN            hCheck;
  ITEM_INFO         * pItemInfo;
} PARA;

static void em_DrawBitmap_565(int x0, int y0, int xSize, int ySize, const U8 GUI_UNI_PTR * pPixel, const LCD_LOGPALETTE GUI_UNI_PTR * pLogPal, int xMag, int yMag);

/*********************************************************************
*
*       Static data
*
**********************************************************************
*/

static const GUI_BITMAP_METHODS em_BitmapMethods565 = {
  em_DrawBitmap_565,
  LCD_Index2Color_565,
  NULL,
  NULL
};

static const GUI_WIDGET_CREATE_INFO _aDialogCreate[] = {
  { WINDOW_CreateIndirect, "Calibration", ID_WINDOW_0, 0, 0, 320, 240, 0, 0, 0 },
  { TEXT_CreateIndirect, "Instruction", ID_TEXT_0, 22, 62, 270, 20, 0, 100, 0 },
  // USER START (Optionally insert additional widgets)
  // USER END
};

static int joy1 = 0;
static int joy2 = 0;
static uint32_t *pFrameBuffer;

  /*********************************************************************
*                                                                    *
*       GUI_FontRounded22                                            *
*                                                                    *
**********************************************************************
*/
GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0020[  1] = { /* code 0020, SPACE */
  0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0021[ 30] = { /* code 0021, EXCLAMATION MARK */
  0x02, 0x10,
  0x6F, 0xE2,
  0x9F, 0xF4,
  0x9F, 0xF4,
  0x9F, 0xF4,
  0x7F, 0xF2,
  0x5F, 0xF0,
  0x3F, 0xD0,
  0x1F, 0xB0,
  0x0D, 0x80,
  0x00, 0x00,
  0x2B, 0xA0,
  0x9F, 0xF4,
  0x5F, 0xE1,
  0x01, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0022[ 28] = { /* code 0022, QUOTATION MARK */
  0x01, 0x10, 0x02, 0x00,
  0x0E, 0xF2, 0x7F, 0x90,
  0x2F, 0xF4, 0x9F, 0xB0,
  0x2F, 0xF4, 0x9F, 0xB0,
  0x2F, 0xF4, 0x9F, 0xB0,
  0x1E, 0xF2, 0x8F, 0xA0,
  0x02, 0x20, 0x03, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0023[ 84] = { /* code 0023, NUMBER SIGN */
  0x00, 0x02, 0xB4, 0x08, 0x90, 0x00,
  0x00, 0x06, 0xF7, 0x0F, 0xD0, 0x00,
  0x00, 0x08, 0xF5, 0x2F, 0xB0, 0x00,
  0x00, 0x2B, 0xF4, 0x5F, 0xA1, 0x00,
  0x07, 0xFF, 0xFF, 0xFF, 0xFE, 0x10,
  0x03, 0x9F, 0xE9, 0xDF, 0xB8, 0x00,
  0x00, 0x1F, 0xB0, 0xAF, 0x30, 0x00,
  0x02, 0x6F, 0xB4, 0xDF, 0x40, 0x00,
  0x0F, 0xFF, 0xFF, 0xFF, 0xF7, 0x00,
  0x06, 0xBF, 0x98, 0xFD, 0x72, 0x00,
  0x00, 0xAF, 0x33, 0xF9, 0x00, 0x00,
  0x00, 0xCF, 0x15, 0xF7, 0x00, 0x00,
  0x00, 0xDD, 0x07, 0xF4, 0x00, 0x00,
  0x00, 0x22, 0x00, 0x30, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0024[ 96] = { /* code 0024, DOLLAR SIGN */
  0x00, 0x00, 0x0B, 0x10, 0x00, 0x00,
  0x00, 0x28, 0xBF, 0xC8, 0x30, 0x00,
  0x05, 0xFF, 0xFF, 0xFF, 0xF9, 0x00,
  0x1E, 0xF9, 0x2F, 0x39, 0xFF, 0x50,
  0x3F, 0xF0, 0x0F, 0x20, 0x9E, 0x30,
  0x3F, 0xF6, 0x0F, 0x20, 0x00, 0x00,
  0x0D, 0xFF, 0xDF, 0x73, 0x00, 0x00,
  0x02, 0xCF, 0xFF, 0xFF, 0xC3, 0x00,
  0x00, 0x04, 0x8F, 0xEF, 0xFE, 0x10,
  0x03, 0x00, 0x0F, 0x25, 0xFF, 0x70,
  0x7F, 0xA0, 0x0F, 0x20, 0xBF, 0x80,
  0x7F, 0xF3, 0x0F, 0x21, 0xEF, 0x60,
  0x1D, 0xFE, 0xAF, 0xBE, 0xFD, 0x10,
  0x01, 0xAF, 0xFF, 0xFF, 0xA2, 0x00,
  0x00, 0x01, 0x3F, 0x41, 0x00, 0x00,
  0x00, 0x00, 0x0D, 0x10, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0025[120] = { /* code 0025, PERCENT SIGN */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00,
  0x03, 0xAB, 0xA2, 0x00, 0x00, 0x7F, 0x00, 0x00,
  0x2E, 0xEA, 0xFE, 0x10, 0x01, 0xE8, 0x00, 0x00,
  0x7F, 0x70, 0x9F, 0x50, 0x08, 0xE1, 0x00, 0x00,
  0x9F, 0x60, 0x7F, 0x70, 0x2F, 0x70, 0x00, 0x00,
  0x7F, 0x60, 0x8F, 0x60, 0x9E, 0x10, 0x00, 0x00,
  0x3F, 0xD6, 0xEF, 0x22, 0xF7, 0x00, 0x00, 0x00,
  0x07, 0xEF, 0xE6, 0x0A, 0xE0, 0x17, 0x98, 0x20,
  0x00, 0x01, 0x00, 0x3F, 0x60, 0xCF, 0xCF, 0xE1,
  0x00, 0x00, 0x00, 0xBD, 0x04, 0xFA, 0x09, 0xF6,
  0x00, 0x00, 0x04, 0xF5, 0x07, 0xF7, 0x06, 0xF9,
  0x00, 0x00, 0x0C, 0xC0, 0x06, 0xF8, 0x06, 0xF8,
  0x00, 0x00, 0x5F, 0x40, 0x03, 0xFC, 0x3B, 0xF4,
  0x00, 0x00, 0xCB, 0x00, 0x00, 0x8F, 0xFF, 0x90,
  0x00, 0x00, 0x93, 0x00, 0x00, 0x01, 0x42, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0026[105] = { /* code 0026, AMPERSAND */
  0x00, 0x00, 0x01, 0x10, 0x00, 0x00, 0x00,
  0x00, 0x04, 0xDF, 0xFD, 0x50, 0x00, 0x00,
  0x00, 0x3F, 0xFD, 0xCF, 0xF4, 0x00, 0x00,
  0x00, 0x9F, 0xD0, 0x0B, 0xFA, 0x00, 0x00,
  0x00, 0x9F, 0xD0, 0x0B, 0xFA, 0x00, 0x00,
  0x00, 0x4F, 0xF9, 0x8F, 0xF5, 0x00, 0x00,
  0x00, 0x0A, 0xFF, 0xFF, 0x80, 0x00, 0x00,
  0x00, 0x9F, 0xFF, 0xFB, 0x00, 0x54, 0x00,
  0x09, 0xFF, 0xBA, 0xFF, 0x74, 0xFF, 0x00,
  0x1F, 0xFB, 0x00, 0xBF, 0xFE, 0xFC, 0x00,
  0x3F, 0xF7, 0x00, 0x1D, 0xFF, 0xE3, 0x00,
  0x1F, 0xFB, 0x00, 0x2C, 0xFF, 0xE3, 0x00,
  0x0A, 0xFF, 0xED, 0xFF, 0xEE, 0xFD, 0x00,
  0x01, 0xAF, 0xFF, 0xFB, 0x24, 0xFD, 0x00,
  0x00, 0x01, 0x43, 0x10, 0x00, 0x10, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0027[ 14] = { /* code 0027, APOSTROPHE */
  0x01, 0x10,
  0x3F, 0xD0,
  0x6F, 0xF0,
  0x6F, 0xF0,
  0x6F, 0xF0,
  0x3F, 0xE0,
  0x03, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0028[ 54] = { /* code 0028, LEFT PARENTHESIS */
  0x00, 0x03, 0x00,
  0x00, 0x9F, 0x40,
  0x02, 0xFF, 0x20,
  0x08, 0xFB, 0x00,
  0x0E, 0xF7, 0x00,
  0x4F, 0xF3, 0x00,
  0x7F, 0xE0, 0x00,
  0xAF, 0xC0, 0x00,
  0xBF, 0xB0, 0x00,
  0xBF, 0xB0, 0x00,
  0xBF, 0xB0, 0x00,
  0x8F, 0xE0, 0x00,
  0x5F, 0xF2, 0x00,
  0x1F, 0xF5, 0x00,
  0x0A, 0xFA, 0x00,
  0x04, 0xFE, 0x10,
  0x00, 0xCF, 0x50,
  0x00, 0x29, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0029[ 54] = { /* code 0029, RIGHT PARENTHESIS */
  0x03, 0x00, 0x00,
  0x5F, 0x90, 0x00,
  0x2F, 0xF2, 0x00,
  0x0B, 0xF8, 0x00,
  0x07, 0xFE, 0x00,
  0x03, 0xFF, 0x30,
  0x00, 0xFF, 0x70,
  0x00, 0xCF, 0xA0,
  0x00, 0xBF, 0xB0,
  0x00, 0xBF, 0xB0,
  0x00, 0xCF, 0xB0,
  0x00, 0xEF, 0x80,
  0x02, 0xFF, 0x50,
  0x05, 0xFF, 0x10,
  0x0A, 0xFA, 0x00,
  0x1E, 0xF4, 0x00,
  0x5F, 0xC0, 0x00,
  0x19, 0x20, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_002A[ 32] = { /* code 002A, ASTERISK */
  0x00, 0x00, 0x10, 0x00,
  0x00, 0x08, 0xE0, 0x00,
  0x05, 0x29, 0xF0, 0x51,
  0x2F, 0xFE, 0xFE, 0xF7,
  0x02, 0x7F, 0xFB, 0x40,
  0x00, 0xAF, 0xCE, 0x20,
  0x03, 0xF7, 0x2F, 0x90,
  0x00, 0x30, 0x03, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_002B[ 66] = { /* code 002B, PLUS SIGN */
  0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x8F, 0x50, 0x00, 0x00,
  0x00, 0x00, 0xBF, 0x70, 0x00, 0x00,
  0x00, 0x00, 0xBF, 0x70, 0x00, 0x00,
  0x02, 0x22, 0xCF, 0x82, 0x22, 0x00,
  0x8F, 0xFF, 0xFF, 0xFF, 0xFF, 0x60,
  0x6F, 0xFF, 0xFF, 0xFF, 0xFE, 0x40,
  0x00, 0x00, 0xBF, 0x70, 0x00, 0x00,
  0x00, 0x00, 0xBF, 0x70, 0x00, 0x00,
  0x00, 0x00, 0xBF, 0x70, 0x00, 0x00,
  0x00, 0x00, 0x7F, 0x40, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_002C[ 12] = { /* code 002C, COMMA */
  0x3C, 0x90,
  0xBF, 0xF5,
  0x6F, 0xF7,
  0x01, 0xE5,
  0x4C, 0xC0,
  0x67, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_002D[ 16] = { /* code 002D, HYPHEN-MINUS */
  0x01, 0x44, 0x42, 0x00,
  0x2F, 0xFF, 0xFF, 0x70,
  0x3F, 0xFF, 0xFF, 0x80,
  0x02, 0x44, 0x43, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_002E[  8] = { /* code 002E, FULL STOP */
  0x3C, 0x90,
  0xBF, 0xF3,
  0x6F, 0xD1,
  0x01, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_002F[ 60] = { /* code 002F, SOLIDUS */
  0x00, 0x00, 0x03, 0x00,
  0x00, 0x00, 0x6F, 0x70,
  0x00, 0x00, 0xCF, 0x40,
  0x00, 0x03, 0xFD, 0x00,
  0x00, 0x08, 0xF8, 0x00,
  0x00, 0x0E, 0xF2, 0x00,
  0x00, 0x5F, 0xB0, 0x00,
  0x00, 0xBF, 0x60, 0x00,
  0x01, 0xFE, 0x10, 0x00,
  0x07, 0xF9, 0x00, 0x00,
  0x0D, 0xF3, 0x00, 0x00,
  0x3F, 0xD0, 0x00, 0x00,
  0x9F, 0x70, 0x00, 0x00,
  0xCF, 0x20, 0x00, 0x00,
  0x23, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0030[ 84] = { /* code 0030, DIGIT ZERO */
  0x00, 0x05, 0xBB, 0xB6, 0x00, 0x00,
  0x00, 0xAF, 0xFF, 0xFF, 0xA0, 0x00,
  0x06, 0xFF, 0xA6, 0xAF, 0xF7, 0x00,
  0x0D, 0xFC, 0x00, 0x0C, 0xFD, 0x00,
  0x2F, 0xF8, 0x00, 0x08, 0xFF, 0x20,
  0x4F, 0xF6, 0x00, 0x06, 0xFF, 0x40,
  0x4F, 0xF6, 0x00, 0x06, 0xFF, 0x40,
  0x4F, 0xF6, 0x00, 0x06, 0xFF, 0x40,
  0x2F, 0xF7, 0x00, 0x06, 0xFF, 0x30,
  0x0E, 0xFA, 0x00, 0x0A, 0xFE, 0x00,
  0x09, 0xFF, 0x40, 0x4F, 0xF9, 0x00,
  0x02, 0xEF, 0xFE, 0xFF, 0xE2, 0x00,
  0x00, 0x3C, 0xFF, 0xFC, 0x30, 0x00,
  0x00, 0x00, 0x24, 0x20, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0031[ 56] = { /* code 0031, DIGIT ONE */
  0x00, 0x00, 0x2B, 0x70,
  0x00, 0x00, 0xAF, 0xC0,
  0x01, 0x49, 0xFF, 0xD0,
  0x1E, 0xFF, 0xFF, 0xD0,
  0x1B, 0xDD, 0xFF, 0xD0,
  0x00, 0x00, 0xDF, 0xD0,
  0x00, 0x00, 0xDF, 0xD0,
  0x00, 0x00, 0xDF, 0xD0,
  0x00, 0x00, 0xDF, 0xD0,
  0x00, 0x00, 0xDF, 0xD0,
  0x00, 0x00, 0xDF, 0xD0,
  0x00, 0x00, 0xDF, 0xC0,
  0x00, 0x00, 0xBF, 0xA0,
  0x00, 0x00, 0x13, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0032[ 78] = { /* code 0032, DIGIT TWO */
  0x00, 0x17, 0xBB, 0xB6, 0x00, 0x00,
  0x03, 0xEF, 0xFF, 0xFF, 0xD1, 0x00,
  0x0D, 0xFE, 0x86, 0xAF, 0xFB, 0x00,
  0x5F, 0xF6, 0x00, 0x0D, 0xFF, 0x00,
  0x4F, 0xE1, 0x00, 0x0B, 0xFF, 0x00,
  0x03, 0x20, 0x00, 0x3F, 0xFB, 0x00,
  0x00, 0x00, 0x07, 0xEF, 0xF3, 0x00,
  0x00, 0x03, 0xCF, 0xFD, 0x30, 0x00,
  0x00, 0x6F, 0xFE, 0x70, 0x00, 0x00,
  0x06, 0xFF, 0xA2, 0x00, 0x00, 0x00,
  0x2F, 0xFC, 0x44, 0x44, 0x42, 0x00,
  0x6F, 0xFF, 0xFF, 0xFF, 0xFF, 0x10,
  0x3E, 0xFF, 0xFF, 0xFF, 0xFD, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0033[ 70] = { /* code 0033, DIGIT THREE */
  0x00, 0x28, 0xBB, 0xA5, 0x00,
  0x05, 0xFF, 0xFF, 0xFF, 0xA0,
  0x1F, 0xFE, 0x76, 0xCF, 0xF4,
  0x2F, 0xF4, 0x00, 0x2F, 0xF7,
  0x04, 0x40, 0x00, 0x2F, 0xF5,
  0x00, 0x00, 0x5A, 0xEF, 0xB0,
  0x00, 0x00, 0xFF, 0xFF, 0x90,
  0x00, 0x00, 0x38, 0xCF, 0xF8,
  0x01, 0x00, 0x00, 0x1E, 0xFC,
  0x3F, 0xC0, 0x00, 0x0E, 0xFD,
  0x5F, 0xF8, 0x00, 0x7F, 0xF9,
  0x1D, 0xFF, 0xFE, 0xFF, 0xE2,
  0x02, 0xBF, 0xFF, 0xFB, 0x30,
  0x00, 0x01, 0x33, 0x10, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0034[ 84] = { /* code 0034, DIGIT FOUR */
  0x00, 0x00, 0x00, 0x9B, 0x40, 0x00,
  0x00, 0x00, 0x07, 0xFF, 0x90, 0x00,
  0x00, 0x00, 0x4F, 0xFF, 0x90, 0x00,
  0x00, 0x02, 0xEE, 0xEF, 0x90, 0x00,
  0x00, 0x0C, 0xF4, 0xDF, 0x90, 0x00,
  0x00, 0x9F, 0x80, 0xDF, 0x90, 0x00,
  0x06, 0xFB, 0x00, 0xDF, 0x90, 0x00,
  0x3F, 0xE2, 0x00, 0xDF, 0x90, 0x00,
  0xBF, 0xFF, 0xFF, 0xFF, 0xFE, 0x50,
  0x8F, 0xFF, 0xFF, 0xFF, 0xFF, 0x60,
  0x02, 0x22, 0x22, 0xDF, 0xA2, 0x00,
  0x00, 0x00, 0x00, 0xDF, 0x90, 0x00,
  0x00, 0x00, 0x00, 0xBF, 0x80, 0x00,
  0x00, 0x00, 0x00, 0x13, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0035[ 70] = { /* code 0035, DIGIT FIVE */
  0x01, 0x89, 0x99, 0x99, 0x70,
  0x07, 0xFF, 0xFF, 0xFF, 0xF3,
  0x0A, 0xFD, 0xBB, 0xBB, 0x90,
  0x0C, 0xF5, 0x00, 0x00, 0x00,
  0x0F, 0xF3, 0x46, 0x51, 0x00,
  0x3F, 0xFD, 0xFF, 0xFE, 0x60,
  0x3F, 0xFE, 0xAB, 0xFF, 0xF3,
  0x06, 0x60, 0x00, 0x4F, 0xFA,
  0x00, 0x00, 0x00, 0x0D, 0xFB,
  0x17, 0x40, 0x00, 0x0E, 0xFB,
  0x5F, 0xF4, 0x00, 0x8F, 0xF7,
  0x3F, 0xFF, 0xDE, 0xFF, 0xD1,
  0x04, 0xCF, 0xFF, 0xFA, 0x10,
  0x00, 0x02, 0x43, 0x10, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0036[ 84] = { /* code 0036, DIGIT SIX */
  0x00, 0x04, 0x9B, 0xB9, 0x30, 0x00,
  0x00, 0x8F, 0xFF, 0xFF, 0xF4, 0x00,
  0x04, 0xFF, 0x93, 0x4E, 0xFB, 0x00,
  0x0B, 0xFC, 0x00, 0x02, 0x93, 0x00,
  0x1F, 0xF7, 0x02, 0x31, 0x00, 0x00,
  0x3F, 0xF9, 0xDF, 0xFF, 0x91, 0x00,
  0x4F, 0xFF, 0xEB, 0xDF, 0xFA, 0x00,
  0x4F, 0xFD, 0x10, 0x0B, 0xFF, 0x20,
  0x3F, 0xF8, 0x00, 0x06, 0xFF, 0x40,
  0x1F, 0xF8, 0x00, 0x06, 0xFF, 0x40,
  0x0B, 0xFE, 0x20, 0x1C, 0xFF, 0x10,
  0x03, 0xEF, 0xFD, 0xEF, 0xF7, 0x00,
  0x00, 0x3C, 0xFF, 0xFE, 0x70, 0x00,
  0x00, 0x00, 0x24, 0x30, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0037[ 70] = { /* code 0037, DIGIT SEVEN */
  0x49, 0x99, 0x99, 0x99, 0x94,
  0xBF, 0xFF, 0xFF, 0xFF, 0xFD,
  0x5B, 0xBB, 0xBB, 0xBF, 0xF9,
  0x00, 0x00, 0x00, 0x9F, 0xC0,
  0x00, 0x00, 0x05, 0xFE, 0x20,
  0x00, 0x00, 0x1E, 0xF6, 0x00,
  0x00, 0x00, 0x9F, 0xD0, 0x00,
  0x00, 0x02, 0xFF, 0x70, 0x00,
  0x00, 0x08, 0xFF, 0x10, 0x00,
  0x00, 0x0E, 0xFB, 0x00, 0x00,
  0x00, 0x4F, 0xF7, 0x00, 0x00,
  0x00, 0x7F, 0xF3, 0x00, 0x00,
  0x00, 0x6F, 0xD0, 0x00, 0x00,
  0x00, 0x03, 0x10, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0038[ 84] = { /* code 0038, DIGIT EIGHT */
  0x00, 0x17, 0xBB, 0xB8, 0x10, 0x00,
  0x02, 0xEF, 0xFF, 0xFF, 0xE3, 0x00,
  0x0B, 0xFE, 0x62, 0x6E, 0xFB, 0x00,
  0x0D, 0xFA, 0x00, 0x0A, 0xFF, 0x00,
  0x0C, 0xFB, 0x00, 0x0B, 0xFC, 0x00,
  0x04, 0xFF, 0xB8, 0xBF, 0xF4, 0x00,
  0x02, 0xBF, 0xFF, 0xFF, 0xB2, 0x00,
  0x0C, 0xFE, 0x64, 0x6E, 0xFD, 0x00,
  0x3F, 0xF7, 0x00, 0x07, 0xFF, 0x30,
  0x4F, 0xF6, 0x00, 0x06, 0xFF, 0x40,
  0x2F, 0xFC, 0x10, 0x1B, 0xFF, 0x20,
  0x09, 0xFF, 0xED, 0xEF, 0xF9, 0x00,
  0x00, 0x7E, 0xFF, 0xFE, 0x80, 0x00,
  0x00, 0x00, 0x24, 0x30, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0039[ 84] = { /* code 0039, DIGIT NINE */
  0x00, 0x17, 0xBB, 0xB6, 0x00, 0x00,
  0x03, 0xEF, 0xFF, 0xFF, 0xB0, 0x00,
  0x0C, 0xFE, 0x74, 0x8F, 0xF8, 0x00,
  0x3F, 0xF8, 0x00, 0x0A, 0xFE, 0x00,
  0x4F, 0xF6, 0x00, 0x07, 0xFF, 0x30,
  0x3F, 0xF7, 0x00, 0x0A, 0xFF, 0x40,
  0x0D, 0xFF, 0x74, 0x9F, 0xFF, 0x40,
  0x03, 0xEF, 0xFF, 0xFD, 0xFF, 0x40,
  0x00, 0x17, 0x99, 0x56, 0xFF, 0x20,
  0x00, 0x30, 0x00, 0x09, 0xFD, 0x00,
  0x09, 0xFA, 0x00, 0x3F, 0xF8, 0x00,
  0x08, 0xFF, 0xDB, 0xFF, 0xD1, 0x00,
  0x01, 0x9F, 0xFF, 0xFA, 0x20, 0x00,
  0x00, 0x01, 0x33, 0x10, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_003A[ 22] = { /* code 003A, COLON */
  0x05, 0x30,
  0x9F, 0xF2,
  0x9F, 0xF2,
  0x17, 0x40,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x3C, 0x90,
  0xBF, 0xF3,
  0x6F, 0xD1,
  0x01, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_003B[ 26] = { /* code 003B, SEMICOLON */
  0x05, 0x30,
  0x9F, 0xF2,
  0x9F, 0xF2,
  0x17, 0x40,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x3C, 0x90,
  0xBF, 0xF5,
  0x6F, 0xF7,
  0x01, 0xE5,
  0x4C, 0xC0,
  0x67, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_003C[ 60] = { /* code 003C, LESS-THAN SIGN */
  0x00, 0x00, 0x00, 0x01, 0x8B, 0x20,
  0x00, 0x00, 0x02, 0x9F, 0xFF, 0x50,
  0x00, 0x03, 0xAF, 0xFF, 0xC6, 0x00,
  0x05, 0xCF, 0xFF, 0xB4, 0x00, 0x00,
  0x7F, 0xFF, 0x92, 0x00, 0x00, 0x00,
  0x5F, 0xFF, 0xB5, 0x00, 0x00, 0x00,
  0x02, 0x9F, 0xFF, 0xD7, 0x10, 0x00,
  0x00, 0x01, 0x7E, 0xFF, 0xF8, 0x10,
  0x00, 0x00, 0x00, 0x7D, 0xFF, 0x50,
  0x00, 0x00, 0x00, 0x00, 0x57, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_003D[ 48] = { /* code 003D, EQUALS SIGN */
  0x04, 0x44, 0x44, 0x44, 0x43, 0x00,
  0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0x70,
  0x5D, 0xDD, 0xDD, 0xDD, 0xDC, 0x30,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0x50,
  0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0x50,
  0x02, 0x22, 0x22, 0x22, 0x21, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_003E[ 60] = { /* code 003E, GREATER-THAN SIGN */
  0x4B, 0x70, 0x00, 0x00, 0x00, 0x00,
  0x8F, 0xFE, 0x81, 0x00, 0x00, 0x00,
  0x17, 0xEF, 0xFF, 0x92, 0x00, 0x00,
  0x00, 0x05, 0xCF, 0xFF, 0xA3, 0x00,
  0x00, 0x00, 0x03, 0xAF, 0xFF, 0x40,
  0x00, 0x00, 0x06, 0xDF, 0xFE, 0x30,
  0x00, 0x28, 0xEF, 0xFE, 0x71, 0x00,
  0x1A, 0xFF, 0xFD, 0x60, 0x00, 0x00,
  0x9F, 0xFC, 0x50, 0x00, 0x00, 0x00,
  0x27, 0x30, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_003F[ 75] = { /* code 003F, QUESTION MARK */
  0x00, 0x00, 0x22, 0x00, 0x00,
  0x00, 0x7E, 0xFF, 0xFA, 0x20,
  0x09, 0xFF, 0xEE, 0xFF, 0xE1,
  0x2F, 0xFA, 0x00, 0x7F, 0xF7,
  0x2F, 0xE2, 0x00, 0x3F, 0xF7,
  0x02, 0x20, 0x00, 0xAF, 0xF5,
  0x00, 0x00, 0x1B, 0xFF, 0xA0,
  0x00, 0x00, 0xCF, 0xF7, 0x00,
  0x00, 0x05, 0xFF, 0x50, 0x00,
  0x00, 0x02, 0xEC, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x02, 0xBA, 0x10, 0x00,
  0x00, 0x08, 0xFF, 0x50, 0x00,
  0x00, 0x04, 0xFE, 0x20, 0x00,
  0x00, 0x00, 0x11, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0040[105] = { /* code 0040, COMMERCIAL AT */
  0x00, 0x00, 0x00, 0x34, 0x31, 0x00, 0x00,
  0x00, 0x02, 0x9E, 0xFF, 0xFF, 0xA2, 0x00,
  0x00, 0x3E, 0xFB, 0x76, 0x7A, 0xFE, 0x50,
  0x02, 0xEF, 0x50, 0x00, 0x00, 0x3E, 0xE2,
  0x0B, 0xF6, 0x07, 0xEE, 0x96, 0xB5, 0xF8,
  0x2F, 0xD0, 0x7F, 0xFF, 0xFF, 0xF0, 0xEC,
  0x5F, 0x91, 0xEF, 0x40, 0x8F, 0xC0, 0xBD,
  0x7F, 0x74, 0xFA, 0x00, 0x4F, 0x90, 0xCB,
  0x6F, 0x85, 0xFB, 0x00, 0x6F, 0x71, 0xF7,
  0x3F, 0xC2, 0xFF, 0x98, 0xEF, 0xAC, 0xD1,
  0x0C, 0xF4, 0x9F, 0xFF, 0xEF, 0xFB, 0x20,
  0x03, 0xFE, 0x45, 0x73, 0x37, 0x57, 0x00,
  0x00, 0x5E, 0xFB, 0x66, 0x69, 0xEE, 0x10,
  0x00, 0x02, 0x9F, 0xFF, 0xFF, 0xA2, 0x00,
  0x00, 0x00, 0x01, 0x34, 0x31, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0041[ 90] = { /* code 0041, LATIN CAPITAL LETTER A */
  0x00, 0x00, 0x02, 0x30, 0x00, 0x00,
  0x00, 0x00, 0x9F, 0xFB, 0x00, 0x00,
  0x00, 0x01, 0xFF, 0xFF, 0x30, 0x00,
  0x00, 0x06, 0xFF, 0xFF, 0x80, 0x00,
  0x00, 0x0C, 0xFD, 0xCF, 0xE0, 0x00,
  0x00, 0x3F, 0xF8, 0x7F, 0xF4, 0x00,
  0x00, 0x8F, 0xF3, 0x2F, 0xFA, 0x00,
  0x00, 0xEF, 0xD0, 0x0D, 0xFF, 0x10,
  0x04, 0xFF, 0x80, 0x08, 0xFF, 0x60,
  0x0A, 0xFF, 0xCB, 0xBC, 0xFF, 0xB0,
  0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF2,
  0x7F, 0xF9, 0x44, 0x44, 0x9F, 0xF7,
  0xCF, 0xF3, 0x00, 0x00, 0x3F, 0xFC,
  0xAF, 0xC0, 0x00, 0x00, 0x0C, 0xFA,
  0x03, 0x10, 0x00, 0x00, 0x01, 0x30
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0042[ 78] = { /* code 0042, LATIN CAPITAL LETTER B */
  0x3D, 0xFF, 0xFF, 0xED, 0xA3, 0x00,
  0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0x30,
  0x9F, 0xF8, 0x44, 0x4C, 0xFF, 0xA0,
  0x9F, 0xF6, 0x00, 0x04, 0xFF, 0xB0,
  0x9F, 0xF6, 0x00, 0x06, 0xFF, 0x70,
  0x9F, 0xFB, 0x99, 0xBF, 0xFB, 0x10,
  0x9F, 0xFF, 0xFF, 0xFF, 0xFB, 0x20,
  0x9F, 0xF8, 0x44, 0x4A, 0xFF, 0xD0,
  0x9F, 0xF6, 0x00, 0x00, 0xCF, 0xF2,
  0x9F, 0xF6, 0x00, 0x00, 0xCF, 0xF3,
  0x9F, 0xF8, 0x44, 0x5A, 0xFF, 0xE0,
  0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0x60,
  0x4E, 0xFF, 0xFF, 0xFE, 0xB4, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0043[ 90] = { /* code 0043, LATIN CAPITAL LETTER C */
  0x00, 0x00, 0x13, 0x43, 0x00, 0x00,
  0x00, 0x2A, 0xFF, 0xFF, 0xE7, 0x00,
  0x03, 0xEF, 0xFF, 0xFF, 0xFF, 0xB0,
  0x1E, 0xFF, 0xB3, 0x25, 0xEF, 0xF6,
  0x7F, 0xFB, 0x00, 0x00, 0x4F, 0xF7,
  0xCF, 0xF3, 0x00, 0x00, 0x03, 0x61,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xD0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xDF, 0xF3, 0x00, 0x00, 0x05, 0x71,
  0x9F, 0xFA, 0x00, 0x00, 0x4F, 0xF7,
  0x3F, 0xFF, 0x93, 0x25, 0xEF, 0xF5,
  0x06, 0xFF, 0xFF, 0xFF, 0xFF, 0xA0,
  0x00, 0x4C, 0xFF, 0xFF, 0xE7, 0x00,
  0x00, 0x00, 0x24, 0x43, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0044[ 78] = { /* code 0044, LATIN CAPITAL LETTER D */
  0x3D, 0xFF, 0xFF, 0xEC, 0x71, 0x00,
  0x9F, 0xFF, 0xFF, 0xFF, 0xFE, 0x30,
  0x9F, 0xF9, 0x66, 0x7D, 0xFF, 0xD0,
  0x9F, 0xF6, 0x00, 0x01, 0xCF, 0xF6,
  0x9F, 0xF6, 0x00, 0x00, 0x5F, 0xFA,
  0x9F, 0xF6, 0x00, 0x00, 0x2F, 0xFD,
  0x9F, 0xF6, 0x00, 0x00, 0x2F, 0xFD,
  0x9F, 0xF6, 0x00, 0x00, 0x2F, 0xFC,
  0x9F, 0xF6, 0x00, 0x00, 0x6F, 0xFA,
  0x9F, 0xF6, 0x00, 0x01, 0xDF, 0xF5,
  0x9F, 0xF9, 0x66, 0x7D, 0xFF, 0xC0,
  0x9F, 0xFF, 0xFF, 0xFF, 0xFD, 0x20,
  0x4E, 0xFF, 0xFF, 0xFC, 0x71, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0045[ 78] = { /* code 0045, LATIN CAPITAL LETTER E */
  0x3D, 0xFF, 0xFF, 0xFF, 0xFE, 0x50,
  0x8F, 0xFF, 0xFF, 0xFF, 0xFF, 0x80,
  0x9F, 0xF9, 0x66, 0x66, 0x65, 0x10,
  0x9F, 0xF6, 0x00, 0x00, 0x00, 0x00,
  0x9F, 0xF6, 0x00, 0x00, 0x00, 0x00,
  0x9F, 0xFD, 0xBB, 0xBB, 0xB6, 0x00,
  0x9F, 0xFF, 0xFF, 0xFF, 0xFB, 0x00,
  0x9F, 0xFA, 0x77, 0x77, 0x73, 0x00,
  0x9F, 0xF6, 0x00, 0x00, 0x00, 0x00,
  0x9F, 0xF6, 0x00, 0x00, 0x00, 0x00,
  0x9F, 0xF9, 0x66, 0x66, 0x65, 0x10,
  0x8F, 0xFF, 0xFF, 0xFF, 0xFF, 0xA0,
  0x3D, 0xFF, 0xFF, 0xFF, 0xFF, 0x70
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0046[ 84] = { /* code 0046, LATIN CAPITAL LETTER F */
  0x3D, 0xFF, 0xFF, 0xFF, 0xFB, 0x10,
  0x8F, 0xFF, 0xFF, 0xFF, 0xFF, 0x10,
  0x9F, 0xF9, 0x66, 0x66, 0x64, 0x00,
  0x9F, 0xF6, 0x00, 0x00, 0x00, 0x00,
  0x9F, 0xF6, 0x00, 0x00, 0x00, 0x00,
  0x9F, 0xFB, 0x99, 0x99, 0x70, 0x00,
  0x9F, 0xFF, 0xFF, 0xFF, 0xF3, 0x00,
  0x9F, 0xFD, 0xBB, 0xBB, 0x90, 0x00,
  0x9F, 0xF6, 0x00, 0x00, 0x00, 0x00,
  0x9F, 0xF6, 0x00, 0x00, 0x00, 0x00,
  0x9F, 0xF6, 0x00, 0x00, 0x00, 0x00,
  0x9F, 0xF6, 0x00, 0x00, 0x00, 0x00,
  0x5F, 0xF3, 0x00, 0x00, 0x00, 0x00,
  0x03, 0x20, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0047[105] = { /* code 0047, LATIN CAPITAL LETTER G */
  0x00, 0x00, 0x03, 0x43, 0x10, 0x00, 0x00,
  0x00, 0x2A, 0xFF, 0xFF, 0xFA, 0x20, 0x00,
  0x03, 0xEF, 0xFF, 0xFF, 0xFF, 0xE2, 0x00,
  0x1E, 0xFF, 0xB4, 0x23, 0xAF, 0xFA, 0x00,
  0x8F, 0xFB, 0x00, 0x00, 0x0B, 0xF8, 0x00,
  0xCF, 0xF3, 0x00, 0x00, 0x00, 0x20, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xD0, 0x00, 0x5D, 0xDD, 0xDD, 0x30,
  0xFF, 0xE0, 0x00, 0x8F, 0xFF, 0xFF, 0x60,
  0xDF, 0xF2, 0x00, 0x15, 0x69, 0xFF, 0x60,
  0x9F, 0xF9, 0x00, 0x00, 0x0B, 0xFF, 0x60,
  0x2F, 0xFF, 0x82, 0x02, 0x9F, 0xFF, 0x60,
  0x06, 0xFF, 0xFF, 0xFF, 0xFE, 0xEF, 0x60,
  0x00, 0x4C, 0xFF, 0xFF, 0xD3, 0x9F, 0x50,
  0x00, 0x00, 0x24, 0x43, 0x00, 0x03, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0048[ 90] = { /* code 0048, LATIN CAPITAL LETTER H */
  0x02, 0x10, 0x00, 0x00, 0x01, 0x20,
  0x6F, 0xE2, 0x00, 0x00, 0x2E, 0xF6,
  0x9F, 0xF5, 0x00, 0x00, 0x5F, 0xF9,
  0x9F, 0xF6, 0x00, 0x00, 0x6F, 0xF9,
  0x9F, 0xF6, 0x00, 0x00, 0x6F, 0xF9,
  0x9F, 0xF6, 0x00, 0x00, 0x6F, 0xF9,
  0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF9,
  0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF9,
  0x9F, 0xFA, 0x77, 0x77, 0xAF, 0xF9,
  0x9F, 0xF6, 0x00, 0x00, 0x6F, 0xF9,
  0x9F, 0xF6, 0x00, 0x00, 0x6F, 0xF9,
  0x9F, 0xF6, 0x00, 0x00, 0x6F, 0xF9,
  0x9F, 0xF5, 0x00, 0x00, 0x5F, 0xF9,
  0x6F, 0xE2, 0x00, 0x00, 0x2E, 0xF7,
  0x03, 0x20, 0x00, 0x00, 0x02, 0x30
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0049[ 30] = { /* code 0049, LATIN CAPITAL LETTER I */
  0x02, 0x10,
  0x6F, 0xE2,
  0x9F, 0xF5,
  0x9F, 0xF6,
  0x9F, 0xF6,
  0x9F, 0xF6,
  0x9F, 0xF6,
  0x9F, 0xF6,
  0x9F, 0xF6,
  0x9F, 0xF6,
  0x9F, 0xF6,
  0x9F, 0xF6,
  0x9F, 0xF5,
  0x6F, 0xE2,
  0x03, 0x20
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_004A[ 75] = { /* code 004A, LATIN CAPITAL LETTER J */
  0x00, 0x00, 0x00, 0x02, 0x00,
  0x00, 0x00, 0x00, 0xBF, 0xB0,
  0x00, 0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0x00, 0xFF, 0xF0,
  0x01, 0x00, 0x00, 0xFF, 0xF0,
  0x5F, 0xC0, 0x00, 0xFF, 0xF0,
  0x9F, 0xF1, 0x00, 0xFF, 0xE0,
  0x9F, 0xF6, 0x07, 0xFF, 0xB0,
  0x3F, 0xFF, 0xFF, 0xFF, 0x50,
  0x05, 0xEF, 0xFF, 0xF7, 0x00,
  0x00, 0x03, 0x43, 0x10, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_004B[ 90] = { /* code 004B, LATIN CAPITAL LETTER K */
  0x02, 0x10, 0x00, 0x00, 0x11, 0x00,
  0x6F, 0xE2, 0x00, 0x02, 0xEF, 0x50,
  0x9F, 0xF5, 0x00, 0x1D, 0xFF, 0x60,
  0x9F, 0xF6, 0x01, 0xDF, 0xF8, 0x00,
  0x9F, 0xF6, 0x1B, 0xFF, 0x90, 0x00,
  0x9F, 0xF6, 0xAF, 0xFA, 0x00, 0x00,
  0x9F, 0xFE, 0xFF, 0xF4, 0x00, 0x00,
  0x9F, 0xFF, 0xFF, 0xFD, 0x00, 0x00,
  0x9F, 0xFF, 0xAD, 0xFF, 0x80, 0x00,
  0x9F, 0xFA, 0x03, 0xFF, 0xF3, 0x00,
  0x9F, 0xF6, 0x00, 0x9F, 0xFD, 0x00,
  0x9F, 0xF6, 0x00, 0x1D, 0xFF, 0x70,
  0x9F, 0xF5, 0x00, 0x04, 0xFF, 0xF1,
  0x6F, 0xE2, 0x00, 0x00, 0x9F, 0xE1,
  0x03, 0x20, 0x00, 0x00, 0x03, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_004C[ 70] = { /* code 004C, LATIN CAPITAL LETTER L */
  0x02, 0x10, 0x00, 0x00, 0x00,
  0x6F, 0xE2, 0x00, 0x00, 0x00,
  0x9F, 0xF5, 0x00, 0x00, 0x00,
  0x9F, 0xF6, 0x00, 0x00, 0x00,
  0x9F, 0xF6, 0x00, 0x00, 0x00,
  0x9F, 0xF6, 0x00, 0x00, 0x00,
  0x9F, 0xF6, 0x00, 0x00, 0x00,
  0x9F, 0xF6, 0x00, 0x00, 0x00,
  0x9F, 0xF6, 0x00, 0x00, 0x00,
  0x9F, 0xF6, 0x00, 0x00, 0x00,
  0x9F, 0xF6, 0x00, 0x00, 0x00,
  0x9F, 0xFA, 0x77, 0x77, 0x72,
  0x9F, 0xFF, 0xFF, 0xFF, 0xFB,
  0x4E, 0xFF, 0xFF, 0xFF, 0xF7
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_004D[105] = { /* code 004D, LATIN CAPITAL LETTER M */
  0x02, 0x31, 0x00, 0x00, 0x00, 0x13, 0x20,
  0x7F, 0xFE, 0x30, 0x00, 0x02, 0xEF, 0xF7,
  0xBF, 0xFF, 0x80, 0x00, 0x08, 0xFF, 0xF9,
  0xBF, 0xFF, 0xD0, 0x00, 0x0C, 0xFF, 0xF9,
  0xBF, 0xFF, 0xF2, 0x00, 0x2F, 0xFF, 0xF9,
  0xBF, 0xFB, 0xF7, 0x00, 0x7F, 0xBF, 0xF9,
  0xBF, 0xF7, 0xFC, 0x00, 0xBF, 0x7F, 0xF9,
  0xBF, 0xF2, 0xFF, 0x21, 0xFF, 0x2F, 0xF9,
  0xBF, 0xF0, 0xCF, 0x65, 0xFC, 0x0F, 0xF9,
  0xBF, 0xF0, 0x8F, 0xBA, 0xF7, 0x0F, 0xF9,
  0xBF, 0xF0, 0x3F, 0xFE, 0xF3, 0x0F, 0xF9,
  0xBF, 0xF0, 0x0D, 0xFF, 0xD0, 0x0F, 0xF9,
  0xBF, 0xF0, 0x08, 0xFF, 0x80, 0x0F, 0xF9,
  0x8F, 0xB0, 0x03, 0xFF, 0x30, 0x0B, 0xF7,
  0x03, 0x10, 0x00, 0x22, 0x00, 0x01, 0x30
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_004E[ 90] = { /* code 004E, LATIN CAPITAL LETTER N */
  0x01, 0x20, 0x00, 0x00, 0x01, 0x20,
  0x6F, 0xF8, 0x00, 0x00, 0x1E, 0xF8,
  0xAF, 0xFF, 0x30, 0x00, 0x2F, 0xFB,
  0xBF, 0xFF, 0xC0, 0x00, 0x2F, 0xFB,
  0xBF, 0xFF, 0xF7, 0x00, 0x2F, 0xFB,
  0xBF, 0xFC, 0xFE, 0x20, 0x2F, 0xFB,
  0xBF, 0xF4, 0xEF, 0xB0, 0x2F, 0xFB,
  0xBF, 0xF2, 0x7F, 0xF5, 0x2F, 0xFB,
  0xBF, 0xF2, 0x0C, 0xFD, 0x3F, 0xFB,
  0xBF, 0xF2, 0x03, 0xFF, 0xAF, 0xFB,
  0xBF, 0xF2, 0x00, 0x8F, 0xFF, 0xFB,
  0xBF, 0xF2, 0x00, 0x0D, 0xFF, 0xFB,
  0xBF, 0xF2, 0x00, 0x04, 0xFF, 0xFA,
  0x8F, 0xE1, 0x00, 0x00, 0x9F, 0xF6,
  0x03, 0x10, 0x00, 0x00, 0x03, 0x30
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_004F[105] = { /* code 004F, LATIN CAPITAL LETTER O */
  0x00, 0x00, 0x01, 0x34, 0x30, 0x00, 0x00,
  0x00, 0x03, 0xBF, 0xFF, 0xFE, 0x91, 0x00,
  0x00, 0x6F, 0xFF, 0xFF, 0xFF, 0xFE, 0x20,
  0x03, 0xFF, 0xF9, 0x32, 0x4B, 0xFF, 0xD0,
  0x0B, 0xFF, 0x80, 0x00, 0x00, 0xCF, 0xF6,
  0x0F, 0xFF, 0x10, 0x00, 0x00, 0x5F, 0xFA,
  0x2F, 0xFC, 0x00, 0x00, 0x00, 0x2F, 0xFD,
  0x4F, 0xFB, 0x00, 0x00, 0x00, 0x2F, 0xFD,
  0x2F, 0xFC, 0x00, 0x00, 0x00, 0x2F, 0xFC,
  0x0F, 0xFF, 0x10, 0x00, 0x00, 0x5F, 0xF9,
  0x0A, 0xFF, 0x70, 0x00, 0x00, 0xCF, 0xF4,
  0x03, 0xFF, 0xF8, 0x22, 0x3B, 0xFF, 0xC0,
  0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xFD, 0x20,
  0x00, 0x05, 0xDF, 0xFF, 0xFF, 0x91, 0x00,
  0x00, 0x00, 0x02, 0x44, 0x31, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0050[ 84] = { /* code 0050, LATIN CAPITAL LETTER P */
  0x3D, 0xFF, 0xFF, 0xFD, 0xA3, 0x00,
  0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0x40,
  0x9F, 0xF9, 0x66, 0x6B, 0xFF, 0xC0,
  0x9F, 0xF6, 0x00, 0x00, 0xEF, 0xF1,
  0x9F, 0xF6, 0x00, 0x00, 0xEF, 0xF1,
  0x9F, 0xF6, 0x00, 0x18, 0xFF, 0xD0,
  0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0x60,
  0x9F, 0xFF, 0xFF, 0xFF, 0xE6, 0x00,
  0x9F, 0xF8, 0x44, 0x43, 0x00, 0x00,
  0x9F, 0xF6, 0x00, 0x00, 0x00, 0x00,
  0x9F, 0xF6, 0x00, 0x00, 0x00, 0x00,
  0x9F, 0xF5, 0x00, 0x00, 0x00, 0x00,
  0x6F, 0xE2, 0x00, 0x00, 0x00, 0x00,
  0x03, 0x20, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0051[105] = { /* code 0051, LATIN CAPITAL LETTER Q */
  0x00, 0x00, 0x01, 0x34, 0x30, 0x00, 0x00,
  0x00, 0x03, 0xBF, 0xFF, 0xFE, 0x91, 0x00,
  0x00, 0x6F, 0xFF, 0xFF, 0xFF, 0xFE, 0x20,
  0x03, 0xFF, 0xF9, 0x32, 0x4B, 0xFF, 0xD0,
  0x0B, 0xFF, 0x80, 0x00, 0x00, 0xCF, 0xF6,
  0x0F, 0xFF, 0x10, 0x00, 0x00, 0x5F, 0xFA,
  0x2F, 0xFC, 0x00, 0x00, 0x00, 0x2F, 0xFD,
  0x4F, 0xFB, 0x00, 0x00, 0x00, 0x2F, 0xFD,
  0x2F, 0xFC, 0x00, 0x00, 0x00, 0x2F, 0xFC,
  0x0F, 0xFF, 0x10, 0x04, 0xB2, 0x5F, 0xF9,
  0x0A, 0xFF, 0x70, 0x09, 0xFE, 0xCF, 0xF4,
  0x03, 0xFF, 0xF8, 0x23, 0xCF, 0xFF, 0xC0,
  0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0x60,
  0x00, 0x05, 0xDF, 0xFF, 0xFF, 0xBF, 0xF4,
  0x00, 0x00, 0x02, 0x44, 0x30, 0x08, 0xF4
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0052[ 84] = { /* code 0052, LATIN CAPITAL LETTER R */
  0x3D, 0xFF, 0xFF, 0xFE, 0xC7, 0x10,
  0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xB0,
  0x9F, 0xF9, 0x66, 0x67, 0xEF, 0xF4,
  0x9F, 0xF6, 0x00, 0x00, 0x9F, 0xF7,
  0x9F, 0xF6, 0x00, 0x00, 0x8F, 0xF5,
  0x9F, 0xF8, 0x44, 0x46, 0xEF, 0xD0,
  0x9F, 0xFF, 0xFF, 0xFF, 0xFC, 0x20,
  0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0x70,
  0x9F, 0xF6, 0x00, 0x06, 0xFF, 0xE0,
  0x9F, 0xF6, 0x00, 0x00, 0xDF, 0xF0,
  0x9F, 0xF6, 0x00, 0x00, 0xBF, 0xF1,
  0x9F, 0xF5, 0x00, 0x00, 0xBF, 0xF5,
  0x6F, 0xE2, 0x00, 0x00, 0x5F, 0xF4,
  0x03, 0x20, 0x00, 0x00, 0x03, 0x20
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0053[ 90] = { /* code 0053, LATIN CAPITAL LETTER S */
  0x00, 0x00, 0x24, 0x41, 0x00, 0x00,
  0x00, 0x5D, 0xFF, 0xFF, 0xC4, 0x00,
  0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0x70,
  0x0E, 0xFE, 0x40, 0x16, 0xEF, 0xF0,
  0x2F, 0xFA, 0x00, 0x00, 0x4D, 0x90,
  0x1F, 0xFF, 0x72, 0x00, 0x00, 0x00,
  0x0B, 0xFF, 0xFF, 0xDA, 0x61, 0x00,
  0x01, 0xAF, 0xFF, 0xFF, 0xFE, 0x50,
  0x00, 0x01, 0x69, 0xDF, 0xFF, 0xF2,
  0x01, 0x10, 0x00, 0x02, 0xCF, 0xF7,
  0x2E, 0xF4, 0x00, 0x00, 0x6F, 0xF7,
  0x2F, 0xFE, 0x40, 0x02, 0xDF, 0xF5,
  0x09, 0xFF, 0xFE, 0xDF, 0xFF, 0xC0,
  0x00, 0x6D, 0xFF, 0xFF, 0xF9, 0x10,
  0x00, 0x00, 0x34, 0x43, 0x10, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0054[ 84] = { /* code 0054, LATIN CAPITAL LETTER T */
  0x6E, 0xFF, 0xFF, 0xFF, 0xFF, 0xE7,
  0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB,
  0x27, 0x77, 0xBF, 0xFB, 0x77, 0x72,
  0x00, 0x00, 0x7F, 0xF7, 0x00, 0x00,
  0x00, 0x00, 0x7F, 0xF7, 0x00, 0x00,
  0x00, 0x00, 0x7F, 0xF7, 0x00, 0x00,
  0x00, 0x00, 0x7F, 0xF7, 0x00, 0x00,
  0x00, 0x00, 0x7F, 0xF7, 0x00, 0x00,
  0x00, 0x00, 0x7F, 0xF7, 0x00, 0x00,
  0x00, 0x00, 0x7F, 0xF7, 0x00, 0x00,
  0x00, 0x00, 0x7F, 0xF7, 0x00, 0x00,
  0x00, 0x00, 0x7F, 0xF7, 0x00, 0x00,
  0x00, 0x00, 0x4F, 0xF4, 0x00, 0x00,
  0x00, 0x00, 0x02, 0x20, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0055[ 90] = { /* code 0055, LATIN CAPITAL LETTER U */
  0x02, 0x10, 0x00, 0x00, 0x01, 0x20,
  0x6F, 0xE2, 0x00, 0x00, 0x2E, 0xF6,
  0x9F, 0xF5, 0x00, 0x00, 0x5F, 0xF9,
  0x9F, 0xF6, 0x00, 0x00, 0x6F, 0xF9,
  0x9F, 0xF6, 0x00, 0x00, 0x6F, 0xF9,
  0x9F, 0xF6, 0x00, 0x00, 0x6F, 0xF9,
  0x9F, 0xF6, 0x00, 0x00, 0x6F, 0xF9,
  0x9F, 0xF6, 0x00, 0x00, 0x6F, 0xF9,
  0x9F, 0xF6, 0x00, 0x00, 0x6F, 0xF9,
  0x9F, 0xF6, 0x00, 0x00, 0x6F, 0xF9,
  0x7F, 0xF7, 0x00, 0x00, 0x7F, 0xF8,
  0x3F, 0xFE, 0x62, 0x26, 0xEF, 0xF3,
  0x0A, 0xFF, 0xFF, 0xFF, 0xFF, 0xA0,
  0x00, 0x7E, 0xFF, 0xFF, 0xE7, 0x00,
  0x00, 0x00, 0x34, 0x43, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0056[ 90] = { /* code 0056, LATIN CAPITAL LETTER V */
  0x02, 0x00, 0x00, 0x00, 0x01, 0x10,
  0xAF, 0xC0, 0x00, 0x00, 0x2E, 0xF5,
  0xCF, 0xF4, 0x00, 0x00, 0x7F, 0xF7,
  0x7F, 0xF9, 0x00, 0x00, 0xCF, 0xF2,
  0x2F, 0xFD, 0x00, 0x02, 0xFF, 0xB0,
  0x0B, 0xFF, 0x30, 0x07, 0xFF, 0x60,
  0x06, 0xFF, 0x70, 0x0B, 0xFF, 0x10,
  0x01, 0xFF, 0xB0, 0x1F, 0xFA, 0x00,
  0x00, 0xAF, 0xF1, 0x6F, 0xF5, 0x00,
  0x00, 0x5F, 0xF6, 0xBF, 0xE0, 0x00,
  0x00, 0x0E, 0xFB, 0xFF, 0x80, 0x00,
  0x00, 0x09, 0xFF, 0xFF, 0x30, 0x00,
  0x00, 0x04, 0xFF, 0xFD, 0x00, 0x00,
  0x00, 0x00, 0xCF, 0xF6, 0x00, 0x00,
  0x00, 0x00, 0x03, 0x20, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0057[135] = { /* code 0057, LATIN CAPITAL LETTER W */
  0x02, 0x00, 0x00, 0x01, 0x20, 0x00, 0x00, 0x11, 0x00,
  0xAF, 0xC0, 0x00, 0x2E, 0xFB, 0x00, 0x01, 0xEF, 0x50,
  0xCF, 0xF1, 0x00, 0x6F, 0xFF, 0x10, 0x05, 0xFF, 0x70,
  0x8F, 0xF4, 0x00, 0x9F, 0xFF, 0x40, 0x08, 0xFF, 0x30,
  0x4F, 0xF7, 0x00, 0xCF, 0xFF, 0x80, 0x0B, 0xFE, 0x00,
  0x1F, 0xFA, 0x01, 0xFF, 0xAF, 0xB0, 0x0E, 0xFB, 0x00,
  0x0C, 0xFD, 0x05, 0xFE, 0x4F, 0xF0, 0x3F, 0xF7, 0x00,
  0x08, 0xFF, 0x18, 0xFA, 0x0F, 0xF3, 0x6F, 0xF3, 0x00,
  0x04, 0xFF, 0x4B, 0xF7, 0x0B, 0xF7, 0x9F, 0xE0, 0x00,
  0x00, 0xFF, 0x8F, 0xF3, 0x08, 0xFA, 0xCF, 0xA0, 0x00,
  0x00, 0xBF, 0xDF, 0xE0, 0x04, 0xFE, 0xFF, 0x70, 0x00,
  0x00, 0x7F, 0xFF, 0xA0, 0x01, 0xFF, 0xFF, 0x20, 0x00,
  0x00, 0x4F, 0xFF, 0x70, 0x00, 0xCF, 0xFE, 0x00, 0x00,
  0x00, 0x0C, 0xFE, 0x20, 0x00, 0x6F, 0xF8, 0x00, 0x00,
  0x00, 0x01, 0x41, 0x00, 0x00, 0x03, 0x30, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0058[ 90] = { /* code 0058, LATIN CAPITAL LETTER X */
  0x01, 0x10, 0x00, 0x00, 0x11, 0x00,
  0x3F, 0xF3, 0x00, 0x04, 0xFF, 0x20,
  0x5F, 0xFC, 0x00, 0x0D, 0xFF, 0x30,
  0x0D, 0xFF, 0x60, 0x8F, 0xFA, 0x00,
  0x03, 0xFF, 0xE3, 0xFF, 0xD1, 0x00,
  0x00, 0x8F, 0xFF, 0xFF, 0x40, 0x00,
  0x00, 0x0D, 0xFF, 0xF9, 0x00, 0x00,
  0x00, 0x07, 0xFF, 0xF3, 0x00, 0x00,
  0x00, 0x2F, 0xFF, 0xFC, 0x00, 0x00,
  0x00, 0xCF, 0xFD, 0xFF, 0x70, 0x00,
  0x07, 0xFF, 0xB2, 0xFF, 0xF3, 0x00,
  0x3F, 0xFF, 0x20, 0x8F, 0xFC, 0x00,
  0xAF, 0xF7, 0x00, 0x0D, 0xFF, 0x60,
  0xAF, 0xC0, 0x00, 0x05, 0xFF, 0x40,
  0x03, 0x10, 0x00, 0x00, 0x32, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0059[ 90] = { /* code 0059, LATIN CAPITAL LETTER Y */
  0x02, 0x10, 0x00, 0x00, 0x02, 0x00,
  0x9F, 0xC0, 0x00, 0x00, 0xBF, 0x90,
  0xBF, 0xF7, 0x00, 0x05, 0xFF, 0xC0,
  0x4F, 0xFE, 0x10, 0x0D, 0xFF, 0x40,
  0x0A, 0xFF, 0x80, 0x6F, 0xFA, 0x00,
  0x01, 0xEF, 0xF2, 0xEF, 0xE2, 0x00,
  0x00, 0x7F, 0xFE, 0xFF, 0x70, 0x00,
  0x00, 0x0C, 0xFF, 0xFD, 0x00, 0x00,
  0x00, 0x03, 0xFF, 0xF4, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0xCF, 0xC0, 0x00, 0x00,
  0x00, 0x00, 0x03, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_005A[ 78] = { /* code 005A, LATIN CAPITAL LETTER Z */
  0x09, 0xFF, 0xFF, 0xFF, 0xFF, 0xE6,
  0x0E, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA,
  0x03, 0x77, 0x77, 0x7B, 0xFF, 0xF4,
  0x00, 0x00, 0x00, 0x3E, 0xFF, 0x60,
  0x00, 0x00, 0x01, 0xDF, 0xF8, 0x00,
  0x00, 0x00, 0x0C, 0xFF, 0xB0, 0x00,
  0x00, 0x00, 0xAF, 0xFC, 0x10, 0x00,
  0x00, 0x07, 0xFF, 0xE2, 0x00, 0x00,
  0x00, 0x5F, 0xFF, 0x30, 0x00, 0x00,
  0x03, 0xFF, 0xF5, 0x00, 0x00, 0x00,
  0x2E, 0xFF, 0xD7, 0x77, 0x77, 0x72,
  0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB,
  0x3D, 0xFF, 0xFF, 0xFF, 0xFF, 0xF7
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_005B[ 51] = { /* code 005B, LEFT SQUARE BRACKET */
  0x3D, 0xFF, 0xE2,
  0x7F, 0xFF, 0xE2,
  0x7F, 0xF0, 0x00,
  0x7F, 0xF0, 0x00,
  0x7F, 0xF0, 0x00,
  0x7F, 0xF0, 0x00,
  0x7F, 0xF0, 0x00,
  0x7F, 0xF0, 0x00,
  0x7F, 0xF0, 0x00,
  0x7F, 0xF0, 0x00,
  0x7F, 0xF0, 0x00,
  0x7F, 0xF0, 0x00,
  0x7F, 0xF0, 0x00,
  0x7F, 0xF0, 0x00,
  0x7F, 0xF9, 0x91,
  0x4F, 0xFF, 0xF3,
  0x03, 0x66, 0x40
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_005C[ 60] = { /* code 005C, REVERSE SOLIDUS */
  0x12, 0x00, 0x00, 0x00,
  0xCF, 0x10, 0x00, 0x00,
  0x9F, 0x70, 0x00, 0x00,
  0x4F, 0xC0, 0x00, 0x00,
  0x0D, 0xF3, 0x00, 0x00,
  0x07, 0xF9, 0x00, 0x00,
  0x02, 0xFE, 0x00, 0x00,
  0x00, 0xBF, 0x50, 0x00,
  0x00, 0x5F, 0xB0, 0x00,
  0x00, 0x0E, 0xF2, 0x00,
  0x00, 0x09, 0xF7, 0x00,
  0x00, 0x03, 0xFD, 0x00,
  0x00, 0x00, 0xCF, 0x40,
  0x00, 0x00, 0x6F, 0x70,
  0x00, 0x00, 0x04, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_005D[ 51] = { /* code 005D, RIGHT SQUARE BRACKET */
  0xBF, 0xFE, 0x60,
  0xCF, 0xFF, 0xB0,
  0x00, 0x9F, 0xB0,
  0x00, 0x9F, 0xB0,
  0x00, 0x9F, 0xB0,
  0x00, 0x9F, 0xB0,
  0x00, 0x9F, 0xB0,
  0x00, 0x9F, 0xB0,
  0x00, 0x9F, 0xB0,
  0x00, 0x9F, 0xB0,
  0x00, 0x9F, 0xB0,
  0x00, 0x9F, 0xB0,
  0x00, 0x9F, 0xB0,
  0x00, 0x9F, 0xB0,
  0x79, 0xDF, 0xB0,
  0xEF, 0xFF, 0x90,
  0x25, 0x64, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_005E[ 40] = { /* code 005E, CIRCUMFLEX ACCENT */
  0x00, 0x03, 0x72, 0x00, 0x00,
  0x00, 0x0E, 0xFB, 0x00, 0x00,
  0x00, 0x7F, 0xFF, 0x50, 0x00,
  0x01, 0xEF, 0xAF, 0xD0, 0x00,
  0x09, 0xFB, 0x0D, 0xF6, 0x00,
  0x2F, 0xF3, 0x06, 0xFE, 0x10,
  0xAF, 0x90, 0x00, 0xCF, 0x70,
  0x69, 0x10, 0x00, 0x39, 0x50
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_005F[ 12] = { /* code 005F, LOW LINE */
  0x49, 0x99, 0x99, 0x99, 0x99, 0x40,
  0x14, 0x44, 0x44, 0x44, 0x44, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0060[  8] = { /* code 0060, GRAVE ACCENT */
  0x78, 0x00,
  0xEF, 0xC2,
  0x3C, 0xFE,
  0x00, 0x78
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0061[ 55] = { /* code 0061, LATIN SMALL LETTER A */
  0x00, 0x05, 0x99, 0x96, 0x10,
  0x02, 0xDF, 0xFF, 0xFF, 0xE3,
  0x09, 0xFE, 0x74, 0x8F, 0xFB,
  0x04, 0xB3, 0x00, 0x0E, 0xFB,
  0x00, 0x15, 0x79, 0xCF, 0xFB,
  0x06, 0xFF, 0xFF, 0xDE, 0xFB,
  0x2F, 0xFC, 0x41, 0x0D, 0xFB,
  0x4F, 0xF6, 0x00, 0x3F, 0xFB,
  0x2F, 0xFE, 0x89, 0xEE, 0xFD,
  0x05, 0xEF, 0xFE, 0x67, 0xFE,
  0x00, 0x13, 0x30, 0x00, 0x31
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0062[ 75] = { /* code 0062, LATIN SMALL LETTER B */
  0x02, 0x00, 0x00, 0x00, 0x00,
  0xCF, 0x80, 0x00, 0x00, 0x00,
  0xFF, 0x90, 0x00, 0x00, 0x00,
  0xFF, 0x90, 0x00, 0x00, 0x00,
  0xFF, 0x92, 0x89, 0x71, 0x00,
  0xFF, 0xCE, 0xFF, 0xFE, 0x20,
  0xFF, 0xFB, 0x69, 0xFF, 0xB0,
  0xFF, 0xE0, 0x00, 0xAF, 0xF2,
  0xFF, 0x90, 0x00, 0x5F, 0xF4,
  0xFF, 0x80, 0x00, 0x4F, 0xF6,
  0xFF, 0xB0, 0x00, 0x7F, 0xF3,
  0xFF, 0xF3, 0x02, 0xDF, 0xE0,
  0xFF, 0xEF, 0xDF, 0xFF, 0x70,
  0xDF, 0x6C, 0xFF, 0xF7, 0x00,
  0x13, 0x00, 0x33, 0x10, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0063[ 55] = { /* code 0063, LATIN SMALL LETTER C */
  0x00, 0x05, 0x99, 0x83, 0x00,
  0x01, 0xCF, 0xFF, 0xFF, 0xA0,
  0x0B, 0xFF, 0xA6, 0xBF, 0xF3,
  0x3F, 0xF9, 0x00, 0x0B, 0xD2,
  0x6F, 0xF4, 0x00, 0x00, 0x00,
  0x7F, 0xF2, 0x00, 0x00, 0x00,
  0x5F, 0xF4, 0x00, 0x04, 0x70,
  0x2F, 0xFC, 0x10, 0x3F, 0xF4,
  0x09, 0xFF, 0xED, 0xFF, 0xE1,
  0x00, 0x8E, 0xFF, 0xFC, 0x30,
  0x00, 0x00, 0x34, 0x20, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0064[ 75] = { /* code 0064, LATIN SMALL LETTER D */
  0x00, 0x00, 0x00, 0x00, 0x20,
  0x00, 0x00, 0x00, 0x08, 0xFC,
  0x00, 0x00, 0x00, 0x09, 0xFF,
  0x00, 0x00, 0x00, 0x09, 0xFF,
  0x00, 0x17, 0x98, 0x29, 0xFF,
  0x02, 0xEF, 0xFF, 0xEC, 0xFF,
  0x0B, 0xFF, 0x96, 0xBF, 0xFF,
  0x2F, 0xFA, 0x00, 0x0E, 0xFF,
  0x5F, 0xF5, 0x00, 0x09, 0xFF,
  0x6F, 0xF4, 0x00, 0x08, 0xFF,
  0x4F, 0xF7, 0x00, 0x0B, 0xFF,
  0x1E, 0xFD, 0x20, 0x3F, 0xFF,
  0x07, 0xFF, 0xFD, 0xFE, 0xFF,
  0x00, 0x7F, 0xFF, 0xC6, 0xFD,
  0x00, 0x01, 0x32, 0x00, 0x31
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0065[ 66] = { /* code 0065, LATIN SMALL LETTER E */
  0x00, 0x03, 0x89, 0x95, 0x00, 0x00,
  0x00, 0xAF, 0xFF, 0xFF, 0xC1, 0x00,
  0x09, 0xFF, 0x74, 0x6E, 0xFB, 0x00,
  0x1F, 0xF8, 0x00, 0x05, 0xFF, 0x30,
  0x4F, 0xFC, 0xBB, 0xBC, 0xFF, 0x60,
  0x6F, 0xFC, 0xBB, 0xBB, 0xBB, 0x30,
  0x4F, 0xF6, 0x00, 0x00, 0x10, 0x00,
  0x0E, 0xFD, 0x20, 0x06, 0xFA, 0x00,
  0x05, 0xFF, 0xFD, 0xEF, 0xFA, 0x00,
  0x00, 0x5D, 0xFF, 0xFE, 0x91, 0x00,
  0x00, 0x00, 0x24, 0x30, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0066[ 60] = { /* code 0066, LATIN SMALL LETTER F */
  0x00, 0x01, 0x42, 0x00,
  0x00, 0x6F, 0xFF, 0x50,
  0x01, 0xFF, 0xFD, 0x40,
  0x02, 0xFF, 0x80, 0x00,
  0x37, 0xFF, 0xA6, 0x10,
  0xBF, 0xFF, 0xFF, 0x70,
  0x26, 0xFF, 0xA4, 0x10,
  0x02, 0xFF, 0x70, 0x00,
  0x02, 0xFF, 0x70, 0x00,
  0x02, 0xFF, 0x70, 0x00,
  0x02, 0xFF, 0x70, 0x00,
  0x02, 0xFF, 0x70, 0x00,
  0x02, 0xFF, 0x70, 0x00,
  0x01, 0xEF, 0x60, 0x00,
  0x00, 0x13, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0067[ 70] = { /* code 0067, LATIN SMALL LETTER G */
  0x00, 0x16, 0x98, 0x31, 0x96,
  0x02, 0xDF, 0xFF, 0xFA, 0xFE,
  0x0B, 0xFF, 0xA6, 0xBF, 0xFF,
  0x2F, 0xF9, 0x00, 0x0C, 0xFF,
  0x5F, 0xF5, 0x00, 0x09, 0xFF,
  0x6F, 0xF4, 0x00, 0x09, 0xFF,
  0x3F, 0xF8, 0x00, 0x0C, 0xFF,
  0x0E, 0xFF, 0x64, 0x8F, 0xFF,
  0x04, 0xFF, 0xFF, 0xFE, 0xFF,
  0x00, 0x38, 0xBA, 0x49, 0xFF,
  0x01, 0x61, 0x00, 0x0B, 0xFC,
  0x09, 0xFD, 0x32, 0x6F, 0xF7,
  0x05, 0xFF, 0xFF, 0xFF, 0xB1,
  0x00, 0x39, 0xCD, 0xB7, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0068[ 75] = { /* code 0068, LATIN SMALL LETTER H */
  0x02, 0x00, 0x00, 0x00, 0x00,
  0xCF, 0x80, 0x00, 0x00, 0x00,
  0xFF, 0x90, 0x00, 0x00, 0x00,
  0xFF, 0x90, 0x00, 0x00, 0x00,
  0xFF, 0x91, 0x79, 0x83, 0x00,
  0xFF, 0xBE, 0xFF, 0xFF, 0x40,
  0xFF, 0xFD, 0x8B, 0xFF, 0xB0,
  0xFF, 0xE1, 0x00, 0xDF, 0xE0,
  0xFF, 0xA0, 0x00, 0x9F, 0xF0,
  0xFF, 0x90, 0x00, 0x9F, 0xF0,
  0xFF, 0x90, 0x00, 0x9F, 0xF0,
  0xFF, 0x90, 0x00, 0x9F, 0xF0,
  0xFF, 0x90, 0x00, 0x9F, 0xF0,
  0xCF, 0x80, 0x00, 0x8F, 0xC0,
  0x13, 0x00, 0x00, 0x03, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0069[ 30] = { /* code 0069, LATIN SMALL LETTER I */
  0x04, 0x00,
  0xAF, 0xB0,
  0xCF, 0xC0,
  0x27, 0x20,
  0x49, 0x40,
  0xCF, 0xC0,
  0xDF, 0xD0,
  0xDF, 0xD0,
  0xDF, 0xD0,
  0xDF, 0xD0,
  0xDF, 0xD0,
  0xDF, 0xD0,
  0xDF, 0xD0,
  0xAF, 0xA0,
  0x04, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_006A[ 54] = { /* code 006A, LATIN SMALL LETTER J */
  0x00, 0x04, 0x00,
  0x00, 0xAF, 0xB0,
  0x00, 0xCF, 0xC0,
  0x00, 0x27, 0x20,
  0x00, 0x49, 0x40,
  0x00, 0xCF, 0xC0,
  0x00, 0xDF, 0xD0,
  0x00, 0xDF, 0xD0,
  0x00, 0xDF, 0xD0,
  0x00, 0xDF, 0xD0,
  0x00, 0xDF, 0xD0,
  0x00, 0xDF, 0xD0,
  0x00, 0xDF, 0xD0,
  0x00, 0xDF, 0xD0,
  0x00, 0xDF, 0xD0,
  0x05, 0xEF, 0xB0,
  0x4F, 0xFF, 0x80,
  0x1A, 0xB7, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_006B[ 75] = { /* code 006B, LATIN SMALL LETTER K */
  0x02, 0x00, 0x00, 0x00, 0x00,
  0xCF, 0x80, 0x00, 0x00, 0x00,
  0xFF, 0x90, 0x00, 0x00, 0x00,
  0xFF, 0x90, 0x00, 0x00, 0x00,
  0xFF, 0x90, 0x02, 0x93, 0x00,
  0xFF, 0x90, 0x1D, 0xFC, 0x00,
  0xFF, 0x91, 0xDF, 0xF5, 0x00,
  0xFF, 0xAB, 0xFF, 0x60, 0x00,
  0xFF, 0xFF, 0xFB, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0x40, 0x00,
  0xFF, 0xE6, 0xFF, 0xE2, 0x00,
  0xFF, 0x90, 0x6F, 0xFB, 0x00,
  0xFF, 0x90, 0x0B, 0xFF, 0x60,
  0xCF, 0x80, 0x01, 0xEF, 0x50,
  0x13, 0x00, 0x00, 0x13, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_006C[ 30] = { /* code 006C, LATIN SMALL LETTER L */
  0x02, 0x00,
  0xAF, 0xA0,
  0xDF, 0xD0,
  0xDF, 0xD0,
  0xDF, 0xD0,
  0xDF, 0xD0,
  0xDF, 0xD0,
  0xDF, 0xD0,
  0xDF, 0xD0,
  0xDF, 0xD0,
  0xDF, 0xD0,
  0xDF, 0xD0,
  0xDF, 0xD0,
  0xAF, 0xA0,
  0x03, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_006D[ 88] = { /* code 006D, LATIN SMALL LETTER M */
  0x59, 0x11, 0x79, 0x82, 0x03, 0x89, 0x72, 0x00,
  0xEF, 0x9D, 0xFF, 0xFE, 0x6F, 0xFF, 0xFE, 0x20,
  0xFF, 0xFC, 0x8C, 0xFF, 0xFC, 0x8C, 0xFF, 0x70,
  0xFF, 0xE1, 0x02, 0xFF, 0xD1, 0x02, 0xFF, 0x90,
  0xFF, 0xA0, 0x00, 0xFF, 0xA0, 0x00, 0xFF, 0x90,
  0xFF, 0x90, 0x00, 0xFF, 0x90, 0x00, 0xFF, 0x90,
  0xFF, 0x90, 0x00, 0xFF, 0x90, 0x00, 0xFF, 0x90,
  0xFF, 0x90, 0x00, 0xFF, 0x90, 0x00, 0xFF, 0x90,
  0xFF, 0x90, 0x00, 0xFF, 0x90, 0x00, 0xFF, 0x90,
  0xCF, 0x80, 0x00, 0xDF, 0x80, 0x00, 0xDF, 0x70,
  0x13, 0x00, 0x00, 0x13, 0x00, 0x00, 0x13, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_006E[ 55] = { /* code 006E, LATIN SMALL LETTER N */
  0x59, 0x11, 0x79, 0x83, 0x00,
  0xEF, 0x8E, 0xFF, 0xFF, 0x40,
  0xFF, 0xFD, 0x8B, 0xFF, 0xB0,
  0xFF, 0xE1, 0x00, 0xDF, 0xE0,
  0xFF, 0xA0, 0x00, 0x9F, 0xF0,
  0xFF, 0x90, 0x00, 0x9F, 0xF0,
  0xFF, 0x90, 0x00, 0x9F, 0xF0,
  0xFF, 0x90, 0x00, 0x9F, 0xF0,
  0xFF, 0x90, 0x00, 0x9F, 0xF0,
  0xCF, 0x80, 0x00, 0x8F, 0xC0,
  0x13, 0x00, 0x00, 0x03, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_006F[ 66] = { /* code 006F, LATIN SMALL LETTER O */
  0x00, 0x04, 0x89, 0x84, 0x00, 0x00,
  0x01, 0xBF, 0xFF, 0xFF, 0xB1, 0x00,
  0x0A, 0xFF, 0x95, 0x8F, 0xFA, 0x00,
  0x1F, 0xFA, 0x00, 0x0A, 0xFF, 0x20,
  0x5F, 0xF5, 0x00, 0x05, 0xFF, 0x50,
  0x6F, 0xF4, 0x00, 0x04, 0xFF, 0x60,
  0x4F, 0xF7, 0x00, 0x06, 0xFF, 0x40,
  0x0E, 0xFD, 0x10, 0x1D, 0xFE, 0x10,
  0x07, 0xFF, 0xEB, 0xEF, 0xF7, 0x00,
  0x00, 0x6E, 0xFF, 0xFE, 0x60, 0x00,
  0x00, 0x00, 0x34, 0x30, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0070[ 70] = { /* code 0070, LATIN SMALL LETTER P */
  0x69, 0x13, 0x99, 0x61, 0x00,
  0xEF, 0xAF, 0xFF, 0xFD, 0x20,
  0xFF, 0xFB, 0x6A, 0xFF, 0xB0,
  0xFF, 0xD0, 0x00, 0xAF, 0xF2,
  0xFF, 0x90, 0x00, 0x5F, 0xF4,
  0xFF, 0x80, 0x00, 0x4F, 0xF6,
  0xFF, 0xB0, 0x00, 0x7F, 0xF3,
  0xFF, 0xF3, 0x01, 0xDF, 0xE1,
  0xFF, 0xFF, 0xDE, 0xFF, 0x80,
  0xFF, 0xAB, 0xFF, 0xF9, 0x00,
  0xFF, 0x90, 0x24, 0x10, 0x00,
  0xFF, 0x90, 0x00, 0x00, 0x00,
  0xEF, 0x90, 0x00, 0x00, 0x00,
  0x6B, 0x30, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0071[ 70] = { /* code 0071, LATIN SMALL LETTER Q */
  0x00, 0x16, 0x99, 0x31, 0x96,
  0x02, 0xDF, 0xFF, 0xFA, 0xFE,
  0x0B, 0xFF, 0xA6, 0xBF, 0xFF,
  0x2F, 0xFA, 0x00, 0x0D, 0xFF,
  0x5F, 0xF5, 0x00, 0x09, 0xFF,
  0x6F, 0xF4, 0x00, 0x08, 0xFF,
  0x4F, 0xF7, 0x00, 0x0B, 0xFF,
  0x1F, 0xFD, 0x10, 0x3F, 0xFF,
  0x08, 0xFF, 0xED, 0xFF, 0xFF,
  0x00, 0x9F, 0xFF, 0xBA, 0xFF,
  0x00, 0x01, 0x42, 0x09, 0xFF,
  0x00, 0x00, 0x00, 0x09, 0xFF,
  0x00, 0x00, 0x00, 0x09, 0xFE,
  0x00, 0x00, 0x00, 0x03, 0xB6
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0072[ 44] = { /* code 0072, LATIN SMALL LETTER R */
  0x49, 0x22, 0x97, 0x00,
  0xCF, 0x9E, 0xFF, 0x30,
  0xDF, 0xFF, 0xFB, 0x10,
  0xDF, 0xF5, 0x00, 0x00,
  0xDF, 0xE0, 0x00, 0x00,
  0xDF, 0xD0, 0x00, 0x00,
  0xDF, 0xD0, 0x00, 0x00,
  0xDF, 0xD0, 0x00, 0x00,
  0xDF, 0xD0, 0x00, 0x00,
  0xAF, 0xA0, 0x00, 0x00,
  0x04, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0073[ 55] = { /* code 0073, LATIN SMALL LETTER S */
  0x00, 0x48, 0x99, 0x61, 0x00,
  0x0A, 0xFF, 0xFF, 0xFE, 0x30,
  0x4F, 0xFA, 0x46, 0xEF, 0x80,
  0x6F, 0xF7, 0x00, 0x27, 0x10,
  0x2F, 0xFF, 0xFB, 0x82, 0x00,
  0x04, 0xCF, 0xFF, 0xFF, 0x50,
  0x03, 0x01, 0x59, 0xEF, 0xE0,
  0x4F, 0xC1, 0x00, 0xAF, 0xF0,
  0x3F, 0xFE, 0xAB, 0xFF, 0xA0,
  0x04, 0xCF, 0xFF, 0xF9, 0x10,
  0x00, 0x01, 0x33, 0x10, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0074[ 56] = { /* code 0074, LATIN SMALL LETTER T */
  0x00, 0x33, 0x00, 0x00,
  0x02, 0xFF, 0x40, 0x00,
  0x04, 0xFF, 0x60, 0x00,
  0x38, 0xFF, 0x95, 0x10,
  0xBF, 0xFF, 0xFF, 0x50,
  0x27, 0xFF, 0x94, 0x00,
  0x04, 0xFF, 0x60, 0x00,
  0x04, 0xFF, 0x60, 0x00,
  0x04, 0xFF, 0x60, 0x00,
  0x04, 0xFF, 0x60, 0x00,
  0x04, 0xFF, 0x60, 0x00,
  0x03, 0xFF, 0xEC, 0x30,
  0x00, 0xBF, 0xFF, 0x30,
  0x00, 0x02, 0x41, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0075[ 55] = { /* code 0075, LATIN SMALL LETTER U */
  0x59, 0x30, 0x00, 0x39, 0x50,
  0xEF, 0x90, 0x00, 0x9F, 0xE0,
  0xFF, 0x90, 0x00, 0x9F, 0xF0,
  0xFF, 0x90, 0x00, 0x9F, 0xF0,
  0xFF, 0x90, 0x00, 0x9F, 0xF0,
  0xFF, 0x90, 0x00, 0x9F, 0xF0,
  0xFF, 0xA0, 0x00, 0xBF, 0xF0,
  0xEF, 0xE2, 0x06, 0xFF, 0xF0,
  0x9F, 0xFF, 0xEF, 0xEF, 0xF0,
  0x1C, 0xFF, 0xF9, 0x5F, 0xD0,
  0x00, 0x24, 0x10, 0x03, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0076[ 55] = { /* code 0076, LATIN SMALL LETTER V */
  0x49, 0x20, 0x00, 0x29, 0x40,
  0xDF, 0xB0, 0x00, 0xBF, 0xD0,
  0xAF, 0xF1, 0x01, 0xFF, 0xA0,
  0x5F, 0xF5, 0x05, 0xFF, 0x50,
  0x0E, 0xF9, 0x09, 0xFE, 0x00,
  0x09, 0xFE, 0x0E, 0xF9, 0x00,
  0x03, 0xFF, 0x7F, 0xF3, 0x00,
  0x00, 0xDF, 0xEF, 0xD0, 0x00,
  0x00, 0x8F, 0xFF, 0x80, 0x00,
  0x00, 0x2F, 0xFF, 0x20, 0x00,
  0x00, 0x02, 0x42, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0077[ 77] = { /* code 0077, LATIN SMALL LETTER W */
  0x39, 0x40, 0x01, 0x89, 0x10, 0x04, 0x93,
  0xBF, 0xB0, 0x07, 0xFF, 0x80, 0x0B, 0xFB,
  0x9F, 0xF1, 0x0B, 0xFF, 0xC0, 0x0F, 0xF9,
  0x4F, 0xF4, 0x0E, 0xFF, 0xF1, 0x3F, 0xF4,
  0x0E, 0xF7, 0x2F, 0xCC, 0xF3, 0x7F, 0xE0,
  0x0A, 0xFB, 0x5F, 0x88, 0xF7, 0xAF, 0xA0,
  0x06, 0xFE, 0x9F, 0x44, 0xFA, 0xDF, 0x60,
  0x01, 0xFF, 0xEF, 0x11, 0xFE, 0xFF, 0x10,
  0x00, 0xBF, 0xFC, 0x00, 0xCF, 0xFB, 0x00,
  0x00, 0x6F, 0xF7, 0x00, 0x7F, 0xF6, 0x00,
  0x00, 0x03, 0x30, 0x00, 0x03, 0x30, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0078[ 55] = { /* code 0078, LATIN SMALL LETTER X */
  0x18, 0x70, 0x00, 0x78, 0x00,
  0x7F, 0xF4, 0x05, 0xFF, 0x30,
  0x2F, 0xFD, 0x1E, 0xFD, 0x00,
  0x07, 0xFF, 0xDF, 0xF3, 0x00,
  0x00, 0xCF, 0xFF, 0x80, 0x00,
  0x00, 0x8F, 0xFF, 0x50, 0x00,
  0x04, 0xFF, 0xFF, 0xD1, 0x00,
  0x1D, 0xFE, 0x6F, 0xF9, 0x00,
  0x8F, 0xF5, 0x0B, 0xFF, 0x30,
  0x8F, 0xB0, 0x02, 0xEF, 0x30,
  0x03, 0x00, 0x00, 0x22, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0079[ 70] = { /* code 0079, LATIN SMALL LETTER Y */
  0x39, 0x40, 0x00, 0x39, 0x30,
  0xBF, 0xD0, 0x00, 0xCF, 0xB0,
  0x8F, 0xF2, 0x01, 0xFF, 0x80,
  0x3F, 0xF7, 0x05, 0xFF, 0x30,
  0x0D, 0xFB, 0x09, 0xFD, 0x00,
  0x08, 0xFE, 0x0D, 0xF7, 0x00,
  0x03, 0xFF, 0x6F, 0xF2, 0x00,
  0x00, 0xCF, 0xEF, 0xB0, 0x00,
  0x00, 0x7F, 0xFF, 0x70, 0x00,
  0x00, 0x2F, 0xFF, 0x10, 0x00,
  0x00, 0x0C, 0xFB, 0x00, 0x00,
  0x06, 0x8F, 0xF5, 0x00, 0x00,
  0x1F, 0xFF, 0xC0, 0x00, 0x00,
  0x07, 0xB8, 0x10, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_007A[ 50] = { /* code 007A, LATIN SMALL LETTER Z */
  0x03, 0x66, 0x66, 0x66, 0x50,
  0x0F, 0xFF, 0xFF, 0xFF, 0xF5,
  0x07, 0x99, 0x9B, 0xFF, 0xE1,
  0x00, 0x00, 0x1D, 0xFE, 0x30,
  0x00, 0x01, 0xDF, 0xF4, 0x00,
  0x00, 0x1B, 0xFF, 0x50, 0x00,
  0x00, 0xBF, 0xF7, 0x00, 0x00,
  0x0A, 0xFF, 0x80, 0x00, 0x00,
  0x5F, 0xFF, 0xFF, 0xFF, 0xF5,
  0x4F, 0xFF, 0xFF, 0xFF, 0xF4
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_007B[ 68] = { /* code 007B, LEFT CURLY BRACKET */
  0x00, 0x6D, 0xFE, 0x30,
  0x01, 0xFF, 0xC9, 0x20,
  0x03, 0xFF, 0x40, 0x00,
  0x04, 0xFF, 0x40, 0x00,
  0x04, 0xFF, 0x40, 0x00,
  0x04, 0xFF, 0x40, 0x00,
  0x04, 0xFF, 0x30, 0x00,
  0x8D, 0xFB, 0x00, 0x00,
  0xDF, 0xE7, 0x00, 0x00,
  0x06, 0xFF, 0x10, 0x00,
  0x04, 0xFF, 0x40, 0x00,
  0x04, 0xFF, 0x40, 0x00,
  0x04, 0xFF, 0x40, 0x00,
  0x03, 0xFF, 0x40, 0x00,
  0x02, 0xFF, 0x95, 0x00,
  0x00, 0xBF, 0xFF, 0x40,
  0x00, 0x03, 0x55, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_007C[ 30] = { /* code 007C, VERTICAL LINE */
  0x02, 0x20,
  0x1E, 0xE1,
  0x2F, 0xF2,
  0x2F, 0xF2,
  0x2F, 0xF2,
  0x2F, 0xF2,
  0x2F, 0xF2,
  0x2F, 0xF2,
  0x2F, 0xF2,
  0x2F, 0xF2,
  0x2F, 0xF2,
  0x2F, 0xF2,
  0x2F, 0xF2,
  0x1F, 0xF1,
  0x02, 0x20
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_007D[ 68] = { /* code 007D, RIGHT CURLY BRACKET */
  0xCF, 0xEA, 0x00, 0x00,
  0x8B, 0xFF, 0x60, 0x00,
  0x00, 0xDF, 0x70, 0x00,
  0x00, 0xDF, 0x70, 0x00,
  0x00, 0xDF, 0x70, 0x00,
  0x00, 0xDF, 0x70, 0x00,
  0x00, 0xDF, 0x80, 0x00,
  0x00, 0x7F, 0xEA, 0x10,
  0x00, 0x3C, 0xFF, 0x30,
  0x00, 0xCF, 0xA0, 0x00,
  0x00, 0xDF, 0x70, 0x00,
  0x00, 0xDF, 0x70, 0x00,
  0x00, 0xDF, 0x70, 0x00,
  0x00, 0xDF, 0x70, 0x00,
  0x36, 0xFF, 0x70, 0x00,
  0xEF, 0xFE, 0x20, 0x00,
  0x36, 0x41, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_007E[ 24] = { /* code 007E, TILDE */
  0x02, 0xAB, 0x83, 0x00, 0x38, 0x00,
  0x0D, 0xFF, 0xFF, 0xBA, 0xFF, 0x00,
  0x4F, 0xC6, 0xAF, 0xFF, 0xF9, 0x00,
  0x06, 0x10, 0x01, 0x79, 0x50, 0x00
};

GUI_CONST_STORAGE GUI_CHARINFO_EXT GUI_FontRounded22_CharInfo[95] = {
   {   1,   1,   0,  18,   6, acGUI_FontRounded22_0020 } /* code 0020, SPACE */
  ,{   4,  15,   1,   4,   6, acGUI_FontRounded22_0021 } /* code 0021, EXCLAMATION MARK */
  ,{   7,   7,   1,   4,  10, acGUI_FontRounded22_0022 } /* code 0022, QUOTATION MARK */
  ,{  11,  14,   0,   5,  11, acGUI_FontRounded22_0023 } /* code 0023, NUMBER SIGN */
  ,{  11,  16,   0,   4,  11, acGUI_FontRounded22_0024 } /* code 0024, DOLLAR SIGN */
  ,{  16,  15,   1,   4,  18, acGUI_FontRounded22_0025 } /* code 0025, PERCENT SIGN */
  ,{  13,  15,   0,   4,  13, acGUI_FontRounded22_0026 } /* code 0026, AMPERSAND */
  ,{   3,   7,   1,   4,   6, acGUI_FontRounded22_0027 } /* code 0027, APOSTROPHE */
  ,{   5,  18,   1,   4,   6, acGUI_FontRounded22_0028 } /* code 0028, LEFT PARENTHESIS */
  ,{   5,  18,   0,   4,   6, acGUI_FontRounded22_0029 } /* code 0029, RIGHT PARENTHESIS */
  ,{   8,   8,   0,   4,   8, acGUI_FontRounded22_002A } /* code 002A, ASTERISK */
  ,{  11,  11,   0,   7,  11, acGUI_FontRounded22_002B } /* code 002B, PLUS SIGN */
  ,{   4,   6,   1,  15,   6, acGUI_FontRounded22_002C } /* code 002C, COMMA */
  ,{   7,   4,   0,  11,   7, acGUI_FontRounded22_002D } /* code 002D, HYPHEN-MINUS */
  ,{   4,   4,   1,  15,   6, acGUI_FontRounded22_002E } /* code 002E, FULL STOP */
  ,{   7,  15,   0,   4,   7, acGUI_FontRounded22_002F } /* code 002F, SOLIDUS */
  ,{  11,  14,   0,   5,  11, acGUI_FontRounded22_0030 } /* code 0030, DIGIT ZERO */
  ,{   7,  14,  -1,   5,   7, acGUI_FontRounded22_0031 } /* code 0031, DIGIT ONE */
  ,{  11,  13,   0,   5,  11, acGUI_FontRounded22_0032 } /* code 0032, DIGIT TWO */
  ,{  10,  14,   0,   5,  11, acGUI_FontRounded22_0033 } /* code 0033, DIGIT THREE */
  ,{  11,  14,   0,   5,  11, acGUI_FontRounded22_0034 } /* code 0034, DIGIT FOUR */
  ,{  10,  14,   0,   5,  11, acGUI_FontRounded22_0035 } /* code 0035, DIGIT FIVE */
  ,{  11,  14,   0,   5,  11, acGUI_FontRounded22_0036 } /* code 0036, DIGIT SIX */
  ,{  10,  14,   0,   5,  10, acGUI_FontRounded22_0037 } /* code 0037, DIGIT SEVEN */
  ,{  11,  14,   0,   5,  11, acGUI_FontRounded22_0038 } /* code 0038, DIGIT EIGHT */
  ,{  11,  14,   0,   5,  11, acGUI_FontRounded22_0039 } /* code 0039, DIGIT NINE */
  ,{   4,  11,   1,   8,   6, acGUI_FontRounded22_003A } /* code 003A, COLON */
  ,{   4,  13,   1,   8,   6, acGUI_FontRounded22_003B } /* code 003B, SEMICOLON */
  ,{  11,  10,   0,   8,  11, acGUI_FontRounded22_003C } /* code 003C, LESS-THAN SIGN */
  ,{  11,   8,   0,   9,  11, acGUI_FontRounded22_003D } /* code 003D, EQUALS SIGN */
  ,{  11,  10,   0,   8,  11, acGUI_FontRounded22_003E } /* code 003E, GREATER-THAN SIGN */
  ,{  10,  15,   0,   4,  10, acGUI_FontRounded22_003F } /* code 003F, QUESTION MARK */
  ,{  14,  15,   0,   4,  14, acGUI_FontRounded22_0040 } /* code 0040, COMMERCIAL AT */
  ,{  12,  15,   0,   4,  12, acGUI_FontRounded22_0041 } /* code 0041, LATIN CAPITAL LETTER A */
  ,{  12,  13,   1,   5,  13, acGUI_FontRounded22_0042 } /* code 0042, LATIN CAPITAL LETTER B */
  ,{  12,  15,   1,   4,  13, acGUI_FontRounded22_0043 } /* code 0043, LATIN CAPITAL LETTER C */
  ,{  12,  13,   1,   5,  14, acGUI_FontRounded22_0044 } /* code 0044, LATIN CAPITAL LETTER D */
  ,{  11,  13,   1,   5,  12, acGUI_FontRounded22_0045 } /* code 0045, LATIN CAPITAL LETTER E */
  ,{  11,  14,   1,   5,  11, acGUI_FontRounded22_0046 } /* code 0046, LATIN CAPITAL LETTER F */
  ,{  13,  15,   1,   4,  15, acGUI_FontRounded22_0047 } /* code 0047, LATIN CAPITAL LETTER G */
  ,{  12,  15,   1,   4,  14, acGUI_FontRounded22_0048 } /* code 0048, LATIN CAPITAL LETTER H */
  ,{   4,  15,   1,   4,   6, acGUI_FontRounded22_0049 } /* code 0049, LATIN CAPITAL LETTER I */
  ,{   9,  15,   0,   4,  10, acGUI_FontRounded22_004A } /* code 004A, LATIN CAPITAL LETTER J */
  ,{  12,  15,   1,   4,  12, acGUI_FontRounded22_004B } /* code 004B, LATIN CAPITAL LETTER K */
  ,{  10,  14,   1,   4,  11, acGUI_FontRounded22_004C } /* code 004C, LATIN CAPITAL LETTER L */
  ,{  14,  15,   1,   4,  16, acGUI_FontRounded22_004D } /* code 004D, LATIN CAPITAL LETTER M */
  ,{  12,  15,   1,   4,  14, acGUI_FontRounded22_004E } /* code 004E, LATIN CAPITAL LETTER N */
  ,{  14,  15,   0,   4,  15, acGUI_FontRounded22_004F } /* code 004F, LATIN CAPITAL LETTER O */
  ,{  12,  14,   1,   5,  13, acGUI_FontRounded22_0050 } /* code 0050, LATIN CAPITAL LETTER P */
  ,{  14,  15,   0,   4,  15, acGUI_FontRounded22_0051 } /* code 0051, LATIN CAPITAL LETTER Q */
  ,{  12,  14,   1,   5,  13, acGUI_FontRounded22_0052 } /* code 0052, LATIN CAPITAL LETTER R */
  ,{  12,  15,   0,   4,  12, acGUI_FontRounded22_0053 } /* code 0053, LATIN CAPITAL LETTER S */
  ,{  12,  14,   0,   5,  12, acGUI_FontRounded22_0054 } /* code 0054, LATIN CAPITAL LETTER T */
  ,{  12,  15,   1,   4,  14, acGUI_FontRounded22_0055 } /* code 0055, LATIN CAPITAL LETTER U */
  ,{  12,  15,   0,   4,  12, acGUI_FontRounded22_0056 } /* code 0056, LATIN CAPITAL LETTER V */
  ,{  17,  15,   0,   4,  17, acGUI_FontRounded22_0057 } /* code 0057, LATIN CAPITAL LETTER W */
  ,{  11,  15,   0,   4,  11, acGUI_FontRounded22_0058 } /* code 0058, LATIN CAPITAL LETTER X */
  ,{  11,  15,   0,   4,  11, acGUI_FontRounded22_0059 } /* code 0059, LATIN CAPITAL LETTER Y */
  ,{  12,  13,   0,   5,  12, acGUI_FontRounded22_005A } /* code 005A, LATIN CAPITAL LETTER Z */
  ,{   6,  17,   1,   5,   6, acGUI_FontRounded22_005B } /* code 005B, LEFT SQUARE BRACKET */
  ,{   7,  15,   0,   4,   7, acGUI_FontRounded22_005C } /* code 005C, REVERSE SOLIDUS */
  ,{   5,  17,   0,   5,   6, acGUI_FontRounded22_005D } /* code 005D, RIGHT SQUARE BRACKET */
  ,{   9,   8,   1,   5,  11, acGUI_FontRounded22_005E } /* code 005E, CIRCUMFLEX ACCENT */
  ,{  11,   2,  -1,  19,   9, acGUI_FontRounded22_005F } /* code 005F, LOW LINE */
  ,{   4,   4,   0,   4,   5, acGUI_FontRounded22_0060 } /* code 0060, GRAVE ACCENT */
  ,{  10,  11,   0,   8,  11, acGUI_FontRounded22_0061 } /* code 0061, LATIN SMALL LETTER A */
  ,{  10,  15,   1,   4,  11, acGUI_FontRounded22_0062 } /* code 0062, LATIN SMALL LETTER B */
  ,{  10,  11,   0,   8,  10, acGUI_FontRounded22_0063 } /* code 0063, LATIN SMALL LETTER C */
  ,{  10,  15,   0,   4,  11, acGUI_FontRounded22_0064 } /* code 0064, LATIN SMALL LETTER D */
  ,{  11,  11,   0,   8,  11, acGUI_FontRounded22_0065 } /* code 0065, LATIN SMALL LETTER E */
  ,{   7,  15,   0,   4,   7, acGUI_FontRounded22_0066 } /* code 0066, LATIN SMALL LETTER F */
  ,{  10,  14,   0,   8,  11, acGUI_FontRounded22_0067 } /* code 0067, LATIN SMALL LETTER G */
  ,{   9,  15,   1,   4,  11, acGUI_FontRounded22_0068 } /* code 0068, LATIN SMALL LETTER H */
  ,{   3,  15,   1,   4,   5, acGUI_FontRounded22_0069 } /* code 0069, LATIN SMALL LETTER I */
  ,{   5,  18,  -1,   4,   5, acGUI_FontRounded22_006A } /* code 006A, LATIN SMALL LETTER J */
  ,{   9,  15,   1,   4,  10, acGUI_FontRounded22_006B } /* code 006B, LATIN SMALL LETTER K */
  ,{   3,  15,   1,   4,   5, acGUI_FontRounded22_006C } /* code 006C, LATIN SMALL LETTER L */
  ,{  15,  11,   1,   8,  17, acGUI_FontRounded22_006D } /* code 006D, LATIN SMALL LETTER M */
  ,{   9,  11,   1,   8,  11, acGUI_FontRounded22_006E } /* code 006E, LATIN SMALL LETTER N */
  ,{  11,  11,   0,   8,  11, acGUI_FontRounded22_006F } /* code 006F, LATIN SMALL LETTER O */
  ,{  10,  14,   1,   8,  11, acGUI_FontRounded22_0070 } /* code 0070, LATIN SMALL LETTER P */
  ,{  10,  14,   0,   8,  11, acGUI_FontRounded22_0071 } /* code 0071, LATIN SMALL LETTER Q */
  ,{   7,  11,   1,   8,   7, acGUI_FontRounded22_0072 } /* code 0072, LATIN SMALL LETTER R */
  ,{   9,  11,   0,   8,  10, acGUI_FontRounded22_0073 } /* code 0073, LATIN SMALL LETTER S */
  ,{   7,  14,   0,   5,   7, acGUI_FontRounded22_0074 } /* code 0074, LATIN SMALL LETTER T */
  ,{   9,  11,   1,   8,  11, acGUI_FontRounded22_0075 } /* code 0075, LATIN SMALL LETTER U */
  ,{   9,  11,   0,   8,   9, acGUI_FontRounded22_0076 } /* code 0076, LATIN SMALL LETTER V */
  ,{  14,  11,   0,   8,  14, acGUI_FontRounded22_0077 } /* code 0077, LATIN SMALL LETTER W */
  ,{   9,  11,   0,   8,   9, acGUI_FontRounded22_0078 } /* code 0078, LATIN SMALL LETTER X */
  ,{   9,  14,   0,   8,   9, acGUI_FontRounded22_0079 } /* code 0079, LATIN SMALL LETTER Y */
  ,{  10,  10,   0,   8,  10, acGUI_FontRounded22_007A } /* code 007A, LATIN SMALL LETTER Z */
  ,{   7,  17,   0,   5,   6, acGUI_FontRounded22_007B } /* code 007B, LEFT CURLY BRACKET */
  ,{   4,  15,   0,   4,   4, acGUI_FontRounded22_007C } /* code 007C, VERTICAL LINE */
  ,{   7,  17,   0,   5,   6, acGUI_FontRounded22_007D } /* code 007D, RIGHT CURLY BRACKET */
  ,{  11,   4,   0,  11,  11, acGUI_FontRounded22_007E } /* code 007E, TILDE */
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_FontRounded22_Prop1 = {
   0x0020 /* first character */
  ,0x007E /* last character  */
  ,&GUI_FontRounded22_CharInfo[  0] /* address of first character */
  ,(GUI_CONST_STORAGE GUI_FONT_PROP_EXT *)0 /* pointer to next GUI_FONT_PROP_EXT */
};

GUI_CONST_STORAGE GUI_FONT GUI_FontRounded22 = {
   GUI_FONTTYPE_PROP_AA4_EXT /* type of font    */
  ,22 /* height of font  */
  ,22 /* space of font y */
  ,1 /* magnification x */
  ,1 /* magnification y */
  ,{&GUI_FontRounded22_Prop1}
  ,22 /* Baseline */
  ,11 /* Height of lowercase characters */
  ,15 /* Height of capital characters */
};

/*********************************************************************
*
*       _bmBrowser
*
* Purpose:
*   Icon bitmap with alpha channel
*/
static GUI_CONST_STORAGE uint16_t _acBrowser[] = {
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x9080, 0x90A0,
0x90A0, 0x90A0, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x9080, 0x9922, 0xB225, 0xC329, 0xCC0C, 0xDCCF, 0xE530,
0xDD30, 0xDCEF, 0xD42C, 0xC369, 0xB2A6, 0xA1A3, 0x9100, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x90A1, 0xBAE8, 0xDD0F, 0xF674, 0xFF39, 0xFFDC, 0xFFFE, 0xFFFE, 0xFFFE,
0xFFFE, 0xFFFE, 0xFFFD, 0xFFBC, 0xFF38, 0xF674, 0xE570, 0xCBCA, 0xA1A2, 0x88C0, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x9081, 0xBB09, 0xEDB1, 0xFF37, 0xFFBC, 0xFFFE, 0xFFFF, 0xFFFF, 0xF7DE, 0xF7DE, 0xFFFF,
0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDD, 0xFF9B, 0xFF16, 0xF5F1, 0xD40B, 0xA1A2, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x8800, 0xAA26, 0xE550, 0xFF16, 0xFF7A, 0xF7DE, 0xFFFF, 0xF7BE, 0xF7BE, 0xEFBD, 0xEFBD, 0xF7DE, 0xF7BE,
0xFFFF, 0xFFFF, 0xF7DE, 0xF7BD, 0xEF9D, 0xEFBD, 0xEFBE, 0xF7BD, 0xFF59, 0xFED4, 0xF5B0, 0xC369, 0x9120, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x9061, 0xCBAB, 0xFE93, 0xFF16, 0xEF7C, 0xE79C, 0xEF9C, 0xEF9C, 0xEF9D, 0xFFFE, 0xF7BE, 0xFFFF, 0xFFFF, 0xF7BE,
0xF7DD, 0xE79C, 0xE77C, 0xE77C, 0xE77C, 0xE77C, 0xE77C, 0xE77C, 0xE79D, 0xEF7B, 0xFEB4, 0xFE71, 0xDCEE, 0xA1A2, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x9061, 0xD46D, 0xFEB3, 0xEED6, 0xDF7B, 0xDF5B, 0xDF5B, 0xDF5B, 0xDF5B, 0xDF5B, 0xEF9C, 0xEFBD, 0xEFBD, 0xF7BE, 0xE79C,
0xDF5B, 0xDF5B, 0xDF5B, 0xDF5B, 0xDF5B, 0xDF5B, 0xDF5B, 0xDF5B, 0xDF5B, 0xDF5B, 0xDF7B, 0xEE94, 0xFE2F, 0xED70, 0xAA03, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x9061, 0xE50F, 0xF651, 0xD6B5, 0xD73A, 0xD73A, 0xD73A, 0xD73A, 0xD73A, 0xD73A, 0xCF19, 0xD73A, 0xD73A, 0xD73A, 0xE77C, 0xDF5B,
0xD73A, 0xD73A, 0xD73A, 0xD73A, 0xD73A, 0xD73A, 0xD73A, 0xD73A, 0xD73A, 0xD73A, 0xD73A, 0xD75B, 0xBE53, 0xD58C, 0xFDD1, 0xAA03, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x8841, 0xDC6D, 0xE60E, 0xB612, 0xC719, 0xCF19, 0xCF19, 0xC6F9, 0xC6F8, 0xCF19, 0xEF7C, 0xDF5B, 0xF7BD, 0xF7DE, 0xF7DE, 0xF7BD, 0xCF19,
0xCF19, 0xCF19, 0xCF19, 0xCF19, 0xCF19, 0xCF19, 0xCF19, 0xCF19, 0xCF19, 0xCF19, 0xCF19, 0xCF19, 0xCF3A, 0x8D8F, 0xAD09, 0xF590, 0xA9E3, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x8000, 0xCBAC, 0xF650, 0x8D4D, 0xBED8, 0xC6F8, 0xBED8, 0xBED7, 0xCF19, 0xE75A, 0xEF7B, 0xFFBD, 0xFFDD, 0xFFDE, 0xFFDE, 0xFFFE, 0xFFFF, 0xD73A,
0xBED7, 0xC6F8, 0xC6F8, 0xC6F8, 0xC6F8, 0xC6F8, 0xC6F8, 0xC6F8, 0xC6D8, 0xC6F8, 0xC6F8, 0xC6F8, 0xC6F8, 0xC6F9, 0x5CCA, 0xB54A, 0xED4F, 0x9161, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0xAA06, 0xFE52, 0x8CA8, 0xA655, 0xBEB7, 0xB696, 0xC6D7, 0xDF19, 0xFF9B, 0xFF9C, 0xFFBD, 0xFFBD, 0xFFBD, 0xFFBD, 0xFFDE, 0xFFDE, 0xFFDE, 0xDF5B,
0xBEB6, 0xBEB7, 0xBEB7, 0xBEB7, 0xBEB7, 0xBEB7, 0xBEB7, 0xBEB7, 0xBEB7, 0xBEB7, 0xBEB7, 0xBEB7, 0xBEB7, 0xC6D7, 0xAE75, 0x33A3, 0xDDCE, 0xD3EA, 0x78E0, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x8841, 0xF550, 0xA4C8, 0x7D2E, 0xBE97, 0xC697, 0xE719, 0xF75A, 0xFF7B, 0xFF7B, 0xFF7B, 0xFF9C, 0xFF9C, 0xFFBC, 0xFFBD, 0xFFBD, 0xFFDD, 0xEF7C, 0xBE76,
0xB675, 0xBE96, 0xB676, 0xB676, 0xB676, 0xB676, 0xB676, 0xD6F8, 0xCEB7, 0xB676, 0xB676, 0xB676, 0xB676, 0xB676, 0xBE97, 0x7D4F, 0x5BA3, 0xF5F0, 0xAA44, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0xC30A, 0xE5EE, 0x22A1, 0x6CAD, 0xCEB7, 0xFF39, 0xFF5A, 0xFF5A, 0xFF5A, 0xFF7B, 0xFF7B, 0xFF7B, 0xFF9B, 0xFF9C, 0xFF9C, 0xFFBC, 0xFFDD, 0xD6D8, 0xAE14,
0xCEB7, 0xF77B, 0xEF5A, 0xBE76, 0xBE76, 0xBE76, 0xDEF8, 0xDED8, 0xB635, 0xB635, 0xB635, 0xB635, 0xB635, 0xB635, 0xBE76, 0x7D0E, 0x1260, 0xBD2B, 0xE4EE, 0x8900, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, 0x9081, 0xF5B1, 0x9426, 0x5B23, 0x32A1, 0xE612, 0xFF59, 0xFF39, 0xFF39, 0xFF5A, 0xFF5A, 0xFF5A, 0xFF7B, 0xFF7B, 0xFF7B, 0xFF9C, 0xFF9C, 0xDED9, 0xB614, 0xADF4,
0xBE35, 0xBE56, 0xC656, 0xBE55, 0xEF19, 0xEF19, 0xD6B7, 0xC655, 0xADF4, 0xADF4, 0xADF4, 0xADF4, 0xB614, 0xB614, 0x748C, 0x2261, 0x1200, 0x6343, 0xFE31, 0xB284, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, 0xBAE9, 0xEDCE, 0x7323, 0x93C6, 0x9C06, 0xFD8C, 0xFE31, 0xFEF7, 0xFF39, 0xFF39, 0xFF39, 0xFF59, 0xFF5A, 0xFF5A, 0xFF7B, 0xF73A, 0xC635, 0xA592, 0xA593, 0xADB3,
0xA593, 0xA592, 0xA592, 0xADB3, 0xADB3, 0xADB3, 0xA593, 0xA593, 0xADB3, 0xADB3, 0xADB3, 0xADD4, 0x9D51, 0x5B88, 0x19E0, 0x2200, 0x2200, 0x2200, 0xD56D, 0xE4CD, 0x7100, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, 0x8800, 0xED30, 0x93E7, 0x9385, 0x8344, 0xB447, 0xFDAC, 0xFD8C, 0xFDAD, 0xFE52, 0xFEF7, 0xFF39, 0xFF39, 0xFF39, 0xFF39, 0xDE96, 0xAD72, 0x9D51, 0xA552, 0xA552, 0xA552,
0xA552, 0xA552, 0xA552, 0xA552, 0xA552, 0xA552, 0xA552, 0xA552, 0xAD73, 0xAD93, 0x9D10, 0x6368, 0x3222, 0x21A0, 0x29C0, 0x29C0, 0x29C0, 0x2180, 0x8386, 0xFE11, 0xA1C1, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, 0x98C3, 0xF5B0, 0x5242, 0xABC6, 0xFD6B, 0xF52A, 0xFD6B, 0xFD8C, 0xFD8C, 0xFD8C, 0xFDCE, 0xFE52, 0xFEB5, 0xFF18, 0xFF18, 0xAD72, 0xA531, 0xA532, 0xA531, 0xA531, 0xA531,
0xA531, 0xA531, 0xA531, 0xA531, 0xA552, 0xA552, 0xA531, 0x9CF1, 0x842C, 0x6B27, 0x5263, 0x2940, 0x3180, 0x31A0, 0x31A0, 0x31A0, 0x31A0, 0x2980, 0x5242, 0xF611, 0xBAC5, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, 0xAA06, 0xEDAE, 0x4A21, 0xCC68, 0xFDAC, 0xFD6B, 0xFD6B, 0xFD6B, 0xFD8C, 0xFD8C, 0xFDAD, 0xFDAD, 0xFDCE, 0xFE10, 0xFE52, 0x840B, 0x6BAA, 0x842C, 0x8C6D, 0x8C8E, 0x94AE,
0x94AE, 0x8C8E, 0x8C6D, 0x842C, 0x7BCB, 0x6B69, 0x5AE6, 0x4243, 0x31A0, 0x2960, 0x5A62, 0x4201, 0x31A0, 0x31A0, 0x31A0, 0x31A0, 0x31C0, 0x31A0, 0x31C0, 0xD56E, 0xD3E9, 0x60C0, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, 0xBAE9, 0xFE70, 0x8B65, 0x6AC3, 0xB427, 0xE50A, 0xFD8B, 0xFD8B, 0xFD6C, 0xFD8C, 0xFD8C, 0xFDAD, 0xFDAD, 0xFDCE, 0xFDEE, 0xC4AA, 0x3A01, 0x29C0, 0x3201, 0x3A01, 0x3A01,
0x3A01, 0x3A01, 0x3201, 0x31E0, 0x31C0, 0x29A0, 0x29C0, 0x31C0, 0x31E0, 0x31E0, 0x4A42, 0x8345, 0x31C0, 0x31E0, 0x3A21, 0x4A42, 0x31E0, 0x29C0, 0x29A0, 0x9C4A, 0xE4ED, 0x7900, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, 0xD3CC, 0xE58D, 0x4A62, 0x21C0, 0x29E0, 0x4241, 0x93A5, 0xD4C9, 0xFD8B, 0xFD8C, 0xFD8C, 0xFD8C, 0xFDAD, 0xFDAD, 0xFDAD, 0xFE0F, 0xB489, 0x3201, 0x29E0, 0x29E0, 0x29E0,
0x29E0, 0x3200, 0x3200, 0x3200, 0x3201, 0x3201, 0x3201, 0x3201, 0x3201, 0x3201, 0x3200, 0x93A5, 0x5AA2, 0x62C3, 0xBC88, 0x7324, 0x21E0, 0x4A82, 0x29E0, 0x7366, 0xED90, 0x8960, TRANSP, TRANSP,
TRANSP, TRANSP, 0x8000, 0xDC8E, 0x7BC6, 0x2A00, 0x3241, 0x3241, 0x2A21, 0x2A00, 0x3A41, 0x6B24, 0xD4C9, 0xFD8C, 0xFD8C, 0xFD8C, 0xFD8C, 0xFDAD, 0xFDAD, 0xFDEE, 0xC4AA, 0x6304, 0x6304, 0x7345,
0x8386, 0x3A41, 0x3241, 0x3241, 0x3241, 0x3241, 0x3241, 0x3241, 0x3241, 0x3241, 0x3241, 0x3A61, 0x3A61, 0x3A41, 0x93C6, 0x6B24, 0x93E7, 0xED8D, 0x52C3, 0x7386, 0xF612, 0x91A1, TRANSP, TRANSP,
TRANSP, TRANSP, 0x8800, 0xDCCE, 0x6BA6, 0x2A40, 0x3261, 0x3261, 0x3261, 0x3261, 0x3261, 0x2220, 0x7364, 0xFD8B, 0xFD8B, 0xFD6B, 0xFD8C, 0xFD8C, 0xFD8C, 0xFD8C, 0xFDAD, 0xFD8D, 0xFD8C, 0xFDAD,
0xFD8C, 0x4AC2, 0x2A61, 0x3261, 0x3261, 0x3261, 0x3261, 0x3261, 0x3261, 0x3261, 0x3261, 0x2A41, 0x42A2, 0x93C6, 0x7365, 0xD50B, 0xF5CE, 0xC4EB, 0x8C08, 0xB4EB, 0xEE32, 0x99A1, TRANSP, TRANSP,
TRANSP, TRANSP, 0x8800, 0xDCCF, 0x73C6, 0x2A81, 0x32A1, 0x32A1, 0x32A1, 0x32A1, 0x32A1, 0x32A1, 0x3281, 0x7BA5, 0xE52A, 0xFD6B, 0xFD6B, 0xFD6B, 0xFD6C, 0xFD8C, 0xFD8C, 0xFD8C, 0xFD8C, 0xFD8C,
0xFDAC, 0x83C5, 0x2A61, 0x32A1, 0x32A1, 0x32A1, 0x32A1, 0x32A1, 0x32A1, 0x32A1, 0x3281, 0x3AA2, 0xC4C9, 0xED6B, 0xCD0B, 0x8BE6, 0x9448, 0x6B85, 0x9C8A, 0xE5F0, 0xEE32, 0x99A1, TRANSP, TRANSP,
TRANSP, TRANSP, 0x8800, 0xDC8E, 0x7407, 0x2AA1, 0x32C2, 0x32C2, 0x32C2, 0x32C2, 0x32C2, 0x32C2, 0x32C1, 0x2281, 0x4B02, 0xE52A, 0xFD6B, 0xFD6B, 0xFD6B, 0xFD6B, 0xFD6B, 0xFD6B, 0xFD6B, 0xFD6B,
0xFD8C, 0xB467, 0x2AA1, 0x32C2, 0x32C2, 0x32C2, 0x32C2, 0x32C2, 0x32C2, 0x32C1, 0x32C1, 0xB488, 0xFDAD, 0xFDCD, 0xF5AD, 0x7BC6, 0x4B23, 0x6BA6, 0xD5AF, 0xFE93, 0xF633, 0x91A1, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, 0xD3EC, 0x7C89, 0x2AC1, 0x32E2, 0x32E2, 0x32E2, 0x32E2, 0x32E2, 0x32E2, 0x32E2, 0x2AE2, 0x6BA4, 0xED2A, 0xFD6B, 0xFD4B, 0xFD4B, 0xFD6B, 0xFD6B, 0xFD6B, 0xFD6B, 0xFD6B,
0xFD6B, 0xD4E9, 0x3B02, 0x32E2, 0x32E2, 0x32E2, 0x32E2, 0x32E2, 0x32E2, 0x2AC1, 0x6BA4, 0xFDAD, 0xFDAD, 0xED8D, 0x9468, 0xE5AE, 0xDD8E, 0xE5D0, 0xFE93, 0xFED5, 0xEDB1, 0x8960, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, 0xCB2A, 0x94EA, 0x2AE1, 0x3322, 0x3322, 0x3322, 0x3322, 0x3322, 0x3322, 0x2B02, 0x8C26, 0xFD8B, 0xFD6B, 0xFD4B, 0xFD4A, 0xFD4A, 0xFD4A, 0xFD4A, 0xFD4A, 0xFD4A, 0xFD4A,
0xFD6B, 0xDD09, 0x3B22, 0x3302, 0x3322, 0x3322, 0x3322, 0x3322, 0x2B02, 0x3B22, 0xBCC9, 0xFDCE, 0xFDCE, 0xEDAD, 0xACCA, 0xF610, 0xF611, 0xFE93, 0xFEB4, 0xFF16, 0xDCEE, 0x7900, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, 0xBA47, 0xAD4D, 0x2B22, 0x3342, 0x3342, 0x3342, 0x3342, 0x3342, 0x3342, 0x3342, 0xD52A, 0xFD8C, 0xFD6B, 0xFD6B, 0xFD6B, 0xFD6B, 0xFD6B, 0xFD6B, 0xFD4B, 0xFD4B, 0xFD4B,
0xFD6B, 0xE52A, 0x3B62, 0x3342, 0x3342, 0x3342, 0x3342, 0x3342, 0x7405, 0xACC9, 0xFDCE, 0xFDCE, 0xFDEF, 0xDD8D, 0x4383, 0x7C68, 0x53A4, 0xBD8E, 0xC5AF, 0xFEF6, 0xCBEA, 0x60C0, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, 0x98E3, 0xDDF1, 0x3BA3, 0x3362, 0x3362, 0x3362, 0x3362, 0x3362, 0x2B62, 0x53C4, 0xF58D, 0xFD8D, 0xFD8C, 0xFD8C, 0xFD6C, 0xFD6B, 0xFD6B, 0xFD6B, 0xFD6B, 0xFD6B, 0xFD6B,
0xFD6B, 0xF56B, 0x63E4, 0x2B62, 0x3362, 0x3362, 0x2B62, 0x6C05, 0x8467, 0xC52B, 0xFDEF, 0xFDEF, 0xFE10, 0xF610, 0x4BC4, 0x2341, 0x3362, 0x2B62, 0x6468, 0xFEF6, 0xBAE5, 0x48A0, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, 0x8820, 0xE551, 0x6CA8, 0x2B82, 0x33A3, 0x33A3, 0x2B82, 0x7C87, 0xBD4C, 0xD54C, 0xFDCE, 0xFDAD, 0xFDAD, 0xFD8D, 0xFD8C, 0xFD8C, 0xFD8C, 0xFD8C, 0xFD8C, 0xFD8C, 0xFD8C,
0xFD8C, 0xFDAD, 0xC509, 0x33A2, 0x33A3, 0x33A3, 0x33A3, 0x6C25, 0x94A8, 0xFDEF, 0xFDEF, 0xFE10, 0xFE51, 0xF631, 0x4BE4, 0x2B82, 0x33A3, 0x2361, 0x9D6D, 0xFE95, 0xA1C1, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, 0xCB4B, 0xBE10, 0x2BA2, 0x33C3, 0x2BA2, 0x5C46, 0xF610, 0xFE31, 0xFE10, 0xFDEF, 0xFDCE, 0xFDCE, 0xFDCE, 0xFDAD, 0xFDAD, 0xFDAD, 0xFDAD, 0xFDAD, 0xFDAD, 0xFDAD,
0xFDAD, 0xFDAD, 0xFDCD, 0x6445, 0x23A2, 0x23A2, 0x6445, 0xBD4B, 0xF5EF, 0xFE10, 0xFE31, 0xE5F0, 0xD5CF, 0xFE73, 0x43E4, 0x23A2, 0x33C2, 0x3BE4, 0xE6F6, 0xE50F, 0x7900, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, 0x90A2, 0xF613, 0x64C8, 0x2BC2, 0x3403, 0xCDAF, 0xFE73, 0xFE31, 0xFE31, 0xFE10, 0xFDF0, 0xFDEF, 0xFDEF, 0xFDCE, 0xFDCE, 0xFDCE, 0xFDCE, 0xFDCE, 0xFDCE, 0xFDCE,
0xFDCE, 0xFDCE, 0xFDEF, 0xAD2A, 0x6466, 0x84C8, 0xDDAE, 0xFE31, 0xFE31, 0xFE31, 0xFE73, 0xA54C, 0xB58E, 0xFEB5, 0xA58D, 0x64A8, 0x23A1, 0x854C, 0xFF18, 0xB2A5, 0x4080, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, 0x7800, 0xD3AC, 0xC672, 0x2402, 0x5CA7, 0xFE94, 0xFE93, 0xFE72, 0xFE52, 0xFE31, 0xFE31, 0xFE11, 0xFE10, 0xFE10, 0xFDF0, 0xFDEF, 0xFDEF, 0xFDEF, 0xFDEF, 0xFDEF,
0xFDEF, 0xFDEF, 0xFDF0, 0xFE10, 0xFE10, 0xFE51, 0xFE51, 0xFE51, 0xFE52, 0xFE73, 0xF673, 0x74E9, 0xE673, 0xFED6, 0xFF38, 0xEED6, 0x9DAF, 0xEF58, 0xE550, 0x8920, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x90A2, 0xF614, 0x756B, 0x4485, 0xF6B4, 0xFEB5, 0xFE94, 0xFE73, 0xFE73, 0xFE52, 0xFE52, 0xFE51, 0xFE31, 0xFE31, 0xFE31, 0xFE11, 0xFE10, 0xFE10, 0xFE10,
0xFE11, 0xFE31, 0xFE31, 0xFE31, 0xFE52, 0xFE52, 0xFE52, 0xFE73, 0xFE93, 0xFE94, 0xF694, 0xD632, 0xFED6, 0xFEF7, 0xFF18, 0xFF5A, 0xFFBD, 0xFEF8, 0xB284, 0x50A0, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0xBAA9, 0xF737, 0x4CE7, 0x95AD, 0xFEF7, 0xFED6, 0xFEB5, 0xFEB4, 0xFE94, 0xFE73, 0xFE73, 0xFE73, 0xFE52, 0xFE52, 0xFE52, 0xFE52, 0xFE52, 0xFE52,
0xFE52, 0xFE52, 0xFE72, 0xFE73, 0xFE73, 0xFE73, 0xFE94, 0xFE94, 0xFEB5, 0xFED6, 0xFEF6, 0xFF18, 0xFF18, 0xFF39, 0xFF5A, 0xFF9C, 0xFFBC, 0xD44B, 0x80E0, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x8020, 0xDCAF, 0xDF15, 0x4D07, 0xDEB5, 0xFF18, 0xFEF6, 0xFED6, 0xFED5, 0xFEB5, 0xFEB4, 0xFE94, 0xFE94, 0xFE94, 0xFE93, 0xFE93, 0xFE93, 0xFE93,
0xFE93, 0xFE94, 0xFE94, 0xFE94, 0xFEB4, 0xFEB5, 0xFED5, 0xFED6, 0xFEF6, 0xFEF7, 0xFF18, 0xFF39, 0xFF5A, 0xFF7B, 0xFF9C, 0xFFFD, 0xEDF2, 0xA1A1, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x90A2, 0xED72, 0xDF37, 0xEF39, 0xFF39, 0xFF18, 0xFF18, 0xFEF7, 0xFEF7, 0xFED6, 0xFED6, 0xFED6, 0xFEB5, 0xFEB5, 0xFEB5, 0xFEB5, 0xFEB5,
0xFEB5, 0xFEB5, 0xFED6, 0xFED6, 0xFED6, 0xFEF7, 0xFEF7, 0xFF18, 0xFF18, 0xFF39, 0xFF5A, 0xFF7B, 0xFF7B, 0xFFBD, 0xFFFE, 0xF675, 0xAA43, 0x50A0, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x98E2, 0xF5F4, 0xFFDC, 0xFF7B, 0xFF5A, 0xFF3A, 0xFF39, 0xFF19, 0xFF18, 0xFF18, 0xFF17, 0xFEF7, 0xFEF7, 0xFEF7, 0xFEF7, 0xFEF7,
0xFEF7, 0xFEF7, 0xFF17, 0xFF18, 0xFF18, 0xFF39, 0xFF39, 0xFF5A, 0xFF5A, 0xFF7B, 0xFF9C, 0xFFBC, 0xFFDE, 0xFFFF, 0xF6D7, 0xB264, 0x68A0, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x98E2, 0xE592, 0xFFFC, 0xFFBD, 0xFF7B, 0xFF7B, 0xFF5A, 0xFF5A, 0xFF5A, 0xFF39, 0xFF39, 0xFF39, 0xFF39, 0xFF39, 0xFF39,
0xFF39, 0xFF39, 0xFF39, 0xFF5A, 0xFF5A, 0xFF5B, 0xFF7B, 0xFF9B, 0xFF9C, 0xFFBD, 0xFFDE, 0xFFFF, 0xFFFF, 0xF696, 0xB264, 0x60A0, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x90C2, 0xDCEF, 0xFFBB, 0xFFFE, 0xFFBD, 0xFFBC, 0xFF9C, 0xFF9C, 0xFF7C, 0xFF7B, 0xFF7B, 0xFF7B, 0xFF7B, 0xFF7B,
0xFF7B, 0xFF7B, 0xFF7B, 0xFF9B, 0xFF9C, 0xFF9C, 0xFFBD, 0xFFBD, 0xFFDE, 0xFFFF, 0xFFFF, 0xFFFE, 0xEDF3, 0xAA23, 0x68A0, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x8040, 0xBB09, 0xF6B6, 0xFFFE, 0xF7FE, 0xE7BC, 0x9ED2, 0xCF37, 0xF7BD, 0xEF9B, 0xFFBC, 0xFFDE, 0xFFDE,
0xFFBC, 0xFFBD, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFF39, 0xD42C, 0x9961, 0x5080, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x6800, 0x9922, 0xD46E, 0xDEB5, 0x96F0, 0x4607, 0x4608, 0x4E29, 0x3DC6, 0x562A, 0x9EF3, 0xA714,
0x560A, 0x86AF, 0x9EF3, 0xAF35, 0xDFBB, 0xE7DC, 0xFFFF, 0xFFFF, 0xFF5A, 0xDD2F, 0xB244, 0x78A0, 0x2860, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x7820, 0xA184, 0xD42D, 0xD612, 0x9E6E, 0x6E6B, 0x5669, 0x3E26, 0x3606, 0x2DE5,
0x2DE5, 0x3606, 0x3605, 0x3E47, 0x666A, 0x8E6D, 0xDE74, 0xDCCF, 0xB265, 0x88C0, 0x5080, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x6820, 0x90C1, 0xB206, 0xC329, 0xCC4D, 0xD54F, 0xCE11, 0xC651,
0xC651, 0xC610, 0xC56E, 0xC48C, 0xBB89, 0xB266, 0x9962, 0x70A0, 0x4060, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x5820, 0x6840, 0x80A0, 0x88E1, 0x9102,
0x9102, 0x9101, 0x80C1, 0x7080, 0x6060, 0x4860, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP
};

GUI_CONST_STORAGE GUI_BITMAP _bmBrowser = {
  48, /* XSize */
  48, /* YSize */
  192, /* BytesPerLine */
  32, /* BitsPerPixel */
  (unsigned char *)_acBrowser,  /* Pointer to picture data */
  NULL  /* Pointer to palette */
 ,&em_BitmapMethods565
};

/*********************************************************************
*
*       _bmClock
*
* Purpose:
*   Icon bitmap with alpha channel
*/
static GUI_CONST_STORAGE uint16_t _acClock[] = {
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0xA9E2, 0xB284, 0xBAC5,
0xBAE5, 0xB2C4, 0xB262, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0xA9E3, 0xCBEC, 0xDD51, 0xEE55, 0xF6F8, 0xFF18, 0xFF39,
0xFF39, 0xFF18, 0xFEF8, 0xF695, 0xE5B2, 0xD4AD, 0xBB04, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0xB2C8, 0xDD10, 0xF6D7, 0xFFBB, 0xFFDC, 0xFFBC, 0xFFBC, 0xFFBC, 0xFFBC,
0xFFBC, 0xFFBC, 0xFFBC, 0xFFBC, 0xFFBC, 0xFF9B, 0xFEF8, 0xE5B1, 0xCC29, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0xA9E6, 0xE572, 0xFF59, 0xFF9B, 0xFFBC, 0xFFBB, 0xFEF8, 0xF655, 0xEDD3, 0xE551, 0xDD31,
0xDD31, 0xDD51, 0xEDB3, 0xF655, 0xFED7, 0xFF9B, 0xFFBC, 0xFF9B, 0xFF59, 0xF633, 0xCBC7, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0xCC0D, 0xFED6, 0xFF7A, 0xFF9B, 0xFF18, 0xEDD2, 0xCBEC, 0xBB8C, 0xBC30, 0xC492, 0xCD14, 0xBCF3,
0xBCF3, 0xCD34, 0xC4B2, 0xBC30, 0xBBAD, 0xCBAC, 0xED92, 0xFEF7, 0xFF9B, 0xFF7B, 0xFEF7, 0xE54F, 0xAA82, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x9903, 0xDCF0, 0xFF58, 0xFF5A, 0xFF17, 0xE550, 0xCBCD, 0xBC0F, 0xC514, 0xDE79, 0xE71C, 0xEF3C, 0xEF5D, 0xC618,
0xBDD7, 0xEF5D, 0xE73C, 0xE71C, 0xDE9A, 0xCD55, 0xBC10, 0xC3CD, 0xE4EF, 0xFEF7, 0xFF5A, 0xFF39, 0xEDF2, 0xBB24, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x9903, 0xEDB2, 0xFF38, 0xFF59, 0xFE32, 0xD3EC, 0xB34D, 0xCDB7, 0xE71C, 0xEF5C, 0xEF5C, 0xEF5C, 0xEF5D, 0xF77D, 0xC618,
0xBDD7, 0xF79D, 0xEF5D, 0xEF5C, 0xEF5C, 0xEF5C, 0xE73C, 0xD618, 0xB38E, 0xCBAB, 0xF5F2, 0xFF39, 0xFF19, 0xF654, 0xC365, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0xA103, 0xED91, 0xFF18, 0xFEF7, 0xED4F, 0xBB0A, 0xCD34, 0xCE79, 0xB575, 0xEF5D, 0xEF5D, 0xEF5D, 0xF77D, 0xF77D, 0xF79D, 0xDEBA,
0xD699, 0xF79E, 0xF77D, 0xF77D, 0xEF7D, 0xEF5D, 0xF77D, 0xB575, 0xC617, 0xD5B6, 0xBB2B, 0xE4ED, 0xFEF6, 0xFF18, 0xF632, 0xBB44, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0xE4CF, 0xFEF6, 0xFED6, 0xECED, 0xBB4B, 0xD5D7, 0xEF3C, 0xEF5C, 0xB596, 0xDEFB, 0xF79D, 0xF77D, 0xF79D, 0xF79E, 0xF79E, 0xF7BE,
0xF7BE, 0xF79E, 0xF79E, 0xF79D, 0xF79D, 0xF77D, 0xEF3C, 0xBDB6, 0xEF3C, 0xEF5C, 0xD639, 0xBB8D, 0xE46C, 0xFEB5, 0xFED7, 0xF5D1, 0xAA82, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0xD3CB, 0xFEB5, 0xFEB6, 0xF4EC, 0xBB4B, 0xD639, 0xEF3C, 0xEF5C, 0xEF5D, 0xF77D, 0xF77D, 0xF79E, 0xF79E, 0xF7BE, 0xF7BE, 0xF7BE, 0xFFDE,
0xFFDE, 0xF7BE, 0xF7BE, 0xF7BE, 0xF7BE, 0xF79E, 0xF77D, 0xF77D, 0xF77D, 0xEF5C, 0xEF5C, 0xDE9A, 0xB34C, 0xECAB, 0xFE94, 0xFE96, 0xE50D, 0x89C0, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0xB9E5, 0xFE12, 0xFE95, 0xFD4D, 0xBAE9, 0xD5F7, 0xEF3C, 0xEF5C, 0xEF5D, 0xF77D, 0xF79E, 0xF7BE, 0xF7BE, 0xF7DE, 0xFFDE, 0xFFDF, 0xFFFF, 0xFFFF,
0xFFFF, 0xFFFF, 0xFFDF, 0xFFDF, 0xFFDE, 0xF7BE, 0xF7BE, 0xF79D, 0xF77D, 0xEF7D, 0xEF5C, 0xEF5C, 0xDE79, 0xB2EA, 0xF4CB, 0xFE94, 0xFE53, 0xCBE7, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0xECCD, 0xFE94, 0xFDCF, 0xD348, 0xCD55, 0xEF5D, 0xEF5C, 0xEF5D, 0xF77D, 0xF79E, 0xF7BE, 0xFFBE, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFBE, 0xF7BE, 0xF79E, 0xF77D, 0xEF7D, 0xEF5C, 0xEF5C, 0xCD96, 0xCB49, 0xFD8D, 0xFE74, 0xF56E, 0xA241, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0xCA86, 0xFE12, 0xFE11, 0xEBE8, 0xB34C, 0xB555, 0xCE18, 0xEF5C, 0xF79E, 0xF79E, 0xF7BE, 0xFFDE, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFDE, 0xF7BE, 0xF79E, 0xF77D, 0xEF7D, 0xF77D, 0xD6BA, 0xB3CF, 0xE3A7, 0xFDF1, 0xFE33, 0xD428, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0xE42B, 0xFDF1, 0xFD0B, 0xCB28, 0xC596, 0x9410, 0xA471, 0xB534, 0xDEBA, 0xFFDE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDE, 0xF7BE, 0xF79E, 0xF79D, 0xBDF7, 0xAD55, 0xCE18, 0xBAE9, 0xFCC9, 0xFDD1, 0xF52D, 0x89E0, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, 0xB983, 0xFD6F, 0xFDAF, 0xEBE6, 0xBBCE, 0xE73C, 0xDE9A, 0xAD14, 0x9C30, 0xA471, 0xBDB6, 0xE71C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFDE, 0xF7BE, 0xF79D, 0xDEFB, 0xEF5C, 0xEF5D, 0xC491, 0xE385, 0xFD6D, 0xFD8F, 0xBB24, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, 0xDB48, 0xFDD0, 0xFD0A, 0xCAA4, 0xC535, 0xEF5C, 0xF77D, 0xF79E, 0xD679, 0xA492, 0x9C30, 0xA4B2, 0xCE38, 0xF79E, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xF7BE, 0xF79E, 0xF79D, 0xEF5D, 0xEF5C, 0xD5F8, 0xCAE6, 0xFCE9, 0xFDD0, 0xDBE8, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, 0xEC2A, 0xFD4D, 0xFC25, 0xBAE8, 0xDE9A, 0xEF5C, 0xEF5D, 0xF79D, 0xFFDE, 0xF7BE, 0xCE38, 0x9C51, 0x9C30, 0xAD14, 0xD679, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xF7BE, 0xF79D, 0xEF7D, 0xEF5C, 0xE6DB, 0xBAE9, 0xF3C4, 0xFD4D, 0xECEC, 0x7980, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, 0xF4AB, 0xFCCA, 0xF362, 0xBBCE, 0xE73C, 0xEF5C, 0xF77D, 0xF79D, 0xF7BE, 0xFFDF, 0xFFFF, 0xEF7D, 0xBD75, 0x9C51, 0x9C51, 0xBD96, 0xDEFB, 0xFFFF, 0xFFFF, 0xFFFF,
0xFFFF, 0xFFFF, 0xA55F, 0xEF7F, 0xFFFF, 0xFFFF, 0xFFFF, 0xF79E, 0xE71B, 0xCE59, 0xE71B, 0xFFDF, 0xF79D, 0xF77D, 0xEF5C, 0xEF5D, 0xBBCE, 0xE302, 0xFCA9, 0xFD4D, 0x9202, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, 0xC982, 0xFCCB, 0xFC67, 0xEB02, 0xC471, 0xEF3C, 0xEF5D, 0xF77D, 0xF79E, 0xF7BE, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xE71B, 0xACD3, 0x9C30, 0xA492, 0xC5D7, 0xEF7D, 0xFFDE,
0xF7DE, 0x94BF, 0x5AFE, 0xEF7E, 0xEF7D, 0xDEBA, 0xCDF7, 0xACF3, 0xA492, 0x9C30, 0xB575, 0xFFFF, 0xF79E, 0xF77D, 0xEF5D, 0xEF5C, 0xC514, 0xDAA2, 0xFC66, 0xFCEB, 0xAA83, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, 0xD1E2, 0xFCAA, 0xFC25, 0xE2C1, 0xCD14, 0xEF5D, 0xF77D, 0xF79D, 0xF79E, 0xF7BE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xD69A, 0xA492, 0x9C10, 0xA4D2, 0xB555,
0xA4D3, 0x5276, 0xB556, 0xBD95, 0xACB2, 0xA451, 0x93EF, 0x9C30, 0xAD34, 0xC618, 0xE73C, 0xFFDE, 0xF79E, 0xF79E, 0xF79D, 0xEF7D, 0xD5D7, 0xD282, 0xFC03, 0xFCCA, 0xB2E4, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, 0xDA23, 0xFCAA, 0xFBE3, 0xDAA1, 0xBCF3, 0xC638, 0xC618, 0xDEBA, 0xF7BE, 0xFFDE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xF7BE, 0xC5D7, 0x9C51, 0xB555,
0x8C10, 0x7B6C, 0x9C30, 0xA471, 0xACF3, 0xBDB6, 0xD69A, 0xEF7D, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDE, 0xF7BE, 0xDEDA, 0xC618, 0xC618, 0xC596, 0xD282, 0xFBA1, 0xFCAA, 0xBB05, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, 0xDA23, 0xFCA9, 0xFBC2, 0xDAA1, 0xBCF3, 0xBDD7, 0xBDD7, 0xD679, 0xF7BE, 0xFFDE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xB534, 0x83AE,
0x8BEF, 0x9410, 0x9451, 0xEF5D, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDE, 0xF7BE, 0xD69A, 0xBDD7, 0xBDD7, 0xBD76, 0xD283, 0xFB80, 0xFC89, 0xBB05, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, 0xDA02, 0xFCA9, 0xFBE3, 0xDAE2, 0xCD34, 0xEF7D, 0xF79D, 0xF79E, 0xF79E, 0xF7BE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xF7BF, 0x7BDC, 0xBDB7,
0xCE38, 0x9C92, 0xB555, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDE, 0xF79E, 0xF79E, 0xF79D, 0xF77D, 0xD5F8, 0xD2A3, 0xFBC2, 0xFC89, 0xB2A4, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, 0xD1A1, 0xFCAA, 0xFC25, 0xEB64, 0xC492, 0xEF3C, 0xEF5D, 0xF77D, 0xF79E, 0xF7BE, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xF7DF, 0x7BDF, 0x9CDE, 0xF79D,
0xEF7D, 0xF7BE, 0xF7DE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xF7BE, 0xF79E, 0xF77D, 0xEF5D, 0xEF5C, 0xCD35, 0xDB04, 0xFC04, 0xFCCA, 0xA223, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, 0xFC69, 0xFC66, 0xF3C5, 0xBC0F, 0xE73C, 0xEF5C, 0xF77D, 0xF79D, 0xF7BE, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x949F, 0x7BDD, 0xFFFF, 0xFFFF,
0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xF7BE, 0xF79D, 0xF77D, 0xEF5D, 0xEF5D, 0xBBEF, 0xE365, 0xFC46, 0xFCCB, 0x8982, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, 0xF408, 0xFCA8, 0xFC47, 0xBB6C, 0xDE9A, 0xEF5C, 0xEF5D, 0xF79D, 0xF7BE, 0xFFDE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xA51F, 0x73BD, 0xF7DE, 0xFFFF, 0xFFFF,
0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDE, 0xF7BE, 0xF79D, 0xF77D, 0xEF5C, 0xE6DB, 0xBB6D, 0xF427, 0xFCA8, 0xEC69, 0x68E0, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, 0xEB66, 0xFCEA, 0xFCE9, 0xCB29, 0xCD56, 0xEF5C, 0xEF5D, 0xF77D, 0xF79E, 0xF7BE, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC63F, 0x6B7E, 0xE73E, 0xFFFF, 0xFFFF, 0xFFFF,
0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xF7BE, 0xF79E, 0xF79D, 0xEF5D, 0xEF5C, 0xD618, 0xCBAC, 0xFCC9, 0xFCE9, 0xD346, 0x4880, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, 0xE222, 0xFCCA, 0xFCEA, 0xECAC, 0xBC51, 0xE73C, 0xF77D, 0xEF3C, 0xF77D, 0xF7BE, 0xFFBE, 0xFFDF, 0xFFFF, 0xDEDF, 0x633E, 0xDEFE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDE, 0xF7BE, 0xF79D, 0xEF3C, 0xF77D, 0xEF5C, 0xC4F3, 0xE44B, 0xFD0A, 0xFCEA, 0xB223, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0xF408, 0xFD0B, 0xFD4D, 0xC3CD, 0xD618, 0xAD75, 0xBDB6, 0xF77D, 0xF79E, 0xF7BE, 0xFFFE, 0xEF5F, 0x73BE, 0xCE7D, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDE, 0xF7BE, 0xF79E, 0xF79E, 0xC618, 0xAD55, 0xD659, 0xBB8D, 0xFD2D, 0xFD2B, 0xEC69, 0x70C0, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0xEAE4, 0xFD0B, 0xFD6D, 0xE4AE, 0xB3AF, 0xC5F7, 0xEF3C, 0xF77D, 0xF77D, 0xFFBE, 0xF79E, 0x7BFE, 0xB59D, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDE, 0xF7BE, 0xF79E, 0xF79D, 0xF77D, 0xEF5D, 0xC638, 0xAC10, 0xDC6E, 0xFD8E, 0xFD2B, 0xCAE6, 0x3040, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0xD181, 0xFC69, 0xFD4D, 0xFE11, 0xCC0F, 0xD596, 0xEF5C, 0xEF5C, 0xF77D, 0xF79D, 0x949E, 0xA51C, 0xFFFE, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFDE, 0xF7BE, 0xF79E, 0xF79D, 0xF77D, 0xEF5C, 0xEF5C, 0xD618, 0xC40F, 0xFDF1, 0xFD6D, 0xEC69, 0x88C1, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0xEA83, 0xFD0A, 0xFDCF, 0xF5F3, 0xBB6D, 0xD618, 0xEF5C, 0xF79C, 0xA4FE, 0x8C7D, 0xF7BD, 0xF7BE, 0xF7BE, 0xFFDE, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF,
0xFFFF, 0xFFFF, 0xFFFF, 0xFFDF, 0xFFDE, 0xF7BE, 0xF7BE, 0xF79E, 0xF77D, 0xEF7D, 0xEF5D, 0xEF5C, 0xDE9A, 0xB38E, 0xED92, 0xFDF0, 0xFD4B, 0xBA65, 0x3020, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0xF3C6, 0xFD6C, 0xFE53, 0xE593, 0xBBCF, 0xDE99, 0xB57E, 0x8C5D, 0xEF3C, 0xF7BE, 0xF79D, 0xF79E, 0xF7BE, 0xF7BE, 0xF7BE, 0xFFDE, 0xFFDE,
0xFFDE, 0xFFDE, 0xF7BE, 0xF7BE, 0xF7BE, 0xF79E, 0xF79D, 0xF79D, 0xF77D, 0xEF5D, 0xEF5C, 0xDEBA, 0xBBF0, 0xE573, 0xFE74, 0xFD8D, 0xDB87, 0x6840, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0xD9A1, 0xFC48, 0xFDAE, 0xFED6, 0xE594, 0xB3AE, 0x945A, 0xD6BC, 0xF79D, 0xBDF7, 0xDEFB, 0xF79D, 0xF79D, 0xF79D, 0xF79E, 0xF79E, 0xF7BE,
0xF7BE, 0xF79E, 0xF79E, 0xF79D, 0xF79D, 0xF79D, 0xEF3C, 0xC617, 0xEF5D, 0xEF5C, 0xDE9A, 0xBBF0, 0xDD33, 0xFED6, 0xFDCF, 0xF469, 0x88A1, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0xE202, 0xFCA9, 0xFDCF, 0xFEF7, 0xEE36, 0xBB8D, 0xD595, 0xD69A, 0xAD55, 0xEF5C, 0xEF7D, 0xEF7D, 0xF77D, 0xF77D, 0xF79E, 0xDEDA,
0xD69A, 0xF79E, 0xF77D, 0xF77D, 0xF77D, 0xEF7D, 0xF77D, 0xAD55, 0xC638, 0xD5F7, 0xB38E, 0xE5B5, 0xFF18, 0xFE10, 0xF4C9, 0xA122, 0x2800, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0xE222, 0xFCA9, 0xFDF0, 0xFF18, 0xF6B8, 0xCC71, 0xB3EF, 0xCDD7, 0xEF5C, 0xEF5C, 0xEF5C, 0xEF5D, 0xEF5D, 0xF79D, 0xC618,
0xBDD7, 0xF79D, 0xEF5D, 0xEF5D, 0xEF5C, 0xEF5C, 0xEF5C, 0xD638, 0xABF0, 0xC450, 0xEE78, 0xFF39, 0xFE11, 0xF4C9, 0xA983, 0x3800, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0xE202, 0xFC48, 0xFDCE, 0xFF17, 0xFF9C, 0xE5D6, 0xBBCE, 0xC492, 0xD5D6, 0xDEBA, 0xEF3C, 0xEF3C, 0xF77D, 0xC618,
0xBDD7, 0xF77D, 0xEF3C, 0xEF5C, 0xE6DB, 0xD5F7, 0xC4D3, 0xBBAE, 0xDD75, 0xFF9C, 0xFF38, 0xFDEF, 0xF468, 0xA942, 0x4000, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0xC9A1, 0xF385, 0xFD4B, 0xFE73, 0xFF9C, 0xFF9D, 0xE658, 0xCCD2, 0xBBAE, 0xBBEF, 0xC4F3, 0xD5B6, 0xC555,
0xC555, 0xD5D6, 0xCD14, 0xBC10, 0xB3AE, 0xCCB2, 0xE5F7, 0xFF7D, 0xFFBC, 0xFEB4, 0xFD8C, 0xE386, 0x98C1, 0x2800, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0xA920, 0xEAA3, 0xFC47, 0xFDAE, 0xFEB4, 0xFF9B, 0xFFFF, 0xF77D, 0xE679, 0xDD96, 0xD534, 0xD534,
0xD534, 0xD534, 0xDD96, 0xE638, 0xF75C, 0xFFFF, 0xFFBC, 0xFED5, 0xFDEF, 0xF448, 0xCA23, 0x7040, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0xC160, 0xF2C3, 0xFC27, 0xFD2B, 0xFE51, 0xFF17, 0xFF9B, 0xFFFD, 0xFFFF, 0xFFFF,
0xFFFF, 0xFFFF, 0xFFFE, 0xFF9B, 0xFF37, 0xFE72, 0xFD4B, 0xF447, 0xD284, 0x90A0, 0x4020, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0xA920, 0xE201, 0xEAE3, 0xF3E6, 0xFCC9, 0xFD2B, 0xFD8C, 0xFDAE,
0xFDCE, 0xFD8D, 0xFD2B, 0xFCC9, 0xF3E7, 0xDAC4, 0xC1A2, 0x88A0, 0x4020, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x90E0, 0xB140, 0xC1A1, 0xD202, 0xDA22,
0xD222, 0xC9E2, 0xB981, 0xA100, 0x80A0, 0x5860, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP
};

GUI_CONST_STORAGE GUI_BITMAP _bmClock = {
  48, /* XSize */
  48, /* YSize */
  192, /* BytesPerLine */
  32, /* BitsPerPixel */
  (unsigned char *)_acClock,  /* Pointer to picture data */
  NULL  /* Pointer to palette */
 ,&em_BitmapMethods565
};

/*********************************************************************
*
*       _bmDate
*
* Purpose:
*   Icon bitmap with alpha channel
*/
static GUI_CONST_STORAGE uint16_t _acDate[] = {
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x7BEF, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, 0x7BCF, 0x7BEF, 0x8C71, 0x8C51, 0x738E, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x7B4D, 0xACF3, 0x9C51,
0x7BCF, 0x73AE, 0x7BEF, 0x8C51, 0xAD75, 0xD6BA, 0xF79E, 0xCE58, 0x7BEF, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x93EF, 0x9C30, 0x7B6D, 0x9451, 0xA4F3, 0xA4B2,
0x9451, 0xA554, 0xD699, 0xEF7D, 0xFFFF, 0xFFFF, 0xFFFF, 0xEF5C, 0x8430, 0x4A69, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x7B6D, 0x9410, 0x7B6D, 0x83AE, 0xB534, 0xA4D3, 0x9451, 0x8C51, 0x9CF3, 0xB595,
0xBD75, 0xFFDE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x9CD3, 0x630C, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x838E, 0x838E, 0x730C, 0xAD13, 0xBD75, 0x9451, 0x8410, 0x840F, 0x9CD2, 0xAD13, 0xDEDA, 0xFFFE, 0xFFDE,
0xC5D6, 0xF79E, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDE, 0xE71C, 0xD6BA, 0xBDD6, 0x73AE, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x83AE, 0xBD75, 0xA492, 0x83EF, 0x8410, 0x7BEF, 0xA4B2, 0xB575, 0xEF7C, 0xFFDE, 0xCE17, 0xE6DA, 0xFFFF, 0xFFDE,
0xDEBA, 0xFFFF, 0xF7BE, 0xEF9D, 0xFFFF, 0xDEFB, 0xB596, 0xE71B, 0xEF5B, 0x8410, 0x4A69, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x736D, 0x83EF, 0x7BCF, 0x9450, 0xACD3, 0xCE37, 0xEF5B, 0xE6DA, 0xD638, 0xFFFF, 0xFFFF, 0xE6DB, 0xEF7D, 0xFFFF, 0xFFFF,
0xFFFF, 0xCE79, 0xB595, 0xD69A, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDD, 0xA513, 0x632C, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x738E, 0x73AE, 0x8430, 0xA513, 0xCE37, 0xE71A, 0xCDD6, 0xF79D, 0xFFFF, 0xF79D, 0xDE9A, 0xFFFF, 0xFFFF, 0xF79E, 0xE75C, 0xB5B6, 0xD6DA,
0xFFFF, 0xEF7D, 0xF7BE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFE, 0xC5F6, 0x738E, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x7BCF, 0x8C71, 0xAD54, 0xCE57, 0xEF5B, 0xFFDD, 0xFFFE, 0xFFFF, 0xD679, 0xF77D, 0xFFFF, 0xF79D, 0xEF7D, 0xDEDB, 0xF7BE, 0xF7DE, 0xCE58, 0xDEDA, 0xF7BE,
0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFE, 0xE6FA, 0x7BEF, 0x528A, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, 0x738E, 0x9471, 0xF77B, 0xFFDD, 0xFFFE, 0xFFFE, 0xFFFF, 0xFFFF, 0xFFFF, 0xF77D, 0xF7BE, 0xFFFF, 0xEF7D, 0xB596, 0xBDD6, 0xF7BE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFBC, 0x9CF2, 0x632C, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, 0x6B6D, 0x9491, 0xFF7B, 0xFFDE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xDEFB, 0xB575, 0xCE58, 0xFFDE, 0xF7BE, 0xF7BE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFD, 0xCE36, 0x738E, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, 0x6B6D, 0x8C71, 0xF75A, 0xFFDD, 0xF79E, 0xD6BA, 0xDEDA, 0xFFFF, 0xDEFB, 0xE71B, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFDE, 0xEF39, 0x840F, 0x4A49, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, 0x6B4D, 0x8C71, 0xEF3B, 0xFF9B, 0xCE58, 0xC638, 0xEF5C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFFE, 0xFFFE, 0xF79F, 0xE73F, 0xDEFF,
0xDEDF, 0xDEDF, 0xE73F, 0xFFDF, 0xFFFE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFBB, 0xAD33, 0x630C, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x8410, 0xDEDA, 0xFF7A, 0xFFFE, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xEF5F, 0xCE7F, 0xBDDF, 0xB5BF, 0xB59F,
0xB59F, 0xAD7F, 0xAD7F, 0xC61F, 0xF79E, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFF, 0xFFDC, 0xDE76, 0x738E, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x738E, 0xC618, 0xFF5A, 0xFFBC, 0xFFFF, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xF7DE, 0xD6BF, 0xB5BF, 0xB59F, 0xB5BF, 0xB59F, 0xAD7F,
0xB59F, 0xB59F, 0xAD7F, 0xAD5F, 0xBDFF, 0xFFDE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFF, 0xFFDD, 0xF739, 0x840F, 0x4A49, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x6B4D, 0xAD54, 0xF739, 0xFF9A, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFFE, 0xF7BE, 0xC63F, 0xB59F, 0xB5BF, 0xB59F, 0xB5BF, 0xCE5F, 0xCE5F,
0xB59F, 0xAD5F, 0xAD5F, 0xAD5F, 0xA53F, 0xE71F, 0xFFFE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFF9A, 0xAD12, 0x5AEC, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x630C, 0x8C51, 0xE6D8, 0xFF59, 0xFFDE, 0xFFDF, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFFE, 0xD6BF, 0xAD7F, 0xB59F, 0xB59F, 0xD6BF, 0xF7BE, 0xFFFE, 0xFFFE,
0xEF5E, 0xAD7F, 0xA53F, 0xA53F, 0x9D1F, 0xD69F, 0xFFFE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFFF, 0xFFDC, 0xD635, 0x6B6D, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x738E, 0xCDF6, 0xFF38, 0xFFBC, 0xFFFF, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFFE, 0xF7BE, 0xDEDF, 0xB5BF, 0xDEDF, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE,
0xFFFE, 0xCE7F, 0x9D1F, 0xA51F, 0x9CFF, 0xD69F, 0xFFFE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFFE, 0xFFDD, 0xFF38, 0x8C30, 0x4A6A, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x632C, 0xB533, 0xF6F7, 0xFF7A, 0xFFFE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFFE, 0xFFFE, 0xF7BE, 0xFFFE, 0xFFFE, 0xFFDE, 0xFFDE, 0xFFDE,
0xFFFE, 0xD6BF, 0x9CFF, 0x9CFF, 0x9CFF, 0xE71E, 0xFFFE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFF9A, 0xB532, 0x5AEC, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x5AEC, 0x9471, 0xEE97, 0xFF37, 0xFFDD, 0xFFFE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFFE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFFE, 0xFFFE,
0xEF7E, 0xAD7F, 0x9CDF, 0x9CDF, 0xBDDF, 0xFFFE, 0xFFFE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFFF, 0xFFBB, 0xD634, 0x6B4D, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x73AE, 0xDDF5, 0xFF16, 0xFF9B, 0xFFFF, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFFE, 0xEF7E, 0xCE5F,
0xA53F, 0x9CDF, 0x9CDF, 0x9CDF, 0xC61F, 0xE75E, 0xFFFE, 0xFFFE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDD, 0xF717, 0x840F, 0x4A69, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x632C, 0xB4F2, 0xF6D6, 0xFF79, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFFE, 0xBDDF, 0x949F,
0x94BF, 0x94BF, 0x94BF, 0x94BF, 0x8C7F, 0x949F, 0xAD5F, 0xE71E, 0xFFFE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFF99, 0xBD52, 0x5AEC, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x5ACB, 0x8C0F, 0xEE54, 0xFF36, 0xFFDD, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFFE, 0xD69E, 0x8C7F,
0x94BF, 0x9CDF, 0x949F, 0x8C7F, 0x8C7F, 0x8C7F, 0x843F, 0x94BF, 0xEF7E, 0xFFFE, 0xFFDE, 0xFFDE, 0xFFFF, 0xFFBB, 0xE674, 0x6B4D, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x6B6D, 0xDD92, 0xFED5, 0xFF9A, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFFE, 0xF79E, 0xC63F,
0xDEFE, 0xEF7E, 0xE71E, 0xB59F, 0x8C5F, 0x8C5F, 0x8C5F, 0x841F, 0xBDFF, 0xFFFE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDD, 0xFF16, 0x8C0F, 0x4A49, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x5B0C, 0xBCB0, 0xFE74, 0xFF37, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFFE,
0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 0xB59F, 0x841F, 0x843F, 0x841F, 0x949F, 0xF7BE, 0xFFFE, 0xFFDE, 0xFFDE, 0xFFFE, 0xFF79, 0xBD51, 0x5ACB, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x52AB, 0x8BCE, 0xF5F2, 0xFF15, 0xFFBD, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE,
0xFFDE, 0xFFDE, 0xFFDE, 0xFFFE, 0xDEFE, 0x841F, 0x841F, 0x7BFF, 0x841F, 0xEF7E, 0xFFFE, 0xFFDE, 0xFFDE, 0xFFFE, 0xFFBB, 0xEE94, 0x6B6D, 0x39E7, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x6B2C, 0xD530, 0xFEB3, 0xFF7A, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE,
0xFFDE, 0xFFDE, 0xFFDE, 0xFFFE, 0xE6FE, 0x841F, 0x7BFF, 0x7BDF, 0x8C5F, 0xF79E, 0xFFFE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDD, 0xFF36, 0x944F, 0x4A6A, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x52CB, 0xB44E, 0xFE32, 0xFF16, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE,
0xFFDE, 0xFFDE, 0xFFFE, 0xFFFE, 0xB57F, 0x7BDF, 0x7BDF, 0x739F, 0xB57F, 0xFFFE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFF78, 0xC571, 0x5ACB, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x4A8A, 0x8B8C, 0xF590, 0xFED3, 0xFF9B, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFBE, 0xFFBE, 0xFFFE,
0xFFFE, 0xFFDE, 0xEF5E, 0xAD7E, 0x73BF, 0x7BDF, 0x739F, 0x841F, 0xEF5E, 0xFFFE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFBC, 0xEE73, 0x6B4C, 0x39C7, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x62EB, 0xDCAE, 0xFE72, 0xFF58, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFFE, 0xB59E, 0x949F, 0xAD5F,
0xAD5F, 0x9CDF, 0x841F, 0x73BF, 0x73BF, 0x6B7F, 0x841F, 0xDEFE, 0xFFFE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFF36, 0xA4AF, 0x4A8A, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x52AB, 0xA3CC, 0xFDF0, 0xFF15, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFFE, 0xEF5E, 0x843F, 0x73BF, 0x73BF,
0x739F, 0x739F, 0x739F, 0x6B7F, 0x6B7F, 0x9CDF, 0xE73E, 0xFFFE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFFF, 0xFF79, 0xDDF1, 0x5AEB, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x4A69, 0x732B, 0xED2D, 0xFE92, 0xFF7A, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFFD, 0xCE5E, 0x739F, 0x6B9F, 0x6B7F,
0x6B7F, 0x739F, 0x841F, 0xA51F, 0xD67E, 0xFFDE, 0xFFFE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFBC, 0xFF79, 0xFF36, 0xFEF3, 0xF672, 0x738D, 0x4A49, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x5AAB, 0xD42B, 0xFE0F, 0xFF16, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xEF7E, 0xCE5E, 0xB59E, 0xB59E,
0xBDBE, 0xD69E, 0xF79E, 0xFFFE, 0xFFFD, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFBC, 0xFF79, 0xFF16, 0xFEB2, 0xFE71, 0xFE30, 0xF5F0, 0xED8F, 0x7B6C, 0x4A49, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x4A8A, 0xA36A, 0xFD6D, 0xFED2, 0xFFBC, 0xFFDE, 0xFFDD, 0xFFDE, 0xFFDE, 0xFFDD, 0xFFFD, 0xFFFD, 0xFFFD,
0xFFFD, 0xFFFD, 0xFFDD, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFF9C, 0xFF37, 0xFEF4, 0xFEB2, 0xFE70, 0xFE0F, 0xF5CF, 0xF58E, 0xF52E, 0xF50C, 0xECAB, 0x732B, 0x4249, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x6ACA, 0xEC8B, 0xFE70, 0xFF37, 0xFFDE, 0xFFDD, 0xFFDD, 0xFFDD, 0xFFDD, 0xFFDD, 0xFFDD, 0xFFDD,
0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFBC, 0xFF38, 0xFEF4, 0xFE91, 0xFE50, 0xFE0F, 0xF5CF, 0xF56E, 0xF52D, 0xF4EC, 0xF4AA, 0xFC68, 0xFC28, 0xF3E8, 0x730B, 0x4229, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x4A8A, 0xBBA9, 0xFDCD, 0xFED3, 0xFFBD, 0xFFDE, 0xFFDD, 0xFFDD, 0xFFDD, 0xFFDE, 0xFFDE, 0xFFDE,
0xFFBD, 0xFF7B, 0xFF37, 0xFEF4, 0xFE91, 0xFE2F, 0xFDEE, 0xF5AE, 0xF54D, 0xF50C, 0xF4CB, 0xF489, 0xFC48, 0xFC07, 0xF3C7, 0xD388, 0xAB49, 0x82EA, 0x5AAA, 0x4208, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x4249, 0x8AE9, 0xFCEA, 0xFE90, 0xFF9B, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDD, 0xFF9B, 0xFF37,
0xFED2, 0xFE70, 0xFE2F, 0xFDEE, 0xFD8D, 0xF54D, 0xF4EB, 0xF4AA, 0xF468, 0xFC06, 0xFBE5, 0xF3A6, 0xDB67, 0xAB29, 0x7ACA, 0x52AA, 0x4A6A, 0x3A08, 0x3186, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x6289, 0xEBE8, 0xFDED, 0xFF36, 0xFFDF, 0xFFBD, 0xFF7B, 0xFF37, 0xFEB2, 0xFE6F, 0xFE2E,
0xFDED, 0xFD8D, 0xFD4C, 0xF4EB, 0xF489, 0xFC48, 0xFC05, 0xFBC5, 0xF385, 0xDB46, 0xAB08, 0x7AC9, 0x528A, 0x4A69, 0x3A08, 0x3186, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x424A, 0xAB07, 0xFD2A, 0xFE91, 0xFEF5, 0xFEB2, 0xFE6F, 0xFE0D, 0xFDCD, 0xFD6C, 0xFD0B,
0xFCAA, 0xFC68, 0xFC26, 0xFBC4, 0xFB84, 0xF344, 0xD306, 0x9AE8, 0x6AA9, 0x5289, 0x4249, 0x39E8, 0x2925, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x3A29, 0x7288, 0xFC27, 0xFE4E, 0xFE0D, 0xFDAC, 0xFD6C, 0xFD0B, 0xFCA9, 0xFC47, 0xFC05,
0xFBC3, 0xFB63, 0xFB23, 0xD2E5, 0x9AC7, 0x7289, 0x5269, 0x4249, 0x39E7, 0x2925, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x4A49, 0xD345, 0xFD2A, 0xFCEA, 0xFC88, 0xFC26, 0xFBE4, 0xFB83, 0xFB42, 0xEB03,
0xCAC5, 0x9AA7, 0x7288, 0x5269, 0x3A29, 0x31A7, 0x2925, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x3A29, 0x8AA7, 0xFBE4, 0xFBC4, 0xFB61, 0xFB01, 0xF2C2, 0xCAA4, 0x9A86, 0x6269,
0x4A49, 0x3A29, 0x31A7, 0x2125, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x5A68, 0xF2E1, 0xF2A1, 0xCA83, 0x9A66, 0x6268, 0x4A49, 0x3A29, 0x31A7,
0x2925, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x4A49, 0x7247, 0x6248, 0x4A49, 0x3A29, 0x3186, 0x20E4, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x4208, 0x3A08, 0x2986, 0x2104, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP
};
GUI_CONST_STORAGE GUI_BITMAP _bmDate = {
  48, /* XSize */
  48, /* YSize */
  192, /* BytesPerLine */
  32, /* BitsPerPixel */
  (unsigned char *)_acDate,  /* Pointer to picture data */
  NULL  /* Pointer to palette */
 ,&em_BitmapMethods565
};

/*********************************************************************
*
*       _bmEmail
*
* Purpose:
*   Icon bitmap with alpha channel
*/
static GUI_CONST_STORAGE uint16_t _acEmail[] = {
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x99C7, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x99C7, 0xB2AA, 0xCB0C, 0xA9E8, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, 0x99C7, 0xA1E7, 0xB2AA, 0xDD55, 0xF73C, 0xFC92, 0xCB4C, 0x8986, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, 0x99E7, 0xA228, 0xBB2C, 0xDCB2, 0xFE79, 0xFFFF, 0xF5B7, 0xF513, 0xF5D6, 0xAA08, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
0x99E7, 0xAA49, 0xC34D, 0xE534, 0xFE79, 0xFEBA, 0xFFBE, 0xFF3C, 0xEBCF, 0xF616, 0xFF1A, 0xD3CE, 0x8966, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x99E8, 0xAA89,
0xD40F, 0xED95, 0xFE79, 0xFEDA, 0xFEDA, 0xFF5C, 0xFFFF, 0xF492, 0xF513, 0xFE97, 0xFEDA, 0xF617, 0xAA28, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x9A08, 0xAA8A, 0xD430, 0xF5B6,
0xFE99, 0xFEBA, 0xFEDA, 0xFF1B, 0xFF3C, 0xFFFF, 0xF679, 0xEBEF, 0xF677, 0xFEB8, 0xFE98, 0xFF1B, 0xCB8D, 0x8165, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x9A28, 0xB2EB, 0xD471, 0xF5D6, 0xFE99, 0xFEDA,
0xFEFB, 0xFF1B, 0xFF3C, 0xFF5C, 0xFFBE, 0xFFDF, 0xEC72, 0xF574, 0xFEB9, 0xFEB9, 0xFEB8, 0xFEFA, 0xF5D6, 0xAA08, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x9A28, 0xA249, 0xBB2C, 0xDCB2, 0xFE17, 0xFE99, 0xFEDA, 0xFEFB, 0xFF1B,
0xFF3C, 0xFF5D, 0xFF7D, 0xFF9E, 0xFFFF, 0xF5B7, 0xEC51, 0xFEB9, 0xFEB9, 0xFEB9, 0xFEB9, 0xFED9, 0xFF1B, 0xD3AE, 0x8965, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x9A28, 0xA269, 0xC3AE, 0xED34, 0xFE58, 0xFEBA, 0xFEDA, 0xFEFB, 0xFF1B, 0xFF5C, 0xFF7D,
0xFF9D, 0xFF9E, 0xFFBE, 0xFFFF, 0xFF9D, 0xE3F0, 0xF5F6, 0xFEFA, 0xFED9, 0xFEDA, 0xFEDA, 0xFEDA, 0xFF1B, 0xF5B6, 0xA9E7, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x9A29, 0xAAAB, 0xCBEF, 0xED54, 0xFE78, 0xFEBA, 0xFEDA, 0xFEFB, 0xFF1B, 0xFF5C, 0xFF7D, 0xFF9D, 0xFF9E,
0xFFBE, 0xFFBE, 0xFFDF, 0xFFFF, 0xED55, 0xECD3, 0xFEFA, 0xFEDA, 0xFEDA, 0xFEDA, 0xFEDA, 0xFEFA, 0xFEFA, 0xFEFB, 0xD3AE, 0x9186, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x9A49, 0xAAEB, 0xCC10, 0xF5B6, 0xFE79, 0xFEBA, 0xFEDA, 0xFEFB, 0xFF3C, 0xFF5C, 0xFF7D, 0xFF9D, 0xFF9E, 0xFFBE, 0xFFDE,
0xFFDE, 0xFFDF, 0xFFFF, 0xF6FB, 0xE3CF, 0xF679, 0xFEFB, 0xFEFB, 0xFEFB, 0xFEFB, 0xFEFB, 0xFEFB, 0xFEFB, 0xFF3C, 0xF5D6, 0xB208, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x9A69, 0xB2EB, 0xD451, 0xF5D6, 0xFE79, 0xFEBA, 0xFEDA, 0xFEFB, 0xFF3C, 0xFF5C, 0xFF7D, 0xFF9D, 0xFF9E, 0xFFBE, 0xFFDE, 0xFFDE, 0xFFDF,
0xFFFF, 0xFFFF, 0xFFFF, 0xECD3, 0xE4F3, 0xFF1B, 0xFEFB, 0xFEFB, 0xFEFB, 0xFEFB, 0xFEFB, 0xFEFB, 0xFF1B, 0xFF1C, 0xFF1B, 0xDBCE, 0x9166, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, 0x9A8A, 0x9A8A, 0xB38E, 0xDCF3, 0xFDF7, 0xFE79, 0xFE9A, 0xFEDA, 0xFEFB, 0xFF3C, 0xFF5C, 0xFF7D, 0xFF9D, 0xFFBE, 0xFFBE, 0xFFDE, 0xFFDE, 0xFFDF, 0xFFFF, 0xFFFF,
0xFFFF, 0xFFFF, 0xF679, 0xE410, 0xF6BA, 0xFF1B, 0xFF1B, 0xFF1B, 0xFF1B, 0xFF1C, 0xFF1C, 0xFF1C, 0xFF3C, 0xFF3C, 0xFF5C, 0xF5D6, 0xB208, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, 0x9A8A, 0xA2EB, 0xD555, 0xF77D, 0xFFFF, 0xFFFF, 0xFFBE, 0xFF9D, 0xFF7D, 0xFF7D, 0xFF9D, 0xFF9D, 0xFF9E, 0xFFBE, 0xFFDE, 0xFFDE, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
0xFFFF, 0xFFDE, 0xE411, 0xED76, 0xFF3C, 0xFF1C, 0xFF1C, 0xFF3C, 0xFF3C, 0xFF3C, 0xFF3C, 0xFF3C, 0xFF3C, 0xFF3C, 0xFF5C, 0xFF1B, 0xD38D, 0x8965, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, 0x9A8A, 0xA2AA, 0xAB4D, 0xB36D, 0xC492, 0xD576, 0xE638, 0xEEFB, 0xF79E, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
0xFFFF, 0xEDF7, 0xDC51, 0xF71B, 0xFF3C, 0xFF3C, 0xFF3C, 0xFF5C, 0xFF5C, 0xFF5C, 0xFF5C, 0xFF5D, 0xFF5D, 0xFF5D, 0xFF5D, 0xFF7D, 0xFDB5, 0xB208, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, 0xA269, 0xD4F3, 0xCD53, 0xBBCD, 0xB36D, 0xB36D, 0xB34D, 0xB34D, 0xC3CF, 0xCC92, 0xDD34, 0xE638, 0xF75C, 0xFFBE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
0xFF7D, 0xDBCF, 0xEE38, 0xFF5D, 0xFF5C, 0xFF5C, 0xFF5D, 0xFF5D, 0xFF5D, 0xFF5D, 0xFF7D, 0xFF7D, 0xFF7D, 0xFF7D, 0xFF7D, 0xFF7D, 0xFF1B, 0xDBAE, 0x9166, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, 0x8A29, 0xD410, 0xFF7C, 0xFE77, 0xF656, 0xEDF6, 0xE5B5, 0xDD54, 0xD4D2, 0xCC50, 0xC3CF, 0xC3AE, 0xC3AF, 0xCC10, 0xD492, 0xDD14, 0xE5B6, 0xEE79, 0xF73C, 0xFFBE,
0xE4F3, 0xDC92, 0xFF5C, 0xFF5D, 0xFF5D, 0xFF7D, 0xFF7D, 0xFF7D, 0xFF7D, 0xFF7D, 0xFF7D, 0xFF7D, 0xFF7D, 0xFF7D, 0xFF9D, 0xFF9D, 0xFF9D, 0xF595, 0xB208, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0xA269, 0xF617, 0xFF3B, 0xFE97, 0xFEB8, 0xFED9, 0xFED9, 0xFED9, 0xFEDA, 0xF6DA, 0xEE78, 0xE5F7, 0xDD96, 0xDD34, 0xD472, 0xCC10, 0xD3EF, 0xD3AF, 0xDBCF,
0xDBCF, 0xEEBA, 0xFF7D, 0xFF7D, 0xFF7D, 0xFF7D, 0xFF7D, 0xFF9D, 0xFF9D, 0xFF9D, 0xFF9D, 0xFF9D, 0xFF9E, 0xFF9E, 0xFF9E, 0xFF9E, 0xFFBE, 0xFF1A, 0xDB8D, 0x9186, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x9229, 0xCC10, 0xFF9D, 0xFEB8, 0xFE98, 0xFEB9, 0xFEB9, 0xFEDA, 0xFEDA, 0xFEFA, 0xFEFB, 0xFF1B, 0xFF1C, 0xFF1C, 0xFF3C, 0xF6FB, 0xEEBA, 0xE659, 0xE5F7,
0xE679, 0xFF7D, 0xFF7D, 0xFF7D, 0xFF9D, 0xFF9D, 0xFF9D, 0xFF9E, 0xFF9E, 0xFF9E, 0xFF9E, 0xFF9E, 0xFF9E, 0xFF9E, 0xFF9E, 0xFF9E, 0xFFBE, 0xFF9D, 0xF574, 0xB1E8, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0xAA8A, 0xF5F7, 0xFF3B, 0xFEB9, 0xFEB9, 0xFEDA, 0xFEDA, 0xFEFA, 0xFEFB, 0xFEFB, 0xFF1B, 0xFF1C, 0xFF3C, 0xFF3C, 0xFF5D, 0xFF7D, 0xFF7D, 0xFF7D,
0xFF7D, 0xFF7D, 0xFF7D, 0xFF9D, 0xFF9E, 0xFF9E, 0xFF9E, 0xFF9E, 0xFFBE, 0xFFBE, 0xFFBE, 0xFFBE, 0xFFBE, 0xFFBE, 0xFFBE, 0xFFBE, 0xFFBE, 0xFFDF, 0xFF1A, 0xDB6D, 0x9166, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x8A28, 0xCBAE, 0xFF7C, 0xFED9, 0xFEDA, 0xFEDA, 0xFEDA, 0xFEFB, 0xFEFB, 0xFF1B, 0xFF1C, 0xFF3C, 0xFF3C, 0xFF5C, 0xFF5D, 0xFF7D, 0xFF7D, 0xFF7D,
0xFF9D, 0xFF9D, 0xFF9E, 0xFF9E, 0xFF9E, 0xFFBE, 0xFFBE, 0xFFBE, 0xFFBE, 0xFFBE, 0xFFBE, 0xFFBE, 0xFFBE, 0xFFBE, 0xFFDE, 0xFFDE, 0xFFBD, 0xFEFA, 0xF574, 0xD32C, 0x99A6, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0xA269, 0xF638, 0xFF5C, 0xFEDA, 0xFEFA, 0xFEFB, 0xFEFB, 0xFF1B, 0xFF1C, 0xFF3C, 0xFF5C, 0xFF5C, 0xFF5D, 0xFF7D, 0xFF7D, 0xFF7D, 0xFF9D,
0xFF9E, 0xFF9E, 0xFF9E, 0xFFBE, 0xFFBE, 0xFFBE, 0xFFBE, 0xFFBE, 0xFFBE, 0xFFBE, 0xFFBE, 0xFFDE, 0xFFDE, 0xFFDF, 0xFFBE, 0xFEFB, 0xF554, 0xD34D, 0xB1E8, 0x9186, 0x50E3, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x8A28, 0xCBAE, 0xFF5C, 0xFEFB, 0xFEFB, 0xFEFB, 0xFF1B, 0xFF1C, 0xFF3C, 0xFF5C, 0xFF5D, 0xFF5D, 0xFF7D, 0xFF7D, 0xFF9D, 0xFF9D, 0xFF9E,
0xFF9E, 0xFFBE, 0xFFBE, 0xFFBE, 0xFFBE, 0xFFBE, 0xFFBE, 0xFFBE, 0xFFDE, 0xFFDE, 0xFFDF, 0xFFDF, 0xFFBE, 0xFEDB, 0xECD3, 0xCAEC, 0xA9E8, 0x8165, 0x48C3, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0xA269, 0xF5D7, 0xFF7D, 0xFEFB, 0xFF1B, 0xFF1C, 0xFF3C, 0xFF5C, 0xFF5D, 0xFF7D, 0xFF7D, 0xFF7D, 0xFF9D, 0xFF9D, 0xFF9E, 0xFFBE,
0xFFBE, 0xFFBE, 0xFFBE, 0xFFBE, 0xFFBE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDF, 0xFFFF, 0xFFBE, 0xFEDB, 0xECB3, 0xC2CB, 0xA9C7, 0x8165, 0x40C3, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x9228, 0xCBCF, 0xFF9D, 0xFF1C, 0xFF1C, 0xFF3C, 0xFF5C, 0xFF5D, 0xFF7D, 0xFF7D, 0xFF7D, 0xFF9D, 0xFF9E, 0xFF9E, 0xFFBE, 0xFFBE,
0xFFBE, 0xFFBE, 0xFFBE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFFF, 0xFFFF, 0xFFBE, 0xFE59, 0xE472, 0xC2AB, 0xA1C7, 0x7145, 0x38A3, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0xAA6A, 0xF5D7, 0xFF9D, 0xFF1C, 0xFF3C, 0xFF5D, 0xFF7D, 0xFF7D, 0xFF7D, 0xFF9D, 0xFF9E, 0xFF9E, 0xFFBE, 0xFFBE, 0xFFBE,
0xFFBE, 0xFFDE, 0xFFDE, 0xFFDF, 0xFFDF, 0xFFFF, 0xFF7D, 0xF638, 0xDC31, 0xBA69, 0x99A6, 0x6945, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x8A08, 0xCB6E, 0xFF7D, 0xFF5D, 0xFF5C, 0xFF7D, 0xFF7D, 0xFF7D, 0xFF9D, 0xFF9E, 0xFF9E, 0xFFBE, 0xFFBE, 0xFFBE, 0xFFBE,
0xFFDE, 0xFFDF, 0xFFFF, 0xFFFF, 0xFF5D, 0xF596, 0xD38E, 0xB249, 0x91A7, 0x5904, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0xA249, 0xED55, 0xFFBE, 0xFF5D, 0xFF7D, 0xFF7D, 0xFF9D, 0xFF9E, 0xFF9E, 0xFFBE, 0xFFBE, 0xFFBE, 0xFFDE, 0xFFDE,
0xFFFF, 0xFFDF, 0xFEFB, 0xED35, 0xCB6D, 0xAA28, 0x8186, 0x5104, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x8A28, 0xC34D, 0xFF5D, 0xFF9D, 0xFF7D, 0xFF9D, 0xFF9E, 0xFF9E, 0xFFBE, 0xFFBE, 0xFFBE, 0xFFDE, 0xFFFF, 0xFFDF,
0xFEDB, 0xED14, 0xC2EC, 0xA208, 0x7986, 0x40C3, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0xA269, 0xF5B7, 0xFFDE, 0xFF7D, 0xFF9D, 0xFF9E, 0xFFBE, 0xFFBE, 0xFFDE, 0xFFFF, 0xFFBE, 0xFEBA, 0xE4B3,
0xC2CB, 0xA208, 0x7986, 0x38C3, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x8A08, 0xCB4D, 0xFF3C, 0xFFBE, 0xFF9E, 0xFFBE, 0xFFDE, 0xFFFF, 0xFFBE, 0xFE59, 0xDC10, 0xB2AA, 0x99E8,
0x6165, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0xA249, 0xED75, 0xFFFF, 0xFFBE, 0xFFFF, 0xFF7D, 0xF5D7, 0xD3F0, 0xB28A, 0x89C7, 0x5945, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x8A28, 0xC36E, 0xFF7D, 0xFF5D, 0xED96, 0xCB6E, 0xAA49, 0x81C7, 0x5125, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0xA28A, 0xDBF0, 0xC34D, 0xA249, 0x79A7, 0x40E3, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x8A08, 0x69A6, 0x38C3, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP
};
GUI_CONST_STORAGE GUI_BITMAP _bmEmail = {
  48, /* XSize */
  48, /* YSize */
  192, /* BytesPerLine */
  32, /* BitsPerPixel */
  (unsigned char *)_acEmail,  /* Pointer to picture data */
  NULL  /* Pointer to palette */
 ,&em_BitmapMethods565
};

/*********************************************************************
*
*       _bmPassword
*
* Purpose:
*   Icon bitmap with alpha channel
*/
static GUI_CONST_STORAGE uint16_t _acPassword[] = {
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x1155, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x1134, 0x0B59, 0x061E, 0x0BDA, 0x1092, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, 0x1133, 0x1297, 0x0D5C, 0x071F, 0x06FF, 0x06FF, 0x0B7A, 0x0892, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, 0x1276, 0x0D3C, 0x06DF, 0x06FF, 0x067F, 0x067F, 0x06DF, 0x06FF, 0x0BFB, 0x0893, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, 0x11D4, 0x0C5A, 0x069F, 0x071F, 0x069F, 0x065F, 0x067F, 0x069F, 0x06DF, 0x06FF, 0x06FF, 0x0C1B, 0x0893, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x1993,
0x13B8, 0x061E, 0x071F, 0x069F, 0x063F, 0x063F, 0x067F, 0x069F, 0x06DF, 0x06FF, 0x06DF, 0x06DF, 0x073F, 0x0BDB, 0x0873, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x1992, 0x0CFB,
0x071F, 0x06BF, 0x063F, 0x061F, 0x063F, 0x067F, 0x069F, 0x06DF, 0x06DF, 0x053B, 0x0B98, 0x0BF9, 0x057C, 0x06DF, 0x0BBB, 0x0893, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x1439, 0x071F,
0x065F, 0x05DF, 0x05FF, 0x063F, 0x067F, 0x069F, 0x06DF, 0x0EFF, 0x253B, 0x1113, 0x088E, 0x0891, 0x09F7, 0x055C, 0x06DF, 0x041C, 0x0874, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x12F6, 0x06BF, 0x069F,
0x05DF, 0x05FF, 0x063F, 0x067F, 0x069F, 0x06DF, 0x06DF, 0x26FF, 0x3B17, 0x0849, TRANSP, TRANSP, 0x0891, 0x0B5A, 0x067F, 0x067F, 0x03DC, 0x0853, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x1A33, 0x0DFD, 0x06FF, 0x061F,
0x05FF, 0x063F, 0x067F, 0x069F, 0x06DF, 0x071F, 0x06FF, 0x3F1F, 0x3AD7, TRANSP, TRANSP, TRANSP, TRANSP, 0x0AB9, 0x06DF, 0x165F, 0x05FF, 0x035B, 0x0853, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x0D3B, 0x071F, 0x063F, 0x05FF,
0x063F, 0x067F, 0x069F, 0x06DF, 0x06FF, 0x073F, 0x073F, 0x271F, 0x753B, 0x0890, TRANSP, TRANSP, TRANSP, 0x0C1B, 0x0EFF, 0x5FBF, 0x2E9F, 0x059F, 0x039C, 0x0875, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x1397, 0x06FF, 0x067F, 0x05FF, 0x063F,
0x067F, 0x069F, 0x06DF, 0x06FF, 0x073F, 0x077F, 0x079F, 0x06FF, 0x46FF, 0x6C7A, 0x1934, 0x1915, 0x0B1A, 0x065E, 0x2EDF, 0x77FF, 0x87FF, 0x2E3F, 0x057F, 0x037C, 0x0073, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x1AB4, 0x067E, 0x06BF, 0x061F, 0x063F, 0x067F,
0x069F, 0x06DF, 0x06FF, 0x073F, 0x075F, 0x079F, 0x07DF, 0x07DF, 0x06FF, 0x2EDF, 0x3DFE, 0x259E, 0x063F, 0x169F, 0x6FBF, 0x87FF, 0x9FFF, 0x5EDF, 0x053F, 0x043E, 0x0074, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x0CFA, 0x073F, 0x065F, 0x061F, 0x067F, 0x069F,
0x06DF, 0x06FF, 0x073F, 0x075F, 0x079F, 0x07DF, 0x07FF, 0x17FF, 0x1FDF, 0x1F5F, 0x16FF, 0x1EDF, 0x3F1F, 0x6FBF, 0x87FF, 0x97FF, 0x97BF, 0x157F, 0x04BF, 0x0179, 0x000A, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x1AF5, 0x065E, 0x06DF, 0x067F, 0x069F, 0x06DF,
0x071F, 0x073F, 0x075F, 0x079F, 0x07DF, 0x07FF, 0x17FF, 0x27FF, 0x37FF, 0x47FF, 0x57FF, 0x67FF, 0x77FF, 0x87FF, 0x97FF, 0xA7FF, 0x463F, 0x051F, 0x02BB, 0x0030, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x1337, 0x06BF, 0x06DF, 0x06DF, 0x06FF,
0x073F, 0x077F, 0x079F, 0x07DF, 0x07FF, 0x17FF, 0x27FF, 0x37FF, 0x47FF, 0x57FF, 0x67FF, 0x77FF, 0x87FF, 0x97FF, 0xAFFF, 0x7F1F, 0x051F, 0x03FD, 0x0895, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x196F, 0x0BDA, 0x06BF, 0x06BF, 0x071F,
0x077F, 0x07BF, 0x07FF, 0x07FF, 0x17FF, 0x27FF, 0x37FF, 0x47FF, 0x57FF, 0x67FF, 0x77FF, 0x87FF, 0x8FFF, 0xA7FF, 0xA7BF, 0x1D7F, 0x04BF, 0x0999, 0x002A, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x1990, 0x1418, 0x06BF, 0x06DF, 0x075F,
0x07BF, 0x061B, 0x06BC, 0x17FF, 0x27FF, 0x37FF, 0x47FF, 0x57FF, 0x67FF, 0x77FF, 0x87FF, 0x97FF, 0xA7FF, 0xB7FF, 0x4E1F, 0x04DF, 0x02FB, 0x084F, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x13D7, 0x06DF, 0x06DF, 0x075F, 0x07BF,
0x05FB, 0x045B, 0x0D9C, 0x27FF, 0x37FF, 0x47FF, 0x57FF, 0x67FF, 0x77FF, 0x87FF, 0x97FF, 0xA7FF, 0xBFFF, 0x7EFF, 0x04FF, 0x041D, 0x08D5, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x21B1, 0x1418, 0x06BF, 0x06FF, 0x075F, 0x07BF, 0x05DB,
0x049C, 0x0E1F, 0x1FDF, 0x37FF, 0x47FF, 0x57FF, 0x67FF, 0x77FF, 0x87FF, 0x97FF, 0xAFFF, 0xAFDF, 0x667F, 0x0D1F, 0x049F, 0x09D9, 0x002B, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x21F1, 0x1458, 0x06DF, 0x06FF, 0x077F, 0x07BF, 0x05BA, 0x04BC,
0x0E5F, 0x27FF, 0x37FF, 0x47FF, 0x57FF, 0x67FF, 0x77FF, 0x87FF, 0x97FF, 0xAFFF, 0x977F, 0x2D9F, 0x04DF, 0x045E, 0x0A19, 0x0870, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x21D0, 0x1458, 0x06FF, 0x06DF, 0x077F, 0x079E, 0x059A, 0x04BD, 0x0E7F,
0x27FF, 0x37FF, 0x47FF, 0x57FF, 0x67FF, 0x77FF, 0x87FF, 0x97FF, 0xAFFF, 0x7F1F, 0x153F, 0x04DF, 0x03DD, 0x0977, 0x084E, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x21F0, 0x1417, 0x06DF, 0x06DF, 0x077F, 0x079E, 0x057A, 0x04FD, 0x0E5F, 0x27DF,
0x37FF, 0x47FF, 0x57FF, 0x5FDF, 0x2E9F, 0x2E5F, 0x87BF, 0x9FDF, 0x567F, 0x051F, 0x04BF, 0x031A, 0x08F5, 0x0849, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x2210, 0x1499, 0x06DF, 0x06FF, 0x077F, 0x077E, 0x055A, 0x053E, 0x0EBF, 0x27FF, 0x37FF,
0x47DF, 0x5FFF, 0x57BF, 0x1E3F, 0x057F, 0x055F, 0x159F, 0x259F, 0x051F, 0x045D, 0x09F8, 0x0890, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x2210, 0x14B9, 0x06FF, 0x06DF, 0x077F, 0x075E, 0x055A, 0x053E, 0x0EDF, 0x27FF, 0x37FF, 0x1EDF,
0x165F, 0x3F1F, 0x161F, 0x059F, 0x03FB, 0x0B5A, 0x04FF, 0x051F, 0x039B, 0x0976, 0x086B, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x220F, 0x1477, 0x06DF, 0x06FF, 0x077F, 0x073E, 0x053A, 0x055E, 0x0EBF, 0x27FF, 0x37FF, 0x1EDF, 0x05FF,
0x05DF, 0x05BF, 0x059F, 0x0B9A, 0x1153, 0x10F2, 0x0A78, 0x0AD9, 0x1113, 0x0847, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x2250, 0x14B8, 0x06DF, 0x06FF, 0x077F, 0x073D, 0x055B, 0x057E, 0x171F, 0x27FF, 0x2FBF, 0x169F, 0x061F, 0x047C,
0x0B39, 0x04DD, 0x0B39, 0x1110, TRANSP, TRANSP, 0x08AD, 0x08AE, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x226F, 0x14F9, 0x06FF, 0x06FF, 0x079F, 0x071D, 0x053A, 0x059E, 0x069F, 0x175F, 0x1F3F, 0x0E7F, 0x061F, 0x045B, 0x11B2,
0x110F, 0x11B4, 0x110F, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x2A4F, 0x14D8, 0x06FF, 0x06DF, 0x077F, 0x06FD, 0x053A, 0x05BE, 0x0EBF, 0x067F, 0x063F, 0x061F, 0x05FF, 0x0BFA, 0x1992, 0x0886,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x2A4F, 0x14B8, 0x06DF, 0x06FF, 0x079F, 0x06FD, 0x053B, 0x05DF, 0x0F3F, 0x175F, 0x065F, 0x0C7B, 0x0B38, 0x0AF7, 0x1970, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x2A6F, 0x153A, 0x06FF, 0x06FF, 0x079F, 0x06BC, 0x055B, 0x05FF, 0x175F, 0x2FFF, 0x171F, 0x05DF, 0x1A73, 0x10EA, 0x10C8, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x2A4F, 0x1539, 0x06FF, 0x06FF, 0x079F, 0x069C, 0x055B, 0x063F, 0x175F, 0x27FF, 0x277F, 0x0E9F, 0x055D, 0x19AF, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, 0x2A6F, 0x14D8, 0x06FF, 0x06FF, 0x079F, 0x069C, 0x055B, 0x063F, 0x069F, 0x0EFF, 0x069F, 0x065F, 0x063F, 0x0CBB, 0x196D, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, 0x1B73, 0x06DF, 0x06FF, 0x077F, 0x067C, 0x057B, 0x067F, 0x06DF, 0x067F, 0x05BE, 0x04FC, 0x0C5A, 0x0B98, 0x1294, 0x110A, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, 0x1BF5, 0x06DF, 0x075F, 0x065B, 0x057B, 0x069F, 0x177F, 0x06DF, 0x05DE, 0x12B4, 0x19F0, 0x198D, 0x112A, 0x08A6, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, 0x1456, 0x071F, 0x05FB, 0x059B, 0x069F, 0x179F, 0x177F, 0x067F, 0x0C79, 0x194A, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, 0x14D8, 0x05FC, 0x05BC, 0x06BF, 0x0F7F, 0x27FF, 0x0EBF, 0x05DE, 0x1AB2, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, 0x0D5A, 0x067E, 0x06FF, 0x06DF, 0x06BF, 0x069F, 0x067F, 0x0C9A, 0x198C, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, 0x226F, 0x0D1B, 0x059D, 0x055D, 0x055D, 0x053D, 0x051D, 0x04FD, 0x1AF3, 0x08A5, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, 0x1A71, 0x1A50, 0x1A50, 0x1A50, 0x1A50, 0x1A50, 0x1A50, 0x198B, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP
};
GUI_CONST_STORAGE GUI_BITMAP _bmPassword = {
  48, /* XSize */
  48, /* YSize */
  192, /* BytesPerLine */
  32, /* BitsPerPixel */
  (unsigned char *)_acPassword,  /* Pointer to picture data */
  NULL  /* Pointer to palette */
 ,&em_BitmapMethods565
};

/*********************************************************************
*
*       _bmRead
*
* Purpose:
*   Icon bitmap with alpha channel
*/
static GUI_CONST_STORAGE uint16_t _acRead[] = {
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0xD3C6, 0xDC28, 0xE46A, 0xEC8B, 0xEC8A, 0xE449, 0xD385, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0xF56F, 0xFEF8, 0xFF7B, 0xFFDE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFF5A, 0xB3EA,
0xAB89, 0xFF18, 0xFFBD, 0xFFDE, 0xFFDE, 0xFFBD, 0xFF5B, 0xFED7, 0xFE13, 0xED4E, 0xD449, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x000F, 0x0016, 0x38B1, 0xF4CB, 0xFFDD, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xF7DF, 0xF7DF, 0xF7DF, 0xF7DF, 0xFFFF, 0xFFFF, 0xFFFF, 0xA534,
0x94B2, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFEB6, 0xFD0A, 0xB2C4, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x0012, 0x001F, 0x48F3, 0xFDAE, 0xFFFE, 0xF7DF, 0xF7BE, 0xF7BE, 0xF7DE, 0xF7BE, 0xF7BE, 0xF7BE, 0xF7BE, 0xF7BE, 0xF7BE, 0xFFFF, 0xA514,
0x9492, 0xFFFF, 0xF7BE, 0xF7BE, 0xF7BE, 0xF7BE, 0xF79E, 0xF79E, 0xF79E, 0xF7BE, 0xF7DE, 0xFFFF, 0xFFBD, 0xFF99, 0xC3EC, 0x001B, 0x0019, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x0015, 0x001F, 0x6151, 0xFE0F, 0xFFFF, 0xF7DF, 0xF7DE, 0xF7BE, 0xF7BE, 0xF7BE, 0xF7BE, 0xF7BE, 0xF7BE, 0xF7BE, 0xF7BE, 0xFFFF, 0xA514,
0x9492, 0xFFFF, 0xF7BE, 0xF7BE, 0xF7BE, 0xF7BE, 0xF7BE, 0xF7BE, 0xF7BE, 0xF7BE, 0xF79E, 0xF7BE, 0xF77C, 0xFF58, 0xD42C, 0x081C, 0x001E, 0x0010, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x0017, 0x001F, 0x71B0, 0xFE71, 0xFFFF, 0xF7DE, 0xF7BE, 0xF7BE, 0xF7BE, 0xF7BE, 0xF7BE, 0xF7BE, 0xF79D, 0xF79D, 0xF79D, 0xFFFF, 0x9CF3,
0x94B2, 0xFFFF, 0xF7BE, 0xF7DE, 0xF7DE, 0xFFDE, 0xF7DE, 0xF7DE, 0xF7BE, 0xF7BE, 0xF7BE, 0xF7BE, 0xF79C, 0xFF79, 0xDC6B, 0x101B, 0x001E, 0x0011, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x0018, 0x001F, 0x822E, 0xFE93, 0xFFDE, 0xF7BE, 0xF7BE, 0xF79D, 0xF79D, 0xF79D, 0xF79D, 0xF79D, 0xF79D, 0xF79D, 0xF79D, 0xFFFF, 0x9CD3,
0xA513, 0xFFDE, 0xD6BA, 0xC617, 0xBDD7, 0xBDF7, 0xC638, 0xDEDB, 0xEF7D, 0xFFDF, 0xF7BE, 0xF79E, 0xF79C, 0xFF79, 0xE4AC, 0x1839, 0x001F, 0x0012, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x000E, 0x0019, 0x001F, 0x9A8C, 0xFED5, 0xF7BE, 0xF7BD, 0xF79D, 0xF79D, 0xF79D, 0xF79D, 0xF79D, 0xF79D, 0xF79D, 0xF79D, 0xF79D, 0xFFFF, 0xA513,
0x6B4D, 0x94B2, 0x9D14, 0xAD96, 0xADB6, 0xAD96, 0xAD75, 0x94D3, 0x8430, 0xAD55, 0xF79D, 0xFFFF, 0xF79D, 0xFF7A, 0xECEC, 0x2856, 0x001F, 0x0013, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x000F, 0x001A, 0x001D, 0xB2EA, 0xFEF7, 0xF7BD, 0xF79D, 0xF79D, 0xF79D, 0xF79D, 0xF79D, 0xF79D, 0xF79D, 0xF79D, 0xF79D, 0xFFBD, 0xC617, 0x8C30,
0xA555, 0xCE9A, 0xDE78, 0xDDB5, 0xD512, 0xD4F1, 0xC512, 0xBD95, 0xB5D7, 0x94B2, 0x73AE, 0xC638, 0xFFFE, 0xFF7A, 0xED2C, 0x3094, 0x001F, 0x0014, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x0010, 0x001B, 0x081C, 0xCB68, 0xF6F8, 0xF7BD, 0xF79D, 0xF79C, 0xF79C, 0xF79C, 0xF79C, 0xF79C, 0xF79C, 0xF79C, 0xFFBD, 0xB574, 0x8C71, 0xCE9A,
0xE678, 0xED52, 0xF551, 0xF5B2, 0xFE14, 0xFDF4, 0xF572, 0xE4CF, 0xCC2D, 0xBCF2, 0xA555, 0x73AE, 0xB595, 0xFF9B, 0xF54D, 0x40B3, 0x001F, 0x0015, 0x0007, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x0010, 0x001C, 0x103A, 0xD3C9, 0xF6F9, 0xF7BD, 0xF79C, 0xF77C, 0xF77C, 0xF77C, 0xF77C, 0xF77C, 0xF77C, 0xFFBD, 0xC5F6, 0x8C92, 0xDF1C, 0xEE15,
0xF54F, 0xFEB6, 0xFF59, 0xFF9B, 0xFF9B, 0xFFBC, 0xFFBC, 0xFF9C, 0xFEF8, 0xECAD, 0xB40D, 0xAD76, 0x630C, 0xBD93, 0xFDAE, 0x48F1, 0x001F, 0x0016, 0x0008, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x0011, 0x001D, 0x2078, 0xDC29, 0xF6F9, 0xFFBD, 0xF79C, 0xF77C, 0xF77C, 0xF77C, 0xF77C, 0xF77C, 0xFF9C, 0xDED9, 0x8410, 0xD6DB, 0xF656, 0xFDB0,
0xFEF6, 0xFEF7, 0xFF18, 0xFF39, 0xFF39, 0xFF5A, 0xFF5A, 0xFF5A, 0xFF5A, 0xFF59, 0xF52F, 0xABED, 0x9D34, 0x630C, 0xE4EB, 0x6150, 0x001F, 0x0017, 0x0009, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x0012, 0x001E, 0x3096, 0xE46A, 0xEF1A, 0xFF9C, 0xF77B, 0xF77B, 0xF75B, 0xF75B, 0xF75B, 0xF75B, 0xF77B, 0x9CD2, 0xB5D7, 0xF6D9, 0xFDB0, 0xFE94,
0xFEB5, 0xFED6, 0xFEF7, 0xFF17, 0xFF18, 0xFF18, 0xFF18, 0xFF18, 0xFF18, 0xFF17, 0xFF17, 0xED2F, 0xA450, 0x7C52, 0x92E4, 0x71AE, 0x001F, 0x0019, 0x000A, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x0013, 0x001E, 0x38D4, 0xECAB, 0xEF1A, 0xFF9C, 0xF77B, 0xF75B, 0xF75B, 0xF75B, 0xF75B, 0xF77B, 0xDE78, 0x8430, 0xE71C, 0xFDF2, 0xFE31, 0xFE73,
0xFE94, 0xFEB5, 0xFED6, 0xFED6, 0xFEF7, 0xFEF7, 0xFEF7, 0xFEF7, 0xFEF7, 0xFED6, 0xFED6, 0xFE94, 0xBC0C, 0x94F3, 0x7AC6, 0x694C, 0x001F, 0x001A, 0x000B, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x0014, 0x001F, 0x4912, 0xECEC, 0xEF1B, 0xFF7B, 0xF75B, 0xF75A, 0xF75A, 0xF73A, 0xF75A, 0xFF9B, 0xB574, 0xA535, 0xEF1A, 0xFE32, 0xFE73, 0xFE52,
0xFE73, 0xFE94, 0xFE95, 0xFEB5, 0xFEB5, 0xFED6, 0xFED6, 0xFED6, 0xFEB5, 0xFEB5, 0xFE94, 0xFEB4, 0xED2E, 0x9C50, 0x736B, 0x40EB, 0x001F, 0x001B, 0x000D, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x0016, 0x001F, 0x5951, 0xED0C, 0xEF3B, 0xF75B, 0xF75A, 0xF75A, 0xF75A, 0xF75A, 0xF75A, 0xFF7B, 0xA512, 0xBE18, 0xF6F9, 0xFE94, 0xFEB4, 0xFE73,
0xFE52, 0xFE53, 0xFE73, 0xFE94, 0xFE94, 0xFEB4, 0xFEB4, 0xFE94, 0xFE94, 0xFE94, 0xFE73, 0xFE73, 0xFE11, 0xA40D, 0x73CE, 0x20AB, 0x081E, 0x001B, 0x000E, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x0017, 0x001F, 0x6990, 0xED4D, 0xEF5C, 0xF75A, 0xF73A, 0xF73A, 0xF73A, 0xF73A, 0xF75A, 0xFF5A, 0xA4F2, 0xC659, 0xFEF8, 0xFED6, 0xFED6, 0xFE94,
0xFE73, 0xFE52, 0xFE52, 0xFE52, 0xFE73, 0xFE73, 0xFE73, 0xFE73, 0xFE73, 0xFE52, 0xFE52, 0xFE73, 0xFE93, 0xAC0D, 0x73EE, 0x20AA, 0x001D, 0x001B, 0x0010, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x0018, 0x001F, 0x79EE, 0xED6F, 0xF77C, 0xFF5A, 0xF73A, 0xF73A, 0xF73A, 0xF73A, 0xF73A, 0xF739, 0xA4D2, 0xC659, 0xFEF8, 0xFEF7, 0xFF17, 0xFED6,
0xFEB5, 0xFE94, 0xFE73, 0xFE73, 0xFE52, 0xFE52, 0xFE52, 0xFE52, 0xFE52, 0xFE73, 0xFE93, 0xFEB4, 0xFED5, 0xAC4D, 0x73CE, 0x20A9, 0x081D, 0x001C, 0x0011, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x000F, 0x0019, 0x001E, 0x8A2D, 0xE591, 0xF77C, 0xFF39, 0xF739, 0xF719, 0xF719, 0xF719, 0xF719, 0xFF39, 0xA4D2, 0xBDF8, 0xF719, 0xFF18, 0xFF39, 0xFF18,
0xFEF7, 0xFED6, 0xFEB5, 0xFEB5, 0xFE94, 0xFE94, 0xFE94, 0xFE94, 0xFE94, 0xFEB5, 0xFED5, 0xFEF6, 0xFEF6, 0xA42E, 0x6B8D, 0x30C7, 0x083C, 0x001C, 0x0012, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x000F, 0x001A, 0x001D, 0x9A8C, 0xDDB2, 0xF77B, 0xF719, 0xF719, 0xF719, 0xF719, 0xF719, 0xF719, 0xFF59, 0xAD12, 0xA555, 0xEEF9, 0xFF38, 0xFF59, 0xFF39,
0xFF38, 0xFF18, 0xFEF7, 0xFEF6, 0xFED6, 0xFED6, 0xFED6, 0xFED6, 0xFEF6, 0xFEF7, 0xFF17, 0xFF38, 0xF695, 0x9C2F, 0x632B, 0x6145, 0x103C, 0x001D, 0x0013, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x0010, 0x001B, 0x001C, 0xA2AB, 0xDDD4, 0xF75B, 0xF718, 0xF718, 0xF718, 0xF6F8, 0xF6F8, 0xF6F8, 0xFF39, 0xC5B4, 0x8451, 0xDEB9, 0xFF18, 0xFF5A, 0xFF59,
0xFF39, 0xFF39, 0xFF39, 0xFF38, 0xFF18, 0xFF18, 0xFF18, 0xFF18, 0xFF18, 0xFF38, 0xFF39, 0xFF79, 0xDDB2, 0x8430, 0x62A9, 0xA244, 0x083B, 0x001D, 0x0014, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x0010, 0x001B, 0x001B, 0xB30A, 0xDDF5, 0xF73A, 0xF718, 0xF718, 0xF718, 0xF718, 0xF718, 0xF6F8, 0xF718, 0xF6D7, 0x8C2F, 0xB5B6, 0xEEF8, 0xFF59, 0xFF7A,
0xFF5A, 0xFF59, 0xFF59, 0xFF59, 0xFF59, 0xFF39, 0xFF39, 0xFF39, 0xFF59, 0xFF59, 0xFF7A, 0xFF38, 0x9C4E, 0x73CF, 0x62A9, 0xCB46, 0x081A, 0x001D, 0x0015, 0x0007, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x0011, 0x001C, 0x081B, 0xBB49, 0xD5F6, 0xF739, 0xF6F8, 0xF6F8, 0xF718, 0xF718, 0xF718, 0xF718, 0xF718, 0xFF39, 0xBD93, 0x8410, 0xCE59, 0xF718, 0xFF7A,
0xFF7B, 0xFF7A, 0xFF5A, 0xFF5A, 0xFF5A, 0xFF5A, 0xFF5A, 0xFF5A, 0xFF5A, 0xFF7A, 0xFF9A, 0xCD72, 0x8430, 0x4A49, 0x93AD, 0xD3A7, 0x1039, 0x001D, 0x0016, 0x0008, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x0012, 0x001C, 0x1039, 0xC389, 0xD616, 0xFF39, 0xF718, 0xF718, 0xF718, 0xF718, 0xF718, 0xF718, 0xF6F8, 0xF718, 0xF718, 0x9C90, 0x94B3, 0xCE38, 0xF6F8,
0xFF7A, 0xFF9B, 0xFF7B, 0xFF7B, 0xFF7A, 0xFF7A, 0xFF7B, 0xFF7B, 0xFF9B, 0xFF7A, 0xCD92, 0x8C30, 0x630C, 0x6B4D, 0xC532, 0xCB87, 0x2057, 0x001D, 0x0017, 0x0009, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x0013, 0x001D, 0x2896, 0xCBA9, 0xD617, 0xFF59, 0xF718, 0xF718, 0xF718, 0xF718, 0xF6F8, 0xF6F8, 0xF6F8, 0xF6F8, 0xFF18, 0xEED7, 0x8C0F, 0x8C92, 0xBDD6,
0xE697, 0xFF39, 0xFF9B, 0xFF9B, 0xFF9B, 0xFF9B, 0xFFBB, 0xFF9B, 0xF6D7, 0xB511, 0x8430, 0x73AE, 0x734B, 0xE6D9, 0xBD12, 0xCBA7, 0x2895, 0x001D, 0x0018, 0x000A, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x0014, 0x001D, 0x38D4, 0xCBC9, 0xDE57, 0xFF59, 0xF718, 0xF6F8, 0xF6F8, 0xF6F8, 0xF6F8, 0xF6F7, 0xF6F7, 0xF6F7, 0xF6F7, 0xFF18, 0xEEB7, 0x944F, 0x8C51,
0xA514, 0xB595, 0xD636, 0xDE97, 0xE6B8, 0xE697, 0xDE36, 0xBD73, 0x9471, 0x8C71, 0xB5B6, 0x9CF3, 0x734E, 0xD65A, 0xB4F2, 0xCBC7, 0x38B3, 0x001D, 0x0019, 0x000B, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x0015, 0x001D, 0x5111, 0xCC2A, 0xDEBA, 0xFF7A, 0xFF5A, 0xFF5A, 0xF75B, 0xF75B, 0xF75B, 0xF75B, 0xF75B, 0xF75B, 0xF75B, 0xF75B, 0xFF7A, 0xFF9A, 0x840F,
0x6B6E, 0x7C10, 0x8C72, 0x94B2, 0x94B2, 0x9492, 0x8451, 0x73EF, 0x632D, 0x6B4D, 0xB595, 0xDEFA, 0x8477, 0x3A3A, 0x6B14, 0xDC07, 0x48D1, 0x001D, 0x001A, 0x000C, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x0016, 0x001E, 0x616E, 0xEC67, 0xDD71, 0xEDD2, 0xE571, 0xDD50, 0xD510, 0xCCEF, 0xCCCE, 0xC4AE, 0xC4AE, 0xC4AF, 0xC4CF, 0xCCF0, 0xD551, 0xEE13, 0x938B,
0xAC6E, 0xAC2D, 0x93CC, 0x83AC, 0x7B6B, 0x7B4B, 0x7B2A, 0x834A, 0xA42D, 0x6B0D, 0x73B2, 0xC617, 0xE75B, 0x86DE, 0x2219, 0xC367, 0x592F, 0x001D, 0x001A, 0x000D, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, 0x000E, 0x0016, 0x001D, 0x4911, 0x9A49, 0x920A, 0x8A0A, 0x89EA, 0x89EA, 0x89EA, 0x89EA, 0x89EA, 0x89EA, 0x89EA, 0x81EA, 0x79CB, 0x79AA, 0x79AA, 0x79AA, 0x820A,
0x8A0A, 0x89EA, 0x8A09, 0x89E9, 0x89E8, 0x9208, 0x9A48, 0xA288, 0xB2A7, 0x616C, 0x641A, 0xB6B9, 0x9EDC, 0x679F, 0x34FE, 0x594D, 0x592E, 0x001D, 0x001A, 0x000E, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, 0x000E, 0x0857, 0x001C, 0x001B, 0x001B, 0x001B, 0x001B, 0x001B, 0x001B, 0x001C, 0x003C, 0x085C, 0x109C, 0x18DC, 0x211D, 0x215D, 0x297D, 0x319D, 0x39FD, 0x52BE,
0x52BD, 0x421D, 0x39FD, 0x39BD, 0x317C, 0x20FC, 0x109B, 0x085B, 0x001A, 0x0019, 0x2A59, 0x4E3F, 0x2DBF, 0x3E3F, 0x5F9F, 0x2B1A, 0x0018, 0x001C, 0x085A, 0x000F, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x10B6, 0x213D, 0x211D, 0x211D, 0x293D, 0x297D, 0x319D, 0x39BD, 0x39FD, 0x421C, 0x4A5C, 0x4A5C, 0x423B, 0x423B, 0x421A, 0x39DA, 0x3199, 0x2117, 0x0834,
0x0854, 0x2957, 0x39F9, 0x4A7A, 0x5AFB, 0x6B5C, 0x6B9D, 0x6B5D, 0x633E, 0x631E, 0x3199, 0x023B, 0x145F, 0x2D5F, 0x4EFF, 0x5EFE, 0x08F8, 0x20FB, 0x31BB, 0x0010, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x000F, 0x1073, 0x10B4, 0x10B4, 0x1094, 0x1073, 0x0872, 0x0852, 0x0831, 0x0031, 0x0010, 0x0010, 0x000F, 0x000D, 0x000C, 0x000B, 0x000A, 0x0009, 0x0006,
TRANSP, 0x0008, 0x0009, 0x000B, 0x000D, 0x000F, 0x0010, 0x0852, 0x1093, 0x18F4, 0x18D4, 0x0075, 0x0B7E, 0x1C9F, 0x35BF, 0x577F, 0x457C, 0x41F9, 0x2939, 0x000E, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x0008, 0x0008, 0x0008, 0x0007, 0x0006, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x0007, 0x000A, 0x0198, 0x0C1F, 0x24FF, 0x465F, 0x5FBF, 0x2298, 0x0010, 0x0006, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x000E, 0x029B, 0x147F, 0x2D7F, 0x4EFF, 0x56DE, 0x10F2, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x0072, 0x0B5E, 0x1CBF, 0x35DF, 0x5F9F, 0x453C, 0x000D, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x0197, 0x0C1F, 0x251F, 0x469F, 0x56FE, 0x088F, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x0A9B, 0x147F, 0x2D7F, 0x1A97, 0x0008, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x006F, 0x0975, 0x08D0, 0x0007, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP
};
GUI_CONST_STORAGE GUI_BITMAP _bmRead = {
  48, /* XSize */
  48, /* YSize */
  192, /* BytesPerLine */
  32, /* BitsPerPixel */
  (unsigned char *)_acRead,  /* Pointer to picture data */
  NULL  /* Pointer to palette */
 ,&em_BitmapMethods565
};

/*********************************************************************
*
*       _bmRemote
*
* Purpose:
*   Icon bitmap with alpha channel
*/
static GUI_CONST_STORAGE uint16_t _acRemote[] = {
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x0861, 0x1062, 0x1062, 0x1062,
0x1062, 0x1062, 0x1062, 0x0861, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x1062, 0x1082, 0x1082, 0x1082, 0x1082, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, 0x1082, 0x1082, 0x1082, 0x1082, 0x0861, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x1082, 0x1082, 0x1082, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x1082, 0x1082, 0x1082, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x1082, 0x10A2, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x1082, 0x1082, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x1082, 0x10A2, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x10A2, 0x1062, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x1082, 0x10A2, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x39A7, 0x39C7, 0x39C7, 0x39C7,
0x39C7, 0x39C7, 0x39C7, 0x31A6, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x10A2, 0x1082, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x10A2, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x39C7, 0x39E7, 0x39C7, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, 0x39C7, 0x39C7, 0x39C7, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x10A2, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x18A3, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x39E7, 0x39E7, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x39C7, 0x39E7, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x18A3, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x18A3, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x39E7, 0x4208, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x39E7, 0x39C7, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x18A3, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x18A3, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x4208, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x31A6, 0x41E8, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x10A2, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, 0x18A3, 0x18C3, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x4208, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x632C, 0x6B2D, 0x6B4D, 0x6B2D,
0x6B2D, 0x632C, 0x632C, 0x630C, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x4208, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x18C3, 0x10A2, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, 0x18E3, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x4228, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x6B4D, 0x632C, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, 0x630C, 0x6B4D, 0x5AEB, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x4228, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x18C3, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, 0x18C3, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x4228, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x6B4D, 0x6B2D, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x62EC, 0x6B2D, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x4208, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x18C3, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, 0x18E3, TRANSP, TRANSP, TRANSP, TRANSP, 0x4208, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x6B6D, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x6B4D, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x4208, TRANSP, TRANSP, TRANSP, TRANSP, 0x18C3, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, 0x18E3, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x4A49, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x738E, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x6B6D, 0x5ACB, TRANSP, TRANSP, TRANSP, TRANSP, 0x4228, 0x31A6, TRANSP, TRANSP, TRANSP, TRANSP, 0x18C3, TRANSP, TRANSP,
TRANSP, TRANSP, 0x20E4, TRANSP, TRANSP, TRANSP, TRANSP, 0x4A49, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x738E, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x6B6D, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x4A29, TRANSP, TRANSP, TRANSP, TRANSP, 0x18E3, TRANSP, TRANSP,
TRANSP, 0x18C3, 0x20E4, TRANSP, TRANSP, TRANSP, TRANSP, 0x4A49, TRANSP, TRANSP, TRANSP, TRANSP, 0x738E, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x738E, TRANSP, TRANSP, TRANSP, TRANSP, 0x4A29, 0x31A6, TRANSP, TRANSP, TRANSP, TRANSP, 0x18C3, TRANSP,
TRANSP, 0x20E4, TRANSP, TRANSP, TRANSP, TRANSP, 0x4A49, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x6B6D, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x6B4D, 0x630C, TRANSP, TRANSP, TRANSP, TRANSP, 0x4228, TRANSP, TRANSP, TRANSP, TRANSP, 0x20E4, TRANSP,
TRANSP, 0x2104, TRANSP, TRANSP, TRANSP, TRANSP, 0x4A49, TRANSP, TRANSP, TRANSP, TRANSP, 0x73AE, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x000D, 0x0010,
0x000F, 0x000C, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x73AE, TRANSP, TRANSP, TRANSP, TRANSP, 0x4A49, TRANSP, TRANSP, TRANSP, TRANSP, 0x2104, TRANSP,
TRANSP, 0x2104, TRANSP, TRANSP, TRANSP, TRANSP, 0x4A49, TRANSP, TRANSP, TRANSP, TRANSP, 0x73AE, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x0075, 0x009C, 0x007F,
0x001E, 0x001A, 0x0013, 0x000A, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x738E, 0x5ACB, TRANSP, TRANSP, TRANSP, 0x4A49, 0x39C7, TRANSP, TRANSP, TRANSP, 0x2104, TRANSP,
0x20E4, 0x2104, TRANSP, TRANSP, TRANSP, 0x4A49, TRANSP, TRANSP, TRANSP, TRANSP, 0x73AE, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x0076, 0x327F, 0x5B9F, 0x199F,
0x003F, 0x001D, 0x001B, 0x0012, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x6B6D, TRANSP, TRANSP, TRANSP, TRANSP, 0x4228, TRANSP, TRANSP, TRANSP, TRANSP, 0x18C3,
0x2104, TRANSP, TRANSP, TRANSP, TRANSP, 0x4A69, TRANSP, TRANSP, TRANSP, TRANSP, 0x7BCF, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x0010, 0x00BF, 0x5BBF, 0xADDF, 0x2A3E,
0x005F, 0x001D, 0x001B, 0x0015, 0x000C, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x73AE, TRANSP, TRANSP, TRANSP, TRANSP, 0x4A49, TRANSP, TRANSP, TRANSP, TRANSP, 0x20E4,
0x2124, TRANSP, TRANSP, TRANSP, TRANSP, 0x528A, TRANSP, TRANSP, TRANSP, TRANSP, 0x7BEF, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x0016, 0x007F, 0x199E, 0x2A3E, 0x091F,
0x003F, 0x001D, 0x001A, 0x0014, 0x000D, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x7BCF, TRANSP, TRANSP, TRANSP, TRANSP, 0x4A69, TRANSP, TRANSP, TRANSP, TRANSP, 0x2104,
0x2124, TRANSP, TRANSP, TRANSP, TRANSP, 0x528A, TRANSP, TRANSP, TRANSP, TRANSP, 0x7BEF, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x0017, 0x001F, 0x005F, 0x007F, 0x003F,
0x001D, 0x001B, 0x0019, 0x0012, 0x000C, 0x0007, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x7BEF, TRANSP, TRANSP, TRANSP, TRANSP, 0x4A69, TRANSP, TRANSP, TRANSP, TRANSP, 0x2104,
0x2925, TRANSP, TRANSP, TRANSP, TRANSP, 0x528A, TRANSP, TRANSP, TRANSP, TRANSP, 0x7BEF, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x0014, 0x001D, 0x001D, 0x001D, 0x001D,
0x001B, 0x0019, 0x0015, 0x000E, 0x000B, 0x0005, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x7BEF, TRANSP, TRANSP, TRANSP, TRANSP, 0x528A, TRANSP, TRANSP, TRANSP, TRANSP, 0x2104,
0x2925, TRANSP, TRANSP, TRANSP, TRANSP, 0x52AA, TRANSP, TRANSP, TRANSP, TRANSP, 0x8410, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x000D, 0x0018, 0x001B, 0x001B, 0x001A,
0x0018, 0x0015, 0x000F, 0x000C, 0x000B, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x7BEF, TRANSP, TRANSP, TRANSP, TRANSP, 0x528A, TRANSP, TRANSP, TRANSP, TRANSP, 0x2124,
0x2925, TRANSP, TRANSP, TRANSP, TRANSP, 0x528A, TRANSP, TRANSP, TRANSP, TRANSP, 0x8410, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x0010, 0x0015, 0x0015, 0x0014,
0x0012, 0x000E, 0x000C, 0x000B, 0x0006, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x7BEF, TRANSP, TRANSP, TRANSP, TRANSP, 0x528A, TRANSP, TRANSP, TRANSP, TRANSP, 0x2104,
0x2124, 0x2925, TRANSP, TRANSP, TRANSP, 0x528A, TRANSP, TRANSP, TRANSP, TRANSP, 0x7BEF, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x000D, 0x000E, 0x000D,
0x000C, 0x000B, 0x000B, 0x0007, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x7BCF, TRANSP, TRANSP, TRANSP, TRANSP, 0x4A69, TRANSP, TRANSP, TRANSP, TRANSP, 0x2104,
TRANSP, 0x2945, TRANSP, TRANSP, TRANSP, TRANSP, 0x528A, TRANSP, TRANSP, TRANSP, TRANSP, 0x7BEF, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x000C, 0x000D,
0x000C, 0x000C, 0x0005, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x8430, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x2945, TRANSP,
TRANSP, 0x2965, TRANSP, TRANSP, TRANSP, TRANSP, 0x5AAB, TRANSP, TRANSP, TRANSP, TRANSP, 0x8C51, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x000D, 0x000F,
0x000D, 0x000C, 0x0005, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x8430, TRANSP, TRANSP, TRANSP, TRANSP, 0x5ACB, TRANSP, TRANSP, TRANSP, TRANSP, 0x2965, TRANSP,
TRANSP, 0x2965, TRANSP, TRANSP, TRANSP, TRANSP, 0x5AAB, TRANSP, TRANSP, TRANSP, TRANSP, 0x7BCF, 0x7BEF, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x000F, 0x0010,
0x000E, 0x000D, 0x0006, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x8C51, 0x7BCF, TRANSP, TRANSP, TRANSP, TRANSP, 0x52AA, TRANSP, TRANSP, TRANSP, TRANSP, 0x2945, TRANSP,
TRANSP, 0x2945, 0x2945, TRANSP, TRANSP, TRANSP, TRANSP, 0x5ACB, TRANSP, TRANSP, TRANSP, TRANSP, 0x8C51, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x0011, 0x0011,
0x000F, 0x000E, 0x0008, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x8C51, TRANSP, TRANSP, TRANSP, TRANSP, 0x5AEB, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x2925, TRANSP,
TRANSP, TRANSP, 0x3186, TRANSP, TRANSP, TRANSP, TRANSP, 0x5AEB, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x000C, 0x0013, 0x0012,
0x0011, 0x000F, 0x000A, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x5AEB, TRANSP, TRANSP, TRANSP, TRANSP, 0x3186, TRANSP, TRANSP,
TRANSP, TRANSP, 0x2965, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x5AEB, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x000D, 0x0014, 0x0013,
0x0012, 0x0010, 0x000C, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x630C, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x2965, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, 0x3186, TRANSP, TRANSP, TRANSP, TRANSP, 0x5ACB, 0x528A, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x000F, 0x0016, 0x0014,
0x0013, 0x0012, 0x000D, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x5ACB, TRANSP, TRANSP, TRANSP, TRANSP, 0x3186, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, 0x3186, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x630C, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x0011, 0x0017, 0x0016,
0x0014, 0x0013, 0x000E, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x630C, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x3186, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, 0x31A6, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x528A, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x0874, 0x0039, 0x0016,
0x0015, 0x0014, 0x0010, 0x0006, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x31A6, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, 0x2965, 0x3186, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x2959, 0x18BB, 0x0018,
0x0016, 0x0016, 0x0012, 0x0007, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x39A7, 0x2965, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x3186, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x421C, 0x39BD, 0x0019,
0x0018, 0x0017, 0x0015, 0x0009, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x3186, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x39A7, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x000E, 0x52BE, 0x4A3E, 0x001A,
0x0019, 0x0018, 0x0016, 0x000B, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x31A6, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x39C7, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x0031, 0x6B5F, 0x4A5F, 0x001B,
0x001A, 0x0019, 0x0018, 0x000E, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x39C7, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x0873, 0x7BFF, 0x4A7F, 0x001D,
0x001B, 0x001A, 0x0019, 0x0010, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x18F6, 0x841F, 0x4A5F, 0x085E,
0x001D, 0x001B, 0x001B, 0x0013, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x2978, 0x841F, 0x423F, 0x087F,
0x001E, 0x001C, 0x001C, 0x0015, 0x0007, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x41FA, 0x841F, 0x41FF, 0x085F,
0x001F, 0x001E, 0x001D, 0x0017, 0x0008, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x000C, 0x529D, 0x841F, 0x39DF, 0x083F,
0x001F, 0x001F, 0x001E, 0x001B, 0x000A, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x000E, 0x633F, 0x7BFF, 0x31BF, 0x003F,
0x001F, 0x001F, 0x001F, 0x001D, 0x000D, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x000D, 0x2973, 0x2972, 0x1092, 0x0012,
0x0012, 0x0012, 0x0012, 0x0011, 0x000C, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP
};
GUI_CONST_STORAGE GUI_BITMAP _bmRemote = {
  48, /* XSize */
  48, /* YSize */
  192, /* BytesPerLine */
  32, /* BitsPerPixel */
  (unsigned char *)_acRemote,  /* Pointer to picture data */
  NULL  /* Pointer to palette */
 ,&em_BitmapMethods565
};

/*********************************************************************
*
*       _bmSystem
*
* Purpose:
*   Icon bitmap with alpha channel
*/
static GUI_CONST_STORAGE uint16_t _acSystem[] = {
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, 0xA471, TRANSP, TRANSP, TRANSP, TRANSP, 0xB4F3, 0xDE9A, 0xD618, 0xBD75, 0xACD2, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
0xBD34, 0xE6BA, 0xC575, TRANSP, TRANSP, TRANSP, 0xD618, 0xFFFF, 0xFFFF, 0xFFFF, 0xD618, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0xAC92, 0xCDF7,
0xF77D, 0xFFBE, 0xF77D, 0xC5B6, 0xACD3, 0xC596, 0xEF1C, 0xFFFF, 0xFFFF, 0xFFFF, 0xD658, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0xC575, 0xDE79,
0xF79E, 0xF79D, 0xF7BE, 0xF79E, 0xF79D, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xEF1B, 0xACD3, TRANSP, TRANSP, 0xA471, 0xA4B2, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0xA492, 0xCD96, 0xC596,
0xE6FB, 0xF79D, 0xF79D, 0xF79E, 0xFFBE, 0xFFDE, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xF7BE, 0xCDF7, 0xD638, 0xF77D, 0xEF3C, 0xA492, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x7B6D, 0xC575, 0xCD96,
0xE6DA, 0xF77D, 0xF77D, 0xF79D, 0xFFBE, 0xF7BE, 0xF79E, 0xF7BE, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xE6DB, 0x9430, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x9C51, 0x9C30, 0xB4F3, 0xDE59,
0xEF5D, 0xEF5D, 0xF77D, 0xF77D, 0xE6DB, 0xD638, 0xD618, 0xD638, 0xDE99, 0xEF5C, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xEF5C, 0xACB2, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0xACD3, 0xDE79, 0xE6DB, 0xE6DA, 0xEF1B,
0xEF3C, 0xEF3C, 0xF75D, 0xDE79, 0xC596, 0xC596, 0xCDB6, 0xCDD7, 0xCDF7, 0xD618, 0xE6DB, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xEF3C, 0xB513, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x732C, 0xC575, 0xDE9A, 0xEF1B, 0xEF1B, 0xEF1C,
0xEF3C, 0xEF5C, 0xE6DB, 0xB4F3, 0x8BEF, 0x732D, 0x7B4D, 0x9C51, 0xBD55, 0xD618, 0xD638, 0xEF1C, 0xFFFF, 0xFFFF, 0xFFFF, 0xDE79, 0x8BCF, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x9C51, 0xC575, 0xDE79, 0xE6FB, 0xE6FB, 0xEEFB,
0xEF1C, 0xEF3C, 0xD638, 0x7B6D, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0xACB2, 0xD618, 0xDE9A, 0xFFBE, 0xFFFF, 0xFFFF, 0xF75D, 0x9410, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x62AA, 0xA4B2, 0xC596, 0xCDB6, 0xD5F7, 0xDE9A, 0xE6FB,
0xEF1B, 0xEF3C, 0xCDF7, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0xB513, 0xDE79, 0xF77D, 0xFFFF, 0xFFFF, 0xFFDF, 0xD659, 0xA4B2, 0x83AE, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0xB4D3, 0xBD34, TRANSP, TRANSP, TRANSP, TRANSP, 0x838E, 0xA492, 0xCDB6, 0xCDB6, 0xCD96, 0xD5F7, 0xE6DB,
0xE6FB, 0xEF1C, 0xDE79, 0x8BEF, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x7B4D, 0xD617, 0xF77D, 0xFFDF, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFDF, 0xD658, 0x838E, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0xA471, 0xC575, 0xEF1B, 0xF75D, 0xC596, 0xA451, TRANSP, 0x732C, 0x9430, 0x9C71, 0x9C51, 0xB4F3, 0xC596, 0xCDD6, 0xDE9A,
0xE6FB, 0xE6FB, 0xEEFB, 0xB514, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0xCDB6, 0xFFBE, 0xFFBE, 0xFFDE, 0xFFDF, 0xFFFF, 0xFFFF, 0xDE79, 0x7B6D, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0xACD2, 0xD618, 0xF77D, 0xF7BE, 0xFFBE, 0xF77D, 0xCDF7, 0xBD55, 0xD618, 0xD659, 0xD6BA, 0xBDD6, 0x9471, 0xACD3, 0xD5F7, 0xDE9A,
0xE6DB, 0xE6DB, 0xEEFB, 0xE6DA, 0xACD2, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x8C10, 0xE6DB, 0xFFBE, 0xF7BE, 0xFFBE, 0xF79E, 0xF79E, 0xFFDE, 0xC5B6, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x836D, 0xC575, 0xD5F7, 0xF77D, 0xF79D, 0xF79D, 0xF7BE, 0xF79E, 0xFFBE, 0xFFFF, 0xFFFF, 0xFFFF, 0xEF7D, 0x9492, 0xB4F3, 0xDE9A, 0xE6BA,
0xE6BA, 0xE6DB, 0xE6DB, 0xEEFB, 0xE6FB, 0xC5B6, 0x9C92, 0x8C10, 0x9430, 0xBD55, 0xE6FB, 0xF79D, 0xF79D, 0xF79E, 0xF79D, 0xDE99, 0xDE59, 0xDE79, 0xA4B2, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0xB514, 0xCD96, 0xC575, 0xDEBA, 0xF79D, 0xF77D, 0xF79D, 0xF79E, 0xFFBE, 0xFFBE, 0xFFDE, 0xFFFF, 0xC5F7, 0x9410, 0xC5B6, 0xDE99, 0xE6BA,
0xE6BA, 0xE6DB, 0xE6DB, 0xE6DB, 0xE6FB, 0xEF3C, 0xEF1C, 0xEEFB, 0xEF1C, 0xF75D, 0xF77D, 0xF77D, 0xF77D, 0xF79D, 0xDE9A, 0xD617, 0xDE58, 0xC596, 0x7B6D, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x9C51, 0xCD96, 0xC575, 0xD638, 0xF77D, 0xF77D, 0xF77D, 0xF79D, 0xF79E, 0xFFBE, 0xFFDF, 0xEF7D, 0x9430, 0xB513, 0xC596, 0xCDD6, 0xDE99,
0xDE79, 0xD618, 0xDE59, 0xE6DB, 0xE6FB, 0xE6FB, 0xEF1B, 0xEF3C, 0xEF3C, 0xEF3C, 0xEF5C, 0xEF5D, 0xF77D, 0xF79D, 0xD618, 0x9410, 0x8BCF, 0x83AE, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x838E, 0xB4F3, 0xCDB6, 0xEF1B, 0xF75D, 0xF77D, 0xF77D, 0xF79D, 0xF77D, 0xE6FB, 0xE6BA, 0xC5B6, 0x8BEF, 0x9C71, 0xC596, 0xC596, 0xD5F7,
0xD5F7, 0xCDB6, 0xC5B6, 0xCE17, 0xE6BA, 0xE6FB, 0xE6FB, 0xE6FB, 0xEF1C, 0xEF1C, 0xEF1C, 0xEF5C, 0xF75D, 0xF77D, 0xF75C, 0x9451, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0xBD55, 0xCDF7, 0xC5B6, 0xCDB6, 0xDE9A, 0xEF5C, 0xEF3C, 0xEF5D, 0xF77D, 0xE71B, 0xD5F7, 0xCDB6, 0xCDD7, 0xC596, 0xA4B2, 0x83AE, 0xACB2, 0xCDB6, 0xC596,
0xACD3, 0xBD55, 0xCDD7, 0xCDD6, 0xDE99, 0xE6DB, 0xE6DB, 0xE6FB, 0xDE99, 0xDE79, 0xD618, 0xDE9A, 0xEF5C, 0xF75D, 0xEF3C, 0xBD54, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, 0x9C30, 0xCD96, 0xE6FB, 0xEF1C, 0xEF3C, 0xEF3C, 0xEF3C, 0xEF3C, 0xEF5C, 0xEF1B, 0xCDB6, 0xBD55, 0xBD55, 0xBD55, 0xC596, 0xBD55, 0x9C92, 0x83AE, 0x9410, 0x83CF,
0x8C30, 0x83EF, 0xACD3, 0xD5F7, 0xDE79, 0xE6DB, 0xE6DB, 0xE6DA, 0xDE38, 0xD618, 0xCDD7, 0xC5D7, 0xDE79, 0xE6DA, 0xD5F7, 0x8BCF, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, 0xBD34, 0xCDB6, 0xE6FB, 0xE6FB, 0xE6FB, 0xEF1B, 0xEF1C, 0xEF3C, 0xEF5C, 0xD618, 0x9C51, 0x732C, TRANSP, TRANSP, 0x6B0C, 0x9C51, 0xA4B2, 0x9C71, 0x9CB2, 0xCDF7,
0xDEFB, 0xAD75, 0x83CF, 0xD5F7, 0xD638, 0xDE59, 0xDE9A, 0xCDF7, 0xA4B2, 0x9C51, 0xBD55, 0xCDF7, 0xD638, 0xD5F7, 0x9C71, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, 0x6AEC, 0xBD55, 0xCDD6, 0xE6DB, 0xE6FB, 0xE6FB, 0xE6FB, 0xEF1B, 0xEF3C, 0xEF3C, 0xBD75, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x6AEC, 0xACD2, 0xD638, 0xDE9A,
0xF77D, 0xC658, 0x83CF, 0xCDD7, 0xDE59, 0xD658, 0xD638, 0xA471, TRANSP, TRANSP, 0x734D, 0xBD55, 0xBD55, 0x7B8E, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, 0x7B6D, 0xBD55, 0xC596, 0xCDD7, 0xD638, 0xE6BA, 0xE6FB, 0xE6FB, 0xEF1C, 0xEF1C, 0xB514, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x62CB, 0xB514, 0xDE79,
0xEF3C, 0xD679, 0x7BAE, 0x8BEF, 0xA492, 0xBD34, 0xB513, 0x6B2C, TRANSP, TRANSP, TRANSP, 0x5ACB, 0x5269, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, 0x8BEF, 0xCD96, 0xCDB6, 0xCDB6, 0xC596, 0xD5F7, 0xE6FB, 0xE6FB, 0xEEFB, 0xEF1C, 0xC575, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x8BCF, 0xCDD7,
0xEF3C, 0xE6FB, 0xBDD7, 0x9CF3, 0x8C51, 0x83EF, 0x7BAE, 0xB575, 0xACD3, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, 0x83AE, 0xB514, 0xC575, 0xCD96, 0xCDB6, 0xCDD7, 0xE6BA, 0xE6FB, 0xE6FB, 0xEF1B, 0xDE79, 0x9410, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x5269, 0xBD55,
0xEF5C, 0xFFDE, 0xFFBE, 0xF79E, 0xEF7D, 0xDEFB, 0xEF7D, 0xFFDE, 0xA492, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x734D, 0x9C71, 0xC575, 0xCDB6, 0xDE79, 0xE6DB, 0xE6DB, 0xE6FB, 0xEF1B, 0xC596, 0x838E, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x62AA, 0xBD75,
0xF79D, 0xFFBE, 0xFFBE, 0xFFDF, 0xFFFF, 0xFFFF, 0xFFFF, 0xEF5C, 0x9410, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x62EB, 0xBD34, 0xD618, 0xE6BA, 0xE6DA, 0xE6DB, 0xE6DB, 0xE6FB, 0xEEFB, 0xC5B6, 0x8BEF, TRANSP, TRANSP, TRANSP, TRANSP, 0x736D, 0xACF3, 0xEF1C,
0xF79E, 0xF79E, 0xF7BE, 0xFFBE, 0xEF3C, 0xEF3C, 0xF75D, 0xDE9A, 0x83CF, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x83CF, 0xCDB6, 0xE6BA, 0xE6BA, 0xE6BA, 0xE6DA, 0xE6DB, 0xE6FB, 0xE6FB, 0xEF1B, 0xDE99, 0xBD75, 0xA4B2, 0x9C92, 0xACF3, 0xD618, 0xEF3C, 0xF79D,
0xF77D, 0xF79D, 0xFFBE, 0xEF3C, 0xD638, 0xD638, 0xD638, 0xBD34, 0x736D, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x62CB, 0xB514, 0xCDD6, 0xDE99, 0xE69A, 0xE6BA, 0xE6BA, 0xE6DB, 0xE6DB, 0xE6DB, 0xE6FB, 0xEF1B, 0xEF3C, 0xEF3C, 0xEF3C, 0xF75C, 0xF77D, 0xF75D, 0xF77D,
0xF77D, 0xF79D, 0xF75D, 0xD638, 0xD618, 0xDE38, 0xCDD7, 0x8BEF, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x9C51, 0xC575, 0xBD75, 0xCDD7, 0xDE9A, 0xDE9A, 0xDE59, 0xD638, 0xDEBA, 0xE6DB, 0xE6FB, 0xE6FB, 0xE6FB, 0xEF1B, 0xEF3C, 0xEF3C, 0xEF3C, 0xEF3C, 0xEF5C,
0xF77D, 0xF77D, 0xEF5C, 0xB534, 0x9410, 0x9451, 0x9430, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x9410, 0xBD55, 0xC596, 0xC575, 0xCDF7, 0xD618, 0xCDD7, 0xC596, 0xCDD7, 0xDE59, 0xE6DA, 0xE6FB, 0xE6FB, 0xE6FB, 0xEF1B, 0xEF3C, 0xEF3C, 0xEF3C, 0xEF5C,
0xEF5C, 0xF77D, 0xF79D, 0xDE79, 0x736D, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x9C51, 0xC575, 0xC5B6, 0xD5F7, 0xCDD6, 0xC596, 0xCDD6, 0xC5B6, 0xCDB6, 0xDE9A, 0xE6DB, 0xE6DB, 0xE6FB, 0xE6FB, 0xE6DA, 0xE6BA, 0xDE79, 0xE6DB,
0xEF5C, 0xF75D, 0xF77D, 0xF75C, 0xACD3, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0xA4B2, 0xC575, 0xB514, 0x9430, 0x9451, 0xBD55, 0xC5B6, 0xCDF7, 0xDE99, 0xE6DB, 0xE6DB, 0xE6FB, 0xE6BA, 0xD638, 0xD638, 0xCDD7, 0xCDF7,
0xE6DA, 0xEF3C, 0xE6FB, 0xDE38, 0x9C71, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x62CB, 0x7B8E, TRANSP, TRANSP, TRANSP, 0x734D, 0xB4F3, 0xD618, 0xDE79, 0xE6BA, 0xE6DA, 0xE6DB, 0xDE59, 0xD617, 0xCDD6, 0xCDD7, 0xCDD7,
0xCDF7, 0xDE79, 0xDE79, 0xB514, 0x6B2C, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0xA492, 0xD618, 0xD618, 0xD638, 0xDE59, 0xDE59, 0xACD3, 0x8BEF, 0x83CF, 0xB514, 0xCDF7,
0xD638, 0xD618, 0xB514, 0x7B8E, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x9C71, 0xD638, 0xD658, 0xD638, 0xD658, 0xC575, 0x734D, TRANSP, TRANSP, 0x6B2C, 0xB4F3,
0xC596, 0x9451, 0x528A, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x83CF, 0xACD3, 0xBD54, 0xCD96, 0xCDD7, 0x9430, TRANSP, TRANSP, TRANSP, TRANSP, 0x62CB,
0x734D, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x4A49, 0x62EB, 0x7B8E, 0x630C, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP
};
GUI_CONST_STORAGE GUI_BITMAP _bmSystem = {
  48, /* XSize */
  48, /* YSize */
  192, /* BytesPerLine */
  32, /* BitsPerPixel */
  (unsigned char *)_acSystem,  /* Pointer to picture data */
  NULL  /* Pointer to palette */
 ,&em_BitmapMethods565
};

/*********************************************************************
*
*       _bmWrite
*
* Purpose:
*   Icon bitmap with alpha channel
*/
static GUI_CONST_STORAGE uint16_t _acWrite[] = {
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, 0x000D, 0x082E, 0x000D, 0x000D, 0x000D, 0x000D, 0x000D, 0x000D, 0x000D, 0x000D, 0x080D, 0x080D, 0x080D, 0x080D, 0x080D, 0x080D, 0x080D, 0x080D, 0x080D, 0x080D, 0x080C,
0x080C, 0x080C, 0x080C, 0x080C, 0x080C, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, 0x000D, 0x000B, 0x4A30, 0x6AF7, 0x5258, 0x5277, 0x5AB6, 0x62F7, 0x6B17, 0x7337, 0x7357, 0x7357, 0x7377, 0x7B77, 0x7B97, 0x7B97, 0x7BB7, 0x7BB7, 0x7B97, 0x7BB7, 0x83B7, 0x7BB7,
0x7BB7, 0x7BB7, 0x83D7, 0x83F7, 0x83B7, 0x4931, 0x100B, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, 0x000E, 0x000F, 0x40A8, 0x6A90, 0x8BDA, 0x733D, 0x62DD, 0x6B1D, 0x733D, 0x7B7D, 0x83DD, 0x8C3D, 0x9C9D, 0xA4FE, 0xAD3E, 0xB55E, 0xB55E, 0xB57E, 0xBD9E, 0xBDBE, 0xBDDE, 0xC5FE,
0xC61F, 0xCE1F, 0xCE3F, 0xCE5F, 0xEF5F, 0xDF1E, 0x8377, 0x280D, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, 0x000F, 0x000E, 0x104F, 0x9123, 0x9B2C, 0x524F, 0x7316, 0x7B5C, 0x5A9D, 0x5A9C, 0x62BC, 0x62BD, 0x62DD, 0x62FD, 0x6B3D, 0x7B9D, 0x8C1D, 0x947D, 0x9CBD, 0xA4FD, 0xA4FD, 0xA51D, 0xAD3E,
0xAD5E, 0xAD5E, 0xB57E, 0xB57E, 0xC5FE, 0xEF5F, 0xE77F, 0xA4FB, 0x40F1, 0x100B, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, 0x000E, 0x000E, 0x0870, 0x78C4, 0xD42B, 0xC572, 0x72EE, 0x6292, 0x7B5A, 0x6AFD, 0x527D, 0x5ABD, 0x5ABD, 0x62BD, 0x62BD, 0x62DD, 0x62FD, 0x6B1D, 0x737D, 0x83FD, 0x945D, 0x9CBE, 0x9CDE,
0xA4FE, 0xA51E, 0xAD3E, 0xAD3E, 0xB57E, 0xD69E, 0xCE9F, 0xDF1F, 0xC63E, 0x72D6, 0x282D, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x002F, 0x002F, 0x000D, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, 0x000E, 0x08B1, 0x58C8, 0xCB27, 0xD5F4, 0xDDB1, 0xA42F, 0x5A4F, 0x7316, 0x733D, 0x527D, 0x527D, 0x5A9D, 0x5ABD, 0x5ABD, 0x5ABD, 0x62DD, 0x62DD, 0x62DD, 0x631E, 0x737E, 0x83FE,
0x947E, 0x9CBE, 0x9CDE, 0x9CFE, 0xA4FE, 0xBDFE, 0xBDFF, 0xBDFF, 0xCE5F, 0xD6BF, 0x9C9B, 0x40D1, 0x100B, TRANSP, TRANSP, TRANSP, 0x188F, 0x5B96, 0x23FD, 0x0954, 0x000D, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, 0x000E, 0x0870, 0x30AE, 0xC244, 0xD5D3, 0xD592, 0xDDD2, 0xCD71, 0x72EF, 0x6AB3, 0x7B5B, 0x5ABD, 0x525D, 0x529D, 0x5A9D, 0x5ABD, 0x5ABD, 0x5ABD, 0x5ADE, 0x62DE, 0x62DE, 0x62FE,
0x6B1E, 0x739E, 0x841E, 0x947E, 0x949E, 0xAD5E, 0xAD7F, 0xA53F, 0xAD7F, 0xB5BF, 0xC63F, 0xAD7E, 0x6A56, 0x200D, 0x000D, 0x0132, 0x9D16, 0xC69B, 0x353F, 0x1C5F, 0x0954, 0x000C, TRANSP, TRANSP,
TRANSP, TRANSP, 0x000F, 0x002E, 0x20D2, 0xB1A4, 0xD50F, 0xD5D3, 0xD592, 0xDDD2, 0xDDF2, 0xAC71, 0x6270, 0x7317, 0x6B1D, 0x4A5E, 0x525D, 0x527D, 0x529E, 0x5A9E, 0x5ABE, 0x5ABE, 0x5ABE, 0x5ADE,
0x5ADE, 0x5ADE, 0x62FE, 0x6B3E, 0x739E, 0x8C7E, 0x9CFF, 0x8C5F, 0x949F, 0x9CDF, 0xA53F, 0xB5BF, 0x7399, 0x0830, 0x02D6, 0x263E, 0xCF3C, 0xFF7C, 0x75FE, 0x24DF, 0x1BFE, 0x0091, TRANSP, TRANSP,
TRANSP, TRANSP, 0x000E, 0x000E, 0x18F2, 0x9967, 0xEC2A, 0xD5F4, 0xD5B2, 0xD5B2, 0xDDD3, 0xE613, 0xCD72, 0x8370, 0x6AD3, 0x733B, 0x62BE, 0x4A3E, 0x525D, 0x527E, 0x527E, 0x527E, 0x529E, 0x5ABE,
0x5ABE, 0x5ABE, 0x5ADE, 0x5ADE, 0x5ADE, 0x631F, 0x7BBF, 0x52BF, 0x6B5F, 0x7BFF, 0x7BDE, 0x3995, 0x00B1, 0x043A, 0x46FF, 0x9F7F, 0xC77E, 0xEEDA, 0xB5F9, 0x453E, 0x24DF, 0x0A37, 0x000C, TRANSP,
TRANSP, TRANSP, TRANSP, 0x000E, 0x1912, 0x716C, 0xFBC7, 0xDE55, 0xD5B2, 0xD5B3, 0xDDD3, 0xDDF3, 0xDE14, 0xE654, 0xAC92, 0x6AB1, 0x7B37, 0x6B1D, 0x525E, 0x4A5E, 0x4A5E, 0x4A5E, 0x4A7E, 0x527E,
0x527F, 0x529F, 0x529F, 0x52BF, 0x52BF, 0x5ABF, 0x631F, 0x213F, 0x211F, 0x39BC, 0x1871, 0x0193, 0x15BD, 0x6F5F, 0xB79F, 0xA77F, 0x56FF, 0x85FA, 0xD574, 0xA556, 0x4D5E, 0x1B7B, 0x000E, TRANSP,
TRANSP, TRANSP, TRANSP, 0x000F, 0x088F, 0x5170, 0xF304, 0xF6B6, 0xD5D3, 0xD5D3, 0xDDD3, 0xDDF3, 0xDE14, 0xDE14, 0xE675, 0xD5D4, 0x8351, 0x7AF5, 0x733B, 0x6AFC, 0x6AFC, 0x6AFD, 0x6AFD, 0x6AFD,
0x6AFD, 0x6AFD, 0x62FD, 0x62FD, 0x6B1D, 0x6B1E, 0x7B9E, 0x5A9D, 0x1059, 0x0010, 0x02D6, 0x2EBF, 0x8F7F, 0xB79F, 0x975F, 0x46DF, 0x067F, 0x0E5F, 0x85D9, 0xBD54, 0x9C72, 0x2991, 0x000C, TRANSP,
TRANSP, TRANSP, TRANSP, 0x000E, 0x084E, 0x2953, 0xCA45, 0xFDD1, 0xEEB6, 0xD5D3, 0xDDF3, 0xD5D3, 0xDDF4, 0xDE35, 0xDE15, 0xE675, 0xDE35, 0xB4D3, 0x7AF2, 0x72B2, 0x7AD2, 0x6A72, 0x7AB2, 0x7AD3,
0x7AD3, 0x82F3, 0x7AB3, 0x8314, 0x82F4, 0x9315, 0x8294, 0x38CF, 0x00D0, 0x04BA, 0x573F, 0xAF9F, 0xB77F, 0x6F1F, 0x1E9F, 0x067F, 0x067F, 0x069F, 0x0EDF, 0x3C78, 0x20AF, 0x000A, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, 0x000E, 0x000E, 0x1913, 0x91CA, 0xFCEC, 0xFF39, 0xE634, 0xDDF4, 0xC552, 0xACB0, 0xACB0, 0xBD12, 0xB511, 0xACD1, 0xB4F1, 0x9C2F, 0xA470, 0xC573, 0xB4D1, 0x8BAD, 0x940F,
0xA470, 0xACB1, 0x8BCE, 0x8BAD, 0xBD12, 0xD5B7, 0x30CE, 0x01B2, 0x15FD, 0x777F, 0xBF9F, 0x9F7F, 0x56FF, 0x0E9F, 0x067F, 0x069F, 0x06DF, 0x0EDF, 0x13B7, 0x002F, 0x0008, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, 0x000E, 0x2132, 0x618F, 0xFC08, 0xFF38, 0xFED6, 0xE634, 0xD5D3, 0xCD73, 0xACB0, 0xBD52, 0xCDB4, 0xC573, 0xC593, 0xCDB4, 0xD615, 0xE676, 0xD615, 0xC594, 0xC594,
0xD5F5, 0xD636, 0xD615, 0xC5B4, 0x72F0, 0x10CF, 0x0316, 0x3EDF, 0x979F, 0xB79F, 0x875F, 0x36DF, 0x069F, 0x069F, 0x06BF, 0x06FF, 0x15DC, 0x1254, 0x000C, 0x0005, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, 0x000E, 0x18F0, 0x51D4, 0xEB47, 0xFEF7, 0xFF17, 0xF6B6, 0xDE14, 0xDE35, 0xCD93, 0xD5D4, 0xE696, 0xE696, 0xEEB7, 0xEEB7, 0xEEB7, 0xEEB7, 0xEED8, 0xF6F9, 0xEEF8,
0xEEF9, 0xFF7A, 0xE6D9, 0x6271, 0x00CF, 0x0CFB, 0x5F7F, 0xB7BF, 0xB79F, 0x6F3F, 0x16BF, 0x069F, 0x06BF, 0x06DF, 0x071F, 0x1CFA, 0x10D0, 0x000A, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, 0x000E, 0x108E, 0x4216, 0xBAA9, 0xFE74, 0xFF39, 0xFEF7, 0xEE96, 0xDE15, 0xDE35, 0xDE35, 0xDE35, 0xDE35, 0xE676, 0xE697, 0xE697, 0xEEB8, 0xEED8, 0xEED8, 0xF6F9,
0xFF5A, 0xC596, 0x290D, 0x01B1, 0x1E3D, 0x87BF, 0xB7BF, 0x9F7F, 0x4F1F, 0x0EBF, 0x069F, 0x069F, 0x06DF, 0x0E7E, 0x1B76, 0x082E, 0x0007, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x000D, 0x2994, 0x820E, 0xFD8F, 0xFF5A, 0xFEF7, 0xFF17, 0xD5F4, 0xC573, 0xB4F1, 0xA490, 0xB4F1, 0x8BEE, 0xB532, 0xACF1, 0xEEB8, 0xEED8, 0xF719, 0xF719,
0x8371, 0x086C, 0x03F7, 0x473F, 0xA7BF, 0xB79F, 0x7F3F, 0x26BF, 0x067F, 0x065F, 0x065F, 0x069F, 0x1D7C, 0x11B2, 0x000B, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x000E, 0x2972, 0x59D3, 0xF46A, 0xFF39, 0xFEF7, 0xFF17, 0xFEF7, 0xDE55, 0xCD94, 0xCD94, 0xCDB4, 0xC5B4, 0xC594, 0xD5F5, 0xEED8, 0xF719, 0xD617, 0x4A0D,
0x012E, 0x151A, 0x6F9F, 0xB79F, 0xA75F, 0x56DF, 0x165F, 0x061F, 0x05FF, 0x061F, 0x0E1F, 0x1BD8, 0x10AF, 0x0008, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x000E, 0x18EF, 0x5A77, 0xDBA9, 0xFED7, 0xFF38, 0xFF17, 0xFF18, 0xF6F8, 0xEE97, 0xE697, 0xEEB7, 0xEEB8, 0xEED8, 0xEED8, 0xEEF9, 0xDE57, 0x20CA, 0x0231,
0x369F, 0x979F, 0xBF7F, 0x8F1F, 0x365F, 0x05DF, 0x05BF, 0x059F, 0x05DF, 0x157E, 0x1A94, 0x080C, 0x0005, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x000E, 0x084E, 0x4A77, 0xBB2C, 0xFE74, 0xFF5A, 0xFF17, 0xFF18, 0xFF38, 0xE676, 0xDE56, 0xE676, 0xEED8, 0xF6F9, 0xF6F9, 0xFF5A, 0x6B0E, 0x08ED, 0x567F,
0xAF7F, 0xB75F, 0x6EBF, 0x1DDF, 0x057F, 0x057F, 0x055F, 0x059F, 0x14BC, 0x1171, 0x000A, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x000E, 0x31B4, 0x9AD0, 0xFDAF, 0xFF5A, 0xFF18, 0xFF38, 0xF6D7, 0xC573, 0xC573, 0xA470, 0xBD32, 0xF6F8, 0xFFBB, 0xBD95, 0x18A7, 0x7CFB, 0x9E7F,
0x9F1F, 0x4E1F, 0x0D5F, 0x051F, 0x051F, 0x051F, 0x0D3F, 0x1B16, 0x086D, 0x62B2, 0x10AC, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x000E, 0x2953, 0x6255, 0xFCCC, 0xFF39, 0xFF18, 0xFF18, 0xFF18, 0xF6F8, 0xE697, 0xEEB7, 0xDE56, 0xFF39, 0xFF7A, 0x39A9, 0x5B0F, 0xDF9F, 0x755F,
0x2D7F, 0x04FF, 0x04DF, 0x04BF, 0x04FF, 0x14BE, 0x11F2, 0x188C, 0x8C12, 0xDED9, 0x4A72, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x000E, 0x10B1, 0x4A39, 0xD3EC, 0xFEF6, 0xFF39, 0xFF18, 0xFF39, 0xFF39, 0xFF59, 0xFF5A, 0xFF7A, 0xFFDB, 0x9C92, 0x2149, 0xCF1D, 0xE7DF, 0x9DFE,
0x143F, 0x049F, 0x049F, 0x0CDF, 0x1BDA, 0x10EE, 0x398D, 0xB535, 0xD657, 0xDE98, 0x8436, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x000D, 0x086F, 0x4239, 0xAB4F, 0xFE94, 0xFF7A, 0xFF18, 0xFF39, 0xFF39, 0xFF39, 0xFF39, 0xFF7A, 0xEEF9, 0x2926, 0x6BCF, 0xE7FF, 0xC73E, 0xBF3E,
0x8DDF, 0x2C9F, 0x0C7E, 0x22F5, 0x106A, 0x62CF, 0xCE37, 0xD657, 0xCDF6, 0xCE36, 0xAD57, 0x0828, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x000E, 0x4AB8, 0x8B13, 0xFE31, 0xFF7B, 0xFF38, 0xFF59, 0xE697, 0xD615, 0xD616, 0xC574, 0x62EB, 0x0840, 0x4A63, 0xAE59, 0xAEDD, 0x8DBA,
0x6454, 0x2A11, 0x008B, 0x1048, 0x41C9, 0x9470, 0xD657, 0xCE16, 0xD657, 0xE6D9, 0xE71C, 0x18CD, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x000E, 0x31B5, 0x5A98, 0xED4F, 0xFF7B, 0xFF39, 0xFF39, 0xFF39, 0xF719, 0xF6F9, 0xAD12, 0x0841, 0x20E0, 0x10A0, 0x18E5, 0x2149, 0x1087,
0x2929, 0x5AAD, 0x83F1, 0xA4F3, 0xAD12, 0xAD54, 0xDE99, 0xEF3B, 0xFF9C, 0xFFDD, 0xFFFE, 0x4A72, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x000E, 0x10B2, 0x4A5B, 0xC430, 0xFF38, 0xFF5A, 0xFF39, 0xFF59, 0xFF7A, 0xF739, 0x5248, 0x0000, 0x20E3, 0x41C8, 0x5AAC, 0x83CF, 0xAD33,
0xCDF6, 0xD657, 0xD677, 0xDE98, 0xE71A, 0xF79C, 0xFFBD, 0xFFDD, 0xFFBD, 0xFFBD, 0xFFFE, 0x8436, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x000D, 0x0830, 0x529B, 0xA393, 0xFED4, 0xFF7B, 0xFF39, 0xFF5A, 0xFF5A, 0xD615, 0x942F, 0xA4D1, 0xC595, 0xCE16, 0xD657, 0xD657, 0xCE36,
0xCE17, 0xDE98, 0xEF3B, 0xFFBD, 0xFFDD, 0xFFDD, 0xFFBD, 0xFFBD, 0xFFBD, 0xFFBD, 0xFFFE, 0xCE7C, 0x0829, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x000F, 0x52BA, 0x8B76, 0xFE72, 0xFF7B, 0xFF39, 0xFF5A, 0xFF5A, 0xF739, 0xFF5A, 0xFF5A, 0xF73A, 0xEF1A, 0xEF1A, 0xEF1A, 0xEF1A,
0xF75B, 0xFFBD, 0xFFDD, 0xFFBD, 0xFFBD, 0xFFBD, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xF7BE, 0x294E, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x000E, 0x2116, 0x735A, 0xF5D1, 0xFF7A, 0xFF7B, 0xFF5A, 0xFF5A, 0xFF7B, 0xFF9B, 0xFF9B, 0xFF9C, 0xFF9C, 0xFFBC, 0xFFBC, 0xFFBD,
0xFFBD, 0xFFBD, 0xFFDD, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFDE, 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFF, 0x5AF3, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x000D, 0x1094, 0x529C, 0xBC72, 0xFEF2, 0xFF59, 0xFF9A, 0xFF9A, 0xFF9A, 0xFF9A, 0xFF9A, 0xFF9B, 0xFFBB, 0xFFBB, 0xFFBB, 0xFFBC,
0xFFBC, 0xFFBC, 0xFFBC, 0xFFBC, 0xFFDD, 0xFFDD, 0xFFDD, 0xFFDD, 0xFFDD, 0xFFDD, 0xFFFD, 0xDEDD, 0x6B38, 0x0006, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x000D, 0x0011, 0x4A5C, 0x315A, 0xAC13, 0xCCF2, 0xCD12, 0xD512, 0xD512, 0xD512, 0xD4F2, 0xD4F2, 0xD4F2, 0xD4F1, 0xDD11, 0xDD11,
0xDCF1, 0xDCF0, 0xDCF0, 0xDCF0, 0xDCD0, 0xDCF0, 0xE4EF, 0xE4EF, 0xE4EF, 0xE4EF, 0xD470, 0x311B, 0x5B1E, 0x10AA, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x000F, 0x4A5A, 0x211F, 0x001D, 0x083B, 0x083B, 0x083C, 0x083C, 0x083C, 0x083C, 0x083C, 0x083C, 0x083C, 0x083C, 0x083C,
0x083C, 0x083C, 0x081C, 0x081B, 0x081B, 0x081B, 0x081B, 0x081B, 0x001B, 0x001B, 0x001D, 0x001F, 0x62FF, 0x294D, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x000E, 0x1094, 0x211A, 0x087A, 0x109A, 0x109B, 0x10BB, 0x18BB, 0x18DB, 0x18FC, 0x211C, 0x293C, 0x295D, 0x297D, 0x297D,
0x297D, 0x319E, 0x31BE, 0x39FE, 0x421E, 0x423F, 0x421F, 0x421F, 0x423F, 0x423F, 0x4A5F, 0x52BF, 0x631C, 0x0849, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x000D, 0x0010, 0x0011, 0x0032, 0x0032, 0x0032, 0x0833, 0x0833, 0x0834, 0x0834, 0x0855, 0x0856, 0x0856, 0x0856, 0x0877,
0x0878, 0x1078, 0x1079, 0x1099, 0x109A, 0x109A, 0x10BA, 0x10BA, 0x10BA, 0x18BA, 0x18DA, 0x18DB, 0x0853, 0x0006, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, 0x000C, 0x000D, 0x000D, 0x000D, 0x000D, 0x000E, 0x000E, 0x000E, 0x000E, 0x000E, 0x000E, 0x000E, 0x000F, 0x000F,
0x000F, 0x000F, 0x0010, 0x0010, 0x0010, 0x0010, 0x0010, 0x0010, 0x0010, 0x0010, 0x0010, 0x0010, 0x0009, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP,
TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP, TRANSP
};
GUI_CONST_STORAGE GUI_BITMAP _bmWrite = {
  48, /* XSize */
  48, /* YSize */
  192, /* BytesPerLine */
  32, /* BitsPerPixel */
  (unsigned char *)_acWrite,  /* Pointer to picture data */
  NULL  /* Pointer to palette */
 ,&em_BitmapMethods565
};

/*********************************************************************
*
*       _bmRectRed_60x60
*/
static GUI_CONST_STORAGE unsigned char _acRectRed_60x60[] = {
  /* RLE: 003 Pixels @ 000,000*/ 3, 0xFF,
  /* ABS: 007 Pixels @ 003,000*/ 0, 7, 0xC3, 0x81, 0x99, 0x99, 0xC0, 0xCC, 0xE1,
  /* RLE: 008 Pixels @ 010,000*/ 8, 0xFF,
  /* ABS: 008 Pixels @ 018,000*/ 0, 8, 0xF0, 0xB4, 0x78, 0x4B, 0x33, 0x33, 0x33, 0x4B,
  /* RLE: 004 Pixels @ 026,000*/ 4, 0x66,
  /* ABS: 003 Pixels @ 030,000*/ 0, 3, 0x93, 0x99, 0xC9,
  /* RLE: 011 Pixels @ 033,000*/ 11, 0xFF,
  /* ABS: 013 Pixels @ 044,000*/ 0, 13, 0xF0, 0xB7, 0x8D, 0x66, 0x66, 0x3F, 0x33, 0x24, 0x03, 0x33, 0x33, 0x54, 0xA8,
  /* RLE: 005 Pixels @ 057,000*/ 5, 0xFF,
  /* RLE: 001 Pixels @ 002,001*/ 1, 0x69,
  /* RLE: 009 Pixels @ 003,001*/ 9, 0x00,
  /* ABS: 006 Pixels @ 012,001*/ 0, 6, 0x33, 0x33, 0x51, 0x63, 0x33, 0x12,
  /* RLE: 015 Pixels @ 018,001*/ 15, 0x00,
  /* ABS: 011 Pixels @ 033,001*/ 0, 11, 0x03, 0x33, 0x66, 0x8A, 0xAE, 0xD5, 0xFF, 0xCC, 0xA5, 0x6F, 0x30,
  /* RLE: 013 Pixels @ 044,001*/ 13, 0x00,
  /* RLE: 001 Pixels @ 057,001*/ 1, 0x72,
  /* RLE: 004 Pixels @ 058,001*/ 4, 0xFF,
  /* RLE: 001 Pixels @ 002,002*/ 1, 0x12,
  /* RLE: 055 Pixels @ 003,002*/ 55, 0x00,
  /* ABS: 004 Pixels @ 058,002*/ 0, 4, 0xC3, 0xFF, 0xFF, 0xF3,
  /* RLE: 004 Pixels @ 002,003*/ 4, 0x00,
  /* ABS: 006 Pixels @ 006,003*/ 0, 6, 0x42, 0x6F, 0x75, 0x66, 0x36, 0x2A,
  /* RLE: 013 Pixels @ 012,003*/ 13, 0x00,
  /* ABS: 015 Pixels @ 025,003*/ 0, 15, 0x12, 0x33, 0x66, 0x90, 0xBA, 0xE4, 0xFF, 0xFF, 0xD5, 0xCC, 0xC9, 0x99, 0x6F, 0x45, 0x18,
  /* RLE: 007 Pixels @ 040,003*/ 7, 0x00,
  /* RLE: 001 Pixels @ 047,003*/ 1, 0x2D,
  /* RLE: 004 Pixels @ 048,003*/ 4, 0x33,
  /* RLE: 001 Pixels @ 052,003*/ 1, 0x30,
  /* RLE: 005 Pixels @ 053,003*/ 5, 0x00,
  /* ABS: 008 Pixels @ 058,003*/ 0, 8, 0x75, 0xFF, 0xFF, 0xDE, 0x00, 0x00, 0x48, 0xCF,
  /* RLE: 009 Pixels @ 006,004*/ 9, 0xFF,
  /* RLE: 001 Pixels @ 015,004*/ 1, 0xED,
  /* RLE: 004 Pixels @ 016,004*/ 4, 0xCC,
  /* ABS: 005 Pixels @ 020,004*/ 0, 5, 0xBA, 0x99, 0xB4, 0xCC, 0xFC,
  /* RLE: 016 Pixels @ 025,004*/ 16, 0xFF,
  /* ABS: 003 Pixels @ 041,004*/ 0, 3, 0xF0, 0xCC, 0xF9,
  /* RLE: 010 Pixels @ 044,004*/ 10, 0xFF,
  /* ABS: 011 Pixels @ 054,004*/ 0, 11, 0xB4, 0x06, 0x00, 0x00, 0x66, 0xFF, 0xFF, 0xC9, 0x00, 0x12, 0xF9,
  /* RLE: 050 Pixels @ 005,005*/ 50, 0xFF,
  /* ABS: 009 Pixels @ 055,005*/ 0, 9, 0x54, 0x00, 0x00, 0x78, 0xFF, 0xFF, 0xC6, 0x00, 0x48,
  /* RLE: 051 Pixels @ 004,006*/ 51, 0xFF,
  /* ABS: 009 Pixels @ 055,006*/ 0, 9, 0x5A, 0x00, 0x00, 0x9F, 0xFF, 0xFF, 0xDB, 0x00, 0x5A,
  /* RLE: 051 Pixels @ 004,007*/ 51, 0xFF,
  /* ABS: 009 Pixels @ 055,007*/ 0, 9, 0x3F, 0x00, 0x00, 0xCF, 0xFF, 0xFF, 0xF6, 0x00, 0x60,
  /* RLE: 051 Pixels @ 004,008*/ 51, 0xFF,
  /* ABS: 009 Pixels @ 055,008*/ 0, 9, 0x27, 0x00, 0x00, 0xF0, 0xFF, 0xFF, 0xFF, 0x0C, 0x5A,
  /* RLE: 051 Pixels @ 004,009*/ 51, 0xFF,
  /* ABS: 003 Pixels @ 055,009*/ 0, 3, 0x0F, 0x00, 0x00,
  /* RLE: 004 Pixels @ 058,009*/ 4, 0xFF,
  /* ABS: 002 Pixels @ 002,010*/ 0, 2, 0x24, 0x4B,
  /* RLE: 051 Pixels @ 004,010*/ 51, 0xFF,
  /* ABS: 003 Pixels @ 055,010*/ 0, 3, 0x12, 0x00, 0x00,
  /* RLE: 004 Pixels @ 058,010*/ 4, 0xFF,
  /* ABS: 002 Pixels @ 002,011*/ 0, 2, 0x21, 0x3F,
  /* RLE: 051 Pixels @ 004,011*/ 51, 0xFF,
  /* ABS: 009 Pixels @ 055,011*/ 0, 9, 0x33, 0x00, 0x00, 0xF6, 0xFF, 0xFF, 0xFF, 0x1B, 0x3C,
  /* RLE: 051 Pixels @ 004,012*/ 51, 0xFF,
  /* ABS: 009 Pixels @ 055,012*/ 0, 9, 0x7B, 0x00, 0x00, 0xF0, 0xFF, 0xFF, 0xFF, 0x0F, 0x30,
  /* RLE: 051 Pixels @ 004,013*/ 51, 0xFF,
  /* ABS: 009 Pixels @ 055,013*/ 0, 9, 0xD2, 0x00, 0x00, 0xE1, 0xFF, 0xFF, 0xFF, 0x06, 0x2D,
  /* RLE: 052 Pixels @ 004,014*/ 52, 0xFF,
  /* ABS: 008 Pixels @ 056,014*/ 0, 8, 0x18, 0x00, 0xD8, 0xFF, 0xFF, 0xF9, 0x00, 0x27,
  /* RLE: 052 Pixels @ 004,015*/ 52, 0xFF,
  /* ABS: 008 Pixels @ 056,015*/ 0, 8, 0x4E, 0x00, 0xCF, 0xFF, 0xFF, 0xE1, 0x00, 0x1E,
  /* RLE: 052 Pixels @ 004,016*/ 52, 0xFF,
  /* ABS: 008 Pixels @ 056,016*/ 0, 8, 0x72, 0x00, 0xC3, 0xFF, 0xFF, 0xCC, 0x00, 0x0C,
  /* RLE: 052 Pixels @ 004,017*/ 52, 0xFF,
  /* ABS: 009 Pixels @ 056,017*/ 0, 9, 0x78, 0x00, 0xB4, 0xFF, 0xFF, 0xB4, 0x00, 0x00, 0xF9,
  /* RLE: 051 Pixels @ 005,018*/ 51, 0xFF,
  /* ABS: 009 Pixels @ 056,018*/ 0, 9, 0x72, 0x00, 0xAE, 0xFF, 0xFF, 0x9C, 0x00, 0x00, 0xE1,
  /* RLE: 051 Pixels @ 005,019*/ 51, 0xFF,
  /* ABS: 009 Pixels @ 056,019*/ 0, 9, 0x54, 0x00, 0xA5, 0xFF, 0xFF, 0x7E, 0x00, 0x00, 0xC6,
  /* RLE: 051 Pixels @ 005,020*/ 51, 0xFF,
  /* ABS: 009 Pixels @ 056,020*/ 0, 9, 0x2D, 0x00, 0xA2, 0xFF, 0xFF, 0x63, 0x00, 0x00, 0xA8,
  /* RLE: 050 Pixels @ 005,021*/ 50, 0xFF,
  /* ABS: 010 Pixels @ 055,021*/ 0, 10, 0xF9, 0x06, 0x00, 0x93, 0xFF, 0xFF, 0x45, 0x00, 0x00, 0x84,
  /* RLE: 050 Pixels @ 005,022*/ 50, 0xFF,
  /* ABS: 010 Pixels @ 055,022*/ 0, 10, 0xD2, 0x00, 0x00, 0x81, 0xFF, 0xFF, 0x27, 0x00, 0x00, 0x5D,
  /* RLE: 050 Pixels @ 005,023*/ 50, 0xFF,
  /* ABS: 010 Pixels @ 055,023*/ 0, 10, 0xA8, 0x00, 0x00, 0x6C, 0xFF, 0xFF, 0x09, 0x00, 0x00, 0x42,
  /* RLE: 050 Pixels @ 005,024*/ 50, 0xFF,
  /* ABS: 010 Pixels @ 055,024*/ 0, 10, 0x7B, 0x00, 0x00, 0x4E, 0xFF, 0xEA, 0x00, 0x00, 0x00, 0x2D,
  /* RLE: 050 Pixels @ 005,025*/ 50, 0xFF,
  /* ABS: 010 Pixels @ 055,025*/ 0, 10, 0x57, 0x00, 0x00, 0x2A, 0xFF, 0xCC, 0x00, 0x00, 0x00, 0x21,
  /* RLE: 050 Pixels @ 005,026*/ 50, 0xFF,
  /* ABS: 010 Pixels @ 055,026*/ 0, 10, 0x3F, 0x00, 0x00, 0x0C, 0xFF, 0xB1, 0x00, 0x00, 0x00, 0x33,
  /* RLE: 050 Pixels @ 005,027*/ 50, 0xFF,
  /* ABS: 010 Pixels @ 055,027*/ 0, 10, 0x30, 0x00, 0x00, 0x00, 0xDB, 0x99, 0x00, 0x00, 0x00, 0x57,
  /* RLE: 050 Pixels @ 005,028*/ 50, 0xFF,
  /* ABS: 010 Pixels @ 055,028*/ 0, 10, 0x30, 0x00, 0x00, 0x00, 0xAE, 0x84, 0x00, 0x00, 0x00, 0xA5,
  /* RLE: 050 Pixels @ 005,029*/ 50, 0xFF,
  /* ABS: 010 Pixels @ 055,029*/ 0, 10, 0x3F, 0x00, 0x00, 0x00, 0x7E, 0x6F, 0x00, 0x00, 0x12, 0xF6,
  /* RLE: 050 Pixels @ 005,030*/ 50, 0xFF,
  /* ABS: 009 Pixels @ 055,030*/ 0, 9, 0x4B, 0x00, 0x00, 0x00, 0x57, 0x5D, 0x00, 0x00, 0x63,
  /* RLE: 051 Pixels @ 004,031*/ 51, 0xFF,
  /* ABS: 009 Pixels @ 055,031*/ 0, 9, 0x66, 0x00, 0x00, 0x00, 0x33, 0x4E, 0x00, 0x00, 0xB1,
  /* RLE: 051 Pixels @ 004,032*/ 51, 0xFF,
  /* ABS: 009 Pixels @ 055,032*/ 0, 9, 0x93, 0x00, 0x00, 0x00, 0x27, 0x3F, 0x00, 0x00, 0xDB,
  /* RLE: 051 Pixels @ 004,033*/ 51, 0xFF,
  /* ABS: 009 Pixels @ 055,033*/ 0, 9, 0xB7, 0x00, 0x00, 0x00, 0x2D, 0x33, 0x00, 0x00, 0xE7,
  /* RLE: 051 Pixels @ 004,034*/ 51, 0xFF,
  /* ABS: 009 Pixels @ 055,034*/ 0, 9, 0xE4, 0x00, 0x00, 0x00, 0x3C, 0x2D, 0x00, 0x00, 0xE1,
  /* RLE: 052 Pixels @ 004,035*/ 52, 0xFF,
  /* ABS: 008 Pixels @ 056,035*/ 0, 8, 0x06, 0x00, 0x00, 0x5D, 0x2A, 0x00, 0x00, 0xCC,
  /* RLE: 052 Pixels @ 004,036*/ 52, 0xFF,
  /* ABS: 008 Pixels @ 056,036*/ 0, 8, 0x1B, 0x00, 0x00, 0x8A, 0x1E, 0x00, 0x00, 0xB7,
  /* RLE: 052 Pixels @ 004,037*/ 52, 0xFF,
  /* ABS: 008 Pixels @ 056,037*/ 0, 8, 0x18, 0x00, 0x00, 0xB7, 0x1E, 0x00, 0x00, 0xA8,
  /* RLE: 052 Pixels @ 004,038*/ 52, 0xFF,
  /* ABS: 008 Pixels @ 056,038*/ 0, 8, 0x0C, 0x00, 0x00, 0xE7, 0x1E, 0x00, 0x00, 0x93,
  /* RLE: 051 Pixels @ 004,039*/ 51, 0xFF,
  /* ABS: 009 Pixels @ 055,039*/ 0, 9, 0xF9, 0x00, 0x00, 0x18, 0xFF, 0x0F, 0x00, 0x00, 0x96,
  /* RLE: 051 Pixels @ 004,040*/ 51, 0xFF,
  /* ABS: 009 Pixels @ 055,040*/ 0, 9, 0xDE, 0x00, 0x00, 0x3C, 0xFF, 0x0F, 0x00, 0x00, 0xAB,
  /* RLE: 051 Pixels @ 004,041*/ 51, 0xFF,
  /* ABS: 009 Pixels @ 055,041*/ 0, 9, 0xC3, 0x00, 0x00, 0x5A, 0xFF, 0x0F, 0x00, 0x00, 0xC3,
  /* RLE: 051 Pixels @ 004,042*/ 51, 0xFF,
  /* ABS: 009 Pixels @ 055,042*/ 0, 9, 0xAB, 0x00, 0x00, 0x6F, 0xFF, 0x15, 0x00, 0x00, 0xE4,
  /* RLE: 051 Pixels @ 004,043*/ 51, 0xFF,
  /* ABS: 008 Pixels @ 055,043*/ 0, 8, 0x96, 0x00, 0x00, 0x60, 0xFF, 0x1E, 0x00, 0x0C,
  /* RLE: 052 Pixels @ 003,044*/ 52, 0xFF,
  /* ABS: 008 Pixels @ 055,044*/ 0, 8, 0x8A, 0x00, 0x00, 0x45, 0xFF, 0x33, 0x00, 0x2D,
  /* RLE: 052 Pixels @ 003,045*/ 52, 0xFF,
  /* ABS: 008 Pixels @ 055,045*/ 0, 8, 0x90, 0x00, 0x00, 0x18, 0xFF, 0x4B, 0x00, 0x48,
  /* RLE: 052 Pixels @ 003,046*/ 52, 0xFF,
  /* ABS: 008 Pixels @ 055,046*/ 0, 8, 0xA2, 0x00, 0x00, 0x00, 0xE7, 0x69, 0x00, 0x57,
  /* RLE: 052 Pixels @ 003,047*/ 52, 0xFF,
  /* ABS: 008 Pixels @ 055,047*/ 0, 8, 0xCC, 0x00, 0x00, 0x00, 0xB4, 0x84, 0x00, 0x51,
  /* RLE: 052 Pixels @ 003,048*/ 52, 0xFF,
  /* ABS: 008 Pixels @ 055,048*/ 0, 8, 0xFC, 0x09, 0x00, 0x00, 0x87, 0xA2, 0x00, 0x3F,
  /* RLE: 053 Pixels @ 003,049*/ 53, 0xFF,
  /* ABS: 007 Pixels @ 056,049*/ 0, 7, 0x42, 0x00, 0x00, 0x72, 0xBD, 0x00, 0x18,
  /* RLE: 053 Pixels @ 003,050*/ 53, 0xFF,
  /* ABS: 008 Pixels @ 056,050*/ 0, 8, 0x7B, 0x00, 0x00, 0x69, 0xD2, 0x00, 0x00, 0xDB,
  /* RLE: 052 Pixels @ 004,051*/ 52, 0xFF,
  /* ABS: 008 Pixels @ 056,051*/ 0, 8, 0xAB, 0x00, 0x00, 0x84, 0xD2, 0x00, 0x00, 0x9F,
  /* RLE: 052 Pixels @ 004,052*/ 52, 0xFF,
  /* ABS: 008 Pixels @ 056,052*/ 0, 8, 0xC0, 0x00, 0x00, 0xAB, 0xD2, 0x00, 0x00, 0x6C,
  /* RLE: 052 Pixels @ 004,053*/ 52, 0xFF,
  /* ABS: 008 Pixels @ 056,053*/ 0, 8, 0xBA, 0x00, 0x00, 0xC0, 0xE4, 0x00, 0x00, 0x5D,
  /* RLE: 052 Pixels @ 004,054*/ 52, 0xFF,
  /* ABS: 008 Pixels @ 056,054*/ 0, 8, 0x6F, 0x00, 0x00, 0xC6, 0xFC, 0x15, 0x00, 0x51,
  /* RLE: 042 Pixels @ 004,055*/ 42, 0xFF,
  /* ABS: 021 Pixels @ 046,055*/ 0, 21, 0xCF, 0x99, 0x99, 0x99, 0xB4, 0xCC, 0xCC, 0xFF, 0xD2, 0x99, 0x06, 0x00, 0x00, 0xD8, 0xFF, 0x81, 0x00, 0x06, 0x72, 0xC0, 0xFC,
  /* RLE: 022 Pixels @ 007,056*/ 22, 0xFF,
  /* ABS: 009 Pixels @ 029,056*/ 0, 9, 0xDE, 0xAB, 0x84, 0x66, 0x66, 0x66, 0x93, 0x99, 0xA8,
  /* RLE: 004 Pixels @ 038,056*/ 4, 0xCC,
  /* ABS: 004 Pixels @ 042,056*/ 0, 4, 0x99, 0x72, 0x3C, 0x06,
  /* RLE: 012 Pixels @ 046,056*/ 12, 0x00,
  /* ABS: 005 Pixels @ 058,056*/ 0, 5, 0x15, 0xFC, 0xFF, 0xFC, 0x57,
  /* RLE: 005 Pixels @ 003,057*/ 5, 0x00,
  /* ABS: 011 Pixels @ 008,057*/ 0, 11, 0x0C, 0x33, 0x33, 0x4B, 0x66, 0x66, 0x84, 0x99, 0x99, 0x99, 0xAE,
  /* RLE: 005 Pixels @ 019,057*/ 5, 0xCC,
  /* ABS: 005 Pixels @ 024,057*/ 0, 5, 0xA2, 0x93, 0x66, 0x45, 0x12,
  /* RLE: 028 Pixels @ 029,057*/ 28, 0x00,
  /* ABS: 002 Pixels @ 057,057*/ 0, 2, 0x09, 0xB1,
  /* RLE: 004 Pixels @ 059,057*/ 4, 0xFF,
  /* ABS: 002 Pixels @ 003,058*/ 0, 2, 0xA2, 0x2A,
  /* RLE: 033 Pixels @ 005,058*/ 33, 0x00,
  /* ABS: 008 Pixels @ 038,058*/ 0, 8, 0x15, 0x33, 0x33, 0x60, 0x7E, 0x9C, 0xCC, 0xF0,
  /* RLE: 004 Pixels @ 046,058*/ 4, 0xFF,
  /* ABS: 008 Pixels @ 050,058*/ 0, 8, 0xD2, 0xCC, 0xBA, 0x99, 0x99, 0x7E, 0x99, 0xE4,
  /* RLE: 007 Pixels @ 058,058*/ 7, 0xFF,
  /* ABS: 004 Pixels @ 005,059*/ 0, 4, 0xE4, 0xAB, 0x6F, 0x63,
  /* RLE: 004 Pixels @ 009,059*/ 4, 0x33,
  /* ABS: 024 Pixels @ 013,059*/ 0, 24, 0x5D, 0x66, 0x66, 0x90, 0x99, 0xC0, 0xD2, 0xF9, 0xCC, 0xA2, 0x81, 0x66, 0x51, 0x33, 0x21, 0x0C, 0x33, 0x3C, 0x66, 0x6F, 0x99, 0xA8, 0xCC, 0xDE,
  /* RLE: 023 Pixels @ 037,059*/ 23, 0xFF,


  0};  /* 968 bytes for 3600 pixels */

static GUI_CONST_STORAGE GUI_BITMAP _bmRectRed_60x60 = {
  60, /* XSize */
  60, /* YSize */
  60, /* BytesPerLine */
  GUI_COMPRESS_RLE8, /* BitsPerPixel */
  (unsigned char *)_acRectRed_60x60,  /* Pointer to picture data */
  NULL,  /* Pointer to palette */
  GUI_DRAW_RLEALPHA
};

/*********************************************************************
*
*       _aBitmapItem
*/
static const BITMAP_ITEM _aBitmapItem[] = {
  {&_bmBrowser, "Browser" , "Use the browser to explore the www"},
  {&_bmClock,   "Clock"   , "Adjust current time and date"},
  {&_bmDate,    "Date"    , "Use the diary"},
  {&_bmEmail,   "Email"   , "Read an email"},
  {&_bmSystem,  "System"  , "Change system settings"},
  {&_bmRead,    "Read"    , "Read a document"},
  {&_bmWrite,   "Write"   , "Write an email"},
  {&_bmPassword,"Password", "Determine the system password"},
  {&_bmRemote,  "Network" , "Select network"},
};

/*********************************************************************
*
*       Private routines
*
**********************************************************************
*/


/*********************************************************************
*
*       h/w 2D Copy engine (uses previously initiated DMA)
*   data are treated as 2D matrix to be copied (not linear)
*/
static void Copy2D16bit(uint16_t *pDst, uint16_t *pSrc, int width, int height, int srcDX, int dstDX )
{ DMA_CfgLoop_TypeDef loopCfg = {false, width-1 };
  DMA_CfgDescr_TypeDef descrCfg = {dmaDataInc2, dmaDataInc2, dmaDataSize2, dmaArbitrate1024, 9};
  DMA_CfgRect_TypeDef rectCfg = { dstDX*2, srcDX*2, height-1 };

  /* wait for finishing previous transaction - can take a nap for a moment */
  while(DMA_ChannelEnabled(0))
  {
#ifdef ENERGY_AWARE
    EMU_EnterEM1();
#endif
  }
  DMA_CfgDescr(0,true, &descrCfg);
  DMA_CfgRect(0, &rectCfg);
  DMA_CfgLoop(0, &loopCfg);
  DMA_ActivateAuto(0, true, (uint32_t *)pDst, (uint32_t *)pSrc, width-1);
  /* wait to finish transaction - can take a nap for a moment */
  while(DMA_ChannelEnabled(0))
  {
#ifdef ENERGY_AWARE
    EMU_EnterEM1();
#endif
  }
}

/*********************************************************************
*
*       em_DrawBitmap
*/
static void em_DrawBitmap(int x0,int y0,int xSize, int ySize, const U8 GUI_UNI_PTR * pPixel) {

  int BytesPerLine;

  /*
   * Get function pointer for color conversion
   */

    BytesPerLine = xSize * 2;
    int x1, y1, Diff;
    y1 = y0 + ySize - 1;
    x1 = x0 + xSize - 1;

#if ( GUI_VERSION >= 52601 )
    int clipX0 = GUI_pContext->ClipRect.x0;
    int clipX1 = GUI_pContext->ClipRect.x1;
    int clipY0 = GUI_pContext->ClipRect.y0;
    int clipY1 = GUI_pContext->ClipRect.y1;
#else
    int clipX0 = GUI_Context.ClipRect.x0;
    int clipX1 = GUI_Context.ClipRect.x1;
    int clipY0 = GUI_Context.ClipRect.y0;
    int clipY1 = GUI_Context.ClipRect.y1;
#endif
    /*
     * Clip Y
     */
    if (y0 < clipY0 ) {
      Diff = clipY0 - y0;
      y0   = clipY0;
      pPixel += (U32)Diff * (U32)BytesPerLine;
      ySize -= Diff;
    }
    Diff = y1 - clipY1;
    if (Diff > 0) {
      ySize -= Diff;
    }
    if (ySize <=0) {
      return;
    }
    /*
     * Clip right side
     */
    Diff = x1 - clipX1;
    if (Diff > 0) {
      xSize -= Diff;
    }
    /*
     * Clip left side
     */
    if (x0 < clipX0) {
      Diff =   clipX0 - x0;
      xSize -= Diff;
      pPixel += Diff * 4;
      x0 += Diff;
    }
    if (xSize <=0) {
      return;
    }
    /* below instruction sets color to be supressed        */
     EBI_TFTMaskSet(TRANSP);
    /* we will use hardware masking accelerator. Since now setting pixel     */
    /* with above defined color will be supressed                             */
    /* Read reference manual "14.3.17 Alpha Blending and Masking" for details */
    EBI_TFTMaskBlendMode(ebiTFTMBEMask);

    /* make fast 2D copy - source is clipped bitmap, output is frame buffer */
    Copy2D16bit((uint16_t *)((uint32_t)pFrameBuffer + x0*2 + y0*XSIZE*2), (uint16_t *)pPixel, xSize, ySize, BytesPerLine/2, XSIZE );

    /* Disable h/w masking */
    EBI_TFTMaskBlendMode(ebiTFTMBDisabled);
}

static void em_DrawBitmap_565(int x0, int y0, int xSize, int ySize, const U8 GUI_UNI_PTR * pPixel, const LCD_LOGPALETTE GUI_UNI_PTR * pLogPal, int xMag, int yMag) {
  (void)xMag;                   /* Unused parameter */
  (void)yMag;                   /* Unused parameter */
  GUI_USE_PARA(pLogPal);
  em_DrawBitmap(x0, y0, xSize, ySize, pPixel);
}

/*********************************************************************
*
*       _cbDialog
*/
static void _cbDialog(WM_MESSAGE * pMsg) {
  WM_HWIN hItem;
  static int point = 0;
  static U8 PressedPrev = 0;
  const POINT Points[3] = { {40, 40}, {280, 120}, {160, 200} }; /* calibration points on screen */
  static POINT PointsScr[3];

  // USER START (Optionally insert additional variables)
  // USER END

  switch (pMsg->MsgId) {
  case WM_INIT_DIALOG:
    //
    // Initialization of 'Calibration'
    //
    hItem = pMsg->hWin;
    WINDOW_SetBkColor(hItem, 0x00000000);
    //
    // Initialization of 'Instruction'
    //
    hItem = WM_GetDialogItem(pMsg->hWin, ID_TEXT_0);
    TEXT_SetText(hItem, "Press calibration point");
    TEXT_SetTextColor(hItem, 0x0080FFFF);
    TEXT_SetTextAlign(hItem, GUI_TA_HCENTER | GUI_TA_VCENTER);
    TEXT_SetFont(hItem, GUI_FONT_16_1);
    GUI_CURSOR_Select(&GUI_CursorCrossM);
    GUI_CURSOR_SetPosition(Points[0].x, Points[0].y);
    GUI_CURSOR_Show();
    point = 0;
    PressedPrev = 0;
    /* draw first cross here */
    // USER START (Optionally insert additional code for further widget initialization)
  case WM_TOUCH:
  case WM_TOUCH_CHILD:
    { TOUCH_Pos_TypeDef *pos = TOUCH_GetPos();  /* get information from touchpanel */
      GUI_PID_STATE *pInfo;
      pInfo = (GUI_PID_STATE *)pMsg->Data.p;
      switch(point)
      { case 0:
        case 1:
        case 2: GUI_CURSOR_SetPosition(Points[point].x, Points[point].y); break;
       default: GUI_CURSOR_Hide();
                GUI_EndDialog(pMsg->hWin, 0);
      }
      if(pInfo->Layer==0)
      {
        if( (pos->pen == 1) && (PressedPrev==0) )
        {
          PointsScr[point].x = pos->adcx;
          PointsScr[point].y = pos->adcy;
          if(point==2)
          {
            TOUCH_CalibrationTable((POINT *)Points, PointsScr);
          }
          point++;
        }
        PressedPrev = pos->pen;
      }
    }

    // USER END
    break;
  // USER START (Optionally insert additional message handling)
  // USER END
  default:
    WM_DefaultProc(pMsg);
    break;
  }
}

/*********************************************************************
*
*       _cbBk
*
*  Function description:
*    Callback routine of desktop window
*/
static void _cbBk(WM_MESSAGE * pMsg) {
  int     xSize, ySize;
  int     NCode, Id;
  PARA  * pPara;
  WM_HWIN hItem;

  switch (pMsg->MsgId) {
  case WM_NOTIFY_PARENT:
    Id    = WM_GetId(pMsg->hWinSrc);      /* Id of widget */
    NCode = pMsg->Data.v;                 /* Notification code */
    switch (Id) {
    case GUI_ID_CHECK0:
      switch (NCode) {
      case WM_NOTIFICATION_VALUE_CHANGED:
        hItem = pMsg->hWinSrc;
        CHECKBOX_GetUserData(hItem, &pPara, sizeof(pPara));
        pPara->DoAnimation = CHECKBOX_GetState(hItem);
        break;
      }
      break;
    }
    break;
  case WM_PAINT:
    xSize = LCD_GetXSize();
    ySize = LCD_GetYSize();
    GUI_DrawGradientV(0, 0, xSize - 1, ySize - 1, GUI_BLACK, GUI_DARKBLUE);
    GUI_SetTextMode(GUI_TM_TRANS);
    GUI_SetFont(&GUI_FontRounded22);
    GUI_DispStringHCenterAt("Radial Menu with Motion Support", 160, 5);
    break;
  }
}

/*********************************************************************
*
*       _cbDraw
*
*  Function description:
*    Callback routine of radial menu
*/
static void _cbDraw(WM_MESSAGE * pMsg) {
  WM_HWIN     hWin;
  PARA      * pPara;
  int         i, a1000, Swap;
  I32         SinHQ, CosHQ, a;
  ITEM_INFO   ItemInfo;

  hWin = pMsg->hWin;
  switch (pMsg->MsgId) {
  case WM_PAINT:
    WM_GetUserData(hWin, &pPara, sizeof(pPara));
    //
    // One time initialization of parameter structure
    //
    if (pPara->xSizeItem == 0) {
      pPara->xSizeWindow = WM_GetWindowSizeX(hWin);
      pPara->ySizeWindow = WM_GetWindowSizeY(hWin);
      pPara->xSizeItem   = pPara->pBitmapItem[0].pBitmap->XSize;
      pPara->ySizeItem   = pPara->pBitmapItem[0].pBitmap->YSize;
      pPara->rx          = (pPara->xSizeWindow - pPara->xSizeItem) / 2;
      pPara->ry          = (pPara->ySizeWindow-20 - pPara->ySizeItem) / 2;
      pPara->mx          = pPara->xSizeWindow/2;
      pPara->my          = (pPara->ySizeWindow-20)/2;
    }
    //
    // Calculate current positions of items
    //
    a1000 = (pPara->Pos * 3600) / pPara->NumItems;
    for (i = 0; i < pPara->NumItems; i++) {
      a = 90000 + a1000 + (i * 360000) / pPara->NumItems;
      SinHQ = GUI__SinHQ(a);
      CosHQ = GUI__CosHQ(a);
      pPara->pItemInfo[i].Index = i;
      pPara->pItemInfo[i].xPos  = pPara->mx -  ((CosHQ * pPara->rx) >> 16);
      pPara->pItemInfo[i].yPos  = pPara->my + ((SinHQ * pPara->ry) >> 16);
    }
    //
    // Bubble sort items to be able to draw background items first
    //
    do {
      Swap = 0;
      for (i = 0; i < (pPara->NumItems - 1); i++) {
        if (pPara->pItemInfo[i].yPos > pPara->pItemInfo[i + 1].yPos) {
          ItemInfo                = pPara->pItemInfo[i];
          pPara->pItemInfo[i]     = pPara->pItemInfo[i + 1];
          pPara->pItemInfo[i + 1] = ItemInfo;
          Swap = 1;
        }
      }
    } while (Swap);
    //
    // Draw items
    //
    for (i = 0; i < pPara->NumItems; i++) {
      GUI_DrawBitmap((pPara->pBitmapItem + pPara->pItemInfo[i].Index)->pBitmap, pPara->pItemInfo[i].xPos - pPara->xSizeItem / 2, pPara->pItemInfo[i].yPos - pPara->ySizeItem / 2);
    }
    //
    // Draw item text only after final move
    //
    if (pPara->FinalMove) {
      GUI_SetTextMode(GUI_TM_TRANS);
      GUI_SetFont(GUI_FONT_13_ASCII);
      GUI_DispStringHCenterAt((pPara->pBitmapItem + pPara->pItemInfo[pPara->NumItems - 1].Index)->pExplanation, 150, pPara->ySizeWindow-14);
    }
    //
    // Draw frame surround the current item
    //
    GUI_SetColor(GUI_RED);
    GUI_DrawBitmap(&_bmRectRed_60x60, 120, pPara->my+pPara->ry-30);

    break;
  }
}

/*********************************************************************
*
*       _cbMotion
*
*  Function description:
*    Callback routine of transparent motion window which is responsible
*    for processing the motion messages.
*/
static void _cbMotion(WM_MESSAGE * pMsg) {
  WM_HWIN hWin;
  WM_MOTION_INFO * pInfo;
  PARA           * pPara;

  hWin = pMsg->hWin;
  switch (pMsg->MsgId) {
  case WM_MOTION:
    WM_GetUserData(hWin, &pPara, sizeof(pPara));
    pInfo = (WM_MOTION_INFO *)pMsg->Data.p;
    switch (pInfo->Cmd) {
    case WM_MOTION_INIT:
      pInfo->Flags = WM_CF_MOTION_X | WM_MOTION_MANAGE_BY_WINDOW;
      pInfo->SnapX = 100;
      break;
    case WM_MOTION_MOVE:
      pPara->FinalMove = pInfo->FinalMove;
      pPara->Pos += pInfo->dx;
      if (pPara->Pos > pPara->NumItems * 100) {
        pPara->Pos -= pPara->NumItems * 100;
      }
      if (pPara->Pos < 0) {
        pPara->Pos += pPara->NumItems * 100;
      }
      WM_Invalidate(WM_GetParent(hWin));
      break;
    case WM_MOTION_GETPOS:
      pInfo->xPos = pPara->Pos;
      break;
    }
    break;
  }
}

/*********************************************************************
*
*       _Delay
*
*  Function description:
*    Delay function which returns 1 immediately if automatic animation is off
*/
static int _Delay(int ms, PARA * pPara) {
  int TimeNow, TimeEnd;

  TimeNow = GUI_GetTime();
  TimeEnd = TimeNow + ms;
  joy1 = BSP_JoystickGet();
  do {
    GUI_Delay(10);
    joy2 = joy1;
    joy1 = BSP_JoystickGet();
    if(( (joy2 & JOYSTICK_DOWN)==0) && (joy1 & JOYSTICK_DOWN))
    { /* joystick pressed down */
      pPara->DoAnimation ^= 1;
      CHECKBOX_SetState(pPara->hCheck, pPara->DoAnimation);
    }
    if( BSP_PushButtonsGet() & KEY_PB4)
         GUI_ExecDialogBox(_aDialogCreate, GUI_COUNTOF(_aDialogCreate), &_cbDialog, WM_HBKWIN, 0, 0);
    TimeNow = GUI_GetTime();
  } while (pPara->DoAnimation && (TimeNow < TimeEnd));
  return pPara->DoAnimation ? 0 : 1;
}

/*********************************************************************
*
*       _CreateCheckbox
*
*  Function description:
*    Creates a checkbox which is used to turn automatic animation on or off
*/
static void _CreateCheckbox(PARA * pPara) {
  CHECKBOX_SKINFLEX_PROPS Props;
  int i;

  //
  // Get properties of current skin
  //
  CHECKBOX_GetSkinFlexProps(&Props, CHECKBOX_SKINFLEX_PI_ENABLED);
  //
  // Change button size and colors of skin
  //
  Props.ButtonSize = CHECBOX_BUTTON_SIZE;
  for (i = 0; i < (int)GUI_COUNTOF(Props.aColorFrame); i++) {
    Props.aColorFrame[i] |= GUI_BLUE;
  }
  for (i = 0; i < (int)GUI_COUNTOF(Props.aColorInner); i++) {
    Props.aColorInner[i] |= GUI_BLUE;
  }
  Props.ColorCheck |= GUI_BLUE;
  //
  // Set properties of current skin
  //
  CHECKBOX_SetSkinFlexProps(&Props, CHECKBOX_SKINFLEX_PI_ENABLED);
  //
  // Enable skinning
  //
  CHECKBOX_SetDefaultSkin(CHECKBOX_SKIN_FLEX);
  //
  // Create checkbox and do some more configurations
  //
  pPara->hCheck = CHECKBOX_CreateUser(50, 210, 220, 20, WM_HBKWIN, WM_CF_SHOW | WM_CF_HASTRANS, 0, GUI_ID_CHECK0, sizeof(pPara));
  CHECKBOX_SetUserData(pPara->hCheck, &pPara, sizeof(pPara));
  CHECKBOX_SetTextColor(pPara->hCheck, GUI_WHITE);
  CHECKBOX_SetFont(pPara->hCheck, &GUI_FontRounded22);
  CHECKBOX_SetText(pPara->hCheck, "Automatic animation");
  CHECKBOX_SetTextAlign(pPara->hCheck, GUI_TA_VCENTER);
  CHECKBOX_SetState(pPara->hCheck, 1);
}

/*********************************************************************
*
*       _RadialMenu
*
*  Function description:
*    Creates and executes a radial menu with motion support.
*/
static void _RadialMenu(void) {
  WM_HWIN hDraw, hMotion;
  static PARA Para;
  static ITEM_INFO aItemInfo[GUI_COUNTOF(_aBitmapItem)];
  PARA * pPara;
  int    xSizeWindow, ySizeWindow, i;

  //
  // Initialize parameter structure for items to be shown
  //
  pPara = &Para;
  pPara->NumItems    = GUI_COUNTOF(_aBitmapItem);
  pPara->pBitmapItem = _aBitmapItem;
  pPara->pItemInfo   = aItemInfo;
  pPara->Pos         = 0;
  //
  // Create radial menu window
  //
  hDraw              = WM_CreateWindowAsChild(10, 40, 300, 150, WM_HBKWIN, WM_CF_SHOW | WM_CF_HASTRANS , _cbDraw, sizeof(pPara));
  //
  // Create transparent window which receives the motion messages
  //
  xSizeWindow        = WM_GetWindowSizeX(hDraw);
  ySizeWindow        = WM_GetWindowSizeY(hDraw);
  hMotion            = WM_CreateWindowAsChild(0, ySizeWindow / 2, xSizeWindow, ySizeWindow / 2, hDraw, WM_CF_SHOW | WM_CF_HASTRANS , _cbMotion, sizeof(pPara));
  //
  // Add pointer to parameter structure to windows
  //
  WM_SetUserData(hDraw,   &pPara, sizeof(pPara));
  WM_SetUserData(hMotion, &pPara, sizeof(pPara));
  //
  // Create checkbox
  //
  _CreateCheckbox(pPara);
  //
  // Animation loop
  //
  WM_DisableMemdev(hDraw);

  while (1) {
    if (pPara->DoAnimation) {
      do {

        //
        // Turn left (motion)
        //

        WM_MOTION_SetMotion(hMotion, GUI_COORD_X, 200, 200);
        DELAY(2000);
        WM_MOTION_SetMotion(hMotion, GUI_COORD_X, 800, 800);
        DELAY(2000);
        WM_MOTION_SetMotion(hMotion, GUI_COORD_X, 2000, 2000);
        DELAY(2000);
        //
        // Turn right (motion)
        //
        WM_MOTION_SetMotion(hMotion, GUI_COORD_X, -200, 200);
        DELAY(2000);
        WM_MOTION_SetMotion(hMotion, GUI_COORD_X, -800, 800);
        DELAY(2000);
        WM_MOTION_SetMotion(hMotion, GUI_COORD_X, -2000, 2000);
        DELAY(2000);
        //
        // Turn left (movement)
        //
        for (i = 0; i < 5; i++) {
          WM_MOTION_SetMovement(hMotion, GUI_COORD_X, 500, 100);
          DELAY(500);
        }
        DELAY(1000);
        //
        // Turn right (movement)
        //
        for (i = 0; i < 5; i++) {
          WM_MOTION_SetMovement(hMotion, GUI_COORD_X, -500, 100);
          DELAY(500);
        }
      } while (pPara->DoAnimation);
      WM_MOTION_SetMotion(hMotion, GUI_COORD_X, 100, 800);
    }
    _Delay(10, &Para);
    if(( (joy2 & JOYSTICK_LEFT)==0) && (joy1 & JOYSTICK_LEFT))
    { /* joystick shifted left */
      WM_MOTION_SetMovement(hMotion, GUI_COORD_X, -200, 100+(pPara->Pos%100));
    }
    if(( (joy2 & JOYSTICK_RIGHT)==0) && (joy1 & JOYSTICK_RIGHT))
    { /* joystick shifted right */
      WM_MOTION_SetMovement(hMotion, GUI_COORD_X, 200, 100-(pPara->Pos%100) + ((pPara->Pos%100)?100:0) );
    }
    if( BSP_PushButtonsGet() & KEY_PB4)
         GUI_ExecDialogBox(_aDialogCreate, GUI_COUNTOF(_aDialogCreate), &_cbDialog, WM_HBKWIN, 0, 0);
  }
}

extern uint32_t VRAM_pointer;

/*********************************************************************
*
*       _CopyBuffer
*
*  Function description:
*    Copies frame buffer using DMA
*/
static void _CopyBuffer(int LayerIndex, int IndexSrc, int IndexDst)
{  unsigned long BufferSize, AddrSrc, AddrDst;

  (void)LayerIndex;                   /* Unused parameter */

  // Calculate the size of one frame buffer
  //
  BufferSize = (XSIZE * YSIZE * BITSPERPIXEL) / 8;
  //
  // Calculate source- and destination address
  //
  AddrSrc    = VRAM_pointer + BufferSize * IndexSrc + EBI_BankAddress(EBI_BANK2);
  AddrDst    = VRAM_pointer + BufferSize * IndexDst + EBI_BankAddress(EBI_BANK2);
  /* make fast 2D copy of source frame buffer into destination source buffer */
  Copy2D16bit((uint16_t *)AddrDst, (uint16_t *)AddrSrc, XSIZE, YSIZE, XSIZE, XSIZE);

  pFrameBuffer = (uint32_t *)AddrDst;
};

/* definition of DMA control block - it must be properly aligned */
SL_ALIGN(256)
static DMA_DESCRIPTOR_TypeDef controlBlock[2] SL_ATTRIBUTE_ALIGN(256);

static DMA_Init_TypeDef dmaInit = {0, controlBlock};
DMA_CfgChannel_TypeDef chanCfg = {false, true, 0, NULL};

/*********************************************************************
*
*       Public routines
*
**********************************************************************
*/

/*********************************************************************
*
*       MainTask
*/
int main(void) {
  //WM_SetCreateFlags(WM_CF_MEMDEV);
  GUI_Init();
  DMA_Init(&dmaInit);
  DMA_CfgChannel(0, &chanCfg);
  LCD_SetDevFunc(0, LCD_DEVFUNC_COPYBUFFER, (void (*)())_CopyBuffer);
  WM_MOTION_Enable(1);
  WM_MOTION_SetDefaultPeriod(100);
  WM_MULTIBUF_Enable(1);
  WM_SetCallback(WM_HBKWIN, _cbBk);
  _RadialMenu();
  while (1) {
    GUI_Delay(50);
  }
}

/*************************** End of file ****************************/
