/***************************************************************************//**
 * @file displayconfigapp.h
 * @brief Display application specific configuration file.
 * @version 5.0.0
 *******************************************************************************
 * @section License
 * <b>Copyright 2015 Silicon Labs, Inc. http://www.silabs.com</b>
 *******************************************************************************
 *
 * This file is licensed under the Silabs License Agreement. See the file
 * "Silabs_License_Agreement.txt" for details. Before using this software for
 * any purpose, you must agree to the terms of that agreement.
 *
 ******************************************************************************/

#ifndef __DISPLAYCONFIGAPP_H__
#define __DISPLAYCONFIGAPP_H__

/* Include TEXTDISPLAY support because this example prints text to the
   display. */
#define INCLUDE_TEXTDISPLAY_SUPPORT

/* Enable/disable video terminal escape sequences. */
#define INCLUDE_VIDEO_TERMINAL_ESCAPE_SEQUENCE_SUPPORT

/* Select one of the fonts listed below:
   TEXTDISPLAY_FONT_6x8
   TEXTDISPLAY_FONT_8x8
*/
#define TEXTDISPLAY_FONT_8x8

/* Enable or disable scroll mode on the text display. */
#define RETARGETTEXTDISPLAY_SCROLL_MODE  (false)

/* Enable or disable adding Carriage Return (CR) to Line Feed (LF) characters
   on the text display. */
#define RETARGETTEXTDISPLAY_LINE_FEED_MODE  (true)

/* Use ULFRCO, since we need the clock to work in EM3 */
#undef  PAL_RTCC_CLOCK_LFXO
#undef  PAL_RTCC_CLOCK_LFRCO
#define  PAL_RTCC_CLOCK_ULFRCO

/* The ULFRCO is running at 1 kHz so we setup a frequency that can
 * be generated by a power of 2 divisor of the ULFRCO.
 *
 * 1 kHz / 8 = 125
 *
 * The rtcc will trigger at this frequency and will toggle the EXTCOMIN
 * pin at a frequency of 125 / 2 = 62.5 Hz
 */
#define LS013B7DH03_POLARITY_INVERSION_FREQUENCY (125)

#endif /* __DISPLAYCONFIGAPP_H__ */
