/*
    FreeRTOS V9.0.0 - Copyright (C) 2016 Real Time Engineers Ltd.
    All rights reserved

    VISIT http://www.FreeRTOS.org TO ENSURE YOU ARE USING THE LATEST VERSION.

    This file is part of the FreeRTOS distribution.

    FreeRTOS is free software; you can redistribute it and/or modify it under
    the terms of the GNU General Public License (version 2) as published by the
    Free Software Foundation >>>> AND MODIFIED BY <<<< the FreeRTOS exception.

    ***************************************************************************
    >>!   NOTE: The modification to the GPL is included to allow you to     !<<
    >>!   distribute a combined work that includes FreeRTOS without being   !<<
    >>!   obliged to provide the source code for proprietary components     !<<
    >>!   outside of the FreeRTOS kernel.                                   !<<
    ***************************************************************************

    FreeRTOS is distributed in the hope that it will be useful, but WITHOUT ANY
    WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
    FOR A PARTICULAR PURPOSE.  Full license text is available on the following
    link: http://www.freertos.org/a00114.html

    ***************************************************************************
     *                                                                       *
     *    FreeRTOS provides completely free yet professionally developed,    *
     *    robust, strictly quality controlled, supported, and cross          *
     *    platform software that is more than just the market leader, it     *
     *    is the industry's de facto standard.                               *
     *                                                                       *
     *    Help yourself get started quickly while simultaneously helping     *
     *    to support the FreeRTOS project by purchasing a FreeRTOS           *
     *    tutorial book, reference manual, or both:                          *
     *    http://www.FreeRTOS.org/Documentation                              *
     *                                                                       *
    ***************************************************************************

    http://www.FreeRTOS.org/FAQHelp.html - Having a problem?  Start by reading
    the FAQ page "My application does not run, what could be wrong?".  Have you
    defined configASSERT()?

    http://www.FreeRTOS.org/support - In return for receiving this top quality
    embedded software for free we request you assist our global community by
    participating in the support forum.

    http://www.FreeRTOS.org/training - Investing in training allows your team to
    be as productive as possible as early as possible.  Now you can receive
    FreeRTOS training directly from Richard Barry, CEO of Real Time Engineers
    Ltd, and the world's leading authority on the world's leading RTOS.

    http://www.FreeRTOS.org/plus - A selection of FreeRTOS ecosystem products,
    including FreeRTOS+Trace - an indispensable productivity tool, a DOS
    compatible FAT file system, and our tiny thread aware UDP/IP stack.

    http://www.FreeRTOS.org/labs - Where new FreeRTOS products go to incubate.
    Come and try FreeRTOS+TCP, our new open source TCP/IP stack for FreeRTOS.

    http://www.OpenRTOS.com - Real Time Engineers ltd. license FreeRTOS to High
    Integrity Systems ltd. to sell under the OpenRTOS brand.  Low cost OpenRTOS
    licenses offer ticketed support, indemnification and commercial middleware.

    http://www.SafeRTOS.com - High Integrity Systems also provide a safety
    engineered and independently SIL3 certified version for use in safety and
    mission critical applications that require provable dependability.

    1 tab == 4 spaces!
*/

/*
 * "Reg test" tasks - These fill the registers with known values, then check
 * that each register maintains its expected value for the lifetime of the
 * task.  Each task uses a different set of values.  The reg test tasks execute
 * with a very low priority, so get preempted very frequently.  A register
 * containing an unexpected value is indicative of an error in the context
 * switching mechanism.
 */

__asm void vRegTest1Implementation( void )
{
	PRESERVE8
	IMPORT ulRegTest1LoopCounter

	/* Fill the core registers with known values.  This is only done once. */
	mov	r0, #100
	mov	r1, #101
	mov	r2, #102
	mov	r3, #103
	mov	r4, #104
	mov	r5, #105
	mov	r6, #106
	mov	r7, #107
	mov	r8, #108
	mov	r9, #109
	mov	r10, #110
	mov	r11, #111
	mov	r12, #112

	/* Fill the VFP registers with known values. */
	vmov d0, r0, r1
	vmov d1, r2, r3
	vmov d2, r4, r5
	vmov d3, r6, r7
	vmov d4, r8, r9
	vmov d5, r10, r11
	vmov d6, r0, r1
	vmov d7, r2, r3
	vmov d8, r4, r5
	vmov d9, r6, r7
	vmov d10, r8, r9
	vmov d11, r10, r11
	vmov d12, r0, r1
	vmov d13, r2, r3
	vmov d14, r4, r5
	vmov d15, r6, r7

reg1_loop
	/* Check all the VFP registers still contain the values set above.
	First save registers that are clobbered by the test. */
	push { r0-r1 }

	vmov r0, r1, d0
	cmp r0, #100
	bne reg1_error_loopf
	cmp r1, #101
	bne reg1_error_loopf
	vmov r0, r1, d1
	cmp r0, #102
	bne reg1_error_loopf
	cmp r1, #103
	bne reg1_error_loopf
	vmov r0, r1, d2
	cmp r0, #104
	bne reg1_error_loopf
	cmp r1, #105
	bne reg1_error_loopf
	vmov r0, r1, d3
	cmp r0, #106
	bne reg1_error_loopf
	cmp r1, #107
	bne reg1_error_loopf
	vmov r0, r1, d4
	cmp r0, #108
	bne reg1_error_loopf
	cmp r1, #109
	bne reg1_error_loopf
	vmov r0, r1, d5
	cmp r0, #110
	bne reg1_error_loopf
	cmp r1, #111
	bne reg1_error_loopf
	vmov r0, r1, d6
	cmp r0, #100
	bne reg1_error_loopf
	cmp r1, #101
	bne reg1_error_loopf
	vmov r0, r1, d7
	cmp r0, #102
	bne reg1_error_loopf
	cmp r1, #103
	bne reg1_error_loopf
	vmov r0, r1, d8
	cmp r0, #104
	bne reg1_error_loopf
	cmp r1, #105
	bne reg1_error_loopf
	vmov r0, r1, d9
	cmp r0, #106
	bne reg1_error_loopf
	cmp r1, #107
	bne reg1_error_loopf
	vmov r0, r1, d10
	cmp r0, #108
	bne reg1_error_loopf
	cmp r1, #109
	bne reg1_error_loopf
	vmov r0, r1, d11
	cmp r0, #110
	bne reg1_error_loopf
	cmp r1, #111
	bne reg1_error_loopf
	vmov r0, r1, d12
	cmp r0, #100
	bne reg1_error_loopf
	cmp r1, #101
	bne reg1_error_loopf
	vmov r0, r1, d13
	cmp r0, #102
	bne reg1_error_loopf
	cmp r1, #103
	bne reg1_error_loopf
	vmov r0, r1, d14
	cmp r0, #104
	bne reg1_error_loopf
	cmp r1, #105
	bne reg1_error_loopf
	vmov r0, r1, d15
	cmp r0, #106
	bne reg1_error_loopf
	cmp r1, #107
	bne reg1_error_loopf

	/* Restore the registers that were clobbered by the test. */
	pop {r0-r1}

	/* VFP register test passed.  Jump to the core register test. */
	b reg1_loopf_pass

reg1_error_loopf
	/* If this line is hit then a VFP register value was found to be
	incorrect. */
	b reg1_error_loopf

reg1_loopf_pass

	cmp r0, #100
	bne reg1_error_loop
	cmp r1, #101
	bne reg1_error_loop
	cmp r2, #102
	bne reg1_error_loop
	cmp r3, #103
	bne reg1_error_loop
	cmp r4, #104
	bne reg1_error_loop
	cmp r5, #105
	bne reg1_error_loop
	cmp r6, #106
	bne reg1_error_loop
	cmp r7, #107
	bne reg1_error_loop
	cmp r8, #108
	bne reg1_error_loop
	cmp r9, #109
	bne reg1_error_loop
	cmp r10, #110
	bne reg1_error_loop
	cmp r11, #111
	bne reg1_error_loop
	cmp r12, #112
	bne reg1_error_loop

	/* Everything passed, increment the loop counter. */
	push { r0-r1 }
	ldr	r0, =ulRegTest1LoopCounter
	ldr r1, [r0]
	adds r1, r1, #1
	str r1, [r0]
	pop { r0-r1 }

	/* Start again. */
	b reg1_loop

reg1_error_loop
	/* If this line is hit then there was an error in a core register value.
	The loop ensures the loop counter stops incrementing. */
	b reg1_error_loop
	nop
}
/*-----------------------------------------------------------*/

__asm void vRegTest2Implementation( void )
{
	PRESERVE8
	IMPORT ulRegTest2LoopCounter

	/* Set all the core registers to known values. */
	mov r0, #-1
	mov r1, #1
	mov r2, #2
	mov r3, #3
	mov	r4, #4
	mov	r5, #5
	mov	r6, #6
	mov r7, #7
	mov	r8, #8
	mov	r9, #9
	mov	r10, #10
	mov	r11, #11
	mov r12, #12

	/* Set all the VFP to known values. */
	vmov d0, r0, r1
	vmov d1, r2, r3
	vmov d2, r4, r5
	vmov d3, r6, r7
	vmov d4, r8, r9
	vmov d5, r10, r11
	vmov d6, r0, r1
	vmov d7, r2, r3
	vmov d8, r4, r5
	vmov d9, r6, r7
	vmov d10, r8, r9
	vmov d11, r10, r11
	vmov d12, r0, r1
	vmov d13, r2, r3
	vmov d14, r4, r5
	vmov d15, r6, r7

reg2_loop

	/* Check all the VFP registers still contain the values set above.
	First save registers that are clobbered by the test. */
	push { r0-r1 }

	vmov r0, r1, d0
	cmp r0, #-1
	bne reg2_error_loopf
	cmp r1, #1
	bne reg2_error_loopf
	vmov r0, r1, d1
	cmp r0, #2
	bne reg2_error_loopf
	cmp r1, #3
	bne reg2_error_loopf
	vmov r0, r1, d2
	cmp r0, #4
	bne reg2_error_loopf
	cmp r1, #5
	bne reg2_error_loopf
	vmov r0, r1, d3
	cmp r0, #6
	bne reg2_error_loopf
	cmp r1, #7
	bne reg2_error_loopf
	vmov r0, r1, d4
	cmp r0, #8
	bne reg2_error_loopf
	cmp r1, #9
	bne reg2_error_loopf
	vmov r0, r1, d5
	cmp r0, #10
	bne reg2_error_loopf
	cmp r1, #11
	bne reg2_error_loopf
	vmov r0, r1, d6
	cmp r0, #-1
	bne reg2_error_loopf
	cmp r1, #1
	bne reg2_error_loopf
	vmov r0, r1, d7
	cmp r0, #2
	bne reg2_error_loopf
	cmp r1, #3
	bne reg2_error_loopf
	vmov r0, r1, d8
	cmp r0, #4
	bne reg2_error_loopf
	cmp r1, #5
	bne reg2_error_loopf
	vmov r0, r1, d9
	cmp r0, #6
	bne reg2_error_loopf
	cmp r1, #7
	bne reg2_error_loopf
	vmov r0, r1, d10
	cmp r0, #8
	bne reg2_error_loopf
	cmp r1, #9
	bne reg2_error_loopf
	vmov r0, r1, d11
	cmp r0, #10
	bne reg2_error_loopf
	cmp r1, #11
	bne reg2_error_loopf
	vmov r0, r1, d12
	cmp r0, #-1
	bne reg2_error_loopf
	cmp r1, #1
	bne reg2_error_loopf
	vmov r0, r1, d13
	cmp r0, #2
	bne reg2_error_loopf
	cmp r1, #3
	bne reg2_error_loopf
	vmov r0, r1, d14
	cmp r0, #4
	bne reg2_error_loopf
	cmp r1, #5
	bne reg2_error_loopf
	vmov r0, r1, d15
	cmp r0, #6
	bne reg2_error_loopf
	cmp r1, #7
	bne reg2_error_loopf

	/* Restore the registers that were clobbered by the test. */
	pop {r0-r1}

	/* VFP register test passed.  Jump to the core register test. */
	b reg2_loopf_pass

reg2_error_loopf
	/* If this line is hit then a VFP register value was found to be
	incorrect. */
	b reg2_error_loopf

reg2_loopf_pass

	cmp r0, #-1
	bne reg2_error_loop
	cmp r1, #1
	bne reg2_error_loop
	cmp r2, #2
	bne reg2_error_loop
	cmp r3, #3
	bne reg2_error_loop
	cmp r4, #4
	bne reg2_error_loop
	cmp r5, #5
	bne reg2_error_loop
	cmp r6, #6
	bne reg2_error_loop
	cmp r7, #7
	bne reg2_error_loop
	cmp r8, #8
	bne reg2_error_loop
	cmp r9, #9
	bne reg2_error_loop
	cmp r10, #10
	bne reg2_error_loop
	cmp r11, #11
	bne reg2_error_loop
	cmp r12, #12
	bne reg2_error_loop

	/* Increment the loop counter to indicate this test is still functioning
	correctly. */
	push { r0-r1 }
	ldr r0, =ulRegTest2LoopCounter
	ldr r1, [r0]
	adds r1, r1, #1
	str r1, [r0]

	/* Yield to increase test coverage. */
	movs r0, #0x01
	ldr r1, =0xe000ed04 /*NVIC_INT_CTRL */
	lsl r0, r0, #28     /* Shift to PendSV bit */
	str r0, [r1]
	dsb

	pop { r0-r1 }

	/* Start again. */
	b reg2_loop

reg2_error_loop
	/* If this line is hit then there was an error in a core register value.
	This loop ensures the loop counter variable stops incrementing. */
	b reg2_error_loop
}
/*-----------------------------------------------------------*/

