// Copyright 2016 Silicon Laboratories, Inc.
//
//

// Modem configuration parameters
// version: 1.3.0.117
// afc_en: 0
// ant_div: 0
// BER_mode: 0
// Ch_Fil_Bw_AFC: 0
// Chip_Version: 2
// crystal_tol: 20
// dsa_mode: 0
// dsource: 1
// ETSI: 0
// fc: 915000000
// Fdev: 20000
// Fdev_error: 0
// fhch: 10
// fhst: 250000
// freq_xo: 30000000
// hi_pfm_div_mode: 1
// High_perf_Ch_Fil: 1
// if_mode: 2
// inputBW: 0
// Manchester: 0
// Max_Rb_Error: 0
// modulation_type: 2
// OSRtune: 0
// pm_len: 16
// pm_pattern: 0
// raw_demod: 0
// Rsymb: 10000
// RXBW: 150000
// TC: 29

// Modem configuration calculated values
// if_freq: -468750.0
// nb_filter: 3
// nb_filter_bw: 123.48333333333333
// wb_filter: 3
// wb_filter_bw: 123.48333333333333

// Enclosing macro to prevent multiple inclusion
#ifndef __SLAB_RADIO_CONFIG_WDS__
#define __SLAB_RADIO_CONFIG_WDS__




#define RADIO_CONFIGURATION_DATA_RADIO_XO_FREQ 30000000L

#define RADIO_CONFIGURATION_DATA_RADIO_CHIP_FAMILY RADIO_CHIP_FAMILY_EZRADIOPRO

#define RADIO_CONFIGURATION_DATA_RADIO_PACKET_LENGTH (9)
#define RADIO_CONFIGURATION_DATA_RADIO_STATE_AFTER_POWER_UP (3)
#define RADIO_CONFIGURATION_DATA_RADIO_DELAY_CNT_AFTER_RESET (61440)
#define RADIO_CONFIGURATION_DATA_VARIABLEPACKETSTATE (0)
#define RADIO_CONFIGURATION_DATA_CUSTOM_PAYLOAD {0x1C, 0xC5, 0xC5, 0xC5, 0xC5, 0xC5, 0xC5, 0xC5, 0xC5, 0xC5, 0xC5, 0xC5, 0xC5, 0xC5, 0xC5, 0xC5, 0xC5, 0xC5, 0xC5, 0xC5, 0xC5, 0xC5, 0xC5, 0xC5, 0xC5, 0xC5, 0xC5, 0xC5, 0xC5}


#define RF_POWER_UP 0x02, 0x01, 0x00, 0x01, 0xC9, 0xC3, 0x80

#define RF_GPIO_PIN_CFG 0x13, 0x00, 0x00, 0x20, 0x21, 0x00, 0x00, 0x00

#define RF_SET_PROPERTY_GLOBAL_XO_TUNE 0x11, 0x00, 0x01, 0x00, 0x45

#define RF_SET_PROPERTY_FRR_CTL_A_MODE 0x11, 0x02, 0x01, 0x00, 0x01

#define RF_SET_PROPERTY_FRR_CTL_B_MODE 0x11, 0x02, 0x01, 0x01, 0x02

#define RF_SET_PROPERTY_FRR_CTL_C_MODE 0x11, 0x02, 0x01, 0x02, 0x09

#define RF_SET_PROPERTY_FRR_CTL_D_MODE 0x11, 0x02, 0x01, 0x03, 0x00

#define RF_SET_PROPERTY_INT_CTL_ENABLE 0x11, 0x01, 0x01, 0x00, 0x00

#define RF_SET_PROPERTY_INT_CTL_PH_ENABLE 0x11, 0x01, 0x01, 0x01, 0x00

#define RF_SET_PROPERTY_INT_CTL_MODEM_ENABLE 0x11, 0x01, 0x01, 0x02, 0x00

#define RF_SET_PROPERTY_INT_CTL_CHIP_ENABLE 0x11, 0x01, 0x01, 0x03, 0x00

#define RF_SET_PROPERTY_PA_MODE 0x11, 0x22, 0x01, 0x00, 0x08

#define RF_SET_PROPERTY_PA_PWR_LVL 0x11, 0x22, 0x01, 0x01, 0x7F

#define RF_SET_PROPERTY_PA_BIAS_CLKDUTY 0x11, 0x22, 0x01, 0x02, 0x0C

#define RF_SET_PROPERTY_PA_RAMP_EX 0x11, 0x22, 0x01, 0x04, 0x0E

#define RF_SET_PROPERTY_PA_RAMP_DOWN_DELAY 0x11, 0x22, 0x01, 0x05, 0x23

#define RF_SET_PROPERTY_PA_DIG_PWR_SEQ_CONFIG 0x11, 0x22, 0x01, 0x06, 0x03

#define RF_SET_PROPERTY_PREAMBLE_TX_LENGTH 0x11, 0x10, 0x01, 0x00, 0x08

#define RF_SET_PROPERTY_PREAMBLE_CONFIG_STD_1 0x11, 0x10, 0x01, 0x01, 0x14

#define RF_SET_PROPERTY_PREAMBLE_CONFIG_NSTD 0x11, 0x10, 0x01, 0x02, 0x00

#define RF_SET_PROPERTY_PREAMBLE_CONFIG_STD_2 0x11, 0x10, 0x01, 0x03, 0x0F

#define RF_SET_PROPERTY_PREAMBLE_CONFIG 0x11, 0x10, 0x01, 0x04, 0x21

#define RF_SET_PROPERTY_PREAMBLE_PATTERN 0x11, 0x10, 0x04, 0x05, 0x00, 0x00, 0x00, 0x00

#define RF_SET_PROPERTY_PREAMBLE_POSTAMBLE_CONFIG 0x11, 0x10, 0x01, 0x09, 0x00

#define RF_SET_PROPERTY_PREAMBLE_POSTAMBLE_PATTERN 0x11, 0x10, 0x04, 0x0A, 0x00, 0x00, 0x00, 0x00

#define RF_SET_PROPERTY_SYNC_CONFIG 0x11, 0x11, 0x01, 0x00, 0x01

#define RF_SET_PROPERTY_SYNC_BITS 0x11, 0x11, 0x04, 0x01, 0xB4, 0x2B, 0x00, 0x00

#define RF_SET_PROPERTY_SYNC_CONFIG2 0x11, 0x11, 0x01, 0x05, 0x00

#define RF_SET_PROPERTY_SYNC_BITS2 0x11, 0x11, 0x04, 0x06, 0x2D, 0xD4, 0x2D, 0xD4

#define RF_SET_PROPERTY_PKT_CRC_CONFIG 0x11, 0x12, 0x01, 0x00, 0x04

#define RF_SET_PROPERTY_PKT_WHT_POLY 0x11, 0x12, 0x02, 0x01, 0x05, 0x00

#define RF_SET_PROPERTY_PKT_WHT_SEED 0x11, 0x12, 0x02, 0x03, 0xFF, 0xFF

#define RF_SET_PROPERTY_PKT_WHT_BIT_NUM 0x11, 0x12, 0x01, 0x05, 0x20

#define RF_SET_PROPERTY_PKT_CONFIG1 0x11, 0x12, 0x01, 0x06, 0x00

#define RF_SET_PROPERTY_PKT_CONFIG2 0x11, 0x12, 0x01, 0x07, 0x00

#define RF_SET_PROPERTY_PKT_LEN 0x11, 0x12, 0x01, 0x08, 0x00

#define RF_SET_PROPERTY_PKT_LEN_FIELD_SOURCE 0x11, 0x12, 0x01, 0x09, 0x00

#define RF_SET_PROPERTY_PKT_LEN_ADJUST 0x11, 0x12, 0x01, 0x0A, 0x00

#define RF_SET_PROPERTY_PKT_TX_THRESHOLD 0x11, 0x12, 0x01, 0x0B, 0x30

#define RF_SET_PROPERTY_PKT_RX_THRESHOLD 0x11, 0x12, 0x01, 0x0C, 0x30

#define RF_SET_PROPERTY_PKT_FIELD_1_LENGTH 0x11, 0x12, 0x02, 0x0D, 0x00, 0x01

#define RF_SET_PROPERTY_PKT_FIELD_1_CONFIG 0x11, 0x12, 0x01, 0x0F, 0x00

#define RF_SET_PROPERTY_PKT_FIELD_1_CRC_CONFIG 0x11, 0x12, 0x01, 0x10, 0x82

#define RF_SET_PROPERTY_PKT_FIELD_2_LENGTH 0x11, 0x12, 0x02, 0x11, 0x00, 0x08

#define RF_SET_PROPERTY_PKT_FIELD_2_CONFIG 0x11, 0x12, 0x01, 0x13, 0x00

#define RF_SET_PROPERTY_PKT_FIELD_2_CRC_CONFIG 0x11, 0x12, 0x01, 0x14, 0x2A

#define RF_SET_PROPERTY_PKT_FIELD_3_LENGTH 0x11, 0x12, 0x02, 0x15, 0x00, 0x00

#define RF_SET_PROPERTY_PKT_FIELD_3_CONFIG 0x11, 0x12, 0x01, 0x17, 0x00

#define RF_SET_PROPERTY_PKT_FIELD_3_CRC_CONFIG 0x11, 0x12, 0x01, 0x18, 0x00

#define RF_SET_PROPERTY_PKT_FIELD_4_LENGTH 0x11, 0x12, 0x02, 0x19, 0x00, 0x00

#define RF_SET_PROPERTY_PKT_FIELD_4_CONFIG 0x11, 0x12, 0x01, 0x1B, 0x00

#define RF_SET_PROPERTY_PKT_FIELD_4_CRC_CONFIG 0x11, 0x12, 0x01, 0x1C, 0x00

#define RF_SET_PROPERTY_PKT_FIELD_5_LENGTH 0x11, 0x12, 0x02, 0x1D, 0x00, 0x00

#define RF_SET_PROPERTY_PKT_FIELD_5_CONFIG 0x11, 0x12, 0x01, 0x1F, 0x00

#define RF_SET_PROPERTY_PKT_FIELD_5_CRC_CONFIG 0x11, 0x12, 0x01, 0x20, 0x00

#define RF_SET_PROPERTY_PKT_RX_FIELD_1_LENGTH 0x11, 0x12, 0x02, 0x21, 0x00, 0x00

#define RF_SET_PROPERTY_PKT_RX_FIELD_1_CONFIG 0x11, 0x12, 0x01, 0x23, 0x00

#define RF_SET_PROPERTY_PKT_RX_FIELD_1_CRC_CONFIG 0x11, 0x12, 0x01, 0x24, 0x00

#define RF_SET_PROPERTY_PKT_RX_FIELD_2_LENGTH 0x11, 0x12, 0x02, 0x25, 0x00, 0x00

#define RF_SET_PROPERTY_PKT_RX_FIELD_2_CONFIG 0x11, 0x12, 0x01, 0x27, 0x00

#define RF_SET_PROPERTY_PKT_RX_FIELD_2_CRC_CONFIG 0x11, 0x12, 0x01, 0x28, 0x00

#define RF_SET_PROPERTY_PKT_RX_FIELD_3_LENGTH 0x11, 0x12, 0x02, 0x29, 0x00, 0x00

#define RF_SET_PROPERTY_PKT_RX_FIELD_3_CONFIG 0x11, 0x12, 0x01, 0x2B, 0x00

#define RF_SET_PROPERTY_PKT_RX_FIELD_3_CRC_CONFIG 0x11, 0x12, 0x01, 0x2C, 0x00

#define RF_SET_PROPERTY_PKT_RX_FIELD_4_LENGTH 0x11, 0x12, 0x02, 0x2D, 0x00, 0x00

#define RF_SET_PROPERTY_PKT_RX_FIELD_4_CONFIG 0x11, 0x12, 0x01, 0x2F, 0x00

#define RF_SET_PROPERTY_PKT_RX_FIELD_4_CRC_CONFIG 0x11, 0x12, 0x01, 0x30, 0x00

#define RF_SET_PROPERTY_PKT_RX_FIELD_5_LENGTH 0x11, 0x12, 0x02, 0x31, 0x00, 0x00

#define RF_SET_PROPERTY_PKT_RX_FIELD_5_CONFIG 0x11, 0x12, 0x01, 0x33, 0x00

#define RF_SET_PROPERTY_PKT_RX_FIELD_5_CRC_CONFIG 0x11, 0x12, 0x01, 0x34, 0x00

#define RF_SET_PROPERTY_PKT_CRC_SEED 0x11, 0x12, 0x04, 0x36, 0x00, 0x00, 0x00, 0x00

#define RF_SET_PROPERTY_MATCH_VALUE_1 0x11, 0x30, 0x01, 0x00, 0x00

#define RF_SET_PROPERTY_MATCH_MASK_1 0x11, 0x30, 0x01, 0x01, 0x00

#define RF_SET_PROPERTY_MATCH_CTRL_1 0x11, 0x30, 0x01, 0x02, 0x00

#define RF_SET_PROPERTY_MATCH_VALUE_2 0x11, 0x30, 0x01, 0x03, 0x00

#define RF_SET_PROPERTY_MATCH_MASK_2 0x11, 0x30, 0x01, 0x04, 0x00

#define RF_SET_PROPERTY_MATCH_CTRL_2 0x11, 0x30, 0x01, 0x05, 0x00

#define RF_SET_PROPERTY_MATCH_VALUE_3 0x11, 0x30, 0x01, 0x06, 0x00

#define RF_SET_PROPERTY_MATCH_MASK_3 0x11, 0x30, 0x01, 0x07, 0x00

#define RF_SET_PROPERTY_MATCH_CTRL_3 0x11, 0x30, 0x01, 0x08, 0x00

#define RF_SET_PROPERTY_MATCH_VALUE_4 0x11, 0x30, 0x01, 0x09, 0x00

#define RF_SET_PROPERTY_MATCH_MASK_4 0x11, 0x30, 0x01, 0x0A, 0x00

#define RF_SET_PROPERTY_MATCH_CTRL_4 0x11, 0x30, 0x01, 0x0B, 0x00

#define RF_SET_PROPERTY_MODEM_MOD_TYPE 0x11, 0x20, 0x01, 0x00, 0x0A

#define RF_SET_PROPERTY_MODEM_MAP_CONTROL 0x11, 0x20, 0x01, 0x01, 0x00

#define RF_SET_PROPERTY_MODEM_DSM_CTRL 0x11, 0x20, 0x01, 0x02, 0x07

#define RF_SET_PROPERTY_MODEM_CLKGEN_BAND 0x11, 0x20, 0x01, 0x51, 0x08

#define RF_SET_PROPERTY_SYNTH_PFDCP_CPFF 0x11, 0x23, 0x01, 0x00, 0x2C

#define RF_SET_PROPERTY_SYNTH_PFDCP_CPINT 0x11, 0x23, 0x01, 0x01, 0x0E

#define RF_SET_PROPERTY_SYNTH_VCO_KV 0x11, 0x23, 0x01, 0x02, 0x0B

#define RF_SET_PROPERTY_SYNTH_LPFILT3 0x11, 0x23, 0x01, 0x03, 0x04

#define RF_SET_PROPERTY_SYNTH_LPFILT2 0x11, 0x23, 0x01, 0x04, 0x0C

#define RF_SET_PROPERTY_SYNTH_LPFILT1 0x11, 0x23, 0x01, 0x05, 0x73

#define RF_SET_PROPERTY_SYNTH_LPFILT0 0x11, 0x23, 0x01, 0x06, 0x03

#define RF_SET_PROPERTY_MODEM_DATA_RATE 0x11, 0x20, 0x03, 0x03, 0x01, 0x86, 0xA0

#define RF_SET_PROPERTY_MODEM_TX_NCO_MODE 0x11, 0x20, 0x04, 0x06, 0x01, 0xC9, 0xC3, 0x80

#define RF_SET_PROPERTY_MODEM_FREQ_DEV 0x11, 0x20, 0x03, 0x0A, 0x00, 0x02, 0xBB

#define RF_SET_PROPERTY_MODEM_TX_RAMP_DELAY 0x11, 0x20, 0x01, 0x18, 0x01

#define RF_SET_PROPERTY_PA_TC 0x11, 0x22, 0x01, 0x03, 0x1D

#define RF_SET_PROPERTY_FREQ_CONTROL_INTE 0x11, 0x40, 0x01, 0x00, 0x3C

#define RF_SET_PROPERTY_FREQ_CONTROL_FRAC 0x11, 0x40, 0x03, 0x01, 0x08, 0x00, 0x00

#define RF_SET_PROPERTY_FREQ_CONTROL_CHANNEL_STEP_SIZE 0x11, 0x40, 0x02, 0x04, 0x22, 0x22

#define RF_SET_PROPERTY_FREQ_CONTROL_W_SIZE 0x11, 0x40, 0x01, 0x06, 0x20

#define RF_SET_PROPERTY_FREQ_CONTROL_VCOCNT_RX_ADJ 0x11, 0x40, 0x01, 0x07, 0xFF

#define RF_SET_PROPERTY_MODEM_MDM_CTRL 0x11, 0x20, 0x01, 0x19, 0x80

#define RF_SET_PROPERTY_MODEM_IF_CONTROL 0x11, 0x20, 0x01, 0x1A, 0x08

#define RF_SET_PROPERTY_MODEM_IF_FREQ 0x11, 0x20, 0x03, 0x1B, 0x03, 0xC0, 0x00

#define RF_SET_PROPERTY_MODEM_DECIMATION_CFG1 0x11, 0x20, 0x01, 0x1E, 0x10

#define RF_SET_PROPERTY_MODEM_DECIMATION_CFG0 0x11, 0x20, 0x01, 0x1F, 0x10

#define RF_SET_PROPERTY_MODEM_BCR_OSR 0x11, 0x20, 0x02, 0x22, 0x01, 0xF4

#define RF_SET_PROPERTY_MODEM_BCR_NCO_OFFSET 0x11, 0x20, 0x03, 0x24, 0x01, 0x06, 0x25

#define RF_SET_PROPERTY_MODEM_BCR_GAIN 0x11, 0x20, 0x02, 0x27, 0x00, 0x83

#define RF_SET_PROPERTY_MODEM_BCR_GEAR 0x11, 0x20, 0x01, 0x29, 0x02

#define RF_SET_PROPERTY_MODEM_BCR_MISC0 0x11, 0x20, 0x01, 0x2B, 0x00

#define RF_SET_PROPERTY_MODEM_BCR_MISC1 0x11, 0x20, 0x01, 0x2A, 0xC2

#define RF_SET_PROPERTY_MODEM_AFC_GEAR 0x11, 0x20, 0x01, 0x2C, 0x04

#define RF_SET_PROPERTY_MODEM_AFC_WAIT 0x11, 0x20, 0x01, 0x2D, 0x23

#define RF_SET_PROPERTY_MODEM_AFC_GAIN 0x11, 0x20, 0x02, 0x2E, 0x80, 0x0F

#define RF_SET_PROPERTY_MODEM_AFC_LIMITER 0x11, 0x20, 0x02, 0x30, 0x16, 0xFE

#define RF_SET_PROPERTY_MODEM_AFC_MISC 0x11, 0x20, 0x01, 0x32, 0x80

#define RF_SET_PROPERTY_MODEM_AGC_CONTROL 0x11, 0x20, 0x01, 0x35, 0xE0

#define RF_SET_PROPERTY_MODEM_AGC_WINDOW_SIZE 0x11, 0x20, 0x01, 0x38, 0x11

#define RF_SET_PROPERTY_MODEM_AGC_RFPD_DECAY 0x11, 0x20, 0x01, 0x39, 0x6D

#define RF_SET_PROPERTY_MODEM_AGC_IFPD_DECAY 0x11, 0x20, 0x01, 0x3A, 0x6D

#define RF_SET_PROPERTY_MODEM_FSK4_GAIN1 0x11, 0x20, 0x01, 0x3B, 0x80

#define RF_SET_PROPERTY_MODEM_FSK4_GAIN0 0x11, 0x20, 0x01, 0x3C, 0x02

#define RF_SET_PROPERTY_MODEM_FSK4_TH 0x11, 0x20, 0x02, 0x3D, 0xFF, 0xFF

#define RF_SET_PROPERTY_MODEM_FSK4_MAP 0x11, 0x20, 0x01, 0x3F, 0x00

#define RF_SET_PROPERTY_MODEM_OOK_PDTC 0x11, 0x20, 0x01, 0x40, 0x2A

#define RF_SET_PROPERTY_MODEM_OOK_BLOPK 0x11, 0x20, 0x01, 0x41, 0x0C

#define RF_SET_PROPERTY_MODEM_OOK_CNT1 0x11, 0x20, 0x01, 0x42, 0xA4

#define RF_SET_PROPERTY_MODEM_OOK_MISC 0x11, 0x20, 0x01, 0x43, 0x22

#define RF_SET_PROPERTY_MODEM_RAW_SEARCH2 0x11, 0x20, 0x01, 0x50, 0x84

#define RF_SET_PROPERTY_MODEM_RAW_CONTROL 0x11, 0x20, 0x01, 0x45, 0x83

#define RF_SET_PROPERTY_MODEM_RAW_EYE 0x11, 0x20, 0x02, 0x46, 0x01, 0x00

#define RF_SET_PROPERTY_MODEM_ANT_DIV_MODE 0x11, 0x20, 0x01, 0x48, 0x01

#define RF_SET_PROPERTY_MODEM_ANT_DIV_CONTROL 0x11, 0x20, 0x01, 0x49, 0x00

#define RF_SET_PROPERTY_MODEM_RSSI_JUMP_THRESH 0x11, 0x20, 0x01, 0x4B, 0x06

#define RF_SET_PROPERTY_MODEM_RSSI_CONTROL 0x11, 0x20, 0x01, 0x4C, 0x09

#define RF_SET_PROPERTY_MODEM_RSSI_CONTROL2 0x11, 0x20, 0x01, 0x4D, 0x18

#define RF_SET_PROPERTY_MODEM_RSSI_COMP 0x11, 0x20, 0x01, 0x4E, 0x40

#define RF_SET_PROPERTY_MODEM_CHFLT_RX1_CHFLT_COE_0 0x11, 0x21, 0x0C, 0x00, 0xCC, 0xA1, 0x30, 0xA0, 0x21, 0xD1, 0xB9, 0xC9, 0xEA, 0x05, 0x12, 0x11

#define RF_SET_PROPERTY_MODEM_CHFLT_RX1_CHFLT_COE_1 0x11, 0x21, 0x06, 0x0C, 0x0A, 0x04, 0x15, 0xFC, 0x03, 0x00

#define RF_SET_PROPERTY_MODEM_CHFLT_RX2_CHFLT_COE_0 0x11, 0x21, 0x0C, 0x12, 0xCC, 0xA1, 0x30, 0xA0, 0x21, 0xD1, 0xB9, 0xC9, 0xEA, 0x05, 0x12, 0x11

#define RF_SET_PROPERTY_MODEM_CHFLT_RX2_CHFLT_COE_1 0x11, 0x21, 0x06, 0x1E, 0x0A, 0x04, 0x15, 0xFC, 0x03, 0x00

#define RF_SET_PROPERTY_MODEM_SPIKE_DET 0x11, 0x20, 0x01, 0x54, 0x03

#define RF_SET_PROPERTY_MODEM_DSA_CTRL1 0x11, 0x20, 0x01, 0x5B, 0x40

#define RF_SET_PROPERTY_MODEM_DSA_CTRL2 0x11, 0x20, 0x01, 0x5C, 0x04

#define RF_SET_PROPERTY_MODEM_ONE_SHOT_AFC 0x11, 0x20, 0x01, 0x55, 0x07

#define RF_SET_PROPERTY_MODEM_DSA_QUAL 0x11, 0x20, 0x01, 0x5D, 0x09

#define RF_SET_PROPERTY_MODEM_DSA_RSSI 0x11, 0x20, 0x01, 0x5E, 0x78

#define RF_SET_PROPERTY_MODEM_DECIMATION_CFG2 0x11, 0x20, 0x01, 0x20, 0x00

#define RF_SET_PROPERTY_MODEM_RSSI_MUTE 0x11, 0x20, 0x01, 0x57, 0x00

#define RF_SET_PROPERTY_MODEM_DSA_MISC 0x11, 0x20, 0x01, 0x5F, 0x20

#define RF_SET_PROPERTY_GLOBAL_CLK_CFG 0x11, 0x00, 0x01, 0x01, 0x00

#define RF_SET_PROPERTY_GLOBAL_CONFIG 0x11, 0x00, 0x01, 0x03, 0x20

#define RF_SET_PROPERTY_GLOBAL_WUT_CONFIG 0x11, 0x00, 0x01, 0x04, 0x00

#define RF_SET_PROPERTY_GLOBAL_WUT_M 0x11, 0x00, 0x02, 0x05, 0x00, 0x01

#define RF_SET_PROPERTY_GLOBAL_WUT_R 0x11, 0x00, 0x01, 0x07, 0x60

#define RF_SET_PROPERTY_GLOBAL_WUT_LDC 0x11, 0x00, 0x01, 0x08, 0x01

#define RF_SET_PROPERTY_GLOBAL_BUFCLK_CFG 0x11, 0x00, 0x01, 0x0A, 0x00

#define RF_SET_PROPERTY_RX_HOP_CONTROL 0x11, 0x50, 0x01, 0x00, 0x04

#define RF_SET_PROPERTY_RX_HOP_TABLE_SIZE 0x11, 0x50, 0x01, 0x01, 0x01

#define RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_0 0x11, 0x50, 0x01, 0x02, 0x00

#define RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_1 0x11, 0x50, 0x01, 0x03, 0x01

#define RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_2 0x11, 0x50, 0x01, 0x04, 0x02

#define RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_3 0x11, 0x50, 0x01, 0x05, 0x03

#define RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_4 0x11, 0x50, 0x01, 0x06, 0x04

#define RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_5 0x11, 0x50, 0x01, 0x07, 0x05

#define RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_6 0x11, 0x50, 0x01, 0x08, 0x06

#define RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_7 0x11, 0x50, 0x01, 0x09, 0x07

#define RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_8 0x11, 0x50, 0x01, 0x0A, 0x08

#define RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_9 0x11, 0x50, 0x01, 0x0B, 0x09

#define RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_10 0x11, 0x50, 0x01, 0x0C, 0x0A

#define RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_11 0x11, 0x50, 0x01, 0x0D, 0x0B

#define RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_12 0x11, 0x50, 0x01, 0x0E, 0x0C

#define RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_13 0x11, 0x50, 0x01, 0x0F, 0x0D

#define RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_14 0x11, 0x50, 0x01, 0x10, 0x0E

#define RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_15 0x11, 0x50, 0x01, 0x11, 0x0F

#define RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_16 0x11, 0x50, 0x01, 0x12, 0x10

#define RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_17 0x11, 0x50, 0x01, 0x13, 0x11

#define RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_18 0x11, 0x50, 0x01, 0x14, 0x12

#define RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_19 0x11, 0x50, 0x01, 0x15, 0x13

#define RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_20 0x11, 0x50, 0x01, 0x16, 0x14

#define RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_21 0x11, 0x50, 0x01, 0x17, 0x15

#define RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_22 0x11, 0x50, 0x01, 0x18, 0x16

#define RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_23 0x11, 0x50, 0x01, 0x19, 0x17

#define RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_24 0x11, 0x50, 0x01, 0x1A, 0x18

#define RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_25 0x11, 0x50, 0x01, 0x1B, 0x19

#define RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_26 0x11, 0x50, 0x01, 0x1C, 0x1A

#define RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_27 0x11, 0x50, 0x01, 0x1D, 0x1B

#define RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_28 0x11, 0x50, 0x01, 0x1E, 0x1C

#define RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_29 0x11, 0x50, 0x01, 0x1F, 0x1D

#define RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_30 0x11, 0x50, 0x01, 0x20, 0x1E

#define RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_31 0x11, 0x50, 0x01, 0x21, 0x1F

#define RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_32 0x11, 0x50, 0x01, 0x22, 0x20

#define RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_33 0x11, 0x50, 0x01, 0x23, 0x21

#define RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_34 0x11, 0x50, 0x01, 0x24, 0x22

#define RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_35 0x11, 0x50, 0x01, 0x25, 0x23

#define RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_36 0x11, 0x50, 0x01, 0x26, 0x24

#define RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_37 0x11, 0x50, 0x01, 0x27, 0x25

#define RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_38 0x11, 0x50, 0x01, 0x28, 0x26

#define RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_39 0x11, 0x50, 0x01, 0x29, 0x27

#define RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_40 0x11, 0x50, 0x01, 0x2A, 0x28

#define RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_41 0x11, 0x50, 0x01, 0x2B, 0x29

#define RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_42 0x11, 0x50, 0x01, 0x2C, 0x2A

#define RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_43 0x11, 0x50, 0x01, 0x2D, 0x2B

#define RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_44 0x11, 0x50, 0x01, 0x2E, 0x2C

#define RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_45 0x11, 0x50, 0x01, 0x2F, 0x2D

#define RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_46 0x11, 0x50, 0x01, 0x30, 0x2E

#define RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_47 0x11, 0x50, 0x01, 0x31, 0x2F

#define RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_48 0x11, 0x50, 0x01, 0x32, 0x30

#define RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_49 0x11, 0x50, 0x01, 0x33, 0x31

#define RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_50 0x11, 0x50, 0x01, 0x34, 0x32

#define RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_51 0x11, 0x50, 0x01, 0x35, 0x33

#define RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_52 0x11, 0x50, 0x01, 0x36, 0x34

#define RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_53 0x11, 0x50, 0x01, 0x37, 0x35

#define RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_54 0x11, 0x50, 0x01, 0x38, 0x36

#define RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_55 0x11, 0x50, 0x01, 0x39, 0x37

#define RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_56 0x11, 0x50, 0x01, 0x3A, 0x38

#define RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_57 0x11, 0x50, 0x01, 0x3B, 0x39

#define RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_58 0x11, 0x50, 0x01, 0x3C, 0x3A

#define RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_59 0x11, 0x50, 0x01, 0x3D, 0x3B

#define RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_60 0x11, 0x50, 0x01, 0x3E, 0x3C

#define RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_61 0x11, 0x50, 0x01, 0x3F, 0x3D

#define RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_62 0x11, 0x50, 0x01, 0x40, 0x3E

#define RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_63 0x11, 0x50, 0x01, 0x41, 0x3F



#ifndef FIRMWARE_LOAD_COMPILE

#define RADIO_CONFIGURATION_DATA_ARRAY {\
  7, RF_POWER_UP, \
  8, RF_GPIO_PIN_CFG, \
  5, RF_SET_PROPERTY_GLOBAL_XO_TUNE, \
  5, RF_SET_PROPERTY_FRR_CTL_A_MODE, \
  5, RF_SET_PROPERTY_FRR_CTL_B_MODE, \
  5, RF_SET_PROPERTY_FRR_CTL_C_MODE, \
  5, RF_SET_PROPERTY_FRR_CTL_D_MODE, \
  5, RF_SET_PROPERTY_INT_CTL_ENABLE, \
  5, RF_SET_PROPERTY_INT_CTL_PH_ENABLE, \
  5, RF_SET_PROPERTY_INT_CTL_MODEM_ENABLE, \
  5, RF_SET_PROPERTY_INT_CTL_CHIP_ENABLE, \
  5, RF_SET_PROPERTY_PA_MODE, \
  5, RF_SET_PROPERTY_PA_PWR_LVL, \
  5, RF_SET_PROPERTY_PA_BIAS_CLKDUTY, \
  5, RF_SET_PROPERTY_PA_RAMP_EX, \
  5, RF_SET_PROPERTY_PA_RAMP_DOWN_DELAY, \
  5, RF_SET_PROPERTY_PA_DIG_PWR_SEQ_CONFIG, \
  5, RF_SET_PROPERTY_PREAMBLE_TX_LENGTH, \
  5, RF_SET_PROPERTY_PREAMBLE_CONFIG_STD_1, \
  5, RF_SET_PROPERTY_PREAMBLE_CONFIG_NSTD, \
  5, RF_SET_PROPERTY_PREAMBLE_CONFIG_STD_2, \
  5, RF_SET_PROPERTY_PREAMBLE_CONFIG, \
  8, RF_SET_PROPERTY_PREAMBLE_PATTERN, \
  5, RF_SET_PROPERTY_PREAMBLE_POSTAMBLE_CONFIG, \
  8, RF_SET_PROPERTY_PREAMBLE_POSTAMBLE_PATTERN, \
  5, RF_SET_PROPERTY_SYNC_CONFIG, \
  8, RF_SET_PROPERTY_SYNC_BITS, \
  5, RF_SET_PROPERTY_SYNC_CONFIG2, \
  8, RF_SET_PROPERTY_SYNC_BITS2, \
  5, RF_SET_PROPERTY_PKT_CRC_CONFIG, \
  6, RF_SET_PROPERTY_PKT_WHT_POLY, \
  6, RF_SET_PROPERTY_PKT_WHT_SEED, \
  5, RF_SET_PROPERTY_PKT_WHT_BIT_NUM, \
  5, RF_SET_PROPERTY_PKT_CONFIG1, \
  5, RF_SET_PROPERTY_PKT_CONFIG2, \
  5, RF_SET_PROPERTY_PKT_LEN, \
  5, RF_SET_PROPERTY_PKT_LEN_FIELD_SOURCE, \
  5, RF_SET_PROPERTY_PKT_LEN_ADJUST, \
  5, RF_SET_PROPERTY_PKT_TX_THRESHOLD, \
  5, RF_SET_PROPERTY_PKT_RX_THRESHOLD, \
  6, RF_SET_PROPERTY_PKT_FIELD_1_LENGTH, \
  5, RF_SET_PROPERTY_PKT_FIELD_1_CONFIG, \
  5, RF_SET_PROPERTY_PKT_FIELD_1_CRC_CONFIG, \
  6, RF_SET_PROPERTY_PKT_FIELD_2_LENGTH, \
  5, RF_SET_PROPERTY_PKT_FIELD_2_CONFIG, \
  5, RF_SET_PROPERTY_PKT_FIELD_2_CRC_CONFIG, \
  6, RF_SET_PROPERTY_PKT_FIELD_3_LENGTH, \
  5, RF_SET_PROPERTY_PKT_FIELD_3_CONFIG, \
  5, RF_SET_PROPERTY_PKT_FIELD_3_CRC_CONFIG, \
  6, RF_SET_PROPERTY_PKT_FIELD_4_LENGTH, \
  5, RF_SET_PROPERTY_PKT_FIELD_4_CONFIG, \
  5, RF_SET_PROPERTY_PKT_FIELD_4_CRC_CONFIG, \
  6, RF_SET_PROPERTY_PKT_FIELD_5_LENGTH, \
  5, RF_SET_PROPERTY_PKT_FIELD_5_CONFIG, \
  5, RF_SET_PROPERTY_PKT_FIELD_5_CRC_CONFIG, \
  6, RF_SET_PROPERTY_PKT_RX_FIELD_1_LENGTH, \
  5, RF_SET_PROPERTY_PKT_RX_FIELD_1_CONFIG, \
  5, RF_SET_PROPERTY_PKT_RX_FIELD_1_CRC_CONFIG, \
  6, RF_SET_PROPERTY_PKT_RX_FIELD_2_LENGTH, \
  5, RF_SET_PROPERTY_PKT_RX_FIELD_2_CONFIG, \
  5, RF_SET_PROPERTY_PKT_RX_FIELD_2_CRC_CONFIG, \
  6, RF_SET_PROPERTY_PKT_RX_FIELD_3_LENGTH, \
  5, RF_SET_PROPERTY_PKT_RX_FIELD_3_CONFIG, \
  5, RF_SET_PROPERTY_PKT_RX_FIELD_3_CRC_CONFIG, \
  6, RF_SET_PROPERTY_PKT_RX_FIELD_4_LENGTH, \
  5, RF_SET_PROPERTY_PKT_RX_FIELD_4_CONFIG, \
  5, RF_SET_PROPERTY_PKT_RX_FIELD_4_CRC_CONFIG, \
  6, RF_SET_PROPERTY_PKT_RX_FIELD_5_LENGTH, \
  5, RF_SET_PROPERTY_PKT_RX_FIELD_5_CONFIG, \
  5, RF_SET_PROPERTY_PKT_RX_FIELD_5_CRC_CONFIG, \
  8, RF_SET_PROPERTY_PKT_CRC_SEED, \
  5, RF_SET_PROPERTY_MATCH_VALUE_1, \
  5, RF_SET_PROPERTY_MATCH_MASK_1, \
  5, RF_SET_PROPERTY_MATCH_CTRL_1, \
  5, RF_SET_PROPERTY_MATCH_VALUE_2, \
  5, RF_SET_PROPERTY_MATCH_MASK_2, \
  5, RF_SET_PROPERTY_MATCH_CTRL_2, \
  5, RF_SET_PROPERTY_MATCH_VALUE_3, \
  5, RF_SET_PROPERTY_MATCH_MASK_3, \
  5, RF_SET_PROPERTY_MATCH_CTRL_3, \
  5, RF_SET_PROPERTY_MATCH_VALUE_4, \
  5, RF_SET_PROPERTY_MATCH_MASK_4, \
  5, RF_SET_PROPERTY_MATCH_CTRL_4, \
  5, RF_SET_PROPERTY_MODEM_MOD_TYPE, \
  5, RF_SET_PROPERTY_MODEM_MAP_CONTROL, \
  5, RF_SET_PROPERTY_MODEM_DSM_CTRL, \
  5, RF_SET_PROPERTY_MODEM_CLKGEN_BAND, \
  5, RF_SET_PROPERTY_SYNTH_PFDCP_CPFF, \
  5, RF_SET_PROPERTY_SYNTH_PFDCP_CPINT, \
  5, RF_SET_PROPERTY_SYNTH_VCO_KV, \
  5, RF_SET_PROPERTY_SYNTH_LPFILT3, \
  5, RF_SET_PROPERTY_SYNTH_LPFILT2, \
  5, RF_SET_PROPERTY_SYNTH_LPFILT1, \
  5, RF_SET_PROPERTY_SYNTH_LPFILT0, \
  7, RF_SET_PROPERTY_MODEM_DATA_RATE, \
  8, RF_SET_PROPERTY_MODEM_TX_NCO_MODE, \
  7, RF_SET_PROPERTY_MODEM_FREQ_DEV, \
  5, RF_SET_PROPERTY_MODEM_TX_RAMP_DELAY, \
  5, RF_SET_PROPERTY_PA_TC, \
  5, RF_SET_PROPERTY_FREQ_CONTROL_INTE, \
  7, RF_SET_PROPERTY_FREQ_CONTROL_FRAC, \
  6, RF_SET_PROPERTY_FREQ_CONTROL_CHANNEL_STEP_SIZE, \
  5, RF_SET_PROPERTY_FREQ_CONTROL_W_SIZE, \
  5, RF_SET_PROPERTY_FREQ_CONTROL_VCOCNT_RX_ADJ, \
  5, RF_SET_PROPERTY_MODEM_MDM_CTRL, \
  5, RF_SET_PROPERTY_MODEM_IF_CONTROL, \
  7, RF_SET_PROPERTY_MODEM_IF_FREQ, \
  5, RF_SET_PROPERTY_MODEM_DECIMATION_CFG1, \
  5, RF_SET_PROPERTY_MODEM_DECIMATION_CFG0, \
  6, RF_SET_PROPERTY_MODEM_BCR_OSR, \
  7, RF_SET_PROPERTY_MODEM_BCR_NCO_OFFSET, \
  6, RF_SET_PROPERTY_MODEM_BCR_GAIN, \
  5, RF_SET_PROPERTY_MODEM_BCR_GEAR, \
  5, RF_SET_PROPERTY_MODEM_BCR_MISC0, \
  5, RF_SET_PROPERTY_MODEM_BCR_MISC1, \
  5, RF_SET_PROPERTY_MODEM_AFC_GEAR, \
  5, RF_SET_PROPERTY_MODEM_AFC_WAIT, \
  6, RF_SET_PROPERTY_MODEM_AFC_GAIN, \
  6, RF_SET_PROPERTY_MODEM_AFC_LIMITER, \
  5, RF_SET_PROPERTY_MODEM_AFC_MISC, \
  5, RF_SET_PROPERTY_MODEM_AGC_CONTROL, \
  5, RF_SET_PROPERTY_MODEM_AGC_WINDOW_SIZE, \
  5, RF_SET_PROPERTY_MODEM_AGC_RFPD_DECAY, \
  5, RF_SET_PROPERTY_MODEM_AGC_IFPD_DECAY, \
  5, RF_SET_PROPERTY_MODEM_FSK4_GAIN1, \
  5, RF_SET_PROPERTY_MODEM_FSK4_GAIN0, \
  6, RF_SET_PROPERTY_MODEM_FSK4_TH, \
  5, RF_SET_PROPERTY_MODEM_FSK4_MAP, \
  5, RF_SET_PROPERTY_MODEM_OOK_PDTC, \
  5, RF_SET_PROPERTY_MODEM_OOK_BLOPK, \
  5, RF_SET_PROPERTY_MODEM_OOK_CNT1, \
  5, RF_SET_PROPERTY_MODEM_OOK_MISC, \
  5, RF_SET_PROPERTY_MODEM_RAW_SEARCH2, \
  5, RF_SET_PROPERTY_MODEM_RAW_CONTROL, \
  6, RF_SET_PROPERTY_MODEM_RAW_EYE, \
  5, RF_SET_PROPERTY_MODEM_ANT_DIV_MODE, \
  5, RF_SET_PROPERTY_MODEM_ANT_DIV_CONTROL, \
  5, RF_SET_PROPERTY_MODEM_RSSI_JUMP_THRESH, \
  5, RF_SET_PROPERTY_MODEM_RSSI_CONTROL, \
  5, RF_SET_PROPERTY_MODEM_RSSI_CONTROL2, \
  5, RF_SET_PROPERTY_MODEM_RSSI_COMP, \
  16, RF_SET_PROPERTY_MODEM_CHFLT_RX1_CHFLT_COE_0, \
  10, RF_SET_PROPERTY_MODEM_CHFLT_RX1_CHFLT_COE_1, \
  16, RF_SET_PROPERTY_MODEM_CHFLT_RX2_CHFLT_COE_0, \
  10, RF_SET_PROPERTY_MODEM_CHFLT_RX2_CHFLT_COE_1, \
  5, RF_SET_PROPERTY_MODEM_SPIKE_DET, \
  5, RF_SET_PROPERTY_MODEM_DSA_CTRL1, \
  5, RF_SET_PROPERTY_MODEM_DSA_CTRL2, \
  5, RF_SET_PROPERTY_MODEM_ONE_SHOT_AFC, \
  5, RF_SET_PROPERTY_MODEM_DSA_QUAL, \
  5, RF_SET_PROPERTY_MODEM_DSA_RSSI, \
  5, RF_SET_PROPERTY_MODEM_DECIMATION_CFG2, \
  5, RF_SET_PROPERTY_MODEM_RSSI_MUTE, \
  5, RF_SET_PROPERTY_MODEM_DSA_MISC, \
  5, RF_SET_PROPERTY_GLOBAL_CLK_CFG, \
  5, RF_SET_PROPERTY_GLOBAL_CONFIG, \
  5, RF_SET_PROPERTY_GLOBAL_WUT_CONFIG, \
  6, RF_SET_PROPERTY_GLOBAL_WUT_M, \
  5, RF_SET_PROPERTY_GLOBAL_WUT_R, \
  5, RF_SET_PROPERTY_GLOBAL_WUT_LDC, \
  5, RF_SET_PROPERTY_GLOBAL_BUFCLK_CFG, \
  5, RF_SET_PROPERTY_RX_HOP_CONTROL, \
  5, RF_SET_PROPERTY_RX_HOP_TABLE_SIZE, \
  5, RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_0, \
  5, RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_1, \
  5, RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_2, \
  5, RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_3, \
  5, RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_4, \
  5, RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_5, \
  5, RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_6, \
  5, RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_7, \
  5, RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_8, \
  5, RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_9, \
  5, RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_10, \
  5, RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_11, \
  5, RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_12, \
  5, RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_13, \
  5, RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_14, \
  5, RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_15, \
  5, RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_16, \
  5, RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_17, \
  5, RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_18, \
  5, RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_19, \
  5, RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_20, \
  5, RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_21, \
  5, RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_22, \
  5, RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_23, \
  5, RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_24, \
  5, RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_25, \
  5, RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_26, \
  5, RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_27, \
  5, RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_28, \
  5, RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_29, \
  5, RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_30, \
  5, RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_31, \
  5, RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_32, \
  5, RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_33, \
  5, RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_34, \
  5, RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_35, \
  5, RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_36, \
  5, RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_37, \
  5, RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_38, \
  5, RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_39, \
  5, RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_40, \
  5, RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_41, \
  5, RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_42, \
  5, RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_43, \
  5, RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_44, \
  5, RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_45, \
  5, RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_46, \
  5, RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_47, \
  5, RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_48, \
  5, RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_49, \
  5, RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_50, \
  5, RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_51, \
  5, RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_52, \
  5, RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_53, \
  5, RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_54, \
  5, RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_55, \
  5, RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_56, \
  5, RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_57, \
  5, RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_58, \
  5, RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_59, \
  5, RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_60, \
  5, RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_61, \
  5, RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_62, \
  5, RF_SET_PROPERTY_RX_HOP_TABLE_ENTRY_63, \
  0 \
  }

#else // ! FIRMWARE_LOAD_COMPILE

#define RADIO_CONFIGURATION_DATA_ARRAY { 0 }

#endif // FIRMWARE_LOAD_COMPILE


#define RADIO_CONFIGURATION_DATA_BASE_FREQUENCY 915000000
#define RADIO_CONFIGURATION_DATA_BIT_ORDER FALSE
#define RADIO_CONFIGURATION_DATA_CENTER_FREQUENCY 915000000
#define RADIO_CONFIGURATION_DATA_CHANNEL_NUMBER 0
#define RADIO_CONFIGURATION_DATA_CHANNEL_SPACING 250000
#define RADIO_CONFIGURATION_DATA_CHECK_CRC_0 FALSE
#define RADIO_CONFIGURATION_DATA_CHECK_CRC_1 TRUE
#define RADIO_CONFIGURATION_DATA_CHECK_CRC_2 FALSE
#define RADIO_CONFIGURATION_DATA_CHECK_CRC_3 FALSE
#define RADIO_CONFIGURATION_DATA_CHECK_CRC_4 FALSE
#define RADIO_CONFIGURATION_DATA_CHIP_HW_INTERRUPT 0
#define RADIO_CONFIGURATION_DATA_CRC_PADDING FALSE
#define RADIO_CONFIGURATION_DATA_CRC_START TRUE
#define RADIO_CONFIGURATION_DATA_CRYSTAL_CAP_BANK 69
#define RADIO_CONFIGURATION_DATA_CRYSTAL_FREQUENCY 30000000
#define RADIO_CONFIGURATION_DATA_CRYSTAL_TOLERANCE_RX 20
#define RADIO_CONFIGURATION_DATA_CRYSTAL_TOLERANCE_TX 20
#define RADIO_CONFIGURATION_DATA_CRYSTAL_USE_EXTERNAL_SOURCE FALSE
#define RADIO_CONFIGURATION_DATA_DRIVE_STRENGTH 0
#define RADIO_CONFIGURATION_DATA_ENABLE_CHIP_HW_INTERRUPT FALSE
#define RADIO_CONFIGURATION_DATA_ENABLE_CRC_0 TRUE
#define RADIO_CONFIGURATION_DATA_ENABLE_CRC_1 TRUE
#define RADIO_CONFIGURATION_DATA_ENABLE_CRC_2 FALSE
#define RADIO_CONFIGURATION_DATA_ENABLE_CRC_3 FALSE
#define RADIO_CONFIGURATION_DATA_ENABLE_CRC_4 FALSE
#define RADIO_CONFIGURATION_DATA_ENABLE_MODEM_HW_INTERRUPT FALSE
#define RADIO_CONFIGURATION_DATA_ENABLE_PACKET_HANDELR_HW_INTERRUPT FALSE
#define RADIO_CONFIGURATION_DATA_FLD_CRC_BITORDER 0
#define RADIO_CONFIGURATION_DATA_FLD_CRC_ENDIAN 0
#define RADIO_CONFIGURATION_DATA_FLD_INVERT_CRC FALSE
#define RADIO_CONFIGURATION_DATA_FLD_MANCHESTER_PATTERN 0
#define RADIO_CONFIGURATION_DATA_FLD_MODEM_4GFSK_MODE FALSE
#define RADIO_CONFIGURATION_DATA_FRR_CTL_A_MODE 1
#define RADIO_CONFIGURATION_DATA_FRR_CTL_B_MODE 2
#define RADIO_CONFIGURATION_DATA_FRR_CTL_C_MODE 9
#define RADIO_CONFIGURATION_DATA_FRR_CTL_D_MODE 0
#define RADIO_CONFIGURATION_DATA_GPIO0 0
#define RADIO_CONFIGURATION_DATA_GPIO0_PULLUP FALSE
#define RADIO_CONFIGURATION_DATA_GPIO1 0
#define RADIO_CONFIGURATION_DATA_GPIO1_PULLUP FALSE
#define RADIO_CONFIGURATION_DATA_GPIO2 32
#define RADIO_CONFIGURATION_DATA_GPIO2_PULLUP FALSE
#define RADIO_CONFIGURATION_DATA_GPIO3 33
#define RADIO_CONFIGURATION_DATA_GPIO3_PULLUP FALSE
#define RADIO_CONFIGURATION_DATA_HOP_ENABLE 0
#define RADIO_CONFIGURATION_DATA_HOP_PREAMBLE_TIMEOUT 20
#define RADIO_CONFIGURATION_DATA_HOP_RSSI_TIMEOUT 10
#define RADIO_CONFIGURATION_DATA_HOP_TABLE 
#define RADIO_CONFIGURATION_DATA_HOP_TYPE MANUAL_FREQUENCY_HOP
#define RADIO_CONFIGURATION_DATA_LDC_RX_TIME_ADJUST 1
#define RADIO_CONFIGURATION_DATA_LDC_SLEEP_TIME_ADJUST 1
#define RADIO_CONFIGURATION_DATA_LDC_STEP_SIZE_ADJUST 0
#define RADIO_CONFIGURATION_DATA_LENGTH_SUB 0
#define RADIO_CONFIGURATION_DATA_MATCH_BYTES 0
#define RADIO_CONFIGURATION_DATA_MATCH_LOGIC_1 AND
#define RADIO_CONFIGURATION_DATA_MATCH_LOGIC_2 AND
#define RADIO_CONFIGURATION_DATA_MATCH_LOGIC_3 AND
#define RADIO_CONFIGURATION_DATA_MATCH_MASK_0 00
#define RADIO_CONFIGURATION_DATA_MATCH_MASK_1 00
#define RADIO_CONFIGURATION_DATA_MATCH_MASK_2 00
#define RADIO_CONFIGURATION_DATA_MATCH_MASK_3 00
#define RADIO_CONFIGURATION_DATA_MATCH_OFFSET_0 0
#define RADIO_CONFIGURATION_DATA_MATCH_OFFSET_1 0
#define RADIO_CONFIGURATION_DATA_MATCH_OFFSET_2 0
#define RADIO_CONFIGURATION_DATA_MATCH_OFFSET_3 0
#define RADIO_CONFIGURATION_DATA_MATCH_POLARITY_0 MATCH
#define RADIO_CONFIGURATION_DATA_MATCH_POLARITY_1 MATCH
#define RADIO_CONFIGURATION_DATA_MATCH_POLARITY_2 MATCH
#define RADIO_CONFIGURATION_DATA_MATCH_POLARITY_3 MATCH
#define RADIO_CONFIGURATION_DATA_MATCH_VALUE_0 00
#define RADIO_CONFIGURATION_DATA_MATCH_VALUE_1 00
#define RADIO_CONFIGURATION_DATA_MATCH_VALUE_2 00
#define RADIO_CONFIGURATION_DATA_MATCH_VALUE_3 00
#define RADIO_CONFIGURATION_DATA_MODEM_HW_INTERRUPT 0
#define RADIO_CONFIGURATION_DATA_NIRQ 0
#define RADIO_CONFIGURATION_DATA_NIRQ_PULLUP FALSE
#define RADIO_CONFIGURATION_DATA_PACKET_HANDELR_HW_INTERRUPT 0
#define RADIO_CONFIGURATION_DATA_PH_FIELD_SPLIT FALSE
#define RADIO_CONFIGURATION_DATA_PKT_ALLOW_BIT_ERR 0
#define RADIO_CONFIGURATION_DATA_PKT_CRC_POLY 4
#define RADIO_CONFIGURATION_DATA_PKT_CRC_SEED 0
#define RADIO_CONFIGURATION_DATA_PKT_DATA_WHITENING_SEED FF FF
#define RADIO_CONFIGURATION_DATA_PKT_ENABLE_PREAMBLE TRUE
#define RADIO_CONFIGURATION_DATA_PKT_FIELD_4GFSK_0 FALSE
#define RADIO_CONFIGURATION_DATA_PKT_FIELD_4GFSK_1 FALSE
#define RADIO_CONFIGURATION_DATA_PKT_FIELD_4GFSK_2 FALSE
#define RADIO_CONFIGURATION_DATA_PKT_FIELD_4GFSK_3 FALSE
#define RADIO_CONFIGURATION_DATA_PKT_FIELD_4GFSK_4 FALSE
#define RADIO_CONFIGURATION_DATA_PKT_FIELD_CONTAINING_LENGTH 1
#define RADIO_CONFIGURATION_DATA_PKT_FIELD_LENGTH_0 1
#define RADIO_CONFIGURATION_DATA_PKT_FIELD_LENGTH_1 8
#define RADIO_CONFIGURATION_DATA_PKT_FIELD_LENGTH_2 0
#define RADIO_CONFIGURATION_DATA_PKT_FIELD_LENGTH_3 0
#define RADIO_CONFIGURATION_DATA_PKT_FIELD_LENGTH_4 0
#define RADIO_CONFIGURATION_DATA_PKT_FIELD_MANCHESTER_0 FALSE
#define RADIO_CONFIGURATION_DATA_PKT_FIELD_MANCHESTER_1 FALSE
#define RADIO_CONFIGURATION_DATA_PKT_FIELD_MANCHESTER_2 FALSE
#define RADIO_CONFIGURATION_DATA_PKT_FIELD_MANCHESTER_3 FALSE
#define RADIO_CONFIGURATION_DATA_PKT_FIELD_MANCHESTER_4 FALSE
#define RADIO_CONFIGURATION_DATA_PKT_FIELD_WHITEN_0 FALSE
#define RADIO_CONFIGURATION_DATA_PKT_FIELD_WHITEN_1 FALSE
#define RADIO_CONFIGURATION_DATA_PKT_FIELD_WHITEN_2 FALSE
#define RADIO_CONFIGURATION_DATA_PKT_FIELD_WHITEN_3 FALSE
#define RADIO_CONFIGURATION_DATA_PKT_FIELD_WHITEN_4 FALSE
#define RADIO_CONFIGURATION_DATA_PKT_LENGTH_ADJUST 0
#define RADIO_CONFIGURATION_DATA_PKT_LENGTH_SIZE 1
#define RADIO_CONFIGURATION_DATA_PKT_LEN_ADD_TO_RX_FIFO TRUE
#define RADIO_CONFIGURATION_DATA_PKT_LEN_IN_MSB TRUE
#define RADIO_CONFIGURATION_DATA_PKT_NUMBER_OF_FIELDS 2
#define RADIO_CONFIGURATION_DATA_PKT_NUMBER_OF_RX_FIELDS 1
#define RADIO_CONFIGURATION_DATA_PKT_PREAMBLE_EXTENDED_TIMEOUT 0
#define RADIO_CONFIGURATION_DATA_PKT_PREAMBLE_MANCHESTER_CONSTANT FALSE
#define RADIO_CONFIGURATION_DATA_PKT_PREAMBLE_MANCHESTER_ENABLED FALSE
#define RADIO_CONFIGURATION_DATA_PKT_PREAMBLE_NONE_STANDARD 00 00 00 00
#define RADIO_CONFIGURATION_DATA_PKT_PREAMBLE_PATTERN 1
#define RADIO_CONFIGURATION_DATA_PKT_PREAMBLE_PATTERN_LENGTH 0
#define RADIO_CONFIGURATION_DATA_PKT_PREAMBLE_RX_BIT_ERROR 0
#define RADIO_CONFIGURATION_DATA_PKT_PREAMBLE_RX_THRESHOLD 20
#define RADIO_CONFIGURATION_DATA_PKT_PREAMBLE_TIMEOUT 15
#define RADIO_CONFIGURATION_DATA_PKT_PREAMBLE_TX_LENGTH 8
#define RADIO_CONFIGURATION_DATA_PKT_RESET_DATAWHITENING FALSE
#define RADIO_CONFIGURATION_DATA_PKT_RX_FIELD_4GFSK_0 FALSE
#define RADIO_CONFIGURATION_DATA_PKT_RX_FIELD_4GFSK_1 FALSE
#define RADIO_CONFIGURATION_DATA_PKT_RX_FIELD_4GFSK_2 FALSE
#define RADIO_CONFIGURATION_DATA_PKT_RX_FIELD_4GFSK_3 FALSE
#define RADIO_CONFIGURATION_DATA_PKT_RX_FIELD_4GFSK_4 FALSE
#define RADIO_CONFIGURATION_DATA_PKT_RX_FIELD_LENGTH_0 0
#define RADIO_CONFIGURATION_DATA_PKT_RX_FIELD_LENGTH_1 0
#define RADIO_CONFIGURATION_DATA_PKT_RX_FIELD_LENGTH_2 0
#define RADIO_CONFIGURATION_DATA_PKT_RX_FIELD_LENGTH_3 0
#define RADIO_CONFIGURATION_DATA_PKT_RX_FIELD_LENGTH_4 0
#define RADIO_CONFIGURATION_DATA_PKT_RX_FIELD_MANCHESTER_0 FALSE
#define RADIO_CONFIGURATION_DATA_PKT_RX_FIELD_MANCHESTER_1 FALSE
#define RADIO_CONFIGURATION_DATA_PKT_RX_FIELD_MANCHESTER_2 FALSE
#define RADIO_CONFIGURATION_DATA_PKT_RX_FIELD_MANCHESTER_3 FALSE
#define RADIO_CONFIGURATION_DATA_PKT_RX_FIELD_MANCHESTER_4 FALSE
#define RADIO_CONFIGURATION_DATA_PKT_RX_FIELD_WHITEN_0 FALSE
#define RADIO_CONFIGURATION_DATA_PKT_RX_FIELD_WHITEN_1 FALSE
#define RADIO_CONFIGURATION_DATA_PKT_RX_FIELD_WHITEN_2 FALSE
#define RADIO_CONFIGURATION_DATA_PKT_RX_FIELD_WHITEN_3 FALSE
#define RADIO_CONFIGURATION_DATA_PKT_RX_FIELD_WHITEN_4 FALSE
#define RADIO_CONFIGURATION_DATA_PKT_RX_THRESHOLD 48
#define RADIO_CONFIGURATION_DATA_PKT_SKIP_SYNCWORD FALSE
#define RADIO_CONFIGURATION_DATA_PKT_SKIP_SYNC_TIMEOUT FALSE
#define RADIO_CONFIGURATION_DATA_PKT_SYNC_4GFSK FALSE
#define RADIO_CONFIGURATION_DATA_PKT_SYNC_LENGTH 2
#define RADIO_CONFIGURATION_DATA_PKT_SYNC_MANCHESTER FALSE
#define RADIO_CONFIGURATION_DATA_PKT_SYNC_WORD 2D D4
#define RADIO_CONFIGURATION_DATA_PKT_SYNC_WORD_API B4 2B
#define RADIO_CONFIGURATION_DATA_PKT_TX_THRESHOLD 48
#define RADIO_CONFIGURATION_DATA_PKT_VARIABLE_LENGTH_FIELD 2
#define RADIO_CONFIGURATION_DATA_PKT_VARIABLE_PACKET_LENGTH_ENABLE FALSE
#define RADIO_CONFIGURATION_DATA_PKT_WHITENING_POLY 1280
#define RADIO_CONFIGURATION_DATA_PN_DIRECTION 1
#define RADIO_CONFIGURATION_DATA_POWER_ENABLE_RAMP_CONTROL FALSE
#define RADIO_CONFIGURATION_DATA_POWER_PA_BIAS 12
#define RADIO_CONFIGURATION_DATA_POWER_PA_MODE 0
#define RADIO_CONFIGURATION_DATA_POWER_PA_POWERLEVEL 127
#define RADIO_CONFIGURATION_DATA_POWER_RAMPING_TIME 14
#define RADIO_CONFIGURATION_DATA_POWER_RAMP_HV 29
#define RADIO_CONFIGURATION_DATA_POWER_REGULATOR_VOLTAGE 15
#define RADIO_CONFIGURATION_DATA_RFPARAM_4GFSK_MAP 0
#define RADIO_CONFIGURATION_DATA_RFPARAM_ADAPTIVE_CHFILL FALSE
#define RADIO_CONFIGURATION_DATA_RFPARAM_BANDWIDTH_TIME 50
#define RADIO_CONFIGURATION_DATA_RFPARAM_BER_MODE FALSE
#define RADIO_CONFIGURATION_DATA_RFPARAM_CHECKTHRESHOLDATLATCH FALSE
#define RADIO_CONFIGURATION_DATA_RFPARAM_DATA_RATE 10000
#define RADIO_CONFIGURATION_DATA_RFPARAM_DEVIATION 20000
#define RADIO_CONFIGURATION_DATA_RFPARAM_DEVIATION_ERROR_NEGATIVE 0
#define RADIO_CONFIGURATION_DATA_RFPARAM_DEVIATION_ERROR_POSITIVE 0
#define RADIO_CONFIGURATION_DATA_RFPARAM_ENABLEANTENNADIVERSITY FALSE
#define RADIO_CONFIGURATION_DATA_RFPARAM_ENABLEIQCALIBRATION FALSE
#define RADIO_CONFIGURATION_DATA_RFPARAM_ENABLE_HIGH_PERFORMANCE_CHANNEL_FILLTER TRUE
#define RADIO_CONFIGURATION_DATA_RFPARAM_ENABLE_MANUAL_RXBANDWIDTH FALSE
#define RADIO_CONFIGURATION_DATA_RFPARAM_ENABLE_PLL_AFC FALSE
#define RADIO_CONFIGURATION_DATA_RFPARAM_IF_MODE 2
#define RADIO_CONFIGURATION_DATA_RFPARAM_MODULATION_MODE DIRECT
#define RADIO_CONFIGURATION_DATA_RFPARAM_MODULATION_TYPE FSK2
#define RADIO_CONFIGURATION_DATA_RFPARAM_OSR_TUNE 0
#define RADIO_CONFIGURATION_DATA_RFPARAM_PREAMBLE_PATTERN 0
#define RADIO_CONFIGURATION_DATA_RFPARAM_RSSI_AVERAGE 0
#define RADIO_CONFIGURATION_DATA_RFPARAM_RSSI_JUMP_THRESHOLD 12
#define RADIO_CONFIGURATION_DATA_RFPARAM_RSSI_LATCH 0
#define RADIO_CONFIGURATION_DATA_RFPARAM_RSSI_THRESHOLD 255
#define RADIO_CONFIGURATION_DATA_RFPARAM_RXBANDWIDTH 150000
#define RADIO_CONFIGURATION_DATA_RFPARAM_RXDATARATEERROR 0
#define RADIO_CONFIGURATION_DATA_RFPARAM_RX_CURRENT 0
#define RADIO_CONFIGURATION_DATA_RFPARAM_RX_PERFORMANCE 0
#define RADIO_CONFIGURATION_DATA_RX_CHECK_CRC_0 FALSE
#define RADIO_CONFIGURATION_DATA_RX_CHECK_CRC_1 FALSE
#define RADIO_CONFIGURATION_DATA_RX_CHECK_CRC_2 FALSE
#define RADIO_CONFIGURATION_DATA_RX_CHECK_CRC_3 FALSE
#define RADIO_CONFIGURATION_DATA_RX_CHECK_CRC_4 FALSE
#define RADIO_CONFIGURATION_DATA_RX_ENABLE_CRC_0 FALSE
#define RADIO_CONFIGURATION_DATA_RX_ENABLE_CRC_1 FALSE
#define RADIO_CONFIGURATION_DATA_RX_ENABLE_CRC_2 FALSE
#define RADIO_CONFIGURATION_DATA_RX_ENABLE_CRC_3 FALSE
#define RADIO_CONFIGURATION_DATA_RX_ENABLE_CRC_4 FALSE
#define RADIO_CONFIGURATION_DATA_SDO 0
#define RADIO_CONFIGURATION_DATA_SDO_PULLUP FALSE
#define RADIO_CONFIGURATION_DATA_SELECTED_CHIP si4468~revision[REVA2A]
#define RADIO_CONFIGURATION_DATA_SW_CRC_CTRL FALSE
#define RADIO_CONFIGURATION_DATA_SW_WHT_CTRL FALSE
#define RADIO_CONFIGURATION_DATA_SYNC_ERROR_ONLY_BEGIN 0
#define RADIO_CONFIGURATION_DATA_SYSCLOCK_32KHZ_CLOCK 0
#define RADIO_CONFIGURATION_DATA_SYSCLOCK_CLOCK_OUTPUT 0
#define RADIO_CONFIGURATION_DATA_SYSCLOCK_ENABLE_DIVIDED_CLOCK_OUTPUT FALSE
#define RADIO_CONFIGURATION_DATA_TRANSMIT_CRC_0 FALSE
#define RADIO_CONFIGURATION_DATA_TRANSMIT_CRC_1 TRUE
#define RADIO_CONFIGURATION_DATA_TRANSMIT_CRC_2 FALSE
#define RADIO_CONFIGURATION_DATA_TRANSMIT_CRC_3 FALSE
#define RADIO_CONFIGURATION_DATA_TRANSMIT_CRC_4 FALSE
#define RADIO_CONFIGURATION_DATA_WHT_BIT_NUM 0


#define RADIO_CONFIG_DATA_FIELD1_LENGTH RADIO_CONFIGURATION_DATA_PKT_FIELD_LENGTH_0
#define RADIO_CONFIG_DATA_FIELD2_LENGTH RADIO_CONFIGURATION_DATA_PKT_FIELD_LENGTH_1
#define RADIO_CONFIG_DATA_FIELD3_LENGTH RADIO_CONFIGURATION_DATA_PKT_FIELD_LENGTH_2
#define RADIO_CONFIG_DATA_FIELD4_LENGTH RADIO_CONFIGURATION_DATA_PKT_FIELD_LENGTH_3
#define RADIO_CONFIG_DATA_FIELD5_LENGTH RADIO_CONFIGURATION_DATA_PKT_FIELD_LENGTH_4


#define RADIO_CONFIGURATION_DATA { \
                                   Radio_Configuration_Data_Array,                       \
                                   RADIO_CONFIGURATION_DATA_CHANNEL_NUMBER,              \
                                   RADIO_CONFIGURATION_DATA_RADIO_PACKET_LENGTH,         \
                                   RADIO_CONFIGURATION_DATA_RADIO_STATE_AFTER_POWER_UP,  \
                                   RADIO_CONFIGURATION_DATA_RADIO_DELAY_CNT_AFTER_RESET, \
                                   RADIO_CONFIGURATION_DATA_VARIABLEPACKETSTATE,         \
                                   RADIO_CONFIGURATION_DATA_CUSTOM_PAYLOAD               \
                                  }

#endif // __SLAB_RADIO_CONFIG_WDS__


//        _  _                          
//       | )/ )         Wireless        
//    \\ |//,' __       Application     
//    (")(_)-"()))=-    Software        
//       (\\            Platform        
