/**************************************************************************//**
 * @file em_device.h
 * @brief CMSIS Cortex-M Peripheral Access Layer for Silicon Laboratories
 *        microcontroller devices
 *
 * This is a convenience header file for defining the part number on the
 * build command line, instead of specifying the part specific header file.
 *
 * @verbatim
 * Example: Add "-DEFM32G890F128" to your build options, to define part
 *          Add "#include "em_device.h" to your source files
 *
 *
 * @endverbatim
 * @version 5.0.0
 ******************************************************************************
 * @section License
 * <b>Copyright 2016 Silicon Laboratories, Inc. http://www.silabs.com</b>
 ******************************************************************************
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must not
 *    claim that you wrote the original software.@n
 * 2. Altered source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.@n
 * 3. This notice may not be removed or altered from any source distribution.
 *
 * DISCLAIMER OF WARRANTY/LIMITATION OF REMEDIES: Silicon Laboratories, Inc.
 * has no obligation to support this Software. Silicon Laboratories, Inc. is
 * providing the Software "AS IS", with no express or implied warranties of any
 * kind, including, but not limited to, any implied warranties of
 * merchantability or fitness for any particular purpose or warranties against
 * infringement of any proprietary rights of a third party.
 *
 * Silicon Laboratories, Inc. will not be liable for any consequential,
 * incidental, or special damages, or any other relief, or for any claim by
 * any third party, arising from your use of this Software.
 *
 *****************************************************************************/

#ifndef EM_DEVICE_H
#define EM_DEVICE_H

#if defined(EZR32WG230F128R55)
#include "ezr32wg230f128r55.h"

#elif defined(EZR32WG230F128R60)
#include "ezr32wg230f128r60.h"

#elif defined(EZR32WG230F128R61)
#include "ezr32wg230f128r61.h"

#elif defined(EZR32WG230F128R63)
#include "ezr32wg230f128r63.h"

#elif defined(EZR32WG230F128R67)
#include "ezr32wg230f128r67.h"

#elif defined(EZR32WG230F128R68)
#include "ezr32wg230f128r68.h"

#elif defined(EZR32WG230F128R69)
#include "ezr32wg230f128r69.h"

#elif defined(EZR32WG230F256R55)
#include "ezr32wg230f256r55.h"

#elif defined(EZR32WG230F256R60)
#include "ezr32wg230f256r60.h"

#elif defined(EZR32WG230F256R61)
#include "ezr32wg230f256r61.h"

#elif defined(EZR32WG230F256R63)
#include "ezr32wg230f256r63.h"

#elif defined(EZR32WG230F256R67)
#include "ezr32wg230f256r67.h"

#elif defined(EZR32WG230F256R68)
#include "ezr32wg230f256r68.h"

#elif defined(EZR32WG230F256R69)
#include "ezr32wg230f256r69.h"

#elif defined(EZR32WG230F64R55)
#include "ezr32wg230f64r55.h"

#elif defined(EZR32WG230F64R60)
#include "ezr32wg230f64r60.h"

#elif defined(EZR32WG230F64R61)
#include "ezr32wg230f64r61.h"

#elif defined(EZR32WG230F64R63)
#include "ezr32wg230f64r63.h"

#elif defined(EZR32WG230F64R67)
#include "ezr32wg230f64r67.h"

#elif defined(EZR32WG230F64R68)
#include "ezr32wg230f64r68.h"

#elif defined(EZR32WG230F64R69)
#include "ezr32wg230f64r69.h"

#elif defined(EZR32WG330F128R55)
#include "ezr32wg330f128r55.h"

#elif defined(EZR32WG330F128R60)
#include "ezr32wg330f128r60.h"

#elif defined(EZR32WG330F128R61)
#include "ezr32wg330f128r61.h"

#elif defined(EZR32WG330F128R63)
#include "ezr32wg330f128r63.h"

#elif defined(EZR32WG330F128R67)
#include "ezr32wg330f128r67.h"

#elif defined(EZR32WG330F128R68)
#include "ezr32wg330f128r68.h"

#elif defined(EZR32WG330F128R69)
#include "ezr32wg330f128r69.h"

#elif defined(EZR32WG330F256R55)
#include "ezr32wg330f256r55.h"

#elif defined(EZR32WG330F256R60)
#include "ezr32wg330f256r60.h"

#elif defined(EZR32WG330F256R61)
#include "ezr32wg330f256r61.h"

#elif defined(EZR32WG330F256R63)
#include "ezr32wg330f256r63.h"

#elif defined(EZR32WG330F256R67)
#include "ezr32wg330f256r67.h"

#elif defined(EZR32WG330F256R68)
#include "ezr32wg330f256r68.h"

#elif defined(EZR32WG330F256R69)
#include "ezr32wg330f256r69.h"

#elif defined(EZR32WG330F64R55)
#include "ezr32wg330f64r55.h"

#elif defined(EZR32WG330F64R60)
#include "ezr32wg330f64r60.h"

#elif defined(EZR32WG330F64R61)
#include "ezr32wg330f64r61.h"

#elif defined(EZR32WG330F64R63)
#include "ezr32wg330f64r63.h"

#elif defined(EZR32WG330F64R67)
#include "ezr32wg330f64r67.h"

#elif defined(EZR32WG330F64R68)
#include "ezr32wg330f64r68.h"

#elif defined(EZR32WG330F64R69)
#include "ezr32wg330f64r69.h"

#else
#error "em_device.h: PART NUMBER undefined"
#endif
#endif /* EM_DEVICE_H */
