 /*************************************************************************//**
 * @file glib_color.h
 * @brief Silicon Labs Graphics Library: Color Defines
 ******************************************************************************
 * @section License
 * <b>Copyright 2015 Silicon Labs, http://www.silabs.com</b>
 *******************************************************************************
 *
 * This file is licensensed under the Silabs License Agreement. See the file
 * "Silabs_License_Agreement.txt" for details. Before using this software for
 * any purpose, you must agree to the terms of that agreement.
 *
 ******************************************************************************/


#ifndef __GLIB_COLOR_H
#define __GLIB_COLOR_H

#ifdef __cplusplus
extern "C" {
#endif

/* A Set of color defines. This is a subset of the X11 colors */
#define AliceBlue               (0x00F0F8FF)
#define AntiqueWhite            (0x00FAEBD7)
#define Aqua                    (0x0000FFFF)
#define Aquamarine              (0x007FFFD4)
#define Azure                   (0x00F0FFFF)
#define Beige                   (0x00F5F5DC)
#define Bisque                  (0x00FFE4C4)
#define Black                   (0x00000000)
#define BlanchedAlmond          (0x00FFEBCD)
#define Blue                    (0x000000FF)
#define BlueViolet              (0x008A2BE2)
#define Brown                   (0x00A52A2A)
#define BurlyWood               (0x00DEB887)
#define CadetBlue               (0x005F9EA0)
#define Chartreuse              (0x007FFF00)
#define Chocolate               (0x00D2691E)
#define Coral                   (0x00FF7F50)
#define CornflowerBlue          (0x006495ED)
#define Cornsilk                (0x00FFF8DC)
#define Crimson                 (0x00DC143C)
#define Cyan                    (0x0000FFFF)
#define DarkBlue                (0x0000008B)
#define DarkCyan                (0x00008B8B)
#define DarkGoldenrod           (0x00B8860B)
#define DarkGray                (0x00A9A9A9)
#define DarkGreen               (0x00006400)
#define DarkKhaki               (0x00BDB76B)
#define DarkMagenta             (0x008B008B)
#define DarkOliveGreen          (0x00556B2F)
#define DarkOrange              (0x00FF8C00)
#define DarkOrchid              (0x009932CC)
#define DarkRed                 (0x008B0000)
#define DarkSalmon              (0x00E9967A)
#define DarkSeaGreen            (0x008FBC8F)
#define DarkSlateBlue           (0x00483D8B)
#define DarkSlateGray           (0x002F4F4F)
#define DarkTurquoise           (0x0000CED1)
#define DarkViolet              (0x009400D3)
#define DeepPink                (0x00FF1493)
#define DeepSkyBlue             (0x0000BFFF)
#define DimGray                 (0x00696969)
#define DodgerBlue              (0x001E90FF)
#define FireBrick               (0x00B22222)
#define FloralWhite             (0x00FFFAF0)
#define ForestGreen             (0x00228B22)
#define Fuchsia                 (0x00FF00FF)
#define Gainsboro               (0x00DCDCDC)
#define GhostWhite              (0x00F8F8FF)
#define Gold                    (0x00FFD700)
#define Goldenrod               (0x00DAA520)
#define Gray                    (0x00808080)
#define Green                   (0x00008000)
#define GreenYellow             (0x00ADFF2F)
#define Honeydew                (0x00F0FFF0)
#define HotPink                 (0x00FF69B4)
#define IndianRed               (0x00CD5C5C)
#define Indigo                  (0x004B0082)
#define Ivory                   (0x00FFFFF0)
#define Khaki                   (0x00F0E68C)
#define Lavender                (0x00E6E6FA)
#define LavenderBlush           (0x00FFF0F5)
#define LawnGreen               (0x007CFC00)
#define LemonChiffon            (0x00FFFACD)
#define LightBlue               (0x00ADD8E6)
#define LightCoral              (0x00F08080)
#define LightCyan               (0x00E0FFFF)
#define LightGoldenrodYellow    (0x00FAFAD2)
#define LightGreen              (0x0090EE90)
#define LightGrey               (0x00D3D3D3)
#define LightPink               (0x00FFB6C1)
#define LightSalmon             (0x00FFA07A)
#define LightSeaGreen           (0x0020B2AA)
#define LightSkyBlue            (0x0087CEFA)
#define LightSlateGray          (0x00778899)
#define LightSteelBlue          (0x00B0C4DE)
#define LightYellow             (0x00FFFFE0)
#define Lime                    (0x0000FF00)
#define LimeGreen               (0x0032CD32)
#define Linen                   (0x00FAF0E6)
#define Magenta                 (0x00FF00FF)
#define Maroon                  (0x00800000)
#define MediumAquamarine        (0x0066CDAA)
#define MediumBlue              (0x000000CD)
#define MediumOrchid            (0x00BA55D3)
#define MediumPurple            (0x009370DB)
#define MediumSeaGreen          (0x003CB371)
#define MediumSlateBlue         (0x007B68EE)
#define MediumSpringGreen       (0x0000FA9A)
#define MediumTurquoise         (0x0048D1CC)
#define MediumVioletRed         (0x00C71585)
#define MidnightBlue            (0x00191970)
#define MintCream               (0x00F5FFFA)
#define MistyRose               (0x00FFE4E1)
#define Moccasin                (0x00FFE4B5)
#define NavajoWhite             (0x00FFDEAD)
#define Navy                    (0x00000080)
#define OldLace                 (0x00FDF5E6)
#define Olive                   (0x00808000)
#define OliveDrab               (0x006B8E23)
#define Orange                  (0x00FFA500)
#define OrangeRed               (0x00FF4500)
#define Orchid                  (0x00DA70D6)
#define PaleGoldenrod           (0x00EEE8AA)
#define PaleGreen               (0x0098FB98)
#define PaleTurquoise           (0x00AFEEEE)
#define PaleVioletRed           (0x00DB7093)
#define PaleVioletRed           (0x00DB7093)
#define PapayaWhip              (0x00FFEFD5)
#define PeachPuff               (0x00FFDAB9)
#define Peru                    (0x00CD853F)
#define Pink                    (0x00FFC0CB)
#define Plum                    (0x00DDA0DD)
#define PowderBlue              (0x00B0E0E6)
#define Purple                  (0x00800080)
#define Red                     (0x00FF0000)
#define RosyBrown               (0x00BC8F8F)
#define RoyalBlue               (0x004169E1)
#define SaddleBrown             (0x008B4513)
#define Salmon                  (0x00FA8072)
#define SandyBrown              (0x00F4A460)
#define SeaGreen                (0x002E8B57)
#define Seashell                (0x00FFF5EE)
#define Sienna                  (0x00A0522D)
#define Silver                  (0x00C0C0C0)
#define SkyBlue                 (0x0087CEEB)
#define SlateBlue               (0x006A5ACD)
#define SlateGray               (0x00708090)
#define Snow                    (0x00FFFAFA)
#define SpringGreen             (0x0000FF7F)
#define SteelBlue               (0x004682B4)
#define Tan                     (0x00D2B48C)
#define Teal                    (0x00008080)
#define Thistle                 (0x00D8BFD8)
#define Tomato                  (0x00FF6347)
#define Turquoise               (0x0040E0D0)
#define Violet                  (0x00EE82EE)
#define Wheat                   (0x00F5DEB3)
#define White                   (0x00FFFFFF)
#define WhiteSmoke              (0x00F5F5F5)
#define Yellow                  (0x00FFFF00)
#define YellowGreen             (0x009ACD32)

/* Mask to help extract components */
#define RedMask                 (0x00FF0000)
#define RedShift                16
#define GreenMask               (0x0000FF00)
#define GreenShift              8
#define BlueMask                (0x000000FF)
#define BlueShift               0

#ifdef __cplusplus
}
#endif

#endif
