/*********************************************************************
*                SEGGER Microcontroller GmbH & Co. KG                *
*        Solutions for real time microcontroller applications        *
**********************************************************************
*                                                                    *
*        (c) 1996 - 2016  SEGGER Microcontroller GmbH & Co. KG       *
*                                                                    *
*        Internet: www.segger.com    Support:  support@segger.com    *
*                                                                    *
**********************************************************************

** emWin V5.34 - Graphical user interface for embedded applications **
All  Intellectual Property rights  in the Software belongs to  SEGGER.
emWin is protected by  international copyright laws.  Knowledge of the
source code may not be used to write a similar product.  This file may
only be used in accordance with the following terms:

The  software has  been licensed  to Silicon Labs Norway, a subsidiary
of Silicon Labs Inc. whose registered office is 400 West Cesar Chavez,
Austin,  TX 78701, USA solely for  the purposes of creating  libraries 
for its  ARM Cortex-M3, M4F  processor-based devices,  sublicensed and 
distributed  under the  terms and conditions  of the  End User License  
Agreement supplied by Silicon Labs.
Full source code is available at: www.segger.com

We appreciate your understanding and fairness.
----------------------------------------------------------------------
Licensing information

Licensor:                 SEGGER Software GmbH
Licensed to:              Silicon Laboratories Norway
Licensed SEGGER software: emWin
License number:           GUI-00140
License model:            See Agreement, dated 20th April 2012
Licensed product:         - 
Licensed platform:        Cortex M3, Cortex M4F
Licensed number of seats: -
----------------------------------------------------------------------
File        : MEMDEV_AttitudeIndicator.c
Purpose     : Shows use of high resolution rotation for memory devices
Requirements: WindowManager - ( )
              MemoryDevices - (x)
              AntiAliasing  - (x)
              VNC-Server    - ( )
              PNG-Library   - ( )
              TrueTypeFonts - ( )
----------------------------------------------------------------------
*/

#include <stddef.h>
#include "GUI.h"

#if GUI_WINSUPPORT
  #include "WM.h"
#endif

/*********************************************************************
*
*       Defines
*
**********************************************************************
*/
#if (GUI_USE_ARGB)
  #define COLOR_SKY    0xFF5daad8
  #define COLOR_GROUND 0xFFc7932d
#else
  #define COLOR_SKY    0xd8aa5d
  #define COLOR_GROUND 0x2d93c7
#endif
#define AA_FACTOR 6
#define SPEED_MAX_PITCH  (500 * 25)
#define SPEED_MAX_ROLL  (1200 * 25)
#define BUTTON_UP    0
#define BUTTON_DOWN  1
#define BUTTON_LEFT  2
#define BUTTON_RIGHT 3

//
// Recommended memory to run the sample with adequate performance
//
#define RECOMMENDED_MEMORY (1024L * 700)

/*********************************************************************
*
*       Types
*
**********************************************************************
*/
typedef struct {
  GUI_MEMDEV_Handle hMemMask;          // Mask device for punch operation
  GUI_MEMDEV_Handle hMemScale;         // Content of complete scale
  GUI_MEMDEV_Handle hMemWork;          // Destination device
  GUI_POINT         aPointSrc[3];      // Source points for roll indicator triangle
  GUI_POINT         aPointDst[3];      // Destination points for roll indicator
  GUI_POINT         aPointSrcCL[4];    // Initial coordinates of clearing polygon left
  GUI_POINT         aPointSrcCR[4];    // Initial coordinates of clearing polygon left
  GUI_POINT         aPointDstCL[4];    // Initial coordinates of clearing polygon right
  GUI_POINT         aPointDstCR[4];    // Initial coordinates of clearing polygon right
  GUI_RECT          RectUD;            // Up/down touch area
  GUI_RECT          RectLR;            // Left/right touch area
  I32               Pitch;
  I32               Roll;
  int               xSizeDisplay;
  int               ySizeDisplay;
  int               r;
  int               d;
  int               xm;
  int               ym;
} ANIM_CONTEXT;

/*********************************************************************
*
*       Static data
*
**********************************************************************
*/
GUI_CONST_STORAGE unsigned char acGUI_Font24_0020[  1] = { // Code 0020, SPACE
  0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font24_0041[120] = { // Code 0041, LATIN CAPITAL LETTER A
  0x00, 0x00, 0x01, 0xFF, 0xF1, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x05, 0xFF, 0xF5, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x0B, 0xF9, 0xFB, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x1F, 0xE1, 0xEF, 0x10, 0x00, 0x00,
  0x00, 0x00, 0x6F, 0xA0, 0xAF, 0x60, 0x00, 0x00,
  0x00, 0x00, 0xBF, 0x40, 0x4F, 0xB0, 0x00, 0x00,
  0x00, 0x02, 0xFE, 0x00, 0x0E, 0xF2, 0x00, 0x00,
  0x00, 0x07, 0xF9, 0x00, 0x09, 0xF7, 0x00, 0x00,
  0x00, 0x0D, 0xFF, 0xFF, 0xFF, 0xFD, 0x00, 0x00,
  0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0x30, 0x00,
  0x00, 0x8F, 0x50, 0x00, 0x00, 0x5F, 0x80, 0x00,
  0x00, 0xDE, 0x00, 0x00, 0x00, 0x0E, 0xD0, 0x00,
  0x04, 0xF9, 0x00, 0x00, 0x00, 0x0A, 0xF4, 0x00,
  0x09, 0xF4, 0x00, 0x00, 0x00, 0x04, 0xF9, 0x00,
  0x0E, 0xE0, 0x00, 0x00, 0x00, 0x00, 0xEE, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font24_0049[ 15] = { // Code 0049, LATIN CAPITAL LETTER I
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font24_0061[ 66] = { // Code 0061, LATIN SMALL LETTER A
  0x00, 0x4A, 0xEF, 0xFC, 0x70, 0x00,
  0x09, 0xFF, 0xFF, 0xFF, 0xF9, 0x00,
  0x0F, 0xF7, 0x10, 0x18, 0xFE, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0x00,
  0x00, 0x02, 0x79, 0xBD, 0xFF, 0x00,
  0x01, 0xAF, 0xFF, 0xFF, 0xFF, 0x00,
  0x09, 0xFE, 0x97, 0x52, 0xFF, 0x00,
  0x0F, 0xF2, 0x00, 0x04, 0xFF, 0x00,
  0x0E, 0xF6, 0x01, 0x6E, 0xFF, 0x20,
  0x09, 0xFF, 0xFF, 0xFF, 0xFF, 0x40,
  0x00, 0x8E, 0xFE, 0xB4, 0x4F, 0xB0
};

GUI_CONST_STORAGE unsigned char acGUI_Font24_0063[ 55] = { // Code 0063, LATIN SMALL LETTER C
  0x00, 0x7C, 0xFE, 0xA2, 0x00,
  0x0B, 0xFF, 0xFF, 0xFE, 0x10,
  0x6F, 0xE5, 0x02, 0xBF, 0x90,
  0xBF, 0x50, 0x00, 0x2F, 0xE0,
  0xEF, 0x10, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00,
  0xEF, 0x10, 0x00, 0x00, 0x00,
  0xCF, 0x50, 0x00, 0x2F, 0xE0,
  0x7F, 0xE4, 0x02, 0xBF, 0x80,
  0x0B, 0xFF, 0xFF, 0xFD, 0x10,
  0x00, 0x7D, 0xFE, 0x91, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font24_0064[ 75] = { // Code 0064, LATIN SMALL LETTER D
  0x00, 0x00, 0x00, 0x0F, 0xF0,
  0x00, 0x00, 0x00, 0x0F, 0xF0,
  0x00, 0x00, 0x00, 0x0F, 0xF0,
  0x00, 0x00, 0x00, 0x0F, 0xF0,
  0x01, 0x9E, 0xFA, 0x1F, 0xF0,
  0x0C, 0xFF, 0xFF, 0xBF, 0xF0,
  0x6F, 0xE3, 0x04, 0xEF, 0xF0,
  0xBF, 0x50, 0x00, 0x6F, 0xF0,
  0xEF, 0x10, 0x00, 0x1F, 0xF0,
  0xFF, 0x00, 0x00, 0x0F, 0xF0,
  0xEF, 0x10, 0x00, 0x1F, 0xF0,
  0xBF, 0x60, 0x00, 0x5F, 0xF0,
  0x6F, 0xE4, 0x03, 0xEF, 0xF0,
  0x0B, 0xFF, 0xFF, 0xAF, 0xF0,
  0x01, 0x8E, 0xFA, 0x1F, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font24_0065[ 55] = { // Code 0065, LATIN SMALL LETTER E
  0x00, 0x6C, 0xFF, 0xC6, 0x00,
  0x09, 0xFF, 0xFF, 0xFF, 0xA0,
  0x5F, 0xD4, 0x00, 0x3C, 0xF6,
  0xBF, 0x20, 0x00, 0x02, 0xFB,
  0xEF, 0xFF, 0xFF, 0xFF, 0xFE,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xEF, 0x10, 0x00, 0x00, 0x00,
  0xBF, 0x60, 0x00, 0x00, 0x00,
  0x6F, 0xF7, 0x10, 0x29, 0xFB,
  0x0A, 0xFF, 0xFF, 0xFF, 0xE2,
  0x00, 0x6C, 0xFF, 0xD9, 0x20
};

GUI_CONST_STORAGE unsigned char acGUI_Font24_0069[ 15] = { // Code 0069, LATIN SMALL LETTER I
  0xFF,
  0xFF,
  0x00,
  0x00,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font24_006E[ 55] = { // Code 006E, LATIN SMALL LETTER N
  0xFF, 0x19, 0xEF, 0xD7, 0x00,
  0xFF, 0xDF, 0xFF, 0xFF, 0x70,
  0xFF, 0xE4, 0x02, 0xBF, 0xD0,
  0xFF, 0x40, 0x00, 0x2F, 0xF0,
  0xFF, 0x10, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x0F, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font24_006F[ 55] = { // Code 006F, LATIN SMALL LETTER O
  0x00, 0x6C, 0xFF, 0xC6, 0x00,
  0x0A, 0xFF, 0xFF, 0xFF, 0xA0,
  0x6F, 0xE6, 0x11, 0x6E, 0xF6,
  0xBF, 0x60, 0x00, 0x07, 0xFB,
  0xEF, 0x10, 0x00, 0x01, 0xFE,
  0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xEF, 0x10, 0x00, 0x01, 0xFE,
  0xBF, 0x70, 0x00, 0x07, 0xFB,
  0x6F, 0xE6, 0x11, 0x6E, 0xF6,
  0x0A, 0xFF, 0xFF, 0xFF, 0xA0,
  0x00, 0x6C, 0xFF, 0xC6, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font24_0072[ 33] = { // Code 0072, LATIN SMALL LETTER R
  0xFF, 0x2C, 0xFB,
  0xFF, 0xBF, 0xF9,
  0xFF, 0xC2, 0x00,
  0xFF, 0x40, 0x00,
  0xFF, 0x10, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font24_0074[ 45] = { // Code 0074, LATIN SMALL LETTER T
  0x01, 0x80, 0x00,
  0x0E, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xF0,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF2, 0x00,
  0x0D, 0xFF, 0xE0,
  0x05, 0xDF, 0xE0
};

GUI_CONST_STORAGE unsigned char acGUI_Font24_0075[ 55] = { // Code 0075, LATIN SMALL LETTER U
  0xFF, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x1F, 0xF0,
  0xFF, 0x20, 0x00, 0x5F, 0xF0,
  0xDF, 0xB2, 0x05, 0xEF, 0xF0,
  0x7F, 0xFF, 0xFF, 0xAF, 0xF0,
  0x06, 0xDF, 0xE9, 0x1F, 0xF0
};

GUI_CONST_STORAGE GUI_CHARINFO_EXT GUI_Font24_CharInfo[13] = {
   {   1,   1,   0,  19,   6, acGUI_Font24_0020 } // Code 0020, SPACE
  ,{  15,  15,  -1,   4,  13, acGUI_Font24_0041 } // Code 0041, LATIN CAPITAL LETTER A
  ,{   2,  15,   2,   4,   6, acGUI_Font24_0049 } // Code 0049, LATIN CAPITAL LETTER I
  ,{  11,  11,   0,   8,  12, acGUI_Font24_0061 } // Code 0061, LATIN SMALL LETTER A
  ,{   9,  11,   1,   8,  11, acGUI_Font24_0063 } // Code 0063, LATIN SMALL LETTER C
  ,{   9,  15,   1,   4,  11, acGUI_Font24_0064 } // Code 0064, LATIN SMALL LETTER D
  ,{  10,  11,   1,   8,  12, acGUI_Font24_0065 } // Code 0065, LATIN SMALL LETTER E
  ,{   2,  15,   1,   4,   5, acGUI_Font24_0069 } // Code 0069, LATIN SMALL LETTER I
  ,{   9,  11,   1,   8,  11, acGUI_Font24_006E } // Code 006E, LATIN SMALL LETTER N
  ,{  10,  11,   1,   8,  12, acGUI_Font24_006F } // Code 006F, LATIN SMALL LETTER O
  ,{   6,  11,   1,   8,   7, acGUI_Font24_0072 } // Code 0072, LATIN SMALL LETTER R
  ,{   5,  15,   0,   4,   6, acGUI_Font24_0074 } // Code 0074, LATIN SMALL LETTER T
  ,{   9,  11,   1,   8,  11, acGUI_Font24_0075 } // Code 0075, LATIN SMALL LETTER U
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_Font24_Prop9 = {
   0x0074                                   // First character
  ,0x0075                                   // Last character 
  ,&GUI_Font24_CharInfo[ 11]                // Address of first character
  ,(GUI_CONST_STORAGE GUI_FONT_PROP_EXT *)0 // Pointer to next GUI_FONT_PROP_EXT
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_Font24_Prop8 = {
   0x0072                    // First character
  ,0x0072                    // Last character 
  ,&GUI_Font24_CharInfo[ 10] // Address of first character
  ,&GUI_Font24_Prop9         // Pointer to next GUI_FONT_PROP_EXT
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_Font24_Prop7 = {
   0x006E                    // First character
  ,0x006F                    // Last character 
  ,&GUI_Font24_CharInfo[  8] // Address of first character
  ,&GUI_Font24_Prop8         // Pointer to next GUI_FONT_PROP_EXT
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_Font24_Prop6 = {
   0x0069                    // First character
  ,0x0069                    // Last character 
  ,&GUI_Font24_CharInfo[  7] // Address of first character
  ,&GUI_Font24_Prop7         // Pointer to next GUI_FONT_PROP_EXT
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_Font24_Prop5 = {
   0x0063                    // First character
  ,0x0065                    // Last character 
  ,&GUI_Font24_CharInfo[  4] // Address of first character
  ,&GUI_Font24_Prop6         // Pointer to next GUI_FONT_PROP_EXT
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_Font24_Prop4 = {
   0x0061                    // First character
  ,0x0061                    // Last character 
  ,&GUI_Font24_CharInfo[  3] // Address of first character
  ,&GUI_Font24_Prop5         // Pointer to next GUI_FONT_PROP_EXT
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_Font24_Prop3 = {
   0x0049                    // First character
  ,0x0049                    // Last character 
  ,&GUI_Font24_CharInfo[  2] // Address of first character
  ,&GUI_Font24_Prop4         // Pointer to next GUI_FONT_PROP_EXT
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_Font24_Prop2 = {
   0x0041                    // First character
  ,0x0041                    // Last character 
  ,&GUI_Font24_CharInfo[  1] // Address of first character
  ,&GUI_Font24_Prop3         // Pointer to next GUI_FONT_PROP_EXT
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_Font24_Prop1 = {
   0x0020                    // First character
  ,0x0020                    // Last character 
  ,&GUI_Font24_CharInfo[  0] // Address of first character
  ,&GUI_Font24_Prop2         // Pointer to next GUI_FONT_PROP_EXT
};

GUI_CONST_STORAGE GUI_FONT GUI_Font24 = {
   GUI_FONTTYPE_PROP_AA4_EXT // type of font   
  ,24                        // height of font 
  ,24                        // space of font y
  ,1                         // magnification x
  ,1                         // magnification y
  ,{&GUI_Font24_Prop1}
  ,19                        // Baseline
  ,11                        // Height of lowercase characters
  ,15                        // Height of capital characters
};

#if (GUI_USE_ARGB)

static GUI_CONST_STORAGE unsigned long _acSeggerLogo_80x40[] = {
  0x10292929, 0xAF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 
        0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 
        0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 
        0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xAF292929, 0x10292929,
  0x9F292929, 0xFF292929, 0xFF363636, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 
        0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 
        0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 
        0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF363636, 0xFF292929, 0x9F292929,
  0xFF292929, 0xFF292929, 0xFFD7D7D7, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFD7D7D7, 0xFF292929, 0xFF292929,
  0xFF292929, 0xFF5F5F5F, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF5F5F5F, 0xFF292929,
  0xFF292929, 0xFF5F5F5F, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF5F5F5F, 0xFF292929,
  0xFF292929, 0xFF5F5F5F, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFC2C4DE, 0xFF7A7EB7, 0xFFDBDCEB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFDBDCEB, 0xFF868ABD, 0xFFDBDCEB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF5F5F5F, 0xFF292929,
  0xFF292929, 0xFF5F5F5F, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF3D4396, 0xFF3D4396, 0xFF6166AA, 0xFFF3F3F8, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF6E72B0, 0xFF3D4396, 0xFF494F9D, 0xFFE7E8F2, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF5F5F5F, 0xFF292929,
  0xFF292929, 0xFF5F5F5F, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF7A7EB7, 0xFF3D4396, 0xFF3D4396, 0xFF868ABD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF9295C4, 0xFF3D4396, 0xFF3D4396, 0xFF6166AA, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF5F5F5F, 0xFF292929,
  0xFF292929, 0xFF5F5F5F, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF3F3F8, 0xFF555BA3, 0xFF3D4396, 0xFF3D4396, 0xFFB6B9D8, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF6166AA, 0xFF3D4396, 0xFF3D4396, 0xFF868ABD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF5F5F5F, 0xFF292929,
  0xFF292929, 0xFF5F5F5F, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFDBDCEB, 0xFF3D4396, 0xFF3D4396, 0xFF494F9D, 0xFFDBDCEB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF3F3F8, 0xFF494F9D, 0xFF3D4396, 0xFF3D4396, 0xFFB6B9D8, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF5F5F5F, 0xFF292929,
  0xFF292929, 0xFF5F5F5F, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFAAADD1, 0xFF3D4396, 0xFF3D4396, 0xFF6166AA, 0xFFF3F3F8, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFCFD0E5, 0xFF3D4396, 0xFF3D4396, 0xFF494F9D, 0xFFDBDCEB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF5F5F5F, 0xFF292929,
  0xFF292929, 0xFF5F5F5F, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF7A7EB7, 0xFF3D4396, 0xFF3D4396, 0xFF868ABD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFAAADD1, 0xFF3D4396, 0xFF3D4396, 0xFF6166AA, 0xFFF3F3F8, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF5F5F5F, 0xFF292929,
  0xFF292929, 0xFF5F5F5F, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF3F3F8, 0xFF555BA3, 0xFF3D4396, 0xFF3D4396, 0xFFB6B9D8, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF7A7EB7, 0xFF3D4396, 0xFF3D4396, 0xFF7A7EB7, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF5F5F5F, 0xFF292929,
  0xFF292929, 0xFF5F5F5F, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFAAADD1, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFDBDCEB, 0xFF3D4396, 0xFF3D4396, 0xFF494F9D, 0xFFDBDCEB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF3F3F8, 0xFF555BA3, 0xFF3D4396, 0xFF3D4396, 0xFFAAADD1, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF5F5F5F, 0xFF292929,
  0xFF292929, 0xFF5F5F5F, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF3D4396, 0xFFCFD0E5, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFAAADD1, 0xFF3D4396, 0xFF3D4396, 0xFF6166AA, 0xFFF3F3F8, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFDBDCEB, 0xFF494F9D, 0xFF3D4396, 0xFF3D4396, 0xFFDBDCEB, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF5F5F5F, 0xFF292929,
  0xFF292929, 0xFF5F5F5F, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF3D4396, 0xFF494F9D, 0xFFF3F3F8, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF7A7EB7, 0xFF3D4396, 0xFF3D4396, 0xFF868ABD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFB6B9D8, 0xFF3D4396, 0xFF3D4396, 0xFF494F9D, 
        0xFFF3F3F8, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF5F5F5F, 0xFF292929,
  0xFF292929, 0xFF5F5F5F, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF3D4396, 0xFF3D4396, 0xFF6E72B0, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF3F3F8, 0xFF555BA3, 0xFF3D4396, 0xFF3D4396, 0xFFB6B9D8, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF868ABD, 0xFF3D4396, 0xFF3D4396, 
        0xFF555BA3, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 
        0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 
        0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFFE7E8F2, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF5F5F5F, 0xFF292929,
  0xFF292929, 0xFF5F5F5F, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF9EA1CB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFDBDCEB, 0xFF3D4396, 0xFF3D4396, 0xFF494F9D, 0xFFDBDCEB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF3F3F8, 0xFF6166AA, 0xFF3D4396, 
        0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 
        0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 
        0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF9EA1CB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF5F5F5F, 0xFF292929,
  0xFF292929, 0xFF5F5F5F, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFFCFD0E5, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFAAADD1, 0xFF3D4396, 0xFF3D4396, 0xFF6166AA, 0xFFF3F3F8, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFE7E8F2, 0xFF6E72B0, 
        0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 
        0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 
        0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFFE7E8F2, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF5F5F5F, 0xFF292929,
  0xFF292929, 0xFF5F5F5F, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF494F9D, 0xFFF3F3F8, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF7A7EB7, 0xFF3D4396, 0xFF3D4396, 0xFF9EA1CB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF5F5F5F, 0xFF292929,
  0xFF292929, 0xFF5F5F5F, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF494F9D, 0xFFF3F3F8, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF7A7EB7, 0xFF3D4396, 0xFF3D4396, 0xFF9EA1CB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF5F5F5F, 0xFF292929,
  0xFF292929, 0xFF5F5F5F, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFFCFD0E5, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFAAADD1, 0xFF3D4396, 0xFF3D4396, 0xFF6166AA, 0xFFF3F3F8, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFE7E8F2, 0xFF6E72B0, 
        0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 
        0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 
        0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFFE7E8F2, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF5F5F5F, 0xFF292929,
  0xFF292929, 0xFF5F5F5F, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF9EA1CB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFDBDCEB, 0xFF3D4396, 0xFF3D4396, 0xFF494F9D, 0xFFDBDCEB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF3F3F8, 0xFF6166AA, 0xFF3D4396, 
        0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 
        0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 
        0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF3D4396, 0xFF9EA1CB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF5F5F5F, 0xFF292929,
  0xFF292929, 0xFF5F5F5F, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF3D4396, 0xFF3D4396, 0xFF6E72B0, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF3F3F8, 0xFF555BA3, 0xFF3D4396, 0xFF3D4396, 0xFFB6B9D8, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF868ABD, 0xFF3D4396, 0xFF3D4396, 
        0xFF555BA3, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 
        0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 
        0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFF6E72B0, 0xFFE7E8F2, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF5F5F5F, 0xFF292929,
  0xFF292929, 0xFF5F5F5F, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF3D4396, 0xFF494F9D, 0xFFF3F3F8, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF7A7EB7, 0xFF3D4396, 0xFF3D4396, 0xFF868ABD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFB6B9D8, 0xFF3D4396, 0xFF3D4396, 0xFF494F9D, 
        0xFFF3F3F8, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF5F5F5F, 0xFF292929,
  0xFF292929, 0xFF5F5F5F, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF3D4396, 0xFFCFD0E5, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFAAADD1, 0xFF3D4396, 0xFF3D4396, 0xFF6166AA, 0xFFF3F3F8, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFDBDCEB, 0xFF494F9D, 0xFF3D4396, 0xFF3D4396, 0xFFDBDCEB, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF5F5F5F, 0xFF292929,
  0xFF292929, 0xFF5F5F5F, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFAAADD1, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFDBDCEB, 0xFF3D4396, 0xFF3D4396, 0xFF494F9D, 0xFFDBDCEB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF3F3F8, 0xFF555BA3, 0xFF3D4396, 0xFF3D4396, 0xFFAAADD1, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFF2F2F2, 0xFFBCBCBC, 0xFF949494, 0xFF949494, 0xFFBCBCBC, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFE4E4E4, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFD7D7D7, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFE4E4E4, 
        0xFFAFAFAF, 0xFF949494, 0xFFA1A1A1, 0xFFD7D7D7, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFE4E4E4, 0xFFA1A1A1, 0xFF949494, 0xFFA1A1A1, 0xFFD7D7D7, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF2F2F2, 0xFFCACACA, 0xFFCACACA, 
        0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFD7D7D7, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF5F5F5F, 0xFF292929,
  0xFF292929, 0xFF5F5F5F, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF3F3F8, 0xFF555BA3, 0xFF3D4396, 0xFF3D4396, 0xFFB6B9D8, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF7A7EB7, 0xFF3D4396, 0xFF3D4396, 0xFF7A7EB7, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFD7D7D7, 0xFF363636, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF444444, 0xFFE4E4E4, 0xFFFFFFFF, 0xFF5F5F5F, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFFD7D7D7, 0xFFFFFFFF, 0xFF878787, 0xFF292929, 
        0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF5F5F5F, 0xFFF2F2F2, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF878787, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF6C6C6C, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF797979, 0xFF292929, 0xFF292929, 
        0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFFCACACA, 0xFFCACACA, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF5F5F5F, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF5F5F5F, 0xFF292929,
  0xFF292929, 0xFF5F5F5F, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF7A7EB7, 0xFF3D4396, 0xFF3D4396, 0xFF868ABD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFAAADD1, 0xFF3D4396, 0xFF3D4396, 0xFF6166AA, 0xFFF3F3F8, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFF878787, 0xFF292929, 0xFF6C6C6C, 0xFFE4E4E4, 0xFFD7D7D7, 0xFF515151, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFF5F5F5F, 0xFF292929, 0xFFA1A1A1, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFFFFFFF, 0xFFAFAFAF, 0xFF292929, 0xFF292929, 
        0xFF949494, 0xFFCACACA, 0xFFAFAFAF, 0xFF363636, 0xFF292929, 0xFFAFAFAF, 0xFFFFFFFF, 0xFF949494, 0xFF292929, 0xFF292929, 0xFFA1A1A1, 0xFFCACACA, 0xFFA1A1A1, 0xFF363636, 0xFF292929, 0xFFCACACA, 0xFFFFFFFF, 0xFF5F5F5F, 0xFF292929, 0xFF797979, 
        0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFF2F2F2, 0xFFCACACA, 0xFF292929, 0xFF515151, 0xFFCACACA, 0xFFCACACA, 0xFF949494, 0xFF292929, 0xFF292929, 0xFFCACACA, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF5F5F5F, 0xFF292929,
  0xFF292929, 0xFF5F5F5F, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFAAADD1, 0xFF3D4396, 0xFF3D4396, 0xFF6166AA, 0xFFF3F3F8, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFCFD0E5, 0xFF3D4396, 0xFF3D4396, 0xFF494F9D, 0xFFDBDCEB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFF878787, 0xFF292929, 0xFF444444, 0xFFA1A1A1, 0xFFD7D7D7, 0xFFF2F2F2, 0xFFCACACA, 0xFFF2F2F2, 0xFFFFFFFF, 0xFF5F5F5F, 0xFF292929, 0xFFA1A1A1, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFE4E4E4, 0xFFFFFFFF, 0xFF5F5F5F, 0xFF292929, 0xFF797979, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFD7D7D7, 0xFF949494, 0xFFF2F2F2, 0xFFFFFFFF, 0xFF444444, 0xFF292929, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFD7D7D7, 0xFFA1A1A1, 0xFFF2F2F2, 0xFFFFFFFF, 0xFF5F5F5F, 0xFF292929, 0xFF797979, 
        0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFE4E4E4, 0xFFFFFFFF, 0xFFCACACA, 0xFF292929, 0xFF5F5F5F, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF2F2F2, 0xFF444444, 0xFF292929, 0xFFCACACA, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF5F5F5F, 0xFF292929,
  0xFF292929, 0xFF5F5F5F, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFDBDCEB, 0xFF3D4396, 0xFF3D4396, 0xFF494F9D, 0xFFDBDCEB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF3F3F8, 0xFF494F9D, 0xFF3D4396, 0xFF3D4396, 0xFFB6B9D8, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFD7D7D7, 0xFF444444, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF6C6C6C, 0xFFD7D7D7, 0xFFFFFFFF, 0xFF5F5F5F, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF5F5F5F, 0xFFFFFFFF, 0xFF292929, 0xFF292929, 0xFFBCBCBC, 
        0xFFFFFFFF, 0xFFE4E4E4, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFFA1A1A1, 0xFFFFFFFF, 0xFF292929, 0xFF292929, 0xFFCACACA, 0xFFFFFFFF, 0xFFD7D7D7, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFFA1A1A1, 0xFFFFFFFF, 0xFF5F5F5F, 0xFF292929, 0xFF292929, 
        0xFF292929, 0xFF292929, 0xFF292929, 0xFF363636, 0xFFFFFFFF, 0xFFCACACA, 0xFF292929, 0xFF363636, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF363636, 0xFF292929, 0xFF5F5F5F, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF5F5F5F, 0xFF292929,
  0xFF292929, 0xFF5F5F5F, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF3F3F8, 0xFF555BA3, 0xFF3D4396, 0xFF3D4396, 0xFFB6B9D8, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF6166AA, 0xFF3D4396, 0xFF3D4396, 0xFF868ABD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFCACACA, 0xFF949494, 0xFF5F5F5F, 0xFF292929, 0xFF292929, 0xFF515151, 0xFFFFFFFF, 0xFF5F5F5F, 0xFF292929, 0xFFA1A1A1, 0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFE4E4E4, 0xFFFFFFFF, 0xFF444444, 0xFF292929, 0xFFA1A1A1, 
        0xFFFFFFFF, 0xFFD7D7D7, 0xFF363636, 0xFF292929, 0xFF292929, 0xFF5F5F5F, 0xFFFFFFFF, 0xFF292929, 0xFF292929, 0xFFBCBCBC, 0xFFFFFFFF, 0xFFBCBCBC, 0xFF363636, 0xFF292929, 0xFF292929, 0xFF5F5F5F, 0xFFFFFFFF, 0xFF5F5F5F, 0xFF292929, 0xFF797979, 
        0xFFCACACA, 0xFFCACACA, 0xFFCACACA, 0xFFD7D7D7, 0xFFFFFFFF, 0xFFCACACA, 0xFF292929, 0xFF363636, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF363636, 0xFF292929, 0xFF515151, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF5F5F5F, 0xFF292929,
  0xFF292929, 0xFF5F5F5F, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF7A7EB7, 0xFF3D4396, 0xFF3D4396, 0xFF868ABD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF9295C4, 0xFF3D4396, 0xFF3D4396, 0xFF6166AA, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFA1A1A1, 0xFF292929, 0xFFAFAFAF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFBCBCBC, 0xFF292929, 0xFF292929, 0xFFFFFFFF, 0xFF5F5F5F, 0xFF292929, 0xFFCACACA, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF797979, 0xFF292929, 0xFF444444, 
        0xFFF2F2F2, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF949494, 0xFF292929, 0xFF5F5F5F, 0xFFFFFFFF, 0xFF6C6C6C, 0xFF292929, 0xFF515151, 0xFFF2F2F2, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF797979, 0xFF292929, 0xFF5F5F5F, 0xFFFFFFFF, 0xFF5F5F5F, 0xFF292929, 0xFF949494, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFCACACA, 0xFF292929, 0xFF5F5F5F, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFCACACA, 0xFF292929, 0xFF292929, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF5F5F5F, 0xFF292929,
  0xFF292929, 0xFF5F5F5F, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF3D4396, 0xFF3D4396, 0xFF6166AA, 0xFFF3F3F8, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF6E72B0, 0xFF3D4396, 0xFF494F9D, 0xFFE7E8F2, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFA1A1A1, 0xFF292929, 0xFF292929, 0xFF5F5F5F, 0xFF797979, 0xFF444444, 0xFF292929, 0xFF6C6C6C, 0xFFFFFFFF, 0xFF5F5F5F, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF363636, 0xFFBCBCBC, 0xFFE4E4E4, 0xFF363636, 0xFF292929, 
        0xFF363636, 0xFF5F5F5F, 0xFF515151, 0xFF292929, 0xFF292929, 0xFF5F5F5F, 0xFFFFFFFF, 0xFFD7D7D7, 0xFF363636, 0xFF292929, 0xFF363636, 0xFF5F5F5F, 0xFF444444, 0xFF292929, 0xFF292929, 0xFF5F5F5F, 0xFFFFFFFF, 0xFF5F5F5F, 0xFF292929, 0xFF292929, 
        0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFFAFAFAF, 0xFFCACACA, 0xFF292929, 0xFF5F5F5F, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF292929, 0xFF292929, 0xFFD7D7D7, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF5F5F5F, 0xFF292929,
  0xFF292929, 0xFF5F5F5F, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFC2C4DE, 0xFF7A7EB7, 0xFFDBDCEB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFDBDCEB, 0xFF868ABD, 0xFFDBDCEB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFAFAFAF, 0xFF515151, 0xFF292929, 0xFF292929, 0xFF444444, 0xFF797979, 0xFFF2F2F2, 0xFFFFFFFF, 0xFF949494, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFFD7D7D7, 0xFFFFFFFF, 0xFFE4E4E4, 0xFF797979, 
        0xFF363636, 0xFF292929, 0xFF363636, 0xFF878787, 0xFF6C6C6C, 0xFF6C6C6C, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFD7D7D7, 0xFF6C6C6C, 0xFF363636, 0xFF292929, 0xFF444444, 0xFF949494, 0xFF5F5F5F, 0xFF6C6C6C, 0xFFFFFFFF, 0xFFAFAFAF, 0xFF5F5F5F, 0xFF5F5F5F, 
        0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFFBCBCBC, 0xFFD7D7D7, 0xFF5F5F5F, 0xFF949494, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF6C6C6C, 0xFF444444, 0xFFE4E4E4, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF5F5F5F, 0xFF292929,
  0xFF292929, 0xFF5F5F5F, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF5F5F5F, 0xFF292929,
  0xFF292929, 0xFF5F5F5F, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF5F5F5F, 0xFF292929,
  0xFF292929, 0xFF292929, 0xFFD7D7D7, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFD7D7D7, 0xFF292929, 0xFF292929,
  0x9F292929, 0xFF292929, 0xFF363636, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 
        0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 
        0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 
        0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF5F5F5F, 0xFF363636, 0xFF292929, 0x9F292929,
  0x10292929, 0xAF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 
        0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 
        0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 
        0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xFF292929, 0xAF292929, 0x10292929
};

static GUI_CONST_STORAGE GUI_BITMAP _bmSeggerLogo_80x40 = {
  80, // xSize
  40, // ySize
  320, // BytesPerLine
  32, // BitsPerPixel
  (unsigned char *)_acSeggerLogo_80x40,  // Pointer to picture data
  NULL,  // Pointer to palette
  GUI_DRAW_BMPM8888I
};

#else

static GUI_CONST_STORAGE unsigned long _acSeggerLogo_80x40[] = {
  0xEF292929, 0x50292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929,
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929,
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929,
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x50292929, 0xEF292929,
  0x60292929, 0x00292929, 0x00363636, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F,
        0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F,
        0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F,
        0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x00363636, 0x00292929, 0x60292929,
  0x00292929, 0x00292929, 0x00D7D7D7, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00D7D7D7, 0x00292929, 0x00292929,
  0x00292929, 0x005F5F5F, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x005F5F5F, 0x00292929,
  0x00292929, 0x005F5F5F, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x005F5F5F, 0x00292929,
  0x00292929, 0x005F5F5F, 0x00FFFFFF, 0x00FFFFFF, 0x00DEC4C2, 0x00B77E7A, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EBDCDB, 0x00BD8A86, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x005F5F5F, 0x00292929,
  0x00292929, 0x005F5F5F, 0x00FFFFFF, 0x00FFFFFF, 0x0096433D, 0x0096433D, 0x00AA6661, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x0096433D, 0x009D4F49, 0x00F2E8E7, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x005F5F5F, 0x00292929,
  0x00292929, 0x005F5F5F, 0x00FFFFFF, 0x00FFFFFF, 0x00B77E7A, 0x0096433D, 0x0096433D, 0x00BD8A86, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00C49592, 0x0096433D, 0x0096433D, 0x00AA6661, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x005F5F5F, 0x00292929,
  0x00292929, 0x005F5F5F, 0x00FFFFFF, 0x00FFFFFF, 0x00F8F3F3, 0x00A35B55, 0x0096433D, 0x0096433D, 0x00D8B9B6, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00AA6661, 0x0096433D, 0x0096433D, 0x00BD8A86, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x005F5F5F, 0x00292929,
  0x00292929, 0x005F5F5F, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EBDCDB, 0x0096433D, 0x0096433D, 0x009D4F49, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00F8F3F3, 0x009D4F49, 0x0096433D, 0x0096433D, 0x00D8B9B6, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x005F5F5F, 0x00292929,
  0x00292929, 0x005F5F5F, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00D1ADAA, 0x0096433D, 0x0096433D, 0x00AA6661, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00E5D0CF, 0x0096433D, 0x0096433D, 0x009D4F49, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x005F5F5F, 0x00292929,
  0x00292929, 0x005F5F5F, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B77E7A, 0x0096433D, 0x0096433D, 0x00BD8A86, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00D1ADAA, 0x0096433D, 0x0096433D, 0x00AA6661, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x005F5F5F, 0x00292929,
  0x00292929, 0x005F5F5F, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F8F3F3, 0x00A35B55, 0x0096433D, 0x0096433D, 0x00D8B9B6, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B77E7A, 0x0096433D, 0x0096433D, 0x00B77E7A, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x005F5F5F, 0x00292929,
  0x00292929, 0x005F5F5F, 0x00FFFFFF, 0x00FFFFFF, 0x00D1ADAA, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EBDCDB, 0x0096433D, 0x0096433D, 0x009D4F49, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00F8F3F3, 0x00A35B55, 0x0096433D, 0x0096433D, 0x00D1ADAA, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x005F5F5F, 0x00292929,
  0x00292929, 0x005F5F5F, 0x00FFFFFF, 0x00FFFFFF, 0x0096433D, 0x00E5D0CF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00D1ADAA, 0x0096433D, 0x0096433D, 0x00AA6661, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00EBDCDB, 0x009D4F49, 0x0096433D, 0x0096433D, 0x00EBDCDB,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x005F5F5F, 0x00292929,
  0x00292929, 0x005F5F5F, 0x00FFFFFF, 0x00FFFFFF, 0x0096433D, 0x009D4F49, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B77E7A, 0x0096433D, 0x0096433D, 0x00BD8A86, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00D8B9B6, 0x0096433D, 0x0096433D, 0x009D4F49,
        0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x005F5F5F, 0x00292929,
  0x00292929, 0x005F5F5F, 0x00FFFFFF, 0x00FFFFFF, 0x0096433D, 0x0096433D, 0x00B0726E, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F8F3F3, 0x00A35B55, 0x0096433D, 0x0096433D, 0x00D8B9B6, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00BD8A86, 0x0096433D, 0x0096433D,
        0x00A35B55, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E,
        0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E,
        0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00F2E8E7, 0x00FFFFFF, 0x00FFFFFF, 0x005F5F5F, 0x00292929,
  0x00292929, 0x005F5F5F, 0x00FFFFFF, 0x00FFFFFF, 0x0096433D, 0x0096433D, 0x0096433D, 0x00CBA19E, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EBDCDB, 0x0096433D, 0x0096433D, 0x009D4F49, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00F8F3F3, 0x00AA6661, 0x0096433D,
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D,
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D,
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00CBA19E, 0x00FFFFFF, 0x00FFFFFF, 0x005F5F5F, 0x00292929,
  0x00292929, 0x005F5F5F, 0x00FFFFFF, 0x00FFFFFF, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00E5D0CF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00D1ADAA, 0x0096433D, 0x0096433D, 0x00AA6661, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00F2E8E7, 0x00B0726E,
        0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E,
        0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E,
        0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00F2E8E7, 0x00FFFFFF, 0x00FFFFFF, 0x005F5F5F, 0x00292929,
  0x00292929, 0x005F5F5F, 0x00FFFFFF, 0x00FFFFFF, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x009D4F49, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B77E7A, 0x0096433D, 0x0096433D, 0x00CBA19E, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x005F5F5F, 0x00292929,
  0x00292929, 0x005F5F5F, 0x00FFFFFF, 0x00FFFFFF, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x009D4F49, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B77E7A, 0x0096433D, 0x0096433D, 0x00CBA19E, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x005F5F5F, 0x00292929,
  0x00292929, 0x005F5F5F, 0x00FFFFFF, 0x00FFFFFF, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00E5D0CF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00D1ADAA, 0x0096433D, 0x0096433D, 0x00AA6661, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00F2E8E7, 0x00B0726E,
        0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E,
        0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E,
        0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00F2E8E7, 0x00FFFFFF, 0x00FFFFFF, 0x005F5F5F, 0x00292929,
  0x00292929, 0x005F5F5F, 0x00FFFFFF, 0x00FFFFFF, 0x0096433D, 0x0096433D, 0x0096433D, 0x00CBA19E, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EBDCDB, 0x0096433D, 0x0096433D, 0x009D4F49, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00F8F3F3, 0x00AA6661, 0x0096433D,
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D,
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D,
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00CBA19E, 0x00FFFFFF, 0x00FFFFFF, 0x005F5F5F, 0x00292929,
  0x00292929, 0x005F5F5F, 0x00FFFFFF, 0x00FFFFFF, 0x0096433D, 0x0096433D, 0x00B0726E, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F8F3F3, 0x00A35B55, 0x0096433D, 0x0096433D, 0x00D8B9B6, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00BD8A86, 0x0096433D, 0x0096433D,
        0x00A35B55, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E,
        0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E,
        0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00F2E8E7, 0x00FFFFFF, 0x00FFFFFF, 0x005F5F5F, 0x00292929,
  0x00292929, 0x005F5F5F, 0x00FFFFFF, 0x00FFFFFF, 0x0096433D, 0x009D4F49, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B77E7A, 0x0096433D, 0x0096433D, 0x00BD8A86, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00D8B9B6, 0x0096433D, 0x0096433D, 0x009D4F49,
        0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x005F5F5F, 0x00292929,
  0x00292929, 0x005F5F5F, 0x00FFFFFF, 0x00FFFFFF, 0x0096433D, 0x00E5D0CF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00D1ADAA, 0x0096433D, 0x0096433D, 0x00AA6661, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00EBDCDB, 0x009D4F49, 0x0096433D, 0x0096433D, 0x00EBDCDB,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x005F5F5F, 0x00292929,
  0x00292929, 0x005F5F5F, 0x00FFFFFF, 0x00FFFFFF, 0x00D1ADAA, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EBDCDB, 0x0096433D, 0x0096433D, 0x009D4F49, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00F8F3F3, 0x00A35B55, 0x0096433D, 0x0096433D, 0x00D1ADAA, 0x00FFFFFF,
        0x00FFFFFF, 0x00F2F2F2, 0x00BCBCBC, 0x00949494, 0x00949494, 0x00BCBCBC, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00E4E4E4, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00D7D7D7, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00E4E4E4,
        0x00AFAFAF, 0x00949494, 0x00A1A1A1, 0x00D7D7D7, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00E4E4E4, 0x00A1A1A1, 0x00949494, 0x00A1A1A1, 0x00D7D7D7, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F2F2F2, 0x00CACACA, 0x00CACACA,
        0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00FFFFFF, 0x00FFFFFF, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00D7D7D7, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x005F5F5F, 0x00292929,
  0x00292929, 0x005F5F5F, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F8F3F3, 0x00A35B55, 0x0096433D, 0x0096433D, 0x00D8B9B6, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B77E7A, 0x0096433D, 0x0096433D, 0x00B77E7A, 0x00FFFFFF, 0x00FFFFFF,
        0x00D7D7D7, 0x00363636, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00444444, 0x00E4E4E4, 0x00FFFFFF, 0x005F5F5F, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00D7D7D7, 0x00FFFFFF, 0x00878787, 0x00292929,
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x005F5F5F, 0x00F2F2F2, 0x00FFFFFF, 0x00FFFFFF, 0x00878787, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x006C6C6C, 0x00FFFFFF, 0x00FFFFFF, 0x00797979, 0x00292929, 0x00292929,
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00CACACA, 0x00CACACA, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x005F5F5F, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x005F5F5F, 0x00292929,
  0x00292929, 0x005F5F5F, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B77E7A, 0x0096433D, 0x0096433D, 0x00BD8A86, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00D1ADAA, 0x0096433D, 0x0096433D, 0x00AA6661, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF,
        0x00878787, 0x00292929, 0x006C6C6C, 0x00E4E4E4, 0x00D7D7D7, 0x00515151, 0x00292929, 0x00949494, 0x00FFFFFF, 0x005F5F5F, 0x00292929, 0x00A1A1A1, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00FFFFFF, 0x00AFAFAF, 0x00292929, 0x00292929,
        0x00949494, 0x00CACACA, 0x00AFAFAF, 0x00363636, 0x00292929, 0x00AFAFAF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00A1A1A1, 0x00CACACA, 0x00A1A1A1, 0x00363636, 0x00292929, 0x00CACACA, 0x00FFFFFF, 0x005F5F5F, 0x00292929, 0x00797979,
        0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00F2F2F2, 0x00CACACA, 0x00292929, 0x00515151, 0x00CACACA, 0x00CACACA, 0x00949494, 0x00292929, 0x00292929, 0x00CACACA, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x005F5F5F, 0x00292929,
  0x00292929, 0x005F5F5F, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00D1ADAA, 0x0096433D, 0x0096433D, 0x00AA6661, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00E5D0CF, 0x0096433D, 0x0096433D, 0x009D4F49, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00878787, 0x00292929, 0x00444444, 0x00A1A1A1, 0x00D7D7D7, 0x00F2F2F2, 0x00CACACA, 0x00F2F2F2, 0x00FFFFFF, 0x005F5F5F, 0x00292929, 0x00A1A1A1, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00E4E4E4, 0x00FFFFFF, 0x005F5F5F, 0x00292929, 0x00797979,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00D7D7D7, 0x00949494, 0x00F2F2F2, 0x00FFFFFF, 0x00444444, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00D7D7D7, 0x00A1A1A1, 0x00F2F2F2, 0x00FFFFFF, 0x005F5F5F, 0x00292929, 0x00797979,
        0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00E4E4E4, 0x00FFFFFF, 0x00CACACA, 0x00292929, 0x005F5F5F, 0x00FFFFFF, 0x00FFFFFF, 0x00F2F2F2, 0x00444444, 0x00292929, 0x00CACACA, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x005F5F5F, 0x00292929,
  0x00292929, 0x005F5F5F, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EBDCDB, 0x0096433D, 0x0096433D, 0x009D4F49, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00F8F3F3, 0x009D4F49, 0x0096433D, 0x0096433D, 0x00D8B9B6, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00D7D7D7, 0x00444444, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x006C6C6C, 0x00D7D7D7, 0x00FFFFFF, 0x005F5F5F, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x005F5F5F, 0x00FFFFFF, 0x00292929, 0x00292929, 0x00BCBCBC,
        0x00FFFFFF, 0x00E4E4E4, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x00A1A1A1, 0x00FFFFFF, 0x00292929, 0x00292929, 0x00CACACA, 0x00FFFFFF, 0x00D7D7D7, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x00A1A1A1, 0x00FFFFFF, 0x005F5F5F, 0x00292929, 0x00292929,
        0x00292929, 0x00292929, 0x00292929, 0x00363636, 0x00FFFFFF, 0x00CACACA, 0x00292929, 0x00363636, 0x005F5F5F, 0x005F5F5F, 0x00363636, 0x00292929, 0x005F5F5F, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x005F5F5F, 0x00292929,
  0x00292929, 0x005F5F5F, 0x00FFFFFF, 0x00FFFFFF, 0x00F8F3F3, 0x00A35B55, 0x0096433D, 0x0096433D, 0x00D8B9B6, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00AA6661, 0x0096433D, 0x0096433D, 0x00BD8A86, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00CACACA, 0x00949494, 0x005F5F5F, 0x00292929, 0x00292929, 0x00515151, 0x00FFFFFF, 0x005F5F5F, 0x00292929, 0x00A1A1A1, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00E4E4E4, 0x00FFFFFF, 0x00444444, 0x00292929, 0x00A1A1A1,
        0x00FFFFFF, 0x00D7D7D7, 0x00363636, 0x00292929, 0x00292929, 0x005F5F5F, 0x00FFFFFF, 0x00292929, 0x00292929, 0x00BCBCBC, 0x00FFFFFF, 0x00BCBCBC, 0x00363636, 0x00292929, 0x00292929, 0x005F5F5F, 0x00FFFFFF, 0x005F5F5F, 0x00292929, 0x00797979,
        0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00D7D7D7, 0x00FFFFFF, 0x00CACACA, 0x00292929, 0x00363636, 0x005F5F5F, 0x005F5F5F, 0x00363636, 0x00292929, 0x00515151, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x005F5F5F, 0x00292929,
  0x00292929, 0x005F5F5F, 0x00FFFFFF, 0x00FFFFFF, 0x00B77E7A, 0x0096433D, 0x0096433D, 0x00BD8A86, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00C49592, 0x0096433D, 0x0096433D, 0x00AA6661, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00A1A1A1, 0x00292929, 0x00AFAFAF, 0x00FFFFFF, 0x00FFFFFF, 0x00BCBCBC, 0x00292929, 0x00292929, 0x00FFFFFF, 0x005F5F5F, 0x00292929, 0x00CACACA, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00797979, 0x00292929, 0x00444444,
        0x00F2F2F2, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x005F5F5F, 0x00FFFFFF, 0x006C6C6C, 0x00292929, 0x00515151, 0x00F2F2F2, 0x00FFFFFF, 0x00FFFFFF, 0x00797979, 0x00292929, 0x005F5F5F, 0x00FFFFFF, 0x005F5F5F, 0x00292929, 0x00949494,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CACACA, 0x00292929, 0x005F5F5F, 0x00FFFFFF, 0x00FFFFFF, 0x00CACACA, 0x00292929, 0x00292929, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x005F5F5F, 0x00292929,
  0x00292929, 0x005F5F5F, 0x00FFFFFF, 0x00FFFFFF, 0x0096433D, 0x0096433D, 0x00AA6661, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x0096433D, 0x009D4F49, 0x00F2E8E7, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00A1A1A1, 0x00292929, 0x00292929, 0x005F5F5F, 0x00797979, 0x00444444, 0x00292929, 0x006C6C6C, 0x00FFFFFF, 0x005F5F5F, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00363636, 0x00BCBCBC, 0x00E4E4E4, 0x00363636, 0x00292929,
        0x00363636, 0x005F5F5F, 0x00515151, 0x00292929, 0x00292929, 0x005F5F5F, 0x00FFFFFF, 0x00D7D7D7, 0x00363636, 0x00292929, 0x00363636, 0x005F5F5F, 0x00444444, 0x00292929, 0x00292929, 0x005F5F5F, 0x00FFFFFF, 0x005F5F5F, 0x00292929, 0x00292929,
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00AFAFAF, 0x00CACACA, 0x00292929, 0x005F5F5F, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00292929, 0x00292929, 0x00D7D7D7, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x005F5F5F, 0x00292929,
  0x00292929, 0x005F5F5F, 0x00FFFFFF, 0x00FFFFFF, 0x00DEC4C2, 0x00B77E7A, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EBDCDB, 0x00BD8A86, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00AFAFAF, 0x00515151, 0x00292929, 0x00292929, 0x00444444, 0x00797979, 0x00F2F2F2, 0x00FFFFFF, 0x00949494, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x00D7D7D7, 0x00FFFFFF, 0x00E4E4E4, 0x00797979,
        0x00363636, 0x00292929, 0x00363636, 0x00878787, 0x006C6C6C, 0x006C6C6C, 0x00FFFFFF, 0x00FFFFFF, 0x00D7D7D7, 0x006C6C6C, 0x00363636, 0x00292929, 0x00444444, 0x00949494, 0x005F5F5F, 0x006C6C6C, 0x00FFFFFF, 0x00AFAFAF, 0x005F5F5F, 0x005F5F5F,
        0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x00BCBCBC, 0x00D7D7D7, 0x005F5F5F, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x006C6C6C, 0x00444444, 0x00E4E4E4, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x005F5F5F, 0x00292929,
  0x00292929, 0x005F5F5F, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x005F5F5F, 0x00292929,
  0x00292929, 0x005F5F5F, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x005F5F5F, 0x00292929,
  0x00292929, 0x00292929, 0x00D7D7D7, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00D7D7D7, 0x00292929, 0x00292929,
  0x60292929, 0x00292929, 0x00363636, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F,
        0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F,
        0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F,
        0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x00363636, 0x00292929, 0x60292929,
  0xEF292929, 0x50292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929,
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929,
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929,
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x50292929, 0xEF292929
};

static GUI_CONST_STORAGE GUI_BITMAP _bmSeggerLogo_80x40 = {
  80,                                   // XSize
  40,                                   // YSize
  320,                                  // BytesPerLine
  32,                                   // BitsPerPixel
  (unsigned char *)_acSeggerLogo_80x40, // Pointer to picture data
  NULL                                  // Pointer to palette
 ,GUI_DRAW_BMP8888
};

#endif

#if (GUI_USE_ARGB)
  #define COLOR_CONVERSION GUICC_M8888I
#else
  #define COLOR_CONVERSION GUICC_8888
#endif

/*********************************************************************
*
*       Static code
*
**********************************************************************
*/
/*********************************************************************
*
*       _CreateMask
*/
static GUI_MEMDEV_Handle _CreateMask(int xPos, int yPos, int xSize, int ySize, int r) {
  GUI_MEMDEV_Handle hMem;
  int               xm;
  int               ym;

  xm = xPos + xSize / 2;
  ym = yPos + ySize / 2;
  hMem = GUI_MEMDEV_CreateFixed(xPos, yPos, xSize, ySize, GUI_MEMDEV_NOTRANS, GUI_MEMDEV_APILIST_8, GUICC_8);
  GUI_MEMDEV_Select(hMem);
  GUI_SetColor(GUI_WHITE);
  GUI_AA_FillCircle(xm, ym, r);
  GUI_MEMDEV_Select(0);
  return hMem;
}

/*********************************************************************
*
*       _CreateScale
*/
static GUI_MEMDEV_Handle _CreateScale(int xm, int r) {
  GUI_MEMDEV_Handle hMemScale;
  GUI_RECT          Rect;
  char              acBuffer[] = "90\0";
  int               x0;
  int               x1;
  int               yPosLine;
  int               xEndLine;
  int               xSizeText;
  int               ySizeText;
  int               xPosScale;
  int               xSizeScale;
  int               ySizeScale;
  int               ym;
  int               i;
  
  xEndLine   = 0;
  xPosScale  = xm - r;
  xSizeScale = r * 2 + 1;
  ySizeScale = (r * 2 + 1) * 3;
  ym         = ySizeScale / 2;
  hMemScale  = GUI_MEMDEV_CreateFixed(xPosScale, 0, xSizeScale, ySizeScale, GUI_MEMDEV_NOTRANS, GUI_MEMDEV_APILIST_32, COLOR_CONVERSION);
  GUI_MEMDEV_Select(hMemScale);
  //
  // Sky
  //
  GUI_SetColor(COLOR_SKY);
  GUI_FillRect(xPosScale, 0, xPosScale + xSizeScale - 1, ySizeScale / 2 - 1);
  //
  // Ground
  //
  GUI_SetColor(COLOR_GROUND);
  GUI_FillRect(xPosScale, ySizeScale / 2, xPosScale + xSizeScale - 1, ySizeScale - 1);
  //
  // Scale
  //
  GUI_SetColor(GUI_WHITE);
  GUI_SetTextMode(GUI_TM_TRANS);
  xSizeText = GUI_GetStringDistX("XXX");
  ySizeText = GUI_GetFontSizeY();
  GUI_DrawHLine(ym + 0, xPosScale, xPosScale + xSizeScale - 1);
  GUI_DrawHLine(ym + 1, xPosScale, xPosScale + xSizeScale - 1);
  GUI_DrawVLine(xm, 0, ySizeScale - 1);
  for (i = 1; i <= 9 * 4; i++) {
    yPosLine = (i * r) / 12;
    switch (i % 4) {
    case 0:
      xEndLine = r / 3;
      Rect.x0 = xPosScale + xSizeScale / 2 - xEndLine - xSizeText;
      Rect.y0 = ym - yPosLine - ySizeText / 2;
      Rect.x1 = Rect.x0 + xSizeText - 1;
      Rect.y1 = Rect.y0 + ySizeText - 1;
      acBuffer[0] = '0' + i / 4;
      GUI_DispStringInRect(acBuffer, &Rect, GUI_TA_HCENTER | GUI_TA_VCENTER);
      GUI_MoveRect(&Rect, xEndLine * 2 + xSizeText, 0);
      GUI_DispStringInRect(acBuffer, &Rect, GUI_TA_HCENTER | GUI_TA_VCENTER);
      GUI_MoveRect(&Rect, 0, yPosLine * 2);
      GUI_DispStringInRect(acBuffer, &Rect, GUI_TA_HCENTER | GUI_TA_VCENTER);
      GUI_MoveRect(&Rect, -xEndLine * 2 - xSizeText, 0);
      GUI_DispStringInRect(acBuffer, &Rect, GUI_TA_HCENTER | GUI_TA_VCENTER);
      break;
    case 1:
    case 3:
      xEndLine = r / 12;
      break;
    case 2:
      xEndLine = r / 6;
      break;
    }
    x0 = xPosScale + xSizeScale / 2 - xEndLine;
    x1 = xPosScale + xSizeScale / 2 + xEndLine;
    GUI_DrawHLine(ym + yPosLine + 0, x0, x1);
    GUI_DrawHLine(ym + yPosLine + 1, x0, x1);
    GUI_DrawHLine(ym - yPosLine - 0, x0, x1);
    GUI_DrawHLine(ym - yPosLine - 1, x0, x1);
  }
  GUI_MEMDEV_Select(0);
  return hMemScale;
}

/*********************************************************************
*
*       _DrawButton
*/
static void _DrawButton(ANIM_CONTEXT * pContext, int Pressed, int Index) {
  GUI_MEMDEV_Handle   hMem;
  GUI_MEMDEV_Handle   hMemOld;
  const GUI_RECT    * pClipOld;
  GUI_RECT            rClip;
  int                 xm;
  int                 ym;
  int                 xd;
  int                 yd;
  int                 s;
  int                 x;
  int                 y;

  xm = ym = xd = yd = 0;
  GUI_SetPenSize(2);
  GUI_SetBkColor(GUI_BLACK);
  GUI_SetColor(GUI_WHITE);
  //
  // Calculate and set clip rect
  //
  rClip = ((Index == BUTTON_LEFT) || (Index == BUTTON_RIGHT)) ? pContext->RectLR : pContext->RectUD;
  x     = rClip.x0 + ((rClip.x1 - rClip.x0) + 1) / 2;
  y     = rClip.y0 + ((rClip.y1 - rClip.y0) + 1) / 2;
  switch (Index) {
  case BUTTON_UP:
    rClip.y1 = y;
    break;
  case BUTTON_DOWN:
    rClip.y0 = y;
    break;
  case BUTTON_LEFT:
    rClip.x1 = x;
    break;
  case BUTTON_RIGHT:
    rClip.x0 = x;
    break;
  }
  pClipOld = GUI_SetClipRect(&rClip);
  //
  // Create & select memory device
  //
  hMem    = GUI_MEMDEV_CreateEx(rClip.x0, rClip.y0, rClip.x1, rClip.y1, GUI_MEMDEV_NOTRANS);
  hMemOld = GUI_MEMDEV_Select(hMem);
  GUI_Clear();
  //
  // Calculate values for arrow & draw background and arrow
  //
  switch (Index) {
  case BUTTON_UP:
  case BUTTON_DOWN:
    ym = (pContext->RectLR.y1 + pContext->RectUD.y0) / 2;
    yd = (pContext->RectLR.y1 - pContext->RectUD.y0) / 8;
    xm = (pContext->RectUD.x1 + pContext->RectUD.x0) / 2;
    xd = (pContext->RectUD.x1 - pContext->RectUD.x0) / 8;
    if (Pressed) {
      GUI_AA_FillRoundedRectEx(&pContext->RectUD, 5);
      GUI_SetColor(GUI_BLACK);
    } else {
      GUI_AA_DrawRoundedRectEx(&pContext->RectUD, 5);
      GUI_DrawHLine(ym, pContext->RectUD.x0, pContext->RectUD.x1);
    }
    break;
  case BUTTON_LEFT:
  case BUTTON_RIGHT:
    ym = (pContext->RectLR.y1 + pContext->RectLR.y0) / 2;
    yd = (pContext->RectLR.y1 - pContext->RectLR.y0) / 8;
    xm = (pContext->RectLR.x1 + pContext->RectLR.x0) / 2;
    xd = (pContext->RectLR.x1 - pContext->RectLR.x0) / 8;
    if (Pressed) {
      GUI_AA_FillRoundedRectEx(&pContext->RectLR, 5);
      GUI_SetColor(GUI_BLACK);
    } else {
      GUI_AA_DrawRoundedRectEx(&pContext->RectLR, 5);
      GUI_DrawVLine(xm, pContext->RectLR.y0, pContext->RectLR.y1);
    }
    break;
  }
  if ((Index == BUTTON_LEFT) || (Index == BUTTON_RIGHT)) {
    s = (Index == BUTTON_LEFT) ? -1 : +1;
    GUI_AA_DrawLine(xm + 3 * xd * s, ym         ,
                    xm + 1 * xd * s, ym + 2 * yd);
    GUI_AA_DrawLine(xm + 3 * xd * s, ym         ,
                    xm + 1 * xd * s, ym - 2 * yd);
  } else {
    s = (Index == BUTTON_UP) ? -1 : +1;
    GUI_AA_DrawLine(xm         , ym + 3 * yd * s,
                    xm + 2 * xd, ym + 1 * yd * s);
    GUI_AA_DrawLine(xm         , ym + 3 * yd * s,
                    xm - 2 * xd, ym + 1 * yd * s);
  }
  //
  // Draw and delete memory device
  //
  GUI_MEMDEV_Select(hMemOld);
  GUI_MEMDEV_Write(hMem);
  GUI_MEMDEV_Delete(hMem);
  GUI_SetClipRect(pClipOld);
}

/*********************************************************************
*
*       _InitAnimContext
*/
static int _InitAnimContext(ANIM_CONTEXT * pContext) {
  int xPosWork;
  int yPosWork;
  int xSizeWork;
  int ySizeWork;
  int d;
  I32 SinHQ;
  I32 CosHQ;

  pContext->xSizeDisplay = LCD_GetXSize();
  pContext->ySizeDisplay = LCD_GetYSize();
  pContext->xm           = pContext->xSizeDisplay / 2;
  pContext->ym           = pContext->ySizeDisplay / 2;
  pContext->r            = pContext->ySizeDisplay / 3;
  pContext->d            = pContext->r / 14;
  xPosWork               = pContext->xm - pContext->r * 6 / 7;
  xSizeWork              = (pContext->r * 6 / 7) * 2 + 1;
  yPosWork               = pContext->ym - pContext->r;
  ySizeWork              = pContext->r * 2 + 1;
  pContext->hMemMask     = _CreateMask(xPosWork, yPosWork, xSizeWork, ySizeWork, pContext->r);
  if (pContext->hMemMask == 0) {
    return 1;
  }
  pContext->hMemWork = GUI_MEMDEV_CreateFixed(xPosWork, yPosWork, xSizeWork, ySizeWork, GUI_MEMDEV_NOTRANS, GUI_MEMDEV_APILIST_32, COLOR_CONVERSION);
  if (pContext->hMemWork == 0) {
    GUI_MEMDEV_Delete(pContext->hMemMask);
    return 1;
  }
  pContext->hMemScale = _CreateScale(pContext->xm, pContext->r);
  if (pContext->hMemScale == 0) {
    GUI_MEMDEV_Delete(pContext->hMemWork);
    GUI_MEMDEV_Delete(pContext->hMemMask);
    return 1;
  }
  pContext->aPointSrc[0].x = 0;
  pContext->aPointSrc[0].y = (pContext->r + pContext->d * 2) * AA_FACTOR;
  SinHQ = GUI__SinHQ(60000);
  CosHQ = GUI__CosHQ(60000);
  //
  // Roll indicator
  //
  pContext->aPointSrc[1].x = pContext->aPointSrc[0].x - (((CosHQ * pContext->d * 2) >> 16) * AA_FACTOR);
  pContext->aPointSrc[1].y = pContext->aPointSrc[0].y - (((SinHQ * pContext->d * 2) >> 16) * AA_FACTOR);
  pContext->aPointSrc[2].x = pContext->aPointSrc[0].x + (((CosHQ * pContext->d * 2) >> 16) * AA_FACTOR);
  pContext->aPointSrc[2].y = pContext->aPointSrc[1].y;
  //
  // Polygon for clearing left side of indicator
  //
  pContext->aPointSrcCL[0].x = pContext->aPointSrc[0].x;
  pContext->aPointSrcCL[0].y = pContext->aPointSrc[0].y;
  pContext->aPointSrcCL[1].x = pContext->aPointSrc[1].x;
  pContext->aPointSrcCL[1].y = pContext->aPointSrc[1].y - 4;
  pContext->aPointSrcCL[2].x = pContext->aPointSrcCL[1].x - AA_FACTOR * 4;
  pContext->aPointSrcCL[2].y = pContext->aPointSrcCL[1].y;
  pContext->aPointSrcCL[3].x = pContext->aPointSrcCL[0].x - AA_FACTOR * 4;
  pContext->aPointSrcCL[3].y = pContext->aPointSrcCL[0].y;
  //
  // Polygon for clearing right side of indicator
  //
  pContext->aPointSrcCR[0].x = pContext->aPointSrc[0].x;
  pContext->aPointSrcCR[0].y = pContext->aPointSrc[0].y;
  pContext->aPointSrcCR[1].x = pContext->aPointSrc[2].x;
  pContext->aPointSrcCR[1].y = pContext->aPointSrc[2].y - 4;
  pContext->aPointSrcCR[2].x = pContext->aPointSrcCR[1].x + AA_FACTOR * 4;
  pContext->aPointSrcCR[2].y = pContext->aPointSrcCR[1].y;
  pContext->aPointSrcCR[3].x = pContext->aPointSrcCR[0].x + AA_FACTOR * 4;
  pContext->aPointSrcCR[3].y = pContext->aPointSrcCR[0].y;
  //
  // Surrounding rectangle
  //
  GUI_AA_DrawRoundedRect(0, 0, pContext->xSizeDisplay - 1, pContext->ySizeDisplay - 1, 5);
  //
  // Calculate button areas
  //
  d                   = pContext->xSizeDisplay / 16;
  pContext->RectLR.x0 = d * 0 + 10;
  pContext->RectLR.x1 = pContext->RectLR.x0 + d * 3;
  pContext->RectUD.x1 = pContext->xSizeDisplay - pContext->RectLR.x0 - 1;
  pContext->RectUD.x0 = pContext->RectUD.x1 - (pContext->RectLR.x1 - pContext->RectLR.x0);
  d                   = pContext->ySizeDisplay / 16;
  pContext->RectLR.y0 = d * 4;
  pContext->RectLR.y1 = pContext->RectLR.y0 + d * 4;
  pContext->RectUD.y1 = pContext->RectLR.y1;
  pContext->RectUD.y0 = pContext->RectLR.y0;
  return 0;
}

/*********************************************************************
*
*       _ShowAttitudeIndicator
*/
static void _ShowAttitudeIndicator(ANIM_CONTEXT * pContext) {
  float a;
  int   dx;
  int   dy;
  int   mx;
  int   my;
  int   mxCross;
  int   myCross;
  int   xSizeScale;
  int   ySizeScale;
  int   xPosWork;
  int   yPosWork;
  int   xSizeWork;
  int   ySizeWork;
  I32   sinHQ;
  I32   cosHQ;

  //
  // Rotate memory device in HR mode
  //
  xSizeScale = GUI_MEMDEV_GetXSize(pContext->hMemScale);
  ySizeScale = GUI_MEMDEV_GetYSize(pContext->hMemScale);
  xPosWork   = GUI_MEMDEV_GetXPos(pContext->hMemWork);
  yPosWork   = GUI_MEMDEV_GetYPos(pContext->hMemWork);
  xSizeWork  = GUI_MEMDEV_GetXSize(pContext->hMemWork);
  ySizeWork  = GUI_MEMDEV_GetYSize(pContext->hMemWork);
  sinHQ      = GUI__SinHQ(pContext->Roll);
  cosHQ      = GUI__CosHQ(pContext->Roll);
  dx         = ((((ySizeScale * 4) * (I32)pContext->Pitch) / 90000) * sinHQ) >> 16;
  dy         = ((((ySizeScale * 4) * (I32)pContext->Pitch) / 90000) * cosHQ) >> 16;
  mx         = -(xSizeScale - xSizeWork) * 4;
  my         = -(ySizeScale - ySizeWork) * 4;
  mxCross    = xPosWork + xSizeWork / 2;
  myCross    = yPosWork + ySizeWork / 2;
  GUI_MEMDEV_RotateHQHR(pContext->hMemScale, pContext->hMemWork, mx + dx, my + dy, pContext->Roll, 1000);
  //
  // Punch out area defined in mask device
  //
  GUI_SetBkColor(GUI_BLACK);
  GUI_MEMDEV_PunchOutDevice(pContext->hMemWork, pContext->hMemMask);
  //
  // Draw black cross in center of device
  //
  GUI_MEMDEV_Select(pContext->hMemWork);
  GUI_SetColor(GUI_BLACK);
  GUI_SetPenSize(3);
  GUI_DrawLine(mxCross - 10, myCross, mxCross + 10, myCross);
  GUI_DrawLine(mxCross, myCross - 10, mxCross, myCross + 10);
  //
  // Show the result
  //
  GUI_MEMDEV_Select(0);
  GUI_MEMDEV_Write(pContext->hMemWork);
  //
  // Enable hires antialiasing
  //
  GUI_AA_EnableHiRes();
  GUI_AA_SetFactor(AA_FACTOR);
  a = (pContext->Roll * 3.1415926f) / 180000;
  //
  // Clear right, left and top side of roll indicator
  //
  GUI_SetColor(GUI_BLACK);
  GUI_RotatePolygon(pContext->aPointDstCL, pContext->aPointSrcCL, GUI_COUNTOF(pContext->aPointDstCL), a);
  GUI_AA_FillPolygon(pContext->aPointDstCL, GUI_COUNTOF(pContext->aPointDstCL), pContext->xSizeDisplay / 2 * AA_FACTOR, pContext->ySizeDisplay / 2 * AA_FACTOR);
  GUI_RotatePolygon(pContext->aPointDstCR, pContext->aPointSrcCR, GUI_COUNTOF(pContext->aPointDstCR), a);
  GUI_AA_FillPolygon(pContext->aPointDstCR, GUI_COUNTOF(pContext->aPointDstCR), pContext->xSizeDisplay / 2 * AA_FACTOR, pContext->ySizeDisplay / 2 * AA_FACTOR);
  mx = pContext->xSizeDisplay / 2 * AA_FACTOR;
  my = pContext->ySizeDisplay / 2 * AA_FACTOR;
  GUI_SetColor(GUI_BLACK);
  GUI_SetPenSize(2);
  GUI_AA_DrawLine(mx + pContext->aPointDstCL[1].x, my + pContext->aPointDstCL[1].y, mx + pContext->aPointDstCR[1].x, my + pContext->aPointDstCR[1].y);
  //
  // Draw roll indicator
  //
  GUI_SetColor(GUI_WHITE);
  GUI_RotatePolygon(pContext->aPointDst, pContext->aPointSrc, GUI_COUNTOF(pContext->aPointDst), (pContext->Roll * 3.1415926f) / 180000);
  GUI_AA_FillPolygon(pContext->aPointDst, GUI_COUNTOF(pContext->aPointDst), pContext->xSizeDisplay / 2 * AA_FACTOR, pContext->ySizeDisplay / 2 * AA_FACTOR);
}

/*********************************************************************
*
*       _DrawScale
*/
static void _DrawScale(ANIM_CONTEXT * pAnim) {
  int i;
  int a;
  int xm;
  int ym;
  int rm;
  int x0;
  int y0;
  int x1;
  int x2;
  int y1;
  int r0;
  int r1;
  int s;
  I32 SinHQ;
  I32 CosHQ;

  GUI_AA_EnableHiRes();
  GUI_AA_SetFactor(AA_FACTOR);
  //
  // Draw markers
  //
  GUI_SetPenSize(3);
  r0 = pAnim->r + pAnim->d * 2 + 2;
  r1 = pAnim->r + pAnim->d * 4;
  for (i = 10; i <= 60; i += 10) {
    a = (270 + i) * 1000;
    SinHQ = GUI__SinHQ(a);
    CosHQ = GUI__CosHQ(a);
    y0    = pAnim->ym - ((SinHQ * r0) >> 16);
    y1    = pAnim->ym - ((SinHQ * r1) >> 16);
    x0    = pAnim->xm + ((CosHQ * r0) >> 16);
    x1    = pAnim->xm + ((CosHQ * r1) >> 16);
    GUI_AA_DrawLine(x0 * AA_FACTOR, y0 * AA_FACTOR, x1 * AA_FACTOR, y1 * AA_FACTOR);
    x0 = pAnim->xm - ((CosHQ * r0) >> 16);
    x1 = pAnim->xm - ((CosHQ * r1) >> 16);
    GUI_AA_DrawLine(x0 * AA_FACTOR, y0 * AA_FACTOR, x1 * AA_FACTOR, y1 * AA_FACTOR);
  }
  //
  // Draw center
  //
  GUI_SetPenSize(2);
  SinHQ = GUI__SinHQ(60000);
  CosHQ = GUI__CosHQ(60000);
  s     = (pAnim->d * 3) / 2;
  x0    = pAnim->xm;
  y0    = pAnim->ym + r0;
  y1    = y0 + ((SinHQ * s) >> 16);
  x1    = x0 + ((CosHQ * s) >> 16);
  x2    = x0 - ((CosHQ * s) >> 16);
  GUI_AA_DrawLine(x0 * AA_FACTOR, y0 * AA_FACTOR, x1 * AA_FACTOR, y1 * AA_FACTOR);
  GUI_AA_DrawLine(x0 * AA_FACTOR, y0 * AA_FACTOR, x2 * AA_FACTOR, y1 * AA_FACTOR);
  GUI_AA_DrawLine(x1 * AA_FACTOR, y1 * AA_FACTOR, x2 * AA_FACTOR, y1 * AA_FACTOR);
  GUI_AA_DisableHiRes();
  //
  // Draw text
  //
  GUI_SetPenSize(4);
  GUI_SetTextMode(GUI_TM_TRANS);
  rm = r1 + pAnim->d * 3;
  for (i = 30; i <= 60; i += 30) {
    a = (270 + i) * 1000;
    SinHQ = GUI__SinHQ(a);
    CosHQ = GUI__CosHQ(a);
    ym    = pAnim->ym - ((SinHQ * rm) >> 16);
    xm    = pAnim->xm + ((CosHQ * rm) >> 16);
    GUI_GotoXY(xm, ym);
    GUI_SetTextAlign(GUI_TA_HCENTER | GUI_TA_VCENTER);
    GUI_DispDecMin(i);
    xm = pAnim->xm - ((CosHQ * rm) >> 16);
    GUI_GotoXY(xm, ym);
    GUI_SetTextAlign(GUI_TA_HCENTER | GUI_TA_VCENTER);
    GUI_DispDecMin(i);
  }
}

/*********************************************************************
*
*       Public code
*
**********************************************************************
*/
/*********************************************************************
*
*       MainTask
*/
void MainTask(void) {
  GUI_PID_STATE State;
  ANIM_CONTEXT  Context;
  I32           SpeedPitch;
  I32           SpeedRoll;
  int           Key;
  int           Step;
  int           IndexDraw;
  int           t0;
  int           tNow;
  int           tUsed;
  int           tNext;
  int           Pressed;
  int           PressedOld;

  IndexDraw = 0;
  GUI_Init();
  //
  // Check if recommended memory for the sample is available
  //
  if (GUI_ALLOC_GetNumFreeBytes() < RECOMMENDED_MEMORY) {
    GUI_ErrorOut("Not enough memory available."); 
    return;
  }
  GUI_SetFont(GUI_FONT_20_ASCII);
  if (_InitAnimContext(&Context)) {
    return;
  }
  //
  // Draw button areas (unpressed) and scale
  //
  _DrawButton(&Context, 0, BUTTON_UP);
  _DrawButton(&Context, 0, BUTTON_DOWN);
  _DrawButton(&Context, 0, BUTTON_LEFT);
  _DrawButton(&Context, 0, BUTTON_RIGHT);
  _DrawScale(&Context);
  GUI_DrawBitmap(&_bmSeggerLogo_80x40, 10, 5);
  GUI_SetFont(&GUI_Font24);
  GUI_SetTextAlign(GUI_TA_VCENTER);
  GUI_SetColor(GUI_WHITE);
  GUI_DispStringHCenterAt("Attitude Indicator", (Context.xSizeDisplay + _bmSeggerLogo_80x40.XSize) / 2, 5 + _bmSeggerLogo_80x40.YSize / 2);
  #if GUI_WINSUPPORT
    WM_SetWindowPos(WM_HBKWIN, 0, 0, Context.xSizeDisplay, Context.ySizeDisplay);
  #endif
  Step          = 50;
  Context.Pitch = 0;
  Context.Roll  = 0;
  SpeedPitch    =  750; // Millidegrees / s
  SpeedRoll     = 1250; // Millidegrees / s
  PressedOld    = 0;
  t0            = GUI_GetTime();
  do {
    //
    // Draw attitude indicator
    //
    tNext = t0 + 40;
    GUI_MULTIBUF_Begin();
    _ShowAttitudeIndicator(&Context);
    GUI_MULTIBUF_End();
    tNow = GUI_GetTime();
    if (tNext > tNow) {
      GUI_X_Delay(tNext - tNow);
    }
    tUsed = GUI_GetTime() - t0;
    //
    // Manage keyboard
    //
    Key   = GUI_GetKey();
    //
    // Manage touch input
    //
    if (Key == 0) {
      Pressed = 0;
      if (GUI_PID_GetState(&State)) {
        if ((State.y >= Context.RectLR.y0) && (State.y <= Context.RectLR.y1)) {
          if ((State.x >= Context.RectLR.x0) && (State.x <= Context.RectLR.x1)) {
            Pressed = 1;
            if (State.x < (Context.RectLR.x0 + Context.RectLR.x1) / 2) {
              Key       = GUI_KEY_LEFT;
              IndexDraw = BUTTON_LEFT;
            } else {
              Key       = GUI_KEY_RIGHT;
              IndexDraw = BUTTON_RIGHT;
            }
          } else if ((State.x >= Context.RectUD.x0) && (State.x <= Context.RectUD.x1)) {
            Pressed = 1;
            if (State.y < (Context.RectUD.y0 + Context.RectUD.y1) / 2) {
              Key       = GUI_KEY_UP;
              IndexDraw = BUTTON_UP;
            } else {
              Key       = GUI_KEY_DOWN;
              IndexDraw = BUTTON_DOWN;
            }
          }
        }
      }
      if (Pressed != PressedOld) {
        GUI_AA_DisableHiRes();
        _DrawButton(&Context, Pressed, IndexDraw);
        PressedOld = Pressed;
      }
    }
    switch (Key) {
    case GUI_KEY_UP:
      SpeedPitch -= Step;
      break;
    case GUI_KEY_DOWN:
      SpeedPitch += Step;
      break;
    case GUI_KEY_LEFT:
      SpeedRoll  += Step;
      break;
    case GUI_KEY_RIGHT:
      SpeedRoll  -= Step;
      break;
    }
    if (SpeedRoll > +SPEED_MAX_ROLL) {
      SpeedRoll = +SPEED_MAX_ROLL;
    }
    if (SpeedRoll < -SPEED_MAX_ROLL) {
      SpeedRoll = -SPEED_MAX_ROLL;
    }
    if (SpeedPitch > +SPEED_MAX_PITCH) {
      SpeedPitch = +SPEED_MAX_PITCH;
    }
    if (SpeedPitch < -SPEED_MAX_PITCH) {
      SpeedPitch = -SPEED_MAX_PITCH;
    }
    //
    // Change pitch and roll in dependence of speed
    //
    Context.Pitch += SpeedPitch * tUsed / 1000;
    Context.Roll  += SpeedRoll  * tUsed / 1000;
    if (Context.Pitch < -60000) {
      Context.Pitch = -60000;
      SpeedPitch    = -SpeedPitch;
    }
    if (Context.Pitch > +60000) {
      Context.Pitch = +60000;
      SpeedPitch    = -SpeedPitch;
    }
    if (Context.Roll < -60000) {
      Context.Roll = -60000;
      SpeedRoll    = -SpeedRoll;
    }
    if (Context.Roll > 60000) {
      Context.Roll = 60000;
      SpeedRoll    = -SpeedRoll;
    }
    t0 = tNow;
  } while (1);
}

/*************************** End of file ****************************/
