/*********************************************************************
*                SEGGER Microcontroller GmbH & Co. KG                *
*        Solutions for real time microcontroller applications        *
**********************************************************************
*                                                                    *
*        (c) 1996 - 2016  SEGGER Microcontroller GmbH & Co. KG       *
*                                                                    *
*        Internet: www.segger.com    Support:  support@segger.com    *
*                                                                    *
**********************************************************************

** emWin V5.34 - Graphical user interface for embedded applications **
All  Intellectual Property rights  in the Software belongs to  SEGGER.
emWin is protected by  international copyright laws.  Knowledge of the
source code may not be used to write a similar product.  This file may
only be used in accordance with the following terms:

The  software has  been licensed  to Silicon Labs Norway, a subsidiary
of Silicon Labs Inc. whose registered office is 400 West Cesar Chavez,
Austin,  TX 78701, USA solely for  the purposes of creating  libraries 
for its  ARM Cortex-M3, M4F  processor-based devices,  sublicensed and 
distributed  under the  terms and conditions  of the  End User License  
Agreement supplied by Silicon Labs.
Full source code is available at: www.segger.com

We appreciate your understanding and fairness.
----------------------------------------------------------------------
Licensing information

Licensor:                 SEGGER Software GmbH
Licensed to:              Silicon Laboratories Norway
Licensed SEGGER software: emWin
License number:           GUI-00140
License model:            See Agreement, dated 20th April 2012
Licensed product:         - 
Licensed platform:        Cortex M3, Cortex M4F
Licensed number of seats: -
----------------------------------------------------------------------
File        : MEMDEV_BitmapSpeedometer.c
Purpose     : Shows how to use memory devices for rotation.
Requirements: WindowManager - ( )
              MemoryDevices - (x)
              AntiAliasing  - (x)
              VNC-Server    - ( )
              PNG-Library   - ( )
              TrueTypeFonts - ( )
---------------------------END-OF-HEADER------------------------------
*/
#include <stdlib.h>

#include "GUI.h"

/*********************************************************************
*
*       Defines
*
**********************************************************************
*/
#define COLOR_BACK0    0xFF3333
#define COLOR_BACK1    0x550000
#define COLOR_NEEDLE   0x2080FF
#define R_CHECK  75
#define R_RING  110
#define R_KNOB   10
#define T_MAX       10000
#define T_ROLL       2000
#define MAG 6
#define T_MIN_FRAME  20

//
// Recommended memory to run the sample with adequate performance
//
#define RECOMMENDED_MEMORY (1024L * 1300)

/*********************************************************************
*
*       Static (const) data
*
**********************************************************************
*/
static const char _acText[] = "Speedometer\nDemo\n";

/*********************************************************************
*
*       GUI_FontRounded16 (needed to display "kmh" - "mph")
*/
GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0057[ 66] = { // Code 0057, LATIN CAPITAL LETTER W
  0x46, 0x00, 0x06, 0x70, 0x00, 0x64,
  0xDF, 0x20, 0x2F, 0xF3, 0x01, 0xFD,
  0xAF, 0x60, 0x6F, 0xF7, 0x05, 0xFA,
  0x6F, 0x90, 0x9E, 0xEA, 0x08, 0xF7,
  0x2F, 0xC0, 0xDB, 0xAE, 0x0B, 0xF3,
  0x0E, 0xF2, 0xF7, 0x7F, 0x2E, 0xE0,
  0x09, 0xF7, 0xF4, 0x3F, 0x7F, 0xA0,
  0x06, 0xFE, 0xF0, 0x0E, 0xEF, 0x60,
  0x02, 0xFF, 0xB0, 0x0B, 0xFF, 0x20,
  0x00, 0xCF, 0x70, 0x06, 0xFD, 0x00,
  0x00, 0x12, 0x00, 0x00, 0x21, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0065[ 32] = { // Code 0065, LATIN SMALL LETTER E
  0x02, 0xAE, 0xEB, 0x20,
  0x0D, 0xE7, 0x7E, 0xE1,
  0x6F, 0x82, 0x28, 0xF6,
  0x7F, 0xFF, 0xFF, 0xF6,
  0x7F, 0x70, 0x00, 0x30,
  0x2E, 0xE7, 0x6C, 0xF1,
  0x04, 0xDF, 0xFE, 0x70,
  0x00, 0x02, 0x20, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0068[ 44] = { // Code 0068, LATIN SMALL LETTER H
  0x07, 0x30, 0x00, 0x00,
  0x4F, 0x90, 0x00, 0x00,
  0x4F, 0x90, 0x00, 0x00,
  0x4F, 0xAA, 0xED, 0x50,
  0x4F, 0xFB, 0xAF, 0xF1,
  0x4F, 0xC0, 0x0C, 0xF3,
  0x4F, 0x90, 0x0B, 0xF4,
  0x4F, 0x90, 0x0B, 0xF4,
  0x4F, 0x90, 0x0B, 0xF4,
  0x3F, 0x90, 0x0A, 0xF2,
  0x02, 0x00, 0x00, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0069[ 22] = { // Code 0069, LATIN SMALL LETTER I
  0x07, 0x40,
  0x2F, 0xB0,
  0x04, 0x20,
  0x1E, 0x80,
  0x2F, 0xB0,
  0x2F, 0xB0,
  0x2F, 0xB0,
  0x2F, 0xB0,
  0x2F, 0xB0,
  0x1F, 0xA0,
  0x01, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_006B[ 44] = { // Code 006B, LATIN SMALL LETTER K
  0x07, 0x30, 0x00, 0x00,
  0x4F, 0x90, 0x00, 0x00,
  0x4F, 0x90, 0x00, 0x00,
  0x4F, 0x90, 0x5E, 0x30,
  0x4F, 0x94, 0xFE, 0x20,
  0x4F, 0xCE, 0xE3, 0x00,
  0x4F, 0xFF, 0xE2, 0x00,
  0x4F, 0xD8, 0xFC, 0x00,
  0x4F, 0x90, 0xBF, 0x80,
  0x3F, 0x90, 0x2E, 0xB0,
  0x01, 0x00, 0x01, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_006D[ 48] = { // Code 006D, LATIN SMALL LETTER M
  0x2E, 0x69, 0xED, 0x38, 0xEE, 0x70,
  0x4F, 0xEB, 0xBF, 0xED, 0xAF, 0xF3,
  0x4F, 0xC0, 0x0F, 0xF2, 0x0A, 0xF4,
  0x4F, 0x90, 0x0F, 0xF0, 0x09, 0xF4,
  0x4F, 0x90, 0x0F, 0xF0, 0x09, 0xF4,
  0x4F, 0x90, 0x0F, 0xF0, 0x09, 0xF4,
  0x3F, 0x90, 0x0D, 0xE0, 0x08, 0xF3,
  0x02, 0x00, 0x01, 0x10, 0x00, 0x20
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_006E[ 32] = { // Code 006E, LATIN SMALL LETTER N
  0x2E, 0x6A, 0xED, 0x50,
  0x4F, 0xFB, 0xAF, 0xF1,
  0x4F, 0xC0, 0x0C, 0xF3,
  0x4F, 0x90, 0x0B, 0xF4,
  0x4F, 0x90, 0x0B, 0xF4,
  0x4F, 0x90, 0x0B, 0xF4,
  0x3F, 0x90, 0x0A, 0xF2,
  0x02, 0x00, 0x00, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded16_0070[ 40] = { // Code 0070, LATIN SMALL LETTER P
  0x2E, 0x7B, 0xFC, 0x30,
  0x4F, 0xFA, 0x9F, 0xE1,
  0x4F, 0xB0, 0x0A, 0xF5,
  0x4F, 0x80, 0x06, 0xF7,
  0x4F, 0xA0, 0x08, 0xF6,
  0x4F, 0xF7, 0x7E, 0xF2,
  0x4F, 0xBD, 0xFF, 0x50,
  0x4F, 0x90, 0x21, 0x00,
  0x4F, 0x90, 0x00, 0x00,
  0x19, 0x40, 0x00, 0x00
};

GUI_CONST_STORAGE GUI_CHARINFO_EXT GUI_FontRounded16_CharInfo[8] = {
   {  12,  11,   0,   3,  12, acGUI_FontRounded16_0057 } // Code 0057, LATIN CAPITAL LETTER W
  ,{   8,   8,   0,   6,   8, acGUI_FontRounded16_0065 } // Code 0065, LATIN SMALL LETTER E
  ,{   8,  11,   0,   3,   8, acGUI_FontRounded16_0068 } // Code 0068, LATIN SMALL LETTER H
  ,{   3,  11,   0,   3,   4, acGUI_FontRounded16_0069 } // Code 0069, LATIN SMALL LETTER I
  ,{   7,  11,   0,   3,   7, acGUI_FontRounded16_006B } // Code 006B, LATIN SMALL LETTER K
  ,{  12,   8,   0,   6,  12, acGUI_FontRounded16_006D } // Code 006D, LATIN SMALL LETTER M
  ,{   8,   8,   0,   6,   8, acGUI_FontRounded16_006E } // Code 006E, LATIN SMALL LETTER N
  ,{   8,  10,   0,   6,   8, acGUI_FontRounded16_0070 } // Code 0070, LATIN SMALL LETTER P
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_FontRounded16_Prop6 = {
   0x0070                                   // First character
  ,0x0070                                   // Last character 
  ,&GUI_FontRounded16_CharInfo[  7]         // Address of first character
  ,(GUI_CONST_STORAGE GUI_FONT_PROP_EXT *)0 // Pointer to next GUI_FONT_PROP_EXT
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_FontRounded16_Prop5 = {
   0x006D                                   // First character
  ,0x006E                                   // Last character 
  ,&GUI_FontRounded16_CharInfo[  5]         // Address of first character
  ,&GUI_FontRounded16_Prop6                 // Pointer to next GUI_FONT_PROP_EXT
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_FontRounded16_Prop4 = {
   0x006B                                   // First character
  ,0x006B                                   // Last character 
  ,&GUI_FontRounded16_CharInfo[  4]         // Address of first character
  ,&GUI_FontRounded16_Prop5                 // Pointer to next GUI_FONT_PROP_EXT
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_FontRounded16_Prop3 = {
   0x0068                                   // First character
  ,0x0069                                   // Last character 
  ,&GUI_FontRounded16_CharInfo[  2]         // Address of first character
  ,&GUI_FontRounded16_Prop4                 // Pointer to next GUI_FONT_PROP_EXT
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_FontRounded16_Prop2 = {
   0x0065                                   // First character
  ,0x0065                                   // Last character 
  ,&GUI_FontRounded16_CharInfo[  1]         // Address of first character
  ,&GUI_FontRounded16_Prop3                 // Pointer to next GUI_FONT_PROP_EXT
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_FontRounded16_Prop1 = {
   0x0057                                   // First character
  ,0x0057                                   // Last character 
  ,&GUI_FontRounded16_CharInfo[  0]         // Address of first character
  ,&GUI_FontRounded16_Prop2                 // Pointer to next GUI_FONT_PROP_EXT
};

GUI_CONST_STORAGE GUI_FONT GUI_FontRounded16 = {
   GUI_FONTTYPE_PROP_AA4_EXT // type of font   
  ,16 // height of font 
  ,16 // space of font y
  ,1  // magnification x
  ,1  // magnification y
  ,{&GUI_FontRounded16_Prop1}
  ,16 // Baseline
  ,8  // Height of lowercase characters
  ,11 // Height of capital characters
};

/*********************************************************************
*
*       GUI_FontDigit19 (needed for digital display)
*/
GUI_CONST_STORAGE unsigned char acGUI_FontDigit19_0030[133] = { // Code 0030, DIGIT ZERO
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x7C, 0xFF, 0xFB, 0x40, 0x00,
  0x00, 0x1B, 0xFF, 0xFF, 0xFF, 0xF7, 0x00,
  0x00, 0x9F, 0xFF, 0xED, 0xFF, 0xFF, 0x50,
  0x03, 0xFF, 0xFA, 0x00, 0x2D, 0xFF, 0xD0,
  0x08, 0xFF, 0xF1, 0x00, 0x05, 0xFF, 0xF3,
  0x0C, 0xFF, 0xB0, 0x00, 0x01, 0xFF, 0xF7,
  0x0E, 0xFF, 0x80, 0x00, 0x00, 0xDF, 0xFA,
  0x0F, 0xFF, 0x70, 0x00, 0x00, 0xBF, 0xFB,
  0x0F, 0xFF, 0x70, 0x00, 0x00, 0xBF, 0xFB,
  0x0F, 0xFF, 0x70, 0x00, 0x00, 0xBF, 0xFB,
  0x0E, 0xFF, 0x80, 0x00, 0x00, 0xDF, 0xF9,
  0x0C, 0xFF, 0xA0, 0x00, 0x00, 0xFF, 0xF7,
  0x08, 0xFF, 0xE0, 0x00, 0x03, 0xFF, 0xF4,
  0x03, 0xFF, 0xF7, 0x00, 0x0B, 0xFF, 0xE0,
  0x00, 0xBF, 0xFF, 0xB9, 0xCF, 0xFF, 0x60,
  0x00, 0x2E, 0xFF, 0xFF, 0xFF, 0xFA, 0x00,
  0x00, 0x01, 0xAF, 0xFF, 0xFE, 0x70, 0x00,
  0x00, 0x00, 0x01, 0x44, 0x30, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontDigit19_0031[133] = { // Code 0031, DIGIT ONE
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xBF, 0x70,
  0x00, 0x00, 0x00, 0x00, 0x07, 0xFF, 0xB0,
  0x00, 0x00, 0x00, 0x00, 0x4E, 0xFF, 0xB0,
  0x00, 0x00, 0x04, 0x8C, 0xFF, 0xFF, 0xB0,
  0x00, 0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0xB0,
  0x00, 0x00, 0x2E, 0xFF, 0xFF, 0xFF, 0xB0,
  0x00, 0x00, 0x00, 0x22, 0x2D, 0xFF, 0xB0,
  0x00, 0x00, 0x00, 0x00, 0x0D, 0xFF, 0xB0,
  0x00, 0x00, 0x00, 0x00, 0x0D, 0xFF, 0xB0,
  0x00, 0x00, 0x00, 0x00, 0x0D, 0xFF, 0xB0,
  0x00, 0x00, 0x00, 0x00, 0x0D, 0xFF, 0xB0,
  0x00, 0x00, 0x00, 0x00, 0x0D, 0xFF, 0xB0,
  0x00, 0x00, 0x00, 0x00, 0x0D, 0xFF, 0xB0,
  0x00, 0x00, 0x00, 0x00, 0x0D, 0xFF, 0xB0,
  0x00, 0x00, 0x00, 0x00, 0x0D, 0xFF, 0xB0,
  0x00, 0x00, 0x00, 0x00, 0x0D, 0xFF, 0xB0,
  0x00, 0x00, 0x00, 0x00, 0x09, 0xFF, 0x70,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x33, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontDigit19_0032[126] = { // Code 0032, DIGIT TWO
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x02, 0x8D, 0xFF, 0xFB, 0x50, 0x00,
  0x00, 0x5E, 0xFF, 0xFF, 0xFF, 0xFB, 0x10,
  0x04, 0xFF, 0xFF, 0xED, 0xFF, 0xFF, 0xA0,
  0x0D, 0xFF, 0xE4, 0x00, 0x2D, 0xFF, 0xF2,
  0x1F, 0xFF, 0x70, 0x00, 0x05, 0xFF, 0xF6,
  0x1F, 0xFF, 0x10, 0x00, 0x04, 0xFF, 0xF5,
  0x06, 0xB6, 0x00, 0x00, 0x08, 0xFF, 0xF3,
  0x00, 0x00, 0x00, 0x00, 0x6F, 0xFF, 0xC0,
  0x00, 0x00, 0x00, 0x2A, 0xFF, 0xFE, 0x30,
  0x00, 0x00, 0x06, 0xEF, 0xFF, 0xD3, 0x00,
  0x00, 0x02, 0xBF, 0xFF, 0xE7, 0x00, 0x00,
  0x00, 0x3E, 0xFF, 0xFA, 0x10, 0x00, 0x00,
  0x02, 0xEF, 0xFD, 0x40, 0x00, 0x00, 0x00,
  0x0B, 0xFF, 0xE1, 0x00, 0x00, 0x00, 0x00,
  0x2F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE3,
  0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF7,
  0x09, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xD3
};

GUI_CONST_STORAGE unsigned char acGUI_FontDigit19_0033[133] = { // Code 0033, DIGIT THREE
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x04, 0xAE, 0xFF, 0xEA, 0x30, 0x00,
  0x00, 0x9F, 0xFF, 0xFF, 0xFF, 0xF7, 0x00,
  0x07, 0xFF, 0xFF, 0xDE, 0xFF, 0xFF, 0x30,
  0x0C, 0xFF, 0xD2, 0x00, 0x5F, 0xFF, 0x70,
  0x0C, 0xFF, 0x30, 0x00, 0x0C, 0xFF, 0x90,
  0x03, 0x75, 0x00, 0x00, 0x0C, 0xFF, 0x80,
  0x00, 0x00, 0x00, 0x13, 0x8F, 0xFF, 0x20,
  0x00, 0x00, 0x06, 0xFF, 0xFF, 0xE5, 0x00,
  0x00, 0x00, 0x09, 0xFF, 0xFF, 0xFA, 0x10,
  0x00, 0x00, 0x01, 0x8B, 0xEF, 0xFF, 0x90,
  0x00, 0x00, 0x00, 0x00, 0x1D, 0xFF, 0xF1,
  0x03, 0x72, 0x00, 0x00, 0x08, 0xFF, 0xF2,
  0x2F, 0xFD, 0x00, 0x00, 0x09, 0xFF, 0xF2,
  0x3F, 0xFF, 0x80, 0x00, 0x2E, 0xFF, 0xD0,
  0x0D, 0xFF, 0xFC, 0x9A, 0xEF, 0xFF, 0x70,
  0x03, 0xEF, 0xFF, 0xFF, 0xFF, 0xFA, 0x00,
  0x00, 0x2A, 0xFF, 0xFF, 0xFD, 0x60, 0x00,
  0x00, 0x00, 0x14, 0x44, 0x20, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontDigit19_0034[133] = { // Code 0034, DIGIT FOUR
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xAF, 0xE3, 0x00,
  0x00, 0x00, 0x00, 0x08, 0xFF, 0xF7, 0x00,
  0x00, 0x00, 0x00, 0x5F, 0xFF, 0xF7, 0x00,
  0x00, 0x00, 0x02, 0xEF, 0xFF, 0xF7, 0x00,
  0x00, 0x00, 0x1C, 0xFD, 0xEF, 0xF7, 0x00,
  0x00, 0x00, 0xAF, 0xF3, 0xDF, 0xF7, 0x00,
  0x00, 0x07, 0xFF, 0x60, 0xDF, 0xF7, 0x00,
  0x00, 0x3F, 0xFA, 0x00, 0xDF, 0xF7, 0x00,
  0x01, 0xEF, 0xD1, 0x00, 0xDF, 0xF7, 0x00,
  0x0B, 0xFF, 0x30, 0x00, 0xDF, 0xF7, 0x00,
  0x7F, 0xFD, 0x99, 0x99, 0xEF, 0xFC, 0x95,
  0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0x4F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC,
  0x01, 0x22, 0x22, 0x22, 0xDF, 0xF8, 0x20,
  0x00, 0x00, 0x00, 0x00, 0xDF, 0xF7, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xDF, 0xF7, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xAF, 0xF5, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x30, 0x00,
};

GUI_CONST_STORAGE unsigned char acGUI_FontDigit19_0035[126] = { // Code 0035, DIGIT FIVE
  0x00, 0x4B, 0xBB, 0xBB, 0xBB, 0xB9, 0x00,
  0x00, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0x40,
  0x02, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x20,
  0x05, 0xFF, 0xA4, 0x44, 0x44, 0x42, 0x00,
  0x07, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x00,
  0x0A, 0xFF, 0x40, 0x12, 0x10, 0x00, 0x00,
  0x0C, 0xFF, 0x7D, 0xFF, 0xFD, 0x60, 0x00,
  0x0E, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0x00,
  0x0E, 0xFF, 0xEA, 0x8B, 0xFF, 0xFF, 0x60,
  0x04, 0xB8, 0x10, 0x00, 0x3E, 0xFF, 0xC0,
  0x00, 0x00, 0x00, 0x00, 0x09, 0xFF, 0xF0,
  0x00, 0x00, 0x00, 0x00, 0x06, 0xFF, 0xF2,
  0x07, 0xB4, 0x00, 0x00, 0x09, 0xFF, 0xF0,
  0x3F, 0xFE, 0x30, 0x00, 0x3F, 0xFF, 0xB0,
  0x2F, 0xFF, 0xF9, 0x69, 0xFF, 0xFF, 0x40,
  0x08, 0xFF, 0xFF, 0xFF, 0xFF, 0xF7, 0x00,
  0x00, 0x5D, 0xFF, 0xFF, 0xFB, 0x40, 0x00,
  0x00, 0x00, 0x24, 0x44, 0x10, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontDigit19_0036[133] = { // Code 0036, DIGIT SIX
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x4A, 0xEF, 0xFE, 0xA3, 0x00,
  0x00, 0x08, 0xFF, 0xFF, 0xFF, 0xFF, 0x40,
  0x00, 0x7F, 0xFF, 0xC8, 0x9F, 0xFF, 0xD0,
  0x01, 0xEF, 0xF9, 0x00, 0x05, 0xFF, 0xD0,
  0x06, 0xFF, 0xE0, 0x00, 0x00, 0x49, 0x30,
  0x0A, 0xFF, 0x90, 0x00, 0x00, 0x00, 0x00,
  0x0D, 0xFF, 0x73, 0xAD, 0xDC, 0x81, 0x00,
  0x0F, 0xFF, 0xDF, 0xFF, 0xFF, 0xFE, 0x30,
  0x0F, 0xFF, 0xFF, 0xC9, 0xCF, 0xFF, 0xE1,
  0x0F, 0xFF, 0xF6, 0x00, 0x07, 0xFF, 0xF7,
  0x0F, 0xFF, 0xC0, 0x00, 0x00, 0xDF, 0xFA,
  0x0E, 0xFF, 0x90, 0x00, 0x00, 0xBF, 0xFB,
  0x0B, 0xFF, 0xB0, 0x00, 0x00, 0xDF, 0xFA,
  0x06, 0xFF, 0xF4, 0x00, 0x04, 0xFF, 0xF7,
  0x00, 0xDF, 0xFE, 0x96, 0x9F, 0xFF, 0xE1,
  0x00, 0x3E, 0xFF, 0xFF, 0xFF, 0xFF, 0x40,
  0x00, 0x02, 0xAF, 0xFF, 0xFF, 0xB3, 0x00,
  0x00, 0x00, 0x01, 0x44, 0x41, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontDigit19_0037[126] = { // Code 0037, DIGIT SEVEN
  0x3B, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0x80,
  0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF3,
  0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF2,
  0x03, 0x44, 0x44, 0x44, 0x4D, 0xFF, 0x70,
  0x00, 0x00, 0x00, 0x00, 0x9F, 0xF9, 0x00,
  0x00, 0x00, 0x00, 0x05, 0xFF, 0xC0, 0x00,
  0x00, 0x00, 0x00, 0x1E, 0xFF, 0x30, 0x00,
  0x00, 0x00, 0x00, 0xAF, 0xF9, 0x00, 0x00,
  0x00, 0x00, 0x03, 0xFF, 0xF2, 0x00, 0x00,
  0x00, 0x00, 0x0A, 0xFF, 0xA0, 0x00, 0x00,
  0x00, 0x00, 0x3F, 0xFF, 0x40, 0x00, 0x00,
  0x00, 0x00, 0x9F, 0xFD, 0x00, 0x00, 0x00,
  0x00, 0x01, 0xEF, 0xF9, 0x00, 0x00, 0x00,
  0x00, 0x05, 0xFF, 0xF4, 0x00, 0x00, 0x00,
  0x00, 0x09, 0xFF, 0xF1, 0x00, 0x00, 0x00,
  0x00, 0x0B, 0xFF, 0xC0, 0x00, 0x00, 0x00,
  0x00, 0x07, 0xFF, 0x60, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x33, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontDigit19_0038[133] = { // Code 0038, DIGIT EIGHT
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x02, 0x9D, 0xFF, 0xFC, 0x71, 0x00,
  0x00, 0x5F, 0xFF, 0xFF, 0xFF, 0xFD, 0x20,
  0x01, 0xEF, 0xFF, 0xA8, 0xBF, 0xFF, 0xB0,
  0x07, 0xFF, 0xF3, 0x00, 0x07, 0xFF, 0xF2,
  0x09, 0xFF, 0xC0, 0x00, 0x02, 0xFF, 0xF4,
  0x07, 0xFF, 0xE0, 0x00, 0x03, 0xFF, 0xF2,
  0x01, 0xEF, 0xF9, 0x32, 0x4D, 0xFF, 0xB0,
  0x00, 0x3E, 0xFF, 0xFF, 0xFF, 0xFB, 0x10,
  0x00, 0x6E, 0xFF, 0xFF, 0xFF, 0xFC, 0x30,
  0x05, 0xFF, 0xFC, 0x54, 0x7E, 0xFF, 0xE2,
  0x0D, 0xFF, 0xD1, 0x00, 0x03, 0xFF, 0xF8,
  0x0F, 0xFF, 0x80, 0x00, 0x00, 0xCF, 0xFB,
  0x0F, 0xFF, 0x80, 0x00, 0x00, 0xCF, 0xFB,
  0x0D, 0xFF, 0xD1, 0x00, 0x04, 0xFF, 0xF8,
  0x07, 0xFF, 0xFD, 0x86, 0x9F, 0xFF, 0xF3,
  0x00, 0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0x60,
  0x00, 0x06, 0xDF, 0xFF, 0xFF, 0xB4, 0x00,
  0x00, 0x00, 0x02, 0x44, 0x31, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontDigit19_0039[133] = { // Code 0039, DIGIT NINE
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x02, 0x9D, 0xFF, 0xEB, 0x40, 0x00,
  0x00, 0x5F, 0xFF, 0xFF, 0xFF, 0xF8, 0x00,
  0x03, 0xFF, 0xFF, 0xBA, 0xEF, 0xFF, 0x60,
  0x0A, 0xFF, 0xF3, 0x00, 0x0B, 0xFF, 0xE1,
  0x0E, 0xFF, 0x90, 0x00, 0x02, 0xFF, 0xF5,
  0x0F, 0xFF, 0x70, 0x00, 0x00, 0xFF, 0xF8,
  0x0F, 0xFF, 0x80, 0x00, 0x01, 0xFF, 0xFB,
  0x0D, 0xFF, 0xD1, 0x00, 0x07, 0xFF, 0xFB,
  0x07, 0xFF, 0xFD, 0x76, 0xAF, 0xFF, 0xFB,
  0x00, 0xBF, 0xFF, 0xFF, 0xFF, 0xEF, 0xFA,
  0x00, 0x07, 0xDF, 0xFF, 0xD4, 0xBF, 0xF9,
  0x00, 0x00, 0x02, 0x21, 0x00, 0xDF, 0xF6,
  0x00, 0x25, 0x00, 0x00, 0x02, 0xFF, 0xF2,
  0x02, 0xEF, 0xA0, 0x00, 0x0B, 0xFF, 0xC0,
  0x03, 0xFF, 0xFB, 0x45, 0xBF, 0xFF, 0x40,
  0x00, 0xBF, 0xFF, 0xFF, 0xFF, 0xF7, 0x00,
  0x00, 0x18, 0xFF, 0xFF, 0xFC, 0x50, 0x00,
  0x00, 0x00, 0x13, 0x44, 0x20, 0x00, 0x00
};

GUI_CONST_STORAGE GUI_CHARINFO_EXT GUI_FontDigit19_CharInfo[10] = {
   {  14,  19,   0,   6,  15, acGUI_FontDigit19_0030 } // Code 0030, DIGIT ZERO
  ,{  13,  19,  -1,   6,  15, acGUI_FontDigit19_0031 } // Code 0031, DIGIT ONE
  ,{  14,  18,   0,   6,  15, acGUI_FontDigit19_0032 } // Code 0032, DIGIT TWO
  ,{  14,  19,   0,   6,  15, acGUI_FontDigit19_0033 } // Code 0033, DIGIT THREE
  ,{  14,  19,   0,   6,  15, acGUI_FontDigit19_0034 } // Code 0034, DIGIT FOUR
  ,{  14,  18,   0,   7,  15, acGUI_FontDigit19_0035 } // Code 0035, DIGIT FIVE
  ,{  14,  19,   0,   6,  15, acGUI_FontDigit19_0036 } // Code 0036, DIGIT SIX
  ,{  14,  18,   0,   7,  15, acGUI_FontDigit19_0037 } // Code 0037, DIGIT SEVEN
  ,{  14,  19,   0,   6,  15, acGUI_FontDigit19_0038 } // Code 0038, DIGIT EIGHT
  ,{  14,  19,   0,   6,  15, acGUI_FontDigit19_0039 } // Code 0039, DIGIT NINE
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_FontDigit19_Prop1 = {
   0x0030                                   // First character
  ,0x0039                                   // Last character 
  ,&GUI_FontDigit19_CharInfo[  0]           // Address of first character
  ,(GUI_CONST_STORAGE GUI_FONT_PROP_EXT *)0 // Pointer to next GUI_FONT_PROP_EXT
};

GUI_CONST_STORAGE GUI_FONT GUI_FontDigit19 = {
   GUI_FONTTYPE_PROP_AA4_EXT // type of font   
  ,30 // height of font 
  ,30 // space of font y
  ,1  // magnification x
  ,1  // magnification y
  ,{&GUI_FontDigit19_Prop1}
  ,30 // Baseline
  ,14 // Height of lowercase characters
  ,19 // Height of capital characters
};

/*********************************************************************
*
*       GUI_FontDigit19 (needed for digital display)
*/
GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0020[  1] = { // Code 0020, SPACE
  0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0021[ 63] = { // Code 0021, EXCLAMATION MARK
  0x2A, 0xB7, 0x00,
  0xBF, 0xFF, 0x40,
  0xDF, 0xFF, 0x60,
  0xDF, 0xFF, 0x60,
  0xDF, 0xFF, 0x60,
  0xDF, 0xFF, 0x60,
  0xCF, 0xFF, 0x50,
  0xAF, 0xFF, 0x30,
  0x8F, 0xFF, 0x10,
  0x6F, 0xFE, 0x00,
  0x4F, 0xFC, 0x00,
  0x2F, 0xFA, 0x00,
  0x0F, 0xF8, 0x00,
  0x0B, 0xF4, 0x00,
  0x00, 0x00, 0x00,
  0x02, 0x30, 0x00,
  0x6F, 0xFC, 0x10,
  0xDF, 0xFF, 0x60,
  0xDF, 0xFF, 0x60,
  0x5F, 0xFB, 0x10,
  0x01, 0x20, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0022[ 45] = { // Code 0022, QUOTATION MARK
  0x06, 0xB8, 0x00, 0x3B, 0xA1,
  0x1F, 0xFF, 0x50, 0xCF, 0xF8,
  0x2F, 0xFF, 0x60, 0xDF, 0xF9,
  0x2F, 0xFF, 0x60, 0xDF, 0xF9,
  0x2F, 0xFF, 0x60, 0xDF, 0xF9,
  0x2F, 0xFF, 0x60, 0xDF, 0xF9,
  0x2F, 0xFF, 0x60, 0xDF, 0xF9,
  0x0D, 0xFF, 0x30, 0xAF, 0xF6,
  0x01, 0x63, 0x00, 0x05, 0x40
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0023[168] = { // Code 0023, NUMBER SIGN
  0x00, 0x00, 0x02, 0x20, 0x00, 0x12, 0x00, 0x00,
  0x00, 0x00, 0x4F, 0xF2, 0x03, 0xFF, 0x40, 0x00,
  0x00, 0x00, 0x8F, 0xF3, 0x07, 0xFF, 0x50, 0x00,
  0x00, 0x00, 0xAF, 0xF1, 0x08, 0xFF, 0x30, 0x00,
  0x00, 0x00, 0xCF, 0xE0, 0x0B, 0xFF, 0x10, 0x00,
  0x00, 0x00, 0xFF, 0xC0, 0x0C, 0xFE, 0x00, 0x00,
  0x03, 0x9A, 0xFF, 0xD9, 0x9F, 0xFE, 0x97, 0x00,
  0x0B, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x10,
  0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0x00,
  0x00, 0x08, 0xFF, 0x30, 0x6F, 0xF5, 0x00, 0x00,
  0x00, 0x0A, 0xFF, 0x10, 0x8F, 0xF3, 0x00, 0x00,
  0x00, 0x0C, 0xFE, 0x00, 0xAF, 0xF1, 0x00, 0x00,
  0x3B, 0xBF, 0xFF, 0xBB, 0xEF, 0xFB, 0xA1, 0x00,
  0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF4, 0x00,
  0x3B, 0xCF, 0xFD, 0xBC, 0xFF, 0xEB, 0xA1, 0x00,
  0x00, 0x6F, 0xF6, 0x03, 0xFF, 0x80, 0x00, 0x00,
  0x00, 0x8F, 0xF3, 0x06, 0xFF, 0x60, 0x00, 0x00,
  0x00, 0xAF, 0xF2, 0x08, 0xFF, 0x30, 0x00, 0x00,
  0x00, 0xCF, 0xF0, 0x0A, 0xFF, 0x20, 0x00, 0x00,
  0x00, 0xCF, 0xB0, 0x0A, 0xFD, 0x00, 0x00, 0x00,
  0x00, 0x15, 0x10, 0x01, 0x52, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0024[192] = { // Code 0024, DOLLAR SIGN
  0x00, 0x00, 0x00, 0x03, 0xA0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x19, 0xF4, 0x00, 0x00, 0x00,
  0x00, 0x01, 0x8D, 0xFF, 0xFF, 0xFC, 0x71, 0x00,
  0x00, 0x3E, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0x40,
  0x02, 0xEF, 0xFF, 0xBC, 0xFA, 0xCF, 0xFF, 0xF3,
  0x09, 0xFF, 0xE3, 0x07, 0xF2, 0x08, 0xFF, 0xF7,
  0x0D, 0xFF, 0x80, 0x07, 0xF2, 0x00, 0xAF, 0xF6,
  0x0D, 0xFF, 0x90, 0x07, 0xF2, 0x00, 0x17, 0x50,
  0x0C, 0xFF, 0xF5, 0x07, 0xF2, 0x00, 0x00, 0x00,
  0x07, 0xFF, 0xFF, 0xDC, 0xF4, 0x00, 0x00, 0x00,
  0x00, 0xBF, 0xFF, 0xFF, 0xFF, 0xEA, 0x50, 0x00,
  0x00, 0x08, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x20,
  0x00, 0x00, 0x17, 0xBE, 0xFF, 0xFF, 0xFF, 0xD1,
  0x00, 0x00, 0x00, 0x07, 0xF7, 0xAF, 0xFF, 0xF7,
  0x02, 0x41, 0x00, 0x07, 0xF2, 0x03, 0xEF, 0xFB,
  0x2E, 0xFD, 0x00, 0x07, 0xF2, 0x00, 0x9F, 0xFD,
  0x5F, 0xFF, 0x50, 0x07, 0xF2, 0x00, 0x9F, 0xFC,
  0x2F, 0xFF, 0xC1, 0x07, 0xF2, 0x03, 0xFF, 0xF8,
  0x09, 0xFF, 0xFD, 0x8A, 0xF8, 0xAF, 0xFF, 0xE2,
  0x01, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x50,
  0x00, 0x06, 0xCF, 0xFF, 0xFF, 0xFE, 0xA2, 0x00,
  0x00, 0x00, 0x02, 0x4A, 0xF6, 0x30, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x07, 0xF2, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0xD1, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0025[252] = { // Code 0025, PERCENT SIGN
  0x00, 0x01, 0x32, 0x00, 0x00, 0x00, 0x00, 0x04, 0xD5, 0x00, 0x00, 0x00,
  0x02, 0xBF, 0xFF, 0xD5, 0x00, 0x00, 0x00, 0x0D, 0xF7, 0x00, 0x00, 0x00,
  0x1E, 0xFF, 0xEF, 0xFF, 0x50, 0x00, 0x00, 0x6F, 0xE1, 0x00, 0x00, 0x00,
  0x7F, 0xF9, 0x04, 0xFF, 0xC0, 0x00, 0x00, 0xEF, 0x70, 0x00, 0x00, 0x00,
  0xBF, 0xF3, 0x00, 0xDF, 0xF1, 0x00, 0x07, 0xFE, 0x00, 0x00, 0x00, 0x00,
  0xDF, 0xF1, 0x00, 0xBF, 0xF3, 0x00, 0x1E, 0xF6, 0x00, 0x00, 0x00, 0x00,
  0xDF, 0xF1, 0x00, 0xBF, 0xF3, 0x00, 0x7F, 0xD0, 0x00, 0x00, 0x00, 0x00,
  0xBF, 0xF3, 0x00, 0xDF, 0xF1, 0x01, 0xFF, 0x50, 0x00, 0x00, 0x00, 0x00,
  0x7F, 0xFA, 0x05, 0xFF, 0xC0, 0x08, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x1D, 0xFF, 0xFF, 0xFF, 0x40, 0x2F, 0xF4, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x01, 0xAF, 0xFF, 0xC4, 0x00, 0x9F, 0xB0, 0x02, 0xAE, 0xFD, 0x81, 0x00,
  0x00, 0x00, 0x21, 0x00, 0x03, 0xFF, 0x30, 0x3E, 0xFF, 0xFF, 0xFB, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0A, 0xFA, 0x00, 0xBF, 0xF8, 0x2C, 0xFF, 0x60,
  0x00, 0x00, 0x00, 0x00, 0x3F, 0xF3, 0x01, 0xFF, 0xE0, 0x04, 0xFF, 0xA0,
  0x00, 0x00, 0x00, 0x00, 0xBF, 0x90, 0x03, 0xFF, 0xB0, 0x01, 0xFF, 0xD0,
  0x00, 0x00, 0x00, 0x04, 0xFF, 0x20, 0x03, 0xFF, 0xB0, 0x00, 0xFF, 0xD0,
  0x00, 0x00, 0x00, 0x0C, 0xF8, 0x00, 0x01, 0xFF, 0xC0, 0x03, 0xFF, 0xB0,
  0x00, 0x00, 0x00, 0x5F, 0xE1, 0x00, 0x00, 0xDF, 0xF3, 0x07, 0xFF, 0x80,
  0x00, 0x00, 0x00, 0xDF, 0x70, 0x00, 0x00, 0x6F, 0xFE, 0xCF, 0xFE, 0x20,
  0x00, 0x00, 0x05, 0xFE, 0x10, 0x00, 0x00, 0x07, 0xFF, 0xFF, 0xD3, 0x00,
  0x00, 0x00, 0x06, 0xF6, 0x00, 0x00, 0x00, 0x00, 0x14, 0x63, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0026[189] = { // Code 0026, AMPERSAND
  0x00, 0x00, 0x03, 0x79, 0x97, 0x30, 0x00, 0x00, 0x00,
  0x00, 0x01, 0xAF, 0xFF, 0xFF, 0xFB, 0x10, 0x00, 0x00,
  0x00, 0x0A, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0x00,
  0x00, 0x2F, 0xFF, 0xC3, 0x39, 0xFF, 0xF4, 0x00, 0x00,
  0x00, 0x6F, 0xFF, 0x30, 0x00, 0xEF, 0xF7, 0x00, 0x00,
  0x00, 0x6F, 0xFF, 0x30, 0x00, 0xEF, 0xF7, 0x00, 0x00,
  0x00, 0x3F, 0xFF, 0xB0, 0x07, 0xFF, 0xF5, 0x00, 0x00,
  0x00, 0x0B, 0xFF, 0xFA, 0x9F, 0xFF, 0xD0, 0x00, 0x00,
  0x00, 0x02, 0xEF, 0xFF, 0xFF, 0xFE, 0x30, 0x00, 0x00,
  0x00, 0x07, 0xEF, 0xFF, 0xFF, 0xB2, 0x00, 0x00, 0x00,
  0x01, 0xBF, 0xFF, 0xFF, 0xFF, 0xA0, 0x00, 0x69, 0x40,
  0x0A, 0xFF, 0xFF, 0xAE, 0xFF, 0xF8, 0x04, 0xFF, 0xF1,
  0x4F, 0xFF, 0xE4, 0x05, 0xFF, 0xFF, 0x6C, 0xFF, 0xE0,
  0x9F, 0xFF, 0x60, 0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0x80,
  0xBF, 0xFF, 0x20, 0x00, 0x09, 0xFF, 0xFF, 0xFD, 0x10,
  0xBF, 0xFF, 0x40, 0x00, 0x00, 0xDF, 0xFF, 0xF5, 0x00,
  0x9F, 0xFF, 0xC1, 0x00, 0x1A, 0xFF, 0xFF, 0xFD, 0x10,
  0x3F, 0xFF, 0xFE, 0xBC, 0xFF, 0xFF, 0xFF, 0xFF, 0xB0,
  0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x4E, 0xFF, 0xF1,
  0x00, 0x5D, 0xFF, 0xFF, 0xFD, 0x70, 0x03, 0xEF, 0xA0,
  0x00, 0x00, 0x35, 0x64, 0x20, 0x00, 0x00, 0x12, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0027[ 18] = { // Code 0027, APOSTROPHE
  0x19, 0xB5,
  0x6F, 0xFE,
  0x7F, 0xFF,
  0x7F, 0xFF,
  0x7F, 0xFF,
  0x7F, 0xFF,
  0x7F, 0xFF,
  0x4F, 0xFC,
  0x03, 0x51
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0028[104] = { // Code 0028, LEFT PARENTHESIS
  0x00, 0x00, 0x6D, 0x90,
  0x00, 0x01, 0xEF, 0xF0,
  0x00, 0x08, 0xFF, 0xB0,
  0x00, 0x1E, 0xFF, 0x70,
  0x00, 0x6F, 0xFF, 0x10,
  0x00, 0xCF, 0xFB, 0x00,
  0x02, 0xFF, 0xF7, 0x00,
  0x06, 0xFF, 0xF3, 0x00,
  0x0A, 0xFF, 0xF0, 0x00,
  0x0D, 0xFF, 0xC0, 0x00,
  0x1F, 0xFF, 0xB0, 0x00,
  0x2F, 0xFF, 0x90, 0x00,
  0x2F, 0xFF, 0x90, 0x00,
  0x2F, 0xFF, 0x90, 0x00,
  0x2F, 0xFF, 0xA0, 0x00,
  0x0F, 0xFF, 0xB0, 0x00,
  0x0C, 0xFF, 0xE0, 0x00,
  0x08, 0xFF, 0xF2, 0x00,
  0x04, 0xFF, 0xF5, 0x00,
  0x00, 0xEF, 0xF9, 0x00,
  0x00, 0x9F, 0xFD, 0x00,
  0x00, 0x3F, 0xFF, 0x30,
  0x00, 0x0C, 0xFF, 0x90,
  0x00, 0x05, 0xFF, 0xE0,
  0x00, 0x00, 0xCF, 0xE0,
  0x00, 0x00, 0x16, 0x30
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0029[104] = { // Code 0029, RIGHT PARENTHESIS
  0x9D, 0x60, 0x00, 0x00,
  0xFF, 0xE1, 0x00, 0x00,
  0xBF, 0xF8, 0x00, 0x00,
  0x7F, 0xFE, 0x00, 0x00,
  0x2F, 0xFF, 0x60, 0x00,
  0x0B, 0xFF, 0xC0, 0x00,
  0x07, 0xFF, 0xF2, 0x00,
  0x04, 0xFF, 0xF6, 0x00,
  0x00, 0xFF, 0xFA, 0x00,
  0x00, 0xCF, 0xFD, 0x00,
  0x00, 0xBF, 0xFF, 0x10,
  0x00, 0x9F, 0xFF, 0x20,
  0x00, 0x9F, 0xFF, 0x20,
  0x00, 0x9F, 0xFF, 0x20,
  0x00, 0xAF, 0xFF, 0x20,
  0x00, 0xBF, 0xFF, 0x00,
  0x00, 0xEF, 0xFC, 0x00,
  0x02, 0xFF, 0xF8, 0x00,
  0x05, 0xFF, 0xF4, 0x00,
  0x09, 0xFF, 0xE0, 0x00,
  0x0E, 0xFF, 0x90, 0x00,
  0x3F, 0xFF, 0x30, 0x00,
  0x9F, 0xFB, 0x00, 0x00,
  0xEF, 0xF5, 0x00, 0x00,
  0xEF, 0xC0, 0x00, 0x00,
  0x36, 0x10, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_002A[ 60] = { // Code 002A, ASTERISK
  0x00, 0x00, 0x7B, 0x20, 0x00, 0x00,
  0x00, 0x00, 0xDF, 0x60, 0x00, 0x00,
  0x01, 0x00, 0xDF, 0x60, 0x01, 0x00,
  0x8F, 0xB6, 0xEF, 0x88, 0xEE, 0x20,
  0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0x30,
  0x04, 0x9D, 0xFF, 0xFB, 0x62, 0x00,
  0x00, 0x1D, 0xFF, 0xF7, 0x00, 0x00,
  0x00, 0xBF, 0xE9, 0xFF, 0x40, 0x00,
  0x05, 0xFF, 0x60, 0xCF, 0xC0, 0x00,
  0x02, 0xC9, 0x00, 0x3D, 0x80, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_002B[128] = { // Code 002B, PLUS SIGN
  0x00, 0x00, 0x00, 0x02, 0x30, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x3F, 0xF6, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x7F, 0xFB, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x7F, 0xFB, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x7F, 0xFB, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x7F, 0xFB, 0x00, 0x00, 0x00,
  0x02, 0x44, 0x44, 0x9F, 0xFC, 0x44, 0x44, 0x30,
  0x4F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF7,
  0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB,
  0x2C, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xD4,
  0x00, 0x00, 0x00, 0x7F, 0xFB, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x7F, 0xFB, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x7F, 0xFB, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x7F, 0xFB, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x7F, 0xFA, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x2D, 0xE4, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_002C[ 27] = { // Code 002C, COMMA
  0x00, 0x23, 0x00,
  0x07, 0xFF, 0xB0,
  0x0F, 0xFF, 0xF6,
  0x0F, 0xFF, 0xF9,
  0x07, 0xFF, 0xF9,
  0x00, 0x05, 0xF8,
  0x00, 0x2D, 0xF3,
  0x08, 0xFF, 0x80,
  0x0C, 0xC5, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_002D[ 25] = { // Code 002D, HYPHEN-MINUS
  0x03, 0x56, 0x66, 0x53, 0x00,
  0x9F, 0xFF, 0xFF, 0xFF, 0x90,
  0xDF, 0xFF, 0xFF, 0xFF, 0xD0,
  0xAF, 0xFF, 0xFF, 0xFF, 0xA0,
  0x04, 0x66, 0x66, 0x64, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_002E[ 18] = { // Code 002E, FULL STOP
  0x00, 0x23, 0x00,
  0x07, 0xFF, 0xB0,
  0x0F, 0xFF, 0xF4,
  0x0F, 0xFF, 0xF4,
  0x06, 0xFF, 0xA0,
  0x00, 0x12, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_002F[105] = { // Code 002F, SOLIDUS
  0x00, 0x00, 0x00, 0x09, 0xD5,
  0x00, 0x00, 0x00, 0x3F, 0xFB,
  0x00, 0x00, 0x00, 0x9F, 0xF8,
  0x00, 0x00, 0x00, 0xEF, 0xF2,
  0x00, 0x00, 0x05, 0xFF, 0xB0,
  0x00, 0x00, 0x0B, 0xFF, 0x60,
  0x00, 0x00, 0x2F, 0xFE, 0x10,
  0x00, 0x00, 0x7F, 0xF9, 0x00,
  0x00, 0x00, 0xDF, 0xF3, 0x00,
  0x00, 0x04, 0xFF, 0xD0, 0x00,
  0x00, 0x0A, 0xFF, 0x70, 0x00,
  0x00, 0x1F, 0xFF, 0x20, 0x00,
  0x00, 0x6F, 0xFB, 0x00, 0x00,
  0x00, 0xCF, 0xF5, 0x00, 0x00,
  0x02, 0xFF, 0xE0, 0x00, 0x00,
  0x08, 0xFF, 0x90, 0x00, 0x00,
  0x0E, 0xFF, 0x30, 0x00, 0x00,
  0x4F, 0xFC, 0x00, 0x00, 0x00,
  0xAF, 0xF7, 0x00, 0x00, 0x00,
  0xAF, 0xE1, 0x00, 0x00, 0x00,
  0x17, 0x30, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0030[168] = { // Code 0030, DIGIT ZERO
  0x00, 0x00, 0x00, 0x23, 0x10, 0x00, 0x00, 0x00,
  0x00, 0x03, 0xBF, 0xFF, 0xFD, 0x70, 0x00, 0x00,
  0x00, 0x5F, 0xFF, 0xFF, 0xFF, 0xFC, 0x10, 0x00,
  0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xB0, 0x00,
  0x0C, 0xFF, 0xFA, 0x31, 0x5E, 0xFF, 0xF5, 0x00,
  0x3F, 0xFF, 0xD0, 0x00, 0x06, 0xFF, 0xFB, 0x00,
  0x8F, 0xFF, 0x70, 0x00, 0x00, 0xEF, 0xFF, 0x10,
  0xBF, 0xFF, 0x40, 0x00, 0x00, 0xBF, 0xFF, 0x40,
  0xDF, 0xFF, 0x20, 0x00, 0x00, 0x9F, 0xFF, 0x60,
  0xEF, 0xFF, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0x70,
  0xFF, 0xFF, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0x70,
  0xDF, 0xFF, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0x70,
  0xCF, 0xFF, 0x10, 0x00, 0x00, 0x8F, 0xFF, 0x50,
  0xAF, 0xFF, 0x30, 0x00, 0x00, 0xAF, 0xFF, 0x30,
  0x7F, 0xFF, 0x60, 0x00, 0x00, 0xDF, 0xFF, 0x10,
  0x3F, 0xFF, 0xB0, 0x00, 0x04, 0xFF, 0xFB, 0x00,
  0x0C, 0xFF, 0xF8, 0x00, 0x3D, 0xFF, 0xF5, 0x00,
  0x04, 0xFF, 0xFF, 0xFD, 0xFF, 0xFF, 0xB0, 0x00,
  0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xFD, 0x10, 0x00,
  0x00, 0x04, 0xDF, 0xFF, 0xFF, 0x91, 0x00, 0x00,
  0x00, 0x00, 0x02, 0x56, 0x31, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0031[105] = { // Code 0031, DIGIT ONE
  0x00, 0x00, 0x00, 0x01, 0x20,
  0x00, 0x00, 0x00, 0x4F, 0xF7,
  0x00, 0x00, 0x00, 0xDF, 0xFB,
  0x00, 0x00, 0x08, 0xFF, 0xFB,
  0x00, 0x37, 0xBF, 0xFF, 0xFB,
  0x1D, 0xFF, 0xFF, 0xFF, 0xFB,
  0x3F, 0xFF, 0xFF, 0xFF, 0xFB,
  0x09, 0xBB, 0xBD, 0xFF, 0xFB,
  0x00, 0x00, 0x06, 0xFF, 0xFB,
  0x00, 0x00, 0x06, 0xFF, 0xFB,
  0x00, 0x00, 0x06, 0xFF, 0xFB,
  0x00, 0x00, 0x06, 0xFF, 0xFB,
  0x00, 0x00, 0x06, 0xFF, 0xFB,
  0x00, 0x00, 0x06, 0xFF, 0xFB,
  0x00, 0x00, 0x06, 0xFF, 0xFB,
  0x00, 0x00, 0x06, 0xFF, 0xFB,
  0x00, 0x00, 0x06, 0xFF, 0xFB,
  0x00, 0x00, 0x06, 0xFF, 0xFB,
  0x00, 0x00, 0x05, 0xFF, 0xFA,
  0x00, 0x00, 0x01, 0xEF, 0xF5,
  0x00, 0x00, 0x00, 0x15, 0x30
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0032[160] = { // Code 0032, DIGIT TWO
  0x00, 0x00, 0x00, 0x13, 0x32, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x6C, 0xFF, 0xFF, 0xD8, 0x10, 0x00,
  0x00, 0x1C, 0xFF, 0xFF, 0xFF, 0xFF, 0xE3, 0x00,
  0x01, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x30,
  0x08, 0xFF, 0xFE, 0x61, 0x15, 0xEF, 0xFF, 0xB0,
  0x0E, 0xFF, 0xF4, 0x00, 0x00, 0x5F, 0xFF, 0xF0,
  0x0F, 0xFF, 0xC0, 0x00, 0x00, 0x1F, 0xFF, 0xF0,
  0x0D, 0xFF, 0x60, 0x00, 0x00, 0x2F, 0xFF, 0xF0,
  0x01, 0x55, 0x00, 0x00, 0x00, 0x8F, 0xFF, 0xB0,
  0x00, 0x00, 0x00, 0x00, 0x07, 0xFF, 0xFF, 0x40,
  0x00, 0x00, 0x00, 0x03, 0xCF, 0xFF, 0xF9, 0x00,
  0x00, 0x00, 0x01, 0x8F, 0xFF, 0xFF, 0x70, 0x00,
  0x00, 0x00, 0x3D, 0xFF, 0xFF, 0xB3, 0x00, 0x00,
  0x00, 0x06, 0xFF, 0xFF, 0xD5, 0x00, 0x00, 0x00,
  0x00, 0x7F, 0xFF, 0xF8, 0x10, 0x00, 0x00, 0x00,
  0x04, 0xFF, 0xFE, 0x40, 0x00, 0x00, 0x00, 0x00,
  0x0C, 0xFF, 0xFA, 0x66, 0x66, 0x66, 0x66, 0x20,
  0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE1,
  0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF2,
  0x07, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xA0
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0033[168] = { // Code 0033, DIGIT THREE
  0x00, 0x00, 0x00, 0x13, 0x31, 0x00, 0x00, 0x00,
  0x00, 0x01, 0x8D, 0xFF, 0xFF, 0xD7, 0x00, 0x00,
  0x00, 0x5E, 0xFF, 0xFF, 0xFF, 0xFF, 0xB1, 0x00,
  0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x00,
  0x09, 0xFF, 0xFD, 0x41, 0x29, 0xFF, 0xFE, 0x00,
  0x0B, 0xFF, 0xE2, 0x00, 0x00, 0xBF, 0xFF, 0x30,
  0x06, 0xFF, 0x50, 0x00, 0x00, 0x9F, 0xFF, 0x30,
  0x00, 0x11, 0x00, 0x00, 0x00, 0xCF, 0xFE, 0x00,
  0x00, 0x00, 0x00, 0x15, 0x7C, 0xFF, 0xF7, 0x00,
  0x00, 0x00, 0x00, 0xDF, 0xFF, 0xFF, 0x70, 0x00,
  0x00, 0x00, 0x00, 0xEF, 0xFF, 0xFF, 0xE5, 0x00,
  0x00, 0x00, 0x00, 0x4A, 0xCF, 0xFF, 0xFF, 0x30,
  0x00, 0x00, 0x00, 0x00, 0x02, 0xDF, 0xFF, 0x90,
  0x00, 0x31, 0x00, 0x00, 0x00, 0x6F, 0xFF, 0xB0,
  0x0B, 0xFE, 0x30, 0x00, 0x00, 0x6F, 0xFF, 0xB0,
  0x2F, 0xFF, 0xB0, 0x00, 0x00, 0x9F, 0xFF, 0xA0,
  0x1F, 0xFF, 0xF8, 0x00, 0x06, 0xFF, 0xFF, 0x50,
  0x09, 0xFF, 0xFF, 0xFD, 0xFF, 0xFF, 0xFC, 0x00,
  0x01, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xD1, 0x00,
  0x00, 0x07, 0xDF, 0xFF, 0xFF, 0xD7, 0x10, 0x00,
  0x00, 0x00, 0x03, 0x46, 0x42, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0034[168] = { // Code 0034, DIGIT FOUR
  0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0B, 0xFF, 0x90, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x8F, 0xFF, 0xE0, 0x00,
  0x00, 0x00, 0x00, 0x05, 0xFF, 0xFF, 0xF0, 0x00,
  0x00, 0x00, 0x00, 0x2E, 0xFF, 0xFF, 0xF0, 0x00,
  0x00, 0x00, 0x01, 0xDF, 0xFF, 0xFF, 0xF0, 0x00,
  0x00, 0x00, 0x0A, 0xFF, 0x7D, 0xFF, 0xF0, 0x00,
  0x00, 0x00, 0x7F, 0xFB, 0x0D, 0xFF, 0xF0, 0x00,
  0x00, 0x04, 0xFF, 0xD1, 0x0D, 0xFF, 0xF0, 0x00,
  0x00, 0x2E, 0xFF, 0x30, 0x0D, 0xFF, 0xF0, 0x00,
  0x00, 0xCF, 0xF7, 0x00, 0x0D, 0xFF, 0xF0, 0x00,
  0x09, 0xFF, 0xB0, 0x00, 0x0D, 0xFF, 0xF0, 0x00,
  0x4F, 0xFF, 0x76, 0x66, 0x6E, 0xFF, 0xF6, 0x51,
  0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA,
  0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC,
  0x08, 0xBB, 0xBB, 0xBB, 0xBF, 0xFF, 0xFB, 0xA3,
  0x00, 0x00, 0x00, 0x00, 0x0D, 0xFF, 0xF0, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0D, 0xFF, 0xF0, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0C, 0xFF, 0xF0, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x08, 0xFF, 0xB0, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x45, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0035[160] = { // Code 0035, DIGIT FIVE
  0x00, 0x2B, 0xDD, 0xDD, 0xDD, 0xDD, 0xC4, 0x00,
  0x00, 0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00,
  0x00, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0x00,
  0x01, 0xFF, 0xFB, 0x99, 0x99, 0x99, 0x72, 0x00,
  0x03, 0xFF, 0xF1, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x06, 0xFF, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x08, 0xFF, 0xB0, 0x58, 0x97, 0x40, 0x00, 0x00,
  0x0B, 0xFF, 0xCE, 0xFF, 0xFF, 0xFD, 0x40, 0x00,
  0x0D, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF4, 0x00,
  0x0C, 0xFF, 0xFC, 0x87, 0xBF, 0xFF, 0xFE, 0x10,
  0x03, 0xBB, 0x50, 0x00, 0x03, 0xEF, 0xFF, 0x60,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0xA0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x4F, 0xFF, 0xB0,
  0x00, 0x52, 0x00, 0x00, 0x00, 0x5F, 0xFF, 0xA0,
  0x0C, 0xFE, 0x30, 0x00, 0x00, 0xBF, 0xFF, 0x70,
  0x2F, 0xFF, 0xE3, 0x00, 0x08, 0xFF, 0xFF, 0x30,
  0x0D, 0xFF, 0xFF, 0xCB, 0xEF, 0xFF, 0xF9, 0x00,
  0x03, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xA0, 0x00,
  0x00, 0x29, 0xFF, 0xFF, 0xFF, 0xC5, 0x00, 0x00,
  0x00, 0x00, 0x03, 0x56, 0x41, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0036[168] = { // Code 0036, DIGIT SIX
  0x00, 0x00, 0x00, 0x13, 0x31, 0x00, 0x00, 0x00,
  0x00, 0x01, 0x7D, 0xFF, 0xFF, 0xD6, 0x00, 0x00,
  0x00, 0x2D, 0xFF, 0xFF, 0xFF, 0xFF, 0xB0, 0x00,
  0x01, 0xDF, 0xFF, 0xEB, 0xCF, 0xFF, 0xF6, 0x00,
  0x08, 0xFF, 0xF9, 0x00, 0x06, 0xFF, 0xF8, 0x00,
  0x1F, 0xFF, 0xC0, 0x00, 0x00, 0x6F, 0xD2, 0x00,
  0x5F, 0xFF, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x9F, 0xFF, 0x20, 0x14, 0x43, 0x00, 0x00, 0x00,
  0xBF, 0xFF, 0x2A, 0xFF, 0xFF, 0xE8, 0x10, 0x00,
  0xDF, 0xFF, 0xEF, 0xFF, 0xFF, 0xFF, 0xC1, 0x00,
  0xEF, 0xFF, 0xFF, 0xB9, 0xBF, 0xFF, 0xFA, 0x00,
  0xFF, 0xFF, 0xE3, 0x00, 0x05, 0xFF, 0xFF, 0x20,
  0xEF, 0xFF, 0x70, 0x00, 0x00, 0xAF, 0xFF, 0x50,
  0xCF, 0xFF, 0x40, 0x00, 0x00, 0x7F, 0xFF, 0x70,
  0xAF, 0xFF, 0x40, 0x00, 0x00, 0x8F, 0xFF, 0x60,
  0x6F, 0xFF, 0x80, 0x00, 0x00, 0xBF, 0xFF, 0x40,
  0x1E, 0xFF, 0xF4, 0x00, 0x07, 0xFF, 0xFE, 0x00,
  0x07, 0xFF, 0xFF, 0xDB, 0xDF, 0xFF, 0xF7, 0x00,
  0x00, 0x8F, 0xFF, 0xFF, 0xFF, 0xFF, 0x90, 0x00,
  0x00, 0x05, 0xDF, 0xFF, 0xFF, 0xD5, 0x00, 0x00,
  0x00, 0x00, 0x02, 0x46, 0x42, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0037[160] = { // Code 0037, DIGIT SEVEN
  0x3C, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDC, 0x40,
  0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0,
  0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0,
  0x17, 0x99, 0x99, 0x99, 0x99, 0xCF, 0xFF, 0x40,
  0x00, 0x00, 0x00, 0x00, 0x03, 0xEF, 0xF7, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x1E, 0xFF, 0x90, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xBF, 0xFD, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x05, 0xFF, 0xF4, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x1E, 0xFF, 0xA0, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x7F, 0xFF, 0x30, 0x00, 0x00,
  0x00, 0x00, 0x01, 0xEF, 0xFB, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x07, 0xFF, 0xF5, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x0E, 0xFF, 0xE0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x5F, 0xFF, 0xA0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xAF, 0xFF, 0x50, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0xFF, 0x10, 0x00, 0x00, 0x00,
  0x00, 0x03, 0xFF, 0xFD, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x04, 0xFF, 0xF9, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x01, 0xEF, 0xF3, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x25, 0x30, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0038[168] = { // Code 0038, DIGIT EIGHT
  0x00, 0x00, 0x01, 0x33, 0x20, 0x00, 0x00, 0x00,
  0x00, 0x07, 0xCF, 0xFF, 0xFE, 0xA3, 0x00, 0x00,
  0x01, 0xCF, 0xFF, 0xFF, 0xFF, 0xFF, 0x70, 0x00,
  0x0B, 0xFF, 0xFF, 0xCB, 0xEF, 0xFF, 0xF4, 0x00,
  0x3F, 0xFF, 0xE3, 0x00, 0x08, 0xFF, 0xFB, 0x00,
  0x6F, 0xFF, 0x70, 0x00, 0x00, 0xEF, 0xFD, 0x00,
  0x5F, 0xFF, 0x60, 0x00, 0x00, 0xDF, 0xFD, 0x00,
  0x2F, 0xFF, 0xB0, 0x00, 0x03, 0xFF, 0xFA, 0x00,
  0x09, 0xFF, 0xFB, 0x66, 0x8E, 0xFF, 0xE2, 0x00,
  0x00, 0x8F, 0xFF, 0xFF, 0xFF, 0xFD, 0x30, 0x00,
  0x03, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0x91, 0x00,
  0x3E, 0xFF, 0xFB, 0x54, 0x7E, 0xFF, 0xFA, 0x00,
  0xAF, 0xFF, 0xA0, 0x00, 0x02, 0xEF, 0xFF, 0x20,
  0xDF, 0xFF, 0x20, 0x00, 0x00, 0x9F, 0xFF, 0x60,
  0xFF, 0xFF, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0x70,
  0xDF, 0xFF, 0x30, 0x00, 0x00, 0xAF, 0xFF, 0x50,
  0x9F, 0xFF, 0xD2, 0x00, 0x07, 0xFF, 0xFF, 0x20,
  0x2E, 0xFF, 0xFF, 0xCB, 0xEF, 0xFF, 0xF9, 0x00,
  0x04, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xB0, 0x00,
  0x00, 0x29, 0xEF, 0xFF, 0xFF, 0xD6, 0x00, 0x00,
  0x00, 0x00, 0x03, 0x56, 0x42, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0039[168] = { // Code 0039, DIGIT NINE
  0x00, 0x00, 0x01, 0x33, 0x10, 0x00, 0x00, 0x00,
  0x00, 0x07, 0xDF, 0xFF, 0xFD, 0x70, 0x00, 0x00,
  0x01, 0xCF, 0xFF, 0xFF, 0xFF, 0xFC, 0x10, 0x00,
  0x0C, 0xFF, 0xFF, 0xED, 0xFF, 0xFF, 0xC0, 0x00,
  0x5F, 0xFF, 0xE4, 0x00, 0x2C, 0xFF, 0xF7, 0x00,
  0xBF, 0xFF, 0x50, 0x00, 0x02, 0xFF, 0xFD, 0x00,
  0xDF, 0xFF, 0x10, 0x00, 0x00, 0xCF, 0xFF, 0x20,
  0xFF, 0xFF, 0x00, 0x00, 0x00, 0xBF, 0xFF, 0x50,
  0xDF, 0xFF, 0x20, 0x00, 0x00, 0xEF, 0xFF, 0x60,
  0xAF, 0xFF, 0xA0, 0x00, 0x07, 0xFF, 0xFF, 0x70,
  0x3F, 0xFF, 0xFC, 0x87, 0xBF, 0xFF, 0xFF, 0x70,
  0x08, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x60,
  0x00, 0x6E, 0xFF, 0xFF, 0xF9, 0x8F, 0xFF, 0x40,
  0x00, 0x00, 0x46, 0x75, 0x20, 0x8F, 0xFF, 0x20,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xCF, 0xFE, 0x00,
  0x06, 0xDA, 0x10, 0x00, 0x03, 0xFF, 0xF9, 0x00,
  0x0F, 0xFF, 0xA1, 0x00, 0x2D, 0xFF, 0xF3, 0x00,
  0x0E, 0xFF, 0xFD, 0x9A, 0xEF, 0xFF, 0x90, 0x00,
  0x06, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0x00, 0x00,
  0x00, 0x4C, 0xFF, 0xFF, 0xFD, 0x60, 0x00, 0x00,
  0x00, 0x00, 0x24, 0x64, 0x20, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_003A[ 48] = { // Code 003A, COLON
  0x00, 0x11, 0x00,
  0x06, 0xFF, 0x90,
  0x0F, 0xFF, 0xF4,
  0x1F, 0xFF, 0xF4,
  0x08, 0xFF, 0xB0,
  0x00, 0x33, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x23, 0x00,
  0x07, 0xFF, 0xB0,
  0x0F, 0xFF, 0xF4,
  0x0F, 0xFF, 0xF4,
  0x06, 0xFF, 0xA0,
  0x00, 0x12, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_003B[ 57] = { // Code 003B, SEMICOLON
  0x00, 0x11, 0x00,
  0x06, 0xFF, 0x90,
  0x0F, 0xFF, 0xF4,
  0x1F, 0xFF, 0xF4,
  0x08, 0xFF, 0xB0,
  0x00, 0x33, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x23, 0x00,
  0x07, 0xFF, 0xB0,
  0x0F, 0xFF, 0xF6,
  0x0F, 0xFF, 0xF9,
  0x07, 0xFF, 0xF9,
  0x00, 0x05, 0xF8,
  0x00, 0x2D, 0xF3,
  0x08, 0xFF, 0x80,
  0x0C, 0xC5, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_003C[120] = { // Code 003C, LESS-THAN SIGN
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x81,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x4B, 0xFF, 0xF8,
  0x00, 0x00, 0x00, 0x00, 0x5C, 0xFF, 0xFF, 0xF7,
  0x00, 0x00, 0x00, 0x7D, 0xFF, 0xFF, 0xFD, 0x70,
  0x00, 0x01, 0x7E, 0xFF, 0xFF, 0xFC, 0x50, 0x00,
  0x02, 0x9F, 0xFF, 0xFF, 0xFA, 0x30, 0x00, 0x00,
  0x2E, 0xFF, 0xFF, 0xE8, 0x20, 0x00, 0x00, 0x00,
  0x5F, 0xFF, 0xFE, 0x40, 0x00, 0x00, 0x00, 0x00,
  0x1C, 0xFF, 0xFF, 0xFC, 0x60, 0x00, 0x00, 0x00,
  0x00, 0x5B, 0xFF, 0xFF, 0xFE, 0x71, 0x00, 0x00,
  0x00, 0x00, 0x3A, 0xFF, 0xFF, 0xFF, 0x93, 0x00,
  0x00, 0x00, 0x00, 0x29, 0xFF, 0xFF, 0xFF, 0xB1,
  0x00, 0x00, 0x00, 0x00, 0x18, 0xEF, 0xFF, 0xF8,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0xDF, 0xF6,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x40
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_003D[ 88] = { // Code 003D, EQUALS SIGN
  0x04, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x50,
  0x6F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8,
  0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA,
  0x19, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xA2,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x00,
  0x3E, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF5,
  0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB,
  0x3E, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF6,
  0x01, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_003E[120] = { // Code 003E, GREATER-THAN SIGN
  0x07, 0x94, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x5F, 0xFF, 0xC5, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x4F, 0xFF, 0xFF, 0xD7, 0x10, 0x00, 0x00, 0x00,
  0x05, 0xCF, 0xFF, 0xFF, 0xE8, 0x10, 0x00, 0x00,
  0x00, 0x04, 0xAF, 0xFF, 0xFF, 0xF9, 0x20, 0x00,
  0x00, 0x00, 0x02, 0x8E, 0xFF, 0xFF, 0xFA, 0x30,
  0x00, 0x00, 0x00, 0x01, 0x7D, 0xFF, 0xFF, 0xF5,
  0x00, 0x00, 0x00, 0x00, 0x03, 0xDF, 0xFF, 0xF8,
  0x00, 0x00, 0x00, 0x04, 0xBF, 0xFF, 0xFF, 0xD2,
  0x00, 0x00, 0x06, 0xDF, 0xFF, 0xFF, 0xD6, 0x00,
  0x00, 0x28, 0xEF, 0xFF, 0xFF, 0xB5, 0x00, 0x00,
  0x09, 0xFF, 0xFF, 0xFF, 0xA3, 0x00, 0x00, 0x00,
  0x5F, 0xFF, 0xFF, 0x92, 0x00, 0x00, 0x00, 0x00,
  0x3F, 0xFE, 0x81, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x03, 0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_003F[147] = { // Code 003F, QUESTION MARK
  0x00, 0x02, 0x8B, 0xBB, 0x95, 0x00, 0x00,
  0x00, 0x9F, 0xFF, 0xFF, 0xFF, 0xE4, 0x00,
  0x0B, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x40,
  0x6F, 0xFF, 0xE7, 0x46, 0xCF, 0xFF, 0xE0,
  0xBF, 0xFF, 0x40, 0x00, 0x1E, 0xFF, 0xF3,
  0xCF, 0xFB, 0x00, 0x00, 0x0B, 0xFF, 0xF6,
  0x4C, 0xB2, 0x00, 0x00, 0x1E, 0xFF, 0xF3,
  0x00, 0x00, 0x00, 0x00, 0xAF, 0xFF, 0xD0,
  0x00, 0x00, 0x00, 0x2C, 0xFF, 0xFF, 0x40,
  0x00, 0x00, 0x02, 0xEF, 0xFF, 0xE4, 0x00,
  0x00, 0x00, 0x1D, 0xFF, 0xFC, 0x20, 0x00,
  0x00, 0x00, 0x6F, 0xFF, 0xA0, 0x00, 0x00,
  0x00, 0x00, 0x7F, 0xFF, 0x20, 0x00, 0x00,
  0x00, 0x00, 0x1C, 0xF8, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x01, 0x30, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x4F, 0xFD, 0x10, 0x00, 0x00,
  0x00, 0x00, 0xCF, 0xFF, 0x70, 0x00, 0x00,
  0x00, 0x00, 0xCF, 0xFF, 0x70, 0x00, 0x00,
  0x00, 0x00, 0x4E, 0xFC, 0x10, 0x00, 0x00,
  0x00, 0x00, 0x01, 0x20, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0040[231] = { // Code 0040, COMMERCIAL AT
  0x00, 0x00, 0x00, 0x03, 0x8C, 0xDD, 0xDB, 0x72, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x04, 0xCF, 0xFF, 0xFF, 0xFF, 0xFF, 0xA2, 0x00, 0x00,
  0x00, 0x00, 0x8F, 0xFF, 0xFB, 0x87, 0x9C, 0xFF, 0xFE, 0x30, 0x00,
  0x00, 0x08, 0xFF, 0xF8, 0x10, 0x00, 0x00, 0x29, 0xFF, 0xE2, 0x00,
  0x00, 0x6F, 0xFE, 0x40, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xFB, 0x00,
  0x01, 0xEF, 0xF5, 0x00, 0x5B, 0xFD, 0x91, 0x6B, 0x3A, 0xFF, 0x40,
  0x07, 0xFF, 0xA0, 0x08, 0xFF, 0xFF, 0xFC, 0xEF, 0x82, 0xFF, 0x90,
  0x0C, 0xFF, 0x30, 0x5F, 0xFF, 0xFF, 0xFF, 0xFF, 0x60, 0xCF, 0xB0,
  0x1F, 0xFE, 0x00, 0xDF, 0xF9, 0x10, 0x7F, 0xFF, 0x30, 0xAF, 0xB0,
  0x2F, 0xFB, 0x03, 0xFF, 0xB0, 0x00, 0x0E, 0xFF, 0x10, 0x9F, 0xB0,
  0x2F, 0xFB, 0x06, 0xFF, 0x70, 0x00, 0x0C, 0xFD, 0x00, 0xBF, 0x90,
  0x2F, 0xFC, 0x07, 0xFF, 0x70, 0x00, 0x0E, 0xFB, 0x00, 0xEF, 0x40,
  0x0E, 0xFE, 0x06, 0xFF, 0xC1, 0x00, 0x9F, 0xF8, 0x08, 0xFC, 0x00,
  0x0A, 0xFF, 0x42, 0xFF, 0xFE, 0xAD, 0xFF, 0xFC, 0xBF, 0xE3, 0x00,
  0x05, 0xFF, 0xC0, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x30, 0x00,
  0x00, 0xCF, 0xF7, 0x1A, 0xFF, 0xF9, 0x8F, 0xFE, 0x81, 0x00, 0x00,
  0x00, 0x2E, 0xFF, 0x80, 0x24, 0x10, 0x03, 0x30, 0x7A, 0x10, 0x00,
  0x00, 0x03, 0xEF, 0xFD, 0x73, 0x00, 0x02, 0x7D, 0xFF, 0x30, 0x00,
  0x00, 0x00, 0x2C, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF7, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x5B, 0xFF, 0xFF, 0xFF, 0xE9, 0x20, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x14, 0x67, 0x63, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0041[189] = { // Code 0041, LATIN CAPITAL LETTER A
  0x00, 0x00, 0x00, 0x19, 0xBB, 0xA2, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x8F, 0xFF, 0xFC, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xEF, 0xFF, 0xFF, 0x30, 0x00, 0x00,
  0x00, 0x00, 0x05, 0xFF, 0xFF, 0xFF, 0x90, 0x00, 0x00,
  0x00, 0x00, 0x0B, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x00,
  0x00, 0x00, 0x1F, 0xFF, 0xDB, 0xFF, 0xF5, 0x00, 0x00,
  0x00, 0x00, 0x7F, 0xFF, 0x87, 0xFF, 0xFA, 0x00, 0x00,
  0x00, 0x00, 0xDF, 0xFF, 0x32, 0xFF, 0xFF, 0x10, 0x00,
  0x00, 0x03, 0xFF, 0xFD, 0x00, 0xCF, 0xFF, 0x60, 0x00,
  0x00, 0x09, 0xFF, 0xF8, 0x00, 0x7F, 0xFF, 0xB0, 0x00,
  0x00, 0x0E, 0xFF, 0xF3, 0x00, 0x2F, 0xFF, 0xF2, 0x00,
  0x00, 0x5F, 0xFF, 0xD0, 0x00, 0x0D, 0xFF, 0xF7, 0x00,
  0x00, 0xBF, 0xFF, 0xA4, 0x44, 0x4A, 0xFF, 0xFC, 0x00,
  0x02, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x30,
  0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80,
  0x0D, 0xFF, 0xFE, 0xDD, 0xDD, 0xDD, 0xEF, 0xFF, 0xD0,
  0x4F, 0xFF, 0xF3, 0x00, 0x00, 0x00, 0x3F, 0xFF, 0xF4,
  0x9F, 0xFF, 0xD0, 0x00, 0x00, 0x00, 0x0D, 0xFF, 0xF9,
  0xBF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x08, 0xFF, 0xFB,
  0x6F, 0xFE, 0x20, 0x00, 0x00, 0x00, 0x02, 0xEF, 0xF6,
  0x03, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x30
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0042[180] = { // Code 0042, LATIN CAPITAL LETTER B
  0x04, 0x67, 0x77, 0x77, 0x76, 0x53, 0x00, 0x00, 0x00,
  0x8F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xD6, 0x00, 0x00,
  0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x90, 0x00,
  0xFF, 0xFF, 0xDB, 0xBB, 0xCE, 0xFF, 0xFF, 0xF3, 0x00,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x8F, 0xFF, 0xF8, 0x00,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x0D, 0xFF, 0xF9, 0x00,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x0C, 0xFF, 0xF8, 0x00,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x3F, 0xFF, 0xF3, 0x00,
  0xFF, 0xFF, 0xB7, 0x77, 0x79, 0xFF, 0xFF, 0x70, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF7, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xA1, 0x00,
  0xFF, 0xFF, 0xA6, 0x66, 0x67, 0xCF, 0xFF, 0xFA, 0x00,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x09, 0xFF, 0xFF, 0x10,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x03, 0xFF, 0xFF, 0x40,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x03, 0xFF, 0xFF, 0x40,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x09, 0xFF, 0xFF, 0x30,
  0xFF, 0xFF, 0xA6, 0x66, 0x68, 0xCF, 0xFF, 0xFD, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF5, 0x00,
  0xCF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x60, 0x00,
  0x3C, 0xFF, 0xFF, 0xFF, 0xFF, 0xEB, 0x71, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0043[189] = { // Code 0043, LATIN CAPITAL LETTER C
  0x00, 0x00, 0x00, 0x5A, 0xCD, 0xDC, 0x94, 0x00, 0x00,
  0x00, 0x00, 0x5E, 0xFF, 0xFF, 0xFF, 0xFF, 0xD4, 0x00,
  0x00, 0x08, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x70,
  0x00, 0x7F, 0xFF, 0xFF, 0xDA, 0xBD, 0xFF, 0xFF, 0xF3,
  0x02, 0xFF, 0xFF, 0xE6, 0x00, 0x00, 0x7F, 0xFF, 0xFA,
  0x09, 0xFF, 0xFF, 0x40, 0x00, 0x00, 0x08, 0xFF, 0xFB,
  0x0F, 0xFF, 0xFA, 0x00, 0x00, 0x00, 0x00, 0xBF, 0xF6,
  0x4F, 0xFF, 0xF4, 0x00, 0x00, 0x00, 0x00, 0x02, 0x10,
  0x7F, 0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x7F, 0xFF, 0xD0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x7F, 0xFF, 0xD0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x7F, 0xFF, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x6F, 0xFF, 0xF1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x3F, 0xFF, 0xF5, 0x00, 0x00, 0x00, 0x00, 0x6C, 0xA2,
  0x0E, 0xFF, 0xFC, 0x00, 0x00, 0x00, 0x04, 0xFF, 0xFB,
  0x09, 0xFF, 0xFF, 0x80, 0x00, 0x00, 0x1D, 0xFF, 0xFB,
  0x02, 0xEF, 0xFF, 0xFB, 0x52, 0x25, 0xDF, 0xFF, 0xF6,
  0x00, 0x5F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xB0,
  0x00, 0x05, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0x10,
  0x00, 0x00, 0x29, 0xEF, 0xFF, 0xFF, 0xFD, 0x60, 0x00,
  0x00, 0x00, 0x00, 0x03, 0x57, 0x75, 0x20, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0044[180] = { // Code 0044, LATIN CAPITAL LETTER D
  0x04, 0x67, 0x77, 0x77, 0x65, 0x30, 0x00, 0x00, 0x00,
  0x8F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xA3, 0x00, 0x00,
  0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x60, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF6, 0x00,
  0xFF, 0xFF, 0x82, 0x22, 0x24, 0xAF, 0xFF, 0xFE, 0x10,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x07, 0xFF, 0xFF, 0x80,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0xCF, 0xFF, 0xD0,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0xF1,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x4F, 0xFF, 0xF3,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x2F, 0xFF, 0xF4,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x2F, 0xFF, 0xF4,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x3F, 0xFF, 0xF4,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x5F, 0xFF, 0xF2,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0xAF, 0xFF, 0xE0,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x03, 0xFF, 0xFF, 0xA0,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x3D, 0xFF, 0xFF, 0x30,
  0xFF, 0xFF, 0xC9, 0x99, 0x9B, 0xFF, 0xFF, 0xF9, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xB0, 0x00,
  0xCF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, 0x00,
  0x3C, 0xFF, 0xFF, 0xFF, 0xFE, 0xB7, 0x20, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0045[160] = { // Code 0045, LATIN CAPITAL LETTER E
  0x03, 0x67, 0x77, 0x77, 0x77, 0x77, 0x76, 0x30,
  0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF3,
  0xCF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF6,
  0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xD1,
  0xDF, 0xFF, 0xA2, 0x22, 0x22, 0x22, 0x22, 0x00,
  0xDF, 0xFF, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xDF, 0xFF, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xDF, 0xFF, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xDF, 0xFF, 0xD9, 0x99, 0x99, 0x99, 0x95, 0x00,
  0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x10,
  0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x10,
  0xDF, 0xFF, 0xEB, 0xBB, 0xBB, 0xBB, 0xB6, 0x00,
  0xDF, 0xFF, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xDF, 0xFF, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xDF, 0xFF, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xDF, 0xFF, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xDF, 0xFF, 0xD9, 0x99, 0x99, 0x99, 0x98, 0x60,
  0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF7,
  0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF9,
  0x2C, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC3
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0046[168] = { // Code 0046, LATIN CAPITAL LETTER F
  0x03, 0x67, 0x77, 0x77, 0x77, 0x77, 0x74, 0x00,
  0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80,
  0xCF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xB0,
  0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x50,
  0xDF, 0xFF, 0xA2, 0x22, 0x22, 0x22, 0x20, 0x00,
  0xDF, 0xFF, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xDF, 0xFF, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xDF, 0xFF, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xDF, 0xFF, 0xB6, 0x66, 0x66, 0x65, 0x20, 0x00,
  0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF3, 0x00,
  0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF5, 0x00,
  0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xD1, 0x00,
  0xDF, 0xFF, 0xA2, 0x22, 0x22, 0x20, 0x00, 0x00,
  0xDF, 0xFF, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xDF, 0xFF, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xDF, 0xFF, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xDF, 0xFF, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xDF, 0xFF, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xCF, 0xFF, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x6F, 0xFE, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x03, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0047[210] = { // Code 0047, LATIN CAPITAL LETTER G
  0x00, 0x00, 0x00, 0x48, 0xBD, 0xDD, 0xB8, 0x20, 0x00, 0x00,
  0x00, 0x00, 0x4D, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0x10, 0x00,
  0x00, 0x08, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xD1, 0x00,
  0x00, 0x7F, 0xFF, 0xFF, 0xEB, 0xAC, 0xFF, 0xFF, 0xFA, 0x00,
  0x03, 0xFF, 0xFF, 0xE6, 0x00, 0x00, 0x1A, 0xFF, 0xFF, 0x10,
  0x0A, 0xFF, 0xFF, 0x40, 0x00, 0x00, 0x00, 0xCF, 0xFE, 0x00,
  0x1F, 0xFF, 0xFA, 0x00, 0x00, 0x00, 0x00, 0x19, 0xA3, 0x00,
  0x4F, 0xFF, 0xF4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x7F, 0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x7F, 0xFF, 0xD0, 0x00, 0x00, 0x04, 0x66, 0x66, 0x64, 0x10,
  0x7F, 0xFF, 0xD0, 0x00, 0x00, 0xAF, 0xFF, 0xFF, 0xFF, 0xD0,
  0x7F, 0xFF, 0xD0, 0x00, 0x00, 0xDF, 0xFF, 0xFF, 0xFF, 0xF2,
  0x6F, 0xFF, 0xF1, 0x00, 0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xF2,
  0x3F, 0xFF, 0xF5, 0x00, 0x00, 0x01, 0x22, 0x3F, 0xFF, 0xF2,
  0x0E, 0xFF, 0xFB, 0x00, 0x00, 0x00, 0x00, 0x6F, 0xFF, 0xF2,
  0x09, 0xFF, 0xFF, 0x70, 0x00, 0x00, 0x02, 0xEF, 0xFF, 0xF2,
  0x02, 0xEF, 0xFF, 0xFA, 0x30, 0x01, 0x7E, 0xFF, 0xFF, 0xF2,
  0x00, 0x5F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF2,
  0x00, 0x05, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE5, 0xFF, 0xF2,
  0x00, 0x00, 0x29, 0xEF, 0xFF, 0xFF, 0xFA, 0x20, 0xDF, 0xD0,
  0x00, 0x00, 0x00, 0x03, 0x67, 0x75, 0x20, 0x00, 0x15, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0048[189] = { // Code 0048, LATIN CAPITAL LETTER H
  0x2A, 0xB7, 0x00, 0x00, 0x00, 0x00, 0x07, 0xBA, 0x20,
  0xCF, 0xFF, 0x40, 0x00, 0x00, 0x00, 0x4F, 0xFF, 0xC0,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0xF0,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0xF0,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0xF0,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0xF0,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0xF0,
  0xFF, 0xFF, 0x82, 0x22, 0x22, 0x22, 0x8F, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xC9, 0x99, 0x99, 0x99, 0xCF, 0xFF, 0xF0,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0xF0,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0xF0,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0xF0,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0xF0,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0xF0,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0xF0,
  0xEF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0xE0,
  0x7F, 0xFE, 0x20, 0x00, 0x00, 0x00, 0x2E, 0xFF, 0x70,
  0x03, 0x51, 0x00, 0x00, 0x00, 0x00, 0x01, 0x53, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0049[ 63] = { // Code 0049, LATIN CAPITAL LETTER I
  0x2A, 0xB7, 0x00,
  0xCF, 0xFF, 0x40,
  0xFF, 0xFF, 0x70,
  0xFF, 0xFF, 0x70,
  0xFF, 0xFF, 0x70,
  0xFF, 0xFF, 0x70,
  0xFF, 0xFF, 0x70,
  0xFF, 0xFF, 0x70,
  0xFF, 0xFF, 0x70,
  0xFF, 0xFF, 0x70,
  0xFF, 0xFF, 0x70,
  0xFF, 0xFF, 0x70,
  0xFF, 0xFF, 0x70,
  0xFF, 0xFF, 0x70,
  0xFF, 0xFF, 0x70,
  0xFF, 0xFF, 0x70,
  0xFF, 0xFF, 0x70,
  0xFF, 0xFF, 0x70,
  0xEF, 0xFF, 0x70,
  0x7F, 0xFE, 0x20,
  0x03, 0x51, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_004A[147] = { // Code 004A, LATIN CAPITAL LETTER J
  0x00, 0x00, 0x00, 0x00, 0x02, 0xAB, 0x70,
  0x00, 0x00, 0x00, 0x00, 0x0C, 0xFF, 0xF4,
  0x00, 0x00, 0x00, 0x00, 0x0F, 0xFF, 0xF7,
  0x00, 0x00, 0x00, 0x00, 0x0F, 0xFF, 0xF7,
  0x00, 0x00, 0x00, 0x00, 0x0F, 0xFF, 0xF7,
  0x00, 0x00, 0x00, 0x00, 0x0F, 0xFF, 0xF7,
  0x00, 0x00, 0x00, 0x00, 0x0F, 0xFF, 0xF7,
  0x00, 0x00, 0x00, 0x00, 0x0F, 0xFF, 0xF7,
  0x00, 0x00, 0x00, 0x00, 0x0F, 0xFF, 0xF7,
  0x00, 0x00, 0x00, 0x00, 0x0F, 0xFF, 0xF7,
  0x00, 0x00, 0x00, 0x00, 0x0F, 0xFF, 0xF7,
  0x00, 0x00, 0x00, 0x00, 0x0F, 0xFF, 0xF7,
  0x05, 0x97, 0x00, 0x00, 0x0F, 0xFF, 0xF7,
  0x3F, 0xFF, 0x50, 0x00, 0x0F, 0xFF, 0xF7,
  0x7F, 0xFF, 0x90, 0x00, 0x0F, 0xFF, 0xF7,
  0x7F, 0xFF, 0xA0, 0x00, 0x3F, 0xFF, 0xF5,
  0x5F, 0xFF, 0xF4, 0x01, 0xBF, 0xFF, 0xF1,
  0x0E, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xA0,
  0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0x10,
  0x00, 0x4C, 0xFF, 0xFF, 0xFF, 0xA1, 0x00,
  0x00, 0x00, 0x36, 0x76, 0x51, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_004B[189] = { // Code 004B, LATIN CAPITAL LETTER K
  0x2A, 0xB7, 0x00, 0x00, 0x00, 0x01, 0xAB, 0x60, 0x00,
  0xCF, 0xFF, 0x40, 0x00, 0x00, 0x1B, 0xFF, 0xF3, 0x00,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0xBF, 0xFF, 0xF3, 0x00,
  0xFF, 0xFF, 0x70, 0x00, 0x0A, 0xFF, 0xFF, 0x80, 0x00,
  0xFF, 0xFF, 0x70, 0x00, 0x8F, 0xFF, 0xFA, 0x00, 0x00,
  0xFF, 0xFF, 0x70, 0x07, 0xFF, 0xFF, 0xA0, 0x00, 0x00,
  0xFF, 0xFF, 0x70, 0x6F, 0xFF, 0xFB, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x75, 0xFF, 0xFF, 0xB1, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xBE, 0xFF, 0xFF, 0x40, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF7, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xAE, 0xFF, 0xFF, 0x30, 0x00, 0x00,
  0xFF, 0xFF, 0xFA, 0x05, 0xFF, 0xFF, 0xC0, 0x00, 0x00,
  0xFF, 0xFF, 0xB0, 0x00, 0xAF, 0xFF, 0xF7, 0x00, 0x00,
  0xFF, 0xFF, 0x70, 0x00, 0x1E, 0xFF, 0xFF, 0x20, 0x00,
  0xFF, 0xFF, 0x70, 0x00, 0x06, 0xFF, 0xFF, 0xC0, 0x00,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0xBF, 0xFF, 0xF7, 0x00,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x2E, 0xFF, 0xFE, 0x10,
  0xEF, 0xFF, 0x70, 0x00, 0x00, 0x06, 0xFF, 0xFF, 0x30,
  0x7F, 0xFE, 0x20, 0x00, 0x00, 0x00, 0xBF, 0xFD, 0x00,
  0x03, 0x51, 0x00, 0x00, 0x00, 0x00, 0x05, 0x40, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_004C[160] = { // Code 004C, LATIN CAPITAL LETTER L
  0x2A, 0xB7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xCF, 0xFF, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xDB, 0xBB, 0xBB, 0xBB, 0xA3, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x10,
  0xCF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x10,
  0x3C, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE7, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_004D[210] = { // Code 004D, LATIN CAPITAL LETTER M
  0x3A, 0xBB, 0xA2, 0x00, 0x00, 0x00, 0x00, 0x2A, 0xBB, 0xA3,
  0xDF, 0xFF, 0xFD, 0x00, 0x00, 0x00, 0x00, 0xCF, 0xFF, 0xFD,
  0xFF, 0xFF, 0xFF, 0x30, 0x00, 0x00, 0x03, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0x80, 0x00, 0x00, 0x08, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xD0, 0x00, 0x00, 0x0C, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xF2, 0x00, 0x00, 0x2F, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFD, 0xEF, 0xF7, 0x00, 0x00, 0x7F, 0xFD, 0xFF, 0xFF,
  0xFF, 0xFD, 0x9F, 0xFC, 0x00, 0x00, 0xBF, 0xF9, 0xFF, 0xFF,
  0xFF, 0xFD, 0x4F, 0xFF, 0x20, 0x01, 0xFF, 0xF4, 0xFF, 0xFF,
  0xFF, 0xFD, 0x0E, 0xFF, 0x60, 0x05, 0xFF, 0xE0, 0xFF, 0xFF,
  0xFF, 0xFD, 0x0A, 0xFF, 0xB0, 0x0A, 0xFF, 0x90, 0xFF, 0xFF,
  0xFF, 0xFD, 0x05, 0xFF, 0xF1, 0x0E, 0xFF, 0x50, 0xFF, 0xFF,
  0xFF, 0xFD, 0x01, 0xFF, 0xF5, 0x4F, 0xFE, 0x00, 0xFF, 0xFF,
  0xFF, 0xFD, 0x00, 0xAF, 0xFA, 0x8F, 0xFA, 0x00, 0xFF, 0xFF,
  0xFF, 0xFD, 0x00, 0x5F, 0xFE, 0xDF, 0xF5, 0x00, 0xFF, 0xFF,
  0xFF, 0xFD, 0x00, 0x1F, 0xFF, 0xFF, 0xF1, 0x00, 0xFF, 0xFF,
  0xFF, 0xFD, 0x00, 0x0B, 0xFF, 0xFF, 0xA0, 0x00, 0xFF, 0xFF,
  0xFF, 0xFD, 0x00, 0x06, 0xFF, 0xFF, 0x60, 0x00, 0xFF, 0xFF,
  0xFF, 0xFD, 0x00, 0x01, 0xFF, 0xFF, 0x10, 0x00, 0xEF, 0xFF,
  0xAF, 0xF8, 0x00, 0x00, 0xAF, 0xFA, 0x00, 0x00, 0x9F, 0xFA,
  0x05, 0x40, 0x00, 0x00, 0x04, 0x40, 0x00, 0x00, 0x04, 0x40
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_004E[189] = { // Code 004E, LATIN CAPITAL LETTER N
  0x2A, 0xBB, 0x30, 0x00, 0x00, 0x00, 0x06, 0xBB, 0x30,
  0xCF, 0xFF, 0xE2, 0x00, 0x00, 0x00, 0x2F, 0xFF, 0xE0,
  0xFF, 0xFF, 0xFA, 0x00, 0x00, 0x00, 0x4F, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0x40, 0x00, 0x00, 0x4F, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xD0, 0x00, 0x00, 0x4F, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xF8, 0x00, 0x00, 0x4F, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xFF, 0x20, 0x00, 0x4F, 0xFF, 0xF0,
  0xFF, 0xFF, 0xAF, 0xFF, 0xB0, 0x00, 0x4F, 0xFF, 0xF0,
  0xFF, 0xFF, 0x4B, 0xFF, 0xF6, 0x00, 0x4F, 0xFF, 0xF0,
  0xFF, 0xFF, 0x42, 0xFF, 0xFE, 0x10, 0x4F, 0xFF, 0xF0,
  0xFF, 0xFF, 0x40, 0x7F, 0xFF, 0x90, 0x4F, 0xFF, 0xF0,
  0xFF, 0xFF, 0x40, 0x0D, 0xFF, 0xF4, 0x4F, 0xFF, 0xF0,
  0xFF, 0xFF, 0x40, 0x03, 0xFF, 0xFD, 0x4F, 0xFF, 0xF0,
  0xFF, 0xFF, 0x40, 0x00, 0x9F, 0xFF, 0xBF, 0xFF, 0xF0,
  0xFF, 0xFF, 0x40, 0x00, 0x1D, 0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0x40, 0x00, 0x05, 0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0x40, 0x00, 0x00, 0xBF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0x40, 0x00, 0x00, 0x2E, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0x30, 0x00, 0x00, 0x06, 0xFF, 0xFF, 0xE0,
  0xAF, 0xFD, 0x00, 0x00, 0x00, 0x00, 0xBF, 0xFF, 0x70,
  0x04, 0x51, 0x00, 0x00, 0x00, 0x00, 0x04, 0x63, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_004F[210] = { // Code 004F, LATIN CAPITAL LETTER O
  0x00, 0x00, 0x01, 0x6A, 0xCD, 0xDC, 0xA6, 0x10, 0x00, 0x00,
  0x00, 0x00, 0x7E, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, 0x00,
  0x00, 0x1B, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC1, 0x00,
  0x00, 0xBF, 0xFF, 0xFF, 0xDA, 0xAD, 0xFF, 0xFF, 0xFB, 0x00,
  0x07, 0xFF, 0xFF, 0xD3, 0x00, 0x00, 0x3C, 0xFF, 0xFF, 0x70,
  0x0E, 0xFF, 0xFD, 0x10, 0x00, 0x00, 0x01, 0xDF, 0xFF, 0xE1,
  0x4F, 0xFF, 0xF5, 0x00, 0x00, 0x00, 0x00, 0x5F, 0xFF, 0xF5,
  0x8F, 0xFF, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x0E, 0xFF, 0xF9,
  0xBF, 0xFF, 0xB0, 0x00, 0x00, 0x00, 0x00, 0x0A, 0xFF, 0xFB,
  0xBF, 0xFF, 0x90, 0x00, 0x00, 0x00, 0x00, 0x09, 0xFF, 0xFD,
  0xBF, 0xFF, 0x90, 0x00, 0x00, 0x00, 0x00, 0x09, 0xFF, 0xFD,
  0xBF, 0xFF, 0xA0, 0x00, 0x00, 0x00, 0x00, 0x0A, 0xFF, 0xFB,
  0x9F, 0xFF, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x0C, 0xFF, 0xF9,
  0x7F, 0xFF, 0xF2, 0x00, 0x00, 0x00, 0x00, 0x2F, 0xFF, 0xF6,
  0x2F, 0xFF, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x9F, 0xFF, 0xF1,
  0x0B, 0xFF, 0xFF, 0x50, 0x00, 0x00, 0x05, 0xFF, 0xFF, 0x90,
  0x03, 0xFF, 0xFF, 0xF9, 0x42, 0x24, 0xAF, 0xFF, 0xFE, 0x10,
  0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF4, 0x00,
  0x00, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0x30, 0x00,
  0x00, 0x00, 0x2A, 0xFF, 0xFF, 0xFF, 0xFE, 0x71, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x03, 0x67, 0x75, 0x30, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0050[189] = { // Code 0050, LATIN CAPITAL LETTER P
  0x04, 0x67, 0x77, 0x77, 0x76, 0x63, 0x00, 0x00, 0x00,
  0x8F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE7, 0x00, 0x00,
  0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xA0, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF6, 0x00,
  0xFF, 0xFF, 0x70, 0x00, 0x02, 0x7F, 0xFF, 0xFC, 0x00,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x08, 0xFF, 0xFF, 0x10,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x04, 0xFF, 0xFF, 0x20,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x06, 0xFF, 0xFF, 0x10,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x1D, 0xFF, 0xFE, 0x00,
  0xFF, 0xFF, 0xB7, 0x77, 0x7A, 0xEF, 0xFF, 0xF8, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xD1, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x20, 0x00,
  0xFF, 0xFF, 0xED, 0xDD, 0xDD, 0xCA, 0x50, 0x00, 0x00,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xEF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x7F, 0xFE, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x03, 0x51, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0051[220] = { // Code 0051, LATIN CAPITAL LETTER Q
  0x00, 0x00, 0x01, 0x6A, 0xCD, 0xDC, 0xA6, 0x10, 0x00, 0x00,
  0x00, 0x00, 0x7E, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, 0x00,
  0x00, 0x1B, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC1, 0x00,
  0x00, 0xBF, 0xFF, 0xFF, 0xDA, 0xAD, 0xFF, 0xFF, 0xFB, 0x00,
  0x07, 0xFF, 0xFF, 0xD3, 0x00, 0x00, 0x3C, 0xFF, 0xFF, 0x70,
  0x0E, 0xFF, 0xFD, 0x10, 0x00, 0x00, 0x01, 0xDF, 0xFF, 0xE1,
  0x4F, 0xFF, 0xF5, 0x00, 0x00, 0x00, 0x00, 0x5F, 0xFF, 0xF5,
  0x8F, 0xFF, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x0E, 0xFF, 0xF9,
  0xBF, 0xFF, 0xB0, 0x00, 0x00, 0x00, 0x00, 0x0A, 0xFF, 0xFB,
  0xBF, 0xFF, 0x90, 0x00, 0x00, 0x00, 0x00, 0x09, 0xFF, 0xFD,
  0xBF, 0xFF, 0x90, 0x00, 0x00, 0x00, 0x00, 0x09, 0xFF, 0xFD,
  0xBF, 0xFF, 0xA0, 0x00, 0x00, 0x00, 0x00, 0x0A, 0xFF, 0xFB,
  0x9F, 0xFF, 0xC0, 0x00, 0x00, 0x02, 0x00, 0x0C, 0xFF, 0xF9,
  0x7F, 0xFF, 0xF2, 0x00, 0x00, 0xAF, 0xB1, 0x2F, 0xFF, 0xF6,
  0x2F, 0xFF, 0xF8, 0x00, 0x00, 0xFF, 0xFC, 0xAF, 0xFF, 0xF1,
  0x0B, 0xFF, 0xFF, 0x50, 0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0x90,
  0x03, 0xFF, 0xFF, 0xF9, 0x42, 0x2A, 0xFF, 0xFF, 0xFE, 0x20,
  0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF7, 0x00,
  0x00, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x30,
  0x00, 0x00, 0x2A, 0xFF, 0xFF, 0xFF, 0xFD, 0x8E, 0xFF, 0xE2,
  0x00, 0x00, 0x00, 0x03, 0x67, 0x75, 0x30, 0x02, 0xEF, 0xF1,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x27, 0x30
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0052[189] = { // Code 0052, LATIN CAPITAL LETTER R
  0x04, 0x67, 0x77, 0x77, 0x77, 0x65, 0x30, 0x00, 0x00,
  0x8F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0x50, 0x00,
  0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x30,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x29, 0xFF, 0xFF, 0x70,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0xEF, 0xFF, 0x90,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0xBF, 0xFF, 0x90,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0xDF, 0xFF, 0x70,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x08, 0xFF, 0xFE, 0x10,
  0xFF, 0xFF, 0xDB, 0xBB, 0xBC, 0xFF, 0xFF, 0xF5, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0x30, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xD2, 0x00,
  0xFF, 0xFF, 0xB7, 0x77, 0x77, 0xCF, 0xFF, 0xFB, 0x00,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x0B, 0xFF, 0xFE, 0x00,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x05, 0xFF, 0xFF, 0x00,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x03, 0xFF, 0xFF, 0x00,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x02, 0xFF, 0xFF, 0x30,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x01, 0xFF, 0xFF, 0x60,
  0xEF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0xEF, 0xFF, 0x90,
  0x7F, 0xFE, 0x20, 0x00, 0x00, 0x00, 0x6F, 0xFF, 0x40,
  0x03, 0x51, 0x00, 0x00, 0x00, 0x00, 0x02, 0x52, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0053[189] = { // Code 0053, LATIN CAPITAL LETTER S
  0x00, 0x01, 0x6A, 0xCD, 0xDC, 0x94, 0x00, 0x00, 0x00,
  0x00, 0x6E, 0xFF, 0xFF, 0xFF, 0xFF, 0xD5, 0x00, 0x00,
  0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x70, 0x00,
  0x3F, 0xFF, 0xFE, 0x97, 0x8B, 0xFF, 0xFF, 0xF3, 0x00,
  0x9F, 0xFF, 0xD1, 0x00, 0x00, 0x3E, 0xFF, 0xF7, 0x00,
  0xBF, 0xFF, 0x80, 0x00, 0x00, 0x03, 0xEF, 0xF4, 0x00,
  0xBF, 0xFF, 0xB0, 0x00, 0x00, 0x00, 0x26, 0x30, 0x00,
  0x9F, 0xFF, 0xFB, 0x51, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x4F, 0xFF, 0xFF, 0xFF, 0xDA, 0x73, 0x00, 0x00, 0x00,
  0x08, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xD6, 0x00, 0x00,
  0x00, 0x5D, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xB1, 0x00,
  0x00, 0x00, 0x37, 0xBF, 0xFF, 0xFF, 0xFF, 0xF9, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x47, 0xCF, 0xFF, 0xFF, 0x10,
  0x03, 0x30, 0x00, 0x00, 0x00, 0x08, 0xFF, 0xFF, 0x30,
  0x7F, 0xFA, 0x00, 0x00, 0x00, 0x02, 0xFF, 0xFF, 0x40,
  0xBF, 0xFF, 0x70, 0x00, 0x00, 0x05, 0xFF, 0xFF, 0x30,
  0xAF, 0xFF, 0xF8, 0x10, 0x00, 0x4E, 0xFF, 0xFE, 0x00,
  0x2E, 0xFF, 0xFF, 0xFC, 0xBE, 0xFF, 0xFF, 0xF6, 0x00,
  0x04, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x00,
  0x00, 0x18, 0xEF, 0xFF, 0xFF, 0xFF, 0xB4, 0x00, 0x00,
  0x00, 0x00, 0x03, 0x57, 0x76, 0x41, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0054[189] = { // Code 0054, LATIN CAPITAL LETTER T
  0x03, 0x67, 0x77, 0x77, 0x77, 0x77, 0x77, 0x76, 0x30,
  0x6F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF7,
  0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB,
  0x4F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF5,
  0x01, 0x44, 0x44, 0x7F, 0xFF, 0xF7, 0x44, 0x44, 0x20,
  0x00, 0x00, 0x00, 0x4F, 0xFF, 0xF4, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x4F, 0xFF, 0xF4, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x4F, 0xFF, 0xF4, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x4F, 0xFF, 0xF4, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x4F, 0xFF, 0xF4, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x4F, 0xFF, 0xF4, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x4F, 0xFF, 0xF4, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x4F, 0xFF, 0xF4, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x4F, 0xFF, 0xF4, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x4F, 0xFF, 0xF4, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x4F, 0xFF, 0xF4, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x4F, 0xFF, 0xF4, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x4F, 0xFF, 0xF4, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x3F, 0xFF, 0xF3, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0B, 0xFF, 0xC0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x45, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0055[189] = { // Code 0055, LATIN CAPITAL LETTER U
  0x2A, 0xB7, 0x00, 0x00, 0x00, 0x00, 0x07, 0xBA, 0x20,
  0xCF, 0xFF, 0x40, 0x00, 0x00, 0x00, 0x4F, 0xFF, 0xC0,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0xF0,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0xF0,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0xF0,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0xF0,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0xF0,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0xF0,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0xF0,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0xF0,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0xF0,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0xF0,
  0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0xF0,
  0xEF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0xE0,
  0xCF, 0xFF, 0xA0, 0x00, 0x00, 0x00, 0xAF, 0xFF, 0xC0,
  0x9F, 0xFF, 0xF3, 0x00, 0x00, 0x02, 0xFF, 0xFF, 0x90,
  0x3F, 0xFF, 0xFE, 0x73, 0x23, 0x7E, 0xFF, 0xFF, 0x30,
  0x0A, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0x00,
  0x01, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xB1, 0x00,
  0x00, 0x06, 0xCF, 0xFF, 0xFF, 0xFF, 0xD6, 0x00, 0x00,
  0x00, 0x00, 0x02, 0x56, 0x76, 0x52, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0056[189] = { // Code 0056, LATIN CAPITAL LETTER V
  0x1A, 0xB8, 0x00, 0x00, 0x00, 0x00, 0x02, 0xAB, 0x60,
  0xAF, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x0C, 0xFF, 0xF2,
  0xBF, 0xFF, 0xC0, 0x00, 0x00, 0x00, 0x3F, 0xFF, 0xF3,
  0x7F, 0xFF, 0xF2, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0xE0,
  0x2F, 0xFF, 0xF6, 0x00, 0x00, 0x00, 0xCF, 0xFF, 0x90,
  0x0B, 0xFF, 0xFB, 0x00, 0x00, 0x02, 0xFF, 0xFF, 0x30,
  0x06, 0xFF, 0xFF, 0x10, 0x00, 0x07, 0xFF, 0xFD, 0x00,
  0x01, 0xFF, 0xFF, 0x50, 0x00, 0x0B, 0xFF, 0xF8, 0x00,
  0x00, 0xAF, 0xFF, 0xA0, 0x00, 0x1F, 0xFF, 0xF2, 0x00,
  0x00, 0x5F, 0xFF, 0xE0, 0x00, 0x5F, 0xFF, 0xB0, 0x00,
  0x00, 0x0E, 0xFF, 0xF3, 0x00, 0xAF, 0xFF, 0x60, 0x00,
  0x00, 0x0A, 0xFF, 0xF8, 0x00, 0xFF, 0xFF, 0x10, 0x00,
  0x00, 0x04, 0xFF, 0xFD, 0x05, 0xFF, 0xFA, 0x00, 0x00,
  0x00, 0x00, 0xEF, 0xFF, 0x29, 0xFF, 0xF5, 0x00, 0x00,
  0x00, 0x00, 0x8F, 0xFF, 0x7E, 0xFF, 0xE0, 0x00, 0x00,
  0x00, 0x00, 0x3F, 0xFF, 0xEF, 0xFF, 0x90, 0x00, 0x00,
  0x00, 0x00, 0x0D, 0xFF, 0xFF, 0xFF, 0x30, 0x00, 0x00,
  0x00, 0x00, 0x07, 0xFF, 0xFF, 0xFD, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x02, 0xFF, 0xFF, 0xF7, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x9F, 0xFF, 0xD1, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x03, 0x64, 0x10, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0057[273] = { // Code 0057, LATIN CAPITAL LETTER W
  0x19, 0xB7, 0x00, 0x00, 0x00, 0x2A, 0xBA, 0x20, 0x00, 0x00, 0x07, 0xB9, 0x10,
  0x9F, 0xFF, 0x40, 0x00, 0x00, 0xBF, 0xFF, 0xB0, 0x00, 0x00, 0x3F, 0xFF, 0x90,
  0xBF, 0xFF, 0x80, 0x00, 0x00, 0xFF, 0xFF, 0xF1, 0x00, 0x00, 0x7F, 0xFF, 0xB0,
  0x8F, 0xFF, 0xB0, 0x00, 0x03, 0xFF, 0xFF, 0xF4, 0x00, 0x00, 0xAF, 0xFF, 0x80,
  0x4F, 0xFF, 0xE0, 0x00, 0x07, 0xFF, 0xFF, 0xF7, 0x00, 0x00, 0xDF, 0xFF, 0x40,
  0x1F, 0xFF, 0xF3, 0x00, 0x0A, 0xFF, 0xFF, 0xFB, 0x00, 0x01, 0xFF, 0xFF, 0x10,
  0x0B, 0xFF, 0xF5, 0x00, 0x0E, 0xFF, 0xDF, 0xFE, 0x00, 0x04, 0xFF, 0xFB, 0x00,
  0x07, 0xFF, 0xF8, 0x00, 0x2F, 0xFF, 0x6F, 0xFF, 0x30, 0x07, 0xFF, 0xF7, 0x00,
  0x04, 0xFF, 0xFB, 0x00, 0x6F, 0xFE, 0x0E, 0xFF, 0x70, 0x0B, 0xFF, 0xF4, 0x00,
  0x00, 0xFF, 0xFE, 0x00, 0x9F, 0xFA, 0x0A, 0xFF, 0xA0, 0x0E, 0xFF, 0xF0, 0x00,
  0x00, 0xBF, 0xFF, 0x30, 0xDF, 0xF7, 0x07, 0xFF, 0xD0, 0x2F, 0xFF, 0xB0, 0x00,
  0x00, 0x7F, 0xFF, 0x61, 0xFF, 0xF3, 0x03, 0xFF, 0xF2, 0x5F, 0xFF, 0x70, 0x00,
  0x00, 0x3F, 0xFF, 0x95, 0xFF, 0xE0, 0x00, 0xEF, 0xF5, 0x8F, 0xFF, 0x30, 0x00,
  0x00, 0x0E, 0xFF, 0xC8, 0xFF, 0xB0, 0x00, 0xBF, 0xF9, 0xBF, 0xFE, 0x00, 0x00,
  0x00, 0x0B, 0xFF, 0xFC, 0xFF, 0x70, 0x00, 0x7F, 0xFC, 0xEF, 0xFB, 0x00, 0x00,
  0x00, 0x07, 0xFF, 0xFF, 0xFF, 0x30, 0x00, 0x3F, 0xFF, 0xFF, 0xF7, 0x00, 0x00,
  0x00, 0x03, 0xFF, 0xFF, 0xFE, 0x00, 0x00, 0x0E, 0xFF, 0xFF, 0xF3, 0x00, 0x00,
  0x00, 0x00, 0xEF, 0xFF, 0xFB, 0x00, 0x00, 0x0B, 0xFF, 0xFF, 0xE0, 0x00, 0x00,
  0x00, 0x00, 0xAF, 0xFF, 0xF7, 0x00, 0x00, 0x07, 0xFF, 0xFF, 0xA0, 0x00, 0x00,
  0x00, 0x00, 0x3E, 0xFF, 0xE1, 0x00, 0x00, 0x01, 0xEF, 0xFE, 0x30, 0x00, 0x00,
  0x00, 0x00, 0x02, 0x55, 0x10, 0x00, 0x00, 0x00, 0x15, 0x52, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0058[168] = { // Code 0058, LATIN CAPITAL LETTER X
  0x03, 0xBB, 0x30, 0x00, 0x00, 0x01, 0xAB, 0x70,
  0x1E, 0xFF, 0xE1, 0x00, 0x00, 0x09, 0xFF, 0xF5,
  0x2F, 0xFF, 0xF9, 0x00, 0x00, 0x3F, 0xFF, 0xF7,
  0x0C, 0xFF, 0xFF, 0x30, 0x00, 0xCF, 0xFF, 0xE1,
  0x02, 0xFF, 0xFF, 0xB0, 0x07, 0xFF, 0xFF, 0x40,
  0x00, 0x7F, 0xFF, 0xF5, 0x2E, 0xFF, 0xF9, 0x00,
  0x00, 0x0C, 0xFF, 0xFD, 0xBF, 0xFF, 0xD1, 0x00,
  0x00, 0x02, 0xFF, 0xFF, 0xFF, 0xFF, 0x40, 0x00,
  0x00, 0x00, 0x7F, 0xFF, 0xFF, 0xF9, 0x00, 0x00,
  0x00, 0x00, 0x0C, 0xFF, 0xFF, 0xD1, 0x00, 0x00,
  0x00, 0x00, 0x0C, 0xFF, 0xFF, 0xD1, 0x00, 0x00,
  0x00, 0x00, 0x7F, 0xFF, 0xFF, 0xF9, 0x00, 0x00,
  0x00, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0x40, 0x00,
  0x00, 0x0D, 0xFF, 0xFD, 0xDF, 0xFF, 0xD1, 0x00,
  0x00, 0x8F, 0xFF, 0xF4, 0x5F, 0xFF, 0xF8, 0x00,
  0x04, 0xFF, 0xFF, 0xA0, 0x0B, 0xFF, 0xFF, 0x30,
  0x1D, 0xFF, 0xFE, 0x10, 0x02, 0xFF, 0xFF, 0xD0,
  0x7F, 0xFF, 0xF6, 0x00, 0x00, 0x8F, 0xFF, 0xF7,
  0xAF, 0xFF, 0xB0, 0x00, 0x00, 0x1D, 0xFF, 0xF9,
  0x5F, 0xFE, 0x20, 0x00, 0x00, 0x05, 0xFF, 0xF4,
  0x02, 0x52, 0x00, 0x00, 0x00, 0x00, 0x25, 0x20
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0059[189] = { // Code 0059, LATIN CAPITAL LETTER Y
  0x19, 0xB8, 0x00, 0x00, 0x00, 0x00, 0x2B, 0xB4, 0x00,
  0x9F, 0xFF, 0x70, 0x00, 0x00, 0x00, 0xCF, 0xFF, 0x20,
  0xBF, 0xFF, 0xE1, 0x00, 0x00, 0x06, 0xFF, 0xFF, 0x30,
  0x4F, 0xFF, 0xF8, 0x00, 0x00, 0x0D, 0xFF, 0xFC, 0x00,
  0x0B, 0xFF, 0xFF, 0x20, 0x00, 0x7F, 0xFF, 0xF3, 0x00,
  0x02, 0xFF, 0xFF, 0xA0, 0x01, 0xEF, 0xFF, 0xA0, 0x00,
  0x00, 0x8F, 0xFF, 0xF3, 0x08, 0xFF, 0xFE, 0x10, 0x00,
  0x00, 0x0D, 0xFF, 0xFB, 0x1F, 0xFF, 0xF7, 0x00, 0x00,
  0x00, 0x05, 0xFF, 0xFF, 0xCF, 0xFF, 0xC0, 0x00, 0x00,
  0x00, 0x00, 0xBF, 0xFF, 0xFF, 0xFF, 0x30, 0x00, 0x00,
  0x00, 0x00, 0x2F, 0xFF, 0xFF, 0xF9, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x07, 0xFF, 0xFF, 0xE1, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x80, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xEF, 0xFF, 0x70, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x7F, 0xFE, 0x20, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x03, 0x51, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_005A[180] = { // Code 005A, LATIN CAPITAL LETTER Z
  0x00, 0x26, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x30,
  0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF5,
  0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF7,
  0x02, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF5,
  0x00, 0x14, 0x44, 0x44, 0x44, 0x4C, 0xFF, 0xFF, 0xA0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0xFC, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0xFF, 0xFF, 0xD1, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x3E, 0xFF, 0xFE, 0x30, 0x00,
  0x00, 0x00, 0x00, 0x02, 0xEF, 0xFF, 0xF4, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x1C, 0xFF, 0xFF, 0x70, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xBF, 0xFF, 0xF9, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x08, 0xFF, 0xFF, 0xB0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x6F, 0xFF, 0xFD, 0x10, 0x00, 0x00, 0x00,
  0x00, 0x04, 0xFF, 0xFF, 0xE2, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x2E, 0xFF, 0xFF, 0x40, 0x00, 0x00, 0x00, 0x00,
  0x01, 0xDF, 0xFF, 0xF6, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0B, 0xFF, 0xFF, 0xFB, 0xBB, 0xBB, 0xBB, 0xBB, 0x71,
  0x2F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8,
  0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF9,
  0x07, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC2
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_005B[100] = { // Code 005B, LEFT SQUARE BRACKET
  0x04, 0x77, 0x77, 0x50,
  0x5F, 0xFF, 0xFF, 0xF5,
  0x9F, 0xFF, 0xFF, 0xF6,
  0x9F, 0xFE, 0x77, 0x50,
  0x9F, 0xFD, 0x00, 0x00,
  0x9F, 0xFD, 0x00, 0x00,
  0x9F, 0xFD, 0x00, 0x00,
  0x9F, 0xFD, 0x00, 0x00,
  0x9F, 0xFD, 0x00, 0x00,
  0x9F, 0xFD, 0x00, 0x00,
  0x9F, 0xFD, 0x00, 0x00,
  0x9F, 0xFD, 0x00, 0x00,
  0x9F, 0xFD, 0x00, 0x00,
  0x9F, 0xFD, 0x00, 0x00,
  0x9F, 0xFD, 0x00, 0x00,
  0x9F, 0xFD, 0x00, 0x00,
  0x9F, 0xFD, 0x00, 0x00,
  0x9F, 0xFD, 0x00, 0x00,
  0x9F, 0xFD, 0x00, 0x00,
  0x9F, 0xFD, 0x00, 0x00,
  0x9F, 0xFD, 0x00, 0x00,
  0x9F, 0xFD, 0x00, 0x00,
  0x9F, 0xFF, 0xFF, 0xC2,
  0x8F, 0xFF, 0xFF, 0xF7,
  0x2C, 0xFF, 0xFF, 0xD3
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_005C[105] = { // Code 005C, REVERSE SOLIDUS
  0x5D, 0x90, 0x00, 0x00, 0x00,
  0xBF, 0xF3, 0x00, 0x00, 0x00,
  0x8F, 0xF9, 0x00, 0x00, 0x00,
  0x2F, 0xFE, 0x00, 0x00, 0x00,
  0x0B, 0xFF, 0x50, 0x00, 0x00,
  0x06, 0xFF, 0xB0, 0x00, 0x00,
  0x01, 0xEF, 0xF2, 0x00, 0x00,
  0x00, 0x9F, 0xF7, 0x00, 0x00,
  0x00, 0x3F, 0xFD, 0x00, 0x00,
  0x00, 0x0D, 0xFF, 0x40, 0x00,
  0x00, 0x07, 0xFF, 0xA0, 0x00,
  0x00, 0x02, 0xFF, 0xF1, 0x00,
  0x00, 0x00, 0xBF, 0xF6, 0x00,
  0x00, 0x00, 0x5F, 0xFC, 0x00,
  0x00, 0x00, 0x0E, 0xFF, 0x20,
  0x00, 0x00, 0x09, 0xFF, 0x80,
  0x00, 0x00, 0x03, 0xFF, 0xE0,
  0x00, 0x00, 0x00, 0xCF, 0xF4,
  0x00, 0x00, 0x00, 0x7F, 0xFA,
  0x00, 0x00, 0x00, 0x1E, 0xFA,
  0x00, 0x00, 0x00, 0x03, 0x71
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_005D[100] = { // Code 005D, RIGHT SQUARE BRACKET
  0x26, 0x77, 0x75, 0x10,
  0xDF, 0xFF, 0xFF, 0xD0,
  0xDF, 0xFF, 0xFF, 0xF2,
  0x27, 0x7A, 0xFF, 0xF2,
  0x00, 0x06, 0xFF, 0xF2,
  0x00, 0x06, 0xFF, 0xF2,
  0x00, 0x06, 0xFF, 0xF2,
  0x00, 0x06, 0xFF, 0xF2,
  0x00, 0x06, 0xFF, 0xF2,
  0x00, 0x06, 0xFF, 0xF2,
  0x00, 0x06, 0xFF, 0xF2,
  0x00, 0x06, 0xFF, 0xF2,
  0x00, 0x06, 0xFF, 0xF2,
  0x00, 0x06, 0xFF, 0xF2,
  0x00, 0x06, 0xFF, 0xF2,
  0x00, 0x06, 0xFF, 0xF2,
  0x00, 0x06, 0xFF, 0xF2,
  0x00, 0x06, 0xFF, 0xF2,
  0x00, 0x06, 0xFF, 0xF2,
  0x00, 0x06, 0xFF, 0xF2,
  0x00, 0x06, 0xFF, 0xF2,
  0x00, 0x06, 0xFF, 0xF2,
  0x8E, 0xFF, 0xFF, 0xF2,
  0xEF, 0xFF, 0xFF, 0xF1,
  0x8F, 0xFF, 0xFE, 0x70
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_005E[ 77] = { // Code 005E, CIRCUMFLEX ACCENT
  0x00, 0x00, 0x02, 0xBC, 0x40, 0x00, 0x00,
  0x00, 0x00, 0x0C, 0xFF, 0xE1, 0x00, 0x00,
  0x00, 0x00, 0x5F, 0xFF, 0xF8, 0x00, 0x00,
  0x00, 0x00, 0xDF, 0xFF, 0xFF, 0x20, 0x00,
  0x00, 0x07, 0xFF, 0xEC, 0xFF, 0x90, 0x00,
  0x00, 0x1E, 0xFF, 0x74, 0xFF, 0xF3, 0x00,
  0x00, 0x8F, 0xFE, 0x00, 0xBF, 0xFB, 0x00,
  0x02, 0xFF, 0xF6, 0x00, 0x3F, 0xFF, 0x40,
  0x09, 0xFF, 0xC0, 0x00, 0x09, 0xFF, 0xC0,
  0x1F, 0xFF, 0x40, 0x00, 0x02, 0xFF, 0xF4,
  0x1D, 0xF9, 0x00, 0x00, 0x00, 0x6F, 0xF3
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_005F[ 16] = { // Code 005F, LOW LINE
  0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF3,
  0x36, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x50
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0060[ 18] = { // Code 0060, GRAVE ACCENT
  0x37, 0x30, 0x00,
  0xEF, 0xF7, 0x00,
  0xCF, 0xFF, 0xA1,
  0x1B, 0xFF, 0xFC,
  0x00, 0x6E, 0xFF,
  0x00, 0x02, 0x73
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0061[128] = { // Code 0061, LATIN SMALL LETTER A
  0x00, 0x00, 0x25, 0x77, 0x65, 0x10, 0x00, 0x00,
  0x00, 0x3B, 0xFF, 0xFF, 0xFF, 0xFB, 0x20, 0x00,
  0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE1, 0x00,
  0x0D, 0xFF, 0xFC, 0x87, 0xAF, 0xFF, 0xF7, 0x00,
  0x0E, 0xFF, 0x70, 0x00, 0x06, 0xFF, 0xF9, 0x00,
  0x03, 0x95, 0x00, 0x00, 0x05, 0xFF, 0xF9, 0x00,
  0x00, 0x00, 0x13, 0x56, 0x8E, 0xFF, 0xF9, 0x00,
  0x00, 0x7C, 0xFF, 0xFF, 0xFF, 0xFF, 0xF9, 0x00,
  0x1C, 0xFF, 0xFF, 0xFF, 0xDB, 0xFF, 0xF9, 0x00,
  0x8F, 0xFF, 0xD7, 0x31, 0x04, 0xFF, 0xF9, 0x00,
  0xCF, 0xFF, 0x30, 0x00, 0x06, 0xFF, 0xF9, 0x00,
  0xDF, 0xFF, 0x20, 0x00, 0x1D, 0xFF, 0xFA, 0x00,
  0xBF, 0xFF, 0xC5, 0x46, 0xDF, 0xFF, 0xFC, 0x00,
  0x3F, 0xFF, 0xFF, 0xFF, 0xF8, 0xFF, 0xFF, 0x00,
  0x04, 0xDF, 0xFF, 0xFD, 0x50, 0x9F, 0xFC, 0x00,
  0x00, 0x03, 0x64, 0x20, 0x00, 0x04, 0x51, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0062[168] = { // Code 0062, LATIN SMALL LETTER B
  0x08, 0xB9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x5F, 0xFF, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x7F, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x7F, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x7F, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x7F, 0xFF, 0x70, 0x26, 0x76, 0x20, 0x00, 0x00,
  0x7F, 0xFF, 0x78, 0xFF, 0xFF, 0xFA, 0x10, 0x00,
  0x7F, 0xFF, 0xDF, 0xFF, 0xFF, 0xFF, 0xB0, 0x00,
  0x7F, 0xFF, 0xFF, 0xB9, 0xCF, 0xFF, 0xF7, 0x00,
  0x7F, 0xFF, 0xF6, 0x00, 0x07, 0xFF, 0xFE, 0x00,
  0x7F, 0xFF, 0xB0, 0x00, 0x00, 0xDF, 0xFF, 0x40,
  0x7F, 0xFF, 0x70, 0x00, 0x00, 0x8F, 0xFF, 0x70,
  0x7F, 0xFF, 0x50, 0x00, 0x00, 0x7F, 0xFF, 0x70,
  0x7F, 0xFF, 0x50, 0x00, 0x00, 0x7F, 0xFF, 0x70,
  0x7F, 0xFF, 0x70, 0x00, 0x00, 0x9F, 0xFF, 0x60,
  0x7F, 0xFF, 0xB0, 0x00, 0x00, 0xEF, 0xFF, 0x30,
  0x7F, 0xFF, 0xF7, 0x00, 0x09, 0xFF, 0xFD, 0x00,
  0x7F, 0xFF, 0xFF, 0xDB, 0xEF, 0xFF, 0xF6, 0x00,
  0x7F, 0xFF, 0x9F, 0xFF, 0xFF, 0xFF, 0xA0, 0x00,
  0x3F, 0xFD, 0x08, 0xFF, 0xFF, 0xE7, 0x00, 0x00,
  0x03, 0x51, 0x00, 0x14, 0x63, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0063[112] = { // Code 0063, LATIN SMALL LETTER C
  0x00, 0x00, 0x01, 0x57, 0x75, 0x20, 0x00,
  0x00, 0x02, 0xAF, 0xFF, 0xFF, 0xFB, 0x30,
  0x00, 0x3E, 0xFF, 0xFF, 0xFF, 0xFF, 0xF4,
  0x01, 0xDF, 0xFF, 0xEA, 0xAD, 0xFF, 0xFC,
  0x07, 0xFF, 0xFD, 0x20, 0x00, 0xBF, 0xFE,
  0x0D, 0xFF, 0xF4, 0x00, 0x00, 0x1B, 0xD6,
  0x1F, 0xFF, 0xE0, 0x00, 0x00, 0x00, 0x00,
  0x2F, 0xFF, 0xB0, 0x00, 0x00, 0x00, 0x00,
  0x2F, 0xFF, 0xB0, 0x00, 0x00, 0x00, 0x00,
  0x2F, 0xFF, 0xD0, 0x00, 0x00, 0x02, 0x30,
  0x0E, 0xFF, 0xF3, 0x00, 0x00, 0x3E, 0xFB,
  0x09, 0xFF, 0xFD, 0x20, 0x02, 0xDF, 0xFE,
  0x02, 0xEF, 0xFF, 0xFC, 0xBF, 0xFF, 0xF9,
  0x00, 0x5E, 0xFF, 0xFF, 0xFF, 0xFF, 0xD1,
  0x00, 0x02, 0xAF, 0xFF, 0xFF, 0xE8, 0x10,
  0x00, 0x00, 0x01, 0x35, 0x53, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0064[147] = { // Code 0064, LATIN SMALL LETTER D
  0x00, 0x00, 0x00, 0x00, 0x00, 0x4B, 0xB3,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xEF, 0xFC,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF,
  0x00, 0x00, 0x47, 0x74, 0x00, 0xFF, 0xFF,
  0x00, 0x4E, 0xFF, 0xFF, 0xD2, 0xFF, 0xFF,
  0x05, 0xFF, 0xFF, 0xFF, 0xFD, 0xFF, 0xFF,
  0x1E, 0xFF, 0xFE, 0xAA, 0xEF, 0xFF, 0xFF,
  0x7F, 0xFF, 0xD2, 0x00, 0x1C, 0xFF, 0xFF,
  0xBF, 0xFF, 0x60, 0x00, 0x04, 0xFF, 0xFF,
  0xEF, 0xFF, 0x10, 0x00, 0x00, 0xEF, 0xFF,
  0xFF, 0xFE, 0x00, 0x00, 0x00, 0xCF, 0xFF,
  0xFF, 0xFE, 0x00, 0x00, 0x00, 0xCF, 0xFF,
  0xEF, 0xFF, 0x10, 0x00, 0x00, 0xEF, 0xFF,
  0xBF, 0xFF, 0x70, 0x00, 0x04, 0xFF, 0xFF,
  0x6F, 0xFF, 0xE3, 0x00, 0x2D, 0xFF, 0xFF,
  0x0D, 0xFF, 0xFF, 0xCC, 0xFF, 0xFF, 0xFF,
  0x03, 0xEF, 0xFF, 0xFF, 0xFE, 0xAF, 0xFE,
  0x00, 0x3B, 0xFF, 0xFF, 0xD3, 0x6F, 0xFB,
  0x00, 0x00, 0x25, 0x53, 0x00, 0x04, 0x50
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0065[128] = { // Code 0065, LATIN SMALL LETTER E
  0x00, 0x00, 0x04, 0x67, 0x63, 0x00, 0x00, 0x00,
  0x00, 0x08, 0xEF, 0xFF, 0xFF, 0xD5, 0x00, 0x00,
  0x01, 0xCF, 0xFF, 0xFF, 0xFF, 0xFF, 0xA0, 0x00,
  0x0B, 0xFF, 0xFC, 0x64, 0x7D, 0xFF, 0xF7, 0x00,
  0x4F, 0xFF, 0xB0, 0x00, 0x01, 0xDF, 0xFF, 0x10,
  0xAF, 0xFF, 0x30, 0x00, 0x00, 0x6F, 0xFF, 0x50,
  0xDF, 0xFF, 0x99, 0x99, 0x99, 0xBF, 0xFF, 0x70,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x70,
  0xFF, 0xFF, 0xBB, 0xBB, 0xBB, 0xBB, 0xB9, 0x20,
  0xEF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xBF, 0xFF, 0x50, 0x00, 0x00, 0x08, 0x91, 0x00,
  0x5F, 0xFF, 0xE4, 0x00, 0x02, 0xCF, 0xFA, 0x00,
  0x0B, 0xFF, 0xFF, 0xDB, 0xCF, 0xFF, 0xFA, 0x00,
  0x01, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xD2, 0x00,
  0x00, 0x06, 0xDF, 0xFF, 0xFF, 0xD7, 0x10, 0x00,
  0x00, 0x00, 0x02, 0x46, 0x42, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0066[105] = { // Code 0066, LATIN SMALL LETTER F
  0x00, 0x00, 0x3A, 0xDD, 0xA2,
  0x00, 0x05, 0xFF, 0xFF, 0xFA,
  0x00, 0x0E, 0xFF, 0xFF, 0xF9,
  0x00, 0x2F, 0xFF, 0xE4, 0x51,
  0x00, 0x4F, 0xFF, 0xB0, 0x00,
  0x01, 0x5F, 0xFF, 0xC2, 0x10,
  0x7F, 0xFF, 0xFF, 0xFF, 0xF8,
  0x9F, 0xFF, 0xFF, 0xFF, 0xFA,
  0x17, 0x9F, 0xFF, 0xD7, 0x71,
  0x00, 0x4F, 0xFF, 0xB0, 0x00,
  0x00, 0x4F, 0xFF, 0xB0, 0x00,
  0x00, 0x4F, 0xFF, 0xB0, 0x00,
  0x00, 0x4F, 0xFF, 0xB0, 0x00,
  0x00, 0x4F, 0xFF, 0xB0, 0x00,
  0x00, 0x4F, 0xFF, 0xB0, 0x00,
  0x00, 0x4F, 0xFF, 0xB0, 0x00,
  0x00, 0x4F, 0xFF, 0xB0, 0x00,
  0x00, 0x4F, 0xFF, 0xB0, 0x00,
  0x00, 0x3F, 0xFF, 0xB0, 0x00,
  0x00, 0x0D, 0xFF, 0x70, 0x00,
  0x00, 0x01, 0x53, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0067[147] = { // Code 0067, LATIN SMALL LETTER G
  0x00, 0x00, 0x47, 0x75, 0x00, 0x06, 0x71,
  0x00, 0x4D, 0xFF, 0xFF, 0xE3, 0x7F, 0xFB,
  0x04, 0xFF, 0xFF, 0xFF, 0xFE, 0xBF, 0xFE,
  0x1E, 0xFF, 0xFE, 0xA9, 0xDF, 0xFF, 0xFF,
  0x7F, 0xFF, 0xD1, 0x00, 0x0B, 0xFF, 0xFF,
  0xBF, 0xFF, 0x40, 0x00, 0x02, 0xFF, 0xFF,
  0xEF, 0xFF, 0x00, 0x00, 0x00, 0xEF, 0xFF,
  0xFF, 0xFD, 0x00, 0x00, 0x00, 0xDF, 0xFF,
  0xFF, 0xFE, 0x00, 0x00, 0x00, 0xDF, 0xFF,
  0xEF, 0xFF, 0x30, 0x00, 0x01, 0xFF, 0xFF,
  0xAF, 0xFF, 0xA0, 0x00, 0x08, 0xFF, 0xFF,
  0x4F, 0xFF, 0xFB, 0x55, 0xAF, 0xFF, 0xFF,
  0x0A, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0x00, 0x9F, 0xFF, 0xFF, 0xF6, 0xDF, 0xFF,
  0x00, 0x02, 0x79, 0x97, 0x10, 0xDF, 0xFD,
  0x00, 0x20, 0x00, 0x00, 0x01, 0xFF, 0xFC,
  0x0A, 0xFD, 0x30, 0x00, 0x06, 0xFF, 0xF8,
  0x0F, 0xFF, 0xE7, 0x23, 0x7F, 0xFF, 0xF2,
  0x0B, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x70,
  0x01, 0xAF, 0xFF, 0xFF, 0xFF, 0xF7, 0x00,
  0x00, 0x03, 0x7A, 0xBB, 0xA6, 0x10, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0068[147] = { // Code 0068, LATIN SMALL LETTER H
  0x08, 0xB9, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x5F, 0xFF, 0x60, 0x00, 0x00, 0x00, 0x00,
  0x7F, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x00,
  0x7F, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x00,
  0x7F, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x00,
  0x7F, 0xFF, 0x70, 0x05, 0x77, 0x40, 0x00,
  0x7F, 0xFF, 0x75, 0xEF, 0xFF, 0xFD, 0x30,
  0x7F, 0xFF, 0xCF, 0xFF, 0xFF, 0xFF, 0xE2,
  0x7F, 0xFF, 0xFF, 0xEB, 0xEF, 0xFF, 0xF9,
  0x7F, 0xFF, 0xF9, 0x00, 0x0A, 0xFF, 0xFD,
  0x7F, 0xFF, 0xC0, 0x00, 0x02, 0xFF, 0xFE,
  0x7F, 0xFF, 0x80, 0x00, 0x00, 0xFF, 0xFF,
  0x7F, 0xFF, 0x70, 0x00, 0x00, 0xFF, 0xFF,
  0x7F, 0xFF, 0x70, 0x00, 0x00, 0xFF, 0xFF,
  0x7F, 0xFF, 0x70, 0x00, 0x00, 0xFF, 0xFF,
  0x7F, 0xFF, 0x70, 0x00, 0x00, 0xFF, 0xFF,
  0x7F, 0xFF, 0x70, 0x00, 0x00, 0xFF, 0xFF,
  0x7F, 0xFF, 0x70, 0x00, 0x00, 0xFF, 0xFF,
  0x6F, 0xFF, 0x70, 0x00, 0x00, 0xFF, 0xFE,
  0x3F, 0xFF, 0x30, 0x00, 0x00, 0xBF, 0xFA,
  0x02, 0x62, 0x00, 0x00, 0x00, 0x05, 0x50
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0069[ 63] = { // Code 0069, LATIN SMALL LETTER I
  0x07, 0xDB, 0x20,
  0x3F, 0xFF, 0xA0,
  0x3F, 0xFF, 0xB0,
  0x0B, 0xFF, 0x40,
  0x00, 0x31, 0x00,
  0x03, 0x76, 0x00,
  0x1E, 0xFF, 0x70,
  0x3F, 0xFF, 0xB0,
  0x4F, 0xFF, 0xB0,
  0x4F, 0xFF, 0xB0,
  0x4F, 0xFF, 0xB0,
  0x4F, 0xFF, 0xB0,
  0x4F, 0xFF, 0xB0,
  0x4F, 0xFF, 0xB0,
  0x4F, 0xFF, 0xB0,
  0x4F, 0xFF, 0xB0,
  0x4F, 0xFF, 0xB0,
  0x4F, 0xFF, 0xB0,
  0x3F, 0xFF, 0xB0,
  0x0D, 0xFF, 0x60,
  0x01, 0x54, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_006A[104] = { // Code 006A, LATIN SMALL LETTER J
  0x00, 0x07, 0xDB, 0x20,
  0x00, 0x3F, 0xFF, 0xA0,
  0x00, 0x3F, 0xFF, 0xB0,
  0x00, 0x0B, 0xFF, 0x40,
  0x00, 0x00, 0x31, 0x00,
  0x00, 0x03, 0x76, 0x00,
  0x00, 0x1E, 0xFF, 0x70,
  0x00, 0x3F, 0xFF, 0xB0,
  0x00, 0x4F, 0xFF, 0xB0,
  0x00, 0x4F, 0xFF, 0xB0,
  0x00, 0x4F, 0xFF, 0xB0,
  0x00, 0x4F, 0xFF, 0xB0,
  0x00, 0x4F, 0xFF, 0xB0,
  0x00, 0x4F, 0xFF, 0xB0,
  0x00, 0x4F, 0xFF, 0xB0,
  0x00, 0x4F, 0xFF, 0xB0,
  0x00, 0x4F, 0xFF, 0xB0,
  0x00, 0x4F, 0xFF, 0xB0,
  0x00, 0x4F, 0xFF, 0xB0,
  0x00, 0x4F, 0xFF, 0xB0,
  0x00, 0x4F, 0xFF, 0xB0,
  0x00, 0x4F, 0xFF, 0xB0,
  0x17, 0xAF, 0xFF, 0xA0,
  0x6F, 0xFF, 0xFF, 0x60,
  0x5F, 0xFF, 0xFC, 0x00,
  0x06, 0x98, 0x50, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_006B[147] = { // Code 006B, LATIN SMALL LETTER K
  0x08, 0xB9, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x5F, 0xFF, 0x60, 0x00, 0x00, 0x00, 0x00,
  0x7F, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x00,
  0x7F, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x00,
  0x7F, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x00,
  0x7F, 0xFF, 0x70, 0x00, 0x03, 0x72, 0x00,
  0x7F, 0xFF, 0x70, 0x00, 0x5F, 0xFE, 0x10,
  0x7F, 0xFF, 0x70, 0x03, 0xFF, 0xFF, 0x30,
  0x7F, 0xFF, 0x70, 0x2E, 0xFF, 0xFB, 0x00,
  0x7F, 0xFF, 0x72, 0xEF, 0xFF, 0xB1, 0x00,
  0x7F, 0xFF, 0x9D, 0xFF, 0xFB, 0x10, 0x00,
  0x7F, 0xFF, 0xFF, 0xFF, 0xE1, 0x00, 0x00,
  0x7F, 0xFF, 0xFF, 0xFF, 0xF6, 0x00, 0x00,
  0x7F, 0xFF, 0xFF, 0xFF, 0xFE, 0x30, 0x00,
  0x7F, 0xFF, 0xF8, 0xDF, 0xFF, 0xC0, 0x00,
  0x7F, 0xFF, 0x90, 0x3F, 0xFF, 0xF9, 0x00,
  0x7F, 0xFF, 0x70, 0x07, 0xFF, 0xFF, 0x50,
  0x7F, 0xFF, 0x70, 0x00, 0xBF, 0xFF, 0xE1,
  0x6F, 0xFF, 0x70, 0x00, 0x2E, 0xFF, 0xF3,
  0x3F, 0xFF, 0x30, 0x00, 0x05, 0xFF, 0xD0,
  0x02, 0x52, 0x00, 0x00, 0x00, 0x25, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_006C[ 63] = { // Code 006C, LATIN SMALL LETTER L
  0x06, 0xBA, 0x10,
  0x2F, 0xFF, 0x90,
  0x4F, 0xFF, 0xB0,
  0x4F, 0xFF, 0xB0,
  0x4F, 0xFF, 0xB0,
  0x4F, 0xFF, 0xB0,
  0x4F, 0xFF, 0xB0,
  0x4F, 0xFF, 0xB0,
  0x4F, 0xFF, 0xB0,
  0x4F, 0xFF, 0xB0,
  0x4F, 0xFF, 0xB0,
  0x4F, 0xFF, 0xB0,
  0x4F, 0xFF, 0xB0,
  0x4F, 0xFF, 0xB0,
  0x4F, 0xFF, 0xB0,
  0x4F, 0xFF, 0xB0,
  0x4F, 0xFF, 0xB0,
  0x4F, 0xFF, 0xB0,
  0x3F, 0xFF, 0xB0,
  0x0D, 0xFF, 0x60,
  0x01, 0x53, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_006D[192] = { // Code 006D, LATIN SMALL LETTER M
  0x03, 0x73, 0x00, 0x04, 0x77, 0x40, 0x00, 0x02, 0x67, 0x63, 0x00, 0x00,
  0x3F, 0xFE, 0x14, 0xDF, 0xFF, 0xFB, 0x10, 0x9F, 0xFF, 0xFF, 0xC1, 0x00,
  0x7F, 0xFF, 0x8F, 0xFF, 0xFF, 0xFF, 0xAA, 0xFF, 0xFF, 0xFF, 0xFC, 0x00,
  0x7F, 0xFF, 0xFF, 0xEB, 0xEF, 0xFF, 0xFF, 0xFE, 0xBF, 0xFF, 0xFF, 0x30,
  0x7F, 0xFF, 0xF8, 0x00, 0x1E, 0xFF, 0xFF, 0x70, 0x02, 0xEF, 0xFF, 0x60,
  0x7F, 0xFF, 0xC0, 0x00, 0x08, 0xFF, 0xFB, 0x00, 0x00, 0x9F, 0xFF, 0x70,
  0x7F, 0xFF, 0x80, 0x00, 0x07, 0xFF, 0xF7, 0x00, 0x00, 0x7F, 0xFF, 0x70,
  0x7F, 0xFF, 0x70, 0x00, 0x07, 0xFF, 0xF7, 0x00, 0x00, 0x7F, 0xFF, 0x70,
  0x7F, 0xFF, 0x70, 0x00, 0x07, 0xFF, 0xF7, 0x00, 0x00, 0x7F, 0xFF, 0x70,
  0x7F, 0xFF, 0x70, 0x00, 0x07, 0xFF, 0xF7, 0x00, 0x00, 0x7F, 0xFF, 0x70,
  0x7F, 0xFF, 0x70, 0x00, 0x07, 0xFF, 0xF7, 0x00, 0x00, 0x7F, 0xFF, 0x70,
  0x7F, 0xFF, 0x70, 0x00, 0x07, 0xFF, 0xF7, 0x00, 0x00, 0x7F, 0xFF, 0x70,
  0x7F, 0xFF, 0x70, 0x00, 0x07, 0xFF, 0xF7, 0x00, 0x00, 0x7F, 0xFF, 0x70,
  0x6F, 0xFF, 0x70, 0x00, 0x07, 0xFF, 0xF7, 0x00, 0x00, 0x7F, 0xFF, 0x60,
  0x3F, 0xFF, 0x30, 0x00, 0x03, 0xFF, 0xF3, 0x00, 0x00, 0x3F, 0xFF, 0x30,
  0x02, 0x62, 0x00, 0x00, 0x00, 0x26, 0x20, 0x00, 0x00, 0x02, 0x62, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_006E[112] = { // Code 006E, LATIN SMALL LETTER N
  0x04, 0x73, 0x00, 0x05, 0x77, 0x40, 0x00,
  0x3F, 0xFE, 0x05, 0xEF, 0xFF, 0xFD, 0x30,
  0x7F, 0xFF, 0x8F, 0xFF, 0xFF, 0xFF, 0xE2,
  0x7F, 0xFF, 0xFF, 0xEB, 0xEF, 0xFF, 0xF9,
  0x7F, 0xFF, 0xF9, 0x00, 0x0A, 0xFF, 0xFD,
  0x7F, 0xFF, 0xC0, 0x00, 0x02, 0xFF, 0xFE,
  0x7F, 0xFF, 0x80, 0x00, 0x00, 0xFF, 0xFF,
  0x7F, 0xFF, 0x70, 0x00, 0x00, 0xFF, 0xFF,
  0x7F, 0xFF, 0x70, 0x00, 0x00, 0xFF, 0xFF,
  0x7F, 0xFF, 0x70, 0x00, 0x00, 0xFF, 0xFF,
  0x7F, 0xFF, 0x70, 0x00, 0x00, 0xFF, 0xFF,
  0x7F, 0xFF, 0x70, 0x00, 0x00, 0xFF, 0xFF,
  0x7F, 0xFF, 0x70, 0x00, 0x00, 0xFF, 0xFF,
  0x6F, 0xFF, 0x70, 0x00, 0x00, 0xFF, 0xFE,
  0x3F, 0xFF, 0x30, 0x00, 0x00, 0xBF, 0xFA,
  0x02, 0x62, 0x00, 0x00, 0x00, 0x05, 0x50
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_006F[128] = { // Code 006F, LATIN SMALL LETTER O
  0x00, 0x00, 0x15, 0x77, 0x63, 0x00, 0x00, 0x00,
  0x00, 0x19, 0xFF, 0xFF, 0xFF, 0xD5, 0x00, 0x00,
  0x02, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x00,
  0x0C, 0xFF, 0xFE, 0x87, 0xAF, 0xFF, 0xF5, 0x00,
  0x5F, 0xFF, 0xD1, 0x00, 0x06, 0xFF, 0xFD, 0x00,
  0xBF, 0xFF, 0x50, 0x00, 0x00, 0xCF, 0xFF, 0x30,
  0xEF, 0xFF, 0x10, 0x00, 0x00, 0x8F, 0xFF, 0x70,
  0xFF, 0xFD, 0x00, 0x00, 0x00, 0x6F, 0xFF, 0x70,
  0xFF, 0xFE, 0x00, 0x00, 0x00, 0x6F, 0xFF, 0x70,
  0xEF, 0xFF, 0x10, 0x00, 0x00, 0x8F, 0xFF, 0x70,
  0xBF, 0xFF, 0x60, 0x00, 0x00, 0xDF, 0xFF, 0x30,
  0x5F, 0xFF, 0xE2, 0x00, 0x08, 0xFF, 0xFD, 0x00,
  0x0C, 0xFF, 0xFF, 0xA9, 0xCF, 0xFF, 0xF6, 0x00,
  0x02, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x00,
  0x00, 0x18, 0xEF, 0xFF, 0xFF, 0xC4, 0x00, 0x00,
  0x00, 0x00, 0x03, 0x56, 0x42, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0070[168] = { // Code 0070, LATIN SMALL LETTER P
  0x04, 0x73, 0x00, 0x26, 0x75, 0x20, 0x00, 0x00,
  0x4F, 0xFE, 0x1A, 0xFF, 0xFF, 0xF9, 0x10, 0x00,
  0x7F, 0xFF, 0xAF, 0xFF, 0xFF, 0xFF, 0xB0, 0x00,
  0x7F, 0xFF, 0xFF, 0xB9, 0xCF, 0xFF, 0xF7, 0x00,
  0x7F, 0xFF, 0xF5, 0x00, 0x08, 0xFF, 0xFE, 0x00,
  0x7F, 0xFF, 0xB0, 0x00, 0x00, 0xDF, 0xFF, 0x40,
  0x7F, 0xFF, 0x60, 0x00, 0x00, 0x8F, 0xFF, 0x70,
  0x7F, 0xFF, 0x40, 0x00, 0x00, 0x6F, 0xFF, 0x70,
  0x7F, 0xFF, 0x50, 0x00, 0x00, 0x7F, 0xFF, 0x70,
  0x7F, 0xFF, 0x70, 0x00, 0x00, 0x9F, 0xFF, 0x70,
  0x7F, 0xFF, 0xC0, 0x00, 0x00, 0xDF, 0xFF, 0x30,
  0x7F, 0xFF, 0xF8, 0x00, 0x09, 0xFF, 0xFE, 0x00,
  0x7F, 0xFF, 0xFF, 0xDB, 0xDF, 0xFF, 0xF6, 0x00,
  0x7F, 0xFF, 0xCF, 0xFF, 0xFF, 0xFF, 0xA0, 0x00,
  0x7F, 0xFF, 0x76, 0xEF, 0xFF, 0xF8, 0x00, 0x00,
  0x7F, 0xFF, 0x70, 0x14, 0x64, 0x10, 0x00, 0x00,
  0x7F, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x7F, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x7F, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x4F, 0xFF, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x05, 0x95, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0071[147] = { // Code 0071, LATIN SMALL LETTER Q
  0x00, 0x00, 0x47, 0x75, 0x00, 0x06, 0x71,
  0x00, 0x4D, 0xFF, 0xFF, 0xE4, 0x7F, 0xFB,
  0x04, 0xFF, 0xFF, 0xFF, 0xFE, 0xBF, 0xFE,
  0x1E, 0xFF, 0xFF, 0xAA, 0xEF, 0xFF, 0xFF,
  0x7F, 0xFF, 0xE2, 0x00, 0x1C, 0xFF, 0xFF,
  0xBF, 0xFF, 0x60, 0x00, 0x03, 0xFF, 0xFF,
  0xEF, 0xFF, 0x10, 0x00, 0x00, 0xEF, 0xFF,
  0xFF, 0xFE, 0x00, 0x00, 0x00, 0xCF, 0xFF,
  0xFF, 0xFE, 0x00, 0x00, 0x00, 0xCF, 0xFF,
  0xEF, 0xFF, 0x10, 0x00, 0x00, 0xEF, 0xFF,
  0xBF, 0xFF, 0x60, 0x00, 0x05, 0xFF, 0xFF,
  0x6F, 0xFF, 0xE3, 0x00, 0x2D, 0xFF, 0xFF,
  0x0D, 0xFF, 0xFF, 0xCC, 0xFF, 0xFF, 0xFF,
  0x04, 0xFF, 0xFF, 0xFF, 0xFC, 0xFF, 0xFF,
  0x00, 0x3C, 0xFF, 0xFF, 0xB1, 0xFF, 0xFF,
  0x00, 0x00, 0x35, 0x52, 0x00, 0xFF, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFE,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xDF, 0xFB,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x81
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0072[ 80] = { // Code 0072, LATIN SMALL LETTER R
  0x03, 0x73, 0x00, 0x37, 0x50,
  0x1E, 0xFF, 0x26, 0xFF, 0xF8,
  0x4F, 0xFF, 0x7F, 0xFF, 0xFC,
  0x4F, 0xFF, 0xDF, 0xFF, 0xF8,
  0x4F, 0xFF, 0xFE, 0x86, 0x50,
  0x4F, 0xFF, 0xF5, 0x00, 0x00,
  0x4F, 0xFF, 0xE0, 0x00, 0x00,
  0x4F, 0xFF, 0xB0, 0x00, 0x00,
  0x4F, 0xFF, 0xB0, 0x00, 0x00,
  0x4F, 0xFF, 0xB0, 0x00, 0x00,
  0x4F, 0xFF, 0xB0, 0x00, 0x00,
  0x4F, 0xFF, 0xB0, 0x00, 0x00,
  0x4F, 0xFF, 0xB0, 0x00, 0x00,
  0x3F, 0xFF, 0xB0, 0x00, 0x00,
  0x0D, 0xFF, 0x60, 0x00, 0x00,
  0x01, 0x54, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0073[112] = { // Code 0073, LATIN SMALL LETTER S
  0x00, 0x00, 0x35, 0x77, 0x52, 0x00, 0x00,
  0x00, 0x3C, 0xFF, 0xFF, 0xFF, 0xD5, 0x00,
  0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x70,
  0x0C, 0xFF, 0xFC, 0x77, 0xAF, 0xFF, 0xD0,
  0x0F, 0xFF, 0xE0, 0x00, 0x05, 0xEF, 0x90,
  0x0F, 0xFF, 0xF7, 0x10, 0x00, 0x13, 0x00,
  0x0C, 0xFF, 0xFF, 0xFC, 0x95, 0x10, 0x00,
  0x03, 0xEF, 0xFF, 0xFF, 0xFF, 0xF8, 0x10,
  0x00, 0x29, 0xEF, 0xFF, 0xFF, 0xFF, 0xB0,
  0x00, 0x00, 0x03, 0x7B, 0xEF, 0xFF, 0xF5,
  0x07, 0xC7, 0x00, 0x00, 0x0A, 0xFF, 0xF7,
  0x0F, 0xFF, 0x90, 0x00, 0x07, 0xFF, 0xF7,
  0x0E, 0xFF, 0xFC, 0x76, 0x9F, 0xFF, 0xF2,
  0x04, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0x70,
  0x00, 0x29, 0xEF, 0xFF, 0xFF, 0xC4, 0x00,
  0x00, 0x00, 0x03, 0x46, 0x41, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0074[100] = { // Code 0074, LATIN SMALL LETTER T
  0x00, 0x03, 0x74, 0x00, 0x00,
  0x00, 0x3F, 0xFF, 0x50, 0x00,
  0x00, 0x6F, 0xFF, 0x70, 0x00,
  0x00, 0x6F, 0xFF, 0x70, 0x00,
  0x01, 0x7F, 0xFF, 0x82, 0x10,
  0x7F, 0xFF, 0xFF, 0xFF, 0xF5,
  0x9F, 0xFF, 0xFF, 0xFF, 0xF7,
  0x17, 0xAF, 0xFF, 0xB7, 0x60,
  0x00, 0x6F, 0xFF, 0x70, 0x00,
  0x00, 0x6F, 0xFF, 0x70, 0x00,
  0x00, 0x6F, 0xFF, 0x70, 0x00,
  0x00, 0x6F, 0xFF, 0x70, 0x00,
  0x00, 0x6F, 0xFF, 0x70, 0x00,
  0x00, 0x6F, 0xFF, 0x70, 0x00,
  0x00, 0x6F, 0xFF, 0x70, 0x00,
  0x00, 0x6F, 0xFF, 0x80, 0x00,
  0x00, 0x5F, 0xFF, 0xFB, 0xA2,
  0x00, 0x2F, 0xFF, 0xFF, 0xF7,
  0x00, 0x06, 0xFF, 0xFF, 0xE3,
  0x00, 0x00, 0x14, 0x64, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0075[112] = { // Code 0075, LATIN SMALL LETTER U
  0x04, 0x74, 0x00, 0x00, 0x00, 0x17, 0x71,
  0x3F, 0xFF, 0x40, 0x00, 0x00, 0xCF, 0xFB,
  0x7F, 0xFF, 0x70, 0x00, 0x00, 0xFF, 0xFE,
  0x7F, 0xFF, 0x70, 0x00, 0x00, 0xFF, 0xFF,
  0x7F, 0xFF, 0x70, 0x00, 0x00, 0xFF, 0xFF,
  0x7F, 0xFF, 0x70, 0x00, 0x00, 0xFF, 0xFF,
  0x7F, 0xFF, 0x70, 0x00, 0x00, 0xFF, 0xFF,
  0x7F, 0xFF, 0x70, 0x00, 0x00, 0xFF, 0xFF,
  0x7F, 0xFF, 0x70, 0x00, 0x00, 0xFF, 0xFF,
  0x7F, 0xFF, 0x70, 0x00, 0x01, 0xFF, 0xFF,
  0x6F, 0xFF, 0xB0, 0x00, 0x06, 0xFF, 0xFF,
  0x5F, 0xFF, 0xF5, 0x00, 0x5E, 0xFF, 0xFF,
  0x1F, 0xFF, 0xFF, 0xEE, 0xFF, 0xFF, 0xFF,
  0x07, 0xFF, 0xFF, 0xFF, 0xFB, 0xAF, 0xFE,
  0x00, 0x7F, 0xFF, 0xFF, 0x80, 0x6F, 0xFA,
  0x00, 0x01, 0x46, 0x41, 0x00, 0x04, 0x50
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0076[112] = { // Code 0076, LATIN SMALL LETTER V
  0x05, 0x61, 0x00, 0x00, 0x00, 0x37, 0x20,
  0x8F, 0xFC, 0x00, 0x00, 0x04, 0xFF, 0xE1,
  0xBF, 0xFF, 0x30, 0x00, 0x0A, 0xFF, 0xF4,
  0x9F, 0xFF, 0x70, 0x00, 0x0E, 0xFF, 0xF2,
  0x3F, 0xFF, 0xB0, 0x00, 0x4F, 0xFF, 0xB0,
  0x0D, 0xFF, 0xF1, 0x00, 0x8F, 0xFF, 0x60,
  0x08, 0xFF, 0xF5, 0x00, 0xDF, 0xFF, 0x10,
  0x02, 0xFF, 0xFA, 0x02, 0xFF, 0xFA, 0x00,
  0x00, 0xCF, 0xFE, 0x07, 0xFF, 0xF4, 0x00,
  0x00, 0x7F, 0xFF, 0x4B, 0xFF, 0xE0, 0x00,
  0x00, 0x1F, 0xFF, 0x9F, 0xFF, 0x90, 0x00,
  0x00, 0x0B, 0xFF, 0xFF, 0xFF, 0x30, 0x00,
  0x00, 0x05, 0xFF, 0xFF, 0xFD, 0x00, 0x00,
  0x00, 0x01, 0xFF, 0xFF, 0xF8, 0x00, 0x00,
  0x00, 0x00, 0x9F, 0xFF, 0xE2, 0x00, 0x00,
  0x00, 0x00, 0x04, 0x65, 0x20, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0077[176] = { // Code 0077, LATIN SMALL LETTER W
  0x04, 0x72, 0x00, 0x00, 0x05, 0x75, 0x00, 0x00, 0x02, 0x74, 0x00,
  0x6F, 0xFE, 0x00, 0x00, 0x6F, 0xFF, 0x70, 0x00, 0x0D, 0xFF, 0x60,
  0x9F, 0xFF, 0x30, 0x00, 0xCF, 0xFF, 0xD0, 0x00, 0x3F, 0xFF, 0x90,
  0x7F, 0xFF, 0x70, 0x01, 0xFF, 0xFF, 0xF2, 0x00, 0x7F, 0xFF, 0x70,
  0x2F, 0xFF, 0xB0, 0x04, 0xFF, 0xFF, 0xF5, 0x00, 0xAF, 0xFF, 0x30,
  0x0D, 0xFF, 0xE0, 0x07, 0xFF, 0xEF, 0xF9, 0x00, 0xEF, 0xFD, 0x00,
  0x08, 0xFF, 0xF3, 0x0A, 0xFF, 0x7F, 0xFC, 0x02, 0xFF, 0xF8, 0x00,
  0x03, 0xFF, 0xF7, 0x0D, 0xFE, 0x0E, 0xFF, 0x05, 0xFF, 0xF4, 0x00,
  0x00, 0xEF, 0xFA, 0x2F, 0xFB, 0x0B, 0xFF, 0x38, 0xFF, 0xE0, 0x00,
  0x00, 0x9F, 0xFE, 0x5F, 0xF7, 0x07, 0xFF, 0x7C, 0xFF, 0xA0, 0x00,
  0x00, 0x5F, 0xFF, 0xBF, 0xF3, 0x03, 0xFF, 0xBF, 0xFF, 0x50, 0x00,
  0x00, 0x1F, 0xFF, 0xFF, 0xE0, 0x00, 0xEF, 0xFF, 0xFF, 0x10, 0x00,
  0x00, 0x0B, 0xFF, 0xFF, 0xB0, 0x00, 0xBF, 0xFF, 0xFB, 0x00, 0x00,
  0x00, 0x06, 0xFF, 0xFF, 0x70, 0x00, 0x7F, 0xFF, 0xF6, 0x00, 0x00,
  0x00, 0x01, 0xEF, 0xFE, 0x20, 0x00, 0x2E, 0xFF, 0xE1, 0x00, 0x00,
  0x00, 0x00, 0x15, 0x52, 0x00, 0x00, 0x02, 0x55, 0x10, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0078[112] = { // Code 0078, LATIN SMALL LETTER X
  0x01, 0x75, 0x00, 0x00, 0x02, 0x73, 0x00,
  0x0D, 0xFF, 0x60, 0x00, 0x2E, 0xFF, 0x30,
  0x3F, 0xFF, 0xE1, 0x00, 0xBF, 0xFF, 0x50,
  0x0D, 0xFF, 0xFA, 0x05, 0xFF, 0xFE, 0x10,
  0x03, 0xFF, 0xFF, 0x4D, 0xFF, 0xF5, 0x00,
  0x00, 0x8F, 0xFF, 0xFF, 0xFF, 0xA0, 0x00,
  0x00, 0x0D, 0xFF, 0xFF, 0xFE, 0x10, 0x00,
  0x00, 0x03, 0xFF, 0xFF, 0xF5, 0x00, 0x00,
  0x00, 0x07, 0xFF, 0xFF, 0xF9, 0x00, 0x00,
  0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0x40, 0x00,
  0x00, 0xCF, 0xFF, 0xCF, 0xFF, 0xD1, 0x00,
  0x08, 0xFF, 0xFC, 0x0D, 0xFF, 0xF9, 0x00,
  0x3F, 0xFF, 0xF3, 0x03, 0xFF, 0xFF, 0x40,
  0x7F, 0xFF, 0x80, 0x00, 0x9F, 0xFF, 0x70,
  0x3F, 0xFD, 0x10, 0x00, 0x1D, 0xFF, 0x30,
  0x02, 0x51, 0x00, 0x00, 0x01, 0x52, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_0079[147] = { // Code 0079, LATIN SMALL LETTER Y
  0x04, 0x72, 0x00, 0x00, 0x00, 0x57, 0x10,
  0x6F, 0xFE, 0x10, 0x00, 0x06, 0xFF, 0xD0,
  0x9F, 0xFF, 0x60, 0x00, 0x0C, 0xFF, 0xF2,
  0x7F, 0xFF, 0xA0, 0x00, 0x1F, 0xFF, 0xD0,
  0x2F, 0xFF, 0xE0, 0x00, 0x5F, 0xFF, 0x80,
  0x0B, 0xFF, 0xF3, 0x00, 0x9F, 0xFF, 0x30,
  0x06, 0xFF, 0xF7, 0x00, 0xDF, 0xFC, 0x00,
  0x01, 0xFF, 0xFC, 0x02, 0xFF, 0xF7, 0x00,
  0x00, 0xAF, 0xFF, 0x16, 0xFF, 0xF2, 0x00,
  0x00, 0x5F, 0xFF, 0x5A, 0xFF, 0xB0, 0x00,
  0x00, 0x1E, 0xFF, 0x9E, 0xFF, 0x70, 0x00,
  0x00, 0x0A, 0xFF, 0xFF, 0xFF, 0x10, 0x00,
  0x00, 0x05, 0xFF, 0xFF, 0xFB, 0x00, 0x00,
  0x00, 0x00, 0xEF, 0xFF, 0xF5, 0x00, 0x00,
  0x00, 0x00, 0x9F, 0xFF, 0xF1, 0x00, 0x00,
  0x00, 0x00, 0x4F, 0xFF, 0xA0, 0x00, 0x00,
  0x00, 0x00, 0x5F, 0xFF, 0x50, 0x00, 0x00,
  0x02, 0xAD, 0xFF, 0xFE, 0x00, 0x00, 0x00,
  0x09, 0xFF, 0xFF, 0xF6, 0x00, 0x00, 0x00,
  0x07, 0xFF, 0xFF, 0xA0, 0x00, 0x00, 0x00,
  0x00, 0x69, 0x84, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_007A[120] = { // Code 007A, LATIN SMALL LETTER Z
  0x00, 0x12, 0x22, 0x22, 0x22, 0x22, 0x20, 0x00,
  0x04, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0x00,
  0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00,
  0x03, 0xCF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xBF, 0xFF, 0xD1, 0x00,
  0x00, 0x00, 0x00, 0x0A, 0xFF, 0xFD, 0x10, 0x00,
  0x00, 0x00, 0x00, 0x9F, 0xFF, 0xE2, 0x00, 0x00,
  0x00, 0x00, 0x08, 0xFF, 0xFE, 0x30, 0x00, 0x00,
  0x00, 0x00, 0x7F, 0xFF, 0xF4, 0x00, 0x00, 0x00,
  0x00, 0x05, 0xFF, 0xFF, 0x50, 0x00, 0x00, 0x00,
  0x00, 0x4F, 0xFF, 0xF7, 0x00, 0x00, 0x00, 0x00,
  0x03, 0xEF, 0xFF, 0x92, 0x22, 0x22, 0x20, 0x00,
  0x1E, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00,
  0x2F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x30,
  0x0A, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_007B[125] = { // Code 007B, LEFT CURLY BRACKET
  0x00, 0x00, 0x26, 0x77, 0x60,
  0x00, 0x06, 0xFF, 0xFF, 0xF6,
  0x00, 0x1F, 0xFF, 0xFF, 0xE3,
  0x00, 0x3F, 0xFF, 0x90, 0x00,
  0x00, 0x4F, 0xFF, 0x40, 0x00,
  0x00, 0x4F, 0xFF, 0x40, 0x00,
  0x00, 0x4F, 0xFF, 0x40, 0x00,
  0x00, 0x4F, 0xFF, 0x40, 0x00,
  0x00, 0x4F, 0xFF, 0x40, 0x00,
  0x00, 0x4F, 0xFF, 0x40, 0x00,
  0x00, 0x5F, 0xFF, 0x40, 0x00,
  0x48, 0xEF, 0xFD, 0x00, 0x00,
  0xEF, 0xFE, 0x92, 0x00, 0x00,
  0xAF, 0xFF, 0xF7, 0x00, 0x00,
  0x01, 0x9F, 0xFF, 0x20, 0x00,
  0x00, 0x4F, 0xFF, 0x40, 0x00,
  0x00, 0x4F, 0xFF, 0x40, 0x00,
  0x00, 0x4F, 0xFF, 0x40, 0x00,
  0x00, 0x4F, 0xFF, 0x40, 0x00,
  0x00, 0x4F, 0xFF, 0x40, 0x00,
  0x00, 0x4F, 0xFF, 0x40, 0x00,
  0x00, 0x4F, 0xFF, 0x50, 0x00,
  0x00, 0x3F, 0xFF, 0xD7, 0x71,
  0x00, 0x0C, 0xFF, 0xFF, 0xF6,
  0x00, 0x02, 0xAE, 0xFF, 0xE3
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_007C[ 42] = { // Code 007C, VERTICAL LINE
  0x2C, 0xC2,
  0x9F, 0xF9,
  0x9F, 0xF9,
  0x9F, 0xF9,
  0x9F, 0xF9,
  0x9F, 0xF9,
  0x9F, 0xF9,
  0x9F, 0xF9,
  0x9F, 0xF9,
  0x9F, 0xF9,
  0x9F, 0xF9,
  0x9F, 0xF9,
  0x9F, 0xF9,
  0x9F, 0xF9,
  0x9F, 0xF9,
  0x9F, 0xF9,
  0x9F, 0xF9,
  0x9F, 0xF9,
  0x9F, 0xF9,
  0x7F, 0xF7,
  0x06, 0x60
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_007D[125] = { // Code 007D, RIGHT CURLY BRACKET
  0x37, 0x76, 0x40, 0x00, 0x00,
  0xEF, 0xFF, 0xFD, 0x10, 0x00,
  0xAF, 0xFF, 0xFF, 0x80, 0x00,
  0x00, 0x2E, 0xFF, 0xB0, 0x00,
  0x00, 0x0B, 0xFF, 0xB0, 0x00,
  0x00, 0x0B, 0xFF, 0xB0, 0x00,
  0x00, 0x0B, 0xFF, 0xB0, 0x00,
  0x00, 0x0B, 0xFF, 0xB0, 0x00,
  0x00, 0x0B, 0xFF, 0xB0, 0x00,
  0x00, 0x0B, 0xFF, 0xB0, 0x00,
  0x00, 0x0B, 0xFF, 0xD0, 0x00,
  0x00, 0x06, 0xFF, 0xFA, 0x70,
  0x00, 0x00, 0x6C, 0xFF, 0xF6,
  0x00, 0x02, 0xDF, 0xFF, 0xF3,
  0x00, 0x0A, 0xFF, 0xF3, 0x00,
  0x00, 0x0B, 0xFF, 0xC0, 0x00,
  0x00, 0x0B, 0xFF, 0xB0, 0x00,
  0x00, 0x0B, 0xFF, 0xB0, 0x00,
  0x00, 0x0B, 0xFF, 0xB0, 0x00,
  0x00, 0x0B, 0xFF, 0xB0, 0x00,
  0x00, 0x0B, 0xFF, 0xB0, 0x00,
  0x00, 0x0D, 0xFF, 0xB0, 0x00,
  0x37, 0x9F, 0xFF, 0xA0, 0x00,
  0xEF, 0xFF, 0xFF, 0x50, 0x00,
  0xAF, 0xFF, 0xC6, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded33_007E[ 48] = { // Code 007E, TILDE
  0x00, 0x02, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x04, 0xEF, 0xFE, 0x92, 0x00, 0x02, 0xDC, 0x00,
  0x4F, 0xFF, 0xFF, 0xFF, 0xB6, 0x7E, 0xFF, 0x10,
  0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0x00,
  0xDF, 0xE4, 0x26, 0xCF, 0xFF, 0xFF, 0xF4, 0x00,
  0x59, 0x10, 0x00, 0x03, 0x9D, 0xDA, 0x30, 0x00
};

GUI_CONST_STORAGE GUI_CHARINFO_EXT GUI_FontRounded33_CharInfo[95] = {
   {   1,   1,   0,  27,   8, acGUI_FontRounded33_0020 } // Code 0020, SPACE
  ,{   5,  21,   2,   7,   9, acGUI_FontRounded33_0021 } // Code 0021, EXCLAMATION MARK
  ,{  10,   9,   2,   7,  14, acGUI_FontRounded33_0022 } // Code 0022, QUOTATION MARK
  ,{  15,  21,   1,   7,  17, acGUI_FontRounded33_0023 } // Code 0023, NUMBER SIGN
  ,{  16,  24,   0,   6,  17, acGUI_FontRounded33_0024 } // Code 0024, DOLLAR SIGN
  ,{  23,  21,   2,   7,  27, acGUI_FontRounded33_0025 } // Code 0025, PERCENT SIGN
  ,{  18,  21,   1,   7,  19, acGUI_FontRounded33_0026 } // Code 0026, AMPERSAND
  ,{   4,   9,   2,   7,   9, acGUI_FontRounded33_0027 } // Code 0027, APOSTROPHE
  ,{   7,  26,   1,   7,   9, acGUI_FontRounded33_0028 } // Code 0028, LEFT PARENTHESIS
  ,{   7,  26,   1,   7,   9, acGUI_FontRounded33_0029 } // Code 0029, RIGHT PARENTHESIS
  ,{  11,  10,   1,   7,  13, acGUI_FontRounded33_002A } // Code 002A, ASTERISK
  ,{  16,  16,   0,  11,  16, acGUI_FontRounded33_002B } // Code 002B, PLUS SIGN
  ,{   6,   9,   1,  22,   8, acGUI_FontRounded33_002C } // Code 002C, COMMA
  ,{   9,   5,   1,  17,  11, acGUI_FontRounded33_002D } // Code 002D, HYPHEN-MINUS
  ,{   6,   6,   1,  22,   8, acGUI_FontRounded33_002E } // Code 002E, FULL STOP
  ,{  10,  21,   0,   7,  10, acGUI_FontRounded33_002F } // Code 002F, SOLIDUS
  ,{  15,  21,   1,   7,  17, acGUI_FontRounded33_0030 } // Code 0030, DIGIT ZERO
  ,{  10,  21,  -1,   7,  11, acGUI_FontRounded33_0031 } // Code 0031, DIGIT ONE
  ,{  16,  20,   0,   7,  16, acGUI_FontRounded33_0032 } // Code 0032, DIGIT TWO
  ,{  15,  21,   0,   7,  16, acGUI_FontRounded33_0033 } // Code 0033, DIGIT THREE
  ,{  16,  21,   0,   7,  16, acGUI_FontRounded33_0034 } // Code 0034, DIGIT FOUR
  ,{  15,  20,   0,   8,  16, acGUI_FontRounded33_0035 } // Code 0035, DIGIT FIVE
  ,{  15,  21,   1,   7,  17, acGUI_FontRounded33_0036 } // Code 0036, DIGIT SIX
  ,{  15,  20,   0,   8,  15, acGUI_FontRounded33_0037 } // Code 0037, DIGIT SEVEN
  ,{  15,  21,   1,   7,  17, acGUI_FontRounded33_0038 } // Code 0038, DIGIT EIGHT
  ,{  15,  21,   1,   7,  17, acGUI_FontRounded33_0039 } // Code 0039, DIGIT NINE
  ,{   6,  16,   1,  12,   8, acGUI_FontRounded33_003A } // Code 003A, COLON
  ,{   6,  19,   1,  12,   8, acGUI_FontRounded33_003B } // Code 003B, SEMICOLON
  ,{  16,  15,   0,  12,  16, acGUI_FontRounded33_003C } // Code 003C, LESS-THAN SIGN
  ,{  16,  11,   0,  14,  16, acGUI_FontRounded33_003D } // Code 003D, EQUALS SIGN
  ,{  16,  15,   0,  12,  16, acGUI_FontRounded33_003E } // Code 003E, GREATER-THAN SIGN
  ,{  14,  21,   1,   7,  15, acGUI_FontRounded33_003F } // Code 003F, QUESTION MARK
  ,{  21,  21,   0,   7,  22, acGUI_FontRounded33_0040 } // Code 0040, COMMERCIAL AT
  ,{  18,  21,   0,   7,  18, acGUI_FontRounded33_0041 } // Code 0041, LATIN CAPITAL LETTER A
  ,{  17,  20,   2,   7,  19, acGUI_FontRounded33_0042 } // Code 0042, LATIN CAPITAL LETTER B
  ,{  18,  21,   1,   7,  19, acGUI_FontRounded33_0043 } // Code 0043, LATIN CAPITAL LETTER C
  ,{  18,  20,   2,   7,  20, acGUI_FontRounded33_0044 } // Code 0044, LATIN CAPITAL LETTER D
  ,{  16,  20,   2,   7,  18, acGUI_FontRounded33_0045 } // Code 0045, LATIN CAPITAL LETTER E
  ,{  15,  21,   2,   7,  17, acGUI_FontRounded33_0046 } // Code 0046, LATIN CAPITAL LETTER F
  ,{  20,  21,   1,   7,  22, acGUI_FontRounded33_0047 } // Code 0047, LATIN CAPITAL LETTER G
  ,{  17,  21,   2,   7,  21, acGUI_FontRounded33_0048 } // Code 0048, LATIN CAPITAL LETTER H
  ,{   5,  21,   2,   7,   9, acGUI_FontRounded33_0049 } // Code 0049, LATIN CAPITAL LETTER I
  ,{  14,  21,   0,   7,  15, acGUI_FontRounded33_004A } // Code 004A, LATIN CAPITAL LETTER J
  ,{  17,  21,   2,   7,  18, acGUI_FontRounded33_004B } // Code 004B, LATIN CAPITAL LETTER K
  ,{  15,  20,   2,   7,  16, acGUI_FontRounded33_004C } // Code 004C, LATIN CAPITAL LETTER L
  ,{  20,  21,   2,   7,  24, acGUI_FontRounded33_004D } // Code 004D, LATIN CAPITAL LETTER M
  ,{  17,  21,   2,   7,  21, acGUI_FontRounded33_004E } // Code 004E, LATIN CAPITAL LETTER N
  ,{  20,  21,   1,   7,  22, acGUI_FontRounded33_004F } // Code 004F, LATIN CAPITAL LETTER O
  ,{  17,  21,   2,   7,  19, acGUI_FontRounded33_0050 } // Code 0050, LATIN CAPITAL LETTER P
  ,{  20,  22,   1,   7,  22, acGUI_FontRounded33_0051 } // Code 0051, LATIN CAPITAL LETTER Q
  ,{  17,  21,   2,   7,  20, acGUI_FontRounded33_0052 } // Code 0052, LATIN CAPITAL LETTER R
  ,{  17,  21,   1,   7,  18, acGUI_FontRounded33_0053 } // Code 0053, LATIN CAPITAL LETTER S
  ,{  18,  21,   0,   7,  18, acGUI_FontRounded33_0054 } // Code 0054, LATIN CAPITAL LETTER T
  ,{  17,  21,   2,   7,  21, acGUI_FontRounded33_0055 } // Code 0055, LATIN CAPITAL LETTER U
  ,{  18,  21,   0,   7,  17, acGUI_FontRounded33_0056 } // Code 0056, LATIN CAPITAL LETTER V
  ,{  25,  21,   0,   7,  25, acGUI_FontRounded33_0057 } // Code 0057, LATIN CAPITAL LETTER W
  ,{  16,  21,   0,   7,  16, acGUI_FontRounded33_0058 } // Code 0058, LATIN CAPITAL LETTER X
  ,{  17,  21,   0,   7,  17, acGUI_FontRounded33_0059 } // Code 0059, LATIN CAPITAL LETTER Y
  ,{  18,  20,   0,   7,  18, acGUI_FontRounded33_005A } // Code 005A, LATIN CAPITAL LETTER Z
  ,{   8,  25,   2,   7,  10, acGUI_FontRounded33_005B } // Code 005B, LEFT SQUARE BRACKET
  ,{  10,  21,   0,   7,  10, acGUI_FontRounded33_005C } // Code 005C, REVERSE SOLIDUS
  ,{   8,  25,   0,   7,  10, acGUI_FontRounded33_005D } // Code 005D, RIGHT SQUARE BRACKET
  ,{  14,  11,   1,   8,  16, acGUI_FontRounded33_005E } // Code 005E, CIRCUMFLEX ACCENT
  ,{  16,   2,  -1,  29,  13, acGUI_FontRounded33_005F } // Code 005F, LOW LINE
  ,{   6,   6,   0,   6,   8, acGUI_FontRounded33_0060 } // Code 0060, GRAVE ACCENT
  ,{  15,  16,   1,  12,  16, acGUI_FontRounded33_0061 } // Code 0061, LATIN SMALL LETTER A
  ,{  15,  21,   1,   7,  16, acGUI_FontRounded33_0062 } // Code 0062, LATIN SMALL LETTER B
  ,{  14,  16,   0,  12,  14, acGUI_FontRounded33_0063 } // Code 0063, LATIN SMALL LETTER C
  ,{  14,  21,   1,   7,  16, acGUI_FontRounded33_0064 } // Code 0064, LATIN SMALL LETTER D
  ,{  15,  16,   1,  12,  17, acGUI_FontRounded33_0065 } // Code 0065, LATIN SMALL LETTER E
  ,{  10,  21,   0,   7,  10, acGUI_FontRounded33_0066 } // Code 0066, LATIN SMALL LETTER F
  ,{  14,  21,   1,  12,  16, acGUI_FontRounded33_0067 } // Code 0067, LATIN SMALL LETTER G
  ,{  14,  21,   1,   7,  16, acGUI_FontRounded33_0068 } // Code 0068, LATIN SMALL LETTER H
  ,{   5,  21,   1,   7,   8, acGUI_FontRounded33_0069 } // Code 0069, LATIN SMALL LETTER I
  ,{   7,  26,  -1,   7,   8, acGUI_FontRounded33_006A } // Code 006A, LATIN SMALL LETTER J
  ,{  14,  21,   1,   7,  14, acGUI_FontRounded33_006B } // Code 006B, LATIN SMALL LETTER K
  ,{   5,  21,   1,   7,   8, acGUI_FontRounded33_006C } // Code 006C, LATIN SMALL LETTER L
  ,{  23,  16,   1,  12,  25, acGUI_FontRounded33_006D } // Code 006D, LATIN SMALL LETTER M
  ,{  14,  16,   1,  12,  16, acGUI_FontRounded33_006E } // Code 006E, LATIN SMALL LETTER N
  ,{  15,  16,   1,  12,  17, acGUI_FontRounded33_006F } // Code 006F, LATIN SMALL LETTER O
  ,{  15,  21,   1,  12,  16, acGUI_FontRounded33_0070 } // Code 0070, LATIN SMALL LETTER P
  ,{  14,  21,   1,  12,  16, acGUI_FontRounded33_0071 } // Code 0071, LATIN SMALL LETTER Q
  ,{  10,  16,   1,  12,  11, acGUI_FontRounded33_0072 } // Code 0072, LATIN SMALL LETTER R
  ,{  14,  16,   0,  12,  14, acGUI_FontRounded33_0073 } // Code 0073, LATIN SMALL LETTER S
  ,{  10,  20,   0,   8,  10, acGUI_FontRounded33_0074 } // Code 0074, LATIN SMALL LETTER T
  ,{  14,  16,   1,  12,  16, acGUI_FontRounded33_0075 } // Code 0075, LATIN SMALL LETTER U
  ,{  14,  16,   0,  12,  13, acGUI_FontRounded33_0076 } // Code 0076, LATIN SMALL LETTER V
  ,{  21,  16,   0,  12,  21, acGUI_FontRounded33_0077 } // Code 0077, LATIN SMALL LETTER W
  ,{  13,  16,   0,  12,  13, acGUI_FontRounded33_0078 } // Code 0078, LATIN SMALL LETTER X
  ,{  14,  21,   0,  12,  13, acGUI_FontRounded33_0079 } // Code 0079, LATIN SMALL LETTER Y
  ,{  15,  15,   0,  12,  15, acGUI_FontRounded33_007A } // Code 007A, LATIN SMALL LETTER Z
  ,{  10,  25,   0,   7,  10, acGUI_FontRounded33_007B } // Code 007B, LEFT CURLY BRACKET
  ,{   4,  21,   1,   7,   6, acGUI_FontRounded33_007C } // Code 007C, VERTICAL LINE
  ,{  10,  25,   0,   7,  10, acGUI_FontRounded33_007D } // Code 007D, RIGHT CURLY BRACKET
  ,{  15,   6,   1,  16,  16, acGUI_FontRounded33_007E } // Code 007E, TILDE
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_FontRounded33_Prop1 = {
   0x0020                                   // First character
  ,0x007E                                   // Last character 
  ,&GUI_FontRounded33_CharInfo[  0]         // Address of first character
  ,(GUI_CONST_STORAGE GUI_FONT_PROP_EXT *)0 // Pointer to next GUI_FONT_PROP_EXT
};

GUI_CONST_STORAGE GUI_FONT GUI_FontRounded33 = {
   GUI_FONTTYPE_PROP_AA4_EXT // type of font   
  ,33 // height of font 
  ,33 // space of font y
  ,1  // magnification x
  ,1  // magnification y
  ,{&GUI_FontRounded33_Prop1}
  ,33 // Baseline
  ,16 // Height of lowercase characters
  ,21 // Height of capital characters
};

/*********************************************************************
*
*       _SeggerLogo50x25
*/
static GUI_CONST_STORAGE GUI_COLOR ColorsSeggerLogo50x25[] = {
     0x00FF00,0xFFFFFF,0x908F91,0x201F23
    ,0xA02020,0xB85858,0x58575A,0xF9F1F1
    ,0xE7C7C7,0x2E2D31,0x747376,0xA62E2E
    ,0xEDD5D5,0xB24A4A,0x9D9D9F,0xB9B9BA
    ,0xC7C7C8,0xD5D5D6,0x3C3B3F,0xBE6666
    ,0xCA8282,0xE1B9B9,0xE3E3E4,0xF1F1F1
    ,0xAC3C3C,0x828183,0xABABAD,0xDBABAB
    ,0x4A494C,0xD59D9D,0xF3E3E3,0x666568
    ,0xC47474,0xD09090
};

static GUI_CONST_STORAGE GUI_LOGPALETTE PalSeggerLogo50x25 = {
  34,	// number of entries
  1, 	// Has transparency
  &ColorsSeggerLogo50x25[0]
};

static GUI_CONST_STORAGE unsigned char acSeggerLogo50x25[] = {
  0x00, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x00,
  0x03, 0x09, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x09, 0x03,
  0x03, 0x02, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x03,
  0x03, 0x02, 0x07, 0x21, 0x07, 0x01, 0x01, 0x15, 0x15, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x03,
  0x03, 0x02, 0x08, 0x04, 0x0D, 0x01, 0x01, 0x0D, 0x04, 0x08, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x03,
  0x03, 0x02, 0x01, 0x13, 0x04, 0x14, 0x01, 0x08, 0x04, 0x0B, 0x07, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x03,
  0x03, 0x02, 0x01, 0x07, 0x18, 0x04, 0x15, 0x01, 0x1D, 0x04, 0x0D, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x03,
  0x03, 0x02, 0x01, 0x01, 0x0C, 0x04, 0x0B, 0x1E, 0x01, 0x13, 0x04, 0x14, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x03,
  0x03, 0x02, 0x0C, 0x0C, 0x01, 0x1D, 0x04, 0x0D, 0x01, 0x07, 0x18, 0x04, 0x1B, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x03,
  0x03, 0x02, 0x08, 0x0D, 0x07, 0x01, 0x13, 0x04, 0x14, 0x01, 0x0C, 0x0B, 0x0B, 0x0C, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x03,
  0x03, 0x02, 0x08, 0x04, 0x20, 0x01, 0x07, 0x18, 0x04, 0x15, 0x01, 0x1B, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x05, 0x01, 0x02, 0x03,
  0x03, 0x02, 0x08, 0x04, 0x04, 0x1B, 0x01, 0x0C, 0x0B, 0x0B, 0x1E, 0x01, 0x14, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x13, 0x01, 0x02, 0x03,
  0x03, 0x02, 0x08, 0x04, 0x04, 0x18, 0x01, 0x01, 0x20, 0x04, 0x21, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x03,
  0x03, 0x02, 0x08, 0x04, 0x04, 0x1B, 0x01, 0x0C, 0x0B, 0x0B, 0x1E, 0x01, 0x14, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 
        0x05, 0x05, 0x05, 0x05, 0x13, 0x01, 0x02, 0x03,
  0x03, 0x02, 0x08, 0x04, 0x20, 0x01, 0x07, 0x18, 0x04, 0x15, 0x01, 0x1B, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 
        0x04, 0x04, 0x04, 0x04, 0x05, 0x01, 0x02, 0x03,
  0x03, 0x02, 0x08, 0x0D, 0x07, 0x01, 0x13, 0x04, 0x14, 0x01, 0x0C, 0x0B, 0x0B, 0x0C, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x03,
  0x03, 0x02, 0x0C, 0x0C, 0x01, 0x1D, 0x04, 0x0D, 0x01, 0x07, 0x18, 0x04, 0x1B, 0x01, 0x1A, 0x02, 0x02, 0x16, 0x01, 0x0E, 0x02, 0x02, 0x0E, 0x17, 0x17, 0x1A, 0x02, 0x0E, 0x16, 0x01, 0x01, 0x1A, 0x02, 0x02, 0x16, 0x01, 0x10, 0x02, 0x02, 0x02, 0x10, 0x11, 
        0x02, 0x02, 0x02, 0x11, 0x01, 0x01, 0x02, 0x03,
  0x03, 0x02, 0x01, 0x01, 0x0C, 0x04, 0x0B, 0x1E, 0x01, 0x13, 0x04, 0x14, 0x01, 0x0E, 0x03, 0x19, 0x12, 0x1C, 0x10, 0x03, 0x1C, 0x06, 0x06, 0x16, 0x1C, 0x09, 0x19, 0x12, 0x09, 0x01, 0x19, 0x03, 0x0A, 0x12, 0x03, 0x16, 0x06, 0x09, 0x06, 0x06, 0x0E, 0x02, 
        0x03, 0x06, 0x1C, 0x03, 0x11, 0x01, 0x02, 0x03,
  0x03, 0x02, 0x01, 0x07, 0x18, 0x04, 0x15, 0x01, 0x1D, 0x04, 0x0D, 0x01, 0x01, 0x0E, 0x03, 0x0A, 0x0E, 0x0F, 0x10, 0x03, 0x0A, 0x02, 0x02, 0x11, 0x03, 0x1A, 0x17, 0x0F, 0x02, 0x01, 0x03, 0x19, 0x01, 0x0F, 0x02, 0x17, 0x06, 0x12, 0x02, 0x02, 0x10, 0x02, 
        0x03, 0x10, 0x02, 0x03, 0x11, 0x01, 0x02, 0x03,
  0x03, 0x02, 0x01, 0x13, 0x04, 0x14, 0x01, 0x08, 0x04, 0x0B, 0x07, 0x01, 0x01, 0x17, 0x0E, 0x0A, 0x09, 0x09, 0x1A, 0x03, 0x0A, 0x02, 0x02, 0x10, 0x03, 0x0F, 0x0F, 0x06, 0x03, 0x10, 0x03, 0x02, 0x11, 0x06, 0x03, 0x02, 0x06, 0x12, 0x02, 0x02, 0x11, 0x02, 
        0x03, 0x06, 0x12, 0x09, 0x17, 0x01, 0x02, 0x03,
  0x03, 0x02, 0x08, 0x04, 0x0D, 0x01, 0x01, 0x0D, 0x04, 0x08, 0x01, 0x01, 0x01, 0x02, 0x09, 0x1A, 0x0A, 0x03, 0x0E, 0x03, 0x0A, 0x02, 0x02, 0x11, 0x12, 0x12, 0x02, 0x1F, 0x03, 0x10, 0x06, 0x09, 0x02, 0x0A, 0x03, 0x02, 0x06, 0x12, 0x02, 0x02, 0x1A, 0x02, 
        0x03, 0x01, 0x0F, 0x03, 0x10, 0x01, 0x02, 0x03,
  0x03, 0x02, 0x07, 0x21, 0x07, 0x01, 0x01, 0x15, 0x15, 0x01, 0x01, 0x01, 0x01, 0x17, 0x19, 0x06, 0x06, 0x0F, 0x01, 0x02, 0x02, 0x02, 0x02, 0x11, 0x16, 0x0A, 0x06, 0x0A, 0x0A, 0x11, 0x17, 0x19, 0x06, 0x1F, 0x0A, 0x0F, 0x0F, 0x02, 0x02, 0x02, 0x0E, 0x0F, 
        0x19, 0x01, 0x16, 0x1F, 0x16, 0x01, 0x02, 0x03,
  0x03, 0x02, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x03,
  0x03, 0x09, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x09, 0x03,
  0x00, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x00
};

extern GUI_CONST_STORAGE GUI_BITMAP bmSeggerLogo50x25;

GUI_CONST_STORAGE GUI_BITMAP bmSeggerLogo50x25 = {
  50,                   // XSize
  25,                   // YSize
  50,                   // BytesPerLine
  8,                    // BitsPerPixel
  acSeggerLogo50x25,    // Pointer to picture data (indices)
  &PalSeggerLogo50x25   // Pointer to palette
};

/*********************************************************************
*
*       Needle with 32bpp and transparency
*/
static GUI_CONST_STORAGE unsigned long _acNeedle[] = {
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x37277FFF, 0x22277FFF, 0x23277FFF, 0x23277FFF, 0x19277FFF, 0x19277FFF, 0x19277FFF, 0x19277FFF, 0x23277FFF, 0x23277FFF, 0x23277FFF, 
        0x23277FFF, 0x23277FFF, 0x23277FFF, 0x21277FFF, 0x2D277FFF, 0x47277FFF, 0x49277FFF, 0x48277FFF, 0x48277FFF, 0x5B277FFF, 0x5B277FFF, 0x5B277FFF, 0x5B277FFF, 0x5B277FFF, 0x5B277FFF, 0x5B277FFF, 0x5B277FFF, 0x48277FFF, 0x48277FFF, 0x48277FFF, 
        0x48277FFF, 0x5B277FFF, 0x5B277FFF, 0x5B277FFF, 0x5B277FFF, 0x5B277FFF, 0x5B277FFF, 0x5B277FFF, 0x5B277FFF, 0x5B277FFF, 0x5B277FFF, 0x5B277FFF, 0x5B277FFF, 0x5B277FFF, 0x5B277FFF, 0x5A277FFF, 0x82277FFF, 0x93277FFF, 0x93277FFF, 0x93277FFF, 
        0x93277FFF, 0x93277FFF, 0x93277FFF, 0x93277FFF, 0x93277FFF, 0x93277FFF, 0x93277FFF, 0x93277FFF, 0x93277FFF, 0x93277FFF, 0x92277FFF, 0x9B277FFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x0E277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 
        0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 
        0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 
        0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0x00277FFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x31277FFF, 0x1C277FFF, 0x1C277FFF, 0x1C277FFF, 0x1C277FFF, 0x1C277FFF, 0x1C277FFF, 0x1C277FFF, 0x1C277FFF, 0x1C277FFF, 0x1C277FFF, 
        0x1C277FFF, 0x1C277FFF, 0x1C277FFF, 0x1C277FFF, 0x23277FFF, 0x41277FFF, 0x42277FFF, 0x42277FFF, 0x42277FFF, 0x42277FFF, 0x42277FFF, 0x42277FFF, 0x42277FFF, 0x42277FFF, 0x42277FFF, 0x42277FFF, 0x42277FFF, 0x42277FFF, 0x42277FFF, 0x42277FFF, 
        0x42277FFF, 0x42277FFF, 0x42277FFF, 0x42277FFF, 0x42277FFF, 0x42277FFF, 0x42277FFF, 0x42277FFF, 0x42277FFF, 0x42277FFF, 0x42277FFF, 0x42277FFF, 0x42277FFF, 0x42277FFF, 0x42277FFF, 0x42277FFF, 0x5B277FFF, 0x67277FFF, 0x66277FFF, 0x66277FFF, 
        0x66277FFF, 0x66277FFF, 0x66277FFF, 0x66277FFF, 0x66277FFF, 0x66277FFF, 0x66277FFF, 0x66277FFF, 0x66277FFF, 0x66277FFF, 0x66277FFF, 0x73277FFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF
};

static GUI_CONST_STORAGE GUI_BITMAP _bmNeedle = {
  75, // xSize
  9, // ySize
  300, // BytesPerLine
  32, // BitsPerPixel
  (unsigned char *)_acNeedle,  // Pointer to picture data
  NULL,  // Pointer to palette
  GUI_DRAW_BMP8888
};

/*********************************************************************
*
*       Speedometer with 32bpp and transparency
*/
static GUI_CONST_STORAGE unsigned long _acSpeedometerScale_BMP[] = {
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xDECCCCCC, 0xABCCCCCC, 0x9ACCCCCC, 0x78CCCCCC, 0x56CCCCCC, 0x34CCCCCC, 0x23CCCCCC, 0x00CCCCCC, 
        0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x01CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x23CCCCCC, 
        0x23CCCCCC, 0x56CCCCCC, 0x67CCCCCC, 0x89CCCCCC, 0xABCCCCCC, 0xCDCCCCCC, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xEFCCCCCC, 0xBCCCCCCC, 0x89CCCCCC, 0x56CCCCCC, 0x34CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 
        0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x01CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 
        0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x23CCCCCC, 0x56CCCCCC, 0x89CCCCCC, 0xBCCCCCCC, 0xEFCCCCCC, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xDECBCBCB, 0x9ACBCBCB, 0x67CBCBCB, 0x23CBCBCB, 0x00CBCBCB, 0x00CBCBCB, 0x00CBCBCB, 0x00CBCBCB, 0x00CBCBCB, 0x00CBCBCB, 0x00CBCBCB, 0x00CBCBCB, 0x00CBCBCB, 0x00CBCBCB, 0x00CBCBCB, 0x00CBCBCB, 0x00CBCBCB, 0x00CBCBCB, 
        0x00CBCBCB, 0x00CBCBCB, 0x00CBCBCB, 0x00CBCBCB, 0x00CBCBCB, 0x00CBCBCB, 0x00CBCBCB, 0x00CBCBCB, 0x00CBCBCB, 0x01CBCBCB, 0x00CBCBCB, 0x00CBCBCB, 0x00CBCBCB, 0x00CBCBCB, 0x00CBCBCB, 0x00CBCBCB, 0x00CBCBCB, 0x00CBCBCB, 0x00CBCBCB, 0x00CBCBCB, 
        0x00CBCBCB, 0x00CBCBCB, 0x00CBCBCB, 0x00CBCBCB, 0x00CBCBCB, 0x00CBCBCB, 0x00CBCBCB, 0x00CBCBCB, 0x00CBCBCB, 0x00CBCBCB, 0x00CBCBCB, 0x00CBCBCB, 0x23CBCBCB, 0x56CBCBCB, 0x9ACBCBCB, 0xCDCBCBCB, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xEFCACACA, 0xABCACACA, 
        0x67CACACA, 0x23CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 
        0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00C8C8C8, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 
        0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x12CACACA, 0x56CACACA, 0x9ACACACA, 0xEFCACACA, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xDECACACA, 0x89CACACA, 0x45CACACA, 0x00CACACA, 0x00CACACA, 
        0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 
        0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00C8C8C8, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 
        0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 
        0x34CACACA, 0x78CACACA, 0xCDCACACA, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xDEC9C9C9, 0x89C9C9C9, 0x34C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 
        0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 
        0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C7C7C7, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 
        0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 
        0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x23C9C9C9, 0x78C9C9C9, 0xCDC9C9C9, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xEFC8C8C8, 0x9AC8C8C8, 0x34C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 
        0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 
        0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 
        0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 
        0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x23C8C8C8, 0x89C8C8C8, 0xEFC8C8C8, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xCCC7C7C7, 0x55C7C7C7, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 
        0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00BDBDBD, 0x00B2B2B2, 0x00ABABAB, 0x009C9C9C, 0x00909090, 0x00848484, 0x00636363, 0x00333333, 
        0x00333333, 0x00333333, 0x00333333, 0x00333333, 0x00333333, 0x00333333, 0x00333333, 0x00333333, 0x00333333, 0x00333333, 0x00333333, 0x00333333, 0x00333333, 0x00333333, 0x00333333, 0x00333333, 0x00333333, 0x00333333, 0x00333333, 0x00636363, 
        0x00767676, 0x00909090, 0x009C9C9C, 0x00A8A8A8, 0x00B2B2B2, 0x00BDBDBD, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 
        0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x55C7C7C7, 0xAAC7C7C7, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x99C6C6C6, 0x33C6C6C6, 0x00C7C7C7, 0x00C7C7C7, 0x00C7C7C7, 0x00C7C7C7, 0x00C7C7C7, 0x00C7C7C7, 0x00C7C7C7, 0x00C7C7C7, 0x00C7C7C7, 0x00C7C7C7, 0x00C7C7C7, 0x00C7C7C7, 0x00C7C7C7, 
        0x00C7C7C7, 0x00C7C7C7, 0x00C7C7C7, 0x00C7C7C7, 0x00C7C7C7, 0x00C7C7C7, 0x00C7C7C7, 0x00B6B6B6, 0x00AAAAAA, 0x009E9E9E, 0x008F8F8F, 0x00646464, 0x00333333, 0x00333333, 0x00333333, 0x00333333, 0x00333333, 0x00333333, 0x00333333, 0x00333333, 
        0x00333333, 0x00333333, 0x00333333, 0x00333333, 0x00333333, 0x00333333, 0x00333333, 0x00333333, 0x00333333, 0x00333333, 0x00333333, 0x00333333, 0x00333333, 0x00333333, 0x00333333, 0x00333333, 0x00333333, 0x00333333, 0x00333333, 0x00333333, 
        0x00333333, 0x00333333, 0x00333333, 0x00333333, 0x00333333, 0x00333333, 0x004E4E4E, 0x00848484, 0x009E9E9E, 0x00AAAAAA, 0x00B6B6B6, 0x00C7C7C7, 0x00C7C7C7, 0x00C7C7C7, 0x00C7C7C7, 0x00C7C7C7, 0x00C7C7C7, 0x00C7C7C7, 0x00C7C7C7, 0x00C7C7C7, 
        0x00C7C7C7, 0x00C7C7C7, 0x00C7C7C7, 0x00C7C7C7, 0x00C7C7C7, 0x00C7C7C7, 0x00C7C7C7, 0x00C7C7C7, 0x00C7C7C7, 0x00C7C7C7, 0x00C7C7C7, 0x22C6C6C6, 0x88C6C6C6, 0xEEC6C6C6, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xEEC5C5C5, 0x77C5C5C5, 0x11C5C5C5, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 
        0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00AFAFAF, 0x00A6A6A6, 0x008F8F8F, 0x00646464, 0x00343434, 0x00343434, 0x00343434, 0x00343434, 0x00343434, 0x00343434, 0x00343434, 0x00343434, 0x00343434, 0x00343434, 0x00343434, 0x00343434, 0x00343434, 
        0x00343434, 0x003C3C3C, 0x003C3C3C, 0x00434343, 0x00454545, 0x00454545, 0x00444444, 0x00444444, 0x00444444, 0x00424242, 0x00434343, 0x00424242, 0x00424242, 0x00424242, 0x003F3F3F, 0x00393939, 0x00393939, 0x00343434, 0x00343434, 0x00343434, 
        0x00343434, 0x00343434, 0x00343434, 0x00343434, 0x00343434, 0x00343434, 0x00343434, 0x00343434, 0x00343434, 0x00343434, 0x00343434, 0x004F4F4F, 0x00848484, 0x00A2A2A2, 0x00B0B0B0, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 
        0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x11C5C5C5, 0x66C5C5C5, 0xDDC5C5C5, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xDDC5C5C5, 0x66C5C5C5, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00BCBCBC, 
        0x00AAAAAA, 0x00989898, 0x004F4F4F, 0x00353535, 0x00353535, 0x00353535, 0x00353535, 0x00353535, 0x00353535, 0x00353535, 0x00353535, 0x00353535, 0x00353535, 0x003F3F3F, 0x004A4A4A, 0x004F4F4F, 0x00525252, 0x00565656, 0x00585858, 0x005F5F5F, 
        0x005F5F5F, 0x005D5D5D, 0x005D5D5D, 0x005C5C5C, 0x005A5A5A, 0x00585858, 0x00585858, 0x00585858, 0x00575757, 0x00575757, 0x00565656, 0x00545454, 0x00535353, 0x00535353, 0x00505050, 0x00505050, 0x004F4F4F, 0x004E4E4E, 0x004D4D4D, 0x00484848, 
        0x00474747, 0x00454545, 0x00414141, 0x003F3F3F, 0x003A3A3A, 0x00353535, 0x00353535, 0x00353535, 0x00353535, 0x00353535, 0x00353535, 0x00353535, 0x00353535, 0x00353535, 0x00353535, 0x004F4F4F, 0x008F8F8F, 0x00A7A7A7, 0x00BCBCBC, 0x00C6C6C6, 
        0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x55C5C5C5, 0xCCC5C5C5, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xDDC4C4C4, 0x66C4C4C4, 
        0x00C5C5C5, 0x00C5C5C5, 0x00C5C5C5, 0x00C5C5C5, 0x00C5C5C5, 0x00C5C5C5, 0x00C5C5C5, 0x00C5C5C5, 0x00C5C5C5, 0x00C5C5C5, 0x00C5C5C5, 0x00C5C5C5, 0x00C5C5C5, 0x00C5C5C5, 0x00C5C5C5, 0x00C5C5C5, 0x00BBBBBB, 0x00A6A6A6, 0x00848484, 0x00353535, 
        0x00353535, 0x00353535, 0x00353535, 0x00353535, 0x00353535, 0x00353535, 0x00353535, 0x003A3A3A, 0x004A4A4A, 0x00525252, 0x00595959, 0x005D5D5D, 0x00646464, 0x00646464, 0x00636363, 0x00636363, 0x00616161, 0x00606060, 0x005F5F5F, 0x005F5F5F, 
        0x005F5F5F, 0x0050506B, 0x00494971, 0x00424278, 0x003B3B7F, 0x003A3A7E, 0x003A3A7E, 0x0039397D, 0x0039397D, 0x00343480, 0x0038387C, 0x0038387C, 0x0037377A, 0x0037377A, 0x003B3B71, 0x003F3F68, 0x003F3F68, 0x004E4E4E, 0x004D4D4D, 0x004D4D4D, 
        0x004D4D4D, 0x004D4D4D, 0x004B4B4B, 0x004B4B4B, 0x00494949, 0x00484848, 0x00454545, 0x00414141, 0x003D3D3D, 0x003A3A3A, 0x00353535, 0x00353535, 0x00353535, 0x00353535, 0x00353535, 0x00353535, 0x00353535, 0x00353535, 0x00353535, 0x00767676, 
        0x00A2A2A2, 0x00B4B4B4, 0x00C5C5C5, 0x00C5C5C5, 0x00C5C5C5, 0x00C5C5C5, 0x00C5C5C5, 0x00C5C5C5, 0x00C5C5C5, 0x00C5C5C5, 0x00C5C5C5, 0x00C5C5C5, 0x00C5C5C5, 0x00C5C5C5, 0x00C5C5C5, 0x00C5C5C5, 0x00C5C5C5, 0x00C5C5C5, 0x55C4C4C4, 0xCCC4C4C4, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xEEC3C3C3, 0x77C3C3C3, 0x00C4C4C4, 0x00C4C4C4, 
        0x00C4C4C4, 0x00C4C4C4, 0x00C4C4C4, 0x00C4C4C4, 0x00C4C4C4, 0x00C4C4C4, 0x00C4C4C4, 0x00C4C4C4, 0x00C4C4C4, 0x00C4C4C4, 0x00C4C4C4, 0x00C4C4C4, 0x00C4C4C4, 0x00BABABA, 0x00A5A5A5, 0x00848484, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 
        0x00363636, 0x00363636, 0x00363636, 0x003C3C3C, 0x004E4E4E, 0x005A5A5A, 0x00606060, 0x006A6A6A, 0x006A6A6A, 0x00696969, 0x00676767, 0x00666666, 0x00646464, 0x00565671, 0x00414185, 0x00333392, 0x002626A0, 0x001F1FA7, 0x000C0CBC, 0x000606C3, 
        0x000000CC, 0x000C0CBC, 0x000C0CBC, 0x001818AD, 0x001D1DA5, 0x001D1DA4, 0x001D1DA4, 0x001C1CA4, 0x001C1CA4, 0x001818A8, 0x001C1CA3, 0x001C1CA3, 0x001B1BA3, 0x001B1BA3, 0x001515AA, 0x000A0ABA, 0x000A0ABA, 0x000000CC, 0x000000CC, 0x000A0ABA, 
        0x001414A9, 0x001E1E98, 0x00282887, 0x00313175, 0x003A3A63, 0x00484848, 0x00464646, 0x00454545, 0x00444444, 0x00444444, 0x00434343, 0x003F3F3F, 0x003D3D3D, 0x003A3A3A, 0x00373737, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 
        0x00363636, 0x00363636, 0x00767676, 0x00A1A1A1, 0x00B3B3B3, 0x00C4C4C4, 0x00C4C4C4, 0x00C4C4C4, 0x00C4C4C4, 0x00C4C4C4, 0x00C4C4C4, 0x00C4C4C4, 0x00C4C4C4, 0x00C4C4C4, 0x00C4C4C4, 0x00C4C4C4, 0x00C4C4C4, 0x00C4C4C4, 0x00C4C4C4, 0x00C4C4C4, 
        0x55C3C3C3, 0xDDC3C3C3, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x88C2C2C2, 0x11C2C2C2, 0x00C3C3C3, 0x00C3C3C3, 0x00C3C3C3, 
        0x00C3C3C3, 0x00C3C3C3, 0x00C3C3C3, 0x00C3C3C3, 0x00C3C3C3, 0x00C3C3C3, 0x00C3C3C3, 0x00C3C3C3, 0x00C3C3C3, 0x00C3C3C3, 0x00C3C3C3, 0x00A8A8A8, 0x008E8E8E, 0x00373737, 0x00373737, 0x00373737, 0x00373737, 0x00373737, 0x00373737, 0x00373737, 
        0x00484848, 0x00585858, 0x00636363, 0x006D6D6D, 0x006C6C6C, 0x006B6B6B, 0x006A6A6A, 0x006A6A6A, 0x0053537C, 0x003D3D8E, 0x002929A2, 0x001414B6, 0x000000CC, 0x000D0DBD, 0x002020A8, 0x002D2D99, 0x0039398B, 0x003F3F83, 0x004C4C75, 0x00585865, 
        0x005D5D5D, 0x005D5D5D, 0x005C5C5C, 0x005B5B5B, 0x005B5B5B, 0x00585858, 0x00585858, 0x00575757, 0x00575757, 0x00565656, 0x00555555, 0x00555555, 0x00535353, 0x00535353, 0x00535353, 0x00515151, 0x00505050, 0x004E4E4E, 0x004D4D4D, 0x003D3D66, 
        0x0038386E, 0x002E2E7F, 0x0023238F, 0x001818A0, 0x000909B9, 0x000000CC, 0x000909B9, 0x0017179E, 0x00242482, 0x00313167, 0x00444444, 0x00424242, 0x00424242, 0x00414141, 0x00404040, 0x003D3D3D, 0x003A3A3A, 0x00383838, 0x00373737, 0x00373737, 
        0x00373737, 0x00373737, 0x00373737, 0x00373737, 0x00373737, 0x00838383, 0x00A8A8A8, 0x00C3C3C3, 0x00C3C3C3, 0x00C3C3C3, 0x00C3C3C3, 0x00C3C3C3, 0x00C3C3C3, 0x00C3C3C3, 0x00C3C3C3, 0x00C3C3C3, 0x00C3C3C3, 0x00C3C3C3, 0x00C3C3C3, 0x00C3C3C3, 
        0x00C3C3C3, 0x00C3C3C3, 0x77C2C2C2, 0xEEC2C2C2, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xAAC2C2C2, 0x22C2C2C2, 0x00C3C3C3, 0x00C3C3C3, 0x00C3C3C3, 0x00C3C3C3, 0x00C3C3C3, 
        0x00C3C3C3, 0x00C3C3C3, 0x00C3C3C3, 0x00C3C3C3, 0x00C3C3C3, 0x00C3C3C3, 0x00C3C3C3, 0x00C3C3C3, 0x00B9B9B9, 0x00A1A1A1, 0x00666666, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x004F4F4F, 0x005F5F5F, 0x006B6B6B, 
        0x006F6F6F, 0x006F6F6F, 0x006E6E6E, 0x006D6D6D, 0x004E4E85, 0x0031319E, 0x001C1CB1, 0x000000CC, 0x001414B7, 0x002929A2, 0x003D3D8E, 0x0052527A, 0x00646464, 0x00636363, 0x00626262, 0x00616161, 0x00616161, 0x00606060, 0x00606060, 0x005F5F5F, 
        0x005D5D5D, 0x005D5D5D, 0x005C5C5C, 0x005B5B5B, 0x005A5A5A, 0x00585858, 0x00585858, 0x00585858, 0x00565656, 0x00565656, 0x00545454, 0x00545454, 0x00535353, 0x00535353, 0x00525252, 0x00505050, 0x004F4F4F, 0x004E4E4E, 0x004D4D4D, 0x004D4D4D, 
        0x004D4D4D, 0x004B4B4B, 0x004B4B4B, 0x00494949, 0x00494949, 0x00484848, 0x00373760, 0x0029297B, 0x001B1B95, 0x000D0DB0, 0x000000CC, 0x000D0DAF, 0x001E1E8B, 0x002F2F65, 0x003B3B49, 0x003F3F3F, 0x003E3E3E, 0x003E3E3E, 0x00393939, 0x00383838, 
        0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00515151, 0x009C9C9C, 0x00B3B3B3, 0x00C3C3C3, 0x00C3C3C3, 0x00C3C3C3, 0x00C3C3C3, 0x00C3C3C3, 0x00C3C3C3, 0x00C3C3C3, 0x00C3C3C3, 0x00C3C3C3, 0x00C3C3C3, 
        0x00C3C3C3, 0x00C3C3C3, 0x00C3C3C3, 0x11C2C2C2, 0x99C2C2C2, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xDDC1C1C1, 0x44C1C1C1, 0x00C2C2C2, 0x00C2C2C2, 0x00C2C2C2, 0x00C2C2C2, 0x00C2C2C2, 0x00C2C2C2, 0x00C2C2C2, 
        0x00C2C2C2, 0x00C2C2C2, 0x00C2C2C2, 0x00C2C2C2, 0x00C2C2C2, 0x00C2C2C2, 0x00ACACAC, 0x008E8E8E, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x004A4A4A, 0x00606060, 0x006C6C6C, 0x00727272, 0x00707070, 0x00707070, 
        0x005F5F7A, 0x00424293, 0x001C1CB1, 0x000000CC, 0x001515B7, 0x0031319D, 0x004D4D83, 0x0061616F, 0x00676767, 0x00676767, 0x00676767, 0x00656565, 0x00646464, 0x00626262, 0x00616161, 0x00616161, 0x00616161, 0x00606060, 0x005F5F5F, 0x005F5F5F, 
        0x005D5D5D, 0x005B5B5B, 0x005B5B5B, 0x005A5A5A, 0x005A5A5A, 0x00585858, 0x00575757, 0x00575757, 0x00565656, 0x00555555, 0x00555555, 0x00545454, 0x00535353, 0x00525252, 0x00505050, 0x00505050, 0x004F4F4F, 0x004F4F4F, 0x004D4D4D, 0x004D4D4D, 
        0x004C4C4C, 0x004B4B4B, 0x004B4B4B, 0x004A4A4A, 0x00494949, 0x00484848, 0x00464646, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00303067, 0x00222281, 0x001111A6, 0x000000CC, 0x001010A5, 0x0020207F, 0x00303059, 0x003C3C3C, 0x003B3B3B, 
        0x003A3A3A, 0x00373737, 0x00383838, 0x00363636, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x008E8E8E, 0x00AAAAAA, 0x00C2C2C2, 0x00C2C2C2, 0x00C2C2C2, 0x00C2C2C2, 0x00C2C2C2, 0x00C2C2C2, 0x00C2C2C2, 0x00C2C2C2, 
        0x00C2C2C2, 0x00C2C2C2, 0x00C2C2C2, 0x00C2C2C2, 0x00C2C2C2, 0x33C1C1C1, 0xCCC1C1C1, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x77C0C0C0, 0x00C1C1C1, 0x00C1C1C1, 0x00C1C1C1, 0x00C1C1C1, 0x00C1C1C1, 0x00C1C1C1, 0x00C1C1C1, 0x00C1C1C1, 0x00C1C1C1, 
        0x00C1C1C1, 0x00C1C1C1, 0x00C1C1C1, 0x00C1C1C1, 0x00A9A9A9, 0x00838383, 0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x003F3F3F, 0x005A5A5A, 0x00676767, 0x00727272, 0x00707070, 0x00707070, 0x0060607B, 0x003B3B9A, 0x001616B8, 
        0x000707C4, 0x002B2BA5, 0x0047478B, 0x00626270, 0x006A6A6A, 0x006A6A6A, 0x006A6A6A, 0x00696969, 0x00676767, 0x00676767, 0x00666666, 0x00646464, 0x00646464, 0x00636363, 0x00616161, 0x00616161, 0x00606060, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 
        0x005D5D5D, 0x005C5C5C, 0x005B5B5B, 0x005A5A5A, 0x005A5A5A, 0x00595959, 0x00575757, 0x00575757, 0x00565656, 0x00555555, 0x00555555, 0x00545454, 0x00545454, 0x00535353, 0x00505050, 0x00505050, 0x004F4F4F, 0x004E4E4E, 0x004D4D4D, 0x004C4C4C, 
        0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 0x004A4A4A, 0x00484848, 0x00474747, 0x00464646, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00424242, 0x00404040, 0x00404040, 0x003F3F3F, 0x002D2D63, 0x00181892, 0x000808B8, 0x000707B8, 0x001B1B87, 
        0x002E2E56, 0x003A3A3A, 0x00393939, 0x00393939, 0x00353535, 0x00353535, 0x00373737, 0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x00767676, 0x00A6A6A6, 0x00C1C1C1, 0x00C1C1C1, 0x00C1C1C1, 0x00C1C1C1, 0x00C1C1C1, 0x00C1C1C1, 
        0x00C1C1C1, 0x00C1C1C1, 0x00C1C1C1, 0x00C1C1C1, 0x00C1C1C1, 0x00C1C1C1, 0x00C1C1C1, 0x66C0C0C0, 0xEEC0C0C0, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xCCC0C0C0, 0x22C0C0C0, 0x00C1C1C1, 0x00C1C1C1, 0x00C1C1C1, 0x00C1C1C1, 0x00C1C1C1, 0x00C1C1C1, 0x00C1C1C1, 0x00C1C1C1, 0x00C1C1C1, 0x00C1C1C1, 
        0x00C1C1C1, 0x00C1C1C1, 0x00A9A9A9, 0x00848484, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x004A4A4A, 0x00606060, 0x00727272, 0x00707070, 0x00707070, 0x00686875, 0x003B3B9A, 0x001616B8, 0x000707C5, 0x002C2CA6, 0x00505086, 
        0x006D6D6D, 0x006C6C6C, 0x006B6B6B, 0x006A6A6A, 0x006A6A6A, 0x006A6A6A, 0x00696969, 0x00686868, 0x00676767, 0x00676767, 0x00676767, 0x00646464, 0x00636363, 0x00636363, 0x00616161, 0x00606060, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005E5E5E, 
        0x00757575, 0x00DADADA, 0x005A5A5A, 0x005A5A5A, 0x00636363, 0x00B7B7B7, 0x00D9D9D9, 0x00A8A8A8, 0x005F5F5F, 0x00555555, 0x00555555, 0x00585858, 0x009B9B9B, 0x00D8D8D8, 0x00C4C4C4, 0x00909090, 0x00545454, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 
        0x004B4B4B, 0x004B4B4B, 0x00494949, 0x00494949, 0x00484848, 0x00484848, 0x00464646, 0x00454545, 0x00444444, 0x00444444, 0x00444444, 0x00434343, 0x00414141, 0x00404040, 0x00404040, 0x003E3E3E, 0x003E3E3E, 0x003D3D3D, 0x00303059, 0x001B1B87, 
        0x000707B7, 0x000707B7, 0x001A1A86, 0x0031314C, 0x00373737, 0x00363636, 0x00343434, 0x00343434, 0x00343434, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x00666666, 0x00A6A6A6, 0x00C1C1C1, 0x00C1C1C1, 0x00C1C1C1, 0x00C1C1C1, 
        0x00C1C1C1, 0x00C1C1C1, 0x00C1C1C1, 0x00C1C1C1, 0x00C1C1C1, 0x00C1C1C1, 0x00C1C1C1, 0x00C1C1C1, 0x11C0C0C0, 0xAAC0C0C0, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x77BFBFBF, 0x00C0C0C0, 0x00C0C0C0, 0x00C0C0C0, 0x00C0C0C0, 0x00C0C0C0, 0x00C0C0C0, 0x00C0C0C0, 0x00C0C0C0, 0x00C0C0C0, 0x00C0C0C0, 0x00C0C0C0, 0x00C0C0C0, 
        0x00ACACAC, 0x00838383, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x00525252, 0x00656565, 0x006F6F6F, 0x006F6F6F, 0x00707070, 0x004A4A8E, 0x002525AC, 0x000707C5, 0x002C2CA6, 0x00505086, 0x006D6D6D, 0x006D6D6D, 0x006D6D6D, 
        0x006D6D6D, 0x006D6D6D, 0x006A6A6A, 0x006A6A6A, 0x006A6A6A, 0x006A6A6A, 0x00686868, 0x00686868, 0x00676767, 0x00666666, 0x00646464, 0x00646464, 0x00636363, 0x00626262, 0x00616161, 0x00606060, 0x00606060, 0x005F5F5F, 0x005F5F5F, 0x007A7A7A, 
        0x00DADADA, 0x00DADADA, 0x005A5A5A, 0x005A5A5A, 0x009E9E9E, 0x00D9D9D9, 0x00D9D9D9, 0x00D8D8D8, 0x009C9C9C, 0x00555555, 0x00545454, 0x009B9B9B, 0x00D8D8D8, 0x00D8D8D8, 0x00D8D8D8, 0x00D7D7D7, 0x008F8F8F, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 
        0x004B4B4B, 0x004B4B4B, 0x004A4A4A, 0x00494949, 0x00484848, 0x00484848, 0x00464646, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00434343, 0x00414141, 0x003F3F3F, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003D3D3D, 0x003C3C3C, 0x003B3B3B, 
        0x00393939, 0x002D2D56, 0x001A1A86, 0x000303C1, 0x000A0AAD, 0x00232366, 0x00343434, 0x00343434, 0x00313131, 0x00313131, 0x00343434, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x00656565, 0x00A6A6A6, 0x00C0C0C0, 0x00C0C0C0, 
        0x00C0C0C0, 0x00C0C0C0, 0x00C0C0C0, 0x00C0C0C0, 0x00C0C0C0, 0x00C0C0C0, 0x00C0C0C0, 0x00C0C0C0, 0x00C0C0C0, 0x00C0C0C0, 0x55BFBFBF, 0xEEBFBFBF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xCCBEBEBE, 0x22BEBEBE, 0x00BFBFBF, 0x00BFBFBF, 0x00BFBFBF, 0x00BFBFBF, 0x00BFBFBF, 0x00BFBFBF, 0x00BFBFBF, 0x00BFBFBF, 0x00BFBFBF, 0x00BFBFBF, 0x00BFBFBF, 0x00B0B0B0, 0x008D8D8D, 
        0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x00545454, 0x00666666, 0x006D6D6D, 0x006E6E6E, 0x00676774, 0x003A3A99, 0x000E0EBE, 0x001616B8, 0x0049498C, 0x006D6D6D, 0x006D6D6D, 0x006D6D6D, 0x006D6D6D, 0x006D6D6D, 0x006D6D6D, 
        0x006C6C6C, 0x006B6B6B, 0x006A6A6A, 0x006A6A6A, 0x006A6A6A, 0x00696969, 0x00686868, 0x00676767, 0x00666666, 0x00646464, 0x00636363, 0x00636363, 0x00636363, 0x00636363, 0x00616161, 0x00606060, 0x00606060, 0x005F5F5F, 0x00B9B9B9, 0x00DBDBDB, 
        0x00DADADA, 0x00DADADA, 0x005B5B5B, 0x005A5A5A, 0x00D9D9D9, 0x00D9D9D9, 0x005B5B5B, 0x00A8A8A8, 0x00D8D8D8, 0x00555555, 0x00535353, 0x00C5C5C5, 0x00D8D8D8, 0x005D5D5D, 0x00555555, 0x00D7D7D7, 0x00C3C3C3, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 
        0x004B4B4B, 0x004A4A4A, 0x00494949, 0x00484848, 0x00484848, 0x00464646, 0x00464646, 0x00444444, 0x00444444, 0x00444444, 0x00424242, 0x00424242, 0x00414141, 0x003F3F3F, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003C3C3C, 0x003B3B3B, 0x003B3B3B, 
        0x003A3A3A, 0x00393939, 0x00393939, 0x00363636, 0x00232367, 0x00111199, 0x000303C1, 0x00181884, 0x002B2B46, 0x00313131, 0x00313131, 0x00303030, 0x00333333, 0x00383838, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x00838383, 0x00ABABAB, 
        0x00BFBFBF, 0x00BFBFBF, 0x00BFBFBF, 0x00BFBFBF, 0x00BFBFBF, 0x00BFBFBF, 0x00BFBFBF, 0x00BFBFBF, 0x00BFBFBF, 0x00BFBFBF, 0x00BFBFBF, 0x11BEBEBE, 0xBBBEBEBE, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x88BEBEBE, 0x00BFBFBF, 0x00BFBFBF, 0x00BFBFBF, 0x00BFBFBF, 0x00BFBFBF, 0x00BFBFBF, 0x00BFBFBF, 0x00BFBFBF, 0x00BFBFBF, 0x00BFBFBF, 0x00BFBFBF, 0x00B6B6B6, 0x009B9B9B, 0x003C3C3C, 0x003C3C3C, 
        0x003C3C3C, 0x003C3C3C, 0x003C3C3C, 0x00545454, 0x00636363, 0x006B6B6B, 0x006C6C6C, 0x005E5E79, 0x002B2BA5, 0x000707C4, 0x002B2BA5, 0x0056567F, 0x006D6D6D, 0x006D6D6D, 0x006D6D6D, 0x006D6D6D, 0x006D6D6D, 0x006C6C6C, 0x006B6B6B, 0x006B6B6B, 
        0x006B6B6B, 0x006B6B6B, 0x006A6A6A, 0x006D6D6D, 0x00696969, 0x00686868, 0x00676767, 0x00646464, 0x00646464, 0x00646464, 0x00636363, 0x00626262, 0x00626262, 0x00616161, 0x00606060, 0x00606060, 0x00606060, 0x005F5F5F, 0x005D5D5D, 0x00656565, 
        0x00DADADA, 0x00DADADA, 0x005B5B5B, 0x00595959, 0x00D9D9D9, 0x00D9D9D9, 0x00575757, 0x00B5B5B5, 0x00C5C5C5, 0x00545454, 0x00535353, 0x00D8D8D8, 0x00D8D8D8, 0x00515151, 0x00505050, 0x00D7D7D7, 0x00D7D7D7, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 
        0x004B4B4B, 0x00494949, 0x00494949, 0x00484848, 0x00484848, 0x00464646, 0x00464646, 0x00454545, 0x00444444, 0x00444444, 0x00424242, 0x00424242, 0x00525252, 0x005B5B5B, 0x003E3E3E, 0x003E3E3E, 0x003D3D3D, 0x003D3D3D, 0x003B3B3B, 0x003B3B3B, 
        0x003A3A3A, 0x00383838, 0x00373737, 0x00363636, 0x00363636, 0x00363636, 0x002C2C47, 0x00171784, 0x000303C0, 0x00101097, 0x0027274F, 0x00313131, 0x00303030, 0x002C2C2C, 0x00303030, 0x00383838, 0x003C3C3C, 0x003C3C3C, 0x003C3C3C, 0x003C3C3C, 
        0x008D8D8D, 0x00B0B0B0, 0x00BFBFBF, 0x00BFBFBF, 0x00BFBFBF, 0x00BFBFBF, 0x00BFBFBF, 0x00BFBFBF, 0x00BFBFBF, 0x00BFBFBF, 0x00BFBFBF, 0x00BFBFBF, 0x00BFBFBF, 0x66BEBEBE, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xEEBDBDBD, 0x55BDBDBD, 0x00BEBEBE, 0x00BEBEBE, 0x00BEBEBE, 0x00BEBEBE, 0x00BEBEBE, 0x00BEBEBE, 0x00BEBEBE, 0x00BEBEBE, 0x00BEBEBE, 0x00BEBEBE, 0x00BEBEBE, 0x00A4A4A4, 0x00676767, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 
        0x003D3D3D, 0x00515151, 0x00636363, 0x006A6A6A, 0x006A6A6A, 0x0055557D, 0x002323AA, 0x000707C4, 0x0031319D, 0x00636371, 0x006B6B6B, 0x006C6C6C, 0x006D6D6D, 0x006D6D6D, 0x006C6C6C, 0x006C6C6C, 0x006B6B6B, 0x006B6B6B, 0x006B6B6B, 0x006B6B6B, 
        0x006F6F6F, 0x00878787, 0x00A3A3A3, 0x009C9C9C, 0x007D7D7D, 0x00666666, 0x00676767, 0x00656565, 0x00646464, 0x00646464, 0x00626262, 0x00616161, 0x00616161, 0x00616161, 0x00606060, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005D5D5D, 0x005D5D5D, 
        0x00DADADA, 0x00DADADA, 0x005A5A5A, 0x00585858, 0x00585858, 0x00575757, 0x00707070, 0x00D8D8D8, 0x00929292, 0x00545454, 0x00535353, 0x00D8D8D8, 0x00D8D8D8, 0x00505050, 0x00505050, 0x00D7D7D7, 0x00D7D7D7, 0x004D4D4D, 0x004C4C4C, 0x004B4B4B, 
        0x004B4B4B, 0x004A4A4A, 0x00494949, 0x00484848, 0x00474747, 0x00464646, 0x00464646, 0x00454545, 0x00444444, 0x00545454, 0x00636363, 0x00737373, 0x009E9E9E, 0x00B4B4B4, 0x003E3E3E, 0x003E3E3E, 0x003D3D3D, 0x003D3D3D, 0x003B3B3B, 0x003B3B3B, 
        0x00393939, 0x00383838, 0x00363636, 0x00363636, 0x00363636, 0x00353535, 0x00333333, 0x00313131, 0x002D2D3B, 0x001D1D6E, 0x000606B6, 0x000C0CA1, 0x00212157, 0x002D2D2D, 0x002C2C2C, 0x002A2A2A, 0x00313131, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 
        0x003D3D3D, 0x00545454, 0x009E9E9E, 0x00BEBEBE, 0x00BEBEBE, 0x00BEBEBE, 0x00BEBEBE, 0x00BEBEBE, 0x00BEBEBE, 0x00BEBEBE, 0x00BEBEBE, 0x00BEBEBE, 0x00BEBEBE, 0x00BEBEBE, 0x33BDBDBD, 0xDDBDBDBD, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xCCBCBCBC, 0x22BCBCBC, 0x00BDBDBD, 0x00BDBDBD, 0x00BDBDBD, 0x00BDBDBD, 0x00BDBDBD, 0x00BDBDBD, 0x00BDBDBD, 0x00BDBDBD, 0x00BDBDBD, 0x00BDBDBD, 0x00AEAEAE, 0x00838383, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x004D4D4D, 
        0x00606060, 0x00686868, 0x00696969, 0x0053537C, 0x002222AA, 0x000E0EBE, 0x00383897, 0x00626270, 0x006A6A6A, 0x006A6A6A, 0x006B6B6B, 0x006B6B6B, 0x006C6C6C, 0x006B6B6B, 0x006B6B6B, 0x006B6B6B, 0x006B6B6B, 0x006A6A6A, 0x006A6A6A, 0x006C6C6C, 
        0x00A3A3A3, 0x00D7D7D7, 0x00D8D8D8, 0x00D8D8D8, 0x00B9B9B9, 0x007C7C7C, 0x00666666, 0x00646464, 0x00646464, 0x00646464, 0x00636363, 0x00616161, 0x00616161, 0x00606060, 0x00606060, 0x005F5F5F, 0x005F5F5F, 0x005E5E5E, 0x005D5D5D, 0x005B5B5B, 
        0x00DADADA, 0x00DADADA, 0x00595959, 0x00585858, 0x00585858, 0x00575757, 0x00A8A8A8, 0x00D8D8D8, 0x00686868, 0x00545454, 0x00545454, 0x00D8D8D8, 0x00D8D8D8, 0x00505050, 0x004F4F4F, 0x00D7D7D7, 0x00D6D6D6, 0x004D4D4D, 0x004C4C4C, 0x004B4B4B, 
        0x004B4B4B, 0x004A4A4A, 0x00484848, 0x00474747, 0x00464646, 0x00464646, 0x00464646, 0x00454545, 0x00444444, 0x00595959, 0x00949494, 0x00CBCBCB, 0x00D4D4D4, 0x00777777, 0x003E3E3E, 0x003D3D3D, 0x00464646, 0x005E5E5E, 0x006E6E6E, 0x00494949, 
        0x003A3A3A, 0x00393939, 0x00363636, 0x00363636, 0x00353535, 0x00353535, 0x00343434, 0x00323232, 0x00313131, 0x00313131, 0x00303030, 0x001E1E62, 0x000606B6, 0x000B0BA0, 0x00202056, 0x002B2B2B, 0x00292929, 0x002A2A2A, 0x00323232, 0x003E3E3E, 
        0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x00676767, 0x00AAAAAA, 0x00BDBDBD, 0x00BDBDBD, 0x00BDBDBD, 0x00BDBDBD, 0x00BDBDBD, 0x00BDBDBD, 0x00BDBDBD, 0x00BDBDBD, 0x00BDBDBD, 0x00BDBDBD, 0x11BCBCBC, 0xAABCBCBC, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0x88BCBCBC, 0x00BDBDBD, 0x00BDBDBD, 0x00BDBDBD, 0x00BDBDBD, 0x00BDBDBD, 0x00BDBDBD, 0x00BDBDBD, 0x00BDBDBD, 0x00BDBDBD, 0x00BDBDBD, 0x00BDBDBD, 0x009E9E9E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x00454545, 0x00595959, 0x00666666, 
        0x00676767, 0x00585874, 0x002929A2, 0x000606C4, 0x00363695, 0x00696969, 0x006A6A6A, 0x006A6A6A, 0x006A6A6A, 0x006A6A6A, 0x006A6A6A, 0x006A6A6A, 0x006B6B6B, 0x006B6B6B, 0x006A6A6A, 0x00767676, 0x006F6F6F, 0x00696969, 0x00696969, 0x007D7D7D, 
        0x00C1C1C1, 0x00BBBBBB, 0x00828282, 0x00868686, 0x00D7D7D7, 0x00A0A0A0, 0x00646464, 0x00646464, 0x00646464, 0x00646464, 0x00626262, 0x00616161, 0x00616161, 0x00606060, 0x00606060, 0x005F5F5F, 0x005E5E5E, 0x005D5D5D, 0x005C5C5C, 0x005B5B5B, 
        0x00DADADA, 0x00DADADA, 0x00595959, 0x00585858, 0x00575757, 0x00707070, 0x00D8D8D8, 0x00929292, 0x00545454, 0x00545454, 0x00535353, 0x00D8D8D8, 0x00D8D8D8, 0x00505050, 0x004F4F4F, 0x00D7D7D7, 0x00D6D6D6, 0x004D4D4D, 0x004D4D4D, 0x004B4B4B, 
        0x004B4B4B, 0x00494949, 0x00484848, 0x00484848, 0x00464646, 0x00464646, 0x00454545, 0x00444444, 0x00444444, 0x00424242, 0x004B4B4B, 0x00C1C1C1, 0x00D4D4D4, 0x00525252, 0x003E3E3E, 0x00414141, 0x006C6C6C, 0x00A5A5A5, 0x00D3D3D3, 0x00D2D2D2, 
        0x006A6A6A, 0x00393939, 0x00373737, 0x00363636, 0x00363636, 0x00353535, 0x00343434, 0x00323232, 0x00313131, 0x00303030, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x001D1D61, 0x000505B5, 0x000D0D95, 0x00202049, 0x00292929, 0x00292929, 0x002A2A2A, 
        0x00373737, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x009A9A9A, 0x00B4B4B4, 0x00BDBDBD, 0x00BDBDBD, 0x00BDBDBD, 0x00BDBDBD, 0x00BDBDBD, 0x00BDBDBD, 0x00BDBDBD, 0x00BDBDBD, 0x00BDBDBD, 0x00BDBDBD, 0x77BCBCBC, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x66BBBBBB, 
        0x00BCBCBC, 0x00BCBCBC, 0x00BCBCBC, 0x00BCBCBC, 0x00BCBCBC, 0x00BCBCBC, 0x00BCBCBC, 0x00BCBCBC, 0x00BCBCBC, 0x00BCBCBC, 0x00AEAEAE, 0x00777777, 0x003F3F3F, 0x003F3F3F, 0x003F3F3F, 0x003F3F3F, 0x00535353, 0x00646464, 0x00646464, 0x00646464, 
        0x002E2E9B, 0x000606C4, 0x002F2F9C, 0x005F5F6D, 0x00676767, 0x00686868, 0x00696969, 0x00696969, 0x006A6A6A, 0x006A6A6A, 0x006A6A6A, 0x00696969, 0x006F6F6F, 0x008B8B8B, 0x00B8B8B8, 0x00B8B8B8, 0x00989898, 0x007E7E7E, 0x00686868, 0x00797979, 
        0x00CCCCCC, 0x00B7B7B7, 0x00686868, 0x006B6B6B, 0x00DCDCDC, 0x00DCDCDC, 0x006A6A6A, 0x00646464, 0x00636363, 0x00636363, 0x00626262, 0x00616161, 0x00616161, 0x00606060, 0x005F5F5F, 0x005E5E5E, 0x005D5D5D, 0x005B5B5B, 0x005B5B5B, 0x005B5B5B, 
        0x00DADADA, 0x00D9D9D9, 0x00585858, 0x00585858, 0x00575757, 0x00B6B6B6, 0x00D8D8D8, 0x005F5F5F, 0x00545454, 0x00535353, 0x00515151, 0x00D8D8D8, 0x00D8D8D8, 0x00505050, 0x004F4F4F, 0x00D7D7D7, 0x00D6D6D6, 0x004D4D4D, 0x004D4D4D, 0x004B4B4B, 
        0x004B4B4B, 0x00494949, 0x00484848, 0x00484848, 0x00474747, 0x00464646, 0x00454545, 0x00444444, 0x00444444, 0x00434343, 0x005E5E5E, 0x00D4D4D4, 0x00A0A0A0, 0x003E3E3E, 0x00404040, 0x005B5B5B, 0x00C5C5C5, 0x00B5B5B5, 0x00CFCFCF, 0x00D2D2D2, 
        0x00575757, 0x00393939, 0x003B3B3B, 0x00535353, 0x00535353, 0x00343434, 0x00343434, 0x00313131, 0x00313131, 0x00313131, 0x002E2E2E, 0x002E2E2E, 0x002D2D2D, 0x002D2D2D, 0x002C2C2C, 0x00181869, 0x000202C0, 0x000F0F89, 0x00242431, 0x00272727, 
        0x00252525, 0x002C2C2C, 0x003A3A3A, 0x003F3F3F, 0x003F3F3F, 0x003F3F3F, 0x00686868, 0x00A9A9A9, 0x00BCBCBC, 0x00BCBCBC, 0x00BCBCBC, 0x00BCBCBC, 0x00BCBCBC, 0x00BCBCBC, 0x00BCBCBC, 0x00BCBCBC, 0x00BCBCBC, 0x00BCBCBC, 0x44BBBBBB, 0xEEBBBBBB, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xEEBABABA, 0x33BABABA, 0x00BBBBBB, 
        0x00BBBBBB, 0x00BBBBBB, 0x00BBBBBB, 0x00BBBBBB, 0x00BBBBBB, 0x00BBBBBB, 0x00BBBBBB, 0x00BBBBBB, 0x00BBBBBB, 0x009D9D9D, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x004A4A4A, 0x005A5A5A, 0x00636363, 0x00636363, 0x00424286, 0x000D0DBD, 
        0x002121A8, 0x00585874, 0x00676767, 0x00676767, 0x00676767, 0x00676767, 0x00676767, 0x00686868, 0x00696969, 0x006B6B6B, 0x00696969, 0x00696969, 0x00828282, 0x00C5C5C5, 0x00DBDBDB, 0x00C2C2C2, 0x00D4D4D4, 0x00B4B4B4, 0x00676767, 0x00676767, 
        0x00C4C4C4, 0x00DCDCDC, 0x00757575, 0x00666666, 0x009C9C9C, 0x00DCDCDC, 0x00848484, 0x00636363, 0x00636363, 0x00626262, 0x00616161, 0x00606060, 0x005F5F5F, 0x005F5F5F, 0x005D5D5D, 0x005D5D5D, 0x005D5D5D, 0x005B5B5B, 0x005B5B5B, 0x005B5B5B, 
        0x00DADADA, 0x00D9D9D9, 0x00585858, 0x00585858, 0x007C7C7C, 0x00D8D8D8, 0x00818181, 0x00545454, 0x00545454, 0x00535353, 0x00505050, 0x00C4C4C4, 0x00D8D8D8, 0x00555555, 0x00595959, 0x00D7D7D7, 0x00D6D6D6, 0x004D4D4D, 0x004D4D4D, 0x004B4B4B, 
        0x00494949, 0x00484848, 0x00484848, 0x00484848, 0x00474747, 0x00454545, 0x00444444, 0x00444444, 0x00444444, 0x00424242, 0x00868686, 0x00D4D4D4, 0x006C6C6C, 0x003E3E3E, 0x005F5F5F, 0x009B9B9B, 0x00A6A6A6, 0x00888888, 0x00D2D2D2, 0x00B2B2B2, 
        0x00393939, 0x00383838, 0x00808080, 0x00A5A5A5, 0x00C5C5C5, 0x00ADADAD, 0x00626262, 0x003A3A3A, 0x00313131, 0x00313131, 0x002F2F2F, 0x002E2E2E, 0x002D2D2D, 0x002D2D2D, 0x002C2C2C, 0x002A2A2A, 0x00262633, 0x0013137F, 0x000202C0, 0x00141473, 
        0x00252525, 0x00242424, 0x00262626, 0x00323232, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x00999999, 0x00BBBBBB, 0x00BBBBBB, 0x00BBBBBB, 0x00BBBBBB, 0x00BBBBBB, 0x00BBBBBB, 0x00BBBBBB, 0x00BBBBBB, 0x00BBBBBB, 0x00BBBBBB, 0x22BABABA, 
        0xCCBABABA, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xCCB9B9B9, 0x22B9B9B9, 0x00BABABA, 0x00BABABA, 
        0x00BABABA, 0x00BABABA, 0x00BABABA, 0x00BABABA, 0x00BABABA, 0x00BABABA, 0x00BABABA, 0x00B1B1B1, 0x008C8C8C, 0x00414141, 0x00414141, 0x00414141, 0x00414141, 0x00545454, 0x00616161, 0x00606060, 0x0053536E, 0x001919AE, 0x001313B6, 0x0048487E, 
        0x00646464, 0x00646464, 0x00646464, 0x00666666, 0x00676767, 0x00676767, 0x00676767, 0x00696969, 0x007F7F7F, 0x00ACACAC, 0x00676767, 0x00696969, 0x00AAAAAA, 0x00DBDBDB, 0x00828282, 0x006B6B6B, 0x00B3B3B3, 0x00D8D8D8, 0x007C7C7C, 0x00676767, 
        0x00919191, 0x00DCDCDC, 0x008F8F8F, 0x00646464, 0x007A7A7A, 0x00DCDCDC, 0x00AFAFAF, 0x00626262, 0x00616161, 0x00616161, 0x00606060, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005D5D5D, 0x005D5D5D, 0x005C5C5C, 0x005B5B5B, 0x005A5A5A, 0x005A5A5A, 
        0x00DADADA, 0x00D9D9D9, 0x00575757, 0x00575757, 0x00A8A8A8, 0x00D8D8D8, 0x00D8D8D8, 0x00D8D8D8, 0x00D8D8D8, 0x00535353, 0x00515151, 0x00909090, 0x00D7D7D7, 0x00D7D7D7, 0x00D7D7D7, 0x00D7D7D7, 0x00989898, 0x004D4D4D, 0x004B4B4B, 0x004B4B4B, 
        0x00494949, 0x00494949, 0x00484848, 0x00464646, 0x00464646, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00474747, 0x00D4D4D4, 0x00D4D4D4, 0x004B4B4B, 0x005C5C5C, 0x009F9F9F, 0x00BABABA, 0x00656565, 0x00868686, 0x00D2D2D2, 0x00717171, 
        0x00373737, 0x00585858, 0x00BCBCBC, 0x00B3B3B3, 0x009D9D9D, 0x00CCCCCC, 0x009F9F9F, 0x00464646, 0x00313131, 0x00313131, 0x00303030, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002B2B2B, 0x00292929, 0x00282828, 0x001E1E46, 0x0009099E, 
        0x000707A9, 0x001B1B44, 0x00222222, 0x00212121, 0x00272727, 0x003B3B3B, 0x00414141, 0x00414141, 0x00414141, 0x00777777, 0x00ACACAC, 0x00BABABA, 0x00BABABA, 0x00BABABA, 0x00BABABA, 0x00BABABA, 0x00BABABA, 0x00BABABA, 0x00BABABA, 0x00BABABA, 
        0x11B9B9B9, 0xBBB9B9B9, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xBBB9B9B9, 0x11B9B9B9, 0x00BABABA, 0x00BABABA, 0x00BABABA, 
        0x00BABABA, 0x00BABABA, 0x00BABABA, 0x00BABABA, 0x00BABABA, 0x00BABABA, 0x00A8A8A8, 0x00696969, 0x00414141, 0x00414141, 0x00414141, 0x00494949, 0x00585858, 0x005F5F5F, 0x005F5F5F, 0x00333391, 0x000606C4, 0x00333392, 0x00616161, 0x00616161, 
        0x00626262, 0x00646464, 0x00646464, 0x00646464, 0x00656565, 0x00646464, 0x00666666, 0x006C6C6C, 0x00A4A4A4, 0x00DCDCDC, 0x00727272, 0x00676767, 0x009B9B9B, 0x00D8D8D8, 0x00858585, 0x00676767, 0x00878787, 0x00DCDCDC, 0x009B9B9B, 0x00656565, 
        0x00737373, 0x00DCDCDC, 0x00C3C3C3, 0x00646464, 0x00646464, 0x00C8C8C8, 0x00DBDBDB, 0x006F6F6F, 0x00606060, 0x00606060, 0x00606060, 0x005F5F5F, 0x005F5F5F, 0x005D5D5D, 0x005D5D5D, 0x005D5D5D, 0x005D5D5D, 0x005B5B5B, 0x005A5A5A, 0x005A5A5A, 
        0x00D9D9D9, 0x00D9D9D9, 0x00575757, 0x00575757, 0x00C5C5C5, 0x00D8D8D8, 0x00D8D8D8, 0x00D8D8D8, 0x00D8D8D8, 0x00525252, 0x00505050, 0x00555555, 0x009A9A9A, 0x00D7D7D7, 0x00D7D7D7, 0x00989898, 0x00515151, 0x004D4D4D, 0x004B4B4B, 0x004B4B4B, 
        0x00494949, 0x00494949, 0x00484848, 0x00454545, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00434343, 0x00676767, 0x00D4D4D4, 0x008F8F8F, 0x00525252, 0x009F9F9F, 0x00C0C0C0, 0x00737373, 0x003C3C3C, 0x00BABABA, 0x00D2D2D2, 0x004D4D4D, 
        0x00373737, 0x00858585, 0x00D0D0D0, 0x00686868, 0x003D3D3D, 0x00727272, 0x00B8B8B8, 0x00656565, 0x00313131, 0x002F2F2F, 0x002E2E2E, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002C2C2C, 0x002A2A2A, 0x00282828, 0x00272727, 0x00272727, 0x00252525, 
        0x0018185C, 0x000202C0, 0x000F0F7C, 0x00222222, 0x001F1F1F, 0x00202020, 0x00313131, 0x00414141, 0x00414141, 0x00414141, 0x00575757, 0x00A2A2A2, 0x00BABABA, 0x00BABABA, 0x00BABABA, 0x00BABABA, 0x00BABABA, 0x00BABABA, 0x00BABABA, 0x00BABABA, 
        0x00BABABA, 0x00BABABA, 0xAAB9B9B9, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xBBB8B8B8, 0x00B9B9B9, 0x00B9B9B9, 0x00B9B9B9, 0x00B9B9B9, 0x00B9B9B9, 
        0x00B9B9B9, 0x00B9B9B9, 0x00B9B9B9, 0x00B9B9B9, 0x00B9B9B9, 0x009C9C9C, 0x00424242, 0x00424242, 0x00424242, 0x00424242, 0x00515151, 0x005E5E5E, 0x005F5F5F, 0x0052526D, 0x001212B5, 0x001919AE, 0x0052526D, 0x00616161, 0x00616161, 0x00616161, 
        0x00616161, 0x00636363, 0x00636363, 0x00636363, 0x00646464, 0x00636363, 0x00646464, 0x00828282, 0x00C3C3C3, 0x00DCDCDC, 0x008B8B8B, 0x00646464, 0x007D7D7D, 0x00DCDCDC, 0x00ABABAB, 0x00666666, 0x006C6C6C, 0x00DCDCDC, 0x00DCDCDC, 0x00676767, 
        0x00646464, 0x00B3B3B3, 0x00DCDCDC, 0x00777777, 0x00626262, 0x00929292, 0x00DBDBDB, 0x00898989, 0x00606060, 0x00606060, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005D5D5D, 0x005D5D5D, 0x005D5D5D, 0x005C5C5C, 0x005B5B5B, 0x00595959, 0x00585858, 
        0x00575757, 0x00575757, 0x00575757, 0x00575757, 0x00565656, 0x00555555, 0x00545454, 0x00545454, 0x00535353, 0x00535353, 0x00505050, 0x00505050, 0x004F4F4F, 0x004E4E4E, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004C4C4C, 0x004A4A4A, 0x00494949, 
        0x00484848, 0x00484848, 0x00474747, 0x00464646, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00424242, 0x00959595, 0x00D4D4D4, 0x00646464, 0x00797979, 0x00CDCDCD, 0x00A3A3A3, 0x00565656, 0x005B5B5B, 0x00D2D2D2, 0x009D9D9D, 0x00393939, 
        0x003F3F3F, 0x00D1D1D1, 0x00D1D1D1, 0x00404040, 0x00343434, 0x00989898, 0x00C6C6C6, 0x00555555, 0x00313131, 0x002F2F2F, 0x002E2E2E, 0x002D2D2D, 0x002D2D2D, 0x002C2C2C, 0x002A2A2A, 0x00292929, 0x00292929, 0x00272727, 0x00272727, 0x00252525, 
        0x00252525, 0x0021212F, 0x000D0D87, 0x000404B4, 0x00191942, 0x001F1F1F, 0x001E1E1E, 0x00282828, 0x00424242, 0x00424242, 0x00424242, 0x00424242, 0x00939393, 0x00B9B9B9, 0x00B9B9B9, 0x00B9B9B9, 0x00B9B9B9, 0x00B9B9B9, 0x00B9B9B9, 0x00B9B9B9, 
        0x00B9B9B9, 0x00B9B9B9, 0x00B9B9B9, 0x99B8B8B8, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x99B7B7B7, 0x00B8B8B8, 0x00B8B8B8, 0x00B8B8B8, 0x00B8B8B8, 0x00B8B8B8, 0x00B8B8B8, 
        0x00B8B8B8, 0x00B8B8B8, 0x00B8B8B8, 0x00B8B8B8, 0x008C8C8C, 0x00434343, 0x00434343, 0x00434343, 0x00454545, 0x00545454, 0x005D5D5D, 0x005D5D5D, 0x00383889, 0x000606C3, 0x0038388A, 0x00606060, 0x00606060, 0x00616161, 0x00616161, 0x00616161, 
        0x00616161, 0x00616161, 0x00626262, 0x00636363, 0x00636363, 0x00636363, 0x00757575, 0x00A8A8A8, 0x009C9C9C, 0x00DCDCDC, 0x00BBBBBB, 0x00646464, 0x00656565, 0x00D1D1D1, 0x00DCDCDC, 0x006D6D6D, 0x00646464, 0x00A2A2A2, 0x00DCDCDC, 0x00808080, 
        0x00636363, 0x00858585, 0x00D7D7D7, 0x00999999, 0x00666666, 0x008D8D8D, 0x00D2D2D2, 0x00969696, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005D5D5D, 0x005B5B5B, 0x005B5B5B, 0x005B5B5B, 0x00595959, 0x00585858, 0x00585858, 
        0x00585858, 0x00575757, 0x00565656, 0x00565656, 0x00555555, 0x00545454, 0x00545454, 0x00545454, 0x00525252, 0x00505050, 0x00505050, 0x00505050, 0x004F4F4F, 0x004E4E4E, 0x004D4D4D, 0x004D4D4D, 0x004C4C4C, 0x004B4B4B, 0x00494949, 0x00494949, 
        0x00494949, 0x00484848, 0x00474747, 0x00464646, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x004F4F4F, 0x00D4D4D4, 0x00CBCBCB, 0x00424242, 0x009C9C9C, 0x00D3D3D3, 0x00D3D3D3, 0x00D3D3D3, 0x00BABABA, 0x00D2D2D2, 0x006C6C6C, 0x00393939, 
        0x00636363, 0x00D2D2D2, 0x00878787, 0x00353535, 0x00474747, 0x00D2D2D2, 0x00BEBEBE, 0x00313131, 0x00313131, 0x002F2F2F, 0x002E2E2E, 0x002D2D2D, 0x002C2C2C, 0x002B2B2B, 0x00292929, 0x00292929, 0x00292929, 0x00272727, 0x00262626, 0x00252525, 
        0x00242424, 0x00242424, 0x00232323, 0x0018184E, 0x000202BF, 0x000D0D7A, 0x001E1E1E, 0x001C1C1C, 0x00212121, 0x00383838, 0x00434343, 0x00434343, 0x00434343, 0x00777777, 0x00AFAFAF, 0x00B8B8B8, 0x00B8B8B8, 0x00B8B8B8, 0x00B8B8B8, 0x00B8B8B8, 
        0x00B8B8B8, 0x00B8B8B8, 0x00B8B8B8, 0x00B8B8B8, 0x77B7B7B7, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x99B7B7B7, 0x00B8B8B8, 0x00B8B8B8, 0x00B8B8B8, 0x00B8B8B8, 0x00B8B8B8, 0x00B8B8B8, 0x00B8B8B8, 
        0x00B8B8B8, 0x00B8B8B8, 0x00AAAAAA, 0x00696969, 0x00444444, 0x00444444, 0x00444444, 0x004A4A4A, 0x00565656, 0x005B5B5B, 0x00555563, 0x001E1EA5, 0x001212B5, 0x0050506B, 0x005E5E5E, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 
        0x00606060, 0x00606060, 0x00616161, 0x00636363, 0x00626262, 0x00616161, 0x00616161, 0x00636363, 0x00686868, 0x00BBBBBB, 0x00DCDCDC, 0x00747474, 0x00646464, 0x00959595, 0x00DCDCDC, 0x00898989, 0x00646464, 0x007D7D7D, 0x00DBDBDB, 0x00A6A6A6, 
        0x00616161, 0x006A6A6A, 0x00BDBDBD, 0x00DADADA, 0x00CBCBCB, 0x00DBDBDB, 0x00BABABA, 0x00707070, 0x005F5F5F, 0x005F5F5F, 0x005E5E5E, 0x005D5D5D, 0x005D5D5D, 0x005C5C5C, 0x005B5B5B, 0x005A5A5A, 0x005A5A5A, 0x005A5A5A, 0x00585858, 0x00575757, 
        0x00575757, 0x00555555, 0x00555555, 0x00555555, 0x00555555, 0x00545454, 0x00535353, 0x00535353, 0x00525252, 0x00505050, 0x00505050, 0x004F4F4F, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004B4B4B, 0x004B4B4B, 0x004A4A4A, 0x00494949, 
        0x00484848, 0x00464646, 0x00464646, 0x00464646, 0x00454545, 0x00444444, 0x00444444, 0x00424242, 0x005B5B5B, 0x00B7B7B7, 0x00828282, 0x003E3E3E, 0x003D3D3D, 0x00575757, 0x007D7D7D, 0x00C5C5C5, 0x00D3D3D3, 0x00D2D2D2, 0x00D2D2D2, 0x00444444, 
        0x00959595, 0x00D1D1D1, 0x005A5A5A, 0x00343434, 0x006C6C6C, 0x00D2D2D2, 0x00757575, 0x00313131, 0x00313131, 0x002E2E2E, 0x002D2D2D, 0x002D2D2D, 0x002B2B2B, 0x002B2B2B, 0x00292929, 0x00292929, 0x00282828, 0x00272727, 0x00252525, 0x00252525, 
        0x00242424, 0x00242424, 0x00222222, 0x001F1F1F, 0x001C1C2A, 0x00090991, 0x000505A8, 0x00181833, 0x001C1C1C, 0x001B1B1B, 0x002E2E2E, 0x00444444, 0x00444444, 0x00444444, 0x00585858, 0x00A6A6A6, 0x00B8B8B8, 0x00B8B8B8, 0x00B8B8B8, 0x00B8B8B8, 
        0x00B8B8B8, 0x00B8B8B8, 0x00B8B8B8, 0x00B8B8B8, 0x00B8B8B8, 0x66B7B7B7, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x99B6B6B6, 0x00B7B7B7, 0x00B7B7B7, 0x00B7B7B7, 0x00B7B7B7, 0x00B7B7B7, 0x00B7B7B7, 0x00B7B7B7, 0x00B7B7B7, 
        0x00B7B7B7, 0x00A5A5A5, 0x00585858, 0x00444444, 0x00444444, 0x00444444, 0x004F4F4F, 0x00585858, 0x00585858, 0x0046466F, 0x000C0CBC, 0x002A2A96, 0x005C5C5C, 0x005D5D5D, 0x005D5D5D, 0x005D5D5D, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 
        0x00606060, 0x00606060, 0x00606060, 0x00616161, 0x00616161, 0x00616161, 0x00616161, 0x00626262, 0x00636363, 0x00898989, 0x00DBDBDB, 0x00939393, 0x00636363, 0x00767676, 0x00DBDBDB, 0x00B8B8B8, 0x00626262, 0x00676767, 0x00D4D4D4, 0x00D0D0D0, 
        0x006A6A6A, 0x00616161, 0x007D7D7D, 0x009C9C9C, 0x00C5C5C5, 0x00ACACAC, 0x007B7B7B, 0x00626262, 0x005F5F5F, 0x005D5D5D, 0x005D5D5D, 0x005C5C5C, 0x005B5B5B, 0x005B5B5B, 0x005A5A5A, 0x005A5A5A, 0x00595959, 0x00585858, 0x00585858, 0x00575757, 
        0x00575757, 0x00565656, 0x00555555, 0x00555555, 0x00545454, 0x00535353, 0x00535353, 0x00535353, 0x00525252, 0x004F4F4F, 0x004F4F4F, 0x004E4E4E, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004B4B4B, 0x004B4B4B, 0x00494949, 0x00484848, 
        0x00484848, 0x00474747, 0x00464646, 0x00464646, 0x00444444, 0x00434343, 0x00424242, 0x00424242, 0x00424242, 0x00404040, 0x00484848, 0x003F3F3F, 0x003E3E3E, 0x003D3D3D, 0x003C3C3C, 0x00656565, 0x00D3D3D3, 0x00B7B7B7, 0x00969696, 0x00484848, 
        0x00CCCCCC, 0x00C2C2C2, 0x00363636, 0x00353535, 0x00AAAAAA, 0x00D1D1D1, 0x004C4C4C, 0x00313131, 0x00313131, 0x002F2F2F, 0x002D2D2D, 0x002D2D2D, 0x002C2C2C, 0x002B2B2B, 0x002A2A2A, 0x00292929, 0x00292929, 0x00272727, 0x00252525, 0x00252525, 
        0x00242424, 0x00232323, 0x00202020, 0x001F1F1F, 0x001F1F1F, 0x001E1E1E, 0x00111162, 0x000101BF, 0x00111155, 0x001A1A1A, 0x00191919, 0x00262626, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00A0A0A0, 0x00B7B7B7, 0x00B7B7B7, 0x00B7B7B7, 
        0x00B7B7B7, 0x00B7B7B7, 0x00B7B7B7, 0x00B7B7B7, 0x00B7B7B7, 0x00B7B7B7, 0x66B6B6B6, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x99B5B5B5, 0x00B6B6B6, 0x00B6B6B6, 0x00B6B6B6, 0x00B6B6B6, 0x00B6B6B6, 0x00B6B6B6, 0x00B6B6B6, 0x00B6B6B6, 0x00B6B6B6, 
        0x00A2A2A2, 0x00454545, 0x00454545, 0x00454545, 0x00454545, 0x00505050, 0x00585858, 0x00585858, 0x002E2E8D, 0x000B0BBB, 0x003B3B7F, 0x005B5B5B, 0x005B5B5B, 0x005C5C5C, 0x005B5B5B, 0x005D5D5D, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 
        0x005F5F5F, 0x00606060, 0x00606060, 0x00606060, 0x00616161, 0x00616161, 0x00616161, 0x00616161, 0x00616161, 0x006E6E6E, 0x00DBDBDB, 0x00CCCCCC, 0x00616161, 0x00626262, 0x00B8B8B8, 0x00D8D8D8, 0x007A7A7A, 0x00858585, 0x00C7C7C7, 0x00AEAEAE, 
        0x006F6F6F, 0x00606060, 0x00616161, 0x00696969, 0x006A6A6A, 0x005F5F5F, 0x005F5F5F, 0x005E5E5E, 0x005D5D5D, 0x005D5D5D, 0x005D5D5D, 0x005B5B5B, 0x005B5B5B, 0x005B5B5B, 0x00595959, 0x00585858, 0x00585858, 0x00585858, 0x00585858, 0x00575757, 
        0x00565656, 0x00555555, 0x00555555, 0x00555555, 0x00545454, 0x00535353, 0x00535353, 0x00515151, 0x00505050, 0x004F4F4F, 0x004F4F4F, 0x004E4E4E, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004B4B4B, 0x004B4B4B, 0x00494949, 0x00494949, 0x00494949, 
        0x00474747, 0x00464646, 0x00464646, 0x00454545, 0x00444444, 0x00424242, 0x00424242, 0x00424242, 0x00424242, 0x00404040, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003D3D3D, 0x003C3C3C, 0x00939393, 0x00D2D2D2, 0x005E5E5E, 0x003C3C3C, 0x00606060, 
        0x00BCBCBC, 0x007C7C7C, 0x00393939, 0x00535353, 0x00D1D1D1, 0x00A7A7A7, 0x00313131, 0x00313131, 0x00313131, 0x002F2F2F, 0x002D2D2D, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x00282828, 0x00272727, 0x00262626, 0x00252525, 0x00242424, 
        0x00232323, 0x00222222, 0x00212121, 0x001F1F1F, 0x001E1E1E, 0x001E1E1E, 0x001C1C1C, 0x0016163E, 0x000303B3, 0x000A0A84, 0x00191919, 0x00161616, 0x001E1E1E, 0x003D3D3D, 0x00454545, 0x00454545, 0x00454545, 0x009D9D9D, 0x00B6B6B6, 0x00B6B6B6, 
        0x00B6B6B6, 0x00B6B6B6, 0x00B6B6B6, 0x00B6B6B6, 0x00B6B6B6, 0x00B6B6B6, 0x00B6B6B6, 0x66B5B5B5, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x99B5B5B5, 0x00B6B6B6, 0x00B6B6B6, 0x00B6B6B6, 0x00B6B6B6, 0x00B6B6B6, 0x00B6B6B6, 0x00B6B6B6, 0x00B6B6B6, 0x00B6B6B6, 0x009D9D9D, 
        0x00464646, 0x00464646, 0x00464646, 0x00464646, 0x00525252, 0x00575757, 0x00585858, 0x001C1CA4, 0x001111B4, 0x004B4B67, 0x00585858, 0x005A5A5A, 0x005A5A5A, 0x005B5B5B, 0x005B5B5B, 0x005C5C5C, 0x005D5D5D, 0x005D5D5D, 0x005D5D5D, 0x005F5F5F, 
        0x005F5F5F, 0x00606060, 0x005F5F5F, 0x005F5F5F, 0x00606060, 0x00606060, 0x00616161, 0x00616161, 0x00606060, 0x00616161, 0x00A9A9A9, 0x00DBDBDB, 0x00787878, 0x00616161, 0x00838383, 0x00BCBCBC, 0x00DADADA, 0x00DBDBDB, 0x00CBCBCB, 0x008A8A8A, 
        0x00616161, 0x00606060, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005E5E5E, 0x005D5D5D, 0x005D5D5D, 0x005D5D5D, 0x005D5D5D, 0x005D5D5D, 0x005B5B5B, 0x005A5A5A, 0x005A5A5A, 0x00595959, 0x00585858, 0x00585858, 0x00575757, 0x00575757, 0x00575757, 
        0x00555555, 0x00555555, 0x00555555, 0x00555555, 0x00535353, 0x00525252, 0x00515151, 0x00505050, 0x004F4F4F, 0x004F4F4F, 0x004F4F4F, 0x004E4E4E, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004B4B4B, 0x004B4B4B, 0x00494949, 0x00494949, 0x00484848, 
        0x00464646, 0x00464646, 0x00454545, 0x00444444, 0x00444444, 0x00434343, 0x00424242, 0x00424242, 0x00404040, 0x00404040, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003C3C3C, 0x003B3B3B, 0x00484848, 0x00696969, 0x003C3C3C, 0x00383838, 0x00565656, 
        0x00ADADAD, 0x00ABABAB, 0x006E6E6E, 0x00888888, 0x00D1D1D1, 0x00696969, 0x00313131, 0x00313131, 0x002E2E2E, 0x002E2E2E, 0x002D2D2D, 0x002B2B2B, 0x002B2B2B, 0x002A2A2A, 0x00292929, 0x00282828, 0x00272727, 0x00272727, 0x00383838, 0x00383838, 
        0x00373737, 0x00363636, 0x00333333, 0x001F1F1F, 0x001E1E1E, 0x001E1E1E, 0x001C1C1C, 0x001C1C1C, 0x00191926, 0x00080890, 0x000404A7, 0x00141422, 0x00151515, 0x001B1B1B, 0x00383838, 0x00464646, 0x00464646, 0x00464646, 0x00979797, 0x00B6B6B6, 
        0x00B6B6B6, 0x00B6B6B6, 0x00B6B6B6, 0x00B6B6B6, 0x00B6B6B6, 0x00B6B6B6, 0x00B6B6B6, 0x00B6B6B6, 0x66B5B5B5, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x99B4B4B4, 0x00B5B5B5, 0x00B5B5B5, 0x00B5B5B5, 0x00B5B5B5, 0x00B5B5B5, 0x00B5B5B5, 0x00B5B5B5, 0x00B5B5B5, 0x00B5B5B5, 0x009C9C9C, 0x00464646, 
        0x00464646, 0x00464646, 0x00484848, 0x00515151, 0x00565656, 0x004F4F5D, 0x001111B3, 0x001C1CA4, 0x00575757, 0x00585858, 0x00585858, 0x00585858, 0x005A5A5A, 0x005A5A5A, 0x005A5A5A, 0x005B5B5B, 0x005B5B5B, 0x005D5D5D, 0x005D5D5D, 0x005E5E5E, 
        0x005D5D5D, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x00606060, 0x00606060, 0x005F5F5F, 0x005F5F5F, 0x007F7F7F, 0x00DBDBDB, 0x009C9C9C, 0x00606060, 0x00666666, 0x007A7A7A, 0x00A7A7A7, 0x009E9E9E, 0x007A7A7A, 0x005F5F5F, 
        0x005F5F5F, 0x005F5F5F, 0x005E5E5E, 0x005D5D5D, 0x005D5D5D, 0x005D5D5D, 0x005D5D5D, 0x005D5D5D, 0x005C5C5C, 0x005C5C5C, 0x005B5B5B, 0x005B5B5B, 0x005A5A5A, 0x005A5A5A, 0x00595959, 0x00585858, 0x00585858, 0x00575757, 0x00575757, 0x00575757, 
        0x00555555, 0x00545454, 0x00545454, 0x00535353, 0x00525252, 0x00505050, 0x00505050, 0x00505050, 0x004E4E4E, 0x004E4E4E, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004C4C4C, 0x004B4B4B, 0x00494949, 0x00484848, 0x00484848, 0x00474747, 
        0x00464646, 0x00464646, 0x00464646, 0x00444444, 0x00444444, 0x00424242, 0x00424242, 0x00424242, 0x00404040, 0x00404040, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003C3C3C, 0x003B3B3B, 0x003B3B3B, 0x003A3A3A, 0x00393939, 0x00373737, 0x00424242, 
        0x00878787, 0x00D1D1D1, 0x00D1D1D1, 0x00C9C9C9, 0x009F9F9F, 0x00424242, 0x00313131, 0x00313131, 0x002F2F2F, 0x002D2D2D, 0x002D2D2D, 0x002C2C2C, 0x002A2A2A, 0x00292929, 0x00272727, 0x00272727, 0x00272727, 0x00272727, 0x00474747, 0x00B3B3B3, 
        0x00878787, 0x00959595, 0x00B9B9B9, 0x00323232, 0x001E1E1E, 0x001C1C1C, 0x001C1C1C, 0x001C1C1C, 0x001B1B1B, 0x001A1A1A, 0x000B0B77, 0x000202B3, 0x00101039, 0x00141414, 0x00131313, 0x00333333, 0x00464646, 0x00464646, 0x00464646, 0x00919191, 
        0x00B5B5B5, 0x00B5B5B5, 0x00B5B5B5, 0x00B5B5B5, 0x00B5B5B5, 0x00B5B5B5, 0x00B5B5B5, 0x00B5B5B5, 0x00B5B5B5, 0x77B4B4B4, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xBBB3B3B3, 0x00B4B4B4, 0x00B4B4B4, 0x00B4B4B4, 0x00B4B4B4, 0x00B4B4B4, 0x00B4B4B4, 0x00B4B4B4, 0x00B4B4B4, 0x00B4B4B4, 0x00959595, 0x00474747, 0x00474747, 
        0x00474747, 0x00494949, 0x00505050, 0x00535353, 0x0043436C, 0x000505C3, 0x002D2D8C, 0x00575757, 0x00575757, 0x00585858, 0x00575757, 0x00585858, 0x005A5A5A, 0x005A5A5A, 0x005A5A5A, 0x005A5A5A, 0x005B5B5B, 0x005B5B5B, 0x005B5B5B, 0x005C5C5C, 
        0x005D5D5D, 0x005D5D5D, 0x005E5E5E, 0x005E5E5E, 0x005F5F5F, 0x005E5E5E, 0x005D5D5D, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x00656565, 0x00DBDBDB, 0x00DBDBDB, 0x00646464, 0x00606060, 0x00616161, 0x00636363, 0x005F5F5F, 0x005F5F5F, 0x005E5E5E, 
        0x005D5D5D, 0x005D5D5D, 0x005D5D5D, 0x005D5D5D, 0x005D5D5D, 0x005C5C5C, 0x005C5C5C, 0x005B5B5B, 0x005B5B5B, 0x005B5B5B, 0x005B5B5B, 0x005B5B5B, 0x00595959, 0x00585858, 0x00585858, 0x00585858, 0x00585858, 0x00575757, 0x00565656, 0x00555555, 
        0x00555555, 0x00535353, 0x00535353, 0x00535353, 0x00535353, 0x00505050, 0x00505050, 0x00505050, 0x004E4E4E, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004B4B4B, 0x004B4B4B, 0x004A4A4A, 0x00484848, 0x00484848, 0x00484848, 0x00484848, 
        0x00454545, 0x00454545, 0x00444444, 0x00444444, 0x00444444, 0x00424242, 0x00424242, 0x00414141, 0x00404040, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003B3B3B, 0x003A3A3A, 0x003A3A3A, 0x00393939, 0x00393939, 0x00363636, 0x00363636, 
        0x00363636, 0x00555555, 0x00757575, 0x006C6C6C, 0x004A4A4A, 0x00313131, 0x00313131, 0x002F2F2F, 0x002E2E2E, 0x002D2D2D, 0x002D2D2D, 0x002B2B2B, 0x00292929, 0x00292929, 0x00272727, 0x00272727, 0x00272727, 0x00252525, 0x00292929, 0x00646464, 
        0x00CDCDCD, 0x00CDCDCD, 0x00565656, 0x001E1E1E, 0x001D1D1D, 0x001C1C1C, 0x001C1C1C, 0x001B1B1B, 0x001B1B1B, 0x00181818, 0x00181818, 0x000D0D51, 0x000101BE, 0x000D0D44, 0x00121212, 0x00111111, 0x00303030, 0x00474747, 0x00474747, 0x00474747, 
        0x008B8B8B, 0x00B4B4B4, 0x00B4B4B4, 0x00B4B4B4, 0x00B4B4B4, 0x00B4B4B4, 0x00B4B4B4, 0x00B4B4B4, 0x00B4B4B4, 0x00B4B4B4, 0x99B3B3B3, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xCCB3B3B3, 0x00B4B4B4, 0x00B4B4B4, 0x00B4B4B4, 0x00B4B4B4, 0x00B4B4B4, 0x00B4B4B4, 0x00B4B4B4, 0x00B4B4B4, 0x00B4B4B4, 0x00919191, 0x00484848, 0x00484848, 0x00484848, 
        0x004A4A4A, 0x00515151, 0x00535353, 0x003C3C72, 0x000505C3, 0x0038387C, 0x00555555, 0x00565656, 0x00565656, 0x00575757, 0x00575757, 0x00585858, 0x006B6B6B, 0x00656565, 0x00595959, 0x005A5A5A, 0x005B5B5B, 0x005B5B5B, 0x005B5B5B, 0x005B5B5B, 
        0x005C5C5C, 0x005B5B5B, 0x005C5C5C, 0x005C5C5C, 0x005D5D5D, 0x005D5D5D, 0x005D5D5D, 0x005E5E5E, 0x005E5E5E, 0x005E5E5E, 0x005F5F5F, 0x008F8F8F, 0x00888888, 0x00636363, 0x005F5F5F, 0x005F5F5F, 0x005E5E5E, 0x005D5D5D, 0x005D5D5D, 0x005D5D5D, 
        0x005D5D5D, 0x005D5D5D, 0x005D5D5D, 0x005C5C5C, 0x005B5B5B, 0x005B5B5B, 0x005B5B5B, 0x005B5B5B, 0x005B5B5B, 0x005B5B5B, 0x005A5A5A, 0x005A5A5A, 0x00595959, 0x00585858, 0x00575757, 0x00575757, 0x00575757, 0x00565656, 0x00555555, 0x00545454, 
        0x00545454, 0x00535353, 0x00535353, 0x00525252, 0x00515151, 0x00505050, 0x00505050, 0x00505050, 0x004E4E4E, 0x00C3C3C3, 0x00D7D7D7, 0x004D4D4D, 0x004C4C4C, 0x004B4B4B, 0x00494949, 0x00494949, 0x00484848, 0x00484848, 0x00474747, 0x00464646, 
        0x00454545, 0x00444444, 0x00444444, 0x00444444, 0x00424242, 0x00424242, 0x00414141, 0x00404040, 0x00404040, 0x003E3E3E, 0x003E3E3E, 0x003D3D3D, 0x003C3C3C, 0x003B3B3B, 0x003A3A3A, 0x003A3A3A, 0x00393939, 0x00393939, 0x00373737, 0x00363636, 
        0x00353535, 0x00343434, 0x00343434, 0x00333333, 0x00323232, 0x00313131, 0x00303030, 0x002E2E2E, 0x002E2E2E, 0x002D2D2D, 0x002D2D2D, 0x002B2B2B, 0x00292929, 0x00292929, 0x00282828, 0x00272727, 0x00272727, 0x00252525, 0x00363636, 0x00B0B0B0, 
        0x00CDCDCD, 0x00686868, 0x001F1F1F, 0x001F1F1F, 0x00363636, 0x003B3B3B, 0x001C1C1C, 0x001A1A1A, 0x00191919, 0x00181818, 0x00181818, 0x00171717, 0x000F0F38, 0x000101BE, 0x000A0A5B, 0x00111111, 0x00111111, 0x00292929, 0x00484848, 0x00484848, 
        0x00484848, 0x00828282, 0x00B4B4B4, 0x00B4B4B4, 0x00B4B4B4, 0x00B4B4B4, 0x00B4B4B4, 0x00B4B4B4, 0x00B4B4B4, 0x00B4B4B4, 0x00B4B4B4, 0xAAB3B3B3, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xCCB2B2B2, 0x11B2B2B2, 0x00B3B3B3, 0x00B3B3B3, 0x00B3B3B3, 0x00B3B3B3, 0x00B3B3B3, 0x00B3B3B3, 0x00B3B3B3, 0x00B3B3B3, 0x00919191, 0x00494949, 0x00494949, 0x00494949, 0x004A4A4A, 
        0x00505050, 0x00505050, 0x0037377A, 0x000B0BBB, 0x0042426A, 0x00555555, 0x00545454, 0x00555555, 0x00555555, 0x00565656, 0x005E5E5E, 0x00979797, 0x00AFAFAF, 0x00AAAAAA, 0x00828282, 0x005A5A5A, 0x005A5A5A, 0x005B5B5B, 0x005B5B5B, 0x005B5B5B, 
        0x005B5B5B, 0x005B5B5B, 0x005B5B5B, 0x005B5B5B, 0x005C5C5C, 0x005D5D5D, 0x005D5D5D, 0x005D5D5D, 0x005D5D5D, 0x005D5D5D, 0x005F5F5F, 0x005E5E5E, 0x005D5D5D, 0x005D5D5D, 0x005D5D5D, 0x005D5D5D, 0x005D5D5D, 0x005D5D5D, 0x005D5D5D, 0x005D5D5D, 
        0x005C5C5C, 0x005B5B5B, 0x005B5B5B, 0x005B5B5B, 0x005B5B5B, 0x005B5B5B, 0x005B5B5B, 0x005A5A5A, 0x005A5A5A, 0x005A5A5A, 0x005A5A5A, 0x00595959, 0x00585858, 0x00575757, 0x00565656, 0x00565656, 0x00BDBDBD, 0x00CECECE, 0x00555555, 0x00545454, 
        0x00535353, 0x00535353, 0x00535353, 0x00525252, 0x00505050, 0x00505050, 0x00505050, 0x004F4F4F, 0x004D4D4D, 0x00C3C3C3, 0x00D6D6D6, 0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 0x004A4A4A, 0x00484848, 0x00484848, 0x00484848, 0x00474747, 0x00464646, 
        0x00454545, 0x00444444, 0x00CACACA, 0x00B6B6B6, 0x00424242, 0x00424242, 0x00424242, 0x00404040, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003C3C3C, 0x003B3B3B, 0x003B3B3B, 0x003A3A3A, 0x00393939, 0x00393939, 0x00363636, 0x00363636, 0x00363636, 
        0x00353535, 0x00343434, 0x00323232, 0x00313131, 0x00313131, 0x00313131, 0x002F2F2F, 0x002E2E2E, 0x002E2E2E, 0x002D2D2D, 0x002C2C2C, 0x002A2A2A, 0x00292929, 0x00292929, 0x00292929, 0x00272727, 0x00262626, 0x00252525, 0x00909090, 0x00CDCDCD, 
        0x007B7B7B, 0x00222222, 0x001F1F1F, 0x00656565, 0x009A9A9A, 0x00969696, 0x00828282, 0x00292929, 0x00181818, 0x00181818, 0x00171717, 0x00161616, 0x00131313, 0x000E0E29, 0x000202B2, 0x00070774, 0x00111111, 0x00111111, 0x00292929, 0x00494949, 
        0x00494949, 0x00494949, 0x00838383, 0x00B3B3B3, 0x00B3B3B3, 0x00B3B3B3, 0x00B3B3B3, 0x00B3B3B3, 0x00B3B3B3, 0x00B3B3B3, 0x00B3B3B3, 0x00B3B3B3, 0xBBB2B2B2, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xEEB1B1B1, 0x22B1B1B1, 0x00B2B2B2, 0x00B2B2B2, 0x00B2B2B2, 0x00B2B2B2, 0x00B2B2B2, 0x00B2B2B2, 0x00B2B2B2, 0x00B2B2B2, 0x00939393, 0x00494949, 0x00494949, 0x00494949, 0x00494949, 0x004F4F4F, 
        0x00505050, 0x002F2F81, 0x000505C3, 0x0042426A, 0x00535353, 0x00535353, 0x00545454, 0x00555555, 0x00555555, 0x00606060, 0x00AAAAAA, 0x00D4D4D4, 0x00B9B9B9, 0x00D4D4D4, 0x00D1D1D1, 0x007F7F7F, 0x00585858, 0x00585858, 0x00595959, 0x005A5A5A, 
        0x005B5B5B, 0x005B5B5B, 0x005B5B5B, 0x005B5B5B, 0x005B5B5B, 0x005C5C5C, 0x005D5D5D, 0x005D5D5D, 0x005C5C5C, 0x005C5C5C, 0x005D5D5D, 0x005C5C5C, 0x005C5C5C, 0x005D5D5D, 0x005D5D5D, 0x005D5D5D, 0x005D5D5D, 0x005C5C5C, 0x005C5C5C, 0x005B5B5B, 
        0x005B5B5B, 0x005B5B5B, 0x005B5B5B, 0x005B5B5B, 0x005A5A5A, 0x005A5A5A, 0x005A5A5A, 0x005A5A5A, 0x005A5A5A, 0x00595959, 0x00585858, 0x00585858, 0x00575757, 0x00565656, 0x00555555, 0x00555555, 0x00ACACAC, 0x00D8D8D8, 0x00656565, 0x00535353, 
        0x00535353, 0x00535353, 0x00535353, 0x00525252, 0x00505050, 0x004F4F4F, 0x004E4E4E, 0x004E4E4E, 0x004D4D4D, 0x00C4C4C4, 0x00D6D6D6, 0x004C4C4C, 0x004B4B4B, 0x004A4A4A, 0x00484848, 0x00484848, 0x00484848, 0x00484848, 0x00474747, 0x00444444, 
        0x00444444, 0x004E4E4E, 0x00D4D4D4, 0x00ADADAD, 0x00424242, 0x00424242, 0x00404040, 0x003F3F3F, 0x003E3E3E, 0x003E3E3E, 0x003D3D3D, 0x003C3C3C, 0x003B3B3B, 0x003B3B3B, 0x003A3A3A, 0x00393939, 0x00393939, 0x00363636, 0x00363636, 0x00363636, 
        0x00343434, 0x00343434, 0x00323232, 0x00313131, 0x00313131, 0x00313131, 0x00303030, 0x002E2E2E, 0x002D2D2D, 0x002D2D2D, 0x002B2B2B, 0x002B2B2B, 0x00292929, 0x00282828, 0x00282828, 0x00252525, 0x00252525, 0x00787878, 0x00CDCDCD, 0x00959595, 
        0x00272727, 0x001F1F1F, 0x005C5C5C, 0x00CDCDCD, 0x00C6C6C6, 0x00A5A5A5, 0x00CCCCCC, 0x00919191, 0x002F2F2F, 0x00181818, 0x00151515, 0x00151515, 0x00131313, 0x00121212, 0x000F0F1D, 0x000202B2, 0x00060680, 0x00111111, 0x00111111, 0x00292929, 
        0x00494949, 0x00494949, 0x00494949, 0x008A8A8A, 0x00B2B2B2, 0x00B2B2B2, 0x00B2B2B2, 0x00B2B2B2, 0x00B2B2B2, 0x00B2B2B2, 0x00B2B2B2, 0x00B2B2B2, 0x11B1B1B1, 0xCCB1B1B1, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x44B0B0B0, 0x00B1B1B1, 0x00B1B1B1, 0x00B1B1B1, 0x00B1B1B1, 0x00B1B1B1, 0x00B1B1B1, 0x00B1B1B1, 0x00B1B1B1, 0x009A9A9A, 0x004A4A4A, 0x004A4A4A, 0x004A4A4A, 0x004A4A4A, 0x004D4D4D, 0x004E4E4E, 
        0x002F2F81, 0x000A0ABA, 0x00454561, 0x00535353, 0x00535353, 0x00535353, 0x00545454, 0x00545454, 0x00555555, 0x00676767, 0x00C1C1C1, 0x00A8A8A8, 0x00616161, 0x00717171, 0x00D9D9D9, 0x00D9D9D9, 0x00747474, 0x00585858, 0x00585858, 0x00595959, 
        0x00595959, 0x005A5A5A, 0x005A5A5A, 0x005A5A5A, 0x005A5A5A, 0x005B5B5B, 0x005C5C5C, 0x005B5B5B, 0x005B5B5B, 0x005B5B5B, 0x005B5B5B, 0x005B5B5B, 0x005B5B5B, 0x005C5C5C, 0x005C5C5C, 0x005C5C5C, 0x005B5B5B, 0x005B5B5B, 0x005B5B5B, 0x005B5B5B, 
        0x005B5B5B, 0x005B5B5B, 0x005A5A5A, 0x005A5A5A, 0x005A5A5A, 0x005A5A5A, 0x00595959, 0x00585858, 0x00585858, 0x00575757, 0x00575757, 0x00575757, 0x00575757, 0x00565656, 0x00555555, 0x00555555, 0x00656565, 0x005C5C5C, 0x00545454, 0x00535353, 
        0x00525252, 0x00515151, 0x00505050, 0x00505050, 0x004E4E4E, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x00C3C3C3, 0x00D6D6D6, 0x004B4B4B, 0x00494949, 0x00494949, 0x00494949, 0x00474747, 0x00464646, 0x00464646, 0x00464646, 0x00454545, 
        0x00444444, 0x00444444, 0x004C4C4C, 0x00555555, 0x00414141, 0x00414141, 0x00404040, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003C3C3C, 0x003B3B3B, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x00393939, 0x00373737, 0x00363636, 0x00363636, 0x00353535, 
        0x00343434, 0x00343434, 0x00333333, 0x00313131, 0x00313131, 0x002F2F2F, 0x002E2E2E, 0x002E2E2E, 0x002D2D2D, 0x002D2D2D, 0x002B2B2B, 0x002B2B2B, 0x00292929, 0x00282828, 0x00272727, 0x00272727, 0x00656565, 0x00CDCDCD, 0x00B7B7B7, 0x00393939, 
        0x00202020, 0x004D4D4D, 0x00CDCDCD, 0x00CDCDCD, 0x004D4D4D, 0x00313131, 0x008B8B8B, 0x00ADADAD, 0x00414141, 0x001B1B1B, 0x00161616, 0x00141414, 0x00131313, 0x00111111, 0x00111111, 0x000F0F1D, 0x00040499, 0x00060680, 0x00111111, 0x00111111, 
        0x00292929, 0x004A4A4A, 0x004A4A4A, 0x004A4A4A, 0x00909090, 0x00B1B1B1, 0x00B1B1B1, 0x00B1B1B1, 0x00B1B1B1, 0x00B1B1B1, 0x00B1B1B1, 0x00B1B1B1, 0x00B1B1B1, 0x22B0B0B0, 0xEEB0B0B0, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0x66B0B0B0, 0x00B1B1B1, 0x00B1B1B1, 0x00B1B1B1, 0x00B1B1B1, 0x00B1B1B1, 0x00B1B1B1, 0x00B1B1B1, 0x00B1B1B1, 0x009B9B9B, 0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 0x004D4D4D, 0x004D4D4D, 0x002E2E7F, 
        0x000A0ABA, 0x004A4A57, 0x00505050, 0x00515151, 0x00505050, 0x00525252, 0x00535353, 0x00545454, 0x00555555, 0x00717171, 0x00BBBBBB, 0x00B4B4B4, 0x005C5C5C, 0x00565656, 0x007B7B7B, 0x00D9D9D9, 0x00D9D9D9, 0x00686868, 0x00585858, 0x00585858, 
        0x00585858, 0x005A5A5A, 0x005A5A5A, 0x005A5A5A, 0x005A5A5A, 0x00595959, 0x005A5A5A, 0x005A5A5A, 0x005A5A5A, 0x005A5A5A, 0x005B5B5B, 0x005B5B5B, 0x005B5B5B, 0x005A5A5A, 0x005B5B5B, 0x005B5B5B, 0x005B5B5B, 0x005B5B5B, 0x005B5B5B, 0x005A5A5A, 
        0x005A5A5A, 0x005A5A5A, 0x005A5A5A, 0x00737373, 0x00A5A5A5, 0x007A7A7A, 0x00575757, 0x00575757, 0x00575757, 0x00575757, 0x00575757, 0x00575757, 0x00565656, 0x00565656, 0x00545454, 0x00545454, 0x00545454, 0x00545454, 0x00535353, 0x00525252, 
        0x00505050, 0x00505050, 0x004F4F4F, 0x004F4F4F, 0x004E4E4E, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x00C3C3C3, 0x00D6D6D6, 0x004B4B4B, 0x004A4A4A, 0x00494949, 0x00484848, 0x00464646, 0x00464646, 0x00464646, 0x00454545, 0x00444444, 
        0x00444444, 0x00444444, 0x00424242, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x003E3E3E, 0x003E3E3E, 0x003D3D3D, 0x003C3C3C, 0x003B3B3B, 0x003B3B3B, 0x003A3A3A, 0x00585858, 0x00939393, 0x00555555, 0x00363636, 0x00353535, 0x00353535, 
        0x00343434, 0x00343434, 0x00333333, 0x00313131, 0x00313131, 0x002F2F2F, 0x002E2E2E, 0x002E2E2E, 0x002D2D2D, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x002A2A2A, 0x00282828, 0x00262626, 0x00565656, 0x00CDCDCD, 0x00CDCDCD, 0x00454545, 0x00222222, 
        0x003F3F3F, 0x00CDCDCD, 0x00CDCDCD, 0x008B8B8B, 0x003C3C3C, 0x00202020, 0x008F8F8F, 0x00ABABAB, 0x00494949, 0x00161616, 0x00151515, 0x00131313, 0x00131313, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00040499, 0x00060680, 0x00111111, 
        0x00111111, 0x002A2A2A, 0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 0x00949494, 0x00B1B1B1, 0x00B1B1B1, 0x00B1B1B1, 0x00B1B1B1, 0x00B1B1B1, 0x00B1B1B1, 0x00B1B1B1, 0x00B1B1B1, 0x44B0B0B0, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0x99AFAFAF, 0x00B0B0B0, 0x00B0B0B0, 0x00B0B0B0, 0x00B0B0B0, 0x00B0B0B0, 0x00B0B0B0, 0x00B0B0B0, 0x00B0B0B0, 0x009E9E9E, 0x004C4C4C, 0x004C4C4C, 0x004C4C4C, 0x004A4A4A, 0x004D4D4D, 0x004D4D4D, 0x002E2E7F, 0x000A0ABA, 
        0x00484856, 0x004E4E4E, 0x004F4F4F, 0x00505050, 0x00505050, 0x00515151, 0x00676767, 0x00646464, 0x00535353, 0x00535353, 0x00989898, 0x00D5D5D5, 0x00999999, 0x00555555, 0x00565656, 0x00888888, 0x00D8D8D8, 0x00BCBCBC, 0x005F5F5F, 0x00585858, 
        0x00575757, 0x00585858, 0x00585858, 0x00585858, 0x00585858, 0x00585858, 0x00585858, 0x005A5A5A, 0x005A5A5A, 0x00595959, 0x00585858, 0x005A5A5A, 0x005A5A5A, 0x005A5A5A, 0x005B5B5B, 0x005B5B5B, 0x005A5A5A, 0x005A5A5A, 0x005A5A5A, 0x005A5A5A, 
        0x00595959, 0x00585858, 0x00585858, 0x007A7A7A, 0x00D9D9D9, 0x00ADADAD, 0x00575757, 0x00575757, 0x00575757, 0x00565656, 0x00565656, 0x00555555, 0x00555555, 0x00555555, 0x00555555, 0x00535353, 0x00535353, 0x00535353, 0x00525252, 0x00515151, 
        0x00505050, 0x00505050, 0x004F4F4F, 0x004F4F4F, 0x004E4E4E, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x00C3C3C3, 0x00D6D6D6, 0x00494949, 0x00494949, 0x00494949, 0x00484848, 0x00474747, 0x00464646, 0x00464646, 0x00444444, 0x00444444, 
        0x00444444, 0x00444444, 0x00424242, 0x00414141, 0x00404040, 0x00404040, 0x003E3E3E, 0x003E3E3E, 0x003D3D3D, 0x003D3D3D, 0x003C3C3C, 0x003B3B3B, 0x003A3A3A, 0x00393939, 0x009E9E9E, 0x00D1D1D1, 0x005F5F5F, 0x00363636, 0x00353535, 0x00343434, 
        0x00343434, 0x00323232, 0x00313131, 0x00313131, 0x00313131, 0x002F2F2F, 0x002E2E2E, 0x002D2D2D, 0x002D2D2D, 0x002B2B2B, 0x002B2B2B, 0x00292929, 0x00292929, 0x00272727, 0x00373737, 0x00CECECE, 0x00CDCDCD, 0x00565656, 0x00232323, 0x00313131, 
        0x00A9A9A9, 0x00CDCDCD, 0x009F9F9F, 0x00AFAFAF, 0x00C4C4C4, 0x00505050, 0x00323232, 0x00696969, 0x00171717, 0x00151515, 0x00282828, 0x002C2C2C, 0x00131313, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00040499, 0x00060680, 
        0x00111111, 0x00111111, 0x002A2A2A, 0x004C4C4C, 0x004C4C4C, 0x004C4C4C, 0x009A9A9A, 0x00B0B0B0, 0x00B0B0B0, 0x00B0B0B0, 0x00B0B0B0, 0x00B0B0B0, 0x00B0B0B0, 0x00B0B0B0, 0x00B0B0B0, 0x77AFAFAF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xCCAEAEAE, 0x00AFAFAF, 0x00AFAFAF, 0x00AFAFAF, 0x00AFAFAF, 0x00AFAFAF, 0x00AFAFAF, 0x00AFAFAF, 0x00AFAFAF, 0x009E9E9E, 0x004C4C4C, 0x004C4C4C, 0x004C4C4C, 0x004A4A4A, 0x00494949, 0x004C4C4C, 0x002E2E7F, 0x000A0ABA, 0x00474755, 
        0x004D4D4D, 0x004E4E4E, 0x004F4F4F, 0x004F4F4F, 0x00575757, 0x00969696, 0x00BABABA, 0x00BBBBBB, 0x00737373, 0x00535353, 0x005B5B5B, 0x00B8B8B8, 0x00D8D8D8, 0x00888888, 0x00555555, 0x00555555, 0x00999999, 0x00D8D8D8, 0x009F9F9F, 0x00575757, 
        0x00575757, 0x00575757, 0x00575757, 0x00575757, 0x00585858, 0x00585858, 0x00585858, 0x00585858, 0x00585858, 0x00585858, 0x00585858, 0x00585858, 0x00595959, 0x00585858, 0x00585858, 0x005A5A5A, 0x005A5A5A, 0x005A5A5A, 0x00595959, 0x00585858, 
        0x00585858, 0x00575757, 0x00575757, 0x00575757, 0x00C7C7C7, 0x00D9D9D9, 0x005F5F5F, 0x00565656, 0x00555555, 0x00555555, 0x00555555, 0x00555555, 0x00555555, 0x00555555, 0x00545454, 0x00535353, 0x00535353, 0x00505050, 0x00505050, 0x00505050, 
        0x00505050, 0x00505050, 0x004E4E4E, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004B4B4B, 0x00C3C3C3, 0x00D6D6D6, 0x00494949, 0x00494949, 0x00484848, 0x00484848, 0x00464646, 0x00454545, 0x00444444, 0x00444444, 0x00444444, 
        0x00444444, 0x00434343, 0x00424242, 0x00404040, 0x00404040, 0x00404040, 0x003E3E3E, 0x003E3E3E, 0x003D3D3D, 0x003B3B3B, 0x003B3B3B, 0x003A3A3A, 0x003A3A3A, 0x00424242, 0x00C7C7C7, 0x00BDBDBD, 0x00363636, 0x00363636, 0x00343434, 0x00343434, 
        0x00343434, 0x00333333, 0x00313131, 0x00313131, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002C2C2C, 0x002B2B2B, 0x002B2B2B, 0x00292929, 0x00272727, 0x00262626, 0x00252525, 0x004E4E4E, 0x00636363, 0x00232323, 0x00222222, 0x00868686, 
        0x00CDCDCD, 0x007F7F7F, 0x002C2C2C, 0x00626262, 0x00C7C7C7, 0x007E7E7E, 0x002C2C2C, 0x00161616, 0x00151515, 0x00464646, 0x008B8B8B, 0x008F8F8F, 0x00737373, 0x001E1E1E, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00040499, 
        0x00060680, 0x00111111, 0x00111111, 0x00323232, 0x004C4C4C, 0x004C4C4C, 0x004C4C4C, 0x009B9B9B, 0x00AFAFAF, 0x00AFAFAF, 0x00AFAFAF, 0x00AFAFAF, 0x00AFAFAF, 0x00AFAFAF, 0x00AFAFAF, 0x00AFAFAF, 0xAAAEAEAE, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xEEAEAEAE, 0x22AEAEAE, 0x00AFAFAF, 0x00AFAFAF, 0x00AFAFAF, 0x00AFAFAF, 0x00AFAFAF, 0x00AFAFAF, 0x00AFAFAF, 0x00A8A8A8, 0x005E5E5E, 0x004D4D4D, 0x004D4D4D, 0x004B4B4B, 0x00484848, 0x004B4B4B, 0x00323276, 0x000505C2, 0x003D3D66, 0x004D4D4D, 
        0x004D4D4D, 0x004D4D4D, 0x004F4F4F, 0x00535353, 0x00909090, 0x00CFCFCF, 0x00C2C2C2, 0x00D7D7D7, 0x00CFCFCF, 0x00676767, 0x00535353, 0x00666666, 0x00D8D8D8, 0x00D8D8D8, 0x007A7A7A, 0x00555555, 0x005E5E5E, 0x00B9B9B9, 0x00B5B5B5, 0x00686868, 
        0x00575757, 0x00575757, 0x00575757, 0x00565656, 0x00575757, 0x00575757, 0x00575757, 0x00585858, 0x00585858, 0x00585858, 0x00585858, 0x00585858, 0x00585858, 0x00585858, 0x00585858, 0x00595959, 0x00585858, 0x00585858, 0x00575757, 0x00575757, 
        0x00575757, 0x00575757, 0x00575757, 0x00575757, 0x009B9B9B, 0x00D8D8D8, 0x00898989, 0x00555555, 0x00555555, 0x00555555, 0x00555555, 0x00545454, 0x00545454, 0x00535353, 0x00535353, 0x00535353, 0x00535353, 0x00515151, 0x00505050, 0x00505050, 
        0x004F4F4F, 0x004F4F4F, 0x004E4E4E, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004B4B4B, 0x00C3C3C3, 0x00D6D6D6, 0x00484848, 0x00484848, 0x00474747, 0x00464646, 0x00454545, 0x00444444, 0x00444444, 0x00444444, 0x00434343, 
        0x00424242, 0x00424242, 0x00424242, 0x00404040, 0x00404040, 0x003F3F3F, 0x003E3E3E, 0x003D3D3D, 0x003C3C3C, 0x003B3B3B, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x006B6B6B, 0x00D2D2D2, 0x00898989, 0x00363636, 0x00353535, 0x00353535, 0x00333333, 
        0x00323232, 0x00313131, 0x00313131, 0x00313131, 0x002F2F2F, 0x002E2E2E, 0x002D2D2D, 0x002D2D2D, 0x002C2C2C, 0x002A2A2A, 0x00292929, 0x00282828, 0x00272727, 0x00272727, 0x00252525, 0x00242424, 0x00242424, 0x00222222, 0x00424242, 0x00A2A2A2, 
        0x00A7A7A7, 0x00313131, 0x001C1C1C, 0x005D5D5D, 0x00C6C6C6, 0x009E9E9E, 0x00282828, 0x00171717, 0x003F3F3F, 0x00BABABA, 0x00C2C2C2, 0x00AFAFAF, 0x00C4C4C4, 0x00858585, 0x00272727, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x000F0F1D, 
        0x000202B2, 0x00070774, 0x00111111, 0x00111111, 0x00383838, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x00A0A0A0, 0x00AFAFAF, 0x00AFAFAF, 0x00AFAFAF, 0x00AFAFAF, 0x00AFAFAF, 0x00AFAFAF, 0x00AFAFAF, 0x11AEAEAE, 0xDDAEAEAE, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0x55ADADAD, 0x00AEAEAE, 0x00AEAEAE, 0x00AEAEAE, 0x00AEAEAE, 0x00AEAEAE, 0x00AEAEAE, 0x00AEAEAE, 0x00AEAEAE, 0x00797979, 0x004E4E4E, 0x004E4E4E, 0x004C4C4C, 0x00474747, 0x00494949, 0x0036366C, 0x000909BA, 0x003C3C65, 0x004C4C4C, 0x004D4D4D, 
        0x004C4C4C, 0x004D4D4D, 0x004D4D4D, 0x00545454, 0x00939393, 0x00D7D7D7, 0x006B6B6B, 0x00818181, 0x00C9C9C9, 0x007D7D7D, 0x005B5B5B, 0x00535353, 0x006F6F6F, 0x00D8D8D8, 0x00D8D8D8, 0x00717171, 0x00737373, 0x00D3D3D3, 0x00B0B0B0, 0x00626262, 
        0x00565656, 0x00565656, 0x00555555, 0x00555555, 0x00565656, 0x00575757, 0x00575757, 0x00575757, 0x00575757, 0x00575757, 0x00585858, 0x00585858, 0x00575757, 0x00575757, 0x00575757, 0x00575757, 0x00575757, 0x00575757, 0x00575757, 0x00575757, 
        0x00575757, 0x00565656, 0x00565656, 0x00555555, 0x006F6F6F, 0x00D8D8D8, 0x00BDBDBD, 0x00555555, 0x00545454, 0x00545454, 0x00535353, 0x00535353, 0x00535353, 0x00535353, 0x00535353, 0x00525252, 0x00515151, 0x00505050, 0x004F4F4F, 0x004F4F4F, 
        0x004F4F4F, 0x004E4E4E, 0x004E4E4E, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004C4C4C, 0x004B4B4B, 0x00C2C2C2, 0x00D6D6D6, 0x00484848, 0x00464646, 0x00464646, 0x00464646, 0x00464646, 0x00444444, 0x00444444, 0x00444444, 0x00424242, 
        0x00424242, 0x00424242, 0x00414141, 0x003F3F3F, 0x003E3E3E, 0x003E3E3E, 0x003C3C3C, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003A3A3A, 0x00393939, 0x00393939, 0x00A9A9A9, 0x00D1D1D1, 0x00555555, 0x00363636, 0x00343434, 0x00343434, 0x00323232, 
        0x00313131, 0x00313131, 0x00313131, 0x002F2F2F, 0x002E2E2E, 0x002D2D2D, 0x002D2D2D, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x00292929, 0x00282828, 0x00262626, 0x00252525, 0x00252525, 0x00242424, 0x00242424, 0x00222222, 0x003A3A3A, 0x009C9C9C, 
        0x00C7C7C7, 0x00525252, 0x004E4E4E, 0x00CCCCCC, 0x00CCCCCC, 0x00474747, 0x00191919, 0x00313131, 0x00B5B5B5, 0x00CBCBCB, 0x005E5E5E, 0x00303030, 0x00818181, 0x00A4A4A4, 0x00404040, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x000F0F1D, 0x000202B2, 0x000A0A5B, 0x00111111, 0x00131313, 0x003E3E3E, 0x004E4E4E, 0x004E4E4E, 0x005F5F5F, 0x00A7A7A7, 0x00AEAEAE, 0x00AEAEAE, 0x00AEAEAE, 0x00AEAEAE, 0x00AEAEAE, 0x00AEAEAE, 0x00AEAEAE, 0x33ADADAD, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x99ACACAC, 
        0x00ADADAD, 0x00ADADAD, 0x00ADADAD, 0x00ADADAD, 0x00ADADAD, 0x00ADADAD, 0x00ADADAD, 0x00ADADAD, 0x00898989, 0x004F4F4F, 0x004F4F4F, 0x004F4F4F, 0x00484848, 0x00484848, 0x00393962, 0x000404C2, 0x0035356B, 0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 
        0x004B4B4B, 0x004C4C4C, 0x004D4D4D, 0x004D4D4D, 0x007E7E7E, 0x00D5D5D5, 0x00B9B9B9, 0x00757575, 0x00D3D3D3, 0x00B2B2B2, 0x00949494, 0x00545454, 0x00515151, 0x00797979, 0x00CBCBCB, 0x00D4D4D4, 0x00D5D5D5, 0x00D8D8D8, 0x00858585, 0x00545454, 
        0x00545454, 0x00555555, 0x00555555, 0x00555555, 0x00555555, 0x00555555, 0x00555555, 0x00565656, 0x00575757, 0x00565656, 0x00575757, 0x00575757, 0x005F5F5F, 0x006F6F6F, 0x00555555, 0x00565656, 0x00575757, 0x00575757, 0x00565656, 0x00565656, 
        0x00555555, 0x00555555, 0x00555555, 0x00555555, 0x00555555, 0x00C6C6C6, 0x00D8D8D8, 0x00646464, 0x00535353, 0x00535353, 0x00535353, 0x00535353, 0x00535353, 0x00525252, 0x00515151, 0x00505050, 0x00505050, 0x00505050, 0x004F4F4F, 0x004E4E4E, 
        0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004C4C4C, 0x004B4B4B, 0x004B4B4B, 0x004A4A4A, 0x00C2C2C2, 0x00D6D6D6, 0x00484848, 0x00464646, 0x00454545, 0x00454545, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00424242, 
        0x00424242, 0x00414141, 0x00404040, 0x003F3F3F, 0x003E3E3E, 0x003D3D3D, 0x003D3D3D, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x00393939, 0x00393939, 0x004C4C4C, 0x00D2D2D2, 0x00BDBDBD, 0x00353535, 0x00353535, 0x00343434, 0x00343434, 0x00323232, 
        0x00313131, 0x00313131, 0x00303030, 0x002E2E2E, 0x002E2E2E, 0x002D2D2D, 0x004D4D4D, 0x00404040, 0x002B2B2B, 0x002A2A2A, 0x00282828, 0x00272727, 0x00262626, 0x00252525, 0x00252525, 0x00242424, 0x00222222, 0x00222222, 0x00202020, 0x00666666, 
        0x00CDCDCD, 0x00C8C8C8, 0x00CACACA, 0x00CCCCCC, 0x00585858, 0x00181818, 0x001F1F1F, 0x00939393, 0x00CBCBCB, 0x006F6F6F, 0x00131313, 0x00131313, 0x00707070, 0x00A6A6A6, 0x004B4B4B, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x000E0E29, 0x000101BE, 0x000C0C42, 0x00111111, 0x001B1B1B, 0x00464646, 0x004F4F4F, 0x004F4F4F, 0x00787878, 0x00ADADAD, 0x00ADADAD, 0x00ADADAD, 0x00ADADAD, 0x00ADADAD, 0x00ADADAD, 0x00ADADAD, 0x00ADADAD, 0x66ACACAC, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xDDACACAC, 0x00ADADAD, 
        0x00ADADAD, 0x00ADADAD, 0x00ADADAD, 0x00ADADAD, 0x00ADADAD, 0x00ADADAD, 0x00ADADAD, 0x00989898, 0x004F4F4F, 0x004F4F4F, 0x004F4F4F, 0x00484848, 0x00464646, 0x0041414E, 0x000909B9, 0x002F2F73, 0x00494949, 0x004A4A4A, 0x004B4B4B, 0x004B4B4B, 
        0x004B4B4B, 0x004B4B4B, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x00898989, 0x00ADADAD, 0x00D7D7D7, 0x00D7D7D7, 0x00C1C1C1, 0x00D7D7D7, 0x00949494, 0x00505050, 0x00505050, 0x00787878, 0x00939393, 0x00A7A7A7, 0x007A7A7A, 0x00545454, 0x00545454, 
        0x00545454, 0x00555555, 0x00545454, 0x00555555, 0x00555555, 0x00555555, 0x00555555, 0x00555555, 0x00565656, 0x00555555, 0x00555555, 0x00666666, 0x00CECECE, 0x00C6C6C6, 0x00555555, 0x00555555, 0x00565656, 0x00555555, 0x00555555, 0x00555555, 
        0x00555555, 0x00555555, 0x00555555, 0x00545454, 0x00535353, 0x00909090, 0x00D8D8D8, 0x009A9A9A, 0x00535353, 0x00535353, 0x00525252, 0x00515151, 0x00505050, 0x00505050, 0x00505050, 0x00505050, 0x00505050, 0x004F4F4F, 0x004E4E4E, 0x004D4D4D, 
        0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004B4B4B, 0x004B4B4B, 0x004A4A4A, 0x00494949, 0x00494949, 0x005A5A5A, 0x00636363, 0x00464646, 0x00454545, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00424242, 0x00414141, 
        0x00414141, 0x00404040, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003D3D3D, 0x003C3C3C, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x00393939, 0x00393939, 0x008A8A8A, 0x00D1D1D1, 0x007E7E7E, 0x00353535, 0x00353535, 0x00343434, 0x00323232, 0x00313131, 
        0x00313131, 0x00313131, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002D2D2D, 0x00B9B9B9, 0x00C3C3C3, 0x00404040, 0x002A2A2A, 0x00282828, 0x00272727, 0x00262626, 0x00252525, 0x00252525, 0x00232323, 0x00222222, 0x00222222, 0x001F1F1F, 0x001F1F1F, 
        0x00595959, 0x008F8F8F, 0x00858585, 0x00606060, 0x001A1A1A, 0x00191919, 0x00787878, 0x00CBCBCB, 0x00878787, 0x00131313, 0x00131313, 0x00585858, 0x00CACACA, 0x00A4A4A4, 0x00262626, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x000D0D36, 0x000101BE, 0x000D0D36, 0x00111111, 0x001D1D1D, 0x004F4F4F, 0x004F4F4F, 0x004F4F4F, 0x008E8E8E, 0x00ADADAD, 0x00ADADAD, 0x00ADADAD, 0x00ADADAD, 0x00ADADAD, 0x00ADADAD, 0x00ADADAD, 0x00ADADAD, 0xBBACACAC, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x33ABABAB, 0x00ACACAC, 
        0x00ACACAC, 0x00ACACAC, 0x00ACACAC, 0x00ACACAC, 0x00ACACAC, 0x00ACACAC, 0x009E9E9E, 0x00505050, 0x00505050, 0x00505050, 0x00484848, 0x00444444, 0x00444444, 0x000D0DB0, 0x0020208C, 0x00484848, 0x00494949, 0x00494949, 0x004A4A4A, 0x00494949, 
        0x004B4B4B, 0x004B4B4B, 0x004C4C4C, 0x004D4D4D, 0x004D4D4D, 0x00505050, 0x00757575, 0x00C0C0C0, 0x00ACACAC, 0x005E5E5E, 0x00BCBCBC, 0x00D8D8D8, 0x00838383, 0x00505050, 0x00505050, 0x00545454, 0x005C5C5C, 0x00535353, 0x00535353, 0x00535353, 
        0x00535353, 0x00535353, 0x00545454, 0x00555555, 0x00555555, 0x00555555, 0x00545454, 0x00535353, 0x00545454, 0x00545454, 0x00545454, 0x00555555, 0x00B5B5B5, 0x00C6C6C6, 0x00656565, 0x00545454, 0x00555555, 0x00555555, 0x00555555, 0x00555555, 
        0x00545454, 0x00545454, 0x00535353, 0x00535353, 0x00535353, 0x00646464, 0x00D8D8D8, 0x00C5C5C5, 0x00515151, 0x00505050, 0x00505050, 0x00505050, 0x00505050, 0x00505050, 0x00505050, 0x004F4F4F, 0x004F4F4F, 0x004F4F4F, 0x004E4E4E, 0x004D4D4D, 
        0x004D4D4D, 0x004D4D4D, 0x004C4C4C, 0x004C4C4C, 0x00494949, 0x00494949, 0x00494949, 0x00494949, 0x00484848, 0x00474747, 0x00464646, 0x00464646, 0x00454545, 0x00444444, 0x00444444, 0x00444444, 0x00434343, 0x00424242, 0x00404040, 0x00404040, 
        0x00404040, 0x00404040, 0x003E3E3E, 0x003E3E3E, 0x003D3D3D, 0x003C3C3C, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003A3A3A, 0x00393939, 0x00393939, 0x00BDBDBD, 0x00D1D1D1, 0x00494949, 0x00353535, 0x00353535, 0x00333333, 0x00313131, 0x00313131, 
        0x00313131, 0x00313131, 0x002F2F2F, 0x002E2E2E, 0x002D2D2D, 0x00414141, 0x00B9B9B9, 0x00A3A3A3, 0x002B2B2B, 0x00292929, 0x00272727, 0x00252525, 0x00252525, 0x00252525, 0x00242424, 0x00222222, 0x00222222, 0x00212121, 0x001F1F1F, 0x001E1E1E, 
        0x001D1D1D, 0x00323232, 0x002A2A2A, 0x001B1B1B, 0x00191919, 0x005C5C5C, 0x00C3C3C3, 0x00A9A9A9, 0x00292929, 0x00131313, 0x00494949, 0x00CBCBCB, 0x00CCCCCC, 0x003B3B3B, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x000B0B4F, 0x000202B2, 0x000F0F1D, 0x00111111, 0x00252525, 0x00505050, 0x00505050, 0x00505050, 0x009A9A9A, 0x00ACACAC, 0x00ACACAC, 0x00ACACAC, 0x00ACACAC, 0x00ACACAC, 0x00ACACAC, 0x00ACACAC, 0x11ABABAB, 
        0xEEABABAB, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x77AAAAAA, 0x00ABABAB, 0x00ABABAB, 
        0x00ABABAB, 0x00ABABAB, 0x00ABABAB, 0x00ABABAB, 0x00ABABAB, 0x00A4A4A4, 0x006E6E6E, 0x00515151, 0x00515151, 0x004B4B4B, 0x00444444, 0x00444444, 0x0016169E, 0x0017179E, 0x00464646, 0x00464646, 0x00474747, 0x00484848, 0x00484848, 0x00494949, 
        0x004A4A4A, 0x004B4B4B, 0x004A4A4A, 0x004B4B4B, 0x004C4C4C, 0x004B4B4B, 0x00595959, 0x00BCBCBC, 0x00D7D7D7, 0x007C7C7C, 0x00656565, 0x00D7D7D7, 0x00B5B5B5, 0x00636363, 0x00505050, 0x00505050, 0x00505050, 0x00505050, 0x00515151, 0x00535353, 
        0x00535353, 0x00535353, 0x00535353, 0x00535353, 0x00535353, 0x00535353, 0x00535353, 0x00535353, 0x00535353, 0x00545454, 0x00535353, 0x00545454, 0x00656565, 0x00545454, 0x00545454, 0x00545454, 0x00545454, 0x00545454, 0x00545454, 0x00535353, 
        0x00535353, 0x00535353, 0x00535353, 0x00535353, 0x00525252, 0x00515151, 0x00BBBBBB, 0x00D8D8D8, 0x00747474, 0x00505050, 0x00505050, 0x00505050, 0x004F4F4F, 0x004F4F4F, 0x004F4F4F, 0x004F4F4F, 0x004E4E4E, 0x004E4E4E, 0x004D4D4D, 0x004D4D4D, 
        0x004C4C4C, 0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 0x004A4A4A, 0x00494949, 0x00484848, 0x00484848, 0x00484848, 0x00474747, 0x00464646, 0x00454545, 0x00444444, 0x00444444, 0x00444444, 0x00424242, 0x00424242, 0x00424242, 0x00414141, 0x00404040, 
        0x00404040, 0x003E3E3E, 0x003E3E3E, 0x003D3D3D, 0x003D3D3D, 0x003C3C3C, 0x003B3B3B, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x00393939, 0x00606060, 0x00D2D2D2, 0x00B1B1B1, 0x00343434, 0x00343434, 0x00343434, 0x00323232, 0x00313131, 0x00313131, 
        0x00313131, 0x002F2F2F, 0x002E2E2E, 0x002E2E2E, 0x002D2D2D, 0x002D2D2D, 0x002B2B2B, 0x00404040, 0x00292929, 0x00282828, 0x00272727, 0x00252525, 0x00252525, 0x00252525, 0x00242424, 0x00232323, 0x00212121, 0x001F1F1F, 0x001F1F1F, 0x001E1E1E, 
        0x001E1E1E, 0x001C1C1C, 0x001C1C1C, 0x001A1A1A, 0x00303030, 0x00878787, 0x00CACACA, 0x003C3C3C, 0x00141414, 0x003A3A3A, 0x00CBCBCB, 0x00CCCCCC, 0x004A4A4A, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00070774, 0x000303A5, 0x00111111, 0x00111111, 0x00313131, 0x00515151, 0x00515151, 0x00616161, 0x00A0A0A0, 0x00ABABAB, 0x00ABABAB, 0x00ABABAB, 0x00ABABAB, 0x00ABABAB, 0x00ABABAB, 0x00ABABAB, 
        0x55AAAAAA, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xCCAAAAAA, 0x00ABABAB, 0x00ABABAB, 0x00ABABAB, 
        0x00ABABAB, 0x00ABABAB, 0x00ABABAB, 0x00ABABAB, 0x00ABABAB, 0x00898989, 0x00525252, 0x00525252, 0x004E4E4E, 0x00424242, 0x00434343, 0x00282879, 0x000909B9, 0x00444444, 0x00444444, 0x00454545, 0x00464646, 0x00484848, 0x00484848, 0x00494949, 
        0x00494949, 0x00494949, 0x00494949, 0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 0x004C4C4C, 0x00676767, 0x00D6D6D6, 0x00D6D6D6, 0x00868686, 0x00CECECE, 0x00B0B0B0, 0x005F5F5F, 0x004F4F4F, 0x004F4F4F, 0x00505050, 0x00505050, 0x00505050, 0x00515151, 
        0x00505050, 0x00525252, 0x00515151, 0x00505050, 0x00525252, 0x00535353, 0x00535353, 0x00535353, 0x00535353, 0x00535353, 0x00535353, 0x00535353, 0x00545454, 0x00535353, 0x00535353, 0x00535353, 0x00535353, 0x00535353, 0x00535353, 0x00535353, 
        0x00535353, 0x00535353, 0x00525252, 0x00515151, 0x00505050, 0x00505050, 0x00868686, 0x00D8D8D8, 0x008E8E8E, 0x004F4F4F, 0x004F4F4F, 0x004F4F4F, 0x004F4F4F, 0x004E4E4E, 0x004E4E4E, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004C4C4C, 
        0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 0x004A4A4A, 0x00494949, 0x00494949, 0x00484848, 0x00484848, 0x00474747, 0x00464646, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00434343, 0x00424242, 0x00414141, 0x00404040, 0x003E3E3E, 
        0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003D3D3D, 0x003D3D3D, 0x003B3B3B, 0x003B3B3B, 0x003A3A3A, 0x003A3A3A, 0x00393939, 0x00383838, 0x00747474, 0x00D1D1D1, 0x00737373, 0x00343434, 0x00343434, 0x00343434, 0x00333333, 0x00313131, 0x00313131, 
        0x00313131, 0x002E2E2E, 0x002E2E2E, 0x002D2D2D, 0x002C2C2C, 0x002B2B2B, 0x002A2A2A, 0x00292929, 0x00282828, 0x00272727, 0x00272727, 0x00252525, 0x00252525, 0x00242424, 0x00222222, 0x00222222, 0x00222222, 0x001F1F1F, 0x001E1E1E, 0x001E1E1E, 
        0x001E1E1E, 0x001C1C1C, 0x001C1C1C, 0x001B1B1B, 0x00272727, 0x00858585, 0x00C0C0C0, 0x00474747, 0x00343434, 0x00AEAEAE, 0x00CBCBCB, 0x005C5C5C, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x0005058D, 0x00060680, 0x00111111, 0x00131313, 0x00414141, 0x00525252, 0x00525252, 0x00797979, 0x00ABABAB, 0x00ABABAB, 0x00ABABAB, 0x00ABABAB, 0x00ABABAB, 0x00ABABAB, 0x00ABABAB, 
        0x00ABABAB, 0xAAAAAAAA, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x33A9A9A9, 0x00AAAAAA, 0x00AAAAAA, 0x00AAAAAA, 
        0x00AAAAAA, 0x00AAAAAA, 0x00AAAAAA, 0x00AAAAAA, 0x00969696, 0x00525252, 0x00525252, 0x00525252, 0x00444444, 0x00424242, 0x0034345D, 0x000404C2, 0x003A3A55, 0x00444444, 0x00444444, 0x00444444, 0x00464646, 0x00484848, 0x00474747, 0x00484848, 
        0x00484848, 0x00484848, 0x00494949, 0x004A4A4A, 0x004B4B4B, 0x004B4B4B, 0x004C4C4C, 0x004D4D4D, 0x00737373, 0x00BCBCBC, 0x00CECECE, 0x00CACACA, 0x00858585, 0x004D4D4D, 0x004F4F4F, 0x004F4F4F, 0x004F4F4F, 0x004F4F4F, 0x004F4F4F, 0x00505050, 
        0x004F4F4F, 0x00505050, 0x00505050, 0x00505050, 0x00515151, 0x00515151, 0x00515151, 0x00535353, 0x00535353, 0x00535353, 0x00525252, 0x00515151, 0x00525252, 0x00525252, 0x00515151, 0x00525252, 0x00535353, 0x00535353, 0x00535353, 0x00525252, 
        0x00515151, 0x00505050, 0x00505050, 0x00505050, 0x00505050, 0x00505050, 0x00595959, 0x00585858, 0x004F4F4F, 0x004F4F4F, 0x004F4F4F, 0x004E4E4E, 0x004E4E4E, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004C4C4C, 
        0x004A4A4A, 0x00494949, 0x00494949, 0x00494949, 0x00494949, 0x00494949, 0x00474747, 0x00464646, 0x00454545, 0x00454545, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00434343, 0x00424242, 0x00404040, 0x00404040, 0x00404040, 0x003E3E3E, 
        0x003E3E3E, 0x003E3E3E, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 0x003C3C3C, 0x003B3B3B, 0x003A3A3A, 0x00393939, 0x00383838, 0x00363636, 0x00363636, 0x003F3F3F, 0x003F3F3F, 0x00343434, 0x00343434, 0x00323232, 0x00313131, 0x00313131, 0x00313131, 
        0x00303030, 0x002E2E2E, 0x002D2D2D, 0x002D2D2D, 0x002B2B2B, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00272727, 0x00262626, 0x00252525, 0x00242424, 0x00242424, 0x00222222, 0x00222222, 0x00212121, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 
        0x001E1E1E, 0x001C1C1C, 0x001B1B1B, 0x00191919, 0x00181818, 0x005F5F5F, 0x00CBCBCB, 0x00CBCBCB, 0x00A7A7A7, 0x00CBCBCB, 0x00707070, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x000F0F1D, 0x000202B2, 0x000B0B4F, 0x00111111, 0x001B1B1B, 0x00525252, 0x00525252, 0x00525252, 0x00919191, 0x00AAAAAA, 0x00AAAAAA, 0x00AAAAAA, 0x00AAAAAA, 0x00AAAAAA, 0x00AAAAAA, 
        0x00AAAAAA, 0x11A9A9A9, 0xEEA9A9A9, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x88A8A8A8, 0x00A9A9A9, 0x00A9A9A9, 0x00A9A9A9, 0x00A9A9A9, 
        0x00A9A9A9, 0x00A9A9A9, 0x00A9A9A9, 0x009F9F9F, 0x00626262, 0x00535353, 0x00535353, 0x00484848, 0x00404040, 0x003D3D4A, 0x000808B8, 0x002D2D70, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00454545, 0x00464646, 0x00464646, 
        0x00484848, 0x00484848, 0x00484848, 0x00484848, 0x00494949, 0x004B4B4B, 0x004B4B4B, 0x004C4C4C, 0x004C4C4C, 0x006A6A6A, 0x00747474, 0x00717171, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004E4E4E, 0x004F4F4F, 0x004F4F4F, 
        0x004F4F4F, 0x004F4F4F, 0x00505050, 0x00505050, 0x00505050, 0x00505050, 0x00505050, 0x00525252, 0x00515151, 0x00505050, 0x00505050, 0x00505050, 0x00505050, 0x00505050, 0x00505050, 0x00515151, 0x00525252, 0x00515151, 0x00505050, 0x00505050, 
        0x00505050, 0x00505050, 0x00505050, 0x00505050, 0x004F4F4F, 0x004F4F4F, 0x004F4F4F, 0x004F4F4F, 0x004E4E4E, 0x004E4E4E, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004C4C4C, 0x004B4B4B, 0x004B4B4B, 
        0x004A4A4A, 0x00494949, 0x00494949, 0x00484848, 0x00484848, 0x00474747, 0x00464646, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00424242, 0x00424242, 0x00424242, 0x00404040, 0x00404040, 0x003F3F3F, 0x003E3E3E, 
        0x003E3E3E, 0x003E3E3E, 0x003D3D3D, 0x003C3C3C, 0x003C3C3C, 0x003B3B3B, 0x00393939, 0x00393939, 0x00393939, 0x00363636, 0x00363636, 0x00363636, 0x00353535, 0x00343434, 0x00343434, 0x00343434, 0x00323232, 0x00313131, 0x00313131, 0x00303030, 
        0x002E2E2E, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002B2B2B, 0x00292929, 0x00292929, 0x00282828, 0x00272727, 0x00262626, 0x00252525, 0x00252525, 0x00242424, 0x00232323, 0x00222222, 0x00222222, 0x00212121, 0x001E1E1E, 0x001D1D1D, 0x001C1C1C, 
        0x001C1C1C, 0x001B1B1B, 0x00191919, 0x00181818, 0x00181818, 0x00161616, 0x005A5A5A, 0x00999999, 0x008B8B8B, 0x00727272, 0x00141414, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x000D0D36, 0x000101BE, 0x000E0E29, 0x00111111, 0x00232323, 0x00535353, 0x00535353, 0x00535353, 0x009C9C9C, 0x00A9A9A9, 0x00A9A9A9, 0x00A9A9A9, 0x00A9A9A9, 0x00A9A9A9, 
        0x00A9A9A9, 0x00A9A9A9, 0x66A8A8A8, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xDDA7A7A7, 0x11A7A7A7, 0x00A8A8A8, 0x00A8A8A8, 0x00A8A8A8, 0x00A8A8A8, 
        0x00A8A8A8, 0x00A8A8A8, 0x00A8A8A8, 0x00797979, 0x00545454, 0x00545454, 0x004D4D4D, 0x00404040, 0x00404040, 0x0015159D, 0x00191993, 0x00424242, 0x00424242, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00464646, 0x00464646, 
        0x00464646, 0x00464646, 0x00484848, 0x00484848, 0x00484848, 0x00494949, 0x00494949, 0x004B4B4B, 0x004B4B4B, 0x004C4C4C, 0x00505050, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004F4F4F, 0x004E4E4E, 
        0x004E4E4E, 0x004D4D4D, 0x004E4E4E, 0x00505050, 0x00505050, 0x00505050, 0x004F4F4F, 0x004F4F4F, 0x00505050, 0x004F4F4F, 0x004F4F4F, 0x00505050, 0x00505050, 0x00505050, 0x00505050, 0x004F4F4F, 0x00505050, 0x00505050, 0x00505050, 0x00505050, 
        0x00505050, 0x004F4F4F, 0x004F4F4F, 0x004F4F4F, 0x004F4F4F, 0x004E4E4E, 0x004E4E4E, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004C4C4C, 0x004C4C4C, 0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 
        0x004A4A4A, 0x00484848, 0x00484848, 0x00474747, 0x00464646, 0x00464646, 0x00464646, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00424242, 0x00424242, 0x00414141, 0x00404040, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 
        0x003E3E3E, 0x003E3E3E, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003A3A3A, 0x00393939, 0x00393939, 0x00393939, 0x00363636, 0x00363636, 0x00353535, 0x00343434, 0x00343434, 0x00343434, 0x00333333, 0x00313131, 0x00313131, 0x00303030, 0x002F2F2F, 
        0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002A2A2A, 0x00292929, 0x00292929, 0x00282828, 0x00272727, 0x00272727, 0x00252525, 0x00252525, 0x00242424, 0x00222222, 0x00222222, 0x00212121, 0x00202020, 0x001E1E1E, 0x001C1C1C, 0x001C1C1C, 
        0x001B1B1B, 0x001A1A1A, 0x00191919, 0x00181818, 0x00181818, 0x00151515, 0x00131313, 0x00313131, 0x001F1F1F, 0x001E1E1E, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x000A0A5B, 0x000303A5, 0x00111111, 0x00111111, 0x00373737, 0x00545454, 0x00545454, 0x006F6F6F, 0x00A2A2A2, 0x00A8A8A8, 0x00A8A8A8, 0x00A8A8A8, 0x00A8A8A8, 
        0x00A8A8A8, 0x00A8A8A8, 0x00A8A8A8, 0xCCA7A7A7, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x55A7A7A7, 0x00A8A8A8, 0x00A8A8A8, 0x00A8A8A8, 0x00A8A8A8, 0x00A8A8A8, 
        0x00A8A8A8, 0x00A8A8A8, 0x00959595, 0x00555555, 0x00555555, 0x00555555, 0x00414141, 0x003F3F3F, 0x0029296D, 0x000C0CAF, 0x00404040, 0x00404040, 0x00424242, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00464646, 0x00464646, 
        0x00464646, 0x00464646, 0x00474747, 0x00484848, 0x00484848, 0x00484848, 0x00494949, 0x004A4A4A, 0x004A4A4A, 0x004A4A4A, 0x004B4B4B, 0x004C4C4C, 0x004B4B4B, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 
        0x004D4D4D, 0x007B7B7B, 0x00B2B2B2, 0x004E4E4E, 0x004F4F4F, 0x004E4E4E, 0x004E4E4E, 0x004D4D4D, 0x004F4F4F, 0x004F4F4F, 0x004F4F4F, 0x00505050, 0x004F4F4F, 0x004F4F4F, 0x004F4F4F, 0x004F4F4F, 0x00505050, 0x00505050, 0x004F4F4F, 0x004F4F4F, 
        0x004F4F4F, 0x004F4F4F, 0x004E4E4E, 0x004E4E4E, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004C4C4C, 0x004C4C4C, 0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 0x004A4A4A, 0x00494949, 
        0x00484848, 0x00484848, 0x00464646, 0x00464646, 0x00464646, 0x00464646, 0x00454545, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00434343, 0x00424242, 0x00404040, 0x00404040, 0x00404040, 0x003E3E3E, 0x003E3E3E, 0x003D3D3D, 
        0x003D3D3D, 0x003C3C3C, 0x003B3B3B, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x00393939, 0x00373737, 0x00363636, 0x00363636, 0x00353535, 0x00353535, 0x00343434, 0x00323232, 0x00313131, 0x00313131, 0x00313131, 0x002F2F2F, 0x002E2E2E, 0x002E2E2E, 
        0x002D2D2D, 0x002C2C2C, 0x002C2C2C, 0x002B2B2B, 0x002A2A2A, 0x00292929, 0x00292929, 0x00282828, 0x00262626, 0x00252525, 0x00252525, 0x00252525, 0x00242424, 0x00222222, 0x00222222, 0x00202020, 0x001E1E1E, 0x009D9D9D, 0x00565656, 0x001C1C1C, 
        0x001B1B1B, 0x001A1A1A, 0x00191919, 0x00181818, 0x00181818, 0x00151515, 0x00131313, 0x00131313, 0x00121212, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x0005058D, 0x00070774, 0x00111111, 0x00141414, 0x004A4A4A, 0x00555555, 0x00555555, 0x00909090, 0x00A8A8A8, 0x00A8A8A8, 0x00A8A8A8, 0x00A8A8A8, 
        0x00A8A8A8, 0x00A8A8A8, 0x00A8A8A8, 0x33A7A7A7, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xBBA6A6A6, 0x00A7A7A7, 0x00A7A7A7, 0x00A7A7A7, 0x00A7A7A7, 0x00A7A7A7, 0x00A7A7A7, 
        0x00A7A7A7, 0x009D9D9D, 0x00636363, 0x00555555, 0x00555555, 0x00454545, 0x003E3E3E, 0x00353550, 0x000404C1, 0x0031315A, 0x00404040, 0x00404040, 0x00424242, 0x00424242, 0x00424242, 0x00434343, 0x00444444, 0x00444444, 0x00454545, 0x00454545, 
        0x00454545, 0x00464646, 0x00464646, 0x00484848, 0x00484848, 0x00484848, 0x00494949, 0x00494949, 0x00494949, 0x00494949, 0x00494949, 0x004B4B4B, 0x004B4B4B, 0x004C4C4C, 0x004C4C4C, 0x004C4C4C, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 
        0x004D4D4D, 0x00A9A9A9, 0x00D6D6D6, 0x00A8A8A8, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004E4E4E, 0x004E4E4E, 0x004D4D4D, 0x004E4E4E, 0x004F4F4F, 0x004F4F4F, 0x004E4E4E, 0x004E4E4E, 0x004D4D4D, 0x004F4F4F, 0x004F4F4F, 0x004F4F4F, 
        0x004E4E4E, 0x004E4E4E, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004C4C4C, 0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 0x004A4A4A, 0x00494949, 0x00484848, 0x00484848, 0x00484848, 
        0x00484848, 0x00484848, 0x00464646, 0x00454545, 0x00454545, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00434343, 0x00424242, 0x00424242, 0x00424242, 0x00424242, 0x00404040, 0x00404040, 0x003F3F3F, 0x003E3E3E, 0x003E3E3E, 0x003C3C3C, 
        0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003A3A3A, 0x00393939, 0x00393939, 0x00393939, 0x00363636, 0x00363636, 0x00363636, 0x00353535, 0x00353535, 0x00343434, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00303030, 0x002E2E2E, 0x002E2E2E, 
        0x002C2C2C, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x002A2A2A, 0x00282828, 0x00272727, 0x00272727, 0x00262626, 0x00252525, 0x00252525, 0x00252525, 0x00232323, 0x00212121, 0x00202020, 0x001E1E1E, 0x00929292, 0x00CDCDCD, 0x00919191, 0x001B1B1B, 
        0x001A1A1A, 0x00181818, 0x00181818, 0x00181818, 0x00181818, 0x00151515, 0x00131313, 0x00131313, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x000F0F1D, 0x000101BE, 0x000D0D36, 0x00111111, 0x00222222, 0x00555555, 0x00555555, 0x00555555, 0x009A9A9A, 0x00A7A7A7, 0x00A7A7A7, 0x00A7A7A7, 
        0x00A7A7A7, 0x00A7A7A7, 0x00A7A7A7, 0x00A7A7A7, 0x99A6A6A6, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x22A5A5A5, 0x00A6A6A6, 0x00A6A6A6, 0x00A6A6A6, 0x00A6A6A6, 0x00A6A6A6, 0x00A6A6A6, 
        0x00A6A6A6, 0x00878787, 0x00565656, 0x00565656, 0x004E4E4E, 0x003C3C3C, 0x003D3D3D, 0x001010A5, 0x0020207F, 0x003E3E3E, 0x003F3F3F, 0x003F3F3F, 0x003F3F3F, 0x00414141, 0x00424242, 0x00424242, 0x00434343, 0x00424242, 0x00444444, 0x00444444, 
        0x00444444, 0x00464646, 0x00454545, 0x00464646, 0x00464646, 0x00464646, 0x00474747, 0x00484848, 0x00484848, 0x00494949, 0x00494949, 0x00494949, 0x004A4A4A, 0x004A4A4A, 0x004B4B4B, 0x004B4B4B, 0x004D4D4D, 0x004C4C4C, 0x004B4B4B, 0x004C4C4C, 
        0x004C4C4C, 0x004D4D4D, 0x00BABABA, 0x00D6D6D6, 0x00969696, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004E4E4E, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004E4E4E, 0x004E4E4E, 0x004D4D4D, 
        0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004C4C4C, 0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 0x00494949, 0x00494949, 0x00484848, 0x00484848, 0x00484848, 0x00484848, 0x00484848, 
        0x00474747, 0x00464646, 0x00464646, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00424242, 0x00424242, 0x00424242, 0x00424242, 0x00414141, 0x00414141, 0x003F3F3F, 0x003E3E3E, 0x003E3E3E, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 
        0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x00363636, 0x00363636, 0x00353535, 0x00343434, 0x00343434, 0x00333333, 0x00313131, 0x00313131, 0x00313131, 0x002F2F2F, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 
        0x002D2D2D, 0x002B2B2B, 0x002B2B2B, 0x00292929, 0x00292929, 0x00282828, 0x00272727, 0x00272727, 0x00252525, 0x00242424, 0x00242424, 0x00232323, 0x00212121, 0x001F1F1F, 0x001F1F1F, 0x007B7B7B, 0x00CDCDCD, 0x00A8A8A8, 0x001C1C1C, 0x001A1A1A, 
        0x001A1A1A, 0x00191919, 0x00181818, 0x00171717, 0x00151515, 0x00141414, 0x00131313, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00484848, 0x00484848, 0x00262626, 0x00151515, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x000C0C42, 0x000202B2, 0x00111111, 0x00111111, 0x00383838, 0x00565656, 0x00565656, 0x006F6F6F, 0x00A6A6A6, 0x00A6A6A6, 0x00A6A6A6, 
        0x00A6A6A6, 0x00A6A6A6, 0x00A6A6A6, 0x00A6A6A6, 0x11A5A5A5, 0xEEA5A5A5, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x99A5A5A5, 0x00A6A6A6, 0x00A6A6A6, 0x00A6A6A6, 0x00A6A6A6, 0x00A6A6A6, 0x00A6A6A6, 0x00A6A6A6, 
        0x00979797, 0x00575757, 0x00575757, 0x00575757, 0x003D3D3D, 0x003B3B3B, 0x00232375, 0x000C0CAE, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x00404040, 0x00424242, 0x00424242, 0x00424242, 0x00424242, 0x00434343, 0x00444444, 
        0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00454545, 0x00464646, 0x00484848, 0x00474747, 0x00484848, 0x00484848, 0x00494949, 0x00494949, 0x00494949, 0x004A4A4A, 0x004A4A4A, 0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 
        0x004B4B4B, 0x004C4C4C, 0x00555555, 0x00C3C3C3, 0x00D6D6D6, 0x00838383, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 
        0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004C4C4C, 0x004C4C4C, 0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 0x004A4A4A, 0x00494949, 0x00484848, 0x00484848, 0x00484848, 0x00484848, 0x00484848, 0x00484848, 0x00474747, 0x00464646, 
        0x00464646, 0x00464646, 0x00464646, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00424242, 0x00414141, 0x00414141, 0x00404040, 0x00404040, 0x003F3F3F, 0x003E3E3E, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 0x003C3C3C, 0x003C3C3C, 
        0x003B3B3B, 0x003A3A3A, 0x003A3A3A, 0x00393939, 0x00393939, 0x00383838, 0x00363636, 0x00363636, 0x00353535, 0x00343434, 0x00343434, 0x00343434, 0x00333333, 0x00313131, 0x00313131, 0x00313131, 0x002F2F2F, 0x002E2E2E, 0x002E2E2E, 0x002D2D2D, 
        0x002C2C2C, 0x002B2B2B, 0x002B2B2B, 0x002A2A2A, 0x00292929, 0x00282828, 0x00272727, 0x00252525, 0x00252525, 0x00242424, 0x00242424, 0x00222222, 0x00222222, 0x001F1F1F, 0x00646464, 0x00CDCDCD, 0x00B4B4B4, 0x00272727, 0x001C1C1C, 0x001B1B1B, 
        0x00191919, 0x00181818, 0x00171717, 0x00161616, 0x00131313, 0x00131313, 0x00131313, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00363636, 0x00B6B6B6, 0x007C7C7C, 0x00505050, 0x00313131, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00060680, 0x00070774, 0x00111111, 0x00181818, 0x004C4C4C, 0x00575757, 0x00575757, 0x00929292, 0x00A6A6A6, 0x00A6A6A6, 
        0x00A6A6A6, 0x00A6A6A6, 0x00A6A6A6, 0x00A6A6A6, 0x00A6A6A6, 0x77A5A5A5, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x22A4A4A4, 0x00A5A5A5, 0x00A5A5A5, 0x00A5A5A5, 0x00A5A5A5, 0x00A5A5A5, 0x00A5A5A5, 0x00A5A5A5, 
        0x00707070, 0x00575757, 0x00575757, 0x00454545, 0x003A3A3A, 0x0032324E, 0x000303C1, 0x00303059, 0x003D3D3D, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x00404040, 0x00414141, 0x00424242, 0x00424242, 0x00424242, 0x00424242, 0x00444444, 
        0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00464646, 0x00464646, 0x00464646, 0x00474747, 0x00484848, 0x00484848, 0x00484848, 0x00494949, 0x00484848, 0x00484848, 0x00484848, 0x00494949, 0x004A4A4A, 0x004B4B4B, 
        0x004B4B4B, 0x004A4A4A, 0x004B4B4B, 0x00676767, 0x00CCCCCC, 0x00D6D6D6, 0x00707070, 0x004C4C4C, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004C4C4C, 0x004B4B4B, 0x004B4B4B, 0x004D4D4D, 0x004D4D4D, 
        0x004C4C4C, 0x004C4C4C, 0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 0x004A4A4A, 0x00494949, 0x00484848, 0x00484848, 0x00484848, 0x00484848, 0x00484848, 0x00484848, 0x00474747, 0x00464646, 0x00464646, 0x00464646, 0x00464646, 
        0x00464646, 0x00454545, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00424242, 0x00424242, 0x00404040, 0x00404040, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003D3D3D, 0x003C3C3C, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 
        0x003B3B3B, 0x00393939, 0x00393939, 0x00393939, 0x00383838, 0x00373737, 0x00353535, 0x00353535, 0x00353535, 0x00343434, 0x00333333, 0x00323232, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x002F2F2F, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 
        0x002D2D2D, 0x002B2B2B, 0x002A2A2A, 0x00292929, 0x00272727, 0x00272727, 0x00252525, 0x00242424, 0x00242424, 0x00242424, 0x00242424, 0x00222222, 0x001F1F1F, 0x004D4D4D, 0x00CDCDCD, 0x00C0C0C0, 0x00404040, 0x001C1C1C, 0x001C1C1C, 0x00191919, 
        0x00181818, 0x00181818, 0x00151515, 0x00151515, 0x00141414, 0x00131313, 0x00121212, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x004E4E4E, 0x00BABABA, 0x00CCCCCC, 0x00C0C0C0, 0x00545454, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x000F0F1D, 0x000101BE, 0x000D0D36, 0x00111111, 0x00282828, 0x00575757, 0x00575757, 0x00656565, 0x009B9B9B, 0x00A5A5A5, 
        0x00A5A5A5, 0x00A5A5A5, 0x00A5A5A5, 0x00A5A5A5, 0x00A5A5A5, 0x00A5A5A5, 0xDDA4A4A4, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x88A3A3A3, 0x00A4A4A4, 0x00A4A4A4, 0x00A4A4A4, 0x00A4A4A4, 0x00A4A4A4, 0x00A4A4A4, 0x00A4A4A4, 0x00919191, 
        0x00585858, 0x00585858, 0x00525252, 0x00393939, 0x003A3A3A, 0x0013139A, 0x001B1B87, 0x003C3C3C, 0x003C3C3C, 0x003D3D3D, 0x003F3F3F, 0x00454545, 0x00424242, 0x003F3F3F, 0x00404040, 0x00404040, 0x00404040, 0x00414141, 0x00404040, 0x00424242, 
        0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00454545, 0x00464646, 0x00464646, 0x00464646, 0x00464646, 0x00464646, 0x00474747, 0x00484848, 0x00484848, 0x00484848, 0x00484848, 0x00484848, 0x00484848, 0x00494949, 
        0x00494949, 0x00494949, 0x004B4B4B, 0x004B4B4B, 0x006F6F6F, 0x00D6D6D6, 0x00CCCCCC, 0x00676767, 0x004D4D4D, 0x004C4C4C, 0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 
        0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 0x004A4A4A, 0x00494949, 0x00484848, 0x00484848, 0x00484848, 0x00484848, 0x00484848, 0x00484848, 0x00474747, 0x00464646, 0x00464646, 0x00464646, 0x00464646, 0x00464646, 0x00454545, 0x00454545, 
        0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00434343, 0x00424242, 0x00424242, 0x00414141, 0x00404040, 0x00404040, 0x00404040, 0x003F3F3F, 0x003E3E3E, 0x003E3E3E, 0x003D3D3D, 0x003D3D3D, 0x003C3C3C, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 
        0x003A3A3A, 0x00393939, 0x00373737, 0x00363636, 0x00363636, 0x00363636, 0x00353535, 0x00343434, 0x00343434, 0x00323232, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x002F2F2F, 0x002E2E2E, 0x002E2E2E, 0x002D2D2D, 0x002D2D2D, 0x002C2C2C, 
        0x002C2C2C, 0x00292929, 0x00282828, 0x00272727, 0x00262626, 0x00252525, 0x00252525, 0x00252525, 0x00232323, 0x00222222, 0x00222222, 0x00212121, 0x00414141, 0x00C0C0C0, 0x00CDCDCD, 0x004A4A4A, 0x001C1C1C, 0x001B1B1B, 0x001A1A1A, 0x00191919, 
        0x00181818, 0x00181818, 0x00161616, 0x00141414, 0x00131313, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00353535, 
        0x00818181, 0x00CCCCCC, 0x00CCCCCC, 0x007F7F7F, 0x00343434, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x000B0B4F, 0x000303A5, 0x00111111, 0x00111111, 0x00454545, 0x00585858, 0x00585858, 0x00878787, 0x00A4A4A4, 
        0x00A4A4A4, 0x00A4A4A4, 0x00A4A4A4, 0x00A4A4A4, 0x00A4A4A4, 0x00A4A4A4, 0x55A3A3A3, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xEEA3A3A3, 0x11A3A3A3, 0x00A4A4A4, 0x00A4A4A4, 0x00A4A4A4, 0x00A4A4A4, 0x00A4A4A4, 0x00A4A4A4, 0x009A9A9A, 0x00656565, 
        0x00595959, 0x00595959, 0x00404040, 0x00393939, 0x0029295F, 0x000707B7, 0x003A3A3A, 0x003B3B3B, 0x003B3B3B, 0x003C3C3C, 0x006D6D6D, 0x00808080, 0x00949494, 0x00676767, 0x003E3E3E, 0x003F3F3F, 0x003E3E3E, 0x00404040, 0x00404040, 0x00414141, 
        0x00424242, 0x00424242, 0x00424242, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00454545, 0x00464646, 0x00454545, 0x00464646, 0x00464646, 0x00464646, 0x00474747, 0x00474747, 0x00474747, 0x00484848, 0x00484848, 0x00484848, 0x00484848, 
        0x00494949, 0x00494949, 0x00494949, 0x00494949, 0x00494949, 0x00828282, 0x00D6D6D6, 0x00C3C3C3, 0x00545454, 0x004B4B4B, 0x004A4A4A, 0x00494949, 0x00494949, 0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 0x004A4A4A, 0x00494949, 0x004A4A4A, 0x004B4B4B, 
        0x004B4B4B, 0x004B4B4B, 0x00494949, 0x00494949, 0x00484848, 0x00484848, 0x00484848, 0x00484848, 0x00484848, 0x00474747, 0x00464646, 0x00464646, 0x00464646, 0x00464646, 0x00464646, 0x00454545, 0x00454545, 0x00444444, 0x00444444, 0x00444444, 
        0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00424242, 0x00414141, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x003E3E3E, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 0x003C3C3C, 0x003B3B3B, 0x003A3A3A, 0x00393939, 
        0x00393939, 0x00393939, 0x00373737, 0x00363636, 0x00363636, 0x00363636, 0x00343434, 0x00343434, 0x00343434, 0x00333333, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x002E2E2E, 0x002E2E2E, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002B2B2B, 
        0x00292929, 0x00292929, 0x00282828, 0x00272727, 0x00272727, 0x00252525, 0x00252525, 0x00242424, 0x00222222, 0x00222222, 0x00222222, 0x002C2C2C, 0x00B5B5B5, 0x00CDCDCD, 0x00636363, 0x001B1B1B, 0x001A1A1A, 0x001A1A1A, 0x001A1A1A, 0x00191919, 
        0x00171717, 0x00161616, 0x00151515, 0x00131313, 0x00131313, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00232323, 0x00676767, 0x00CCCCCC, 
        0x00CCCCCC, 0x00A1A1A1, 0x00454545, 0x00111111, 0x00111111, 0x001E1E1E, 0x00222222, 0x00131313, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00040499, 0x00090967, 0x00111111, 0x001F1F1F, 0x00595959, 0x00595959, 0x00595959, 0x00989898, 
        0x00A4A4A4, 0x00A4A4A4, 0x00A4A4A4, 0x00A4A4A4, 0x00A4A4A4, 0x00A4A4A4, 0x00A4A4A4, 0xCCA3A3A3, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x77A2A2A2, 0x00A3A3A3, 0x00A3A3A3, 0x00A3A3A3, 0x00A3A3A3, 0x00A3A3A3, 0x00A3A3A3, 0x00A3A3A3, 0x008B8B8B, 0x005A5A5A, 
        0x005A5A5A, 0x00505050, 0x00373737, 0x00393939, 0x000707B7, 0x00252569, 0x00393939, 0x003A3A3A, 0x003B3B3B, 0x00616161, 0x00B9B9B9, 0x00C5C5C5, 0x00CECECE, 0x00D0D0D0, 0x009F9F9F, 0x005C5C5C, 0x003E3E3E, 0x003F3F3F, 0x00404040, 0x00404040, 
        0x00414141, 0x00424242, 0x00424242, 0x00434343, 0x00424242, 0x00444444, 0x00434343, 0x00444444, 0x00444444, 0x00444444, 0x00454545, 0x00464646, 0x00454545, 0x00454545, 0x00464646, 0x00464646, 0x00484848, 0x00474747, 0x00464646, 0x00464646, 
        0x00484848, 0x00494949, 0x00494949, 0x00484848, 0x00484848, 0x00494949, 0x00939393, 0x00D6D6D6, 0x00B0B0B0, 0x00494949, 0x00494949, 0x00494949, 0x00494949, 0x00494949, 0x00494949, 0x00494949, 0x00494949, 0x00494949, 0x00484848, 0x004A4A4A, 
        0x00494949, 0x00484848, 0x00484848, 0x00484848, 0x00484848, 0x00484848, 0x00484848, 0x00474747, 0x00464646, 0x00464646, 0x00464646, 0x00464646, 0x00464646, 0x00454545, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 
        0x00444444, 0x00434343, 0x00424242, 0x00424242, 0x00414141, 0x00404040, 0x00404040, 0x00404040, 0x003F3F3F, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003D3D3D, 0x003C3C3C, 0x003C3C3C, 0x003B3B3B, 0x003B3B3B, 0x00393939, 0x00393939, 0x00393939, 
        0x00393939, 0x00393939, 0x00373737, 0x00353535, 0x00353535, 0x00353535, 0x00353535, 0x00343434, 0x00333333, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00303030, 0x002F2F2F, 0x002D2D2D, 0x002D2D2D, 0x002C2C2C, 0x002B2B2B, 0x002A2A2A, 
        0x00292929, 0x00292929, 0x00282828, 0x00262626, 0x00252525, 0x00252525, 0x00252525, 0x00242424, 0x00222222, 0x00222222, 0x00202020, 0x009E9E9E, 0x00CDCDCD, 0x007B7B7B, 0x001D1D1D, 0x001B1B1B, 0x001A1A1A, 0x001A1A1A, 0x00191919, 0x00181818, 
        0x00151515, 0x00151515, 0x00151515, 0x00131313, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00535353, 0x00C5C5C5, 0x00CCCCCC, 0x00CCCCCC, 
        0x00575757, 0x00111111, 0x00111111, 0x00111111, 0x00515151, 0x00A5A5A5, 0x00777777, 0x00545454, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x000D0D36, 0x000101BE, 0x000F0F1D, 0x00111111, 0x00363636, 0x005A5A5A, 0x005A5A5A, 0x00818181, 
        0x00A3A3A3, 0x00A3A3A3, 0x00A3A3A3, 0x00A3A3A3, 0x00A3A3A3, 0x00A3A3A3, 0x00A3A3A3, 0x55A2A2A2, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xEEA1A1A1, 0x11A1A1A1, 0x00A2A2A2, 0x00A2A2A2, 0x00A2A2A2, 0x00A2A2A2, 0x00A2A2A2, 0x00A2A2A2, 0x00969696, 0x005A5A5A, 0x005A5A5A, 
        0x005A5A5A, 0x003C3C3C, 0x00363636, 0x00222273, 0x000F0FA4, 0x00393939, 0x00393939, 0x00393939, 0x003D3D3D, 0x00ABABAB, 0x00D1D1D1, 0x00656565, 0x005E5E5E, 0x00A5A5A5, 0x00D3D3D3, 0x00D4D4D4, 0x00878787, 0x004F4F4F, 0x00404040, 0x00404040, 
        0x00404040, 0x00424242, 0x00424242, 0x00424242, 0x00424242, 0x00424242, 0x00424242, 0x00434343, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00464646, 0x00454545, 0x00464646, 0x00464646, 0x00464646, 0x00464646, 
        0x00474747, 0x00484848, 0x00484848, 0x00474747, 0x00464646, 0x00474747, 0x00484848, 0x009C9C9C, 0x00646464, 0x00484848, 0x00484848, 0x00484848, 0x00484848, 0x00494949, 0x00494949, 0x00484848, 0x00484848, 0x00484848, 0x00484848, 0x00484848, 
        0x00484848, 0x00484848, 0x00484848, 0x00484848, 0x00474747, 0x00464646, 0x00464646, 0x00464646, 0x00464646, 0x00464646, 0x00454545, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00434343, 0x00424242, 
        0x00424242, 0x00424242, 0x00424242, 0x00424242, 0x00414141, 0x003F3F3F, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003C3C3C, 0x003B3B3B, 0x003B3B3B, 0x003A3A3A, 0x003A3A3A, 0x00393939, 0x00393939, 0x00383838, 
        0x00373737, 0x00363636, 0x00363636, 0x00353535, 0x00353535, 0x00343434, 0x00343434, 0x00323232, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00303030, 0x002E2E2E, 0x002D2D2D, 0x002D2D2D, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x002A2A2A, 
        0x00282828, 0x00272727, 0x00272727, 0x00262626, 0x00252525, 0x00252525, 0x00252525, 0x00232323, 0x00212121, 0x00202020, 0x001F1F1F, 0x00414141, 0x00868686, 0x001E1E1E, 0x001D1D1D, 0x001B1B1B, 0x001A1A1A, 0x001A1A1A, 0x00181818, 0x00181818, 
        0x00161616, 0x00141414, 0x00131313, 0x00121212, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x004E4E4E, 0x00CCCCCC, 0x00CCCCCC, 0x006C6C6C, 0x00262626, 
        0x00111111, 0x00111111, 0x00313131, 0x005C5C5C, 0x00B4B4B4, 0x00CACACA, 0x00CACACA, 0x00C2C2C2, 0x002F2F2F, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00070774, 0x00060680, 0x00111111, 0x00181818, 0x005A5A5A, 0x005A5A5A, 0x005A5A5A, 
        0x00939393, 0x00A2A2A2, 0x00A2A2A2, 0x00A2A2A2, 0x00A2A2A2, 0x00A2A2A2, 0x00A2A2A2, 0x00A2A2A2, 0xCCA1A1A1, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x77A1A1A1, 0x00A2A2A2, 0x00A2A2A2, 0x00A2A2A2, 0x00A2A2A2, 0x00A2A2A2, 0x00A2A2A2, 0x00A2A2A2, 0x00868686, 0x005B5B5B, 0x005B5B5B, 
        0x004A4A4A, 0x00353535, 0x0032323F, 0x000303C1, 0x002B2B54, 0x00373737, 0x00383838, 0x00383838, 0x004E4E4E, 0x00A1A1A1, 0x00B2B2B2, 0x00494949, 0x003B3B3B, 0x003B3B3B, 0x006A6A6A, 0x00C7C7C7, 0x00D4D4D4, 0x00D4D4D4, 0x00717171, 0x00404040, 
        0x003F3F3F, 0x00404040, 0x00404040, 0x00414141, 0x00424242, 0x00424242, 0x00424242, 0x00424242, 0x00424242, 0x00444444, 0x00444444, 0x00444444, 0x00747474, 0x009A9A9A, 0x00444444, 0x00444444, 0x00454545, 0x00464646, 0x00464646, 0x00464646, 
        0x00464646, 0x00464646, 0x00464646, 0x00464646, 0x00464646, 0x00464646, 0x00474747, 0x00464646, 0x00464646, 0x00484848, 0x00484848, 0x00484848, 0x00474747, 0x00484848, 0x00484848, 0x00474747, 0x00464646, 0x00464646, 0x00464646, 0x00484848, 
        0x00484848, 0x00474747, 0x00464646, 0x00464646, 0x00464646, 0x00464646, 0x00464646, 0x00454545, 0x00454545, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00434343, 0x00424242, 0x00424242, 0x00424242, 
        0x00424242, 0x00424242, 0x00414141, 0x00404040, 0x00404040, 0x003F3F3F, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003D3D3D, 0x003D3D3D, 0x003C3C3C, 0x003B3B3B, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x00393939, 0x00393939, 0x00363636, 0x00363636, 
        0x00363636, 0x00363636, 0x00363636, 0x00353535, 0x00343434, 0x00343434, 0x00343434, 0x00333333, 0x00313131, 0x00313131, 0x00313131, 0x00303030, 0x002F2F2F, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002B2B2B, 0x002A2A2A, 0x00292929, 0x00292929, 
        0x00282828, 0x00272727, 0x00272727, 0x00262626, 0x00242424, 0x00242424, 0x00232323, 0x00222222, 0x001F1F1F, 0x001F1F1F, 0x001F1F1F, 0x001E1E1E, 0x001C1C1C, 0x001C1C1C, 0x001C1C1C, 0x001B1B1B, 0x001A1A1A, 0x00191919, 0x00181818, 0x00151515, 
        0x00151515, 0x00151515, 0x00131313, 0x00121212, 0x00111111, 0x00111111, 0x00808080, 0x004F4F4F, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00131313, 0x00757575, 0x00393939, 0x00111111, 0x00111111, 
        0x00313131, 0x00757575, 0x009E9E9E, 0x009B9B9B, 0x00949494, 0x003E3E3E, 0x00707070, 0x00BABABA, 0x00585858, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x000F0F1D, 0x000101BE, 0x000D0D36, 0x00111111, 0x00313131, 0x005B5B5B, 0x005B5B5B, 
        0x00717171, 0x00A2A2A2, 0x00A2A2A2, 0x00A2A2A2, 0x00A2A2A2, 0x00A2A2A2, 0x00A2A2A2, 0x00A2A2A2, 0x55A1A1A1, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x11A0A0A0, 0x00A1A1A1, 0x00A1A1A1, 0x00A1A1A1, 0x00A1A1A1, 0x00A1A1A1, 0x00A1A1A1, 0x00959595, 0x005C5C5C, 0x005C5C5C, 0x005C5C5C, 
        0x00393939, 0x00343434, 0x00181884, 0x0015158F, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x003D3D3D, 0x00898989, 0x00C3C3C3, 0x00B6B6B6, 0x00626262, 0x003B3B3B, 0x003B3B3B, 0x00464646, 0x007B7B7B, 0x00D3D3D3, 0x00B3B3B3, 0x005D5D5D, 
        0x003E3E3E, 0x003F3F3F, 0x00404040, 0x00404040, 0x00414141, 0x00404040, 0x00424242, 0x00424242, 0x00424242, 0x00424242, 0x00424242, 0x00434343, 0x00ADADAD, 0x00D5D5D5, 0x00878787, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00454545, 
        0x00444444, 0x00444444, 0x00464646, 0x00464646, 0x00454545, 0x00444444, 0x00454545, 0x00464646, 0x00464646, 0x00464646, 0x00474747, 0x00464646, 0x00464646, 0x00464646, 0x00464646, 0x00464646, 0x00464646, 0x00464646, 0x00464646, 0x00464646, 
        0x00464646, 0x00464646, 0x00464646, 0x00464646, 0x00454545, 0x00454545, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00434343, 0x00424242, 0x00424242, 0x00424242, 0x00424242, 0x00424242, 0x00414141, 
        0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x003F3F3F, 0x003D3D3D, 0x003D3D3D, 0x003C3C3C, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003A3A3A, 0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x00373737, 0x00363636, 
        0x00363636, 0x00353535, 0x00353535, 0x00353535, 0x00343434, 0x00333333, 0x00323232, 0x00313131, 0x00313131, 0x00313131, 0x002F2F2F, 0x002E2E2E, 0x002E2E2E, 0x002D2D2D, 0x002C2C2C, 0x002C2C2C, 0x002A2A2A, 0x00292929, 0x00292929, 0x00292929, 
        0x00282828, 0x00262626, 0x00252525, 0x00252525, 0x00242424, 0x00242424, 0x00222222, 0x00222222, 0x00202020, 0x001E1E1E, 0x001E1E1E, 0x001D1D1D, 0x001C1C1C, 0x001C1C1C, 0x001C1C1C, 0x001A1A1A, 0x00181818, 0x00181818, 0x00181818, 0x00151515, 
        0x00151515, 0x00141414, 0x00111111, 0x00111111, 0x00111111, 0x00676767, 0x00CCCCCC, 0x00A5A5A5, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x001A1A1A, 0x00616161, 
        0x00CCCCCC, 0x00CCCCCC, 0x00BEBEBE, 0x00CCCCCC, 0x007C7C7C, 0x00666666, 0x00CCCCCC, 0x00AFAFAF, 0x00434343, 0x00161616, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x000A0A5B, 0x0005058D, 0x00111111, 0x00141414, 0x00515151, 0x005C5C5C, 
        0x005C5C5C, 0x00939393, 0x00A1A1A1, 0x00A1A1A1, 0x00A1A1A1, 0x00A1A1A1, 0x00A1A1A1, 0x00A1A1A1, 0x00A1A1A1, 0xDDA0A0A0, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x999F9F9F, 0x00A0A0A0, 0x00A0A0A0, 0x00A0A0A0, 0x00A0A0A0, 0x00A0A0A0, 0x00A0A0A0, 0x00A0A0A0, 0x00868686, 0x005D5D5D, 0x005D5D5D, 0x00464646, 
        0x00313131, 0x002C2C47, 0x000303C1, 0x002D2D48, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00383838, 0x004C4C4C, 0x00898989, 0x00D2D2D2, 0x00D2D2D2, 0x00979797, 0x00565656, 0x003B3B3B, 0x00414141, 0x00757575, 0x00C5C5C5, 0x00737373, 
        0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x00404040, 0x00404040, 0x00414141, 0x00414141, 0x00414141, 0x00424242, 0x00424242, 0x00424242, 0x00434343, 0x00999999, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 
        0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00454545, 0x00454545, 0x00454545, 0x00444444, 0x00454545, 0x00444444, 0x00444444, 0x00444444, 0x00464646, 0x00464646, 0x00454545, 0x00444444, 0x00444444, 0x00454545, 
        0x00464646, 0x00464646, 0x00454545, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00434343, 0x00424242, 0x00424242, 0x00424242, 0x00424242, 0x00424242, 0x00414141, 0x00414141, 0x00404040, 0x00404040, 
        0x00404040, 0x00404040, 0x00404040, 0x003F3F3F, 0x003E3E3E, 0x003E3E3E, 0x003C3C3C, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x00383838, 0x00363636, 0x00353535, 
        0x00353535, 0x00353535, 0x00353535, 0x00343434, 0x00323232, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00303030, 0x002D2D2D, 0x002D2D2D, 0x002C2C2C, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x00292929, 0x00292929, 0x00272727, 
        0x00272727, 0x00252525, 0x00252525, 0x00252525, 0x00242424, 0x00242424, 0x00222222, 0x00202020, 0x001F1F1F, 0x001E1E1E, 0x001E1E1E, 0x001D1D1D, 0x001C1C1C, 0x001C1C1C, 0x001A1A1A, 0x001A1A1A, 0x00181818, 0x00181818, 0x00171717, 0x00141414, 
        0x00131313, 0x00131313, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00747474, 0x001D1D1D, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x001B1B1B, 0x00555555, 0x00AFAFAF, 
        0x00CCCCCC, 0x005D5D5D, 0x002C2C2C, 0x00C0C0C0, 0x00CCCCCC, 0x00A7A7A7, 0x00BEBEBE, 0x00575757, 0x00151515, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x000202B2, 0x000C0C42, 0x00111111, 0x002E2E2E, 0x005D5D5D, 
        0x005D5D5D, 0x00717171, 0x00A0A0A0, 0x00A0A0A0, 0x00A0A0A0, 0x00A0A0A0, 0x00A0A0A0, 0x00A0A0A0, 0x00A0A0A0, 0x669F9F9F, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x229E9E9E, 0x009F9F9F, 0x009F9F9F, 0x009F9F9F, 0x009F9F9F, 0x009F9F9F, 0x009F9F9F, 0x00949494, 0x005D5D5D, 0x005D5D5D, 0x005D5D5D, 0x00373737, 
        0x00313131, 0x0014148E, 0x00181884, 0x00343434, 0x00353535, 0x00353535, 0x003C3C3C, 0x00454545, 0x00424242, 0x00393939, 0x00393939, 0x005D5D5D, 0x00ACACAC, 0x00D2D2D2, 0x00D2D2D2, 0x007F7F7F, 0x004D4D4D, 0x00A8A8A8, 0x00D3D3D3, 0x00636363, 
        0x003D3D3D, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003F3F3F, 0x003F3F3F, 0x003F3F3F, 0x00404040, 0x00404040, 0x00424242, 0x00424242, 0x00424242, 0x00424242, 0x00414141, 0x00424242, 0x00434343, 0x00444444, 0x00444444, 0x00434343, 0x00434343, 
        0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 
        0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00434343, 0x00424242, 0x00424242, 0x00424242, 0x00424242, 0x00424242, 0x00424242, 0x00414141, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 
        0x003F3F3F, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003D3D3D, 0x003D3D3D, 0x003C3C3C, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x00383838, 0x00373737, 0x00363636, 0x00363636, 0x00363636, 0x00353535, 
        0x00353535, 0x00343434, 0x00343434, 0x00333333, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00303030, 0x002F2F2F, 0x002E2E2E, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002B2B2B, 0x00292929, 0x00292929, 0x00282828, 0x00282828, 0x00262626, 
        0x00252525, 0x00252525, 0x00252525, 0x00252525, 0x00232323, 0x00222222, 0x00222222, 0x001F1F1F, 0x001F1F1F, 0x001E1E1E, 0x001C1C1C, 0x001C1C1C, 0x001C1C1C, 0x001C1C1C, 0x001B1B1B, 0x00191919, 0x00181818, 0x00171717, 0x00141414, 0x00131313, 
        0x00131313, 0x00131313, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00202020, 0x00797979, 0x00CCCCCC, 
        0x00414141, 0x003F3F3F, 0x00929292, 0x00BFBFBF, 0x007F7F7F, 0x00444444, 0x002A2A2A, 0x00111111, 0x00111111, 0x001F1F1F, 0x00131313, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x000B0B4F, 0x00040499, 0x00111111, 0x00141414, 0x00525252, 
        0x005D5D5D, 0x005D5D5D, 0x00919191, 0x009F9F9F, 0x009F9F9F, 0x009F9F9F, 0x009F9F9F, 0x009F9F9F, 0x009F9F9F, 0x119E9E9E, 0xEE9E9E9E, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xAA9E9E9E, 0x009F9F9F, 0x009F9F9F, 0x009F9F9F, 0x009F9F9F, 0x009F9F9F, 0x009F9F9F, 0x009F9F9F, 0x00868686, 0x005E5E5E, 0x005E5E5E, 0x00474747, 0x00313131, 
        0x002A2A45, 0x000303C0, 0x002D2D3B, 0x00323232, 0x00343434, 0x00353535, 0x00767676, 0x008B8B8B, 0x00ACACAC, 0x00565656, 0x00373737, 0x00363636, 0x00383838, 0x006C6C6C, 0x00D2D2D2, 0x00CBCBCB, 0x00D2D2D2, 0x00C4C4C4, 0x009E9E9E, 0x003C3C3C, 
        0x003D3D3D, 0x003D3D3D, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003F3F3F, 0x003F3F3F, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x00414141, 0x00424242, 0x00424242, 0x00424242, 0x00424242, 0x00424242, 
        0x00444444, 0x00434343, 0x00444444, 0x00444444, 0x00434343, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 
        0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00434343, 0x00424242, 0x00424242, 0x00424242, 0x00424242, 0x00424242, 0x00414141, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x003F3F3F, 0x003E3E3E, 0x003E3E3E, 
        0x003E3E3E, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 0x003C3C3C, 0x003B3B3B, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x00393939, 0x00393939, 0x00393939, 0x00373737, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00353535, 
        0x00343434, 0x00343434, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x002F2F2F, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002D2D2D, 0x002C2C2C, 0x002B2B2B, 0x00292929, 0x00292929, 0x00282828, 0x00272727, 0x00272727, 0x00272727, 
        0x00252525, 0x00252525, 0x00242424, 0x00242424, 0x00222222, 0x00222222, 0x00212121, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001C1C1C, 0x001C1C1C, 0x001B1B1B, 0x001B1B1B, 0x00191919, 0x00171717, 0x00161616, 0x00151515, 0x00131313, 0x00131313, 
        0x00131313, 0x00131313, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00616161, 0x00C5C5C5, 
        0x00A5A5A5, 0x00CCCCCC, 0x00CCCCCC, 0x008F8F8F, 0x00363636, 0x00111111, 0x00111111, 0x002B2B2B, 0x00636363, 0x00747474, 0x00565656, 0x001F1F1F, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x000202B2, 0x000C0C42, 0x00111111, 0x002E2E2E, 
        0x005E5E5E, 0x005E5E5E, 0x007A7A7A, 0x009F9F9F, 0x009F9F9F, 0x009F9F9F, 0x009F9F9F, 0x009F9F9F, 0x009F9F9F, 0x009F9F9F, 0x889E9E9E, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x559D9D9D, 0x009E9E9E, 0x009E9E9E, 0x009E9E9E, 0x009E9E9E, 0x009E9E9E, 0x009E9E9E, 0x00969696, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x00373737, 0x00313131, 
        0x0013138D, 0x00161683, 0x00313131, 0x00313131, 0x00343434, 0x00646464, 0x00C8C8C8, 0x00BDBDBD, 0x00C5C5C5, 0x00414141, 0x00494949, 0x004F4F4F, 0x00373737, 0x00393939, 0x00464646, 0x00757575, 0x008C8C8C, 0x00737373, 0x00535353, 0x003B3B3B, 
        0x003B3B3B, 0x003B3B3B, 0x003D3D3D, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003F3F3F, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x00424242, 0x00424242, 0x00424242, 0x00424242, 
        0x00424242, 0x00424242, 0x00424242, 0x00424242, 0x00424242, 0x00424242, 0x00444444, 0x00434343, 0x00434343, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00434343, 0x00424242, 0x00434343, 0x00444444, 0x00444444, 0x00444444, 0x00434343, 
        0x00434343, 0x00444444, 0x00434343, 0x00424242, 0x00424242, 0x00424242, 0x00424242, 0x00424242, 0x00414141, 0x00414141, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x003F3F3F, 0x003E3E3E, 0x003E3E3E, 0x003D3D3D, 0x003D3D3D, 
        0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 0x003C3C3C, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003A3A3A, 0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x00373737, 0x00363636, 0x00363636, 0x00343434, 0x00343434, 0x00343434, 
        0x00343434, 0x00343434, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x002F2F2F, 0x002E2E2E, 0x002D2D2D, 0x002D2D2D, 0x002C2C2C, 0x002B2B2B, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00272727, 0x00272727, 0x00252525, 
        0x00242424, 0x00242424, 0x00242424, 0x00242424, 0x00222222, 0x001F1F1F, 0x001F1F1F, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001C1C1C, 0x001A1A1A, 0x001A1A1A, 0x00191919, 0x00181818, 0x00151515, 0x00151515, 0x00151515, 0x00131313, 0x00121212, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00212121, 0x00919191, 
        0x00949494, 0x00A7A7A7, 0x004E4E4E, 0x00111111, 0x00111111, 0x00171717, 0x005C5C5C, 0x00CCCCCC, 0x00C0C0C0, 0x00C4C4C4, 0x00B3B3B3, 0x00676767, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x000B0B4F, 0x00040499, 0x00111111, 0x00141414, 
        0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x00929292, 0x009E9E9E, 0x009E9E9E, 0x009E9E9E, 0x009E9E9E, 0x009E9E9E, 0x009E9E9E, 0x229D9D9D, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xDD9C9C9C, 0x009D9D9D, 0x009D9D9D, 0x009D9D9D, 0x009D9D9D, 0x009D9D9D, 0x009D9D9D, 0x009D9D9D, 0x008B8B8B, 0x00606060, 0x00606060, 0x004A4A4A, 0x00313131, 0x002D2D3B, 
        0x000303C0, 0x002A2A45, 0x00313131, 0x00313131, 0x00383838, 0x00AAAAAA, 0x00D2D2D2, 0x005D5D5D, 0x00444444, 0x005B5B5B, 0x00959595, 0x00B7B7B7, 0x008E8E8E, 0x00515151, 0x00393939, 0x00393939, 0x00424242, 0x003C3C3C, 0x003A3A3A, 0x003A3A3A, 
        0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003C3C3C, 0x003C3C3C, 0x003C3C3C, 0x003D3D3D, 0x003D3D3D, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003F3F3F, 0x003E3E3E, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x00414141, 0x00414141, 0x00414141, 
        0x00404040, 0x00404040, 0x00404040, 0x00424242, 0x00424242, 0x00414141, 0x00424242, 0x00424242, 0x00424242, 0x00434343, 0x00434343, 0x00424242, 0x00424242, 0x00424242, 0x00424242, 0x00424242, 0x00434343, 0x00424242, 0x00424242, 0x00414141, 
        0x00414141, 0x00424242, 0x00424242, 0x00424242, 0x00424242, 0x00414141, 0x00414141, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x003F3F3F, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 
        0x003C3C3C, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003A3A3A, 0x003A3A3A, 0x00393939, 0x00393939, 0x00383838, 0x00373737, 0x00363636, 0x00363636, 0x00363636, 0x00353535, 0x00343434, 0x00343434, 0x00343434, 
        0x00333333, 0x00323232, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00303030, 0x002E2E2E, 0x002D2D2D, 0x002C2C2C, 0x002C2C2C, 0x002B2B2B, 0x002B2B2B, 0x00292929, 0x00292929, 0x00282828, 0x00272727, 0x00262626, 0x00252525, 0x00252525, 
        0x00252525, 0x00232323, 0x00222222, 0x00222222, 0x00212121, 0x001F1F1F, 0x001F1F1F, 0x001E1E1E, 0x001E1E1E, 0x001D1D1D, 0x001B1B1B, 0x001A1A1A, 0x001A1A1A, 0x00191919, 0x00181818, 0x00161616, 0x00151515, 0x00141414, 0x00131313, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00232323, 
        0x00333333, 0x001C1C1C, 0x00111111, 0x00111111, 0x004A4A4A, 0x00ABABAB, 0x00CCCCCC, 0x00CCCCCC, 0x00646464, 0x003E3E3E, 0x00CCCCCC, 0x00B5B5B5, 0x002F2F2F, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x000202B2, 0x000D0D36, 0x00111111, 
        0x00333333, 0x00606060, 0x00606060, 0x00858585, 0x009D9D9D, 0x009D9D9D, 0x009D9D9D, 0x009D9D9D, 0x009D9D9D, 0x009D9D9D, 0x009D9D9D, 0xAA9C9C9C, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x779C9C9C, 0x009D9D9D, 0x009D9D9D, 0x009D9D9D, 0x009D9D9D, 0x009D9D9D, 0x009D9D9D, 0x009D9D9D, 0x006A6A6A, 0x00606060, 0x00606060, 0x00393939, 0x002F2F2F, 0x00151582, 
        0x0012128C, 0x00303030, 0x00303030, 0x00313131, 0x00444444, 0x00929292, 0x00B0B0B0, 0x00494949, 0x00373737, 0x00AAAAAA, 0x00CCCCCC, 0x00BEBEBE, 0x00D1D1D1, 0x00D2D2D2, 0x00747474, 0x003F3F3F, 0x00393939, 0x00393939, 0x003A3A3A, 0x003A3A3A, 
        0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003B3B3B, 0x003B3B3B, 0x003D3D3D, 0x003C3C3C, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003F3F3F, 0x003E3E3E, 0x003E3E3E, 0x003F3F3F, 0x003E3E3E, 0x00404040, 
        0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x00414141, 0x00424242, 0x00414141, 0x00414141, 0x00424242, 0x00424242, 0x00424242, 0x00424242, 0x00414141, 0x00404040, 0x00424242, 0x00414141, 0x00404040, 0x00404040, 
        0x00404040, 0x00414141, 0x00424242, 0x00414141, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x003F3F3F, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 0x003C3C3C, 0x003C3C3C, 0x003B3B3B, 
        0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x00393939, 0x00373737, 0x00363636, 0x00363636, 0x00353535, 0x00353535, 0x00353535, 0x00353535, 0x00343434, 0x00323232, 0x00313131, 
        0x00313131, 0x00313131, 0x00313131, 0x00303030, 0x002F2F2F, 0x002E2E2E, 0x002D2D2D, 0x002D2D2D, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x002A2A2A, 0x00292929, 0x00272727, 0x00272727, 0x00272727, 0x00272727, 0x00252525, 0x00252525, 
        0x00242424, 0x00222222, 0x00222222, 0x00222222, 0x00212121, 0x001F1F1F, 0x001E1E1E, 0x001D1D1D, 0x001C1C1C, 0x001C1C1C, 0x001B1B1B, 0x001A1A1A, 0x001A1A1A, 0x00181818, 0x00161616, 0x00151515, 0x00151515, 0x00151515, 0x00131313, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00333333, 0x00818181, 0x00CCCCCC, 0x00CCCCCC, 0x00797979, 0x00313131, 0x00111111, 0x00181818, 0x00707070, 0x00A5A5A5, 0x00444444, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x000A0A5B, 0x0005058D, 0x00111111, 
        0x001D1D1D, 0x00606060, 0x00606060, 0x00606060, 0x00959595, 0x009D9D9D, 0x009D9D9D, 0x009D9D9D, 0x009D9D9D, 0x009D9D9D, 0x009D9D9D, 0x559C9C9C, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x119B9B9B, 0x009C9C9C, 0x009C9C9C, 0x009C9C9C, 0x009C9C9C, 0x009C9C9C, 0x009C9C9C, 0x00909090, 0x00616161, 0x00616161, 0x00535353, 0x002C2C2C, 0x002D2D2D, 0x000303C0, 
        0x0024244D, 0x002E2E2E, 0x002E2E2E, 0x00313131, 0x00363636, 0x00858585, 0x00C7C7C7, 0x00C4C4C4, 0x007C7C7C, 0x00949494, 0x00949494, 0x00434343, 0x006E6E6E, 0x00D1D1D1, 0x00B9B9B9, 0x005E5E5E, 0x003A3A3A, 0x00373737, 0x00393939, 0x00393939, 
        0x00393939, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003C3C3C, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 0x003E3E3E, 0x003D3D3D, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003F3F3F, 
        0x003F3F3F, 0x003E3E3E, 0x003E3E3E, 0x003F3F3F, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x00424242, 0x00414141, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 
        0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x003F3F3F, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 0x003C3C3C, 0x003C3C3C, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 
        0x003B3B3B, 0x003B3B3B, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x00393939, 0x00393939, 0x00393939, 0x00383838, 0x00363636, 0x00353535, 0x00353535, 0x00353535, 0x00353535, 0x00343434, 0x00343434, 0x00333333, 0x00313131, 0x00313131, 
        0x00313131, 0x00313131, 0x00313131, 0x002E2E2E, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002C2C2C, 0x002A2A2A, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00272727, 0x00272727, 0x00262626, 0x00252525, 0x00242424, 0x00242424, 
        0x00242424, 0x00222222, 0x00222222, 0x00202020, 0x001E1E1E, 0x001E1E1E, 0x001D1D1D, 0x001C1C1C, 0x001C1C1C, 0x001C1C1C, 0x001B1B1B, 0x00191919, 0x00181818, 0x00181818, 0x00151515, 0x00151515, 0x00141414, 0x00131313, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00242424, 0x007D7D7D, 0x00BEBEBE, 0x009B9B9B, 0x00414141, 0x00111111, 0x00111111, 0x00262626, 0x006D6D6D, 0x00C5C5C5, 0x008D8D8D, 0x002C2C2C, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x000F0F1D, 0x000101BE, 0x000E0E29, 
        0x00111111, 0x00393939, 0x00616161, 0x00616161, 0x008B8B8B, 0x009C9C9C, 0x009C9C9C, 0x009C9C9C, 0x009C9C9C, 0x009C9C9C, 0x009C9C9C, 0x009C9C9C, 0xEE9B9B9B, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xAB9B9B9B, 0x009B9B9B, 0x009B9B9B, 0x009B9B9B, 0x009B9B9B, 0x009B9B9B, 0x009B9B9B, 0x009B9B9B, 0x007B7B7B, 0x00626262, 0x00626262, 0x003D3D3D, 0x002B2B2B, 0x001D1D61, 0x000F0F96, 
        0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x00303030, 0x00313131, 0x00414141, 0x00808080, 0x00D1D1D1, 0x00D1D1D1, 0x00CDCDCD, 0x00707070, 0x00383838, 0x003C3C3C, 0x006E6E6E, 0x00C4C4C4, 0x00737373, 0x00373737, 0x00363636, 0x00363636, 0x00383838, 
        0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003C3C3C, 0x003B3B3B, 0x003B3B3B, 0x003C3C3C, 0x003D3D3D, 0x003E3E3E, 0x003E3E3E, 0x003D3D3D, 0x003E3E3E, 
        0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x00404040, 0x00404040, 0x003F3F3F, 0x00404040, 0x00404040, 0x003F3F3F, 0x003E3E3E, 0x003F3F3F, 0x00404040, 0x00404040, 0x00404040, 0x003F3F3F, 0x003E3E3E, 
        0x003E3E3E, 0x003E3E3E, 0x00404040, 0x00404040, 0x003F3F3F, 0x003E3E3E, 0x003E3E3E, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 0x003C3C3C, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003A3A3A, 
        0x00313131, 0x002D2D2D, 0x002B2B2B, 0x002A2A2A, 0x002B2B2B, 0x002A2A2A, 0x00292929, 0x00292929, 0x00282828, 0x00282828, 0x00272727, 0x00262626, 0x00262626, 0x00262626, 0x00252525, 0x00252525, 0x00242424, 0x00252525, 0x00252525, 0x00272727, 
        0x00313131, 0x00303030, 0x002F2F2F, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002C2C2C, 0x002B2B2B, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00282828, 0x00262626, 0x00252525, 0x00252525, 0x00252525, 0x00242424, 0x00232323, 
        0x00222222, 0x00212121, 0x00202020, 0x001F1F1F, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001B1B1B, 0x001B1B1B, 0x001A1A1A, 0x001A1A1A, 0x00181818, 0x00181818, 0x00171717, 0x00151515, 0x00131313, 0x00131313, 0x00121212, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00393939, 0x00A4A4A4, 0x00898989, 0x00161616, 0x00111111, 0x00111111, 0x00575757, 0x00CCCCCC, 0x00CCCCCC, 0x00B8B8B8, 0x00484848, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00070774, 0x00070774, 
        0x00111111, 0x00252525, 0x00626262, 0x00626262, 0x006B6B6B, 0x009B9B9B, 0x009B9B9B, 0x009B9B9B, 0x009B9B9B, 0x009B9B9B, 0x009B9B9B, 0x009B9B9B, 0x889A9A9A, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x569B9B9B, 0x009B9B9B, 0x009B9B9B, 0x009B9B9B, 0x009B9B9B, 0x009B9B9B, 0x009B9B9B, 0x00929292, 0x00636363, 0x00636363, 0x00636363, 0x002C2C2C, 0x002B2B2B, 0x000808AB, 0x001D1D61, 
        0x002D2D2D, 0x002D2D2D, 0x002E2E2E, 0x002F2F2F, 0x00303030, 0x00303030, 0x00313131, 0x00535353, 0x009A9A9A, 0x00D1D1D1, 0x00D1D1D1, 0x00868686, 0x00555555, 0x00AEAEAE, 0x00D2D2D2, 0x005B5B5B, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 
        0x00373737, 0x00363636, 0x00393939, 0x00393939, 0x003A3A3A, 0x004D4D4D, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 
        0x003E3E3E, 0x003D3D3D, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003F3F3F, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 
        0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 0x003C3C3C, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x00363636, 0x002F2F2F, 0x002C2C2C, 0x002B2B2B, 
        0x002D2D2D, 0x002C2C2C, 0x002B2B2B, 0x002A2A2A, 0x002A2A2A, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00282828, 0x00282828, 0x00262626, 0x00262626, 0x00262626, 0x00262626, 0x00252525, 0x00252525, 0x00242424, 0x00222222, 0x00212121, 
        0x00202020, 0x00202020, 0x00242424, 0x002B2B2B, 0x002D2D2D, 0x002D2D2D, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x00292929, 0x00282828, 0x00272727, 0x00272727, 0x00272727, 0x00272727, 0x00252525, 0x00252525, 0x00242424, 0x00232323, 0x00222222, 
        0x001F1F1F, 0x001F1F1F, 0x001F1F1F, 0x001F1F1F, 0x001E1E1E, 0x001C1C1C, 0x001C1C1C, 0x001B1B1B, 0x001A1A1A, 0x001A1A1A, 0x00191919, 0x00181818, 0x00151515, 0x00141414, 0x00141414, 0x00131313, 0x00131313, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00292929, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x002C2C2C, 0x00BEBEBE, 0x00CCCCCC, 0x00393939, 0x00484848, 0x00A1A1A1, 0x00CCCCCC, 0x00CCCCCC, 0x00676767, 0x00232323, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x000E0E29, 0x000101BE, 
        0x00111111, 0x00111111, 0x004E4E4E, 0x00636363, 0x00636363, 0x008F8F8F, 0x009B9B9B, 0x009B9B9B, 0x009B9B9B, 0x009B9B9B, 0x009B9B9B, 0x009B9B9B, 0x229A9A9A, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xEF9A9A9A, 0x009A9A9A, 0x009A9A9A, 0x009A9A9A, 0x009A9A9A, 0x009A9A9A, 0x009A9A9A, 0x009A9A9A, 0x008A8A8A, 0x00636363, 0x00636363, 0x00464646, 0x00292929, 0x00202049, 0x000505B5, 0x002B2B2B, 
        0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002E2E2E, 0x002E2E2E, 0x00303030, 0x00313131, 0x00313131, 0x00616161, 0x00BCBCBC, 0x00D1D1D1, 0x00CDCDCD, 0x00BFBFBF, 0x00919191, 0x00353535, 0x00353535, 0x00363636, 0x00353535, 0x00363636, 
        0x00363636, 0x00363636, 0x00373737, 0x00373737, 0x004C4C4C, 0x00D2D2D2, 0x009F9F9F, 0x004D4D4D, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003C3C3C, 0x003D3D3D, 0x003D3D3D, 
        0x003D3D3D, 0x003D3D3D, 0x003E3E3E, 0x003E3E3E, 0x003D3D3D, 0x003D3D3D, 0x003E3E3E, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 0x003E3E3E, 0x003E3E3E, 0x003D3D3D, 0x003D3D3D, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003D3D3D, 
        0x003C3C3C, 0x003C3C3C, 0x003C3C3C, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 0x003C3C3C, 0x003C3C3C, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x00323232, 0x002C2C2C, 0x002F2F2F, 0x002F2F2F, 0x002E2E2E, 0x002D2D2D, 
        0x002D2D2D, 0x002C2C2C, 0x002C2C2C, 0x002B2B2B, 0x002B2B2B, 0x00282828, 0x00282828, 0x00292929, 0x00282828, 0x00282828, 0x00292929, 0x00282828, 0x00272727, 0x00252525, 0x00242424, 0x00252525, 0x00252525, 0x00242424, 0x00242424, 0x00222222, 
        0x00222222, 0x00212121, 0x00212121, 0x00202020, 0x00212121, 0x00252525, 0x002C2C2C, 0x002A2A2A, 0x00292929, 0x00282828, 0x00272727, 0x00272727, 0x00272727, 0x00272727, 0x00252525, 0x00242424, 0x00232323, 0x00222222, 0x00222222, 0x00222222, 
        0x00202020, 0x001F1F1F, 0x001E1E1E, 0x001E1E1E, 0x001D1D1D, 0x001C1C1C, 0x001C1C1C, 0x001B1B1B, 0x00191919, 0x00181818, 0x00171717, 0x00161616, 0x00151515, 0x00131313, 0x00131313, 0x00131313, 0x00131313, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00292929, 0x008D8D8D, 0x00CCCCCC, 0x00292929, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00616161, 0x00BCBCBC, 0x00B1B1B1, 0x00CCCCCC, 0x00CCCCCC, 0x00818181, 0x00353535, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x0005058D, 
        0x000B0B4F, 0x00111111, 0x002C2C2C, 0x00636363, 0x00636363, 0x00808080, 0x009A9A9A, 0x009A9A9A, 0x009A9A9A, 0x009A9A9A, 0x009A9A9A, 0x009A9A9A, 0x009A9A9A, 0xCD9A9A9A, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xAB999999, 0x00999999, 0x00999999, 0x00999999, 0x00999999, 0x00999999, 0x00999999, 0x00999999, 0x006D6D6D, 0x00646464, 0x00646464, 0x00343434, 0x00292929, 0x0010108A, 0x00151574, 0x002A2A2A, 
        0x002C2C2C, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002E2E2E, 0x002E2E2E, 0x002F2F2F, 0x00313131, 0x00313131, 0x00393939, 0x006D6D6D, 0x008F8F8F, 0x00696969, 0x00494949, 0x00343434, 0x00343434, 0x00343434, 0x00353535, 0x00363636, 
        0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00555555, 0x00BDBDBD, 0x00D2D2D2, 0x00D2D2D2, 0x008A8A8A, 0x00434343, 0x00393939, 0x00393939, 0x003A3A3A, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003A3A3A, 0x003B3B3B, 0x003C3C3C, 0x003D3D3D, 
        0x003C3C3C, 0x003C3C3C, 0x003B3B3B, 0x003C3C3C, 0x003B3B3B, 0x003B3B3B, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 0x003C3C3C, 0x003C3C3C, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 0x003C3C3C, 0x003B3B3B, 
        0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003C3C3C, 0x003C3C3C, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003A3A3A, 0x002F2F2F, 0x002D2D2D, 0x00303030, 0x002F2F2F, 0x002F2F2F, 0x002E2E2E, 0x002E2E2E, 0x002D2D2D, 
        0x002A2A2A, 0x002A2A2A, 0x002D2D2D, 0x00303030, 0x00363636, 0x00353535, 0x00353535, 0x00353535, 0x00353535, 0x00353535, 0x00343434, 0x00343434, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00292929, 0x00272727, 0x00242424, 0x00222222, 
        0x00222222, 0x00222222, 0x00222222, 0x00222222, 0x00222222, 0x00222222, 0x001E1E1E, 0x00212121, 0x00292929, 0x00292929, 0x00272727, 0x00272727, 0x00252525, 0x00252525, 0x00252525, 0x00232323, 0x00222222, 0x00222222, 0x00222222, 0x00212121, 
        0x001F1F1F, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001D1D1D, 0x001B1B1B, 0x001A1A1A, 0x001A1A1A, 0x00181818, 0x00181818, 0x00161616, 0x00151515, 0x00151515, 0x00141414, 0x00121212, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x001D1D1D, 0x00747474, 0x00CCCCCC, 0x00CCCCCC, 0x00B2B2B2, 0x00363636, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x001C1C1C, 0x00686868, 0x007E7E7E, 0x008F8F8F, 0x00464646, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x000B0B4F, 
        0x000303A5, 0x00111111, 0x00191919, 0x00646464, 0x00646464, 0x00646464, 0x00929292, 0x00999999, 0x00999999, 0x00999999, 0x00999999, 0x00999999, 0x00999999, 0x78999999, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x56999999, 0x00999999, 0x00999999, 0x00999999, 0x00999999, 0x00999999, 0x00999999, 0x008E8E8E, 0x00656565, 0x00656565, 0x00555555, 0x00282828, 0x00282828, 0x000202C0, 0x00262633, 0x00292929, 
        0x002C2C2C, 0x002D2D2D, 0x002C2C2C, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002E2E2E, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x003A3A3A, 0x00343434, 0x00313131, 0x00323232, 0x00343434, 0x00333333, 0x00343434, 0x00343434, 
        0x00343434, 0x00353535, 0x00353535, 0x00363636, 0x00363636, 0x00363636, 0x00747474, 0x00C6C6C6, 0x00D2D2D2, 0x00BDBDBD, 0x006B6B6B, 0x00393939, 0x00393939, 0x00393939, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003B3B3B, 0x003B3B3B, 
        0x003B3B3B, 0x003B3B3B, 0x003A3A3A, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003C3C3C, 0x003B3B3B, 0x003B3B3B, 0x003C3C3C, 0x003D3D3D, 0x003C3C3C, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 
        0x003B3B3B, 0x003B3B3B, 0x003A3A3A, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003A3A3A, 0x003A3A3A, 0x00313131, 0x002F2F2F, 0x00303030, 0x00303030, 0x002F2F2F, 0x002F2F2F, 0x002E2E2E, 0x002B2B2B, 0x002B2B2B, 0x00303030, 
        0x00363636, 0x00363636, 0x00363636, 0x00353535, 0x00353535, 0x00353535, 0x00353535, 0x00343434, 0x00343434, 0x00343434, 0x00333333, 0x00323232, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00303030, 0x002E2E2E, 0x002E2E2E, 0x002D2D2D, 
        0x00282828, 0x00252525, 0x00202020, 0x00222222, 0x00222222, 0x00222222, 0x00222222, 0x001F1F1F, 0x001D1D1D, 0x00202020, 0x00272727, 0x00262626, 0x00252525, 0x00242424, 0x00242424, 0x00232323, 0x00222222, 0x00212121, 0x001F1F1F, 0x001F1F1F, 
        0x001F1F1F, 0x001E1E1E, 0x001D1D1D, 0x001C1C1C, 0x001C1C1C, 0x001A1A1A, 0x001A1A1A, 0x00191919, 0x00181818, 0x00181818, 0x00171717, 0x00141414, 0x00141414, 0x00131313, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x004F4F4F, 0x00B2B2B2, 0x00CCCCCC, 0x00BEBEBE, 0x005B5B5B, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00151515, 0x00262626, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x000101BE, 0x000E0E29, 0x00111111, 0x00404040, 0x00656565, 0x00656565, 0x008B8B8B, 0x00999999, 0x00999999, 0x00999999, 0x00999999, 0x00999999, 0x00999999, 0x23999999, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xEF989898, 0x00989898, 0x00989898, 0x00989898, 0x00989898, 0x00989898, 0x00989898, 0x00989898, 0x00848484, 0x00666666, 0x00666666, 0x003E3E3E, 0x00262626, 0x0019195D, 0x000C0C94, 0x00292929, 0x00292929, 
        0x00292929, 0x002B2B2B, 0x002A2A2A, 0x002B2B2B, 0x002B2B2B, 0x002C2C2C, 0x002D2D2D, 0x002D2D2D, 0x002F2F2F, 0x002F2F2F, 0x002F2F2F, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00343434, 0x00343434, 
        0x00343434, 0x00343434, 0x00353535, 0x00353535, 0x00353535, 0x00363636, 0x00363636, 0x00414141, 0x00898989, 0x00D2D2D2, 0x00D2D2D2, 0x00B2B2B2, 0x00575757, 0x00393939, 0x00393939, 0x00393939, 0x003A3A3A, 0x00393939, 0x00393939, 0x00393939, 
        0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003B3B3B, 0x003B3B3B, 0x003A3A3A, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003A3A3A, 0x003A3A3A, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 
        0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003B3B3B, 0x003B3B3B, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x00343434, 0x002E2E2E, 0x00323232, 0x00313131, 0x00313131, 0x00303030, 0x002F2F2F, 0x002C2C2C, 0x00303030, 0x00363636, 0x00363636, 0x00363636, 
        0x00353535, 0x00353535, 0x00353535, 0x00353535, 0x00343434, 0x00343434, 0x00343434, 0x00333333, 0x00323232, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00303030, 0x002F2F2F, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002D2D2D, 
        0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x00272727, 0x00222222, 0x00212121, 0x00212121, 0x001F1F1F, 0x001E1E1E, 0x001D1D1D, 0x001C1C1C, 0x00212121, 0x00252525, 0x00242424, 0x00232323, 0x00222222, 0x00222222, 0x00222222, 0x001F1F1F, 0x001E1E1E, 
        0x001E1E1E, 0x001C1C1C, 0x001B1B1B, 0x001B1B1B, 0x001A1A1A, 0x001A1A1A, 0x001A1A1A, 0x00191919, 0x00171717, 0x00161616, 0x00151515, 0x00131313, 0x00131313, 0x00131313, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00363636, 0x00A5A5A5, 0x00CCCCCC, 0x00CCCCCC, 0x00747474, 0x001D1D1D, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00070774, 0x00070774, 0x00111111, 0x00252525, 0x00666666, 0x00666666, 0x007B7B7B, 0x00989898, 0x00989898, 0x00989898, 0x00989898, 0x00989898, 0x00989898, 0x00989898, 0xCD989898, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xAB979797, 0x00979797, 0x00979797, 0x00979797, 0x00979797, 0x00979797, 0x00979797, 0x00979797, 0x006E6E6E, 0x00666666, 0x00666666, 0x002D2D2D, 0x00252525, 0x000C0C94, 0x0019195D, 0x00272727, 0x00272727, 
        0x00282828, 0x00292929, 0x00292929, 0x00292929, 0x002B2B2B, 0x002C2C2C, 0x002C2C2C, 0x002C2C2C, 0x002D2D2D, 0x002E2E2E, 0x002E2E2E, 0x00303030, 0x002F2F2F, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00333333, 0x00343434, 
        0x00333333, 0x00343434, 0x00343434, 0x00343434, 0x00353535, 0x00353535, 0x00363636, 0x00353535, 0x00353535, 0x00555555, 0x00A7A7A7, 0x00D2D2D2, 0x00D2D2D2, 0x009E9E9E, 0x00414141, 0x00373737, 0x00383838, 0x00393939, 0x00393939, 0x00393939, 
        0x003A3A3A, 0x00393939, 0x00393939, 0x00393939, 0x003A3A3A, 0x003A3A3A, 0x00393939, 0x003B3B3B, 0x003A3A3A, 0x00393939, 0x00393939, 0x00393939, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x00393939, 0x00393939, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 
        0x003A3A3A, 0x00393939, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x002F2F2F, 0x00323232, 0x00323232, 0x00323232, 0x00313131, 0x00303030, 0x002C2C2C, 0x00333333, 0x00363636, 0x00363636, 0x00353535, 0x00353535, 0x00353535, 
        0x00353535, 0x00353535, 0x00343434, 0x00343434, 0x00333333, 0x00323232, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 
        0x002C2C2C, 0x002B2B2B, 0x002A2A2A, 0x00292929, 0x00292929, 0x00252525, 0x00212121, 0x001F1F1F, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001C1C1C, 0x00222222, 0x00222222, 0x00222222, 0x00212121, 0x00202020, 0x001E1E1E, 0x001D1D1D, 
        0x001C1C1C, 0x001C1C1C, 0x001A1A1A, 0x001A1A1A, 0x001A1A1A, 0x00191919, 0x00191919, 0x00181818, 0x00151515, 0x00151515, 0x00151515, 0x00131313, 0x00121212, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x008D8D8D, 0x00CCCCCC, 0x00CCCCCC, 0x00999999, 0x00363636, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x000D0D36, 0x000202B2, 0x00111111, 0x00151515, 0x00666666, 0x00666666, 0x00666666, 0x00919191, 0x00979797, 0x00979797, 0x00979797, 0x00979797, 0x00979797, 0x00979797, 0x78979797, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x56969696, 0x00969696, 0x00969696, 0x00969696, 0x00969696, 0x00969696, 0x00969696, 0x008B8B8B, 0x00676767, 0x00676767, 0x00555555, 0x00242424, 0x0022222F, 0x000202C0, 0x0022222F, 0x00262626, 0x00272727, 
        0x00282828, 0x00292929, 0x00292929, 0x00292929, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002E2E2E, 0x002E2E2E, 0x002F2F2F, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 
        0x00313131, 0x00343434, 0x00343434, 0x00333333, 0x00343434, 0x00343434, 0x00353535, 0x00353535, 0x00353535, 0x00363636, 0x00363636, 0x005F5F5F, 0x00BCBCBC, 0x00A7A7A7, 0x00363636, 0x00363636, 0x00363636, 0x00393939, 0x00383838, 0x00373737, 
        0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x003A3A3A, 0x00393939, 0x00393939, 
        0x00393939, 0x00393939, 0x00393939, 0x003A3A3A, 0x00393939, 0x00353535, 0x002F2F2F, 0x00333333, 0x00323232, 0x00313131, 0x00313131, 0x002D2D2D, 0x00323232, 0x00363636, 0x00353535, 0x00353535, 0x00353535, 0x00353535, 0x00353535, 0x00343434, 
        0x00343434, 0x00333333, 0x00323232, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x002E2E2E, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002C2C2C, 
        0x002B2B2B, 0x002B2B2B, 0x002A2A2A, 0x00282828, 0x00272727, 0x00272727, 0x00272727, 0x00252525, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001B1B1B, 0x001F1F1F, 0x00202020, 0x001F1F1F, 0x001E1E1E, 0x001E1E1E, 0x001C1C1C, 
        0x001C1C1C, 0x001C1C1C, 0x001A1A1A, 0x001A1A1A, 0x00191919, 0x00181818, 0x00181818, 0x00181818, 0x00161616, 0x00141414, 0x00131313, 0x00131313, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00999999, 0x00B2B2B2, 0x00424242, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x000202B2, 0x000D0D36, 0x00111111, 0x003C3C3C, 0x00676767, 0x00676767, 0x00898989, 0x00969696, 0x00969696, 0x00969696, 0x00969696, 0x00969696, 0x00969696, 0x34969696, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x12969696, 0x00969696, 0x00969696, 0x00969696, 0x00969696, 0x00969696, 0x00969696, 0x00848484, 0x00686868, 0x00686868, 0x003D3D3D, 0x00232323, 0x0017175A, 0x000B0B93, 0x00252525, 0x00252525, 0x00272727, 
        0x00272727, 0x00272727, 0x00292929, 0x00292929, 0x002A2A2A, 0x002B2B2B, 0x002A2A2A, 0x002B2B2B, 0x002C2C2C, 0x002C2C2C, 0x002D2D2D, 0x002D2D2D, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002F2F2F, 0x002E2E2E, 0x00313131, 0x00313131, 0x00313131, 
        0x00313131, 0x00323232, 0x00313131, 0x00313131, 0x00333333, 0x00343434, 0x00343434, 0x00343434, 0x00353535, 0x00343434, 0x00343434, 0x00343434, 0x00353535, 0x00494949, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 
        0x00383838, 0x00383838, 0x00383838, 0x00393939, 0x00383838, 0x00373737, 0x00373737, 0x00393939, 0x00393939, 0x00383838, 0x00373737, 0x00363636, 0x00393939, 0x00393939, 0x00393939, 0x00383838, 0x00373737, 0x00383838, 0x00393939, 0x00393939, 
        0x00393939, 0x00383838, 0x00383838, 0x00393939, 0x00323232, 0x00303030, 0x00333333, 0x00333333, 0x00333333, 0x002E2E2E, 0x00303030, 0x00363636, 0x00353535, 0x00353535, 0x00353535, 0x00353535, 0x00343434, 0x00343434, 0x00343434, 0x00333333, 
        0x00323232, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00303030, 0x002F2F2F, 0x002E2E2E, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002C2C2C, 0x002C2C2C, 0x002B2B2B, 0x002A2A2A, 
        0x00292929, 0x00292929, 0x00292929, 0x00282828, 0x00272727, 0x00272727, 0x00262626, 0x00252525, 0x00252525, 0x00212121, 0x001E1E1E, 0x001F1F1F, 0x001F1F1F, 0x001D1D1D, 0x001B1B1B, 0x001A1A1A, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001C1C1C, 
        0x001B1B1B, 0x001A1A1A, 0x001A1A1A, 0x001A1A1A, 0x00191919, 0x00181818, 0x00171717, 0x00161616, 0x00151515, 0x00131313, 0x00131313, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00292929, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00070774, 0x00070774, 0x00111111, 0x00262626, 0x00686868, 0x00686868, 0x007B7B7B, 0x00969696, 0x00969696, 0x00969696, 0x00969696, 0x00969696, 0x00969696, 0x00969696, 0xEF969696, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xCD959595, 0x00959595, 0x00959595, 0x00959595, 0x00959595, 0x00959595, 0x00959595, 0x00959595, 0x006F6F6F, 0x00686868, 0x00686868, 0x002A2A2A, 0x00222222, 0x000B0B92, 0x0017175B, 0x00252525, 0x00252525, 0x00252525, 
        0x00252525, 0x00272727, 0x00282828, 0x00282828, 0x00282828, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x002B2B2B, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x00303030, 0x002F2F2F, 0x00303030, 
        0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00323232, 0x00343434, 0x00343434, 0x00343434, 0x00343434, 0x00343434, 0x00343434, 0x00343434, 0x00353535, 0x00353535, 0x00363636, 0x00363636, 0x00363636, 
        0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00373737, 0x00373737, 0x00363636, 0x00363636, 0x00363636, 0x00373737, 0x00383838, 0x00373737, 0x00363636, 0x00363636, 0x00373737, 0x00383838, 0x00373737, 
        0x00363636, 0x00363636, 0x00363636, 0x002F2F2F, 0x00343434, 0x00343434, 0x00343434, 0x00343434, 0x002D2D2D, 0x00353535, 0x00353535, 0x00353535, 0x00353535, 0x00343434, 0x00343434, 0x00343434, 0x00333333, 0x00323232, 0x00313131, 0x00313131, 
        0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00303030, 0x002F2F2F, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002C2C2C, 0x002B2B2B, 0x002B2B2B, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00272727, 0x00252525, 0x00252525, 0x00252525, 0x00252525, 0x00252525, 0x00232323, 0x00222222, 0x001D1D1D, 0x001E1E1E, 0x001D1D1D, 0x001D1D1D, 0x001C1C1C, 0x001A1A1A, 0x001D1D1D, 0x001C1C1C, 0x001B1B1B, 
        0x001A1A1A, 0x001A1A1A, 0x001A1A1A, 0x00191919, 0x00181818, 0x00151515, 0x00151515, 0x00151515, 0x00151515, 0x00131313, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x000D0D36, 0x000202B2, 0x00111111, 0x00151515, 0x00686868, 0x00686868, 0x00686868, 0x00909090, 0x00959595, 0x00959595, 0x00959595, 0x00959595, 0x00959595, 0x00959595, 0x9A959595, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0x78949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x008D8D8D, 0x00696969, 0x00696969, 0x005E5E5E, 0x001F1F1F, 0x001E1E2C, 0x000202BF, 0x0020202E, 0x00242424, 0x00242424, 0x00252525, 
        0x00252525, 0x00252525, 0x00262626, 0x00272727, 0x00272727, 0x00272727, 0x00272727, 0x00292929, 0x00292929, 0x00292929, 0x002B2B2B, 0x002B2B2B, 0x002C2C2C, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 
        0x00313131, 0x00303030, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00333333, 0x00333333, 0x00333333, 0x00343434, 0x00343434, 0x00343434, 0x00343434, 0x00353535, 0x00353535, 0x00353535, 0x00343434, 0x00343434, 
        0x00353535, 0x00353535, 0x00353535, 0x00363636, 0x00363636, 0x00363636, 0x00353535, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00353535, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 
        0x00353535, 0x00353535, 0x002E2E2E, 0x00353535, 0x00353535, 0x00353535, 0x00323232, 0x002E2E2E, 0x00353535, 0x00353535, 0x00353535, 0x00343434, 0x00343434, 0x00333333, 0x00323232, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 
        0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00303030, 0x002F2F2F, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002B2B2B, 0x002B2B2B, 0x002A2A2A, 0x00292929, 0x00292929, 0x00292929, 
        0x00282828, 0x00272727, 0x00272727, 0x00272727, 0x00252525, 0x00252525, 0x00252525, 0x00242424, 0x00242424, 0x00222222, 0x00202020, 0x001F1F1F, 0x001C1C1C, 0x001D1D1D, 0x001E1E1E, 0x001D1D1D, 0x001C1C1C, 0x00191919, 0x001C1C1C, 0x001C1C1C, 
        0x00191919, 0x00191919, 0x00181818, 0x00181818, 0x00181818, 0x00161616, 0x00141414, 0x00141414, 0x00131313, 0x00121212, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x000202B2, 0x000D0D36, 0x00111111, 0x00434343, 0x00696969, 0x00696969, 0x008A8A8A, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x56949494, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0x45949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00878787, 0x006A6A6A, 0x006A6A6A, 0x003F3F3F, 0x001F1F1F, 0x00151558, 0x0009099E, 0x00222222, 0x00242424, 0x00242424, 0x00242424, 
        0x00252525, 0x00252525, 0x00252525, 0x00272727, 0x00272727, 0x00272727, 0x00272727, 0x00282828, 0x00292929, 0x00292929, 0x00292929, 0x002B2B2B, 0x002B2B2B, 0x002C2C2C, 0x002B2B2B, 0x002D2D2D, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 
        0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x00303030, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00343434, 0x00333333, 0x00323232, 0x00313131, 0x00333333, 0x00343434, 0x00343434, 0x00343434, 0x00343434, 
        0x00343434, 0x00343434, 0x00343434, 0x00343434, 0x00353535, 0x00353535, 0x00353535, 0x00353535, 0x00363636, 0x00353535, 0x00353535, 0x00353535, 0x00353535, 0x00363636, 0x00363636, 0x00353535, 0x00353535, 0x00363636, 0x00353535, 0x00353535, 
        0x00353535, 0x002E2E2E, 0x00353535, 0x00353535, 0x00363636, 0x00303030, 0x00313131, 0x00353535, 0x00343434, 0x00343434, 0x00333333, 0x00323232, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 
        0x00313131, 0x00313131, 0x00303030, 0x002F2F2F, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002C2C2C, 0x002C2C2C, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x002A2A2A, 0x00282828, 0x00272727, 0x00272727, 
        0x00272727, 0x00272727, 0x00272727, 0x00272727, 0x00252525, 0x00242424, 0x00232323, 0x00222222, 0x00222222, 0x00222222, 0x00212121, 0x001F1F1F, 0x001E1E1E, 0x001B1B1B, 0x001B1B1B, 0x001F1F1F, 0x001F1F1F, 0x001C1C1C, 0x00181818, 0x001A1A1A, 
        0x00191919, 0x00181818, 0x00181818, 0x00171717, 0x00161616, 0x00141414, 0x00131313, 0x00121212, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00060680, 0x00090967, 0x00111111, 0x002E2E2E, 0x006A6A6A, 0x006A6A6A, 0x00838383, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x12949494, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0x00939393, 0x00939393, 0x00939393, 0x00939393, 0x00939393, 0x00939393, 0x00939393, 0x007C7C7C, 0x006B6B6B, 0x006B6B6B, 0x00313131, 0x001F1F1F, 0x000C0C86, 0x0011116F, 0x00202020, 0x00212121, 0x00222222, 0x00222222, 
        0x00232323, 0x00242424, 0x00252525, 0x00262626, 0x00262626, 0x00262626, 0x00272727, 0x00272727, 0x00292929, 0x00292929, 0x00292929, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x002C2C2C, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 
        0x002D2D2D, 0x002E2E2E, 0x002E2E2E, 0x002F2F2F, 0x00303030, 0x002F2F2F, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00323232, 0x00343434, 0x00333333, 0x00323232, 
        0x00323232, 0x00343434, 0x00343434, 0x00343434, 0x00343434, 0x00343434, 0x00343434, 0x00343434, 0x00343434, 0x00353535, 0x00343434, 0x00343434, 0x00353535, 0x00343434, 0x00343434, 0x00343434, 0x00343434, 0x00353535, 0x00353535, 0x00343434, 
        0x002E2E2E, 0x00363636, 0x00363636, 0x00363636, 0x00313131, 0x00313131, 0x00343434, 0x00343434, 0x00333333, 0x00323232, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00303030, 
        0x002F2F2F, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002D2D2D, 0x002D2D2D, 0x002C2C2C, 0x002C2C2C, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x002A2A2A, 0x00292929, 0x00292929, 0x00282828, 0x00272727, 0x00272727, 
        0x00272727, 0x00262626, 0x00252525, 0x00252525, 0x00242424, 0x00222222, 0x00222222, 0x00222222, 0x00222222, 0x00212121, 0x00202020, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001B1B1B, 0x001E1E1E, 0x001D1D1D, 0x001D1D1D, 0x00181818, 
        0x00191919, 0x00181818, 0x00181818, 0x00151515, 0x00141414, 0x00131313, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x001E1E1E, 0x00363636, 0x003E3E3E, 0x001F1F1F, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x000C0C42, 0x00040499, 0x00111111, 0x001F1F1F, 0x006B6B6B, 0x006B6B6B, 0x00717171, 0x00939393, 0x00939393, 0x00939393, 0x00939393, 0x00939393, 0x00939393, 0x00939393, 0xCD939393, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xBC929292, 0x00929292, 0x00929292, 0x00929292, 0x00929292, 0x00929292, 0x00929292, 0x008D8D8D, 0x006B6B6B, 0x006B6B6B, 0x006B6B6B, 0x00212121, 0x001E1E1E, 0x000303B4, 0x00171740, 0x001F1F1F, 0x001F1F1F, 0x00202020, 0x00222222, 
        0x00222222, 0x00232323, 0x00232323, 0x00242424, 0x00252525, 0x00252525, 0x00272727, 0x00272727, 0x00272727, 0x00272727, 0x00282828, 0x002A2A2A, 0x002A2A2A, 0x002A2A2A, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x004D4D4D, 
        0x004D4D4D, 0x002D2D2D, 0x002D2D2D, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x00303030, 0x00303030, 0x00303030, 0x00313131, 0x00303030, 0x00303030, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00323232, 0x00313131, 0x00313131, 
        0x00313131, 0x00333333, 0x00333333, 0x00323232, 0x00333333, 0x00343434, 0x00343434, 0x00333333, 0x00333333, 0x00343434, 0x00333333, 0x00333333, 0x00343434, 0x00343434, 0x00343434, 0x00343434, 0x00333333, 0x00343434, 0x00343434, 0x002E2E2E, 
        0x00373737, 0x00373737, 0x00373737, 0x002E2E2E, 0x00323232, 0x00333333, 0x00323232, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00303030, 0x002F2F2F, 0x002E2E2E, 
        0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002C2C2C, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x002A2A2A, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00282828, 0x00262626, 0x00252525, 
        0x00252525, 0x00252525, 0x00242424, 0x00242424, 0x00242424, 0x00222222, 0x00212121, 0x00202020, 0x001F1F1F, 0x001F1F1F, 0x001F1F1F, 0x001E1E1E, 0x001D1D1D, 0x001C1C1C, 0x001C1C1C, 0x001C1C1C, 0x001A1A1A, 0x001E1E1E, 0x001D1D1D, 0x001C1C1C, 
        0x00171717, 0x00171717, 0x00161616, 0x00131313, 0x00131313, 0x00131313, 0x00121212, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00363636, 
        0x00363636, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00131313, 0x00202020, 0x00121212, 0x00111111, 0x00111111, 0x00111111, 0x00949494, 0x00CCCCCC, 0x00A0A0A0, 0x006A6A6A, 0x00282828, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x000000CC, 0x000F0F1D, 0x00111111, 0x00545454, 0x006B6B6B, 0x006B6B6B, 0x008B8B8B, 0x00929292, 0x00929292, 0x00929292, 0x00929292, 0x00929292, 0x00929292, 0x9A929292, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0x89929292, 0x00929292, 0x00929292, 0x00929292, 0x00929292, 0x00929292, 0x00929292, 0x008A8A8A, 0x006C6C6C, 0x006C6C6C, 0x00505050, 0x001D1D1D, 0x00191934, 0x000101BF, 0x001E1E1E, 0x001F1F1F, 0x001F1F1F, 0x001F1F1F, 0x00222222, 
        0x00222222, 0x00222222, 0x00222222, 0x00242424, 0x00252525, 0x00242424, 0x00252525, 0x00252525, 0x00262626, 0x00272727, 0x00272727, 0x00282828, 0x00292929, 0x00282828, 0x00292929, 0x00292929, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x00989898, 
        0x00CFCFCF, 0x00989898, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x00313131, 0x00303030, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 
        0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00323232, 0x00333333, 0x00323232, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00333333, 0x00333333, 0x00323232, 0x00313131, 0x00313131, 0x00323232, 0x002F2F2F, 0x00383838, 
        0x00373737, 0x00363636, 0x002F2F2F, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00303030, 0x002F2F2F, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 
        0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002C2C2C, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x002A2A2A, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00282828, 0x00272727, 0x00272727, 0x00252525, 0x00242424, 
        0x00242424, 0x00242424, 0x00242424, 0x00232323, 0x00232323, 0x00202020, 0x001F1F1F, 0x001F1F1F, 0x001F1F1F, 0x001E1E1E, 0x001E1E1E, 0x001D1D1D, 0x001C1C1C, 0x001C1C1C, 0x001C1C1C, 0x001B1B1B, 0x001B1B1B, 0x001A1A1A, 0x001E1E1E, 0x001C1C1C, 
        0x001B1B1B, 0x00141414, 0x00151515, 0x00141414, 0x00121212, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x008D8D8D, 0x00CCCCCC, 
        0x008D8D8D, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00636363, 0x00949494, 0x006A6A6A, 0x00494949, 0x00363636, 0x001C1C1C, 0x00111111, 0x00686868, 0x00868686, 0x009B9B9B, 0x00BCBCBC, 0x00464646, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00040499, 0x000C0C42, 0x00111111, 0x00393939, 0x006C6C6C, 0x006C6C6C, 0x00878787, 0x00929292, 0x00929292, 0x00929292, 0x00929292, 0x00929292, 0x00929292, 0x56929292, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0x45919191, 0x00919191, 0x00919191, 0x00919191, 0x00919191, 0x00919191, 0x00919191, 0x00868686, 0x006D6D6D, 0x006D6D6D, 0x003A3A3A, 0x001C1C1C, 0x00101062, 0x00090991, 0x001D1D1D, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x00212121, 
        0x00222222, 0x00222222, 0x00222222, 0x00232323, 0x00242424, 0x00242424, 0x00242424, 0x00252525, 0x00252525, 0x00252525, 0x00252525, 0x00262626, 0x00272727, 0x00272727, 0x00282828, 0x00292929, 0x00292929, 0x002A2A2A, 0x002B2B2B, 0x004B4B4B, 
        0x00828282, 0x00565656, 0x002C2C2C, 0x002C2C2C, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x00303030, 0x00313131, 0x00303030, 0x00303030, 0x00313131, 0x00313131, 
        0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x002F2F2F, 0x00333333, 0x00383838, 
        0x00373737, 0x00323232, 0x002E2E2E, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00303030, 0x002F2F2F, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 
        0x002C2C2C, 0x002C2C2C, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x002A2A2A, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00282828, 0x00272727, 0x00272727, 0x00272727, 0x00262626, 0x00252525, 0x00252525, 0x00242424, 
        0x00242424, 0x00232323, 0x00222222, 0x00222222, 0x00222222, 0x00212121, 0x001F1F1F, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001C1C1C, 0x001B1B1B, 0x001A1A1A, 0x00191919, 0x00191919, 0x00181818, 0x00191919, 0x001D1D1D, 
        0x001D1D1D, 0x001A1A1A, 0x00131313, 0x00131313, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00424242, 0x00808080, 
        0x00363636, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00616161, 0x00CCCCCC, 0x00B8B8B8, 0x00A1A1A1, 0x008C8C8C, 0x00707070, 0x00545454, 0x002E2E2E, 0x002E2E2E, 0x006B6B6B, 0x00B6B6B6, 0x00545454, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00090967, 0x00070774, 0x00111111, 0x002C2C2C, 0x006D6D6D, 0x006D6D6D, 0x00808080, 0x00919191, 0x00919191, 0x00919191, 0x00919191, 0x00919191, 0x00919191, 0x23919191, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0x12909090, 0x00909090, 0x00909090, 0x00909090, 0x00909090, 0x00909090, 0x00909090, 0x007F7F7F, 0x006E6E6E, 0x006E6E6E, 0x002E2E2E, 0x001B1B1B, 0x000A0A84, 0x00101062, 0x001C1C1C, 0x001D1D1D, 0x001E1E1E, 0x001E1E1E, 0x001F1F1F, 
        0x001F1F1F, 0x00202020, 0x00222222, 0x00222222, 0x00232323, 0x00242424, 0x00242424, 0x00252525, 0x00252525, 0x00252525, 0x00252525, 0x00252525, 0x00272727, 0x00272727, 0x00272727, 0x00272727, 0x00282828, 0x00292929, 0x002B2B2B, 0x002A2A2A, 
        0x002B2B2B, 0x002B2B2B, 0x002A2A2A, 0x00292929, 0x002A2A2A, 0x002C2C2C, 0x002D2D2D, 0x002D2D2D, 0x002C2C2C, 0x002C2C2C, 0x002D2D2D, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002D2D2D, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x00313131, 0x00303030, 
        0x00313131, 0x00313131, 0x00303030, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x00313131, 0x002D2D2D, 0x00383838, 0x00383838, 
        0x00353535, 0x002C2C2C, 0x00313131, 0x00303030, 0x002F2F2F, 0x002F2F2F, 0x00313131, 0x00313131, 0x00303030, 0x002F2F2F, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002D2D2D, 0x002D2D2D, 0x002C2C2C, 0x002C2C2C, 0x002B2B2B, 
        0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x002A2A2A, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00282828, 0x00282828, 0x00272727, 0x00272727, 0x00262626, 0x00252525, 0x00252525, 0x00252525, 0x00252525, 0x00242424, 0x00222222, 
        0x00222222, 0x00222222, 0x00222222, 0x00222222, 0x00212121, 0x001F1F1F, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001D1D1D, 0x001C1C1C, 0x001C1C1C, 0x001B1B1B, 0x00191919, 0x00181818, 0x00181818, 0x00181818, 0x00181818, 0x00161616, 0x001A1A1A, 
        0x001C1C1C, 0x001C1C1C, 0x00181818, 0x00131313, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x004A4A4A, 0x00CCCCCC, 0x00898989, 0x00535353, 0x006D6D6D, 0x00939393, 0x00B6B6B6, 0x00B8B8B8, 0x009C9C9C, 0x00A1A1A1, 0x007E7E7E, 0x00333333, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x000C0C42, 0x000303A5, 0x00111111, 0x00202020, 0x006E6E6E, 0x006E6E6E, 0x00727272, 0x00909090, 0x00909090, 0x00909090, 0x00909090, 0x00909090, 0x00909090, 0x00909090, 0xEF909090, 0xFF000000, 0xFF000000,
  0xFF000000, 0xDE909090, 0x00909090, 0x00909090, 0x00909090, 0x00909090, 0x00909090, 0x00909090, 0x00909090, 0x006E6E6E, 0x006E6E6E, 0x006E6E6E, 0x001D1D1D, 0x001A1A1A, 0x000303B3, 0x0015153E, 0x001C1C1C, 0x001C1C1C, 0x001C1C1C, 0x001C1C1C, 0x001E1E1E, 
        0x001F1F1F, 0x001F1F1F, 0x00202020, 0x001F1F1F, 0x00212121, 0x00222222, 0x00222222, 0x00232323, 0x00242424, 0x00252525, 0x00252525, 0x00252525, 0x00252525, 0x00252525, 0x00252525, 0x00272727, 0x00272727, 0x00272727, 0x00292929, 0x00282828, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 
        0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002F2F2F, 0x00313131, 0x00303030, 0x002F2F2F, 0x002E2E2E, 0x00313131, 0x00313131, 0x00313131, 0x00303030, 0x002F2F2F, 0x00303030, 0x00303030, 0x002F2F2F, 0x002B2B2B, 0x00373737, 0x00383838, 0x003A3A3A, 
        0x002C2C2C, 0x002F2F2F, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002F2F2F, 0x002F2F2F, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002C2C2C, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 
        0x002A2A2A, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00282828, 0x00282828, 0x00272727, 0x00272727, 0x00262626, 0x00252525, 0x00252525, 0x00252525, 0x00252525, 0x00252525, 0x00252525, 0x00242424, 0x00242424, 0x00222222, 
        0x00222222, 0x00212121, 0x00202020, 0x001F1F1F, 0x001F1F1F, 0x001F1F1F, 0x001E1E1E, 0x001D1D1D, 0x001C1C1C, 0x001C1C1C, 0x001B1B1B, 0x001A1A1A, 0x001A1A1A, 0x00181818, 0x00181818, 0x00181818, 0x00171717, 0x00151515, 0x00151515, 0x00151515, 
        0x001E1E1E, 0x001E1E1E, 0x001D1D1D, 0x00131313, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00343434, 0x00CCCCCC, 0x00898989, 0x00111111, 0x00222222, 0x00373737, 0x004C4C4C, 0x00747474, 0x00848484, 0x00686868, 0x003D3D3D, 0x00151515, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x000000CC, 0x00111111, 0x00111111, 0x00616161, 0x006E6E6E, 0x006E6E6E, 0x008B8B8B, 0x00909090, 0x00909090, 0x00909090, 0x00909090, 0x00909090, 0x00909090, 0xBC909090, 0xFF000000, 0xFF000000,
  0xFF000000, 0xAB8F8F8F, 0x008F8F8F, 0x008F8F8F, 0x008F8F8F, 0x008F8F8F, 0x008F8F8F, 0x008F8F8F, 0x00898989, 0x006F6F6F, 0x006F6F6F, 0x00585858, 0x00181818, 0x00181825, 0x000101BF, 0x001A1A1A, 0x001C1C1C, 0x001C1C1C, 0x001C1C1C, 0x00232323, 0x00505050, 
        0x00515151, 0x00404040, 0x002B2B2B, 0x001F1F1F, 0x001F1F1F, 0x00202020, 0x00222222, 0x00222222, 0x00232323, 0x00222222, 0x00242424, 0x00242424, 0x00252525, 0x00252525, 0x00252525, 0x00252525, 0x00252525, 0x00262626, 0x00272727, 0x00272727, 
        0x00282828, 0x00292929, 0x00282828, 0x00292929, 0x00292929, 0x00292929, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x002C2C2C, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 
        0x002D2D2D, 0x002E2E2E, 0x002E2E2E, 0x002D2D2D, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002F2F2F, 0x002F2F2F, 0x002E2E2E, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002E2E2E, 0x002C2C2C, 0x00353535, 0x00393939, 0x00393939, 0x002D2D2D, 
        0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002E2E2E, 0x002E2E2E, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002C2C2C, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x002A2A2A, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00282828, 0x00272727, 0x00272727, 0x00262626, 0x00252525, 0x00252525, 0x00252525, 0x00252525, 0x00252525, 0x00252525, 0x00242424, 0x00242424, 0x00242424, 0x00242424, 0x00232323, 0x00212121, 
        0x001F1F1F, 0x001F1F1F, 0x001F1F1F, 0x001F1F1F, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001D1D1D, 0x001B1B1B, 0x001A1A1A, 0x001A1A1A, 0x001A1A1A, 0x001A1A1A, 0x00181818, 0x00161616, 0x00151515, 0x00151515, 0x00151515, 0x00151515, 0x00141414, 
        0x00161616, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x001C1C1C, 0x00CCCCCC, 0x00969696, 0x00111111, 0x00111111, 0x00111111, 0x00171717, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x000303A5, 0x000C0C42, 0x00111111, 0x00474747, 0x006F6F6F, 0x006F6F6F, 0x00878787, 0x008F8F8F, 0x008F8F8F, 0x008F8F8F, 0x008F8F8F, 0x008F8F8F, 0x008F8F8F, 0x898F8F8F, 0xFF000000, 0xFF000000,
  0xFF000000, 0x788E8E8E, 0x008E8E8E, 0x008E8E8E, 0x008E8E8E, 0x008E8E8E, 0x008E8E8E, 0x008E8E8E, 0x00868686, 0x00707070, 0x00707070, 0x00434343, 0x00161616, 0x00101046, 0x0006069B, 0x001A1A1A, 0x001B1B1B, 0x001B1B1B, 0x002E2E2E, 0x006A6A6A, 0x00A5A5A5, 
        0x00BEBEBE, 0x00CDCDCD, 0x00CDCDCD, 0x00ABABAB, 0x00828282, 0x00656565, 0x004F4F4F, 0x00343434, 0x00222222, 0x00222222, 0x00232323, 0x00232323, 0x00232323, 0x00242424, 0x00252525, 0x00252525, 0x00252525, 0x00252525, 0x00252525, 0x00272727, 
        0x00262626, 0x00272727, 0x00272727, 0x00292929, 0x00292929, 0x00282828, 0x00292929, 0x00292929, 0x002A2A2A, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x002C2C2C, 0x002B2B2B, 0x002C2C2C, 0x002C2C2C, 0x002B2B2B, 0x002B2B2B, 0x002D2D2D, 0x002D2D2D, 
        0x002C2C2C, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002E2E2E, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x00393939, 0x00393939, 0x00323232, 0x002D2D2D, 
        0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002C2C2C, 0x002C2C2C, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x002A2A2A, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00282828, 0x00272727, 0x00272727, 0x00272727, 0x00262626, 0x00252525, 0x00252525, 0x00252525, 0x00252525, 0x00252525, 0x00242424, 0x00242424, 0x00242424, 0x00242424, 0x00242424, 0x00232323, 0x00222222, 0x00222222, 0x00212121, 
        0x001F1F1F, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001D1D1D, 0x001C1C1C, 0x001C1C1C, 0x001C1C1C, 0x001B1B1B, 0x001A1A1A, 0x00191919, 0x00191919, 0x00181818, 0x00171717, 0x00151515, 0x00151515, 0x00141414, 0x00141414, 0x00131313, 0x00121212, 
        0x00111111, 0x00171717, 0x001F1F1F, 0x001F1F1F, 0x00191919, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00191919, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00292929, 0x003C3C3C, 0x00464646, 0x00292929, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00060680, 0x00090967, 0x00111111, 0x00363636, 0x00707070, 0x00707070, 0x00848484, 0x008E8E8E, 0x008E8E8E, 0x008E8E8E, 0x008E8E8E, 0x008E8E8E, 0x008E8E8E, 0x568E8E8E, 0xFF000000, 0xFF000000,
  0xFF000000, 0x568D8D8D, 0x008D8D8D, 0x008D8D8D, 0x008D8D8D, 0x008D8D8D, 0x008D8D8D, 0x008D8D8D, 0x00848484, 0x00717171, 0x00717171, 0x00333333, 0x00151515, 0x000B0B6A, 0x000B0B77, 0x00191919, 0x00181818, 0x00191919, 0x00474747, 0x00ADADAD, 0x00919191, 
        0x006C6C6C, 0x00898989, 0x00B6B6B6, 0x00CDCDCD, 0x00CDCDCD, 0x00CDCDCD, 0x00BDBDBD, 0x00747474, 0x00282828, 0x00222222, 0x00222222, 0x00222222, 0x00222222, 0x00222222, 0x00242424, 0x00242424, 0x00252525, 0x00252525, 0x00252525, 0x00252525, 
        0x00252525, 0x00272727, 0x00272727, 0x00272727, 0x00272727, 0x00272727, 0x00282828, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x002A2A2A, 0x002B2B2B, 0x002B2B2B, 0x002A2A2A, 0x002B2B2B, 0x002B2B2B, 
        0x002B2B2B, 0x002C2C2C, 0x002D2D2D, 0x002C2C2C, 0x002C2C2C, 0x002D2D2D, 0x002C2C2C, 0x002B2B2B, 0x002B2B2B, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002B2B2B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x002B2B2B, 0x002C2C2C, 
        0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002D2D2D, 0x002C2C2C, 0x002B2B2B, 0x002B2B2B, 0x002C2C2C, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x002A2A2A, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00282828, 0x00282828, 
        0x00272727, 0x00272727, 0x00262626, 0x00252525, 0x00252525, 0x00252525, 0x00252525, 0x00252525, 0x00242424, 0x00242424, 0x00242424, 0x00242424, 0x00242424, 0x00232323, 0x00222222, 0x00222222, 0x00222222, 0x00222222, 0x00212121, 0x00202020, 
        0x001E1E1E, 0x001D1D1D, 0x001C1C1C, 0x001C1C1C, 0x001C1C1C, 0x001C1C1C, 0x001C1C1C, 0x001B1B1B, 0x001A1A1A, 0x00181818, 0x00181818, 0x00181818, 0x00181818, 0x00171717, 0x00151515, 0x00151515, 0x00131313, 0x00121212, 0x00111111, 0x00111111, 
        0x00111111, 0x00101010, 0x00212121, 0x00212121, 0x00212121, 0x00131313, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00171717, 0x00323232, 0x004D4D4D, 0x00676767, 0x008A8A8A, 0x00BEBEBE, 0x00CCCCCC, 0x00BFBFBF, 0x00A9A9A9, 0x00737373, 0x003A3A3A, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x000A0A5B, 0x0005058D, 0x00111111, 0x00292929, 0x00717171, 0x00717171, 0x007F7F7F, 0x008D8D8D, 0x008D8D8D, 0x008D8D8D, 0x008D8D8D, 0x008D8D8D, 0x008D8D8D, 0x238D8D8D, 0xFF000000, 0xFF000000,
  0xFF000000, 0x238D8D8D, 0x008D8D8D, 0x008D8D8D, 0x008D8D8D, 0x008D8D8D, 0x008D8D8D, 0x008D8D8D, 0x007F7F7F, 0x00717171, 0x00717171, 0x002A2A2A, 0x00151515, 0x0006068E, 0x000D0D51, 0x00181818, 0x00181818, 0x00181818, 0x00606060, 0x00C7C7C7, 0x005E5E5E, 
        0x001F1F1F, 0x001B1B1B, 0x001C1C1C, 0x002F2F2F, 0x00454545, 0x005E5E5E, 0x00979797, 0x00AFAFAF, 0x00575757, 0x00202020, 0x001F1F1F, 0x00222222, 0x00222222, 0x00222222, 0x00232323, 0x00222222, 0x00232323, 0x00242424, 0x00252525, 0x00252525, 
        0x00252525, 0x00252525, 0x00252525, 0x00252525, 0x00272727, 0x00272727, 0x00272727, 0x00272727, 0x00272727, 0x00272727, 0x00272727, 0x00282828, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x002B2B2B, 
        0x002A2A2A, 0x00292929, 0x002B2B2B, 0x002A2A2A, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x002C2C2C, 0x002B2B2B, 0x002C2C2C, 0x002D2D2D, 0x00323232, 0x003C3C3C, 0x003B3B3B, 0x002E2E2E, 0x002B2B2B, 0x002B2B2B, 
        0x002D2D2D, 0x002C2C2C, 0x002B2B2B, 0x002A2A2A, 0x00292929, 0x002A2A2A, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x002A2A2A, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00282828, 0x00282828, 0x00272727, 0x00272727, 0x00262626, 
        0x00252525, 0x00252525, 0x00252525, 0x00252525, 0x00252525, 0x00252525, 0x00242424, 0x00242424, 0x00242424, 0x00242424, 0x00232323, 0x00222222, 0x00222222, 0x00222222, 0x00222222, 0x00222222, 0x00212121, 0x00202020, 0x001F1F1F, 0x001E1E1E, 
        0x001D1D1D, 0x001C1C1C, 0x001C1C1C, 0x001C1C1C, 0x001C1C1C, 0x001B1B1B, 0x001A1A1A, 0x001A1A1A, 0x001A1A1A, 0x00181818, 0x00171717, 0x00161616, 0x00151515, 0x00151515, 0x00141414, 0x00131313, 0x00121212, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00161616, 0x00232323, 0x00232323, 0x001D1D1D, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00141414, 0x004A4A4A, 0x00989898, 0x00C2C2C2, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00A0A0A0, 0x00797979, 0x00818181, 0x00BCBCBC, 0x00656565, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x000D0D36, 0x000202B2, 0x00111111, 0x001B1B1B, 0x00717171, 0x00717171, 0x00757575, 0x008D8D8D, 0x008D8D8D, 0x008D8D8D, 0x008D8D8D, 0x008D8D8D, 0x008D8D8D, 0x008D8D8D, 0xFF000000, 0xFF000000,
  0xFF000000, 0x008C8C8C, 0x008C8C8C, 0x008C8C8C, 0x008C8C8C, 0x008C8C8C, 0x008C8C8C, 0x008C8C8C, 0x00757575, 0x00727272, 0x00727272, 0x001D1D1D, 0x00141414, 0x000202B2, 0x000F0F38, 0x00171717, 0x00181818, 0x00181818, 0x00606060, 0x00B7B7B7, 0x00808080, 
        0x004E4E4E, 0x00353535, 0x001F1F1F, 0x001C1C1C, 0x001C1C1C, 0x00232323, 0x00707070, 0x00CDCDCD, 0x00555555, 0x001E1E1E, 0x001F1F1F, 0x00202020, 0x00202020, 0x00202020, 0x00222222, 0x00222222, 0x00222222, 0x00232323, 0x00232323, 0x00242424, 
        0x00252525, 0x00252525, 0x00252525, 0x00252525, 0x00252525, 0x00252525, 0x00262626, 0x00262626, 0x00252525, 0x00262626, 0x00272727, 0x00272727, 0x00282828, 0x00272727, 0x00272727, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x002A2A2A, 0x002B2B2B, 0x002A2A2A, 0x00292929, 0x00292929, 0x00292929, 0x002B2B2B, 0x002B2B2B, 0x002A2A2A, 0x002B2B2B, 0x003C3C3C, 0x003C3C3C, 0x003C3C3C, 0x002A2A2A, 0x002B2B2B, 0x002B2B2B, 
        0x002B2B2B, 0x002A2A2A, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x002B2B2B, 0x002A2A2A, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00282828, 0x00272727, 0x00272727, 0x00262626, 0x00252525, 0x00252525, 0x00252525, 
        0x00252525, 0x00252525, 0x00252525, 0x00242424, 0x00242424, 0x00242424, 0x00242424, 0x00232323, 0x00232323, 0x00222222, 0x00222222, 0x00222222, 0x00222222, 0x00212121, 0x00202020, 0x001F1F1F, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 
        0x001E1E1E, 0x001C1C1C, 0x001B1B1B, 0x001A1A1A, 0x001A1A1A, 0x001A1A1A, 0x001A1A1A, 0x001A1A1A, 0x00191919, 0x00171717, 0x00151515, 0x00141414, 0x00131313, 0x00131313, 0x00131313, 0x00131313, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00101010, 0x001F1F1F, 0x00242424, 0x00242424, 0x00151515, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00333333, 0x00959595, 0x00AFAFAF, 0x00656565, 0x00494949, 0x00333333, 0x001A1A1A, 0x00111111, 0x00141414, 0x003B3B3B, 0x00C7C7C7, 0x00838383, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x000000CC, 0x00111111, 0x00111111, 0x00727272, 0x00727272, 0x00727272, 0x00888888, 0x008C8C8C, 0x008C8C8C, 0x008C8C8C, 0x008C8C8C, 0x008C8C8C, 0x008C8C8C, 0xCD8C8C8C, 0xFF000000,
  0xCD8B8B8B, 0x008B8B8B, 0x008B8B8B, 0x008B8B8B, 0x008B8B8B, 0x008B8B8B, 0x008B8B8B, 0x00878787, 0x00737373, 0x00737373, 0x00737373, 0x00111111, 0x00121212, 0x000000CC, 0x00141414, 0x00151515, 0x00161616, 0x00151515, 0x002A2A2A, 0x00818181, 0x00B8B8B8, 
        0x00CACACA, 0x00CCCCCC, 0x00CCCCCC, 0x009A9A9A, 0x00757575, 0x005D5D5D, 0x009C9C9C, 0x00C0C0C0, 0x003F3F3F, 0x001D1D1D, 0x001E1E1E, 0x001E1E1E, 0x001F1F1F, 0x001F1F1F, 0x00212121, 0x00222222, 0x00222222, 0x00222222, 0x00222222, 0x00232323, 
        0x00252525, 0x00252525, 0x00242424, 0x00242424, 0x00242424, 0x00242424, 0x00252525, 0x00252525, 0x00252525, 0x00252525, 0x00262626, 0x00252525, 0x00272727, 0x00272727, 0x00272727, 0x00272727, 0x00272727, 0x00282828, 0x00282828, 0x00272727, 
        0x00282828, 0x00292929, 0x00292929, 0x00292929, 0x00282828, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00282828, 0x00292929, 0x00292929, 0x00292929, 0x002F2F2F, 0x003D3D3D, 0x003D3D3D, 0x002D2D2D, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00282828, 0x00282828, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00282828, 0x00272727, 0x00272727, 0x00272727, 0x00262626, 0x00252525, 0x00252525, 0x00252525, 0x00252525, 0x00252525, 
        0x00242424, 0x00242424, 0x00242424, 0x00242424, 0x00242424, 0x00232323, 0x00222222, 0x00222222, 0x00222222, 0x00222222, 0x00212121, 0x00202020, 0x001F1F1F, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001D1D1D, 
        0x001C1C1C, 0x001B1B1B, 0x001A1A1A, 0x001A1A1A, 0x001A1A1A, 0x00191919, 0x00191919, 0x00181818, 0x00171717, 0x00151515, 0x00131313, 0x00131313, 0x00131313, 0x00131313, 0x00121212, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00161616, 0x00262626, 0x00262626, 0x001E1E1E, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x002C2C2C, 0x00CCCCCC, 0x009B9B9B, 0x001C1C1C, 0x00111111, 0x00111111, 0x00111111, 0x001F1F1F, 0x00373737, 0x00555555, 0x00C7C7C7, 0x00777777, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x000202B2, 0x000D0D36, 0x00111111, 0x00515151, 0x00737373, 0x00737373, 0x00868686, 0x008B8B8B, 0x008B8B8B, 0x008B8B8B, 0x008B8B8B, 0x008B8B8B, 0x008B8B8B, 0xAB8B8B8B, 0xFF000000,
  0xBC8B8B8B, 0x008B8B8B, 0x008B8B8B, 0x008B8B8B, 0x008B8B8B, 0x008B8B8B, 0x008B8B8B, 0x00868686, 0x00747474, 0x00747474, 0x005B5B5B, 0x00111111, 0x000D0D36, 0x000202B2, 0x00111111, 0x00131313, 0x00151515, 0x00151515, 0x00171717, 0x00363636, 0x00525252, 
        0x00707070, 0x00959595, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00C0C0C0, 0x00A9A9A9, 0x00757575, 0x00252525, 0x001C1C1C, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x00212121, 0x00222222, 0x00222222, 0x00222222, 0x00222222, 
        0x00222222, 0x00232323, 0x00222222, 0x00242424, 0x00242424, 0x00242424, 0x00232323, 0x00242424, 0x00252525, 0x00252525, 0x00252525, 0x00252525, 0x00262626, 0x00262626, 0x00252525, 0x00262626, 0x00262626, 0x00262626, 0x00272727, 0x00272727, 
        0x00272727, 0x00282828, 0x00272727, 0x00272727, 0x00272727, 0x00292929, 0x00292929, 0x00282828, 0x00272727, 0x00272727, 0x00282828, 0x00292929, 0x00272727, 0x003E3E3E, 0x003E3E3E, 0x003D3D3D, 0x00282828, 0x00272727, 0x00272727, 0x00292929, 
        0x00292929, 0x00282828, 0x00282828, 0x00272727, 0x00272727, 0x00272727, 0x00282828, 0x00282828, 0x00282828, 0x00272727, 0x00272727, 0x00262626, 0x00252525, 0x00252525, 0x00252525, 0x00252525, 0x00252525, 0x00242424, 0x00242424, 0x00242424, 
        0x00242424, 0x00242424, 0x00232323, 0x00222222, 0x00222222, 0x00222222, 0x00222222, 0x00212121, 0x00202020, 0x001F1F1F, 0x001F1F1F, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001D1D1D, 0x001C1C1C, 0x001C1C1C, 0x001C1C1C, 
        0x001C1C1C, 0x001B1B1B, 0x00191919, 0x00191919, 0x00181818, 0x00171717, 0x00161616, 0x00151515, 0x00151515, 0x00151515, 0x00131313, 0x00131313, 0x00121212, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00101010, 0x00232323, 0x00282828, 0x00282828, 0x00151515, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00C5C5C5, 0x00CCCCCC, 0x00525252, 0x005E5E5E, 0x007D7D7D, 0x00A9A9A9, 0x00CCCCCC, 0x00CCCCCC, 0x00BFBFBF, 0x00919191, 0x00393939, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x0005058D, 0x000B0B4F, 0x00111111, 0x00434343, 0x00747474, 0x00747474, 0x00858585, 0x008B8B8B, 0x008B8B8B, 0x008B8B8B, 0x008B8B8B, 0x008B8B8B, 0x008B8B8B, 0x898B8B8B, 0xFF000000,
  0x9A8A8A8A, 0x008A8A8A, 0x008A8A8A, 0x008A8A8A, 0x008A8A8A, 0x008A8A8A, 0x008A8A8A, 0x00858585, 0x00747474, 0x00747474, 0x00434343, 0x00111111, 0x000B0B4F, 0x0005058D, 0x00111111, 0x00121212, 0x00131313, 0x00131313, 0x00141414, 0x00151515, 0x00151515, 
        0x00151515, 0x00151515, 0x00191919, 0x00333333, 0x00484848, 0x00585858, 0x00505050, 0x00222222, 0x001C1C1C, 0x001C1C1C, 0x001D1D1D, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001F1F1F, 0x001F1F1F, 0x001F1F1F, 0x00202020, 0x001F1F1F, 
        0x001F1F1F, 0x00222222, 0x00222222, 0x00232323, 0x00232323, 0x00222222, 0x00222222, 0x00232323, 0x00252525, 0x00252525, 0x00252525, 0x00242424, 0x00242424, 0x00252525, 0x00252525, 0x00252525, 0x00252525, 0x00252525, 0x00272727, 0x00262626, 
        0x00252525, 0x00272727, 0x00272727, 0x00272727, 0x00272727, 0x00272727, 0x00272727, 0x00272727, 0x00272727, 0x00272727, 0x00272727, 0x00272727, 0x002A2A2A, 0x003B3B3B, 0x003D3D3D, 0x002D2D2D, 0x00272727, 0x00272727, 0x00272727, 0x00272727, 
        0x00272727, 0x00272727, 0x00272727, 0x00272727, 0x00272727, 0x00262626, 0x00262626, 0x00272727, 0x00262626, 0x00252525, 0x00252525, 0x00252525, 0x00252525, 0x00252525, 0x00252525, 0x00242424, 0x00242424, 0x00242424, 0x00242424, 0x00232323, 
        0x00232323, 0x00222222, 0x00222222, 0x00222222, 0x00222222, 0x00212121, 0x00202020, 0x001F1F1F, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001D1D1D, 0x001C1C1C, 0x001C1C1C, 0x001C1C1C, 0x001C1C1C, 0x001C1C1C, 0x001C1C1C, 
        0x001B1B1B, 0x001A1A1A, 0x00171717, 0x00161616, 0x00151515, 0x00151515, 0x00151515, 0x00151515, 0x00141414, 0x00141414, 0x00121212, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00181818, 0x00292929, 0x00292929, 0x001B1B1B, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00626262, 0x00A2A2A2, 0x00C2C2C2, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00B3B3B3, 0x00838383, 0x005E5E5E, 0x003C3C3C, 0x001A1A1A, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00070774, 0x00090967, 0x00111111, 0x00373737, 0x00747474, 0x00747474, 0x00828282, 0x008A8A8A, 0x008A8A8A, 0x008A8A8A, 0x008A8A8A, 0x008A8A8A, 0x008A8A8A, 0x678A8A8A, 0xFF000000,
  0x78898989, 0x00898989, 0x00898989, 0x00898989, 0x00898989, 0x00898989, 0x00898989, 0x00828282, 0x00757575, 0x00757575, 0x00373737, 0x00111111, 0x00090967, 0x00070774, 0x00111111, 0x00111111, 0x00121212, 0x004F4F4F, 0x00979797, 0x00717171, 0x00575757, 
        0x00424242, 0x002A2A2A, 0x00171717, 0x003B3B3B, 0x006B6B6B, 0x00434343, 0x00191919, 0x00191919, 0x001B1B1B, 0x001C1C1C, 0x001C1C1C, 0x001E1E1E, 0x001D1D1D, 0x001C1C1C, 0x001C1C1C, 0x001D1D1D, 0x00A8A8A8, 0x00929292, 0x007B7B7B, 0x00595959, 
        0x00353535, 0x00202020, 0x001F1F1F, 0x00202020, 0x00222222, 0x00222222, 0x00222222, 0x00222222, 0x00222222, 0x00242424, 0x00232323, 0x00242424, 0x00242424, 0x00242424, 0x00252525, 0x00252525, 0x00252525, 0x00242424, 0x00252525, 0x00252525, 
        0x00252525, 0x00252525, 0x00262626, 0x00252525, 0x00252525, 0x00252525, 0x00272727, 0x00272727, 0x00262626, 0x00272727, 0x00272727, 0x00262626, 0x00383838, 0x003D3D3D, 0x003E3E3E, 0x00292929, 0x00272727, 0x00262626, 0x00252525, 0x00262626, 
        0x00272727, 0x00272727, 0x00262626, 0x00252525, 0x00252525, 0x00252525, 0x00242424, 0x00252525, 0x00252525, 0x00252525, 0x00252525, 0x00252525, 0x00242424, 0x00242424, 0x00242424, 0x00242424, 0x00232323, 0x00232323, 0x00222222, 0x00222222, 
        0x00222222, 0x00222222, 0x00212121, 0x00202020, 0x001F1F1F, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001D1D1D, 0x001C1C1C, 0x001C1C1C, 0x001C1C1C, 0x001C1C1C, 0x001C1C1C, 0x001B1B1B, 0x001A1A1A, 0x001A1A1A, 
        0x00191919, 0x00181818, 0x00161616, 0x00151515, 0x00151515, 0x00151515, 0x00141414, 0x00131313, 0x00131313, 0x00131313, 0x00131313, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00121212, 0x002B2B2B, 0x002B2B2B, 0x002B2B2B, 0x00101010, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00292929, 
        0x004F4F4F, 0x00747474, 0x008D8D8D, 0x00A5A5A5, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00161616, 0x00484848, 0x00616161, 0x00515151, 0x003B3B3B, 0x00242424, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x000A0A5B, 0x00060680, 0x00111111, 0x00292929, 0x00757575, 0x00757575, 0x00808080, 0x00898989, 0x00898989, 0x00898989, 0x00898989, 0x00898989, 0x00898989, 0x56898989, 0xFF000000,
  0x56898989, 0x00898989, 0x00898989, 0x00898989, 0x00898989, 0x00898989, 0x00898989, 0x00828282, 0x00767676, 0x00767676, 0x002E2E2E, 0x00111111, 0x00070774, 0x00090967, 0x00111111, 0x00111111, 0x00111111, 0x00676767, 0x00CBCBCB, 0x00CBCBCB, 0x00CBCBCB, 
        0x00CBCBCB, 0x00CBCBCB, 0x00B9B9B9, 0x00A6A6A6, 0x00CBCBCB, 0x007F7F7F, 0x003B3B3B, 0x001F1F1F, 0x001A1A1A, 0x001B1B1B, 0x001B1B1B, 0x001C1C1C, 0x001B1B1B, 0x001C1C1C, 0x001C1C1C, 0x00272727, 0x00B4B4B4, 0x00CDCDCD, 0x00CDCDCD, 0x00CDCDCD, 
        0x00CDCDCD, 0x00C0C0C0, 0x00A9A9A9, 0x00868686, 0x00656565, 0x00424242, 0x00212121, 0x00212121, 0x001F1F1F, 0x00212121, 0x00222222, 0x00232323, 0x00242424, 0x00232323, 0x00232323, 0x00242424, 0x00242424, 0x00242424, 0x00242424, 0x00252525, 
        0x00242424, 0x00242424, 0x00252525, 0x00252525, 0x00252525, 0x00252525, 0x00252525, 0x00252525, 0x00252525, 0x00252525, 0x00252525, 0x00262626, 0x003F3F3F, 0x003E3E3E, 0x00393939, 0x00252525, 0x00252525, 0x00252525, 0x00252525, 0x00252525, 
        0x00252525, 0x00252525, 0x00252525, 0x00242424, 0x00242424, 0x00242424, 0x00242424, 0x00252525, 0x00252525, 0x00242424, 0x00242424, 0x00242424, 0x00242424, 0x00242424, 0x00232323, 0x00222222, 0x00222222, 0x00222222, 0x00222222, 0x00212121, 
        0x00202020, 0x001F1F1F, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001D1D1D, 0x001C1C1C, 0x001C1C1C, 0x001C1C1C, 0x001C1C1C, 0x001C1C1C, 0x001B1B1B, 0x001B1B1B, 0x001A1A1A, 0x00191919, 0x00181818, 0x00181818, 
        0x00181818, 0x00181818, 0x00171717, 0x00151515, 0x00131313, 0x00131313, 0x00131313, 0x00131313, 0x00131313, 0x00121212, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x001F1F1F, 0x002D2D2D, 0x002D2D2D, 0x00171717, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00363636, 0x005B5B5B, 0x00808080, 0x00999999, 0x00BEBEBE, 0x00CCCCCC, 
        0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00B2B2B2, 0x001D1D1D, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00141414, 0x002F2F2F, 0x00444444, 0x00525252, 0x00444444, 
        0x00161616, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x000C0C42, 0x00040499, 0x00111111, 0x00252525, 0x00767676, 0x00767676, 0x007D7D7D, 0x00898989, 0x00898989, 0x00898989, 0x00898989, 0x00898989, 0x00898989, 0x23898989, 0xFF000000,
  0x45888888, 0x00888888, 0x00888888, 0x00888888, 0x00888888, 0x00888888, 0x00888888, 0x00808080, 0x00777777, 0x00777777, 0x002A2A2A, 0x00111111, 0x0005058D, 0x000B0B4F, 0x00111111, 0x00111111, 0x00111111, 0x00898989, 0x00CBCBCB, 0x00B2B2B2, 0x008D8D8D, 
        0x00858585, 0x00A5A5A5, 0x00CBCBCB, 0x00CBCBCB, 0x00CBCBCB, 0x00CBCBCB, 0x00CBCBCB, 0x004A4A4A, 0x00181818, 0x00191919, 0x00191919, 0x00191919, 0x001A1A1A, 0x001B1B1B, 0x001C1C1C, 0x001C1C1C, 0x001C1C1C, 0x00272727, 0x004A4A4A, 0x00636363, 
        0x00868686, 0x00A9A9A9, 0x00CDCDCD, 0x00CDCDCD, 0x00CDCDCD, 0x00CDCDCD, 0x00353535, 0x001F1F1F, 0x001F1F1F, 0x00202020, 0x00212121, 0x00202020, 0x00222222, 0x00222222, 0x00222222, 0x00242424, 0x00232323, 0x00222222, 0x00222222, 0x00242424, 
        0x00242424, 0x00242424, 0x00242424, 0x00242424, 0x00232323, 0x00232323, 0x00232323, 0x00242424, 0x00242424, 0x00242424, 0x00252525, 0x002B2B2B, 0x003F3F3F, 0x003F3F3F, 0x002B2B2B, 0x00252525, 0x00252525, 0x00252525, 0x00242424, 0x00232323, 
        0x00242424, 0x00242424, 0x00242424, 0x00242424, 0x00242424, 0x00232323, 0x00222222, 0x00222222, 0x00242424, 0x00242424, 0x00242424, 0x00232323, 0x00222222, 0x00222222, 0x00222222, 0x00222222, 0x00212121, 0x00202020, 0x001F1F1F, 0x001F1F1F, 
        0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001D1D1D, 0x001C1C1C, 0x001C1C1C, 0x001C1C1C, 0x001C1C1C, 0x001C1C1C, 0x001B1B1B, 0x001B1B1B, 0x001A1A1A, 0x00191919, 0x00191919, 0x00181818, 0x00181818, 0x00181818, 0x00181818, 
        0x00171717, 0x00161616, 0x00151515, 0x00151515, 0x00131313, 0x00131313, 0x00121212, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00181818, 0x002F2F2F, 0x002F2F2F, 0x00202020, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00292929, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00A5A5A5, 0x00808080, 
        0x005B5B5B, 0x00424242, 0x001D1D1D, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00151515, 0x00333333, 0x00515151, 0x00707070, 0x00979797, 0x00CCCCCC, 0x00CCCCCC, 0x00C7C7C7, 0x00B8B8B8, 0x009E9E9E, 
        0x005F5F5F, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x000D0D36, 0x000202B2, 0x00111111, 0x00202020, 0x00777777, 0x00777777, 0x007B7B7B, 0x00888888, 0x00888888, 0x00888888, 0x00888888, 0x00888888, 0x00888888, 0x23888888, 0xFF000000,
  0x23878787, 0x00878787, 0x00878787, 0x00878787, 0x00878787, 0x00878787, 0x00878787, 0x007A7A7A, 0x00777777, 0x00777777, 0x00202020, 0x00111111, 0x000303A5, 0x000D0D36, 0x00111111, 0x00111111, 0x00111111, 0x00383838, 0x00848484, 0x00B3B3B3, 0x007A7A7A, 
        0x00414141, 0x001F1F1F, 0x001F1F1F, 0x00A5A5A5, 0x00CBCBCB, 0x00727272, 0x00878787, 0x00333333, 0x00161616, 0x00181818, 0x00181818, 0x00181818, 0x001A1A1A, 0x00191919, 0x001A1A1A, 0x001A1A1A, 0x001C1C1C, 0x001C1C1C, 0x001C1C1C, 0x001C1C1C, 
        0x001C1C1C, 0x001C1C1C, 0x001D1D1D, 0x00353535, 0x00585858, 0x007B7B7B, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001F1F1F, 0x001F1F1F, 0x001F1F1F, 0x00212121, 0x00212121, 0x00202020, 0x00212121, 0x00222222, 0x00222222, 0x00222222, 0x00222222, 
        0x00222222, 0x00222222, 0x00222222, 0x00222222, 0x00222222, 0x00222222, 0x00222222, 0x00232323, 0x00232323, 0x00222222, 0x00242424, 0x00363636, 0x00404040, 0x003F3F3F, 0x00252525, 0x00232323, 0x00232323, 0x00232323, 0x00222222, 0x00222222, 
        0x00222222, 0x00242424, 0x00232323, 0x00232323, 0x00222222, 0x00222222, 0x00222222, 0x00222222, 0x00232323, 0x00232323, 0x00222222, 0x00222222, 0x00222222, 0x00222222, 0x00212121, 0x00202020, 0x001F1F1F, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 
        0x001E1E1E, 0x001E1E1E, 0x001D1D1D, 0x001C1C1C, 0x001C1C1C, 0x001C1C1C, 0x001C1C1C, 0x001C1C1C, 0x001C1C1C, 0x001B1B1B, 0x001A1A1A, 0x001A1A1A, 0x00191919, 0x00181818, 0x00181818, 0x00181818, 0x00181818, 0x00171717, 0x00161616, 0x00151515, 
        0x00151515, 0x00151515, 0x00151515, 0x00141414, 0x00131313, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00121212, 0x00303030, 0x00303030, 0x00303030, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00747474, 0x004F4F4F, 0x00292929, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00313131, 0x00898989, 0x00BCBCBC, 0x00CCCCCC, 0x00CCCCCC, 0x00CACACA, 0x00929292, 0x006D6D6D, 0x005A5A5A, 0x00C4C4C4, 
        0x00BCBCBC, 0x00191919, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x000000CC, 0x00111111, 0x00111111, 0x00777777, 0x00777777, 0x00777777, 0x00878787, 0x00878787, 0x00878787, 0x00878787, 0x00878787, 0x00878787, 0x00878787, 0xFF000000,
  0x12878787, 0x00878787, 0x00878787, 0x00878787, 0x00878787, 0x00878787, 0x00878787, 0x007B7B7B, 0x00787878, 0x00787878, 0x001C1C1C, 0x00111111, 0x000202B2, 0x000D0D36, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x002C2C2C, 0x00545454, 0x008E8E8E, 
        0x00BBBBBB, 0x00717171, 0x00313131, 0x00CACACA, 0x00C5C5C5, 0x00141414, 0x00131313, 0x00151515, 0x00151515, 0x00171717, 0x00181818, 0x00181818, 0x00181818, 0x00181818, 0x00191919, 0x001A1A1A, 0x001A1A1A, 0x001B1B1B, 0x001C1C1C, 0x001B1B1B, 
        0x001A1A1A, 0x001A1A1A, 0x001C1C1C, 0x001E1E1E, 0x001D1D1D, 0x001C1C1C, 0x001C1C1C, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001F1F1F, 0x001F1F1F, 0x00202020, 0x00212121, 0x00202020, 0x00222222, 0x00212121, 
        0x00202020, 0x001F1F1F, 0x00222222, 0x00222222, 0x00222222, 0x00222222, 0x00222222, 0x00222222, 0x00222222, 0x00222222, 0x00212121, 0x00414141, 0x00404040, 0x003F3F3F, 0x00212121, 0x00222222, 0x00222222, 0x00222222, 0x00222222, 0x00212121, 
        0x00202020, 0x00212121, 0x00222222, 0x00222222, 0x00222222, 0x00212121, 0x00202020, 0x001F1F1F, 0x00202020, 0x00222222, 0x00222222, 0x00212121, 0x00202020, 0x001F1F1F, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 
        0x001B1B1B, 0x001A1A1A, 0x001A1A1A, 0x001A1A1A, 0x001A1A1A, 0x001A1A1A, 0x002B2B2B, 0x003A3A3A, 0x00848484, 0x00868686, 0x007F7F7F, 0x00787878, 0x00616161, 0x00292929, 0x00151515, 0x00151515, 0x00131313, 0x00131313, 0x00131313, 0x00131313, 
        0x00131313, 0x00141414, 0x00131313, 0x00131313, 0x00131313, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00282828, 0x00323232, 0x00323232, 0x00161616, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00797979, 0x00C4C4C4, 0x00646464, 0x00434343, 0x002C2C2C, 0x00111111, 0x00111111, 0x00111111, 0x001C1C1C, 0x00919191, 
        0x00B8B8B8, 0x002F2F2F, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x000000CC, 0x00111111, 0x00111111, 0x00787878, 0x00787878, 0x00787878, 0x00878787, 0x00878787, 0x00878787, 0x00878787, 0x00878787, 0x00878787, 0x00878787, 0xEF878787,
  0x00868686, 0x00868686, 0x00868686, 0x00868686, 0x00868686, 0x00868686, 0x00868686, 0x00797979, 0x00797979, 0x00797979, 0x00111111, 0x00111111, 0x000000CC, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00202020, 0x00444444, 
        0x007E7E7E, 0x00BCBCBC, 0x00B2B2B2, 0x00CBCBCB, 0x00909090, 0x00131313, 0x00131313, 0x00141414, 0x00141414, 0x00141414, 0x00171717, 0x00181818, 0x00181818, 0x00181818, 0x00181818, 0x00181818, 0x00181818, 0x00191919, 0x001A1A1A, 0x001A1A1A, 
        0x001A1A1A, 0x001A1A1A, 0x001B1B1B, 0x001C1C1C, 0x001C1C1C, 0x001C1C1C, 0x001C1C1C, 0x001C1C1C, 0x001C1C1C, 0x001C1C1C, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001F1F1F, 0x001E1E1E, 0x001E1E1E, 0x001F1F1F, 0x001F1F1F, 
        0x001F1F1F, 0x001F1F1F, 0x00202020, 0x00202020, 0x001F1F1F, 0x00202020, 0x00222222, 0x00222222, 0x00212121, 0x00202020, 0x00252525, 0x00414141, 0x00404040, 0x002F2F2F, 0x001F1F1F, 0x00212121, 0x00212121, 0x00212121, 0x001F1F1F, 0x001F1F1F, 
        0x001F1F1F, 0x00202020, 0x00212121, 0x00202020, 0x001F1F1F, 0x001F1F1F, 0x001F1F1F, 0x001F1F1F, 0x001E1E1E, 0x00202020, 0x001F1F1F, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001D1D1D, 0x001C1C1C, 0x001C1C1C, 
        0x001A1A1A, 0x001A1A1A, 0x001A1A1A, 0x00191919, 0x00272727, 0x004E4E4E, 0x00A1A1A1, 0x00A2A2A2, 0x009C9C9C, 0x00969696, 0x00909090, 0x00898989, 0x00838383, 0x007D7D7D, 0x00646464, 0x002A2A2A, 0x00131313, 0x00131313, 0x00121212, 0x00111111, 
        0x00111111, 0x00131313, 0x00131313, 0x00131313, 0x00121212, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x001F1F1F, 0x00343434, 0x00343434, 0x001D1D1D, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00848484, 0x00CCCCCC, 0x00404040, 0x00141414, 0x00111111, 0x00111111, 0x00262626, 0x003E3E3E, 0x00575757, 0x00A4A4A4, 
        0x00919191, 0x00363636, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x000202B2, 0x000D0D36, 0x00111111, 0x005F5F5F, 0x00797979, 0x00797979, 0x00828282, 0x00868686, 0x00868686, 0x00868686, 0x00868686, 0x00868686, 0x00868686, 0xCD868686,
  0x00858585, 0x00858585, 0x00858585, 0x00858585, 0x00858585, 0x00858585, 0x00858585, 0x00797979, 0x00797979, 0x00797979, 0x00111111, 0x00111111, 0x000000CC, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00252525, 0x00595959, 0x00A4A4A4, 0x00CCCCCC, 0x006B6B6B, 0x00131313, 0x00131313, 0x00131313, 0x00131313, 0x00141414, 0x00151515, 0x00161616, 0x00151515, 0x00171717, 0x00161616, 0x00181818, 0x00181818, 0x00181818, 0x00191919, 0x00191919, 
        0x00191919, 0x001A1A1A, 0x001A1A1A, 0x001B1B1B, 0x001C1C1C, 0x001B1B1B, 0x001C1C1C, 0x001C1C1C, 0x001C1C1C, 0x001C1C1C, 0x001D1D1D, 0x001E1E1E, 0x001E1E1E, 0x001D1D1D, 0x001C1C1C, 0x001D1D1D, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 
        0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001F1F1F, 0x001F1F1F, 0x001E1E1E, 0x00202020, 0x001F1F1F, 0x001E1E1E, 0x001E1E1E, 0x00272727, 0x00404040, 0x00404040, 0x00292929, 0x001E1E1E, 0x001F1F1F, 0x001F1F1F, 0x001F1F1F, 0x001F1F1F, 0x001F1F1F, 
        0x001E1E1E, 0x001E1E1E, 0x001F1F1F, 0x001F1F1F, 0x001F1F1F, 0x001F1F1F, 0x001E1E1E, 0x001E1E1E, 0x001D1D1D, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001D1D1D, 0x001C1C1C, 0x001C1C1C, 0x001C1C1C, 0x001C1C1C, 0x001C1C1C, 
        0x00191919, 0x00191919, 0x00181818, 0x00323232, 0x00909090, 0x00959595, 0x009A9A9A, 0x009B9B9B, 0x00979797, 0x00929292, 0x008C8C8C, 0x00868686, 0x00808080, 0x00797979, 0x00737373, 0x006C6C6C, 0x00393939, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00121212, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00181818, 0x00353535, 0x00353535, 0x00212121, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00606060, 0x00BEBEBE, 0x007C7C7C, 0x00696969, 0x00898989, 0x00BABABA, 0x00CCCCCC, 0x00CCCCCC, 0x00C4C4C4, 0x00A0A0A0, 
        0x00525252, 0x00151515, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x000202B2, 0x000D0D36, 0x00111111, 0x005F5F5F, 0x00797979, 0x00797979, 0x00828282, 0x00858585, 0x00858585, 0x00858585, 0x00858585, 0x00858585, 0x00858585, 0xCD858585,
  0x00848484, 0x00848484, 0x00848484, 0x00848484, 0x00848484, 0x00848484, 0x00848484, 0x007A7A7A, 0x007A7A7A, 0x00606060, 0x00111111, 0x000E0E29, 0x000202B2, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00242424, 0x003C3C3C, 0x00323232, 0x00111111, 0x00131313, 0x00131313, 0x00131313, 0x00131313, 0x00131313, 0x00141414, 0x00131313, 0x00141414, 0x00151515, 0x00171717, 0x00171717, 0x00161616, 0x00161616, 0x00181818, 
        0x00181818, 0x001A1A1A, 0x00191919, 0x00191919, 0x001A1A1A, 0x001A1A1A, 0x001C1C1C, 0x001C1C1C, 0x001B1B1B, 0x001A1A1A, 0x001B1B1B, 0x001C1C1C, 0x001C1C1C, 0x001C1C1C, 0x001C1C1C, 0x001C1C1C, 0x001D1D1D, 0x001C1C1C, 0x001C1C1C, 0x001E1E1E, 
        0x001E1E1E, 0x001E1E1E, 0x001D1D1D, 0x001E1E1E, 0x001E1E1E, 0x001D1D1D, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x00303030, 0x00424242, 0x00424242, 0x00242424, 0x001E1E1E, 0x001E1E1E, 0x001F1F1F, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 
        0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001D1D1D, 0x001C1C1C, 0x001C1C1C, 0x001C1C1C, 0x001E1E1E, 0x001D1D1D, 0x001D1D1D, 0x001C1C1C, 0x001C1C1C, 0x001C1C1C, 0x001C1C1C, 0x001C1C1C, 0x001B1B1B, 0x001A1A1A, 
        0x00181818, 0x00171717, 0x00303030, 0x00848484, 0x008A8A8A, 0x008F8F8F, 0x00919191, 0x00919191, 0x008F8F8F, 0x008B8B8B, 0x00868686, 0x00808080, 0x007A7A7A, 0x00747474, 0x006C6C6C, 0x00676767, 0x005C5C5C, 0x00353535, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00151515, 0x00373737, 0x00373737, 0x002C2C2C, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x003A3A3A, 0x00797979, 0x00B1B1B1, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00A2A2A2, 0x00787878, 0x00585858, 0x003C3C3C, 
        0x001F1F1F, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00040499, 0x000C0C42, 0x00111111, 0x004D4D4D, 0x007A7A7A, 0x007A7A7A, 0x00818181, 0x00848484, 0x00848484, 0x00848484, 0x00848484, 0x00848484, 0x00848484, 0xAB848484,
  0x00848484, 0x00848484, 0x00848484, 0x00848484, 0x00848484, 0x00848484, 0x00848484, 0x007B7B7B, 0x007B7B7B, 0x00606060, 0x00111111, 0x000D0D36, 0x000202B2, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00121212, 0x00131313, 0x00131313, 0x00141414, 0x00141414, 0x00131313, 0x00151515, 0x00151515, 0x00151515, 0x00171717, 
        0x00161616, 0x00181818, 0x00181818, 0x00181818, 0x00191919, 0x00191919, 0x001A1A1A, 0x001A1A1A, 0x001A1A1A, 0x001A1A1A, 0x001A1A1A, 0x001A1A1A, 0x001C1C1C, 0x001C1C1C, 0x001B1B1B, 0x001A1A1A, 0x001C1C1C, 0x001C1C1C, 0x001C1C1C, 0x001D1D1D, 
        0x001D1D1D, 0x001C1C1C, 0x001C1C1C, 0x001C1C1C, 0x001C1C1C, 0x001C1C1C, 0x001C1C1C, 0x001E1E1E, 0x001D1D1D, 0x001D1D1D, 0x00373737, 0x00444444, 0x00444444, 0x00212121, 0x001D1D1D, 0x001C1C1C, 0x001D1D1D, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 
        0x001D1D1D, 0x001D1D1D, 0x001E1E1E, 0x001D1D1D, 0x001C1C1C, 0x001C1C1C, 0x001C1C1C, 0x001C1C1C, 0x001C1C1C, 0x001B1B1B, 0x001C1C1C, 0x001C1C1C, 0x001C1C1C, 0x001C1C1C, 0x001C1C1C, 0x001B1B1B, 0x001A1A1A, 0x001A1A1A, 0x00191919, 0x00181818, 
        0x00161616, 0x00232323, 0x00787878, 0x007D7D7D, 0x00828282, 0x00868686, 0x00888888, 0x00888888, 0x00878787, 0x00838383, 0x007F7F7F, 0x00797979, 0x00747474, 0x006E6E6E, 0x00676767, 0x00606060, 0x00565656, 0x00565656, 0x00272727, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00393939, 0x00393939, 0x00393939, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00292929, 0x00505050, 0x004B4B4B, 0x00343434, 0x001C1C1C, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x0005058D, 0x000B0B4F, 0x00111111, 0x00464646, 0x007B7B7B, 0x007B7B7B, 0x00818181, 0x00848484, 0x00848484, 0x00848484, 0x00848484, 0x00848484, 0x00848484, 0xAB848484,
  0x00838383, 0x00838383, 0x00838383, 0x00838383, 0x00838383, 0x00838383, 0x00838383, 0x007C7C7C, 0x007C7C7C, 0x00606060, 0x00111111, 0x000D0D36, 0x000202B2, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00121212, 0x00111111, 0x00111111, 0x00131313, 0x00131313, 0x00141414, 0x00141414, 0x00141414, 0x00151515, 
        0x00151515, 0x00171717, 0x00171717, 0x00171717, 0x00181818, 0x00171717, 0x00171717, 0x00181818, 0x00181818, 0x001A1A1A, 0x001A1A1A, 0x00191919, 0x001A1A1A, 0x001A1A1A, 0x001A1A1A, 0x001A1A1A, 0x001B1B1B, 0x001B1B1B, 0x001A1A1A, 0x001B1B1B, 
        0x001B1B1B, 0x001A1A1A, 0x001A1A1A, 0x001A1A1A, 0x001C1C1C, 0x001C1C1C, 0x001B1B1B, 0x001C1C1C, 0x001C1C1C, 0x001C1C1C, 0x00444444, 0x00444444, 0x00434343, 0x001C1C1C, 0x001C1C1C, 0x001C1C1C, 0x001C1C1C, 0x001D1D1D, 0x001C1C1C, 0x001C1C1C, 
        0x001B1B1B, 0x001B1B1B, 0x001C1C1C, 0x001C1C1C, 0x001C1C1C, 0x001C1C1C, 0x001B1B1B, 0x001B1B1B, 0x001A1A1A, 0x001A1A1A, 0x001B1B1B, 0x001C1C1C, 0x001B1B1B, 0x001B1B1B, 0x001A1A1A, 0x00191919, 0x00181818, 0x00181818, 0x00181818, 0x00181818, 
        0x00161616, 0x00414141, 0x00717171, 0x00757575, 0x00797979, 0x007C7C7C, 0x007D7D7D, 0x007F7F7F, 0x007D7D7D, 0x007B7B7B, 0x00777777, 0x00727272, 0x006C6C6C, 0x00676767, 0x00616161, 0x00595959, 0x00525252, 0x00525252, 0x00474747, 0x00121212, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x002E2E2E, 0x003A3A3A, 0x003A3A3A, 0x00151515, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x0005058D, 0x000B0B4F, 0x00111111, 0x00474747, 0x007C7C7C, 0x007C7C7C, 0x00808080, 0x00838383, 0x00838383, 0x00838383, 0x00838383, 0x00838383, 0x00838383, 0xAB838383,
  0x00828282, 0x00828282, 0x00828282, 0x00828282, 0x00828282, 0x00828282, 0x00828282, 0x007C7C7C, 0x007C7C7C, 0x00606060, 0x00111111, 0x000D0D36, 0x000202B2, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00121212, 0x00111111, 0x00121212, 0x00131313, 0x00141414, 0x00151515, 
        0x00141414, 0x00141414, 0x00151515, 0x00141414, 0x00151515, 0x00151515, 0x00151515, 0x00171717, 0x00171717, 0x00181818, 0x00181818, 0x00181818, 0x00191919, 0x001A1A1A, 0x00191919, 0x00191919, 0x00181818, 0x00191919, 0x001A1A1A, 0x001A1A1A, 
        0x001A1A1A, 0x001A1A1A, 0x001A1A1A, 0x001A1A1A, 0x001A1A1A, 0x001A1A1A, 0x001A1A1A, 0x001B1B1B, 0x001C1C1C, 0x001B1B1B, 0x00434343, 0x00444444, 0x003D3D3D, 0x001C1C1C, 0x001C1C1C, 0x001B1B1B, 0x001A1A1A, 0x001C1C1C, 0x001B1B1B, 0x001A1A1A, 
        0x001A1A1A, 0x001A1A1A, 0x001B1B1B, 0x001B1B1B, 0x001B1B1B, 0x001A1A1A, 0x001A1A1A, 0x001A1A1A, 0x001A1A1A, 0x00191919, 0x00191919, 0x001A1A1A, 0x00191919, 0x00191919, 0x00181818, 0x00181818, 0x00181818, 0x00181818, 0x00171717, 0x00161616, 
        0x00212121, 0x00636363, 0x00686868, 0x006D6D6D, 0x006F6F6F, 0x00737373, 0x00747474, 0x00757575, 0x00737373, 0x00727272, 0x006E6E6E, 0x006A6A6A, 0x00656565, 0x005F5F5F, 0x00585858, 0x004E4E4E, 0x004E4E4E, 0x004E4E4E, 0x004E4E4E, 0x00242424, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00282828, 0x003C3C3C, 0x003C3C3C, 0x00181818, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x0005058D, 0x000B0B4F, 0x00111111, 0x00474747, 0x007C7C7C, 0x007C7C7C, 0x007F7F7F, 0x00828282, 0x00828282, 0x00828282, 0x00828282, 0x00828282, 0x00828282, 0xAB828282,
  0x00828282, 0x00828282, 0x00828282, 0x00828282, 0x00828282, 0x00828282, 0x00828282, 0x007D7D7D, 0x007D7D7D, 0x00616161, 0x00111111, 0x000D0D36, 0x000202B2, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00121212, 0x00111111, 0x00111111, 
        0x00131313, 0x00131313, 0x00131313, 0x00131313, 0x00141414, 0x00151515, 0x00151515, 0x00151515, 0x00151515, 0x00161616, 0x00181818, 0x00171717, 0x00171717, 0x00181818, 0x00171717, 0x00181818, 0x00181818, 0x00181818, 0x001A1A1A, 0x001A1A1A, 
        0x00191919, 0x00191919, 0x00191919, 0x001A1A1A, 0x001A1A1A, 0x001A1A1A, 0x00191919, 0x00191919, 0x001A1A1A, 0x001A1A1A, 0x00454545, 0x00464646, 0x00393939, 0x001A1A1A, 0x001A1A1A, 0x00191919, 0x00181818, 0x00191919, 0x001A1A1A, 0x001A1A1A, 
        0x001A1A1A, 0x00191919, 0x00191919, 0x001A1A1A, 0x001A1A1A, 0x001A1A1A, 0x001A1A1A, 0x00191919, 0x00181818, 0x00171717, 0x00161616, 0x00181818, 0x00181818, 0x00181818, 0x00181818, 0x00171717, 0x00161616, 0x00151515, 0x00151515, 0x00151515, 
        0x002B2B2B, 0x005B5B5B, 0x005F5F5F, 0x00636363, 0x00676767, 0x00696969, 0x006A6A6A, 0x006A6A6A, 0x006A6A6A, 0x00676767, 0x00646464, 0x00616161, 0x005C5C5C, 0x00565656, 0x00525252, 0x004A4A4A, 0x004A4A4A, 0x004A4A4A, 0x004A4A4A, 0x00353535, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00262626, 0x003E3E3E, 0x003E3E3E, 0x001A1A1A, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x0005058D, 0x000B0B4F, 0x00111111, 0x00484848, 0x007D7D7D, 0x007D7D7D, 0x007F7F7F, 0x00828282, 0x00828282, 0x00828282, 0x00828282, 0x00828282, 0x00828282, 0xAB828282,
  0x00818181, 0x00818181, 0x00818181, 0x00818181, 0x00818181, 0x00818181, 0x00818181, 0x007E7E7E, 0x007E7E7E, 0x00626262, 0x00111111, 0x000D0D36, 0x000202B2, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00121212, 0x00131313, 0x00131313, 0x00121212, 0x00121212, 0x00141414, 0x00151515, 0x00151515, 0x00151515, 0x00141414, 0x00151515, 0x00151515, 0x00151515, 0x00151515, 0x00151515, 0x00171717, 0x00181818, 0x00171717, 0x00181818, 0x00181818, 
        0x00181818, 0x00181818, 0x00181818, 0x00191919, 0x00191919, 0x00181818, 0x00181818, 0x00181818, 0x001A1A1A, 0x00191919, 0x00454545, 0x00454545, 0x00383838, 0x00191919, 0x00181818, 0x00181818, 0x00181818, 0x00181818, 0x00191919, 0x00181818, 
        0x00181818, 0x00181818, 0x00181818, 0x001A1A1A, 0x00191919, 0x00181818, 0x00181818, 0x00171717, 0x00161616, 0x00151515, 0x00151515, 0x00171717, 0x00171717, 0x00171717, 0x00151515, 0x00151515, 0x00151515, 0x00151515, 0x00151515, 0x00141414, 
        0x00373737, 0x00505050, 0x00555555, 0x00585858, 0x005C5C5C, 0x005E5E5E, 0x00606060, 0x00616161, 0x00606060, 0x005D5D5D, 0x005A5A5A, 0x00575757, 0x00525252, 0x00474747, 0x00464646, 0x00464646, 0x00464646, 0x00464646, 0x00464646, 0x00464646, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00272727, 0x003F3F3F, 0x003F3F3F, 0x001B1B1B, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x0005058D, 0x000B0B4F, 0x00111111, 0x00484848, 0x007E7E7E, 0x007E7E7E, 0x007F7F7F, 0x00818181, 0x00818181, 0x00818181, 0x00818181, 0x00818181, 0x00818181, 0xAB818181,
  0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x007F7F7F, 0x007F7F7F, 0x00666666, 0x00111111, 0x000D0D36, 0x000101B5, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00B2B2B2, 0x00B2B2B2, 0x00292929, 0x00111111, 0x00111111, 
        0x00111111, 0x00121212, 0x00111111, 0x00111111, 0x00111111, 0x00131313, 0x00141414, 0x00141414, 0x00131313, 0x00131313, 0x00131313, 0x00131313, 0x00141414, 0x00151515, 0x00151515, 0x00151515, 0x00161616, 0x00151515, 0x00151515, 0x00181818, 
        0x00171717, 0x00171717, 0x00151515, 0x00181818, 0x00181818, 0x00181818, 0x00181818, 0x00181818, 0x00181818, 0x00171717, 0x00444444, 0x00444444, 0x00393939, 0x00181818, 0x00181818, 0x00171717, 0x00161616, 0x00151515, 0x00181818, 0x00181818, 
        0x00181818, 0x00171717, 0x00161616, 0x00171717, 0x00171717, 0x00161616, 0x00151515, 0x00151515, 0x00151515, 0x00151515, 0x00141414, 0x00151515, 0x00151515, 0x00151515, 0x00151515, 0x00151515, 0x00141414, 0x00131313, 0x00131313, 0x00131313, 
        0x00424242, 0x00424242, 0x00454545, 0x004D4D4D, 0x00505050, 0x00535353, 0x00545454, 0x00555555, 0x00545454, 0x00525252, 0x004F4F4F, 0x004D4D4D, 0x00494949, 0x00424242, 0x00424242, 0x00424242, 0x00424242, 0x00424242, 0x00424242, 0x00424242, 
        0x00151515, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00282828, 0x00414141, 0x00414141, 0x001B1B1B, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00B2B2B2, 0x00B2B2B2, 0x00292929, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00040495, 0x00090956, 0x00111111, 0x004D4D4D, 0x007F7F7F, 0x007F7F7F, 0x007E7E7E, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0xA0808080,
  0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x007F7F7F, 0x007F7F7F, 0x00636363, 0x00111111, 0x000D0D36, 0x000202B2, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00CCCCCC, 0x00CCCCCC, 0x00363636, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00121212, 0x00121212, 0x00131313, 0x00131313, 0x00131313, 0x00131313, 0x00141414, 0x00131313, 0x00131313, 0x00151515, 0x00151515, 0x00141414, 0x00151515, 
        0x00151515, 0x00151515, 0x00151515, 0x00161616, 0x00171717, 0x00151515, 0x00161616, 0x00171717, 0x00151515, 0x00151515, 0x00464646, 0x00464646, 0x003C3C3C, 0x00161616, 0x00151515, 0x00151515, 0x00151515, 0x00151515, 0x00161616, 0x00161616, 
        0x00151515, 0x00141414, 0x00141414, 0x00141414, 0x00151515, 0x00151515, 0x00151515, 0x00141414, 0x00141414, 0x00131313, 0x00131313, 0x00151515, 0x00151515, 0x00141414, 0x00141414, 0x00131313, 0x00131313, 0x00131313, 0x00131313, 0x00121212, 
        0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x00454545, 0x00484848, 0x00494949, 0x00484848, 0x00494949, 0x00484848, 0x00414141, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 
        0x00161616, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x002B2B2B, 0x00434343, 0x00434343, 0x001D1D1D, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00CCCCCC, 0x00CCCCCC, 0x00363636, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x0005058D, 0x000B0B4F, 0x00111111, 0x00484848, 0x007F7F7F, 0x007F7F7F, 0x007E7E7E, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0x00808080, 0xAB808080,
  0x007F7F7F, 0x007F7F7F, 0x007F7F7F, 0x007F7F7F, 0x007F7F7F, 0x007F7F7F, 0x007F7F7F, 0x00808080, 0x00808080, 0x00646464, 0x00111111, 0x000D0D36, 0x000202B2, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00121212, 0x00111111, 0x00111111, 0x00131313, 0x00131313, 0x00131313, 0x00131313, 0x00131313, 0x00131313, 0x00141414, 
        0x00151515, 0x00141414, 0x00141414, 0x00131313, 0x00141414, 0x00131313, 0x00131313, 0x00151515, 0x00151515, 0x00151515, 0x00464646, 0x00454545, 0x00383838, 0x00151515, 0x00151515, 0x00151515, 0x00141414, 0x00151515, 0x00151515, 0x00141414, 
        0x00131313, 0x00131313, 0x00131313, 0x00131313, 0x00141414, 0x00141414, 0x00131313, 0x00131313, 0x00131313, 0x00131313, 0x00131313, 0x00131313, 0x00131313, 0x00131313, 0x00131313, 0x00131313, 0x00131313, 0x00121212, 0x00111111, 0x00111111, 
        0x002E2E2E, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00292929, 0x00444444, 0x00444444, 0x001C1C1C, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x0005058D, 0x000B0B4F, 0x00111111, 0x00494949, 0x00808080, 0x00808080, 0x007D7D7D, 0x007F7F7F, 0x007F7F7F, 0x007F7F7F, 0x007F7F7F, 0x007F7F7F, 0x007F7F7F, 0xAB7F7F7F,
  0x007E7E7E, 0x007E7E7E, 0x007E7E7E, 0x007E7E7E, 0x007E7E7E, 0x007E7E7E, 0x007E7E7E, 0x00818181, 0x00818181, 0x00656565, 0x00111111, 0x000D0D36, 0x000202B2, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00131313, 0x00131313, 0x00121212, 
        0x00131313, 0x00131313, 0x00121212, 0x00111111, 0x00131313, 0x00131313, 0x00131313, 0x00141414, 0x00141414, 0x00131313, 0x00474747, 0x00474747, 0x00393939, 0x00141414, 0x00131313, 0x00131313, 0x00121212, 0x00131313, 0x00131313, 0x00131313, 
        0x00131313, 0x00131313, 0x00121212, 0x00111111, 0x00121212, 0x00131313, 0x00131313, 0x00131313, 0x00121212, 0x00111111, 0x00111111, 0x00111111, 0x00131313, 0x00131313, 0x00121212, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00222222, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x002B2B2B, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x002A2A2A, 0x00464646, 0x00464646, 0x001D1D1D, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x0005058D, 0x000B0B4F, 0x00111111, 0x00494949, 0x00818181, 0x00818181, 0x007D7D7D, 0x007E7E7E, 0x007E7E7E, 0x007E7E7E, 0x007E7E7E, 0x007E7E7E, 0x007E7E7E, 0xAB7E7E7E,
  0x007E7E7E, 0x007E7E7E, 0x007E7E7E, 0x007E7E7E, 0x007E7E7E, 0x007E7E7E, 0x007E7E7E, 0x00828282, 0x00828282, 0x00666666, 0x00111111, 0x000D0D36, 0x000202B2, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00121212, 0x00121212, 0x00111111, 0x00111111, 0x00131313, 0x00131313, 0x00494949, 0x00484848, 0x003A3A3A, 0x00131313, 0x00121212, 0x00111111, 0x00111111, 0x00131313, 0x00131313, 0x00121212, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00121212, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00171717, 0x00323232, 0x00323232, 0x00323232, 0x00323232, 0x00323232, 0x00323232, 0x00323232, 0x00323232, 0x00323232, 0x00323232, 0x00323232, 0x00323232, 0x00323232, 0x00323232, 0x00323232, 0x00323232, 0x00323232, 0x00323232, 0x001C1C1C, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x002F2F2F, 0x00484848, 0x00484848, 0x001D1D1D, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x0005058D, 0x000B0B4F, 0x00111111, 0x004A4A4A, 0x00828282, 0x00828282, 0x007D7D7D, 0x007E7E7E, 0x007E7E7E, 0x007E7E7E, 0x007E7E7E, 0x007E7E7E, 0x007E7E7E, 0xAB7E7E7E,
  0x007D7D7D, 0x007D7D7D, 0x007D7D7D, 0x007D7D7D, 0x007D7D7D, 0x007D7D7D, 0x007D7D7D, 0x00828282, 0x00828282, 0x00666666, 0x00111111, 0x000E0E29, 0x000202B2, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00494949, 0x00494949, 0x00494949, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00252525, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x002E2E2E, 0x00121212, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x003A3A3A, 0x00494949, 0x00494949, 0x00181818, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00232323, 0x00686868, 0x00464646, 0x00262626, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x0005058D, 0x000B0B4F, 0x00111111, 0x004A4A4A, 0x00828282, 0x00828282, 0x007D7D7D, 0x007D7D7D, 0x007D7D7D, 0x007D7D7D, 0x007D7D7D, 0x007D7D7D, 0x007D7D7D, 0xAB7D7D7D,
  0x007C7C7C, 0x007C7C7C, 0x007C7C7C, 0x007C7C7C, 0x007C7C7C, 0x007C7C7C, 0x007C7C7C, 0x00838383, 0x00838383, 0x00838383, 0x00111111, 0x00111111, 0x000000CC, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x003B3B3B, 0x004B4B4B, 0x004B4B4B, 0x00191919, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00161616, 0x002A2A2A, 0x002A2A2A, 0x002A2A2A, 0x002A2A2A, 0x002A2A2A, 0x002A2A2A, 0x002A2A2A, 0x002A2A2A, 0x002A2A2A, 0x002A2A2A, 0x002A2A2A, 0x002A2A2A, 0x002A2A2A, 0x002A2A2A, 0x002A2A2A, 0x002A2A2A, 0x00191919, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 0x00121212, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x003E3E3E, 0x00BCBCBC, 0x00989898, 0x005A5A5A, 0x00212121, 0x00111111, 0x00111111, 0x00252525, 0x004F4F4F, 
        0x00373737, 0x001C1C1C, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x000202B2, 0x000D0D36, 0x00111111, 0x00666666, 0x00838383, 0x00838383, 0x007B7B7B, 0x007C7C7C, 0x007C7C7C, 0x007C7C7C, 0x007C7C7C, 0x007C7C7C, 0x007C7C7C, 0xCD7C7C7C,
  0x007B7B7B, 0x007B7B7B, 0x007B7B7B, 0x007B7B7B, 0x007B7B7B, 0x007B7B7B, 0x007B7B7B, 0x00848484, 0x00848484, 0x00848484, 0x00111111, 0x00111111, 0x000000CC, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00323232, 0x004D4D4D, 0x004D4D4D, 0x001E1E1E, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x001A1A1A, 0x00262626, 0x00262626, 0x00262626, 0x00262626, 0x00262626, 0x00262626, 0x00262626, 0x00262626, 0x00262626, 0x00262626, 0x00262626, 0x00262626, 0x00262626, 0x00262626, 0x001D1D1D, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00161616, 0x004D4D4D, 0x004D4D4D, 0x00434343, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00545454, 0x00CCCCCC, 0x00A5A5A5, 0x00A1A1A1, 0x00727272, 0x002C2C2C, 0x00111111, 0x00464646, 0x00CCCCCC, 
        0x00B1B1B1, 0x005E5E5E, 0x001C1C1C, 0x00111111, 0x00111111, 0x00111111, 0x000202B2, 0x000D0D36, 0x00111111, 0x00676767, 0x00848484, 0x00848484, 0x007B7B7B, 0x007B7B7B, 0x007B7B7B, 0x007B7B7B, 0x007B7B7B, 0x007B7B7B, 0x007B7B7B, 0xCD7B7B7B,
  0x127B7B7B, 0x007B7B7B, 0x007B7B7B, 0x007B7B7B, 0x007B7B7B, 0x007B7B7B, 0x007B7B7B, 0x00808080, 0x00858585, 0x00858585, 0x001D1D1D, 0x00111111, 0x000202B2, 0x000E0E29, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00272727, 0x004E4E4E, 0x004E4E4E, 0x00242424, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00181818, 0x00222222, 0x00222222, 0x00222222, 0x00222222, 0x00222222, 0x00222222, 0x00222222, 0x00222222, 0x00222222, 0x00222222, 0x00222222, 0x00222222, 0x001A1A1A, 0x000F0F0F, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x001E1E1E, 0x004E4E4E, 0x004E4E4E, 0x00333333, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00707070, 0x00CCCCCC, 0x005A5A5A, 0x00656565, 0x00B2B2B2, 0x00969696, 0x00484848, 0x003D3D3D, 0x00626262, 
        0x00A4A4A4, 0x00B2B2B2, 0x00464646, 0x00111111, 0x00111111, 0x00111111, 0x000000CC, 0x00111111, 0x00111111, 0x00747474, 0x00858585, 0x00858585, 0x007A7A7A, 0x007B7B7B, 0x007B7B7B, 0x007B7B7B, 0x007B7B7B, 0x007B7B7B, 0x007B7B7B, 0xDE7B7B7B,
  0x237A7A7A, 0x007A7A7A, 0x007A7A7A, 0x007A7A7A, 0x007A7A7A, 0x007A7A7A, 0x007A7A7A, 0x007F7F7F, 0x00858585, 0x00858585, 0x00232323, 0x00111111, 0x000202B2, 0x000D0D36, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00222222, 0x00505050, 0x00505050, 0x00333333, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00131313, 0x001A1A1A, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x001E1E1E, 0x00141414, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00282828, 0x00505050, 0x00505050, 0x00282828, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00989898, 0x00CCCCCC, 0x002C2C2C, 0x001C1C1C, 0x00545454, 0x00ACACAC, 0x009E9E9E, 0x005E5E5E, 0x00434343, 
        0x00868686, 0x00C7C7C7, 0x003E3E3E, 0x00111111, 0x00111111, 0x00111111, 0x000000CC, 0x00111111, 0x00111111, 0x00858585, 0x00858585, 0x00858585, 0x007A7A7A, 0x007A7A7A, 0x007A7A7A, 0x007A7A7A, 0x007A7A7A, 0x007A7A7A, 0x007A7A7A, 0xFF000000,
  0x45797979, 0x00797979, 0x00797979, 0x00797979, 0x00797979, 0x00797979, 0x00797979, 0x007C7C7C, 0x00868686, 0x00868686, 0x002E2E2E, 0x00111111, 0x0005058D, 0x000B0B4F, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x001E1E1E, 0x00363636, 0x004D4D4D, 0x004E4E4E, 0x00191919, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00171717, 0x00525252, 0x00525252, 0x00474747, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x000F0F0F, 0x00121212, 0x00151515, 0x001A1A1A, 0x001A1A1A, 0x001A1A1A, 0x001A1A1A, 0x00161616, 0x00121212, 0x00101010, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x003A3A3A, 0x00525252, 0x00525252, 0x001C1C1C, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00313131, 0x00464646, 0x00111111, 0x00111111, 0x00111111, 0x003C3C3C, 0x007C7C7C, 0x00A5A5A5, 0x00A1A1A1, 
        0x00B1B1B1, 0x008A8A8A, 0x00232323, 0x00111111, 0x00111111, 0x000D0D36, 0x000202B2, 0x00111111, 0x001E1E1E, 0x00868686, 0x00868686, 0x00808080, 0x00797979, 0x00797979, 0x00797979, 0x00797979, 0x00797979, 0x00797979, 0x12797979, 0xFF000000,
  0x56797979, 0x00797979, 0x00797979, 0x00797979, 0x00797979, 0x00797979, 0x00797979, 0x007C7C7C, 0x00878787, 0x00878787, 0x00333333, 0x00111111, 0x00060680, 0x000A0A5B, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00252525, 0x00414141, 0x005C5C5C, 
        0x007C7C7C, 0x00A7A7A7, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00ABABAB, 0x006C6C6C, 0x00262626, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00292929, 0x004F4F4F, 0x00747474, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00414141, 0x00535353, 0x00535353, 0x001D1D1D, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00131313, 0x00535353, 0x00535353, 0x00535353, 0x00131313, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00747474, 0x004F4F4F, 0x00292929, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00141414, 0x002C2C2C, 0x004A4A4A, 0x00666666, 
        0x005C5C5C, 0x00232323, 0x00111111, 0x00111111, 0x00111111, 0x000C0C42, 0x00040499, 0x00111111, 0x00232323, 0x00878787, 0x00878787, 0x007F7F7F, 0x00797979, 0x00797979, 0x00797979, 0x00797979, 0x00797979, 0x00797979, 0x23797979, 0xFF000000,
  0x78787878, 0x00787878, 0x00787878, 0x00787878, 0x00787878, 0x00787878, 0x00787878, 0x007B7B7B, 0x00888888, 0x00888888, 0x003F3F3F, 0x00111111, 0x00090967, 0x00070774, 0x00111111, 0x00111111, 0x00111111, 0x00191919, 0x00646464, 0x00ABABAB, 0x00C7C7C7, 
        0x00CCCCCC, 0x00CCCCCC, 0x00B4B4B4, 0x00848484, 0x00686868, 0x00929292, 0x00BABABA, 0x00444444, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x001D1D1D, 0x00424242, 0x005B5B5B, 
        0x00808080, 0x00A5A5A5, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00292929, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x002E2E2E, 0x00555555, 0x00555555, 0x002A2A2A, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00212121, 0x00555555, 0x00555555, 0x00373737, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00292929, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00A5A5A5, 0x00808080, 
        0x005B5B5B, 0x00424242, 0x001D1D1D, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x003F3F3F, 0x00707070, 0x00474747, 0x00242424, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x000B0B4F, 0x0005058D, 0x00111111, 0x002E2E2E, 0x00888888, 0x00888888, 0x007D7D7D, 0x00787878, 0x00787878, 0x00787878, 0x00787878, 0x00787878, 0x00787878, 0x56787878, 0xFF000000,
  0x89777777, 0x00777777, 0x00777777, 0x00777777, 0x00777777, 0x00777777, 0x00777777, 0x00797979, 0x00888888, 0x00888888, 0x004D4D4D, 0x00111111, 0x000B0B4F, 0x0005058D, 0x00111111, 0x00111111, 0x00111111, 0x00484848, 0x00A2A2A2, 0x008E8E8E, 0x00545454, 
        0x003C3C3C, 0x00252525, 0x00111111, 0x00111111, 0x00181818, 0x00585858, 0x00CCCCCC, 0x005D5D5D, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x001D1D1D, 0x00B2B2B2, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 
        0x00CCCCCC, 0x00BEBEBE, 0x00A5A5A5, 0x00808080, 0x005B5B5B, 0x00363636, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00212121, 0x00575757, 0x00575757, 0x00444444, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00333333, 0x00575757, 0x00575757, 0x00272727, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00363636, 0x005B5B5B, 0x00808080, 0x00A5A5A5, 0x00BEBEBE, 0x00CCCCCC, 
        0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00B2B2B2, 0x001D1D1D, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x005C5C5C, 0x00BCBCBC, 0x00959595, 0x00555555, 0x00252525, 0x00111111, 0x00111111, 0x003D3D3D, 0x00585858, 0x003C3C3C, 
        0x001E1E1E, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00070774, 0x00070774, 0x00111111, 0x003F3F3F, 0x00888888, 0x00888888, 0x007A7A7A, 0x00777777, 0x00777777, 0x00777777, 0x00777777, 0x00777777, 0x00777777, 0x67777777, 0xFF000000,
  0xAB777777, 0x00777777, 0x00777777, 0x00777777, 0x00777777, 0x00777777, 0x00777777, 0x00787878, 0x00898989, 0x00898989, 0x00606060, 0x00111111, 0x000D0D36, 0x000202B2, 0x00111111, 0x00111111, 0x00111111, 0x00484848, 0x00BCBCBC, 0x00686868, 0x00191919, 
        0x00111111, 0x00111111, 0x00141414, 0x002E2E2E, 0x00464646, 0x00777777, 0x00B5B5B5, 0x005C5C5C, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00A5A5A5, 0x008D8D8D, 0x00747474, 0x004F4F4F, 
        0x00292929, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x004C4C4C, 0x00585858, 0x00585858, 0x001A1A1A, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00131313, 0x00585858, 0x00585858, 0x00585858, 0x00171717, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00292929, 
        0x004F4F4F, 0x00747474, 0x008D8D8D, 0x00A5A5A5, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x007C7C7C, 0x00CCCCCC, 0x00919191, 0x00A4A4A4, 0x00666666, 0x00252525, 0x00111111, 0x00686868, 0x00CCCCCC, 0x00A5A5A5, 
        0x00515151, 0x00191919, 0x00111111, 0x00111111, 0x00111111, 0x0005058D, 0x000B0B4F, 0x00111111, 0x004E4E4E, 0x00898989, 0x00898989, 0x00797979, 0x00777777, 0x00777777, 0x00777777, 0x00777777, 0x00777777, 0x00777777, 0x89777777, 0xFF000000,
  0xCD767676, 0x00767676, 0x00767676, 0x00767676, 0x00767676, 0x00767676, 0x00767676, 0x00757575, 0x008A8A8A, 0x008A8A8A, 0x00787878, 0x00111111, 0x00111111, 0x000000CC, 0x00111111, 0x00111111, 0x00111111, 0x00363636, 0x00BEBEBE, 0x009C9C9C, 0x005C5C5C, 
        0x00707070, 0x00979797, 0x00CCCCCC, 0x00CCCCCC, 0x00CACACA, 0x00B5B5B5, 0x00767676, 0x00242424, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00303030, 0x005A5A5A, 0x005A5A5A, 0x00353535, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00282828, 0x005A5A5A, 0x005A5A5A, 0x003F3F3F, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00A7A7A7, 0x00CCCCCC, 0x00404040, 0x006A6A6A, 0x00AEAEAE, 0x00949494, 0x00414141, 0x003C3C3C, 0x00595959, 0x00B1B1B1, 
        0x00ABABAB, 0x00313131, 0x00111111, 0x00111111, 0x00111111, 0x000303A5, 0x000D0D36, 0x00111111, 0x00606060, 0x008A8A8A, 0x008A8A8A, 0x00777777, 0x00767676, 0x00767676, 0x00767676, 0x00767676, 0x00767676, 0x00767676, 0xAB767676, 0xFF000000,
  0xFF000000, 0x00757575, 0x00757575, 0x00757575, 0x00757575, 0x00757575, 0x00757575, 0x00757575, 0x00848484, 0x008A8A8A, 0x008A8A8A, 0x001E1E1E, 0x00111111, 0x000202B2, 0x000E0E29, 0x00111111, 0x00111111, 0x001B1B1B, 0x00707070, 0x00AEAEAE, 0x00BEBEBE, 
        0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00939393, 0x006D6D6D, 0x004E4E4E, 0x002F2F2F, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x001B1B1B, 0x005C5C5C, 0x005C5C5C, 0x005C5C5C, 0x00171717, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00484848, 0x005C5C5C, 0x005C5C5C, 0x00222222, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x001E1E1E, 0x00CCCCCC, 0x00B4B4B4, 0x00111111, 0x001F1F1F, 0x005C5C5C, 0x00CCCCCC, 0x00A4A4A4, 0x005F5F5F, 0x004A4A4A, 0x00BABABA, 
        0x00C0C0C0, 0x001E1E1E, 0x00111111, 0x00111111, 0x00111111, 0x000000CC, 0x00111111, 0x00111111, 0x00787878, 0x008A8A8A, 0x008A8A8A, 0x00767676, 0x00757575, 0x00757575, 0x00757575, 0x00757575, 0x00757575, 0x00757575, 0xCD757575, 0xFF000000,
  0xFF000000, 0x23757575, 0x00757575, 0x00757575, 0x00757575, 0x00757575, 0x00757575, 0x00757575, 0x007F7F7F, 0x008B8B8B, 0x008B8B8B, 0x00292929, 0x00111111, 0x0005058D, 0x000B0B4F, 0x00111111, 0x00111111, 0x00111111, 0x00181818, 0x00505050, 0x00535353, 
        0x00424242, 0x002C2C2C, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00424242, 0x005E5E5E, 0x005E5E5E, 0x002D2D2D, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00232323, 0x005E5E5E, 0x005E5E5E, 0x00525252, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00262626, 0x00343434, 0x00111111, 0x00111111, 0x00161616, 0x00404040, 0x00828282, 0x00ABABAB, 0x00A4A4A4, 0x00A4A4A4, 
        0x006C6C6C, 0x00111111, 0x00111111, 0x00111111, 0x000E0E29, 0x000202B2, 0x00111111, 0x001E1E1E, 0x008B8B8B, 0x008B8B8B, 0x00858585, 0x00757575, 0x00757575, 0x00757575, 0x00757575, 0x00757575, 0x00757575, 0x00757575, 0xFF000000, 0xFF000000,
  0xFF000000, 0x56747474, 0x00747474, 0x00747474, 0x00747474, 0x00747474, 0x00747474, 0x00747474, 0x007A7A7A, 0x008C8C8C, 0x008C8C8C, 0x003A3A3A, 0x00111111, 0x00070774, 0x00070774, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00464646, 0x00969696, 0x004D4D4D, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00232323, 0x005F5F5F, 0x005F5F5F, 0x00535353, 0x00171717, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00494949, 0x005F5F5F, 0x005F5F5F, 0x002E2E2E, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00282828, 0x00434343, 0x00565656, 0x00484848, 
        0x001E1E1E, 0x00111111, 0x00111111, 0x00111111, 0x000B0B4F, 0x0005058D, 0x00111111, 0x002A2A2A, 0x008C8C8C, 0x008C8C8C, 0x007D7D7D, 0x00747474, 0x00747474, 0x00747474, 0x00747474, 0x00747474, 0x00747474, 0x23747474, 0xFF000000, 0xFF000000,
  0xFF000000, 0x78737373, 0x00737373, 0x00737373, 0x00737373, 0x00737373, 0x00737373, 0x00737373, 0x00777777, 0x008D8D8D, 0x008D8D8D, 0x004F4F4F, 0x00111111, 0x000B0B4F, 0x00040499, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00222222, 0x00454545, 
        0x00616161, 0x00686868, 0x004E4E4E, 0x00333333, 0x00252525, 0x00151515, 0x004B4B4B, 0x00CCCCCC, 0x00666666, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x004B4B4B, 0x00616161, 0x00616161, 0x00333333, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00272727, 0x00616161, 0x00616161, 0x00545454, 0x00131313, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00161616, 0x00414141, 0x00595959, 0x004F4F4F, 0x003C3C3C, 0x00252525, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00070774, 0x00090967, 0x00111111, 0x003B3B3B, 0x008D8D8D, 0x008D8D8D, 0x00797979, 0x00737373, 0x00737373, 0x00737373, 0x00737373, 0x00737373, 0x00737373, 0x56737373, 0xFF000000, 0xFF000000,
  0xFF000000, 0xAB727272, 0x00727272, 0x00727272, 0x00727272, 0x00727272, 0x00727272, 0x00727272, 0x00747474, 0x008D8D8D, 0x008D8D8D, 0x006E6E6E, 0x00111111, 0x000E0E29, 0x000101BE, 0x00111111, 0x00111111, 0x00111111, 0x001B1B1B, 0x00525252, 0x009E9E9E, 
        0x00A2A2A2, 0x00A4A4A4, 0x00BFBFBF, 0x00A7A7A7, 0x006D6D6D, 0x004F4F4F, 0x00545454, 0x00CCCCCC, 0x00898989, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00202020, 0x00636363, 0x00636363, 0x00636363, 0x001C1C1C, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00141414, 0x00555555, 0x00636363, 0x00636363, 0x002B2B2B, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x005F5F5F, 0x009B9B9B, 0x00B6B6B6, 0x00C5C5C5, 0x00CCCCCC, 0x00CCCCCC, 0x00B4B4B4, 0x00848484, 0x005F5F5F, 0x00404040, 0x001C1C1C, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00040499, 0x000C0C42, 0x00111111, 0x004F4F4F, 0x008D8D8D, 0x008D8D8D, 0x00767676, 0x00727272, 0x00727272, 0x00727272, 0x00727272, 0x00727272, 0x00727272, 0x78727272, 0xFF000000, 0xFF000000,
  0xFF000000, 0xDE727272, 0x00727272, 0x00727272, 0x00727272, 0x00727272, 0x00727272, 0x00727272, 0x00727272, 0x008E8E8E, 0x008E8E8E, 0x008E8E8E, 0x00171717, 0x00111111, 0x000202B2, 0x000E0E29, 0x00111111, 0x00111111, 0x002A2A2A, 0x00A0A0A0, 0x00ABABAB, 
        0x00444444, 0x00353535, 0x004D4D4D, 0x007F7F7F, 0x00949494, 0x00AEAEAE, 0x00949494, 0x00CCCCCC, 0x00BABABA, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x003F3F3F, 0x00646464, 0x00646464, 0x00464646, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00353535, 0x00646464, 0x00646464, 0x004E4E4E, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00B6B6B6, 0x00CACACA, 0x00505050, 0x005D5D5D, 0x007C7C7C, 0x00A7A7A7, 0x00CCCCCC, 0x00CCCCCC, 0x00C0C0C0, 0x009B9B9B, 0x003E3E3E, 
        0x00121212, 0x00111111, 0x00111111, 0x00111111, 0x000101BE, 0x000F0F1D, 0x00111111, 0x006E6E6E, 0x008E8E8E, 0x008E8E8E, 0x00747474, 0x00727272, 0x00727272, 0x00727272, 0x00727272, 0x00727272, 0x00727272, 0xAB727272, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0x12717171, 0x00717171, 0x00717171, 0x00717171, 0x00717171, 0x00717171, 0x00717171, 0x00808080, 0x008F8F8F, 0x008F8F8F, 0x002A2A2A, 0x00111111, 0x0005058D, 0x000A0A5B, 0x00111111, 0x00111111, 0x00151515, 0x00BFBFBF, 0x00CACACA, 
        0x00636363, 0x007E7E7E, 0x001B1B1B, 0x00111111, 0x00323232, 0x00505050, 0x006B6B6B, 0x008F8F8F, 0x00ACACAC, 0x00232323, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00181818, 0x00666666, 0x00666666, 0x00666666, 0x002D2D2D, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00242424, 0x00666666, 0x00666666, 0x00666666, 0x00212121, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00262626, 0x00CCCCCC, 0x00A5A5A5, 0x001F1F1F, 0x00111111, 0x00111111, 0x00111111, 0x001E1E1E, 0x00373737, 0x00575757, 0x00CCCCCC, 0x008A8A8A, 
        0x00131313, 0x00111111, 0x00111111, 0x000D0D36, 0x000202B2, 0x00111111, 0x001F1F1F, 0x008F8F8F, 0x008F8F8F, 0x00878787, 0x00717171, 0x00717171, 0x00717171, 0x00717171, 0x00717171, 0x00717171, 0x00717171, 0xDE717171, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0x45707070, 0x00707070, 0x00707070, 0x00707070, 0x00707070, 0x00707070, 0x00707070, 0x00787878, 0x00909090, 0x00909090, 0x00424242, 0x00111111, 0x000A0A5B, 0x00060680, 0x00111111, 0x00111111, 0x00111111, 0x00666666, 0x00989898, 
        0x00BFBFBF, 0x00CCCCCC, 0x00313131, 0x00111111, 0x00111111, 0x00111111, 0x00252525, 0x00292929, 0x00191919, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00313131, 0x00686868, 0x00686868, 0x00686868, 
        0x001D1D1D, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00191919, 
        0x005A5A5A, 0x00686868, 0x00686868, 0x003C3C3C, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00303030, 0x00929292, 0x00B4B4B4, 0x00686868, 0x004A4A4A, 0x00333333, 0x001B1B1B, 0x00111111, 0x00111111, 0x00363636, 0x00CACACA, 0x00959595, 
        0x00111111, 0x00111111, 0x00111111, 0x000A0A5B, 0x00060680, 0x00111111, 0x00303030, 0x00909090, 0x00909090, 0x007C7C7C, 0x00707070, 0x00707070, 0x00707070, 0x00707070, 0x00707070, 0x00707070, 0x12707070, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0x78707070, 0x00707070, 0x00707070, 0x00707070, 0x00707070, 0x00707070, 0x00707070, 0x00757575, 0x00909090, 0x00909090, 0x005A5A5A, 0x00111111, 0x000D0D36, 0x000202B2, 0x00111111, 0x00111111, 0x00111111, 0x001C1C1C, 0x00404040, 
        0x004A4A4A, 0x003A3A3A, 0x00171717, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00494949, 0x00696969, 0x00696969, 
        0x00515151, 0x00141414, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00494949, 
        0x00696969, 0x00696969, 0x00515151, 0x00141414, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00141414, 0x004B4B4B, 0x00A4A4A4, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00A1A1A1, 0x00797979, 0x00797979, 0x00B4B4B4, 0x00636363, 
        0x00111111, 0x00111111, 0x00111111, 0x00040499, 0x000B0B4F, 0x00111111, 0x00494949, 0x00909090, 0x00909090, 0x00787878, 0x00707070, 0x00707070, 0x00707070, 0x00707070, 0x00707070, 0x00707070, 0x56707070, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xBC6F6F6F, 0x006F6F6F, 0x006F6F6F, 0x006F6F6F, 0x006F6F6F, 0x006F6F6F, 0x006F6F6F, 0x006F6F6F, 0x00919191, 0x00919191, 0x00919191, 0x00111111, 0x00111111, 0x000101BE, 0x000E0E29, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00363636, 
        0x00747474, 0x00424242, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00191919, 0x005D5D5D, 0x006B6B6B, 
        0x006B6B6B, 0x00434343, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00383838, 0x006B6B6B, 
        0x006B6B6B, 0x006B6B6B, 0x001E1E1E, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00424242, 0x00808080, 
        0x00363636, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00171717, 0x00343434, 0x004D4D4D, 0x00666666, 0x00898989, 0x00BCBCBC, 0x00CCCCCC, 0x00BFBFBF, 0x00A4A4A4, 0x006F6F6F, 0x00383838, 
        0x00111111, 0x00111111, 0x00111111, 0x000101BE, 0x000F0F1D, 0x00111111, 0x00707070, 0x00919191, 0x00919191, 0x00737373, 0x006F6F6F, 0x006F6F6F, 0x006F6F6F, 0x006F6F6F, 0x006F6F6F, 0x006F6F6F, 0x896F6F6F, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xEF6E6E6E, 0x006E6E6E, 0x006E6E6E, 0x006E6E6E, 0x006E6E6E, 0x006E6E6E, 0x006E6E6E, 0x006E6E6E, 0x00848484, 0x00929292, 0x00929292, 0x002B2B2B, 0x00111111, 0x0005058D, 0x000A0A5B, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x008D8D8D, 
        0x00CCCCCC, 0x008D8D8D, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00232323, 0x006D6D6D, 
        0x006D6D6D, 0x006D6D6D, 0x003E3E3E, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00333333, 0x006D6D6D, 0x006D6D6D, 
        0x006D6D6D, 0x002F2F2F, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00808080, 0x00CCCCCC, 
        0x008D8D8D, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00282828, 0x003C3C3C, 0x00434343, 0x002A2A2A, 0x00111111, 
        0x00111111, 0x00111111, 0x000C0C42, 0x000303A5, 0x00111111, 0x001F1F1F, 0x00929292, 0x00929292, 0x00929292, 0x006E6E6E, 0x006E6E6E, 0x006E6E6E, 0x006E6E6E, 0x006E6E6E, 0x006E6E6E, 0x006E6E6E, 0xCD6E6E6E, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0x346E6E6E, 0x006E6E6E, 0x006E6E6E, 0x006E6E6E, 0x006E6E6E, 0x006E6E6E, 0x006E6E6E, 0x00777777, 0x00939393, 0x00939393, 0x004B4B4B, 0x00111111, 0x000B0B4F, 0x0005058D, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00363636, 
        0x00363636, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x002F2F2F, 
        0x006E6E6E, 0x006E6E6E, 0x006E6E6E, 0x00393939, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x002B2B2B, 0x006E6E6E, 0x006E6E6E, 0x006E6E6E, 
        0x00393939, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00363636, 
        0x00363636, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00070774, 0x00070774, 0x00111111, 0x00373737, 0x00939393, 0x00939393, 0x007D7D7D, 0x006E6E6E, 0x006E6E6E, 0x006E6E6E, 0x006E6E6E, 0x006E6E6E, 0x006E6E6E, 0x126E6E6E, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0x786D6D6D, 0x006D6D6D, 0x006D6D6D, 0x006D6D6D, 0x006D6D6D, 0x006D6D6D, 0x006D6D6D, 0x00727272, 0x00939393, 0x00939393, 0x00727272, 0x00111111, 0x000F0F1D, 0x000101BE, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x003A3A3A, 0x00707070, 0x00707070, 0x00707070, 0x00404040, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00353535, 0x00707070, 0x00707070, 0x00707070, 0x00464646, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x000303A5, 0x000C0C42, 0x00111111, 0x00535353, 0x00939393, 0x00939393, 0x00737373, 0x006D6D6D, 0x006D6D6D, 0x006D6D6D, 0x006D6D6D, 0x006D6D6D, 0x006D6D6D, 0x456D6D6D, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xBC6C6C6C, 0x006C6C6C, 0x006C6C6C, 0x006C6C6C, 0x006C6C6C, 0x006C6C6C, 0x006C6C6C, 0x006C6C6C, 0x008A8A8A, 0x00949494, 0x00949494, 0x001F1F1F, 0x00111111, 0x00040499, 0x000B0B4F, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x003B3B3B, 0x00727272, 0x00727272, 0x00727272, 0x00474747, 0x00141414, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x003B3B3B, 0x00727272, 0x00727272, 0x00727272, 0x00474747, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x000E0E29, 0x000101BE, 0x00111111, 0x00111111, 0x00818181, 0x00949494, 0x00949494, 0x006E6E6E, 0x006C6C6C, 0x006C6C6C, 0x006C6C6C, 0x006C6C6C, 0x006C6C6C, 0x006C6C6C, 0x9A6C6C6C, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x126C6C6C, 0x006C6C6C, 0x006C6C6C, 0x006C6C6C, 0x006C6C6C, 0x006C6C6C, 0x006C6C6C, 0x00797979, 0x00959595, 0x00959595, 0x003D3D3D, 0x00111111, 0x000A0A5B, 0x0005058D, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x003B3B3B, 0x00737373, 0x00737373, 0x00737373, 0x00595959, 0x001F1F1F, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00151515, 0x00484848, 0x00737373, 0x00737373, 0x00737373, 0x00484848, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00090967, 0x00060680, 0x00111111, 0x00323232, 0x00959595, 0x00959595, 0x00858585, 0x006C6C6C, 0x006C6C6C, 0x006C6C6C, 0x006C6C6C, 0x006C6C6C, 0x006C6C6C, 0x006C6C6C, 0xDE6C6C6C, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x566B6B6B, 0x006B6B6B, 0x006B6B6B, 0x006B6B6B, 0x006B6B6B, 0x006B6B6B, 0x006B6B6B, 0x00717171, 0x00969696, 0x00969696, 0x00686868, 0x00111111, 0x000F0F1D, 0x000101BE, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00363636, 0x00757575, 0x00757575, 0x00757575, 0x00757575, 0x00282828, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00242424, 0x00656565, 0x00757575, 0x00757575, 0x00757575, 0x00424242, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x000303A5, 0x000C0C42, 0x00111111, 0x00545454, 0x00969696, 0x00969696, 0x00757575, 0x006B6B6B, 0x006B6B6B, 0x006B6B6B, 0x006B6B6B, 0x006B6B6B, 0x006B6B6B, 0x236B6B6B, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x9A6A6A6A, 0x006A6A6A, 0x006A6A6A, 0x006A6A6A, 0x006A6A6A, 0x006A6A6A, 0x006A6A6A, 0x006B6B6B, 0x00969696, 0x00969696, 0x00969696, 0x00202020, 0x00111111, 0x00040499, 0x000B0B4F, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00292929, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00292929, 0x00777777, 0x00777777, 0x00777777, 0x00777777, 0x00444444, 0x001B1B1B, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00151515, 0x00373737, 0x00777777, 0x00777777, 0x00777777, 0x00777777, 0x00323232, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x001D1D1D, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x001E1E1E, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x000E0E29, 0x000101BE, 0x00111111, 0x00111111, 0x00838383, 0x00969696, 0x00969696, 0x006F6F6F, 0x006A6A6A, 0x006A6A6A, 0x006A6A6A, 0x006A6A6A, 0x006A6A6A, 0x006A6A6A, 0x786A6A6A, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xEF696969, 0x00696969, 0x00696969, 0x00696969, 0x00696969, 0x00696969, 0x00696969, 0x00696969, 0x00787878, 0x00979797, 0x00979797, 0x003E3E3E, 0x00111111, 0x000A0A5B, 0x0005058D, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00424242, 0x00B2B2B2, 0x00999999, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00202020, 0x005D5D5D, 0x00787878, 0x00787878, 0x00787878, 0x00686868, 0x00333333, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00292929, 0x005D5D5D, 0x00787878, 0x00787878, 0x00787878, 0x00686868, 0x00242424, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00999999, 0x00B2B2B2, 0x00424242, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00525252, 0x009B9B9B, 0x00404040, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00090967, 0x00060680, 0x00111111, 0x00323232, 0x00979797, 0x00979797, 0x00868686, 0x00696969, 0x00696969, 0x00696969, 0x00696969, 0x00696969, 0x00696969, 0x00696969, 0xBC696969, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x45696969, 0x00696969, 0x00696969, 0x00696969, 0x00696969, 0x00696969, 0x00696969, 0x00707070, 0x00989898, 0x00989898, 0x00767676, 0x00111111, 0x000F0F1D, 0x000101BE, 0x000F0F1D, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00363636, 0x00999999, 0x00CCCCCC, 0x00CCCCCC, 0x008D8D8D, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x003E3E3E, 0x007A7A7A, 0x007A7A7A, 0x007A7A7A, 0x007A7A7A, 0x005F5F5F, 0x002A2A2A, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00252525, 0x00555555, 0x007A7A7A, 0x007A7A7A, 0x007A7A7A, 0x007A7A7A, 0x004C4C4C, 0x00151515, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x008D8D8D, 0x00CCCCCC, 0x00CCCCCC, 0x00999999, 0x00363636, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00252525, 0x00CCCCCC, 0x00BEBEBE, 0x00777777, 0x00292929, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x000202B2, 0x000D0D36, 0x00111111, 0x00565656, 0x00989898, 0x00989898, 0x00747474, 0x00696969, 0x00696969, 0x00696969, 0x00696969, 0x00696969, 0x00696969, 0x12696969, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x9A686868, 0x00686868, 0x00686868, 0x00686868, 0x00686868, 0x00686868, 0x00686868, 0x00696969, 0x008D8D8D, 0x00999999, 0x00999999, 0x00262626, 0x00111111, 0x0005058D, 0x000A0A5B, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x001D1D1D, 0x00747474, 0x00CCCCCC, 0x00CCCCCC, 0x00A5A5A5, 0x00363636, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00252525, 0x005F5F5F, 0x007C7C7C, 0x007C7C7C, 0x007C7C7C, 0x007C7C7C, 0x005F5F5F, 0x00343434, 0x00151515, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x002B2B2B, 0x005F5F5F, 0x007C7C7C, 0x007C7C7C, 0x007C7C7C, 0x007C7C7C, 0x005F5F5F, 0x002B2B2B, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00363636, 0x00A5A5A5, 0x00CCCCCC, 0x00CCCCCC, 0x00747474, 0x001D1D1D, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x006A6A6A, 0x00CCCCCC, 0x00A1A1A1, 0x00A7A7A7, 0x005F5F5F, 0x001C1C1C, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x000D0D36, 
        0x000202B2, 0x00111111, 0x00181818, 0x00999999, 0x00999999, 0x00999999, 0x006E6E6E, 0x00686868, 0x00686868, 0x00686868, 0x00686868, 0x00686868, 0x00686868, 0x67686868, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xEF676767, 0x00676767, 0x00676767, 0x00676767, 0x00676767, 0x00676767, 0x00676767, 0x00676767, 0x00787878, 0x00999999, 0x00999999, 0x004D4D4D, 0x00111111, 0x000C0C42, 0x000303A5, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x005B5B5B, 0x00BEBEBE, 0x00CCCCCC, 0x00B2B2B2, 0x004F4F4F, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x002F2F2F, 0x006C6C6C, 0x007D7D7D, 0x007D7D7D, 0x007D7D7D, 0x007D7D7D, 0x007D7D7D, 0x00474747, 0x002B2B2B, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00262626, 0x00404040, 0x006C6C6C, 0x007D7D7D, 0x007D7D7D, 0x007D7D7D, 0x007D7D7D, 0x007D7D7D, 0x00393939, 0x00151515, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x004F4F4F, 0x00B2B2B2, 0x00CCCCCC, 0x00BEBEBE, 0x005B5B5B, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00343434, 0x00CCCCCC, 0x00CCCCCC, 0x003F3F3F, 0x00919191, 0x008D8D8D, 0x00323232, 0x00111111, 0x002E2E2E, 0x005F5F5F, 0x001C1C1C, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x0005058D, 
        0x00090967, 0x00111111, 0x00393939, 0x00999999, 0x00999999, 0x00808080, 0x00676767, 0x00676767, 0x00676767, 0x00676767, 0x00676767, 0x00676767, 0x00676767, 0xBC676767, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x45676767, 0x00676767, 0x00676767, 0x00676767, 0x00676767, 0x00676767, 0x00676767, 0x006D6D6D, 0x009A9A9A, 0x009A9A9A, 0x00868686, 0x00111111, 0x00111111, 0x000202B2, 0x000D0D36, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00363636, 0x00B2B2B2, 0x00CCCCCC, 0x00CCCCCC, 0x00747474, 0x001D1D1D, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00151515, 0x003A3A3A, 0x006E6E6E, 0x007F7F7F, 0x007F7F7F, 0x007F7F7F, 0x007F7F7F, 0x007F7F7F, 0x007F7F7F, 
        0x004F4F4F, 0x00353535, 0x00212121, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00212121, 0x00303030, 0x00474747, 
        0x006E6E6E, 0x007F7F7F, 0x007F7F7F, 0x007F7F7F, 0x007F7F7F, 0x007F7F7F, 0x007F7F7F, 0x00414141, 0x001C1C1C, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x001D1D1D, 0x00747474, 0x00CCCCCC, 0x00CCCCCC, 0x00B2B2B2, 0x00363636, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00171717, 0x005E5E5E, 0x00555555, 0x00141414, 0x003B3B3B, 0x009B9B9B, 0x00818181, 0x002C2C2C, 0x00757575, 0x00CCCCCC, 0x00949494, 0x00343434, 0x00111111, 0x00111111, 0x00111111, 0x000F0F1D, 0x000101BE, 
        0x000F0F1D, 0x00111111, 0x006B6B6B, 0x009A9A9A, 0x009A9A9A, 0x00707070, 0x00676767, 0x00676767, 0x00676767, 0x00676767, 0x00676767, 0x00676767, 0x22666666, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xAB666666, 0x00666666, 0x00666666, 0x00666666, 0x00666666, 0x00666666, 0x00666666, 0x00666666, 0x00878787, 0x009B9B9B, 0x009B9B9B, 0x003A3A3A, 0x00111111, 0x00090967, 0x0005058D, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00292929, 0x00CCCCCC, 0x008D8D8D, 0x00292929, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00313131, 0x00595959, 0x00818181, 0x00818181, 0x00818181, 0x00818181, 
        0x00818181, 0x00818181, 0x00818181, 0x00818181, 0x00646464, 0x00505050, 0x00414141, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003E3E3E, 0x003B3B3B, 0x003B3B3B, 0x00414141, 0x00484848, 0x00646464, 0x00818181, 0x00818181, 0x00818181, 0x00818181, 
        0x00818181, 0x00818181, 0x00818181, 0x00818181, 0x00646464, 0x00363636, 0x00151515, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00292929, 0x008D8D8D, 0x00CCCCCC, 0x00292929, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00161616, 0x00111111, 0x00111111, 0x00202020, 0x006D6D6D, 0x00ACACAC, 0x004D4D4D, 0x002F2F2F, 0x007D7D7D, 0x00B6B6B6, 0x004E4E4E, 0x00151515, 0x00111111, 0x00111111, 0x00090967, 0x00060680, 
        0x00111111, 0x00262626, 0x009B9B9B, 0x009B9B9B, 0x009B9B9B, 0x00676767, 0x00666666, 0x00666666, 0x00666666, 0x00666666, 0x00666666, 0x00666666, 0x77656565, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x11646464, 0x00656565, 0x00656565, 0x00656565, 0x00656565, 0x00656565, 0x00656565, 0x00707070, 0x009B9B9B, 0x009B9B9B, 0x006C6C6C, 0x00111111, 0x000F0F1D, 0x000101BE, 
        0x000E0E29, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00292929, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00222222, 0x003C3C3C, 0x00656565, 0x00828282, 
        0x00828282, 0x00828282, 0x00828282, 0x00828282, 0x00828282, 0x00828282, 0x00828282, 0x00828282, 0x00828282, 0x00828282, 0x00828282, 0x00828282, 0x00828282, 0x00828282, 0x00828282, 0x00828282, 0x00828282, 0x00828282, 0x00828282, 0x00828282, 
        0x00828282, 0x00656565, 0x00424242, 0x00272727, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00292929, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x006A6A6A, 0x00707070, 0x00292929, 0x00121212, 0x00353535, 0x00848484, 0x00A4A4A4, 0x005E5E5E, 0x006B6B6B, 0x00C2C2C2, 0x00686868, 0x00111111, 0x00111111, 0x00111111, 0x000202B2, 0x000D0D36, 
        0x00111111, 0x00575757, 0x009B9B9B, 0x009B9B9B, 0x00747474, 0x00656565, 0x00656565, 0x00656565, 0x00656565, 0x00656565, 0x00656565, 0x00656565, 0xDD646464, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x66646464, 0x00656565, 0x00656565, 0x00656565, 0x00656565, 0x00656565, 0x00656565, 0x00676767, 0x009C9C9C, 0x009C9C9C, 0x009C9C9C, 0x002D2D2D, 0x00111111, 0x00060680, 
        0x00070774, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00151515, 0x004C4C4C, 0x00414141, 0x00313131, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x001C1C1C, 
        0x00323232, 0x00434343, 0x00666666, 0x00848484, 0x00848484, 0x00848484, 0x00848484, 0x00848484, 0x00848484, 0x00848484, 0x00848484, 0x00848484, 0x00848484, 0x00848484, 0x00848484, 0x00848484, 0x00848484, 0x00666666, 0x004A4A4A, 0x00323232, 
        0x00222222, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00373737, 0x00CCCCCC, 0x00CCCCCC, 0x00949494, 0x00373737, 0x00111111, 0x00434343, 0x00ACACAC, 0x00A5A5A5, 0x00C0C0C0, 0x00A7A7A7, 0x002E2E2E, 0x00111111, 0x00111111, 0x000B0B4F, 0x00040499, 0x00111111, 
        0x00202020, 0x009C9C9C, 0x009C9C9C, 0x009C9C9C, 0x006B6B6B, 0x00656565, 0x00656565, 0x00656565, 0x00656565, 0x00656565, 0x00656565, 0x33646464, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xCC636363, 0x00646464, 0x00646464, 0x00646464, 0x00646464, 0x00646464, 0x00646464, 0x00646464, 0x00747474, 0x009D9D9D, 0x009D9D9D, 0x00585858, 0x00111111, 0x000E0E29, 
        0x000101BE, 0x000F0F1D, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00484848, 0x00A7A7A7, 0x00BABABA, 0x00B5B5B5, 0x00979797, 0x00292929, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00222222, 0x002D2D2D, 0x00323232, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 0x00404040, 0x003D3D3D, 0x003D3D3D, 0x00373737, 0x002D2D2D, 0x00222222, 0x00161616, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00282828, 0x00484848, 0x00111111, 0x00858585, 0x00CCCCCC, 0x00969696, 0x00BCBCBC, 0x00606060, 0x00111111, 0x00111111, 0x00202020, 0x00535353, 0x004D4D4D, 0x003C3C3C, 0x00111111, 0x00111111, 0x00111111, 0x000202B2, 0x000C0C42, 0x00111111, 
        0x00474747, 0x009D9D9D, 0x009D9D9D, 0x00818181, 0x00646464, 0x00646464, 0x00646464, 0x00646464, 0x00646464, 0x00646464, 0x00646464, 0xAA636363, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x33626262, 0x00636363, 0x00636363, 0x00636363, 0x00636363, 0x00636363, 0x00636363, 0x006A6A6A, 0x009E9E9E, 0x009E9E9E, 0x009E9E9E, 0x00272727, 0x00111111, 
        0x0005058D, 0x00090967, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00373737, 0x00858585, 0x00CCCCCC, 0x00CCCCCC, 0x00828282, 0x007C7C7C, 0x00CCCCCC, 0x00707070, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00707070, 0x00CCCCCC, 0x009C9C9C, 0x00CCCCCC, 0x009F9F9F, 0x00262626, 0x00757575, 0x00B3B3B3, 0x00595959, 0x001E1E1E, 0x00111111, 0x00111111, 0x00141414, 0x00111111, 0x00111111, 0x00111111, 0x000B0B4F, 0x000202B2, 0x00111111, 0x00181818, 
        0x008A8A8A, 0x009E9E9E, 0x009E9E9E, 0x006C6C6C, 0x00636363, 0x00636363, 0x00636363, 0x00636363, 0x00636363, 0x00636363, 0x11626262, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xAA626262, 0x00636363, 0x00636363, 0x00636363, 0x00636363, 0x00636363, 0x00636363, 0x00636363, 0x00777777, 0x009E9E9E, 0x009E9E9E, 0x004F4F4F, 0x00111111, 
        0x000D0D36, 0x000202B2, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00242424, 0x00696969, 0x00CCCCCC, 0x00CCCCCC, 0x009E9E9E, 0x00434343, 0x00141414, 0x002B2B2B, 0x00BFBFBF, 0x009B9B9B, 0x002E2E2E, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00434343, 0x009F9F9F, 0x00CCCCCC, 0x00CCCCCC, 0x00858585, 0x00252525, 0x003C3C3C, 0x00A4A4A4, 0x008F8F8F, 0x00363636, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00040499, 0x000B0B4F, 0x00111111, 0x003A3A3A, 
        0x009E9E9E, 0x009E9E9E, 0x00888888, 0x00636363, 0x00636363, 0x00636363, 0x00636363, 0x00636363, 0x00636363, 0x00636363, 0x77626262, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x22616161, 0x00626262, 0x00626262, 0x00626262, 0x00626262, 0x00626262, 0x00626262, 0x006A6A6A, 0x009F9F9F, 0x009F9F9F, 0x009F9F9F, 0x00202020, 
        0x00111111, 0x0005058D, 0x000A0A5B, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00333333, 0x008D8D8D, 0x00C2C2C2, 0x00CCCCCC, 0x00555555, 0x00111111, 0x00111111, 0x00111111, 0x00575757, 0x00CCCCCC, 0x00737373, 0x00181818, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x005A5A5A, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00585858, 0x00424242, 0x00999999, 0x00A0A0A0, 0x003A3A3A, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x000C0C42, 0x000202B2, 0x00111111, 0x00111111, 0x007B7B7B, 
        0x009F9F9F, 0x009F9F9F, 0x006D6D6D, 0x00626262, 0x00626262, 0x00626262, 0x00626262, 0x00626262, 0x00626262, 0x00626262, 0xDD616161, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x77606060, 0x00616161, 0x00616161, 0x00616161, 0x00616161, 0x00616161, 0x00616161, 0x00616161, 0x007B7B7B, 0x00A0A0A0, 0x00A0A0A0, 0x00505050, 
        0x00111111, 0x000D0D36, 0x000101BE, 0x000F0F1D, 0x00111111, 0x00111111, 0x00111111, 0x00434343, 0x00BABABA, 0x00747474, 0x00262626, 0x00111111, 0x00111111, 0x00434343, 0x009E9E9E, 0x00CACACA, 0x00B4B4B4, 0x004E4E4E, 0x00141414, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00252525, 0x00303030, 
        0x00363636, 0x00252525, 0x006A6A6A, 0x00404040, 0x006A6A6A, 0x00CCCCCC, 0x00CCCCCC, 0x00B4B4B4, 0x00AEAEAE, 0x00BABABA, 0x00616161, 0x001C1C1C, 0x00111111, 0x00111111, 0x00111111, 0x000202B2, 0x000B0B4F, 0x00111111, 0x003B3B3B, 0x00A0A0A0, 
        0x00A0A0A0, 0x00888888, 0x00616161, 0x00616161, 0x00616161, 0x00616161, 0x00616161, 0x00616161, 0x00616161, 0x55606060, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xEE5F5F5F, 0x115F5F5F, 0x00606060, 0x00606060, 0x00606060, 0x00606060, 0x00606060, 0x00606060, 0x00696969, 0x00A1A1A1, 0x00A1A1A1, 0x00A1A1A1, 
        0x00202020, 0x00111111, 0x00060680, 0x00070774, 0x00111111, 0x00111111, 0x00111111, 0x00535353, 0x00B2B2B2, 0x00696969, 0x001D1D1D, 0x00333333, 0x007D7D7D, 0x00CCCCCC, 0x00CCCCCC, 0x00858585, 0x00363636, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x001B1B1B, 0x007F7F7F, 0x00969696, 
        0x00A1A1A1, 0x00787878, 0x00333333, 0x00111111, 0x00111111, 0x00373737, 0x00858585, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 0x00707070, 0x00111111, 0x00111111, 0x00111111, 0x000B0B4F, 0x000303A5, 0x00111111, 0x00111111, 0x007D7D7D, 0x00A1A1A1, 
        0x00A1A1A1, 0x006C6C6C, 0x00606060, 0x00606060, 0x00606060, 0x00606060, 0x00606060, 0x00606060, 0x00606060, 0xCC5F5F5F, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x665F5F5F, 0x00606060, 0x00606060, 0x00606060, 0x00606060, 0x00606060, 0x00606060, 0x00606060, 0x007B7B7B, 0x00A1A1A1, 0x00A1A1A1, 
        0x005A5A5A, 0x00111111, 0x000E0E29, 0x000101BE, 0x000E0E29, 0x00111111, 0x00111111, 0x00292929, 0x00BFBFBF, 0x00CACACA, 0x007C7C7C, 0x00CACACA, 0x00CCCCCC, 0x00A7A7A7, 0x00484848, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x005F5F5F, 0x00CCCCCC, 0x00949494, 
        0x00A9A9A9, 0x00CCCCCC, 0x00CCCCCC, 0x00646464, 0x00202020, 0x00111111, 0x00111111, 0x00484848, 0x00A7A7A7, 0x00CCCCCC, 0x002A2A2A, 0x00111111, 0x00111111, 0x00111111, 0x000202B2, 0x000C0C42, 0x00111111, 0x00494949, 0x00A1A1A1, 0x00A1A1A1, 
        0x00898989, 0x00606060, 0x00606060, 0x00606060, 0x00606060, 0x00606060, 0x00606060, 0x00606060, 0x445F5F5F, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xDD5E5E5E, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x00686868, 0x00A2A2A2, 0x00A2A2A2, 
        0x00A2A2A2, 0x00282828, 0x00111111, 0x00070774, 0x00060680, 0x00111111, 0x00111111, 0x00111111, 0x00505050, 0x00979797, 0x00A7A7A7, 0x00B4B4B4, 0x005A5A5A, 0x00151515, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00282828, 0x00A2A2A2, 0x00CCCCCC, 0x00373737, 
        0x00191919, 0x005A5A5A, 0x00CCCCCC, 0x00CCCCCC, 0x00BCBCBC, 0x00505050, 0x00111111, 0x00111111, 0x00151515, 0x003A3A3A, 0x00111111, 0x00111111, 0x00111111, 0x00090967, 0x0005058D, 0x00111111, 0x00181818, 0x008E8E8E, 0x00A2A2A2, 0x00A2A2A2, 
        0x006C6C6C, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0xBB5E5E5E, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x665D5D5D, 0x005E5E5E, 0x005E5E5E, 0x005E5E5E, 0x005E5E5E, 0x005E5E5E, 0x005E5E5E, 0x005E5E5E, 0x00767676, 0x00A3A3A3, 
        0x00A3A3A3, 0x00656565, 0x00111111, 0x000F0F1D, 0x000202B2, 0x000D0D36, 0x00111111, 0x00111111, 0x00121212, 0x00292929, 0x00464646, 0x00262626, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00242424, 0x007E7E7E, 0x00B3B3B3, 0x00464646, 
        0x00111111, 0x00111111, 0x002A2A2A, 0x00707070, 0x00CCCCCC, 0x00C0C0C0, 0x00787878, 0x002C2C2C, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x000E0E29, 0x000101BE, 0x000E0E29, 0x00111111, 0x00525252, 0x00A3A3A3, 0x00A3A3A3, 0x008A8A8A, 
        0x005E5E5E, 0x005E5E5E, 0x005E5E5E, 0x005E5E5E, 0x005E5E5E, 0x005E5E5E, 0x005E5E5E, 0x445D5D5D, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xDD5D5D5D, 0x005E5E5E, 0x005E5E5E, 0x005E5E5E, 0x005E5E5E, 0x005E5E5E, 0x005E5E5E, 0x005E5E5E, 0x00676767, 0x00A4A4A4, 
        0x00A4A4A4, 0x00A4A4A4, 0x00363636, 0x00111111, 0x000A0A5B, 0x000303A5, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00353535, 0x00545454, 0x00575757, 0x00666666, 0x00666666, 0x00666666, 0x00666666, 0x00666666, 0x00666666, 0x00666666, 0x00666666, 0x00666666, 0x00666666, 0x00666666, 0x00666666, 0x00666666, 0x00666666, 
        0x00666666, 0x00666666, 0x00666666, 0x00666666, 0x00666666, 0x00666666, 0x00666666, 0x00666666, 0x00666666, 0x00666666, 0x00666666, 0x00666666, 0x00666666, 0x00666666, 0x00666666, 0x00666666, 0x00666666, 0x00666666, 0x00666666, 0x00666666, 
        0x00666666, 0x00666666, 0x00666666, 0x00666666, 0x00666666, 0x00666666, 0x00666666, 0x00666666, 0x00666666, 0x00666666, 0x00666666, 0x00666666, 0x00666666, 0x00666666, 0x00575757, 0x00545454, 0x00353535, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00191919, 0x00656565, 0x00C5C5C5, 0x00CCCCCC, 
        0x00757575, 0x002E2E2E, 0x00111111, 0x00111111, 0x003E3E3E, 0x00939393, 0x00AFAFAF, 0x00414141, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00060680, 0x00070774, 0x00111111, 0x00282828, 0x00A4A4A4, 0x00A4A4A4, 0x00A4A4A4, 0x00696969, 
        0x005E5E5E, 0x005E5E5E, 0x005E5E5E, 0x005E5E5E, 0x005E5E5E, 0x005E5E5E, 0x005E5E5E, 0xBB5D5D5D, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x665C5C5C, 0x005D5D5D, 0x005D5D5D, 0x005D5D5D, 0x005D5D5D, 0x005D5D5D, 0x005D5D5D, 0x005D5D5D, 0x00717171, 
        0x00A4A4A4, 0x00A4A4A4, 0x007F7F7F, 0x00111111, 0x00111111, 0x000303A5, 0x000A0A5B, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x005E5E5E, 0x00333333, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00333333, 0x005E5E5E, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x004D4D4D, 0x00B3B3B3, 
        0x00CCCCCC, 0x00CCCCCC, 0x005E5E5E, 0x001A1A1A, 0x00191919, 0x005E5E5E, 0x00BABABA, 0x005F5F5F, 0x00111111, 0x00111111, 0x00111111, 0x000C0C42, 0x000202B2, 0x000F0F1D, 0x00111111, 0x00656565, 0x00A4A4A4, 0x00A4A4A4, 0x007B7B7B, 0x005D5D5D, 
        0x005D5D5D, 0x005D5D5D, 0x005D5D5D, 0x005D5D5D, 0x005D5D5D, 0x005D5D5D, 0x445C5C5C, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xEE5B5B5B, 0x115B5B5B, 0x005C5C5C, 0x005C5C5C, 0x005C5C5C, 0x005C5C5C, 0x005C5C5C, 0x005C5C5C, 0x005F5F5F, 
        0x00959595, 0x00A5A5A5, 0x00A5A5A5, 0x004A4A4A, 0x00111111, 0x000D0D36, 0x000101BE, 0x000E0E29, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x005E5E5E, 0x000D0D0D, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000D0D0D, 0x005E5E5E, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x001C1C1C, 
        0x005F5F5F, 0x00CCCCCC, 0x00CCCCCC, 0x00B1B1B1, 0x005A5A5A, 0x00CCCCCC, 0x00BFBFBF, 0x00363636, 0x00111111, 0x00111111, 0x00111111, 0x000202B2, 0x000B0B4F, 0x00111111, 0x00363636, 0x00A5A5A5, 0x00A5A5A5, 0x00A5A5A5, 0x00656565, 0x005C5C5C, 
        0x005C5C5C, 0x005C5C5C, 0x005C5C5C, 0x005C5C5C, 0x005C5C5C, 0x005C5C5C, 0xCC5B5B5B, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x885B5B5B, 0x005C5C5C, 0x005C5C5C, 0x005C5C5C, 0x005C5C5C, 0x005C5C5C, 0x005C5C5C, 0x005C5C5C, 
        0x006A6A6A, 0x00A6A6A6, 0x00A6A6A6, 0x00A6A6A6, 0x00212121, 0x00111111, 0x00070774, 0x0005058D, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00353535, 0x00333333, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00333333, 0x00353535, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x002E2E2E, 0x00777777, 0x00BABABA, 0x00B1B1B1, 0x009B9B9B, 0x005A5A5A, 0x00111111, 0x00111111, 0x00111111, 0x00070774, 0x0005058D, 0x00111111, 0x00191919, 0x00808080, 0x00A6A6A6, 0x00A6A6A6, 0x006E6E6E, 0x005C5C5C, 0x005C5C5C, 
        0x005C5C5C, 0x005C5C5C, 0x005C5C5C, 0x005C5C5C, 0x005C5C5C, 0x555B5B5B, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x225A5A5A, 0x005B5B5B, 0x005B5B5B, 0x005B5B5B, 0x005B5B5B, 0x005B5B5B, 0x005B5B5B, 
        0x005B5B5B, 0x00828282, 0x00A7A7A7, 0x00A7A7A7, 0x00737373, 0x00111111, 0x00111111, 0x000303A5, 0x000B0B4F, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00545454, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00545454, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00393939, 0x00545454, 0x00373737, 0x001C1C1C, 0x00111111, 0x00111111, 0x000D0D36, 0x000202B2, 0x000F0F1D, 0x00111111, 0x00535353, 0x00A7A7A7, 0x00A7A7A7, 0x008B8B8B, 0x005E5E5E, 0x005B5B5B, 0x005B5B5B, 
        0x005B5B5B, 0x005B5B5B, 0x005B5B5B, 0x005B5B5B, 0x005B5B5B, 0xDD5A5A5A, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xAA595959, 0x005A5A5A, 0x005A5A5A, 0x005A5A5A, 0x005A5A5A, 0x005A5A5A, 0x005A5A5A, 
        0x005A5A5A, 0x00636363, 0x00A7A7A7, 0x00A7A7A7, 0x00A7A7A7, 0x003D3D3D, 0x00111111, 0x000D0D36, 0x000202B2, 0x000E0E29, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00575757, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00575757, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x000202B2, 0x000B0B4F, 0x00111111, 0x00292929, 0x00A7A7A7, 0x00A7A7A7, 0x00A7A7A7, 0x00666666, 0x005A5A5A, 0x005A5A5A, 0x005A5A5A, 
        0x005A5A5A, 0x005A5A5A, 0x005A5A5A, 0x005A5A5A, 0x77595959, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x44595959, 0x005A5A5A, 0x005A5A5A, 0x005A5A5A, 0x005A5A5A, 0x005A5A5A, 
        0x005A5A5A, 0x005A5A5A, 0x006E6E6E, 0x00A8A8A8, 0x00A8A8A8, 0x00929292, 0x00212121, 0x00111111, 0x00070774, 0x00040499, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00666666, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00666666, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00070774, 0x0005058D, 0x00111111, 0x00111111, 0x00828282, 0x00A8A8A8, 0x00A8A8A8, 0x00757575, 0x005A5A5A, 0x005A5A5A, 0x005A5A5A, 0x005A5A5A, 
        0x005A5A5A, 0x005A5A5A, 0x005A5A5A, 0x22595959, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xCC585858, 0x00595959, 0x00595959, 0x00595959, 0x00595959, 0x00595959, 
        0x00595959, 0x00595959, 0x00595959, 0x008C8C8C, 0x00A9A9A9, 0x00A9A9A9, 0x00757575, 0x00111111, 0x00111111, 0x000303A5, 0x00090967, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00666666, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00666666, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x000B0B4F, 0x000202B2, 0x000F0F1D, 0x00111111, 0x00555555, 0x00A9A9A9, 0x00A9A9A9, 0x00979797, 0x005F5F5F, 0x00595959, 0x00595959, 0x00595959, 0x00595959, 
        0x00595959, 0x00595959, 0x00595959, 0xAA585858, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x77575757, 0x00585858, 0x00585858, 0x00585858, 0x00585858, 
        0x00585858, 0x00585858, 0x00585858, 0x00616161, 0x00AAAAAA, 0x00AAAAAA, 0x00AAAAAA, 0x00454545, 0x00111111, 0x000E0E29, 0x000202B2, 0x000D0D36, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00666666, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00666666, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x000E0E29, 0x000202B2, 0x000D0D36, 0x00111111, 0x00373737, 0x00AAAAAA, 0x00AAAAAA, 0x00AAAAAA, 0x00666666, 0x00585858, 0x00585858, 0x00585858, 0x00585858, 0x00585858, 
        0x00585858, 0x00585858, 0x44575757, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x22565656, 0x00575757, 0x00575757, 0x00575757, 
        0x00575757, 0x00575757, 0x00575757, 0x00575757, 0x006D6D6D, 0x00AAAAAA, 0x00AAAAAA, 0x00AAAAAA, 0x00292929, 0x00111111, 0x000B0B4F, 0x000202B2, 0x000F0F1D, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00666666, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00666666, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x000303A5, 0x00090967, 0x00111111, 0x00212121, 0x00949494, 0x00AAAAAA, 0x00AAAAAA, 0x00747474, 0x00575757, 0x00575757, 0x00575757, 0x00575757, 0x00575757, 0x00575757, 
        0x00575757, 0x00575757, 0xDD565656, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xBB565656, 0x00575757, 0x00575757, 0x00575757, 
        0x00575757, 0x00575757, 0x00575757, 0x00575757, 0x00575757, 0x00838383, 0x00ABABAB, 0x00ABABAB, 0x00848484, 0x00191919, 0x00111111, 0x00070774, 0x00040499, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00666666, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00666666, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00070774, 0x0005058D, 0x00111111, 0x00111111, 0x00767676, 0x00ABABAB, 0x00ABABAB, 0x008C8C8C, 0x005A5A5A, 0x00575757, 0x00575757, 0x00575757, 0x00575757, 0x00575757, 0x00575757, 
        0x00575757, 0x88565656, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x66555555, 0x00565656, 0x00565656, 
        0x00565656, 0x00565656, 0x00565656, 0x00565656, 0x00565656, 0x005D5D5D, 0x009A9A9A, 0x00ACACAC, 0x00ACACAC, 0x00606060, 0x00111111, 0x00111111, 0x00040499, 0x00070774, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00666666, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00666666, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x000B0B4F, 0x000202B2, 0x000F0F1D, 0x00111111, 0x004D4D4D, 0x00ACACAC, 0x00ACACAC, 0x00ACACAC, 0x00606060, 0x00565656, 0x00565656, 0x00565656, 0x00565656, 0x00565656, 0x00565656, 0x00565656, 
        0x33555555, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xEE545454, 0x22545454, 0x00555555, 
        0x00555555, 0x00555555, 0x00555555, 0x00555555, 0x00555555, 0x00555555, 0x00646464, 0x00ACACAC, 0x00ACACAC, 0x00ACACAC, 0x00464646, 0x00111111, 0x000F0F1D, 0x000202B2, 0x000B0B4F, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00666666, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00666666, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x000D0D36, 0x000101BE, 0x000D0D36, 0x00111111, 0x00373737, 0x00ACACAC, 0x00ACACAC, 0x00ACACAC, 0x00686868, 0x00555555, 0x00555555, 0x00555555, 0x00555555, 0x00555555, 0x00555555, 0x00555555, 0x00555555, 
        0xDD545454, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xCC545454, 0x00555555, 
        0x00555555, 0x00555555, 0x00555555, 0x00555555, 0x00555555, 0x00555555, 0x00555555, 0x006B6B6B, 0x00ADADAD, 0x00ADADAD, 0x00ADADAD, 0x00313131, 0x00111111, 0x000D0D36, 0x000101BE, 0x000D0D36, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00666666, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00666666, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x000E0E29, 0x000101BE, 0x000C0C42, 0x00111111, 0x002A2A2A, 0x00979797, 0x00ADADAD, 0x00ADADAD, 0x00747474, 0x00555555, 0x00555555, 0x00555555, 0x00555555, 0x00555555, 0x00555555, 0x00555555, 0x00555555, 0x99545454, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x77535353, 
        0x00545454, 0x00545454, 0x00545454, 0x00545454, 0x00545454, 0x00545454, 0x00545454, 0x00545454, 0x007B7B7B, 0x00AEAEAE, 0x00AEAEAE, 0x00989898, 0x002A2A2A, 0x00111111, 0x000C0C42, 0x000202B2, 0x000D0D36, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00666666, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00666666, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x000F0F1D, 0x000202B2, 0x000A0A5B, 0x00111111, 0x00191919, 0x00868686, 0x00AEAEAE, 0x00AEAEAE, 0x008E8E8E, 0x00585858, 0x00545454, 0x00545454, 0x00545454, 0x00545454, 0x00545454, 0x00545454, 0x00545454, 0x55535353, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0x33525252, 0x00535353, 0x00535353, 0x00535353, 0x00535353, 0x00535353, 0x00535353, 0x00535353, 0x00575757, 0x008E8E8E, 0x00AFAFAF, 0x00AFAFAF, 0x00878787, 0x00191919, 0x00111111, 0x000A0A5B, 0x000202B2, 0x000F0F1D, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00666666, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00666666, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00040499, 0x00060680, 0x00111111, 0x00111111, 0x006C6C6C, 0x00AFAFAF, 0x00AFAFAF, 0x00AFAFAF, 0x005F5F5F, 0x00535353, 0x00535353, 0x00535353, 0x00535353, 0x00535353, 0x00535353, 0x00535353, 0x22525252, 0xEE525252, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xDD525252, 0x11525252, 0x00535353, 0x00535353, 0x00535353, 0x00535353, 0x00535353, 0x00535353, 0x00535353, 0x005F5F5F, 0x00AFAFAF, 0x00AFAFAF, 0x00AFAFAF, 0x00797979, 0x00111111, 0x00111111, 0x00090967, 0x000202B2, 0x000F0F1D, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00666666, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00666666, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00040499, 0x0005058D, 0x00111111, 0x00111111, 0x00616161, 0x00AFAFAF, 0x00AFAFAF, 0x00AFAFAF, 0x00626262, 0x00535353, 0x00535353, 0x00535353, 0x00535353, 0x00535353, 0x00535353, 0x00535353, 0x00535353, 0xCC525252, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xAA515151, 0x00525252, 0x00525252, 0x00525252, 0x00525252, 0x00525252, 0x00525252, 0x00525252, 0x00525252, 0x00606060, 0x00B0B0B0, 0x00B0B0B0, 0x00B0B0B0, 0x006D6D6D, 0x00111111, 0x00111111, 0x00060680, 0x00040499, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00666666, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00666666, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00060680, 
        0x00040499, 0x00111111, 0x00111111, 0x00585858, 0x00B0B0B0, 0x00B0B0B0, 0x00B0B0B0, 0x00676767, 0x00525252, 0x00525252, 0x00525252, 0x00525252, 0x00525252, 0x00525252, 0x00525252, 0x00525252, 0x88515151, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0x77505050, 0x00515151, 0x00515151, 0x00515151, 0x00515151, 0x00515151, 0x00515151, 0x00515151, 0x00515151, 0x00636363, 0x00B1B1B1, 0x00B1B1B1, 0x00B1B1B1, 0x00585858, 0x00111111, 0x00111111, 0x00060680, 0x00040499, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00666666, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00666666, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00060680, 0x00040499, 
        0x00111111, 0x00111111, 0x00404040, 0x00B1B1B1, 0x00B1B1B1, 0x00B1B1B1, 0x006D6D6D, 0x00515151, 0x00515151, 0x00515151, 0x00515151, 0x00515151, 0x00515151, 0x00515151, 0x00515151, 0x55505050, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0x44505050, 0x00515151, 0x00515151, 0x00515151, 0x00515151, 0x00515151, 0x00515151, 0x00515151, 0x00515151, 0x00696969, 0x00B2B2B2, 0x00B2B2B2, 0x00B2B2B2, 0x00585858, 0x00111111, 0x00111111, 0x00060680, 
        0x00040499, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00666666, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00666666, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00060680, 0x00040499, 0x00111111, 
        0x00111111, 0x00404040, 0x00B2B2B2, 0x00B2B2B2, 0x00B2B2B2, 0x00737373, 0x00515151, 0x00515151, 0x00515151, 0x00515151, 0x00515151, 0x00515151, 0x00515151, 0x00515151, 0x22505050, 0xEE505050, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xEE4F4F4F, 0x224F4F4F, 0x00505050, 0x00505050, 0x00505050, 0x00505050, 0x00505050, 0x00505050, 0x00505050, 0x00505050, 0x006D6D6D, 0x00B2B2B2, 0x00B2B2B2, 0x00B2B2B2, 0x00585858, 0x00111111, 0x00111111, 
        0x00060680, 0x00040499, 0x000F0F1D, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00666666, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00666666, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00060680, 0x00040499, 0x00111111, 0x00111111, 
        0x00404040, 0x00B2B2B2, 0x00B2B2B2, 0x00B2B2B2, 0x007A7A7A, 0x00505050, 0x00505050, 0x00505050, 0x00505050, 0x00505050, 0x00505050, 0x00505050, 0x00505050, 0x114F4F4F, 0xDD4F4F4F, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xCC4E4E4E, 0x114E4E4E, 0x004F4F4F, 0x004F4F4F, 0x004F4F4F, 0x004F4F4F, 0x004F4F4F, 0x004F4F4F, 0x004F4F4F, 0x004F4F4F, 0x00727272, 0x00B3B3B3, 0x00B3B3B3, 0x00B3B3B3, 0x00595959, 0x00111111, 
        0x00111111, 0x00060680, 0x000202B2, 0x000F0F1D, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00666666, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00666666, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00040499, 0x00040499, 0x00111111, 0x00111111, 0x00404040, 
        0x00B3B3B3, 0x00B3B3B3, 0x00B3B3B3, 0x00838383, 0x004F4F4F, 0x004F4F4F, 0x004F4F4F, 0x004F4F4F, 0x004F4F4F, 0x004F4F4F, 0x004F4F4F, 0x004F4F4F, 0x004F4F4F, 0xBB4E4E4E, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xBB4D4D4D, 0x004E4E4E, 0x004E4E4E, 0x004E4E4E, 0x004E4E4E, 0x004E4E4E, 0x004E4E4E, 0x004E4E4E, 0x004E4E4E, 0x004E4E4E, 0x00797979, 0x00B4B4B4, 0x00B4B4B4, 0x00B4B4B4, 0x00595959, 
        0x00111111, 0x00111111, 0x00070774, 0x000202B2, 0x000E0E29, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00666666, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00666666, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x000F0F1D, 0x00040499, 0x0005058D, 0x00111111, 0x00111111, 0x00414141, 0x00B4B4B4, 
        0x00B4B4B4, 0x00B4B4B4, 0x00909090, 0x00525252, 0x004E4E4E, 0x004E4E4E, 0x004E4E4E, 0x004E4E4E, 0x004E4E4E, 0x004E4E4E, 0x004E4E4E, 0x004E4E4E, 0x994D4D4D, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xAA4D4D4D, 0x004E4E4E, 0x004E4E4E, 0x004E4E4E, 0x004E4E4E, 0x004E4E4E, 0x004E4E4E, 0x004E4E4E, 0x004E4E4E, 0x004E4E4E, 0x007A7A7A, 0x00B5B5B5, 0x00B5B5B5, 0x00B5B5B5, 
        0x005A5A5A, 0x00111111, 0x00111111, 0x000A0A5B, 0x000101BE, 0x000D0D36, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00666666, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00666666, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x000F0F1D, 0x000202B2, 0x00060680, 0x00111111, 0x00111111, 0x00414141, 0x00B5B5B5, 0x00B5B5B5, 
        0x00B5B5B5, 0x00919191, 0x00525252, 0x004E4E4E, 0x004E4E4E, 0x004E4E4E, 0x004E4E4E, 0x004E4E4E, 0x004E4E4E, 0x004E4E4E, 0x004E4E4E, 0x774D4D4D, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x994C4C4C, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x00727272, 0x00B5B5B5, 0x00B5B5B5, 
        0x00B5B5B5, 0x00646464, 0x00111111, 0x00111111, 0x000B0B4F, 0x000101BE, 0x000B0B4F, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00575757, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00575757, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x000D0D36, 0x000101BE, 0x00090967, 0x00111111, 0x00111111, 0x00515151, 0x00B5B5B5, 0x00B5B5B5, 0x00B5B5B5, 
        0x00848484, 0x00515151, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x004D4D4D, 0x664C4C4C, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x774B4B4B, 0x004C4C4C, 0x004C4C4C, 0x004C4C4C, 0x004C4C4C, 0x004C4C4C, 0x004C4C4C, 0x004C4C4C, 0x004C4C4C, 0x004C4C4C, 0x006B6B6B, 0x00B6B6B6, 
        0x00B6B6B6, 0x00B6B6B6, 0x00707070, 0x001A1A1A, 0x00111111, 0x000D0D36, 0x000101BE, 0x00090967, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00545454, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00545454, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x000B0B4F, 0x000101BE, 0x000B0B4F, 0x00111111, 0x00111111, 0x00646464, 0x00B6B6B6, 0x00B6B6B6, 0x00B6B6B6, 0x00797979, 
        0x004C4C4C, 0x004C4C4C, 0x004C4C4C, 0x004C4C4C, 0x004C4C4C, 0x004C4C4C, 0x004C4C4C, 0x004C4C4C, 0x004C4C4C, 0x554B4B4B, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x664B4B4B, 0x004C4C4C, 0x004C4C4C, 0x004C4C4C, 0x004C4C4C, 0x004C4C4C, 0x004C4C4C, 0x004C4C4C, 0x004C4C4C, 0x004C4C4C, 0x006C6C6C, 
        0x00B7B7B7, 0x00B7B7B7, 0x00B7B7B7, 0x008D8D8D, 0x00232323, 0x00111111, 0x000F0F1D, 0x000303A5, 0x0005058D, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00353535, 0x00333333, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00333333, 0x00353535, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00070774, 0x000202B2, 0x000D0D36, 0x00111111, 0x001A1A1A, 0x00717171, 0x00B7B7B7, 0x00B7B7B7, 0x00B7B7B7, 0x007A7A7A, 0x004C4C4C, 
        0x004C4C4C, 0x004C4C4C, 0x004C4C4C, 0x004C4C4C, 0x004C4C4C, 0x004C4C4C, 0x004C4C4C, 0x004C4C4C, 0x444B4B4B, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x664A4A4A, 0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 
        0x00606060, 0x00B8B8B8, 0x00B8B8B8, 0x00B8B8B8, 0x00A0A0A0, 0x00333333, 0x00111111, 0x00111111, 0x0005058D, 0x000202B2, 0x000D0D36, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x005E5E5E, 0x000D0D0D, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000D0D0D, 0x005E5E5E, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x000F0F1D, 0x00040499, 0x00040499, 0x000F0F1D, 0x00111111, 0x002B2B2B, 0x008E8E8E, 0x00B8B8B8, 0x00B8B8B8, 0x00B8B8B8, 0x006B6B6B, 0x004B4B4B, 0x004B4B4B, 
        0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 0x444A4A4A, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x66494949, 0x004A4A4A, 0x004A4A4A, 0x004A4A4A, 0x004A4A4A, 0x004A4A4A, 0x004A4A4A, 0x004A4A4A, 0x004A4A4A, 
        0x004A4A4A, 0x005D5D5D, 0x00B8B8B8, 0x00B8B8B8, 0x00B8B8B8, 0x00B8B8B8, 0x00424242, 0x00111111, 0x00111111, 0x000B0B4F, 0x000101BE, 0x000B0B4F, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x005E5E5E, 0x00333333, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00333333, 0x005E5E5E, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x000C0C42, 0x000101BE, 0x00070774, 0x00111111, 0x00111111, 0x00333333, 0x00A0A0A0, 0x00B8B8B8, 0x00B8B8B8, 0x00B8B8B8, 0x00626262, 0x004A4A4A, 0x004A4A4A, 0x004A4A4A, 
        0x004A4A4A, 0x004A4A4A, 0x004A4A4A, 0x004A4A4A, 0x004A4A4A, 0x004A4A4A, 0x44494949, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x66494949, 0x004A4A4A, 0x004A4A4A, 0x004A4A4A, 0x004A4A4A, 0x004A4A4A, 0x004A4A4A, 0x004A4A4A, 
        0x004A4A4A, 0x004A4A4A, 0x00575757, 0x00A2A2A2, 0x00B9B9B9, 0x00B9B9B9, 0x00B9B9B9, 0x00666666, 0x00111111, 0x00111111, 0x000D0D36, 0x000202B2, 0x0005058D, 0x000F0F1D, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00353535, 0x00545454, 0x00575757, 0x00666666, 0x00666666, 0x00666666, 0x00666666, 0x00666666, 0x00666666, 0x00666666, 0x00666666, 0x00666666, 0x00666666, 0x00666666, 0x00666666, 0x00666666, 0x00666666, 
        0x00666666, 0x00666666, 0x00666666, 0x00666666, 0x00666666, 0x00666666, 0x00666666, 0x00666666, 0x00666666, 0x00666666, 0x00666666, 0x00666666, 0x00666666, 0x00666666, 0x00666666, 0x00666666, 0x00666666, 0x00666666, 0x00666666, 0x00666666, 
        0x00666666, 0x00666666, 0x00666666, 0x00666666, 0x00666666, 0x00666666, 0x00666666, 0x00666666, 0x00666666, 0x00666666, 0x00666666, 0x00666666, 0x00666666, 0x00666666, 0x00575757, 0x00545454, 0x00353535, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00070774, 0x000101BE, 0x000C0C42, 0x00111111, 0x00111111, 0x00525252, 0x00B9B9B9, 0x00B9B9B9, 0x00B9B9B9, 0x00B9B9B9, 0x005D5D5D, 0x004A4A4A, 0x004A4A4A, 0x004A4A4A, 0x004A4A4A, 
        0x004A4A4A, 0x004A4A4A, 0x004A4A4A, 0x004A4A4A, 0x004A4A4A, 0x44494949, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x66484848, 0x00494949, 0x00494949, 0x00494949, 0x00494949, 0x00494949, 0x00494949, 
        0x00494949, 0x00494949, 0x00494949, 0x00535353, 0x00848484, 0x00BABABA, 0x00BABABA, 0x00BABABA, 0x00909090, 0x002B2B2B, 0x00111111, 0x00111111, 0x00060680, 0x000202B2, 0x000D0D36, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x000E0E29, 0x000303A5, 0x0005058D, 0x000F0F1D, 0x00111111, 0x001A1A1A, 0x00727272, 0x00BABABA, 0x00BABABA, 0x00BABABA, 0x00919191, 0x00565656, 0x00494949, 0x00494949, 0x00494949, 0x00494949, 0x00494949, 
        0x00494949, 0x00494949, 0x00494949, 0x00494949, 0x44484848, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x99474747, 0x00484848, 0x00484848, 0x00484848, 0x00484848, 0x00484848, 
        0x00484848, 0x00484848, 0x00484848, 0x00484848, 0x00484848, 0x00717171, 0x00BBBBBB, 0x00BBBBBB, 0x00BBBBBB, 0x00BBBBBB, 0x003B3B3B, 0x00111111, 0x00111111, 0x000C0C42, 0x000202B2, 0x00070774, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00090967, 0x000101BE, 0x000A0A5B, 0x00111111, 0x00111111, 0x00343434, 0x00A3A3A3, 0x00BBBBBB, 0x00BBBBBB, 0x00BBBBBB, 0x00797979, 0x004C4C4C, 0x00484848, 0x00484848, 0x00484848, 0x00484848, 0x00484848, 0x00484848, 
        0x00484848, 0x00484848, 0x00484848, 0x66474747, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x99474747, 0x00484848, 0x00484848, 0x00484848, 0x00484848, 
        0x00484848, 0x00484848, 0x00484848, 0x00484848, 0x00484848, 0x00484848, 0x005C5C5C, 0x00BBBBBB, 0x00BBBBBB, 0x00BBBBBB, 0x00BBBBBB, 0x00676767, 0x001A1A1A, 0x00111111, 0x000F0F1D, 0x00060680, 0x000202B2, 0x000C0C42, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x000D0D36, 0x000303A5, 0x00040499, 0x000E0E29, 0x00111111, 0x00111111, 0x00535353, 0x00BBBBBB, 0x00BBBBBB, 0x00BBBBBB, 0x00BBBBBB, 0x00676767, 0x00484848, 0x00484848, 0x00484848, 0x00484848, 0x00484848, 0x00484848, 0x00484848, 0x00484848, 
        0x00484848, 0x00484848, 0x77474747, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xBB464646, 0x11464646, 0x00474747, 0x00474747, 
        0x00474747, 0x00474747, 0x00474747, 0x00474747, 0x00474747, 0x00474747, 0x00474747, 0x00565656, 0x00939393, 0x00BCBCBC, 0x00BCBCBC, 0x00BCBCBC, 0x00919191, 0x00343434, 0x00111111, 0x00111111, 0x000C0C42, 0x000202B2, 0x0005058D, 0x000E0E29, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00676767, 0x00363636, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00676767, 0x00363636, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x000F0F1D, 0x00070774, 
        0x000101BE, 0x000A0A5B, 0x00111111, 0x00111111, 0x002C2C2C, 0x00818181, 0x00BCBCBC, 0x00BCBCBC, 0x00BCBCBC, 0x00A4A4A4, 0x00595959, 0x00474747, 0x00474747, 0x00474747, 0x00474747, 0x00474747, 0x00474747, 0x00474747, 0x00474747, 0x00474747, 
        0x00474747, 0x99464646, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xCC454545, 0x22454545, 0x00464646, 
        0x00464646, 0x00464646, 0x00464646, 0x00464646, 0x00464646, 0x00464646, 0x00464646, 0x00464646, 0x00464646, 0x00696969, 0x00BDBDBD, 0x00BDBDBD, 0x00BDBDBD, 0x00BDBDBD, 0x00686868, 0x001A1A1A, 0x00111111, 0x00111111, 0x00070774, 0x000101BE, 
        0x00090967, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00424242, 0x00CCCCCC, 0x00808080, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00424242, 0x00CCCCCC, 0x00808080, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x000A0A5B, 0x000101BE, 0x00060680, 
        0x000F0F1D, 0x00111111, 0x00111111, 0x00545454, 0x00BDBDBD, 0x00BDBDBD, 0x00BDBDBD, 0x00BDBDBD, 0x00797979, 0x004B4B4B, 0x00464646, 0x00464646, 0x00464646, 0x00464646, 0x00464646, 0x00464646, 0x00464646, 0x00464646, 0x00464646, 0x11454545, 
        0xBB454545, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xEE444444, 0x44444444, 
        0x00454545, 0x00454545, 0x00454545, 0x00454545, 0x00454545, 0x00454545, 0x00454545, 0x00454545, 0x00454545, 0x00454545, 0x00575757, 0x00A4A4A4, 0x00BDBDBD, 0x00BDBDBD, 0x00BDBDBD, 0x00A5A5A5, 0x00434343, 0x00111111, 0x00111111, 0x000E0E29, 
        0x0005058D, 0x000202B2, 0x000B0B4F, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00424242, 0x00CCCCCC, 0x00808080, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00424242, 0x00CCCCCC, 0x00808080, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x000C0C42, 0x000202B2, 0x00040499, 0x000D0D36, 0x00111111, 
        0x00111111, 0x00343434, 0x00929292, 0x00BDBDBD, 0x00BDBDBD, 0x00BDBDBD, 0x00BDBDBD, 0x005D5D5D, 0x00454545, 0x00454545, 0x00454545, 0x00454545, 0x00454545, 0x00454545, 0x00454545, 0x00454545, 0x00454545, 0x00454545, 0x22444444, 0xCC444444, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0x66444444, 0x00454545, 0x00454545, 0x00454545, 0x00454545, 0x00454545, 0x00454545, 0x00454545, 0x00454545, 0x00454545, 0x00454545, 0x004A4A4A, 0x00696969, 0x00BEBEBE, 0x00BEBEBE, 0x00BEBEBE, 0x00BEBEBE, 0x00757575, 0x002C2C2C, 0x00111111, 
        0x00111111, 0x000C0C42, 0x00040499, 0x000202B2, 0x000C0C42, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00424242, 0x00CCCCCC, 0x00808080, 0x00111111, 
        0x004F4F4F, 0x00BEBEBE, 0x00363636, 0x00292929, 0x00BEBEBE, 0x005B5B5B, 0x00808080, 0x00BEBEBE, 0x00B2B2B2, 0x00363636, 0x00747474, 0x00BEBEBE, 0x00BEBEBE, 0x00676767, 0x00111111, 0x00424242, 0x00CCCCCC, 0x008D8D8D, 0x008D8D8D, 0x00BEBEBE, 
        0x00B2B2B2, 0x004F4F4F, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x000D0D36, 0x00040499, 0x000202B2, 0x000B0B4F, 0x00111111, 0x00111111, 0x00242424, 
        0x00696969, 0x00BEBEBE, 0x00BEBEBE, 0x00BEBEBE, 0x00BEBEBE, 0x00797979, 0x00505050, 0x00454545, 0x00454545, 0x00454545, 0x00454545, 0x00454545, 0x00454545, 0x00454545, 0x00454545, 0x00454545, 0x00454545, 0x44444444, 0xEE444444, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xAA434343, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00565656, 0x00939393, 0x00BFBFBF, 0x00BFBFBF, 0x00BFBFBF, 0x00BFBFBF, 0x005E5E5E, 
        0x001A1A1A, 0x00111111, 0x00111111, 0x000B0B4F, 0x000202B2, 0x00040499, 0x000C0C42, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00424242, 0x00CCCCCC, 0x00808080, 0x00424242, 
        0x00CCCCCC, 0x00BEBEBE, 0x00292929, 0x00424242, 0x00CCCCCC, 0x00BEBEBE, 0x00999999, 0x00999999, 0x00CCCCCC, 0x00BEBEBE, 0x00B2B2B2, 0x008D8D8D, 0x00CCCCCC, 0x00CCCCCC, 0x00363636, 0x00424242, 0x00CCCCCC, 0x00CCCCCC, 0x00999999, 0x008D8D8D, 
        0x00CCCCCC, 0x00CCCCCC, 0x001D1D1D, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x000D0D36, 0x0005058D, 0x000202B2, 0x000A0A5B, 0x00111111, 0x00111111, 0x00111111, 0x00555555, 0x00BFBFBF, 
        0x00BFBFBF, 0x00BFBFBF, 0x00BFBFBF, 0x00A5A5A5, 0x005C5C5C, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x00444444, 0x77434343, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xCC424242, 0x22424242, 0x00434343, 0x00434343, 0x00434343, 0x00434343, 0x00434343, 0x00434343, 0x00434343, 0x00434343, 0x00434343, 0x00434343, 0x00434343, 0x00636363, 0x00C0C0C0, 0x00C0C0C0, 0x00C0C0C0, 0x00C0C0C0, 
        0x00A7A7A7, 0x00555555, 0x001A1A1A, 0x00111111, 0x00111111, 0x000B0B4F, 0x000202B2, 0x000202B2, 0x000B0B4F, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00424242, 0x00CCCCCC, 0x00A5A5A5, 0x00BEBEBE, 
        0x00BEBEBE, 0x00363636, 0x00111111, 0x00424242, 0x00CCCCCC, 0x00A5A5A5, 0x00111111, 0x00111111, 0x00CCCCCC, 0x00CCCCCC, 0x00292929, 0x00111111, 0x008D8D8D, 0x00CCCCCC, 0x00424242, 0x00424242, 0x00CCCCCC, 0x00A5A5A5, 0x00111111, 0x00111111, 
        0x00A5A5A5, 0x00CCCCCC, 0x00363636, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x000C0C42, 0x00040499, 0x000202B2, 0x000A0A5B, 0x00111111, 0x00111111, 0x00111111, 0x00444444, 0x00949494, 0x00C0C0C0, 0x00C0C0C0, 
        0x00C0C0C0, 0x00C0C0C0, 0x00686868, 0x00484848, 0x00434343, 0x00434343, 0x00434343, 0x00434343, 0x00434343, 0x00434343, 0x00434343, 0x00434343, 0x00434343, 0x00434343, 0x11424242, 0xBB424242, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x55424242, 0x00434343, 0x00434343, 0x00434343, 0x00434343, 0x00434343, 0x00434343, 0x00434343, 0x00434343, 0x00434343, 0x00434343, 0x00434343, 0x004E4E4E, 0x00797979, 0x00C0C0C0, 0x00C0C0C0, 
        0x00C0C0C0, 0x00C0C0C0, 0x00949494, 0x00444444, 0x00111111, 0x00111111, 0x00111111, 0x000B0B4F, 0x00040499, 0x000202B2, 0x00090967, 0x000F0F1D, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00424242, 0x00CCCCCC, 0x00CCCCCC, 0x00CCCCCC, 
        0x00BEBEBE, 0x00292929, 0x00111111, 0x00424242, 0x00CCCCCC, 0x00808080, 0x00111111, 0x00111111, 0x00CCCCCC, 0x00CCCCCC, 0x00111111, 0x00111111, 0x00808080, 0x00CCCCCC, 0x00424242, 0x00424242, 0x00CCCCCC, 0x00808080, 0x00111111, 0x00111111, 
        0x00999999, 0x00CCCCCC, 0x00424242, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x000B0B4F, 0x000202B2, 0x000202B2, 0x000B0B4F, 0x00111111, 0x00111111, 0x00111111, 0x003D3D3D, 0x00949494, 0x00C0C0C0, 0x00C0C0C0, 0x00C0C0C0, 0x00C0C0C0, 
        0x00848484, 0x00535353, 0x00434343, 0x00434343, 0x00434343, 0x00434343, 0x00434343, 0x00434343, 0x00434343, 0x00434343, 0x00434343, 0x00434343, 0x00434343, 0x44424242, 0xEE424242, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xAA414141, 0x11414141, 0x00424242, 0x00424242, 0x00424242, 0x00424242, 0x00424242, 0x00424242, 0x00424242, 0x00424242, 0x00424242, 0x00424242, 0x00424242, 0x00555555, 0x00949494, 
        0x00C1C1C1, 0x00C1C1C1, 0x00C1C1C1, 0x00C1C1C1, 0x00959595, 0x00454545, 0x00111111, 0x00111111, 0x00111111, 0x000D0D36, 0x0005058D, 0x000101BE, 0x00060680, 0x000D0D36, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00424242, 0x00CCCCCC, 0x00B2B2B2, 0x00747474, 
        0x00CCCCCC, 0x00A5A5A5, 0x00111111, 0x00424242, 0x00CCCCCC, 0x00808080, 0x00111111, 0x00111111, 0x00CCCCCC, 0x00CCCCCC, 0x00111111, 0x00111111, 0x00808080, 0x00CCCCCC, 0x00424242, 0x00424242, 0x00CCCCCC, 0x00808080, 0x00111111, 0x00111111, 
        0x00999999, 0x00CCCCCC, 0x00424242, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x000E0E29, 0x00070774, 0x000101BE, 0x0005058D, 0x000C0C42, 0x00111111, 0x00111111, 0x00111111, 0x003D3D3D, 0x00959595, 0x00C1C1C1, 0x00C1C1C1, 0x00C1C1C1, 0x00C1C1C1, 0x00949494, 0x005B5B5B, 
        0x00424242, 0x00424242, 0x00424242, 0x00424242, 0x00424242, 0x00424242, 0x00424242, 0x00424242, 0x00424242, 0x00424242, 0x00424242, 0x00424242, 0x88414141, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xDD404040, 0x44404040, 0x00414141, 0x00414141, 0x00414141, 0x00414141, 0x00414141, 0x00414141, 0x00414141, 0x00414141, 0x00414141, 0x00414141, 0x00414141, 0x00414141, 
        0x005A5A5A, 0x00949494, 0x00C2C2C2, 0x00C2C2C2, 0x00C2C2C2, 0x00C2C2C2, 0x00A9A9A9, 0x00565656, 0x001A1A1A, 0x00111111, 0x00111111, 0x000F0F1D, 0x00090967, 0x000202B2, 0x000303A5, 0x00090967, 0x000F0F1D, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00424242, 0x00CCCCCC, 0x00808080, 0x00111111, 
        0x00999999, 0x00CCCCCC, 0x00747474, 0x00424242, 0x00CCCCCC, 0x00808080, 0x00111111, 0x00111111, 0x00CCCCCC, 0x00CCCCCC, 0x00111111, 0x00111111, 0x00808080, 0x00CCCCCC, 0x00424242, 0x00424242, 0x00CCCCCC, 0x00808080, 0x00111111, 0x00111111, 
        0x00999999, 0x00CCCCCC, 0x00424242, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x000F0F1D, 0x000B0B4F, 0x00040499, 0x000101BE, 0x00070774, 0x000E0E29, 0x00111111, 0x00111111, 0x001A1A1A, 0x00454545, 0x00969696, 0x00C2C2C2, 0x00C2C2C2, 0x00C2C2C2, 0x00C2C2C2, 0x00A7A7A7, 0x005E5E5E, 0x00414141, 0x00414141, 
        0x00414141, 0x00414141, 0x00414141, 0x00414141, 0x00414141, 0x00414141, 0x00414141, 0x00414141, 0x00414141, 0x00414141, 0x33404040, 0xCC404040, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x99404040, 0x11404040, 0x00414141, 0x00414141, 0x00414141, 0x00414141, 0x00414141, 0x00414141, 0x00414141, 0x00414141, 0x00414141, 0x00414141, 
        0x00414141, 0x00414141, 0x005B5B5B, 0x00959595, 0x00C3C3C3, 0x00C3C3C3, 0x00C3C3C3, 0x00C3C3C3, 0x00C3C3C3, 0x00606060, 0x002D2D2D, 0x00111111, 0x00111111, 0x00111111, 0x000C0C42, 0x0005058D, 0x000101BE, 0x00040499, 0x000A0A5B, 0x000F0F1D, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00363636, 0x00CCCCCC, 0x00808080, 0x00111111, 
        0x00292929, 0x00BEBEBE, 0x00999999, 0x00363636, 0x00CCCCCC, 0x00808080, 0x00111111, 0x00111111, 0x00B2B2B2, 0x00BEBEBE, 0x00111111, 0x00111111, 0x00747474, 0x00CCCCCC, 0x00363636, 0x00363636, 0x00CCCCCC, 0x00808080, 0x00111111, 0x00111111, 
        0x008D8D8D, 0x00CCCCCC, 0x00292929, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x000F0F1D, 0x000B0B4F, 
        0x0005058D, 0x000101BE, 0x0005058D, 0x000B0B4F, 0x00111111, 0x00111111, 0x00111111, 0x00242424, 0x00565656, 0x00AAAAAA, 0x00C3C3C3, 0x00C3C3C3, 0x00C3C3C3, 0x00C3C3C3, 0x00A8A8A8, 0x00646464, 0x00464646, 0x00414141, 0x00414141, 0x00414141, 
        0x00414141, 0x00414141, 0x00414141, 0x00414141, 0x00414141, 0x00414141, 0x00414141, 0x00414141, 0x00414141, 0x77404040, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xDD3F3F3F, 0x553F3F3F, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 
        0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x005A5A5A, 0x00959595, 0x00C3C3C3, 0x00C3C3C3, 0x00C3C3C3, 0x00C3C3C3, 0x00C3C3C3, 0x00868686, 0x003E3E3E, 0x001B1B1B, 0x00111111, 0x00111111, 0x00111111, 0x000B0B4F, 0x0005058D, 0x000101BE, 
        0x00040499, 0x00090967, 0x000D0D36, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x001D1D1D, 0x00111111, 0x00111111, 
        0x00111111, 0x001D1D1D, 0x001D1D1D, 0x00111111, 0x00292929, 0x00111111, 0x00111111, 0x00111111, 0x001D1D1D, 0x001D1D1D, 0x00111111, 0x00111111, 0x00111111, 0x00292929, 0x00111111, 0x00111111, 0x00292929, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x001D1D1D, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x000E0E29, 0x000A0A5B, 0x0005058D, 0x000101BE, 0x0005058D, 
        0x000B0B4F, 0x000F0F1D, 0x00111111, 0x00111111, 0x00111111, 0x003E3E3E, 0x006B6B6B, 0x00C3C3C3, 0x00C3C3C3, 0x00C3C3C3, 0x00C3C3C3, 0x00C3C3C3, 0x00A8A8A8, 0x00636363, 0x00454545, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 
        0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x00404040, 0x333F3F3F, 0xCC3F3F3F, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xBB3E3E3E, 0x223E3E3E, 0x003F3F3F, 0x003F3F3F, 0x003F3F3F, 0x003F3F3F, 0x003F3F3F, 0x003F3F3F, 0x003F3F3F, 
        0x003F3F3F, 0x003F3F3F, 0x003F3F3F, 0x003F3F3F, 0x003F3F3F, 0x003F3F3F, 0x00565656, 0x00858585, 0x00C4C4C4, 0x00C4C4C4, 0x00C4C4C4, 0x00C4C4C4, 0x00C4C4C4, 0x00AAAAAA, 0x006C6C6C, 0x00353535, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x000B0B4F, 0x00060680, 0x000202B2, 0x000202B2, 0x00060680, 0x000B0B4F, 0x000E0E29, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x000F0F1D, 0x000B0B4F, 0x00060680, 0x000202B2, 0x000101BE, 0x0005058D, 0x000B0B4F, 0x000F0F1D, 0x00111111, 
        0x00111111, 0x00111111, 0x002D2D2D, 0x00575757, 0x00AAAAAA, 0x00C4C4C4, 0x00C4C4C4, 0x00C4C4C4, 0x00C4C4C4, 0x00C4C4C4, 0x00959595, 0x00595959, 0x003F3F3F, 0x003F3F3F, 0x003F3F3F, 0x003F3F3F, 0x003F3F3F, 0x003F3F3F, 0x003F3F3F, 0x003F3F3F, 
        0x003F3F3F, 0x003F3F3F, 0x003F3F3F, 0x003F3F3F, 0x003F3F3F, 0x113E3E3E, 0x993E3E3E, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x883E3E3E, 0x003F3F3F, 0x003F3F3F, 0x003F3F3F, 0x003F3F3F, 0x003F3F3F, 0x003F3F3F, 
        0x003F3F3F, 0x003F3F3F, 0x003F3F3F, 0x003F3F3F, 0x003F3F3F, 0x003F3F3F, 0x003F3F3F, 0x003F3F3F, 0x004F4F4F, 0x006F6F6F, 0x00C5C5C5, 0x00C5C5C5, 0x00C5C5C5, 0x00C5C5C5, 0x00C5C5C5, 0x00C5C5C5, 0x00ABABAB, 0x00616161, 0x00363636, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x000D0D36, 0x000A0A5B, 0x0005058D, 0x000101BE, 0x000202B2, 0x0005058D, 0x00090967, 0x000C0C42, 0x000F0F1D, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x000D0D36, 0x000A0A5B, 0x00060680, 0x000202B2, 0x000101BE, 0x00040499, 0x00090967, 0x000D0D36, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x002E2E2E, 
        0x00575757, 0x00989898, 0x00C5C5C5, 0x00C5C5C5, 0x00C5C5C5, 0x00C5C5C5, 0x00C5C5C5, 0x00C5C5C5, 0x006F6F6F, 0x00565656, 0x003F3F3F, 0x003F3F3F, 0x003F3F3F, 0x003F3F3F, 0x003F3F3F, 0x003F3F3F, 0x003F3F3F, 0x003F3F3F, 0x003F3F3F, 0x003F3F3F, 
        0x003F3F3F, 0x003F3F3F, 0x003F3F3F, 0x003F3F3F, 0x663E3E3E, 0xEE3E3E3E, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xDD3D3D3D, 0x663D3D3D, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 
        0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x00444444, 0x005C5C5C, 0x00979797, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00ACACAC, 
        0x00626262, 0x003E3E3E, 0x001B1B1B, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x000E0E29, 0x000A0A5B, 0x00060680, 0x000303A5, 0x000000CC, 0x000202B2, 0x0005058D, 0x00070774, 0x000A0A5B, 0x000C0C42, 0x000E0E29, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x000E0E29, 0x000D0D36, 0x000B0B4F, 0x00070774, 0x0005058D, 0x000202B2, 0x000000CC, 0x000303A5, 0x00060680, 0x000A0A5B, 0x000D0D36, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00363636, 0x00626262, 0x00999999, 0x00C6C6C6, 
        0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00969696, 0x00616161, 0x004A4A4A, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 0x003E3E3E, 
        0x003E3E3E, 0x003E3E3E, 0x443D3D3D, 0xCC3D3D3D, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xCC3C3C3C, 0x443C3C3C, 0x003D3D3D, 0x003D3D3D, 
        0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 0x004E4E4E, 0x00666666, 0x00AAAAAA, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 
        0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00797979, 0x00585858, 0x00363636, 0x001B1B1B, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x000E0E29, 0x000B0B4F, 0x00090967, 0x00060680, 0x00040499, 0x000202B2, 0x000000CC, 0x000202B2, 
        0x000202B2, 0x0005058D, 0x0005058D, 0x00060680, 0x00070774, 0x00070774, 0x00070774, 0x00070774, 0x00070774, 0x00060679, 0x00070774, 0x00070774, 0x00070774, 0x00070774, 0x00070774, 0x0005058D, 0x0005058D, 0x000202B2, 0x000202B2, 0x000000CC, 
        0x000202B2, 0x000303A5, 0x0005058D, 0x00070774, 0x000B0B4F, 0x000D0D36, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x002E2E2E, 0x004F4F4F, 0x00797979, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 0x00C6C6C6, 
        0x00C6C6C6, 0x00C6C6C6, 0x00AAAAAA, 0x006E6E6E, 0x00525252, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 0x003D3D3D, 
        0x333C3C3C, 0xBB3C3C3C, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xBB3B3B3B, 0x443B3B3B, 
        0x003C3C3C, 0x003C3C3C, 0x003C3C3C, 0x003C3C3C, 0x003C3C3C, 0x003C3C3C, 0x003C3C3C, 0x003C3C3C, 0x003C3C3C, 0x003C3C3C, 0x003C3C3C, 0x003C3C3C, 0x003C3C3C, 0x003C3C3C, 0x003C3C3C, 0x003C3C3C, 0x00515151, 0x00666666, 0x00AAAAAA, 0x00C7C7C7, 
        0x00C7C7C7, 0x00C7C7C7, 0x00C7C7C7, 0x00C7C7C7, 0x00C7C7C7, 0x00C7C7C7, 0x00C7C7C7, 0x00898989, 0x00626262, 0x00474747, 0x002E2E2E, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x000E0E29, 
        0x000D0D36, 0x000B0B4F, 0x000B0B4F, 0x000A0A5B, 0x00070774, 0x00070774, 0x00070774, 0x00070774, 0x00070774, 0x00060679, 0x00070774, 0x00070774, 0x00070774, 0x00070774, 0x00090967, 0x000B0B4F, 0x000B0B4F, 0x000D0D36, 0x000E0E29, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00252525, 0x003E3E3E, 0x00585858, 0x007A7A7A, 0x00C7C7C7, 0x00C7C7C7, 0x00C7C7C7, 0x00C7C7C7, 0x00C7C7C7, 0x00C7C7C7, 0x00C7C7C7, 0x00C7C7C7, 0x00AAAAAA, 
        0x006D6D6D, 0x00545454, 0x003C3C3C, 0x003C3C3C, 0x003C3C3C, 0x003C3C3C, 0x003C3C3C, 0x003C3C3C, 0x003C3C3C, 0x003C3C3C, 0x003C3C3C, 0x003C3C3C, 0x003C3C3C, 0x003C3C3C, 0x003C3C3C, 0x003C3C3C, 0x003C3C3C, 0x003C3C3C, 0x223B3B3B, 0xAA3B3B3B, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xBB3B3B3B, 0x443B3B3B, 0x003C3C3C, 0x003C3C3C, 0x003C3C3C, 0x003C3C3C, 0x003C3C3C, 0x003C3C3C, 0x003C3C3C, 0x003C3C3C, 0x003C3C3C, 0x003C3C3C, 0x003C3C3C, 0x003C3C3C, 0x003C3C3C, 0x003C3C3C, 0x003C3C3C, 0x003C3C3C, 0x003C3C3C, 0x004E4E4E, 
        0x00626262, 0x00868686, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x009A9A9A, 0x006E6E6E, 0x00585858, 0x003E3E3E, 0x002E2E2E, 0x00252525, 0x00111111, 0x00111111, 
        0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 0x00111111, 
        0x001B1B1B, 0x002E2E2E, 0x003E3E3E, 0x00585858, 0x006E6E6E, 0x008A8A8A, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00C8C8C8, 0x00989898, 0x00606060, 0x00515151, 0x003C3C3C, 
        0x003C3C3C, 0x003C3C3C, 0x003C3C3C, 0x003C3C3C, 0x003C3C3C, 0x003C3C3C, 0x003C3C3C, 0x003C3C3C, 0x003C3C3C, 0x003C3C3C, 0x003C3C3C, 0x003C3C3C, 0x003C3C3C, 0x003C3C3C, 0x003C3C3C, 0x003C3C3C, 0x223B3B3B, 0xAA3B3B3B, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xCC3A3A3A, 0x553A3A3A, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 
        0x003B3B3B, 0x003B3B3B, 0x00414141, 0x00545454, 0x00666666, 0x00979797, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x009B9B9B, 
        0x009B9B9B, 0x006E6E6E, 0x006E6E6E, 0x00636363, 0x00585858, 0x00585858, 0x00585858, 0x00585858, 0x00585858, 0x005D5D5D, 0x00585858, 0x00585858, 0x00585858, 0x00585858, 0x00585858, 0x006E6E6E, 0x006E6E6E, 0x008A8A8A, 0x009B9B9B, 0x00C9C9C9, 
        0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00969696, 0x00666666, 0x00575757, 0x00484848, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 
        0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x003B3B3B, 0x443A3A3A, 0xBB3A3A3A, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xDD393939, 0x77393939, 0x11393939, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 
        0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x00404040, 0x00505050, 0x005A5A5A, 0x006D6D6D, 0x00969696, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 
        0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 
        0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00C9C9C9, 0x00969696, 0x00787878, 0x005F5F5F, 0x00535353, 0x00404040, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 
        0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x55393939, 0xCC393939, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x99393939, 0x33393939, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 
        0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x00404040, 0x004C4C4C, 0x00535353, 0x005F5F5F, 0x006D6D6D, 0x00868686, 0x00ADADAD, 0x00CACACA, 0x00CACACA, 
        0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 
        0x00ADADAD, 0x00989898, 0x006D6D6D, 0x005F5F5F, 0x00565656, 0x00505050, 0x00404040, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 
        0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x003A3A3A, 0x22393939, 0x88393939, 0xEE393939, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xCC383838, 0x77383838, 0x11383838, 0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x00393939, 
        0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x00464646, 
        0x004D4D4D, 0x00525252, 0x00525252, 0x005A5A5A, 0x00616161, 0x00616161, 0x00616161, 0x00616161, 0x00616161, 0x00656565, 0x00616161, 0x00616161, 0x00616161, 0x00616161, 0x005A5A5A, 0x00525252, 0x00525252, 0x004B4B4B, 0x004D4D4D, 0x00393939, 
        0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x00393939, 
        0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x00393939, 0x11383838, 0x55383838, 0xBB383838, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xAB383838, 0x56383838, 0x12383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 
        0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 
        0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 
        0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 
        0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x56383838, 0xAB383838, 0xEF383838, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xAB383838, 0x67383838, 0x12383838, 0x00383838, 0x00383838, 
        0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 
        0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 
        0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 0x00383838, 
        0x12383838, 0x56383838, 0xAB383838, 0xEF383838, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xCD373737, 0x78373737, 
        0x34373737, 0x00373737, 0x00373737, 0x00373737, 0x00373737, 0x00373737, 0x00373737, 0x00373737, 0x00373737, 0x00373737, 0x00373737, 0x00373737, 0x00373737, 0x00373737, 0x00373737, 0x00373737, 0x00373737, 0x00373737, 0x00373737, 0x00373737, 
        0x00373737, 0x00373737, 0x00373737, 0x00373737, 0x00373737, 0x00373737, 0x00373737, 0x00373737, 0x00373737, 0x00373737, 0x00373737, 0x00373737, 0x00373737, 0x00373737, 0x00373737, 0x00373737, 0x00373737, 0x00373737, 0x00373737, 0x00373737, 
        0x00373737, 0x00373737, 0x00373737, 0x00373737, 0x00373737, 0x00373737, 0x00373737, 0x00373737, 0x00373737, 0x00373737, 0x00373737, 0x00373737, 0x00373737, 0x00373737, 0x00373737, 0x00373737, 0x00373737, 0x23373737, 0x78373737, 0xBC373737, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xEF363636, 0xBC363636, 0x78363636, 0x34363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 
        0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 
        0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x34363636, 0x67363636, 0xAB363636, 0xEF363636, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xCD363636, 0x9A363636, 0x67363636, 0x34363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 
        0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 
        0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x00363636, 0x23363636, 0x56363636, 0x89363636, 0xBC363636, 0xEF363636, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xDE353535, 0xAB353535, 0x89353535, 0x67353535, 0x45353535, 0x23353535, 0x00353535, 0x00353535, 0x00353535, 
        0x00353535, 0x00353535, 0x00353535, 0x00353535, 0x00353535, 0x00353535, 0x00353535, 0x00353535, 0x00353535, 0x00353535, 0x00353535, 0x00353535, 0x00353535, 0x00353535, 0x00353535, 0x00353535, 0x00353535, 0x00353535, 0x00353535, 0x00353535, 
        0x00353535, 0x23353535, 0x45353535, 0x67353535, 0x78353535, 0xAB353535, 0xCD353535, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xCD343434, 
        0xCD343434, 0xAB343434, 0xAB343434, 0x89343434, 0x78343434, 0x78343434, 0x78343434, 0x78343434, 0x78343434, 0x71343434, 0x78343434, 0x78343434, 0x78343434, 0x78343434, 0x78343434, 0xAB343434, 0xAB343434, 0xBC343434, 0xCD343434, 0xEF343434, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000
};

static GUI_CONST_STORAGE GUI_BITMAP _bmSpeedometerScale = {
  221, // xSize
  221, // ySize
  884, // BytesPerLine
  32, // BitsPerPixel
  (unsigned char *)_acSpeedometerScale_BMP,  // Pointer to picture data
  NULL,  // Pointer to palette
  GUI_DRAW_BMP8888
};
/*********************************************************************
*
*       Types
*
**********************************************************************
*/
typedef struct {
  GUI_AUTODEV_INFO  AutoDevInfo;
  GUI_MEMDEV_Handle hNeedle;  // Handle to draw the needle bitmap
  GUI_MEMDEV_Handle hDst;     // Handle for the rotated needle
  GUI_MEMDEV_Handle hScale;
  GUI_MEMDEV_Handle hScaleRot;
  GUI_MEMDEV_Handle hMemBk;
  float             Angle;
  float             Speed;
  int               xSize;
  int               ySize;
  U32               FontColor;
} PARAM;


/*********************************************************************
*
*       Static Code
*
**********************************************************************
*/
/*********************************************************************
*
*       _DrawCentered
*/
static void _DrawCentered(GUI_MEMDEV_Handle hMem, int xOff, int yOff) {
  int xSizeDevice;
  int ySizeDevice;
  int xSize;
  int ySize;

  xSize = LCD_GetXSize();
  ySize = LCD_GetYSize();
  xSizeDevice = GUI_MEMDEV_GetXSize(hMem);
  ySizeDevice = GUI_MEMDEV_GetYSize(hMem);
  GUI_MEMDEV_WriteAt(hMem, xOff + (xSize - xSizeDevice) / 2, yOff + (ySize - ySizeDevice) / 2);
}

/*********************************************************************
*
*       _GetFontColor
*/
static U32 _GetFontColor(int Speed, U32 Color0, U32 Color1) {
  static GUI_MEMDEV_Handle  hMem;
  GUI_MEMDEV_Handle         hMemOld;
  U32                     * pData;

  if (hMem == 0) {
    hMem = GUI_MEMDEV_CreateFixed(0, 0, 10, 10, GUI_MEMDEV_NOTRANS, GUI_MEMDEV_APILIST_32, GUI_COLOR_CONV_8888);
  }
  hMemOld = GUI_MEMDEV_Select(hMem);
  GUI_DrawGradientV(0, Speed - 240, 0, Speed, Color0, Color1);
  GUI_MEMDEV_Select(hMemOld);
  pData = (U32 *)GUI_MEMDEV_GetDataPtr(hMem);
  return *pData;
}

/*********************************************************************
*
*       _DrawNeedle
*/
static void _DrawNeedle(PARAM * pParam, GUI_MEMDEV_Handle hDst) {
  int xSizeNeedle, ySizeNeedle, xSizeDst, ySizeDst;
  I32 SinHQ, CosHQ;
  //
  // Draw needle
  //
  xSizeNeedle = GUI_MEMDEV_GetXSize(pParam->hNeedle);
  ySizeNeedle = GUI_MEMDEV_GetYSize(pParam->hNeedle);
  xSizeDst = (GUI_MEMDEV_GetXSize(hDst) + 1) & ~1;
  ySizeDst = (GUI_MEMDEV_GetYSize(hDst) + 1) & ~1;
  SinHQ = GUI__SinHQ((I32)((pParam->Angle) * (-1000)) + 30000);
  CosHQ = GUI__CosHQ((I32)((pParam->Angle) * (-1000)) + 30000);
  GUI_MEMDEV_RotateHQHR(pParam->hNeedle, hDst, 
                        ((xSizeDst - xSizeNeedle) * 4) - (((xSizeNeedle) * CosHQ) >> 14),
                        ((ySizeDst - ySizeNeedle) * 4) + (((xSizeNeedle) * SinHQ) >> 14),
                        (int)((pParam->Angle) * (-1000) + 210000), 1000);
}
/*********************************************************************
*
*       _DrawSpeed
*/
static void _DrawSpeed(PARAM * pParam, int mx, int my) {
  GUI_COLOR FontColor;

  GUI_SetFont(&GUI_FontDigit19);
  FontColor = pParam->FontColor;
  GUI_SetColor(FontColor);
  GUI_SetTextAlign(GUI_TA_RIGHT);
  GUI_SetTextMode(GUI_TM_TRANS);
  GUI_GotoXY(mx + 23, my + 49);
  GUI_DispDecMin((int)pParam->Speed);
}

/*********************************************************************
*
*       _Draw
*/
static void _Draw(PARAM * pParam, GUI_MEMDEV_Handle hDst) {
  _DrawCentered(pParam->hScale, 0, 0);
  _DrawNeedle(pParam, hDst);
}

/*********************************************************************
*
*       _CalcXIn
*
*  Purpose: Moves to the right getting slower
*/
static void _CalcXIn(int tDiff, int tMax, int xSize, int * pix, int * piSpin) {
  float fx;
  int   xSize_LCD;
  
  xSize_LCD = LCD_GetXSize();
  fx = 1 - (float)tDiff / tMax;
  fx = fx * fx * fx * fx;
  *pix = ((xSize_LCD - xSize) >> 1) - (int)(fx * xSize_LCD);
  *piSpin = (int)(fx * 1000 * xSize);
}

/*********************************************************************
*
*       _CalcXOut
*
*  Purpose: Moves to the right getting faster
*/
static void _CalcXOut(int tDiff, int tMax, int xSize, int * pix, int * piSpin) {
  float fx;
  int   xSize_LCD;
  
  xSize_LCD = LCD_GetXSize();
  fx = (float)tDiff / tMax;
  fx = fx * fx * fx * fx;
  *pix = ((xSize_LCD - xSize) >> 1) + (int)(fx * xSize_LCD);
  *piSpin = (int)(0 - fx * 1000 * xSize);
}

/*********************************************************************
*
*       _FillBkDev
*/
static void _FillBkDev(PARAM * pParam) {
  GUI_MEMDEV_Select(pParam->hMemBk);
  GUI_DrawGradientV(0, 0, pParam->xSize - 1, pParam->ySize - 1, COLOR_BACK0, COLOR_BACK1);
  GUI_DrawBitmap(&bmSeggerLogo50x25, 15, 10);
  GUI_SetFont(&GUI_FontRounded16);
  GUI_SetTextMode(GUI_TM_TRANS);
  GUI_SetColor(GUI_WHITE);
  GUI_DispStringHCenterAt("emWin", pParam->xSize - 40, 15);
  GUI_MEMDEV_Select(0);
}

/*********************************************************************
*
*       _Roll
*/
static void _Roll(PARAM * pParam, int tMax, void (* pfCalcX)(int, int, int, int *, int *)) {
  int                      ix;
  int                      iSpin;
  int                      tStart;
  int                      tNow;
  int                      tDiff;
  int                      tUsed;
  int                      Size_DevRotate;

  Size_DevRotate = GUI_MEMDEV_GetXSize(pParam->hScaleRot);
  tStart = tNow = GUI_GetTime();
  do {
    tDiff = tNow - tStart;
    tDiff = (tDiff < tMax) ? tDiff : tMax;
    if (tDiff) {
      GUI_MEMDEV_Select(pParam->hDst);
      GUI_MEMDEV_Write(pParam->hMemBk);
      pfCalcX(tDiff, tMax, Size_DevRotate, &ix, &iSpin);
      GUI_MEMDEV_Rotate(pParam->hScaleRot, pParam->hDst, ix , (pParam->ySize - Size_DevRotate) >> 1, iSpin, 1000);
      GUI_MEMDEV_Select(0);
      GUI_MEMDEV_CopyToLCD(pParam->hDst);
    }
    tUsed = GUI_GetTime() - tNow;
    tNow += tUsed;
    if (tUsed < T_MIN_FRAME) {
      GUI_X_Delay(T_MIN_FRAME - tUsed);
    }
  } while (tDiff < tMax);
}

/*********************************************************************
*
*       _RollOut
*/
static void _RollOut(PARAM * pParam, int tMax) {
  _Roll(pParam, tMax, _CalcXOut);
}

/*********************************************************************
*
*       _RollIn
*/
static void _RollIn(PARAM * pParam, int tMax) {
  _Roll(pParam, tMax, _CalcXIn);
}

/*********************************************************************
*
*       _CreateNeedle
*/
static int _CreateNeedle(PARAM * pParam) {
  if (pParam->hNeedle) {
    GUI_MEMDEV_Select(pParam->hNeedle);
    GUI_SetBkColor(GUI_TRANSPARENT);
    GUI_Clear();
    GUI_DrawBitmap(&_bmNeedle, 0, 0);
    GUI_MEMDEV_Select(0);
    return 0;
  } else {
    return 1;
  }
}

/*********************************************************************
*
*       _DrawScale
*/
static int _DrawScale (PARAM * pParam) {
  if (pParam->hScale) {
    GUI_MEMDEV_Select(pParam->hScale);
    GUI_SetBkColor(GUI_TRANSPARENT);
    GUI_Clear();
    GUI_DrawBitmap(&_bmSpeedometerScale, 0, 0);
    GUI_MEMDEV_Select(0);
    return 0;
  } else {
    return 1;
  }
}
/*********************************************************************
*
*       Public Code
*
**********************************************************************
*/
/*********************************************************************
*
*       MainTask
*/
void MainTask(void) {
  GUI_MEMDEV_Handle hTitle, hTitleBk, hClearAlpha;
  GUI_AUTODEV       AutoDev;
  GUI_RECT          Rect;
  PARAM             Param = {{0}};
  float             f;
  int               t0;
  int               tStart;
  int               tDiff;
  int               tUsed;
  GUI_RECT          RectQ1, RectQ2, RectQ3, RectQ4, RectClip, RectSpeed;
  
  Param.Speed = 0;
  Param.Angle = 0;
  GUI_Init();
  //
  // Check if recommended memory for the sample is available
  //
  if (GUI_ALLOC_GetNumFreeBytes() < RECOMMENDED_MEMORY) {
    GUI_ErrorOut("Not enough memory available."); 
    return;
  }
  //
  // Get display size
  //
  Param.xSize = LCD_GetXSize();
  Param.ySize = LCD_GetYSize();
  //
  // Create clipping rectangles to draw the needle
  //
  RectQ1.x0 = Param.xSize / 2 - _bmNeedle.YSize / 2 - 2;                        // RectQ1 x0
  RectQ1.y0 = Param.ySize / 2 - (_bmNeedle.XSize + (_bmNeedle.YSize / 2)) + 2;  // RectQ1 y0
  RectQ1.x1 = Param.xSize / 2 + _bmNeedle.XSize + _bmNeedle.YSize / 2 - 1;      // RectQ1 x1
  RectQ1.y1 = Param.ySize / 2 + _bmNeedle.YSize / 2 + 3;                        // RectQ1 y1
  RectQ2.x0 = Param.xSize / 2 - (_bmNeedle.XSize + (_bmNeedle.YSize / 2));      // RectQ2 x0
  RectQ2.y0 = Param.ySize / 2 - (_bmNeedle.XSize + (_bmNeedle.YSize / 2));      // RectQ2 y0
  RectQ2.x1 = Param.xSize / 2 + _bmNeedle.YSize / 2 + 3;                        // RectQ2 x1
  RectQ2.y1 = Param.ySize / 2 + _bmNeedle.YSize / 2 + 3;                        // RectQ2 y1
  RectQ3.x0 = Param.xSize / 2 - (_bmNeedle.XSize + (_bmNeedle.YSize / 2)) - 2;  // RectQ3 x0
  RectQ3.y0 = Param.ySize / 2 - _bmNeedle.YSize / 2 - 2;                        // RectQ3 y0
  RectQ3.x1 = Param.xSize / 2 + _bmNeedle.YSize / 2 + 3;                        // RectQ3 x1
  RectQ3.y1 = Param.ySize / 2 + _bmNeedle.YSize / 2 + _bmNeedle.XSize - 25 + 3; // RectQ3 y1
  RectQ4.x0 = Param.xSize / 2 - _bmNeedle.YSize / 2 - 2;                        // RectQ4 x0
  RectQ4.y0 = (Param.ySize - _bmNeedle.YSize) / 2 - 2;                          // RectQ4 y0
  RectQ4.x1 = Param.xSize / 2 + _bmNeedle.XSize + _bmNeedle.YSize / 2 + 3;      // RectQ4 x1
  RectQ4.y1 = Param.ySize / 2 + _bmNeedle.XSize + _bmNeedle.YSize / 2 - 25 + 3; // RectQ4 y1
  //
  // Create a clipping rectangle to draw the speed
  //
  RectSpeed.x0 = Param.xSize / 2 - 30; 
  RectSpeed.y0 = Param.ySize / 2 + 49;
  RectSpeed.x1 = Param.xSize / 2 + 30;
  RectSpeed.y1 = Param.ySize / 2 + 78;
  //
  // Create devices
  //
  Param.hScale    = GUI_MEMDEV_CreateFixed32(0, 0, _bmSpeedometerScale.XSize, _bmSpeedometerScale.YSize);
  Param.hScaleRot = GUI_MEMDEV_CreateFixed(0, 0, R_RING * 2 + 1, R_RING * 2 + 1, GUI_MEMDEV_NOTRANS, GUI_MEMDEV_APILIST_32, GUI_COLOR_CONV_8888);
  Param.hNeedle   = GUI_MEMDEV_CreateFixed32(0, 0, _bmNeedle.XSize, _bmNeedle.YSize);
  Param.hDst      = GUI_MEMDEV_CreateFixed32(0, 0, Param.xSize, Param.ySize);
  hClearAlpha     = GUI_MEMDEV_CreateFixed(0, 0, _bmSpeedometerScale.XSize, _bmSpeedometerScale.YSize, GUI_MEMDEV_NOTRANS, GUI_MEMDEV_APILIST_1, GUI_COLOR_CONV_1);
  _CreateNeedle(&Param);
  _DrawScale(&Param);
  //
  // Initialize high resolution anti aliasing
  //
  GUI_AA_EnableHiRes();
  GUI_AA_SetFactor(MAG);
  //
  // Create scale for rotation
  //
  GUI_MEMDEV_Select(Param.hScaleRot);
  GUI_Clear();
  GUI_MEMDEV_Write(Param.hScale);
  //
  // Draw needle and speed into device
  //
  Param.FontColor = _GetFontColor((int)Param.Speed, COLOR_NEEDLE, GUI_WHITE);
  _DrawSpeed(&Param, R_RING + 1, R_RING + 1);
  _DrawNeedle(&Param, Param.hScaleRot);
  GUI_MEMDEV_Select(0);
  GUI_MEMDEV_Select(hClearAlpha);
  GUI_Clear();
  GUI_FillCircle(_bmSpeedometerScale.XSize / 2,_bmSpeedometerScale.YSize / 2, _bmNeedle.XSize);
  GUI_MEMDEV_Select(0);
  //
  // Clear unneeded alpha values
  //
  GUI_MEMDEV_ClearAlpha(Param.hScaleRot, hClearAlpha);
  //
  // Create background device
  //
  Param.hMemBk = GUI_MEMDEV_CreateFixed(0, 0, Param.xSize, Param.ySize, GUI_MEMDEV_NOTRANS, GUI_MEMDEV_APILIST_32, GUI_COLOR_CONV_8888);
  _FillBkDev(&Param);
  GUI_MEMDEV_CopyToLCD(Param.hMemBk);
  //
  // Initialize auto device
  //
  GUI_MEMDEV_CreateAuto(&AutoDev);
  //
  // Fill Title MEMDEVs
  //
  GUI_SetFont(&GUI_FontRounded33);
  GUI_GotoXY(0, 0);
  GUI_GetTextExtend(&Rect, _acText, sizeof(_acText));
  GUI_MoveRect(&Rect, (Param.xSize - Rect.x1) >> 1, (Param.ySize - Rect.y1) >> 1);
  hTitle   = GUI_MEMDEV_CreateFixed(Rect.x0, Rect.y0, Rect.x1 - Rect.x0 + 1, Rect.y1 - Rect.y0 + 1, GUI_MEMDEV_NOTRANS, GUI_MEMDEV_APILIST_32, GUI_COLOR_CONV_8888);
  hTitleBk = GUI_MEMDEV_CreateFixed(Rect.x0, Rect.y0, Rect.x1 - Rect.x0 + 1, Rect.y1 - Rect.y0 + 1, GUI_MEMDEV_NOTRANS, GUI_MEMDEV_APILIST_32, GUI_COLOR_CONV_8888);
  GUI_MEMDEV_Select(hTitle);
  GUI_MEMDEV_Write(Param.hMemBk);
  _DrawCentered(Param.hScaleRot, 0, 0);
  GUI_SetColor(GUI_WHITE);
  GUI_DispStringInRect(_acText, &Rect, GUI_TA_HCENTER | GUI_TA_VCENTER);
  GUI_MEMDEV_Select(hTitleBk);
  GUI_MEMDEV_Write(Param.hMemBk);
  _DrawCentered(Param.hScaleRot, 0, 0);
  GUI_MEMDEV_Select(0);
  //
  // Animation
  //
  while (1) {
    //
    // Let the speedometer roll into the center of the screen
    //
    _RollIn(&Param, T_ROLL);
    //
    // Show Title
    //
    GUI_MEMDEV_CopyToLCD(hTitleBk);
    GUI_MEMDEV_FadeDevices(hTitle,   hTitleBk, 250);
    GUI_X_Delay(1200);
    GUI_MEMDEV_FadeDevices(hTitleBk, hTitle,   250);
    GUI_X_Delay(500);
    //
    // Accelerate and brake
    //
    t0 = GUI_GetTime();
    for (; (tDiff = GUI_GetTime() - t0) < T_MAX;) {
      tStart = GUI_GetTime();
      //
      // Calculate speed dependent on time
      //
      if (tDiff < (T_MAX >> 1)) {
        f = 1 - (float)tDiff / (T_MAX >> 1);
        f = f * f * f;
        Param.Speed = (240 - (240 * f));
      } else {
        f = 1 - ((float)tDiff - (T_MAX >> 1)) / (T_MAX >> 1);
        f = f * f * f;
        Param.Speed = (240 * f);
      }
      Param.Angle = Param.Speed;
      Param.FontColor = _GetFontColor((int)Param.Speed, COLOR_NEEDLE, GUI_WHITE);
      //
      // Select clipping rectangle
      //
      if (Param.Speed <= 30) {
        RectClip = RectQ3;
      }
      if (Param.Speed > 30 && Param.Speed <= 120) {
        RectClip = RectQ2;
      }
      if (Param.Speed > 120 && Param.Speed <= 210) {
        RectClip = RectQ1;
      }
      if (Param.Speed > 210 && Param.Speed <= 240) {
        RectClip = RectQ4;
      }
      //
      // Draw scene
      //
      GUI_MEMDEV_Select(Param.hDst);
      _Draw(&Param, Param.hDst);
      GUI_SetClipRect(&RectClip);
      GUI_MEMDEV_CopyToLCD(Param.hDst);
      GUI_SetClipRect(NULL);
      _DrawSpeed(&Param, Param.xSize >> 1, Param.ySize >> 1);
      GUI_SetClipRect(&RectSpeed);
      GUI_MEMDEV_CopyToLCD(Param.hDst);
      GUI_SetClipRect(NULL);
      //
      // Wait a while
      //
      tUsed = GUI_GetTime() - tStart;
      if (tUsed < T_MIN_FRAME) {
        GUI_X_Delay(T_MIN_FRAME - tUsed);
      }
    }
    _RollOut(&Param, T_ROLL);
  }
}

/*************************** End of file ****************************/
