/*********************************************************************
*                SEGGER Microcontroller GmbH & Co. KG                *
*        Solutions for real time microcontroller applications        *
**********************************************************************
*                                                                    *
*        (c) 1996 - 2016  SEGGER Microcontroller GmbH & Co. KG       *
*                                                                    *
*        Internet: www.segger.com    Support:  support@segger.com    *
*                                                                    *
**********************************************************************

** emWin V5.34 - Graphical user interface for embedded applications **
All  Intellectual Property rights  in the Software belongs to  SEGGER.
emWin is protected by  international copyright laws.  Knowledge of the
source code may not be used to write a similar product.  This file may
only be used in accordance with the following terms:

The  software has  been licensed  to Silicon Labs Norway, a subsidiary
of Silicon Labs Inc. whose registered office is 400 West Cesar Chavez,
Austin,  TX 78701, USA solely for  the purposes of creating  libraries 
for its  ARM Cortex-M3, M4F  processor-based devices,  sublicensed and 
distributed  under the  terms and conditions  of the  End User License  
Agreement supplied by Silicon Labs.
Full source code is available at: www.segger.com

We appreciate your understanding and fairness.
----------------------------------------------------------------------
Licensing information

Licensor:                 SEGGER Software GmbH
Licensed to:              Silicon Laboratories Norway
Licensed SEGGER software: emWin
License number:           GUI-00140
License model:            See Agreement, dated 20th April 2012
Licensed product:         - 
Licensed platform:        Cortex M3, Cortex M4F
Licensed number of seats: -
----------------------------------------------------------------------
File        : MEMDEV_FadingPerformance.c
Purpose     : This sample shows fading between two screens and shows
              the drawing and fading performance.
Requirements: WindowManager - ( )
              MemoryDevices - (x)
              AntiAliasing  - ( )
              VNC-Server    - ( )
              PNG-Library   - ( )
              TrueTypeFonts - ( )
----------------------------------------------------------------------
*/

#include <string.h>
#include "GUI_Private.h"

/*********************************************************************
*
*       Defines
*
**********************************************************************
*/
//
// Recommended memory to run the sample with adequate performance
//
#define RECOMMENDED_MEMORY (1024L * 1400)

/*********************************************************************
*
*       Static data
*
**********************************************************************
*/
/*********************************************************************
*
*       _bmSeggerLogo_160x80
*/
static GUI_CONST_STORAGE unsigned long acSeggerLogo_160x80[] = {
  0xFF000000, 0xFF000000, 0xFF000000, 0x7F292929, 0x20292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x20292929, 0x7F292929, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xEF292929, 0x30292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x30292929, 0xEF292929, 0xFF000000,
  0xFF000000, 0x30292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x30292929, 0xFF000000,
  0x9F292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00797979, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 
        0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 
        0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 
        0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 
        0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 
        0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 
        0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 
        0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00797979, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x9F292929,
  0x30292929, 0x00292929, 0x00292929, 0x00292929, 0x00AFAFAF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00AFAFAF, 0x00292929, 0x00292929, 0x00292929, 0x30292929,
  0x00292929, 0x00292929, 0x00292929, 0x006C6C6C, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x006C6C6C, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EBDCDB, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F2E8E7, 0x00F2E8E7, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F2E8E7, 0x00A35B55, 0x0096433D, 0x0096433D, 0x00D8B9B6, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00BD8A86, 0x0096433D, 0x0096433D, 0x00BD8A86, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B77E7A, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00D8B9B6, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00CBA19E, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00A35B55, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00CBA19E, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00DEC4C2, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CBA19E, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00B77E7A, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00E5D0CF, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x009D4F49, 0x00F2E8E7, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00AA6661, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00D1ADAA, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00CBA19E, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00AA6661, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F2E8E7, 0x009D4F49, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00BD8A86, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00DEC4C2, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00A35B55, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F8F3F3, 0x00A35B55, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00D8B9B6, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00C49592, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00B77E7A, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EBDCDB, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x009D4F49, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00AA6661, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00D1ADAA, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00D8B9B6, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00AA6661, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F2E8E7, 0x009D4F49, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00EBDCDB, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00BD8A86, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00B77E7A, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00DEC4C2, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00A35B55, 0x00F8F3F3, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F8F3F3, 0x00AA6661, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00D1ADAA, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00C49592, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00B77E7A, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EBDCDB, 0x009D4F49, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00AA6661, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x00D1ADAA, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00DEC4C2, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x009D4F49, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F2E8E7, 0x009D4F49, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00C49592, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00B0726E, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00DEC4C2, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x00A35B55, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00AA6661, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00CBA19E, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00C49592, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x00B77E7A, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F8F3F3, 0x009D4F49, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00DEC4C2, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00AA6661, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x00D1ADAA, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00E5D0CF, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x009D4F49, 0x00F2E8E7, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x00A35B55, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F2E8E7, 0x009D4F49, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CBA19E, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00AA6661, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x0096433D, 0x00B77E7A, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00DEC4C2, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00A35B55, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B77E7A, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00BD8A86, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x0096433D, 0x0096433D, 0x00D1ADAA, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00C49592, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00B77E7A, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F8F3F3, 0x00A35B55, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x00D8B9B6, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x0096433D, 0x0096433D, 0x0096433D, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00AA6661, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00D1ADAA, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EBDCDB, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x009D4F49, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x0096433D, 0x0096433D, 0x0096433D, 0x00A35B55, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00F2E8E7, 0x009D4F49, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00D8B9B6, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x00AA6661, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 
        0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 
        0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 
        0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 
        0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 
        0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00E5D0CF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00B77E7A, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00DEC4C2, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00A35B55, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00BD8A86, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00DEC4C2, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00D1ADAA, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00C49592, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00B77E7A, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F8F3F3, 0x00AA6661, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00B0726E, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00AA6661, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00D1ADAA, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EBDCDB, 0x009D4F49, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00B0726E, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00A35B55, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F2E8E7, 0x009D4F49, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00DEC4C2, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00DEC4C2, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00B77E7A, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00DEC4C2, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00A35B55, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00E5D0CF, 
        0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 
        0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 
        0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 
        0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 
        0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 
        0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00E5D0CF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00D1ADAA, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00C49592, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00B77E7A, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00AA6661, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00F2E8E7, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00AA6661, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00F2E8E7, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00D1ADAA, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00C49592, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00B77E7A, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00B77E7A, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00DEC4C2, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00A35B55, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00E5D0CF, 
        0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 
        0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 
        0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 
        0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 
        0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 
        0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00E5D0CF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00A35B55, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F2E8E7, 0x009D4F49, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00DEC4C2, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00DEC4C2, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00AA6661, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00D1ADAA, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EBDCDB, 0x009D4F49, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00B0726E, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00D1ADAA, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00C49592, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00B77E7A, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F8F3F3, 0x00AA6661, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00B0726E, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00B77E7A, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00DEC4C2, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00A35B55, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00BD8A86, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00DEC4C2, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x0096433D, 0x0096433D, 0x0096433D, 0x00A35B55, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00F2E8E7, 0x009D4F49, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00D8B9B6, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x00AA6661, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 
        0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 
        0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 
        0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 
        0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 
        0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00CBA19E, 0x00E5D0CF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x0096433D, 0x0096433D, 0x0096433D, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00AA6661, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00D1ADAA, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EBDCDB, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x009D4F49, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x0096433D, 0x0096433D, 0x00D1ADAA, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00C49592, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00B77E7A, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F8F3F3, 0x00A35B55, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x00D8B9B6, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x0096433D, 0x00B77E7A, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00DEC4C2, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00A35B55, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B77E7A, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00BD8A86, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x00A35B55, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F2E8E7, 0x009D4F49, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CBA19E, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00AA6661, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00AA6661, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x00D1ADAA, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00E5D0CF, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x009D4F49, 0x00F2E8E7, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00C49592, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x00B77E7A, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F8F3F3, 0x009D4F49, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00DEC4C2, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F2F2F2, 0x00AFAFAF, 0x00878787, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x00878787, 0x00BCBCBC, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00D7D7D7, 0x00AFAFAF, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00AFAFAF, 0x00E4E4E4, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00D7D7D7, 0x00949494, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x00797979, 0x00AFAFAF, 0x00F2F2F2, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00BCBCBC, 0x00878787, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x00878787, 0x00AFAFAF, 0x00F2F2F2, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00E4E4E4, 0x00BCBCBC, 0x00949494, 0x00949494, 
        0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00A1A1A1, 0x00D7D7D7, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00D7D7D7, 0x00AFAFAF, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 
        0x00949494, 0x00949494, 0x00CACACA, 0x00CACACA, 0x00F2F2F2, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00DEC4C2, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x00A35B55, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00AA6661, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00CBA19E, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00AFAFAF, 0x00363636, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00444444, 0x00BCBCBC, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CACACA, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00E4E4E4, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CACACA, 0x00444444, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00797979, 0x00F2F2F2, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00BCBCBC, 0x00444444, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00363636, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00363636, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00A1A1A1, 0x00FFFFFF, 0x00FFFFFF, 0x00BCBCBC, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00797979, 0x00F2F2F2, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F2E8E7, 0x009D4F49, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00C49592, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00B0726E, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00AFAFAF, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00BCBCBC, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00D7D7D7, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00AFAFAF, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00515151, 0x00F2F2F2, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00797979, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00515151, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CACACA, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x005F5F5F, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00AA6661, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x00D1ADAA, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00DEC4C2, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x009D4F49, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00363636, 0x00292929, 0x00292929, 0x00292929, 0x006C6C6C, 0x00D7D7D7, 0x00FFFFFF, 0x00F2F2F2, 0x00AFAFAF, 0x00444444, 0x00292929, 0x00292929, 0x00292929, 0x005F5F5F, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 
        0x00292929, 0x00292929, 0x00292929, 0x005F5F5F, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00BCBCBC, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CACACA, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00363636, 0x00878787, 0x00CACACA, 0x00CACACA, 0x00AFAFAF, 0x005F5F5F, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00878787, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00A1A1A1, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00444444, 0x00A1A1A1, 0x00CACACA, 0x00CACACA, 0x00AFAFAF, 0x00444444, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00A1A1A1, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CACACA, 0x00292929, 0x00292929, 0x00292929, 0x00444444, 
        0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00A1A1A1, 0x00F2F2F2, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929, 0x005F5F5F, 0x00949494, 0x00949494, 0x00949494, 
        0x00949494, 0x00878787, 0x00444444, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00D7D7D7, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00C49592, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00B77E7A, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EBDCDB, 0x009D4F49, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00E4E4E4, 0x00292929, 0x00292929, 0x00292929, 0x00515151, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F2F2F2, 0x00515151, 0x00292929, 0x00292929, 0x006C6C6C, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 
        0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00444444, 0x00292929, 0x00292929, 0x00292929, 
        0x00515151, 0x00E4E4E4, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00797979, 0x00292929, 0x00292929, 0x00292929, 0x00797979, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F2F2F2, 0x00363636, 0x00292929, 0x00292929, 0x00292929, 
        0x00515151, 0x00F2F2F2, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F2F2F2, 0x00797979, 0x00292929, 0x00292929, 0x00292929, 0x00A1A1A1, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CACACA, 0x00292929, 0x00292929, 0x00292929, 0x005F5F5F, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00F2F2F2, 0x00444444, 0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00DEC4C2, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00A35B55, 0x00F8F3F3, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F8F3F3, 0x00AA6661, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00D1ADAA, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00E4E4E4, 0x00292929, 0x00292929, 0x00292929, 0x00363636, 0x00CACACA, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F2F2F2, 0x00A1A1A1, 0x00A1A1A1, 0x00F2F2F2, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 
        0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00D7D7D7, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00CACACA, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00A1A1A1, 0x005F5F5F, 0x006C6C6C, 0x00E4E4E4, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00A1A1A1, 0x00292929, 0x00292929, 0x00292929, 0x00363636, 
        0x00F2F2F2, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x005F5F5F, 0x00797979, 0x00F2F2F2, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CACACA, 0x00292929, 0x00292929, 0x00292929, 0x005F5F5F, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F2E8E7, 0x009D4F49, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00EBDCDB, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00BD8A86, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00B77E7A, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00363636, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00515151, 0x00878787, 0x00BCBCBC, 0x00E4E4E4, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 
        0x00292929, 0x00292929, 0x00292929, 0x00797979, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00D7D7D7, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929, 0x00515151, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x006C6C6C, 0x00292929, 0x00292929, 0x00292929, 0x00797979, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CACACA, 0x00292929, 0x00292929, 0x00292929, 0x00515151, 
        0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00F2F2F2, 0x00444444, 0x00292929, 0x00292929, 0x00292929, 0x00BCBCBC, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00AA6661, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00D1ADAA, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00D8B9B6, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00AA6661, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00A1A1A1, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00363636, 0x006C6C6C, 0x00AFAFAF, 0x00F2F2F2, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00BCBCBC, 0x00FFFFFF, 0x00FFFFFF, 0x006C6C6C, 0x00292929, 0x00292929, 0x00292929, 0x00878787, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00D7D7D7, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00E4E4E4, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x005F5F5F, 0x00292929, 0x00292929, 0x00292929, 0x00AFAFAF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00E4E4E4, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CACACA, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00797979, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929, 0x005F5F5F, 0x00949494, 0x00949494, 0x00949494, 
        0x00949494, 0x00797979, 0x00444444, 0x00292929, 0x00292929, 0x00292929, 0x00515151, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00C49592, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00B77E7A, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EBDCDB, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x009D4F49, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00BCBCBC, 0x00444444, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00363636, 0x00AFAFAF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00A1A1A1, 0x00FFFFFF, 0x00FFFFFF, 0x005F5F5F, 0x00292929, 0x00292929, 0x00292929, 0x00949494, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00A1A1A1, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00AFAFAF, 0x00FFFFFF, 0x00FFFFFF, 0x005F5F5F, 0x00292929, 0x00292929, 0x00292929, 0x00CACACA, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00878787, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00D7D7D7, 0x00FFFFFF, 0x00FFFFFF, 0x00CACACA, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x006C6C6C, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x006C6C6C, 0x00F2F2F2, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00DEC4C2, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00A35B55, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F8F3F3, 0x00A35B55, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00D8B9B6, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00D7D7D7, 0x00949494, 0x005F5F5F, 0x00363636, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00CACACA, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 
        0x00292929, 0x00292929, 0x00292929, 0x005F5F5F, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00AFAFAF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x006C6C6C, 0x00292929, 0x00292929, 0x00292929, 0x00878787, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x005F5F5F, 0x00292929, 0x00292929, 0x00292929, 0x00A1A1A1, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x006C6C6C, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00CACACA, 0x00292929, 0x00292929, 0x00292929, 0x00444444, 
        0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00F2F2F2, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00363636, 0x00D7D7D7, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F2E8E7, 0x009D4F49, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00BD8A86, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00D7D7D7, 0x00A1A1A1, 0x00444444, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00797979, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 
        0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929, 0x00515151, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F2F2F2, 0x00797979, 0x005F5F5F, 0x005F5F5F, 0x00515151, 0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x006C6C6C, 0x00292929, 0x00292929, 0x00292929, 0x00797979, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00D7D7D7, 0x00797979, 0x005F5F5F, 0x005F5F5F, 0x00444444, 0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00CACACA, 0x00292929, 0x00292929, 0x00292929, 0x005F5F5F, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929, 0x005F5F5F, 0x00949494, 0x00949494, 0x00949494, 
        0x00949494, 0x00878787, 0x00363636, 0x00292929, 0x00292929, 0x00292929, 0x006C6C6C, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00AA6661, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00D1ADAA, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00CBA19E, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00AA6661, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00878787, 0x00363636, 0x00515151, 0x00D7D7D7, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929, 0x005F5F5F, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 
        0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00D7D7D7, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00CACACA, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00A1A1A1, 0x00292929, 0x00292929, 0x00292929, 0x00363636, 
        0x00E4E4E4, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00797979, 0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00CACACA, 0x00292929, 0x00292929, 0x00292929, 0x005F5F5F, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00AFAFAF, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CBA19E, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00B77E7A, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00EBDCDB, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x009D4F49, 0x00F2E8E7, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00292929, 0x00292929, 0x00292929, 0x00363636, 0x00F2F2F2, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00BCBCBC, 0x00292929, 0x00292929, 0x00292929, 0x005F5F5F, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 
        0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00444444, 0x00292929, 0x00292929, 0x00292929, 
        0x00363636, 0x00D7D7D7, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00D7D7D7, 0x00363636, 0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00F2F2F2, 0x00363636, 0x00292929, 0x00292929, 0x00292929, 
        0x00515151, 0x00F2F2F2, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00AFAFAF, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00CACACA, 0x00292929, 0x00292929, 0x00292929, 0x005F5F5F, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00D7D7D7, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B0726E, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00A35B55, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00CBA19E, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00DEC4C2, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00363636, 0x00292929, 0x00292929, 0x00292929, 0x00444444, 0x00AFAFAF, 0x00D7D7D7, 0x00FFFFFF, 0x00D7D7D7, 0x00AFAFAF, 0x00363636, 0x00292929, 0x00292929, 0x00292929, 0x00A1A1A1, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 
        0x00292929, 0x00292929, 0x00292929, 0x00444444, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x00797979, 0x00D7D7D7, 0x00FFFFFF, 0x00FFFFFF, 0x00CACACA, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00797979, 0x00BCBCBC, 0x00CACACA, 0x00BCBCBC, 0x00797979, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00A1A1A1, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00363636, 0x00878787, 0x00CACACA, 0x00CACACA, 0x00AFAFAF, 0x005F5F5F, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00CACACA, 0x00292929, 0x00292929, 0x00292929, 0x00363636, 
        0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x006C6C6C, 0x00BCBCBC, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00E4E4E4, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B77E7A, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00D8B9B6, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00CBA19E, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00AFAFAF, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00515151, 0x00F2F2F2, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x006C6C6C, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00AFAFAF, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00363636, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00797979, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00363636, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00CACACA, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00363636, 0x00292929, 0x00292929, 0x00292929, 0x00AFAFAF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F2E8E7, 0x00A35B55, 0x0096433D, 0x0096433D, 0x00D8B9B6, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00BD8A86, 0x0096433D, 0x0096433D, 0x00BD8A86, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00BCBCBC, 0x00444444, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x005F5F5F, 0x00F2F2F2, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CACACA, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00797979, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CACACA, 0x00444444, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00878787, 0x00A1A1A1, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00AFAFAF, 0x00363636, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00AFAFAF, 0x00797979, 0x00292929, 0x00292929, 0x00AFAFAF, 0x00FFFFFF, 0x00FFFFFF, 0x00F2F2F2, 0x00363636, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00363636, 0x00FFFFFF, 0x00FFFFFF, 0x00A1A1A1, 0x00292929, 0x00292929, 0x00292929, 0x00AFAFAF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x006C6C6C, 0x00292929, 0x00292929, 0x00292929, 0x00AFAFAF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EBDCDB, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F2E8E7, 0x00F2E8E7, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00BCBCBC, 0x00878787, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x00949494, 0x00D7D7D7, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00D7D7D7, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00BCBCBC, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00BCBCBC, 0x00797979, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x00878787, 0x00D7D7D7, 0x00FFFFFF, 0x00F2F2F2, 0x006C6C6C, 0x005F5F5F, 0x00D7D7D7, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F2F2F2, 
        0x00AFAFAF, 0x00797979, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x005F5F5F, 0x00949494, 0x00E4E4E4, 0x00FFFFFF, 0x00D7D7D7, 0x005F5F5F, 0x005F5F5F, 0x00E4E4E4, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00E4E4E4, 0x00A1A1A1, 0x00949494, 0x00949494, 
        0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00A1A1A1, 0x00E4E4E4, 0x00FFFFFF, 0x00FFFFFF, 0x00F2F2F2, 0x00A1A1A1, 0x00949494, 0x00A1A1A1, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F2F2F2, 0x00949494, 0x006C6C6C, 0x00A1A1A1, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00949494, 0x00292929, 0x00292929, 0x00292929,
  0x00292929, 0x00292929, 0x00292929, 0x006C6C6C, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x006C6C6C, 0x00292929, 0x00292929, 0x00292929,
  0x30292929, 0x00292929, 0x00292929, 0x00292929, 0x00AFAFAF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00AFAFAF, 0x00292929, 0x00292929, 0x00292929, 0x30292929,
  0x9F292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00797979, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 
        0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 
        0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 
        0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 
        0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 
        0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 
        0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 
        0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00949494, 0x00797979, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x9F292929,
  0xFF000000, 0x30292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x30292929, 0xFF000000,
  0xFF000000, 0xEF292929, 0x30292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x30292929, 0xEF292929, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0x7F292929, 0x20292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x20292929, 0x7F292929, 0xFF000000, 0xFF000000, 0xFF000000
};

static GUI_CONST_STORAGE GUI_BITMAP _bmSeggerLogo_160x80 = {
  160,                                   // XSize
  80,                                    // YSize
  640,                                   // BytesPerLine
  32,                                    // BitsPerPixel
  (unsigned char *)acSeggerLogo_160x80,  // Pointer to picture data
  NULL                                   // Pointer to palette
 ,GUI_DRAW_BMP8888
};

/*********************************************************************
*
*       Static code
*
**********************************************************************
*/
/*********************************************************************
*
*       _DrawFrame
*/
static void _DrawFrame(int x0, int y0, int x1, int y1, int b) {
  GUI_FillRect(x0, y0, x1, y0 + b - 1);
  GUI_FillRect(x0, y0 + b, x0 + b - 1, y1 - b);
  GUI_FillRect(x1 - b + 1, y0 + b, x1, y1 - b);
  GUI_FillRect(x0, y1 - b + 1, x1, y1);
}

/*********************************************************************
*
*       _DrawLogo
*/
static void _DrawLogo(int xSize,GUI_MEMDEV_Handle hLogo, GUI_MEMDEV_Handle hMemWork, GUI_RECT * pRect) {
  int xSizeLogo;
  int ySizeLogo;
  int Factor;
  int xFactor;
  int yFactor;

  xSizeLogo = GUI_MEMDEV_GetXSize(hLogo);
  ySizeLogo = GUI_MEMDEV_GetYSize(hLogo);
  if ((xSizeLogo < (pRect->x1 - pRect->x0 + 1)) && (ySizeLogo < (pRect->y1 - pRect->y0 + 1))) {
    GUI_MEMDEV_WriteAt(hLogo,
                       pRect->x0 + (pRect->x1 - pRect->x0 + 1 - xSizeLogo) / 2,
                       pRect->y0 + (pRect->y1 - pRect->y0 + 1 - ySizeLogo) / 2);
  } else {
    xFactor = ((pRect->x1 - pRect->x0 + 1) * 1000) / xSizeLogo;
    yFactor = ((pRect->y1 - pRect->y0 + 1) * 1000) / ySizeLogo;
    Factor = (xFactor > yFactor) ? yFactor : xFactor;
    GUI_MEMDEV_RotateHQ(hLogo, hMemWork,
                        (xSize - xSizeLogo) / 2,
                        pRect->y0 + ((pRect->y1 - pRect->y0 + 1) - ySizeLogo) / 2,
                        0, Factor);
  }
}

/*********************************************************************
*
*       _DrawText
*/
static void _DrawText(GUI_RECT * pRect) {
  GUI_SetFont(GUI_FONT_20_ASCII);
  GUI_SetColor(GUI_WHITE);
  GUI_SetTextMode(GUI_TM_TRANS);
  GUI_DispStringInRectWrap("This sample shows fading between 2 screens", pRect, GUI_TA_HCENTER | GUI_TA_VCENTER, GUI_WRAPMODE_WORD);
}

/*********************************************************************
*
*       _Paint0
*/
static void _Paint0(int xSize, int ySize, GUI_MEMDEV_Handle hLogo, GUI_MEMDEV_Handle hMemWork) {
  GUI_RECT rLogo;
  GUI_RECT rText;
  int      ySizeText;

  //
  // Background
  //
  GUI_SetBkColor(GUI_MAGENTA);
  GUI_Clear();
  GUI_SetColor(GUI_WHITE);
  _DrawFrame(10, 10, xSize - 11, ySize - 11, 5);
  GUI_SetColor(GUI_BLUE);
  GUI_FillRect(15, 15, xSize - 16, ySize - 16);
  //
  // Screen0
  //
  GUI_SetColor(GUI_WHITE);
  GUI_SetFont(GUI_FONT_24B_ASCII);
  GUI_SetTextMode(GUI_TM_TRANS);
  ySizeText = GUI_GetFontDistY();
  GUI_DispStringHCenterAt("Screen 0", xSize / 2, (ySize - ySizeText) / 2);
  //
  // Logo
  //
  rLogo.x0 = 25;
  rLogo.y0 = 25;
  rLogo.x1 = xSize - 25 - 1;
  rLogo.y1 = (ySize - ySizeText) / 2 - 10 - 1;
  _DrawLogo(xSize, hLogo, hMemWork, &rLogo);
  //
  // Message
  //
  rText.x0 = 25;
  rText.y0 = (ySize - ySizeText) / 2 + ySizeText + 10;
  rText.x1 = xSize - 25 - 1;
  rText.y1 = ySize - 25;
  _DrawText(&rText);
}

/*********************************************************************
*
*       _Paint1
*/
static void _Paint1(int xSize, int ySize, GUI_MEMDEV_Handle hLogo, GUI_MEMDEV_Handle hMemWork) {
  GUI_RECT rLogo;
  GUI_RECT rText;
  int      ySizeText;

  //
  // Background
  //
  GUI_SetBkColor(GUI_CYAN);
  GUI_Clear();
  GUI_SetColor(GUI_WHITE);
  _DrawFrame(10, 10, xSize - 11, ySize - 11, 5);
  GUI_SetColor(GUI_BLUE);
  GUI_FillRect(15, 15, xSize - 16, ySize - 16);
  //
  // Screen1
  //
  GUI_SetColor(GUI_WHITE);
  GUI_SetFont(GUI_FONT_24B_ASCII);
  GUI_SetTextMode(GUI_TM_TRANS);
  ySizeText = GUI_GetFontDistY();
  GUI_DispStringHCenterAt("Screen 1", xSize / 2, (ySize - ySizeText) / 2);
  //
  // Logo
  //
  rLogo.x0 = 25;
  rLogo.y0 = (ySize - ySizeText) / 2 + ySizeText + 10;
  rLogo.x1 = xSize - 25 - 1;
  rLogo.y1 = ySize - 25;
  _DrawLogo(xSize, hLogo, hMemWork, &rLogo);
  //
  // Message
  //
  rText.x0 = 25;
  rText.y0 = 25;
  rText.x1 = xSize - 25 - 1;
  rText.y1 = (ySize - ySizeText) / 2 - 10 - 1;
  _DrawText(&rText);
}

/*********************************************************************
*
*       _MakeString
*/
static void _MakeString(int v, int NumDecs, int Shift,  char * acBuffer) {
  int i;
  int a;
  int s;

  acBuffer[NumDecs--] = '0' + (a = v) % 10;
  for (i = 1, s = 1; i <= NumDecs; i++) {
    if (i == Shift) {
      acBuffer[NumDecs - i + s] = '.';
      s = 0;
    }
    acBuffer[NumDecs - i + s] = '0' + (a /= 10) % 10;
  }
}

/*********************************************************************
*
*       _DrawResult
*/
static void _DrawResult(int xSize, int ySize, int ResultDrawing, int ResultFading, int ResultTotal) {
  const char   acDrawing[] = "Drawing: ";
  const char   acFading [] = "Fading: ";
  const char   acTotal  [] = "Total: ";
  const char * apString[3];
  char         acValue[7] = {0};
  int        * apValues[3];
  unsigned     i;
  int          xMid;
  int          yMid;
  int          ySizeFont;
  int          ySizeTotal;
  int          xPosText;
  int          yPosText;
  int          xSizeText;
  int          xSizeLabel;
  int          xSizeValue;
  int          xSizeTotal;

  apString[0] = acDrawing;
  apString[1] = acFading;
  apString[2] = acTotal;
  apValues[0] = &ResultDrawing;
  apValues[1] = &ResultFading;
  apValues[2] = &ResultTotal;
  //
  // Set font
  //
  GUI_SetFont(GUI_FONT_20B_ASCII);
  //
  // Calculate positions
  //
  xMid = xSize / 2;
  yMid = ySize / 2;
  ySizeFont = GUI_GetFontSizeY();
  ySizeTotal = 4 * ySizeFont + 2 * 10;
  yPosText = (yMid - ySizeTotal / 2) / 2;
  for (i = xSizeLabel = 0; i < GUI_COUNTOF(apString); i++ ) {
    xSizeText = GUI_GetStringDistX(apString[i]);
    if (xSizeLabel < xSizeText) {
      xSizeLabel = xSizeText;
    }
  }
  xSizeValue = GUI_GetStringDistX("00.000");
  xSizeTotal = xSizeLabel + xSizeValue;
  xPosText = xMid - xSizeTotal / 2;
  //
  // Draw result
  //
  GUI_SetBkColor(GUI_BLUE);
  GUI_SetColor(GUI_WHITE);
  GUI_SetTextMode(GUI_TM_TRANS);
  GUI_Clear();
  GUI_DispStringHCenterAt("Result [MPixels/s]:", xMid, yPosText);
  GUI_SetTextAlign(GUI_TA_LEFT);
  for (i = 0; i < GUI_COUNTOF(apString); i++ ) {
    GUI_DispStringAt(apString[i], xPosText, yPosText + (i + 1) * ySizeFont + 10);
  }
  for (i = 0; i < GUI_COUNTOF(apString); i++ ) {
    _MakeString(*apValues[i], 5, 3, acValue);
    GUI_DispStringAt(acValue, xPosText + xSizeLabel, yPosText + (i + 1) * ySizeFont + 10);
  }
}

/*********************************************************************
*
*       _DrawMessage
*/
static void _DrawMessage(int xSize, int ySize) {
  int ySizeFont;

  GUI_SetFont(GUI_FONT_24B_ASCII);
  GUI_SetBkColor(GUI_BLUE);
  GUI_Clear();
  GUI_SetTextAlign(GUI_TA_HCENTER);
  ySizeFont = GUI_GetFontDistY();
  GUI_DispStringHCenterAt("Evaluating\nfading\nperformance", xSize / 2, (ySize - ySizeFont * 3) / 4);
}

/*********************************************************************
*
*       Public code
*
**********************************************************************
*/
/*********************************************************************
*
*       MainTask
*/
void MainTask(void);
void MainTask(void) {
  GUI_MEMDEV_Handle ahMem[2];
  GUI_MEMDEV_Handle hMemWork;
  GUI_MEMDEV_Handle hLogo;
  void              (* apFunc[])(int, int, GUI_MEMDEV_Handle, GUI_MEMDEV_Handle) = { _Paint0, _Paint1 };
  int               xSize;
  int               ySize;
  unsigned          i;
  int               j;
  int               TimeStart;
  int               TimeNow;
  int               Cnt;
  int               ResultFading;
  int               ResultDrawing;
  int               ResultTotal;

  GUI_Init();
  //
  // Check if recommended memory for the sample is available
  //
  if (GUI_ALLOC_GetNumFreeBytes() < RECOMMENDED_MEMORY) {
    GUI_ErrorOut("Not enough memory available."); 
    return;
  }
  xSize = LCD_GetXSize();
  ySize = LCD_GetYSize();
  //
  // Create logo device
  //
  hLogo = GUI_MEMDEV_CreateFixed(0, 0, _bmSeggerLogo_160x80.XSize, _bmSeggerLogo_160x80.YSize, GUI_MEMDEV_NOTRANS, GUI_MEMDEV_APILIST_32, GUI_COLOR_CONV_888);
  GUI_MEMDEV_Select(hLogo);
  GUI_SetBkColor(GUI_TRANSPARENT);
  GUI_Clear();
  GUI_DrawBitmap(&_bmSeggerLogo_160x80, 0, 0);
  //
  // Create work device
  //
  hMemWork = GUI_MEMDEV_CreateFixed(0, 0, xSize, ySize, GUI_MEMDEV_NOTRANS, GUI_MEMDEV_APILIST_32, GUI_COLOR_CONV_888);
  //
  // Create screen devices
  //
  for (i = 0; i < GUI_COUNTOF(ahMem); i++) {
    ahMem[i] = GUI_MEMDEV_CreateFixed(0, 0, xSize, ySize, GUI_MEMDEV_HASTRANS, GUI_MEMDEV_APILIST_32, GUI_COLOR_CONV_888);
    GUI_MEMDEV_Select(ahMem[i]);
    apFunc[i](xSize, ySize, hLogo, ahMem[i]);
  }
  GUI_MEMDEV_Select(0);
  //
  // Animation loop
  //
  while (1) {
    //
    // Show fading
    //
    for (j = 0; j < 2; j++) {
      for (i = 0; i < GUI_COUNTOF(ahMem); i++) {
        GUI_MEMDEV_FadeDevices(ahMem[i], ahMem[i ^ 1], 1000);
        if (i == 0) {
          GUI_Delay(1000);
        }
      }
      if (j == 0) {
        GUI_Delay(1000);
      }
    }
    //
    // Measure drawing performance
    //
    GUI_MEMDEV_CopyFromLCD(hMemWork);
    TimeStart = GUI_GetTime();
    Cnt = 0;
    do {
      GUI_MEMDEV_Write(hMemWork);
      TimeNow = GUI_GetTime();
      Cnt++;
    } while (TimeNow < (TimeStart + 1000));
    ResultDrawing = (xSize * ySize * Cnt) / (TimeNow - TimeStart);
    //
    // Measure total performance
    //
    TimeStart = GUI_GetTime();
    Cnt = 0;
    do {
      GUI_MEMDEV__FadeDevice(ahMem[0], ahMem[1], hMemWork, Cnt & 0xff);
      GUI_MEMDEV_Write(hMemWork);
      TimeNow = GUI_GetTime();
      Cnt++;
    } while (TimeNow < (TimeStart + 1000));
    ResultTotal  = (xSize * ySize * Cnt) / (TimeNow - TimeStart);
    //
    // Short message
    //
    GUI_MEMDEV_Select(ahMem[0]);
    _DrawMessage(xSize, ySize);
    GUI_MEMDEV_Select(ahMem[1]);
    GUI_MEMDEV_Write(hMemWork);
    GUI_MEMDEV_Select(0);
    GUI_MEMDEV_FadeDevices(ahMem[0], ahMem[1], 1000);
    GUI_Delay(2000);
    //
    // Measure fading performance
    //
    TimeStart = GUI_GetTime();
    Cnt = 0;
    do {
      GUI_MEMDEV__FadeDevice(ahMem[0], ahMem[1], hMemWork, Cnt & 0xff);
      TimeNow = GUI_GetTime();
      Cnt++;
    } while (TimeNow < (TimeStart + 1000));
    ResultFading  = (xSize * ySize * Cnt) / (TimeNow - TimeStart);
    //
    // Draw result(s)
    //
    GUI_MEMDEV_Select(ahMem[1]);
    _DrawResult(xSize, ySize, ResultDrawing, ResultFading, ResultTotal);
    GUI_MEMDEV_Select(0);
    GUI_MEMDEV_FadeDevices(ahMem[1], ahMem[0], 1000);
    GUI_Delay(10000);
    //
    // Fade out...
    //
    GUI_MEMDEV_Select(ahMem[0]);
    GUI_SetBkColor(GUI_BLACK);
    GUI_Clear();
    GUI_MEMDEV_Select(0);
    GUI_MEMDEV_FadeDevices(ahMem[0], ahMem[1], 1000);
    GUI_MEMDEV_Select(ahMem[1]);
    apFunc[1](xSize, ySize, hLogo, ahMem[1]);
    GUI_MEMDEV_Select(0);
    GUI_MEMDEV_FadeDevices(ahMem[1], ahMem[0], 1000);
    GUI_MEMDEV_Select(ahMem[0]);
    apFunc[0](xSize, ySize, hLogo, ahMem[0]);
    GUI_MEMDEV_Select(0);
    GUI_Delay(1000);
  }
}

/*************************** End of file ****************************/
