/*********************************************************************
*                SEGGER Microcontroller GmbH & Co. KG                *
*        Solutions for real time microcontroller applications        *
**********************************************************************
*                                                                    *
*        (c) 1996 - 2016  SEGGER Microcontroller GmbH & Co. KG       *
*                                                                    *
*        Internet: www.segger.com    Support:  support@segger.com    *
*                                                                    *
**********************************************************************

** emWin V5.34 - Graphical user interface for embedded applications **
All  Intellectual Property rights  in the Software belongs to  SEGGER.
emWin is protected by  international copyright laws.  Knowledge of the
source code may not be used to write a similar product.  This file may
only be used in accordance with the following terms:

The  software has  been licensed  to Silicon Labs Norway, a subsidiary
of Silicon Labs Inc. whose registered office is 400 West Cesar Chavez,
Austin,  TX 78701, USA solely for  the purposes of creating  libraries 
for its  ARM Cortex-M3, M4F  processor-based devices,  sublicensed and 
distributed  under the  terms and conditions  of the  End User License  
Agreement supplied by Silicon Labs.
Full source code is available at: www.segger.com

We appreciate your understanding and fairness.
----------------------------------------------------------------------
Licensing information

Licensor:                 SEGGER Software GmbH
Licensed to:              Silicon Laboratories Norway
Licensed SEGGER software: emWin
License number:           GUI-00140
License model:            See Agreement, dated 20th April 2012
Licensed product:         - 
Licensed platform:        Cortex M3, Cortex M4F
Licensed number of seats: -
----------------------------------------------------------------------
File        : MEMDEV_WindowEffects.c
Purpose     : Shows how to use the window animation functions
Requirements: WindowManager - (x)
              MemoryDevices - (x)
              AntiAliasing  - ( )
              VNC-Server    - ( )
              PNG-Library   - ( )
              TrueTypeFonts - ( )
----------------------------------------------------------------------
*/

#include <stddef.h>
#include <stdlib.h>
#include <math.h>
#include "Main.h"
#include "DIALOG.h"

//
// Recommended memory to run the sample with adequate performance
//
#define RECOMMENDED_MEMORY (1024L * 1600)

/*********************************************************************
*
*       bmLogoSegger_36x18
*/
static GUI_CONST_STORAGE GUI_COLOR ColorsLogoSegger_36x18[] = {
     0xFFFFFF,0x5F5F5F,0xCBA19E,0xB0726E
    ,0x444444,0x96433D,0xEBDCDB,0x515151
    ,0x9D4F49,0xAA6661,0x949494,0xF8F3F3
    ,0xBCBCBC,0xBD8A86,0x6C6C6C,0xAFAFAF
    ,0x292929,0x363636,0x878787,0xD8B9B6
    ,0xE5D0CF,0xF2E8E7,0xD7D7D7,0xB77E7A
    ,0xA1A1A1,0xD1ADAA,0xDEC4C2,0xE4E4E4
    ,0x797979,0xA35B55,0xC49592,0xF2F2F2
    ,0xCACACA
};

static GUI_CONST_STORAGE GUI_LOGPALETTE PalLogoSegger_36x18 = {
  33,	// number of entries
  0, 	// No transparency
  &ColorsLogoSegger_36x18[0]
};

static GUI_CONST_STORAGE unsigned char acLogoSegger_36x18[] = {
  0x07, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x04, 0x07,
  0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04,
  0x01, 0x15, 0x17, 0x0B, 0x00, 0x17, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
  0x01, 0x15, 0x08, 0x0D, 0x00, 0x09, 0x09, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
  0x01, 0x00, 0x13, 0x05, 0x13, 0x06, 0x08, 0x0D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
  0x01, 0x00, 0x00, 0x0D, 0x08, 0x06, 0x1A, 0x05, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
  0x01, 0x14, 0x19, 0x0B, 0x09, 0x09, 0x0B, 0x1E, 0x05, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
  0x01, 0x14, 0x05, 0x06, 0x06, 0x08, 0x0D, 0x00, 0x09, 0x08, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x00, 0x01,
  0x01, 0x14, 0x05, 0x1D, 0x0B, 0x13, 0x05, 0x1A, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x01,
  0x01, 0x14, 0x05, 0x1D, 0x0B, 0x13, 0x05, 0x1A, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x00, 0x01,
  0x01, 0x14, 0x05, 0x06, 0x06, 0x08, 0x0D, 0x00, 0x09, 0x08, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x00, 0x01,
  0x01, 0x14, 0x19, 0x0B, 0x09, 0x09, 0x0B, 0x1E, 0x05, 0x06, 0x00, 0x1B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
  0x01, 0x00, 0x00, 0x0D, 0x08, 0x06, 0x1A, 0x05, 0x19, 0x0C, 0x11, 0x07, 0x01, 0x0A, 0x04, 0x01, 0x12, 0x18, 0x11, 0x04, 0x07, 0x1B, 0x04, 0x07, 0x10, 0x0C, 0x01, 0x07, 0x01, 0x0F, 0x10, 0x01, 0x11, 0x0C, 0x00, 0x01,
  0x01, 0x00, 0x13, 0x05, 0x13, 0x06, 0x08, 0x0D, 0x00, 0x0F, 0x11, 0x0E, 0x12, 0x0A, 0x04, 0x01, 0x0F, 0x11, 0x0C, 0x0F, 0x01, 0x12, 0x07, 0x16, 0x0E, 0x0C, 0x01, 0x07, 0x01, 0x16, 0x10, 0x0A, 0x07, 0x18, 0x00, 0x01,
  0x01, 0x15, 0x08, 0x0D, 0x00, 0x09, 0x09, 0x0B, 0x00, 0x0C, 0x0E, 0x18, 0x10, 0x0A, 0x01, 0x0A, 0x0C, 0x04, 0x0A, 0x0A, 0x10, 0x1C, 0x04, 0x0C, 0x11, 0x0A, 0x01, 0x1C, 0x0A, 0x1B, 0x10, 0x20, 0x04, 0x18, 0x00, 0x01,
  0x01, 0x15, 0x17, 0x0B, 0x00, 0x17, 0x06, 0x00, 0x00, 0x16, 0x0E, 0x01, 0x12, 0x0C, 0x01, 0x01, 0x0E, 0x16, 0x01, 0x01, 0x0E, 0x16, 0x12, 0x01, 0x0E, 0x0F, 0x12, 0x01, 0x01, 0x0F, 0x01, 0x00, 0x0A, 0x0F, 0x00, 0x01,
  0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04,
  0x07, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x04, 0x07
};

GUI_CONST_STORAGE GUI_BITMAP bmLogoSegger_36x18 = {
  36, // XSize
  18, // YSize
  36, // BytesPerLine
  8, // BitsPerPixel
  acLogoSegger_36x18,  // Pointer to picture data (indices)
  &PalLogoSegger_36x18  // Pointer to palette
};

/*********************************************************************
*
*       _FontBig
*/
//
// Start of unicode area <Basic Latin>
//
GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_0020[  1] = { // Code 0020, SPACE
  0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_0021[ 12] = { // Code 0021, EXCLAMATION MARK
  0xFF,
  0xFF,
  0xFF,
  0xEE,
  0xDD,
  0xCC,
  0xBB,
  0x99,
  0x89,
  0x00,
  0xFF,
  0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_0022[ 12] = { // Code 0022, QUOTATION MARK
  0xFF, 0x00, 0xFF,
  0xFF, 0x00, 0xFF,
  0xEE, 0x00, 0xEE,
  0xBC, 0x00, 0xBC
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_0023[ 60] = { // Code 0023, NUMBER SIGN
  0x00, 0x02, 0xFE, 0x2F, 0xE0,
  0x00, 0x06, 0xFA, 0x6F, 0xA0,
  0x00, 0x09, 0xF6, 0x9F, 0x60,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0x00, 0x6F, 0xA6, 0xFA, 0x00,
  0x00, 0x9F, 0x69, 0xF6, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0x06, 0xFA, 0x6F, 0xA0, 0x00,
  0x09, 0xF6, 0x9F, 0x60, 0x00,
  0x0D, 0xF2, 0xDF, 0x20, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_0024[ 60] = { // Code 0024, DOLLAR SIGN
  0x00, 0x0F, 0x00, 0x00,
  0x07, 0xEF, 0xE7, 0x00,
  0x7F, 0xFF, 0xFF, 0x70,
  0xEF, 0x4F, 0x5F, 0xD0,
  0xFF, 0x0F, 0x00, 0x00,
  0xCF, 0xBF, 0x00, 0x00,
  0x4F, 0xFF, 0xC4, 0x00,
  0x03, 0xAF, 0xFF, 0x60,
  0x00, 0x0F, 0x8F, 0xE0,
  0xEF, 0x1F, 0x0F, 0xF0,
  0xAF, 0x7F, 0x3F, 0xD0,
  0x4F, 0xFF, 0xFF, 0x60,
  0x06, 0xDF, 0xD6, 0x00,
  0x00, 0x0F, 0x00, 0x00,
  0x00, 0x0F, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_0025[ 96] = { // Code 0025, PERCENT SIGN
  0x1B, 0xFF, 0xB1, 0x00, 0x03, 0xFC, 0x00, 0x00,
  0xBF, 0x44, 0xFB, 0x00, 0x0C, 0xF4, 0x00, 0x00,
  0xFF, 0x00, 0xFF, 0x00, 0x6F, 0xA0, 0x00, 0x00,
  0xFF, 0x00, 0xFF, 0x01, 0xEF, 0x20, 0x00, 0x00,
  0xBF, 0x44, 0xFB, 0x08, 0xF7, 0x00, 0x00, 0x00,
  0x1B, 0xFF, 0xB1, 0x2F, 0xD0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xBF, 0x51, 0xBF, 0xFB, 0x10,
  0x00, 0x00, 0x04, 0xFB, 0x0B, 0xF4, 0x4F, 0xB0,
  0x00, 0x00, 0x0D, 0xF2, 0x0F, 0xF0, 0x0F, 0xF0,
  0x00, 0x00, 0x7F, 0x80, 0x0F, 0xF0, 0x0F, 0xF0,
  0x00, 0x02, 0xEE, 0x10, 0x0B, 0xF4, 0x4F, 0xB0,
  0x00, 0x0A, 0xF6, 0x00, 0x01, 0xBF, 0xFB, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_0026[ 72] = { // Code 0026, AMPERSAND
  0x01, 0x9E, 0xFE, 0x81, 0x00, 0x00,
  0x0A, 0xFF, 0xFF, 0xFA, 0x00, 0x00,
  0x0F, 0xF3, 0x04, 0xFF, 0x00, 0x00,
  0x0C, 0xF7, 0x05, 0xFD, 0x00, 0x00,
  0x04, 0xFF, 0xDF, 0xE4, 0x00, 0x00,
  0x03, 0xEF, 0xFE, 0x20, 0x00, 0x00,
  0x4F, 0xE9, 0xFF, 0x71, 0x85, 0x00,
  0xCF, 0x40, 0x8F, 0xFC, 0xFD, 0x00,
  0xFF, 0x00, 0x08, 0xFF, 0xF6, 0x00,
  0xDF, 0x80, 0x17, 0xFF, 0xFA, 0x10,
  0x6F, 0xFF, 0xFF, 0xFD, 0xFF, 0xA0,
  0x05, 0xBF, 0xFD, 0x60, 0x6C, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_0027[  4] = { // Code 0027, APOSTROPHE
  0xFF,
  0xFF,
  0xEE,
  0xBC
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_0028[ 30] = { // Code 0028, LEFT PARENTHESIS
  0x04, 0xFB,
  0x0B, 0xF5,
  0x2F, 0xE0,
  0x7F, 0x90,
  0xBF, 0x50,
  0xDF, 0x20,
  0xFF, 0x00,
  0xFF, 0x00,
  0xFF, 0x00,
  0xDF, 0x20,
  0xAF, 0x50,
  0x6F, 0x90,
  0x2F, 0xD0,
  0x0B, 0xF4,
  0x04, 0xFB
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_0029[ 30] = { // Code 0029, RIGHT PARENTHESIS
  0xBF, 0x40,
  0x5F, 0xB0,
  0x0E, 0xF2,
  0x09, 0xF7,
  0x05, 0xFB,
  0x02, 0xFD,
  0x00, 0xFF,
  0x00, 0xFF,
  0x00, 0xFE,
  0x02, 0xFC,
  0x05, 0xFA,
  0x09, 0xF6,
  0x0D, 0xF2,
  0x4F, 0xB0,
  0xBF, 0x40
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_002A[ 15] = { // Code 002A, ASTERISK
  0x00, 0xF0, 0x00,
  0xBA, 0xC9, 0xB0,
  0x28, 0xF8, 0x20,
  0x3E, 0x9E, 0x20,
  0x9B, 0x0B, 0x90
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_002B[ 32] = { // Code 002B, PLUS SIGN
  0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x0F, 0xF0, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF,
  0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x0F, 0xF0, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_002C[  5] = { // Code 002C, COMMA
  0xFF,
  0xFF,
  0x0F,
  0x7B,
  0xB2
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_002D[  6] = { // Code 002D, HYPHEN-MINUS
  0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_002E[  2] = { // Code 002E, FULL STOP
  0xFF,
  0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_002F[ 36] = { // Code 002F, SOLIDUS
  0x00, 0x2F, 0xD0,
  0x00, 0x6F, 0x90,
  0x00, 0xAF, 0x60,
  0x00, 0xEF, 0x20,
  0x02, 0xFD, 0x00,
  0x06, 0xF9, 0x00,
  0x0A, 0xF6, 0x00,
  0x0E, 0xF2, 0x00,
  0x2F, 0xD0, 0x00,
  0x6F, 0x90, 0x00,
  0xAF, 0x60, 0x00,
  0xEF, 0x20, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_0030[ 48] = { // Code 0030, DIGIT ZERO
  0x02, 0xBF, 0xFB, 0x20,
  0x1E, 0xFF, 0xFF, 0xE1,
  0x8F, 0xB1, 0x1B, 0xF7,
  0xCF, 0x30, 0x03, 0xFC,
  0xEF, 0x10, 0x01, 0xFE,
  0xFF, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0xFF,
  0xEF, 0x10, 0x01, 0xFE,
  0xCF, 0x30, 0x03, 0xFC,
  0x7F, 0xB1, 0x1B, 0xF8,
  0x1E, 0xFF, 0xFF, 0xE1,
  0x02, 0xAF, 0xFB, 0x20
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_0031[ 36] = { // Code 0031, DIGIT ONE
  0x00, 0x1E, 0xF0,
  0x00, 0xAF, 0xF0,
  0x3C, 0xFF, 0xF0,
  0xFF, 0x6F, 0xF0,
  0xC4, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_0032[ 48] = { // Code 0032, DIGIT TWO
  0x04, 0xBF, 0xFC, 0x50,
  0x4F, 0xFF, 0xFF, 0xF6,
  0xBF, 0x91, 0x07, 0xFD,
  0xCE, 0x10, 0x00, 0xFF,
  0x00, 0x00, 0x04, 0xFD,
  0x00, 0x00, 0x1D, 0xF7,
  0x00, 0x02, 0xDF, 0xA0,
  0x00, 0x3E, 0xFA, 0x00,
  0x03, 0xEF, 0x70, 0x00,
  0x1E, 0xF7, 0x00, 0x00,
  0x8F, 0xFF, 0xFF, 0xFF,
  0xEF, 0xFF, 0xFF, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_0033[ 48] = { // Code 0033, DIGIT THREE
  0x05, 0xCF, 0xFD, 0x80,
  0x7F, 0xFF, 0xFF, 0xF8,
  0xCF, 0x91, 0x04, 0xFF,
  0x02, 0x00, 0x16, 0xFD,
  0x00, 0x0B, 0xFF, 0xE3,
  0x00, 0x0E, 0xFF, 0xE3,
  0x00, 0x01, 0x09, 0xFB,
  0x00, 0x00, 0x01, 0xFF,
  0xBE, 0x20, 0x01, 0xFF,
  0xBF, 0xA1, 0x1A, 0xFB,
  0x3E, 0xFF, 0xFF, 0xE3,
  0x03, 0xBF, 0xFB, 0x30
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_0034[ 48] = { // Code 0034, DIGIT FOUR
  0x00, 0x00, 0x2E, 0xF0,
  0x00, 0x00, 0xBF, 0xF0,
  0x00, 0x06, 0xFF, 0xF0,
  0x00, 0x2E, 0xEF, 0xF0,
  0x00, 0xBF, 0x5F, 0xF0,
  0x05, 0xFA, 0x0F, 0xF0,
  0x1E, 0xE1, 0x0F, 0xF0,
  0xAF, 0x60, 0x0F, 0xF0,
  0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF,
  0x00, 0x00, 0x0F, 0xF0,
  0x00, 0x00, 0x0F, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_0035[ 48] = { // Code 0035, DIGIT FIVE
  0x1F, 0xFF, 0xFF, 0xF0,
  0x3F, 0xFF, 0xFF, 0xF0,
  0x6F, 0xA0, 0x00, 0x00,
  0x8F, 0x70, 0x00, 0x00,
  0xAF, 0xEF, 0xFB, 0x30,
  0xCF, 0xFF, 0xFF, 0xF4,
  0xBE, 0x60, 0x19, 0xFB,
  0x00, 0x00, 0x01, 0xFF,
  0xBE, 0x20, 0x01, 0xFE,
  0xBF, 0xB1, 0x19, 0xFA,
  0x3F, 0xFF, 0xFF, 0xE2,
  0x03, 0xBF, 0xFB, 0x30
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_0036[ 48] = { // Code 0036, DIGIT SIX
  0x01, 0x8D, 0xFD, 0x70,
  0x0B, 0xFF, 0xFF, 0xF7,
  0x6F, 0xB2, 0x05, 0xEC,
  0xBF, 0x20, 0x00, 0x00,
  0xEE, 0x7D, 0xFB, 0x30,
  0xFF, 0xFF, 0xFF, 0xF4,
  0xFF, 0x91, 0x19, 0xFB,
  0xEF, 0x10, 0x01, 0xFF,
  0xCF, 0x10, 0x00, 0xFF,
  0x7F, 0xA2, 0x08, 0xFB,
  0x1D, 0xFF, 0xFF, 0xF4,
  0x01, 0x9E, 0xFB, 0x40
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_0037[ 48] = { // Code 0037, DIGIT SEVEN
  0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF,
  0x00, 0x00, 0x1D, 0xF5,
  0x00, 0x00, 0x9F, 0x70,
  0x00, 0x02, 0xFD, 0x00,
  0x00, 0x08, 0xF7, 0x00,
  0x00, 0x0E, 0xF2, 0x00,
  0x00, 0x4F, 0xB0, 0x00,
  0x00, 0x8F, 0x70, 0x00,
  0x00, 0xBF, 0x40, 0x00,
  0x00, 0xDF, 0x10, 0x00,
  0x00, 0xFF, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_0038[ 48] = { // Code 0038, DIGIT EIGHT
  0x06, 0xCF, 0xFC, 0x60,
  0x7F, 0xFF, 0xFF, 0xF7,
  0xEF, 0x71, 0x17, 0xFE,
  0xFF, 0x00, 0x00, 0xFF,
  0xBF, 0x71, 0x17, 0xFB,
  0x2C, 0xFF, 0xFF, 0xC1,
  0x3D, 0xFF, 0xFF, 0xD3,
  0xBF, 0x71, 0x18, 0xFC,
  0xFF, 0x00, 0x00, 0xFF,
  0xEF, 0x71, 0x17, 0xFD,
  0x6F, 0xFF, 0xFF, 0xF6,
  0x05, 0xCF, 0xFC, 0x50
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_0039[ 48] = { // Code 0039, DIGIT NINE
  0x04, 0xBF, 0xE9, 0x10,
  0x4F, 0xFF, 0xFF, 0xD1,
  0xBF, 0x80, 0x2A, 0xF7,
  0xFF, 0x10, 0x01, 0xFC,
  0xFF, 0x10, 0x01, 0xFE,
  0xBF, 0x91, 0x19, 0xFF,
  0x4F, 0xFF, 0xFF, 0xFF,
  0x03, 0xBF, 0xC6, 0xEE,
  0x00, 0x00, 0x02, 0xFB,
  0xCE, 0x50, 0x2B, 0xF6,
  0x8F, 0xFF, 0xFF, 0xB0,
  0x08, 0xEF, 0xD8, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_003A[  9] = { // Code 003A, COLON
  0xFF,
  0xFF,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0xFF,
  0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_003B[ 12] = { // Code 003B, SEMICOLON
  0xFF,
  0xFF,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0xFF,
  0xFF,
  0x1F,
  0x7B,
  0xB2
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_003C[ 36] = { // Code 003C, LESS-THAN SIGN
  0x00, 0x00, 0x00, 0x4B,
  0x00, 0x00, 0x4B, 0xFF,
  0x00, 0x4B, 0xFF, 0xA3,
  0x4B, 0xFE, 0x82, 0x00,
  0xFF, 0xD2, 0x00, 0x00,
  0x4B, 0xFF, 0x92, 0x00,
  0x00, 0x4B, 0xFF, 0xA3,
  0x00, 0x00, 0x4B, 0xFF,
  0x00, 0x00, 0x00, 0x4B
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_003D[ 30] = { // Code 003D, EQUALS SIGN
  0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xFF, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_003E[ 36] = { // Code 003E, GREATER-THAN SIGN
  0xB4, 0x00, 0x00, 0x00,
  0xFF, 0xB4, 0x00, 0x00,
  0x3A, 0xFF, 0xB4, 0x00,
  0x00, 0x29, 0xFF, 0xB4,
  0x00, 0x00, 0x2D, 0xFF,
  0x00, 0x29, 0xFF, 0xA3,
  0x3A, 0xFF, 0xB3, 0x00,
  0xFF, 0xB4, 0x00, 0x00,
  0xB4, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_003F[ 48] = { // Code 003F, QUESTION MARK
  0x03, 0xBF, 0xFB, 0x40,
  0x2E, 0xFF, 0xFF, 0xF4,
  0xAF, 0xB2, 0x07, 0xFC,
  0xEF, 0x20, 0x00, 0xFF,
  0x00, 0x00, 0x09, 0xFC,
  0x00, 0x01, 0xBF, 0xE3,
  0x00, 0x09, 0xFE, 0x30,
  0x00, 0x0E, 0xF4, 0x00,
  0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x0F, 0xF0, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_0040[128] = { // Code 0040, COMMERCIAL AT
  0x00, 0x00, 0x39, 0xDF, 0xFE, 0xA5, 0x00, 0x00,
  0x00, 0x1B, 0xFF, 0xFF, 0xFF, 0xFF, 0xB1, 0x00,
  0x01, 0xDF, 0xE7, 0x30, 0x02, 0x7E, 0xFC, 0x00,
  0x09, 0xFD, 0x3A, 0xFC, 0x5F, 0xF4, 0xEF, 0x60,
  0x3F, 0xF2, 0xBF, 0xFF, 0xEF, 0xE0, 0x6F, 0xB0,
  0x8F, 0x95, 0xFC, 0x15, 0xFF, 0xC0, 0x1F, 0xF0,
  0xCF, 0x4B, 0xF5, 0x00, 0xFF, 0x90, 0x0F, 0xF0,
  0xFF, 0x1E, 0xF1, 0x01, 0xFF, 0x60, 0x3F, 0xC0,
  0xFF, 0x0F, 0xF0, 0x05, 0xFF, 0x30, 0xBF, 0x70,
  0xEF, 0x1E, 0xF5, 0x2D, 0xFF, 0x19, 0xFD, 0x10,
  0xBF, 0x59, 0xFF, 0xFF, 0xFF, 0xFF, 0xD2, 0x00,
  0x6F, 0xC1, 0xAF, 0xB5, 0xEF, 0xC7, 0x10, 0x00,
  0x0D, 0xFA, 0x00, 0x00, 0x00, 0x00, 0x4F, 0xFB,
  0x03, 0xEF, 0xD6, 0x30, 0x01, 0x4A, 0xFF, 0xE2,
  0x00, 0x3D, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x20,
  0x00, 0x00, 0x49, 0xCF, 0xFF, 0xDA, 0x40, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_0041[ 72] = { // Code 0041, LATIN CAPITAL LETTER A
  0x00, 0x01, 0xFF, 0xE0, 0x00, 0x00,
  0x00, 0x05, 0xFF, 0xF5, 0x00, 0x00,
  0x00, 0x0B, 0xF9, 0xFA, 0x00, 0x00,
  0x00, 0x1F, 0xE1, 0xEF, 0x10, 0x00,
  0x00, 0x6F, 0xA0, 0x9F, 0x60, 0x00,
  0x00, 0xBF, 0x40, 0x4F, 0xB0, 0x00,
  0x02, 0xFE, 0x00, 0x0D, 0xF1, 0x00,
  0x07, 0xFF, 0xFF, 0xFF, 0xF7, 0x00,
  0x0C, 0xFF, 0xFF, 0xFF, 0xFB, 0x00,
  0x2F, 0xE0, 0x00, 0x00, 0xEF, 0x20,
  0x7F, 0x90, 0x00, 0x00, 0x8F, 0x70,
  0xCF, 0x40, 0x00, 0x00, 0x3F, 0xC0
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_0042[ 60] = { // Code 0042, LATIN CAPITAL LETTER B
  0xFF, 0xFF, 0xFF, 0xD8, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0x80,
  0xFF, 0x00, 0x00, 0x6F, 0xE0,
  0xFF, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x7F, 0xC0,
  0xFF, 0xFF, 0xFF, 0xFF, 0x60,
  0xFF, 0xFF, 0xFF, 0xFF, 0xE3,
  0xFF, 0x00, 0x00, 0x28, 0xFC,
  0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x17, 0xFD,
  0xFF, 0xFF, 0xFF, 0xFF, 0xF6,
  0xFF, 0xFF, 0xFF, 0xFC, 0x60
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_0043[ 60] = { // Code 0043, LATIN CAPITAL LETTER C
  0x00, 0x5B, 0xEF, 0xEA, 0x20,
  0x08, 0xFF, 0xFF, 0xFF, 0xE3,
  0x4F, 0xF8, 0x10, 0x4D, 0xFC,
  0xAF, 0xA0, 0x00, 0x03, 0xB4,
  0xDF, 0x40, 0x00, 0x00, 0x00,
  0xFF, 0x10, 0x00, 0x00, 0x00,
  0xFF, 0x10, 0x00, 0x00, 0x00,
  0xEF, 0x40, 0x00, 0x00, 0x00,
  0xAF, 0xA0, 0x00, 0x03, 0xB4,
  0x4F, 0xF7, 0x10, 0x4D, 0xFC,
  0x08, 0xFF, 0xFF, 0xFF, 0xE3,
  0x00, 0x5B, 0xFF, 0xDA, 0x20
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_0044[ 60] = { // Code 0044, LATIN CAPITAL LETTER D
  0xFF, 0xFF, 0xFF, 0xC6, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0x90,
  0xFF, 0x00, 0x02, 0x7F, 0xF4,
  0xFF, 0x00, 0x00, 0x08, 0xFA,
  0xFF, 0x00, 0x00, 0x02, 0xFD,
  0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x02, 0xFE,
  0xFF, 0x00, 0x00, 0x06, 0xFA,
  0xFF, 0x00, 0x01, 0x5E, 0xF4,
  0xFF, 0xFF, 0xFF, 0xFF, 0x90,
  0xFF, 0xFF, 0xFF, 0xC6, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_0045[ 60] = { // Code 0045, LATIN CAPITAL LETTER E
  0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xFF, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_0046[ 48] = { // Code 0046, LATIN CAPITAL LETTER F
  0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_0047[ 72] = { // Code 0047, LATIN CAPITAL LETTER G
  0x00, 0x39, 0xDF, 0xFD, 0x92, 0x00,
  0x08, 0xFF, 0xFF, 0xFF, 0xFE, 0x30,
  0x5F, 0xF8, 0x20, 0x05, 0xEF, 0xC0,
  0xBF, 0x80, 0x00, 0x00, 0x3B, 0x40,
  0xEF, 0x20, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0xFF, 0xFF, 0xF0,
  0xDF, 0x30, 0x00, 0xFF, 0xFF, 0xF0,
  0xAF, 0x80, 0x00, 0x00, 0x0F, 0xF0,
  0x4F, 0xF7, 0x20, 0x03, 0x9F, 0xF0,
  0x08, 0xFF, 0xFF, 0xFF, 0xFF, 0x90,
  0x00, 0x39, 0xDF, 0xFC, 0x83, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_0048[ 60] = { // Code 0048, LATIN CAPITAL LETTER H
  0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_0049[ 12] = { // Code 0049, LATIN CAPITAL LETTER I
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_004A[ 48] = { // Code 004A, LATIN CAPITAL LETTER J
  0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x10, 0x01, 0xFF,
  0xCF, 0x91, 0x29, 0xFC,
  0x5F, 0xFF, 0xFF, 0xF5,
  0x05, 0xCF, 0xFB, 0x40
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_004B[ 72] = { // Code 004B, LATIN CAPITAL LETTER K
  0xFF, 0x00, 0x00, 0x07, 0xFD, 0x10,
  0xFF, 0x00, 0x00, 0x7F, 0xD1, 0x00,
  0xFF, 0x00, 0x07, 0xFD, 0x10, 0x00,
  0xFF, 0x00, 0x7F, 0xD1, 0x00, 0x00,
  0xFF, 0x07, 0xFF, 0x70, 0x00, 0x00,
  0xFF, 0x7F, 0xCF, 0xE1, 0x00, 0x00,
  0xFF, 0xFB, 0x1A, 0xF7, 0x00, 0x00,
  0xFF, 0xB1, 0x02, 0xFE, 0x10, 0x00,
  0xFF, 0x10, 0x00, 0x9F, 0x90, 0x00,
  0xFF, 0x00, 0x00, 0x1E, 0xF2, 0x00,
  0xFF, 0x00, 0x00, 0x07, 0xFA, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0xEF, 0x30
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_004C[ 48] = { // Code 004C, LATIN CAPITAL LETTER L
  0xFF, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_004D[ 72] = { // Code 004D, LATIN CAPITAL LETTER M
  0xFF, 0xF2, 0x00, 0x02, 0xFF, 0xF0,
  0xFF, 0xF7, 0x00, 0x07, 0xFF, 0xF0,
  0xFF, 0xFB, 0x00, 0x0B, 0xFF, 0xF0,
  0xFF, 0xBF, 0x10, 0x1F, 0xBF, 0xF0,
  0xFF, 0x6F, 0x60, 0x6F, 0x6F, 0xF0,
  0xFF, 0x2F, 0xA0, 0xAF, 0x2F, 0xF0,
  0xFF, 0x0D, 0xE1, 0xED, 0x0F, 0xF0,
  0xFF, 0x08, 0xF8, 0xF8, 0x0F, 0xF0,
  0xFF, 0x04, 0xFF, 0xF4, 0x0F, 0xF0,
  0xFF, 0x00, 0xEF, 0xE0, 0x0F, 0xF0,
  0xFF, 0x00, 0xAF, 0xA0, 0x0F, 0xF0,
  0xFF, 0x00, 0x5F, 0x50, 0x0F, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_004E[ 60] = { // Code 004E, LATIN CAPITAL LETTER N
  0xFF, 0x70, 0x00, 0x00, 0xFF,
  0xFF, 0xE2, 0x00, 0x00, 0xFF,
  0xFF, 0xFB, 0x00, 0x00, 0xFF,
  0xFF, 0xAF, 0x50, 0x00, 0xFF,
  0xFF, 0x1E, 0xE1, 0x00, 0xFF,
  0xFF, 0x05, 0xF9, 0x00, 0xFF,
  0xFF, 0x00, 0xAF, 0x40, 0xFF,
  0xFF, 0x00, 0x2E, 0xD1, 0xFF,
  0xFF, 0x00, 0x06, 0xF8, 0xFF,
  0xFF, 0x00, 0x00, 0xBF, 0xFF,
  0xFF, 0x00, 0x00, 0x2E, 0xFF,
  0xFF, 0x00, 0x00, 0x06, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_004F[ 72] = { // Code 004F, LATIN CAPITAL LETTER O
  0x00, 0x5B, 0xEF, 0xEB, 0x40, 0x00,
  0x08, 0xFF, 0xFF, 0xFF, 0xF8, 0x00,
  0x3F, 0xF7, 0x10, 0x17, 0xFF, 0x30,
  0xAF, 0x80, 0x00, 0x00, 0x7F, 0xA0,
  0xDF, 0x30, 0x00, 0x00, 0x1F, 0xD0,
  0xFF, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xEF, 0x30, 0x00, 0x00, 0x1F, 0xD0,
  0xAF, 0x70, 0x00, 0x00, 0x7F, 0xA0,
  0x4F, 0xF7, 0x10, 0x17, 0xFF, 0x40,
  0x08, 0xFF, 0xFF, 0xFF, 0xF8, 0x00,
  0x00, 0x4B, 0xEF, 0xEB, 0x40, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_0050[ 60] = { // Code 0050, LATIN CAPITAL LETTER P
  0xFF, 0xFF, 0xFF, 0xC7, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0x70,
  0xFF, 0x00, 0x02, 0x8F, 0xE0,
  0xFF, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x02, 0x9F, 0xD0,
  0xFF, 0xFF, 0xFF, 0xFF, 0x50,
  0xFF, 0xFF, 0xFE, 0xB4, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_0051[ 78] = { // Code 0051, LATIN CAPITAL LETTER Q
  0x00, 0x5B, 0xEF, 0xEB, 0x40, 0x00,
  0x08, 0xFF, 0xFF, 0xFF, 0xF8, 0x00,
  0x4F, 0xF7, 0x10, 0x16, 0xEF, 0x40,
  0xAF, 0x80, 0x00, 0x00, 0x7F, 0xA0,
  0xDF, 0x30, 0x00, 0x00, 0x2F, 0xD0,
  0xFF, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xDF, 0x20, 0x00, 0x00, 0x4F, 0xE0,
  0xAF, 0x70, 0x0A, 0x92, 0xCF, 0xC0,
  0x4F, 0xF7, 0x14, 0xEF, 0xFF, 0x60,
  0x08, 0xFF, 0xFF, 0xFF, 0xFA, 0x00,
  0x00, 0x5B, 0xEF, 0xD6, 0xBD, 0x40,
  0x00, 0x00, 0x00, 0x00, 0x1A, 0x90
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_0052[ 72] = { // Code 0052, LATIN CAPITAL LETTER R
  0xFF, 0xFF, 0xFF, 0xFC, 0x70, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xF7, 0x00,
  0xFF, 0x00, 0x00, 0x19, 0xFE, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0xFF, 0x00,
  0xFF, 0x00, 0x00, 0x29, 0xFC, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xF4, 0x00,
  0xFF, 0xFF, 0xFF, 0xF8, 0x20, 0x00,
  0xFF, 0x01, 0x6E, 0xFB, 0x10, 0x00,
  0xFF, 0x00, 0x04, 0xFF, 0xA0, 0x00,
  0xFF, 0x00, 0x00, 0x7F, 0xF5, 0x00,
  0xFF, 0x00, 0x00, 0x0C, 0xFE, 0x10,
  0xFF, 0x00, 0x00, 0x02, 0xFF, 0xA0
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_0053[ 60] = { // Code 0053, LATIN CAPITAL LETTER S
  0x04, 0xBE, 0xFE, 0xA3, 0x00,
  0x6F, 0xFF, 0xFF, 0xFE, 0x30,
  0xDF, 0x92, 0x02, 0xBF, 0xB0,
  0xFF, 0x30, 0x00, 0x2F, 0xE0,
  0xBF, 0xFA, 0x50, 0x00, 0x00,
  0x1C, 0xFF, 0xFE, 0x92, 0x00,
  0x00, 0x5B, 0xFF, 0xFF, 0x40,
  0x00, 0x00, 0x15, 0xBF, 0xC0,
  0xEF, 0x20, 0x00, 0x1F, 0xF0,
  0xAF, 0xB3, 0x01, 0x9F, 0xD0,
  0x2E, 0xFF, 0xFF, 0xFF, 0x50,
  0x02, 0xAE, 0xFE, 0xB4, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_0054[ 60] = { // Code 0054, LATIN CAPITAL LETTER T
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0x00, 0x00, 0xFF, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_0055[ 60] = { // Code 0055, LATIN CAPITAL LETTER U
  0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xDF, 0x30, 0x00, 0x02, 0xFD,
  0xAF, 0xD3, 0x00, 0x3B, 0xFB,
  0x2E, 0xFF, 0xFF, 0xFF, 0xE3,
  0x02, 0x9D, 0xFF, 0xEA, 0x30
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_0056[ 72] = { // Code 0056, LATIN CAPITAL LETTER V
  0xCF, 0x40, 0x00, 0x00, 0x4F, 0xC0,
  0x7F, 0xA0, 0x00, 0x00, 0xAF, 0x60,
  0x1F, 0xF1, 0x00, 0x01, 0xFF, 0x10,
  0x0A, 0xF6, 0x00, 0x06, 0xFA, 0x00,
  0x04, 0xFC, 0x00, 0x0C, 0xF4, 0x00,
  0x00, 0xEF, 0x30, 0x3F, 0xD0, 0x00,
  0x00, 0x8F, 0x80, 0x8F, 0x80, 0x00,
  0x00, 0x2F, 0xE0, 0xEF, 0x20, 0x00,
  0x00, 0x0C, 0xF9, 0xFB, 0x00, 0x00,
  0x00, 0x06, 0xFF, 0xF6, 0x00, 0x00,
  0x00, 0x01, 0xFF, 0xE1, 0x00, 0x00,
  0x00, 0x00, 0xAF, 0x90, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_0057[108] = { // Code 0057, LATIN CAPITAL LETTER W
  0xDF, 0x30, 0x00, 0x0D, 0xFD, 0x00, 0x00, 0x3F, 0xD0,
  0x8F, 0x70, 0x00, 0x3F, 0xFF, 0x30, 0x00, 0x7F, 0x80,
  0x4F, 0xC0, 0x00, 0x8F, 0xFF, 0x80, 0x00, 0xCF, 0x40,
  0x0E, 0xF2, 0x00, 0xDF, 0xBF, 0xD0, 0x01, 0xFE, 0x00,
  0x0A, 0xF6, 0x03, 0xFF, 0x1F, 0xF3, 0x06, 0xFA, 0x00,
  0x06, 0xFA, 0x08, 0xFA, 0x0A, 0xF8, 0x0A, 0xF6, 0x00,
  0x01, 0xFE, 0x0D, 0xF5, 0x05, 0xFD, 0x0E, 0xF2, 0x00,
  0x00, 0xCF, 0x7F, 0xE0, 0x00, 0xEF, 0x7F, 0xC0, 0x00,
  0x00, 0x7F, 0xFF, 0xA0, 0x00, 0xAF, 0xEF, 0x80, 0x00,
  0x00, 0x3F, 0xFF, 0x50, 0x00, 0x5F, 0xFF, 0x30, 0x00,
  0x00, 0x0D, 0xFE, 0x00, 0x00, 0x0E, 0xFE, 0x00, 0x00,
  0x00, 0x09, 0xFA, 0x00, 0x00, 0x0A, 0xFA, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_0058[ 72] = { // Code 0058, LATIN CAPITAL LETTER X
  0x3F, 0xE2, 0x00, 0x02, 0xEF, 0x30,
  0x08, 0xFB, 0x00, 0x0A, 0xF8, 0x00,
  0x00, 0xDF, 0x60, 0x5F, 0xD0, 0x00,
  0x00, 0x3F, 0xE2, 0xEF, 0x30, 0x00,
  0x00, 0x09, 0xFE, 0xF9, 0x00, 0x00,
  0x00, 0x01, 0xDF, 0xD1, 0x00, 0x00,
  0x00, 0x01, 0xDF, 0xD1, 0x00, 0x00,
  0x00, 0x09, 0xFF, 0xF9, 0x00, 0x00,
  0x00, 0x3F, 0xE2, 0xEF, 0x40, 0x00,
  0x00, 0xDF, 0x50, 0x5F, 0xD0, 0x00,
  0x08, 0xFB, 0x00, 0x0B, 0xF8, 0x00,
  0x3F, 0xE2, 0x00, 0x02, 0xEF, 0x30
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_0059[ 72] = { // Code 0059, LATIN CAPITAL LETTER Y
  0x3F, 0xE1, 0x00, 0x00, 0x1E, 0xF3,
  0x08, 0xFA, 0x00, 0x00, 0xAF, 0x80,
  0x00, 0xDF, 0x40, 0x04, 0xFD, 0x00,
  0x00, 0x3F, 0xD0, 0x0D, 0xF4, 0x00,
  0x00, 0x09, 0xF7, 0x7F, 0x90, 0x00,
  0x00, 0x01, 0xDF, 0xFD, 0x10, 0x00,
  0x00, 0x00, 0x4F, 0xF4, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_005A[ 60] = { // Code 005A, LATIN CAPITAL LETTER Z
  0x0F, 0xFF, 0xFF, 0xFF, 0xF0,
  0x0F, 0xFF, 0xFF, 0xFF, 0xA0,
  0x00, 0x00, 0x03, 0xFE, 0x10,
  0x00, 0x00, 0x0C, 0xF5, 0x00,
  0x00, 0x00, 0x8F, 0xB0, 0x00,
  0x00, 0x03, 0xFE, 0x20, 0x00,
  0x00, 0x1D, 0xF6, 0x00, 0x00,
  0x00, 0x9F, 0xB0, 0x00, 0x00,
  0x04, 0xFE, 0x20, 0x00, 0x00,
  0x1D, 0xF6, 0x00, 0x00, 0x00,
  0xAF, 0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xFF, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_005B[ 30] = { // Code 005B, LEFT SQUARE BRACKET
  0xFF, 0xFF,
  0xFF, 0xFF,
  0xFF, 0x00,
  0xFF, 0x00,
  0xFF, 0x00,
  0xFF, 0x00,
  0xFF, 0x00,
  0xFF, 0x00,
  0xFF, 0x00,
  0xFF, 0x00,
  0xFF, 0x00,
  0xFF, 0x00,
  0xFF, 0x00,
  0xFF, 0xFF,
  0xFF, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_005C[ 36] = { // Code 005C, REVERSE SOLIDUS
  0xEF, 0x20, 0x00,
  0xAF, 0x60, 0x00,
  0x6F, 0x90, 0x00,
  0x2F, 0xD0, 0x00,
  0x0E, 0xF2, 0x00,
  0x0A, 0xF6, 0x00,
  0x06, 0xF9, 0x00,
  0x02, 0xFD, 0x00,
  0x00, 0xEF, 0x20,
  0x00, 0xAF, 0x60,
  0x00, 0x6F, 0x90,
  0x00, 0x2F, 0xD0
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_005D[ 30] = { // Code 005D, RIGHT SQUARE BRACKET
  0xFF, 0xFF,
  0xFF, 0xFF,
  0x00, 0xFF,
  0x00, 0xFF,
  0x00, 0xFF,
  0x00, 0xFF,
  0x00, 0xFF,
  0x00, 0xFF,
  0x00, 0xFF,
  0x00, 0xFF,
  0x00, 0xFF,
  0x00, 0xFF,
  0x00, 0xFF,
  0xFF, 0xFF,
  0xFF, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_005E[ 28] = { // Code 005E, CIRCUMFLEX ACCENT
  0x00, 0x3F, 0xF4, 0x00,
  0x00, 0xAF, 0xFB, 0x00,
  0x01, 0xFC, 0xCF, 0x20,
  0x08, 0xF6, 0x6F, 0x80,
  0x0E, 0xE1, 0x1E, 0xE0,
  0x5F, 0x90, 0x09, 0xF6,
  0xCF, 0x30, 0x03, 0xFC
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_005F[ 10] = { // Code 005F, LOW LINE
  0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xFF, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_0060[  4] = { // Code 0060, GRAVE ACCENT
  0x5E, 0xF4,
  0x01, 0xAB
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_0061[ 36] = { // Code 0061, LATIN SMALL LETTER A
  0x18, 0xEF, 0xEB, 0x20,
  0x9F, 0xFF, 0xFF, 0xC0,
  0xEF, 0x50, 0x3F, 0xF0,
  0x01, 0x58, 0xCF, 0xF0,
  0x4E, 0xFF, 0xFF, 0xF0,
  0xDF, 0xA6, 0x2F, 0xF0,
  0xFF, 0x30, 0x6F, 0xF0,
  0xBF, 0xFF, 0xFE, 0xF2,
  0x1B, 0xFE, 0x93, 0xF9
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_0062[ 48] = { // Code 0062, LATIN SMALL LETTER B
  0xFF, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00,
  0xFF, 0x4C, 0xFC, 0x40,
  0xFF, 0xFF, 0xFF, 0xF4,
  0xFF, 0xA1, 0x1A, 0xFB,
  0xFF, 0x20, 0x02, 0xFE,
  0xFF, 0x00, 0x00, 0xFF,
  0xFF, 0x20, 0x02, 0xFE,
  0xFF, 0xB1, 0x1A, 0xFA,
  0xFF, 0xFF, 0xFF, 0xF3,
  0xFF, 0x4C, 0xFD, 0x40
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_0063[ 36] = { // Code 0063, LATIN SMALL LETTER C
  0x04, 0xCF, 0xE8, 0x00,
  0x3F, 0xFF, 0xFF, 0x70,
  0xBF, 0x91, 0x4F, 0xD0,
  0xEF, 0x10, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00,
  0xEF, 0x10, 0x00, 0x00,
  0xBF, 0x90, 0x4F, 0xE0,
  0x3F, 0xFF, 0xFF, 0x80,
  0x04, 0xCF, 0xE8, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_0064[ 48] = { // Code 0064, LATIN SMALL LETTER D
  0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0xFF,
  0x04, 0xCF, 0xC4, 0xFF,
  0x4F, 0xFF, 0xFF, 0xFF,
  0xBF, 0xA1, 0x1A, 0xFF,
  0xEF, 0x20, 0x02, 0xFF,
  0xFF, 0x00, 0x00, 0xFF,
  0xEF, 0x20, 0x02, 0xFF,
  0xAF, 0xA1, 0x1A, 0xFF,
  0x3F, 0xFF, 0xFF, 0xFF,
  0x04, 0xDF, 0xC4, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_0065[ 36] = { // Code 0065, LATIN SMALL LETTER E
  0x04, 0xDF, 0xD5, 0x00,
  0x3F, 0xFF, 0xFF, 0x40,
  0xAF, 0x50, 0x4F, 0xB0,
  0xEF, 0xFF, 0xFF, 0xE0,
  0xFF, 0xFF, 0xFF, 0xF0,
  0xEF, 0x10, 0x00, 0x00,
  0xBF, 0x90, 0x5F, 0xD0,
  0x4F, 0xFF, 0xFF, 0x50,
  0x05, 0xCF, 0xE7, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_0066[ 36] = { // Code 0066, LATIN SMALL LETTER F
  0x04, 0xCF, 0xFB,
  0x0E, 0xFF, 0xFA,
  0x0F, 0xF1, 0x01,
  0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xF0,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_0067[ 48] = { // Code 0067, LATIN SMALL LETTER G
  0x04, 0xDF, 0xB2, 0xFF,
  0x4F, 0xFF, 0xFD, 0xFF,
  0xBF, 0xA1, 0x1B, 0xFF,
  0xEF, 0x20, 0x02, 0xFF,
  0xFF, 0x00, 0x00, 0xFF,
  0xEF, 0x20, 0x02, 0xFF,
  0xBF, 0xA1, 0x1B, 0xFF,
  0x3F, 0xFF, 0xFC, 0xFF,
  0x05, 0xDF, 0xA1, 0xFF,
  0xFF, 0x40, 0x16, 0xFD,
  0xAF, 0xFF, 0xFF, 0xF7,
  0x19, 0xDF, 0xFD, 0x80
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_0068[ 48] = { // Code 0068, LATIN SMALL LETTER H
  0xFF, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00,
  0xFF, 0x09, 0xFE, 0x91,
  0xFF, 0x8F, 0xFF, 0xFA,
  0xFF, 0xA2, 0x06, 0xFE,
  0xFF, 0x20, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_0069[ 12] = { // Code 0069, LATIN SMALL LETTER I
  0xFF,
  0xFF,
  0x00,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_006A[ 30] = { // Code 006A, LATIN SMALL LETTER J
  0x00, 0xFF,
  0x00, 0xFF,
  0x00, 0x00,
  0x00, 0xFF,
  0x00, 0xFF,
  0x00, 0xFF,
  0x00, 0xFF,
  0x00, 0xFF,
  0x00, 0xFF,
  0x00, 0xFF,
  0x00, 0xFF,
  0x00, 0xFF,
  0x02, 0xFF,
  0xAF, 0xFC,
  0xCF, 0xD3
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_006B[ 48] = { // Code 006B, LATIN SMALL LETTER K
  0xFF, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x5F, 0xE2,
  0xFF, 0x05, 0xFE, 0x30,
  0xFF, 0x5F, 0xF4, 0x00,
  0xFF, 0xFF, 0xF2, 0x00,
  0xFF, 0xFE, 0xF9, 0x00,
  0xFF, 0x83, 0xFE, 0x10,
  0xFF, 0x00, 0xAF, 0x70,
  0xFF, 0x00, 0x3F, 0xD0,
  0xFF, 0x00, 0x0B, 0xF4
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_006C[ 12] = { // Code 006C, LATIN SMALL LETTER L
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_006D[ 54] = { // Code 006D, LATIN SMALL LETTER M
  0xFF, 0x4C, 0xFC, 0x14, 0xDF, 0xB2,
  0xFF, 0xFF, 0xFF, 0xCF, 0xFF, 0xFB,
  0xFF, 0x90, 0x5F, 0xF9, 0x05, 0xFF,
  0xFF, 0x10, 0x0F, 0xF2, 0x00, 0xFF,
  0xFF, 0x00, 0x0F, 0xF0, 0x00, 0xFF,
  0xFF, 0x00, 0x0F, 0xF0, 0x00, 0xFF,
  0xFF, 0x00, 0x0F, 0xF0, 0x00, 0xFF,
  0xFF, 0x00, 0x0F, 0xF0, 0x00, 0xFF,
  0xFF, 0x00, 0x0F, 0xF0, 0x00, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_006E[ 36] = { // Code 006E, LATIN SMALL LETTER N
  0xFF, 0x3B, 0xFE, 0xA1,
  0xFF, 0xEF, 0xFF, 0xFA,
  0xFF, 0xB2, 0x07, 0xFE,
  0xFF, 0x20, 0x01, 0xFF,
  0xFF, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_006F[ 36] = { // Code 006F, LATIN SMALL LETTER O
  0x03, 0xBF, 0xFB, 0x20,
  0x2E, 0xFF, 0xFF, 0xE2,
  0x9F, 0xB1, 0x1B, 0xF9,
  0xEF, 0x20, 0x02, 0xFE,
  0xFF, 0x00, 0x00, 0xFF,
  0xEF, 0x20, 0x02, 0xFE,
  0xAF, 0xB1, 0x1B, 0xF9,
  0x2E, 0xFF, 0xFF, 0xE2,
  0x03, 0xBF, 0xFB, 0x20
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_0070[ 48] = { // Code 0070, LATIN SMALL LETTER P
  0xFF, 0x4C, 0xFD, 0x40,
  0xFF, 0xFF, 0xFF, 0xF3,
  0xFF, 0xA1, 0x1A, 0xFB,
  0xFF, 0x20, 0x02, 0xFE,
  0xFF, 0x00, 0x00, 0xFF,
  0xFF, 0x20, 0x02, 0xFE,
  0xFF, 0xB1, 0x1A, 0xFA,
  0xFF, 0xEF, 0xFF, 0xF3,
  0xFF, 0x3C, 0xFC, 0x40,
  0xFF, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_0071[ 48] = { // Code 0071, LATIN SMALL LETTER Q
  0x04, 0xCF, 0xD5, 0xFF,
  0x4F, 0xFF, 0xFF, 0xFF,
  0xBF, 0xA1, 0x1A, 0xFF,
  0xEF, 0x20, 0x02, 0xFF,
  0xFF, 0x00, 0x00, 0xFF,
  0xEF, 0x20, 0x03, 0xFF,
  0xAF, 0xA1, 0x2B, 0xFF,
  0x3F, 0xFF, 0xFF, 0xFF,
  0x04, 0xCF, 0xC4, 0xFF,
  0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_0072[ 27] = { // Code 0072, LATIN SMALL LETTER R
  0xFF, 0x5E, 0xFB,
  0xFF, 0xFF, 0xFB,
  0xFF, 0xB1, 0x12,
  0xFF, 0x30, 0x00,
  0xFF, 0x10, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_0073[ 36] = { // Code 0073, LATIN SMALL LETTER S
  0x01, 0xAE, 0xFD, 0x80,
  0x0B, 0xFF, 0xFF, 0xF8,
  0x0F, 0xF2, 0x05, 0xFE,
  0x0D, 0xFD, 0x95, 0x10,
  0x02, 0xCF, 0xFF, 0xE5,
  0x00, 0x02, 0x6A, 0xFE,
  0x0F, 0xF5, 0x03, 0xFF,
  0x0B, 0xFF, 0xFF, 0xFA,
  0x01, 0x8D, 0xFE, 0x91
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_0074[ 36] = { // Code 0074, LATIN SMALL LETTER T
  0x04, 0xB0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xF0,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF0, 0x00,
  0x0F, 0xF1, 0x10,
  0x0D, 0xFF, 0xA0,
  0x05, 0xEF, 0xB0
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_0075[ 36] = { // Code 0075, LATIN SMALL LETTER U
  0xFF, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0xFF,
  0xFF, 0x10, 0x02, 0xFF,
  0xEF, 0x70, 0x2A, 0xFF,
  0xAF, 0xFF, 0xFE, 0xFF,
  0x1A, 0xFF, 0xB3, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_0076[ 45] = { // Code 0076, LATIN SMALL LETTER V
  0x5F, 0xA0, 0x00, 0xAF, 0x50,
  0x0E, 0xF1, 0x01, 0xFE, 0x00,
  0x0A, 0xF5, 0x05, 0xFA, 0x00,
  0x04, 0xFA, 0x0A, 0xF5, 0x00,
  0x00, 0xEF, 0x1F, 0xE0, 0x00,
  0x00, 0x9F, 0xAF, 0xA0, 0x00,
  0x00, 0x4F, 0xFF, 0x40, 0x00,
  0x00, 0x0D, 0xFE, 0x00, 0x00,
  0x00, 0x08, 0xF9, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_0077[ 63] = { // Code 0077, LATIN SMALL LETTER W
  0xDF, 0x20, 0x0C, 0xFD, 0x00, 0x2F, 0xD0,
  0x9F, 0x60, 0x2F, 0xFF, 0x20, 0x6F, 0x90,
  0x5F, 0xA0, 0x7F, 0xFF, 0x70, 0xAF, 0x50,
  0x1F, 0xE0, 0xBF, 0xCF, 0xB0, 0xEF, 0x10,
  0x0C, 0xF3, 0xFF, 0x3F, 0xF3, 0xFC, 0x00,
  0x08, 0xFC, 0xFB, 0x0B, 0xFC, 0xF8, 0x00,
  0x04, 0xFF, 0xF7, 0x07, 0xFF, 0xF4, 0x00,
  0x01, 0xFF, 0xF2, 0x02, 0xFF, 0xF1, 0x00,
  0x00, 0xCF, 0xC0, 0x00, 0xBF, 0xC0, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_0078[ 45] = { // Code 0078, LATIN SMALL LETTER X
  0x3F, 0xE1, 0x01, 0xDF, 0x30,
  0x08, 0xF8, 0x09, 0xF7, 0x00,
  0x01, 0xDF, 0x6F, 0xC0, 0x00,
  0x00, 0x4F, 0xFF, 0x30, 0x00,
  0x00, 0x0D, 0xFC, 0x00, 0x00,
  0x00, 0x6F, 0xFF, 0x60, 0x00,
  0x01, 0xEF, 0x9F, 0xE1, 0x00,
  0x09, 0xF9, 0x0A, 0xF9, 0x00,
  0x3F, 0xE1, 0x01, 0xEF, 0x30
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_0079[ 72] = { // Code 0079, LATIN SMALL LETTER Y
  0x1F, 0xE0, 0x00, 0x00, 0xEF, 0x10,
  0x0A, 0xF6, 0x00, 0x06, 0xFA, 0x00,
  0x04, 0xFC, 0x00, 0x0C, 0xF3, 0x00,
  0x00, 0xDF, 0x40, 0x4F, 0xC0, 0x00,
  0x00, 0x7F, 0xA0, 0xAF, 0x60, 0x00,
  0x00, 0x2F, 0xF4, 0xFE, 0x10, 0x00,
  0x00, 0x0B, 0xFE, 0xF9, 0x00, 0x00,
  0x00, 0x04, 0xFF, 0xF3, 0x00, 0x00,
  0x00, 0x00, 0xEF, 0xB0, 0x00, 0x00,
  0x00, 0x02, 0xEF, 0x60, 0x00, 0x00,
  0x00, 0xFF, 0xFE, 0x00, 0x00, 0x00,
  0x00, 0xEF, 0xC3, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_007A[ 36] = { // Code 007A, LATIN SMALL LETTER Z
  0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xF0,
  0x00, 0x00, 0x8F, 0x70,
  0x00, 0x08, 0xF8, 0x00,
  0x00, 0x8F, 0x80, 0x00,
  0x08, 0xF8, 0x00, 0x00,
  0x7F, 0x80, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_007B[ 45] = { // Code 007B, LEFT CURLY BRACKET
  0x00, 0x3B, 0xFF,
  0x00, 0xCF, 0xFF,
  0x00, 0xFF, 0x30,
  0x00, 0xFF, 0x00,
  0x01, 0xFF, 0x00,
  0x18, 0xFD, 0x00,
  0xFF, 0xE4, 0x00,
  0xFF, 0xE3, 0x00,
  0x18, 0xFB, 0x00,
  0x01, 0xFE, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xEF, 0x30,
  0x00, 0xBF, 0xFF,
  0x00, 0x2B, 0xEF
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_007C[ 16] = { // Code 007C, VERTICAL LINE
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_007D[ 45] = { // Code 007D, RIGHT CURLY BRACKET
  0xFF, 0xB3, 0x00,
  0xFF, 0xFC, 0x00,
  0x03, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x10,
  0x00, 0xCF, 0x81,
  0x00, 0x4E, 0xFF,
  0x00, 0x3E, 0xFF,
  0x00, 0xBF, 0x81,
  0x00, 0xFF, 0x10,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x03, 0xFE, 0x00,
  0xFF, 0xFB, 0x00,
  0xFE, 0xB2, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font20B_AA4_007E[ 15] = { // Code 007E, TILDE
  0x6D, 0xFE, 0x94, 0x02, 0xA0,
  0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0xA2, 0x03, 0x8D, 0xFC, 0x50
};

GUI_CONST_STORAGE GUI_CHARINFO_EXT GUI_Font20B_AA4_CharInfo[95] = {
   {   1,   1,   0,  15,   5, acGUI_Font20B_AA4_0020 } // Code 0020, SPACE
  ,{   2,  12,   2,   3,   6, acGUI_Font20B_AA4_0021 } // Code 0021, EXCLAMATION MARK
  ,{   6,   4,   1,   3,   8, acGUI_Font20B_AA4_0022 } // Code 0022, QUOTATION MARK
  ,{  10,  12,   0,   3,   9, acGUI_Font20B_AA4_0023 } // Code 0023, NUMBER SIGN
  ,{   7,  15,   1,   2,   9, acGUI_Font20B_AA4_0024 } // Code 0024, DOLLAR SIGN
  ,{  15,  12,   0,   3,  16, acGUI_Font20B_AA4_0025 } // Code 0025, PERCENT SIGN
  ,{  11,  12,   1,   3,  12, acGUI_Font20B_AA4_0026 } // Code 0026, AMPERSAND
  ,{   2,   4,   1,   3,   4, acGUI_Font20B_AA4_0027 } // Code 0027, APOSTROPHE
  ,{   4,  15,   1,   3,   6, acGUI_Font20B_AA4_0028 } // Code 0028, LEFT PARENTHESIS
  ,{   4,  15,   1,   3,   6, acGUI_Font20B_AA4_0029 } // Code 0029, RIGHT PARENTHESIS
  ,{   5,   5,   1,   3,   7, acGUI_Font20B_AA4_002A } // Code 002A, ASTERISK
  ,{   8,   8,   1,   5,  10, acGUI_Font20B_AA4_002B } // Code 002B, PLUS SIGN
  ,{   2,   5,   1,  13,   5, acGUI_Font20B_AA4_002C } // Code 002C, COMMA
  ,{   5,   2,   1,  10,   6, acGUI_Font20B_AA4_002D } // Code 002D, HYPHEN-MINUS
  ,{   2,   2,   1,  13,   5, acGUI_Font20B_AA4_002E } // Code 002E, FULL STOP
  ,{   5,  12,   0,   3,   5, acGUI_Font20B_AA4_002F } // Code 002F, SOLIDUS
  ,{   8,  12,   0,   3,   9, acGUI_Font20B_AA4_0030 } // Code 0030, DIGIT ZERO
  ,{   5,  12,   1,   3,   9, acGUI_Font20B_AA4_0031 } // Code 0031, DIGIT ONE
  ,{   8,  12,   0,   3,   9, acGUI_Font20B_AA4_0032 } // Code 0032, DIGIT TWO
  ,{   8,  12,   0,   3,   9, acGUI_Font20B_AA4_0033 } // Code 0033, DIGIT THREE
  ,{   8,  12,   0,   3,   9, acGUI_Font20B_AA4_0034 } // Code 0034, DIGIT FOUR
  ,{   8,  12,   0,   3,   9, acGUI_Font20B_AA4_0035 } // Code 0035, DIGIT FIVE
  ,{   8,  12,   0,   3,   9, acGUI_Font20B_AA4_0036 } // Code 0036, DIGIT SIX
  ,{   8,  12,   0,   3,   9, acGUI_Font20B_AA4_0037 } // Code 0037, DIGIT SEVEN
  ,{   8,  12,   0,   3,   9, acGUI_Font20B_AA4_0038 } // Code 0038, DIGIT EIGHT
  ,{   8,  12,   0,   3,   9, acGUI_Font20B_AA4_0039 } // Code 0039, DIGIT NINE
  ,{   2,   9,   2,   6,   6, acGUI_Font20B_AA4_003A } // Code 003A, COLON
  ,{   2,  12,   2,   6,   6, acGUI_Font20B_AA4_003B } // Code 003B, SEMICOLON
  ,{   8,   9,   0,   5,  10, acGUI_Font20B_AA4_003C } // Code 003C, LESS-THAN SIGN
  ,{   9,   6,   0,   6,  10, acGUI_Font20B_AA4_003D } // Code 003D, EQUALS SIGN
  ,{   8,   9,   0,   5,  10, acGUI_Font20B_AA4_003E } // Code 003E, GREATER-THAN SIGN
  ,{   8,  12,   1,   3,  10, acGUI_Font20B_AA4_003F } // Code 003F, QUESTION MARK
  ,{  16,  16,   1,   3,  17, acGUI_Font20B_AA4_0040 } // Code 0040, COMMERCIAL AT
  ,{  11,  12,   0,   3,  11, acGUI_Font20B_AA4_0041 } // Code 0041, LATIN CAPITAL LETTER A
  ,{  10,  12,   1,   3,  12, acGUI_Font20B_AA4_0042 } // Code 0042, LATIN CAPITAL LETTER B
  ,{  10,  12,   1,   3,  12, acGUI_Font20B_AA4_0043 } // Code 0043, LATIN CAPITAL LETTER C
  ,{  10,  12,   1,   3,  12, acGUI_Font20B_AA4_0044 } // Code 0044, LATIN CAPITAL LETTER D
  ,{   9,  12,   1,   3,  11, acGUI_Font20B_AA4_0045 } // Code 0045, LATIN CAPITAL LETTER E
  ,{   8,  12,   1,   3,  10, acGUI_Font20B_AA4_0046 } // Code 0046, LATIN CAPITAL LETTER F
  ,{  11,  12,   1,   3,  13, acGUI_Font20B_AA4_0047 } // Code 0047, LATIN CAPITAL LETTER G
  ,{  10,  12,   1,   3,  12, acGUI_Font20B_AA4_0048 } // Code 0048, LATIN CAPITAL LETTER H
  ,{   2,  12,   1,   3,   4, acGUI_Font20B_AA4_0049 } // Code 0049, LATIN CAPITAL LETTER I
  ,{   8,  12,   0,   3,   9, acGUI_Font20B_AA4_004A } // Code 004A, LATIN CAPITAL LETTER J
  ,{  11,  12,   1,   3,  12, acGUI_Font20B_AA4_004B } // Code 004B, LATIN CAPITAL LETTER K
  ,{   8,  12,   1,   3,  10, acGUI_Font20B_AA4_004C } // Code 004C, LATIN CAPITAL LETTER L
  ,{  11,  12,   1,   3,  13, acGUI_Font20B_AA4_004D } // Code 004D, LATIN CAPITAL LETTER M
  ,{  10,  12,   1,   3,  12, acGUI_Font20B_AA4_004E } // Code 004E, LATIN CAPITAL LETTER N
  ,{  11,  12,   1,   3,  13, acGUI_Font20B_AA4_004F } // Code 004F, LATIN CAPITAL LETTER O
  ,{   9,  12,   1,   3,  11, acGUI_Font20B_AA4_0050 } // Code 0050, LATIN CAPITAL LETTER P
  ,{  11,  13,   1,   3,  13, acGUI_Font20B_AA4_0051 } // Code 0051, LATIN CAPITAL LETTER Q
  ,{  11,  12,   1,   3,  12, acGUI_Font20B_AA4_0052 } // Code 0052, LATIN CAPITAL LETTER R
  ,{   9,  12,   1,   3,  11, acGUI_Font20B_AA4_0053 } // Code 0053, LATIN CAPITAL LETTER S
  ,{  10,  12,   0,   3,  10, acGUI_Font20B_AA4_0054 } // Code 0054, LATIN CAPITAL LETTER T
  ,{  10,  12,   1,   3,  12, acGUI_Font20B_AA4_0055 } // Code 0055, LATIN CAPITAL LETTER U
  ,{  11,  12,   0,   3,  11, acGUI_Font20B_AA4_0056 } // Code 0056, LATIN CAPITAL LETTER V
  ,{  17,  12,   0,   3,  17, acGUI_Font20B_AA4_0057 } // Code 0057, LATIN CAPITAL LETTER W
  ,{  11,  12,   0,   3,  11, acGUI_Font20B_AA4_0058 } // Code 0058, LATIN CAPITAL LETTER X
  ,{  12,  12,  -1,   3,  10, acGUI_Font20B_AA4_0059 } // Code 0059, LATIN CAPITAL LETTER Y
  ,{   9,  12,   0,   3,   9, acGUI_Font20B_AA4_005A } // Code 005A, LATIN CAPITAL LETTER Z
  ,{   4,  15,   1,   3,   6, acGUI_Font20B_AA4_005B } // Code 005B, LEFT SQUARE BRACKET
  ,{   5,  12,   0,   3,   5, acGUI_Font20B_AA4_005C } // Code 005C, REVERSE SOLIDUS
  ,{   4,  15,   1,   3,   6, acGUI_Font20B_AA4_005D } // Code 005D, RIGHT SQUARE BRACKET
  ,{   8,   7,   1,   3,  10, acGUI_Font20B_AA4_005E } // Code 005E, CIRCUMFLEX ACCENT
  ,{   9,   2,   0,  16,   9, acGUI_Font20B_AA4_005F } // Code 005F, LOW LINE
  ,{   4,   2,   0,   3,   6, acGUI_Font20B_AA4_0060 } // Code 0060, GRAVE ACCENT
  ,{   8,   9,   1,   6,   9, acGUI_Font20B_AA4_0061 } // Code 0061, LATIN SMALL LETTER A
  ,{   8,  12,   1,   3,  10, acGUI_Font20B_AA4_0062 } // Code 0062, LATIN SMALL LETTER B
  ,{   7,   9,   1,   6,   9, acGUI_Font20B_AA4_0063 } // Code 0063, LATIN SMALL LETTER C
  ,{   8,  12,   1,   3,  10, acGUI_Font20B_AA4_0064 } // Code 0064, LATIN SMALL LETTER D
  ,{   7,   9,   1,   6,   9, acGUI_Font20B_AA4_0065 } // Code 0065, LATIN SMALL LETTER E
  ,{   6,  12,   0,   3,   5, acGUI_Font20B_AA4_0066 } // Code 0066, LATIN SMALL LETTER F
  ,{   8,  12,   1,   6,  10, acGUI_Font20B_AA4_0067 } // Code 0067, LATIN SMALL LETTER G
  ,{   8,  12,   1,   3,  10, acGUI_Font20B_AA4_0068 } // Code 0068, LATIN SMALL LETTER H
  ,{   2,  12,   1,   3,   4, acGUI_Font20B_AA4_0069 } // Code 0069, LATIN SMALL LETTER I
  ,{   4,  15,  -1,   3,   4, acGUI_Font20B_AA4_006A } // Code 006A, LATIN SMALL LETTER J
  ,{   8,  12,   1,   3,   9, acGUI_Font20B_AA4_006B } // Code 006B, LATIN SMALL LETTER K
  ,{   2,  12,   1,   3,   4, acGUI_Font20B_AA4_006C } // Code 006C, LATIN SMALL LETTER L
  ,{  12,   9,   1,   6,  14, acGUI_Font20B_AA4_006D } // Code 006D, LATIN SMALL LETTER M
  ,{   8,   9,   1,   6,  10, acGUI_Font20B_AA4_006E } // Code 006E, LATIN SMALL LETTER N
  ,{   8,   9,   1,   6,  10, acGUI_Font20B_AA4_006F } // Code 006F, LATIN SMALL LETTER O
  ,{   8,  12,   1,   6,  10, acGUI_Font20B_AA4_0070 } // Code 0070, LATIN SMALL LETTER P
  ,{   8,  12,   1,   6,  10, acGUI_Font20B_AA4_0071 } // Code 0071, LATIN SMALL LETTER Q
  ,{   6,   9,   1,   6,   7, acGUI_Font20B_AA4_0072 } // Code 0072, LATIN SMALL LETTER R
  ,{   8,   9,   0,   6,   9, acGUI_Font20B_AA4_0073 } // Code 0073, LATIN SMALL LETTER S
  ,{   5,  12,   0,   3,   6, acGUI_Font20B_AA4_0074 } // Code 0074, LATIN SMALL LETTER T
  ,{   8,   9,   1,   6,  10, acGUI_Font20B_AA4_0075 } // Code 0075, LATIN SMALL LETTER U
  ,{   9,   9,   0,   6,   9, acGUI_Font20B_AA4_0076 } // Code 0076, LATIN SMALL LETTER V
  ,{  13,   9,   0,   6,  13, acGUI_Font20B_AA4_0077 } // Code 0077, LATIN SMALL LETTER W
  ,{   9,   9,   0,   6,   9, acGUI_Font20B_AA4_0078 } // Code 0078, LATIN SMALL LETTER X
  ,{  11,  12,  -1,   6,   9, acGUI_Font20B_AA4_0079 } // Code 0079, LATIN SMALL LETTER Y
  ,{   7,   9,   1,   6,   9, acGUI_Font20B_AA4_007A } // Code 007A, LATIN SMALL LETTER Z
  ,{   6,  15,   1,   3,   7, acGUI_Font20B_AA4_007B } // Code 007B, LEFT CURLY BRACKET
  ,{   2,  16,   1,   3,   4, acGUI_Font20B_AA4_007C } // Code 007C, VERTICAL LINE
  ,{   6,  15,   0,   3,   7, acGUI_Font20B_AA4_007D } // Code 007D, RIGHT CURLY BRACKET
  ,{   9,   3,   0,   8,  10, acGUI_Font20B_AA4_007E } // Code 007E, TILDE
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_Font20B_AA4_Prop1 = {
   0x0020 // first character
  ,0x007E // last character 
  ,&GUI_Font20B_AA4_CharInfo[  0] // address of first character
  ,(GUI_CONST_STORAGE GUI_FONT_PROP_EXT *)0 // pointer to next GUI_FONT_PROP_EXT
};

GUI_CONST_STORAGE GUI_FONT _FontBig = {
   GUI_FONTTYPE_PROP_AA4_EXT // type of font   
  ,19 // height of font 
  ,19 // space of font y
  ,1 // magnification x
  ,1 // magnification y
  ,{&GUI_Font20B_AA4_Prop1}
  ,19 // Baseline
  ,9 // Height of lowercase characters
  ,12 // Height of capital characters
};

/*********************************************************************
*
*       _apIntro
*/
static const char * _apIntro[] = {
  "This demo shows how to use the animation functions of emWin for fading and moving effects for any kind of window..."
};

static const char * _sIntro;

/*********************************************************************
*
*       Static code
*
**********************************************************************
*/
/*********************************************************************
*
*       _cbDesktop_320x240
*/
static void _cbDesktop_320x240(WM_MESSAGE * pMsg) {
  switch (pMsg->MsgId) {
  case WM_PAINT:
    GUI_DrawBitmap(&bmDesktop_320x240, 0, 0);
    break;
  }
}

/*********************************************************************
*
*       _cbFontSelection_174x138
*/
static void _cbFontSelection_174x138(WM_MESSAGE * pMsg) {
  switch (pMsg->MsgId) {
  case WM_PAINT:
    GUI_DrawBitmap(&bmFontSelection_174x138, 0, 0);
    break;
  }
}

/*********************************************************************
*
*       _cbFontConverter0_320x224
*/
static void _cbFontConverter0_320x224(WM_MESSAGE * pMsg) {
  switch (pMsg->MsgId) {
  case WM_PAINT:
    GUI_DrawBitmap(&bmFontConverter0_320x224, 0, 0);
    break;
  }
}

/*********************************************************************
*
*       _cbFontConverter1_320x224
*/
static void _cbFontConverter1_320x224(WM_MESSAGE * pMsg) {
  switch (pMsg->MsgId) {
  case WM_PAINT:
    GUI_DrawBitmap(&bmFontConverter1_320x224, 0, 0);
    break;
  }
}

/*********************************************************************
*
*       _cbFontOptions0_117x96
*/
static void _cbFontOptions0_117x96(WM_MESSAGE * pMsg) {
  switch (pMsg->MsgId) {
  case WM_PAINT:
    GUI_DrawBitmap(&bmFontOptions0_117x96, 0, 0);
    break;
  }
}

/*********************************************************************
*
*       _cbFontOptions1_117x96
*/
static void _cbFontOptions1_117x96(WM_MESSAGE * pMsg) {
  switch (pMsg->MsgId) {
  case WM_PAINT:
    GUI_DrawBitmap(&bmFontOptions1_117x96, 0, 0);
    break;
  }
}

/*********************************************************************
*
*       _cbIntro
*/
static void _cbIntro(WM_MESSAGE * pMsg) {
  GUI_RECT Rect = {0};
  int      xSize;
  int      ySize;

  switch (pMsg->MsgId) {
  case WM_PAINT:
    GUI_EnableAlpha(1);
    xSize = WM_GetWindowSizeX(pMsg->hWin);
    ySize = WM_GetWindowSizeY(pMsg->hWin);
    Rect.x0 = 5;
    Rect.y0 = 5;
    Rect.x1 = xSize - 11;
    Rect.y1 = ySize - 11;
    GUI_SetColor(GUI_GRAY);
    GUI_DrawRect(0, 0, xSize - 2, ySize - 2);
    GUI_SetColor(GUI_DARKGRAY);
    GUI_DrawRect(1, 1, xSize - 1, ySize - 1);
    GUI_SetColor(GUI_WHITE);
    GUI_SetFont(GUI_FONT_20F_ASCII);
    GUI_SetColor(GUI_LIGHTGRAY);
    GUI_SetTextMode(GUI_TM_TRANS);
    GUI_DispStringInRectWrap(_sIntro, &Rect, GUI_TA_HCENTER | GUI_TA_VCENTER, GUI_WRAPMODE_WORD);
    GUI_EnableAlpha(0);
    break;
  }
}

/*********************************************************************
*
*       _cbBk
*/
static void _cbBk(WM_MESSAGE * pMsg) {
  int xSize;
  int ySize;

  switch (pMsg->MsgId) {
  case WM_PAINT:
    xSize = LCD_GetXSize();
    ySize = LCD_GetYSize();
    GUI_DrawGradientV(0, 0, xSize - 1, ySize - 1, GUI_BLUE, GUI_BLACK);
    GUI_DrawBitmap(&bmLogoSegger_36x18, 15, 10);
    GUI_SetFont(&_FontBig);
    GUI_SetColor(0xFFFFFF);
    GUI_SetTextMode(GUI_TM_TRANS);
    GUI_DispStringHCenterAt("Window effects demonstration", 190, 10);
    break;
  }
}

/*********************************************************************
*
*       Public code
*
**********************************************************************
*/
/*********************************************************************
*
*       MainTask
*/

void MainTask(void);
void MainTask(void) {
  WM_HWIN  hIntro;
  WM_HWIN  hDesktop_320x240;
  WM_HWIN  hFontSelection_174x138;
  WM_HWIN  hFontConverter0_320x224;
  WM_HWIN  hFontConverter1_320x224;
  WM_HWIN  hFontOptions0_117x96;
  WM_HWIN  hFontOptions1_117x96;
  unsigned i;

  WM_SetCreateFlags(WM_CF_MEMDEV);
  GUI_Init();
  //
  // Check if recommended memory for the sample is available
  //
  if (GUI_ALLOC_GetNumFreeBytes() < RECOMMENDED_MEMORY) {
    GUI_ErrorOut("Not enough memory available."); 
    return;
  }
  WM_SetCallback(WM_HBKWIN, _cbBk);
  WM_Exec();
  hIntro = WM_CreateWindow(30, 60, 240, 130, WM_CF_HASTRANS, _cbIntro, 0);
  hDesktop_320x240        = WM_CreateWindow(  0,  0, 320, 240, WM_CF_HASTRANS, _cbDesktop_320x240,        0);
  hFontSelection_174x138  = WM_CreateWindow( 73, 51, 174, 138, WM_CF_HASTRANS, _cbFontSelection_174x138,  0);
  hFontConverter0_320x224 = WM_CreateWindow(  0,  0, 320, 224, WM_CF_HASTRANS, _cbFontConverter0_320x224, 0);
  hFontConverter1_320x224 = WM_CreateWindow(  0,  0, 320, 224, WM_CF_HASTRANS, _cbFontConverter1_320x224, 0);
  hFontOptions0_117x96    = WM_CreateWindow(100, 72, 117,  96, WM_CF_HASTRANS, _cbFontOptions0_117x96,    0);
  hFontOptions1_117x96    = WM_CreateWindow(100, 72, 117,  96, WM_CF_HASTRANS, _cbFontOptions1_117x96,    0);
  while (1) {
    for (i = 0; i < GUI_COUNTOF(_apIntro); i++) {
      _sIntro = _apIntro[i];
      GUI_MEMDEV_FadeInWindow(hIntro, 1000);
      GUI_Delay(3000);
      GUI_MEMDEV_FadeOutWindow(hIntro, 1000);
    }
    GUI_MEMDEV_FadeInWindow(hDesktop_320x240, 1000);
    GUI_Delay(500);
    GUI_MEMDEV_MoveInWindow(hFontConverter0_320x224, 30, 224, 0, 500);
    GUI_MEMDEV_FadeInWindow(hFontOptions0_117x96, 500);
    GUI_Delay(1000);
    GUI_MEMDEV_FadeInWindow(hFontOptions1_117x96, 500);
    WM_HideWindow(hFontOptions0_117x96);
    GUI_Delay(500);
    GUI_MEMDEV_FadeOutWindow(hFontOptions1_117x96, 500);
    GUI_MEMDEV_FadeInWindow(hFontSelection_174x138, 500);
    GUI_Delay(1000);
    GUI_MEMDEV_FadeOutWindow(hFontSelection_174x138, 500);
    GUI_MEMDEV_FadeInWindow(hFontConverter1_320x224, 500);
    WM_HideWindow(hFontConverter0_320x224);
    GUI_Delay(2000);
    GUI_MEMDEV_MoveOutWindow(hFontConverter1_320x224, 30, 224, 0, 500);
    GUI_Delay(1000);
    GUI_MEMDEV_FadeOutWindow(hDesktop_320x240, 1000);
    GUI_Delay(500);
  }
}

/*************************** End of file ****************************/
