/*********************************************************************
*                SEGGER Microcontroller GmbH & Co. KG                *
*        Solutions for real time microcontroller applications        *
**********************************************************************
*                                                                    *
*        (c) 1996 - 2016  SEGGER Microcontroller GmbH & Co. KG       *
*                                                                    *
*        Internet: www.segger.com    Support:  support@segger.com    *
*                                                                    *
**********************************************************************

** emWin V5.34 - Graphical user interface for embedded applications **
All  Intellectual Property rights  in the Software belongs to  SEGGER.
emWin is protected by  international copyright laws.  Knowledge of the
source code may not be used to write a similar product.  This file may
only be used in accordance with the following terms:

The  software has  been licensed  to Silicon Labs Norway, a subsidiary
of Silicon Labs Inc. whose registered office is 400 West Cesar Chavez,
Austin,  TX 78701, USA solely for  the purposes of creating  libraries 
for its  ARM Cortex-M3, M4F  processor-based devices,  sublicensed and 
distributed  under the  terms and conditions  of the  End User License  
Agreement supplied by Silicon Labs.
Full source code is available at: www.segger.com

We appreciate your understanding and fairness.
----------------------------------------------------------------------
Licensing information

Licensor:                 SEGGER Software GmbH
Licensed to:              Silicon Laboratories Norway
Licensed SEGGER software: emWin
License number:           GUI-00140
License model:            See Agreement, dated 20th April 2012
Licensed product:         - 
Licensed platform:        Cortex M3, Cortex M4F
Licensed number of seats: -
----------------------------------------------------------------------
File        : MEMDEV_ZoomAndRotate.c
Purpose     : Sample application to show how to zoom and rotate images
              using Memory Devices.
Requirements: WindowManager - ( )
              MemoryDevices - (x)
              AntiAliasing  - ( )
              VNC-Server    - ( )
              PNG-Library   - ( )
              TrueTypeFonts - ( )
---------------------------END-OF-HEADER------------------------------
*/

#include <stdlib.h>
#include "GUI.h"

/*********************************************************************
*
*       Defines
*
**********************************************************************
*/
#define MAG                        300
#define TITLE_SIZE                 40
#define MIN_TIME_PER_FRAME_SHIFT   20
#define MIN_TIME_PER_FRAME_ENLARGE 30
#define BORDER_SIZE                4
#define FINAL_STEP                 100

//
// Recommended memory to run the sample with adequate performance
//
#define RECOMMENDED_MEMORY (1024L * 2200)

/*********************************************************************
*
*       Static const data
*
**********************************************************************
*/
/*********************************************************************
*                                                                    *
*       GUI_FontRounded22                                            *
*                                                                    *
**********************************************************************
*/
GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0020[  1] = { // Code 0020, SPACE
  0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0021[ 30] = { // Code 0021, EXCLAMATION MARK
  0x02, 0x10,
  0x6F, 0xE2,
  0x9F, 0xF4,
  0x9F, 0xF4,
  0x9F, 0xF4,
  0x7F, 0xF2,
  0x5F, 0xF0,
  0x3F, 0xD0,
  0x1F, 0xB0,
  0x0D, 0x80,
  0x00, 0x00,
  0x2B, 0xA0,
  0x9F, 0xF4,
  0x5F, 0xE1,
  0x01, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0022[ 28] = { // Code 0022, QUOTATION MARK
  0x01, 0x10, 0x02, 0x00,
  0x0E, 0xF2, 0x7F, 0x90,
  0x2F, 0xF4, 0x9F, 0xB0,
  0x2F, 0xF4, 0x9F, 0xB0,
  0x2F, 0xF4, 0x9F, 0xB0,
  0x1E, 0xF2, 0x8F, 0xA0,
  0x02, 0x20, 0x03, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0023[ 84] = { // Code 0023, NUMBER SIGN
  0x00, 0x02, 0xB4, 0x08, 0x90, 0x00,
  0x00, 0x06, 0xF7, 0x0F, 0xD0, 0x00,
  0x00, 0x08, 0xF5, 0x2F, 0xB0, 0x00,
  0x00, 0x2B, 0xF4, 0x5F, 0xA1, 0x00,
  0x07, 0xFF, 0xFF, 0xFF, 0xFE, 0x10,
  0x03, 0x9F, 0xE9, 0xDF, 0xB8, 0x00,
  0x00, 0x1F, 0xB0, 0xAF, 0x30, 0x00,
  0x02, 0x6F, 0xB4, 0xDF, 0x40, 0x00,
  0x0F, 0xFF, 0xFF, 0xFF, 0xF7, 0x00,
  0x06, 0xBF, 0x98, 0xFD, 0x72, 0x00,
  0x00, 0xAF, 0x33, 0xF9, 0x00, 0x00,
  0x00, 0xCF, 0x15, 0xF7, 0x00, 0x00,
  0x00, 0xDD, 0x07, 0xF4, 0x00, 0x00,
  0x00, 0x22, 0x00, 0x30, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0024[ 96] = { // Code 0024, DOLLAR SIGN
  0x00, 0x00, 0x0B, 0x10, 0x00, 0x00,
  0x00, 0x28, 0xBF, 0xC8, 0x30, 0x00,
  0x05, 0xFF, 0xFF, 0xFF, 0xF9, 0x00,
  0x1E, 0xF9, 0x2F, 0x39, 0xFF, 0x50,
  0x3F, 0xF0, 0x0F, 0x20, 0x9E, 0x30,
  0x3F, 0xF6, 0x0F, 0x20, 0x00, 0x00,
  0x0D, 0xFF, 0xDF, 0x73, 0x00, 0x00,
  0x02, 0xCF, 0xFF, 0xFF, 0xC3, 0x00,
  0x00, 0x04, 0x8F, 0xEF, 0xFE, 0x10,
  0x03, 0x00, 0x0F, 0x25, 0xFF, 0x70,
  0x7F, 0xA0, 0x0F, 0x20, 0xBF, 0x80,
  0x7F, 0xF3, 0x0F, 0x21, 0xEF, 0x60,
  0x1D, 0xFE, 0xAF, 0xBE, 0xFD, 0x10,
  0x01, 0xAF, 0xFF, 0xFF, 0xA2, 0x00,
  0x00, 0x01, 0x3F, 0x41, 0x00, 0x00,
  0x00, 0x00, 0x0D, 0x10, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0025[120] = { // Code 0025, PERCENT SIGN
  0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00,
  0x03, 0xAB, 0xA2, 0x00, 0x00, 0x7F, 0x00, 0x00,
  0x2E, 0xEA, 0xFE, 0x10, 0x01, 0xE8, 0x00, 0x00,
  0x7F, 0x70, 0x9F, 0x50, 0x08, 0xE1, 0x00, 0x00,
  0x9F, 0x60, 0x7F, 0x70, 0x2F, 0x70, 0x00, 0x00,
  0x7F, 0x60, 0x8F, 0x60, 0x9E, 0x10, 0x00, 0x00,
  0x3F, 0xD6, 0xEF, 0x22, 0xF7, 0x00, 0x00, 0x00,
  0x07, 0xEF, 0xE6, 0x0A, 0xE0, 0x17, 0x98, 0x20,
  0x00, 0x01, 0x00, 0x3F, 0x60, 0xCF, 0xCF, 0xE1,
  0x00, 0x00, 0x00, 0xBD, 0x04, 0xFA, 0x09, 0xF6,
  0x00, 0x00, 0x04, 0xF5, 0x07, 0xF7, 0x06, 0xF9,
  0x00, 0x00, 0x0C, 0xC0, 0x06, 0xF8, 0x06, 0xF8,
  0x00, 0x00, 0x5F, 0x40, 0x03, 0xFC, 0x3B, 0xF4,
  0x00, 0x00, 0xCB, 0x00, 0x00, 0x8F, 0xFF, 0x90,
  0x00, 0x00, 0x93, 0x00, 0x00, 0x01, 0x42, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0026[105] = { // Code 0026, AMPERSAND
  0x00, 0x00, 0x01, 0x10, 0x00, 0x00, 0x00,
  0x00, 0x04, 0xDF, 0xFD, 0x50, 0x00, 0x00,
  0x00, 0x3F, 0xFD, 0xCF, 0xF4, 0x00, 0x00,
  0x00, 0x9F, 0xD0, 0x0B, 0xFA, 0x00, 0x00,
  0x00, 0x9F, 0xD0, 0x0B, 0xFA, 0x00, 0x00,
  0x00, 0x4F, 0xF9, 0x8F, 0xF5, 0x00, 0x00,
  0x00, 0x0A, 0xFF, 0xFF, 0x80, 0x00, 0x00,
  0x00, 0x9F, 0xFF, 0xFB, 0x00, 0x54, 0x00,
  0x09, 0xFF, 0xBA, 0xFF, 0x74, 0xFF, 0x00,
  0x1F, 0xFB, 0x00, 0xBF, 0xFE, 0xFC, 0x00,
  0x3F, 0xF7, 0x00, 0x1D, 0xFF, 0xE3, 0x00,
  0x1F, 0xFB, 0x00, 0x2C, 0xFF, 0xE3, 0x00,
  0x0A, 0xFF, 0xED, 0xFF, 0xEE, 0xFD, 0x00,
  0x01, 0xAF, 0xFF, 0xFB, 0x24, 0xFD, 0x00,
  0x00, 0x01, 0x43, 0x10, 0x00, 0x10, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0027[ 14] = { // Code 0027, APOSTROPHE
  0x01, 0x10,
  0x3F, 0xD0,
  0x6F, 0xF0,
  0x6F, 0xF0,
  0x6F, 0xF0,
  0x3F, 0xE0,
  0x03, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0028[ 54] = { // Code 0028, LEFT PARENTHESIS
  0x00, 0x03, 0x00,
  0x00, 0x9F, 0x40,
  0x02, 0xFF, 0x20,
  0x08, 0xFB, 0x00,
  0x0E, 0xF7, 0x00,
  0x4F, 0xF3, 0x00,
  0x7F, 0xE0, 0x00,
  0xAF, 0xC0, 0x00,
  0xBF, 0xB0, 0x00,
  0xBF, 0xB0, 0x00,
  0xBF, 0xB0, 0x00,
  0x8F, 0xE0, 0x00,
  0x5F, 0xF2, 0x00,
  0x1F, 0xF5, 0x00,
  0x0A, 0xFA, 0x00,
  0x04, 0xFE, 0x10,
  0x00, 0xCF, 0x50,
  0x00, 0x29, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0029[ 54] = { // Code 0029, RIGHT PARENTHESIS
  0x03, 0x00, 0x00,
  0x5F, 0x90, 0x00,
  0x2F, 0xF2, 0x00,
  0x0B, 0xF8, 0x00,
  0x07, 0xFE, 0x00,
  0x03, 0xFF, 0x30,
  0x00, 0xFF, 0x70,
  0x00, 0xCF, 0xA0,
  0x00, 0xBF, 0xB0,
  0x00, 0xBF, 0xB0,
  0x00, 0xCF, 0xB0,
  0x00, 0xEF, 0x80,
  0x02, 0xFF, 0x50,
  0x05, 0xFF, 0x10,
  0x0A, 0xFA, 0x00,
  0x1E, 0xF4, 0x00,
  0x5F, 0xC0, 0x00,
  0x19, 0x20, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_002A[ 32] = { // Code 002A, ASTERISK
  0x00, 0x00, 0x10, 0x00,
  0x00, 0x08, 0xE0, 0x00,
  0x05, 0x29, 0xF0, 0x51,
  0x2F, 0xFE, 0xFE, 0xF7,
  0x02, 0x7F, 0xFB, 0x40,
  0x00, 0xAF, 0xCE, 0x20,
  0x03, 0xF7, 0x2F, 0x90,
  0x00, 0x30, 0x03, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_002B[ 66] = { // Code 002B, PLUS SIGN
  0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x8F, 0x50, 0x00, 0x00,
  0x00, 0x00, 0xBF, 0x70, 0x00, 0x00,
  0x00, 0x00, 0xBF, 0x70, 0x00, 0x00,
  0x02, 0x22, 0xCF, 0x82, 0x22, 0x00,
  0x8F, 0xFF, 0xFF, 0xFF, 0xFF, 0x60,
  0x6F, 0xFF, 0xFF, 0xFF, 0xFE, 0x40,
  0x00, 0x00, 0xBF, 0x70, 0x00, 0x00,
  0x00, 0x00, 0xBF, 0x70, 0x00, 0x00,
  0x00, 0x00, 0xBF, 0x70, 0x00, 0x00,
  0x00, 0x00, 0x7F, 0x40, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_002C[ 12] = { // Code 002C, COMMA
  0x3C, 0x90,
  0xBF, 0xF5,
  0x6F, 0xF7,
  0x01, 0xE5,
  0x4C, 0xC0,
  0x67, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_002D[ 16] = { // Code 002D, HYPHEN-MINUS
  0x01, 0x44, 0x42, 0x00,
  0x2F, 0xFF, 0xFF, 0x70,
  0x3F, 0xFF, 0xFF, 0x80,
  0x02, 0x44, 0x43, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_002E[  8] = { // Code 002E, FULL STOP
  0x3C, 0x90,
  0xBF, 0xF3,
  0x6F, 0xD1,
  0x01, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_002F[ 60] = { // Code 002F, SOLIDUS
  0x00, 0x00, 0x03, 0x00,
  0x00, 0x00, 0x6F, 0x70,
  0x00, 0x00, 0xCF, 0x40,
  0x00, 0x03, 0xFD, 0x00,
  0x00, 0x08, 0xF8, 0x00,
  0x00, 0x0E, 0xF2, 0x00,
  0x00, 0x5F, 0xB0, 0x00,
  0x00, 0xBF, 0x60, 0x00,
  0x01, 0xFE, 0x10, 0x00,
  0x07, 0xF9, 0x00, 0x00,
  0x0D, 0xF3, 0x00, 0x00,
  0x3F, 0xD0, 0x00, 0x00,
  0x9F, 0x70, 0x00, 0x00,
  0xCF, 0x20, 0x00, 0x00,
  0x23, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0030[ 84] = { // Code 0030, DIGIT ZERO
  0x00, 0x05, 0xBB, 0xB6, 0x00, 0x00,
  0x00, 0xAF, 0xFF, 0xFF, 0xA0, 0x00,
  0x06, 0xFF, 0xA6, 0xAF, 0xF7, 0x00,
  0x0D, 0xFC, 0x00, 0x0C, 0xFD, 0x00,
  0x2F, 0xF8, 0x00, 0x08, 0xFF, 0x20,
  0x4F, 0xF6, 0x00, 0x06, 0xFF, 0x40,
  0x4F, 0xF6, 0x00, 0x06, 0xFF, 0x40,
  0x4F, 0xF6, 0x00, 0x06, 0xFF, 0x40,
  0x2F, 0xF7, 0x00, 0x06, 0xFF, 0x30,
  0x0E, 0xFA, 0x00, 0x0A, 0xFE, 0x00,
  0x09, 0xFF, 0x40, 0x4F, 0xF9, 0x00,
  0x02, 0xEF, 0xFE, 0xFF, 0xE2, 0x00,
  0x00, 0x3C, 0xFF, 0xFC, 0x30, 0x00,
  0x00, 0x00, 0x24, 0x20, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0031[ 56] = { // Code 0031, DIGIT ONE
  0x00, 0x00, 0x2B, 0x70,
  0x00, 0x00, 0xAF, 0xC0,
  0x01, 0x49, 0xFF, 0xD0,
  0x1E, 0xFF, 0xFF, 0xD0,
  0x1B, 0xDD, 0xFF, 0xD0,
  0x00, 0x00, 0xDF, 0xD0,
  0x00, 0x00, 0xDF, 0xD0,
  0x00, 0x00, 0xDF, 0xD0,
  0x00, 0x00, 0xDF, 0xD0,
  0x00, 0x00, 0xDF, 0xD0,
  0x00, 0x00, 0xDF, 0xD0,
  0x00, 0x00, 0xDF, 0xC0,
  0x00, 0x00, 0xBF, 0xA0,
  0x00, 0x00, 0x13, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0032[ 78] = { // Code 0032, DIGIT TWO
  0x00, 0x17, 0xBB, 0xB6, 0x00, 0x00,
  0x03, 0xEF, 0xFF, 0xFF, 0xD1, 0x00,
  0x0D, 0xFE, 0x86, 0xAF, 0xFB, 0x00,
  0x5F, 0xF6, 0x00, 0x0D, 0xFF, 0x00,
  0x4F, 0xE1, 0x00, 0x0B, 0xFF, 0x00,
  0x03, 0x20, 0x00, 0x3F, 0xFB, 0x00,
  0x00, 0x00, 0x07, 0xEF, 0xF3, 0x00,
  0x00, 0x03, 0xCF, 0xFD, 0x30, 0x00,
  0x00, 0x6F, 0xFE, 0x70, 0x00, 0x00,
  0x06, 0xFF, 0xA2, 0x00, 0x00, 0x00,
  0x2F, 0xFC, 0x44, 0x44, 0x42, 0x00,
  0x6F, 0xFF, 0xFF, 0xFF, 0xFF, 0x10,
  0x3E, 0xFF, 0xFF, 0xFF, 0xFD, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0033[ 70] = { // Code 0033, DIGIT THREE
  0x00, 0x28, 0xBB, 0xA5, 0x00,
  0x05, 0xFF, 0xFF, 0xFF, 0xA0,
  0x1F, 0xFE, 0x76, 0xCF, 0xF4,
  0x2F, 0xF4, 0x00, 0x2F, 0xF7,
  0x04, 0x40, 0x00, 0x2F, 0xF5,
  0x00, 0x00, 0x5A, 0xEF, 0xB0,
  0x00, 0x00, 0xFF, 0xFF, 0x90,
  0x00, 0x00, 0x38, 0xCF, 0xF8,
  0x01, 0x00, 0x00, 0x1E, 0xFC,
  0x3F, 0xC0, 0x00, 0x0E, 0xFD,
  0x5F, 0xF8, 0x00, 0x7F, 0xF9,
  0x1D, 0xFF, 0xFE, 0xFF, 0xE2,
  0x02, 0xBF, 0xFF, 0xFB, 0x30,
  0x00, 0x01, 0x33, 0x10, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0034[ 84] = { // Code 0034, DIGIT FOUR
  0x00, 0x00, 0x00, 0x9B, 0x40, 0x00,
  0x00, 0x00, 0x07, 0xFF, 0x90, 0x00,
  0x00, 0x00, 0x4F, 0xFF, 0x90, 0x00,
  0x00, 0x02, 0xEE, 0xEF, 0x90, 0x00,
  0x00, 0x0C, 0xF4, 0xDF, 0x90, 0x00,
  0x00, 0x9F, 0x80, 0xDF, 0x90, 0x00,
  0x06, 0xFB, 0x00, 0xDF, 0x90, 0x00,
  0x3F, 0xE2, 0x00, 0xDF, 0x90, 0x00,
  0xBF, 0xFF, 0xFF, 0xFF, 0xFE, 0x50,
  0x8F, 0xFF, 0xFF, 0xFF, 0xFF, 0x60,
  0x02, 0x22, 0x22, 0xDF, 0xA2, 0x00,
  0x00, 0x00, 0x00, 0xDF, 0x90, 0x00,
  0x00, 0x00, 0x00, 0xBF, 0x80, 0x00,
  0x00, 0x00, 0x00, 0x13, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0035[ 70] = { // Code 0035, DIGIT FIVE
  0x01, 0x89, 0x99, 0x99, 0x70,
  0x07, 0xFF, 0xFF, 0xFF, 0xF3,
  0x0A, 0xFD, 0xBB, 0xBB, 0x90,
  0x0C, 0xF5, 0x00, 0x00, 0x00,
  0x0F, 0xF3, 0x46, 0x51, 0x00,
  0x3F, 0xFD, 0xFF, 0xFE, 0x60,
  0x3F, 0xFE, 0xAB, 0xFF, 0xF3,
  0x06, 0x60, 0x00, 0x4F, 0xFA,
  0x00, 0x00, 0x00, 0x0D, 0xFB,
  0x17, 0x40, 0x00, 0x0E, 0xFB,
  0x5F, 0xF4, 0x00, 0x8F, 0xF7,
  0x3F, 0xFF, 0xDE, 0xFF, 0xD1,
  0x04, 0xCF, 0xFF, 0xFA, 0x10,
  0x00, 0x02, 0x43, 0x10, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0036[ 84] = { // Code 0036, DIGIT SIX
  0x00, 0x04, 0x9B, 0xB9, 0x30, 0x00,
  0x00, 0x8F, 0xFF, 0xFF, 0xF4, 0x00,
  0x04, 0xFF, 0x93, 0x4E, 0xFB, 0x00,
  0x0B, 0xFC, 0x00, 0x02, 0x93, 0x00,
  0x1F, 0xF7, 0x02, 0x31, 0x00, 0x00,
  0x3F, 0xF9, 0xDF, 0xFF, 0x91, 0x00,
  0x4F, 0xFF, 0xEB, 0xDF, 0xFA, 0x00,
  0x4F, 0xFD, 0x10, 0x0B, 0xFF, 0x20,
  0x3F, 0xF8, 0x00, 0x06, 0xFF, 0x40,
  0x1F, 0xF8, 0x00, 0x06, 0xFF, 0x40,
  0x0B, 0xFE, 0x20, 0x1C, 0xFF, 0x10,
  0x03, 0xEF, 0xFD, 0xEF, 0xF7, 0x00,
  0x00, 0x3C, 0xFF, 0xFE, 0x70, 0x00,
  0x00, 0x00, 0x24, 0x30, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0037[ 70] = { // Code 0037, DIGIT SEVEN
  0x49, 0x99, 0x99, 0x99, 0x94,
  0xBF, 0xFF, 0xFF, 0xFF, 0xFD,
  0x5B, 0xBB, 0xBB, 0xBF, 0xF9,
  0x00, 0x00, 0x00, 0x9F, 0xC0,
  0x00, 0x00, 0x05, 0xFE, 0x20,
  0x00, 0x00, 0x1E, 0xF6, 0x00,
  0x00, 0x00, 0x9F, 0xD0, 0x00,
  0x00, 0x02, 0xFF, 0x70, 0x00,
  0x00, 0x08, 0xFF, 0x10, 0x00,
  0x00, 0x0E, 0xFB, 0x00, 0x00,
  0x00, 0x4F, 0xF7, 0x00, 0x00,
  0x00, 0x7F, 0xF3, 0x00, 0x00,
  0x00, 0x6F, 0xD0, 0x00, 0x00,
  0x00, 0x03, 0x10, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0038[ 84] = { // Code 0038, DIGIT EIGHT
  0x00, 0x17, 0xBB, 0xB8, 0x10, 0x00,
  0x02, 0xEF, 0xFF, 0xFF, 0xE3, 0x00,
  0x0B, 0xFE, 0x62, 0x6E, 0xFB, 0x00,
  0x0D, 0xFA, 0x00, 0x0A, 0xFF, 0x00,
  0x0C, 0xFB, 0x00, 0x0B, 0xFC, 0x00,
  0x04, 0xFF, 0xB8, 0xBF, 0xF4, 0x00,
  0x02, 0xBF, 0xFF, 0xFF, 0xB2, 0x00,
  0x0C, 0xFE, 0x64, 0x6E, 0xFD, 0x00,
  0x3F, 0xF7, 0x00, 0x07, 0xFF, 0x30,
  0x4F, 0xF6, 0x00, 0x06, 0xFF, 0x40,
  0x2F, 0xFC, 0x10, 0x1B, 0xFF, 0x20,
  0x09, 0xFF, 0xED, 0xEF, 0xF9, 0x00,
  0x00, 0x7E, 0xFF, 0xFE, 0x80, 0x00,
  0x00, 0x00, 0x24, 0x30, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0039[ 84] = { // Code 0039, DIGIT NINE
  0x00, 0x17, 0xBB, 0xB6, 0x00, 0x00,
  0x03, 0xEF, 0xFF, 0xFF, 0xB0, 0x00,
  0x0C, 0xFE, 0x74, 0x8F, 0xF8, 0x00,
  0x3F, 0xF8, 0x00, 0x0A, 0xFE, 0x00,
  0x4F, 0xF6, 0x00, 0x07, 0xFF, 0x30,
  0x3F, 0xF7, 0x00, 0x0A, 0xFF, 0x40,
  0x0D, 0xFF, 0x74, 0x9F, 0xFF, 0x40,
  0x03, 0xEF, 0xFF, 0xFD, 0xFF, 0x40,
  0x00, 0x17, 0x99, 0x56, 0xFF, 0x20,
  0x00, 0x30, 0x00, 0x09, 0xFD, 0x00,
  0x09, 0xFA, 0x00, 0x3F, 0xF8, 0x00,
  0x08, 0xFF, 0xDB, 0xFF, 0xD1, 0x00,
  0x01, 0x9F, 0xFF, 0xFA, 0x20, 0x00,
  0x00, 0x01, 0x33, 0x10, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_003A[ 22] = { // Code 003A, COLON
  0x05, 0x30,
  0x9F, 0xF2,
  0x9F, 0xF2,
  0x17, 0x40,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x3C, 0x90,
  0xBF, 0xF3,
  0x6F, 0xD1,
  0x01, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_003B[ 26] = { // Code 003B, SEMICOLON
  0x05, 0x30,
  0x9F, 0xF2,
  0x9F, 0xF2,
  0x17, 0x40,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x3C, 0x90,
  0xBF, 0xF5,
  0x6F, 0xF7,
  0x01, 0xE5,
  0x4C, 0xC0,
  0x67, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_003C[ 60] = { // Code 003C, LESS-THAN SIGN
  0x00, 0x00, 0x00, 0x01, 0x8B, 0x20,
  0x00, 0x00, 0x02, 0x9F, 0xFF, 0x50,
  0x00, 0x03, 0xAF, 0xFF, 0xC6, 0x00,
  0x05, 0xCF, 0xFF, 0xB4, 0x00, 0x00,
  0x7F, 0xFF, 0x92, 0x00, 0x00, 0x00,
  0x5F, 0xFF, 0xB5, 0x00, 0x00, 0x00,
  0x02, 0x9F, 0xFF, 0xD7, 0x10, 0x00,
  0x00, 0x01, 0x7E, 0xFF, 0xF8, 0x10,
  0x00, 0x00, 0x00, 0x7D, 0xFF, 0x50,
  0x00, 0x00, 0x00, 0x00, 0x57, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_003D[ 48] = { // Code 003D, EQUALS SIGN
  0x04, 0x44, 0x44, 0x44, 0x43, 0x00,
  0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0x70,
  0x5D, 0xDD, 0xDD, 0xDD, 0xDC, 0x30,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0x50,
  0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0x50,
  0x02, 0x22, 0x22, 0x22, 0x21, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_003E[ 60] = { // Code 003E, GREATER-THAN SIGN
  0x4B, 0x70, 0x00, 0x00, 0x00, 0x00,
  0x8F, 0xFE, 0x81, 0x00, 0x00, 0x00,
  0x17, 0xEF, 0xFF, 0x92, 0x00, 0x00,
  0x00, 0x05, 0xCF, 0xFF, 0xA3, 0x00,
  0x00, 0x00, 0x03, 0xAF, 0xFF, 0x40,
  0x00, 0x00, 0x06, 0xDF, 0xFE, 0x30,
  0x00, 0x28, 0xEF, 0xFE, 0x71, 0x00,
  0x1A, 0xFF, 0xFD, 0x60, 0x00, 0x00,
  0x9F, 0xFC, 0x50, 0x00, 0x00, 0x00,
  0x27, 0x30, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_003F[ 75] = { // Code 003F, QUESTION MARK
  0x00, 0x00, 0x22, 0x00, 0x00,
  0x00, 0x7E, 0xFF, 0xFA, 0x20,
  0x09, 0xFF, 0xEE, 0xFF, 0xE1,
  0x2F, 0xFA, 0x00, 0x7F, 0xF7,
  0x2F, 0xE2, 0x00, 0x3F, 0xF7,
  0x02, 0x20, 0x00, 0xAF, 0xF5,
  0x00, 0x00, 0x1B, 0xFF, 0xA0,
  0x00, 0x00, 0xCF, 0xF7, 0x00,
  0x00, 0x05, 0xFF, 0x50, 0x00,
  0x00, 0x02, 0xEC, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x02, 0xBA, 0x10, 0x00,
  0x00, 0x08, 0xFF, 0x50, 0x00,
  0x00, 0x04, 0xFE, 0x20, 0x00,
  0x00, 0x00, 0x11, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0040[105] = { // Code 0040, COMMERCIAL AT
  0x00, 0x00, 0x00, 0x34, 0x31, 0x00, 0x00,
  0x00, 0x02, 0x9E, 0xFF, 0xFF, 0xA2, 0x00,
  0x00, 0x3E, 0xFB, 0x76, 0x7A, 0xFE, 0x50,
  0x02, 0xEF, 0x50, 0x00, 0x00, 0x3E, 0xE2,
  0x0B, 0xF6, 0x07, 0xEE, 0x96, 0xB5, 0xF8,
  0x2F, 0xD0, 0x7F, 0xFF, 0xFF, 0xF0, 0xEC,
  0x5F, 0x91, 0xEF, 0x40, 0x8F, 0xC0, 0xBD,
  0x7F, 0x74, 0xFA, 0x00, 0x4F, 0x90, 0xCB,
  0x6F, 0x85, 0xFB, 0x00, 0x6F, 0x71, 0xF7,
  0x3F, 0xC2, 0xFF, 0x98, 0xEF, 0xAC, 0xD1,
  0x0C, 0xF4, 0x9F, 0xFF, 0xEF, 0xFB, 0x20,
  0x03, 0xFE, 0x45, 0x73, 0x37, 0x57, 0x00,
  0x00, 0x5E, 0xFB, 0x66, 0x69, 0xEE, 0x10,
  0x00, 0x02, 0x9F, 0xFF, 0xFF, 0xA2, 0x00,
  0x00, 0x00, 0x01, 0x34, 0x31, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0041[ 90] = { // Code 0041, LATIN CAPITAL LETTER A
  0x00, 0x00, 0x02, 0x30, 0x00, 0x00,
  0x00, 0x00, 0x9F, 0xFB, 0x00, 0x00,
  0x00, 0x01, 0xFF, 0xFF, 0x30, 0x00,
  0x00, 0x06, 0xFF, 0xFF, 0x80, 0x00,
  0x00, 0x0C, 0xFD, 0xCF, 0xE0, 0x00,
  0x00, 0x3F, 0xF8, 0x7F, 0xF4, 0x00,
  0x00, 0x8F, 0xF3, 0x2F, 0xFA, 0x00,
  0x00, 0xEF, 0xD0, 0x0D, 0xFF, 0x10,
  0x04, 0xFF, 0x80, 0x08, 0xFF, 0x60,
  0x0A, 0xFF, 0xCB, 0xBC, 0xFF, 0xB0,
  0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF2,
  0x7F, 0xF9, 0x44, 0x44, 0x9F, 0xF7,
  0xCF, 0xF3, 0x00, 0x00, 0x3F, 0xFC,
  0xAF, 0xC0, 0x00, 0x00, 0x0C, 0xFA,
  0x03, 0x10, 0x00, 0x00, 0x01, 0x30
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0042[ 78] = { // Code 0042, LATIN CAPITAL LETTER B
  0x3D, 0xFF, 0xFF, 0xED, 0xA3, 0x00,
  0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0x30,
  0x9F, 0xF8, 0x44, 0x4C, 0xFF, 0xA0,
  0x9F, 0xF6, 0x00, 0x04, 0xFF, 0xB0,
  0x9F, 0xF6, 0x00, 0x06, 0xFF, 0x70,
  0x9F, 0xFB, 0x99, 0xBF, 0xFB, 0x10,
  0x9F, 0xFF, 0xFF, 0xFF, 0xFB, 0x20,
  0x9F, 0xF8, 0x44, 0x4A, 0xFF, 0xD0,
  0x9F, 0xF6, 0x00, 0x00, 0xCF, 0xF2,
  0x9F, 0xF6, 0x00, 0x00, 0xCF, 0xF3,
  0x9F, 0xF8, 0x44, 0x5A, 0xFF, 0xE0,
  0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0x60,
  0x4E, 0xFF, 0xFF, 0xFE, 0xB4, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0043[ 90] = { // Code 0043, LATIN CAPITAL LETTER C
  0x00, 0x00, 0x13, 0x43, 0x00, 0x00,
  0x00, 0x2A, 0xFF, 0xFF, 0xE7, 0x00,
  0x03, 0xEF, 0xFF, 0xFF, 0xFF, 0xB0,
  0x1E, 0xFF, 0xB3, 0x25, 0xEF, 0xF6,
  0x7F, 0xFB, 0x00, 0x00, 0x4F, 0xF7,
  0xCF, 0xF3, 0x00, 0x00, 0x03, 0x61,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xD0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xDF, 0xF3, 0x00, 0x00, 0x05, 0x71,
  0x9F, 0xFA, 0x00, 0x00, 0x4F, 0xF7,
  0x3F, 0xFF, 0x93, 0x25, 0xEF, 0xF5,
  0x06, 0xFF, 0xFF, 0xFF, 0xFF, 0xA0,
  0x00, 0x4C, 0xFF, 0xFF, 0xE7, 0x00,
  0x00, 0x00, 0x24, 0x43, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0044[ 78] = { // Code 0044, LATIN CAPITAL LETTER D
  0x3D, 0xFF, 0xFF, 0xEC, 0x71, 0x00,
  0x9F, 0xFF, 0xFF, 0xFF, 0xFE, 0x30,
  0x9F, 0xF9, 0x66, 0x7D, 0xFF, 0xD0,
  0x9F, 0xF6, 0x00, 0x01, 0xCF, 0xF6,
  0x9F, 0xF6, 0x00, 0x00, 0x5F, 0xFA,
  0x9F, 0xF6, 0x00, 0x00, 0x2F, 0xFD,
  0x9F, 0xF6, 0x00, 0x00, 0x2F, 0xFD,
  0x9F, 0xF6, 0x00, 0x00, 0x2F, 0xFC,
  0x9F, 0xF6, 0x00, 0x00, 0x6F, 0xFA,
  0x9F, 0xF6, 0x00, 0x01, 0xDF, 0xF5,
  0x9F, 0xF9, 0x66, 0x7D, 0xFF, 0xC0,
  0x9F, 0xFF, 0xFF, 0xFF, 0xFD, 0x20,
  0x4E, 0xFF, 0xFF, 0xFC, 0x71, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0045[ 78] = { // Code 0045, LATIN CAPITAL LETTER E
  0x3D, 0xFF, 0xFF, 0xFF, 0xFE, 0x50,
  0x8F, 0xFF, 0xFF, 0xFF, 0xFF, 0x80,
  0x9F, 0xF9, 0x66, 0x66, 0x65, 0x10,
  0x9F, 0xF6, 0x00, 0x00, 0x00, 0x00,
  0x9F, 0xF6, 0x00, 0x00, 0x00, 0x00,
  0x9F, 0xFD, 0xBB, 0xBB, 0xB6, 0x00,
  0x9F, 0xFF, 0xFF, 0xFF, 0xFB, 0x00,
  0x9F, 0xFA, 0x77, 0x77, 0x73, 0x00,
  0x9F, 0xF6, 0x00, 0x00, 0x00, 0x00,
  0x9F, 0xF6, 0x00, 0x00, 0x00, 0x00,
  0x9F, 0xF9, 0x66, 0x66, 0x65, 0x10,
  0x8F, 0xFF, 0xFF, 0xFF, 0xFF, 0xA0,
  0x3D, 0xFF, 0xFF, 0xFF, 0xFF, 0x70
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0046[ 84] = { // Code 0046, LATIN CAPITAL LETTER F
  0x3D, 0xFF, 0xFF, 0xFF, 0xFB, 0x10,
  0x8F, 0xFF, 0xFF, 0xFF, 0xFF, 0x10,
  0x9F, 0xF9, 0x66, 0x66, 0x64, 0x00,
  0x9F, 0xF6, 0x00, 0x00, 0x00, 0x00,
  0x9F, 0xF6, 0x00, 0x00, 0x00, 0x00,
  0x9F, 0xFB, 0x99, 0x99, 0x70, 0x00,
  0x9F, 0xFF, 0xFF, 0xFF, 0xF3, 0x00,
  0x9F, 0xFD, 0xBB, 0xBB, 0x90, 0x00,
  0x9F, 0xF6, 0x00, 0x00, 0x00, 0x00,
  0x9F, 0xF6, 0x00, 0x00, 0x00, 0x00,
  0x9F, 0xF6, 0x00, 0x00, 0x00, 0x00,
  0x9F, 0xF6, 0x00, 0x00, 0x00, 0x00,
  0x5F, 0xF3, 0x00, 0x00, 0x00, 0x00,
  0x03, 0x20, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0047[105] = { // Code 0047, LATIN CAPITAL LETTER G
  0x00, 0x00, 0x03, 0x43, 0x10, 0x00, 0x00,
  0x00, 0x2A, 0xFF, 0xFF, 0xFA, 0x20, 0x00,
  0x03, 0xEF, 0xFF, 0xFF, 0xFF, 0xE2, 0x00,
  0x1E, 0xFF, 0xB4, 0x23, 0xAF, 0xFA, 0x00,
  0x8F, 0xFB, 0x00, 0x00, 0x0B, 0xF8, 0x00,
  0xCF, 0xF3, 0x00, 0x00, 0x00, 0x20, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xD0, 0x00, 0x5D, 0xDD, 0xDD, 0x30,
  0xFF, 0xE0, 0x00, 0x8F, 0xFF, 0xFF, 0x60,
  0xDF, 0xF2, 0x00, 0x15, 0x69, 0xFF, 0x60,
  0x9F, 0xF9, 0x00, 0x00, 0x0B, 0xFF, 0x60,
  0x2F, 0xFF, 0x82, 0x02, 0x9F, 0xFF, 0x60,
  0x06, 0xFF, 0xFF, 0xFF, 0xFE, 0xEF, 0x60,
  0x00, 0x4C, 0xFF, 0xFF, 0xD3, 0x9F, 0x50,
  0x00, 0x00, 0x24, 0x43, 0x00, 0x03, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0048[ 90] = { // Code 0048, LATIN CAPITAL LETTER H
  0x02, 0x10, 0x00, 0x00, 0x01, 0x20,
  0x6F, 0xE2, 0x00, 0x00, 0x2E, 0xF6,
  0x9F, 0xF5, 0x00, 0x00, 0x5F, 0xF9,
  0x9F, 0xF6, 0x00, 0x00, 0x6F, 0xF9,
  0x9F, 0xF6, 0x00, 0x00, 0x6F, 0xF9,
  0x9F, 0xF6, 0x00, 0x00, 0x6F, 0xF9,
  0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF9,
  0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF9,
  0x9F, 0xFA, 0x77, 0x77, 0xAF, 0xF9,
  0x9F, 0xF6, 0x00, 0x00, 0x6F, 0xF9,
  0x9F, 0xF6, 0x00, 0x00, 0x6F, 0xF9,
  0x9F, 0xF6, 0x00, 0x00, 0x6F, 0xF9,
  0x9F, 0xF5, 0x00, 0x00, 0x5F, 0xF9,
  0x6F, 0xE2, 0x00, 0x00, 0x2E, 0xF7,
  0x03, 0x20, 0x00, 0x00, 0x02, 0x30
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0049[ 30] = { // Code 0049, LATIN CAPITAL LETTER I
  0x02, 0x10,
  0x6F, 0xE2,
  0x9F, 0xF5,
  0x9F, 0xF6,
  0x9F, 0xF6,
  0x9F, 0xF6,
  0x9F, 0xF6,
  0x9F, 0xF6,
  0x9F, 0xF6,
  0x9F, 0xF6,
  0x9F, 0xF6,
  0x9F, 0xF6,
  0x9F, 0xF5,
  0x6F, 0xE2,
  0x03, 0x20
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_004A[ 75] = { // Code 004A, LATIN CAPITAL LETTER J
  0x00, 0x00, 0x00, 0x02, 0x00,
  0x00, 0x00, 0x00, 0xBF, 0xB0,
  0x00, 0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0x00, 0xFF, 0xF0,
  0x01, 0x00, 0x00, 0xFF, 0xF0,
  0x5F, 0xC0, 0x00, 0xFF, 0xF0,
  0x9F, 0xF1, 0x00, 0xFF, 0xE0,
  0x9F, 0xF6, 0x07, 0xFF, 0xB0,
  0x3F, 0xFF, 0xFF, 0xFF, 0x50,
  0x05, 0xEF, 0xFF, 0xF7, 0x00,
  0x00, 0x03, 0x43, 0x10, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_004B[ 90] = { // Code 004B, LATIN CAPITAL LETTER K
  0x02, 0x10, 0x00, 0x00, 0x11, 0x00,
  0x6F, 0xE2, 0x00, 0x02, 0xEF, 0x50,
  0x9F, 0xF5, 0x00, 0x1D, 0xFF, 0x60,
  0x9F, 0xF6, 0x01, 0xDF, 0xF8, 0x00,
  0x9F, 0xF6, 0x1B, 0xFF, 0x90, 0x00,
  0x9F, 0xF6, 0xAF, 0xFA, 0x00, 0x00,
  0x9F, 0xFE, 0xFF, 0xF4, 0x00, 0x00,
  0x9F, 0xFF, 0xFF, 0xFD, 0x00, 0x00,
  0x9F, 0xFF, 0xAD, 0xFF, 0x80, 0x00,
  0x9F, 0xFA, 0x03, 0xFF, 0xF3, 0x00,
  0x9F, 0xF6, 0x00, 0x9F, 0xFD, 0x00,
  0x9F, 0xF6, 0x00, 0x1D, 0xFF, 0x70,
  0x9F, 0xF5, 0x00, 0x04, 0xFF, 0xF1,
  0x6F, 0xE2, 0x00, 0x00, 0x9F, 0xE1,
  0x03, 0x20, 0x00, 0x00, 0x03, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_004C[ 70] = { // Code 004C, LATIN CAPITAL LETTER L
  0x02, 0x10, 0x00, 0x00, 0x00,
  0x6F, 0xE2, 0x00, 0x00, 0x00,
  0x9F, 0xF5, 0x00, 0x00, 0x00,
  0x9F, 0xF6, 0x00, 0x00, 0x00,
  0x9F, 0xF6, 0x00, 0x00, 0x00,
  0x9F, 0xF6, 0x00, 0x00, 0x00,
  0x9F, 0xF6, 0x00, 0x00, 0x00,
  0x9F, 0xF6, 0x00, 0x00, 0x00,
  0x9F, 0xF6, 0x00, 0x00, 0x00,
  0x9F, 0xF6, 0x00, 0x00, 0x00,
  0x9F, 0xF6, 0x00, 0x00, 0x00,
  0x9F, 0xFA, 0x77, 0x77, 0x72,
  0x9F, 0xFF, 0xFF, 0xFF, 0xFB,
  0x4E, 0xFF, 0xFF, 0xFF, 0xF7
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_004D[105] = { // Code 004D, LATIN CAPITAL LETTER M
  0x02, 0x31, 0x00, 0x00, 0x00, 0x13, 0x20,
  0x7F, 0xFE, 0x30, 0x00, 0x02, 0xEF, 0xF7,
  0xBF, 0xFF, 0x80, 0x00, 0x08, 0xFF, 0xF9,
  0xBF, 0xFF, 0xD0, 0x00, 0x0C, 0xFF, 0xF9,
  0xBF, 0xFF, 0xF2, 0x00, 0x2F, 0xFF, 0xF9,
  0xBF, 0xFB, 0xF7, 0x00, 0x7F, 0xBF, 0xF9,
  0xBF, 0xF7, 0xFC, 0x00, 0xBF, 0x7F, 0xF9,
  0xBF, 0xF2, 0xFF, 0x21, 0xFF, 0x2F, 0xF9,
  0xBF, 0xF0, 0xCF, 0x65, 0xFC, 0x0F, 0xF9,
  0xBF, 0xF0, 0x8F, 0xBA, 0xF7, 0x0F, 0xF9,
  0xBF, 0xF0, 0x3F, 0xFE, 0xF3, 0x0F, 0xF9,
  0xBF, 0xF0, 0x0D, 0xFF, 0xD0, 0x0F, 0xF9,
  0xBF, 0xF0, 0x08, 0xFF, 0x80, 0x0F, 0xF9,
  0x8F, 0xB0, 0x03, 0xFF, 0x30, 0x0B, 0xF7,
  0x03, 0x10, 0x00, 0x22, 0x00, 0x01, 0x30
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_004E[ 90] = { // Code 004E, LATIN CAPITAL LETTER N
  0x01, 0x20, 0x00, 0x00, 0x01, 0x20,
  0x6F, 0xF8, 0x00, 0x00, 0x1E, 0xF8,
  0xAF, 0xFF, 0x30, 0x00, 0x2F, 0xFB,
  0xBF, 0xFF, 0xC0, 0x00, 0x2F, 0xFB,
  0xBF, 0xFF, 0xF7, 0x00, 0x2F, 0xFB,
  0xBF, 0xFC, 0xFE, 0x20, 0x2F, 0xFB,
  0xBF, 0xF4, 0xEF, 0xB0, 0x2F, 0xFB,
  0xBF, 0xF2, 0x7F, 0xF5, 0x2F, 0xFB,
  0xBF, 0xF2, 0x0C, 0xFD, 0x3F, 0xFB,
  0xBF, 0xF2, 0x03, 0xFF, 0xAF, 0xFB,
  0xBF, 0xF2, 0x00, 0x8F, 0xFF, 0xFB,
  0xBF, 0xF2, 0x00, 0x0D, 0xFF, 0xFB,
  0xBF, 0xF2, 0x00, 0x04, 0xFF, 0xFA,
  0x8F, 0xE1, 0x00, 0x00, 0x9F, 0xF6,
  0x03, 0x10, 0x00, 0x00, 0x03, 0x30
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_004F[105] = { // Code 004F, LATIN CAPITAL LETTER O
  0x00, 0x00, 0x01, 0x34, 0x30, 0x00, 0x00,
  0x00, 0x03, 0xBF, 0xFF, 0xFE, 0x91, 0x00,
  0x00, 0x6F, 0xFF, 0xFF, 0xFF, 0xFE, 0x20,
  0x03, 0xFF, 0xF9, 0x32, 0x4B, 0xFF, 0xD0,
  0x0B, 0xFF, 0x80, 0x00, 0x00, 0xCF, 0xF6,
  0x0F, 0xFF, 0x10, 0x00, 0x00, 0x5F, 0xFA,
  0x2F, 0xFC, 0x00, 0x00, 0x00, 0x2F, 0xFD,
  0x4F, 0xFB, 0x00, 0x00, 0x00, 0x2F, 0xFD,
  0x2F, 0xFC, 0x00, 0x00, 0x00, 0x2F, 0xFC,
  0x0F, 0xFF, 0x10, 0x00, 0x00, 0x5F, 0xF9,
  0x0A, 0xFF, 0x70, 0x00, 0x00, 0xCF, 0xF4,
  0x03, 0xFF, 0xF8, 0x22, 0x3B, 0xFF, 0xC0,
  0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xFD, 0x20,
  0x00, 0x05, 0xDF, 0xFF, 0xFF, 0x91, 0x00,
  0x00, 0x00, 0x02, 0x44, 0x31, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0050[ 84] = { // Code 0050, LATIN CAPITAL LETTER P
  0x3D, 0xFF, 0xFF, 0xFD, 0xA3, 0x00,
  0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0x40,
  0x9F, 0xF9, 0x66, 0x6B, 0xFF, 0xC0,
  0x9F, 0xF6, 0x00, 0x00, 0xEF, 0xF1,
  0x9F, 0xF6, 0x00, 0x00, 0xEF, 0xF1,
  0x9F, 0xF6, 0x00, 0x18, 0xFF, 0xD0,
  0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0x60,
  0x9F, 0xFF, 0xFF, 0xFF, 0xE6, 0x00,
  0x9F, 0xF8, 0x44, 0x43, 0x00, 0x00,
  0x9F, 0xF6, 0x00, 0x00, 0x00, 0x00,
  0x9F, 0xF6, 0x00, 0x00, 0x00, 0x00,
  0x9F, 0xF5, 0x00, 0x00, 0x00, 0x00,
  0x6F, 0xE2, 0x00, 0x00, 0x00, 0x00,
  0x03, 0x20, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0051[105] = { // Code 0051, LATIN CAPITAL LETTER Q
  0x00, 0x00, 0x01, 0x34, 0x30, 0x00, 0x00,
  0x00, 0x03, 0xBF, 0xFF, 0xFE, 0x91, 0x00,
  0x00, 0x6F, 0xFF, 0xFF, 0xFF, 0xFE, 0x20,
  0x03, 0xFF, 0xF9, 0x32, 0x4B, 0xFF, 0xD0,
  0x0B, 0xFF, 0x80, 0x00, 0x00, 0xCF, 0xF6,
  0x0F, 0xFF, 0x10, 0x00, 0x00, 0x5F, 0xFA,
  0x2F, 0xFC, 0x00, 0x00, 0x00, 0x2F, 0xFD,
  0x4F, 0xFB, 0x00, 0x00, 0x00, 0x2F, 0xFD,
  0x2F, 0xFC, 0x00, 0x00, 0x00, 0x2F, 0xFC,
  0x0F, 0xFF, 0x10, 0x04, 0xB2, 0x5F, 0xF9,
  0x0A, 0xFF, 0x70, 0x09, 0xFE, 0xCF, 0xF4,
  0x03, 0xFF, 0xF8, 0x23, 0xCF, 0xFF, 0xC0,
  0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0x60,
  0x00, 0x05, 0xDF, 0xFF, 0xFF, 0xBF, 0xF4,
  0x00, 0x00, 0x02, 0x44, 0x30, 0x08, 0xF4
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0052[ 84] = { // Code 0052, LATIN CAPITAL LETTER R
  0x3D, 0xFF, 0xFF, 0xFE, 0xC7, 0x10,
  0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xB0,
  0x9F, 0xF9, 0x66, 0x67, 0xEF, 0xF4,
  0x9F, 0xF6, 0x00, 0x00, 0x9F, 0xF7,
  0x9F, 0xF6, 0x00, 0x00, 0x8F, 0xF5,
  0x9F, 0xF8, 0x44, 0x46, 0xEF, 0xD0,
  0x9F, 0xFF, 0xFF, 0xFF, 0xFC, 0x20,
  0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0x70,
  0x9F, 0xF6, 0x00, 0x06, 0xFF, 0xE0,
  0x9F, 0xF6, 0x00, 0x00, 0xDF, 0xF0,
  0x9F, 0xF6, 0x00, 0x00, 0xBF, 0xF1,
  0x9F, 0xF5, 0x00, 0x00, 0xBF, 0xF5,
  0x6F, 0xE2, 0x00, 0x00, 0x5F, 0xF4,
  0x03, 0x20, 0x00, 0x00, 0x03, 0x20
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0053[ 90] = { // Code 0053, LATIN CAPITAL LETTER S
  0x00, 0x00, 0x24, 0x41, 0x00, 0x00,
  0x00, 0x5D, 0xFF, 0xFF, 0xC4, 0x00,
  0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0x70,
  0x0E, 0xFE, 0x40, 0x16, 0xEF, 0xF0,
  0x2F, 0xFA, 0x00, 0x00, 0x4D, 0x90,
  0x1F, 0xFF, 0x72, 0x00, 0x00, 0x00,
  0x0B, 0xFF, 0xFF, 0xDA, 0x61, 0x00,
  0x01, 0xAF, 0xFF, 0xFF, 0xFE, 0x50,
  0x00, 0x01, 0x69, 0xDF, 0xFF, 0xF2,
  0x01, 0x10, 0x00, 0x02, 0xCF, 0xF7,
  0x2E, 0xF4, 0x00, 0x00, 0x6F, 0xF7,
  0x2F, 0xFE, 0x40, 0x02, 0xDF, 0xF5,
  0x09, 0xFF, 0xFE, 0xDF, 0xFF, 0xC0,
  0x00, 0x6D, 0xFF, 0xFF, 0xF9, 0x10,
  0x00, 0x00, 0x34, 0x43, 0x10, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0054[ 84] = { // Code 0054, LATIN CAPITAL LETTER T
  0x6E, 0xFF, 0xFF, 0xFF, 0xFF, 0xE7,
  0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB,
  0x27, 0x77, 0xBF, 0xFB, 0x77, 0x72,
  0x00, 0x00, 0x7F, 0xF7, 0x00, 0x00,
  0x00, 0x00, 0x7F, 0xF7, 0x00, 0x00,
  0x00, 0x00, 0x7F, 0xF7, 0x00, 0x00,
  0x00, 0x00, 0x7F, 0xF7, 0x00, 0x00,
  0x00, 0x00, 0x7F, 0xF7, 0x00, 0x00,
  0x00, 0x00, 0x7F, 0xF7, 0x00, 0x00,
  0x00, 0x00, 0x7F, 0xF7, 0x00, 0x00,
  0x00, 0x00, 0x7F, 0xF7, 0x00, 0x00,
  0x00, 0x00, 0x7F, 0xF7, 0x00, 0x00,
  0x00, 0x00, 0x4F, 0xF4, 0x00, 0x00,
  0x00, 0x00, 0x02, 0x20, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0055[ 90] = { // Code 0055, LATIN CAPITAL LETTER U
  0x02, 0x10, 0x00, 0x00, 0x01, 0x20,
  0x6F, 0xE2, 0x00, 0x00, 0x2E, 0xF6,
  0x9F, 0xF5, 0x00, 0x00, 0x5F, 0xF9,
  0x9F, 0xF6, 0x00, 0x00, 0x6F, 0xF9,
  0x9F, 0xF6, 0x00, 0x00, 0x6F, 0xF9,
  0x9F, 0xF6, 0x00, 0x00, 0x6F, 0xF9,
  0x9F, 0xF6, 0x00, 0x00, 0x6F, 0xF9,
  0x9F, 0xF6, 0x00, 0x00, 0x6F, 0xF9,
  0x9F, 0xF6, 0x00, 0x00, 0x6F, 0xF9,
  0x9F, 0xF6, 0x00, 0x00, 0x6F, 0xF9,
  0x7F, 0xF7, 0x00, 0x00, 0x7F, 0xF8,
  0x3F, 0xFE, 0x62, 0x26, 0xEF, 0xF3,
  0x0A, 0xFF, 0xFF, 0xFF, 0xFF, 0xA0,
  0x00, 0x7E, 0xFF, 0xFF, 0xE7, 0x00,
  0x00, 0x00, 0x34, 0x43, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0056[ 90] = { // Code 0056, LATIN CAPITAL LETTER V
  0x02, 0x00, 0x00, 0x00, 0x01, 0x10,
  0xAF, 0xC0, 0x00, 0x00, 0x2E, 0xF5,
  0xCF, 0xF4, 0x00, 0x00, 0x7F, 0xF7,
  0x7F, 0xF9, 0x00, 0x00, 0xCF, 0xF2,
  0x2F, 0xFD, 0x00, 0x02, 0xFF, 0xB0,
  0x0B, 0xFF, 0x30, 0x07, 0xFF, 0x60,
  0x06, 0xFF, 0x70, 0x0B, 0xFF, 0x10,
  0x01, 0xFF, 0xB0, 0x1F, 0xFA, 0x00,
  0x00, 0xAF, 0xF1, 0x6F, 0xF5, 0x00,
  0x00, 0x5F, 0xF6, 0xBF, 0xE0, 0x00,
  0x00, 0x0E, 0xFB, 0xFF, 0x80, 0x00,
  0x00, 0x09, 0xFF, 0xFF, 0x30, 0x00,
  0x00, 0x04, 0xFF, 0xFD, 0x00, 0x00,
  0x00, 0x00, 0xCF, 0xF6, 0x00, 0x00,
  0x00, 0x00, 0x03, 0x20, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0057[135] = { // Code 0057, LATIN CAPITAL LETTER W
  0x02, 0x00, 0x00, 0x01, 0x20, 0x00, 0x00, 0x11, 0x00,
  0xAF, 0xC0, 0x00, 0x2E, 0xFB, 0x00, 0x01, 0xEF, 0x50,
  0xCF, 0xF1, 0x00, 0x6F, 0xFF, 0x10, 0x05, 0xFF, 0x70,
  0x8F, 0xF4, 0x00, 0x9F, 0xFF, 0x40, 0x08, 0xFF, 0x30,
  0x4F, 0xF7, 0x00, 0xCF, 0xFF, 0x80, 0x0B, 0xFE, 0x00,
  0x1F, 0xFA, 0x01, 0xFF, 0xAF, 0xB0, 0x0E, 0xFB, 0x00,
  0x0C, 0xFD, 0x05, 0xFE, 0x4F, 0xF0, 0x3F, 0xF7, 0x00,
  0x08, 0xFF, 0x18, 0xFA, 0x0F, 0xF3, 0x6F, 0xF3, 0x00,
  0x04, 0xFF, 0x4B, 0xF7, 0x0B, 0xF7, 0x9F, 0xE0, 0x00,
  0x00, 0xFF, 0x8F, 0xF3, 0x08, 0xFA, 0xCF, 0xA0, 0x00,
  0x00, 0xBF, 0xDF, 0xE0, 0x04, 0xFE, 0xFF, 0x70, 0x00,
  0x00, 0x7F, 0xFF, 0xA0, 0x01, 0xFF, 0xFF, 0x20, 0x00,
  0x00, 0x4F, 0xFF, 0x70, 0x00, 0xCF, 0xFE, 0x00, 0x00,
  0x00, 0x0C, 0xFE, 0x20, 0x00, 0x6F, 0xF8, 0x00, 0x00,
  0x00, 0x01, 0x41, 0x00, 0x00, 0x03, 0x30, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0058[ 90] = { // Code 0058, LATIN CAPITAL LETTER X
  0x01, 0x10, 0x00, 0x00, 0x11, 0x00,
  0x3F, 0xF3, 0x00, 0x04, 0xFF, 0x20,
  0x5F, 0xFC, 0x00, 0x0D, 0xFF, 0x30,
  0x0D, 0xFF, 0x60, 0x8F, 0xFA, 0x00,
  0x03, 0xFF, 0xE3, 0xFF, 0xD1, 0x00,
  0x00, 0x8F, 0xFF, 0xFF, 0x40, 0x00,
  0x00, 0x0D, 0xFF, 0xF9, 0x00, 0x00,
  0x00, 0x07, 0xFF, 0xF3, 0x00, 0x00,
  0x00, 0x2F, 0xFF, 0xFC, 0x00, 0x00,
  0x00, 0xCF, 0xFD, 0xFF, 0x70, 0x00,
  0x07, 0xFF, 0xB2, 0xFF, 0xF3, 0x00,
  0x3F, 0xFF, 0x20, 0x8F, 0xFC, 0x00,
  0xAF, 0xF7, 0x00, 0x0D, 0xFF, 0x60,
  0xAF, 0xC0, 0x00, 0x05, 0xFF, 0x40,
  0x03, 0x10, 0x00, 0x00, 0x32, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0059[ 90] = { // Code 0059, LATIN CAPITAL LETTER Y
  0x02, 0x10, 0x00, 0x00, 0x02, 0x00,
  0x9F, 0xC0, 0x00, 0x00, 0xBF, 0x90,
  0xBF, 0xF7, 0x00, 0x05, 0xFF, 0xC0,
  0x4F, 0xFE, 0x10, 0x0D, 0xFF, 0x40,
  0x0A, 0xFF, 0x80, 0x6F, 0xFA, 0x00,
  0x01, 0xEF, 0xF2, 0xEF, 0xE2, 0x00,
  0x00, 0x7F, 0xFE, 0xFF, 0x70, 0x00,
  0x00, 0x0C, 0xFF, 0xFD, 0x00, 0x00,
  0x00, 0x03, 0xFF, 0xF4, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0xCF, 0xC0, 0x00, 0x00,
  0x00, 0x00, 0x03, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_005A[ 78] = { // Code 005A, LATIN CAPITAL LETTER Z
  0x09, 0xFF, 0xFF, 0xFF, 0xFF, 0xE6,
  0x0E, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA,
  0x03, 0x77, 0x77, 0x7B, 0xFF, 0xF4,
  0x00, 0x00, 0x00, 0x3E, 0xFF, 0x60,
  0x00, 0x00, 0x01, 0xDF, 0xF8, 0x00,
  0x00, 0x00, 0x0C, 0xFF, 0xB0, 0x00,
  0x00, 0x00, 0xAF, 0xFC, 0x10, 0x00,
  0x00, 0x07, 0xFF, 0xE2, 0x00, 0x00,
  0x00, 0x5F, 0xFF, 0x30, 0x00, 0x00,
  0x03, 0xFF, 0xF5, 0x00, 0x00, 0x00,
  0x2E, 0xFF, 0xD7, 0x77, 0x77, 0x72,
  0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB,
  0x3D, 0xFF, 0xFF, 0xFF, 0xFF, 0xF7
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_005B[ 51] = { // Code 005B, LEFT SQUARE BRACKET
  0x3D, 0xFF, 0xE2,
  0x7F, 0xFF, 0xE2,
  0x7F, 0xF0, 0x00,
  0x7F, 0xF0, 0x00,
  0x7F, 0xF0, 0x00,
  0x7F, 0xF0, 0x00,
  0x7F, 0xF0, 0x00,
  0x7F, 0xF0, 0x00,
  0x7F, 0xF0, 0x00,
  0x7F, 0xF0, 0x00,
  0x7F, 0xF0, 0x00,
  0x7F, 0xF0, 0x00,
  0x7F, 0xF0, 0x00,
  0x7F, 0xF0, 0x00,
  0x7F, 0xF9, 0x91,
  0x4F, 0xFF, 0xF3,
  0x03, 0x66, 0x40
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_005C[ 60] = { // Code 005C, REVERSE SOLIDUS
  0x12, 0x00, 0x00, 0x00,
  0xCF, 0x10, 0x00, 0x00,
  0x9F, 0x70, 0x00, 0x00,
  0x4F, 0xC0, 0x00, 0x00,
  0x0D, 0xF3, 0x00, 0x00,
  0x07, 0xF9, 0x00, 0x00,
  0x02, 0xFE, 0x00, 0x00,
  0x00, 0xBF, 0x50, 0x00,
  0x00, 0x5F, 0xB0, 0x00,
  0x00, 0x0E, 0xF2, 0x00,
  0x00, 0x09, 0xF7, 0x00,
  0x00, 0x03, 0xFD, 0x00,
  0x00, 0x00, 0xCF, 0x40,
  0x00, 0x00, 0x6F, 0x70,
  0x00, 0x00, 0x04, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_005D[ 51] = { // Code 005D, RIGHT SQUARE BRACKET
  0xBF, 0xFE, 0x60,
  0xCF, 0xFF, 0xB0,
  0x00, 0x9F, 0xB0,
  0x00, 0x9F, 0xB0,
  0x00, 0x9F, 0xB0,
  0x00, 0x9F, 0xB0,
  0x00, 0x9F, 0xB0,
  0x00, 0x9F, 0xB0,
  0x00, 0x9F, 0xB0,
  0x00, 0x9F, 0xB0,
  0x00, 0x9F, 0xB0,
  0x00, 0x9F, 0xB0,
  0x00, 0x9F, 0xB0,
  0x00, 0x9F, 0xB0,
  0x79, 0xDF, 0xB0,
  0xEF, 0xFF, 0x90,
  0x25, 0x64, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_005E[ 40] = { // Code 005E, CIRCUMFLEX ACCENT
  0x00, 0x03, 0x72, 0x00, 0x00,
  0x00, 0x0E, 0xFB, 0x00, 0x00,
  0x00, 0x7F, 0xFF, 0x50, 0x00,
  0x01, 0xEF, 0xAF, 0xD0, 0x00,
  0x09, 0xFB, 0x0D, 0xF6, 0x00,
  0x2F, 0xF3, 0x06, 0xFE, 0x10,
  0xAF, 0x90, 0x00, 0xCF, 0x70,
  0x69, 0x10, 0x00, 0x39, 0x50
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_005F[ 12] = { // Code 005F, LOW LINE
  0x49, 0x99, 0x99, 0x99, 0x99, 0x40,
  0x14, 0x44, 0x44, 0x44, 0x44, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0060[  8] = { // Code 0060, GRAVE ACCENT
  0x78, 0x00,
  0xEF, 0xC2,
  0x3C, 0xFE,
  0x00, 0x78
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0061[ 55] = { // Code 0061, LATIN SMALL LETTER A
  0x00, 0x05, 0x99, 0x96, 0x10,
  0x02, 0xDF, 0xFF, 0xFF, 0xE3,
  0x09, 0xFE, 0x74, 0x8F, 0xFB,
  0x04, 0xB3, 0x00, 0x0E, 0xFB,
  0x00, 0x15, 0x79, 0xCF, 0xFB,
  0x06, 0xFF, 0xFF, 0xDE, 0xFB,
  0x2F, 0xFC, 0x41, 0x0D, 0xFB,
  0x4F, 0xF6, 0x00, 0x3F, 0xFB,
  0x2F, 0xFE, 0x89, 0xEE, 0xFD,
  0x05, 0xEF, 0xFE, 0x67, 0xFE,
  0x00, 0x13, 0x30, 0x00, 0x31
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0062[ 75] = { // Code 0062, LATIN SMALL LETTER B
  0x02, 0x00, 0x00, 0x00, 0x00,
  0xCF, 0x80, 0x00, 0x00, 0x00,
  0xFF, 0x90, 0x00, 0x00, 0x00,
  0xFF, 0x90, 0x00, 0x00, 0x00,
  0xFF, 0x92, 0x89, 0x71, 0x00,
  0xFF, 0xCE, 0xFF, 0xFE, 0x20,
  0xFF, 0xFB, 0x69, 0xFF, 0xB0,
  0xFF, 0xE0, 0x00, 0xAF, 0xF2,
  0xFF, 0x90, 0x00, 0x5F, 0xF4,
  0xFF, 0x80, 0x00, 0x4F, 0xF6,
  0xFF, 0xB0, 0x00, 0x7F, 0xF3,
  0xFF, 0xF3, 0x02, 0xDF, 0xE0,
  0xFF, 0xEF, 0xDF, 0xFF, 0x70,
  0xDF, 0x6C, 0xFF, 0xF7, 0x00,
  0x13, 0x00, 0x33, 0x10, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0063[ 55] = { // Code 0063, LATIN SMALL LETTER C
  0x00, 0x05, 0x99, 0x83, 0x00,
  0x01, 0xCF, 0xFF, 0xFF, 0xA0,
  0x0B, 0xFF, 0xA6, 0xBF, 0xF3,
  0x3F, 0xF9, 0x00, 0x0B, 0xD2,
  0x6F, 0xF4, 0x00, 0x00, 0x00,
  0x7F, 0xF2, 0x00, 0x00, 0x00,
  0x5F, 0xF4, 0x00, 0x04, 0x70,
  0x2F, 0xFC, 0x10, 0x3F, 0xF4,
  0x09, 0xFF, 0xED, 0xFF, 0xE1,
  0x00, 0x8E, 0xFF, 0xFC, 0x30,
  0x00, 0x00, 0x34, 0x20, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0064[ 75] = { // Code 0064, LATIN SMALL LETTER D
  0x00, 0x00, 0x00, 0x00, 0x20,
  0x00, 0x00, 0x00, 0x08, 0xFC,
  0x00, 0x00, 0x00, 0x09, 0xFF,
  0x00, 0x00, 0x00, 0x09, 0xFF,
  0x00, 0x17, 0x98, 0x29, 0xFF,
  0x02, 0xEF, 0xFF, 0xEC, 0xFF,
  0x0B, 0xFF, 0x96, 0xBF, 0xFF,
  0x2F, 0xFA, 0x00, 0x0E, 0xFF,
  0x5F, 0xF5, 0x00, 0x09, 0xFF,
  0x6F, 0xF4, 0x00, 0x08, 0xFF,
  0x4F, 0xF7, 0x00, 0x0B, 0xFF,
  0x1E, 0xFD, 0x20, 0x3F, 0xFF,
  0x07, 0xFF, 0xFD, 0xFE, 0xFF,
  0x00, 0x7F, 0xFF, 0xC6, 0xFD,
  0x00, 0x01, 0x32, 0x00, 0x31
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0065[ 66] = { // Code 0065, LATIN SMALL LETTER E
  0x00, 0x03, 0x89, 0x95, 0x00, 0x00,
  0x00, 0xAF, 0xFF, 0xFF, 0xC1, 0x00,
  0x09, 0xFF, 0x74, 0x6E, 0xFB, 0x00,
  0x1F, 0xF8, 0x00, 0x05, 0xFF, 0x30,
  0x4F, 0xFC, 0xBB, 0xBC, 0xFF, 0x60,
  0x6F, 0xFC, 0xBB, 0xBB, 0xBB, 0x30,
  0x4F, 0xF6, 0x00, 0x00, 0x10, 0x00,
  0x0E, 0xFD, 0x20, 0x06, 0xFA, 0x00,
  0x05, 0xFF, 0xFD, 0xEF, 0xFA, 0x00,
  0x00, 0x5D, 0xFF, 0xFE, 0x91, 0x00,
  0x00, 0x00, 0x24, 0x30, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0066[ 60] = { // Code 0066, LATIN SMALL LETTER F
  0x00, 0x01, 0x42, 0x00,
  0x00, 0x6F, 0xFF, 0x50,
  0x01, 0xFF, 0xFD, 0x40,
  0x02, 0xFF, 0x80, 0x00,
  0x37, 0xFF, 0xA6, 0x10,
  0xBF, 0xFF, 0xFF, 0x70,
  0x26, 0xFF, 0xA4, 0x10,
  0x02, 0xFF, 0x70, 0x00,
  0x02, 0xFF, 0x70, 0x00,
  0x02, 0xFF, 0x70, 0x00,
  0x02, 0xFF, 0x70, 0x00,
  0x02, 0xFF, 0x70, 0x00,
  0x02, 0xFF, 0x70, 0x00,
  0x01, 0xEF, 0x60, 0x00,
  0x00, 0x13, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0067[ 70] = { // Code 0067, LATIN SMALL LETTER G
  0x00, 0x16, 0x98, 0x31, 0x96,
  0x02, 0xDF, 0xFF, 0xFA, 0xFE,
  0x0B, 0xFF, 0xA6, 0xBF, 0xFF,
  0x2F, 0xF9, 0x00, 0x0C, 0xFF,
  0x5F, 0xF5, 0x00, 0x09, 0xFF,
  0x6F, 0xF4, 0x00, 0x09, 0xFF,
  0x3F, 0xF8, 0x00, 0x0C, 0xFF,
  0x0E, 0xFF, 0x64, 0x8F, 0xFF,
  0x04, 0xFF, 0xFF, 0xFE, 0xFF,
  0x00, 0x38, 0xBA, 0x49, 0xFF,
  0x01, 0x61, 0x00, 0x0B, 0xFC,
  0x09, 0xFD, 0x32, 0x6F, 0xF7,
  0x05, 0xFF, 0xFF, 0xFF, 0xB1,
  0x00, 0x39, 0xCD, 0xB7, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0068[ 75] = { // Code 0068, LATIN SMALL LETTER H
  0x02, 0x00, 0x00, 0x00, 0x00,
  0xCF, 0x80, 0x00, 0x00, 0x00,
  0xFF, 0x90, 0x00, 0x00, 0x00,
  0xFF, 0x90, 0x00, 0x00, 0x00,
  0xFF, 0x91, 0x79, 0x83, 0x00,
  0xFF, 0xBE, 0xFF, 0xFF, 0x40,
  0xFF, 0xFD, 0x8B, 0xFF, 0xB0,
  0xFF, 0xE1, 0x00, 0xDF, 0xE0,
  0xFF, 0xA0, 0x00, 0x9F, 0xF0,
  0xFF, 0x90, 0x00, 0x9F, 0xF0,
  0xFF, 0x90, 0x00, 0x9F, 0xF0,
  0xFF, 0x90, 0x00, 0x9F, 0xF0,
  0xFF, 0x90, 0x00, 0x9F, 0xF0,
  0xCF, 0x80, 0x00, 0x8F, 0xC0,
  0x13, 0x00, 0x00, 0x03, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0069[ 30] = { // Code 0069, LATIN SMALL LETTER I
  0x04, 0x00,
  0xAF, 0xB0,
  0xCF, 0xC0,
  0x27, 0x20,
  0x49, 0x40,
  0xCF, 0xC0,
  0xDF, 0xD0,
  0xDF, 0xD0,
  0xDF, 0xD0,
  0xDF, 0xD0,
  0xDF, 0xD0,
  0xDF, 0xD0,
  0xDF, 0xD0,
  0xAF, 0xA0,
  0x04, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_006A[ 54] = { // Code 006A, LATIN SMALL LETTER J
  0x00, 0x04, 0x00,
  0x00, 0xAF, 0xB0,
  0x00, 0xCF, 0xC0,
  0x00, 0x27, 0x20,
  0x00, 0x49, 0x40,
  0x00, 0xCF, 0xC0,
  0x00, 0xDF, 0xD0,
  0x00, 0xDF, 0xD0,
  0x00, 0xDF, 0xD0,
  0x00, 0xDF, 0xD0,
  0x00, 0xDF, 0xD0,
  0x00, 0xDF, 0xD0,
  0x00, 0xDF, 0xD0,
  0x00, 0xDF, 0xD0,
  0x00, 0xDF, 0xD0,
  0x05, 0xEF, 0xB0,
  0x4F, 0xFF, 0x80,
  0x1A, 0xB7, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_006B[ 75] = { // Code 006B, LATIN SMALL LETTER K
  0x02, 0x00, 0x00, 0x00, 0x00,
  0xCF, 0x80, 0x00, 0x00, 0x00,
  0xFF, 0x90, 0x00, 0x00, 0x00,
  0xFF, 0x90, 0x00, 0x00, 0x00,
  0xFF, 0x90, 0x02, 0x93, 0x00,
  0xFF, 0x90, 0x1D, 0xFC, 0x00,
  0xFF, 0x91, 0xDF, 0xF5, 0x00,
  0xFF, 0xAB, 0xFF, 0x60, 0x00,
  0xFF, 0xFF, 0xFB, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0x40, 0x00,
  0xFF, 0xE6, 0xFF, 0xE2, 0x00,
  0xFF, 0x90, 0x6F, 0xFB, 0x00,
  0xFF, 0x90, 0x0B, 0xFF, 0x60,
  0xCF, 0x80, 0x01, 0xEF, 0x50,
  0x13, 0x00, 0x00, 0x13, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_006C[ 30] = { // Code 006C, LATIN SMALL LETTER L
  0x02, 0x00,
  0xAF, 0xA0,
  0xDF, 0xD0,
  0xDF, 0xD0,
  0xDF, 0xD0,
  0xDF, 0xD0,
  0xDF, 0xD0,
  0xDF, 0xD0,
  0xDF, 0xD0,
  0xDF, 0xD0,
  0xDF, 0xD0,
  0xDF, 0xD0,
  0xDF, 0xD0,
  0xAF, 0xA0,
  0x03, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_006D[ 88] = { // Code 006D, LATIN SMALL LETTER M
  0x59, 0x11, 0x79, 0x82, 0x03, 0x89, 0x72, 0x00,
  0xEF, 0x9D, 0xFF, 0xFE, 0x6F, 0xFF, 0xFE, 0x20,
  0xFF, 0xFC, 0x8C, 0xFF, 0xFC, 0x8C, 0xFF, 0x70,
  0xFF, 0xE1, 0x02, 0xFF, 0xD1, 0x02, 0xFF, 0x90,
  0xFF, 0xA0, 0x00, 0xFF, 0xA0, 0x00, 0xFF, 0x90,
  0xFF, 0x90, 0x00, 0xFF, 0x90, 0x00, 0xFF, 0x90,
  0xFF, 0x90, 0x00, 0xFF, 0x90, 0x00, 0xFF, 0x90,
  0xFF, 0x90, 0x00, 0xFF, 0x90, 0x00, 0xFF, 0x90,
  0xFF, 0x90, 0x00, 0xFF, 0x90, 0x00, 0xFF, 0x90,
  0xCF, 0x80, 0x00, 0xDF, 0x80, 0x00, 0xDF, 0x70,
  0x13, 0x00, 0x00, 0x13, 0x00, 0x00, 0x13, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_006E[ 55] = { // Code 006E, LATIN SMALL LETTER N
  0x59, 0x11, 0x79, 0x83, 0x00,
  0xEF, 0x8E, 0xFF, 0xFF, 0x40,
  0xFF, 0xFD, 0x8B, 0xFF, 0xB0,
  0xFF, 0xE1, 0x00, 0xDF, 0xE0,
  0xFF, 0xA0, 0x00, 0x9F, 0xF0,
  0xFF, 0x90, 0x00, 0x9F, 0xF0,
  0xFF, 0x90, 0x00, 0x9F, 0xF0,
  0xFF, 0x90, 0x00, 0x9F, 0xF0,
  0xFF, 0x90, 0x00, 0x9F, 0xF0,
  0xCF, 0x80, 0x00, 0x8F, 0xC0,
  0x13, 0x00, 0x00, 0x03, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_006F[ 66] = { // Code 006F, LATIN SMALL LETTER O
  0x00, 0x04, 0x89, 0x84, 0x00, 0x00,
  0x01, 0xBF, 0xFF, 0xFF, 0xB1, 0x00,
  0x0A, 0xFF, 0x95, 0x8F, 0xFA, 0x00,
  0x1F, 0xFA, 0x00, 0x0A, 0xFF, 0x20,
  0x5F, 0xF5, 0x00, 0x05, 0xFF, 0x50,
  0x6F, 0xF4, 0x00, 0x04, 0xFF, 0x60,
  0x4F, 0xF7, 0x00, 0x06, 0xFF, 0x40,
  0x0E, 0xFD, 0x10, 0x1D, 0xFE, 0x10,
  0x07, 0xFF, 0xEB, 0xEF, 0xF7, 0x00,
  0x00, 0x6E, 0xFF, 0xFE, 0x60, 0x00,
  0x00, 0x00, 0x34, 0x30, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0070[ 70] = { // Code 0070, LATIN SMALL LETTER P
  0x69, 0x13, 0x99, 0x61, 0x00,
  0xEF, 0xAF, 0xFF, 0xFD, 0x20,
  0xFF, 0xFB, 0x6A, 0xFF, 0xB0,
  0xFF, 0xD0, 0x00, 0xAF, 0xF2,
  0xFF, 0x90, 0x00, 0x5F, 0xF4,
  0xFF, 0x80, 0x00, 0x4F, 0xF6,
  0xFF, 0xB0, 0x00, 0x7F, 0xF3,
  0xFF, 0xF3, 0x01, 0xDF, 0xE1,
  0xFF, 0xFF, 0xDE, 0xFF, 0x80,
  0xFF, 0xAB, 0xFF, 0xF9, 0x00,
  0xFF, 0x90, 0x24, 0x10, 0x00,
  0xFF, 0x90, 0x00, 0x00, 0x00,
  0xEF, 0x90, 0x00, 0x00, 0x00,
  0x6B, 0x30, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0071[ 70] = { // Code 0071, LATIN SMALL LETTER Q
  0x00, 0x16, 0x99, 0x31, 0x96,
  0x02, 0xDF, 0xFF, 0xFA, 0xFE,
  0x0B, 0xFF, 0xA6, 0xBF, 0xFF,
  0x2F, 0xFA, 0x00, 0x0D, 0xFF,
  0x5F, 0xF5, 0x00, 0x09, 0xFF,
  0x6F, 0xF4, 0x00, 0x08, 0xFF,
  0x4F, 0xF7, 0x00, 0x0B, 0xFF,
  0x1F, 0xFD, 0x10, 0x3F, 0xFF,
  0x08, 0xFF, 0xED, 0xFF, 0xFF,
  0x00, 0x9F, 0xFF, 0xBA, 0xFF,
  0x00, 0x01, 0x42, 0x09, 0xFF,
  0x00, 0x00, 0x00, 0x09, 0xFF,
  0x00, 0x00, 0x00, 0x09, 0xFE,
  0x00, 0x00, 0x00, 0x03, 0xB6
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0072[ 44] = { // Code 0072, LATIN SMALL LETTER R
  0x49, 0x22, 0x97, 0x00,
  0xCF, 0x9E, 0xFF, 0x30,
  0xDF, 0xFF, 0xFB, 0x10,
  0xDF, 0xF5, 0x00, 0x00,
  0xDF, 0xE0, 0x00, 0x00,
  0xDF, 0xD0, 0x00, 0x00,
  0xDF, 0xD0, 0x00, 0x00,
  0xDF, 0xD0, 0x00, 0x00,
  0xDF, 0xD0, 0x00, 0x00,
  0xAF, 0xA0, 0x00, 0x00,
  0x04, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0073[ 55] = { // Code 0073, LATIN SMALL LETTER S
  0x00, 0x48, 0x99, 0x61, 0x00,
  0x0A, 0xFF, 0xFF, 0xFE, 0x30,
  0x4F, 0xFA, 0x46, 0xEF, 0x80,
  0x6F, 0xF7, 0x00, 0x27, 0x10,
  0x2F, 0xFF, 0xFB, 0x82, 0x00,
  0x04, 0xCF, 0xFF, 0xFF, 0x50,
  0x03, 0x01, 0x59, 0xEF, 0xE0,
  0x4F, 0xC1, 0x00, 0xAF, 0xF0,
  0x3F, 0xFE, 0xAB, 0xFF, 0xA0,
  0x04, 0xCF, 0xFF, 0xF9, 0x10,
  0x00, 0x01, 0x33, 0x10, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0074[ 56] = { // Code 0074, LATIN SMALL LETTER T
  0x00, 0x33, 0x00, 0x00,
  0x02, 0xFF, 0x40, 0x00,
  0x04, 0xFF, 0x60, 0x00,
  0x38, 0xFF, 0x95, 0x10,
  0xBF, 0xFF, 0xFF, 0x50,
  0x27, 0xFF, 0x94, 0x00,
  0x04, 0xFF, 0x60, 0x00,
  0x04, 0xFF, 0x60, 0x00,
  0x04, 0xFF, 0x60, 0x00,
  0x04, 0xFF, 0x60, 0x00,
  0x04, 0xFF, 0x60, 0x00,
  0x03, 0xFF, 0xEC, 0x30,
  0x00, 0xBF, 0xFF, 0x30,
  0x00, 0x02, 0x41, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0075[ 55] = { // Code 0075, LATIN SMALL LETTER U
  0x59, 0x30, 0x00, 0x39, 0x50,
  0xEF, 0x90, 0x00, 0x9F, 0xE0,
  0xFF, 0x90, 0x00, 0x9F, 0xF0,
  0xFF, 0x90, 0x00, 0x9F, 0xF0,
  0xFF, 0x90, 0x00, 0x9F, 0xF0,
  0xFF, 0x90, 0x00, 0x9F, 0xF0,
  0xFF, 0xA0, 0x00, 0xBF, 0xF0,
  0xEF, 0xE2, 0x06, 0xFF, 0xF0,
  0x9F, 0xFF, 0xEF, 0xEF, 0xF0,
  0x1C, 0xFF, 0xF9, 0x5F, 0xD0,
  0x00, 0x24, 0x10, 0x03, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0076[ 55] = { // Code 0076, LATIN SMALL LETTER V
  0x49, 0x20, 0x00, 0x29, 0x40,
  0xDF, 0xB0, 0x00, 0xBF, 0xD0,
  0xAF, 0xF1, 0x01, 0xFF, 0xA0,
  0x5F, 0xF5, 0x05, 0xFF, 0x50,
  0x0E, 0xF9, 0x09, 0xFE, 0x00,
  0x09, 0xFE, 0x0E, 0xF9, 0x00,
  0x03, 0xFF, 0x7F, 0xF3, 0x00,
  0x00, 0xDF, 0xEF, 0xD0, 0x00,
  0x00, 0x8F, 0xFF, 0x80, 0x00,
  0x00, 0x2F, 0xFF, 0x20, 0x00,
  0x00, 0x02, 0x42, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0077[ 77] = { // Code 0077, LATIN SMALL LETTER W
  0x39, 0x40, 0x01, 0x89, 0x10, 0x04, 0x93,
  0xBF, 0xB0, 0x07, 0xFF, 0x80, 0x0B, 0xFB,
  0x9F, 0xF1, 0x0B, 0xFF, 0xC0, 0x0F, 0xF9,
  0x4F, 0xF4, 0x0E, 0xFF, 0xF1, 0x3F, 0xF4,
  0x0E, 0xF7, 0x2F, 0xCC, 0xF3, 0x7F, 0xE0,
  0x0A, 0xFB, 0x5F, 0x88, 0xF7, 0xAF, 0xA0,
  0x06, 0xFE, 0x9F, 0x44, 0xFA, 0xDF, 0x60,
  0x01, 0xFF, 0xEF, 0x11, 0xFE, 0xFF, 0x10,
  0x00, 0xBF, 0xFC, 0x00, 0xCF, 0xFB, 0x00,
  0x00, 0x6F, 0xF7, 0x00, 0x7F, 0xF6, 0x00,
  0x00, 0x03, 0x30, 0x00, 0x03, 0x30, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0078[ 55] = { // Code 0078, LATIN SMALL LETTER X
  0x18, 0x70, 0x00, 0x78, 0x00,
  0x7F, 0xF4, 0x05, 0xFF, 0x30,
  0x2F, 0xFD, 0x1E, 0xFD, 0x00,
  0x07, 0xFF, 0xDF, 0xF3, 0x00,
  0x00, 0xCF, 0xFF, 0x80, 0x00,
  0x00, 0x8F, 0xFF, 0x50, 0x00,
  0x04, 0xFF, 0xFF, 0xD1, 0x00,
  0x1D, 0xFE, 0x6F, 0xF9, 0x00,
  0x8F, 0xF5, 0x0B, 0xFF, 0x30,
  0x8F, 0xB0, 0x02, 0xEF, 0x30,
  0x03, 0x00, 0x00, 0x22, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_0079[ 70] = { // Code 0079, LATIN SMALL LETTER Y
  0x39, 0x40, 0x00, 0x39, 0x30,
  0xBF, 0xD0, 0x00, 0xCF, 0xB0,
  0x8F, 0xF2, 0x01, 0xFF, 0x80,
  0x3F, 0xF7, 0x05, 0xFF, 0x30,
  0x0D, 0xFB, 0x09, 0xFD, 0x00,
  0x08, 0xFE, 0x0D, 0xF7, 0x00,
  0x03, 0xFF, 0x6F, 0xF2, 0x00,
  0x00, 0xCF, 0xEF, 0xB0, 0x00,
  0x00, 0x7F, 0xFF, 0x70, 0x00,
  0x00, 0x2F, 0xFF, 0x10, 0x00,
  0x00, 0x0C, 0xFB, 0x00, 0x00,
  0x06, 0x8F, 0xF5, 0x00, 0x00,
  0x1F, 0xFF, 0xC0, 0x00, 0x00,
  0x07, 0xB8, 0x10, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_007A[ 50] = { // Code 007A, LATIN SMALL LETTER Z
  0x03, 0x66, 0x66, 0x66, 0x50,
  0x0F, 0xFF, 0xFF, 0xFF, 0xF5,
  0x07, 0x99, 0x9B, 0xFF, 0xE1,
  0x00, 0x00, 0x1D, 0xFE, 0x30,
  0x00, 0x01, 0xDF, 0xF4, 0x00,
  0x00, 0x1B, 0xFF, 0x50, 0x00,
  0x00, 0xBF, 0xF7, 0x00, 0x00,
  0x0A, 0xFF, 0x80, 0x00, 0x00,
  0x5F, 0xFF, 0xFF, 0xFF, 0xF5,
  0x4F, 0xFF, 0xFF, 0xFF, 0xF4
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_007B[ 68] = { // Code 007B, LEFT CURLY BRACKET
  0x00, 0x6D, 0xFE, 0x30,
  0x01, 0xFF, 0xC9, 0x20,
  0x03, 0xFF, 0x40, 0x00,
  0x04, 0xFF, 0x40, 0x00,
  0x04, 0xFF, 0x40, 0x00,
  0x04, 0xFF, 0x40, 0x00,
  0x04, 0xFF, 0x30, 0x00,
  0x8D, 0xFB, 0x00, 0x00,
  0xDF, 0xE7, 0x00, 0x00,
  0x06, 0xFF, 0x10, 0x00,
  0x04, 0xFF, 0x40, 0x00,
  0x04, 0xFF, 0x40, 0x00,
  0x04, 0xFF, 0x40, 0x00,
  0x03, 0xFF, 0x40, 0x00,
  0x02, 0xFF, 0x95, 0x00,
  0x00, 0xBF, 0xFF, 0x40,
  0x00, 0x03, 0x55, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_007C[ 30] = { // Code 007C, VERTICAL LINE
  0x02, 0x20,
  0x1E, 0xE1,
  0x2F, 0xF2,
  0x2F, 0xF2,
  0x2F, 0xF2,
  0x2F, 0xF2,
  0x2F, 0xF2,
  0x2F, 0xF2,
  0x2F, 0xF2,
  0x2F, 0xF2,
  0x2F, 0xF2,
  0x2F, 0xF2,
  0x2F, 0xF2,
  0x1F, 0xF1,
  0x02, 0x20
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_007D[ 68] = { // Code 007D, RIGHT CURLY BRACKET
  0xCF, 0xEA, 0x00, 0x00,
  0x8B, 0xFF, 0x60, 0x00,
  0x00, 0xDF, 0x70, 0x00,
  0x00, 0xDF, 0x70, 0x00,
  0x00, 0xDF, 0x70, 0x00,
  0x00, 0xDF, 0x70, 0x00,
  0x00, 0xDF, 0x80, 0x00,
  0x00, 0x7F, 0xEA, 0x10,
  0x00, 0x3C, 0xFF, 0x30,
  0x00, 0xCF, 0xA0, 0x00,
  0x00, 0xDF, 0x70, 0x00,
  0x00, 0xDF, 0x70, 0x00,
  0x00, 0xDF, 0x70, 0x00,
  0x00, 0xDF, 0x70, 0x00,
  0x36, 0xFF, 0x70, 0x00,
  0xEF, 0xFE, 0x20, 0x00,
  0x36, 0x41, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontRounded22_007E[ 24] = { // Code 007E, TILDE
  0x02, 0xAB, 0x83, 0x00, 0x38, 0x00,
  0x0D, 0xFF, 0xFF, 0xBA, 0xFF, 0x00,
  0x4F, 0xC6, 0xAF, 0xFF, 0xF9, 0x00,
  0x06, 0x10, 0x01, 0x79, 0x50, 0x00
};

GUI_CONST_STORAGE GUI_CHARINFO_EXT GUI_FontRounded22_CharInfo[95] = {
   {   1,   1,   0,  18,   6, acGUI_FontRounded22_0020 } // Code 0020, SPACE
  ,{   4,  15,   1,   4,   6, acGUI_FontRounded22_0021 } // Code 0021, EXCLAMATION MARK
  ,{   7,   7,   1,   4,  10, acGUI_FontRounded22_0022 } // Code 0022, QUOTATION MARK
  ,{  11,  14,   0,   5,  11, acGUI_FontRounded22_0023 } // Code 0023, NUMBER SIGN
  ,{  11,  16,   0,   4,  11, acGUI_FontRounded22_0024 } // Code 0024, DOLLAR SIGN
  ,{  16,  15,   1,   4,  18, acGUI_FontRounded22_0025 } // Code 0025, PERCENT SIGN
  ,{  13,  15,   0,   4,  13, acGUI_FontRounded22_0026 } // Code 0026, AMPERSAND
  ,{   3,   7,   1,   4,   6, acGUI_FontRounded22_0027 } // Code 0027, APOSTROPHE
  ,{   5,  18,   1,   4,   6, acGUI_FontRounded22_0028 } // Code 0028, LEFT PARENTHESIS
  ,{   5,  18,   0,   4,   6, acGUI_FontRounded22_0029 } // Code 0029, RIGHT PARENTHESIS
  ,{   8,   8,   0,   4,   8, acGUI_FontRounded22_002A } // Code 002A, ASTERISK
  ,{  11,  11,   0,   7,  11, acGUI_FontRounded22_002B } // Code 002B, PLUS SIGN
  ,{   4,   6,   1,  15,   6, acGUI_FontRounded22_002C } // Code 002C, COMMA
  ,{   7,   4,   0,  11,   7, acGUI_FontRounded22_002D } // Code 002D, HYPHEN-MINUS
  ,{   4,   4,   1,  15,   6, acGUI_FontRounded22_002E } // Code 002E, FULL STOP
  ,{   7,  15,   0,   4,   7, acGUI_FontRounded22_002F } // Code 002F, SOLIDUS
  ,{  11,  14,   0,   5,  11, acGUI_FontRounded22_0030 } // Code 0030, DIGIT ZERO
  ,{   7,  14,  -1,   5,   7, acGUI_FontRounded22_0031 } // Code 0031, DIGIT ONE
  ,{  11,  13,   0,   5,  11, acGUI_FontRounded22_0032 } // Code 0032, DIGIT TWO
  ,{  10,  14,   0,   5,  11, acGUI_FontRounded22_0033 } // Code 0033, DIGIT THREE
  ,{  11,  14,   0,   5,  11, acGUI_FontRounded22_0034 } // Code 0034, DIGIT FOUR
  ,{  10,  14,   0,   5,  11, acGUI_FontRounded22_0035 } // Code 0035, DIGIT FIVE
  ,{  11,  14,   0,   5,  11, acGUI_FontRounded22_0036 } // Code 0036, DIGIT SIX
  ,{  10,  14,   0,   5,  10, acGUI_FontRounded22_0037 } // Code 0037, DIGIT SEVEN
  ,{  11,  14,   0,   5,  11, acGUI_FontRounded22_0038 } // Code 0038, DIGIT EIGHT
  ,{  11,  14,   0,   5,  11, acGUI_FontRounded22_0039 } // Code 0039, DIGIT NINE
  ,{   4,  11,   1,   8,   6, acGUI_FontRounded22_003A } // Code 003A, COLON
  ,{   4,  13,   1,   8,   6, acGUI_FontRounded22_003B } // Code 003B, SEMICOLON
  ,{  11,  10,   0,   8,  11, acGUI_FontRounded22_003C } // Code 003C, LESS-THAN SIGN
  ,{  11,   8,   0,   9,  11, acGUI_FontRounded22_003D } // Code 003D, EQUALS SIGN
  ,{  11,  10,   0,   8,  11, acGUI_FontRounded22_003E } // Code 003E, GREATER-THAN SIGN
  ,{  10,  15,   0,   4,  10, acGUI_FontRounded22_003F } // Code 003F, QUESTION MARK
  ,{  14,  15,   0,   4,  14, acGUI_FontRounded22_0040 } // Code 0040, COMMERCIAL AT
  ,{  12,  15,   0,   4,  12, acGUI_FontRounded22_0041 } // Code 0041, LATIN CAPITAL LETTER A
  ,{  12,  13,   1,   5,  13, acGUI_FontRounded22_0042 } // Code 0042, LATIN CAPITAL LETTER B
  ,{  12,  15,   1,   4,  13, acGUI_FontRounded22_0043 } // Code 0043, LATIN CAPITAL LETTER C
  ,{  12,  13,   1,   5,  14, acGUI_FontRounded22_0044 } // Code 0044, LATIN CAPITAL LETTER D
  ,{  11,  13,   1,   5,  12, acGUI_FontRounded22_0045 } // Code 0045, LATIN CAPITAL LETTER E
  ,{  11,  14,   1,   5,  11, acGUI_FontRounded22_0046 } // Code 0046, LATIN CAPITAL LETTER F
  ,{  13,  15,   1,   4,  15, acGUI_FontRounded22_0047 } // Code 0047, LATIN CAPITAL LETTER G
  ,{  12,  15,   1,   4,  14, acGUI_FontRounded22_0048 } // Code 0048, LATIN CAPITAL LETTER H
  ,{   4,  15,   1,   4,   6, acGUI_FontRounded22_0049 } // Code 0049, LATIN CAPITAL LETTER I
  ,{   9,  15,   0,   4,  10, acGUI_FontRounded22_004A } // Code 004A, LATIN CAPITAL LETTER J
  ,{  12,  15,   1,   4,  12, acGUI_FontRounded22_004B } // Code 004B, LATIN CAPITAL LETTER K
  ,{  10,  14,   1,   4,  11, acGUI_FontRounded22_004C } // Code 004C, LATIN CAPITAL LETTER L
  ,{  14,  15,   1,   4,  16, acGUI_FontRounded22_004D } // Code 004D, LATIN CAPITAL LETTER M
  ,{  12,  15,   1,   4,  14, acGUI_FontRounded22_004E } // Code 004E, LATIN CAPITAL LETTER N
  ,{  14,  15,   0,   4,  15, acGUI_FontRounded22_004F } // Code 004F, LATIN CAPITAL LETTER O
  ,{  12,  14,   1,   5,  13, acGUI_FontRounded22_0050 } // Code 0050, LATIN CAPITAL LETTER P
  ,{  14,  15,   0,   4,  15, acGUI_FontRounded22_0051 } // Code 0051, LATIN CAPITAL LETTER Q
  ,{  12,  14,   1,   5,  13, acGUI_FontRounded22_0052 } // Code 0052, LATIN CAPITAL LETTER R
  ,{  12,  15,   0,   4,  12, acGUI_FontRounded22_0053 } // Code 0053, LATIN CAPITAL LETTER S
  ,{  12,  14,   0,   5,  12, acGUI_FontRounded22_0054 } // Code 0054, LATIN CAPITAL LETTER T
  ,{  12,  15,   1,   4,  14, acGUI_FontRounded22_0055 } // Code 0055, LATIN CAPITAL LETTER U
  ,{  12,  15,   0,   4,  12, acGUI_FontRounded22_0056 } // Code 0056, LATIN CAPITAL LETTER V
  ,{  17,  15,   0,   4,  17, acGUI_FontRounded22_0057 } // Code 0057, LATIN CAPITAL LETTER W
  ,{  11,  15,   0,   4,  11, acGUI_FontRounded22_0058 } // Code 0058, LATIN CAPITAL LETTER X
  ,{  11,  15,   0,   4,  11, acGUI_FontRounded22_0059 } // Code 0059, LATIN CAPITAL LETTER Y
  ,{  12,  13,   0,   5,  12, acGUI_FontRounded22_005A } // Code 005A, LATIN CAPITAL LETTER Z
  ,{   6,  17,   1,   5,   6, acGUI_FontRounded22_005B } // Code 005B, LEFT SQUARE BRACKET
  ,{   7,  15,   0,   4,   7, acGUI_FontRounded22_005C } // Code 005C, REVERSE SOLIDUS
  ,{   5,  17,   0,   5,   6, acGUI_FontRounded22_005D } // Code 005D, RIGHT SQUARE BRACKET
  ,{   9,   8,   1,   5,  11, acGUI_FontRounded22_005E } // Code 005E, CIRCUMFLEX ACCENT
  ,{  11,   2,  -1,  19,   9, acGUI_FontRounded22_005F } // Code 005F, LOW LINE
  ,{   4,   4,   0,   4,   5, acGUI_FontRounded22_0060 } // Code 0060, GRAVE ACCENT
  ,{  10,  11,   0,   8,  11, acGUI_FontRounded22_0061 } // Code 0061, LATIN SMALL LETTER A
  ,{  10,  15,   1,   4,  11, acGUI_FontRounded22_0062 } // Code 0062, LATIN SMALL LETTER B
  ,{  10,  11,   0,   8,  10, acGUI_FontRounded22_0063 } // Code 0063, LATIN SMALL LETTER C
  ,{  10,  15,   0,   4,  11, acGUI_FontRounded22_0064 } // Code 0064, LATIN SMALL LETTER D
  ,{  11,  11,   0,   8,  11, acGUI_FontRounded22_0065 } // Code 0065, LATIN SMALL LETTER E
  ,{   7,  15,   0,   4,   7, acGUI_FontRounded22_0066 } // Code 0066, LATIN SMALL LETTER F
  ,{  10,  14,   0,   8,  11, acGUI_FontRounded22_0067 } // Code 0067, LATIN SMALL LETTER G
  ,{   9,  15,   1,   4,  11, acGUI_FontRounded22_0068 } // Code 0068, LATIN SMALL LETTER H
  ,{   3,  15,   1,   4,   5, acGUI_FontRounded22_0069 } // Code 0069, LATIN SMALL LETTER I
  ,{   5,  18,  -1,   4,   5, acGUI_FontRounded22_006A } // Code 006A, LATIN SMALL LETTER J
  ,{   9,  15,   1,   4,  10, acGUI_FontRounded22_006B } // Code 006B, LATIN SMALL LETTER K
  ,{   3,  15,   1,   4,   5, acGUI_FontRounded22_006C } // Code 006C, LATIN SMALL LETTER L
  ,{  15,  11,   1,   8,  17, acGUI_FontRounded22_006D } // Code 006D, LATIN SMALL LETTER M
  ,{   9,  11,   1,   8,  11, acGUI_FontRounded22_006E } // Code 006E, LATIN SMALL LETTER N
  ,{  11,  11,   0,   8,  11, acGUI_FontRounded22_006F } // Code 006F, LATIN SMALL LETTER O
  ,{  10,  14,   1,   8,  11, acGUI_FontRounded22_0070 } // Code 0070, LATIN SMALL LETTER P
  ,{  10,  14,   0,   8,  11, acGUI_FontRounded22_0071 } // Code 0071, LATIN SMALL LETTER Q
  ,{   7,  11,   1,   8,   7, acGUI_FontRounded22_0072 } // Code 0072, LATIN SMALL LETTER R
  ,{   9,  11,   0,   8,  10, acGUI_FontRounded22_0073 } // Code 0073, LATIN SMALL LETTER S
  ,{   7,  14,   0,   5,   7, acGUI_FontRounded22_0074 } // Code 0074, LATIN SMALL LETTER T
  ,{   9,  11,   1,   8,  11, acGUI_FontRounded22_0075 } // Code 0075, LATIN SMALL LETTER U
  ,{   9,  11,   0,   8,   9, acGUI_FontRounded22_0076 } // Code 0076, LATIN SMALL LETTER V
  ,{  14,  11,   0,   8,  14, acGUI_FontRounded22_0077 } // Code 0077, LATIN SMALL LETTER W
  ,{   9,  11,   0,   8,   9, acGUI_FontRounded22_0078 } // Code 0078, LATIN SMALL LETTER X
  ,{   9,  14,   0,   8,   9, acGUI_FontRounded22_0079 } // Code 0079, LATIN SMALL LETTER Y
  ,{  10,  10,   0,   8,  10, acGUI_FontRounded22_007A } // Code 007A, LATIN SMALL LETTER Z
  ,{   7,  17,   0,   5,   6, acGUI_FontRounded22_007B } // Code 007B, LEFT CURLY BRACKET
  ,{   4,  15,   0,   4,   4, acGUI_FontRounded22_007C } // Code 007C, VERTICAL LINE
  ,{   7,  17,   0,   5,   6, acGUI_FontRounded22_007D } // Code 007D, RIGHT CURLY BRACKET
  ,{  11,   4,   0,  11,  11, acGUI_FontRounded22_007E } // Code 007E, TILDE
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_FontRounded22_Prop1 = {
  0x0020,                                   // First character
  0x007E,                                   // Last character
  &GUI_FontRounded22_CharInfo[0],           // Address of first character
  (GUI_CONST_STORAGE GUI_FONT_PROP_EXT *)0  // Pointer to next GUI_FONT_PROP_EXT
};

GUI_CONST_STORAGE GUI_FONT GUI_FontRounded22 = {
  GUI_FONTTYPE_PROP_AA4_EXT,     // Type of font
  22,                            // Height of font
  22,                            // Space of font y
  1,                             // Magnification x
  1,                             // Magnification y
  { &GUI_FontRounded22_Prop1 },
  22,                            // Baseline
  11,                            // Height of lowercase characters
  15                             // Height of capital characters
};

/*********************************************************************
*
*       _bmSeggerLogo50
*/
static GUI_CONST_STORAGE GUI_COLOR _ColorsSeggerLogo50[] = {
  0xFFFFFF, 0xFFFFFF, 0x201F23, 0x979698,
  0xBE6767, 0xB85858, 0x949495, 0xA02020,
  0xECD3D3, 0xC0BFC0, 0x909092, 0x1C1B1E,
  0x444346, 0xA12323, 0xA42A2A, 0xA83333,
  0x939394, 0xAAA9AB, 0xEED6D6, 0xFDFAFA,
  0xFDFDFD, 0xFFFEFE, 0x7E7D7F, 0xBB5F5F,
  0xBD6464, 0x858486, 0x9E9E9F, 0xA2A2A3,
  0xC2C2C3, 0xFEFEFE, 0x1B1B1E, 0x212024,
  0x252427, 0x2C2B2F, 0x5A595C, 0x6D6C6F,
  0xA22424, 0xA32828, 0xA42828, 0xA52C2C,
  0xAB3939, 0xAD3F3F, 0xAE4141, 0xAE4242,
  0xB04646, 0xB24A4A, 0xB55151, 0xC06A6A,
  0xC37171, 0xC67979, 0xC87E7E, 0xC87F7F,
  0x929193, 0xA4A4A6, 0xA9A9AB, 0xB9B9BA,
  0xBABABB, 0xBDBDBE, 0xCA8383, 0xD09090,
  0xD19494, 0xD29595, 0xD49A9A, 0xDAA8A8,
  0xDDAFAF, 0xDDB0B0, 0xDFB3B3, 0xDFB5B5,
  0xE1B8B8, 0xBFBFC0, 0xC8C8C9, 0xCDCDCE,
  0xD3D3D4, 0xE6C4C4, 0xE9CCCC, 0xECD2D2,
  0xEED8D8, 0xEFD9D9, 0xF1DFDF, 0xE8E8E8,
  0xECECEC, 0xF4E4E4, 0xF4E6E6, 0xF5E6E6,
  0xF6EAEA, 0xF0F0F0, 0xF5F5F5, 0xF9F0F0,
  0xF9F1F1, 0xFAF3F3, 0xFBF5F5, 0xFBF6F6,
  0xFBFBFB, 0xFCF8F8, 0xFEFCFC, 0xFEFDFD,
  0x070708, 0x141314, 0x242326, 0x242327,
  0x252428, 0x27262A, 0x2B2A2E, 0x313033,
  0x313034, 0x343337, 0x363539, 0x38373B,
  0x39383C, 0x3B3B3E, 0x3D3C3F, 0x3E3D40,
  0x424145, 0x49484B, 0x4A494C, 0x4A494D,
  0x4C4B4E, 0x4F4E51, 0x515053, 0x535255,
  0x555458, 0x575659, 0x5B5A5D, 0x5B5B5E,
  0x5C5B5E, 0x5D5D5F, 0x5F5F62, 0x646366,
  0x666667, 0x666568, 0x6E6E6F, 0x717173,
  0x727174, 0x767578, 0x767678, 0x777679,
  0x777779, 0xAC3C3C, 0xAC3D3D, 0xBD6565,
  0x807F81, 0x808082, 0x838284, 0x868688,
  0x878688, 0x878789, 0x8C8B8E, 0x8D8D8F,
  0x8E8E90, 0x919192, 0x939294, 0x939395,
  0x969597, 0x969698, 0x979799, 0x9D9C9E,
  0x9E9D9F, 0x9E9EA0, 0xA3A2A4, 0xA4A4A5,
  0xA5A4A6, 0xA6A6A8, 0xA7A6A8, 0xA8A7A9,
  0xA9A9AA, 0xAAAAAC, 0xABAAAC, 0xACABAD,
  0xADADAE, 0xAEAEAF, 0xAFAFB0, 0xB0AFB1,
  0xB0B0B1, 0xB4B3B5, 0xB5B4B6, 0xB6B6B7,
  0xBCBCBD, 0xBDBCBD, 0xBEBEBF, 0xDBAAAA,
  0xDCACAC, 0xC0C0C1, 0xC8C7C8, 0xCAC9CA,
  0xCCCCCD, 0xCECECF, 0xCFCFD0, 0xD1D1D2,
  0xD6D6D7, 0xD8D8D9, 0xD9D9DA, 0xDADADA,
  0xDBDBDB, 0xDCDCDC, 0xDEDDDE, 0xDEDEDE,
  0xF0DBDB, 0xF0DCDC, 0xE2E2E2, 0xE4E4E4,
  0xE5E4E5, 0xE9E9E9, 0xEAEAEB, 0xEBEBEB,
  0xECECED, 0xEEEEEE, 0xF7EDED, 0xF8EDED,
  0xF0F0F1, 0xF1F1F2, 0xF2F2F2, 0xF3F3F3,
  0xF3F3F4, 0xF4F4F4, 0xF7F7F7, 0xF8F8F8,
  0xF9F9F9, 0xFAFAFA, 0xFCFCFC
};

static GUI_CONST_STORAGE GUI_LOGPALETTE _PalSeggerLogo50 = {
  219,	// Number of entries
  1, 	// Has transparency
  &_ColorsSeggerLogo50[0]
};

static GUI_CONST_STORAGE unsigned char _acSeggerLogo50[] = {
  0x00, 0x0B, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x0B, 0x00,
  0x1E, 0x0C, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x0C, 0x1E,
  0x02, 0x10, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x10, 0x02,
  0x02, 0x06, 0x5E, 0x42, 0x13, 0x01, 0x01, 0x4B, 0x4C, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x02,
  0x02, 0x06, 0x51, 0x0D, 0x33, 0x01, 0x01, 0x2F, 0x0F, 0x53, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x02,
  0x02, 0x06, 0x01, 0x3C, 0x07, 0x43, 0x01, 0x52, 0x0F, 0x2E, 0x13, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x02,
  0x02, 0x06, 0x01, 0x5F, 0x17, 0x27, 0x4E, 0x01, 0x49, 0x0D, 0x32, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x02,
  0x02, 0x06, 0x01, 0x01, 0xCE, 0x28, 0x2D, 0x5D, 0x01, 0x3D, 0x07, 0x41, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x02,
  0x02, 0x06, 0x54, 0x5A, 0x01, 0x4A, 0x24, 0x31, 0x01, 0x15, 0x18, 0x0E, 0x4D, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x02,
  0x02, 0x06, 0x08, 0x30, 0x01, 0x01, 0x3E, 0x07, 0x40, 0x01, 0x58, 0x29, 0x2A, 0x59, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x02,
  0x02, 0x06, 0x08, 0x07, 0x3F, 0x01, 0x15, 0x18, 0x0E, 0xC5, 0x01, 0x12, 0x26, 0x2B, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
        0x05, 0x05, 0x05, 0x05, 0x3A, 0x01, 0x06, 0x02,
  0x02, 0x06, 0x08, 0x07, 0x25, 0x12, 0x01, 0x57, 0x89, 0x2C, 0x5B, 0x01, 0x44, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
        0x04, 0x04, 0x04, 0x04, 0x3B, 0x01, 0x06, 0x02,
  0x02, 0x06, 0x08, 0x07, 0x07, 0x17, 0x01, 0x01, 0xB4, 0x07, 0xB3, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x02,
  0x02, 0x06, 0x08, 0x07, 0x25, 0x12, 0x01, 0x57, 0x8A, 0x2C, 0x5B, 0x01, 0x44, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
        0x04, 0x04, 0x04, 0x04, 0x3B, 0x01, 0x06, 0x02,
  0x02, 0x06, 0x08, 0x07, 0x3F, 0x01, 0x15, 0x8B, 0x0E, 0xC4, 0x01, 0x12, 0x26, 0x2B, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
        0x05, 0x05, 0x05, 0x05, 0x3A, 0x01, 0x06, 0x02,
  0x02, 0x06, 0x08, 0x30, 0x01, 0x01, 0x3E, 0x07, 0x40, 0x01, 0x58, 0x29, 0x2A, 0x59, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x02,
  0x02, 0x06, 0x54, 0x5A, 0x01, 0x4A, 0x24, 0x31, 0x01, 0x15, 0x18, 0x0E, 0x4D, 0x01, 0xBB, 0xA2, 0x37, 0xD8, 0x01, 0xB8, 0x09, 0x09, 0x1C, 0x5C, 0x01, 0x47, 0xA1, 0xB1, 0xD9, 0x01, 0x01, 0xBD, 0xA3, 0xAF, 0xD5, 0x01, 0x4F, 0x09, 0x09, 0x09, 0xC6, 0xD1,
        0xB5, 0x09, 0x1C, 0xCB, 0x01, 0x01, 0x06, 0x02,
  0x02, 0x06, 0x01, 0x01, 0xCF, 0x28, 0x2D, 0x5D, 0x01, 0x3D, 0x07, 0x41, 0x01, 0x38, 0x6D, 0x9E, 0x81, 0x23, 0x14, 0x1F, 0x86, 0x19, 0x91, 0x55, 0x90, 0x70, 0x9A, 0x7C, 0x7A, 0x01, 0x35, 0x6A, 0x97, 0x23, 0x6E, 0x1D, 0x8C, 0x73, 0x19, 0x19, 0x39, 0x9F,
        0x6C, 0x8F, 0x84, 0x21, 0x55, 0x01, 0x06, 0x02,
  0x02, 0x06, 0x01, 0x5F, 0x17, 0x27, 0x4E, 0x01, 0x49, 0x0D, 0x32, 0x01, 0x01, 0xAD, 0x68, 0x94, 0x45, 0xCA, 0xDA, 0x02, 0x92, 0x1A, 0xA9, 0x56, 0x63, 0xBA, 0x1D, 0x4F, 0x47, 0x01, 0x6B, 0xAB, 0x01, 0xCC, 0x46, 0x1D, 0x16, 0x78, 0x1A, 0x9D, 0xC8, 0x1B,
        0x74, 0x48, 0xB2, 0x65, 0x50, 0x01, 0x06, 0x02,
  0x02, 0x06, 0x01, 0x3C, 0x07, 0x43, 0x01, 0x52, 0x0F, 0x2E, 0x13, 0x01, 0x01, 0x14, 0xB7, 0x96, 0x75, 0x6F, 0xD7, 0x02, 0x98, 0x36, 0x37, 0xD0, 0x02, 0xBE, 0xC2, 0x7D, 0x62, 0xC3, 0x67, 0x38, 0xD2, 0x7E, 0x21, 0x45, 0x16, 0x22, 0x36, 0x11, 0xC9, 0x1B,
        0x69, 0x83, 0x76, 0x77, 0x01, 0x01, 0x06, 0x02,
  0x02, 0x06, 0x51, 0x0D, 0x33, 0x01, 0x01, 0x2F, 0x0F, 0x53, 0x01, 0x01, 0x01, 0xAA, 0x72, 0x46, 0xA7, 0x66, 0x56, 0x02, 0x99, 0x11, 0xA5, 0x50, 0x7F, 0x7B, 0x1C, 0x34, 0x1F, 0xC0, 0x8E, 0x71, 0x39, 0x35, 0x64, 0xB0, 0x16, 0x22, 0x11, 0x11, 0xB6, 0x1B,
        0x79, 0x01, 0xBF, 0x02, 0xD4, 0x01, 0x06, 0x02,
  0x02, 0x06, 0x5E, 0x42, 0x13, 0x01, 0x01, 0x4B, 0x4C, 0x01, 0x01, 0x01, 0x01, 0x14, 0xA6, 0x88, 0x8D, 0x48, 0x01, 0x1A, 0x0A, 0x0A, 0x95, 0xC7, 0xD6, 0x9B, 0x85, 0x9C, 0xA0, 0xCD, 0x14, 0xA4, 0x87, 0x34, 0xAC, 0xC1, 0xB9, 0x0A, 0x0A, 0x0A, 0xAE, 0xBC,
        0xA8, 0x01, 0x5C, 0x93, 0xD3, 0x01, 0x06, 0x02,
  0x02, 0x10, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x10, 0x02,
  0x20, 0x0C, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x0C, 0x20,
  0x00, 0x0B, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x0B, 0x00
};

static GUI_CONST_STORAGE GUI_BITMAP _bmSeggerLogo50 = {
  50,                // XSize
  25,                // YSize
  50,                // BytesPerLine
  8,                 // BitsPerPixel
  _acSeggerLogo50,   // Pointer to picture data (indices)
  &_PalSeggerLogo50  // Pointer to palette
};

/*********************************************************************
*
*       bmPlatine_250x200
*/
static GUI_CONST_STORAGE unsigned long _acPlatine_250x200[] = {
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFEFEFE, 0xE4E8E8E8, 0xE8E9EBEB, 0xC2D6D8D8, 0xBAD2D4D4, 0xBAD2D4D4, 0xBAD2D4D4,
        0xC6D7D9D9, 0xC2D5D7D7, 0xBAD2D4D4, 0xC2D5DAD8, 0xBED4D9D8, 0xC2D6DBDA, 0xC2D5DAD9, 0xBAD1D5D6, 0xBED3D7D8, 0xCAD9DCE0, 0xCEDBDEE2, 0xBAD2D9DC, 0xC6D7DEE1, 0xCAD9E0E3, 0xC2D6DDE0, 0xBAD2D9DC, 0xBAD2D9DC, 0xC2D6DDE0, 0xCAD9E0E3, 0xBAD2DBDF,
        0xC2D6DFE3, 0xBED3DADD, 0xBED3DADD, 0xC6D7DCDD, 0xBED4D9DA, 0xC2D6DCDB, 0xCAD9DEDD, 0xB7CFD8DB, 0xC6D8E1E4, 0xBAD2DADA, 0xB7D0D8D8, 0xBAD2D8D7, 0xC2D5DBDA, 0xE4E7EDEC, 0xE4E7ECEA, 0xFFF8F8F8, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFF7F7F7, 0xB7CFCFCF, 0x00B8BABA, 0x00929494, 0x00828484, 0x00838585, 0x00888A8A,
        0x008E9090, 0x00888A8A, 0x00868888, 0x00919695, 0x00939897, 0x00949998, 0x00939798, 0x00929697, 0x0093969A, 0x00919498, 0x008C8F93, 0x0090979A, 0x00979EA1, 0x009AA1A4, 0x00969DA0, 0x00959C9F, 0x00989FA2, 0x00959C9F, 0x008F9699, 0x00949DA1,
        0x0098A1A5, 0x00959EA2, 0x009CA3A6, 0x009CA3A6, 0x00979C9D, 0x00979C9D, 0x008E9394, 0x008D9699, 0x00949DA0, 0x008B9497, 0x00899191, 0x00868E8E, 0x00949A99, 0x00AEB4B3, 0x8DBAC0BF, 0xFBF4F4F4, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFCFCFC, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFFFFFF, 0xFBF4F4F4, 0x91BCBCBC, 0x00B9BEBD, 0x00A8ADAC, 0x00AAAFAE, 0x00A7ACAB, 0x00A1A6A5,
        0x009EA3A2, 0x009BA09F, 0x00A9AEAD, 0x00C6CBCA, 0x00D2D6D7, 0x00D5D9DA, 0x00D6DADB, 0x00DCDFE3, 0x00D8DBDF, 0x00C2C5CA, 0x00AFB2B7, 0x00C7CCCF, 0x00D4D9DC, 0x00DCE1E4, 0x00DBE0E3, 0x00E0E5E8, 0x00E4E9EC, 0x00D5DADD, 0x00BEC3C6, 0x00C8D0D7,
        0x00C9CFD4, 0x00CAD0D5, 0x00D8DEE3, 0x00D8DDE0, 0x00D1D6D9, 0x00D1D5D6, 0x00BCC0C1, 0x00AFB8BC, 0x00B3B9BE, 0x00B0B7BA, 0x00ABB2B5, 0x00A2A7A8, 0x00A7ACAD, 0x00B2B6B7, 0x00C0C5C4, 0xF4F0F0F0, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFDFDFD, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFCFCFC, 0xFFFFFFFF, 0xFFF5F5F5, 0x85B6B6B6, 0x00ACB1B0, 0x00B4B9B8, 0x00C7CCCB, 0x00BCC1C0, 0x00AEB3B2,
        0x00A9AEAD, 0x00A7ACAB, 0x00BCC1C0, 0x00CFD4D5, 0x00EEF3F4, 0x00FAFFFF, 0x00FAFFFF, 0x00FAFFFF, 0x00F6FAFF, 0x00D4D8DD, 0x00BDC1C6, 0x00DEE1E6, 0x00F3F6FB, 0x00FBFEFF, 0x00F8FBFF, 0x00FBFEFF, 0x00FBFEFF, 0x00F8FBFF, 0x00DEE1E6, 0x00E6E9F1,
        0x00E0E3EB, 0x00E4E8ED, 0x00FBFEFF, 0x00FBFEFF, 0x00FDFEFF, 0x00FDFEFF, 0x00E7E8EC, 0x00BBBFC4, 0x00B6BABF, 0x00BABEC3, 0x00BABDC1, 0x00AEB1B5, 0x00B1B3B4, 0x00A5A7A8, 0x00B0B2B3, 0xF0EDEDED, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFCFCFC, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFCFCFC, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFBFBFB, 0xFFFFFFFF, 0xFFF8F8F8, 0x89B8B8B8, 0x00ACB1B0, 0x00B2B7B6, 0x00B9BEBD, 0x00A6ABAA, 0x00A1A6A5,
        0x00A6ABAA, 0x009DA2A1, 0x00A9AEAD, 0x00B4B9BA, 0x00E5EAEB, 0x00FAFFFF, 0x00F7FCFF, 0x00FAFFFF, 0x00E9EDF2, 0x00C7CBD0, 0x00B6BABF, 0x00C4C4CA, 0x00E9E9EF, 0x00FDFDFF, 0x00FAFAFF, 0x00F7F7FD, 0x00FCFCFF, 0x00EFEFF5, 0x00D4D4DA, 0x00B3B5BD,
        0x00B4B6BE, 0x00CDCFD7, 0x00F9F9FF, 0x00FDFDFF, 0x00FCFBFF, 0x00F7F6FA, 0x00CAC9CD, 0x00A7AAAF, 0x009A9DA2, 0x00A0A3A8, 0x00A7A8AC, 0x00A4A5A9, 0x00B0AFB1, 0x00A09FA1, 0x00B0AFB1, 0xECECECEC, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFCFCFC, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFCFCFC, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFB, 0xFFFFFFFC, 0xFFFFFFFE, 0xFFFCFCFC, 0xFFFBFBFB, 0xFFFEFFFD, 0xFFFEFFFB, 0xFFFFFFFB, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFEFFFD, 0xFFFEFFFD, 0xFFFDFEFC,
        0xFFFEFFFD, 0xFFFEFFFD, 0xFFFEFFFD, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFEFFFD, 0xFFFFFFFE,
        0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFDFFFB, 0xFFFDFFFB, 0xFFFDFFFB, 0xFFFDFFFB, 0xFFFDFFFB,
        0xFFFDFFFB, 0xFFFDFFFB, 0xFFFDFFFB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFFFB, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFEFDFF, 0xFFFDFBFF,
        0xFFFFFDFF, 0xFFFDFCFE, 0xFFFDFDFD, 0xFFFDFDFD, 0xFFFDFCFE, 0xFFFFFDFF, 0xFFFDFBFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFCFF, 0xFFFDFBFF, 0xFFFCFAFF, 0xFFFFFEFF, 0xFFFFFEFF,
        0xFFFDFCFE, 0xFFFBFAFC, 0xFFFCFCFC, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFCFBFF, 0xFFFCFBFF, 0xFFFDFCFF, 0xFFFEFDFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFEFDFF,
        0xFFFEFDFF, 0xFFFEFDFF, 0xFFFEFDFF, 0xFFFEFDFF, 0xFFFEFDFF, 0xFFFEFDFF, 0xFFFEFDFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFEFEFE, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFEFEFE, 0xFFFEFEFE, 0xFFFEFEFE, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFBFF, 0xFFFEFBFF, 0xFFFFFDFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFFFF, 0xFFF6F7F5, 0x85B7B8B6, 0x00B6BBBA, 0x00AFB4B3, 0x00B7BCBB, 0x00A6ABAA, 0x008F9493,
        0x00969B9A, 0x00A5AAA9, 0x00B0B5B4, 0x00B1B7B6, 0x00E9EFEE, 0x00F4FAF9, 0x00F3F9F8, 0x00F8FEFD, 0x00CDD3D2, 0x009BA1A0, 0x008F9594, 0x00A0A3A7, 0x00A5A8AC, 0x00EDF0F4, 0x00FBFEFF, 0x00F3F6FA, 0x00FBFEFF, 0x00CBCED2, 0x0095989C, 0x008E9392,
        0x008E9392, 0x009DA2A1, 0x00FDFFFF, 0x00F9FBFB, 0x00FDFDFD, 0x00F9F9F9, 0x00AFAFAF, 0x00A3A8A7, 0x009CA1A0, 0x00989D9C, 0x00969B9A, 0x009CA1A0, 0x00A1A6A5, 0x00A6ABAA, 0x00B5BAB9, 0xE8ECEAF0, 0xFFFFFDFF, 0xFFFFFDFF, 0xFFFFFDFF, 0xFFFCFAFF,
        0xFFFDFBFF, 0xFFFFFDFF, 0xFFFBF9FF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFEFDFF, 0xFFFEFDFF, 0xFFFDFCFE, 0xFFFEFDFF, 0xFFFEFDFF, 0xFFFEFDFF, 0xFFFEFEFE, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFDFBFF, 0xFFFFFDFF, 0xFFFFFDFF, 0xFFF8F7F9, 0xFFFFFEFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFC, 0xFFFEFFFD, 0xFFFEFEFE, 0xFFFEFDFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFFFF, 0xFFFAFAFA, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFEFDFF,
        0xFFFEFDFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFDFDFD, 0xFFFDFDFD, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFCFCFC, 0xFFFDFDFD, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFEFEFE, 0xFFFDFFFE, 0xFFFDFFFE, 0xFFFDFFFE, 0xFFFDFFFE, 0xFFFDFFFE,
        0xFFFDFFFE, 0xFFFDFFFE, 0xFFFDFFFE, 0xFFFEFDFF, 0xFFFEFDFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFDFEFA, 0xFFFCFDFB, 0xFFFDFEFC, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFFFEFF,
        0xFFFFFFFF, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFF, 0xFFFFFEFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFDFF, 0xFFFDFCFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFE,
        0xFFFFFFFE, 0xFFFEFFFD, 0xFFFFFFFC, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFEFFFB, 0xFFFEFFFB, 0xFFFDFEFA,
        0xFFFDFEFA, 0xFFFCFDF9, 0xFFFBFCF8, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFDFDFD, 0xFFFCFCFC, 0xFFFBFBFB, 0xFFFEFFFB,
        0xFFFEFFFB, 0xFFFEFFFB, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFBFAFE, 0xFFFFFEFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFFFFFE, 0xFFFFFFFC, 0xF7F6F8F2, 0x76B1B3AD, 0x00B1B6B5, 0x00A7ACAB, 0x00B3B8B7, 0x00ACB1B0, 0x00979C9B,
        0x00969B9A, 0x009EA3A2, 0x00A5AAA9, 0x00929897, 0x00A3A9A8, 0x009EA4A3, 0x009CA2A1, 0x00A0A6A5, 0x00959B9A, 0x00909695, 0x00979D9C, 0x00888C8D, 0x00939798, 0x00A3A7A8, 0x009FA3A4, 0x00A0A4A5, 0x00A9ADAE, 0x00A4A8A9, 0x00A1A5A6, 0x008C9190,
        0x00A1A6A5, 0x00A1A6A5, 0x00B9BBBB, 0x00B5B7B7, 0x00B6B6B6, 0x00AFAFAF, 0x00A7A7A7, 0x009DA2A1, 0x00A6ABAA, 0x00AEB3B2, 0x00A8ADAC, 0x00A4A9A8, 0x00A5AAA9, 0x00ABB0AF, 0x00BDC2C1, 0xF0EDEDED, 0xFFFDFDFD, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFDFEFC, 0xFFFDFEFC, 0xFFFEFFFD, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFDFEFC, 0xFFFCFCFC, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFFFFFE, 0xFFFDFEFA, 0xFFFFFFFB, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFCFBFF, 0xFFFCFBFF, 0xFFFFFDFF, 0xFFFEFCFF, 0xFFFFFDFF, 0xFFFFFDFF, 0xFFFFFDFF, 0xFFFFFDFF, 0xFFFFFDFF,
        0xFFFFFDFF, 0xFFFFFDFF, 0xFFFFFDFF, 0xFFFEFDFF, 0xFFFEFDFF, 0xFFFEFDFF, 0xFFFEFDFF, 0xFFFEFDFF, 0xFFFEFDFF, 0xFFFEFDFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFDFCFE,
        0xFFFDFCFE, 0xFFFDFCFE, 0xFFFDFCFE, 0xFFFDFCFE, 0xFFFDFCFE, 0xFFFDFCFE, 0xFFFDFCFE, 0xFFFEFDFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFEFDFF, 0xFFFDFCFE, 0xFFFCFDFF, 0xFFFCFDFF, 0xFFFCFDFF, 0xFFFDFEFF, 0xFFFDFEFF,
        0xFFFDFEFF, 0xFFFDFEFF, 0xFFFDFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFEFFFD, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFC,
        0xFFFFFFFE, 0xFFFCFDFB, 0xFFFEFFFD, 0xFFFEFFFD, 0xFFFCFDFB, 0xFFFFFFFE, 0xFFFFFFFC, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFEFFFB,
        0xFFFCFDF9, 0xFFFEFFFB, 0xFFFFFFFC, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFCFDFB, 0xFFFDFEFC, 0xFFFDFEFC, 0xFFFDFEFC, 0xFFFEFFFD, 0xFFFEFFFD, 0xFFFEFFFD, 0xFFFFFFFE, 0xFFFDFEFC,
        0xFFFDFEFC, 0xFFFDFEFC, 0xFFFDFEFC, 0xFFFDFEFC, 0xFFFDFEFC, 0xFFFDFEFC, 0xFFFDFEFC, 0xFFFEFFFB, 0xFFFEFFFB, 0xFFFEFFFB, 0xFFFEFFFB, 0xFFFEFFFB, 0xFFFEFFFB, 0xFFFEFFFB, 0xFFFEFFFB, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFC,
        0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFEFFFB, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFC,
        0xFFFFFFFC, 0xFFFEFFFB, 0xFFFEFFFB, 0xFFFDFEFA, 0xFFFCFDF9, 0xFFFBFCF8, 0xFFFAFBF7, 0xFFFDFEFC, 0xFFFFFFFE, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFB, 0xFFFCFEF8, 0xF4F5F8EF, 0x6EAFB2A9, 0x00B5BAB9, 0x00B7BCBB, 0x00B8BDBC, 0x00A4A9A8, 0x00969B9A,
        0x009DA2A1, 0x00969B9A, 0x00858A89, 0x00949998, 0x008D9291, 0x008E9392, 0x00979C9B, 0x00919695, 0x00898E8D, 0x00919695, 0x008E9392, 0x00979C9B, 0x00A8ADAC, 0x00989D9C, 0x00949998, 0x00979C9B, 0x00878C8B, 0x008B908F, 0x009A9F9E, 0x00909594,
        0x00A4A9A8, 0x00A3A8A7, 0x008C8E8E, 0x009A9C9C, 0x009D9D9D, 0x00838383, 0x00969696, 0x009DA2A1, 0x00A7ACAB, 0x00ABB0AF, 0x009DA2A1, 0x009A9F9E, 0x00A1A6A5, 0x00A4A9A8, 0x00B3B8B7, 0xF0F0F1ED, 0xFFFEFFFB, 0xFFFDFEFA, 0xFFFDFEFA, 0xFFFFFFFC,
        0xFFFDFEFA, 0xFFFCFDF9, 0xFFFBFCF8, 0xFFFEFFFD, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFEFFFD, 0xFFFDFEFC, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFBFCFA, 0xFFFEFFFB, 0xFFFEFFFA, 0xFFFCFFF6, 0xF7F8FBF2, 0xF7F9FDF2, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFCFCFC, 0xFFFBFAFC, 0xFFFFFEFF, 0xFFFFFDFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF,
        0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFDFF, 0xFFFFFDFF, 0xFFFFFDFF, 0xFFFFFDFF, 0xFFFFFDFF, 0xFFFFFCFF, 0xFFFFFCFF, 0xFFFFFCFF, 0xFFFFFEFF, 0xFFFEFDFF, 0xFFFEFDFF, 0xFFFEFDFF, 0xFFFEFDFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFCFBFF, 0xFFFCFBFF, 0xFFFCFBFF, 0xFFFDFCFF, 0xFFFEFDFF,
        0xFFFEFDFF, 0xFFFEFDFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFEFDFF, 0xFFFEFDFF, 0xFFFEFDFF, 0xFFFEFDFF, 0xFFFFFBFF, 0xFFFDF9FE, 0xFFFDF9FE, 0xFFFFFCFF, 0xFFFFFDFF, 0xFFFFFCFE, 0xFFFEFBFD, 0xFFFFFCFE, 0xFFFFFFFE,
        0xFFFFFEFD, 0xFFFFFDFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFDFF, 0xFFFFFEFD, 0xFFFFFFFE, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFFFE, 0xFFFEFEFE, 0xFFFCFCFC, 0xFFFCFCFC, 0xFFFCFCFC,
        0xFFFCFCFC, 0xFFFCFBFD, 0xFFFCFBFD, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF,
        0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFEFEFE, 0xFFFEFEFE, 0xFFFEFEFE,
        0xFFFEFEFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFEFEFE, 0xFFFEFEFE, 0xFFFEFEFE, 0xFFFEFEFE, 0xFFFEFEFE, 0xFFFEFEFE, 0xFFFEFEFE, 0xFFFFFDFF, 0xFFFFFDFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF,
        0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFCFCFC, 0xFFFFFFFF, 0xFFFFFFFE, 0xFFFBFCFA, 0xFFF8F9F7, 0x76AFB0AE, 0x00A7ACAB, 0x00B9BEBD, 0x00B3B8B7, 0x009BA09F, 0x009A9F9E,
        0x00A3A8A7, 0x009CA1A0, 0x00909594, 0x009A9F9D, 0x00868B89, 0x00818684, 0x00898E8C, 0x007F8482, 0x007E8381, 0x008C918F, 0x00858A88, 0x00959A99, 0x00989D9C, 0x00818685, 0x00888D8C, 0x008F9493, 0x00797E7D, 0x00797E7D, 0x00838887, 0x00818684,
        0x008A8F8D, 0x00A0A5A3, 0x00858886, 0x008E918F, 0x008E8F8D, 0x00787977, 0x00838482, 0x00999E9C, 0x00A2A7A5, 0x00A6ABA9, 0x00969B99, 0x009BA09E, 0x00A9AEAC, 0x00A8ADAB, 0x00B2B7B5, 0xF0EDEDED, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFEFDFF, 0xFFFEFDFF, 0xFFFEFDFF, 0xFFFAF8FE, 0xFFFFFEFF, 0xFFFDFDFD, 0xFFFFFFFE, 0xFFFEFFFB, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFE, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFCFF, 0xFFFBFAFE, 0xFFFFFFFE, 0xFFFFFFF9, 0xFFFEFFF7, 0xFFFFFFF9, 0xFFFFFFFB, 0xFFFCFDF9, 0xFFFCFEF8, 0xFFFCFEF8, 0xFFFCFEF8, 0xFFFCFEF8, 0xFFFCFEF8,
        0xFFFCFEF8, 0xFFFCFEF8, 0xFFFCFEF8, 0xFFFFFFFB, 0xFFFFFFFB, 0xFFFFFFFA, 0xFFFFFFFA, 0xFFFFFFFA, 0xFFFFFFF9, 0xFFFFFFF9, 0xFFFFFFF9, 0xFFFFFFFB, 0xFFFFFFFB, 0xFFFFFFFB, 0xFFFFFFFB, 0xFFFFFFFB, 0xFFFFFFFB, 0xFFFFFFFB, 0xFFFFFFFB, 0xFFFFFFF9,
        0xFFFFFFF9, 0xFFFFFFF9, 0xFFFFFFF9, 0xFFFFFFF9, 0xFFFFFFF9, 0xFFFFFFF9, 0xFFFFFFF9, 0xFFFFFFF9, 0xFFFDFFF7, 0xFFFBFEF5, 0xFFFCFFF6, 0xFFFEFFF8, 0xFFFFFFF9, 0xFFFFFFF9, 0xFFFFFFF9, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFC,
        0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFB, 0xFFFFFFFB, 0xFFFFFFFB, 0xFFFFFFFB, 0xFFFFFFFB, 0xFFFFFFFB, 0xFFFFFFFB, 0xFFFFFFFB, 0xFFFFFDFF, 0xFFFFFDFF, 0xFFFFFDFF, 0xFFFFFDFF, 0xFFFFFEFF, 0xFFFFFDFD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFEFA,
        0xFFFFFDFC, 0xFFFFFDFF, 0xFFFFFDFF, 0xFFFFFDFF, 0xFFFFFDFF, 0xFFFFFDFC, 0xFFFFFEFA, 0xFFFFFEFE, 0xFFFFFEFE, 0xFFFFFEFE, 0xFFFFFEFE, 0xFFFFFEFE, 0xFFFFFEFE, 0xFFFFFEFE, 0xFFFFFEFE, 0xFFFEFFFD, 0xFFFEFFFD, 0xFFFEFFFD, 0xFFFFFFFF, 0xFFFFFEFF,
        0xFFFFFEFF, 0xFFFFFEFF, 0xFFFCFBFF, 0xFFFDFCFF, 0xFFFDFCFF, 0xFFFDFCFF, 0xFFFDFCFF, 0xFFFDFCFF, 0xFFFDFCFF, 0xFFFDFCFF, 0xFFFDFCFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFEFDFF, 0xFFFDFCFF, 0xFFFEFDFF, 0xFFFEFDFF, 0xFFFEFDFF, 0xFFFFFEFF,
        0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFEFDFF, 0xFFFEFDFF, 0xFFFEFDFF, 0xFFFEFDFF, 0xFFFEFDFF, 0xFFFEFDFF, 0xFFFEFDFF, 0xFFFEFDFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF,
        0xFFFEFDFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFEFDFF, 0xFFFEFDFF, 0xFFFEFDFF, 0xFFFEFDFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFDFF, 0xFFFFFDFF, 0xFFFFFDFF, 0xFFFFFCFF, 0xFFFFFBFF, 0xFFFFFBFF, 0xFFFFFCFF, 0xFFFFFCFF, 0xFFFFFDFF,
        0xFFFFFDFF, 0xFFFFFDFF, 0xFFFFFDFF, 0xFFFEFCFF, 0xFFFDFBFF, 0xFFFDFBFF, 0xFFFCFAFF, 0xFFFFFEFF, 0xFFFCFBFD, 0xFFFCFBFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFF9F8FC, 0x5FA2A1A5, 0x00A1A6A5, 0x00B4B9B8, 0x00AEB3B2, 0x00A6ABAA, 0x00ACB1B0,
        0x00A4A9A8, 0x00A4A9A8, 0x00B9BEBD, 0x008E9391, 0x007F8482, 0x00747977, 0x00747977, 0x006F7472, 0x00747977, 0x00818684, 0x007B807E, 0x008E9391, 0x00838886, 0x00696E6C, 0x006D7270, 0x00828785, 0x007A7F7D, 0x00767B79, 0x00888D8B, 0x00989D9B,
        0x00878C8A, 0x00929795, 0x00838684, 0x00898C8A, 0x00868785, 0x00818280, 0x007B7C7A, 0x00787D7B, 0x008A8F8D, 0x009CA19F, 0x00959A98, 0x009EA3A1, 0x00A9AEAC, 0x00A0A5A3, 0x76ADB2B0, 0xECEDECF0, 0xFFFDFCFF, 0xFFFFFEFF, 0xFFFBFAFE, 0xFFFBFAFE,
        0xFFFEFDFF, 0xFFFCFBFF, 0xFFFDFCFF, 0xFFFFFDFF, 0xFFFFFDFF, 0xFFFFFDFF, 0xFFFFFDFF, 0xFFFFFDFF, 0xFFFFFDFF, 0xFFFFFDFF, 0xFFFFFDFF, 0xFFFEFAFF, 0xFFFFFDFF, 0xFFFAF9FB, 0xFFFFFFFE, 0xFFF8F9F7, 0xFFFDFCFE, 0xFFFCFAFF, 0xFFFFFBFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFBFF, 0xFFFCFBFF, 0xFFFFFFF9, 0xFFDEE4D1, 0xFFC2CBB0, 0xFFC9D2B7, 0xFFC2CBB1, 0xFFC2CAB3, 0xFFC1C9B2, 0xFFC0C8B1, 0xFFBFC7B0, 0xFFBEC6AF, 0xFFBEC6AF,
        0xFFBEC6AF, 0xFFBFC7B0, 0xFFBFC7B0, 0xFFC3C6B0, 0xFFC3C6B0, 0xFFC3C6B0, 0xFFC3C6B0, 0xFFC3C6B0, 0xFFC3C6B0, 0xFFC4C7B1, 0xFFC4C7B1, 0xFFCCD2C1, 0xFFCCD2C1, 0xFFCDD3C2, 0xFFCDD3C2, 0xFFCDD3C2, 0xFFCCD2C1, 0xFFCBD1C0, 0xFFCAD0BF, 0xFFCFD6C1,
        0xFFCFD6C1, 0xFFCFD6C1, 0xFFCFD6C1, 0xFFCFD6C1, 0xFFCFD6C1, 0xFFCFD6C1, 0xFFCFD6C1, 0xFFD3DAC5, 0xFFD1D8C3, 0xFFCFD6C1, 0xFFD1D8C3, 0xFFD5DCC7, 0xFFD9E0CB, 0xFFDAE1CC, 0xFFDAE1CC, 0xFFDEE2CF, 0xFFDEE2CF, 0xFFDEE2CF, 0xFFDEE2CF, 0xFFDEE2CF,
        0xFFDEE2CF, 0xFFDEE2CF, 0xFFDEE2CF, 0xFFDCE2CF, 0xFFDCE2CF, 0xFFDCE2CF, 0xFFDCE2CF, 0xFFDCE2CF, 0xFFDCE2CF, 0xFFDCE2CF, 0xFFDCE2CF, 0xFFE3E0DB, 0xFFE2E0D8, 0xFFE6E5DB, 0xFFEEEEE2, 0xFFF0F0E2, 0xFFEEEFDF, 0xFFEEF0DD, 0xFFF2F4E1, 0xFFF2F4E0,
        0xFFF0F0E2, 0xFFF0EEE6, 0xFFEAE6E5, 0xFFEAE6E5, 0xFFF0EEE6, 0xFFF0F0E2, 0xFFF2F4E0, 0xFFF1F2E2, 0xFFF1F2E2, 0xFFF1F2E2, 0xFFF1F2E2, 0xFFF1F2E2, 0xFFF1F2E2, 0xFFF1F2E2, 0xFFF1F2E2, 0xFFF6FCEB, 0xFFF6FCEB, 0xFFF4F9EA, 0xFFF2F6EA, 0xFFF4F8ED,
        0xFFF6F9F0, 0xFFF6F8F2, 0xFFF3F5EF, 0xFFF7FAF1, 0xFFF7FAF1, 0xFFF7FAF1, 0xFFF7FAF1, 0xFFF7FAF1, 0xFFF7FAF1, 0xFFF7FAF1, 0xFFF7FAF1, 0xFFF6F9F0, 0xFFF6F9F0, 0xFFF6F9F0, 0xFFF7FAF1, 0xFFF9FCF3, 0xFFFBFEF5, 0xFFFDFFF7, 0xFFFFFFF9, 0xFFFEFFF8,
        0xFFFEFFF8, 0xFFFEFFF8, 0xFFFEFFF8, 0xFFFEFFF8, 0xFFFEFFF8, 0xFFFEFFF8, 0xFFFEFFF8, 0xFFFFFFFB, 0xFFFFFFFB, 0xFFFFFFFB, 0xFFFFFFFB, 0xFFFFFFFB, 0xFFFFFFFB, 0xFFFFFFFB, 0xFFFFFFFB, 0xFFFAFCF6, 0xFFFAFCF6, 0xFFFAFCF6, 0xFFFBFDF7, 0xFFFCFEF8,
        0xFFFEFFFA, 0xFFFFFFFB, 0xFFFFFFFB, 0xFFFFFFFB, 0xFFFFFFFB, 0xFFFFFFFB, 0xFFFFFFFB, 0xFFFFFFFB, 0xFFFFFFFB, 0xFFFFFFFB, 0xFFFFFFFB, 0xFFFFFFF9, 0xFFFFFFF9, 0xFFFFFFF9, 0xFFFFFFF9, 0xFFFFFFF9, 0xFFFFFFF9, 0xFFFFFFF9, 0xFFFFFFF9, 0xFFFFFFFC,
        0xFFFFFFFC, 0xFFFFFFFC, 0xFFFEFFFB, 0xFFFEFFFB, 0xFFFEFFFB, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFB, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFDFEFC, 0xFFFEFFFD, 0xFFFFFFFF, 0xFFF5F5F5, 0x6EAAA9AB, 0x009FA4A3, 0x00ABB0AF, 0x009DA2A1, 0x00989D9C, 0x00A3A8A7,
        0x009DA2A1, 0x00989D9C, 0x00A2A7A6, 0x00848883, 0x00818580, 0x00777B76, 0x00757974, 0x00747873, 0x00777B76, 0x007E827D, 0x00757974, 0x007A807B, 0x00787E79, 0x00656B66, 0x00606661, 0x00797F7A, 0x00787E79, 0x006F7570, 0x00888E89, 0x00A5ABA6,
        0x008C928D, 0x007C827D, 0x00757974, 0x00818580, 0x007D7E7A, 0x007E7F7B, 0x00797A76, 0x00747A75, 0x007E847F, 0x008F9590, 0x008F9590, 0x00A1A7A2, 0x00ABB1AC, 0x009BA19C, 0x6EA9AFAA, 0xFFF9FAF6, 0xFFFEFFFB, 0xFFFFFFFC, 0xFFFDFEFA, 0xFFFCFDF9,
        0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFEFFFB, 0xFFFDFEFA, 0xFFFDFEFA, 0xFFFDFEFA, 0xFFFDFEFA, 0xFFFDFEFA, 0xFFFFFFFE, 0xFFFCFEF8, 0xFFFCFFF5, 0xFFFFFFF7, 0xFFFCFFF6, 0xFFFFFFFF, 0xFFFCF9FF, 0xFFFFFAFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFAFF, 0xFFFDFCFE, 0xF0F7FCED, 0x2698A383, 0x004F5D33, 0x00506031, 0x00425223, 0x00404F23, 0x003B491F, 0x003A481E, 0x0038461C, 0x0036441A, 0x00354319,
        0x00354319, 0x0036441A, 0x0037451B, 0x0039421A, 0x0039421A, 0x003B441C, 0x003C451D, 0x003E471F, 0x003F4820, 0x00404921, 0x00414A22, 0x00465032, 0x00485234, 0x004C5638, 0x004F593B, 0x00515B3D, 0x00525C3E, 0x00525C3E, 0x00525C3E, 0x004E5938,
        0x004E5938, 0x004E5938, 0x004E5938, 0x004E5938, 0x004E5938, 0x004E5938, 0x004E5938, 0x004E5938, 0x004C5736, 0x004B5635, 0x004D5837, 0x00505B3A, 0x00525D3C, 0x00515C3B, 0x004F5A39, 0x00515B37, 0x00505A36, 0x00505A36, 0x004F5935, 0x004F5935,
        0x004E5834, 0x004E5834, 0x004E5834, 0x004E5939, 0x004E5939, 0x00505B3B, 0x00515C3C, 0x00535E3E, 0x00545F3F, 0x00556040, 0x00566141, 0x005A6140, 0x00515835, 0x004F5732, 0x00576038, 0x005F693E, 0x005D683A, 0x00596535, 0x00596533, 0x00576234,
        0x005D663E, 0x00656B4C, 0x005E6249, 0x005E6249, 0x00656B4C, 0x005D663E, 0x00576234, 0x005A6636, 0x005A6636, 0x005A6636, 0x005A6636, 0x005A6636, 0x005A6636, 0x005A6636, 0x005A6636, 0x005A693D, 0x00616F45, 0x00647249, 0x00616E48, 0x005E6948,
        0x00606B4B, 0x00646E50, 0x00677153, 0x005E6949, 0x005E6949, 0x005E6949, 0x005E6949, 0x005E6949, 0x005E6949, 0x005E6949, 0x005E6949, 0x005E6949, 0x005E6949, 0x005E6949, 0x00606B4B, 0x00626D4D, 0x00667151, 0x00697454, 0x006B7656, 0x00687353,
        0x00687353, 0x00687353, 0x00687353, 0x00687353, 0x00687353, 0x00687353, 0x00687353, 0x00687254, 0x00687254, 0x00687254, 0x00687254, 0x00687254, 0x00687254, 0x00687254, 0x00687254, 0x00677153, 0x00677153, 0x00687254, 0x00697355, 0x006B7557,
        0x006E785A, 0x00717B5D, 0x00737D5F, 0x00747E60, 0x00737D5F, 0x00737D5F, 0x00727C5E, 0x00727C5E, 0x00717B5D, 0x00707A5C, 0x00707A5C, 0x00727859, 0x0073795A, 0x00747A5B, 0x00747A5B, 0x0073795A, 0x00717758, 0x006F7556, 0x006E7455, 0x00677056,
        0x00677056, 0x00677056, 0x00697258, 0x006B745A, 0x006F785E, 0x00737C62, 0x00757E64, 0x00778066, 0x007A8369, 0x007D856E, 0x00747B66, 0x00787E6B, 0x00767C6B, 0x047C8271, 0x00787D6E, 0x00949998, 0x00959A99, 0x00828786, 0x00787D7C, 0x007D8281,
        0x00848988, 0x00828786, 0x006F7473, 0x00737772, 0x006F736E, 0x00626661, 0x005E625D, 0x005E625D, 0x00666A65, 0x00747873, 0x00727671, 0x00636A63, 0x006A716A, 0x00616861, 0x005C635C, 0x00666D66, 0x006B726B, 0x006F766F, 0x00798079, 0x00717772,
        0x006F7570, 0x00686E69, 0x00676B66, 0x00666A65, 0x005F605C, 0x00656662, 0x006F706C, 0x006F7570, 0x00696F6A, 0x00707671, 0x00737974, 0x008C928D, 0x009AA09B, 0x008D938E, 0x67A6ACA7, 0x3198A089, 0x13889079, 0x178B937C, 0x1E8F9780, 0x22919982,
        0x359BA38C, 0x3D9EA68F, 0x41A0A891, 0x39A0A98E, 0x3DA1AA8F, 0x41A4AD92, 0x45A5AE93, 0x45A6AF94, 0x45A6AF94, 0x45A5AE93, 0x41A4AD92, 0x4CAAB398, 0x48ABB696, 0x48AEBA96, 0x4CAFBB97, 0x76C0C9AE, 0xFFFFFFF5, 0xFFFFFFFF, 0xFFFDFAFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFDF8FF, 0xFFFFFEFF, 0xF7FFFFF2, 0x13929F79, 0x00455722, 0x00566A2F, 0x0045591E, 0x003D5017, 0x003F521B, 0x003D5019, 0x00394C15, 0x00374A13, 0x00354811,
        0x00364912, 0x00384B14, 0x00394C15, 0x00404C1A, 0x00414D1B, 0x00434F1D, 0x0045511F, 0x00485422, 0x004B5725, 0x004D5927, 0x004E5A28, 0x0053603A, 0x0057643E, 0x005E6B45, 0x0064714B, 0x006A7751, 0x006E7B55, 0x006F7C56, 0x00707D57, 0x006F7D53,
        0x006F7D53, 0x006F7D53, 0x006F7D53, 0x006F7D53, 0x006F7D53, 0x006F7D53, 0x006F7D53, 0x006C7A50, 0x006A784E, 0x0069774D, 0x006A784E, 0x006B794F, 0x0069774D, 0x00647248, 0x00606E44, 0x005C693B, 0x005C693B, 0x005B683A, 0x005A6739, 0x00596638,
        0x00586537, 0x00586537, 0x00576436, 0x005C6A41, 0x005D6B42, 0x005F6D44, 0x00616F46, 0x00647249, 0x0067754C, 0x0069774E, 0x006A784F, 0x006D7C43, 0x0055642A, 0x00405013, 0x003F5011, 0x00455714, 0x00465914, 0x0044580F, 0x0043570E, 0x00425510,
        0x00556528, 0x006F7C48, 0x00727C51, 0x00727C51, 0x006F7C48, 0x00556528, 0x00425510, 0x00465A12, 0x00465A12, 0x00465A12, 0x00465A12, 0x00465A12, 0x00465A12, 0x00465A12, 0x00465A12, 0x00415716, 0x00556A2B, 0x00697E40, 0x006E8247, 0x006A7D46,
        0x00687A45, 0x006C7C4C, 0x006F7F4F, 0x00697B46, 0x00697B46, 0x00697B46, 0x00697B46, 0x00697B46, 0x00697B46, 0x00697B46, 0x00697B46, 0x006A7C47, 0x00697B46, 0x00677944, 0x00667843, 0x00657742, 0x00667843, 0x00677944, 0x00677944, 0x00657742,
        0x00657742, 0x00657742, 0x00657742, 0x00657742, 0x00657742, 0x00657742, 0x00657742, 0x00627340, 0x00627340, 0x00627340, 0x00627340, 0x00627340, 0x00627340, 0x00627340, 0x00627340, 0x00637441, 0x00627340, 0x0060713E, 0x005E6F3C, 0x005D6E3B,
        0x005E6F3C, 0x005F703D, 0x005F703D, 0x005D6E3B, 0x005D6E3B, 0x005B6C39, 0x005A6B38, 0x00586936, 0x00576835, 0x00556633, 0x00556633, 0x00576430, 0x00586531, 0x00576430, 0x0054612D, 0x004E5B27, 0x00475420, 0x003F4C18, 0x003B4814, 0x00314112,
        0x002F3F10, 0x002B3B0C, 0x00283809, 0x00263607, 0x00253506, 0x00263607, 0x00273708, 0x00253309, 0x00253309, 0x0029370E, 0x0026330D, 0x002D3915, 0x00222D0C, 0x00495434, 0x00959F81, 0x00A3A8A7, 0x00939897, 0x00858A89, 0x007E8382, 0x006C7170,
        0x00696E6D, 0x00747978, 0x00656A69, 0x00696D68, 0x00696D68, 0x00696D68, 0x006E726D, 0x00696D68, 0x00656964, 0x00696D68, 0x00616560, 0x00535A53, 0x00575E57, 0x005C635C, 0x005E655E, 0x004E554E, 0x00535A53, 0x00646B64, 0x004E554E, 0x005A605B,
        0x00595F5A, 0x005C625D, 0x00676B66, 0x00676B66, 0x00696A66, 0x00636460, 0x00646561, 0x00636964, 0x005E645F, 0x006A706B, 0x006D736E, 0x00838984, 0x00909691, 0x008F9590, 0x00B9BFBA, 0x0048562D, 0x00233108, 0x001F2D04, 0x0025330A, 0x00243209,
        0x0029370E, 0x002A380F, 0x002C3A11, 0x002D3D0D, 0x00324212, 0x00394919, 0x00415121, 0x00475727, 0x00495929, 0x004A5A2A, 0x004A5A2A, 0x00475727, 0x0051632E, 0x004E612A, 0x003D4F1A, 0x0068774B, 0xFFEAF3D8, 0xFFFFFFF8, 0xFFFCFCFC, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFB, 0xFFFFFCFF, 0xFFFAFFFF, 0x1B909C7E, 0x00535C29, 0x00595C2A, 0x00484F1C, 0x003E5013, 0x00374B1E, 0x0035491C, 0x00314419, 0x002E4017, 0x002C3E17,
        0x002B3B19, 0x002B3B19, 0x002B3A1A, 0x002A4218, 0x0030471A, 0x00374A19, 0x003C4B18, 0x00414E1A, 0x0047531F, 0x004A5622, 0x004A5624, 0x004C6529, 0x0056673C, 0x005F654C, 0x00686B55, 0x00717656, 0x006E764D, 0x0069724A, 0x006D7655, 0x006B7955,
        0x006B7955, 0x006B7955, 0x006B7A54, 0x006C7B55, 0x006C7C53, 0x006B7B52, 0x006B7B52, 0x0065794A, 0x0066774C, 0x0065734F, 0x00647151, 0x00657050, 0x00626E4A, 0x005F6B41, 0x005B683A, 0x0058652D, 0x0056632B, 0x00536028, 0x00536028, 0x00546129,
        0x0055622A, 0x00546129, 0x00536028, 0x00576629, 0x0058672E, 0x005B6735, 0x00606A3F, 0x00636E48, 0x0067714D, 0x00687352, 0x00697453, 0x00707D5D, 0x004A5933, 0x003B4C20, 0x003F521F, 0x00475B26, 0x00435625, 0x00536439, 0x0057673E, 0x00374C15,
        0x004C5F2E, 0x00708156, 0x0074825E, 0x006D7B57, 0x0071805A, 0x0048592D, 0x003B4D1E, 0x004A5C27, 0x00445621, 0x004A5C27, 0x00576934, 0x004D5F2A, 0x00465823, 0x0052642F, 0x00536530, 0x003B4F14, 0x005B6D38, 0x0077865A, 0x00727F59, 0x00707C58,
        0x0075815D, 0x006F7D53, 0x00748357, 0x0076825E, 0x00717D59, 0x00727F59, 0x006C7A51, 0x00738256, 0x006E7E4F, 0x00728252, 0x006F7F4F, 0x00728155, 0x00738256, 0x00728155, 0x006F7E52, 0x00707F53, 0x00748357, 0x00768559, 0x00748357, 0x00748258,
        0x00738157, 0x00717F55, 0x00707E54, 0x00707E54, 0x00717F55, 0x00728056, 0x00738157, 0x006C7B4F, 0x00708051, 0x00728253, 0x00718151, 0x0071824F, 0x00738550, 0x0071834E, 0x006D7F4A, 0x006F7F56, 0x00708057, 0x00728259, 0x0073835A, 0x00718158,
        0x006F7F56, 0x006E7E55, 0x006E7E55, 0x006E7C53, 0x006F7D54, 0x00707E55, 0x006F7D54, 0x006B7950, 0x0069774E, 0x0068764D, 0x0068764D, 0x0066744A, 0x0066744A, 0x00627046, 0x005A683F, 0x005F6D44, 0x005B6940, 0x0043502A, 0x003B4822, 0x0036411B,
        0x0039431F, 0x002F391B, 0x00394228, 0x00323C25, 0x00253016, 0x00323E22, 0x00324122, 0x0032401C, 0x00303E1C, 0x00323E20, 0x00374228, 0x0037402B, 0x00464E3D, 0x006F7667, 0x00B2B9AC, 0x00AEB5B8, 0x00949B9E, 0x007F8787, 0x00666E6E, 0x0058605F,
        0x005C6463, 0x005A6360, 0x005C6562, 0x005E655E, 0x00596059, 0x005C635C, 0x005F6560, 0x005D635E, 0x00606563, 0x00616664, 0x005B605E, 0x005E625C, 0x005E625C, 0x005F635D, 0x005B5F59, 0x00636761, 0x005A5E58, 0x005C605A, 0x0060645E, 0x0061665D,
        0x0062675E, 0x00676A61, 0x0063645A, 0x006A695F, 0x00706E63, 0x0069655A, 0x006F6C5E, 0x0062645E, 0x00666862, 0x006A6B67, 0x00717270, 0x007A797B, 0x00868589, 0x00A7A5AB, 0x00CECBD4, 0x0078846E, 0x0027341C, 0x001F2C12, 0x002C3B1C, 0x001E2E0C,
        0x0021330C, 0x002F4118, 0x00273A0F, 0x002E3D1D, 0x00334222, 0x00485737, 0x005F6E4E, 0x00697858, 0x00677656, 0x00657454, 0x00697858, 0x006A7554, 0x006A7751, 0x006D7B51, 0x00617044, 0x00616D49, 0xFFF3F9E6, 0xFFFFFFFE, 0xFFFFFCFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFBF9, 0xFFFFFAFF, 0xFFF9FBFF, 0x2A8C9685, 0x004C542F, 0x00525331, 0x003E4522, 0x002D4015, 0x001E3D1C, 0x001D3C1B, 0x001B3A1B, 0x001A381B, 0x0019361C,
        0x0019361C, 0x0019361D, 0x001A371E, 0x001E3116, 0x0027391C, 0x002E3D1D, 0x0034401C, 0x003A451D, 0x00404A20, 0x00444E23, 0x00495328, 0x004C642E, 0x0051653B, 0x0058654B, 0x00626D53, 0x00677553, 0x0063754E, 0x0062734E, 0x00667559, 0x00697753,
        0x00697753, 0x00697852, 0x00697852, 0x00697852, 0x00697950, 0x0068784F, 0x0068784F, 0x00647549, 0x0063734A, 0x0062704C, 0x00636E4D, 0x00616D49, 0x005F6B41, 0x00596737, 0x00556530, 0x00566226, 0x00535F23, 0x00505C20, 0x004F5B1F, 0x00505C20,
        0x00505C20, 0x004F5B1F, 0x004E5A1E, 0x00526124, 0x00536127, 0x0055622E, 0x00596535, 0x005D693F, 0x00626D45, 0x0065704A, 0x0065714D, 0x0064724E, 0x0046562D, 0x0037481C, 0x00506330, 0x00576A37, 0x003D501F, 0x004E5F33, 0x0048582F, 0x00384C17,
        0x004E6130, 0x006E7F54, 0x006E7C58, 0x00697753, 0x006F7E58, 0x0048592D, 0x003B4D1E, 0x00536334, 0x00586839, 0x005A6A3B, 0x00586839, 0x00506031, 0x00556536, 0x005C6C3D, 0x004A5A2B, 0x00384B14, 0x00586936, 0x00758458, 0x00738158, 0x00707D57,
        0x00748259, 0x006E7D51, 0x00728252, 0x00707E55, 0x006F7D54, 0x00758359, 0x00728056, 0x0077865A, 0x00718054, 0x00758556, 0x00758556, 0x00707F53, 0x00718054, 0x00707F53, 0x006D7C50, 0x006E7D51, 0x00718054, 0x00718054, 0x006E7D51, 0x006E7C52,
        0x006F7D53, 0x00707E54, 0x00717F55, 0x00728056, 0x00728056, 0x00717F55, 0x00707E54, 0x00748259, 0x00758359, 0x00738157, 0x00707E54, 0x00707E54, 0x00728056, 0x00728056, 0x00707E54, 0x006D7D54, 0x006E7E55, 0x006E7E55, 0x006D7D54, 0x006B7B52,
        0x006A7A51, 0x006A7A51, 0x00697950, 0x006E7C53, 0x006E7C53, 0x006D7B52, 0x006B7950, 0x0069774E, 0x0068764D, 0x0069774E, 0x006A784F, 0x00657349, 0x00657349, 0x00647248, 0x005D6B42, 0x005A683F, 0x004C5A31, 0x003C4923, 0x0045522C, 0x00767D62,
        0x008C927B, 0x00929683, 0x009A9E92, 0x00989C91, 0x008A9184, 0x00878E7F, 0x00747C6B, 0x008E9783, 0x0099A28E, 0x00878E7F, 0x006E7469, 0x00797D77, 0x00777B76, 0x007E8080, 0x00AAACAC, 0x00B5BAB9, 0x00A8ADAC, 0x00A7ACAA, 0x00A1A6A4, 0x009CA29D,
        0x009DA39E, 0x00969C97, 0x00949A95, 0x00949C92, 0x008D948D, 0x008D948D, 0x008D948D, 0x00888E89, 0x00868C87, 0x00858A88, 0x00808583, 0x00838988, 0x007E8483, 0x00828887, 0x00808685, 0x00858B8A, 0x00828887, 0x008A908F, 0x008D9392, 0x00808C8C,
        0x00808C8C, 0x00869090, 0x00838D8D, 0x00858D8D, 0x00808888, 0x00787D7E, 0x00808586, 0x00898B85, 0x008A8C86, 0x00838480, 0x00858682, 0x009A9B99, 0x00ADAEAC, 0x00B2B2B2, 0x00B1B1B1, 0x0098A096, 0x00838B80, 0x006F786B, 0x005B6555, 0x006D7766,
        0x0065705C, 0x00606B57, 0x006E7A64, 0x00747E6D, 0x0066705F, 0x007D8776, 0x00919B8A, 0x0086907F, 0x008A9483, 0x0096A08F, 0x008B9584, 0x00768160, 0x006C7953, 0x006A784E, 0x00657448, 0x006A7652, 0xFFF7FDEA, 0xFFFFFFFE, 0xFFFBF8FF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xF0FFFFEE, 0xFFFFFFFC, 0xF7F2FFFD, 0x1E80997F, 0x00344C24, 0x00314522, 0x0028401E, 0x001D3F16, 0x001B3916, 0x001B3916, 0x001A3815, 0x001A3716, 0x00193517,
        0x00193517, 0x00193518, 0x00193518, 0x00143013, 0x001A3618, 0x001C3715, 0x001D3811, 0x00253E12, 0x002C4513, 0x00344C16, 0x003E561C, 0x003D5525, 0x00435831, 0x00516443, 0x005B704F, 0x005C734D, 0x005B734B, 0x005A724F, 0x005B7154, 0x0064724E,
        0x0064734D, 0x0065744E, 0x0065744E, 0x0065754C, 0x0064744B, 0x0064754A, 0x0064754A, 0x00617148, 0x00617148, 0x00616E48, 0x005F6D44, 0x005B6A3E, 0x00576633, 0x00506128, 0x004C5E21, 0x004F5A1B, 0x004E591A, 0x004C5718, 0x004C5718, 0x004D5819,
        0x004F5A1B, 0x004F5A1B, 0x004F5A1B, 0x004B5A1C, 0x004C5B1E, 0x004F5D23, 0x00515F29, 0x00566230, 0x005A6739, 0x005F6B41, 0x00636F45, 0x0063724C, 0x0046572C, 0x002E4011, 0x00516433, 0x00586B3A, 0x00324415, 0x004B5C31, 0x0045552C, 0x002E4011,
        0x004B5C30, 0x006C7C53, 0x006D7C56, 0x006C7B55, 0x006D7D54, 0x00435429, 0x00304213, 0x005E6C42, 0x0056643A, 0x004C5A30, 0x0049572D, 0x00435127, 0x00455329, 0x004B592F, 0x003F4D23, 0x00364714, 0x00566637, 0x00738256, 0x00728056, 0x006F7D53,
        0x00738354, 0x0071824F, 0x0072844F, 0x00708051, 0x006F7F50, 0x00748455, 0x00738256, 0x00748357, 0x006D7C50, 0x00707F53, 0x00728155, 0x00718054, 0x00718054, 0x00707F53, 0x006E7D51, 0x006F7E52, 0x00718054, 0x00707F53, 0x006E7D51, 0x00717F55,
        0x00728056, 0x00738157, 0x00738157, 0x00728056, 0x00717F55, 0x00707E54, 0x00707E54, 0x00717F56, 0x00717F56, 0x006F7C56, 0x006E7B55, 0x006F7B57, 0x00737E5D, 0x00737E5D, 0x00707B5B, 0x00708057, 0x006F7F56, 0x006D7D54, 0x006C7C53, 0x006B7B52,
        0x006A7A51, 0x006A7A51, 0x006A7A51, 0x006D7B52, 0x006C7A51, 0x006A784F, 0x006A784F, 0x006A784F, 0x006A784F, 0x0069774E, 0x0069774E, 0x00657349, 0x00637147, 0x00637147, 0x00616F46, 0x005A683F, 0x00425027, 0x0033401A, 0x0048552F, 0x00555849,
        0x00636559, 0x0060605A, 0x00686967, 0x00757575, 0x00757575, 0x00686B69, 0x004B4F4A, 0x006C706B, 0x008E918F, 0x00B3B5B5, 0x00A5A6AA, 0x00AAAAB0, 0x00AAA9B3, 0x00B1AFBB, 0x00AFADB9, 0x0080827C, 0x007C7E78, 0x008A8C86, 0x0095988F, 0x00989B92,
        0x00999D92, 0x0095998E, 0x0093978C, 0x0082877E, 0x007D8279, 0x007E837A, 0x0081857F, 0x007F837D, 0x007D817C, 0x007E827D, 0x007E827D, 0x00808887, 0x00798180, 0x007F8786, 0x007F8786, 0x007F8786, 0x007E8685, 0x0088908F, 0x0088908F, 0x008B9491,
        0x00878F8E, 0x00878F8E, 0x00868E8D, 0x00858D8D, 0x007D8585, 0x00747C7C, 0x007A8184, 0x00A0A19D, 0x00AFB1AB, 0x00B3B5AF, 0x00ACAFA6, 0x00A9ACA3, 0x00A3A79C, 0x0091958A, 0x007F8378, 0x008D8F90, 0x00B0B2B3, 0x00BABCBD, 0x008C8E8F, 0x009A9B9F,
        0x0095969A, 0x009D9EA2, 0x00A6A7AB, 0x00575A58, 0x004C4F4D, 0x00686B69, 0x00828583, 0x00797C7A, 0x00848785, 0x00989B99, 0x008A8D8B, 0x0075805F, 0x006B7852, 0x0069774D, 0x0069784C, 0x006D7955, 0xFFF4FAE7, 0xFFFEFFFD, 0xFFFCF9FF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xF0F4FEEE, 0xCADAEAF0, 0xA0C4E4F1, 0x006C9892, 0x00305B4E, 0x00284D49, 0x00214B4A, 0x001B4E46, 0x00294D47, 0x002A4E48, 0x00294D47, 0x00294D47, 0x00284C46,
        0x00264A44, 0x00254844, 0x00244743, 0x001B4342, 0x001D4543, 0x0018413C, 0x00143F34, 0x00194331, 0x001B4429, 0x00163E1B, 0x00153C16, 0x003B4E23, 0x003B4F25, 0x00455A33, 0x004C643A, 0x00466135, 0x00486135, 0x0050663C, 0x0051663F, 0x005D6C46,
        0x005F6E48, 0x0061704A, 0x00617148, 0x00617148, 0x00617247, 0x00617247, 0x00617247, 0x00606F49, 0x00616F46, 0x005E6C42, 0x005B6B3C, 0x00576732, 0x00506227, 0x004B5C1C, 0x00475916, 0x004D5819, 0x004C5718, 0x004B5617, 0x004A5516, 0x004B5617,
        0x004C5718, 0x004D5819, 0x004E591A, 0x00495618, 0x00485719, 0x004A591B, 0x004D5C1F, 0x00505F25, 0x0056632F, 0x005B6939, 0x00606D41, 0x0063764B, 0x00405328, 0x00273B0E, 0x00425629, 0x00495D30, 0x002F4217, 0x004E6037, 0x00506239, 0x00314217,
        0x004E5E35, 0x006E7E55, 0x006E7E55, 0x00708057, 0x006F8055, 0x0047582D, 0x00304115, 0x004E5F33, 0x0046572B, 0x0046572B, 0x00546539, 0x0056673B, 0x00536438, 0x0058693D, 0x00546539, 0x00334418, 0x00546539, 0x006F8054, 0x00708155, 0x006C7E4F,
        0x00708352, 0x00728552, 0x00718550, 0x00728554, 0x00708352, 0x00708253, 0x006F8152, 0x006E7F53, 0x006B7C51, 0x006C7D52, 0x006F7F56, 0x00738256, 0x00728155, 0x00718054, 0x00707F53, 0x00728155, 0x00748357, 0x00748357, 0x00738256, 0x006E7F54,
        0x006E7F54, 0x006D7E53, 0x006C7D52, 0x006B7C51, 0x006C7D52, 0x006E7F54, 0x006F8055, 0x006D7F50, 0x006D7E52, 0x006E7F53, 0x006F7F56, 0x0072815B, 0x0073815D, 0x00717F5D, 0x006E7C5A, 0x00708057, 0x006F7F56, 0x006E7E55, 0x006E7E55, 0x006E7E55,
        0x006E7E55, 0x006D7D54, 0x006C7C53, 0x006D7B52, 0x006C7A51, 0x006C7A51, 0x006C7A51, 0x006D7B52, 0x006C7A51, 0x0069774E, 0x0066744B, 0x0067754B, 0x00616F45, 0x00606E44, 0x00637148, 0x00616F46, 0x0045532A, 0x002F3C16, 0x00414E28, 0x00444436,
        0x00535347, 0x0052524C, 0x00565453, 0x00575757, 0x00565755, 0x005B5C58, 0x00575B56, 0x00444444, 0x00585759, 0x00C9C8CA, 0x00F0EEF4, 0x00EBE8F1, 0x00F6F2FD, 0x00FBF7FF, 0x00A7A3AF, 0x00434137, 0x003C3A2F, 0x00403E33, 0x00454338, 0x00424133,
        0x003D3C2E, 0x003A3A2A, 0x00393929, 0x0052564B, 0x004E5247, 0x004F5348, 0x0052554C, 0x004F5249, 0x004B4D47, 0x004A4C46, 0x004D4F49, 0x004E504A, 0x00484A44, 0x004D4F49, 0x004F514B, 0x004A4C46, 0x00474943, 0x004C4E48, 0x004A4C46, 0x00505042,
        0x004B4B3F, 0x004A4A3E, 0x004C4C40, 0x00515046, 0x00525147, 0x00504F45, 0x00535149, 0x00504F4B, 0x0043433D, 0x0035362D, 0x0034352B, 0x00393C2D, 0x003B3E2E, 0x00363A27, 0x00333823, 0x003A393B, 0x006B6A6C, 0x00CDCCD0, 0x00D7D5DB, 0x00E4E1EA,
        0x00E3DFEA, 0x00D0CCD8, 0x006E6A76, 0x00454545, 0x004A4A4A, 0x004F4F4F, 0x00535353, 0x004D4D4D, 0x00474747, 0x00474747, 0x00414141, 0x00636E4D, 0x0066734D, 0x006B794F, 0x006A794D, 0x0066724E, 0xFFECF2DF, 0xFFFEFFFD, 0xFFFFFCFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x81B3C5E4, 0x00819CD4, 0x0076A1E4, 0x00649CD3, 0x00649BCE, 0x006F9EDB, 0x006EA0E2, 0x0066A0DB, 0x005F9CD4, 0x005F9CD4, 0x00609ED4, 0x00609ED4, 0x00609ED4,
        0x005E9CD2, 0x005D9BD1, 0x005C9AD0, 0x006D9AD7, 0x006A99D6, 0x006698D4, 0x006096CD, 0x006195C4, 0x005889AF, 0x003C6B87, 0x00214E63, 0x00314020, 0x002A3B19, 0x0029401A, 0x002A431D, 0x00274119, 0x00344B1F, 0x004A5D2C, 0x00576731, 0x00576640,
        0x005A6943, 0x005D6D44, 0x005F6F46, 0x005F7045, 0x005F7045, 0x00607145, 0x00617246, 0x00616D49, 0x005F6D44, 0x005C6C3D, 0x00596934, 0x00526429, 0x004D5E1F, 0x00465717, 0x00435512, 0x004A5719, 0x00495618, 0x00485517, 0x00465315, 0x00455214,
        0x00455214, 0x00465315, 0x00475416, 0x00475319, 0x00495519, 0x004B5919, 0x004B5B1B, 0x004E5D1F, 0x00536229, 0x005B6735, 0x00606B3D, 0x005F7247, 0x003A4C23, 0x002A3C15, 0x002D3E19, 0x0030401E, 0x00263614, 0x00354523, 0x00384826, 0x002C3A18,
        0x00475531, 0x006C7B55, 0x00708057, 0x00738459, 0x006D7E53, 0x0047582D, 0x0028390E, 0x00314314, 0x00344617, 0x00344617, 0x00394B1C, 0x00364819, 0x00344617, 0x00384A1B, 0x00324415, 0x002F3F16, 0x00506136, 0x006C7D51, 0x00718256, 0x006C7D51,
        0x006E7F53, 0x00718256, 0x006D7E52, 0x00728358, 0x00708156, 0x006E7F54, 0x006F8055, 0x006F8055, 0x00718158, 0x006F7F56, 0x006E7E55, 0x00728155, 0x00707F53, 0x006E7D51, 0x006D7C50, 0x006D7C50, 0x006D7C50, 0x006F7E52, 0x00718054, 0x006C7D52,
        0x006E7F54, 0x00708156, 0x00708156, 0x00708156, 0x006F8055, 0x00718257, 0x00728358, 0x006D804D, 0x006B7E4B, 0x006B7E4D, 0x006D7F50, 0x006F8152, 0x006F8054, 0x006F8054, 0x006E7F54, 0x006C7C53, 0x006D7D54, 0x006E7E55, 0x00708057, 0x00708057,
        0x00708057, 0x006F7F56, 0x006F7F56, 0x00707E55, 0x006E7C53, 0x006D7B52, 0x006D7B52, 0x006D7B52, 0x006C7A51, 0x006A784F, 0x0068764D, 0x0069774D, 0x00657349, 0x00616F45, 0x00627047, 0x00637148, 0x0049572E, 0x002F3C16, 0x003D4A24, 0x0043472E,
        0x00585A46, 0x005E5E50, 0x005B5C52, 0x005B5C53, 0x00575B50, 0x005B5F53, 0x005E6354, 0x00656761, 0x00646660, 0x00D6D8D2, 0x00FFFFFC, 0x00EFF0EE, 0x00FBFCFA, 0x00FFFFFF, 0x00A6A6A6, 0x004C4B3D, 0x00454436, 0x00444335, 0x00474737, 0x00434333,
        0x0040402E, 0x00434331, 0x0041412F, 0x005A5E52, 0x005B5F53, 0x005D6155, 0x005F6358, 0x005F6358, 0x005A5D54, 0x005A5D54, 0x005E6158, 0x00646355, 0x00626153, 0x00605F51, 0x00636254, 0x00626153, 0x00605F51, 0x005F5E50, 0x00616052, 0x00515752,
        0x00545B54, 0x00595D57, 0x005E605A, 0x005F6057, 0x00606158, 0x0067665C, 0x0068675D, 0x0063635D, 0x0047483F, 0x00323329, 0x00323428, 0x003A3D2D, 0x003B3F2C, 0x00393E29, 0x00383E27, 0x004A4D44, 0x007A7C76, 0x00F8FAF4, 0x00FFFFFC, 0x00FAFBF9,
        0x00FFFFFF, 0x00FFFEFF, 0x00888789, 0x0052554C, 0x0062655C, 0x00595C53, 0x0053564D, 0x0055584F, 0x004F5249, 0x004E5148, 0x004F5249, 0x00576241, 0x0067744E, 0x006F7D53, 0x006A794D, 0x00616D49, 0xFFE7EDDA, 0xFFFFFFFE, 0xFFFFFCFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x76AED0FB, 0x006D97DC, 0x005995E9, 0x005AA1EB, 0x0062A8EE, 0x0065A1F3, 0x0063A0F6, 0x00599DEA, 0x005897E7, 0x005998E8, 0x005A9AE8, 0x005C9CEA, 0x005D9EE9,
        0x005D9EE9, 0x005D9EE8, 0x005D9EE8, 0x005E97E2, 0x005995E1, 0x005999E7, 0x005B9DEB, 0x005FA1E8, 0x0063A0DE, 0x004780B3, 0x001B4F7D, 0x001B3027, 0x00142C20, 0x00112E1E, 0x0010301F, 0x0015311E, 0x00243A1D, 0x003C4E1F, 0x004D5E1F, 0x0055653C,
        0x00596940, 0x005D6D44, 0x005F7045, 0x005E6F44, 0x005E6F43, 0x005F7044, 0x00607145, 0x00606D47, 0x00606C42, 0x005C6A3A, 0x00566630, 0x00505F25, 0x0049591C, 0x00455417, 0x00435117, 0x003F4C18, 0x003F4C18, 0x003F4C18, 0x003E4B17, 0x003E4B17,
        0x003F4C18, 0x00414E1A, 0x00424F1B, 0x00484F1C, 0x0048541A, 0x004A5719, 0x004C5A18, 0x004C5C1C, 0x00526026, 0x00586432, 0x005D673C, 0x005C6E45, 0x003A4B26, 0x00364525, 0x00263418, 0x0026331B, 0x002A371D, 0x002B391D, 0x002A381C, 0x003A4628,
        0x00475434, 0x00697852, 0x006E7F54, 0x006E7F53, 0x006A7B4F, 0x00526338, 0x00324219, 0x0032441B, 0x002F4118, 0x002C3E15, 0x0034461D, 0x0031431A, 0x00283A11, 0x002F4118, 0x0035471E, 0x003A4C23, 0x00596B42, 0x00708358, 0x00718558, 0x00677A4F,
        0x00657651, 0x006A7959, 0x00627054, 0x00677656, 0x006C7B5B, 0x006A7A58, 0x006A7B56, 0x00697B54, 0x0071835A, 0x006D7F56, 0x00687B50, 0x006D7C50, 0x006B7A4E, 0x0069784C, 0x00657448, 0x005E6D41, 0x0059683C, 0x005A693D, 0x005D6C40, 0x005A6D42,
        0x005F7247, 0x0065784D, 0x0066794E, 0x0062754A, 0x005B6E43, 0x0055683D, 0x0052653A, 0x00516439, 0x004F6237, 0x004D6134, 0x004F6336, 0x00536738, 0x00576B3C, 0x005F7344, 0x00657A49, 0x0063734A, 0x0066764D, 0x006A7A51, 0x006B7B52, 0x006B7B52,
        0x006A7A51, 0x006A7A51, 0x006B7B52, 0x00728057, 0x00707E55, 0x006D7B52, 0x006B7950, 0x006B7950, 0x006C7A51, 0x006D7B52, 0x006D7B52, 0x006A784E, 0x006B794F, 0x00657349, 0x00606E45, 0x00606E45, 0x0047552C, 0x00313E18, 0x0043502A, 0x004B4F32,
        0x005C5F45, 0x00565844, 0x004B4C3C, 0x00515445, 0x005B5E4F, 0x00595C4C, 0x00515744, 0x005C5F50, 0x005B5E4F, 0x00929488, 0x009C9E92, 0x0094968A, 0x00999A90, 0x00A5A69C, 0x00828379, 0x00656456, 0x00636254, 0x00616151, 0x00636353, 0x005F5F4F,
        0x005A5A48, 0x00595947, 0x004F4F3D, 0x00404334, 0x00494C3D, 0x004F5145, 0x00535549, 0x0057594D, 0x0058594F, 0x00595A50, 0x005E5F55, 0x005A594F, 0x005F5E54, 0x00545349, 0x0057564C, 0x00616056, 0x00616056, 0x0059584E, 0x00646359, 0x005C7687,
        0x00647C8E, 0x006C8190, 0x006C7E89, 0x005C6971, 0x004D585C, 0x00515959, 0x00535859, 0x00545349, 0x0056554B, 0x005D5D51, 0x00616155, 0x005F5F51, 0x005F5F51, 0x00606151, 0x005D5E4E, 0x00626556, 0x0076796A, 0x00AEB1A2, 0x00ADB0A1, 0x00AFB2A3,
        0x00B5B8A9, 0x00B1B4A5, 0x0056584C, 0x00515444, 0x00636656, 0x00606353, 0x005C5F4F, 0x00595C4C, 0x00555848, 0x00595C4C, 0x004E5141, 0x005B6645, 0x006C7953, 0x00717F55, 0x006B7A4E, 0x00636F4B, 0xFFE9EFDC, 0xFFFFFFFE, 0xFFFEFBFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x63A4D2EA, 0x006AA0D5, 0x00569CE2, 0x0052A5E3, 0x0055A5E0, 0x005BA0E5, 0x0069A9F0, 0x0060A5E4, 0x006198E1, 0x00629AE1, 0x00639BE2, 0x00659EE3, 0x0066A0E2,
        0x0067A1E2, 0x0068A3E1, 0x0068A3E1, 0x0065A7DC, 0x00599DD8, 0x00579FDF, 0x00529EE0, 0x00519CDA, 0x0060A3DA, 0x004B88B4, 0x00154C71, 0x00274B63, 0x00264E61, 0x00224E5F, 0x00244F60, 0x002B4E5C, 0x00324F4C, 0x003F5735, 0x004C642A, 0x0056663D,
        0x005A6A41, 0x005F7045, 0x00607146, 0x005E6F43, 0x005D6E42, 0x005D6E42, 0x005F7044, 0x00606B43, 0x005E6B3F, 0x00596835, 0x0054632A, 0x004C5B22, 0x0047541E, 0x00444F1D, 0x00434D1E, 0x0038461C, 0x0039471D, 0x0039471D, 0x0038461C, 0x0037451B,
        0x0037451B, 0x0039471D, 0x003C4A20, 0x00464C1D, 0x00484F1C, 0x00495519, 0x004A5816, 0x004A5B18, 0x004E5C22, 0x00555F30, 0x00596339, 0x00546641, 0x003D4E2D, 0x0046543C, 0x003C4836, 0x00434E3E, 0x00515C4C, 0x00515D49, 0x004C5943, 0x005F6952,
        0x00566244, 0x006A7854, 0x00697A4E, 0x0067794A, 0x006C7E4F, 0x006B7C51, 0x0053633A, 0x004A5541, 0x00495440, 0x004F5A46, 0x0065705C, 0x0065705C, 0x00505B47, 0x004C5743, 0x00515C48, 0x00576940, 0x006A7C53, 0x006D8055, 0x005D7045, 0x0043542F,
        0x003A482C, 0x00414C38, 0x00384134, 0x0036402F, 0x0045503C, 0x0048553D, 0x004B593D, 0x004D5D3B, 0x0063754E, 0x006A7D52, 0x006B7F52, 0x006A794D, 0x0068774B, 0x00657448, 0x005C6B3F, 0x004E5D31, 0x00404F23, 0x003C4B1F, 0x003E4D21, 0x004C5F34,
        0x0053663B, 0x005B6E43, 0x005B6E43, 0x0054673C, 0x00495C31, 0x003F5227, 0x00394C21, 0x002C3822, 0x002A371F, 0x0029361C, 0x002C3B1C, 0x002F3F1D, 0x00354720, 0x00405328, 0x004B5E33, 0x0065754C, 0x00697950, 0x006D7D54, 0x006D7D54, 0x006B7B52,
        0x006A7A51, 0x006C7C53, 0x006F7F56, 0x006B7950, 0x006C7A51, 0x006D7B52, 0x006D7B52, 0x006D7B52, 0x006D7B52, 0x006D7B52, 0x006E7C53, 0x006A784E, 0x006B794F, 0x0066744A, 0x00627047, 0x00616F46, 0x0045532A, 0x002F3C16, 0x0045522C, 0x0044472E,
        0x00595B45, 0x00585848, 0x0046463A, 0x0045443A, 0x004A4B41, 0x00505246, 0x00595C4D, 0x00585A4E, 0x00515347, 0x005B5D51, 0x005F6155, 0x0066685C, 0x006A6C60, 0x00626458, 0x00585A4E, 0x005E5E52, 0x00606054, 0x005C5C4E, 0x005D5D4F, 0x00575848,
        0x00525343, 0x004F5040, 0x003E402D, 0x00414232, 0x004F4F41, 0x00555547, 0x00545446, 0x0057574B, 0x0058584C, 0x0057564C, 0x0058574D, 0x00546062, 0x00647072, 0x00525E60, 0x00556163, 0x006A7678, 0x00667274, 0x00505C5E, 0x00626E70, 0x006D93B3,
        0x006F91AF, 0x007492AB, 0x007D95A7, 0x006C7C88, 0x00515C60, 0x00525758, 0x00555856, 0x00555547, 0x00535345, 0x00525246, 0x00505044, 0x00504F45, 0x0059584E, 0x005E5C54, 0x005A5850, 0x004E4E42, 0x005F5F53, 0x006C6C5E, 0x00616252, 0x0060624F,
        0x005B5D49, 0x005D604A, 0x003E412B, 0x00454636, 0x005D5E4E, 0x00606151, 0x00626353, 0x005E5F4F, 0x005B5C4C, 0x00606151, 0x004D4E3E, 0x00616C4B, 0x006D7A54, 0x006F7D53, 0x006D7C50, 0x0066724E, 0xFFE8EEDB, 0xFFFFFFFE, 0xFFFEFBFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x5FA1CAEA, 0x006EA2DE, 0x005A9EEB, 0x0053A1E8, 0x0057A0E4, 0x00629EEA, 0x006EA6F5, 0x005C97DC, 0x005699E8, 0x00569AE7, 0x00579BE6, 0x00579CE5, 0x00589EE4,
        0x00589FE3, 0x0059A0E3, 0x0059A0E3, 0x0065A0D8, 0x005998D5, 0x00589DE2, 0x00539AE4, 0x005094DD, 0x00629FE1, 0x005187BE, 0x00144474, 0x00104171, 0x00134873, 0x00114972, 0x00154977, 0x00224E77, 0x002D4F5F, 0x00375641, 0x00466532, 0x0058683F,
        0x005C6C43, 0x00617247, 0x00617247, 0x005E6F43, 0x005C6D41, 0x005C6D41, 0x005D6F40, 0x005E6941, 0x005C693B, 0x00576732, 0x00516027, 0x0049581F, 0x0045511D, 0x00434D1F, 0x00434B23, 0x003E4F2A, 0x003D4E29, 0x003B4C27, 0x00364722, 0x0031421D,
        0x002E3F1A, 0x002E3F1A, 0x002F401B, 0x0044481E, 0x00474D1C, 0x004A531A, 0x00495715, 0x004A5818, 0x004B591F, 0x00525C2D, 0x00575F37, 0x004C5D3B, 0x00425135, 0x00535F4B, 0x00545E51, 0x0060695F, 0x00697367, 0x00677164, 0x00596553, 0x005E6752,
        0x00505C40, 0x00687652, 0x006D7E52, 0x00697B4C, 0x006A7C4D, 0x006C7D52, 0x00506037, 0x00535856, 0x00606563, 0x00676C6A, 0x00707573, 0x00727775, 0x00696E6C, 0x005F6462, 0x00515654, 0x005F7148, 0x006F8257, 0x006D8055, 0x005F7148, 0x004D5C3C,
        0x00535F49, 0x006C746A, 0x006C716F, 0x00626A60, 0x0071796E, 0x006A7463, 0x005C6951, 0x004F5E3F, 0x0062744D, 0x00697C51, 0x006C8051, 0x006A794D, 0x0069784C, 0x00657448, 0x0059683C, 0x00445327, 0x00303F13, 0x0027360A, 0x0028370B, 0x00273A0F,
        0x002E4116, 0x0036491E, 0x00384B20, 0x0032451A, 0x00293C11, 0x00213409, 0x001D3005, 0x001B201E, 0x00192019, 0x00192116, 0x001B2514, 0x001B2810, 0x001C2A0E, 0x00243412, 0x002E3F1A, 0x00405027, 0x0044542B, 0x0047572E, 0x0046562D, 0x00425229,
        0x00415128, 0x0045552C, 0x00495930, 0x00616F46, 0x0067754C, 0x006D7B52, 0x00717F56, 0x00717F56, 0x006E7C53, 0x006C7A51, 0x006A784F, 0x0069774D, 0x0067754B, 0x00637147, 0x0065734A, 0x0067754C, 0x0047552C, 0x002B3812, 0x00424F29, 0x00474735,
        0x00555446, 0x005B594F, 0x00595651, 0x005E5B57, 0x00575652, 0x0051514B, 0x005C5D54, 0x0054554C, 0x00484940, 0x004F5047, 0x0053544B, 0x0047483F, 0x004F5047, 0x00525349, 0x0053544A, 0x005D5F53, 0x00606256, 0x00595B4F, 0x00575A4B, 0x00535647,
        0x00535647, 0x00525545, 0x003E4131, 0x00474838, 0x00585949, 0x005D5D4F, 0x00575749, 0x00575749, 0x0057574B, 0x00535347, 0x00525246, 0x004D6271, 0x00667B8A, 0x00516675, 0x00546978, 0x006F8493, 0x00647988, 0x003F5463, 0x00536877, 0x00557795,
        0x004A6883, 0x004F687C, 0x006B7D88, 0x00697275, 0x0053554F, 0x00585449, 0x005E5748, 0x00525343, 0x004F5040, 0x00545446, 0x0058574D, 0x0057554D, 0x00595651, 0x005B5854, 0x00575352, 0x0057544F, 0x00504E46, 0x0049483E, 0x004A4A3C, 0x004B4D3A,
        0x00464933, 0x00464A31, 0x0032371C, 0x00404034, 0x005E5E52, 0x005A5A4E, 0x0058584C, 0x005A5A4E, 0x0057574B, 0x005A5A4E, 0x004E4E42, 0x00606B4A, 0x006A7751, 0x006C7A50, 0x006E7D51, 0x0067734F, 0xFFE4EAD7, 0xFFFEFFFD, 0xFFFFFCFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x6EA9CBE9, 0x00659ED6, 0x0059A1EE, 0x005DA2EB, 0x005EA3E8, 0x005AA5F1, 0x005AA5F1, 0x00579DE0, 0x005C9CE3, 0x005D9DE4, 0x0060A0E7, 0x0060A0E7, 0x005F9FE6,
        0x005E9EE5, 0x005E9EE5, 0x005E9EE5, 0x0061A0E4, 0x00599ADE, 0x00589BE0, 0x005A9DE2, 0x00599ADE, 0x0064A3E0, 0x004D8AC2, 0x00094279, 0x001C4064, 0x00224567, 0x00193E60, 0x00113E64, 0x0017496D, 0x00204B5A, 0x00395440, 0x005D6939, 0x005A6D4C,
        0x00576B41, 0x005D703F, 0x00657244, 0x00626C48, 0x00626B4A, 0x005E6F44, 0x00566C38, 0x00576E38, 0x00596A37, 0x00515C2E, 0x004F572F, 0x00525535, 0x0052553B, 0x00464933, 0x00595E49, 0x006C6554, 0x00706958, 0x00666250, 0x005D5B49, 0x003A3A28,
        0x00424431, 0x004E523F, 0x003C402D, 0x003C441F, 0x003E481D, 0x00415017, 0x00465616, 0x00495919, 0x004F5B1F, 0x00545D2A, 0x00575E31, 0x00506435, 0x004D5A40, 0x008C918F, 0x009B9EA6, 0x00989CA1, 0x009DA5A4, 0x009DA5A5, 0x009BA2A5, 0x008F9689,
        0x00556145, 0x006A7B4F, 0x00647746, 0x00697A4F, 0x006B7955, 0x0066754F, 0x005C6D42, 0x007F8979, 0x00A9AEB1, 0x009DA4AD, 0x00A4B0B0, 0x00A6B3B1, 0x009CA4AB, 0x00A0A6A5, 0x00717C68, 0x005E6E4C, 0x006B7B59, 0x006E7D5D, 0x00556347, 0x005F6A56,
        0x006A7268, 0x007C8180, 0x00787B80, 0x006C6B75, 0x008D8F90, 0x00656B60, 0x00353F28, 0x00505D3D, 0x006B7955, 0x0065734F, 0x006B7955, 0x006D7A4E, 0x00697648, 0x00617141, 0x005D703F, 0x003D5025, 0x001C2D0B, 0x001D2B13, 0x001C2A18, 0x00232819,
        0x001E2217, 0x001C1D19, 0x001C1C1C, 0x001D1D1D, 0x001D1E1A, 0x001C2015, 0x00202516, 0x0017240C, 0x0017230D, 0x001C2615, 0x001C2616, 0x001B2515, 0x001B2514, 0x00192410, 0x001D2913, 0x00232B1A, 0x00202A1D, 0x002C3A34, 0x003C4F52, 0x00657984,
        0x006E8190, 0x00657887, 0x00617483, 0x00617265, 0x0030452C, 0x002C451F, 0x00384F29, 0x00344929, 0x0036492E, 0x00445736, 0x005B7246, 0x0067784D, 0x0067784C, 0x00647647, 0x00647647, 0x0064754A, 0x0044532D, 0x00293616, 0x003E4A2E, 0x003A3F2A,
        0x00515542, 0x005D614E, 0x005A5D4D, 0x005B5E4F, 0x005C5E52, 0x005B5C52, 0x005C5D53, 0x00545442, 0x00484836, 0x00484836, 0x004A4A38, 0x00424230, 0x0041412F, 0x00494937, 0x004D4D3B, 0x00555940, 0x00575945, 0x005A5A4E, 0x0057554D, 0x00524F4A,
        0x0054524A, 0x004F4F41, 0x0040422F, 0x00474739, 0x005A5A4E, 0x0057574B, 0x0059594D, 0x00525147, 0x0055544A, 0x00525048, 0x00514F47, 0x00465D4F, 0x005F8290, 0x00495A63, 0x0050525C, 0x007A8CAB, 0x00727C8D, 0x0056544C, 0x0057676D, 0x0064808B,
        0x0055737E, 0x0054747F, 0x004D6C75, 0x00697D82, 0x00555A5B, 0x005E534F, 0x0067544D, 0x00525244, 0x00515145, 0x00545349, 0x00545349, 0x00515046, 0x0057574B, 0x005B5C4C, 0x00555744, 0x004B4C38, 0x00474735, 0x00504F41, 0x00545247, 0x004C4A3F,
        0x004B4A3C, 0x00464634, 0x00363723, 0x0042432F, 0x005B5B4B, 0x00555549, 0x00585550, 0x0056534F, 0x00595854, 0x0055554F, 0x004D4E45, 0x00606D47, 0x006F7D54, 0x00738157, 0x00707D57, 0x00677252, 0xFFE7EDDA, 0xFFFFFFFC, 0xFFFFFEFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x6EA9CBE9, 0x00669ED9, 0x0059A1EE, 0x005DA2EB, 0x005FA4EA, 0x005AA5F1, 0x0059A5F1, 0x00579CE1, 0x005C9CE3, 0x005E9EE5, 0x0060A0E7, 0x0060A0E7, 0x005F9FE6,
        0x005E9EE5, 0x005E9EE5, 0x005E9EE5, 0x0064A3E7, 0x005E9FE4, 0x005A9DE2, 0x005B9EE3, 0x00599ADE, 0x005F9EDB, 0x004985C0, 0x000F487F, 0x000B3969, 0x000B3864, 0x000C3762, 0x0015426D, 0x001C4D6D, 0x001E454E, 0x00364C33, 0x005F6835, 0x00526445,
        0x00566942, 0x00617344, 0x0069764A, 0x00636C4B, 0x005D6546, 0x005D6D44, 0x00607544, 0x00576C3B, 0x00586839, 0x00555F35, 0x004D5330, 0x00686A4D, 0x004E503A, 0x00252714, 0x00565949, 0x00A09988, 0x00938C7B, 0x009B9785, 0x006E6C5A, 0x00262614,
        0x004A4C39, 0x00676B58, 0x00494D3A, 0x003C4223, 0x003F4722, 0x00424E1C, 0x00445316, 0x00465517, 0x004C5B1E, 0x00555F2A, 0x00596230, 0x004D6132, 0x00445137, 0x00969B99, 0x00C2C5CD, 0x00C2C7CA, 0x00B3B9B8, 0x00A9B1B0, 0x00B1B8BB, 0x00A2A99C,
        0x00546044, 0x0068794D, 0x006D804F, 0x006B7C51, 0x006B7955, 0x00677650, 0x00495A2F, 0x00808A7A, 0x00CFD4D7, 0x00D6DDE6, 0x00D4E0E0, 0x00D4E1DF, 0x00D2DAE1, 0x00C2C8C7, 0x006B7662, 0x00607348, 0x006B7E53, 0x006E8156, 0x005D6F48, 0x00617050,
        0x00748169, 0x007C8676, 0x00687065, 0x005B6359, 0x006B7565, 0x004F5C42, 0x002C3C1A, 0x0041532A, 0x0065784D, 0x006B7E53, 0x0064764D, 0x0064744B, 0x0065764B, 0x005F7045, 0x0056673C, 0x00475630, 0x003A462A, 0x0039422E, 0x00383F32, 0x00373C2D,
        0x001F2317, 0x00171913, 0x001C1D1B, 0x001A1B19, 0x001A1C16, 0x00272B1F, 0x0034392A, 0x003F4730, 0x00373E29, 0x00363C2B, 0x0034392A, 0x00353A2B, 0x00353B2A, 0x002F3621, 0x00303821, 0x003F4534, 0x003E463B, 0x006E7976, 0x008E9DA0, 0x009BACB5,
        0x0098A9B6, 0x0098A7B7, 0x0098A7B7, 0x0094A0A2, 0x006D7C74, 0x005F725D, 0x005C6D58, 0x00505E52, 0x00515F54, 0x00576553, 0x0056674C, 0x006A7B50, 0x006A7B4F, 0x0067784C, 0x0068794D, 0x0068794E, 0x00475531, 0x002B3818, 0x00404C30, 0x003F412E,
        0x00565845, 0x005E5F4F, 0x00565648, 0x0057574B, 0x005F5E54, 0x00615F57, 0x005F5D55, 0x004F4E40, 0x004D4C3E, 0x00504F41, 0x00545345, 0x00525143, 0x00525143, 0x00535244, 0x00525143, 0x00575945, 0x00555646, 0x0055544A, 0x00524F4A, 0x00524F4A,
        0x0057564C, 0x00535345, 0x00454734, 0x003E3E30, 0x00525244, 0x00515143, 0x0058584C, 0x0056564A, 0x005A594F, 0x0057564C, 0x0055544A, 0x0054655A, 0x006A8691, 0x00576669, 0x00505455, 0x00627086, 0x005B646E, 0x0058564C, 0x00667276, 0x006A8FB1,
        0x005B81A3, 0x005D87A4, 0x00628AA3, 0x006C8D9D, 0x00495E66, 0x00464E4E, 0x00555352, 0x00545448, 0x00505044, 0x00505044, 0x00505044, 0x00505044, 0x00545446, 0x00565747, 0x0050523F, 0x00585945, 0x00575745, 0x005C5B4D, 0x005B594E, 0x00545247,
        0x00555446, 0x004F4F3D, 0x003A3B27, 0x00464733, 0x005E5E4E, 0x0059594D, 0x0059574F, 0x0053504B, 0x00575751, 0x0054554C, 0x004E4F45, 0x005F6C46, 0x006D7B52, 0x00717F55, 0x006F7C56, 0x00667151, 0xFFE7EDDA, 0xFFFFFFFC, 0xFFFFFEFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x6EAACCEA, 0x00669ED9, 0x0059A1EF, 0x005BA2EC, 0x005FA4EA, 0x005BA5F3, 0x0059A4F2, 0x00579CE1, 0x005A9CE3, 0x005C9EE5, 0x005EA0E7, 0x005EA0E7, 0x005D9FE6,
        0x005C9EE5, 0x005B9DE4, 0x005C9EE5, 0x005F9EE2, 0x005B9CE1, 0x00589AE1, 0x00599EE4, 0x00589CDF, 0x005B9BDB, 0x005A96D1, 0x00427EB4, 0x003A77B9, 0x003C77B5, 0x00427BB3, 0x004D82B5, 0x00497B9F, 0x0038606C, 0x003C5541, 0x00566238, 0x0057684D,
        0x005D6E4C, 0x005F7045, 0x005F6A44, 0x00626A4C, 0x00676E53, 0x00616F4B, 0x00596D40, 0x0056663D, 0x0057643E, 0x00585F3E, 0x00505235, 0x00595843, 0x0093917F, 0x0029291B, 0x0057594D, 0x00BFB8A9, 0x00BFB8A9, 0x00C5C0B1, 0x005A5748, 0x003B3B2B,
        0x00909181, 0x00616454, 0x00232616, 0x00373C27, 0x003E4628, 0x00444E24, 0x00424F1B, 0x00435215, 0x0049581B, 0x00515F25, 0x0059642C, 0x00495B2C, 0x003E4A2E, 0x00939994, 0x00C0C3C8, 0x00B2B7BA, 0x009BA1A0, 0x009AA09F, 0x00B1B8BB, 0x009BA295,
        0x00505C40, 0x00627347, 0x006C7F4E, 0x00697A4F, 0x00677551, 0x00697852, 0x004E5F34, 0x007E8576, 0x00CCD0D1, 0x00C9CED7, 0x00BAC5C3, 0x00B9C4C2, 0x00C4CACF, 0x00BDC2C0, 0x00636C57, 0x00566B3A, 0x00617645, 0x006B814D, 0x00617645, 0x00495D30,
        0x0051633C, 0x00505F3F, 0x003A482C, 0x0037462A, 0x00425332, 0x003F512C, 0x002C4015, 0x00293E11, 0x003C5124, 0x0041552A, 0x0033471D, 0x00354625, 0x00364725, 0x002E3E1C, 0x002B3818, 0x003F482D, 0x00525742, 0x00515143, 0x00504F45, 0x00444A39,
        0x00232819, 0x0014180D, 0x001A1D14, 0x00191C13, 0x0022261B, 0x003C4132, 0x004C5241, 0x004E503C, 0x004C4E3B, 0x00545446, 0x00535347, 0x004D4D3F, 0x00474838, 0x003F412D, 0x00454930, 0x00414435, 0x0050564B, 0x00939C99, 0x00ABB6BA, 0x00A6B2BC,
        0x009DA8B6, 0x009AA5B3, 0x00A0A9B7, 0x00AEB4C7, 0x00A6AFB8, 0x00A4B1AF, 0x00A7B1B1, 0x00A0A8AF, 0x009FA6AF, 0x00959D9C, 0x006F7B6F, 0x006A7B50, 0x00697A4F, 0x00647549, 0x00647549, 0x0065764B, 0x00475531, 0x002E3A1C, 0x00455036, 0x00424333,
        0x00575848, 0x005E5E50, 0x00555549, 0x0056554B, 0x00605E56, 0x00636159, 0x005D5A55, 0x00626056, 0x0068665C, 0x006A685E, 0x006B695F, 0x006D6B61, 0x006C6A60, 0x0069675D, 0x006A685E, 0x005D5D51, 0x0059584E, 0x0055534B, 0x0054524A, 0x0056544C,
        0x0059594D, 0x00545545, 0x00484A36, 0x00454636, 0x00595A4A, 0x00575749, 0x005B5B4D, 0x00555549, 0x0056564A, 0x00545349, 0x0055544A, 0x004B564C, 0x005A6D70, 0x0057615B, 0x0051564D, 0x00505C60, 0x004B5150, 0x00514F44, 0x00595F5E, 0x005F7CA1,
        0x006282A6, 0x006487A8, 0x005F839B, 0x00557483, 0x00455B60, 0x0046544E, 0x0051594E, 0x00555549, 0x00515145, 0x00525244, 0x00535345, 0x00525343, 0x00545545, 0x00575848, 0x00555744, 0x00565743, 0x00575745, 0x005D5C4E, 0x005C5A4F, 0x0059574C,
        0x005E5D4F, 0x00545442, 0x003C3D29, 0x003F402C, 0x00585848, 0x0058584C, 0x005A594F, 0x00535248, 0x0056584C, 0x00505344, 0x00484B3B, 0x00606D47, 0x006B7950, 0x006F7D53, 0x006E7B55, 0x00667151, 0xFFE7EDDA, 0xFFFFFFFC, 0xFFFFFEFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x6BA8CBEC, 0x00649ED9, 0x0058A2F0, 0x005CA3ED, 0x005EA4EA, 0x005AA5F3, 0x0059A4F2, 0x00569DE1, 0x005B9CE6, 0x005C9DE7, 0x005E9FE9, 0x005E9FE9, 0x005D9EE8,
        0x005B9CE6, 0x005B9CE6, 0x005B9CE6, 0x0062A3E8, 0x005EA1E6, 0x00589DE3, 0x005BA0E6, 0x00589BE0, 0x005797D7, 0x0063A2DC, 0x0067A3D9, 0x005A9CDD, 0x0062A0E0, 0x00629CD7, 0x005489BB, 0x003B6A8A, 0x00284C56, 0x00274435, 0x00344A2D, 0x003E4D38,
        0x003E4D31, 0x0034421E, 0x0037401F, 0x0052583F, 0x006D725D, 0x00636F51, 0x004A5C35, 0x00596646, 0x00677153, 0x003C3F26, 0x005E5D49, 0x005A5546, 0x009E9A8F, 0x00727066, 0x0035362D, 0x00BFB7AA, 0x00CDC5B8, 0x00C5BFB2, 0x004C493B, 0x006D6C5E,
        0x00ACAC9E, 0x002F3223, 0x00202314, 0x00282A1E, 0x00323623, 0x003B4324, 0x00404A1F, 0x0042501A, 0x004B591F, 0x00556427, 0x005C6B2E, 0x00596C3B, 0x004E5A3E, 0x009A9E99, 0x00ABAEB3, 0x00979A9E, 0x00919895, 0x00999F9E, 0x00AEB3B6, 0x00969D90,
        0x00626E52, 0x00708155, 0x006E8150, 0x006D7E53, 0x00667450, 0x006C7B55, 0x00637449, 0x00848C7B, 0x00BFC3C4, 0x00B3B9C0, 0x00B1BCBA, 0x00B0BBB8, 0x00B2B8BD, 0x00B4B9B7, 0x0068715C, 0x0066774C, 0x006A7B4F, 0x00708253, 0x006B7E4D, 0x003E5021,
        0x003D4D24, 0x003B4925, 0x002E3B1B, 0x00293D1A, 0x002F441E, 0x002F441E, 0x00253A14, 0x001C300D, 0x001C300D, 0x001D300F, 0x0017290A, 0x00172A0F, 0x0017280D, 0x0017250D, 0x001C2510, 0x003E422F, 0x005A5A4C, 0x005D584F, 0x006B635C, 0x005D6050,
        0x00484B3B, 0x00303324, 0x002B2E1F, 0x002D3021, 0x00373A2B, 0x004C4F3F, 0x00565949, 0x00565442, 0x004F4C3D, 0x00585547, 0x00575348, 0x00504D3F, 0x00484634, 0x003D3C27, 0x0045462C, 0x0049493D, 0x0070736A, 0x00ACB2B1, 0x00AEB7BB, 0x00B2BBC5,
        0x00AFB7C4, 0x00A7ADBA, 0x00B1B4C2, 0x00A7ACC1, 0x00AEB6C3, 0x00AAB4BB, 0x00AFB6BF, 0x00ADB2C1, 0x00B0B5C4, 0x00A4AAAF, 0x006A756D, 0x0067774E, 0x0067784D, 0x00647549, 0x0065764A, 0x0064744B, 0x0043512D, 0x00273315, 0x003A452B, 0x003D3E2E,
        0x004D4E3E, 0x00555547, 0x00505044, 0x00515046, 0x0056554B, 0x0056544C, 0x00504D48, 0x004C4941, 0x00524F47, 0x004F4C44, 0x004D4A42, 0x00504D45, 0x004C4941, 0x00504D45, 0x00625F57, 0x0059574F, 0x0057554D, 0x0057564C, 0x0059584E, 0x005C5C50,
        0x005D5E4E, 0x005A5C49, 0x00535541, 0x00575946, 0x006A6B5B, 0x00676858, 0x00696A5A, 0x00606052, 0x00616153, 0x00646458, 0x006A6A5E, 0x00596156, 0x005A655B, 0x005D6455, 0x00646A59, 0x00656C5F, 0x0064685C, 0x0069695B, 0x0060625C, 0x00505C62,
        0x005B676D, 0x005A696C, 0x00596766, 0x0055615B, 0x005F6657, 0x00686752, 0x006E6B4F, 0x00606054, 0x005E5E50, 0x005F6050, 0x005E604D, 0x005A5C48, 0x00565844, 0x00585A47, 0x005B5C4C, 0x005C5D49, 0x00585846, 0x00575648, 0x00565449, 0x0057554A,
        0x005E5D4F, 0x00585846, 0x00474834, 0x0052533F, 0x00636353, 0x00626254, 0x00626256, 0x005E5E50, 0x00676B58, 0x00616750, 0x00595F46, 0x0064714B, 0x006D7B52, 0x006F7D53, 0x006F7C56, 0x00687353, 0xFFE8EEDB, 0xFFFFFFFC, 0xFFFFFEFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x6BA8CBEC, 0x00649DDA, 0x0058A1F1, 0x005AA2EF, 0x005EA3EC, 0x005AA5F3, 0x0058A5F4, 0x00579DE3, 0x00599DE6, 0x005B9FE8, 0x005CA0E9, 0x005CA0E9, 0x005B9FE8,
        0x00599DE6, 0x00599DE6, 0x00599DE6, 0x005FA0E5, 0x0060A2E9, 0x00579BE4, 0x00569BE4, 0x00589DE2, 0x005D9DDE, 0x005896D2, 0x004782BA, 0x004F7CA2, 0x005581A6, 0x00547D9E, 0x0041637A, 0x00253F46, 0x00182B22, 0x001E3019, 0x002A3A1B, 0x00566355,
        0x00435139, 0x00344022, 0x00394025, 0x00474B38, 0x004D5041, 0x00434D36, 0x003A4A28, 0x00525B41, 0x004F553E, 0x00575844, 0x00858071, 0x007D776A, 0x00716C63, 0x00A4A199, 0x00595651, 0x00999184, 0x00A1998C, 0x00A59F92, 0x007A7769, 0x008F8E80,
        0x00727264, 0x000E1102, 0x002F3223, 0x0021241B, 0x002A2F20, 0x00363C25, 0x003C4622, 0x00414C1E, 0x0046541E, 0x00505E24, 0x00576629, 0x005A6A3A, 0x004F593B, 0x00989C96, 0x00A6A7AB, 0x00989C9D, 0x00A3A8A6, 0x00A4ABA8, 0x00AAAFB0, 0x008E9588,
        0x005F6B4F, 0x00728357, 0x006D804F, 0x006D7E53, 0x006B7955, 0x006F7E58, 0x0064754A, 0x008C9281, 0x00C0C4C5, 0x00B4B7BF, 0x00B4BFBC, 0x00B3BEBB, 0x00B7BCBF, 0x00BCC2BD, 0x00737B64, 0x00687654, 0x006A7854, 0x0066754F, 0x00576640, 0x002B3915,
        0x002E3B1B, 0x002B371B, 0x001B250E, 0x002F4122, 0x00324427, 0x002C3C24, 0x00303F2A, 0x003C4A38, 0x00384535, 0x002E3B2B, 0x00323F31, 0x00384A33, 0x0031402B, 0x00333D2C, 0x0032392C, 0x00404137, 0x00514E46, 0x00655F58, 0x008B837C, 0x006F7263,
        0x00696C5D, 0x004E5141, 0x004C4F3F, 0x00575A4A, 0x00525545, 0x00595C4D, 0x0066695A, 0x00737061, 0x00595648, 0x00555146, 0x00514D42, 0x00524F41, 0x004F4E3A, 0x003D3D25, 0x00434528, 0x0046473D, 0x00797B75, 0x00B1B7B6, 0x00ADB5BC, 0x00B3B9C4,
        0x00B1B7C4, 0x00ABAFBA, 0x00B4B6C1, 0x00AFB7C4, 0x00B3BDC4, 0x00A8B4B6, 0x00ABB3BA, 0x00AAAFBE, 0x00AEB4BF, 0x00A4ACAB, 0x00687565, 0x0065754C, 0x0068784F, 0x00697A4F, 0x006C7D52, 0x0068784F, 0x00404E2C, 0x001C280C, 0x002B351E, 0x001E1F0B,
        0x00222210, 0x00272715, 0x002A2A1A, 0x0029281A, 0x0029271C, 0x0028261C, 0x0026241A, 0x00232117, 0x0026241A, 0x00222016, 0x00222016, 0x00232117, 0x001B190F, 0x0029271D, 0x004D4B41, 0x002D2D21, 0x002D2D1F, 0x002C2D1D, 0x002C2E1B, 0x002B2D19,
        0x00292B17, 0x00292B17, 0x002C2E1A, 0x00323420, 0x003E402D, 0x00373926, 0x003D3F2C, 0x00383929, 0x00393A2A, 0x0038382A, 0x003A3A2C, 0x003A3F30, 0x00333521, 0x00303421, 0x00363C29, 0x00393C23, 0x003C3E2A, 0x00434839, 0x003C3C2C, 0x0043462C,
        0x003D4027, 0x00363723, 0x0041412F, 0x00484634, 0x0048432E, 0x003F381F, 0x00453A1F, 0x00343329, 0x00333325, 0x00323420, 0x0032361D, 0x0034381F, 0x00333620, 0x00333522, 0x00343525, 0x003C3D29, 0x002E2E1C, 0x00242315, 0x00211F14, 0x00232116,
        0x00272618, 0x00282816, 0x00242511, 0x00252513, 0x002C2C1C, 0x002B2C1C, 0x00323323, 0x0040422F, 0x00636950, 0x006F7758, 0x00707958, 0x006A7751, 0x00707E55, 0x00707E54, 0x00707D57, 0x006A7555, 0xFFE8EEDB, 0xFFFEFFFB, 0xFFFEFDFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x67A6CBED, 0x00639FDB, 0x0057A2F1, 0x005AA2EF, 0x005DA5ED, 0x0058A5F4, 0x0058A5F4, 0x00559DE3, 0x00599CE7, 0x005B9EE9, 0x005DA0EB, 0x005C9FEA, 0x005B9EE9,
        0x00599CE7, 0x00589BE6, 0x00589BE6, 0x005597DE, 0x005BA0E6, 0x005398E1, 0x005196DF, 0x005CA1E7, 0x0063A5E6, 0x004584C0, 0x000D4A82, 0x002A4756, 0x00223F4E, 0x00263E4A, 0x0033413F, 0x00393E29, 0x00454422, 0x004F532A, 0x00515931, 0x00263129,
        0x00273321, 0x00465137, 0x006A6F5A, 0x0065675B, 0x00494A40, 0x00394130, 0x003A482C, 0x00373E29, 0x00292E19, 0x00686654, 0x00989384, 0x00978E84, 0x007F786F, 0x00A3A098, 0x0094928A, 0x007B7268, 0x007D746A, 0x00888277, 0x00A19D92, 0x0097958A,
        0x006C6C60, 0x004D4F43, 0x001D1F13, 0x0023261D, 0x0024281C, 0x002B311E, 0x00373F21, 0x003D4822, 0x00424D1F, 0x004B5923, 0x0055642B, 0x004A5A2A, 0x00404A2C, 0x00999B95, 0x00AFB0B4, 0x00A3A5A6, 0x00A9AFAA, 0x00AAAFAD, 0x00B5B9BA, 0x008A9184,
        0x00465236, 0x0067784C, 0x006D804F, 0x006B7C51, 0x00717F5B, 0x006B7A54, 0x004D5E33, 0x00747A67, 0x00C1C3C3, 0x00BDC1C6, 0x00BCC5C2, 0x00BBC5BF, 0x00C1C6C9, 0x00BEC2BD, 0x00575F48, 0x00636E4D, 0x00717C5B, 0x00687450, 0x00475231, 0x002E381A,
        0x004B533C, 0x00686E5D, 0x006E7266, 0x005D6953, 0x00677160, 0x00656E61, 0x00666D66, 0x006E746F, 0x00666C67, 0x005D635E, 0x00646B64, 0x00616C58, 0x005D6756, 0x006C7366, 0x0071746B, 0x0060605A, 0x0054514C, 0x005E5B53, 0x00747268, 0x00737169,
        0x00706F65, 0x0059594B, 0x00656656, 0x00767767, 0x00606052, 0x005F5E54, 0x0076746C, 0x006E6D5F, 0x00535146, 0x00535146, 0x00504E43, 0x004F4E40, 0x00494A36, 0x0036391F, 0x003F4425, 0x00444940, 0x00747A75, 0x00AFB7B7, 0x00B5BFC6, 0x00B1BAC4,
        0x00A8AEB9, 0x00AEB0BB, 0x00B2B3BD, 0x00A9B3BA, 0x00ADB9BB, 0x00A8B4B4, 0x00B0B8BF, 0x00B0B6C3, 0x00B2B9C2, 0x00A5B0A8, 0x006A7A63, 0x00677650, 0x0068784F, 0x0067784D, 0x0068794E, 0x0066754F, 0x0042502E, 0x00232F13, 0x00343E27, 0x00494C33,
        0x0043462D, 0x00444630, 0x00484935, 0x00474735, 0x00474735, 0x004A4A3A, 0x004B4B3B, 0x004C4C3A, 0x004A4A38, 0x00434331, 0x003F3F2D, 0x00353523, 0x00222210, 0x002E2E1C, 0x00565644, 0x00434630, 0x0042462D, 0x003E4328, 0x003C4124, 0x003A3F24,
        0x00373B22, 0x003D3F2B, 0x00484939, 0x003F412D, 0x00444632, 0x00383A26, 0x00424431, 0x00464835, 0x00484A37, 0x003F4030, 0x00383929, 0x00353B28, 0x003D3B1D, 0x003D422D, 0x00424C3C, 0x00424125, 0x00393D24, 0x00394434, 0x003B3D20, 0x00363C1D,
        0x0040452A, 0x00434531, 0x00444535, 0x004E4E42, 0x0049493D, 0x00474739, 0x00505141, 0x004A493F, 0x0048483A, 0x0041442E, 0x003E4326, 0x00444A2B, 0x00494E33, 0x00454734, 0x00414133, 0x0051523E, 0x00474735, 0x00414032, 0x00444237, 0x00464439,
        0x00454436, 0x00454533, 0x00454632, 0x00464634, 0x00454535, 0x003D3E2E, 0x003D3F2C, 0x00444731, 0x00666E4F, 0x006E7953, 0x006E7A50, 0x006E7B55, 0x00728057, 0x00707E54, 0x00717E58, 0x006B7656, 0xFFE9EFDC, 0xFFFEFFFB, 0xFFFDFCFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x6BA7CCEE, 0x00639EDC, 0x0057A2F1, 0x005AA2EF, 0x005DA4EE, 0x0059A6F5, 0x0056A5F4, 0x00559DE5, 0x00599DE8, 0x005A9EE9, 0x005CA0EB, 0x005B9FEA, 0x005A9EE9,
        0x00589CE7, 0x00579BE6, 0x00579BE6, 0x005C9EE5, 0x005DA1EA, 0x00579CE5, 0x00569BE4, 0x00599EE4, 0x005C9EDF, 0x004584C1, 0x0014508B, 0x00285576, 0x001B4667, 0x00163B55, 0x001E343A, 0x00292F1E, 0x003D3E1E, 0x004A4E2B, 0x003F4C2C, 0x0028312E,
        0x00364033, 0x004B543F, 0x004A4D3D, 0x0037382F, 0x00373731, 0x0031382B, 0x001C2911, 0x00282F1A, 0x002D2F1C, 0x002F2D1B, 0x00787162, 0x00978F82, 0x00958F84, 0x009F9A91, 0x0086847A, 0x00877E75, 0x00867D74, 0x00857E75, 0x00908B82, 0x008E8C82,
        0x009B9A90, 0x00A7A89E, 0x004A4B41, 0x0024281C, 0x001C2014, 0x001E2413, 0x002D351E, 0x003B4324, 0x00424D25, 0x00515D2D, 0x00626E3C, 0x00566734, 0x00424C2E, 0x009D9F99, 0x00BBBABE, 0x00AFB1B1, 0x00B4B8B3, 0x00B4BAB5, 0x00C6CBCA, 0x0092998C,
        0x00445034, 0x006B7C50, 0x00738655, 0x006F8055, 0x006D7B57, 0x005B6A44, 0x0044552A, 0x00898D7A, 0x00D1D3D3, 0x00C7CACF, 0x00BFC9C3, 0x00BDC7C1, 0x00C8CBCF, 0x00C9CDC8, 0x00626851, 0x005B6A3E, 0x006F7E52, 0x0067754B, 0x00404E25, 0x003D4827,
        0x005F684E, 0x009AA08F, 0x00C1C5BA, 0x00AEB5A0, 0x00B6BCAB, 0x00B7BBB0, 0x009FA09C, 0x007F807E, 0x00747571, 0x0073766D, 0x006A6E62, 0x005F644F, 0x00686B5B, 0x00808177, 0x007E7E78, 0x0053524E, 0x00474741, 0x0065675B, 0x00737667, 0x00736F6E,
        0x00706D68, 0x005A5A4E, 0x0068685A, 0x00737365, 0x0059594D, 0x00595651, 0x006C6867, 0x006B6B5F, 0x0059584E, 0x0067665C, 0x0066665A, 0x005E5F4F, 0x0051543E, 0x003C4124, 0x004C5332, 0x004A524B, 0x00828B88, 0x00ABB7B7, 0x00AFBBC1, 0x00B1BCC4,
        0x00A7B0BA, 0x00B3B8C1, 0x00B7BAC2, 0x00AFB8C1, 0x00AFBABE, 0x00AAB5B9, 0x00AEB4BF, 0x00ACB0C2, 0x00AFB5C2, 0x00A2ACA6, 0x006D7D66, 0x00687751, 0x0067774E, 0x0064744B, 0x0064744B, 0x0064734D, 0x00445131, 0x00293519, 0x003E4831, 0x0047492B,
        0x00414325, 0x00414326, 0x0045462C, 0x0044442C, 0x00484732, 0x004B4A35, 0x00494834, 0x00474B2E, 0x0045492C, 0x0043472A, 0x0043472A, 0x003C4023, 0x002F3316, 0x003D4124, 0x005F6346, 0x0059603D, 0x0058603B, 0x00555E36, 0x00576038, 0x005A613E,
        0x00585D42, 0x005C5E4B, 0x0069695D, 0x0051543E, 0x00545741, 0x00484B35, 0x00545642, 0x005B5D49, 0x00616350, 0x005C5E4B, 0x00595B48, 0x00414C32, 0x0058522D, 0x00575B48, 0x005B665E, 0x00666148, 0x0052553F, 0x00435544, 0x004B5029, 0x00535843,
        0x006E7161, 0x0076786C, 0x00595A50, 0x00565950, 0x0042483D, 0x00455040, 0x0052604E, 0x006B6961, 0x006D6E5E, 0x0060644B, 0x004F5635, 0x004D5433, 0x004F5437, 0x004C4E3A, 0x0049493B, 0x004C4D39, 0x004D4D3B, 0x00504F41, 0x00555348, 0x0057554A,
        0x00555446, 0x00525240, 0x0050513D, 0x00535341, 0x00525242, 0x0050523F, 0x004C4E3A, 0x004D5237, 0x006A7450, 0x006E7B4F, 0x006C7A4A, 0x006F7C56, 0x00717F56, 0x006E7C52, 0x00707D57, 0x006B7656, 0xFFE9EFDC, 0xFFFEFFFB, 0xFFFDFCFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x6BA7CCEE, 0x00639EDC, 0x0058A2F4, 0x0058A2F0, 0x005DA4EE, 0x0059A6F5, 0x0056A5F6, 0x00559DE5, 0x00599DE8, 0x005B9FEA, 0x005CA0EB, 0x005CA0EB, 0x005A9EE9,
        0x00589CE7, 0x00579BE6, 0x00579BE6, 0x005D9FE6, 0x00569AE3, 0x00579BE6, 0x005CA3ED, 0x00569CE2, 0x005697DB, 0x005F9EDB, 0x005793CE, 0x003C85C9, 0x00448BCE, 0x004584BE, 0x00305B7C, 0x00192F34, 0x001E2D1F, 0x00243625, 0x00122C1F, 0x001F2726,
        0x00404A3E, 0x00464E3D, 0x00212415, 0x0020201A, 0x005F5D5C, 0x00646A5F, 0x00232F19, 0x00272C17, 0x00232512, 0x0033311F, 0x004D4637, 0x008A8275, 0x00918B7E, 0x00928E83, 0x008D8B80, 0x00867D74, 0x00898077, 0x008B847B, 0x0079746B, 0x00838177,
        0x009D9C92, 0x00B0B1A7, 0x00A4A59B, 0x00333A2B, 0x0024291A, 0x001E2413, 0x002A311C, 0x00363D22, 0x003B4521, 0x004B552B, 0x005E693B, 0x00606F3C, 0x00394424, 0x00898C83, 0x00ACABAD, 0x00AEB0B0, 0x00BABEB9, 0x00B2B8B3, 0x00B9BEBD, 0x00858C7F,
        0x00404C30, 0x006A7B4F, 0x006F8251, 0x006F8055, 0x0063714D, 0x004B5A34, 0x00526338, 0x00868A77, 0x00C5C7C7, 0x00C0C3C8, 0x00CAD4CE, 0x00C6D0CA, 0x00BEC2C3, 0x00B7BBB5, 0x00555B42, 0x00657841, 0x00748750, 0x0072844F, 0x00536334, 0x004F5D34,
        0x00444E30, 0x005C624F, 0x007C8172, 0x00979B82, 0x00A1A390, 0x00B9B9AD, 0x00ACAAA2, 0x0086837E, 0x008C8B81, 0x00929383, 0x006F715D, 0x00676652, 0x008F8F7F, 0x00C3C1B7, 0x00B8B5B1, 0x00676662, 0x00484B42, 0x006A7162, 0x006F7864, 0x006D6869,
        0x006D6A66, 0x005A594F, 0x00626254, 0x0068685A, 0x0059584E, 0x00615E5A, 0x00696465, 0x006A6C60, 0x0053544A, 0x005E5F55, 0x005D5F53, 0x00565949, 0x00494F38, 0x0031391B, 0x00404928, 0x00636E66, 0x00A7B5B1, 0x00B4C1C3, 0x00A0AEB4, 0x00B1BEC6,
        0x00ABB6BE, 0x00AFB7BE, 0x00B4BAC1, 0x00B2BAC7, 0x00B1BAC3, 0x00B0B9C3, 0x00AFB3C5, 0x00ABACC6, 0x00AFB3C6, 0x009EA6A6, 0x006B7967, 0x0066754F, 0x00687751, 0x0068784F, 0x006A7A51, 0x00687751, 0x00435030, 0x00222D13, 0x00333D26, 0x003F4320,
        0x003D411E, 0x00404323, 0x00424426, 0x00434528, 0x00494A30, 0x004B4B33, 0x0043432B, 0x00424825, 0x00404623, 0x003F4522, 0x00414724, 0x003D4320, 0x00383E1B, 0x00484E2B, 0x00636946, 0x00626C41, 0x005E693B, 0x00596436, 0x005B6638, 0x005C653D,
        0x0052573A, 0x004D4F3C, 0x00545349, 0x004E5239, 0x00535640, 0x00454832, 0x004A4D37, 0x00494B37, 0x004E503C, 0x0050523F, 0x00565845, 0x003F4D31, 0x00524C23, 0x003D4332, 0x00404B49, 0x005A543D, 0x004F523C, 0x003D5341, 0x004B5225, 0x004D4A3B,
        0x005D5A4C, 0x00666257, 0x00524E43, 0x00595A4A, 0x00313823, 0x00313F23, 0x00475A39, 0x005A5850, 0x00656656, 0x005C6146, 0x00444B28, 0x0039401D, 0x003D4225, 0x00434531, 0x0049493B, 0x00484935, 0x004D4D3B, 0x004D4C3E, 0x004A483D, 0x004A483D,
        0x004C4B3D, 0x004C4C3A, 0x004B4C38, 0x004F4F3F, 0x00505040, 0x00515340, 0x004B4E38, 0x00484D30, 0x0066714B, 0x006E7B4D, 0x0071814C, 0x006E7B55, 0x006F7D54, 0x006C7A50, 0x006F7C56, 0x006B7656, 0xFFE9EFDC, 0xFFFEFFFB, 0xFFFEFDFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x4C97C1EB, 0x00629FE1, 0x0056A0F2, 0x005EA2ED, 0x0064A6ED, 0x005DA5F3, 0x005BA5F7, 0x00579BE6, 0x00589BE6, 0x005C9FEA, 0x00599DE8, 0x005DA1EC, 0x005CA0EB,
        0x00569DE7, 0x005AA1EB, 0x00579EE8, 0x00619FE5, 0x0063A3EA, 0x005D9EE8, 0x005697E1, 0x005A9AE1, 0x00629FE3, 0x00629DDB, 0x006097D4, 0x005D9CCF, 0x006396D5, 0x005993C7, 0x004B90C2, 0x003C73A6, 0x00274A4E, 0x00314B23, 0x0024381B, 0x001B1F13,
        0x00262919, 0x002C2E1A, 0x004A4D34, 0x002A2E15, 0x00454B34, 0x0047503B, 0x001E2A16, 0x00262913, 0x002E301C, 0x00323421, 0x00757666, 0x00848478, 0x0086857B, 0x008D8B83, 0x00908D88, 0x00938D82, 0x00888178, 0x008C877E, 0x00807B72, 0x007D7A72,
        0x009F9C94, 0x00AAA7A2, 0x00999691, 0x006A6860, 0x00252713, 0x00262C15, 0x0026281C, 0x002D3320, 0x003C4A20, 0x00445522, 0x00536439, 0x00626946, 0x00404724, 0x00464D2A, 0x004A5130, 0x00606746, 0x00717758, 0x00666C4D, 0x00646A4B, 0x006A715C,
        0x00464F34, 0x00798463, 0x00727F59, 0x0067754C, 0x00505C38, 0x00606B4B, 0x005A6348, 0x00686B5C, 0x00585B4B, 0x006F7360, 0x008F947F, 0x008B907B, 0x00696D5A, 0x00636656, 0x00525546, 0x0061704A, 0x006F7E58, 0x006E7E55, 0x0066744B, 0x004D5B31,
        0x0039461A, 0x00303D0F, 0x003C491B, 0x00576732, 0x0051622F, 0x004A5B2F, 0x0043572D, 0x003E5431, 0x00395133, 0x00314A30, 0x002A442C, 0x00314C2A, 0x00385030, 0x00405639, 0x00425038, 0x00454E3A, 0x00525546, 0x00636156, 0x007D786F, 0x0077746C,
        0x00726F67, 0x005A584E, 0x006A685D, 0x00666557, 0x005B5A4C, 0x00626252, 0x006F6F5D, 0x0067655A, 0x00545247, 0x00656359, 0x006D6B61, 0x005B594E, 0x00484836, 0x003A3D24, 0x00424629, 0x00687069, 0x00A9B1B0, 0x00ABB3BA, 0x00AAB2BF, 0x00B7BDC8,
        0x00BDC5C5, 0x00ABB4A7, 0x00979E89, 0x00889A6B, 0x00869470, 0x0096A488, 0x00AFBAAA, 0x00B9BDC8, 0x00A9A9C7, 0x00A2ADB1, 0x00667E5B, 0x0068754F, 0x006B7B52, 0x00697C51, 0x00667A50, 0x0062754E, 0x00424F2F, 0x00262D12, 0x00383B25, 0x003C3E21,
        0x003E4022, 0x00414424, 0x00434724, 0x00434724, 0x00424426, 0x0043442A, 0x0044442C, 0x00404526, 0x00444629, 0x0045442A, 0x00454128, 0x00424022, 0x003B3F1C, 0x00495329, 0x00637042, 0x005D6C40, 0x005B6B3C, 0x00586936, 0x005A6B38, 0x005B6A3E,
        0x004E5939, 0x00434A35, 0x0044483C, 0x004A5443, 0x00444B3C, 0x005A6739, 0x0055632D, 0x0042452F, 0x004D5040, 0x003E492F, 0x00485046, 0x004C5834, 0x004A5D26, 0x0047532F, 0x003E4433, 0x004D563C, 0x00424934, 0x00545D43, 0x004D6126, 0x00475630,
        0x00414B34, 0x00494F44, 0x00474C43, 0x0058614C, 0x00515D3F, 0x00596646, 0x00455135, 0x004B514C, 0x0069735C, 0x005C6C3D, 0x00475924, 0x0039461A, 0x00404627, 0x0045482F, 0x004B4D37, 0x004B4E38, 0x004C4E3A, 0x004D4F3B, 0x004C4E3B, 0x004B4D3A,
        0x004B4C3C, 0x004C4D3D, 0x004E4E40, 0x004D4C38, 0x0051503C, 0x004C4C3A, 0x00494B37, 0x004D533A, 0x00687353, 0x00697650, 0x0066774C, 0x006E7C52, 0x006F7E52, 0x00707F53, 0x00728056, 0x00677252, 0xFFE6ECD9, 0xFFFFFFFC, 0xFFFEFDFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x4C97C1EB, 0x0060A0E1, 0x0056A0F2, 0x005EA2ED, 0x0064A6ED, 0x005BA5F3, 0x005BA5F7, 0x00579BE6, 0x00589BE6, 0x005C9FEA, 0x00599DE8, 0x005CA0EB, 0x005A9EE9,
        0x00549BE5, 0x00579EE8, 0x00559CE6, 0x005B99DF, 0x005B9BE2, 0x005A9BE5, 0x005899E3, 0x005E9EE5, 0x00619EE2, 0x004C87C5, 0x003067A4, 0x0030699C, 0x003764A1, 0x00477EB1, 0x005798CB, 0x005388BB, 0x003A5A60, 0x003C5431, 0x0031442B, 0x00212519,
        0x00363929, 0x00363824, 0x005C5F46, 0x003B3E25, 0x00313720, 0x00303924, 0x001C2814, 0x00292C16, 0x00222410, 0x003C3E2B, 0x00828373, 0x008C8C80, 0x00919086, 0x0087857D, 0x007E7B76, 0x00969085, 0x00898279, 0x0089847B, 0x00807B72, 0x007A776F,
        0x00928F87, 0x00A09D98, 0x009F9C97, 0x007D7B73, 0x00353723, 0x002B311A, 0x00232519, 0x00242A17, 0x0038461C, 0x00475825, 0x005E6C42, 0x00616A42, 0x004B532E, 0x004B532E, 0x00424A25, 0x003D4421, 0x004B522F, 0x00444B2A, 0x004D5433, 0x00646D53,
        0x00636D4F, 0x006C7854, 0x0068764D, 0x00556339, 0x0058653F, 0x00465130, 0x003F4A2A, 0x00686E57, 0x004C5239, 0x004D5439, 0x00575E43, 0x00565D42, 0x004D5439, 0x00595F46, 0x00545A43, 0x0065764B, 0x006D7E53, 0x0075865B, 0x006A784F, 0x004F5C36,
        0x00353F1B, 0x00343E1A, 0x003F4925, 0x00455127, 0x003B461E, 0x002F3C16, 0x00263412, 0x001C2B0C, 0x00142308, 0x0012220A, 0x0015250E, 0x000F2209, 0x0016260E, 0x00121F09, 0x0018230F, 0x00424837, 0x00575A4B, 0x004E4E42, 0x00555348, 0x00626055,
        0x00636156, 0x00545247, 0x00666459, 0x005F5D52, 0x00514F44, 0x0057554A, 0x00656358, 0x006C6A5F, 0x0059574C, 0x006B695F, 0x00727066, 0x00605E53, 0x004B4B39, 0x003B3E25, 0x00424629, 0x0069706B, 0x00A6AEAE, 0x00A4ACB3, 0x00B1BAC4, 0x00B7BFC6,
        0x009BA59F, 0x007F8A76, 0x00768062, 0x00738459, 0x006E7C58, 0x0070805E, 0x008A9880, 0x00ABB2B5, 0x00B2B4CC, 0x009FAAAE, 0x00667E5C, 0x0068754F, 0x006B7B52, 0x00687B50, 0x0065794F, 0x0062754E, 0x00424F2F, 0x00262D12, 0x00383B25, 0x003B3D20,
        0x003D3F21, 0x003F4222, 0x003F4320, 0x00414522, 0x00434527, 0x0045462C, 0x0046462E, 0x00404427, 0x00434528, 0x00444329, 0x00454128, 0x00424022, 0x003B3F1C, 0x00485228, 0x005F6F40, 0x005C6B3F, 0x0059693A, 0x00556633, 0x00576737, 0x0058663C,
        0x00505B3B, 0x0049503B, 0x004E5246, 0x003E4838, 0x00464D3E, 0x00515E32, 0x0055632D, 0x00434630, 0x00484B3B, 0x00465137, 0x004B5349, 0x00525D3D, 0x00526330, 0x00434E2D, 0x003E4236, 0x004C533E, 0x003B4130, 0x00525944, 0x004F622B, 0x00485632,
        0x003F4932, 0x004E534A, 0x00474C43, 0x005C6551, 0x005F6B4D, 0x005C684A, 0x00465236, 0x004C524D, 0x0068725B, 0x005B6B3C, 0x00475924, 0x0039461A, 0x00404627, 0x0045482F, 0x004B4D37, 0x00484B35, 0x00494B37, 0x004B4D39, 0x004B4D39, 0x004A4C39,
        0x004A4C39, 0x004B4C3C, 0x004C4D3D, 0x004C4B37, 0x00504F3B, 0x004C4C3A, 0x004A4C38, 0x004E543B, 0x006A7555, 0x006B7852, 0x0068794E, 0x006D7B51, 0x006E7D51, 0x006F7E52, 0x00717F55, 0x00687353, 0xFFE7EDDA, 0xFFFFFFFC, 0xFFFFFEFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x4896C2EB, 0x005F9FE0, 0x0056A0F2, 0x005CA3ED, 0x0062A7ED, 0x005BA5F3, 0x005BA5F7, 0x00549BE5, 0x00589BE6, 0x005C9FEA, 0x00589CE7, 0x005B9FEA, 0x00599DE8,
        0x005299E3, 0x00559CE6, 0x005299E3, 0x0062A0E6, 0x005E9EE5, 0x005C9DE7, 0x00579BE4, 0x005B9DE4, 0x005F9EE2, 0x00417CBA, 0x000F4885, 0x00093B69, 0x00123872, 0x003B6C9E, 0x005794C6, 0x005584BA, 0x003B5A63, 0x003B5232, 0x00344530, 0x004A4E42,
        0x00696C5C, 0x004C4D39, 0x005D6047, 0x0045482F, 0x00333922, 0x00353E29, 0x00202B17, 0x00292B15, 0x0030311D, 0x004A4A38, 0x00777767, 0x008C8A7F, 0x009B998F, 0x0087847C, 0x00898580, 0x00908A7F, 0x00867F76, 0x0088837A, 0x0089847B, 0x00838078,
        0x008A877F, 0x009A9792, 0x00ABA8A3, 0x0094928A, 0x00464834, 0x00353822, 0x002D2F23, 0x00292D1A, 0x0037451B, 0x00435421, 0x005D6B41, 0x006A7449, 0x005A643A, 0x00555F35, 0x00535D33, 0x00454E26, 0x0059623A, 0x0048502B, 0x00545C37, 0x00566141,
        0x00636F4B, 0x006D7B52, 0x004D5B31, 0x00546337, 0x00505E34, 0x00606E45, 0x005F6C46, 0x0068724E, 0x00545E3A, 0x0057613D, 0x005A6440, 0x005B6541, 0x005D6743, 0x00626C48, 0x005B6541, 0x00657845, 0x00677A49, 0x00708155, 0x005F6C46, 0x00535E3E,
        0x003F452C, 0x00424732, 0x003E422F, 0x00474F31, 0x00434A2F, 0x00464D32, 0x004E5239, 0x004C4F39, 0x00434531, 0x003F412D, 0x00434532, 0x00414637, 0x003B4031, 0x00333829, 0x0036392A, 0x004B4E3F, 0x00575A4B, 0x004E4E40, 0x004E4E40, 0x00474735,
        0x00505040, 0x004F4F3F, 0x00676658, 0x00626055, 0x00555349, 0x005B5850, 0x006D6964, 0x00666459, 0x00555348, 0x0067655B, 0x00706E64, 0x005E5C51, 0x00494937, 0x00383B22, 0x003F4326, 0x00686E6D, 0x00AAB1B4, 0x00A8B0B7, 0x00B4BDC6, 0x00A9B3B3,
        0x00788577, 0x00687758, 0x00707E54, 0x006B7A54, 0x0072815B, 0x00687A51, 0x00687A55, 0x00848F85, 0x00B2B7C6, 0x009EAAAC, 0x00677D60, 0x0068754F, 0x006A7A51, 0x00677A4F, 0x0065794F, 0x0062754E, 0x00414E2E, 0x00262D12, 0x00393C26, 0x003A3C1F,
        0x003C3E20, 0x003C3F1F, 0x003B3F1C, 0x003E421F, 0x00454729, 0x0048492F, 0x0047472F, 0x00404528, 0x0041442A, 0x00434228, 0x00454128, 0x00414024, 0x003C401D, 0x00465228, 0x005D6C40, 0x005B693F, 0x0059693A, 0x00556535, 0x00576737, 0x0059673D,
        0x00515C3C, 0x004D5340, 0x0053574B, 0x00414A3D, 0x004B5245, 0x00546036, 0x0055622E, 0x00464834, 0x004E5142, 0x00454F38, 0x004D534E, 0x004F583D, 0x00526233, 0x0040492E, 0x0041433D, 0x00515647, 0x00494D42, 0x005A5F50, 0x004C5C2C, 0x00465430,
        0x003F4833, 0x0050554C, 0x004A4E48, 0x00636B5A, 0x00697559, 0x005F6B4D, 0x00465137, 0x004E544F, 0x0067715A, 0x005A6A3B, 0x00465823, 0x00384519, 0x003F4526, 0x00464930, 0x004B4D37, 0x00464733, 0x00484935, 0x004A4B37, 0x004A4B37, 0x004A4B37,
        0x00494A36, 0x00494A36, 0x004A4B37, 0x004A4934, 0x004F4E3A, 0x004B4C38, 0x00494B37, 0x004E543B, 0x006B7656, 0x006C7953, 0x006A7B50, 0x006E7C52, 0x006E7D51, 0x006E7D51, 0x00717F55, 0x00697454, 0xFFE9EFDC, 0xFFFFFFFC, 0xFFFFFEFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x4896C2EB, 0x005F9FE0, 0x0054A0F2, 0x005BA2EC, 0x0062A7ED, 0x005BA5F3, 0x0059A5F7, 0x00549BE5, 0x00579AE5, 0x005C9FEA, 0x00589CE7, 0x005B9FEA, 0x00599DE8,
        0x00539AE4, 0x00569DE7, 0x00539AE4, 0x005C9DE2, 0x00599BE2, 0x00599DE6, 0x00579BE4, 0x005A9CE3, 0x0063A2E6, 0x004784C2, 0x00124B88, 0x00154470, 0x001D4078, 0x004A78A8, 0x005C97C9, 0x00507EB4, 0x003C5962, 0x003D5336, 0x00394937, 0x0064665A,
        0x00878878, 0x00585945, 0x005C5C44, 0x004B4E35, 0x003B3E28, 0x00444B36, 0x0028331F, 0x002E301A, 0x00333420, 0x004A4A38, 0x00737363, 0x00817F74, 0x0086847A, 0x007B7870, 0x00898580, 0x00898378, 0x00847D74, 0x008A857C, 0x00959087, 0x008F8C84,
        0x0088857D, 0x0095928D, 0x00B2AFAA, 0x00A3A098, 0x004D4E3A, 0x00343721, 0x003C3C30, 0x00333724, 0x0039451B, 0x003C4D1A, 0x005A683E, 0x00667345, 0x00687547, 0x006C794B, 0x00727F53, 0x00515E32, 0x00626E44, 0x00566238, 0x0078845A, 0x00717E58,
        0x006D7B52, 0x00515F35, 0x0057663A, 0x004B5A2E, 0x00657448, 0x006E7D51, 0x006F7E52, 0x00718152, 0x006B7A4E, 0x00748258, 0x00748259, 0x00748259, 0x0078865C, 0x0077865A, 0x00708051, 0x006E844A, 0x006A7E49, 0x00647647, 0x00404C28, 0x004B543A,
        0x00555848, 0x00787970, 0x0083837D, 0x006C705D, 0x006E705D, 0x00727461, 0x00777765, 0x00777563, 0x00706C5A, 0x006B6453, 0x00696251, 0x006D6964, 0x005B5850, 0x006C6961, 0x006E6D63, 0x0056564A, 0x00505344, 0x00505343, 0x00434636, 0x0042442E,
        0x004C4D39, 0x0050503E, 0x006A695B, 0x0067655B, 0x005A5651, 0x005B5653, 0x006C6766, 0x00666459, 0x00545247, 0x0068665C, 0x00716F65, 0x00605E53, 0x004D4D3B, 0x003E4128, 0x0045492C, 0x00666B6C, 0x00AEB4B9, 0x00ACB4BB, 0x00B0BAC1, 0x0096A29C,
        0x00697962, 0x006B7D54, 0x00738550, 0x00717F5B, 0x0075845E, 0x00708455, 0x00657B4B, 0x00687762, 0x00A7AEB7, 0x009EAAAC, 0x006B8067, 0x00697650, 0x00697950, 0x0066794E, 0x0065794F, 0x0062754E, 0x00414E2E, 0x00262D12, 0x003A3D27, 0x00393B1E,
        0x003C3E20, 0x003C3F1F, 0x00393D1A, 0x003C401D, 0x00444628, 0x0047482E, 0x0045452D, 0x00414629, 0x0042452B, 0x0042422A, 0x0045432B, 0x00434226, 0x003D4222, 0x0047522A, 0x005C6B3F, 0x005C6A40, 0x005B6A3E, 0x00596939, 0x005B6B3B, 0x005B693F,
        0x00525D3D, 0x004C523F, 0x0052564B, 0x00485246, 0x004C544A, 0x00546239, 0x00505E2E, 0x00454838, 0x0055594D, 0x003D4834, 0x004E5552, 0x00464F3A, 0x003C4C23, 0x003E4732, 0x00444745, 0x00464C41, 0x00464A44, 0x004C5247, 0x0045562A, 0x00455331,
        0x004C5541, 0x00525650, 0x00494D48, 0x00616958, 0x00646F55, 0x00677357, 0x0049533C, 0x00525853, 0x0067715A, 0x00586839, 0x00465823, 0x00374418, 0x003F4526, 0x00464930, 0x004B4D37, 0x00444531, 0x00464733, 0x00484A34, 0x00494B35, 0x00474933,
        0x00464832, 0x00454731, 0x0045482F, 0x00464530, 0x004B4A35, 0x00494A36, 0x00474A34, 0x004D5439, 0x006A7554, 0x006C7A51, 0x006B7C50, 0x00707E54, 0x006F7E52, 0x006E7D51, 0x00717F55, 0x00687353, 0xFFE8EEDB, 0xFFFFFFFC, 0xFFFFFEFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x4593C1EA, 0x005D9FE0, 0x00539FF1, 0x0059A2EC, 0x0061A6EC, 0x005AA5F3, 0x0059A5F7, 0x00529BE5, 0x00579AE5, 0x005C9FEA, 0x00599DE8, 0x005CA0EB, 0x005B9FEA,
        0x00559CE6, 0x0059A0EA, 0x00569DE7, 0x005C9DE2, 0x005A9CE3, 0x005B9FE8, 0x00589DE6, 0x00599EE4, 0x0061A0E4, 0x00427FBD, 0x000D4683, 0x00154674, 0x00163B75, 0x00426FA2, 0x005792C4, 0x004F7DB3, 0x003D5A63, 0x00415636, 0x003F4E39, 0x005E6054,
        0x007D7E6E, 0x0062614D, 0x006B6B53, 0x005A5A42, 0x003A3D27, 0x00474E39, 0x0038412D, 0x003A3924, 0x002A2915, 0x0042402E, 0x00827F70, 0x0089857A, 0x007E7970, 0x007E7871, 0x00817B76, 0x00888277, 0x00857E75, 0x00858077, 0x008F8A81, 0x008B8880,
        0x00827F77, 0x00928F8A, 0x00B0ADA8, 0x0099968E, 0x00464733, 0x002E301A, 0x00444438, 0x00393B28, 0x003B471D, 0x00404F1C, 0x00647046, 0x006B7949, 0x006C7A4A, 0x006D7A4C, 0x00748153, 0x004B582C, 0x00576438, 0x004E5B2F, 0x007D895F, 0x00717F55,
        0x0067754B, 0x0046542A, 0x005B693F, 0x0057653B, 0x00718054, 0x00758556, 0x00718151, 0x00708050, 0x00728155, 0x0076845B, 0x0077835F, 0x00727E5A, 0x0075835A, 0x0077865A, 0x00798959, 0x0070854E, 0x0070844F, 0x0066774B, 0x00404C28, 0x004B543A,
        0x00555849, 0x008A8B82, 0x00B1B0AC, 0x00B1B5A2, 0x00B6BAA7, 0x00B5B7A4, 0x00A7A795, 0x00949280, 0x00817F6D, 0x00736F5D, 0x006B6453, 0x005C5853, 0x0059564E, 0x007F7C74, 0x00848379, 0x005E5E52, 0x00575A4B, 0x00535646, 0x00353828, 0x0041432D,
        0x00474834, 0x004C4C3A, 0x00676658, 0x0067655B, 0x005D5954, 0x00595451, 0x00686362, 0x0067655A, 0x00545247, 0x0066645A, 0x006F6D63, 0x005E5C51, 0x004C4C3A, 0x003E4128, 0x00464A2D, 0x00686D70, 0x00A9AFB4, 0x00A9B0B9, 0x00ADB8BC, 0x008B9791,
        0x0063735B, 0x006B7E53, 0x006C7F48, 0x00748260, 0x0063724C, 0x006A7F4E, 0x006A814D, 0x00617159, 0x009FA7AE, 0x009EAAAC, 0x006C8069, 0x00697650, 0x0068784F, 0x0065784D, 0x0065794F, 0x0062754E, 0x00404D2D, 0x00262D12, 0x003B3E28, 0x003A3C1F,
        0x003C3E20, 0x003C3F1F, 0x003A3E1B, 0x003C401D, 0x00414325, 0x0043442A, 0x0042422A, 0x0041482D, 0x0044472E, 0x0045452D, 0x0048462E, 0x0045462C, 0x003F4424, 0x0046542B, 0x005B6C41, 0x005D6B42, 0x005D6C40, 0x005B6B3C, 0x005C6C3D, 0x005B6940,
        0x00525C3E, 0x004E5443, 0x00565A4F, 0x00586157, 0x00676E67, 0x00525E3A, 0x00556234, 0x004B4E3F, 0x0054574E, 0x00535D4C, 0x006B7170, 0x005A634F, 0x00374620, 0x004B5440, 0x00505253, 0x0051554F, 0x006D706E, 0x005A5E58, 0x0046562D, 0x00424F2F,
        0x00505847, 0x00525651, 0x006A6D6B, 0x007A8172, 0x00535D46, 0x00606B51, 0x004B543F, 0x00585E59, 0x0068725B, 0x00576738, 0x00465823, 0x00364317, 0x003F4526, 0x00474A31, 0x004A4C36, 0x00474632, 0x00494834, 0x004A4934, 0x004A4A32, 0x0047472F,
        0x0044452B, 0x00424329, 0x00424427, 0x0043432B, 0x00494833, 0x00464832, 0x00454832, 0x004C5338, 0x006A7554, 0x006C7A51, 0x006A7B4F, 0x00717F55, 0x00718054, 0x006F7E52, 0x00717F55, 0x00677252, 0xFFE6ECD9, 0xFFFFFFFC, 0xFFFEFDFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x4593C1EA, 0x005D9FE0, 0x0051A0F1, 0x0059A2EC, 0x0060A6EC, 0x0059A4F2, 0x0056A5F6, 0x00529BE5, 0x00589BE6, 0x005C9FEA, 0x005A9EE9, 0x005DA1EC, 0x005CA0EB,
        0x00569DE7, 0x005AA1EB, 0x00589FE9, 0x0065A8ED, 0x005EA3E9, 0x005A9FE8, 0x00589DE6, 0x005A9FE5, 0x005E9FE3, 0x004483C0, 0x001B5793, 0x001B5186, 0x00174281, 0x0037699E, 0x00508FC2, 0x005282B6, 0x003E5B60, 0x0040522D, 0x0038452B, 0x00616155,
        0x00777767, 0x0064634F, 0x00626048, 0x0056563E, 0x0042442E, 0x00545944, 0x004A533F, 0x0033321D, 0x003B3A26, 0x00393725, 0x005C594A, 0x00827E73, 0x008A857C, 0x00868079, 0x0087817C, 0x00857F74, 0x00847D74, 0x007D786F, 0x00817C73, 0x00817E76,
        0x00838078, 0x0096938E, 0x00A8A5A0, 0x007A746D, 0x00474834, 0x0040422C, 0x0058564B, 0x003E402D, 0x00454F25, 0x00485724, 0x0069754B, 0x006C7C4D, 0x0069794A, 0x00677748, 0x006D7C50, 0x004F5E32, 0x0059673D, 0x004B592F, 0x00738157, 0x006E7D51,
        0x0069774D, 0x0058653F, 0x004F5C36, 0x0065724C, 0x006A784E, 0x00758556, 0x00697949, 0x0057683D, 0x005C6B45, 0x00596547, 0x00657056, 0x005F6A50, 0x00556143, 0x00586741, 0x00617247, 0x006D804F, 0x006B7D4E, 0x006E7F54, 0x00636F4B, 0x00626B50,
        0x0050563F, 0x00676A5A, 0x00878A7B, 0x007B8567, 0x008B9479, 0x00929B80, 0x00889177, 0x007A826B, 0x00747B66, 0x00717863, 0x006E7461, 0x00707566, 0x009CA192, 0x00BCC1B2, 0x00959889, 0x00555849, 0x00444738, 0x004C4C3E, 0x00505042, 0x00444432,
        0x00464636, 0x004B4B3B, 0x00656456, 0x0069675C, 0x00626056, 0x005C5951, 0x006B6762, 0x0069675C, 0x00555348, 0x0066645A, 0x006D6B61, 0x005B594E, 0x00474735, 0x00393C23, 0x00414528, 0x00696E6F, 0x00A5ABB0, 0x00ACB3BC, 0x00B2BCC3, 0x008B9693,
        0x005C6C55, 0x0065774E, 0x00758653, 0x0073815F, 0x006B7955, 0x006F8354, 0x005E7443, 0x00596853, 0x009CA3AC, 0x00A3AEB2, 0x00697D66, 0x00697650, 0x0067774E, 0x0064774C, 0x0065794F, 0x0061744D, 0x003F4C2C, 0x00262D12, 0x003D402A, 0x003B3D20,
        0x003B3D1F, 0x003C3F1F, 0x003B3F1C, 0x003B3F1C, 0x003C3E20, 0x003F4026, 0x0042422A, 0x0042492E, 0x00454930, 0x00484732, 0x00494833, 0x0046472D, 0x003F4526, 0x0047542E, 0x005C6D42, 0x005F6D44, 0x005D6B41, 0x005A6A3B, 0x0059693A, 0x0058663D,
        0x00535D3F, 0x00555B4A, 0x0061645B, 0x00B3BDB7, 0x00BDC3BE, 0x005F6D4B, 0x005A663C, 0x004D4F43, 0x00575B55, 0x009CA696, 0x00C9D0D3, 0x0068735F, 0x003D4E29, 0x004C5743, 0x004B4F50, 0x00767D76, 0x00D1D6D4, 0x008E958E, 0x0036481F, 0x00505C3E,
        0x004C5344, 0x00636664, 0x00C3C6C4, 0x00CCD3C6, 0x00535C47, 0x00505A43, 0x005A634F, 0x005E645F, 0x0069735C, 0x00586839, 0x00475924, 0x00364317, 0x003E4425, 0x00474A31, 0x004A4C36, 0x00494834, 0x004A4935, 0x004A4934, 0x00484830, 0x0045462C,
        0x00424427, 0x00404224, 0x00404323, 0x0042422A, 0x00474631, 0x00454731, 0x00454930, 0x004B5335, 0x00697551, 0x006C7A50, 0x006A7C4D, 0x00717F55, 0x00718054, 0x00718054, 0x00717F55, 0x00657050, 0xFFE3E9D6, 0xFFFEFFFB, 0xFFFEFDFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x4593C1EA, 0x005A9EDF, 0x0051A0F1, 0x0057A2EC, 0x0060A6EC, 0x0057A5F2, 0x0056A5F6, 0x004F9AE4, 0x00599CE7, 0x005DA0EB, 0x005A9EE9, 0x005DA1EC, 0x005CA0EB,
        0x00569DE7, 0x0059A0EA, 0x00579EE8, 0x0061A4E9, 0x005BA0E6, 0x00569BE4, 0x00569BE4, 0x005CA1E7, 0x0062A3E7, 0x005B9AD7, 0x004C88C4, 0x004888C2, 0x004C80C3, 0x00538CC4, 0x005092C7, 0x00497CAE, 0x003B595A, 0x0044572C, 0x00374221, 0x00323226,
        0x00454535, 0x00403F2B, 0x0035331B, 0x003C3A22, 0x00393B25, 0x004F543F, 0x005B6450, 0x00696651, 0x00807C69, 0x00787462, 0x00656051, 0x007A7469, 0x00908980, 0x008A827B, 0x008D8480, 0x00888277, 0x008E877E, 0x00878279, 0x00878279, 0x0088857D,
        0x00908D85, 0x009A9792, 0x00928F8A, 0x00655F58, 0x00686753, 0x0073755F, 0x00747267, 0x003F3F2D, 0x004D572D, 0x0055612F, 0x006B754B, 0x00647347, 0x006D7B51, 0x00748258, 0x006D7B51, 0x004F5D34, 0x0057653C, 0x00505D37, 0x0077845E, 0x00748258,
        0x0067754C, 0x00485430, 0x00566141, 0x00576241, 0x007B8862, 0x00728155, 0x00617141, 0x004B5937, 0x00505B41, 0x0048503F, 0x00676D62, 0x00646A5F, 0x0048503F, 0x00444F35, 0x004C5A38, 0x00707F59, 0x00677650, 0x006D7C56, 0x00727E5A, 0x00626D4C,
        0x004F5738, 0x0051593A, 0x00596142, 0x004E5F34, 0x00506037, 0x004A5C35, 0x003D4E2C, 0x00324425, 0x00304328, 0x0032472E, 0x00344831, 0x002B3E25, 0x0036462E, 0x002D3A24, 0x00202B17, 0x00404635, 0x005B5E4F, 0x00535347, 0x004E4C41, 0x00504E43,
        0x00504E43, 0x00555348, 0x006A685D, 0x0069675C, 0x00615F54, 0x0059574C, 0x0069675C, 0x006E6C61, 0x005B594E, 0x006D6B61, 0x00747268, 0x00615F54, 0x004D4D3B, 0x003D4027, 0x0045492C, 0x00686D6E, 0x00A6ACB1, 0x00AEB5BE, 0x00B5BEC7, 0x009AA4A4,
        0x00667363, 0x005B6A4A, 0x00707F53, 0x00697755, 0x006E7C58, 0x0063764B, 0x004A5E34, 0x006A7769, 0x00A4A9B8, 0x00A1ACB0, 0x00697E65, 0x00697650, 0x0066764D, 0x0063764B, 0x0064784E, 0x0061744D, 0x003F4C2C, 0x00252C11, 0x003D402A, 0x003D3F22,
        0x003A3C1E, 0x003A3D1D, 0x003B3F1C, 0x00393D1A, 0x0037391B, 0x003D3E24, 0x0046462E, 0x0040462D, 0x00454930, 0x00484A34, 0x004A4934, 0x0044472E, 0x003E4425, 0x0046532D, 0x005A6D42, 0x005D6B42, 0x005D6B41, 0x005A693D, 0x0059683C, 0x0058653F,
        0x00545D42, 0x00585E4D, 0x00666960, 0x00E1EAE7, 0x00D8DFDC, 0x00647151, 0x00546239, 0x004C5045, 0x00636762, 0x00AEB8AB, 0x00EDF3F8, 0x006F7A66, 0x00556740, 0x005E6955, 0x005A5F5E, 0x008D958B, 0x00F1F7F2, 0x00A5ADA3, 0x0046592E, 0x00626E52,
        0x00565D4E, 0x006F7171, 0x00D4D6D6, 0x00DAE0D5, 0x0057604B, 0x00525B46, 0x006A735F, 0x00636964, 0x006B755E, 0x00586839, 0x00485A25, 0x00364317, 0x003E4425, 0x00474A31, 0x00494B35, 0x004C4835, 0x004C4835, 0x004B4833, 0x0049482E, 0x00464529,
        0x00434424, 0x00424321, 0x00424321, 0x0043432B, 0x00484830, 0x00464832, 0x00464A31, 0x004C5436, 0x006A7652, 0x006D7B51, 0x006C7E4F, 0x006F7D53, 0x00707F53, 0x00718054, 0x00707E54, 0x00636E4E, 0xFFE1E7D4, 0xFFFDFEFA, 0xFFFFFEFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x4593C1EA, 0x005A9EDF, 0x0051A0F1, 0x0056A1EB, 0x0060A6EC, 0x0057A5F2, 0x0056A5F6, 0x004F9AE4, 0x005A9DE8, 0x005EA1EC, 0x005A9EE9, 0x005DA1EC, 0x005B9FEA,
        0x00549BE5, 0x00579EE8, 0x00559CE6, 0x005C9FE4, 0x005CA1E7, 0x005BA0E9, 0x0058A0E8, 0x00599FE5, 0x005B9CE0, 0x005E9DDA, 0x0064A0DC, 0x004F96D5, 0x0065A0E6, 0x005897D1, 0x003379AE, 0x00255A8C, 0x002E4B48, 0x004A5C2D, 0x003A451F, 0x00535347,
        0x005F5F4F, 0x006B6754, 0x005F5D45, 0x0058563E, 0x00343620, 0x003C412C, 0x006A705D, 0x006F6C57, 0x00676350, 0x00969280, 0x008E897A, 0x00696358, 0x00807970, 0x00958D86, 0x00928985, 0x00938D82, 0x00A09990, 0x009E9990, 0x009C978E, 0x0099968E,
        0x009D9A92, 0x0097948F, 0x0076736E, 0x0069635C, 0x008F8E7A, 0x00A3A28D, 0x00848277, 0x00363624, 0x004D572D, 0x005E6A38, 0x006F794F, 0x006E7C52, 0x006F7D54, 0x006A784F, 0x0056643B, 0x00424F29, 0x00515E38, 0x00495531, 0x00636F4B, 0x006F7D53,
        0x004C5933, 0x00566141, 0x00566042, 0x00555F41, 0x00626E4A, 0x0077855B, 0x005B6B3C, 0x004F5A40, 0x005B6450, 0x005C6158, 0x00919492, 0x00919492, 0x0061665D, 0x004C5541, 0x0049543A, 0x006C7959, 0x00667452, 0x00707E5C, 0x006E7A56, 0x0046532D,
        0x003D4820, 0x003E4A20, 0x00344016, 0x00384C17, 0x002E4410, 0x0022390C, 0x001E360C, 0x001C3612, 0x00173315, 0x00112E14, 0x000B2910, 0x0015300E, 0x00183010, 0x000E2407, 0x0017250D, 0x00404935, 0x00555849, 0x004B493E, 0x00514C43, 0x004B4840,
        0x004E4B43, 0x00555349, 0x0069675C, 0x00676658, 0x00605F51, 0x00595949, 0x006D6D5B, 0x006A685D, 0x0058564B, 0x006B695F, 0x00747268, 0x00626055, 0x004D4D3B, 0x003E4128, 0x0044482B, 0x00696F6E, 0x00A6ADB0, 0x00A8AFB8, 0x00B3BCC6, 0x00B1BABD,
        0x007D897D, 0x004B593D, 0x004C5933, 0x005A6844, 0x00505E3C, 0x00394B24, 0x00425331, 0x0096A199, 0x00B3B7C9, 0x0097A1A8, 0x006E836A, 0x00697650, 0x0066764D, 0x0062754A, 0x0064784E, 0x0061744D, 0x003E4B2B, 0x00252C11, 0x003E412B, 0x003E4023,
        0x00393B1D, 0x00383B1B, 0x003B3F1C, 0x00383C19, 0x00343618, 0x003D3E24, 0x004A4A32, 0x003F452C, 0x00454832, 0x00484A34, 0x004A4934, 0x0043462D, 0x003C4223, 0x0045522C, 0x005A6C43, 0x005B6842, 0x005D6B41, 0x005C6B3F, 0x005D6C40, 0x005B6842,
        0x00555E43, 0x00575C4D, 0x0064675E, 0x00848D8A, 0x00818786, 0x004C583A, 0x00536138, 0x00565950, 0x00606361, 0x005F695D, 0x008D9398, 0x0055614B, 0x004C5E35, 0x005E6A54, 0x005B605E, 0x005B6358, 0x00868D86, 0x005F675D, 0x0053673A, 0x00596549,
        0x005E6558, 0x005C5E5E, 0x00787A7B, 0x007E8479, 0x00424B37, 0x0057604B, 0x005F6756, 0x00666C67, 0x006C765F, 0x0059693A, 0x00485A25, 0x00364317, 0x003E4425, 0x00474A31, 0x00484A34, 0x004B4734, 0x004B4734, 0x004B4833, 0x0048472D, 0x00454527,
        0x00434424, 0x00434422, 0x00444622, 0x0044442C, 0x004A4A32, 0x00474A31, 0x00474B32, 0x004E5638, 0x006C7854, 0x006E7C52, 0x006D7F50, 0x006C7A50, 0x006F7E52, 0x00707F53, 0x00707E54, 0x00626D4D, 0xFFE0E6D3, 0xFFFEFFFB, 0xFFFFFEFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x4594C2EB, 0x005DA1E2, 0x0053A2F3, 0x005AA3ED, 0x0061A6EC, 0x005AA4F2, 0x005BA5F7, 0x00589CE7, 0x005A9EE9, 0x005B9FEA, 0x005DA1EC, 0x005CA0EB, 0x005B9FEA,
        0x005A9EE9, 0x005A9EE9, 0x005A9EE9, 0x0062A1EB, 0x005A9EE9, 0x00559EE8, 0x004F9BE3, 0x005AA2E8, 0x0067A4E6, 0x005587C3, 0x00406BA4, 0x003D6B94, 0x00466F8F, 0x00406272, 0x00344E4E, 0x00172C1D, 0x001A2D14, 0x00556748, 0x003F5330, 0x00616363,
        0x008A8985, 0x00949288, 0x008D8A7B, 0x006A6653, 0x003E3D29, 0x003A3A28, 0x00727461, 0x0087857D, 0x007B7A70, 0x00707064, 0x003F3E30, 0x00383826, 0x00605F4A, 0x007E7E66, 0x0082826A, 0x00807D79, 0x009D9A96, 0x00BFBBBA, 0x00ACA9A5, 0x009B9991,
        0x00858676, 0x0061644E, 0x003C4126, 0x00625F5A, 0x007E7D73, 0x00B1B1A3, 0x00464B36, 0x0042492E, 0x00656E4D, 0x00606D47, 0x006C7A51, 0x006B7C51, 0x006C7D51, 0x006E7E55, 0x00303C20, 0x00383F32, 0x00585E53, 0x004A543D, 0x0054623E, 0x00687652,
        0x00444E37, 0x007E8479, 0x006B7265, 0x00535E44, 0x005B6A44, 0x006D7D54, 0x00677551, 0x00516D6E, 0x00678A98, 0x005B7D94, 0x00638095, 0x00557892, 0x00527B94, 0x005E7D7C, 0x00586342, 0x0067784C, 0x006D7E53, 0x006B7A54, 0x004B5937, 0x005C684A,
        0x00535E44, 0x004C563F, 0x00313A25, 0x00474B32, 0x004E5338, 0x004E5338, 0x00505538, 0x00505637, 0x00454B2C, 0x003E4524, 0x003E4524, 0x00494B3F, 0x00585A4E, 0x00434539, 0x00454539, 0x004E4D43, 0x00545248, 0x004F4D43, 0x00535147, 0x00484A3E,
        0x004B4D41, 0x0054554B, 0x0064655B, 0x0068695F, 0x00595A51, 0x0057584F, 0x00696A61, 0x00656456, 0x005A594B, 0x006B6B5B, 0x00757563, 0x00646551, 0x004D4F39, 0x0042442E, 0x00464930, 0x006F7374, 0x00A9ACB0, 0x00B0B3BB, 0x00B7B9C3, 0x00B6BBC4,
        0x00B0B6BD, 0x00868F92, 0x004E5957, 0x0037453F, 0x0036453D, 0x005A6961, 0x00919D9D, 0x00A6AFB9, 0x00A8B1BB, 0x0099A7A3, 0x006D806D, 0x00687A51, 0x006A7C53, 0x00667851, 0x00697755, 0x00697656, 0x00424C2E, 0x00212A0F, 0x00394228, 0x003C441C,
        0x003B4020, 0x00353920, 0x00393C2C, 0x00393C33, 0x00757672, 0x00BDC0BE, 0x00C2C7C5, 0x0062654F, 0x003D3F29, 0x0042422A, 0x0048472B, 0x0048482A, 0x003C4121, 0x004A5430, 0x005E6D47, 0x005D694B, 0x00667452, 0x005B6B42, 0x005B6C41, 0x00576640,
        0x005B664C, 0x0061675C, 0x00535654, 0x00353B36, 0x00414C38, 0x00566742, 0x004D5F36, 0x00536242, 0x00626E58, 0x00414D37, 0x003F4C34, 0x004B5D36, 0x004F5C42, 0x004B5348, 0x00737B70, 0x0049553F, 0x00364525, 0x004B5B39, 0x00556445, 0x003E4F2A,
        0x006B7564, 0x00666B69, 0x0040493C, 0x0043542F, 0x00576B3E, 0x00455435, 0x005D655B, 0x007A7E7F, 0x00656D5C, 0x005F6D44, 0x00455525, 0x003D4822, 0x00454930, 0x004F4F3D, 0x00484838, 0x004E4C34, 0x0048462E, 0x0054513C, 0x003D3C28, 0x0043422D,
        0x00414228, 0x00393E1E, 0x003A401D, 0x003D4526, 0x00474F31, 0x004A5136, 0x004F583E, 0x004F583E, 0x00657155, 0x006F7C5C, 0x006A7854, 0x00707E5A, 0x00707F59, 0x0073835A, 0x0073825C, 0x00606C4E, 0xFFDEE6D5, 0xFFFDFFFE, 0xFFFDFDFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x4594C2EB, 0x005DA1E2, 0x0054A3F4, 0x005AA3ED, 0x0061A6EC, 0x005AA4F2, 0x005BA5F7, 0x00589CE7, 0x005A9EE9, 0x005CA0EB, 0x005DA1EC, 0x005CA0EB, 0x005B9FEA,
        0x005A9EE9, 0x005A9EE9, 0x005B9FEA, 0x005F9EE8, 0x00589CE7, 0x0057A0EA, 0x0054A0E8, 0x005BA3E9, 0x00609DDF, 0x00467AB6, 0x002F5C95, 0x00687284, 0x005B6471, 0x00444B4E, 0x00393D37, 0x002B2E1F, 0x00313522, 0x00616750, 0x00444C35, 0x003E423C,
        0x006C7065, 0x00929383, 0x007F7E6A, 0x00505038, 0x006B6B53, 0x007F826C, 0x00676C57, 0x005D5D51, 0x00818173, 0x00646456, 0x002D2D1D, 0x00323222, 0x00363624, 0x004A4836, 0x0062614D, 0x00646652, 0x00838572, 0x00939385, 0x00757569, 0x0067675B,
        0x004D4D3F, 0x00323421, 0x002C2E1A, 0x0054524A, 0x0098988C, 0x00656656, 0x002F341F, 0x006C7358, 0x0065704F, 0x006D7A54, 0x00738158, 0x00728358, 0x006F8054, 0x006A7A51, 0x00465236, 0x00697063, 0x0081877C, 0x005F6952, 0x0053613D, 0x006B7955,
        0x004F5942, 0x00979D92, 0x0092998C, 0x0059644A, 0x005B6A44, 0x0076865D, 0x005E6C48, 0x00577677, 0x00779BAB, 0x006F94AA, 0x007494AB, 0x006D92AC, 0x00719DB5, 0x00709291, 0x00586644, 0x00728357, 0x006D7E53, 0x00677551, 0x00434F31, 0x00545E47,
        0x004A5142, 0x00757B70, 0x0081867D, 0x0070725E, 0x00747662, 0x006F715D, 0x006B6D59, 0x006A6C58, 0x00636551, 0x00585A46, 0x0052553F, 0x00555848, 0x00707364, 0x00757869, 0x00767668, 0x005E5E52, 0x00555348, 0x00514F45, 0x004F4D43, 0x00525244,
        0x004C4C3E, 0x00545448, 0x006A6A5E, 0x00717066, 0x00605F55, 0x005E5C54, 0x0074726A, 0x006E6C61, 0x00565449, 0x00525143, 0x00565646, 0x0051513F, 0x00454632, 0x003D3F29, 0x00454731, 0x006A6E6F, 0x00AAADB1, 0x00B4B7BF, 0x00B3B5BF, 0x00AEB3BC,
        0x00B4BAC1, 0x00B3BCBF, 0x00ABB5B5, 0x00A9B6B4, 0x00A5B3AD, 0x00AAB8B2, 0x00B1BCC0, 0x00AEB6C3, 0x00B1B9C6, 0x009DAAA8, 0x00647665, 0x00687A51, 0x006A7C53, 0x00667851, 0x00687654, 0x00687555, 0x00424C2E, 0x00212A0F, 0x003A4329, 0x00394119,
        0x003A3F1F, 0x003C4027, 0x00393C2D, 0x00A5A89F, 0x00FFFFFC, 0x00FDFFFC, 0x00C3C8C6, 0x00585B45, 0x003F412B, 0x0044442C, 0x0046452B, 0x00464628, 0x003B4020, 0x0048522E, 0x005F6E48, 0x005B6947, 0x0064734D, 0x005F7045, 0x00637449, 0x00586642,
        0x00555F48, 0x0071766D, 0x005F6161, 0x002F362F, 0x003B4534, 0x00505E42, 0x004A583C, 0x006A7463, 0x006B7369, 0x00353D32, 0x00374130, 0x00495A35, 0x00515C48, 0x00585E59, 0x00757A79, 0x00576053, 0x0035422A, 0x00445236, 0x0057644A, 0x004C5645,
        0x00737876, 0x0066696D, 0x00363E34, 0x00394828, 0x0061734C, 0x005E6A54, 0x006F7473, 0x0085898A, 0x00555D4C, 0x0057653C, 0x00495929, 0x003B4620, 0x003F432A, 0x004B4B39, 0x00484838, 0x0046472D, 0x0052523A, 0x00454632, 0x00474735, 0x006A6A58,
        0x00383A26, 0x00252910, 0x00282D12, 0x00363C25, 0x00454A35, 0x00464B36, 0x00484F3A, 0x004E563F, 0x006C785C, 0x00758361, 0x006D7C56, 0x00707E5A, 0x00707F59, 0x0073835A, 0x0073825C, 0x00606C4E, 0xFFDEE6D5, 0xFFFCFFFD, 0xFFFDFDFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x4594C2EB, 0x005CA0E1, 0x0054A3F4, 0x005BA4EE, 0x0062A7ED, 0x005BA5F3, 0x005CA6F8, 0x00589CE7, 0x005B9FEA, 0x005CA0EB, 0x005DA1EC, 0x005DA1EC, 0x005B9FEA,
        0x005A9EE9, 0x005A9EE9, 0x005B9FEA, 0x005FA0EA, 0x005A9EE9, 0x0059A2EC, 0x0056A0E8, 0x005BA1E7, 0x005F9FE0, 0x00528AC5, 0x004A7BB3, 0x005282AC, 0x004D7B9D, 0x00466F86, 0x0046656E, 0x003B5349, 0x003B4B33, 0x00676F4A, 0x00555C2F, 0x00293323,
        0x00404935, 0x0051553C, 0x0043472A, 0x00555739, 0x00ADB293, 0x00BCC1A4, 0x006C755A, 0x004D523D, 0x00505540, 0x008C8E7B, 0x00757666, 0x00403F31, 0x00333224, 0x00363429, 0x00383429, 0x00414728, 0x00383D22, 0x00555842, 0x00838474, 0x008A8A7E,
        0x00515145, 0x003A3A2C, 0x005F6050, 0x00A9A99D, 0x00727264, 0x003A3E2B, 0x004D533A, 0x006E785A, 0x00697453, 0x00798660, 0x006C7C53, 0x0067784D, 0x00708155, 0x006D7D54, 0x004A563A, 0x00666D60, 0x006E7469, 0x0058624B, 0x005D6B47, 0x00697753,
        0x004D5740, 0x007B8176, 0x007B8275, 0x0049543A, 0x00596842, 0x0074845B, 0x005A6844, 0x004F7275, 0x00719AA9, 0x006F98AF, 0x007499AF, 0x006F97B3, 0x00709FBA, 0x00668C8C, 0x00465938, 0x0067784D, 0x006B7B52, 0x006F7D5B, 0x004B573B, 0x004D5642,
        0x00444A3F, 0x00858983, 0x00A7AAA8, 0x00B4B9A4, 0x00B1B5A2, 0x00A0A491, 0x00878A7A, 0x00797C6D, 0x006E7162, 0x00616357, 0x005B5D51, 0x00505742, 0x00727663, 0x008C907D, 0x008B8E7E, 0x00606052, 0x00535345, 0x00535146, 0x0049473C, 0x004C4D3D,
        0x004B4C3C, 0x00535444, 0x00626254, 0x00636355, 0x0057574B, 0x005A5A4E, 0x006F6F63, 0x006D6B61, 0x0058564C, 0x004D4B40, 0x004E4D3F, 0x00535343, 0x004C4C3A, 0x00424230, 0x004C4D39, 0x004B504F, 0x00989C9D, 0x00B6BABF, 0x00BABDC5, 0x00B4B9C2,
        0x00AEB4BB, 0x00AEB7BA, 0x00BAC4C4, 0x00B0BBBF, 0x00B1BDBD, 0x00AFBBBB, 0x00A9B2BB, 0x00A4ABBC, 0x00B0B7C6, 0x00A0ACAC, 0x00657668, 0x00697B52, 0x006A7C53, 0x00667851, 0x00687654, 0x00687555, 0x00424C2E, 0x00222B10, 0x003A4329, 0x00404722,
        0x003B4021, 0x0050533D, 0x00333627, 0x00888B82, 0x00BDBFB9, 0x00B9BDB8, 0x00565C57, 0x00464834, 0x0042442E, 0x0047472F, 0x0046452B, 0x00464628, 0x003A3F1F, 0x0046502C, 0x00606E4A, 0x005E6E45, 0x00607146, 0x005A6B3F, 0x00607047, 0x005C6949,
        0x006B7460, 0x00B5B9B3, 0x00939596, 0x00667060, 0x004C5842, 0x0057644C, 0x005C6656, 0x00A1A6A5, 0x00A3A6AA, 0x00606563, 0x00525B4E, 0x0052633E, 0x00535E4A, 0x007E8283, 0x00A9ACB1, 0x00828883, 0x00505B47, 0x00505D43, 0x00576549, 0x005C6061,
        0x00B0B1BB, 0x009EA0A8, 0x004D554A, 0x00445333, 0x00657553, 0x006D7766, 0x009B9EA2, 0x00B9BDBE, 0x00545D49, 0x004F5D34, 0x004C5C2C, 0x0038431B, 0x003C4027, 0x00474735, 0x00484836, 0x004D5237, 0x0050533D, 0x00383C29, 0x005D6051, 0x0092968A,
        0x00363A2E, 0x002F3425, 0x00323A29, 0x0055564C, 0x00505147, 0x0043443A, 0x00494E3F, 0x00565D48, 0x006B775B, 0x006B7955, 0x006C7D52, 0x006F7D59, 0x006F7E58, 0x0073835A, 0x0072815B, 0x005F6B4D, 0xFFDDE5D4, 0xFFFCFFFD, 0xFFFCFCFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x4593C1EA, 0x005CA0E1, 0x0054A3F4, 0x005BA4EE, 0x0063A8EE, 0x005BA5F3, 0x005CA6F8, 0x00589CE7, 0x005B9FEA, 0x005CA0EB, 0x005EA2ED, 0x005DA1EC, 0x005CA0EB,
        0x005B9FEA, 0x005B9FEA, 0x005CA0EB, 0x005FA3EC, 0x005B9FEA, 0x005BA2EC, 0x00569EE6, 0x00599EE4, 0x0063A3E4, 0x00639FDA, 0x0069A1D8, 0x00499EE2, 0x004C9CDB, 0x004C97CB, 0x004585A7, 0x0031636F, 0x00294B40, 0x00556A49, 0x005B6A3E, 0x004C5B40,
        0x00333F23, 0x00444D2C, 0x00464E29, 0x003A411C, 0x007C845F, 0x0098A180, 0x00505B3B, 0x00586042, 0x0040482A, 0x004C5239, 0x00888A76, 0x00959686, 0x00615F54, 0x00535048, 0x003D3934, 0x00393C26, 0x0030321F, 0x00525244, 0x00818076, 0x008B8981,
        0x00828177, 0x0096968A, 0x00B8B8AA, 0x005F6350, 0x00373C27, 0x00454B34, 0x005F684D, 0x006D7858, 0x007C8864, 0x00708057, 0x006E7F54, 0x006C7D52, 0x00728357, 0x006F7F56, 0x00445034, 0x00555C4F, 0x0051574C, 0x00434D36, 0x00596743, 0x00667450,
        0x00454F38, 0x0052584D, 0x004F5649, 0x003F4A30, 0x0065744E, 0x00718158, 0x0065734F, 0x005C8286, 0x0075A1B2, 0x00719DB5, 0x00789EB6, 0x006E9AB7, 0x006D9FBB, 0x006B9294, 0x005A6F4F, 0x006D7F56, 0x006C7E57, 0x00697A55, 0x004F5E3E, 0x004A583C,
        0x0058654D, 0x005F6A56, 0x005D6756, 0x00778065, 0x00828B70, 0x008A9379, 0x00848C75, 0x007F8671, 0x00787E6B, 0x006E7463, 0x006F7465, 0x00737C61, 0x0097A086, 0x00B2BAA3, 0x009FA48F, 0x00595D4A, 0x00464737, 0x004F4F41, 0x00535347, 0x00494B37,
        0x004C4E3A, 0x004E503D, 0x004E503D, 0x004E4F3F, 0x004F5040, 0x00535444, 0x0059594B, 0x0057554B, 0x00514F45, 0x004D4B40, 0x004E4D3F, 0x00555545, 0x004B4B3B, 0x0040402E, 0x004F4F3D, 0x003E443F, 0x00888D8C, 0x00AEB3B6, 0x00B5B8C0, 0x00B9BFC6,
        0x00B2B8BF, 0x00A8B1B5, 0x00B0B9BC, 0x00B1BAC3, 0x00AEB9BD, 0x00ACB7BB, 0x00ACB5BF, 0x00A7ADC0, 0x00A9B0C1, 0x0098A4A4, 0x00657668, 0x00677950, 0x006A7C53, 0x00667851, 0x00697755, 0x00697656, 0x00424C2E, 0x00212A0F, 0x00394228, 0x00414724,
        0x00373B1E, 0x0051543E, 0x0056594A, 0x0094978E, 0x00A8AAA4, 0x00A9ADA7, 0x00525952, 0x00323420, 0x0042432F, 0x004A4934, 0x0048472D, 0x0048472B, 0x003C4122, 0x00444D2C, 0x00606E4A, 0x00637546, 0x005F7142, 0x00596A3E, 0x005B6A44, 0x005F6B4D,
        0x00929A89, 0x00FDFFFC, 0x00BBBDBE, 0x00647151, 0x0052603E, 0x00616D51, 0x007C8376, 0x00F1F3F4, 0x00DDDEE2, 0x006A6F66, 0x00505944, 0x005D6E42, 0x005C674D, 0x00B6BAB5, 0x00FDFFFF, 0x00A3A89F, 0x00626D53, 0x004E5C3A, 0x0042502C, 0x006F6E77,
        0x00FBFAFF, 0x00D3D5D5, 0x0059624D, 0x0052613B, 0x0061704A, 0x006B745F, 0x00D2D5D3, 0x00FAFFFE, 0x00626B57, 0x004C5A30, 0x004B5B2B, 0x0037421A, 0x003F4429, 0x00484935, 0x00484836, 0x00424B30, 0x002D351E, 0x00393E2F, 0x00555A51, 0x005F635D,
        0x00414742, 0x00999F9A, 0x00777E77, 0x00878585, 0x00747271, 0x0052514D, 0x0045483F, 0x00535946, 0x006E7A5C, 0x006B7A54, 0x006D7E52, 0x006F7D59, 0x006F7E58, 0x0073835A, 0x0072815B, 0x005F6B4D, 0xFFDDE5D4, 0xFFFCFFFD, 0xFFFCFCFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x4192C0E9, 0x005CA0E1, 0x0054A3F4, 0x005CA5EF, 0x0064A9EF, 0x005CA6F4, 0x005DA7F9, 0x00599DE8, 0x005CA0EB, 0x005DA1EC, 0x005EA2ED, 0x005EA2ED, 0x005CA0EB,
        0x005B9FEA, 0x005B9FEA, 0x005CA0EB, 0x005CA1EA, 0x00599DE8, 0x005CA0EB, 0x005A9FE8, 0x005BA0E6, 0x005EA0E1, 0x005494CE, 0x00508EC4, 0x00568CC1, 0x00558EC2, 0x005A93C6, 0x005C90BE, 0x005682A1, 0x00486873, 0x005C7169, 0x00606C5A, 0x00495C3B,
        0x00586944, 0x005B6940, 0x00556137, 0x00596339, 0x00515C34, 0x0053603A, 0x0064724E, 0x0076835D, 0x006E7A56, 0x00586041, 0x003C4328, 0x00868874, 0x00BCBDAD, 0x00A2A095, 0x008D8B81, 0x0083807C, 0x00706C6B, 0x007B7776, 0x00AEAAA9, 0x00D6D3CE,
        0x00D1D0C6, 0x00919282, 0x00464834, 0x00363C25, 0x00494F36, 0x0050593E, 0x006C7757, 0x00778261, 0x0074835D, 0x00718158, 0x00738459, 0x0074855A, 0x006D7E52, 0x006A7A51, 0x00414D31, 0x004E5548, 0x00454B40, 0x00404A33, 0x0055633F, 0x00667450,
        0x00414B34, 0x00595F54, 0x004E5548, 0x00323D23, 0x005D6C46, 0x006E7E55, 0x00687652, 0x005C8287, 0x006F9AAD, 0x006994AF, 0x006C94AD, 0x006591B0, 0x006B9DB9, 0x006A9396, 0x005E7457, 0x006C7E57, 0x006F815A, 0x006F815A, 0x00687A53, 0x0051633A,
        0x007F9168, 0x005D6F46, 0x0055673E, 0x0073805A, 0x0076835D, 0x007A8662, 0x00747F5E, 0x00747F5E, 0x00758060, 0x00717B5D, 0x007C8668, 0x006B7957, 0x006D7858, 0x00677153, 0x005E674D, 0x004D533C, 0x00555946, 0x00515242, 0x00454537, 0x0052553C,
        0x004D5037, 0x00474933, 0x00444630, 0x00484935, 0x004E4F3B, 0x0050513D, 0x004D4D3B, 0x004C4A3F, 0x004E4C41, 0x004E4D3F, 0x004C4C3C, 0x00515141, 0x00484836, 0x003E3F2B, 0x0050513D, 0x00454D43, 0x00838984, 0x00AEB3B4, 0x00B0B4B9, 0x00B6BCC3,
        0x00B7BDC4, 0x00B0B9BD, 0x00B5BEC1, 0x00B2BBC5, 0x00ADB7BE, 0x00ABB6BA, 0x00ADB6C0, 0x00A9AFC2, 0x00A8AFBE, 0x0098A5A3, 0x006D7F6E, 0x0066784F, 0x00697B52, 0x00677952, 0x006B7957, 0x006A7757, 0x00434D2F, 0x0020290E, 0x00374026, 0x00414627,
        0x003D4026, 0x003F412D, 0x00434637, 0x00787C71, 0x0093968D, 0x005A5F56, 0x00151D12, 0x00232512, 0x0042432F, 0x004B4A35, 0x004B4931, 0x004B4A2E, 0x003F4425, 0x00444D2C, 0x00606E4A, 0x00617344, 0x00627347, 0x005F7045, 0x00576541, 0x00566147,
        0x00969E8D, 0x00FDFFF9, 0x00A0A3A1, 0x004F6132, 0x005A6C3D, 0x005B6A44, 0x006F7863, 0x00F8FCF6, 0x00D7DBD5, 0x0057604B, 0x0055633F, 0x005F723F, 0x005C6A48, 0x00AEB5A6, 0x00FDFFF8, 0x007B846F, 0x004D5B37, 0x00435429, 0x004D5E33, 0x006E716F,
        0x00FDFFFB, 0x00C8D0BF, 0x0052603E, 0x005F7142, 0x00647549, 0x00626E52, 0x00D3DACD, 0x00FBFFFF, 0x005F6853, 0x004B592F, 0x004C5D2A, 0x003A461C, 0x0044492E, 0x004A4B37, 0x00494A36, 0x0039412A, 0x004E5441, 0x00767D70, 0x003B3F39, 0x000E1311,
        0x00676C6A, 0x00FAFFFE, 0x00878E8B, 0x00858284, 0x00A9A6A8, 0x00A2A09F, 0x006C6F66, 0x00505645, 0x006A7658, 0x006F7F56, 0x00718354, 0x006F7D59, 0x006F7E58, 0x0073835A, 0x0072815B, 0x00606C4E, 0xFFDEE6D5, 0xFFFCFFFD, 0xFFFDFDFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x4192C0E9, 0x005B9FE0, 0x0054A3F4, 0x005DA6F0, 0x0064A9EF, 0x005DA7F5, 0x005DA7F9, 0x00599DE8, 0x005CA0EB, 0x005EA2ED, 0x005FA3EE, 0x005EA2ED, 0x005DA1EC,
        0x005CA0EB, 0x005CA0EB, 0x005DA1EC, 0x005FA4ED, 0x00599DE8, 0x005A9DE8, 0x005A9EE7, 0x0061A3EA, 0x005EA0E1, 0x003F84BD, 0x002A6EA3, 0x003773A1, 0x002B6B9B, 0x002A6C9D, 0x00316F98, 0x00477990, 0x004F7171, 0x006A7A62, 0x007D8059, 0x00718862,
        0x0074885E, 0x007D8E63, 0x00818E62, 0x00818E62, 0x0076845A, 0x0076855F, 0x00788964, 0x006E7C52, 0x00808E64, 0x007A8761, 0x006D7655, 0x00596143, 0x00575B42, 0x009A9C88, 0x00B5B7A4, 0x009B9894, 0x00A3A09C, 0x00A7A4A0, 0x00AFACA7, 0x00919185,
        0x005E604D, 0x003D4227, 0x003C4223, 0x00575F41, 0x00505A3C, 0x00495434, 0x00586342, 0x0052613B, 0x004C5C33, 0x0055683D, 0x004D6035, 0x004F6035, 0x00495A2E, 0x004E5E35, 0x00485438, 0x0062695C, 0x00565C51, 0x005D6750, 0x00566440, 0x006C7A56,
        0x0058624B, 0x00989E93, 0x00959C8F, 0x00586349, 0x0062714B, 0x0077875E, 0x0062704C, 0x00587C84, 0x006E99AE, 0x006E96B3, 0x007095B1, 0x006C95B6, 0x0071A3C1, 0x00648A8F, 0x004B5E43, 0x00687A51, 0x0071835A, 0x00798B62, 0x0074865D, 0x003F5128,
        0x00677950, 0x004A5C33, 0x0056693E, 0x00687652, 0x0066754F, 0x006A7953, 0x0065744E, 0x006F7F56, 0x0078885F, 0x006D7E53, 0x00708156, 0x006D7D54, 0x006F7E58, 0x006A7554, 0x005C6648, 0x00475036, 0x004F543F, 0x004B4F3C, 0x00505343, 0x004C5033,
        0x0045482E, 0x0045482E, 0x00484B31, 0x0042452C, 0x003E4128, 0x00484A34, 0x0053553F, 0x00505040, 0x00535343, 0x00535341, 0x0050513D, 0x00555741, 0x004D4F39, 0x0040432A, 0x004C4F35, 0x00424A3F, 0x007B827B, 0x00BAC0BF, 0x00BCC1C4, 0x00B1B7BE,
        0x00B0B6BD, 0x00ADB5BC, 0x00AFB8BC, 0x00A6AFB9, 0x00AAB5B9, 0x00A9B4B8, 0x00A7B0B9, 0x00A4ABBA, 0x00A7B0BA, 0x0095A39D, 0x00667964, 0x0066784F, 0x00697B52, 0x00677952, 0x006B7957, 0x006A7757, 0x00434D2F, 0x0020290E, 0x00374026, 0x00414528,
        0x00404329, 0x004C4E3A, 0x002A2D1E, 0x00303429, 0x007E8178, 0x00494F44, 0x00151E11, 0x00232512, 0x00454533, 0x004A4935, 0x004C4A32, 0x004B4A30, 0x00414528, 0x00464F2E, 0x00606E4C, 0x005E6F44, 0x0063734A, 0x005C6A46, 0x004D5A3A, 0x00404B31,
        0x006F7864, 0x00BCC3B4, 0x006F7669, 0x00677748, 0x00576737, 0x004E5C32, 0x0050593E, 0x00A2A798, 0x00A2A798, 0x00636D4F, 0x00606F43, 0x00455526, 0x004B5636, 0x00808673, 0x00C7CDBA, 0x006E785A, 0x004F5D34, 0x0039471E, 0x0045512D, 0x00595E4F,
        0x00B9BFAC, 0x008E977C, 0x0046532D, 0x0057663A, 0x005C6A41, 0x00535C41, 0x009AA08D, 0x00BCC1BF, 0x0049523D, 0x004E5D31, 0x0050612E, 0x003E4A20, 0x00474C2F, 0x004C4D39, 0x004C4D39, 0x00444835, 0x00787D6E, 0x00AAAEA3, 0x00939490, 0x00888B89,
        0x00878B86, 0x00A5ACA5, 0x00565D56, 0x00656362, 0x009B9998, 0x00AEADA9, 0x007E8277, 0x00555B48, 0x00657153, 0x006A7A51, 0x00708155, 0x00707E5A, 0x00707F59, 0x0073835A, 0x0073825C, 0x00606C4E, 0xFFDEE6D5, 0xFFFDFFFE, 0xFFFDFDFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x4191BFE8, 0x005B9FE0, 0x0054A3F4, 0x005DA6F0, 0x0065AAF0, 0x005DA7F5, 0x005DA7F9, 0x00599DE8, 0x005DA1EC, 0x005EA2ED, 0x005FA3EE, 0x005FA3EE, 0x005DA1EC,
        0x005CA0EB, 0x005CA0EB, 0x005DA1EC, 0x005FA7EF, 0x005B9FEA, 0x005B9EE9, 0x005A9BE5, 0x0062A2E9, 0x005DA1E2, 0x003D84BD, 0x00216A9E, 0x001C72A8, 0x001771A8, 0x001D77AE, 0x002277A5, 0x003D8099, 0x0049756F, 0x00617552, 0x00797F48, 0x006D855D,
        0x00798F65, 0x00778B5E, 0x00708051, 0x00808F63, 0x0078865D, 0x006D7E59, 0x00728361, 0x007A8A5B, 0x00718054, 0x00758359, 0x00738158, 0x007F8A64, 0x00737C5B, 0x00696F50, 0x00666C4D, 0x003A4021, 0x00393E21, 0x002D3217, 0x003C4027, 0x0044492E,
        0x004B5132, 0x004F5633, 0x00545D35, 0x004C5736, 0x00667150, 0x00717D59, 0x00586642, 0x0062714B, 0x0064764D, 0x005C6F44, 0x005D7045, 0x00607146, 0x005E6F43, 0x0057673E, 0x00727E62, 0x0091988B, 0x00757B70, 0x008B957E, 0x0055633F, 0x00677551,
        0x005F6952, 0x006E7469, 0x0062695C, 0x004F5A40, 0x0045542E, 0x005C6C43, 0x0052603C, 0x0050717A, 0x00648AA2, 0x00658BAB, 0x006A8CAA, 0x00648AAC, 0x006491B2, 0x0052767C, 0x00404F34, 0x005D7245, 0x00596D42, 0x00586B44, 0x00526342, 0x00314024,
        0x004D5A44, 0x0045513F, 0x00424D3D, 0x004C5941, 0x0048553B, 0x00465438, 0x003A4929, 0x004F603B, 0x0071835A, 0x0073865B, 0x00778B5E, 0x00728357, 0x006B7C51, 0x00677650, 0x00616C4B, 0x004C553A, 0x0050563F, 0x00474B38, 0x00484C39, 0x00444628,
        0x00424426, 0x004A4C2F, 0x004D4F32, 0x00404127, 0x0037381E, 0x0044452B, 0x0054553B, 0x004C4D39, 0x004D4F39, 0x004E503A, 0x004B4E35, 0x004D5036, 0x00474B2E, 0x003C4122, 0x00424728, 0x00434C3F, 0x006B7369, 0x00B7BEBB, 0x00BDC2C5, 0x00A5ABB2,
        0x00A2A8AF, 0x00A7AFB6, 0x00A9B2B6, 0x00A1AAB3, 0x00ACB8BA, 0x00AFBBBB, 0x00AFB9C0, 0x00AEB6C3, 0x00B0BAC1, 0x009CACA1, 0x006C8266, 0x00687A51, 0x006A7C53, 0x00667851, 0x00697755, 0x00687555, 0x00424C2E, 0x00212A0F, 0x00394228, 0x0043472A,
        0x0033361D, 0x0040422F, 0x002D2F23, 0x001B1F14, 0x00676B60, 0x00545B4E, 0x00182114, 0x002E2F1F, 0x004B4B39, 0x00474632, 0x00494631, 0x0046452B, 0x00404427, 0x00485031, 0x0062704E, 0x0062704C, 0x0062704E, 0x004F5C3C, 0x00485438, 0x003E492F,
        0x004A543D, 0x00707A63, 0x005B654E, 0x005B6547, 0x0044502C, 0x004E5A36, 0x004E573D, 0x00575C4D, 0x006A6F60, 0x0060694E, 0x004D5B31, 0x00565F45, 0x00555B4A, 0x005E6256, 0x007A806F, 0x00616A4F, 0x00535E3E, 0x00475036, 0x00484E3D, 0x004E5441,
        0x006D755E, 0x00535C41, 0x003C4628, 0x00434C31, 0x004B533C, 0x00494F3E, 0x0065695D, 0x00767B79, 0x003C4530, 0x0057663A, 0x0051632E, 0x003F4C20, 0x00474C2F, 0x004D4F39, 0x004E4F3B, 0x00545446, 0x0057564C, 0x0067685F, 0x00B3B3AD, 0x00DCDED8,
        0x00666960, 0x004A4E42, 0x00818677, 0x0054554C, 0x0057584F, 0x005B5C52, 0x004F5445, 0x004F5641, 0x006F7B5D, 0x006E7D57, 0x006F8054, 0x00717F5B, 0x0071805A, 0x0074845B, 0x0074835D, 0x00616D4F, 0xFFDFE7D6, 0xFFFDFFFE, 0xFFFDFDFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x4191BFE8, 0x005B9FE0, 0x0054A3F4, 0x005DA6F0, 0x0065AAF0, 0x005EA8F6, 0x005EA8FA, 0x00599DE8, 0x005DA1EC, 0x005EA2ED, 0x005FA3EE, 0x005FA3EE, 0x005EA2ED,
        0x005CA0EB, 0x005DA1EC, 0x005DA1EC, 0x0059A1E9, 0x005CA0EB, 0x0060A3EE, 0x005D9CE6, 0x005E9EE5, 0x005B9FE0, 0x003D87BF, 0x002470A4, 0x003A76A0, 0x003375A6, 0x003079B3, 0x002872AC, 0x003878A8, 0x003C6C84, 0x004F6C69, 0x006B7967, 0x00708A62,
        0x00697F55, 0x00798D60, 0x007A8B5F, 0x00748357, 0x006F7F56, 0x00778863, 0x00697A59, 0x006E8051, 0x00748455, 0x00738256, 0x00738256, 0x0078845A, 0x00747F57, 0x00858E66, 0x00757E56, 0x0074834A, 0x0067753F, 0x005D6939, 0x006B754A, 0x005F693F,
        0x00677147, 0x00737D52, 0x006C764B, 0x00616D49, 0x005E6A46, 0x00586642, 0x0055643E, 0x005F6F46, 0x004A5D32, 0x0054673C, 0x0054673C, 0x004F6035, 0x005C6D41, 0x0047572E, 0x00626E52, 0x006A7164, 0x00464C41, 0x00949E87, 0x00677551, 0x00687652,
        0x00768069, 0x00464C41, 0x003E4538, 0x00808B71, 0x0061704A, 0x0055653C, 0x0052603C, 0x0052707B, 0x00587C94, 0x00547798, 0x005A7998, 0x00507498, 0x00517C9D, 0x0050717A, 0x0055624A, 0x005A7040, 0x00586C41, 0x00576846, 0x004C5A42, 0x00495346,
        0x00626867, 0x007F8388, 0x006E707B, 0x00788076, 0x00798176, 0x00727C6B, 0x0054604A, 0x005B6A4B, 0x007A8A68, 0x0074865D, 0x006F8257, 0x00738758, 0x006F8054, 0x0076865D, 0x006E7C58, 0x004E583A, 0x004A5339, 0x00454A35, 0x00484C39, 0x00494C2C,
        0x00454828, 0x00484A2C, 0x00494B2D, 0x0045472A, 0x0045472A, 0x00494A30, 0x0046472D, 0x004A4D34, 0x00494C33, 0x004A4D33, 0x0043472A, 0x00414627, 0x00404525, 0x003C4121, 0x00464C29, 0x00475141, 0x005B6358, 0x00A7AEA9, 0x00B2B7BA, 0x00969CA3,
        0x0090969D, 0x00939BA2, 0x008E969D, 0x00909AA1, 0x0096A2A4, 0x009AA7A5, 0x00A0ABAF, 0x00A2ABB4, 0x00A3AEB2, 0x0093A496, 0x006B8164, 0x006A7C53, 0x006B7D54, 0x00657750, 0x00677553, 0x00667353, 0x00414B2D, 0x00222B10, 0x003B442A, 0x004A4D33,
        0x00454731, 0x0040422F, 0x0064665A, 0x0071756A, 0x0074786D, 0x0060675A, 0x001E2818, 0x00383929, 0x004F4F3D, 0x00454430, 0x0046432E, 0x00414026, 0x003E4225, 0x004A5233, 0x00647250, 0x006B7858, 0x00636F51, 0x00475337, 0x004F5A40, 0x00505A43,
        0x003E492F, 0x00445034, 0x005C684A, 0x004D5243, 0x005E6550, 0x00677056, 0x00555B48, 0x0044483D, 0x0052564B, 0x005B624D, 0x00667150, 0x00666960, 0x005F605C, 0x005A5B59, 0x004D5146, 0x00555C47, 0x00525A43, 0x0065695E, 0x00606060, 0x00545A47,
        0x004E5540, 0x00424934, 0x00515746, 0x00595D51, 0x005F615B, 0x00555751, 0x0052534F, 0x00595E5C, 0x00404A33, 0x005F6E42, 0x004F612C, 0x003D4A1E, 0x00474C2F, 0x004E503A, 0x0050523C, 0x004E4C42, 0x00545149, 0x00514E49, 0x006F6C67, 0x00737169,
        0x002B2D21, 0x00393C2C, 0x005E634E, 0x00434637, 0x00454839, 0x004E5142, 0x00474D3C, 0x004A523B, 0x00717D5F, 0x0072815B, 0x00708156, 0x00717F5B, 0x0071805A, 0x0075855C, 0x0074835D, 0x00616D4F, 0xFFDFE7D6, 0xFFFDFFFE, 0xFFFDFDFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x3189BDF2, 0x00659FDA, 0x0061A7EA, 0x005EABF4, 0x0057A7F4, 0x0058A6F2, 0x0063AAF4, 0x00579CE2, 0x005C9FEA, 0x0062A5F0, 0x005FA2ED, 0x005DA0EB, 0x005EA1EC,
        0x005B9EE9, 0x005C9FEA, 0x0060A3EE, 0x005FA0F1, 0x005B9DEC, 0x005FA3EE, 0x005DA3E9, 0x005EA5E5, 0x005EA2DD, 0x004686BC, 0x003372A5, 0x002D7CA5, 0x00327EAF, 0x003379B4, 0x003D7CB6, 0x004C81A6, 0x004D7A7D, 0x00587B59, 0x00719158, 0x0074895C,
        0x00728858, 0x00798D5E, 0x007A8F5E, 0x00748A56, 0x00748853, 0x00768A55, 0x00728651, 0x0074855A, 0x00738459, 0x00728358, 0x00718257, 0x00718257, 0x00738459, 0x0074855A, 0x0075865B, 0x0076875C, 0x00738459, 0x0076875C, 0x0077885D, 0x00728358,
        0x0074855A, 0x00798A5F, 0x0077885D, 0x007D8C66, 0x0076855F, 0x007A8963, 0x007A8963, 0x0073825C, 0x0075845E, 0x00778660, 0x0072815B, 0x007A8963, 0x0074835D, 0x006A7953, 0x0061704A, 0x005D6C46, 0x005D6C46, 0x0061704A, 0x0064734D, 0x006D7D54,
        0x00526239, 0x004D5D34, 0x005C6C43, 0x006E7E55, 0x005E6E45, 0x0056663D, 0x0053633A, 0x005D6D5C, 0x00586857, 0x00485847, 0x00738372, 0x00586857, 0x00465645, 0x00879786, 0x00637362, 0x00576B3E, 0x00576A3F, 0x005E6F4A, 0x00566546, 0x005E6A54,
        0x00818B7B, 0x00848C82, 0x006F766F, 0x0081857F, 0x008E938A, 0x005E6556, 0x00838C77, 0x00778365, 0x0074825E, 0x0076865D, 0x00718256, 0x0077875E, 0x0078885F, 0x0077875E, 0x0073835A, 0x006D7D54, 0x0068784F, 0x0065754C, 0x0064744B, 0x0062744D,
        0x0061734C, 0x0060724B, 0x005F714A, 0x005E7049, 0x005E7049, 0x005E7049, 0x005E7049, 0x0061724D, 0x0061724D, 0x0061724D, 0x0060714C, 0x0060714C, 0x005F704B, 0x005F704B, 0x005F704B, 0x00606F53, 0x00667559, 0x00758468, 0x007E8D71, 0x007B8A6E,
        0x0079886C, 0x007A896D, 0x00758468, 0x00778863, 0x00768762, 0x00758661, 0x00758661, 0x00768762, 0x00758661, 0x0072835E, 0x0070815C, 0x006E8156, 0x006F8257, 0x00697B54, 0x006A7A58, 0x006A795A, 0x00414E34, 0x001F2C14, 0x0037432D, 0x00404B2B,
        0x00394228, 0x00757A6B, 0x00ABAEA5, 0x008C8F86, 0x005E6354, 0x004E573D, 0x003F4A2A, 0x0045482F, 0x0040432A, 0x003E4127, 0x0042452B, 0x00404427, 0x003D4124, 0x004F5336, 0x006B7051, 0x006E8059, 0x00617051, 0x003F4A36, 0x005E665B, 0x004C5449,
        0x0036402F, 0x003B482E, 0x00627151, 0x00565F4A, 0x00868F7A, 0x005C6550, 0x004B543F, 0x00353E29, 0x0057604B, 0x0067705B, 0x00B4BDA8, 0x00B8BDBB, 0x00697167, 0x003A4630, 0x00465236, 0x005A6648, 0x008C947D, 0x00999E8F, 0x004F514B, 0x004E593F,
        0x00303C20, 0x005E6851, 0x007D8477, 0x00B1B3B3, 0x00686C67, 0x0057604C, 0x0035431F, 0x00505E42, 0x004C5A38, 0x005C6A40, 0x00525E2E, 0x00444E20, 0x004F502E, 0x004D4931, 0x004F4638, 0x00454A2D, 0x004B5033, 0x004F5437, 0x004A4F32, 0x00404528,
        0x00393E21, 0x003A3F22, 0x003E4326, 0x004F493E, 0x00534D40, 0x004F4C3D, 0x00454733, 0x00555E44, 0x006F7B5D, 0x0071815F, 0x006F815C, 0x0072805C, 0x0073825C, 0x0074845B, 0x00798862, 0x00657153, 0xFFDDE5D4, 0xFFFDFFFE, 0xFFFDFDFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x2684B4EE, 0x00699FDE, 0x0065A4E8, 0x005BA2EC, 0x0062ADF9, 0x0062AAF7, 0x0066AAF3, 0x005E9EE5, 0x005EA5EF, 0x0061A8F2, 0x0061A8F2, 0x0061A8F2, 0x0062A9F3,
        0x005EA5EF, 0x005CA3ED, 0x005AA1EB, 0x0064A7EC, 0x0060A5EA, 0x0061A8EB, 0x0059A1E1, 0x005CA5DF, 0x005EA4D9, 0x004789BA, 0x0030719E, 0x004F7E82, 0x0053828A, 0x0050808C, 0x00517F8A, 0x005D8688, 0x00638174, 0x00687E62, 0x0072805C, 0x0071855B,
        0x006E8257, 0x0072855A, 0x0075885D, 0x0073865B, 0x0078895E, 0x007B8C61, 0x0077885D, 0x0074855A, 0x00738459, 0x00738459, 0x00728358, 0x00738459, 0x00738459, 0x0075865B, 0x0075865B, 0x0075865B, 0x00738459, 0x0077885D, 0x0078895E, 0x0074855A,
        0x0076875C, 0x007A8B60, 0x0078895E, 0x0072815B, 0x0072815B, 0x0074835D, 0x0073825C, 0x006F7E58, 0x006F7E58, 0x0071805A, 0x0073825C, 0x0073825C, 0x0072815B, 0x0071805A, 0x00707F59, 0x00707F59, 0x00707F59, 0x00707F59, 0x00707F59, 0x0075845E,
        0x0071805A, 0x0071805A, 0x006A7953, 0x006E7D57, 0x0066754F, 0x0063724C, 0x00596842, 0x007F8E79, 0x00384732, 0x001D2C17, 0x0035442F, 0x000E1D08, 0x003C4B36, 0x009DAC97, 0x00586752, 0x005D7045, 0x00596B42, 0x005A6B46, 0x00495838, 0x00455238,
        0x005C6852, 0x00606A59, 0x00515B4B, 0x00575E4F, 0x00717968, 0x005E6752, 0x0069745A, 0x00606D4D, 0x00707E5A, 0x0073835A, 0x00728358, 0x006F7F56, 0x00718158, 0x0073835A, 0x0074845B, 0x0073835A, 0x00728259, 0x00728259, 0x0073835A, 0x0072845D,
        0x0071835C, 0x0070825B, 0x006F815A, 0x006E8059, 0x006E8059, 0x006E8059, 0x006E8059, 0x0071825D, 0x0071825D, 0x0071825D, 0x0071825D, 0x0071825D, 0x0071825D, 0x0071825D, 0x0071825D, 0x006C7D5C, 0x006D7E5D, 0x00738463, 0x00778867, 0x00738463,
        0x00738463, 0x00768766, 0x00738463, 0x0073845F, 0x0072835E, 0x0071825D, 0x0071825D, 0x0071825D, 0x0071825D, 0x006F805B, 0x006D7E59, 0x006A7D52, 0x006E8156, 0x006B7D56, 0x006C7C5A, 0x006D7C5D, 0x00425034, 0x001F2C14, 0x0039462E, 0x0047492B,
        0x003E3E26, 0x00575445, 0x00716C63, 0x00615C53, 0x004C493A, 0x00484830, 0x00454729, 0x00474A31, 0x0044472D, 0x003F4228, 0x00404329, 0x00414528, 0x003E4225, 0x004F5435, 0x006E7354, 0x006F8158, 0x006D7D5B, 0x0055624A, 0x00828C7B, 0x00909A8A,
        0x0067735D, 0x004E5D3E, 0x0071825D, 0x00616C52, 0x00717C62, 0x005D684E, 0x00606B51, 0x004F5A40, 0x006F7A60, 0x0079846A, 0x0097A288, 0x00CAD1CA, 0x0098A292, 0x0055624A, 0x00667353, 0x006C7959, 0x00737C61, 0x009FA592, 0x00868A7E, 0x00677355,
        0x00485535, 0x00707C60, 0x00959D8C, 0x00EBEFE9, 0x00A7ACA3, 0x006B755E, 0x00475630, 0x005C6B4C, 0x004F5D3B, 0x005D6B41, 0x00525F31, 0x003F481D, 0x00484C29, 0x004E4C34, 0x00504938, 0x004C4D39, 0x004F503C, 0x0051523E, 0x004F503C, 0x004A4B37,
        0x00464733, 0x00464733, 0x00464733, 0x00514C3D, 0x004E4C3A, 0x00484935, 0x00454930, 0x00566042, 0x006D7B59, 0x006B7C57, 0x00687B54, 0x0073815D, 0x0073825C, 0x00728259, 0x00778660, 0x00657153, 0xFFDDE5D4, 0xFFFDFFFE, 0xFFFCFCFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x67A6C4ED, 0x5099BCE8, 0x0085B1E0, 0x006091C1, 0x006FA4D6, 0x0070A4D3, 0x006E9FCD, 0x006F9CC8, 0x00629DCB, 0x00609BC9, 0x00649FCD, 0x00649FCD, 0x0069A4D2,
        0x0069A4D2, 0x006AA5D3, 0x0069A4D2, 0x0073A1DB, 0x006E9DDA, 0x006EA0DC, 0x00679BD7, 0x006B9DD7, 0x006898CC, 0x005987B6, 0x004D7AA5, 0x00788767, 0x00768A67, 0x00728B69, 0x006A8563, 0x00758D6D, 0x007A8C6F, 0x0082886F, 0x007D7F69, 0x00778B61,
        0x0073875D, 0x0072845D, 0x0072845D, 0x006F805B, 0x0072805E, 0x0073815F, 0x00717E5E, 0x0074855A, 0x0074855A, 0x0074855A, 0x0074855A, 0x0074855A, 0x0075865B, 0x0075865B, 0x0075865B, 0x0074855A, 0x0074855A, 0x0077885D, 0x00798A5F, 0x0076875C,
        0x0077885D, 0x00798A5F, 0x0077885D, 0x0073825C, 0x0076855F, 0x0073825C, 0x0071805A, 0x0073825C, 0x0071805A, 0x0072815B, 0x0075845E, 0x00707F59, 0x0071805A, 0x0074835D, 0x0075845E, 0x0075845E, 0x0074835D, 0x0071805A, 0x006F7E58, 0x006A7854,
        0x0074825E, 0x007A8864, 0x006F7D59, 0x00707E5A, 0x0073815D, 0x0075835F, 0x006D7B57, 0x0059664C, 0x005A674D, 0x0049563C, 0x004A573D, 0x0049563C, 0x00566349, 0x00707D63, 0x005C694F, 0x0076885F, 0x0074865F, 0x00758760, 0x00657651, 0x005A6A48,
        0x00657454, 0x006A795A, 0x00637253, 0x005D694B, 0x00727E60, 0x00758262, 0x00677553, 0x005F6D49, 0x0072815B, 0x006F7E58, 0x006F7F56, 0x00708057, 0x00718158, 0x0073835A, 0x0074845B, 0x0074845B, 0x0075855C, 0x0075855C, 0x0076865D, 0x0071835A,
        0x0071835A, 0x00708259, 0x006F8158, 0x006E8057, 0x006E8057, 0x006F8158, 0x006F8158, 0x0070825B, 0x0070825B, 0x0071835C, 0x0071835C, 0x0072845D, 0x0072845D, 0x0073855E, 0x0073855E, 0x0073845F, 0x0070815C, 0x0071825D, 0x0071825D, 0x006E7F5A,
        0x0070815C, 0x0072835E, 0x0071825D, 0x0073855E, 0x0072845D, 0x0070825B, 0x0070825B, 0x0071835C, 0x0071835C, 0x0071835C, 0x0070825B, 0x006A7D52, 0x006F8257, 0x006C7E57, 0x006D7E59, 0x006F7E5E, 0x00425132, 0x001D2B0F, 0x0039462C, 0x00504E30,
        0x004C482F, 0x004C4534, 0x004E4639, 0x004F473A, 0x004D4635, 0x004B472E, 0x004C4A2C, 0x0041462B, 0x00494E33, 0x00474C2F, 0x0042472A, 0x00404627, 0x003B4122, 0x004E5435, 0x00757C5B, 0x006D8154, 0x00758760, 0x00707F60, 0x0079866C, 0x00717E66,
        0x00667458, 0x00748462, 0x0081936C, 0x007A8767, 0x006A7757, 0x005B6848, 0x00697656, 0x00697656, 0x00798666, 0x006A7757, 0x00596646, 0x00828C7B, 0x007B8771, 0x00687758, 0x006C7A56, 0x00788662, 0x006F7A5A, 0x006D765C, 0x00818873, 0x0062704E,
        0x00485632, 0x00616F4B, 0x004A553B, 0x007C8374, 0x00767D6E, 0x00687456, 0x004E5F34, 0x00546141, 0x0045532F, 0x005F6D43, 0x00667347, 0x004D572C, 0x00474D2A, 0x004A4B31, 0x004C4B37, 0x004C493A, 0x004B4839, 0x004B4839, 0x004D4A3B, 0x004E4B3C,
        0x004E4B3C, 0x004C493A, 0x004A4738, 0x004E4D38, 0x004A4D34, 0x00484D32, 0x00474F31, 0x005C6746, 0x0073825C, 0x0072845B, 0x0073855C, 0x0073815D, 0x0073825C, 0x00718158, 0x0076855F, 0x00647052, 0xFFDDE5D4, 0xFFFDFFFE, 0xFFFBFBFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF8FFFF, 0xFBF3FEFF, 0x00BCCDD0, 0x005E7676, 0x006B8585, 0x006C8783, 0x006B827D, 0x00708681, 0x006A8784, 0x00678481, 0x006E8B88, 0x00688582, 0x006D8A87,
        0x006B8885, 0x006B8885, 0x006B8885, 0x006D8E7F, 0x0065877C, 0x00658983, 0x00648985, 0x006A8D89, 0x005D7F78, 0x005C7D6F, 0x00638372, 0x007B845C, 0x0074815B, 0x00788964, 0x0070815F, 0x00798A69, 0x00768363, 0x0083896A, 0x007E8364, 0x00768C5C,
        0x00758A5D, 0x0075895C, 0x0074865D, 0x0071835C, 0x0074825E, 0x00768462, 0x00768462, 0x0074855A, 0x0074855A, 0x0075865B, 0x0075865B, 0x0075865B, 0x0076875C, 0x0075865B, 0x0075865B, 0x0074855A, 0x0075865B, 0x0077885D, 0x00798A5F, 0x0077885D,
        0x0074855A, 0x00728358, 0x006F8055, 0x0076855F, 0x0075845E, 0x006F7E58, 0x00707F59, 0x0072815B, 0x0071805A, 0x0072815B, 0x006F7E58, 0x006F815A, 0x006E8059, 0x006D7F58, 0x006C7E57, 0x006B7D56, 0x006B7D56, 0x006A7C55, 0x006A7C55, 0x006A7A58,
        0x006B7B59, 0x006E7E5C, 0x006E7E5C, 0x0070805E, 0x0071815F, 0x0071815F, 0x006E7E5C, 0x006D7B59, 0x0073815F, 0x006B7957, 0x00677553, 0x0072805E, 0x006D7B59, 0x00657351, 0x00707E5C, 0x0070825B, 0x0073855E, 0x007A8C65, 0x00778962, 0x006F815A,
        0x0071835A, 0x0074865D, 0x00708259, 0x0075865B, 0x0076865D, 0x007D8D64, 0x00728259, 0x0074845B, 0x007A8A61, 0x0075845E, 0x0076855F, 0x0073835A, 0x0073835A, 0x0073835A, 0x0073835A, 0x0073835A, 0x00728259, 0x00728259, 0x00728259, 0x00708259,
        0x006F8158, 0x006F8158, 0x006E8057, 0x006D7F56, 0x006D7F56, 0x006E8057, 0x006E8057, 0x006F815A, 0x006F815A, 0x006F815A, 0x0070825B, 0x0070825B, 0x0070825B, 0x0070825B, 0x0071835C, 0x006F8158, 0x006D7F56, 0x006D7F56, 0x006E8057, 0x006F8158,
        0x00708259, 0x00708259, 0x006E8057, 0x0073855E, 0x0071835C, 0x006F815A, 0x006F815A, 0x0070825B, 0x0071835C, 0x0071835C, 0x0071835C, 0x006C7F54, 0x00708358, 0x006C7E55, 0x0070825B, 0x00778765, 0x004E5D3D, 0x00283718, 0x003F4E2F, 0x00454A2B,
        0x00474B2E, 0x0043452F, 0x0040412D, 0x00464733, 0x00484A34, 0x0043472A, 0x00414627, 0x00394123, 0x00434B2D, 0x003E4627, 0x003D4526, 0x0047502F, 0x00454E2D, 0x00505938, 0x006F7857, 0x006C8051, 0x0073865B, 0x00798B64, 0x00758464, 0x006E7D5D,
        0x00748462, 0x007C8E67, 0x005E7146, 0x006A7854, 0x005B6945, 0x004A5834, 0x004D5B37, 0x0065734F, 0x006A7854, 0x005F6D49, 0x00566440, 0x00647157, 0x00546344, 0x0072835E, 0x0083936A, 0x007A8A61, 0x006B7852, 0x005B6645, 0x00727C5E, 0x0052603C,
        0x004D5E33, 0x00697A4E, 0x00566440, 0x0078826B, 0x00747E67, 0x00677553, 0x004A5C2D, 0x005E6C48, 0x0053623C, 0x00697A4F, 0x00768559, 0x00616D43, 0x004A5430, 0x0043482B, 0x00494D34, 0x004B4A35, 0x004A4934, 0x004B4A35, 0x004D4C37, 0x00504F3A,
        0x0051503B, 0x00504F3A, 0x004E4D38, 0x00494E31, 0x004B5132, 0x0047502F, 0x00424C28, 0x0055623C, 0x006E7E55, 0x00728358, 0x00718459, 0x0075835F, 0x0074835D, 0x00718158, 0x0076855F, 0x00647052, 0xFFDDE5D4, 0xFFFDFFFE, 0xFFFCFCFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xF0FFFFED, 0xF7FFFFF1, 0x00C9D2B8, 0x00596646, 0x00778863, 0x007F916A, 0x006F7F56, 0x0064754A, 0x00646F49, 0x00646F49, 0x006E7953, 0x00646F49, 0x006D7852,
        0x0068734D, 0x0065704A, 0x0069744E, 0x00728A62, 0x00637A5A, 0x00576F57, 0x00506758, 0x00556D61, 0x00435849, 0x003E543C, 0x0040563A, 0x002D4435, 0x002C4138, 0x00405251, 0x003D4F50, 0x00506059, 0x004B5D46, 0x00697B52, 0x00768A55, 0x00708753,
        0x00738A56, 0x00748958, 0x00728657, 0x006F8354, 0x00708155, 0x00728357, 0x0076875C, 0x0074855A, 0x0074855A, 0x0074855A, 0x0075865B, 0x0075865B, 0x0075865B, 0x0075865B, 0x0075865B, 0x0074855A, 0x0075865B, 0x0076875C, 0x0077885D, 0x0076875C,
        0x00708156, 0x0066774C, 0x00607146, 0x005C6B45, 0x005B6A44, 0x00576640, 0x005B6A44, 0x00596842, 0x00576640, 0x005E6D47, 0x00576640, 0x00556740, 0x0054663F, 0x0052643D, 0x0052643D, 0x0052643D, 0x0054663F, 0x00566841, 0x00586A43, 0x00586846,
        0x00546442, 0x00526240, 0x00576745, 0x00596947, 0x00586846, 0x00546442, 0x00546442, 0x005D6C46, 0x0051603A, 0x00586741, 0x005D6C46, 0x005F6E48, 0x005E6D47, 0x0051603A, 0x00586741, 0x005B6C47, 0x0060724B, 0x006A7C55, 0x0073855C, 0x00718459,
        0x006E8156, 0x006E8255, 0x006A7E51, 0x00748657, 0x00708253, 0x00718256, 0x00738458, 0x00798A5F, 0x0075855C, 0x0078885F, 0x0074845B, 0x0073835A, 0x00728259, 0x00728259, 0x0073835A, 0x0073835A, 0x0074845B, 0x0074845B, 0x0074845B, 0x00708259,
        0x00708259, 0x006F8158, 0x006F8158, 0x006F8158, 0x006F8158, 0x006F8158, 0x00708259, 0x00708259, 0x00708259, 0x00708259, 0x00708259, 0x006F8158, 0x006F8158, 0x006F8158, 0x006F8158, 0x006D8055, 0x006C7F54, 0x006B7E53, 0x006C7F54, 0x006F8257,
        0x00708358, 0x006F8257, 0x006E8156, 0x006F8158, 0x006D7F56, 0x006B7D54, 0x006B7D54, 0x006C7E55, 0x006D7F56, 0x006D7F56, 0x006D7F56, 0x006F8257, 0x00708358, 0x006B7D54, 0x006E8059, 0x0073855E, 0x004C5D38, 0x0021310F, 0x002B3B19, 0x002A3B1A,
        0x0029391A, 0x0028371B, 0x0026351A, 0x0026351A, 0x0028371B, 0x0029391A, 0x00273817, 0x002E3919, 0x002E3919, 0x00273211, 0x00394423, 0x00626D4C, 0x00707C58, 0x006E7A56, 0x00788460, 0x00728657, 0x00768A5D, 0x0076895E, 0x007F916A, 0x008D9F78,
        0x00768861, 0x005F7148, 0x0053663B, 0x00627249, 0x006A7A51, 0x0066764D, 0x005C6C43, 0x00697950, 0x005F6F46, 0x005E6E45, 0x00697950, 0x00627151, 0x00677755, 0x00798B64, 0x007E8E65, 0x005B6C41, 0x00616F46, 0x0073805A, 0x0046532D, 0x0035441E,
        0x00617246, 0x00647746, 0x0046572C, 0x006B7858, 0x00636F53, 0x005D6C46, 0x00617443, 0x0054643B, 0x005C6C43, 0x006B7C51, 0x00738459, 0x00728057, 0x005F6B47, 0x00434E2E, 0x00374123, 0x003D4320, 0x003F4522, 0x00414724, 0x00424825, 0x00424825,
        0x00424825, 0x00434926, 0x00444A27, 0x003C4824, 0x003F4B27, 0x003B4723, 0x0036431D, 0x00515F36, 0x00728259, 0x0077885D, 0x0074855A, 0x00768460, 0x0075845E, 0x0073835A, 0x00778660, 0x00657153, 0xFFDDE5D4, 0xFFFDFFFE, 0xFFFDFDFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF9FFF7, 0xFFFBFFF5, 0x00CBD8C0, 0x00566746, 0x0080946A, 0x007F9368, 0x0052673A, 0x002C4114, 0x0039471E, 0x0036441B, 0x003A481F, 0x0028360D, 0x003C4A21,
        0x0039471E, 0x0035431A, 0x00404E25, 0x00697870, 0x005B6B6A, 0x00566673, 0x00677690, 0x0098A5C5, 0x009AA8C4, 0x009DAAC0, 0x0096A3B3, 0x0089A6B4, 0x00849EAF, 0x00869AB3, 0x005D6D84, 0x00596871, 0x0046594A, 0x00667E54, 0x00789459, 0x00778B60,
        0x00798D62, 0x00778B5E, 0x0074885B, 0x00748859, 0x00748657, 0x00748657, 0x00778A59, 0x00738459, 0x00738459, 0x00738459, 0x00738459, 0x0074855A, 0x0074855A, 0x0074855A, 0x0075865B, 0x0074855A, 0x0075865B, 0x0074855A, 0x0075865B, 0x0076875C,
        0x006C7D52, 0x005B6C41, 0x00506136, 0x00505F39, 0x0056653F, 0x0051603A, 0x0056653F, 0x0055643E, 0x004F5E38, 0x00586741, 0x0054633D, 0x004F613A, 0x004F613A, 0x0050623B, 0x0051633C, 0x0051633C, 0x0052643D, 0x0053653E, 0x0053653E, 0x004D5F38,
        0x0052643D, 0x0051633C, 0x0052643D, 0x004F613A, 0x00556740, 0x0053653E, 0x0052643D, 0x004D5F36, 0x0056683F, 0x00576940, 0x004C5E35, 0x0053653C, 0x0052643B, 0x00475930, 0x005A6C43, 0x004F613A, 0x00586A43, 0x0063754E, 0x0072845B, 0x0076885F,
        0x0073855C, 0x0074865D, 0x00718459, 0x006F8054, 0x00748559, 0x00708155, 0x00738458, 0x00738459, 0x00708156, 0x00798A5F, 0x006F8055, 0x0076865D, 0x0075855C, 0x0074845B, 0x0074845B, 0x0075855C, 0x0076865D, 0x0076865D, 0x0076865D, 0x006F8257,
        0x006E8156, 0x006E8156, 0x006D8055, 0x006D8055, 0x006E8156, 0x006E8156, 0x006F8257, 0x006F8158, 0x006E8057, 0x006E8057, 0x006D7F56, 0x006D7F56, 0x006C7E55, 0x006C7E55, 0x006C7E55, 0x00738459, 0x00728358, 0x006D7E53, 0x006B7C51, 0x006F8055,
        0x00708156, 0x006F8055, 0x00718257, 0x00708259, 0x006F8158, 0x006D7F56, 0x006D7F56, 0x006E8057, 0x006E8057, 0x006E8057, 0x006D7F56, 0x006F8257, 0x006E8156, 0x006C7E55, 0x006E8057, 0x00708259, 0x0051633C, 0x002A3C15, 0x00293B14, 0x00213917,
        0x001E3614, 0x001F3715, 0x00213917, 0x001C3412, 0x001C3412, 0x00203816, 0x00203816, 0x002B3615, 0x002B3615, 0x00283312, 0x003D4925, 0x0067734F, 0x0078855F, 0x0073805A, 0x0074815B, 0x0074885B, 0x0074885B, 0x0075885D, 0x007C8F64, 0x006E8057,
        0x005A6C43, 0x0055673E, 0x0061734C, 0x0058683F, 0x00607047, 0x0066764D, 0x005E6E45, 0x005E6E45, 0x0056663D, 0x005A6A41, 0x005E6E45, 0x0070815C, 0x00879873, 0x007C8E67, 0x00606F49, 0x005E6E45, 0x006B7950, 0x0056643A, 0x002E3C12, 0x006B7955,
        0x005C6D41, 0x003C4F1C, 0x003C4E1F, 0x006B7955, 0x006C7959, 0x00606F49, 0x00546637, 0x005B6C40, 0x00708156, 0x0074855A, 0x006F7F56, 0x00798862, 0x006F805B, 0x00465634, 0x00243412, 0x002E3A10, 0x00313D13, 0x00333F15, 0x00333F15, 0x00303C12,
        0x00303C12, 0x00323E14, 0x00354117, 0x00303E1A, 0x00303E1A, 0x002D3C16, 0x002E3D17, 0x004D5C36, 0x0074815B, 0x0077855C, 0x00717F56, 0x00768460, 0x0076855F, 0x0074845B, 0x00778660, 0x00636F51, 0xFFDBE3D2, 0xFFFDFFFE, 0xFFFDFDFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF8FEFF, 0xFFF8FEFD, 0x00C5CEC1, 0x00505D43, 0x007F8F6D, 0x007F916A, 0x0055693F, 0x002E441A, 0x00586A45, 0x0051633E, 0x004A5C37, 0x0031431E, 0x004C5E39,
        0x00435530, 0x0031431E, 0x003B4D28, 0x006A7E61, 0x00556855, 0x00576968, 0x008899A6, 0x00D2E3F8, 0x00D3E5F6, 0x00D3E5F0, 0x00CADDE2, 0x00D5E2FA, 0x00DAE7FD, 0x00CDD7E9, 0x0079828B, 0x00626D6A, 0x00485644, 0x00627554, 0x00667C52, 0x005D6A54,
        0x005B6951, 0x00536046, 0x00526142, 0x005A6A48, 0x005E6D47, 0x005B6C41, 0x005B6C41, 0x00738459, 0x00728358, 0x00728358, 0x00718257, 0x00718257, 0x00728358, 0x00738459, 0x0074855A, 0x00738459, 0x0075865B, 0x00728358, 0x0075865B, 0x0078895E,
        0x006A7B50, 0x00536439, 0x0045562B, 0x0031401A, 0x003D4C26, 0x002A3913, 0x002D3C16, 0x003C4B25, 0x0032411B, 0x002E3D17, 0x002C3B15, 0x002C3F18, 0x002D4019, 0x002F421B, 0x002F421B, 0x002F421B, 0x002E411A, 0x002C3F18, 0x002B3E17, 0x002D4116,
        0x0033471C, 0x00304419, 0x00304419, 0x00293D12, 0x0031451A, 0x002D4116, 0x002B3F14, 0x0030461C, 0x002B4117, 0x002D4319, 0x002A4016, 0x00263C12, 0x002C4218, 0x002C4218, 0x0023390F, 0x003A4C23, 0x004B5D34, 0x005B6D44, 0x006E8059, 0x0074865F,
        0x0070815C, 0x00748560, 0x00728260, 0x00707F59, 0x0074835D, 0x00718158, 0x0078885F, 0x00718257, 0x0076875B, 0x007B8C60, 0x0077885C, 0x0078885F, 0x0076865D, 0x0074845B, 0x0073835A, 0x0074845B, 0x0075855C, 0x0074845B, 0x0073835A, 0x00718459,
        0x00708358, 0x00708358, 0x00708358, 0x00708358, 0x00708358, 0x00718459, 0x00718459, 0x0071835A, 0x00708259, 0x00708259, 0x00708259, 0x00708259, 0x00708259, 0x00708259, 0x00708259, 0x0073835A, 0x0074845B, 0x006E7E55, 0x006C7C53, 0x00708057,
        0x00708057, 0x00708057, 0x0074845B, 0x0073855C, 0x0072845B, 0x0071835A, 0x0071835A, 0x0071835A, 0x0071835A, 0x006F8158, 0x006E8057, 0x006D8055, 0x006C7F54, 0x00708358, 0x00718459, 0x0074875C, 0x006B7E53, 0x00596C41, 0x00596C41, 0x005A6D4C,
        0x005A6E4B, 0x005B704A, 0x005C714B, 0x005C714B, 0x005A6F49, 0x00586C49, 0x00596C4B, 0x005C6A46, 0x00606E4A, 0x005F6D49, 0x0063724C, 0x00707F59, 0x0074835D, 0x00708057, 0x00728259, 0x0071835A, 0x00708259, 0x00708358, 0x0072855A, 0x0056693E,
        0x005E7047, 0x005B6C47, 0x0053643F, 0x0063724C, 0x0064734D, 0x00606F49, 0x00576640, 0x00576640, 0x005C6B45, 0x0061704A, 0x00606F49, 0x006C7E57, 0x0060714C, 0x00576843, 0x0054623E, 0x00677551, 0x0058653F, 0x003B491F, 0x00637147, 0x006A7856,
        0x0036471C, 0x003F521F, 0x00647746, 0x0065734F, 0x00536040, 0x0055633F, 0x005C6D42, 0x006E8051, 0x0078895D, 0x00728358, 0x006A7C55, 0x0073845F, 0x00758762, 0x00657752, 0x0052643F, 0x005A6943, 0x005B6A44, 0x005B6A44, 0x005B6A44, 0x005A6943,
        0x005A6943, 0x005B6A44, 0x005D6C46, 0x00586944, 0x00576843, 0x00576843, 0x00596743, 0x006A7854, 0x007C8864, 0x0077835F, 0x0076825E, 0x0074825E, 0x0075845E, 0x0074845B, 0x0076855F, 0x00606C4E, 0xFFD8E0CF, 0xFFFCFFFD, 0xFFFDFDFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFBFF, 0xFFFBF8FA, 0x00D3D1C6, 0x0063634B, 0x008D916E, 0x00838B62, 0x005D673D, 0x003C481E, 0x0064764F, 0x0060724B, 0x005B6D46, 0x00455730, 0x00687A53,
        0x00566841, 0x0032441D, 0x0033451E, 0x0079815C, 0x00535C42, 0x00565D58, 0x00989EA9, 0x00E3E9FC, 0x00CBD2E3, 0x00C1C8D1, 0x00C2C9CC, 0x00C8C6DA, 0x00E4E2EE, 0x00DBDCDA, 0x00767969, 0x005C6249, 0x0040492F, 0x004B543F, 0x003A4531, 0x005B625F,
        0x00515952, 0x00424A3F, 0x003E4837, 0x0048553D, 0x004C583C, 0x0043512F, 0x003F4D29, 0x00738459, 0x00728358, 0x00708156, 0x00708156, 0x00708156, 0x00718257, 0x00738459, 0x0074855A, 0x00738459, 0x0074855A, 0x00718257, 0x0074855A, 0x00798A5F,
        0x006A7B50, 0x004F6035, 0x003F5025, 0x004A5933, 0x0056653F, 0x0033421C, 0x0036451F, 0x00576640, 0x004A5933, 0x0035441E, 0x0031401A, 0x002D4019, 0x002E411A, 0x002F421B, 0x0030431C, 0x0031441D, 0x0030431C, 0x0030431C, 0x002F421B, 0x00324818,
        0x00324818, 0x002D4313, 0x00344A1A, 0x00304616, 0x00354B1B, 0x002F4515, 0x00304616, 0x002D451B, 0x0030481E, 0x002B4319, 0x002D451B, 0x002D451B, 0x00284016, 0x002B4319, 0x002A4218, 0x00314419, 0x00495C31, 0x005E7047, 0x0073855E, 0x00778765,
        0x00707F5F, 0x00738263, 0x00728162, 0x00798765, 0x00707E5C, 0x006E7C58, 0x00798862, 0x006E7F54, 0x0075865A, 0x006F8152, 0x00738556, 0x00728259, 0x00708057, 0x006F7F56, 0x006F7F56, 0x00728259, 0x0074845B, 0x0074845B, 0x0073835A, 0x006E8156,
        0x006E8156, 0x006D8055, 0x006D8055, 0x006D8055, 0x006E8156, 0x006F8257, 0x006F8257, 0x006E8156, 0x006E8156, 0x006E8156, 0x006F8257, 0x006F8257, 0x006F8257, 0x00708358, 0x00708358, 0x006E7D57, 0x0072815B, 0x006F7E58, 0x006F7E58, 0x0074835D,
        0x0073825C, 0x0071805A, 0x0075845E, 0x00708358, 0x00708358, 0x006F8257, 0x006F8257, 0x006F8257, 0x006E8156, 0x006C7F54, 0x006A7D52, 0x0071835A, 0x006D8055, 0x006F8257, 0x006A7D52, 0x006A7D52, 0x006F8257, 0x006F8257, 0x0074875C, 0x00778262,
        0x007B8665, 0x0075815D, 0x00727F59, 0x00798660, 0x00798561, 0x00747F5E, 0x00778262, 0x00748560, 0x00768762, 0x00748560, 0x0071835C, 0x0072845D, 0x0072845B, 0x00708259, 0x00708259, 0x0070825B, 0x007E9067, 0x0062744B, 0x00576A3F, 0x004D5F36,
        0x005F714A, 0x0050603E, 0x005C6B4B, 0x00505E3A, 0x00667450, 0x00687652, 0x0064724E, 0x0065734F, 0x00667450, 0x00606E4A, 0x00667450, 0x00657750, 0x0060714C, 0x00647452, 0x00707E5C, 0x00485634, 0x0035421C, 0x00606E45, 0x006B794F, 0x00334020,
        0x003E4F24, 0x00607340, 0x005A6D3C, 0x0055633F, 0x00717D5F, 0x0072805E, 0x006A7A51, 0x006D804F, 0x006A7B4F, 0x006A7A51, 0x006D7F58, 0x006A7C57, 0x00647651, 0x00667B55, 0x006D825B, 0x006D7D5E, 0x006B7B5C, 0x006A7A5B, 0x006A7A5B, 0x006C7C5D,
        0x006D7D5E, 0x006D7D5E, 0x006C7C5D, 0x006C7E59, 0x006D7E5C, 0x00748462, 0x00748462, 0x00768462, 0x00747F5E, 0x006D7857, 0x00768160, 0x0072805C, 0x0074835D, 0x0074845B, 0x0075845E, 0x005E6A4C, 0xFFD5DDCC, 0xFFFAFDFB, 0xFFFDFDFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFEFF, 0xFFFBFBFB, 0x00C8CFBA, 0x0058693D, 0x00819267, 0x00808F70, 0x00566742, 0x00395117, 0x0062744D, 0x0034461F, 0x0064764F, 0x00394B24, 0x0053653E,
        0x00596B44, 0x0031431C, 0x00384A23, 0x00658054, 0x00617957, 0x00576958, 0x00A2AFAD, 0x00D7E1E8, 0x00CFD8E1, 0x00C5D0D4, 0x00B1BDBD, 0x00C9CDDF, 0x00D1D4E2, 0x00D3D5DD, 0x009B9D9D, 0x00757A71, 0x00757F6E, 0x0056664E, 0x0062755A, 0x009C9DA1,
        0x00787A7B, 0x00666868, 0x006C6F6D, 0x005D615B, 0x008D9289, 0x007F8679, 0x00373E31, 0x0076875B, 0x00708155, 0x006F8054, 0x00728357, 0x00728357, 0x00748559, 0x0075865A, 0x00738458, 0x0076875C, 0x00728358, 0x00738459, 0x00728259, 0x007A8A61,
        0x0064744B, 0x00505F39, 0x0041502A, 0x0034461F, 0x005E7049, 0x00556740, 0x00263811, 0x004A5C35, 0x00697B54, 0x00384A23, 0x002D3F18, 0x002E4519, 0x002B4216, 0x002A4115, 0x002F461A, 0x00334A1E, 0x0031481C, 0x002D4418, 0x002D4418, 0x002F4417,
        0x002E4316, 0x00314619, 0x00314619, 0x002E4316, 0x0033481B, 0x00364B1E, 0x00304518, 0x00314619, 0x002D4417, 0x002C4317, 0x002C4317, 0x002A4218, 0x00294117, 0x00274217, 0x00264018, 0x002F4319, 0x004F6339, 0x00576940, 0x0076885F, 0x0072845B,
        0x0075855C, 0x0073835A, 0x0077875E, 0x0076875C, 0x0075865B, 0x0074855A, 0x0074855A, 0x0074855A, 0x0074855A, 0x0075865B, 0x0076875C, 0x0076865D, 0x0076865D, 0x0074845B, 0x0073835A, 0x0073835A, 0x00728259, 0x00728259, 0x00728259, 0x00708057,
        0x00708057, 0x00718158, 0x00708057, 0x00708057, 0x006F7F56, 0x006E7E55, 0x006D7D54, 0x006C7E55, 0x006C7E55, 0x006D7F56, 0x006D7F56, 0x006E8057, 0x006F8158, 0x006F8158, 0x00708259, 0x00708057, 0x00708057, 0x00708057, 0x00708057, 0x00718158,
        0x00718158, 0x00718158, 0x00718158, 0x00728259, 0x00718158, 0x00718158, 0x00708057, 0x00708057, 0x00708057, 0x00708057, 0x00708057, 0x006E7D57, 0x0073835A, 0x00718158, 0x006D7F56, 0x0072855A, 0x00718459, 0x006D8255, 0x00708558, 0x00748153,
        0x00738354, 0x00718054, 0x006E7F54, 0x006B7D54, 0x0071845D, 0x006D7F5A, 0x006C7E59, 0x006A825A, 0x006E835C, 0x00697E57, 0x006E815A, 0x0073845F, 0x00738361, 0x00758262, 0x006D795B, 0x00758861, 0x006B7E57, 0x006A7D56, 0x00556841, 0x0053663F,
        0x00546740, 0x00546740, 0x004C5F38, 0x006B7E57, 0x004B5E37, 0x003F522B, 0x00566942, 0x00586B44, 0x003F522B, 0x00566942, 0x00556841, 0x003A4B29, 0x005D6E4C, 0x0052643F, 0x003E502B, 0x00576A43, 0x0055693F, 0x00586C42, 0x003D5126, 0x00333F21,
        0x006B7955, 0x004A5B30, 0x00606D47, 0x00768161, 0x006E7756, 0x00738052, 0x0065773C, 0x00606C50, 0x005E6B4B, 0x005B6945, 0x005A6B40, 0x005A6B3F, 0x005A6B3F, 0x0058693E, 0x0056663D, 0x005A6844, 0x00586642, 0x00596743, 0x005C6A46, 0x005D6B47,
        0x005B6945, 0x005D6B47, 0x00616F4B, 0x0063714F, 0x005C6A48, 0x006D7B59, 0x00667654, 0x00697A55, 0x0071835E, 0x006D8059, 0x00667A50, 0x006D7E59, 0x006E8059, 0x006E8057, 0x00728259, 0x00616E4E, 0xFFD1D8C3, 0xFFFFFFF9, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFEFF, 0xFFFDFDFD, 0x00CAD1BC, 0x0056673B, 0x007B8C61, 0x00798869, 0x0050613C, 0x00324A10, 0x006C7E57, 0x0053653E, 0x0062744D, 0x00364821, 0x005E7049,
        0x0060724B, 0x002B3D16, 0x0033451E, 0x006E8461, 0x004F6249, 0x005C6A5F, 0x00AEB7BB, 0x00DAE0ED, 0x00C7CDDA, 0x00C9CFDA, 0x00CAD2D9, 0x00C9CFDC, 0x00DEE3EC, 0x00CFD2D6, 0x00909391, 0x00ADB3A8, 0x0076816D, 0x003D4D35, 0x006F8366, 0x00ABAFAA,
        0x008C908A, 0x005D6259, 0x00646A5F, 0x00818879, 0x00A8B09F, 0x00848D79, 0x00555E49, 0x005C6D41, 0x007A8B5F, 0x0078895D, 0x006C7D51, 0x0077885C, 0x0077885C, 0x006E7F53, 0x0076875B, 0x0077885D, 0x00738459, 0x0075865B, 0x0073835A, 0x007B8B62,
        0x0066764D, 0x0051603A, 0x0043522C, 0x00263811, 0x0043552E, 0x005F714A, 0x0041532C, 0x002B3D16, 0x00566841, 0x005C6E47, 0x00283A13, 0x0031481C, 0x0030471B, 0x002F461A, 0x0030471B, 0x0030471B, 0x002E4519, 0x002E4519, 0x002F461A, 0x00304419,
        0x00304419, 0x0031451A, 0x0031451A, 0x002F4318, 0x0031451A, 0x0032461B, 0x00304419, 0x0034491C, 0x0035491E, 0x002E4519, 0x002B4216, 0x002C441A, 0x002A4218, 0x00253F17, 0x00274119, 0x002F4319, 0x004F6339, 0x00576940, 0x0075875E, 0x0071835A,
        0x0075855C, 0x0073835A, 0x0076865D, 0x0075865B, 0x0074855A, 0x0074855A, 0x0074855A, 0x0074855A, 0x0074855A, 0x0074855A, 0x0075865B, 0x0074845B, 0x0073835A, 0x0073835A, 0x00728259, 0x00728259, 0x00728259, 0x00728259, 0x0073835A, 0x0073835A,
        0x0073835A, 0x0073835A, 0x0073835A, 0x00728259, 0x00718158, 0x00718158, 0x00708057, 0x006D7F56, 0x006D7F56, 0x006E8057, 0x006E8057, 0x006F8158, 0x00708259, 0x00708259, 0x00708259, 0x00708057, 0x00708057, 0x00708057, 0x00708057, 0x00718158,
        0x00718158, 0x00718158, 0x00718158, 0x00728259, 0x00718158, 0x00718158, 0x00708057, 0x00708057, 0x00708057, 0x00708057, 0x00708057, 0x006E7E55, 0x006D7D54, 0x006F7F56, 0x0071835A, 0x006F815A, 0x00667851, 0x0063764F, 0x006C7E59, 0x0076875C,
        0x0063734A, 0x006D7C56, 0x006B7C57, 0x007D8F68, 0x0064764D, 0x006F8257, 0x007C9063, 0x006D7F56, 0x006E8156, 0x006F8257, 0x006A7C53, 0x0070825B, 0x006E7C5A, 0x005F6B4D, 0x00697559, 0x00697A58, 0x0060714F, 0x00617250, 0x00485937, 0x004F603E,
        0x00536442, 0x004D5E3C, 0x00586947, 0x004A5B39, 0x00415230, 0x00465735, 0x00556644, 0x00495A38, 0x00374826, 0x00586947, 0x00586947, 0x00455536, 0x00556546, 0x00485938, 0x00455634, 0x00586A45, 0x00536540, 0x0053663F, 0x0051643D, 0x00536040,
        0x0053623C, 0x005D6E43, 0x00707C58, 0x00687156, 0x005B6247, 0x004E5931, 0x0062723D, 0x005C6544, 0x0058633D, 0x00535F35, 0x00505D2F, 0x004E5C2C, 0x004C5A2A, 0x00495628, 0x00465327, 0x00465228, 0x00445026, 0x00455127, 0x0048542A, 0x0049552B,
        0x0048542A, 0x004A562C, 0x004F5B31, 0x00515F35, 0x0057653C, 0x00586342, 0x005C684A, 0x00606C4E, 0x00637252, 0x00667752, 0x00687A51, 0x006B7C57, 0x006C7E57, 0x006C7E55, 0x00707F59, 0x005F6C4C, 0xFFD0D6C3, 0xFFFEFFFA, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFDFF, 0xFFFEFEFE, 0x00C9D0BB, 0x00596A3E, 0x00819267, 0x007F8E6F, 0x00566742, 0x00344C12, 0x0063754E, 0x0060724B, 0x00576942, 0x003B4D26, 0x005E7049,
        0x0061734C, 0x00364821, 0x003B4D26, 0x00727F65, 0x0047523E, 0x005E655E, 0x00A4A7AC, 0x00EAEAF6, 0x00E1E1ED, 0x00D4D5DF, 0x00D1D3DB, 0x00D2DBDE, 0x00D8DDDE, 0x00D1D6D4, 0x006B6E65, 0x00808576, 0x0067735D, 0x0057664A, 0x00455A3A, 0x004B5440,
        0x00656E5A, 0x00565F4A, 0x00505A43, 0x004F5A40, 0x00586448, 0x00546042, 0x006D7A5A, 0x004F6034, 0x0068794D, 0x007A8B5F, 0x0077885C, 0x00728357, 0x00748559, 0x0076875B, 0x00738458, 0x0077885D, 0x0074855A, 0x0076875C, 0x0074845B, 0x007C8C63,
        0x0067774E, 0x0053623C, 0x0045542E, 0x0050623B, 0x00253710, 0x004B5D36, 0x006A7C55, 0x002E4019, 0x0032441D, 0x00687A53, 0x004D5F38, 0x002D4116, 0x002E4217, 0x002F4318, 0x002E4217, 0x002C4015, 0x002E4217, 0x0031451A, 0x0032461B, 0x0032461B,
        0x0033471C, 0x0032461B, 0x0032461B, 0x0032461B, 0x0031451A, 0x00304419, 0x0032461B, 0x00304419, 0x0033471C, 0x002B4216, 0x00283E14, 0x002D4319, 0x002A421A, 0x00273F17, 0x00294119, 0x002E4218, 0x004F6339, 0x0056683F, 0x0075875E, 0x00708259,
        0x0074845B, 0x00728259, 0x0075855C, 0x00738459, 0x00738459, 0x00738459, 0x0074855A, 0x0074855A, 0x00738459, 0x00738459, 0x00738459, 0x00728259, 0x00718158, 0x00718158, 0x00718158, 0x00718158, 0x00728259, 0x0073835A, 0x0073835A, 0x0073835A,
        0x0073835A, 0x0073835A, 0x0073835A, 0x0073835A, 0x00728259, 0x00718158, 0x00708057, 0x006E8057, 0x006E8057, 0x006F8158, 0x006F8158, 0x00708259, 0x00708259, 0x0071835A, 0x0071835A, 0x00708057, 0x00708057, 0x00708057, 0x00708057, 0x00718158,
        0x00718158, 0x00718158, 0x00718158, 0x00728259, 0x00718158, 0x00718158, 0x00708057, 0x00708057, 0x00708057, 0x00708057, 0x00708057, 0x00718256, 0x006F8055, 0x006E7E55, 0x00657651, 0x00546442, 0x00495839, 0x0048573B, 0x004D5C40, 0x00526643,
        0x004C5F3E, 0x004A593D, 0x0049573B, 0x00617050, 0x0067774E, 0x00718151, 0x006F824B, 0x00778157, 0x00758256, 0x007A875B, 0x006E7D51, 0x00728259, 0x00647250, 0x00445236, 0x005D6A52, 0x003F4E33, 0x00445338, 0x004E5D42, 0x002F3E23, 0x00455439,
        0x0047563B, 0x002D3C21, 0x00505F44, 0x00526146, 0x00324126, 0x00707F64, 0x004A593E, 0x00314025, 0x004D5C41, 0x00324126, 0x0047563B, 0x0064715B, 0x0035432B, 0x00445338, 0x005E6D51, 0x00334324, 0x00425332, 0x005D6E4C, 0x00455732, 0x005A6846,
        0x004A5A31, 0x00607146, 0x005B6645, 0x00575F48, 0x00797E69, 0x00636B4C, 0x004D592F, 0x00586136, 0x00525C2E, 0x004C5824, 0x00495620, 0x0047541C, 0x0045521A, 0x00424E1A, 0x00404B19, 0x00434C19, 0x00434C19, 0x00444D1A, 0x00454E1B, 0x00464F1C,
        0x00464F1C, 0x0049521F, 0x004D5623, 0x00485620, 0x005B6638, 0x004C5332, 0x005A6049, 0x00595E49, 0x005C654B, 0x00646F4F, 0x00707D57, 0x00697957, 0x006A7C55, 0x006B7D54, 0x006F7E58, 0x005E6B4B, 0xFFCFD5C2, 0xFFFEFFFA, 0xFFFFFEFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFEFF, 0xFFFEFEFE, 0x00C6CDB8, 0x0056673B, 0x007E8F64, 0x007A896A, 0x0051623D, 0x002D450B, 0x00354720, 0x00364821, 0x0031431C, 0x002D3F18, 0x00354720,
        0x003B4D26, 0x002E4019, 0x002D3F18, 0x006E7A5C, 0x006F7A60, 0x008E9685, 0x009BA097, 0x00DBDEDC, 0x00DEE1DF, 0x00D1D4D2, 0x00DCE0DB, 0x00D0DBD3, 0x00EDF6EC, 0x00CBD2C5, 0x006C7261, 0x00ABB39C, 0x00879377, 0x00637453, 0x007C8F6E, 0x00717F5D,
        0x00717F5D, 0x006A7856, 0x0074825E, 0x0073825C, 0x0073825C, 0x005D6D44, 0x00526239, 0x00516237, 0x00516237, 0x0067784D, 0x007A8B60, 0x0075865B, 0x00738459, 0x0077885D, 0x00738459, 0x0076875C, 0x0074855A, 0x0076875C, 0x0074845B, 0x007B8B62,
        0x0066764D, 0x0053623C, 0x0045542E, 0x0071835C, 0x004A5C35, 0x0031431C, 0x00556740, 0x005C6E47, 0x0030421B, 0x003B4D26, 0x006E8059, 0x003A4E24, 0x00384C22, 0x00384C22, 0x00364A20, 0x0033471D, 0x0035491F, 0x00374B21, 0x0033471D, 0x0033471D,
        0x0034481E, 0x0032461C, 0x0033471D, 0x0035491F, 0x0033471D, 0x0031451B, 0x0035491F, 0x0033471C, 0x0032461B, 0x0031451B, 0x002E441A, 0x002D421B, 0x002F441D, 0x002B431B, 0x00263D17, 0x002E4218, 0x004E6238, 0x0056683F, 0x0074865D, 0x00708259,
        0x0073835A, 0x00718158, 0x0074845B, 0x00718257, 0x00728358, 0x00738459, 0x00738459, 0x00738459, 0x00738459, 0x00728358, 0x00718257, 0x0073835A, 0x00728259, 0x00728259, 0x00718158, 0x00728259, 0x00728259, 0x0073835A, 0x0073835A, 0x00718158,
        0x00728259, 0x00728259, 0x00728259, 0x00718158, 0x00708057, 0x006F7F56, 0x006F7F56, 0x006E8057, 0x006E8057, 0x006F8158, 0x006F8158, 0x006F8158, 0x00708259, 0x00708259, 0x00708259, 0x00708057, 0x00708057, 0x00708057, 0x00708057, 0x00718158,
        0x00718158, 0x00718158, 0x00718158, 0x00728259, 0x00718158, 0x00718158, 0x00708057, 0x00708057, 0x00708057, 0x00708057, 0x00708057, 0x006E7F53, 0x00748559, 0x0075855C, 0x0061724D, 0x004E5D3E, 0x00525F45, 0x005C6953, 0x005A6652, 0x004A5E41,
        0x0055684D, 0x00495942, 0x00616E58, 0x0049573B, 0x0052613B, 0x00556633, 0x0076874E, 0x007A7E5A, 0x00767E55, 0x00778156, 0x00738052, 0x00758359, 0x005E6C4A, 0x00414E34, 0x0057624E, 0x00202C18, 0x003C4834, 0x004A5642, 0x001E2A16, 0x00424E3A,
        0x00434F3B, 0x00182410, 0x00525E4A, 0x0047533F, 0x0027331F, 0x00606C58, 0x00384430, 0x002C3824, 0x005F6B57, 0x0036422E, 0x00333F2B, 0x00636E5E, 0x002E3A28, 0x003D4935, 0x005A6850, 0x0026351A, 0x00425233, 0x00576847, 0x00495A38, 0x0052603C,
        0x0053633A, 0x00536439, 0x00505B3B, 0x00636956, 0x00929586, 0x00868C75, 0x0049532F, 0x005C6330, 0x00555D28, 0x004E571E, 0x004B5618, 0x00495416, 0x00465014, 0x00444D15, 0x00444C17, 0x00444B12, 0x00454C13, 0x00454C13, 0x00464D14, 0x00464D14,
        0x00474E15, 0x00495017, 0x004C531A, 0x004E5D1F, 0x00485321, 0x00464B2B, 0x007B7D6A, 0x00707062, 0x00555946, 0x004E5638, 0x0075805A, 0x00697957, 0x006A7B56, 0x006B7D56, 0x006F7E58, 0x005F6B4D, 0xFFD0D6C3, 0xFFFEFFFA, 0xFFFFFEFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFDFF, 0xFFFFFFFF, 0x00C7CEB9, 0x0057683C, 0x007B8C61, 0x00788768, 0x005F704B, 0x00486026, 0x00495B34, 0x00485A33, 0x00455730, 0x0050623B, 0x00475932,
        0x00475932, 0x004B5D36, 0x004B5D36, 0x006E7C53, 0x007A8761, 0x008F9A7A, 0x006E775C, 0x00858E74, 0x00818972, 0x007D856E, 0x00929B81, 0x00809079, 0x0078846E, 0x0078826B, 0x00676E53, 0x00777F61, 0x00687555, 0x00657553, 0x006E835D, 0x0075865B,
        0x00718257, 0x0078895E, 0x007F9064, 0x006E7F53, 0x00738458, 0x00728357, 0x00637448, 0x0056673C, 0x00516237, 0x004E5F34, 0x00637449, 0x007D8E63, 0x0078895E, 0x006D7E53, 0x0078895E, 0x0074855A, 0x00728358, 0x0075865B, 0x0073835A, 0x007A8A61,
        0x0064744B, 0x0051603A, 0x0045542E, 0x006F815A, 0x0072845D, 0x003E5029, 0x0031431C, 0x005D6F48, 0x004D5F38, 0x002D3F18, 0x00475932, 0x0063754C, 0x005D6F46, 0x005E7047, 0x00607249, 0x00607249, 0x0063754C, 0x0064764D, 0x005E7047, 0x005F724B,
        0x0060734C, 0x0060734C, 0x0061744D, 0x0062754E, 0x0062754E, 0x0062754E, 0x0063764F, 0x0062744B, 0x005C6E45, 0x0060744A, 0x0061744D, 0x005A6D46, 0x005A6F49, 0x005A6F49, 0x004A5F39, 0x002E4218, 0x004E6238, 0x0056683F, 0x0074865D, 0x006F8158,
        0x0073835A, 0x00708057, 0x0073835A, 0x00718257, 0x00718257, 0x00728358, 0x00738459, 0x00738459, 0x00728358, 0x00718257, 0x00718257, 0x0076865D, 0x0075855C, 0x0074845B, 0x0073835A, 0x00728259, 0x00728259, 0x00728259, 0x00728259, 0x00728259,
        0x00728259, 0x00728259, 0x00728259, 0x00728259, 0x00718158, 0x00708057, 0x006F7F56, 0x006D7F56, 0x006E8057, 0x006E8057, 0x006E8057, 0x006E8057, 0x006E8057, 0x006E8057, 0x006E8057, 0x00708057, 0x00708057, 0x00708057, 0x00708057, 0x00718158,
        0x00718158, 0x00718158, 0x00718158, 0x00728259, 0x00718158, 0x00718158, 0x00708057, 0x00708057, 0x00708057, 0x00708057, 0x00708057, 0x006E7F53, 0x00748559, 0x0075855C, 0x0061724D, 0x004D5C3D, 0x00515E44, 0x005B6852, 0x005A6652, 0x00617459,
        0x00607058, 0x0045553E, 0x0065725C, 0x005B6A4F, 0x00667555, 0x004F5F36, 0x00455728, 0x004C5136, 0x00555B3C, 0x005E6941, 0x00728155, 0x0079875D, 0x005D6B49, 0x0048523B, 0x004B5544, 0x001E281B, 0x00475144, 0x004F594C, 0x001A2417, 0x00465043,
        0x00495346, 0x001E281B, 0x00626C5F, 0x004A5447, 0x00263023, 0x005A6457, 0x002E382B, 0x002A3427, 0x00687265, 0x00323C2F, 0x00283225, 0x00646E62, 0x00283225, 0x003A4535, 0x005C6854, 0x00233217, 0x00425233, 0x00566746, 0x00495A38, 0x004E5C38,
        0x0058683F, 0x0054653A, 0x00545F3F, 0x00494F3C, 0x003A3D2E, 0x00434932, 0x0049532F, 0x005E672F, 0x00576027, 0x00505A1E, 0x004D581A, 0x004A5517, 0x00485216, 0x0049521A, 0x004C5320, 0x004B511A, 0x004C521B, 0x004C521B, 0x004C521B, 0x004C521B,
        0x004C521B, 0x004B511A, 0x004A5019, 0x00445316, 0x004C5725, 0x004F5434, 0x00595B48, 0x0048483C, 0x005F6350, 0x005C6446, 0x0067714D, 0x006B7A5A, 0x006C7D58, 0x006D7F58, 0x00717F5B, 0x00606C4E, 0xFFD1D7C6, 0xFFFFFFFC, 0xFFFFFEFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFDFCFF, 0xFFFFFFFF, 0x00C9D0BB, 0x005A6B3F, 0x007A8B60, 0x007A896A, 0x00788964, 0x00748C52, 0x007B8D66, 0x007B8D66, 0x00758760, 0x007C8E67, 0x007F916A,
        0x00778962, 0x00778962, 0x007F916A, 0x00829367, 0x00708155, 0x007B8C61, 0x00708156, 0x0077875E, 0x0071805A, 0x0072815B, 0x007C8B65, 0x006A7B5A, 0x006F7F5D, 0x00727D5C, 0x006C7652, 0x0069734F, 0x0077845E, 0x00788A63, 0x0072855E, 0x00788A5B,
        0x00748657, 0x00738556, 0x00728455, 0x006A7B4F, 0x00748559, 0x007B8C60, 0x0077885C, 0x0065754C, 0x0054643B, 0x004A5A31, 0x0055653C, 0x00697950, 0x0075855C, 0x0074845B, 0x00718158, 0x00728358, 0x00708156, 0x0074855A, 0x00728259, 0x0078885F,
        0x0063734A, 0x0051603A, 0x0045542E, 0x006D7F58, 0x00788A63, 0x00465831, 0x002F411A, 0x00576942, 0x0051633C, 0x002F411A, 0x00374922, 0x0061734A, 0x00576940, 0x005A6C43, 0x00607249, 0x005E7047, 0x00607249, 0x0062744B, 0x005D6F46, 0x00576944,
        0x00576944, 0x005A6C47, 0x00596B46, 0x00576944, 0x005B6D48, 0x005E704B, 0x00596B46, 0x005D6F46, 0x00596B42, 0x0060724B, 0x0062754E, 0x005C6E49, 0x0060724D, 0x005C714B, 0x004B5F3C, 0x002F4319, 0x004F6339, 0x0056683F, 0x0074865D, 0x006F8158,
        0x00728259, 0x00708057, 0x0073835A, 0x00718257, 0x00728358, 0x00728358, 0x00728358, 0x00728358, 0x00728358, 0x00728358, 0x00718257, 0x0077875E, 0x0076865D, 0x0075855C, 0x0074845B, 0x0073835A, 0x00728259, 0x00728259, 0x00728259, 0x0075855C,
        0x0075855C, 0x0075855C, 0x0075855C, 0x0074845B, 0x0073835A, 0x00728259, 0x00728259, 0x006D7F56, 0x006D7F56, 0x006D7F56, 0x006D7F56, 0x006D7F56, 0x006D7F56, 0x006D7F56, 0x006D7F56, 0x00708057, 0x00708057, 0x00708057, 0x00708057, 0x00718158,
        0x00718158, 0x00718158, 0x00718158, 0x00728259, 0x00718158, 0x00718158, 0x00708057, 0x00708057, 0x00708057, 0x00708057, 0x00708057, 0x00728357, 0x006F8055, 0x006E7E55, 0x00647550, 0x00536341, 0x00475637, 0x0047563A, 0x004B5A3E, 0x0048563A,
        0x004B593D, 0x004B5A3E, 0x0049583C, 0x00536449, 0x00506146, 0x00495941, 0x00182A13, 0x003A4339, 0x00414D3B, 0x00415031, 0x004D5F38, 0x0053633A, 0x00404E2C, 0x003D452E, 0x00434938, 0x00151F13, 0x00374135, 0x003E483C, 0x00151F13, 0x003A4438,
        0x003B4539, 0x001A2418, 0x004E584C, 0x003C463A, 0x001A2418, 0x00545E52, 0x00252F23, 0x001D271B, 0x005A6458, 0x00202A1E, 0x00293327, 0x00596258, 0x00182216, 0x002F3A2A, 0x0056634D, 0x00202F14, 0x003B4C2B, 0x00536442, 0x0040522D, 0x00515F3D,
        0x004B5B32, 0x0055663B, 0x0065704F, 0x007D856E, 0x006E735E, 0x004D5536, 0x004B572D, 0x005A642F, 0x00525D25, 0x004C581E, 0x004B571B, 0x004A561C, 0x004D5722, 0x00565F2D, 0x0061683B, 0x005E683A, 0x005E683A, 0x005E683A, 0x005E683A, 0x005E683A,
        0x005C6638, 0x00566032, 0x004F592B, 0x004C5925, 0x003D471C, 0x00515738, 0x006F745F, 0x00666A57, 0x00686F5A, 0x005E684A, 0x00737F5B, 0x006D7C5C, 0x006E7E5C, 0x006F805B, 0x0072805C, 0x00616D51, 0xFFD1D7C6, 0xFFFFFFFC, 0xFFFFFEFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFEFF, 0xFFFFFFFF, 0x00C3CAB5, 0x0057683C, 0x0076875C, 0x00738263, 0x00758661, 0x00789056, 0x00758760, 0x0074865F, 0x0074865F, 0x006F815A, 0x007D8F68,
        0x00768861, 0x0071835C, 0x007B8D66, 0x007B8D66, 0x0070825B, 0x0076885F, 0x007F9267, 0x007C8F64, 0x0073855C, 0x00798B64, 0x007C8E67, 0x00798D62, 0x007B8E63, 0x007E8C62, 0x00828E64, 0x00808C62, 0x0078865C, 0x0072855A, 0x0072865B, 0x00718354,
        0x00728357, 0x00718256, 0x0075865A, 0x0078895E, 0x0078895E, 0x0073835A, 0x0073835A, 0x0076865D, 0x005C6C43, 0x0057673E, 0x0055653C, 0x004F5F36, 0x0065754C, 0x00798960, 0x006D7D54, 0x00718257, 0x00708156, 0x0074855A, 0x0073835A, 0x0078885F,
        0x0063734A, 0x0051603A, 0x0045542E, 0x006B7D56, 0x006C7E57, 0x0033451E, 0x0040522B, 0x006A7C55, 0x003B4D26, 0x002A3C15, 0x005E7049, 0x0061734C, 0x00556740, 0x00596B44, 0x0060724B, 0x00576942, 0x0052643D, 0x00596B44, 0x005A6C45, 0x00596A48,
        0x00576846, 0x005D6E4C, 0x005B6C4A, 0x00536442, 0x005D6E4C, 0x00637452, 0x00556644, 0x0054643B, 0x00596842, 0x00576942, 0x00566841, 0x00586A45, 0x005A6C47, 0x00526341, 0x00455936, 0x0030441A, 0x0050643A, 0x00576940, 0x0075875E, 0x00708259,
        0x0073835A, 0x00708057, 0x0073835A, 0x00728358, 0x00728358, 0x00728358, 0x00718257, 0x00718257, 0x00728358, 0x00728358, 0x00728358, 0x0075855C, 0x0074845B, 0x0073835A, 0x00728259, 0x00728259, 0x00728259, 0x00728259, 0x0073835A, 0x0075855C,
        0x0075855C, 0x0075855C, 0x0075855C, 0x0075855C, 0x0074845B, 0x0073835A, 0x00728259, 0x006F8158, 0x006F8158, 0x006E8057, 0x006E8057, 0x006E8057, 0x006E8057, 0x006E8057, 0x006E8057, 0x00708057, 0x00708057, 0x00708057, 0x00708057, 0x00718158,
        0x00718158, 0x00718158, 0x00718158, 0x00728259, 0x00718158, 0x00718158, 0x00708057, 0x00708057, 0x00708057, 0x00708057, 0x00708057, 0x006F7F56, 0x006E7E55, 0x006F7F56, 0x00708259, 0x006D7F58, 0x0063754E, 0x0060734C, 0x00697B56, 0x00565C3D,
        0x00303A16, 0x002A3913, 0x00374924, 0x004D6242, 0x003C4F3E, 0x00465753, 0x00213235, 0x0027373E, 0x003F504C, 0x00495D4A, 0x004B603F, 0x0052653E, 0x0043512F, 0x00333922, 0x00404131, 0x00192317, 0x001E281C, 0x00242E22, 0x00131D11, 0x00273125,
        0x00232D21, 0x00121C10, 0x00252F23, 0x001E281C, 0x00202A1E, 0x00283226, 0x00212B1F, 0x00162014, 0x00283226, 0x001E281C, 0x00172115, 0x00293327, 0x001D271A, 0x001B2715, 0x002E3B25, 0x00324125, 0x00435432, 0x00445730, 0x004D6137, 0x004E5B3B,
        0x0051603A, 0x0066774C, 0x005D6945, 0x0060694E, 0x0061684D, 0x00545F37, 0x0053632E, 0x00566031, 0x004D5826, 0x0044501C, 0x00424F19, 0x00424E1A, 0x00485224, 0x005A6239, 0x006D744F, 0x00667452, 0x00677553, 0x00667452, 0x00657351, 0x00667452,
        0x0062704E, 0x00566442, 0x004A5836, 0x003A4721, 0x003A4622, 0x00424C2E, 0x004D583E, 0x00576248, 0x00637155, 0x00667555, 0x006B7C57, 0x006F7E5E, 0x006F7F5D, 0x006F805B, 0x0072805E, 0x00616D51, 0xFFD0D5C6, 0xFFFEFFFD, 0xFFFFFEFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFEFF, 0xFFFBFBFB, 0x00BCC3AE, 0x0058693D, 0x007E8F64, 0x00798869, 0x00778863, 0x00758D53, 0x00798B64, 0x0074865F, 0x0081936C, 0x0072845D, 0x007C8E67,
        0x007A8C65, 0x00788A63, 0x007B8D66, 0x00718366, 0x007E9071, 0x00708461, 0x00728761, 0x00748963, 0x00748963, 0x00748865, 0x006F8261, 0x006F8555, 0x00728455, 0x00788859, 0x00778156, 0x007F895E, 0x00738256, 0x00798A5F, 0x006E8257, 0x00748559,
        0x00738458, 0x00738459, 0x0074845B, 0x00718158, 0x006B7A54, 0x006D7C56, 0x0075835F, 0x007A8A61, 0x00728259, 0x005F6F46, 0x004F5F36, 0x004D5D34, 0x0056663D, 0x0068784F, 0x00798960, 0x00718257, 0x00718257, 0x0075865B, 0x0073835A, 0x00798960,
        0x0063734A, 0x0052613B, 0x0046552F, 0x006E8059, 0x00394B24, 0x002C3E17, 0x006A7C55, 0x0054663F, 0x00273912, 0x0054663F, 0x005F714A, 0x0032411B, 0x00283711, 0x0032411B, 0x003D4C26, 0x0035441E, 0x0033421C, 0x0042512B, 0x004C5B35, 0x00364725,
        0x00334422, 0x003C4D2B, 0x00384927, 0x002C3D1B, 0x00384927, 0x00415230, 0x002D3E1C, 0x00404F29, 0x004B5A34, 0x003F512A, 0x00364722, 0x003E502B, 0x003A4B29, 0x002A3B19, 0x00243815, 0x0030441A, 0x0050643A, 0x00576940, 0x0075875E, 0x00708259,
        0x0073835A, 0x00708057, 0x0073835A, 0x00738459, 0x00728358, 0x00728358, 0x00718257, 0x00718257, 0x00728358, 0x00728358, 0x00738459, 0x00728259, 0x00728259, 0x00718158, 0x00718158, 0x00718158, 0x00728259, 0x0073835A, 0x0073835A, 0x0073835A,
        0x0073835A, 0x0073835A, 0x0073835A, 0x0073835A, 0x00728259, 0x00718158, 0x00708057, 0x00708259, 0x00708259, 0x00708259, 0x006F8158, 0x006F8158, 0x006F8158, 0x006F8158, 0x006F8158, 0x00708057, 0x00708057, 0x00708057, 0x00708057, 0x00718158,
        0x00718158, 0x00718158, 0x00718158, 0x00728259, 0x00718158, 0x00718158, 0x00708057, 0x00708057, 0x00708057, 0x00708057, 0x00708057, 0x006F7E58, 0x0074845B, 0x00718158, 0x006C7E55, 0x00708358, 0x006E8156, 0x00697E51, 0x006D8255, 0x00434724,
        0x00343C14, 0x002C390D, 0x0036491E, 0x002D4222, 0x00405447, 0x0065777E, 0x005B6C7F, 0x00586C7D, 0x006C8287, 0x006E8577, 0x0051694B, 0x0050653F, 0x00465432, 0x002E341B, 0x004D4D3B, 0x00384235, 0x001D271A, 0x001E281B, 0x001C2619, 0x00212B1E,
        0x001B2518, 0x001B2518, 0x00192316, 0x001D271A, 0x00192316, 0x00202A1D, 0x001F291C, 0x001B2518, 0x002A3427, 0x001A2417, 0x001C2619, 0x001A2418, 0x001C2619, 0x001D2917, 0x00233119, 0x002D3D1E, 0x00495B36, 0x0052663C, 0x00455A2D, 0x00525E40,
        0x00495733, 0x00617247, 0x0076835D, 0x00707B5B, 0x005D6645, 0x00626F41, 0x005B6D32, 0x00566035, 0x004A5527, 0x003D4919, 0x00354111, 0x00323D0F, 0x00384218, 0x004E5532, 0x00646B4A, 0x0065765B, 0x0065765B, 0x0064755A, 0x00637459, 0x0064755A,
        0x005F7055, 0x004F6045, 0x00405136, 0x00344022, 0x00414D2F, 0x00394527, 0x003B4A2B, 0x00556445, 0x00617251, 0x0070815F, 0x006A7B59, 0x006F7E5F, 0x006F7F5D, 0x006F805B, 0x0072805E, 0x00606C50, 0xFFCFD4C5, 0xFFFDFEFC, 0xFFFEFCFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFEFF, 0xFFFFFFFE, 0x00BAC1AC, 0x00586839, 0x0078875B, 0x00838E6E, 0x0066724E, 0x005E7138, 0x0063734A, 0x0064744B, 0x0063734A, 0x005F6F46, 0x005E6E45,
        0x0067774E, 0x00607047, 0x00627249, 0x00708565, 0x004F6247, 0x003D4D3B, 0x0069786A, 0x0049584A, 0x00354631, 0x0033462B, 0x003B502F, 0x00364236, 0x002E3A2E, 0x00354234, 0x00485442, 0x004A5840, 0x00455434, 0x00697C51, 0x00748859, 0x0076895E,
        0x0074865D, 0x0073855C, 0x00708259, 0x00758760, 0x006D7F58, 0x006F805B, 0x00768762, 0x0076855F, 0x00788761, 0x0074835D, 0x005E6D47, 0x0052613B, 0x004F5E38, 0x0054633D, 0x0072815B, 0x0074835D, 0x006F7E58, 0x0075845E, 0x006E7D57, 0x007B8A64,
        0x00677650, 0x00495832, 0x00485731, 0x00424D25, 0x00364119, 0x0065734A, 0x00627047, 0x002C3C13, 0x0047572E, 0x0063754C, 0x003D4F26, 0x002C4016, 0x00283C12, 0x00475B31, 0x00586B44, 0x0051643D, 0x0041532E, 0x005F714C, 0x00485A35, 0x003A4C27,
        0x004C5E39, 0x0051643D, 0x004F6339, 0x00394D23, 0x005A6E43, 0x005B7043, 0x00455A2D, 0x0055673E, 0x0055673E, 0x0042562C, 0x00455831, 0x00566B44, 0x00536842, 0x003A512B, 0x00233A14, 0x002C4016, 0x004D6137, 0x0054683E, 0x0072865C, 0x006A7E54,
        0x0070845A, 0x0072865C, 0x006F8359, 0x0070825B, 0x0071835C, 0x0071835C, 0x0072845D, 0x0072845D, 0x0073855E, 0x0073855E, 0x0073855E, 0x00758458, 0x00748357, 0x00748258, 0x00738157, 0x00738158, 0x00748259, 0x00748259, 0x0074815B, 0x00728259,
        0x00728259, 0x0073835A, 0x0074845B, 0x0074845B, 0x0073835A, 0x00728259, 0x00728259, 0x0074855A, 0x0074855A, 0x00738459, 0x00728358, 0x00728358, 0x00728358, 0x00738459, 0x00738459, 0x006B7D54, 0x006D7F56, 0x006E8057, 0x00708259, 0x0071835A,
        0x00708259, 0x006F8158, 0x006F8158, 0x006E8156, 0x006E8156, 0x006F8257, 0x00708358, 0x00708358, 0x006F8257, 0x006E8156, 0x006D8055, 0x0070825B, 0x0071835C, 0x0070825B, 0x006D7F58, 0x006E8059, 0x006F815A, 0x006D7F58, 0x00687A53, 0x00343E14,
        0x00374325, 0x00314129, 0x003C4C2D, 0x00627351, 0x005C6F5E, 0x006A859A, 0x006281B8, 0x006F8AAC, 0x006D8896, 0x002E4739, 0x00435A34, 0x004C6033, 0x003C4A28, 0x00262F22, 0x00474F4F, 0x00465141, 0x00434E3E, 0x003A4535, 0x00475242, 0x00333E2E,
        0x00354030, 0x00434E3E, 0x00323D2D, 0x00363F2B, 0x00414A36, 0x0038412D, 0x003F4631, 0x003F4631, 0x003F452E, 0x002C321B, 0x00232912, 0x00272916, 0x00282C19, 0x00242A13, 0x002C3219, 0x00343E20, 0x005F6A49, 0x004C5B35, 0x0051603A, 0x00495E3D,
        0x00465C39, 0x005B6E47, 0x006D7E53, 0x006A7749, 0x00657246, 0x005F6F46, 0x00546740, 0x00596338, 0x004F5B37, 0x00465540, 0x00495B54, 0x00879A9D, 0x009CACB3, 0x00A7B1BB, 0x00A7B0B9, 0x00ADBCBE, 0x00ADBCBE, 0x00ADBCBE, 0x00ACBBBD, 0x00AAB9BB,
        0x00A7B6B8, 0x00A4B3B5, 0x00A2B1B3, 0x00A4B2B8, 0x00A1AFB5, 0x00A4B2B8, 0x00A3B1B7, 0x00A8B6BC, 0x00AFBDC3, 0x00ACBAC0, 0x00AEBCC2, 0x00BCC3C6, 0x007F8C7C, 0x006D7F5A, 0x0076885F, 0x00616D4F, 0xFFCFD3C7, 0xFFFFFFFE, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFBFAFC, 0xFFFDFEFC, 0x00BAC1AC, 0x005C6C3D, 0x007B8A5E, 0x007C8767, 0x004E5A36, 0x003A4D14, 0x00314118, 0x00304017, 0x00324219, 0x00314118, 0x0033431A,
        0x002D3D14, 0x002D3D14, 0x0035451C, 0x00667960, 0x0050604E, 0x00616F64, 0x00828D8A, 0x00838E8C, 0x007E8A84, 0x00758377, 0x00778776, 0x006E796F, 0x00869187, 0x00879086, 0x00555F52, 0x003B4832, 0x004A593A, 0x0073855E, 0x0073875A, 0x0071835C,
        0x00788A63, 0x00778962, 0x00798B64, 0x007C8E65, 0x007D8F66, 0x0075875E, 0x0074875C, 0x0074835D, 0x006C7B55, 0x007A8963, 0x00788761, 0x005A6943, 0x004D5C36, 0x00505F39, 0x004F5E38, 0x0073825C, 0x0071805A, 0x007B8A64, 0x00778660, 0x00707F59,
        0x0064734D, 0x00586741, 0x0035441E, 0x002B3B12, 0x0054643B, 0x005C6C43, 0x0033451C, 0x0036481F, 0x005D6F46, 0x0052663C, 0x002B3F15, 0x002B3F15, 0x002E4218, 0x00465932, 0x004F623B, 0x00475934, 0x003B4D28, 0x00586A45, 0x003B4C2A, 0x00283B14,
        0x00485B34, 0x003B4F25, 0x00394D23, 0x0040542A, 0x004B5F35, 0x0032461C, 0x0033471D, 0x00586A41, 0x0045572E, 0x002C3F18, 0x003E512A, 0x005B704A, 0x00556A44, 0x00384F29, 0x00253B18, 0x00364A20, 0x0051653B, 0x0055693F, 0x0074885E, 0x0071855B,
        0x00778B61, 0x0074885E, 0x006D8157, 0x0071835C, 0x0072845D, 0x0072845D, 0x0072845D, 0x0072845D, 0x0072845D, 0x0071835C, 0x0071835C, 0x0075865A, 0x0074855A, 0x0074855A, 0x00738459, 0x00728259, 0x00728259, 0x0072815B, 0x0073825C, 0x00728358,
        0x00728358, 0x00738459, 0x00738459, 0x00738459, 0x00738459, 0x00728358, 0x00728358, 0x00708358, 0x006F8257, 0x006F8257, 0x006F8257, 0x006F8257, 0x00708358, 0x00718459, 0x00718459, 0x00708259, 0x0071835A, 0x0071835A, 0x0071835A, 0x0071835A,
        0x00708259, 0x006F8158, 0x006E8057, 0x00708259, 0x00708259, 0x00708259, 0x00708259, 0x00708259, 0x006F8158, 0x006F8158, 0x006E8057, 0x0070825B, 0x0071835C, 0x0070825B, 0x006E8059, 0x006F815A, 0x0070825B, 0x006D7F58, 0x00687A53, 0x00464C35,
        0x00687265, 0x00717F74, 0x004D5D46, 0x00455837, 0x003F5640, 0x0063818C, 0x007399C3, 0x007192B3, 0x00708F9E, 0x00436051, 0x005A734D, 0x0065794C, 0x00586642, 0x002E3827, 0x00434A45, 0x00455040, 0x00333E2E, 0x00343F2F, 0x00404B3B, 0x00323D2D,
        0x003B4636, 0x00414C3C, 0x003D4838, 0x00414A36, 0x00404935, 0x003D4632, 0x00454C37, 0x003A412C, 0x00353A25, 0x00272D16, 0x00292F18, 0x002C2F1F, 0x00292D1A, 0x0030361F, 0x00232C12, 0x004A5436, 0x0053613F, 0x004B5935, 0x004C5B35, 0x004E6342,
        0x004B603A, 0x005A6A41, 0x00677448, 0x00657042, 0x00606D3F, 0x00606F43, 0x0057683D, 0x005C653A, 0x005D6945, 0x006C7963, 0x0075867D, 0x00B7C6C8, 0x00D4E2E8, 0x00DFE9F0, 0x00E4EDF1, 0x00DAE6E8, 0x00DBE7E9, 0x00DBE7E9, 0x00DDE9EB, 0x00DDE9EB,
        0x00DDE9EB, 0x00DCE8EA, 0x00DBE7E9, 0x00DDE8EC, 0x00D9E4E8, 0x00DDE8EC, 0x00DDE8EC, 0x00DFEAEE, 0x00E2EDF1, 0x00D9E4E8, 0x00D7E2E6, 0x00D9E0E3, 0x008F9C8C, 0x006E805B, 0x0072845B, 0x005F6B4D, 0xFFD0D4C8, 0xFFFFFFFE, 0xFFFFFDFD, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFEFF, 0xFFFEFFFD, 0x00B9C0AB, 0x005B6B3C, 0x007C8B5F, 0x007C8767, 0x004A5632, 0x0032450C, 0x00526239, 0x0055653C, 0x0047572E, 0x0034441B, 0x0056663D,
        0x0048582F, 0x0034441B, 0x003E4E25, 0x00889782, 0x00505D4F, 0x005E6764, 0x00959BA2, 0x00D4D8E3, 0x00DEE2ED, 0x00D0D6DD, 0x00D3D9DE, 0x00DFE8E5, 0x00E2E9E6, 0x00C7CEC9, 0x00717A70, 0x00505A4A, 0x004E5B43, 0x00647250, 0x0064734D, 0x006C795F,
        0x005D6B4F, 0x00485738, 0x00556444, 0x00556641, 0x00586A43, 0x004F6138, 0x005B6E43, 0x0075855C, 0x0077875E, 0x0075855C, 0x0078885F, 0x00718158, 0x005E6E45, 0x0054643B, 0x00516138, 0x00586741, 0x00788761, 0x0073825C, 0x0071805A, 0x007E8D67,
        0x0065744E, 0x00505F39, 0x003F4E28, 0x00374922, 0x0061734C, 0x00455831, 0x0023360F, 0x004E633C, 0x005B7049, 0x002E461E, 0x00233B13, 0x002F4319, 0x002C3F18, 0x00384B24, 0x004B5E37, 0x0052643F, 0x00475934, 0x00576846, 0x00314220, 0x002C4015,
        0x0043572C, 0x004C6036, 0x0051643D, 0x00465932, 0x00566843, 0x00516240, 0x004B5C3A, 0x005A6C43, 0x00465831, 0x002E411A, 0x003E512A, 0x00576C46, 0x004F643E, 0x00384E2B, 0x00283E1B, 0x002A3D16, 0x004A5D36, 0x00576A43, 0x0073865F, 0x006D8059,
        0x0071845D, 0x0073865F, 0x00748760, 0x0071835C, 0x0071835C, 0x0072845D, 0x0072845D, 0x0071835C, 0x0070825B, 0x006F815A, 0x006E8059, 0x0075865B, 0x0074855A, 0x00738459, 0x00728259, 0x00728259, 0x0071805A, 0x0071805A, 0x0072815B, 0x006E8255,
        0x006E8255, 0x006F8356, 0x006F8356, 0x006F8356, 0x006F8356, 0x006E8255, 0x006E8255, 0x006E8156, 0x006E8156, 0x006E8156, 0x006E8156, 0x006F8257, 0x00708358, 0x00718459, 0x00718459, 0x0072845B, 0x0072845B, 0x0071835A, 0x0071835A, 0x00708259,
        0x006F8158, 0x006F8158, 0x006E8057, 0x0072845B, 0x0072845B, 0x0071835A, 0x00708259, 0x00708259, 0x00708259, 0x00708259, 0x00708259, 0x0070825B, 0x0070825B, 0x006F815A, 0x006E8059, 0x0070825B, 0x0072845D, 0x006E8059, 0x00687A53, 0x003C403B,
        0x00939A9D, 0x00AEBABE, 0x005B6C5F, 0x003C4E31, 0x004B644A, 0x00729696, 0x00749FBA, 0x007298BA, 0x00779BAB, 0x00527365, 0x00647E5A, 0x00667B4E, 0x00586741, 0x002E3821, 0x00444D40, 0x00353F2F, 0x00273121, 0x002D3727, 0x002C3626, 0x00283222,
        0x00333D2D, 0x002B3525, 0x00353F2F, 0x00353D2C, 0x00333B2A, 0x00363F2B, 0x00414734, 0x00363D28, 0x00373C27, 0x002C311C, 0x002B311A, 0x00252818, 0x002B2F1C, 0x00222914, 0x002C351B, 0x00343E20, 0x0052603E, 0x0045532F, 0x0055643E, 0x004A5F3E,
        0x004D5F38, 0x005D673C, 0x005C6637, 0x00535E30, 0x004E5B2F, 0x00556236, 0x00566035, 0x004C562B, 0x004E5938, 0x006A7660, 0x00717C72, 0x00B3BDBD, 0x00D7E0E3, 0x00D8E0E0, 0x00D4DCDC, 0x00DDE4E7, 0x00DCE3E6, 0x00DAE1E4, 0x00DAE1E4, 0x00DBE2E5,
        0x00DAE1E4, 0x00D8DFE2, 0x00D6DDE0, 0x00D9E1E1, 0x00D9E1E1, 0x00DFE7E7, 0x00DCE4E4, 0x00D9E1E1, 0x00DAE2E2, 0x00D8E0E0, 0x00DEE6E6, 0x00E4EBEE, 0x0094A191, 0x006E805B, 0x00708259, 0x005F6B4D, 0xFFD3D7CB, 0xFFFFFFFE, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFEFF, 0xFFFFFFFE, 0x00B9C0AB, 0x005A6A3B, 0x007B8A5E, 0x007E8969, 0x00515D39, 0x003D5017, 0x0068784F, 0x005E6E45, 0x00607047, 0x003B4B22, 0x00617148,
        0x0065754C, 0x0048582F, 0x00405027, 0x007C8E71, 0x0051604B, 0x00515C54, 0x009FA5AA, 0x00DBDEEC, 0x00CFD2E1, 0x00C1C4D2, 0x00C8CCD7, 0x00CACFD0, 0x00DADFE0, 0x00C9CFCE, 0x00636964, 0x00474F44, 0x00434C38, 0x00445034, 0x003F4D2B, 0x006E736A,
        0x005B6057, 0x00363D30, 0x003E4635, 0x0039432C, 0x00475337, 0x003C4929, 0x00475533, 0x006E7E55, 0x0078885F, 0x006B7B52, 0x00708057, 0x007D8D64, 0x006F7F56, 0x005D6D44, 0x00526239, 0x00586741, 0x005E6D47, 0x006D7C56, 0x007F8E68, 0x00788761,
        0x005E6D47, 0x004F5E38, 0x003C4B25, 0x00445932, 0x00485D36, 0x002D421B, 0x002C441C, 0x00506840, 0x00415931, 0x001B350D, 0x0028421A, 0x00293C15, 0x002B3E17, 0x003A4D26, 0x0052643F, 0x00536540, 0x0040512F, 0x00586947, 0x004E5F3D, 0x00384C21,
        0x003F5328, 0x0055693F, 0x00566942, 0x0032441F, 0x004D5E3D, 0x005E6F4E, 0x00455536, 0x0051633C, 0x0054663F, 0x00455831, 0x003F512C, 0x00425731, 0x003E522F, 0x00334926, 0x00253B18, 0x002D4019, 0x004C5F38, 0x005E714A, 0x00748760, 0x006C7F58,
        0x006B7E57, 0x006F825B, 0x0073865F, 0x006F815A, 0x0070825B, 0x0071835C, 0x0071835C, 0x0071835C, 0x0070825B, 0x006F815A, 0x006E8059, 0x00718459, 0x00718459, 0x00708259, 0x006F8158, 0x006F815A, 0x006F815A, 0x006F815A, 0x006F805B, 0x006D8255,
        0x006E8356, 0x006E8356, 0x006E8356, 0x006E8356, 0x006E8356, 0x006E8356, 0x006D8255, 0x006F8158, 0x006F8158, 0x006F8158, 0x006F8158, 0x00708259, 0x00708259, 0x0071835A, 0x0072845B, 0x006F8158, 0x006F8158, 0x006F8158, 0x006F8158, 0x006F8158,
        0x006F8158, 0x00708259, 0x00708259, 0x0073855C, 0x0072845B, 0x0071835A, 0x00708259, 0x00708259, 0x00708259, 0x00708259, 0x0071835A, 0x0070825B, 0x0070825B, 0x006F815A, 0x006F815A, 0x0071835C, 0x0073855E, 0x006F815A, 0x00687A53, 0x00393E3C,
        0x00616C70, 0x0069767E, 0x0045544C, 0x004B5E43, 0x00556E54, 0x00769897, 0x00759FB6, 0x006B97B6, 0x00749BA9, 0x0046685D, 0x005B7654, 0x0062774A, 0x004F5F36, 0x002E3A1C, 0x004D5642, 0x003C4636, 0x003D4737, 0x00424C3C, 0x00353F2F, 0x00384232,
        0x00404A3A, 0x00313B2B, 0x003D4737, 0x00293120, 0x00363E2D, 0x00313928, 0x003C422F, 0x003B412E, 0x00424732, 0x00393E29, 0x00252A15, 0x002E3121, 0x00212716, 0x002E3520, 0x00262F15, 0x003C482C, 0x004C5939, 0x00586944, 0x00546540, 0x004A5D3C,
        0x0056643B, 0x0063693A, 0x00505829, 0x003D491F, 0x0030411C, 0x003C4B25, 0x00434F25, 0x00435128, 0x00424D2D, 0x0067705C, 0x0071796F, 0x00B5BBBA, 0x00D8DEDD, 0x00BCC3C0, 0x00A4ABA6, 0x009CA0A1, 0x00989C9D, 0x00949899, 0x00929697, 0x00929697,
        0x00919596, 0x008E9293, 0x008B8F90, 0x009BA09E, 0x009FA4A2, 0x00A8ADAB, 0x00A1A6A4, 0x00979C9A, 0x009DA2A0, 0x00ADB2B0, 0x00C5CAC8, 0x00DCE3E6, 0x008F9C8C, 0x006D7F5A, 0x0073855C, 0x00616D4F, 0xFFD2D6CA, 0xFFFFFFFE, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFCFBFD, 0xFFFEFFFD, 0x00BBC2AD, 0x005C6C3D, 0x007A895D, 0x007B8666, 0x004D5935, 0x003A4D14, 0x00596940, 0x00394920, 0x00607047, 0x00425229, 0x004B5B32,
        0x005C6C43, 0x0047572E, 0x00304017, 0x00687B54, 0x00677758, 0x005B6755, 0x00AFB6B3, 0x00DADEE3, 0x00C6C9D1, 0x00BEC2C7, 0x00B8BCC1, 0x00CACFD2, 0x00D2D7DA, 0x00CED2D3, 0x00818684, 0x0081867D, 0x00666E5D, 0x005C654B, 0x00677252, 0x00919296,
        0x00848687, 0x00545656, 0x004F534D, 0x005C6257, 0x00818879, 0x005D6652, 0x0037402B, 0x0074845B, 0x0073835A, 0x00728259, 0x0076865D, 0x006F7F56, 0x00718158, 0x0075855C, 0x00596940, 0x00596842, 0x004B5A34, 0x005E6D47, 0x0076855F, 0x00778660,
        0x006A7953, 0x004F5E38, 0x0042512B, 0x002A3F19, 0x00283D17, 0x0020350F, 0x00233A14, 0x002E451F, 0x00283F19, 0x001E3711, 0x00223B15, 0x002A3D16, 0x00283A15, 0x00293B16, 0x0032441F, 0x002F401E, 0x0020310F, 0x00344524, 0x00364726, 0x002B3E17,
        0x0032451E, 0x0032441F, 0x002E401B, 0x00253614, 0x00334423, 0x00334423, 0x00273718, 0x0030421B, 0x0041522D, 0x003B4D28, 0x0030421D, 0x002B3F1C, 0x002D411E, 0x002D4221, 0x00243918, 0x003A4C27, 0x004B5D38, 0x00596B46, 0x006E805B, 0x006F815C,
        0x0070825D, 0x006D7F5A, 0x006D7F5A, 0x006F815A, 0x0070825B, 0x0070825B, 0x0070825B, 0x0070825B, 0x0070825B, 0x006F815A, 0x006E8059, 0x006E8258, 0x006E8258, 0x006D8157, 0x006D8059, 0x006D8059, 0x006D7F5A, 0x006E805B, 0x006F815C, 0x006C8357,
        0x006C8357, 0x006C8357, 0x006C8357, 0x006C8357, 0x006C8357, 0x006C8357, 0x006C8357, 0x006E8258, 0x006E8258, 0x006E8258, 0x006D8157, 0x006E8258, 0x006E8258, 0x006F8359, 0x006F8359, 0x006D7F56, 0x006D7F56, 0x006D7F56, 0x006D7F56, 0x006E8057,
        0x006F8158, 0x00708259, 0x00708259, 0x0072845D, 0x0071835C, 0x0070825B, 0x006F815A, 0x006F815A, 0x006F815A, 0x0070825B, 0x0070825B, 0x006F815A, 0x0070825B, 0x006F815A, 0x006F815A, 0x0070825B, 0x0072845D, 0x006F815A, 0x006A7C55, 0x00434F3B,
        0x006E7D75, 0x00778584, 0x005C6A5F, 0x004B5941, 0x00314630, 0x00658286, 0x0081A6C2, 0x007099B0, 0x007398A0, 0x00385649, 0x005B7452, 0x006D8055, 0x00546239, 0x00313D1F, 0x004B543F, 0x003D4737, 0x00313B2B, 0x00364030, 0x00323C2C, 0x00313B2B,
        0x00353F2F, 0x00323C2C, 0x00323C2C, 0x00282F20, 0x003E4536, 0x00303827, 0x003A402F, 0x003B412E, 0x003F4330, 0x00393E29, 0x00232813, 0x0024291A, 0x001E2413, 0x00222815, 0x001C260F, 0x003A462A, 0x00485737, 0x004C5C3A, 0x0041522D, 0x00596B4C,
        0x00667046, 0x00666A39, 0x00454C21, 0x00314324, 0x00243D29, 0x00304830, 0x0035492C, 0x00324321, 0x002A371D, 0x00566050, 0x006A706B, 0x00B3B8B7, 0x00D6DCDB, 0x00B2B9B4, 0x008E9991, 0x00989C9D, 0x0095999A, 0x00929697, 0x00929697, 0x0095999A,
        0x0095999A, 0x00939798, 0x00919596, 0x00939896, 0x00959A98, 0x009CA19F, 0x00929795, 0x00898E8C, 0x00939896, 0x00AFB4B2, 0x00D1D6D4, 0x00DBE2E5, 0x008E9B8B, 0x006E805B, 0x0075875E, 0x00647052, 0xFFD2D6CA, 0xFFFEFFFD, 0xFFFFFEFE, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFBFAFC, 0xFFFDFEFC, 0x00BBC2AD, 0x005C6C3D, 0x007A895D, 0x007A8565, 0x004E5A36, 0x003B4E15, 0x005F6F46, 0x00495930, 0x005E6E45, 0x004B5B32, 0x005F6F46,
        0x005C6C43, 0x0035451C, 0x00304017, 0x0063774C, 0x005D6E4C, 0x0053604A, 0x00A3ACA2, 0x00DCE2E1, 0x00CDD2D3, 0x00C8CECD, 0x00BDC4C1, 0x00CCCFD3, 0x00CDD0D4, 0x00D3D7D8, 0x00A8ABA9, 0x00B9BEB5, 0x00787E6B, 0x00535C41, 0x00636E4E, 0x00939492,
        0x008C8D89, 0x00686A64, 0x0062655C, 0x0073776B, 0x00959A8B, 0x007D8372, 0x005D6350, 0x00697A4F, 0x0075865B, 0x00798A5F, 0x0074855A, 0x006D7E53, 0x00728358, 0x00798A5F, 0x00728358, 0x00596842, 0x0053623C, 0x00505F39, 0x005A6943, 0x0074835D,
        0x007B8A64, 0x00576640, 0x0054633D, 0x004D5E39, 0x00576843, 0x00556742, 0x0052643F, 0x004E633D, 0x004F643E, 0x00536A44, 0x00526943, 0x005B6D48, 0x00556742, 0x004E603B, 0x00475836, 0x004D5E3C, 0x004D5E3D, 0x00455635, 0x00364726, 0x0039492A,
        0x0039492A, 0x003A4A2B, 0x00485938, 0x004E5F3D, 0x004B5C3A, 0x00465735, 0x004D5F3A, 0x0051623D, 0x00566742, 0x0050623D, 0x00526341, 0x00526643, 0x004F6241, 0x004F6443, 0x004A5F3E, 0x00495B36, 0x00546641, 0x0061734E, 0x006F815C, 0x006F815C,
        0x006E805B, 0x006B7D58, 0x006C7E59, 0x006E8059, 0x006D7F58, 0x006B7D56, 0x006A7C55, 0x00687A53, 0x00667851, 0x00657750, 0x0064764F, 0x0061774D, 0x0061774D, 0x0060754E, 0x0060754E, 0x0060754F, 0x0060754F, 0x00617650, 0x00617552, 0x005F774F,
        0x005F774F, 0x005E764E, 0x005E764E, 0x005E764E, 0x005E764E, 0x005F774F, 0x005F774F, 0x0061754B, 0x0060744A, 0x0060744A, 0x0060744A, 0x0061754B, 0x0062764C, 0x0063774D, 0x0064784E, 0x0065774E, 0x0066784F, 0x00677950, 0x00697B52, 0x006A7C53,
        0x006B7D54, 0x006C7E55, 0x006C7E55, 0x006E8059, 0x006E8059, 0x006E8059, 0x006E8059, 0x006E8059, 0x006E8059, 0x006E8059, 0x006F815A, 0x006F815A, 0x0070825B, 0x0070825B, 0x006E8059, 0x006E8059, 0x0070825B, 0x006F815A, 0x006C7E57, 0x005D6F48,
        0x0099A991, 0x00A6B7AA, 0x007E8A78, 0x005A664A, 0x003D4D35, 0x00708888, 0x008BABC2, 0x007E9FAE, 0x00789697, 0x00445B4C, 0x00647756, 0x0064744B, 0x0046522E, 0x00283418, 0x00424D39, 0x003A4132, 0x00171E0F, 0x001D2415, 0x0022291A, 0x001D2415,
        0x001F2617, 0x0022291A, 0x001C2314, 0x00171E0F, 0x0022291A, 0x001F2617, 0x00292F1E, 0x00262C1B, 0x002E321F, 0x002C301D, 0x00272B18, 0x0024291A, 0x00333A2B, 0x001F2814, 0x002E3821, 0x002F3D21, 0x00526142, 0x00485937, 0x005A6B49, 0x0065785D,
        0x006A734B, 0x005F6231, 0x003A451F, 0x00375445, 0x00345C5B, 0x003E6563, 0x003E6056, 0x002F452C, 0x00283826, 0x005F6A60, 0x00808584, 0x00C5C8CC, 0x00DEE3E4, 0x00B4BFBC, 0x008E9D95, 0x00949A99, 0x00929897, 0x00929897, 0x00939998, 0x00959B9A,
        0x00979D9C, 0x00959B9A, 0x00949A99, 0x00979E9B, 0x00939A97, 0x00959C99, 0x008D9491, 0x00888F8C, 0x00949B98, 0x00ADB4B1, 0x00CDD4D1, 0x00E1E8EB, 0x008E9B8B, 0x006A7C57, 0x0074865D, 0x00667254, 0xFFD5D9CD, 0xFFFFFFFE, 0xFFFFFEFE, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFEFF, 0xFFFFFFFE, 0x00B9C0AB, 0x005A6A3B, 0x007A895D, 0x007D8868, 0x00515D39, 0x003D5017, 0x0066764D, 0x0068784F, 0x0055653C, 0x004E5E35, 0x006E7E55,
        0x005F6F46, 0x0037471E, 0x003D4D24, 0x00687757, 0x005A674D, 0x00868F82, 0x00A4A9A7, 0x00E1E5E6, 0x00C9CCD0, 0x00C1C6C5, 0x00C0C5C3, 0x00BEC2C3, 0x00DCE0E1, 0x00D0D2D2, 0x0070746F, 0x0084887D, 0x00616853, 0x00576143, 0x00616C4B, 0x00525B41,
        0x005B644A, 0x00596248, 0x00565F44, 0x00535C41, 0x00576045, 0x005F694B, 0x006D7759, 0x00495A2F, 0x0064754A, 0x00718257, 0x00718257, 0x0078895E, 0x00728358, 0x0068794E, 0x0075865B, 0x0074835D, 0x005B6A44, 0x0056653F, 0x005C6B45, 0x0056653F,
        0x00707F59, 0x0072815B, 0x005A6943, 0x00515F3D, 0x00576543, 0x0053613F, 0x0051613F, 0x004F5F3D, 0x004B5B39, 0x004F603E, 0x004F603E, 0x00455732, 0x004C5E39, 0x00556644, 0x00495A38, 0x004B5C3B, 0x004B5C3B, 0x002E3F1E, 0x00223213, 0x001F2B17,
        0x0014210B, 0x00253419, 0x00455536, 0x004B5C3A, 0x00485A35, 0x004C6036, 0x00506439, 0x004E5F3A, 0x004D5E39, 0x004A5B39, 0x00536442, 0x00526544, 0x004B5E3D, 0x004B603F, 0x004B6040, 0x00516240, 0x00586947, 0x00647553, 0x006C7D5B, 0x006A7B59,
        0x00667755, 0x00647553, 0x00697A58, 0x00677952, 0x0064764F, 0x0060724B, 0x005A6C45, 0x00556740, 0x0050623B, 0x004E6039, 0x004D5F38, 0x00465E34, 0x00455D35, 0x00445C34, 0x00435B33, 0x00425933, 0x00415832, 0x00415734, 0x00415734, 0x003E5634,
        0x003E5634, 0x003D5533, 0x003C5432, 0x003C5432, 0x003D5533, 0x003E5634, 0x003E5634, 0x0041562F, 0x0041562F, 0x00425730, 0x00435831, 0x00455A33, 0x00475C35, 0x00485D36, 0x00495E37, 0x0052643B, 0x0054663D, 0x00586A41, 0x005C6E45, 0x00607249,
        0x0064764D, 0x0066784F, 0x00677950, 0x006A7B56, 0x006A7B56, 0x006B7C57, 0x006C7D58, 0x006D7E59, 0x006D7E59, 0x006D7E59, 0x006D7E59, 0x006E8059, 0x0070825B, 0x0070825B, 0x006D7F58, 0x006C7E57, 0x006E8059, 0x006F815A, 0x006E8059, 0x00455526,
        0x003B4B2C, 0x00404E3C, 0x00444E37, 0x00656D48, 0x005B6945, 0x005F7668, 0x0066858E, 0x00789195, 0x00667C77, 0x0051624D, 0x00687555, 0x00505B35, 0x00404B2B, 0x002A371F, 0x00475444, 0x003E4536, 0x002E3526, 0x00394031, 0x00282F20, 0x00333A2B,
        0x00383F30, 0x00282F20, 0x00343B2C, 0x002E3526, 0x0022291A, 0x003A4132, 0x00393E2F, 0x002C3221, 0x00494C3C, 0x003E422F, 0x003C402D, 0x00363D30, 0x00303728, 0x002E3625, 0x00303C26, 0x00354228, 0x00435334, 0x005C6D4C, 0x006D7E5C, 0x0065785F,
        0x00677048, 0x005A5D30, 0x00364529, 0x00446A6A, 0x00467E91, 0x004F8498, 0x00477882, 0x00334F3C, 0x002D4337, 0x006C7977, 0x009CA0A5, 0x00D9DCE4, 0x00DEE4E9, 0x00ACBAB8, 0x0080928B, 0x008D9594, 0x008D9594, 0x008E9695, 0x008F9796, 0x008F9796,
        0x008F9796, 0x008E9695, 0x008D9594, 0x00929A9A, 0x008D9595, 0x008D9595, 0x00878F8F, 0x00838B8B, 0x008F9797, 0x00A9B1B1, 0x00C8D0D0, 0x00DEE5E8, 0x008D9A8A, 0x006A7C57, 0x0074865D, 0x00647052, 0xFFD3D7CB, 0xFFFFFFFE, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFEFF, 0xFFFFFFFE, 0x00B7BEA9, 0x0059693A, 0x007B8A5E, 0x007C8767, 0x00495531, 0x0030430A, 0x0036461D, 0x003C4C23, 0x00293910, 0x0033431A, 0x0035451C,
        0x0036461D, 0x003D4D24, 0x002D3D14, 0x0069755F, 0x005F6959, 0x00BEC4BF, 0x009FA2A6, 0x00E8EAF2, 0x00E3E5ED, 0x00D8DBDF, 0x00D3D8D7, 0x00DCE1E0, 0x00F0F5F4, 0x00CED1CF, 0x00686C66, 0x008C9084, 0x00757D66, 0x00707B5B, 0x0076805C, 0x006D7D4E,
        0x006F7F50, 0x00707F53, 0x006D7C50, 0x00738157, 0x0068764C, 0x005B693F, 0x00505E35, 0x00536439, 0x00516237, 0x006B7C51, 0x0077885D, 0x00728358, 0x00728358, 0x00708156, 0x00738459, 0x0074835D, 0x0071805A, 0x0055643E, 0x0054633D, 0x0054633D,
        0x0064734D, 0x0076855F, 0x007A8963, 0x00798261, 0x007A8362, 0x00737E5D, 0x00778261, 0x00768462, 0x00748260, 0x00768664, 0x006E7E5C, 0x0072845F, 0x006B7C5A, 0x0070815F, 0x00657654, 0x00687958, 0x005F704F, 0x002D3D1E, 0x00203011, 0x001A2417,
        0x0015210F, 0x00212E18, 0x00455438, 0x00667755, 0x006E8258, 0x006B8053, 0x006C8252, 0x006B7C57, 0x006E7E5C, 0x00687957, 0x00617250, 0x004A5D3C, 0x00344726, 0x00304525, 0x002F4424, 0x00364725, 0x00354624, 0x003F502E, 0x004E5F3D, 0x005C6D4B,
        0x00627351, 0x00617250, 0x00627351, 0x0060724B, 0x005B6D46, 0x0054663F, 0x004B5D36, 0x0043552E, 0x003D4F28, 0x00394B24, 0x00374922, 0x002E461E, 0x002C441C, 0x002B431B, 0x00283F19, 0x00263D17, 0x00253B18, 0x00243A17, 0x00243A17, 0x00203717,
        0x00203717, 0x001F3616, 0x001E3515, 0x001E3515, 0x001F3616, 0x00203717, 0x00203717, 0x00263B14, 0x00273C15, 0x00283D16, 0x002A3F18, 0x002D421B, 0x0030451E, 0x00334821, 0x00344922, 0x003E5027, 0x0041532A, 0x00485A31, 0x00506239, 0x00576940,
        0x005D6F46, 0x0061734A, 0x0063754C, 0x00677853, 0x00687954, 0x006A7B56, 0x006B7C57, 0x006C7D58, 0x006C7D58, 0x006C7D58, 0x006C7D58, 0x006D7F58, 0x0070825B, 0x0070825B, 0x006C7E57, 0x006A7C55, 0x006C7E57, 0x006F815A, 0x0070825B, 0x004E5B2D,
        0x004C5939, 0x00646F5B, 0x004E573C, 0x005C653A, 0x004B582A, 0x00243B1F, 0x00163730, 0x005D6F6E, 0x00405045, 0x004D5A42, 0x00697251, 0x004E5532, 0x00586244, 0x00434F3B, 0x0059685A, 0x00232A1B, 0x0042493A, 0x00515849, 0x00212819, 0x00454C3D,
        0x00515849, 0x00272E1F, 0x004C5344, 0x00434A3D, 0x00252C1D, 0x00505748, 0x003B4031, 0x00232918, 0x00555848, 0x00363A27, 0x00272B18, 0x005B6255, 0x003A4132, 0x002B3322, 0x0057634D, 0x00354228, 0x005D6D4E, 0x006A7B5A, 0x006C7D5B, 0x0062745D,
        0x00676F4A, 0x005B5F35, 0x00394C33, 0x0049777F, 0x004888A7, 0x004B8AAC, 0x00417A90, 0x00426152, 0x00304840, 0x00647173, 0x0091969F, 0x00CDD1DC, 0x00D1D9E0, 0x00AABAB9, 0x00819890, 0x0085908E, 0x00879290, 0x00899492, 0x008B9694, 0x008B9694,
        0x008B9694, 0x008A9593, 0x008A9593, 0x00899295, 0x00858E91, 0x00889194, 0x00818A8D, 0x007C8588, 0x00899295, 0x00A7B0B3, 0x00CCD5D8, 0x00D9E0E3, 0x008E9B8B, 0x0070825D, 0x00778960, 0x00606C4E, 0xFFCACEC2, 0xFFFAFBF9, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFCF5FF, 0xFFFFFFF8, 0x00BEC6A7, 0x0058673B, 0x00808E64, 0x0071805A, 0x00596940, 0x00425327, 0x003E5027, 0x003F5128, 0x00405229, 0x0042542B, 0x0041532A,
        0x003F5128, 0x0042542B, 0x0041532A, 0x00667157, 0x00656F58, 0x007B856E, 0x00929B86, 0x00A6AF9A, 0x00969F8A, 0x0099A38C, 0x00ADB7A0, 0x00A1A893, 0x009DA58E, 0x0097A085, 0x00667151, 0x005D6945, 0x0066744B, 0x00738256, 0x0078875B, 0x00768958,
        0x00728455, 0x00738556, 0x00738459, 0x00708057, 0x0073825C, 0x00707E5A, 0x0064724E, 0x00495930, 0x00526239, 0x004E5E35, 0x006B7B52, 0x0074845B, 0x0076865D, 0x0076865D, 0x00728259, 0x00718257, 0x00728358, 0x0074855A, 0x00596940, 0x00596940,
        0x00506037, 0x005F6E48, 0x00778660, 0x0071835C, 0x006F815A, 0x006E8059, 0x006E8059, 0x0070825B, 0x0071835C, 0x0072845D, 0x0071835C, 0x00737F5B, 0x00707F59, 0x00697B52, 0x00677B51, 0x00657851, 0x00566442, 0x00272F11, 0x0024280F, 0x001A200F,
        0x00262D18, 0x002D361B, 0x00374424, 0x00687652, 0x00697A55, 0x006A7A58, 0x006D7D5B, 0x00778058, 0x00596241, 0x00525F47, 0x004F5E50, 0x0044564F, 0x00354B49, 0x00233D3D, 0x00264242, 0x00173E4D, 0x000F2E37, 0x00213633, 0x00293725, 0x003B4527,
        0x003E4C28, 0x004C5F38, 0x005F774F, 0x00577149, 0x0053693F, 0x004C5D31, 0x00495525, 0x0043501C, 0x00394D18, 0x00314B15, 0x002B4914, 0x00273D20, 0x0021371B, 0x001B2F18, 0x00182B18, 0x0018291B, 0x0018281D, 0x0015241C, 0x0013211B, 0x001A1E19,
        0x001A1E19, 0x00191D18, 0x00191D18, 0x001A1E19, 0x001B1F1A, 0x001C201B, 0x001D211C, 0x001B2B1A, 0x001A2A18, 0x00192D16, 0x001D3317, 0x001E3715, 0x001F3A13, 0x00254116, 0x002B4A1D, 0x00384B12, 0x003A4D14, 0x003D5017, 0x00465922, 0x00536431,
        0x005F6D43, 0x00636F4B, 0x00636D4F, 0x00667752, 0x00687954, 0x00697A55, 0x006A7B56, 0x006A7B56, 0x006B7C57, 0x006D7E59, 0x006F805B, 0x006E8059, 0x006E8059, 0x006E8059, 0x006E8059, 0x006E8059, 0x006D7F58, 0x006D7F58, 0x006D7F58, 0x006E7F5A,
        0x006E7E5C, 0x00829270, 0x007D8D6B, 0x00697858, 0x003A4929, 0x00253415, 0x00334223, 0x003E4B31, 0x00384727, 0x00485A33, 0x005E7146, 0x004F603B, 0x00465339, 0x004A5346, 0x00888E89, 0x00192D1A, 0x00506451, 0x00687C69, 0x001B2F1C, 0x005C705D,
        0x00627663, 0x00172B18, 0x00627663, 0x005E6D58, 0x0023311F, 0x00768472, 0x00505E4C, 0x001C2919, 0x00818E7E, 0x00455244, 0x00233022, 0x00818C7C, 0x00374331, 0x00313E28, 0x0078876C, 0x004A5A3B, 0x006C7D5B, 0x00677954, 0x006B7E57, 0x00718260,
        0x005D6B47, 0x003B4C2B, 0x00304B3B, 0x00557F84, 0x00558A9F, 0x004B839C, 0x0052869D, 0x003E6C74, 0x00273F33, 0x00505945, 0x00727D7A, 0x009AA8AE, 0x00DDE5E5, 0x00B9C0BD, 0x00849094, 0x008A9390, 0x0087908D, 0x00848D8A, 0x00868F8C, 0x008A9390,
        0x008D9693, 0x008C9592, 0x008A9390, 0x0087988F, 0x0086978E, 0x00879790, 0x007F8D87, 0x00778581, 0x00879290, 0x00AAB5B3, 0x00CAD5D3, 0x00DEE4DF, 0x00848E7E, 0x00667556, 0x0075855C, 0x0062714B, 0xFFC5CDB6, 0xFFFDFEFA, 0xFFFEFAFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFAFF, 0xFFFFFFF9, 0x00B9C1A2, 0x00536236, 0x007D8B61, 0x00788761, 0x0077875E, 0x0076875B, 0x00778960, 0x00798B62, 0x00788A61, 0x0076885F, 0x0075875E,
        0x0076885F, 0x0075875E, 0x00708259, 0x00798763, 0x0073815F, 0x00717F5D, 0x006C7959, 0x0073815F, 0x006B7955, 0x006F7E58, 0x007A8A61, 0x00717A5F, 0x00677153, 0x00707B5B, 0x00687450, 0x006A7751, 0x006A784E, 0x00718054, 0x007B8A5E, 0x00738655,
        0x00738655, 0x00768859, 0x0076875B, 0x00728358, 0x0077875E, 0x00798960, 0x0074835D, 0x00617148, 0x004E5E35, 0x005A6A41, 0x0048582F, 0x006E7E55, 0x0077875E, 0x006F7F56, 0x0073835A, 0x0074855A, 0x00738459, 0x00798A5F, 0x0068784F, 0x0056663D,
        0x00506037, 0x005F6E48, 0x0076855F, 0x0072845D, 0x0070825B, 0x006F815A, 0x006F815A, 0x0070825B, 0x0071835C, 0x0071835C, 0x0071835C, 0x0076825E, 0x0072815B, 0x006B7D54, 0x006A7E54, 0x00657851, 0x00586644, 0x00384022, 0x00454930, 0x003D4332,
        0x00313823, 0x001F280D, 0x004A5737, 0x00697753, 0x0062734E, 0x00667654, 0x00687856, 0x006A7C53, 0x00556644, 0x003B4E39, 0x004E635B, 0x006F878D, 0x007D97A7, 0x007E9EB1, 0x007799B0, 0x006B90AC, 0x00638297, 0x0060757D, 0x003D4943, 0x00293120,
        0x00232E14, 0x00394829, 0x00526445, 0x00485D3C, 0x00455634, 0x003D4B29, 0x0038421E, 0x00343E1A, 0x002F3D19, 0x002C3D1B, 0x00283E1B, 0x0020331A, 0x001C2E17, 0x00172813, 0x00152514, 0x00162418, 0x0016231B, 0x0014201A, 0x00111C19, 0x00191C1A,
        0x00191C1A, 0x00181B19, 0x00181B19, 0x00181B19, 0x00191C1A, 0x001A1D1B, 0x001B1E1C, 0x00171E1B, 0x00141E18, 0x00162117, 0x001A2719, 0x00192A15, 0x001A2D14, 0x001D3316, 0x0023391C, 0x0037461A, 0x00384818, 0x003D4F1A, 0x00455821, 0x004D5F2A,
        0x00556536, 0x005C6943, 0x00616C4C, 0x0063744F, 0x00657651, 0x00677853, 0x00677853, 0x00687954, 0x00697A55, 0x006B7C57, 0x006D7E59, 0x006E8059, 0x006E8059, 0x006E8059, 0x006E8059, 0x006E8059, 0x006E8059, 0x006D7F58, 0x006D7F58, 0x006F815A,
        0x006B7D56, 0x00768762, 0x0070815C, 0x006B7B59, 0x00536341, 0x004C5C3A, 0x005B6A4A, 0x00627152, 0x004F5F3D, 0x00596B42, 0x0063764B, 0x004E6039, 0x004E5C40, 0x00717B6A, 0x00B0B8AE, 0x002D3621, 0x0077806B, 0x008D9681, 0x0019220D, 0x00606954,
        0x005E6752, 0x00222B16, 0x00707964, 0x005D6A54, 0x001F2C16, 0x0087947E, 0x0047533F, 0x00313D29, 0x00ABB7A5, 0x00505C4A, 0x00313D2B, 0x007E8A78, 0x002B3723, 0x0054614B, 0x00B6C5AA, 0x00506041, 0x006A7B59, 0x006F815C, 0x006B7E57, 0x005D6E4C,
        0x004C5A36, 0x00394A29, 0x003A5545, 0x005C868B, 0x005E93A8, 0x00558DA6, 0x005589A0, 0x00416F77, 0x00273F33, 0x004F5844, 0x00717C79, 0x0098A6AC, 0x00DDE5E5, 0x00BBC2BF, 0x00859195, 0x00879191, 0x00889292, 0x00889292, 0x00899393, 0x008A9494,
        0x008B9595, 0x008B9595, 0x008C9696, 0x00859490, 0x0081908C, 0x00808F8B, 0x007D8A88, 0x00788583, 0x00869090, 0x00ABB5B5, 0x00CED8D8, 0x00E0E7E0, 0x008F9988, 0x006F7E5E, 0x0075855C, 0x005E6C48, 0xFFC3CAB5, 0xFFFFFFFC, 0xFFFFFCFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFF9FF, 0xFFFFFFF7, 0x00BAC2A3, 0x0057663A, 0x007B895F, 0x0073825C, 0x00728259, 0x0078895D, 0x006C7E55, 0x00708259, 0x0071835A, 0x006F8158, 0x0072845B,
        0x00778960, 0x0076885F, 0x0073855C, 0x0078895D, 0x00798A5F, 0x0076865D, 0x00718158, 0x007C8D62, 0x007E9061, 0x00809360, 0x007D925B, 0x0084906C, 0x007B8862, 0x007F8C66, 0x007E8C63, 0x007A885E, 0x007B895F, 0x007A895D, 0x00768559, 0x00768958,
        0x00758857, 0x00758758, 0x00728455, 0x006E7F53, 0x006F8055, 0x00728358, 0x006F8055, 0x0076865D, 0x005E6E45, 0x004B5B32, 0x00596940, 0x0046562D, 0x006E7E55, 0x007E8E65, 0x006F7F56, 0x0074855A, 0x00728358, 0x007A8B60, 0x0075855C, 0x00516138,
        0x00506037, 0x005F6E48, 0x00788761, 0x0073855E, 0x0071835C, 0x0070825B, 0x0070825B, 0x0071835C, 0x0071835C, 0x0071835C, 0x0070825B, 0x0074805C, 0x006F7E58, 0x006C7E55, 0x006C8056, 0x00657851, 0x00566442, 0x003D4527, 0x00555940, 0x00656B5A,
        0x00282F1A, 0x00353E23, 0x00233010, 0x00576541, 0x0070815C, 0x006D7D5B, 0x00697957, 0x006C8357, 0x00556D4B, 0x002F4735, 0x00435D5D, 0x006F8C9B, 0x007090AD, 0x00688CB0, 0x00648BB2, 0x006B8FB3, 0x0064829F, 0x00617587, 0x004D595F, 0x00515853,
        0x00515849, 0x0045513B, 0x0035422A, 0x00324524, 0x002D3C1D, 0x00273317, 0x00252D16, 0x00272D1A, 0x00262E1D, 0x00222C1C, 0x001D2A1C, 0x001D2716, 0x001A2413, 0x00172111, 0x00161E13, 0x00161E14, 0x00161C17, 0x00151A18, 0x00131817, 0x00181A1A,
        0x00181A1A, 0x00171919, 0x00171919, 0x00171919, 0x00181A1A, 0x00191B1B, 0x001A1C1C, 0x0015141D, 0x0015151B, 0x0015191A, 0x00181D1B, 0x001A211A, 0x00192317, 0x001B2518, 0x001E2919, 0x00273016, 0x00293414, 0x00314014, 0x003B4D18, 0x0042551E,
        0x00485926, 0x00546238, 0x00606C48, 0x0062734E, 0x00647550, 0x00667752, 0x00677853, 0x00687954, 0x00697A55, 0x006B7C57, 0x006C7D58, 0x006E8059, 0x006E8059, 0x006E8059, 0x006E8059, 0x006E8059, 0x006E8059, 0x006E8059, 0x006E8059, 0x00718459,
        0x006C7E55, 0x00708259, 0x006A7C53, 0x0074865F, 0x006F815A, 0x0072835E, 0x007C8D68, 0x00758563, 0x006E7F5A, 0x0073865B, 0x0065794C, 0x004D5F36, 0x004C5B3B, 0x0096A38B, 0x00EAF4E3, 0x003E3F25, 0x00BDBEA4, 0x00DCDDC3, 0x0043442A, 0x00727359,
        0x00626349, 0x0033341A, 0x0067684E, 0x00495539, 0x00424E32, 0x008E9A7E, 0x00364127, 0x003B462C, 0x00959F88, 0x004B553E, 0x00444E37, 0x00535F4B, 0x0028351F, 0x004C5A42, 0x008D9C80, 0x003C4C2D, 0x006F805E, 0x006E805B, 0x00677954, 0x00526341,
        0x0045532F, 0x003A4B2A, 0x003B5646, 0x00578186, 0x005D92A7, 0x005B93AC, 0x005589A0, 0x0044727A, 0x00273F33, 0x004E5743, 0x00707B78, 0x0096A4AA, 0x00DDE5E5, 0x00BDC4C1, 0x00869296, 0x007D898D, 0x007F8B8F, 0x00828E92, 0x00879397, 0x008B979B,
        0x00899599, 0x00849094, 0x00808C90, 0x00808E8D, 0x00808E8D, 0x00818E90, 0x007E8A8C, 0x00768284, 0x00828B8E, 0x00AAB3B6, 0x00D0D9DC, 0x00B9C1B6, 0x00818C78, 0x00707F5F, 0x00778660, 0x005F6D4B, 0xFFC3CAB5, 0xFFFFFFFC, 0xFFFFFCFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFF9FF, 0xFFFFFFF9, 0x00BAC2A3, 0x0058673B, 0x007B895F, 0x0076855F, 0x0073835A, 0x0077885C, 0x00788A61, 0x00798B62, 0x007B8D64, 0x0076885F, 0x00788A61,
        0x007B8D64, 0x00788A61, 0x007D8F66, 0x00778B5E, 0x00778960, 0x00758661, 0x00778666, 0x00778765, 0x006E8057, 0x00708554, 0x00728953, 0x00728259, 0x00708057, 0x0073835A, 0x0077875E, 0x00738459, 0x0075865B, 0x00798A5F, 0x00718257, 0x00738556,
        0x00728455, 0x00728455, 0x00728357, 0x00728357, 0x00738458, 0x00738458, 0x00718256, 0x00718158, 0x007A8A61, 0x005C6C43, 0x004B5B32, 0x00596940, 0x0054643B, 0x006F7F56, 0x007B8B62, 0x00728358, 0x00718257, 0x00738459, 0x0077875E, 0x004E5E35,
        0x00526239, 0x005C6B45, 0x007C8B65, 0x0073855E, 0x0072845D, 0x0071835C, 0x0071835C, 0x0071835C, 0x0072845D, 0x0071835C, 0x006F815A, 0x00727E5A, 0x006F7E58, 0x006A7C53, 0x006B7F55, 0x00667952, 0x00596745, 0x003C4426, 0x004F533A, 0x002B3120,
        0x00353C27, 0x00343D22, 0x003C4929, 0x003E4C28, 0x0061724D, 0x006A7A58, 0x00657553, 0x0071835A, 0x005A6B4A, 0x00334633, 0x002F4441, 0x00637E88, 0x007D9DB0, 0x006E91AB, 0x007BA0BC, 0x006B90AA, 0x00658499, 0x00566D7C, 0x0039484B, 0x0038433B,
        0x003D4736, 0x00455036, 0x003D492B, 0x002E4017, 0x00273511, 0x00202C0E, 0x00242B16, 0x002A2E22, 0x00292E25, 0x00222620, 0x00171D18, 0x00202418, 0x001E2216, 0x001B1F14, 0x00191C13, 0x00191B15, 0x00191A18, 0x00191A18, 0x00191919, 0x00191B1B,
        0x00191B1B, 0x00181A1A, 0x00181A1A, 0x00181A1A, 0x00191B1B, 0x00191B1B, 0x00191B1B, 0x001C181E, 0x001C181D, 0x001E1B1D, 0x001F1F1F, 0x0021221E, 0x001F241B, 0x001E2419, 0x001E2419, 0x001F211B, 0x001F2514, 0x00273211, 0x00344414, 0x003C4F18,
        0x0041531E, 0x004E5E2F, 0x005C6A41, 0x0063744F, 0x00657651, 0x00687954, 0x00697A55, 0x006A7B56, 0x006B7C57, 0x006D7E59, 0x006E7F5A, 0x006D7F58, 0x006D7F58, 0x006D7F58, 0x006E8059, 0x006E8059, 0x006E8059, 0x006E8059, 0x006E8059, 0x00708457,
        0x006F8356, 0x00708358, 0x00677A4F, 0x00708259, 0x006D7F56, 0x006D7F56, 0x006C7E57, 0x0070815C, 0x00788A63, 0x00718459, 0x00586B40, 0x0054663D, 0x00425230, 0x00748266, 0x00BBC8B0, 0x003C3E20, 0x00838567, 0x00828466, 0x003D3F21, 0x00838567,
        0x00737557, 0x00434527, 0x004B4D2F, 0x003B4625, 0x00525D3C, 0x00C0CBAB, 0x00535E3E, 0x00374123, 0x00626C4E, 0x002B3419, 0x00565F44, 0x008C9A82, 0x00324028, 0x0037462B, 0x00617054, 0x003B4B2C, 0x006B7C5B, 0x00687957, 0x004F613C, 0x00495A38,
        0x004B5935, 0x00435433, 0x00375242, 0x004F797E, 0x00598EA3, 0x005991AA, 0x0054889F, 0x0045737B, 0x00253D31, 0x004E5743, 0x00717C79, 0x0094A2A8, 0x00DEE6E6, 0x00C0C7C4, 0x00869296, 0x00708087, 0x00708087, 0x0074848B, 0x007F8F96, 0x008999A0,
        0x0088989F, 0x007B8B92, 0x006E7E85, 0x00778389, 0x00818D93, 0x00869296, 0x00808B8F, 0x00758084, 0x00848D91, 0x00B0B9BC, 0x00CFD8DB, 0x00899382, 0x006E7B63, 0x006E7D5D, 0x00788761, 0x00606D4D, 0xFFC3C9B6, 0xFFFFFFFC, 0xFFFCFAFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFAFF, 0xFFFFFFF9, 0x00BBC3A4, 0x0059683C, 0x007D8B61, 0x007A8963, 0x006A7A51, 0x00607145, 0x0061734A, 0x005F7148, 0x00607249, 0x005C6E45, 0x005F7148,
        0x005F7148, 0x005A6C43, 0x0066784F, 0x0072835E, 0x00637253, 0x005B6751, 0x006C7666, 0x005D6757, 0x0038442E, 0x00303F20, 0x00394A25, 0x002F3C1C, 0x002F3D1B, 0x003A4826, 0x004B5935, 0x0054623E, 0x0051603A, 0x006D7D54, 0x0076865D, 0x00718158,
        0x0073835A, 0x0075855C, 0x0076875C, 0x0077885D, 0x0075865B, 0x0074855A, 0x0075865B, 0x0075855C, 0x0074845B, 0x0078885F, 0x0058683F, 0x0058683F, 0x0053633A, 0x00526239, 0x0074845B, 0x00738459, 0x0076875C, 0x00708156, 0x0074845B, 0x00506037,
        0x0056663D, 0x005A6943, 0x007E8D67, 0x0074865F, 0x0072845D, 0x0071835C, 0x0072845D, 0x0072845D, 0x0072845D, 0x0071835C, 0x0070825B, 0x0076825E, 0x0072815B, 0x006B7D54, 0x006A7E54, 0x006A7D56, 0x00616F4D, 0x003B4325, 0x003F432A, 0x003F4534,
        0x00414833, 0x00454E33, 0x00354222, 0x004B5935, 0x00374823, 0x00667654, 0x006F7F5D, 0x00717853, 0x00626A4B, 0x005E6851, 0x004E5B4D, 0x00889B92, 0x00ADC4BF, 0x006C8783, 0x0063817C, 0x00618383, 0x00658483, 0x005A746E, 0x00314538, 0x001D2C17,
        0x001C2B0C, 0x003D4C26, 0x00526036, 0x003D5019, 0x00374717, 0x002F3E18, 0x002C371D, 0x002C3423, 0x00292F24, 0x0025291E, 0x001F2318, 0x0026271D, 0x0024251B, 0x0022231A, 0x001F1F19, 0x001D1D17, 0x001D1C18, 0x001F1E1A, 0x00211F1E, 0x001A1D1B,
        0x001B1E1C, 0x001B1E1C, 0x001C1F1D, 0x001C1F1D, 0x001B1E1C, 0x001A1D1B, 0x001A1D1B, 0x00221F1B, 0x00221F1B, 0x0024211C, 0x0024251C, 0x0027291D, 0x00262B1C, 0x00242A19, 0x00212716, 0x00262527, 0x0023261D, 0x00283019, 0x0033401A, 0x003B4B1B,
        0x0040511E, 0x004B5B2B, 0x00576738, 0x0062734E, 0x00647550, 0x00677853, 0x00697A55, 0x006A7B56, 0x006B7C57, 0x006C7D58, 0x006E7F5A, 0x006D7F58, 0x006D7F58, 0x006D7F58, 0x006E8059, 0x006E8059, 0x006E8059, 0x006F815A, 0x006F815A, 0x00697D50,
        0x006E8255, 0x006F8257, 0x00687B50, 0x0071835A, 0x006D7F56, 0x00708259, 0x006D7F58, 0x0070815C, 0x006A7C55, 0x00586A41, 0x004A5C33, 0x005B6D46, 0x0042532E, 0x00404F2F, 0x00516041, 0x00576541, 0x004C5A36, 0x002A3814, 0x00465430, 0x006A7854,
        0x00485632, 0x003E4C28, 0x00586642, 0x004C5834, 0x00515D39, 0x007A8662, 0x00606B4A, 0x005A6544, 0x00515C3C, 0x00566141, 0x003C4727, 0x00324126, 0x0048573B, 0x00657458, 0x00546445, 0x005B6C4B, 0x00657655, 0x0050613F, 0x004C5D3B, 0x00435432,
        0x00576541, 0x004E5F3E, 0x00385343, 0x00517B80, 0x005B90A5, 0x00578FA8, 0x0053879E, 0x00437179, 0x0021392D, 0x004E5743, 0x00737E7B, 0x0093A1A7, 0x00DDE5E5, 0x00C2C9C6, 0x00859195, 0x00728289, 0x00718188, 0x0074848B, 0x007F8F96, 0x008999A0,
        0x008999A0, 0x007E8E95, 0x0073838A, 0x00758088, 0x00828D95, 0x00879399, 0x00808B8F, 0x00768185, 0x0090999C, 0x00BBC5C5, 0x00C4CECE, 0x007A876F, 0x006F7D61, 0x0071815F, 0x0075835F, 0x005D694B, 0xFFC1C7B6, 0xFFFFFFFC, 0xFFFFFEFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFCF5FF, 0xFFFFFFF9, 0x00BAC2A3, 0x005E6D41, 0x00808E64, 0x0075845E, 0x004E5E35, 0x00314216, 0x0031431A, 0x002D3F16, 0x002E4017, 0x00293B12, 0x00304219,
        0x0033451C, 0x00273910, 0x0031431A, 0x006A7959, 0x0047543C, 0x00444C41, 0x008A8E8F, 0x00A6A9AD, 0x00919695, 0x00899187, 0x008F9989, 0x008D9787, 0x008E9887, 0x007B8672, 0x00536048, 0x004E5C40, 0x00435232, 0x006E7F5A, 0x0073845F, 0x00768462,
        0x007A8866, 0x007B8967, 0x007A8864, 0x00798862, 0x0075845E, 0x0076865D, 0x007C8C63, 0x007A8A61, 0x006D7D54, 0x0073835A, 0x007F8F66, 0x004F5F36, 0x0056663D, 0x0055653C, 0x0054643B, 0x00718257, 0x0076875C, 0x00738459, 0x0073835A, 0x0053633A,
        0x0058683F, 0x005B6A44, 0x007D8C66, 0x0073855E, 0x0072845D, 0x0072845D, 0x0072845D, 0x0073855E, 0x0073855E, 0x0072845D, 0x0070825B, 0x0074805C, 0x0074835D, 0x00708259, 0x0070845A, 0x006F825B, 0x005F6D4B, 0x002C3416, 0x00262A11, 0x00272D1C,
        0x00202712, 0x001E270C, 0x00364323, 0x00475531, 0x004C5D38, 0x00425230, 0x005A6A48, 0x007D845F, 0x00686D4D, 0x00697153, 0x005A6349, 0x0077846A, 0x007C8B6F, 0x002F4424, 0x002D4221, 0x00456046, 0x00486349, 0x00445A41, 0x002E4428, 0x002C3E1F,
        0x0031431C, 0x004E5F33, 0x00586B3A, 0x0048581B, 0x0043531E, 0x0037471E, 0x002A371D, 0x001F2918, 0x001C2316, 0x00212415, 0x00272818, 0x0027281E, 0x0027281E, 0x0026271D, 0x0023241A, 0x00202118, 0x00202118, 0x0023241B, 0x0026271E, 0x001B1F19,
        0x001C201A, 0x001F231D, 0x0020241E, 0x0020241E, 0x001E221C, 0x001B1F19, 0x001A1E18, 0x00212016, 0x00212016, 0x00202216, 0x00232617, 0x00252B1A, 0x00282E1D, 0x00232C18, 0x001E2713, 0x00222123, 0x0020211D, 0x00222718, 0x002A3319, 0x00323E1A,
        0x003A491D, 0x00475727, 0x00536431, 0x005E6F4A, 0x0061724D, 0x00647550, 0x00677853, 0x00687954, 0x00687954, 0x006A7B56, 0x006B7C57, 0x006C7E57, 0x006D7F58, 0x006D7F58, 0x006D7F58, 0x006E8059, 0x006F815A, 0x006F815A, 0x006F815A, 0x006B7E53,
        0x006F8158, 0x00708259, 0x006C7E55, 0x00758760, 0x006D7F58, 0x00748560, 0x00758661, 0x00728260, 0x00637351, 0x005D6D4B, 0x00556543, 0x00566644, 0x00516040, 0x00526141, 0x00546343, 0x005D724C, 0x00637852, 0x004E633D, 0x00617650, 0x0040552F,
        0x002C411B, 0x00485D37, 0x005B704A, 0x003A4824, 0x0043512D, 0x00616F4B, 0x00505E3C, 0x00687654, 0x005C6949, 0x005A6747, 0x00667353, 0x00627253, 0x00455536, 0x00667657, 0x006E7F5E, 0x00687958, 0x00536443, 0x00506140, 0x00475837, 0x00536442,
        0x0064724E, 0x00516241, 0x00344F3F, 0x004E787D, 0x00588DA2, 0x00558DA6, 0x005589A0, 0x00416F77, 0x001D3529, 0x004E5743, 0x00747F7C, 0x00909EA4, 0x00DCE4E4, 0x00C5CCC9, 0x00879397, 0x007D8D93, 0x007E8E94, 0x00809096, 0x00839399, 0x0086969C,
        0x0088989E, 0x0088989E, 0x0088989E, 0x00869199, 0x008A969C, 0x00899599, 0x00828E90, 0x00778383, 0x0097A2A0, 0x00BDC8C5, 0x00AAB5B2, 0x00707F60, 0x00707F5F, 0x00728260, 0x00748260, 0x005D694D, 0xFFC1C7B6, 0xFFFFFFFC, 0xFFFFFEFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFF9FF, 0xFFFFFFF8, 0x00B3BB9C, 0x005D6C40, 0x007F8D63, 0x0075845E, 0x004B5B32, 0x00314216, 0x0053653C, 0x004F6138, 0x00495B32, 0x003C4E25, 0x00495B32,
        0x00506239, 0x0036481F, 0x00304219, 0x006E8258, 0x00425135, 0x00414B3F, 0x00A4A8AD, 0x00DEE0EB, 0x00DCDEE8, 0x00D6DBDE, 0x00D8DFDC, 0x00DEE1E5, 0x00E9EEED, 0x00C0C6C1, 0x0061695E, 0x00515C48, 0x003C492F, 0x006A7959, 0x005B6B49, 0x005D684E,
        0x00586349, 0x00505C40, 0x00505C3E, 0x00596646, 0x005A6846, 0x00596745, 0x005E6C48, 0x00708057, 0x007B8B62, 0x0074845B, 0x006E7E55, 0x007B8B62, 0x0055653C, 0x005C6C43, 0x004A5A31, 0x00617247, 0x00697A4F, 0x0076875C, 0x0074845B, 0x0053633A,
        0x0055653C, 0x00606F49, 0x00788761, 0x0072845D, 0x0072845D, 0x0072845D, 0x0073855E, 0x0074865F, 0x0074865F, 0x0073855E, 0x0071835C, 0x00727E5A, 0x0073825C, 0x0072845B, 0x0073875D, 0x006D8059, 0x00586644, 0x00293113, 0x002A2E15, 0x00212716,
        0x00252C17, 0x00262F14, 0x003D4A2A, 0x0062704C, 0x0042532E, 0x0050603E, 0x00485836, 0x00677950, 0x006B7A54, 0x006C7A58, 0x00748161, 0x00798666, 0x00616F4D, 0x00475630, 0x00506037, 0x004C5D32, 0x00606F49, 0x006C7C5A, 0x00677758, 0x00687958,
        0x005D6F4A, 0x005F7247, 0x00506435, 0x0045521C, 0x003D4A1C, 0x002F3C1C, 0x001F2B19, 0x00162014, 0x00171C13, 0x001F2115, 0x00262517, 0x001F2619, 0x0021281B, 0x00232A1D, 0x0022291C, 0x001F2619, 0x001E2518, 0x0020271A, 0x00232A1D, 0x001A2114,
        0x001D2417, 0x0021281B, 0x00232A1D, 0x00232A1D, 0x001F2619, 0x001B2215, 0x00181F12, 0x001B1C13, 0x001A1D14, 0x001A1D14, 0x001D2116, 0x0021271C, 0x00262D20, 0x00212A1D, 0x001A2316, 0x001A1B17, 0x001A1B17, 0x001C1F16, 0x001D2213, 0x00222A13,
        0x002F3B17, 0x00425222, 0x0051642D, 0x005D6E49, 0x0060714C, 0x00647550, 0x00667752, 0x00687954, 0x00687954, 0x006A7B56, 0x006B7C57, 0x006C7E57, 0x006C7E57, 0x006D7F58, 0x006D7F58, 0x006E8059, 0x006F815A, 0x006F815A, 0x006F815A, 0x0072845D,
        0x0072845D, 0x006E7F5A, 0x006C7D58, 0x006D7D5B, 0x00546442, 0x0050603E, 0x004C5B3B, 0x00475636, 0x00495839, 0x00556445, 0x004D5B3F, 0x0039472B, 0x00404F30, 0x00455435, 0x00536242, 0x00364725, 0x004B5C3A, 0x004E5F3D, 0x00455634, 0x00354624,
        0x00445533, 0x00546543, 0x00364725, 0x00344621, 0x00566745, 0x00475836, 0x00354624, 0x00596A49, 0x003B4C2B, 0x002E3E1F, 0x002D3D1E, 0x004C5D3C, 0x005D6E4D, 0x00657655, 0x00647554, 0x00586948, 0x00546544, 0x00506140, 0x00556645, 0x00657654,
        0x00606E4A, 0x00455635, 0x002E4939, 0x00487277, 0x0054899E, 0x00548CA5, 0x005589A0, 0x003F6D75, 0x001B3327, 0x004D5642, 0x00737E7B, 0x008C9AA0, 0x00DAE2E2, 0x00C8CFCC, 0x008B979B, 0x008A969A, 0x008B979B, 0x008C989C, 0x008B979B, 0x00899599,
        0x008B979B, 0x008F9B9F, 0x0094A0A4, 0x0094A0A6, 0x008F9B9F, 0x008D9A9C, 0x00889494, 0x0073817D, 0x00919D97, 0x00B9C6BE, 0x009CAA9F, 0x00677755, 0x006F805B, 0x0071825D, 0x00758361, 0x00606B51, 0xFFC2C7B8, 0xFFFFFFFC, 0xFFFDFCFE, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFAFF, 0xFFFDFEF5, 0x00AEB697, 0x005C6B3F, 0x007F8D63, 0x0074835D, 0x004C5C33, 0x0038491D, 0x0062744B, 0x005F7148, 0x00576940, 0x00475930, 0x005A6C43,
        0x00687A51, 0x0046582F, 0x0032441B, 0x00677D4C, 0x004D5F3A, 0x00596454, 0x00B9BEC1, 0x00E1E2F0, 0x00CFD0DE, 0x00C0C4C9, 0x00BCC1C2, 0x00CBCADA, 0x00DCDCE8, 0x00C0C3C8, 0x00646967, 0x005B6457, 0x002C3822, 0x004E5C40, 0x00394828, 0x00616A55,
        0x004E5742, 0x00364029, 0x00354026, 0x00465236, 0x004A5638, 0x00424F2F, 0x003E4B2B, 0x00728259, 0x0073835A, 0x0078885F, 0x0078885F, 0x0073835A, 0x0078885F, 0x005A6A41, 0x00526239, 0x00506136, 0x0058693E, 0x0076875C, 0x0075855C, 0x00506037,
        0x00516138, 0x0065744E, 0x0074835D, 0x0072845D, 0x0071835C, 0x0072845D, 0x0073855E, 0x00758760, 0x00758760, 0x0074865F, 0x0072845D, 0x0077835F, 0x0072815B, 0x006E8057, 0x006D8157, 0x00667952, 0x00566442, 0x003B4325, 0x0050543B, 0x004D5342,
        0x002A311C, 0x00363F24, 0x004C5939, 0x00697753, 0x0061724D, 0x00455533, 0x0050603E, 0x00395629, 0x00668156, 0x005E7451, 0x00657758, 0x005D6D4E, 0x00465536, 0x00576543, 0x0047532F, 0x00464E1F, 0x0060693E, 0x00707A56, 0x006B7759, 0x006A795D,
        0x00607051, 0x005E6F4D, 0x00495B34, 0x00444B1E, 0x00373E1B, 0x00252E19, 0x001C251B, 0x001C2320, 0x00212422, 0x0027241F, 0x0029251A, 0x00192011, 0x001D2415, 0x0022291A, 0x00232A1B, 0x00202718, 0x001E2615, 0x00202817, 0x00222A19, 0x001A2112,
        0x001D2415, 0x00212819, 0x00242B1C, 0x00242B1C, 0x00202718, 0x001B2213, 0x00171E0F, 0x00171816, 0x00181917, 0x00161917, 0x00181B19, 0x001E241F, 0x00232924, 0x00212722, 0x0019201B, 0x001D2116, 0x0020221C, 0x001F201C, 0x001A1C16, 0x00191F0E,
        0x00263111, 0x003D4D1E, 0x004E6128, 0x005F704B, 0x0062734E, 0x00667752, 0x00697A55, 0x006A7B56, 0x006B7C57, 0x006C7D58, 0x006D7E59, 0x006C7E57, 0x006C7E57, 0x006D7F58, 0x006D7F58, 0x006E8059, 0x006F815A, 0x006F815A, 0x0070825B, 0x006E7F5A,
        0x006D7D5B, 0x006C7C5A, 0x006F7F5D, 0x006D7C5C, 0x00465535, 0x00364526, 0x002B3A1B, 0x003B4A2B, 0x004B593D, 0x0059664C, 0x0059664E, 0x004A573F, 0x00455238, 0x001F2E0F, 0x00202F0F, 0x00434C2B, 0x00444D2C, 0x005E6746, 0x004F5837, 0x00454E2D,
        0x0037401F, 0x003F4827, 0x003A4322, 0x00435734, 0x00495D3A, 0x005A6D4C, 0x00344726, 0x00384A2B, 0x00435536, 0x00384A2B, 0x002E4023, 0x003E4F2D, 0x00556644, 0x00556645, 0x006A7B5A, 0x00475837, 0x00556645, 0x00586948, 0x00657655, 0x00617250,
        0x004C5A36, 0x00354625, 0x002E4939, 0x004B757A, 0x00558A9F, 0x00568EA7, 0x0052869D, 0x003F6D75, 0x00193125, 0x004D5642, 0x00727D7A, 0x0089979D, 0x00D8E0E0, 0x00C9D0CD, 0x008E9A9E, 0x008D999B, 0x008D999B, 0x008C989A, 0x008B9799, 0x008B9799,
        0x008C989A, 0x008C989A, 0x008D999B, 0x00929EA2, 0x008B989A, 0x008F9D9C, 0x008C9997, 0x006F7D77, 0x008A988D, 0x00BBC9BD, 0x00A1AFA3, 0x006E7F5A, 0x00758661, 0x00748560, 0x00768363, 0x00626D53, 0xFFC2C7B8, 0xFFFFFFFC, 0xFFFDFCFE, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFDFF, 0xFBFAFEF3, 0x00B2BC9E, 0x005B6940, 0x007B8862, 0x0075815D, 0x004D5B31, 0x00405020, 0x005B6D44, 0x0033451C, 0x005D6F46, 0x0044562D, 0x0035471E,
        0x00687A51, 0x004E6037, 0x00304219, 0x006E8559, 0x005A6E4B, 0x00667462, 0x00C0C9C6, 0x00D9E0E3, 0x00C3C9CE, 0x00BCC4C3, 0x00B4BEB8, 0x00CCD0D5, 0x00D6DBDE, 0x00C4CBC8, 0x00818A80, 0x00697563, 0x00637159, 0x004D5D3E, 0x00728362, 0x00A2A39A,
        0x0077786F, 0x00606158, 0x0063645B, 0x006A6B62, 0x0097988F, 0x0086877E, 0x003B3C33, 0x00728358, 0x0076875C, 0x0074855A, 0x00728358, 0x006F8055, 0x007A8B60, 0x007B8C61, 0x0054653A, 0x004E6039, 0x004C5E37, 0x005B6D46, 0x006E8059, 0x0051633C,
        0x00556740, 0x005C6E47, 0x00788A63, 0x0074875C, 0x0074865D, 0x0073855C, 0x0072845B, 0x0072845D, 0x0072845D, 0x0073845F, 0x00748560, 0x00788964, 0x006D7F58, 0x0072815B, 0x0074825E, 0x00757F61, 0x00586049, 0x00404536, 0x0066675D, 0x0066695A,
        0x003A402D, 0x00353E24, 0x004B5537, 0x00687654, 0x006E7C5A, 0x00627151, 0x00435233, 0x004D603F, 0x00435A2E, 0x002E431D, 0x00334030, 0x00465246, 0x004C5C44, 0x003F5035, 0x003A4739, 0x003B4D4E, 0x0034493A, 0x00354F2B, 0x00647D51, 0x005F7349,
        0x0063724C, 0x00626E44, 0x0052612E, 0x0038402F, 0x001A2112, 0x001A2015, 0x00262B22, 0x001C251B, 0x003A483C, 0x002B412F, 0x0027402C, 0x00384232, 0x00384232, 0x003B4534, 0x00363E2D, 0x00353E2A, 0x003E4431, 0x003B422D, 0x003A412C, 0x003C4834,
        0x00394531, 0x00303C28, 0x0036422E, 0x00384430, 0x002E3A26, 0x002D3925, 0x002D3925, 0x0024331E, 0x002B3A25, 0x002B3A25, 0x00263520, 0x002C3B26, 0x00364530, 0x00303F2A, 0x0021301B, 0x001B3821, 0x00203320, 0x0033372B, 0x0023241B, 0x00192117,
        0x00141F15, 0x002D3125, 0x00555244, 0x00626E50, 0x0063714F, 0x00606F49, 0x006E8057, 0x00697C51, 0x00697B52, 0x00677954, 0x006B7C5A, 0x00687A55, 0x006A7C57, 0x006C7E59, 0x006D7F5A, 0x006D7F5A, 0x006D7F5A, 0x006E805B, 0x006F815C, 0x00757F5B,
        0x00677954, 0x006A845C, 0x006B8353, 0x00718151, 0x0049532F, 0x00444D43, 0x004C5864, 0x0064696A, 0x0042504C, 0x003A4830, 0x007B7C55, 0x005B583C, 0x00414A47, 0x00344647, 0x002C3A2F, 0x00415150, 0x00445139, 0x005D6739, 0x00404A20, 0x00394833,
        0x00384847, 0x00414E50, 0x003E4A44, 0x003C484C, 0x0049573B, 0x005B653B, 0x004A513C, 0x00404C4C, 0x00405553, 0x003D524A, 0x00202F27, 0x003D5035, 0x004A5F3F, 0x00526643, 0x0060754E, 0x004E613A, 0x00485A35, 0x0071815F, 0x006F7E5E, 0x004A593D,
        0x0046562D, 0x003A4E23, 0x0029462F, 0x004B747D, 0x0050829E, 0x00558DA6, 0x00538A97, 0x00426F7A, 0x0020382E, 0x004D5544, 0x0076817E, 0x0086939B, 0x00DAE1E4, 0x00C8CECD, 0x00879399, 0x007D9095, 0x007C8F94, 0x007F9297, 0x00879A9F, 0x0090A3A8,
        0x008FA2A7, 0x0085989D, 0x007B8E93, 0x00829096, 0x007F8D93, 0x00869598, 0x007F8B8F, 0x00717E80, 0x00859193, 0x009AA6A8, 0x00919D9D, 0x006D7F5A, 0x006D7F5A, 0x006B7C57, 0x00758464, 0x00647157, 0xFFBEC5B6, 0xFFFAFEF9, 0xFFFCFEFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFDFF, 0xFFFDFFF6, 0x00B1BB9D, 0x005A683F, 0x007D8A64, 0x00798561, 0x004E5C32, 0x003B4B1B, 0x0061734A, 0x0056683F, 0x00596B42, 0x0042542B, 0x0052643B,
        0x00697B52, 0x00405229, 0x00304219, 0x00677856, 0x00516045, 0x00646E62, 0x00BFC4C5, 0x00D4D6E0, 0x00C5C7D1, 0x00CCD0D5, 0x00C7CCCD, 0x00C9CAD4, 0x00D9DBE3, 0x00C9CCD0, 0x00707573, 0x0071796E, 0x00515B4A, 0x00505C46, 0x00626F55, 0x00989B8B,
        0x00898C7C, 0x006A6D5D, 0x00636656, 0x00747767, 0x00949787, 0x00838676, 0x005F6252, 0x005F7045, 0x0076875C, 0x0074855A, 0x006C7D52, 0x0074855A, 0x0078895E, 0x0075865B, 0x00718257, 0x005C6E47, 0x0051633C, 0x0050623B, 0x005B6D46, 0x0043552E,
        0x0052643D, 0x005E7049, 0x00798B64, 0x0074875C, 0x0074865D, 0x0073855C, 0x0073855C, 0x0073855E, 0x0073855E, 0x00748560, 0x00758661, 0x00768762, 0x00768762, 0x007B8A64, 0x0072815B, 0x00717C5B, 0x0060694E, 0x00444C35, 0x004E5441, 0x003F4534,
        0x003B422D, 0x00424B30, 0x004B5636, 0x00677551, 0x00788662, 0x00768664, 0x005F6F4D, 0x00435536, 0x004F653B, 0x00405431, 0x004D5A4C, 0x005E695F, 0x004A5A43, 0x001F2F17, 0x00344034, 0x0048595C, 0x00384C3F, 0x002E4624, 0x00637B53, 0x00637550,
        0x00667452, 0x0063704A, 0x004D5A2E, 0x00202718, 0x001B2116, 0x00171C13, 0x00191F1A, 0x00212823, 0x005B695E, 0x006A7C6F, 0x00728876, 0x0056685B, 0x00677A6B, 0x00748778, 0x00697A6C, 0x00647665, 0x006E7E6D, 0x00697967, 0x00637361, 0x006F7C6C,
        0x00657262, 0x00606D5D, 0x00697666, 0x00677464, 0x00637060, 0x006A7767, 0x00677464, 0x00617160, 0x00647463, 0x00637362, 0x00627261, 0x0060705F, 0x00596958, 0x00465645, 0x00334332, 0x005D7965, 0x006F7E70, 0x0060635A, 0x0023251F, 0x00161D18,
        0x000D1810, 0x0012170E, 0x00373229, 0x00515D3F, 0x00687555, 0x00677551, 0x0066784F, 0x0061734A, 0x00677952, 0x00687A55, 0x006B7C5A, 0x00697B56, 0x006B7D58, 0x006D7F5A, 0x006E805B, 0x006D7F5A, 0x006D7F5A, 0x006E805B, 0x006F815C, 0x0076815B,
        0x006A7C57, 0x00678159, 0x00698355, 0x0067784C, 0x003F4B2D, 0x004D5C58, 0x00516374, 0x00566578, 0x00465F69, 0x003B5347, 0x00697656, 0x00464F3A, 0x003A5056, 0x00405A6B, 0x003F565E, 0x003A525E, 0x0035493D, 0x00475837, 0x00354728, 0x00496058,
        0x004D6571, 0x00425969, 0x00465B63, 0x00364D55, 0x00435A44, 0x00384C29, 0x0038483D, 0x00526572, 0x003E5967, 0x003A575E, 0x003F565E, 0x00394C31, 0x00516646, 0x00526643, 0x00546942, 0x004D6039, 0x004E603B, 0x00657553, 0x00536242, 0x00415034,
        0x004A5A31, 0x0043572C, 0x002A4730, 0x0049727B, 0x004F819D, 0x00548CA5, 0x00528996, 0x00416E79, 0x0020382E, 0x004B5342, 0x0075807D, 0x0085929A, 0x00DAE1E4, 0x00CCD2D1, 0x008B979D, 0x0072858A, 0x00718489, 0x0075888D, 0x007F9297, 0x008A9DA2,
        0x008A9DA2, 0x007E9196, 0x0072858A, 0x0078868C, 0x007C8A90, 0x00859497, 0x00808C90, 0x00758284, 0x00849092, 0x0096A2A4, 0x00929E9E, 0x00728361, 0x00748661, 0x00748560, 0x00758563, 0x005D6A50, 0xFFB9C0B1, 0xFFFCFFFB, 0xFFFDFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFCFF, 0xF7F9FDF2, 0x00ADB799, 0x005A683F, 0x00818E68, 0x007F8B67, 0x00515F35, 0x00374717, 0x00586A41, 0x0064764D, 0x004C5E35, 0x003B4D24, 0x005A6C43,
        0x00596B42, 0x0036481F, 0x0032441B, 0x006D795D, 0x0057604C, 0x0062675E, 0x00BABCBD, 0x00E5E4ED, 0x00D8D7E0, 0x00D0D1D5, 0x00C7C9CA, 0x00D8D5DE, 0x00E5E3E9, 0x00C6C5C7, 0x005D5E5C, 0x0091948B, 0x005B6051, 0x005B6150, 0x00575E49, 0x0041482D,
        0x005F664B, 0x005F664B, 0x0052593E, 0x0051583D, 0x005E654A, 0x00656C51, 0x00747B60, 0x0058693E, 0x00627348, 0x0077885D, 0x00798A5F, 0x006E7F54, 0x00718257, 0x0077885D, 0x0077885D, 0x006E8059, 0x005D6F48, 0x004B5D36, 0x004D5F38, 0x00374922,
        0x0052643D, 0x005E7049, 0x00768861, 0x0074875C, 0x0073855C, 0x0073855C, 0x0073855C, 0x0074865F, 0x00758760, 0x00758661, 0x00768762, 0x00758563, 0x00758661, 0x00798B64, 0x0073835A, 0x0076865D, 0x00707C58, 0x004D5838, 0x003B4527, 0x00404732,
        0x00485137, 0x00525D3D, 0x005A6844, 0x006F7F56, 0x0071835A, 0x0073855E, 0x00748560, 0x005A694E, 0x00495B36, 0x004E5E3F, 0x00798278, 0x00616863, 0x00434F3D, 0x002A3622, 0x00575F58, 0x0078848A, 0x00536459, 0x002B4124, 0x00657956, 0x00657556,
        0x00657155, 0x005F694B, 0x0038421E, 0x00181E13, 0x00262A24, 0x00191F1A, 0x00131918, 0x000B1312, 0x00313D37, 0x003D4C44, 0x00455649, 0x0020392F, 0x002E473D, 0x003B5349, 0x002F473B, 0x002B4135, 0x00344B3D, 0x00334A3C, 0x00324639, 0x003C4A3F,
        0x002F3D32, 0x002F3D32, 0x0039473C, 0x00324035, 0x00313F34, 0x003C4A3F, 0x00334136, 0x00324237, 0x00304035, 0x002F3F34, 0x00324237, 0x0035453A, 0x0035453A, 0x00334338, 0x00334338, 0x00263D2E, 0x002F3A30, 0x00343531, 0x000C0F0D, 0x00071210,
        0x00121D1A, 0x00171B16, 0x00201A15, 0x00333E24, 0x00606C4E, 0x00667452, 0x0063754E, 0x00697B52, 0x006C7E57, 0x00697B56, 0x006B7C5A, 0x006B7D58, 0x006D7F5A, 0x006E805B, 0x006E805B, 0x006E805B, 0x006D7F5A, 0x006E805B, 0x006F815C, 0x00778058,
        0x006E8059, 0x00667F59, 0x006D855B, 0x00677A53, 0x0041533C, 0x00667C81, 0x0067859E, 0x00617BA3, 0x005C819B, 0x00416662, 0x00577056, 0x00344B3C, 0x00406171, 0x00597FA1, 0x006183A1, 0x005F809A, 0x003B5758, 0x00435A44, 0x00374F3D, 0x00547176,
        0x006F8DA8, 0x006786A5, 0x00718FAA, 0x004F6F7A, 0x00395946, 0x003E5A3D, 0x005E7674, 0x007894AC, 0x006085A1, 0x006A8EA6, 0x0054738C, 0x003B4E33, 0x00506545, 0x00546845, 0x00596E47, 0x004F623B, 0x003F512C, 0x004A5A38, 0x00475636, 0x00425135,
        0x0057673E, 0x004F6338, 0x002D4A33, 0x0049727B, 0x004F819D, 0x00538BA4, 0x00518895, 0x0044717C, 0x00223A30, 0x004A5241, 0x00747F7C, 0x00849199, 0x00D9E0E3, 0x00CDD3D2, 0x008D999F, 0x00718489, 0x00718489, 0x0075888D, 0x007F9297, 0x008A9DA2,
        0x008A9DA2, 0x007F9297, 0x0075888D, 0x007B898F, 0x00829096, 0x00879699, 0x00838F93, 0x007E8B8D, 0x00919D9F, 0x00ABB7B9, 0x00B7C3C3, 0x006E7E5F, 0x006D7E5D, 0x00768664, 0x00778765, 0x005B694D, 0xFFB5BDAC, 0xFFFBFFFA, 0xFFFDFEFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFDFF, 0xFFFFFFF8, 0x00B1BB9D, 0x005C6A41, 0x00808D67, 0x007A8662, 0x004D5B31, 0x00314111, 0x002D3F16, 0x0036481F, 0x002A3C13, 0x0024360D, 0x0033451C,
        0x0034461D, 0x002C3E15, 0x00304219, 0x00707859, 0x00686E55, 0x00646855, 0x00AEAFA5, 0x00F3F3ED, 0x00E9E9E3, 0x00D7D8CF, 0x00DCDDD3, 0x00E6E6E0, 0x00EBECE3, 0x00C7C8BE, 0x00696C5D, 0x00B5B9A6, 0x00868C75, 0x007C8269, 0x00787F64, 0x007F8D64,
        0x0079875E, 0x00717F56, 0x006F7D54, 0x00738158, 0x0076845B, 0x0065734A, 0x004E5C33, 0x0054653A, 0x004E5F34, 0x006D7E53, 0x007B8C61, 0x00708156, 0x00738459, 0x0075865B, 0x00718257, 0x00788A63, 0x006A7C55, 0x0051633C, 0x004E6039, 0x00364821,
        0x00556740, 0x005D6F48, 0x0071835C, 0x0072855A, 0x0072845B, 0x0072845B, 0x0073855C, 0x0074865F, 0x0074865F, 0x00758661, 0x00768762, 0x00748564, 0x006F815C, 0x0074865D, 0x0072855A, 0x0076875B, 0x0076875C, 0x00627047, 0x0053603A, 0x00525A43,
        0x00545D42, 0x005E6C4A, 0x00707F59, 0x00798C61, 0x0072855A, 0x006E8258, 0x0075895F, 0x0079876F, 0x006C7D5B, 0x00425135, 0x00545C55, 0x004E5552, 0x00364131, 0x001C2816, 0x00787F7A, 0x00B4BEC5, 0x007D8B80, 0x00314429, 0x00596A49, 0x004A573D,
        0x004B5440, 0x00535A45, 0x002A3318, 0x00171913, 0x00222621, 0x001B2120, 0x00232D2D, 0x000F1919, 0x00172220, 0x00232D27, 0x002C372F, 0x00283A33, 0x00253730, 0x00293B34, 0x00283930, 0x00283930, 0x002C3D32, 0x002C3C31, 0x00314136, 0x002D3933,
        0x0026322C, 0x0027332D, 0x00313D37, 0x002C3832, 0x0028342E, 0x002F3B35, 0x0026322C, 0x002E3A34, 0x002B3731, 0x0028342E, 0x0025312B, 0x0024302A, 0x0028342E, 0x00323E38, 0x003C4842, 0x0028392E, 0x001C241D, 0x00202321, 0x00121718, 0x00202D2F,
        0x00253332, 0x00161B19, 0x00181310, 0x001A230E, 0x004E593F, 0x00546141, 0x005A6B46, 0x0070825B, 0x006E8059, 0x00677954, 0x006D7E5C, 0x006C7E59, 0x006E805B, 0x006F815C, 0x006F815C, 0x006E805B, 0x006D7F5A, 0x006E805B, 0x006E805B, 0x00788159,
        0x006F815A, 0x00687F59, 0x00688058, 0x00647855, 0x00405644, 0x00607F88, 0x006C93B3, 0x006F8FC0, 0x006F98B8, 0x00466E6C, 0x00516D4F, 0x0038533F, 0x004E7282, 0x006893BA, 0x006C93BA, 0x006F91AF, 0x00314E52, 0x003D5340, 0x00324836, 0x003D575D,
        0x006E8EAB, 0x006F93B7, 0x007699BB, 0x00628589, 0x0041634B, 0x002F4E2D, 0x003C5551, 0x007492AB, 0x006D93B3, 0x006E94B2, 0x006384A5, 0x003D5035, 0x00455A3A, 0x00516542, 0x005E734C, 0x0050633C, 0x003C4E29, 0x00485836, 0x004F5E3E, 0x00556448,
        0x00627249, 0x0052663B, 0x002D4A33, 0x004B747D, 0x005284A0, 0x00548CA5, 0x00528996, 0x004A7782, 0x00273F35, 0x004A5241, 0x00737E7B, 0x00828F97, 0x00D6DDE0, 0x00CDD3D2, 0x008C989E, 0x007C8F94, 0x007C8F94, 0x007E9196, 0x0084979C, 0x008A9DA2,
        0x008A9DA2, 0x0086999E, 0x00819499, 0x00849298, 0x0089979D, 0x00869598, 0x007D898D, 0x007A8789, 0x008C989A, 0x00ADB9BB, 0x00C8D4D4, 0x0085937B, 0x006E7D61, 0x00748462, 0x00778863, 0x005D6C4D, 0xFFB5BDAC, 0xFFFAFEF9, 0xFFFCFDFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFDFF, 0xFFFFFFF8, 0x00B1BB9D, 0x005C6A41, 0x007D8A64, 0x00798561, 0x005C6A40, 0x004A5A2A, 0x004B5D34, 0x0045572E, 0x004B5D34, 0x0046582F, 0x003E5027,
        0x0041532A, 0x0042542B, 0x0046582F, 0x00717D53, 0x006E7953, 0x005D6645, 0x007A8263, 0x009EA688, 0x008C9476, 0x00878F71, 0x009DA586, 0x008D9577, 0x008C9476, 0x00868E6F, 0x00515A39, 0x007B8561, 0x006D7852, 0x006D7850, 0x007B865E, 0x00738256,
        0x00707F53, 0x0079885C, 0x007D8C60, 0x0077865A, 0x0077865A, 0x00758458, 0x00667549, 0x004D5E33, 0x004B5C31, 0x0054653A, 0x00637449, 0x00798A5F, 0x007D8E63, 0x006F8055, 0x0077885D, 0x00768861, 0x006F815A, 0x00566841, 0x0051633C, 0x00374922,
        0x00576942, 0x005D6F48, 0x0072845D, 0x00718459, 0x0071835A, 0x0072845B, 0x0073855C, 0x0073855E, 0x0074865F, 0x00748560, 0x00748560, 0x00718260, 0x0072845F, 0x00768A60, 0x00708457, 0x006D8154, 0x0077885C, 0x00798960, 0x00788761, 0x0078826B,
        0x00768266, 0x00768462, 0x00768861, 0x0073865B, 0x00768A5F, 0x0075895F, 0x0070845A, 0x006F7C64, 0x00798967, 0x00475539, 0x004C534C, 0x00515654, 0x003F4939, 0x00151F0E, 0x005F6560, 0x006F7679, 0x00505C50, 0x00253419, 0x00687859, 0x0064705A,
        0x006E7566, 0x0072796A, 0x003C4530, 0x00191A16, 0x001B201E, 0x00212929, 0x003B4749, 0x00182426, 0x000B1515, 0x00111815, 0x00171B16, 0x00141B14, 0x000E150E, 0x00151A11, 0x00171C13, 0x001B1F14, 0x001A1E13, 0x0013170C, 0x00181A0E, 0x00131B14,
        0x00141C15, 0x00111912, 0x00161E17, 0x00171F18, 0x00121A13, 0x00141C15, 0x00121A13, 0x000D1711, 0x00101A14, 0x00121C16, 0x00111B15, 0x00101A14, 0x00111B15, 0x00111B15, 0x00111B15, 0x000E1C11, 0x00171D18, 0x00191B1B, 0x001A2124, 0x00516364,
        0x00415352, 0x000D1312, 0x00201B1A, 0x00151D0C, 0x004F5843, 0x004E5A3E, 0x004B5B39, 0x00697A55, 0x00687A53, 0x00677954, 0x0070815F, 0x006D7F5A, 0x006E805B, 0x006F815C, 0x006F815C, 0x006E805B, 0x006E805B, 0x006E805B, 0x006F815C, 0x00788159,
        0x006D7E59, 0x006C805D, 0x00657A54, 0x006C7D5B, 0x00475F4D, 0x00567983, 0x00719EBF, 0x007693C0, 0x007AA2BB, 0x0054786C, 0x00657D55, 0x00506649, 0x0060818A, 0x00729BBC, 0x006D93B5, 0x007C9BB2, 0x00465D59, 0x00546347, 0x00465539, 0x00495E5B,
        0x00819DB5, 0x007A9BBC, 0x00769AB8, 0x00799490, 0x00476443, 0x00466038, 0x003E5448, 0x00768FA3, 0x007DA0BA, 0x00789CB4, 0x006E8CA7, 0x004C5F44, 0x00495E3E, 0x00556946, 0x00596E47, 0x004C5F38, 0x004A5C37, 0x00536341, 0x004A5939, 0x00657458,
        0x00607047, 0x00465A2F, 0x0027442D, 0x004B747D, 0x005385A1, 0x00558DA6, 0x00548B98, 0x004B7883, 0x00294137, 0x0048503F, 0x00727D7A, 0x00818E96, 0x00D4DBDE, 0x00CFD5D4, 0x008E9AA0, 0x0085989D, 0x0085989D, 0x0085989D, 0x0084979C, 0x0085989D,
        0x0085989D, 0x00879A9F, 0x00889BA0, 0x00829096, 0x0087959B, 0x00839295, 0x007B878B, 0x00778486, 0x00859193, 0x00A9B5B7, 0x00CDD9D9, 0x00BAC6B4, 0x007D8B73, 0x00728161, 0x00768861, 0x00606F4F, 0xFFB5BEAA, 0xFFFCFFFB, 0xFFFDFDFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFBF9FF, 0xFFFDFFF6, 0x00ACB698, 0x0059673E, 0x007C8963, 0x007F8B67, 0x0076845A, 0x00748454, 0x0076885F, 0x006D7F56, 0x00788A61, 0x0076885F, 0x0073855C,
        0x00788A61, 0x0072845B, 0x00788A61, 0x007B885C, 0x00727F53, 0x006B784C, 0x00717E52, 0x00738054, 0x00667347, 0x00748155, 0x00808D61, 0x00778758, 0x00687849, 0x00778758, 0x006C7C4D, 0x00657546, 0x006E7E4F, 0x00788859, 0x00809061, 0x007B8D5E,
        0x0077895A, 0x00758758, 0x00728455, 0x007A8C5D, 0x00798B5C, 0x00798B5C, 0x00748657, 0x005F7045, 0x004D5E33, 0x00495A2F, 0x0055663B, 0x00697A4F, 0x0077885D, 0x0077885D, 0x0076875C, 0x0070825B, 0x006D7F58, 0x0052643D, 0x004E6039, 0x0033451E,
        0x00576942, 0x005E7049, 0x00798B64, 0x00718459, 0x0072845B, 0x0072845B, 0x0073855C, 0x0074865F, 0x0074865F, 0x00748560, 0x0073845F, 0x006E835D, 0x00748760, 0x0074885D, 0x006F8358, 0x00718459, 0x00788A61, 0x00768460, 0x00697656, 0x0069725D,
        0x00646F55, 0x00647353, 0x0070815C, 0x006D8157, 0x0071855B, 0x006F825B, 0x006B805A, 0x00707D63, 0x006B7C57, 0x00455435, 0x004D554B, 0x003C423D, 0x00242E1D, 0x001B2612, 0x005D645D, 0x006F7574, 0x004F5A4A, 0x00223112, 0x00647353, 0x00626E58,
        0x007B8275, 0x00787F72, 0x00313928, 0x00181A14, 0x001A201B, 0x0025302E, 0x00415150, 0x001A2A29, 0x000F1A18, 0x00171B16, 0x001D1D17, 0x00353426, 0x00343325, 0x00383527, 0x00322F20, 0x00332E1F, 0x00383422, 0x00322E1C, 0x00302C1A, 0x00282F20,
        0x00293021, 0x001F2617, 0x001D2415, 0x001E2516, 0x00192011, 0x001C2314, 0x001D2415, 0x001C2217, 0x001B2116, 0x00191F14, 0x001A2015, 0x001E2419, 0x0022281D, 0x0022281D, 0x001F251A, 0x001E271D, 0x00191D17, 0x00141917, 0x000C1818, 0x003C5250,
        0x00374C4A, 0x000C1512, 0x00231E1B, 0x001B2215, 0x00626A59, 0x005F6952, 0x004E5D3D, 0x00697A55, 0x00697A55, 0x006C7E59, 0x006D7F5A, 0x006C7E59, 0x006D7F5A, 0x006F815C, 0x006F815C, 0x006E805B, 0x006E805B, 0x006E805B, 0x006F815C, 0x0073805A,
        0x006C7C5A, 0x0070815F, 0x006A7C55, 0x0075835F, 0x004F644E, 0x0056797D, 0x007BAAC5, 0x007794B9, 0x007EA4B6, 0x005A7A69, 0x00708155, 0x00596947, 0x00678488, 0x007BA3BC, 0x00749CB5, 0x0085A1B2, 0x005B7067, 0x0054633D, 0x00414E28, 0x004F6055,
        0x008AA4B4, 0x007799B6, 0x007BA0BC, 0x00768D88, 0x003D5533, 0x0061754A, 0x00576A5B, 0x007A94A2, 0x0081A2B6, 0x007DA1B3, 0x006A899E, 0x0055684D, 0x004C6141, 0x005E724F, 0x005F744D, 0x004B5E37, 0x004A5C37, 0x00536341, 0x00505F3F, 0x00637256,
        0x0053633A, 0x00394D22, 0x00234029, 0x0048717A, 0x005284A0, 0x00578FA8, 0x00558C99, 0x0047747F, 0x00263E34, 0x00444C3B, 0x00707B78, 0x00808D95, 0x00D4DBDE, 0x00D4DAD9, 0x00929EA4, 0x00879A9F, 0x00879A9F, 0x00879A9F, 0x00879A9F, 0x0086999E,
        0x00879A9F, 0x00879A9F, 0x00889BA0, 0x0086949A, 0x0086949A, 0x00839295, 0x007C888C, 0x00778486, 0x00879395, 0x00B0BCBE, 0x00DAE6E6, 0x00D3DDD1, 0x007E8A76, 0x006F7E5E, 0x00768861, 0x00637351, 0xFFB7C0AB, 0xFFFDFFFC, 0xFFFDFCFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFDFF, 0xFFFFFFF8, 0x00ADB799, 0x005C6A41, 0x007D8A64, 0x007D8965, 0x007A885E, 0x007F8F5F, 0x00788A61, 0x0073855C, 0x0075875E, 0x0076885F, 0x00778960,
        0x00788A61, 0x0073855C, 0x0074865D, 0x007A8963, 0x0073835A, 0x00798A5F, 0x007E8F63, 0x00809263, 0x007B8D5E, 0x0087986C, 0x007F9064, 0x00839867, 0x00778B5C, 0x007A8E5F, 0x00819566, 0x00728659, 0x00768A5D, 0x00788B60, 0x0072855A, 0x00798A5F,
        0x00798A5F, 0x0078895E, 0x006F8055, 0x0076875C, 0x00728358, 0x0075865B, 0x0076875C, 0x0077885D, 0x005C6D42, 0x00536439, 0x0056673C, 0x00526338, 0x0066774C, 0x007D8E63, 0x00728358, 0x0071835C, 0x006D7F58, 0x004F613A, 0x004D5F38, 0x0032441D,
        0x00576942, 0x005D6F48, 0x007B8D66, 0x0073865B, 0x0074865D, 0x0075875E, 0x0075875E, 0x00758760, 0x00758760, 0x00748560, 0x00748560, 0x0070865C, 0x006F855B, 0x006E8257, 0x00708459, 0x0070835C, 0x00627151, 0x004A583C, 0x0037442C, 0x00283221,
        0x002B3721, 0x00313F23, 0x004D5E3D, 0x0062744F, 0x006F815C, 0x00687C59, 0x006B7F5C, 0x00667556, 0x0073855C, 0x0050603E, 0x00646D60, 0x00788076, 0x005B6751, 0x005D6A52, 0x00A8B0A5, 0x00B6BDB6, 0x0088937F, 0x003E4E2C, 0x00566644, 0x003F4C34,
        0x006A7366, 0x007C8578, 0x00424C3C, 0x0014180D, 0x00131A13, 0x00182620, 0x00304340, 0x00122320, 0x000F1B15, 0x0022241E, 0x003F3D33, 0x0050533A, 0x0044472E, 0x003B3E25, 0x0033331B, 0x0036371D, 0x00403F25, 0x003D3C20, 0x003D3C20, 0x003F422C,
        0x003D402A, 0x00353822, 0x00343721, 0x0030331D, 0x002F321C, 0x00373A24, 0x00343721, 0x002A2E1B, 0x00232714, 0x001F2310, 0x00212512, 0x00272B18, 0x002F3320, 0x003F4330, 0x004D513E, 0x002C3528, 0x000F140B, 0x00181E19, 0x00162521, 0x002F4844,
        0x002E4842, 0x00111B15, 0x0015110C, 0x0021271C, 0x00666D5E, 0x00626B56, 0x00526142, 0x006F7F5D, 0x006C7D58, 0x006D7F5A, 0x006A7C57, 0x006A7C57, 0x006C7E59, 0x006E805B, 0x006F815C, 0x006E805B, 0x006E805B, 0x006F815C, 0x0070825D, 0x00728260,
        0x006D7E5D, 0x006D7E5C, 0x00717F56, 0x00737C54, 0x00415237, 0x00547370, 0x0078A4B5, 0x006D93B3, 0x00759DAF, 0x004C6D5E, 0x00606F49, 0x0048563A, 0x005B797E, 0x007AA3BC, 0x00709CB3, 0x0080A1B4, 0x005D766C, 0x004C5E37, 0x00394822, 0x00435A4C,
        0x007E9FAF, 0x007097B7, 0x0076A3C4, 0x006B8488, 0x00546D53, 0x00546C49, 0x0033483F, 0x007995A6, 0x00769DB3, 0x006D98A9, 0x007A9FB3, 0x004B5E43, 0x004E6343, 0x00667A57, 0x00627750, 0x004E613A, 0x004B5D38, 0x0050603E, 0x00556444, 0x0057664A,
        0x0048582F, 0x00394D22, 0x0027442D, 0x00466F78, 0x004F819D, 0x005991AA, 0x00538A97, 0x0045727D, 0x00263E34, 0x00424A39, 0x006F7A77, 0x00808D95, 0x00D4DBDE, 0x00D5DBDA, 0x00939FA5, 0x00819499, 0x00819499, 0x0084979C, 0x008A9DA2, 0x008FA2A7,
        0x008EA1A6, 0x00879A9F, 0x00819499, 0x0088969C, 0x00849298, 0x00829194, 0x007D898D, 0x00738082, 0x00808C8E, 0x00ACB8BA, 0x00D5E1E1, 0x00D2DAD3, 0x00788472, 0x00707F5F, 0x00788A61, 0x0063744F, 0xFFB7C0AB, 0xFFFDFFFC, 0xFFFAF9FF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFDFF, 0xFFFFFFF8, 0x00ACB698, 0x005E6C43, 0x00808D67, 0x007C8864, 0x0078865C, 0x007D8D5D, 0x007A8C63, 0x00778960, 0x0073855C, 0x00798B62, 0x0075875E,
        0x0076885F, 0x007F9168, 0x00798B62, 0x00758465, 0x00788767, 0x007B8C67, 0x0075875E, 0x00778960, 0x006B7D54, 0x00687A51, 0x005D6F48, 0x00596E41, 0x00687C51, 0x00607449, 0x006D8157, 0x00798C65, 0x0072845F, 0x00738560, 0x00728361, 0x0074845B,
        0x006F7F56, 0x0077875E, 0x0075855C, 0x00798960, 0x0077875E, 0x007A8A61, 0x006F7F56, 0x00798A5F, 0x0076875C, 0x005C6D42, 0x004F6035, 0x00526338, 0x005C6D42, 0x00728358, 0x007A8B60, 0x00768861, 0x0070825B, 0x004F613A, 0x004F613A, 0x00354720,
        0x00596B44, 0x005B6D46, 0x00798B64, 0x0075885D, 0x0076885F, 0x00778960, 0x00778960, 0x00778962, 0x00768861, 0x00758661, 0x00748560, 0x00738A5E, 0x006E8559, 0x006A8155, 0x0070845A, 0x0061734E, 0x00374529, 0x001D2913, 0x001E2817, 0x00404A3A,
        0x00444F3B, 0x0027341A, 0x00203011, 0x003E4F2D, 0x00687C59, 0x006C7F5E, 0x006B7D5E, 0x00778464, 0x006C7D52, 0x00475531, 0x004D5445, 0x00555B50, 0x004F5942, 0x00566147, 0x00545B4E, 0x00383E33, 0x00404A33, 0x0035431F, 0x0063714D, 0x003F4C32,
        0x00646E5E, 0x00737C6F, 0x003E4838, 0x0026281C, 0x00212A20, 0x0026372E, 0x003D534E, 0x001F332E, 0x00101D15, 0x001B1E15, 0x004A463B, 0x00586343, 0x003B4324, 0x00293112, 0x00283110, 0x00343B1A, 0x00373E1D, 0x00313714, 0x00343A17, 0x002E3013,
        0x002A2C0F, 0x002C2E11, 0x00333518, 0x002D2F12, 0x00313316, 0x003E4023, 0x0036381B, 0x0031341B, 0x002D3017, 0x0030331A, 0x00363920, 0x0033361D, 0x0032351C, 0x00474A31, 0x0062654C, 0x003F4637, 0x001D2116, 0x00192019, 0x00182A23, 0x003F5B55,
        0x003B564D, 0x0017241C, 0x002B2820, 0x00242920, 0x00585F52, 0x004D5641, 0x00465438, 0x006B7B59, 0x00657651, 0x00697B56, 0x006B7D58, 0x00697B56, 0x006B7D58, 0x006D7F5A, 0x006E805B, 0x006E805B, 0x006E805B, 0x006F815C, 0x0070825D, 0x00718261,
        0x006C7E5F, 0x006D7D5B, 0x007D865E, 0x00767D52, 0x003D4C2D, 0x00638077, 0x0083ADB9, 0x006B96B7, 0x00709DB2, 0x0043685E, 0x00586948, 0x0041503B, 0x00597984, 0x0078A7C2, 0x00689AB0, 0x00739CB2, 0x0051726B, 0x00526845, 0x004B603A, 0x00456056,
        0x0078A0B3, 0x006A9ABE, 0x00689CC1, 0x005F7A88, 0x004D6A5A, 0x00506C4F, 0x002E4946, 0x007395AC, 0x0074A2BA, 0x0071A3B7, 0x005F8EA4, 0x004E6146, 0x00647959, 0x00748865, 0x00586D46, 0x004A5D36, 0x00546641, 0x00475735, 0x00364525, 0x004D5C40,
        0x0045552C, 0x0041552A, 0x00304D36, 0x00466F78, 0x004D7F9B, 0x005991AA, 0x00518895, 0x0047747F, 0x00273F35, 0x00424A39, 0x006F7A77, 0x007F8C94, 0x00D2D9DC, 0x00D3D9D8, 0x00919DA3, 0x0075888D, 0x0075888D, 0x007B8E93, 0x00889BA0, 0x0094A7AC,
        0x0092A5AA, 0x0083969B, 0x0075888D, 0x007A888E, 0x0079878D, 0x00819093, 0x00859195, 0x007C898B, 0x00869294, 0x00AEBABC, 0x00D3DFDF, 0x00D9E0DB, 0x007F8A7A, 0x00788768, 0x00798B62, 0x005E7049, 0xFFB4BEA7, 0xFFFDFFFC, 0xFFFDFCFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFBFF, 0xFFFFFFF9, 0x00ADB799, 0x005D6A44, 0x007D8A64, 0x00808D67, 0x00647347, 0x00637441, 0x005E7047, 0x00687A51, 0x00576940, 0x0066794E, 0x0065784D,
        0x00607447, 0x00596D40, 0x0063774A, 0x00718162, 0x0058664E, 0x00485442, 0x00646E62, 0x00505A4D, 0x003A4634, 0x00324126, 0x003A4A2B, 0x00313B2B, 0x00353F2E, 0x00313D27, 0x00495539, 0x00485634, 0x0057653C, 0x00728155, 0x00819162, 0x0076845B,
        0x00708050, 0x00768952, 0x00758555, 0x00828F69, 0x00727D5D, 0x0075825C, 0x0079895A, 0x0077875E, 0x007A8A61, 0x00798960, 0x0058683F, 0x004E5E35, 0x0058683F, 0x005A6A41, 0x0078885F, 0x00798C61, 0x0073855C, 0x004E6037, 0x004B5D34, 0x00384A23,
        0x0053653E, 0x0061724D, 0x007B8C67, 0x00758760, 0x00758760, 0x00758760, 0x00758760, 0x00758760, 0x0074865F, 0x0073855E, 0x0073855E, 0x00738462, 0x0070835C, 0x0071845D, 0x0069785C, 0x002E3929, 0x00242D23, 0x003B4735, 0x003B4A2E, 0x0058614D,
        0x004F5A46, 0x00384231, 0x00303A29, 0x0024311B, 0x0039482C, 0x006D815E, 0x006C815A, 0x0072865C, 0x00677954, 0x004B5C3B, 0x0049583C, 0x00425136, 0x002D3C20, 0x00223312, 0x002D3F1A, 0x003F5231, 0x00243716, 0x002D3E1C, 0x005B6A4A, 0x004A563A,
        0x006D745F, 0x007F8475, 0x00505147, 0x003B4025, 0x002B3420, 0x001F2A22, 0x002D3A3C, 0x000F1B21, 0x0012191C, 0x001D211C, 0x002A291F, 0x002B371B, 0x003D4C26, 0x00425425, 0x0036471C, 0x002B3719, 0x002D381E, 0x003F4D2B, 0x0055663A, 0x004E5D3D,
        0x00414E36, 0x001C2616, 0x00242822, 0x00222620, 0x00222718, 0x002C341D, 0x00364121, 0x00343623, 0x0030321E, 0x002F321C, 0x0030361F, 0x002F341F, 0x002D3020, 0x002C3025, 0x0030332A, 0x001B2319, 0x001D1F19, 0x001C1D1B, 0x0016211F, 0x00374C49,
        0x002B413C, 0x00152018, 0x002C2921, 0x00252C1F, 0x00545C4B, 0x00606A53, 0x004C5B3B, 0x006D7E59, 0x00687A53, 0x00687B54, 0x00687B54, 0x006C8055, 0x0071855A, 0x006E8258, 0x006E8258, 0x0072855E, 0x0070835C, 0x0070835C, 0x00738560, 0x00738263,
        0x006D7D5B, 0x006B7F55, 0x00738A5E, 0x00708761, 0x0051664D, 0x0067786D, 0x00879895, 0x007698A5, 0x0078979A, 0x00617D70, 0x005F7961, 0x003A543C, 0x006C8A7D, 0x007B9EA1, 0x007CA4B0, 0x008499A1, 0x00526A6A, 0x00526F60, 0x0042624A, 0x0042614C,
        0x0078928C, 0x008FA2AF, 0x008F9EB8, 0x00637F68, 0x0057735F, 0x004D6858, 0x00375046, 0x006E8783, 0x00869D9F, 0x0092AAB0, 0x00637A82, 0x005C6A46, 0x006E7F5A, 0x00748560, 0x005E6F4A, 0x00455732, 0x00495B36, 0x004F643E, 0x003C512B, 0x00435635,
        0x00505E3A, 0x00586642, 0x00354C36, 0x004C7272, 0x00578B9C, 0x00558DA6, 0x005187A0, 0x003F737F, 0x00213C33, 0x003D4737, 0x006F7776, 0x00818D93, 0x00D1D9D9, 0x00CFD8D5, 0x008FA0A3, 0x006E868C, 0x00657D83, 0x006C848A, 0x007A9298, 0x008AA2A8,
        0x008DA5AB, 0x007D959B, 0x00768E94, 0x0078889F, 0x00768697, 0x0082939C, 0x00839596, 0x007D8C88, 0x00889593, 0x00AEB8B8, 0x00D8E1E4, 0x00D4DAD9, 0x007E887B, 0x007B8A6B, 0x00788A61, 0x005D6F48, 0xFFB4BEA7, 0xFFFDFFFB, 0xFFFDFCFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFBF7FF, 0xFFFFFFF9, 0x00ACB698, 0x005E6B45, 0x00818E68, 0x007F8C66, 0x004F5E32, 0x00394A17, 0x0031431A, 0x002F4118, 0x0032441B, 0x0035481D, 0x002C3F14,
        0x00304417, 0x00314518, 0x00364A1D, 0x006F805F, 0x00526146, 0x004E5A48, 0x00767F75, 0x00A2ABA1, 0x00ADB7AB, 0x00B0BCAA, 0x00AFBCA6, 0x00B3BBB1, 0x00B7C0B3, 0x00A3AD9C, 0x005C6550, 0x00394529, 0x004D5837, 0x007B8862, 0x00707E55, 0x007C8864,
        0x007D8D5E, 0x007E905B, 0x00778757, 0x00798660, 0x00798463, 0x007E8C63, 0x007C8D5A, 0x0078885F, 0x006C7C53, 0x007E8E65, 0x0078885F, 0x005B6B42, 0x0054643B, 0x0054643B, 0x0057673E, 0x00708358, 0x0072845B, 0x0055673E, 0x00506239, 0x00384A23,
        0x00556740, 0x0062734E, 0x007A8B66, 0x00758760, 0x00758760, 0x00758760, 0x00758760, 0x00758760, 0x0074865F, 0x0073855E, 0x0073855E, 0x0070815F, 0x0073865F, 0x006F825B, 0x0048573B, 0x00263121, 0x003E473D, 0x00414D3B, 0x0037462A, 0x004F5843,
        0x0046513D, 0x003B4534, 0x003B4632, 0x00293620, 0x0029381C, 0x00516443, 0x00687D57, 0x00687C52, 0x00778964, 0x00677758, 0x005F6D55, 0x0064725A, 0x0067765B, 0x00637453, 0x003D4F2A, 0x00536645, 0x00435635, 0x00556644, 0x00697858, 0x004D593D,
        0x00707762, 0x00727768, 0x0048493F, 0x00393D24, 0x002C3423, 0x00242F27, 0x00323F41, 0x00111D21, 0x00101818, 0x00171B16, 0x00222018, 0x00141B0C, 0x002F3922, 0x003B4828, 0x002A361A, 0x00141C0B, 0x00141B0E, 0x00323B26, 0x00556143, 0x006B7B59,
        0x004C593F, 0x00162010, 0x00191E15, 0x001E221C, 0x0022261B, 0x00232916, 0x00222A13, 0x00252812, 0x002A2D17, 0x002F331A, 0x002B311A, 0x00232714, 0x001A1E12, 0x001A1C16, 0x001E1F1D, 0x001A2218, 0x001C1E18, 0x001C1D1B, 0x0016211F, 0x00384D4A,
        0x002C423D, 0x00141F17, 0x0029261E, 0x002D3427, 0x005D6554, 0x00616B54, 0x004B5A3A, 0x006E7F5A, 0x00687A53, 0x006B7E57, 0x006B7E57, 0x006B7F54, 0x006C8055, 0x006C8056, 0x006F8359, 0x0070835C, 0x006B7E57, 0x006B7D58, 0x006E805B, 0x00768462,
        0x0076855F, 0x0072845B, 0x0073875D, 0x00718562, 0x004E6146, 0x003A4C3B, 0x002E3E33, 0x003C534E, 0x004C6355, 0x00566950, 0x00748363, 0x00556645, 0x00657A61, 0x00506A5C, 0x0044635C, 0x006A7872, 0x00556658, 0x0062775E, 0x00516848, 0x003C5235,
        0x00576A55, 0x006B7A72, 0x00717D7D, 0x00495B3E, 0x00586B50, 0x0060735A, 0x00465742, 0x00526453, 0x00536457, 0x005F7065, 0x0046574E, 0x0055633F, 0x0071825D, 0x0071825D, 0x005C6D48, 0x00566843, 0x004B5D38, 0x003D522C, 0x004E633D, 0x00485B3A,
        0x005F6D49, 0x00566440, 0x00374E38, 0x00527878, 0x00538798, 0x00548CA5, 0x004E849D, 0x00447884, 0x00254037, 0x00414B3B, 0x00717978, 0x00818D93, 0x00D1D9D9, 0x00D0D9D6, 0x0091A2A5, 0x0083969D, 0x0082959C, 0x008A9DA4, 0x008C9FA6, 0x008EA1A8,
        0x008EA1A8, 0x00899CA3, 0x008B9EA5, 0x008394A7, 0x0080919E, 0x008799A0, 0x00819394, 0x00798785, 0x00869391, 0x00ABB4B7, 0x00D4DADF, 0x00D1D8D3, 0x00778272, 0x00728162, 0x007A8C63, 0x00667851, 0xFFB7C1AA, 0xFFFCFFFA, 0xFFFBFBFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFDF9FF, 0xFFFFFFF9, 0x00ABB597, 0x005C6943, 0x00818E68, 0x00818E68, 0x004C5B2F, 0x002F400D, 0x0051633A, 0x0052643B, 0x00475930, 0x00203308, 0x0035481D,
        0x00475B2E, 0x00304417, 0x0035491C, 0x006E7E5C, 0x004A583C, 0x00545E4E, 0x0099A099, 0x00EAEFEE, 0x00ECF1EF, 0x00EBF1EC, 0x00E8F0E6, 0x00E5EAE9, 0x00ECF1EF, 0x00C9D0C9, 0x005D6457, 0x005C6551, 0x00545D43, 0x00687254, 0x006F7A5A, 0x00656D56,
        0x005C6746, 0x00556339, 0x005E6C43, 0x00606B4A, 0x00606B4B, 0x005B6940, 0x005D6E3B, 0x0078885F, 0x00718158, 0x00728259, 0x0077875E, 0x00708057, 0x005B6B42, 0x004F5F36, 0x0054643B, 0x005C6F44, 0x0064764D, 0x0052643B, 0x004F6138, 0x0034461F,
        0x0053653E, 0x0061724D, 0x00778863, 0x00758760, 0x00758760, 0x00758760, 0x00758760, 0x00758760, 0x0074865F, 0x0074865F, 0x0073855E, 0x0070815F, 0x0073865F, 0x00687B54, 0x002A391D, 0x002B3626, 0x00565F55, 0x003C4836, 0x002E3D21, 0x00364029,
        0x002C3822, 0x00303B27, 0x00404B37, 0x0035422C, 0x0028371C, 0x003C4F2E, 0x006D815E, 0x0073875D, 0x006C7D5B, 0x005B6A4F, 0x006C7864, 0x006A7662, 0x0047553D, 0x005B6B4C, 0x00495B36, 0x00526544, 0x00455837, 0x00637452, 0x005E6D4D, 0x00354125,
        0x00676E59, 0x00676C5D, 0x00323329, 0x00212310, 0x001F2617, 0x00232D27, 0x003A4847, 0x001A2729, 0x00141C1C, 0x00151914, 0x001A1810, 0x001D201E, 0x0022271E, 0x001E2516, 0x00171D12, 0x00171B16, 0x001C1F1D, 0x00252923, 0x0030372A, 0x00647550,
        0x0048563A, 0x00151F0E, 0x00171C13, 0x001E221D, 0x00262822, 0x00282C21, 0x00272B1F, 0x00262A11, 0x00353920, 0x003E442B, 0x00383E27, 0x00262C1B, 0x00191D12, 0x00181917, 0x00191B1C, 0x00182016, 0x001A1B17, 0x001A1B19, 0x00172121, 0x003A4F4D,
        0x002D433E, 0x00121C16, 0x00242119, 0x00242B1E, 0x005A6251, 0x0059634C, 0x00465535, 0x006E7F5A, 0x00687A53, 0x006D8059, 0x006D8059, 0x006B7F55, 0x00697D53, 0x006C8056, 0x006E815A, 0x006D8059, 0x006B7D58, 0x006C7E59, 0x0070825D, 0x00717F55,
        0x00728057, 0x0075855C, 0x007A8864, 0x006E7E5C, 0x00465637, 0x00324126, 0x002D3B23, 0x00344425, 0x00475232, 0x0059603B, 0x0082855E, 0x00686D46, 0x005E6943, 0x00384727, 0x002E4323, 0x00555D46, 0x005E674C, 0x00747F5E, 0x0065724C, 0x00414F26,
        0x003B4822, 0x00404B2A, 0x00434D2F, 0x00485130, 0x00687150, 0x00777F60, 0x005C6747, 0x00475133, 0x00354123, 0x003C482A, 0x00333F23, 0x0054623E, 0x0070815C, 0x0070815C, 0x00677853, 0x004C5E39, 0x00455732, 0x00596E48, 0x00445933, 0x00485B3A,
        0x0063714D, 0x004B5935, 0x00304731, 0x004F7575, 0x004F8394, 0x00568EA7, 0x005288A1, 0x00447884, 0x00254037, 0x00424C3C, 0x00727A79, 0x007F8B91, 0x00CFD7D7, 0x00D2DBD8, 0x0093A4A7, 0x0091A3AA, 0x0090A2A9, 0x0094A6AD, 0x0092A4AB, 0x0094A6AD,
        0x009BADB4, 0x0099ABB2, 0x009CAEB5, 0x0096A8B3, 0x0090A3AA, 0x0090A3A6, 0x00819190, 0x00748281, 0x00889494, 0x00B4BDC1, 0x00DDE3E8, 0x00DEE7DD, 0x00818D7B, 0x00707F60, 0x00798B64, 0x00667752, 0xFFB4BEA7, 0xFFFCFFFA, 0xFFFDFDFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFAFF, 0xFFFFFFF9, 0x00ACB698, 0x005C6943, 0x007E8B65, 0x007E8B65, 0x00526135, 0x0040511E, 0x006A7A51, 0x00607047, 0x005D6D44, 0x0034451A, 0x005D6E43,
        0x006B7C50, 0x003C4D21, 0x003C4D21, 0x00677853, 0x004E5C40, 0x00545E4E, 0x00AAAFAD, 0x00E4E7EB, 0x00D0D3D8, 0x00C6C9CD, 0x00BABEBF, 0x00D3D6DB, 0x00DCDFE3, 0x00D6DBDA, 0x00686C66, 0x00474E41, 0x00414736, 0x00515843, 0x00424A33, 0x00575854,
        0x00535849, 0x003B442A, 0x003A4329, 0x00363C29, 0x003C422F, 0x003A4426, 0x004D5B32, 0x0073835A, 0x0076865D, 0x006C7C53, 0x0074845B, 0x007F8F66, 0x006E7E55, 0x005C6C43, 0x0053633A, 0x004E6136, 0x0051633A, 0x00485A31, 0x004E6037, 0x0034461F,
        0x0053653E, 0x0061724D, 0x00798A65, 0x0074865F, 0x0074865F, 0x00758760, 0x00758760, 0x00758760, 0x00758760, 0x0074865F, 0x0074865F, 0x00748563, 0x0073865F, 0x005C6F48, 0x00243317, 0x00424D3D, 0x005A6359, 0x002C3826, 0x00253418, 0x00303B21,
        0x0026331B, 0x002A3521, 0x003B4632, 0x003D4A34, 0x002F3E23, 0x00293B1C, 0x00617453, 0x0070845A, 0x00687958, 0x00414E38, 0x00465141, 0x00485245, 0x0025311D, 0x00516044, 0x00495B36, 0x005E7150, 0x00425534, 0x00637452, 0x00687757, 0x003E4A2E,
        0x006A715C, 0x006F7465, 0x0035362C, 0x0018180A, 0x00161C11, 0x001A241E, 0x002F3D3B, 0x00111F1E, 0x00121A19, 0x001A1E19, 0x0024211C, 0x001F2220, 0x001F231E, 0x001B1F19, 0x001C201A, 0x00242725, 0x00242725, 0x001E221D, 0x001C201A, 0x004C5C3A,
        0x003C4A2E, 0x0018230F, 0x001B2116, 0x001C201B, 0x00212220, 0x001F201E, 0x001F201C, 0x00242A11, 0x00363C23, 0x00444A31, 0x003B422D, 0x00292E1F, 0x001C1E18, 0x0017191A, 0x0018181E, 0x00171E17, 0x00181915, 0x00191919, 0x00182222, 0x003C514F,
        0x002E4340, 0x00101A14, 0x001F1B16, 0x00181F12, 0x00555D4C, 0x00566049, 0x00465535, 0x0070815C, 0x00687A53, 0x006C7F58, 0x006A7D56, 0x006C8056, 0x006A7E54, 0x006F825B, 0x006D8059, 0x006B7D58, 0x0071835E, 0x00738560, 0x00758762, 0x007C8B5F,
        0x00728056, 0x00717E58, 0x0077835F, 0x00717F5D, 0x005B6947, 0x00546240, 0x00586642, 0x00657147, 0x00687248, 0x00656A43, 0x007D8059, 0x006D7049, 0x00656D45, 0x004D5B31, 0x00516439, 0x004B5635, 0x005C6746, 0x006D7857, 0x006B7753, 0x005A6741,
        0x00515F35, 0x00556536, 0x00546434, 0x005B6142, 0x00717758, 0x00737B5C, 0x006C7554, 0x005A6642, 0x0056623E, 0x0056653F, 0x00505F39, 0x005C6A46, 0x00758661, 0x0072835E, 0x00556641, 0x004A5C37, 0x004F613C, 0x004D623C, 0x004A5F39, 0x003D502F,
        0x00515F3B, 0x003F4D29, 0x002A412B, 0x00486E6E, 0x00518596, 0x00578FA8, 0x005389A2, 0x003D717D, 0x001E3930, 0x003E4838, 0x00707877, 0x007C888E, 0x00CED6D6, 0x00D3DCD9, 0x0093A4A7, 0x008D9AA2, 0x008C99A1, 0x00919EA6, 0x00909DA5, 0x0097A4AC,
        0x00A3B0B8, 0x00A0ADB5, 0x009EABB3, 0x0099ADB2, 0x0099ACAF, 0x009AACAD, 0x00879698, 0x007B8988, 0x00969FA2, 0x00C1C8CB, 0x00E3EAED, 0x00D1DCCC, 0x0085927C, 0x00748363, 0x00788964, 0x0061714F, 0xFFABB49F, 0xFFFCFFFA, 0xFFFDFEFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFDF9FF, 0xFFFDFFF7, 0x00AAB496, 0x005F6C46, 0x007F8C66, 0x0077845E, 0x004D5C30, 0x00425320, 0x00596940, 0x0034441B, 0x005A6A41, 0x0056673C, 0x0068794E,
        0x006B7C50, 0x00435428, 0x0036471B, 0x0072835E, 0x00657357, 0x005D6757, 0x00B6BBBA, 0x00D9DBE3, 0x00CDCED8, 0x00C9CBD3, 0x00B8BBC0, 0x00C3C5CD, 0x00D2D5DA, 0x00CFD3D4, 0x008B8F8A, 0x00797F74, 0x00666B5C, 0x00585E4B, 0x00636A55, 0x008C8992,
        0x00848583, 0x0054584C, 0x0055594D, 0x0083857F, 0x00A1A39D, 0x00707665, 0x004B5439, 0x00798960, 0x0075855C, 0x0076865D, 0x007A8A61, 0x00708057, 0x0074845B, 0x0078885F, 0x0054643B, 0x00506338, 0x0046582F, 0x0042542B, 0x0052643B, 0x003A4C25,
        0x00576942, 0x0063744F, 0x007E8F6A, 0x0074865F, 0x0074865F, 0x00758760, 0x00758760, 0x00758760, 0x00758760, 0x0074865F, 0x0074865F, 0x00758664, 0x00768962, 0x0052653E, 0x0027361A, 0x00556050, 0x00525B51, 0x0024301E, 0x00223115, 0x00313D21,
        0x002D3A20, 0x002B3721, 0x00333E2A, 0x003C4834, 0x0037452D, 0x00213316, 0x00556748, 0x006E8258, 0x006F805F, 0x00465240, 0x005D665C, 0x007A827B, 0x004F5A4A, 0x0057664A, 0x00455732, 0x00586B4A, 0x00415433, 0x00546543, 0x00627151, 0x00495539,
        0x00606752, 0x00616657, 0x00303127, 0x001A1810, 0x00191D17, 0x001C2522, 0x002E3C3A, 0x000E1C1A, 0x00101916, 0x00191D18, 0x0023201C, 0x00171D12, 0x001C2118, 0x001F231D, 0x00242920, 0x002A3025, 0x00262C21, 0x001E231A, 0x001C201A, 0x00313F23,
        0x002C3921, 0x0016200F, 0x00191F14, 0x00181C17, 0x001B1B1B, 0x00131214, 0x00111012, 0x001F240F, 0x002E331E, 0x00373E29, 0x00333926, 0x00272B1F, 0x001C201A, 0x00181A1B, 0x0016161C, 0x00161D16, 0x00181915, 0x00191919, 0x00182222, 0x003D5250,
        0x002F4441, 0x000F1913, 0x001D1914, 0x001B2215, 0x00596150, 0x005F6952, 0x004C5B3B, 0x0070815C, 0x00687A53, 0x006B7E57, 0x00687B54, 0x006A7D56, 0x006D8059, 0x00748760, 0x006C7E59, 0x006C7E59, 0x00758762, 0x006F805E, 0x006B7C5A, 0x00718257,
        0x0077875E, 0x007C8B65, 0x007A8864, 0x00788460, 0x007D8965, 0x007C8A61, 0x007A885E, 0x00809067, 0x00808D67, 0x00747F5E, 0x007F8768, 0x00778262, 0x007A8866, 0x0072845D, 0x007B9167, 0x00758665, 0x007A8A6B, 0x0078876B, 0x0077866A, 0x00748564,
        0x00738560, 0x00788C61, 0x00768C5C, 0x00748169, 0x007A876D, 0x00718065, 0x00768667, 0x00768766, 0x007C906D, 0x007B906A, 0x00748963, 0x00707E5A, 0x0072835E, 0x00596A45, 0x00556641, 0x004B5D38, 0x003E502B, 0x004E633D, 0x004A5F39, 0x00374A29,
        0x003F4D29, 0x00404E2A, 0x002E452F, 0x00436969, 0x00568A9B, 0x00538BA4, 0x004E849D, 0x003B6F7B, 0x001B362D, 0x003D4737, 0x00707877, 0x007C888E, 0x00CED6D6, 0x00D3DCD9, 0x0092A3A6, 0x00849199, 0x0089969E, 0x0093A0A8, 0x0094A1A9, 0x0098A5AD,
        0x009EABB3, 0x0099A6AE, 0x0096A3AB, 0x0099ADAE, 0x009BAFB0, 0x00A4B5B8, 0x009CA9AB, 0x00929EA0, 0x009DA7A7, 0x00A8B1AE, 0x00B0B7B4, 0x009BA892, 0x00758469, 0x00768565, 0x007B8C67, 0x00606F50, 0xFFA7B09C, 0xFFFBFFF9, 0xFFFDFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFBFF, 0xFBF9FCF3, 0x00A3AD8F, 0x005D6A44, 0x00828F69, 0x007A8761, 0x004D5C30, 0x0041521F, 0x006B7950, 0x00546239, 0x00637148, 0x00536137, 0x00616F45,
        0x00707F53, 0x004B5A2E, 0x003B4A1E, 0x006C7A58, 0x00576347, 0x00555C4F, 0x00AEB1AF, 0x00DEDEE4, 0x00D5D4DD, 0x00D5D5DB, 0x00D5D6DA, 0x00D1D4D9, 0x00E3E7E8, 0x00C0C5C3, 0x008D918B, 0x00A8AFA2, 0x00777D6A, 0x004B533C, 0x00838C72, 0x0099989A,
        0x008C8F86, 0x00616756, 0x00696E5F, 0x00A8AAA4, 0x00BEC0BA, 0x0084897A, 0x00545C45, 0x006A7A51, 0x0077875E, 0x007B8B62, 0x0075855C, 0x006C7C53, 0x0076865D, 0x007F8F66, 0x0065754C, 0x0054673C, 0x00405229, 0x003F5128, 0x0053653C, 0x00394B24,
        0x00556740, 0x005F704B, 0x00798A65, 0x0073855E, 0x0074865F, 0x0074865F, 0x00758760, 0x00758760, 0x00758760, 0x00758760, 0x00758760, 0x00718260, 0x007A8D66, 0x004F623B, 0x00233216, 0x00586353, 0x004A5349, 0x00273321, 0x00243317, 0x00273315,
        0x002D3B1F, 0x002A371F, 0x002E3925, 0x00394531, 0x003D4A34, 0x0026371C, 0x005B6D50, 0x0071855B, 0x00708061, 0x00606B5B, 0x00ACB3B0, 0x00D0D7D4, 0x007C867A, 0x00505F44, 0x0052643F, 0x004A5D3C, 0x00586B4A, 0x00566745, 0x00455434, 0x00475337,
        0x006D745F, 0x00656A5B, 0x00313228, 0x00181413, 0x001B1E1C, 0x00222B28, 0x00364541, 0x00162521, 0x00151E1B, 0x00181B19, 0x001D1A16, 0x001C2413, 0x001A2015, 0x00161A15, 0x001C201A, 0x00262D1E, 0x00232B1A, 0x00192013, 0x00151913, 0x001B2514,
        0x00232D1C, 0x001C2518, 0x001D2219, 0x00161A15, 0x001A1A1A, 0x00181719, 0x00201F23, 0x001E2014, 0x00252A1B, 0x002B3120, 0x002B3120, 0x00242B1E, 0x001E231A, 0x00191E1C, 0x00171B1C, 0x00171D18, 0x00181917, 0x0019181A, 0x00172023, 0x003C5051,
        0x002E4341, 0x000E1714, 0x001D1815, 0x001A2114, 0x00545C4B, 0x00656F58, 0x004C5B3B, 0x00687954, 0x00677952, 0x006B7E57, 0x006C7F58, 0x00677A53, 0x006D8059, 0x00768863, 0x006D7F5A, 0x0070825D, 0x00728361, 0x005D6E4C, 0x00576846, 0x004F603F,
        0x00576847, 0x00687957, 0x0073855E, 0x006F7E58, 0x0073835A, 0x00748259, 0x007A885F, 0x006E7F5D, 0x0070815F, 0x006C7C5D, 0x006F8162, 0x006D7F60, 0x00728465, 0x006D8360, 0x00718764, 0x00708565, 0x00708467, 0x006C8063, 0x006C7F64, 0x006D8164,
        0x006E8363, 0x006F8562, 0x006D845E, 0x0072826A, 0x0074856A, 0x006A7D62, 0x006C8063, 0x006D8464, 0x00708767, 0x00718967, 0x0067805E, 0x00788662, 0x005D6E49, 0x0053643F, 0x0050613C, 0x003D4F2A, 0x0041532E, 0x004F643E, 0x00435832, 0x00445736,
        0x0043512D, 0x0044522E, 0x00314832, 0x003D6363, 0x00568A9B, 0x00538BA4, 0x004F859E, 0x00407480, 0x001D382F, 0x003E4838, 0x00717978, 0x007B878D, 0x00CED6D6, 0x00D4DDDA, 0x0091A2A5, 0x00798B92, 0x00788A91, 0x0081939A, 0x00889AA1, 0x0092A4AB,
        0x0098AAB1, 0x008B9DA4, 0x0083959C, 0x00899C9F, 0x008D9DA3, 0x009FADB3, 0x00A7B3B7, 0x00A8B4B4, 0x00A6B0AA, 0x008C968A, 0x00727D6D, 0x0078876C, 0x006F7F60, 0x007B8B69, 0x007F8F6D, 0x00616F53, 0xFFA6AE9D, 0xFFFDFFFB, 0xFFFDFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFBFF, 0xFFFBFEF5, 0x00A2AC8E, 0x005B6842, 0x0083906A, 0x00808D67, 0x00505F33, 0x003F501D, 0x00647249, 0x006A784F, 0x00536138, 0x00324016, 0x00435127,
        0x0059683C, 0x0038471B, 0x0038471B, 0x00697656, 0x005F6A50, 0x007F8679, 0x00A6A9A7, 0x00ECEDF1, 0x00DDDEE2, 0x00D4D6D6, 0x00DDE0DE, 0x00D3D8D7, 0x00E2E7E5, 0x00CED5CE, 0x006B7265, 0x006A735F, 0x00525B41, 0x00596345, 0x00636E4E, 0x00575D4A,
        0x005E684A, 0x00586440, 0x00505B3B, 0x005F6651, 0x00606655, 0x00687157, 0x00798463, 0x004E5E35, 0x00697950, 0x0074845B, 0x0077875E, 0x007D8D64, 0x007C8C63, 0x0073835A, 0x0068784F, 0x00516439, 0x003D4F26, 0x0041532A, 0x0053653C, 0x00354720,
        0x0054663F, 0x005D6E49, 0x00758661, 0x0073855E, 0x0073855E, 0x0074865F, 0x00758760, 0x00758760, 0x00758760, 0x00758760, 0x00758760, 0x00728361, 0x00788B64, 0x0052653E, 0x00202F13, 0x00556050, 0x00464F45, 0x0025311F, 0x00243317, 0x00263313,
        0x002D3B1F, 0x0027341C, 0x002F3A26, 0x00394531, 0x00394630, 0x0022321A, 0x005A6B50, 0x0075895F, 0x006B7A5E, 0x00465044, 0x0074797A, 0x00888D8E, 0x00596258, 0x0044523A, 0x0071835E, 0x00465938, 0x00516443, 0x00536442, 0x00384727, 0x004A563A,
        0x00818873, 0x006C7162, 0x00303127, 0x001C1719, 0x001C1E1F, 0x001F2726, 0x002F3E3A, 0x0011211A, 0x00141E18, 0x001C1F1D, 0x00221E1D, 0x001A2015, 0x001C1F1D, 0x00191A1E, 0x00191B1C, 0x00191E15, 0x00141B0E, 0x00121610, 0x0018191D, 0x00171E17,
        0x00242C22, 0x00232B21, 0x0020251C, 0x00141812, 0x001A1B19, 0x001B1B1B, 0x00272628, 0x00191A16, 0x001C1E18, 0x0021251A, 0x0022291C, 0x001F2619, 0x00192116, 0x00171E17, 0x00171D18, 0x00181E19, 0x00191A18, 0x001A191B, 0x00172023, 0x003B4F50,
        0x002D4240, 0x000F1815, 0x001F1A17, 0x00171E11, 0x004E5645, 0x006E7861, 0x00516040, 0x00647550, 0x00687A53, 0x006B7E57, 0x006F825B, 0x006B7E57, 0x006D7F5A, 0x0072845F, 0x006C7E59, 0x00748563, 0x006C7D5B, 0x004D5E3D, 0x004E5F3E, 0x00566954,
        0x004A5F46, 0x00576C4B, 0x0073895F, 0x00778B60, 0x00798B62, 0x006F7E58, 0x00748260, 0x00778563, 0x00758563, 0x00758762, 0x00748963, 0x0070855F, 0x00738862, 0x00738764, 0x00748563, 0x0070825D, 0x006F815C, 0x00748661, 0x00758762, 0x00738462,
        0x00738463, 0x00718162, 0x006F7F60, 0x0073845F, 0x00778863, 0x00768762, 0x00738560, 0x00788A65, 0x00738764, 0x00788C69, 0x006E825F, 0x0065734F, 0x0052633E, 0x00596A45, 0x0032431E, 0x00465833, 0x005B6D48, 0x002A3F19, 0x00536842, 0x00495C3B,
        0x004F5D39, 0x0044522E, 0x00344B35, 0x00416767, 0x00548899, 0x00558DA6, 0x005389A2, 0x00427682, 0x001C372E, 0x003B4535, 0x006D7574, 0x0078848A, 0x00CDD5D5, 0x00D6DFDC, 0x0092A3A6, 0x0074878E, 0x006B7E85, 0x0070838A, 0x007D9097, 0x008EA1A8,
        0x0095A8AF, 0x008699A0, 0x007D9097, 0x007E9097, 0x007E8D96, 0x008F9BA5, 0x009EA9B1, 0x00ABB5B5, 0x00A9B4AA, 0x008A9682, 0x006B785E, 0x00778867, 0x00748564, 0x007C8C6A, 0x007D8C6C, 0x00606D53, 0xFFA5AD9C, 0xFFFDFFFB, 0xFFFDFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFCF8FF, 0xFFFCFFF6, 0x00A7B193, 0x005D6A44, 0x00828F69, 0x007E8B65, 0x0049582C, 0x0031420F, 0x00344219, 0x0039471E, 0x00344219, 0x00344218, 0x002D3B11,
        0x00354418, 0x0029380C, 0x0039481C, 0x00677454, 0x00838D76, 0x00C2C9BC, 0x00969A95, 0x00E6E8E8, 0x00E1E3E3, 0x00D0D4CF, 0x00C9CEC5, 0x00D0D6D1, 0x00D9E1D7, 0x00CFD8CB, 0x00656D5C, 0x007F8972, 0x00646E50, 0x007B8665, 0x0077835F, 0x0076845B,
        0x00748454, 0x00768952, 0x006D7D4D, 0x007A8662, 0x00717C5C, 0x0066724E, 0x00505F33, 0x0056663D, 0x00516138, 0x00697950, 0x007B8B62, 0x0075855C, 0x0078885F, 0x0078885F, 0x00627249, 0x004F6237, 0x00405229, 0x00485A31, 0x00576940, 0x00374922,
        0x00596B44, 0x0063744F, 0x00798A65, 0x0073855E, 0x0073855E, 0x0074865F, 0x00758760, 0x00758760, 0x00758760, 0x00758760, 0x00758760, 0x00768765, 0x0073865F, 0x00556841, 0x00213014, 0x00545F4F, 0x00434C42, 0x001E2A18, 0x00223115, 0x00273414,
        0x00273617, 0x001E2B13, 0x00313D27, 0x003D4935, 0x00394630, 0x00213119, 0x005B6C51, 0x0073875D, 0x0069785C, 0x004E574D, 0x007D8285, 0x00808489, 0x00525A53, 0x00324028, 0x006A7C57, 0x00596C4B, 0x00324524, 0x004B5C3A, 0x00556444, 0x00667256,
        0x008C937E, 0x00676C5D, 0x00313228, 0x00191219, 0x001A1B1F, 0x001E2625, 0x002F3F38, 0x0011211A, 0x00121C16, 0x00171A18, 0x001A1615, 0x001A1E19, 0x0018181E, 0x00141120, 0x0016151F, 0x001A1D1B, 0x00171B15, 0x00151718, 0x001B1827, 0x00141918,
        0x001B201E, 0x00151B16, 0x00171B15, 0x00161A14, 0x0022231F, 0x001C1D1B, 0x00202020, 0x001C1B1D, 0x001D1D1D, 0x001F231D, 0x0023291E, 0x0021281B, 0x00192215, 0x00182015, 0x001C241A, 0x00191F1A, 0x001A1B19, 0x001A191B, 0x00172023, 0x00394D4E,
        0x002C413F, 0x000F1815, 0x00201B18, 0x001D2417, 0x00525A49, 0x007D8770, 0x005E6D4D, 0x00697A55, 0x006C7E57, 0x006A7D56, 0x006D8059, 0x0071835E, 0x006C7E59, 0x006C7E59, 0x006A7C57, 0x00768765, 0x00697A58, 0x00475837, 0x00526342, 0x003C5043,
        0x00445943, 0x005A7250, 0x006C8559, 0x00687F52, 0x0075895E, 0x0070805E, 0x00748364, 0x007D8461, 0x0078835D, 0x0076875C, 0x0073875A, 0x006F8356, 0x00708358, 0x00788761, 0x00788460, 0x0078865C, 0x00728155, 0x0079885C, 0x0077865A, 0x00738157,
        0x00788460, 0x00788363, 0x007B8469, 0x007A8656, 0x00798658, 0x007A8759, 0x00727F53, 0x007A885E, 0x00728057, 0x0074845B, 0x0065754C, 0x00515F3B, 0x005D6E49, 0x002C3D18, 0x004B5C37, 0x00596B46, 0x00334520, 0x004A5F39, 0x004A5F39, 0x003A4D2C,
        0x0052603C, 0x0042502C, 0x003E553F, 0x00507676, 0x00578B9C, 0x00568EA7, 0x0050869F, 0x00407480, 0x00163128, 0x00343E2E, 0x00676F6E, 0x00737F85, 0x00CCD4D4, 0x00D7E0DD, 0x0094A5A8, 0x0080989E, 0x007A9298, 0x00829AA0, 0x008BA3A9, 0x0095ADB3,
        0x0098B0B6, 0x0090A8AE, 0x0091A9AF, 0x0098A6B2, 0x008D9BA7, 0x00909CA8, 0x00939EA6, 0x0099A3A3, 0x009BA89A, 0x0087967B, 0x00728260, 0x00768765, 0x00728361, 0x00758563, 0x00798868, 0x005F6C52, 0xFFA3AB9A, 0xFFFDFFFB, 0xFFF9FBFB, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFDFF, 0xFFFEFFF7, 0x009EA88A, 0x00606E45, 0x007F8C66, 0x00788460, 0x00657349, 0x004C5C2C, 0x004B5B32, 0x004D5D34, 0x004B5B32, 0x004B5B32, 0x004C5C33,
        0x0047572E, 0x0044542B, 0x004C5C33, 0x006C7D51, 0x00627348, 0x00899773, 0x007F8B6D, 0x008A967A, 0x008B977B, 0x00717D5F, 0x00879474, 0x006A7658, 0x00748062, 0x00869171, 0x006B7655, 0x005C6642, 0x00616C46, 0x007F8A62, 0x007E875F, 0x007B8E63,
        0x0075885D, 0x0074875C, 0x0077875E, 0x0076855F, 0x007B8862, 0x0077835F, 0x00697551, 0x004B5B32, 0x005D6D44, 0x004F5F36, 0x006E7E55, 0x007C8C63, 0x007B8B62, 0x007A8A61, 0x0067774E, 0x0050623B, 0x0042542D, 0x00475932, 0x0050623B, 0x003B4D26,
        0x00566841, 0x0061734C, 0x00768861, 0x0073855C, 0x0073855C, 0x0074865D, 0x0074865D, 0x0074865D, 0x0074865D, 0x0073855C, 0x0073855C, 0x00748661, 0x00778867, 0x00505F43, 0x00222F19, 0x004E5A46, 0x00485442, 0x00283420, 0x0024311B, 0x0029321E,
        0x002A371D, 0x00243314, 0x002F3C24, 0x003D473A, 0x00343E32, 0x00304028, 0x003F5330, 0x004F5D3B, 0x004B563C, 0x00545B4C, 0x00A4A9A0, 0x00BDC2B9, 0x006A7162, 0x00404B31, 0x004C5A38, 0x004C5A42, 0x00435237, 0x003F4D31, 0x00485738, 0x005D6B4F,
        0x006D7760, 0x00555D4C, 0x00282F20, 0x00211710, 0x001A1E18, 0x0022332F, 0x00384847, 0x00181F22, 0x001D1A1C, 0x001C1A19, 0x00191D18, 0x00181D1B, 0x00151B16, 0x00181F18, 0x001C2118, 0x00161B12, 0x00151914, 0x001B1B1B, 0x001C1B1D, 0x001B1B1B,
        0x00171816, 0x001A1C16, 0x001A1D14, 0x00161910, 0x00191C13, 0x001E201A, 0x001C1D19, 0x001B1B21, 0x001B1D1D, 0x00282D24, 0x001F2617, 0x001F2716, 0x00192011, 0x00191E15, 0x00191C1A, 0x00161A1B, 0x001B1D17, 0x001C2015, 0x0017231D, 0x003B4F50,
        0x00304445, 0x00111C14, 0x001E1E0C, 0x001F2213, 0x005C624F, 0x006B745A, 0x00556242, 0x0070815C, 0x00697C55, 0x006B8059, 0x00637852, 0x006D7A5A, 0x0071815F, 0x00748560, 0x0072845D, 0x006A7D56, 0x00516240, 0x00445637, 0x00607156, 0x00526348,
        0x004E6041, 0x00627351, 0x0071845D, 0x0074865D, 0x0073855C, 0x0070825B, 0x00788662, 0x0071835E, 0x0071835E, 0x0071835E, 0x0071835E, 0x0071835E, 0x0071835E, 0x0071835E, 0x0071835E, 0x00748563, 0x00748563, 0x00748563, 0x00748563, 0x00738462,
        0x00728361, 0x00718260, 0x0070815F, 0x006F805B, 0x00758661, 0x00768762, 0x00748560, 0x00798A65, 0x00748560, 0x00667752, 0x00495A35, 0x005E6F4A, 0x002C3D18, 0x0041532E, 0x005A6C47, 0x0030451F, 0x00425731, 0x005D744E, 0x001D340E, 0x00465E40,
        0x003F502E, 0x00303F19, 0x002F452C, 0x004B706C, 0x0055899A, 0x004A859F, 0x00558FAC, 0x003E7185, 0x001E3936, 0x00495346, 0x00697472, 0x0098A6AC, 0x00D5DCDF, 0x00CFD8DB, 0x0097A7B3, 0x008F9CA4, 0x0094A1A9, 0x008F9CA4, 0x0097A4AC, 0x009CA9B1,
        0x009CA9B1, 0x00A4B1B9, 0x00A1AEB6, 0x00A6AEB5, 0x009FAAA8, 0x00929F97, 0x008C9A94, 0x00909C9C, 0x0098A5A3, 0x00798C7B, 0x006C8466, 0x00728263, 0x00778867, 0x0073845F, 0x00788964, 0x00606F4F, 0xFFA4AD98, 0xFFFDFFF8, 0xFFF7FAF8, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFDFF, 0xFFFEFFF7, 0x009DA789, 0x00606E45, 0x007D8A64, 0x007C8864, 0x007A885E, 0x00768656, 0x007E8E65, 0x007B8B62, 0x0077875E, 0x0078885F, 0x007C8C63,
        0x007C8C63, 0x007A8A61, 0x007B8B62, 0x007F925F, 0x006B7D4E, 0x00708156, 0x006B7A54, 0x0075845E, 0x00718158, 0x006D7E53, 0x00839468, 0x00778561, 0x006A7854, 0x006A7854, 0x006C7953, 0x00707E55, 0x00717C54, 0x0079855B, 0x0078845A, 0x00708457,
        0x00728659, 0x00778A5F, 0x0078895E, 0x0074845B, 0x0079875E, 0x007E8C63, 0x007C8963, 0x0066764D, 0x004A5A31, 0x005A6A41, 0x0054643B, 0x00708057, 0x0078885F, 0x007B8B62, 0x00627249, 0x0050623B, 0x0041532C, 0x00455730, 0x004E6039, 0x003A4C25,
        0x00556740, 0x0060724B, 0x00768861, 0x0073855C, 0x0073855C, 0x0074865D, 0x0074865D, 0x0074865D, 0x0074865D, 0x0073855C, 0x0073855C, 0x00738560, 0x00778867, 0x00505F43, 0x00212E18, 0x004C5844, 0x0044503E, 0x0024301C, 0x00212E18, 0x00222B17,
        0x00222F15, 0x00243314, 0x002F3C24, 0x00404A3D, 0x00424C40, 0x0044543C, 0x005A6E4B, 0x00556543, 0x00556445, 0x0045523A, 0x00626D59, 0x0068735F, 0x003D4A32, 0x003F4E2F, 0x005A6A48, 0x00404F34, 0x004B5A3F, 0x00505E42, 0x004D5C3D, 0x00566448,
        0x0058624B, 0x004B5342, 0x00495041, 0x003D342B, 0x0022271E, 0x001A2C25, 0x002F403D, 0x00141C1B, 0x001A1818, 0x00191814, 0x001A1E18, 0x001D231E, 0x00171E17, 0x001B2319, 0x00242A1F, 0x001F241B, 0x001B1C18, 0x001D1D1D, 0x001F1E22, 0x001C1B1D,
        0x001B1B1B, 0x001E1F1D, 0x001D1E1A, 0x00181A14, 0x001B1D17, 0x0020211D, 0x001E1F1B, 0x0017181C, 0x00161917, 0x00252B20, 0x0022291A, 0x00222A19, 0x001A2114, 0x001A1E18, 0x00212323, 0x00131718, 0x00191B15, 0x001B1E15, 0x0014201A, 0x00344849,
        0x002B3F40, 0x0019241C, 0x00333321, 0x00323526, 0x00646A57, 0x00646D53, 0x004D5A3A, 0x006B7C57, 0x00657851, 0x00697E58, 0x00677C56, 0x006B7858, 0x006F7F5D, 0x00687954, 0x006F815A, 0x005F724B, 0x004A5B39, 0x00506243, 0x0044553A, 0x00506146,
        0x005D6F50, 0x00768765, 0x00788B64, 0x0072845B, 0x0074865D, 0x0071835C, 0x00707E5A, 0x00738560, 0x00738560, 0x00738560, 0x00738560, 0x00738560, 0x00738560, 0x00738560, 0x00738560, 0x00738462, 0x00748563, 0x00748563, 0x00748563, 0x00738462,
        0x00738462, 0x00728361, 0x00718260, 0x0073845F, 0x00758661, 0x0072835E, 0x0073845F, 0x0073845F, 0x006C7D58, 0x00445530, 0x005D6E49, 0x002B3C17, 0x004A5B36, 0x005E704B, 0x002E401B, 0x00475C36, 0x005D724C, 0x00223913, 0x0049603A, 0x00496143,
        0x00293A18, 0x0035441E, 0x003D533A, 0x00365B57, 0x00518596, 0x005E99B3, 0x00457F9C, 0x0043768A, 0x002E4945, 0x00626C5F, 0x0085908D, 0x00AAB8BE, 0x00E0E7EA, 0x00D2DBDE, 0x0093A3AF, 0x008A9AA1, 0x0090A0A7, 0x0093A3AA, 0x0099A9B0, 0x009BABB2,
        0x0099A9B0, 0x009CACB3, 0x009AAAB1, 0x0099A3AD, 0x0097A4A6, 0x00919F9B, 0x0092A09C, 0x0097A3A3, 0x009DA8A5, 0x007B8B79, 0x00697E5D, 0x00768569, 0x007B8C6B, 0x00758661, 0x00788964, 0x005F6E4E, 0xFF9FA893, 0xFFFDFFF8, 0xFFFDFFFE, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFCFAFF, 0xFBFBFFF4, 0x00A0AA8C, 0x00647249, 0x007C8963, 0x00798561, 0x0078865C, 0x00819161, 0x0074845B, 0x0077875E, 0x007B8B62, 0x00798960, 0x0075855C,
        0x0075855C, 0x0078885F, 0x007A8A61, 0x00778A57, 0x007C8F5E, 0x0077895A, 0x0077885C, 0x00809165, 0x007D8F60, 0x00839663, 0x007D925B, 0x00809166, 0x00809166, 0x007E8F64, 0x007E8C62, 0x007A885E, 0x007A885E, 0x007C885E, 0x007B875D, 0x00728659,
        0x0074885B, 0x00778B5E, 0x0076875B, 0x00718256, 0x00758359, 0x0079875D, 0x0079875D, 0x0073835A, 0x0068784F, 0x0047572E, 0x0057673E, 0x00526239, 0x006F7F56, 0x007A8A61, 0x0064744B, 0x0050623B, 0x0041532C, 0x0044562F, 0x004C5E37, 0x00384A23,
        0x0054663F, 0x0060724B, 0x00768861, 0x0073855C, 0x0073855C, 0x0074865D, 0x0074865D, 0x0074865D, 0x0074865D, 0x0073855C, 0x0073855C, 0x0072845F, 0x00768766, 0x004E5D41, 0x001F2C16, 0x004B5743, 0x00414D3B, 0x00212D19, 0x00202D17, 0x0027301C,
        0x00263319, 0x002C3B1C, 0x00323F27, 0x003D473A, 0x00353F33, 0x002B3B23, 0x00495D3A, 0x00546442, 0x00556543, 0x00394927, 0x00394828, 0x003C4B2B, 0x00324220, 0x00465634, 0x00586846, 0x00314024, 0x00445337, 0x004E5D3E, 0x00475637, 0x00616F53,
        0x007F8972, 0x00646C5B, 0x0040473A, 0x004A4235, 0x00252B20, 0x00172A21, 0x0031423E, 0x0019221F, 0x001E1D19, 0x0021211B, 0x00282D24, 0x002A3228, 0x001B2318, 0x001B2215, 0x0021281B, 0x001E2118, 0x00171814, 0x00181719, 0x001E1A20, 0x00181719,
        0x001A191B, 0x001C1B1D, 0x00191919, 0x00161616, 0x00191A18, 0x001E1F1D, 0x001C1D1B, 0x001A1C1C, 0x00181C17, 0x00242B1E, 0x00232B1A, 0x00202817, 0x00161C11, 0x00161A15, 0x00222425, 0x001A1E1F, 0x001A1B17, 0x00191C13, 0x0018241E, 0x003F5255,
        0x00374A4D, 0x00222D25, 0x00383828, 0x00353829, 0x00616754, 0x005B644A, 0x00485535, 0x006A7B56, 0x00647651, 0x00647953, 0x00677C56, 0x00697656, 0x0071815F, 0x0072835E, 0x004D5F38, 0x004E613A, 0x00455634, 0x00213314, 0x004F6045, 0x0057684D,
        0x00617354, 0x00758664, 0x0072855E, 0x006C7E55, 0x0072845B, 0x0074865F, 0x00778561, 0x00748661, 0x00748661, 0x00748661, 0x00748661, 0x00748661, 0x00748661, 0x00748661, 0x00748661, 0x00738560, 0x00738560, 0x00738560, 0x00748661, 0x00748661,
        0x00738560, 0x00738560, 0x0072845F, 0x00788964, 0x006E7F5A, 0x006E7F5A, 0x00798A65, 0x00667752, 0x003F502B, 0x0061724D, 0x00344520, 0x00485934, 0x00657651, 0x002B3D18, 0x004A5C37, 0x005A6F49, 0x002A3F19, 0x00455C36, 0x0049603A, 0x0021391B,
        0x004B5C3A, 0x00485731, 0x00263C23, 0x00385D59, 0x00588C9D, 0x00538EA8, 0x004E88A5, 0x00487C8D, 0x0035504C, 0x00636E5E, 0x00838E8B, 0x009DABB1, 0x00DAE1E4, 0x00D2DBDE, 0x0094A5AE, 0x007F9299, 0x0080939A, 0x00889BA2, 0x008FA2A9, 0x0095A8AF,
        0x0096A9B0, 0x008DA0A7, 0x00899CA3, 0x008F9EAE, 0x00899BA2, 0x007F9190, 0x00879593, 0x008F9B9B, 0x009BA59F, 0x007D8975, 0x006A7A58, 0x00718064, 0x00768766, 0x00728260, 0x00778863, 0x00627152, 0xFF9FA893, 0xFFFCFFF8, 0xFFFDFFFE, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFDFF, 0xFFFEFFF7, 0x009FA98B, 0x00627047, 0x007B8862, 0x007E8A66, 0x0078865C, 0x00819161, 0x00798960, 0x00798960, 0x007C8C63, 0x007D8D64, 0x007C8C63,
        0x007E8E65, 0x007D8D64, 0x0076865D, 0x0073865B, 0x007C8E65, 0x0073845F, 0x00758661, 0x00758760, 0x006D7F56, 0x00728657, 0x00687D4C, 0x00687B50, 0x006E8156, 0x00738459, 0x0076875C, 0x00738157, 0x007C8A60, 0x007B895F, 0x00778359, 0x0074875C,
        0x00708358, 0x006F8356, 0x00728357, 0x0075865A, 0x007A895D, 0x00788859, 0x00748455, 0x0077875E, 0x007D8D64, 0x005C6C43, 0x004B5B32, 0x0058683F, 0x00506037, 0x0076865D, 0x0068784F, 0x0052643D, 0x0042542D, 0x00455730, 0x004C5E37, 0x00384A23,
        0x0054663F, 0x0061734C, 0x00788A63, 0x0073855C, 0x0073855C, 0x0074865D, 0x0074865D, 0x0074865D, 0x0074865D, 0x0073855C, 0x0073855C, 0x0070825D, 0x00758665, 0x004D5C40, 0x001E2B15, 0x004C5844, 0x00414D3B, 0x00202C18, 0x00222F19, 0x001D2612,
        0x001E2B11, 0x00273617, 0x002F3C24, 0x00424C3F, 0x00323C30, 0x001F2F17, 0x004F6340, 0x00758661, 0x0072845D, 0x0054663D, 0x004F6237, 0x0052653A, 0x004B5D34, 0x0052643D, 0x0051623D, 0x00516142, 0x00425332, 0x004D5C3C, 0x00495838, 0x0048563A,
        0x005E6752, 0x00565E4D, 0x0040473A, 0x00423A2D, 0x00262D20, 0x00213529, 0x00394B44, 0x001A241E, 0x001A1A14, 0x001C1D14, 0x00242A1F, 0x002A3025, 0x001D2417, 0x001A2112, 0x00212617, 0x001E2217, 0x001A1C16, 0x001B1919, 0x001A161B, 0x00171717,
        0x00171618, 0x0017161A, 0x00161519, 0x00161519, 0x001A191B, 0x001B1C1A, 0x00191A16, 0x001A1E18, 0x001C2316, 0x00262E1D, 0x00242D18, 0x00222B17, 0x001C2316, 0x00181B19, 0x00222327, 0x001D2024, 0x001B1C18, 0x001A1D14, 0x001B2623, 0x0044575A,
        0x00394C4F, 0x001E2822, 0x00303020, 0x00393B2F, 0x006B7160, 0x00636B54, 0x004E5B3B, 0x006E7E5C, 0x00697B56, 0x00677C56, 0x006A7E5B, 0x00788565, 0x00687856, 0x00586944, 0x004E6039, 0x0050633C, 0x00445533, 0x0037492A, 0x004C5D42, 0x00506146,
        0x004C5E3F, 0x00627351, 0x0073865F, 0x00778960, 0x0075875E, 0x0070825B, 0x00778561, 0x0072845F, 0x0072845F, 0x0072845F, 0x0072845F, 0x0072845F, 0x0072845F, 0x0072845F, 0x0072845F, 0x0072845F, 0x0072845F, 0x00738560, 0x00738560, 0x00748661,
        0x00738560, 0x00738560, 0x00738560, 0x0073845F, 0x0073845F, 0x00768762, 0x00647550, 0x004E5F3A, 0x005D6E49, 0x002D3E19, 0x00475833, 0x005A6B46, 0x002F401B, 0x004A5C37, 0x00546641, 0x002F441E, 0x00415630, 0x004F6640, 0x00283F19, 0x00486042,
        0x00425331, 0x00374620, 0x002E442B, 0x003F6460, 0x00528697, 0x004F8AA4, 0x00508AA7, 0x00477B8C, 0x002D4844, 0x004D5848, 0x006A7572, 0x00808F92, 0x00CBD3D3, 0x00D0DADA, 0x0095A6AF, 0x00748A90, 0x006D8389, 0x00768C92, 0x007E949A, 0x008DA3A9,
        0x0093A9AF, 0x0081979D, 0x00788E94, 0x00788C9E, 0x007E929D, 0x007E9293, 0x00899998, 0x008E9A9C, 0x00979E9B, 0x007F8A76, 0x006E7C5A, 0x00718064, 0x00768667, 0x00728260, 0x00758563, 0x00637253, 0xFFA2AB97, 0xFFF9FEF5, 0xFFFBFDFD, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFDFF, 0xFFFFFFF8, 0x009EA88A, 0x00606E45, 0x007C8963, 0x00808C68, 0x00627046, 0x005B6B3B, 0x0057673E, 0x005A6A41, 0x005E6E45, 0x005D6D44, 0x005A6A41,
        0x00596940, 0x005C6C43, 0x005E6E45, 0x00738165, 0x00556248, 0x0045513B, 0x0056614D, 0x00505B47, 0x0035422A, 0x002C3A1E, 0x00354425, 0x00263614, 0x00293917, 0x00374823, 0x0045532F, 0x0042512B, 0x0055633A, 0x006E7C52, 0x007B895F, 0x0074865F,
        0x0074865F, 0x0074865D, 0x0077885D, 0x00798A5F, 0x007A895D, 0x00768657, 0x00758556, 0x0076865D, 0x0077875E, 0x007C8C63, 0x0057673E, 0x0058683F, 0x00526239, 0x005C6C43, 0x005E6E45, 0x0053653E, 0x0043552E, 0x00465831, 0x004E6039, 0x003A4C25,
        0x00566841, 0x0063754E, 0x00798B64, 0x0073855C, 0x0073855C, 0x0074865D, 0x0074865D, 0x0074865D, 0x0074865D, 0x0073855C, 0x0073855C, 0x0070825D, 0x00758665, 0x004C5B3F, 0x001F2C16, 0x004F5B47, 0x00434F3D, 0x00212D19, 0x0026331D, 0x0029321E,
        0x0028351B, 0x00283718, 0x00313E26, 0x00495346, 0x00323C30, 0x001F2F17, 0x005E724F, 0x0072845F, 0x00798C65, 0x006D8157, 0x00708459, 0x0075895E, 0x0065794F, 0x00566942, 0x00475934, 0x00435432, 0x004E5F3D, 0x006C7C5A, 0x00637351, 0x004C5B3C,
        0x00565F4A, 0x004E5546, 0x002E3429, 0x00292114, 0x001B2215, 0x001E3128, 0x00354740, 0x00151E1B, 0x00171612, 0x00171711, 0x00191F14, 0x00191E15, 0x00171D12, 0x001F2317, 0x00272C1D, 0x002A2F20, 0x002D2E24, 0x00272721, 0x001B1918, 0x00181917,
        0x00181818, 0x0018171B, 0x001A181E, 0x001C1A20, 0x001B1A1C, 0x00171814, 0x0015180F, 0x0018210D, 0x00212A15, 0x00293519, 0x00273317, 0x0029331C, 0x00272E1F, 0x00161A15, 0x00131516, 0x0015181C, 0x00191A18, 0x001A1C16, 0x0016211E, 0x00374A4F,
        0x002A3D42, 0x00121C16, 0x0029281A, 0x002F3125, 0x00676D5C, 0x005F6750, 0x00424E30, 0x00566644, 0x00556742, 0x00556946, 0x00586C49, 0x005F6C4C, 0x0051613F, 0x00465732, 0x00495B34, 0x005A6D46, 0x00576846, 0x00465839, 0x0054654A, 0x004B5C41,
        0x00415334, 0x00576846, 0x0070835C, 0x00798B62, 0x0074865D, 0x006E8059, 0x00778561, 0x0071835E, 0x0071835E, 0x0071835E, 0x0071835E, 0x0071835E, 0x0071835E, 0x0071835E, 0x0071835E, 0x0071845D, 0x0072855E, 0x0072855E, 0x0073865F, 0x0073865F,
        0x0073865F, 0x0072855E, 0x0072855E, 0x0072835E, 0x00798A65, 0x006A7B56, 0x004A5B36, 0x005E6F4A, 0x003B4C27, 0x003D4E29, 0x005A6B46, 0x0030411C, 0x00475833, 0x005C6E49, 0x0031431E, 0x00445933, 0x00586D47, 0x00253C16, 0x0049603A, 0x00465E40,
        0x002B3C1A, 0x0036451F, 0x00455B42, 0x00476C68, 0x0055899A, 0x005994AE, 0x004C86A3, 0x0045798A, 0x0026423C, 0x00404C3A, 0x0065716B, 0x0078878A, 0x00CCD4D4, 0x00D1DBDB, 0x0092A4AB, 0x00748A90, 0x006C8288, 0x0073898F, 0x007A9096, 0x00899FA5,
        0x0090A6AC, 0x007F959B, 0x00778D93, 0x0074889A, 0x007D919C, 0x007C9192, 0x00859496, 0x00818C90, 0x00899190, 0x007F8979, 0x00758163, 0x00748368, 0x0079896A, 0x00788767, 0x00758563, 0x005F6D51, 0xFFA4AD99, 0xFFFCFFFA, 0xFFFDFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFDFF, 0xFFFFFFF8, 0x009EA88A, 0x00627047, 0x007E8B65, 0x007C8864, 0x0048562C, 0x00334313, 0x0035451C, 0x0034441B, 0x00304017, 0x00304017, 0x0035451C,
        0x00324219, 0x00304017, 0x0036461D, 0x00727E68, 0x004B5544, 0x004A5346, 0x00828982, 0x009FA5A0, 0x0099A099, 0x0090988E, 0x009BA398, 0x009AA595, 0x009BA795, 0x008C9783, 0x0058654B, 0x00414E2E, 0x004D5B37, 0x00718158, 0x007D8B61, 0x00738262,
        0x00788767, 0x007A8A68, 0x007A8864, 0x0075845E, 0x00728057, 0x00738157, 0x007B8A5E, 0x00708057, 0x0076865D, 0x0076865D, 0x0077875E, 0x005C6C43, 0x00596940, 0x0056663D, 0x00415128, 0x0053653E, 0x0044562F, 0x00475932, 0x004F613A, 0x003B4D26,
        0x00576942, 0x0063754E, 0x00798B64, 0x0073855C, 0x0073855C, 0x0074865D, 0x0074865D, 0x0074865D, 0x0074865D, 0x0073855C, 0x0073855C, 0x0071835E, 0x00758665, 0x004A593D, 0x001F2C16, 0x00535F4B, 0x00465240, 0x00222E1A, 0x0028351F, 0x002A331F,
        0x0029361C, 0x00273617, 0x00323F27, 0x00475144, 0x00303A2E, 0x001F2F17, 0x00566A47, 0x0070815F, 0x00687957, 0x00485937, 0x00405130, 0x004B5C3B, 0x00495A38, 0x00475836, 0x00475836, 0x004F613C, 0x006B7E57, 0x006F805B, 0x00536341, 0x00556445,
        0x0077806B, 0x00676E5F, 0x002B3027, 0x001D140B, 0x0012170E, 0x00172922, 0x002E3F3C, 0x00141C1B, 0x001E1C1C, 0x001D1C18, 0x00181C16, 0x00131614, 0x00171814, 0x001D2116, 0x0024291A, 0x002B2E1E, 0x00303323, 0x002E2E20, 0x00202012, 0x00181C11,
        0x00171814, 0x00171618, 0x001B191F, 0x001C1B1F, 0x00161715, 0x00161910, 0x001D2213, 0x00525F3F, 0x005B6947, 0x005C6B45, 0x00596842, 0x005A6747, 0x00515A45, 0x00292E25, 0x00151816, 0x00111418, 0x00161715, 0x00191B15, 0x0015201E, 0x00394C51,
        0x002E4146, 0x00101916, 0x001E1D0F, 0x0023241A, 0x00616657, 0x00606851, 0x00455133, 0x004D5D3B, 0x004C5D3B, 0x004D613E, 0x004C5F3E, 0x004D5A3A, 0x0051613F, 0x0053643F, 0x0040522B, 0x005E714A, 0x006A7B59, 0x00445637, 0x0065765B, 0x00495A3F,
        0x004B5D3E, 0x00617250, 0x006D8059, 0x006F8158, 0x00708259, 0x0070825B, 0x00778561, 0x00738560, 0x00738560, 0x00738560, 0x00738560, 0x00738560, 0x00738560, 0x00738560, 0x00738560, 0x0071845D, 0x0071845D, 0x0072855E, 0x0072855E, 0x0072855E,
        0x0072855E, 0x0071845D, 0x0071845D, 0x00748560, 0x006A7B56, 0x00445530, 0x0062734E, 0x003A4B26, 0x00394A25, 0x005F704B, 0x00394A25, 0x00475833, 0x0060714C, 0x0030421D, 0x00445631, 0x00586D47, 0x00334822, 0x00415832, 0x004C633D, 0x0020381A,
        0x0040512F, 0x004A5933, 0x003E543B, 0x004B706C, 0x005A8E9F, 0x00518CA6, 0x00518BA8, 0x00477B8B, 0x0026423C, 0x003C4836, 0x006B7771, 0x007A898B, 0x00CFD7D6, 0x00D3DEDC, 0x008FA1A8, 0x007F9299, 0x007D9097, 0x0082959C, 0x0085989F, 0x008A9DA4,
        0x008DA0A7, 0x008699A0, 0x0084979E, 0x008598A7, 0x007D9097, 0x00667B79, 0x0069787A, 0x0069747C, 0x00788185, 0x00747F75, 0x0065755E, 0x006D7C61, 0x006D7C60, 0x00768565, 0x00788767, 0x005E6C50, 0xFFA3AB9A, 0xFFFCFFFA, 0xFFFDFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFDFF, 0xFFFFFFF8, 0x009CA688, 0x00627047, 0x007E8B65, 0x007F8B67, 0x004D5B31, 0x00425222, 0x0063734A, 0x0054643B, 0x00415128, 0x004A5A31, 0x00627249,
        0x005B6B42, 0x00425229, 0x003A4A21, 0x0067765A, 0x0048553F, 0x004F5A4A, 0x00A4ACA5, 0x00D9E0DD, 0x00E4EAE9, 0x00E1E7E6, 0x00E2E8E7, 0x00E5E9EE, 0x00EAEFF2, 0x00BCC3BE, 0x00565F52, 0x0049553F, 0x00566244, 0x006A7953, 0x005A6A41, 0x00536046,
        0x00505D43, 0x0049573B, 0x004B5838, 0x00515F3D, 0x0054613B, 0x0055633A, 0x005C6A41, 0x0073835A, 0x0074845B, 0x0077875E, 0x00728259, 0x007D8D64, 0x004E5E35, 0x0064744B, 0x002E3E15, 0x0052643D, 0x0043552E, 0x00475932, 0x0050623B, 0x003B4D26,
        0x00566841, 0x0062744D, 0x00788A63, 0x0073855C, 0x0073855C, 0x0074865D, 0x0074865D, 0x0074865D, 0x0074865D, 0x0073855C, 0x0073855C, 0x00738560, 0x00768766, 0x0049583C, 0x001E2B15, 0x0054604C, 0x00475341, 0x00212D19, 0x0027341E, 0x0028311D,
        0x0027341A, 0x00283718, 0x0035422A, 0x003F493C, 0x00303A2E, 0x00293921, 0x00455936, 0x004C603D, 0x00455738, 0x0033432B, 0x003D4C37, 0x004C5B46, 0x003A4A32, 0x00394B2C, 0x00526643, 0x006E815A, 0x006E8258, 0x0062744D, 0x005D6E49, 0x005C6B4C,
        0x00646D58, 0x00596053, 0x00282D24, 0x00271C18, 0x00181C17, 0x00182926, 0x002D3C3E, 0x00141A1F, 0x001E1A1F, 0x001B1919, 0x00141715, 0x001C1A20, 0x00171618, 0x001A1C16, 0x00212415, 0x00262B16, 0x002E3219, 0x002E3219, 0x00262A11, 0x001E2413,
        0x001B1F14, 0x00181917, 0x0019181C, 0x00181719, 0x00161713, 0x00272C1D, 0x00444B36, 0x0074855A, 0x00738458, 0x006A7C4D, 0x006C7E4F, 0x00707F59, 0x00636F53, 0x002E3526, 0x00131711, 0x0013161B, 0x00191A18, 0x001A1B17, 0x0016211F, 0x003F5257,
        0x00384A51, 0x00141D1A, 0x00181709, 0x001A1B11, 0x0054594A, 0x005A614C, 0x00485438, 0x00475636, 0x00435432, 0x00455837, 0x00445736, 0x004C5939, 0x00475735, 0x00384924, 0x00455730, 0x004B5E37, 0x00495A38, 0x004C5E3F, 0x00334429, 0x003E4F34,
        0x004E6041, 0x006E7F5D, 0x00758861, 0x0071835A, 0x00708259, 0x006D7F58, 0x006F7D59, 0x0072845F, 0x0072845F, 0x0072845F, 0x0072845F, 0x0072845F, 0x0072845F, 0x0072845F, 0x0072845F, 0x0071855B, 0x0071855B, 0x0071855B, 0x0071855B, 0x0071855B,
        0x0070845A, 0x006F8359, 0x006F8359, 0x006E7F5A, 0x003F502B, 0x0061724D, 0x00374823, 0x0041522D, 0x005D6E49, 0x00364722, 0x0041522D, 0x00657651, 0x00263712, 0x004C5E39, 0x00536540, 0x00283D17, 0x00485D37, 0x00516842, 0x00243B15, 0x00496143,
        0x00475836, 0x00495832, 0x0040563D, 0x00426763, 0x004D8192, 0x004E89A3, 0x004F89A6, 0x004A7E8E, 0x00254239, 0x00374331, 0x006D7A72, 0x00758486, 0x00CBD3D2, 0x00D2DDDB, 0x0091A3AA, 0x0088989F, 0x008B9BA2, 0x008B9BA2, 0x008E9EA5, 0x008E9EA5,
        0x008D9DA4, 0x0090A0A7, 0x008F9FA6, 0x008A99A2, 0x00809293, 0x00687B78, 0x006A797B, 0x0069757F, 0x007A8690, 0x00818F8D, 0x0076897A, 0x0085937B, 0x006D7C60, 0x00707F5F, 0x00798868, 0x005F6D51, 0xFFA3AB9A, 0xFFFBFFF9, 0xFFFCFEFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFDFF, 0xFFFCFFF5, 0x009DA789, 0x0067754C, 0x007F8C66, 0x007A8662, 0x0047552B, 0x00455525, 0x005E6E45, 0x00617148, 0x005B6B42, 0x005F6F46, 0x0067774E,
        0x004E5E35, 0x0035451C, 0x003B4B22, 0x006C7E59, 0x004A5A3B, 0x00505D47, 0x00BAC4B7, 0x00E8EFEA, 0x00D4DAD9, 0x00C8CDCE, 0x00C6CBCC, 0x00D0CFE3, 0x00E8E8F8, 0x00C4C7CF, 0x00585E59, 0x004E5848, 0x003F4B2F, 0x0045532F, 0x003C4C23, 0x00636F59,
        0x004E5A44, 0x0037442A, 0x003A462A, 0x004E5B3B, 0x00576241, 0x004E5A36, 0x004A5731, 0x007B8B62, 0x0077875E, 0x0076865D, 0x00718158, 0x00798960, 0x0068784F, 0x00526239, 0x003C4C23, 0x0050623B, 0x0042542D, 0x00465831, 0x004F613A, 0x003B4D26,
        0x00566841, 0x0061734C, 0x00768861, 0x0073855C, 0x0073855C, 0x0074865D, 0x0074865D, 0x0074865D, 0x0074865D, 0x0073855C, 0x0073855C, 0x00758762, 0x00778867, 0x0048573B, 0x001D2A14, 0x0055614D, 0x00475341, 0x001F2B17, 0x0025321C, 0x002C3521,
        0x0028351B, 0x002C3B1C, 0x0039462E, 0x003D473A, 0x003E483C, 0x00485840, 0x00526643, 0x004A5E3B, 0x00506146, 0x005D6A5A, 0x007E897F, 0x007C877D, 0x00435040, 0x003A4B30, 0x006D815E, 0x00667A50, 0x0062764C, 0x0062744B, 0x00697A55, 0x005B6A4B,
        0x00636C57, 0x00676E61, 0x00292E25, 0x00231715, 0x00141616, 0x00152426, 0x002B3A3D, 0x0012181F, 0x001B171D, 0x001B171C, 0x00181A1B, 0x001D1925, 0x0016141A, 0x001D1C18, 0x00292C1D, 0x002E341D, 0x0033381B, 0x0033391A, 0x00303617, 0x002B321D,
        0x00262A1E, 0x001E1F1B, 0x001A191B, 0x00181818, 0x001D1F19, 0x00424837, 0x00727B61, 0x00607342, 0x00586B38, 0x004B5F2A, 0x00576A37, 0x0066774B, 0x005F6C4C, 0x002C3423, 0x00151A11, 0x0014171C, 0x001E1E1E, 0x001D1E1A, 0x00111C1A, 0x0034464D,
        0x002F4148, 0x00141D1A, 0x001F1E10, 0x002F3026, 0x005D6253, 0x005F6651, 0x004E5A3E, 0x00475636, 0x00435432, 0x00495C3B, 0x004B5E3D, 0x004D5A3A, 0x0050603E, 0x0051623D, 0x0053653E, 0x00586B44, 0x00475836, 0x002F4122, 0x00394A2F, 0x003E4F34,
        0x004C5E3F, 0x006A7B59, 0x0072855E, 0x006E8057, 0x006F8158, 0x006F815A, 0x0075835F, 0x0070825D, 0x0070825D, 0x0070825D, 0x0070825D, 0x0070825D, 0x0070825D, 0x0070825D, 0x0070825D, 0x0071855B, 0x0071855B, 0x0071855B, 0x0071855B, 0x0070845A,
        0x006F8359, 0x006E8258, 0x006D8157, 0x004A5B36, 0x00667752, 0x00384924, 0x00455631, 0x005F704B, 0x003F502B, 0x0041522D, 0x0062734E, 0x002F401B, 0x00546540, 0x00556742, 0x002D3F1A, 0x004B603A, 0x00526741, 0x00213812, 0x004D643E, 0x003F5739,
        0x00536442, 0x005B6A44, 0x00445A41, 0x003D625E, 0x00528697, 0x005691AB, 0x004F89A6, 0x00477B8B, 0x00234037, 0x0036422E, 0x00707D75, 0x00748385, 0x00C9D1D0, 0x00D1DCDA, 0x0093A5AC, 0x0089969E, 0x008D9AA2, 0x0087949C, 0x008D9AA2, 0x00909DA5,
        0x008F9CA4, 0x0095A2AA, 0x00919EA6, 0x008B979B, 0x0093A19F, 0x00859692, 0x00808F91, 0x00727E8A, 0x008794A2, 0x00AEBFC2, 0x00C0D5CC, 0x00BCCAB2, 0x00849377, 0x00707F60, 0x00768565, 0x005E6B51, 0xFFA3AB9A, 0xFFFCFFFB, 0xFFFDFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFDFF, 0xFFFFFFF8, 0x009DA789, 0x00637148, 0x00808D67, 0x007E8A66, 0x0047552B, 0x00465626, 0x005E6F44, 0x003E4F24, 0x005A6B40, 0x0054653A, 0x0055663B,
        0x00627348, 0x003D4E23, 0x003C4D22, 0x0072845B, 0x00566546, 0x00707A6A, 0x00BBC0BF, 0x00DDE0E5, 0x00E3E5ED, 0x00CED2D3, 0x00C0C5C4, 0x00D8D8DE, 0x00D5D6DA, 0x00D0D2D2, 0x00767A75, 0x006B7166, 0x006C7463, 0x00535C47, 0x00646E57, 0x008D908E,
        0x00737674, 0x00525553, 0x0050544F, 0x00737772, 0x00B5B9B3, 0x00B1B5AF, 0x00494D47, 0x005E6B45, 0x007B8862, 0x007A8761, 0x0072815B, 0x0075845E, 0x0063754E, 0x0052643D, 0x00354720, 0x0050633C, 0x00465932, 0x0043562F, 0x004E613A, 0x003A4D26,
        0x00546740, 0x00667952, 0x0073865F, 0x0072845B, 0x0073855C, 0x0075875E, 0x0076885F, 0x0075875E, 0x0074865D, 0x0074865D, 0x0076885F, 0x0074825E, 0x007E8F6A, 0x004C5B3B, 0x00232D1C, 0x00565D58, 0x004B524F, 0x00192715, 0x00233615, 0x00212E18,
        0x002D3C20, 0x002C3C1D, 0x003D4935, 0x00424B41, 0x003D463C, 0x0019280D, 0x0044582D, 0x004F6339, 0x004C5B3F, 0x00545D53, 0x00B3B8BB, 0x00CBCFD4, 0x00757D76, 0x0048563E, 0x006C7D5B, 0x006A7D56, 0x00637550, 0x006A7A58, 0x005D6B4F, 0x00404D35,
        0x007F8874, 0x006A7162, 0x002C3326, 0x001D1417, 0x00171A1E, 0x00243133, 0x003B4749, 0x00181C1D, 0x001C1915, 0x001B1E15, 0x001B2518, 0x00181C17, 0x00181C17, 0x001B1F1A, 0x002B2D27, 0x002A2E22, 0x00262B16, 0x00323A1C, 0x00333C1B, 0x0030371C,
        0x003A4029, 0x00282B1C, 0x001B1F14, 0x00171B0F, 0x0017210A, 0x0054623E, 0x006B7C50, 0x00525B41, 0x002C351A, 0x001C2707, 0x00242F0E, 0x00303A1C, 0x00333B24, 0x0023271B, 0x00171A11, 0x00151D12, 0x00171913, 0x001A1B19, 0x00192323, 0x00465A5B,
        0x003A4E4F, 0x000F1717, 0x00201A1B, 0x00262822, 0x0051574C, 0x005C6453, 0x004C5941, 0x00455438, 0x00455738, 0x00495D40, 0x00495D40, 0x0047563A, 0x004A593D, 0x004F5E43, 0x00516045, 0x004E5C44, 0x004C5A42, 0x0054624A, 0x005E6B55, 0x005A6954,
        0x0053634C, 0x005B6A4E, 0x006E7F5D, 0x007A8C65, 0x00778962, 0x00748560, 0x007A8864, 0x0075845E, 0x0076855F, 0x00788761, 0x00798862, 0x00788761, 0x00778660, 0x00778660, 0x00778660, 0x00798862, 0x007B8A64, 0x007A8963, 0x00778660, 0x00788761,
        0x0076855F, 0x00687751, 0x0056653F, 0x0063754E, 0x00384A23, 0x0041532C, 0x0060724B, 0x003E5029, 0x0041532C, 0x0063754E, 0x0031431C, 0x004D6137, 0x00596D43, 0x00293C15, 0x0051643D, 0x00576944, 0x00273914, 0x004C5D3B, 0x00516240, 0x0053643F,
        0x00667859, 0x00627352, 0x00475636, 0x00446459, 0x004C859A, 0x004C8CAB, 0x00548BA0, 0x004B798A, 0x001B4038, 0x00334633, 0x00767C77, 0x007A8184, 0x00C5D6D3, 0x00CFE0DD, 0x0097A0A9, 0x007F9198, 0x007C8E95, 0x0083959C, 0x008D9FA6, 0x0092A4AB,
        0x0093A5AC, 0x008D9FA6, 0x0081939A, 0x007E939B, 0x007D8F98, 0x0083959C, 0x007D9095, 0x00798A8D, 0x00808F91, 0x00B4C1C3, 0x00D0DEDD, 0x00A5B596, 0x007E8F6E, 0x00788866, 0x007C8C6A, 0x005D6B4F, 0xFF9FA796, 0xFFFAFEF8, 0xFFFDFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFCFF, 0xFFFCFFF5, 0x0098A284, 0x00606E45, 0x007E8B65, 0x007B8763, 0x0046542A, 0x00435323, 0x00606E44, 0x00505E34, 0x005D6B41, 0x004F5D33, 0x0057653B,
        0x00657349, 0x00414F25, 0x00414F25, 0x006D7F58, 0x004C5B3C, 0x00707A6A, 0x00C7CCCA, 0x00D8DBE0, 0x00D4D7DC, 0x00D6DADB, 0x00D6DBD9, 0x00D3D3D9, 0x00E7E8EC, 0x00C8CACA, 0x00727670, 0x00858C7D, 0x005F6853, 0x004E593F, 0x00727E62, 0x00A8AEA3,
        0x008E9489, 0x006E7469, 0x0072796C, 0x00899083, 0x00ACB3A4, 0x00B7BEAF, 0x008A9182, 0x004B5832, 0x0068754F, 0x00727F59, 0x00778660, 0x007D8C66, 0x005D6F48, 0x00556740, 0x00374922, 0x00546740, 0x003F522B, 0x004A5D36, 0x004B5E37, 0x00364922,
        0x005A6D46, 0x0061744D, 0x00788B64, 0x0074865D, 0x0075875E, 0x0076885F, 0x00778960, 0x0076885F, 0x0075875E, 0x0074865D, 0x0074865D, 0x0073815D, 0x00758760, 0x004C5B3B, 0x00293420, 0x00545B56, 0x004F5653, 0x0022301E, 0x001E3011, 0x00202D17,
        0x001D2C11, 0x002B3A1F, 0x003C4834, 0x004A5349, 0x00343E32, 0x00334226, 0x0055693E, 0x00768A60, 0x005B6A4E, 0x00545E52, 0x00999E9F, 0x00979C9F, 0x00565F55, 0x004A5840, 0x006B7C5A, 0x00667952, 0x00687A55, 0x00657553, 0x00576549, 0x00505D45,
        0x0077806C, 0x00555C4D, 0x001F2619, 0x001C1414, 0x00131817, 0x001C2A29, 0x00333F41, 0x0015191A, 0x001B1716, 0x001A1C16, 0x001A2319, 0x00212520, 0x001D211C, 0x001A1E19, 0x0023251F, 0x001F2317, 0x001F2310, 0x002C3219, 0x002F3718, 0x00262D12,
        0x002D321D, 0x00232519, 0x001B1E15, 0x001E2118, 0x001E2615, 0x004C583C, 0x005B6947, 0x002D3320, 0x001F2611, 0x00232C12, 0x00283117, 0x00252D16, 0x00212716, 0x00191C13, 0x001A1B17, 0x00171E17, 0x00191A16, 0x00191919, 0x00111B1B, 0x003C514F,
        0x00344946, 0x000D1613, 0x001D1914, 0x001B1E15, 0x005E6558, 0x0068715C, 0x00465438, 0x00425233, 0x00485B3A, 0x00445938, 0x003C5131, 0x00485839, 0x004A5A3B, 0x004E5E3F, 0x00505F43, 0x004E5D41, 0x004D5C41, 0x00536247, 0x005B6A4F, 0x0051614A,
        0x0047583D, 0x00455635, 0x004C5E39, 0x00506239, 0x004C5E35, 0x004B5D36, 0x00515F3B, 0x00576640, 0x00586741, 0x00596842, 0x00596842, 0x00576640, 0x00576640, 0x00586741, 0x005A6943, 0x00576640, 0x00576640, 0x0052613B, 0x004F5E38, 0x0054633D,
        0x005B6A44, 0x00596842, 0x0051603A, 0x003B4D26, 0x00455730, 0x0062744D, 0x00354720, 0x0040522B, 0x0064764F, 0x00384A23, 0x0042542D, 0x00596D43, 0x0030441A, 0x00546740, 0x004C5F38, 0x0031431E, 0x00546641, 0x00526341, 0x0030411F, 0x0053643F,
        0x00566849, 0x004B5C3B, 0x00394828, 0x003D5D52, 0x00478095, 0x004A8AA9, 0x005A91A6, 0x004A7889, 0x001A3F37, 0x00334633, 0x00757B76, 0x007A8184, 0x00C5D6D3, 0x00CEDFDC, 0x0097A0A9, 0x0074868D, 0x006F8188, 0x0076888F, 0x0084969D, 0x008EA0A7,
        0x0090A2A9, 0x0085979E, 0x0074868D, 0x00798B94, 0x007B8D96, 0x007F9198, 0x0079898F, 0x00778689, 0x00829193, 0x00B4C1C3, 0x00CCD8D8, 0x00829273, 0x006A7B5A, 0x006D7D5B, 0x00778765, 0x005F6D51, 0xFFA3AB9A, 0xFFFDFFFB, 0xFFFDFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFDFF, 0xFFFEFFF7, 0x0098A284, 0x0065734A, 0x0083906A, 0x007D8965, 0x0049572D, 0x00415121, 0x007A845A, 0x00687248, 0x00596339, 0x004D572D, 0x00646E44,
        0x00697349, 0x00424C22, 0x003E481E, 0x006E7E5C, 0x00455238, 0x00596353, 0x00C0C6C1, 0x00E4E8E9, 0x00DADEDF, 0x00D4D9D7, 0x00D4DAD5, 0x00D7D8DC, 0x00E3E5E6, 0x00C0C4BF, 0x00697063, 0x00747D69, 0x00495539, 0x005D6B49, 0x0053613D, 0x005D6750,
        0x00545E47, 0x00465039, 0x00535E44, 0x005C674D, 0x00566246, 0x005B674B, 0x00566246, 0x00596640, 0x004A5731, 0x0075825C, 0x0073825C, 0x0074835D, 0x0061734C, 0x004E6039, 0x00354720, 0x004F613A, 0x0042542D, 0x00495B34, 0x0052643D, 0x003D4F28,
        0x00566841, 0x00687A53, 0x00758760, 0x0073855C, 0x0074865D, 0x0075875E, 0x0075875E, 0x0075875E, 0x0075875E, 0x0074865D, 0x0072845B, 0x0073815D, 0x007F916A, 0x00455533, 0x001E2A14, 0x005B635C, 0x0059605D, 0x00253222, 0x001A2C0F, 0x0027341E,
        0x00223018, 0x0028351F, 0x00424D3D, 0x00495347, 0x00253020, 0x00233216, 0x006A7E54, 0x0071855B, 0x00687859, 0x00566151, 0x00888F8C, 0x00909794, 0x004C564A, 0x003E4D32, 0x006E805B, 0x006C7F58, 0x00657752, 0x005C6C4A, 0x00576549, 0x006C7961,
        0x00838C78, 0x00676E5F, 0x00333A2D, 0x00211C13, 0x00121912, 0x00152420, 0x002C3838, 0x00131718, 0x001C1719, 0x001A1B19, 0x001B221D, 0x001A1E18, 0x00191D17, 0x00181C17, 0x001D1F19, 0x001A1E13, 0x001D2011, 0x00292E19, 0x002A3017, 0x002B3118,
        0x002C301D, 0x0027281E, 0x001D1E1A, 0x001F201C, 0x00181D14, 0x002B3223, 0x002E3723, 0x001F2318, 0x001C2015, 0x00262A1E, 0x0024281C, 0x001A1E13, 0x00151711, 0x00151614, 0x001C1B1D, 0x00181D1C, 0x001C1C1C, 0x001B1A1C, 0x000E171A, 0x00344947,
        0x002F463E, 0x000C170D, 0x001D1B10, 0x0025291D, 0x007B8372, 0x0088927B, 0x005B6A4B, 0x004D5E3C, 0x004F643E, 0x004F6542, 0x00536946, 0x00526341, 0x00526341, 0x00546543, 0x00556645, 0x00556645, 0x00556546, 0x0059694A, 0x005E6E4F, 0x00637459,
        0x005C6E4F, 0x00576944, 0x0055693F, 0x0056693E, 0x0055683D, 0x0056683F, 0x005C6B45, 0x005B6945, 0x005C6A46, 0x005B6945, 0x005A6844, 0x00596743, 0x00596743, 0x005B6945, 0x005D6B47, 0x00586642, 0x005D6B47, 0x005F6D49, 0x005E6C48, 0x005F6D49,
        0x005E6C48, 0x00566440, 0x004B5935, 0x0042542D, 0x0063754E, 0x00394B24, 0x00485A33, 0x00596B44, 0x003D4F28, 0x0053653E, 0x005D6F48, 0x003B4F25, 0x0045592F, 0x00566942, 0x003B4E27, 0x004A5C37, 0x00536540, 0x002B3C1A, 0x00495A38, 0x00596A45,
        0x00506243, 0x00465736, 0x00425131, 0x004C6C61, 0x004D869B, 0x004A8AA9, 0x005A91A6, 0x00497788, 0x001A3F37, 0x00314431, 0x00747A75, 0x007A8184, 0x00C6D7D4, 0x00CEDFDC, 0x0097A0A9, 0x00778990, 0x006F8188, 0x0073858C, 0x0081939A, 0x008D9FA6,
        0x0091A3AA, 0x008799A0, 0x0076888F, 0x00778992, 0x007C8F96, 0x0084969D, 0x007F8F95, 0x007C8B8E, 0x00919EA0, 0x00BECCCB, 0x00C8D4D4, 0x0079896A, 0x00718261, 0x00748462, 0x007A8A68, 0x00637155, 0xFFA4AC9B, 0xFFF9FDF7, 0xFFFBFDFE, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFDFF, 0xFFFFFFF8, 0x0097A183, 0x0066744B, 0x00808D67, 0x0074805C, 0x00435127, 0x00374717, 0x00434C24, 0x003C451D, 0x00343D15, 0x00363F17, 0x00454E26,
        0x003C451D, 0x002F3810, 0x00434C24, 0x00758465, 0x005D6A50, 0x00596352, 0x00B2BAAF, 0x00EBF2EB, 0x00E2E9E2, 0x00D6DED4, 0x00DDE5DA, 0x00E1E4E2, 0x00F4F8F3, 0x00C4CABF, 0x006A735F, 0x00939E84, 0x00667452, 0x007C8C63, 0x006D7E53, 0x006F7D5B,
        0x0073815F, 0x006C7A56, 0x0072805C, 0x0074835D, 0x00697852, 0x006A7953, 0x006C7C53, 0x0055623C, 0x00606D47, 0x0053603A, 0x005F6E48, 0x0085946E, 0x005A6C45, 0x00586A43, 0x00374922, 0x0050623B, 0x003F512A, 0x004C5E37, 0x004F613A, 0x003C4E27,
        0x00576942, 0x00667851, 0x00768861, 0x0072845B, 0x0073855C, 0x0073855C, 0x0072845B, 0x0073855C, 0x0075875E, 0x0075875E, 0x0073855C, 0x00778561, 0x0073855E, 0x0062734E, 0x0025321A, 0x00636C62, 0x00838A87, 0x002B372B, 0x001D2D16, 0x00202D17,
        0x00323E2A, 0x00121D0D, 0x00606A5D, 0x00535D50, 0x00323E2A, 0x002D3D1E, 0x005A6D46, 0x006A7E53, 0x006C7D5C, 0x0065715D, 0x00A3ACA2, 0x00B6BFB5, 0x00606C5A, 0x00445337, 0x00788A65, 0x00586B44, 0x00475934, 0x00465634, 0x00465438, 0x005E6B53,
        0x006F7864, 0x006C7364, 0x003E4538, 0x00373426, 0x00232B20, 0x001E2F26, 0x00323F3D, 0x001A1E1F, 0x00211C1E, 0x001D1C1E, 0x001E2423, 0x001A2015, 0x001C2118, 0x0021251F, 0x00262723, 0x0023251F, 0x0025261C, 0x00282B1B, 0x00232714, 0x00262B16,
        0x00232617, 0x0026271E, 0x001B1C1A, 0x001D1D1D, 0x00141616, 0x00171A18, 0x00161A15, 0x001C1D1B, 0x00161715, 0x00191A18, 0x00181917, 0x00191919, 0x001D1C1E, 0x0019181C, 0x001B191F, 0x00121617, 0x00161519, 0x001E1D21, 0x00182124, 0x003E5350,
        0x00395147, 0x00202D1F, 0x003B3B2B, 0x002F3425, 0x00616A56, 0x00616D51, 0x00475735, 0x00475934, 0x00455A33, 0x00415931, 0x00455C36, 0x004D6039, 0x004C5F38, 0x004D5F3A, 0x004E603B, 0x004F613C, 0x004F603E, 0x00516240, 0x00536442, 0x004D5F40,
        0x004D613E, 0x004F623B, 0x004E6237, 0x004F6336, 0x00506338, 0x0051633A, 0x0053623C, 0x0052633E, 0x0052633E, 0x0053643F, 0x0051623D, 0x0050613C, 0x0050613C, 0x0051623D, 0x0053643F, 0x0052633E, 0x00556641, 0x00566742, 0x0053643F, 0x0052633E,
        0x0052633E, 0x004F603B, 0x004A5B36, 0x00596B44, 0x003F512A, 0x004A5C35, 0x005D6F48, 0x003C4E27, 0x0040522B, 0x005F714A, 0x00394B24, 0x004C6036, 0x005A6E44, 0x0031441D, 0x004B5E37, 0x00566843, 0x00354722, 0x004F603E, 0x00576846, 0x004F603B,
        0x00455738, 0x00415231, 0x00455434, 0x00507065, 0x004E879C, 0x004989A8, 0x00568DA2, 0x00487687, 0x001B4038, 0x00304330, 0x00737974, 0x007B8285, 0x00C6D7D4, 0x00CDDEDB, 0x0098A1AA, 0x0085979E, 0x007D8F96, 0x007D8F96, 0x0083959C, 0x00899BA2,
        0x008FA1A8, 0x008FA1A8, 0x008799A0, 0x0084979E, 0x0085979E, 0x0090A0A6, 0x0088999C, 0x00758486, 0x008D9B9A, 0x00B5C1C1, 0x00AAB7B5, 0x006F7F60, 0x00738463, 0x00748462, 0x00758563, 0x005F6D51, 0xFFA1A998, 0xFFF9FDF7, 0xFFFDFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFCFF, 0xFFFDFFF6, 0x00909A7C, 0x00647249, 0x00818E68, 0x007A8662, 0x005B693F, 0x00546434, 0x00515A32, 0x004E572F, 0x004B542C, 0x00505931, 0x00515A32,
        0x00454E26, 0x00464F27, 0x00576038, 0x007B8A6B, 0x007D8B6F, 0x006F7C64, 0x00929D89, 0x00A0AA99, 0x00939D8C, 0x0095A08C, 0x00A9B4A0, 0x00959C8D, 0x00939B8A, 0x00818A75, 0x00505B41, 0x007C8969, 0x005D6C46, 0x0078895E, 0x0075865A, 0x0076875C,
        0x00798A5F, 0x0077885D, 0x0077885C, 0x0075865A, 0x0075865A, 0x007A8C5D, 0x00788A5B, 0x006D7A54, 0x0053603A, 0x005B6842, 0x00586741, 0x006A7953, 0x005F714A, 0x00586A43, 0x0033451E, 0x00566841, 0x003C4E27, 0x0053653E, 0x00475932, 0x00394B24,
        0x005A6C45, 0x005B6D46, 0x00778962, 0x0075875E, 0x00778960, 0x0076885F, 0x0073855C, 0x0073855C, 0x0076885F, 0x0076885F, 0x0073855C, 0x007B8967, 0x00708259, 0x004F6138, 0x00324024, 0x00778175, 0x00A5ACA9, 0x00667167, 0x00162412, 0x0023301A,
        0x00162111, 0x003C453B, 0x008F988E, 0x006D7868, 0x004D5B43, 0x002D3E1D, 0x006A7C57, 0x0075895E, 0x006D7F5A, 0x004C5B40, 0x00475341, 0x00455040, 0x003D4A34, 0x00586948, 0x00647750, 0x00475A33, 0x00435530, 0x004B5B39, 0x0048563A, 0x005C6951,
        0x00646D59, 0x00666D5E, 0x00444B3E, 0x003F3C2D, 0x002A3326, 0x00213229, 0x00313F3B, 0x00181C1D, 0x001C1719, 0x00161616, 0x00191F1E, 0x001B2215, 0x00191F14, 0x001E221C, 0x0022231F, 0x0020211D, 0x00262620, 0x0026271D, 0x00222418, 0x001E2014,
        0x001C1D13, 0x0025251F, 0x001A1B19, 0x001D1C1E, 0x00151718, 0x00161819, 0x00161819, 0x001C1C1C, 0x00151416, 0x00151416, 0x00151418, 0x001B1A1E, 0x001D1C20, 0x00151418, 0x00151416, 0x00191D1E, 0x00161517, 0x001D1C20, 0x001B2525, 0x003B514C,
        0x002F473B, 0x001C2919, 0x0040402E, 0x00383D2E, 0x00515A46, 0x004F5B3F, 0x00465634, 0x00495B36, 0x00465B34, 0x00445C34, 0x00475E38, 0x00495C35, 0x00495C35, 0x00485B34, 0x00495B36, 0x004A5C37, 0x004C5E39, 0x004D5E3C, 0x004C5D3B, 0x00495C3B,
        0x004D613E, 0x0051643D, 0x0051653A, 0x00516439, 0x0051633A, 0x0050613C, 0x00505E3C, 0x00556543, 0x00566644, 0x00576745, 0x00576745, 0x00566644, 0x00546442, 0x00546442, 0x00556543, 0x00576745, 0x00586846, 0x00566644, 0x00526240, 0x0051613F,
        0x00546442, 0x00576745, 0x00596947, 0x0050623B, 0x00394B24, 0x005D6F48, 0x003E5029, 0x0043552E, 0x0062744D, 0x0034461F, 0x0043552E, 0x0054683E, 0x00384C22, 0x0052653E, 0x004E613A, 0x00364823, 0x004A5C37, 0x00566745, 0x00546543, 0x00697A55,
        0x005F7152, 0x00556645, 0x004C5B3B, 0x004C6C61, 0x004C859A, 0x004A8AA9, 0x00548BA0, 0x00497788, 0x001C4139, 0x00304330, 0x00727873, 0x007D8487, 0x00C7D8D5, 0x00CCDDDA, 0x0097A0A9, 0x008A9CA3, 0x0086989F, 0x008799A0, 0x008799A0, 0x0084969D,
        0x00889AA1, 0x008FA1A8, 0x0090A2A9, 0x0091A3AA, 0x00879A9F, 0x0093A3A9, 0x008F9EA1, 0x006F7C7E, 0x008B9797, 0x00B4C1BF, 0x00A0ABA9, 0x006A7A5B, 0x00748564, 0x00738361, 0x00738361, 0x005F6D51, 0xFFA2AA99, 0xFFFCFFFA, 0xFFFDFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFCFF, 0xFFFDFFF6, 0x008C9678, 0x0065734A, 0x0083906A, 0x0085916D, 0x007A885E, 0x007C8C5C, 0x00829067, 0x007D8B62, 0x0079875E, 0x007A885F, 0x007D8B62,
        0x007E8C63, 0x007D8B62, 0x0077855C, 0x00707F5F, 0x00758464, 0x006E7D5D, 0x00788768, 0x006C7B5C, 0x006B7A5B, 0x00758465, 0x007A896A, 0x00788466, 0x00687456, 0x007B8868, 0x00687654, 0x006C7B55, 0x00697950, 0x0085966B, 0x0074855A, 0x0076875C,
        0x0075865B, 0x00798A5E, 0x007C8D61, 0x00768859, 0x00738556, 0x00768859, 0x00768958, 0x007B8862, 0x00707D57, 0x0057643E, 0x005B6A44, 0x0051603A, 0x0041532C, 0x0062744D, 0x00354720, 0x004C5B35, 0x004E5D37, 0x00495832, 0x0052613B, 0x004C5B35,
        0x004D5C36, 0x00606F49, 0x0064734D, 0x0074865D, 0x007A8C63, 0x007B8D64, 0x00778960, 0x0075875E, 0x00778960, 0x00778960, 0x0073855C, 0x0072805E, 0x008A9C73, 0x005D7045, 0x00314020, 0x006B7568, 0x00A4ABA8, 0x00AAB4AE, 0x008A968A, 0x0066735D,
        0x00717B6E, 0x00A6ADAA, 0x00A1A8A3, 0x00919C8C, 0x00657458, 0x00415230, 0x0070815F, 0x006C8154, 0x0070835C, 0x00485839, 0x002B3921, 0x002A3721, 0x002F3E22, 0x00495A38, 0x00475A33, 0x00475A33, 0x004C5E39, 0x004D5D3B, 0x00475539, 0x006B7860,
        0x00737C68, 0x00545B4C, 0x002A3124, 0x002F2B20, 0x001F271C, 0x001A2A23, 0x002E3C38, 0x00171C1B, 0x001B1716, 0x00181915, 0x00222A23, 0x002E3526, 0x0020271A, 0x001B1F19, 0x00181917, 0x00161616, 0x001F1D1C, 0x0021201C, 0x0022221C, 0x0021201C,
        0x00201F1B, 0x00272622, 0x001C1D1B, 0x001E1E1E, 0x00151717, 0x00181A1A, 0x00191B1C, 0x001C1D1B, 0x001B1B1B, 0x001D1C1E, 0x0019181C, 0x0018171B, 0x0019181A, 0x001C1D1B, 0x002C2D29, 0x00202621, 0x00131412, 0x00161616, 0x0016211F, 0x00354B46,
        0x00284036, 0x00172416, 0x003D3C2E, 0x002F3327, 0x00555D4C, 0x005E6851, 0x004F5E3F, 0x00485937, 0x00475C36, 0x004C623F, 0x004E6441, 0x0051643D, 0x0052643F, 0x0051633E, 0x0051633E, 0x00536442, 0x00566745, 0x00556645, 0x00536443, 0x00546647,
        0x00566948, 0x00586A45, 0x00586B44, 0x00596B44, 0x00596A45, 0x00586747, 0x005A664A, 0x00576745, 0x00596947, 0x005A6A48, 0x005A6A48, 0x00586846, 0x00576745, 0x00566644, 0x00566644, 0x00576745, 0x005A6A48, 0x005C6C4A, 0x005B6B49, 0x00596947,
        0x00576745, 0x00556543, 0x00536341, 0x0053653E, 0x0064764F, 0x003B4D26, 0x0044562F, 0x005F714A, 0x0043552E, 0x00455730, 0x005D6F48, 0x00364A20, 0x00495D33, 0x005D7049, 0x00394C25, 0x00445631, 0x005C6E49, 0x00465735, 0x006C7D5B, 0x006C7D58,
        0x00667859, 0x005C6D4C, 0x00495838, 0x00446459, 0x004B8499, 0x004E8EAD, 0x00558CA1, 0x004B798A, 0x001F443C, 0x00314431, 0x00727873, 0x007E8588, 0x00C8D9D6, 0x00CBDCD9, 0x0097A0A9, 0x0086989F, 0x0086989F, 0x008B9DA4, 0x008D9FA6, 0x00899BA2,
        0x00899BA2, 0x008D9FA6, 0x008B9DA4, 0x008EA1A6, 0x0084949A, 0x008B9C9F, 0x008C9B9D, 0x006F7D7C, 0x008D9999, 0x00B7C2C0, 0x00A7B2B0, 0x006D7D5E, 0x00788968, 0x00768664, 0x00788866, 0x00616F53, 0xFFA1A998, 0xFFFBFFF9, 0xFFFAFCFD, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFDFF, 0xFFFFFFF8, 0x008E987A, 0x0065734A, 0x007C8963, 0x007B8763, 0x0078865C, 0x007D8D5D, 0x0073855E, 0x007A8C65, 0x007F916A, 0x00788A63, 0x0073855E,
        0x0074865F, 0x00778962, 0x00798B64, 0x007D8D6B, 0x00798A65, 0x00768861, 0x00809269, 0x007C8F64, 0x0084976C, 0x0081936A, 0x00798B62, 0x007A8B5F, 0x008A9B6F, 0x0088996E, 0x00798A5F, 0x007B8B62, 0x007C8C63, 0x0073825C, 0x0075845E, 0x007D8D64,
        0x00798960, 0x0077885D, 0x0076875C, 0x00748559, 0x00708155, 0x00718256, 0x00788A5B, 0x0074815B, 0x00818E68, 0x006B7852, 0x004C5B35, 0x00576640, 0x0054663F, 0x003A4C25, 0x005B6D46, 0x0045542E, 0x0055643E, 0x0046552F, 0x0056653F, 0x00576640,
        0x00485731, 0x00596842, 0x0055643E, 0x0066784F, 0x0071835A, 0x00788A61, 0x0076885F, 0x0075875E, 0x00788A61, 0x00778960, 0x0074865D, 0x00758361, 0x006F8158, 0x0074885B, 0x00344422, 0x005F6A5A, 0x00A7AEAB, 0x00868F8C, 0x00828D85, 0x0097A48E,
        0x0098A197, 0x0084898A, 0x00A2A9A6, 0x009CA896, 0x00354625, 0x00556644, 0x007A8B6A, 0x00718659, 0x00697D53, 0x00566745, 0x00667559, 0x006C7B5F, 0x00364627, 0x00374924, 0x0050633C, 0x0042552E, 0x0042542F, 0x00425230, 0x00455337, 0x0078856D,
        0x0099A28E, 0x00686F60, 0x002C3326, 0x00231D18, 0x00191F1A, 0x001B2A26, 0x00323F3D, 0x001D2220, 0x00221F1A, 0x0022261B, 0x00313B2E, 0x00454D3C, 0x002D3427, 0x0022271E, 0x001C1D1B, 0x00181719, 0x001D1A1C, 0x001B1919, 0x001D1B1A, 0x001D1A1C,
        0x001D1A1C, 0x00201E1D, 0x001A1B17, 0x001F201C, 0x00171B16, 0x001E221D, 0x001C201B, 0x00171A11, 0x00181915, 0x001D1D1D, 0x0019181A, 0x00181719, 0x001C1D19, 0x002B2E25, 0x004B4F43, 0x00323A2F, 0x001E2118, 0x001B1C18, 0x001A2522, 0x003B514C,
        0x002E453D, 0x00121D15, 0x002C2A20, 0x002F3229, 0x005E6558, 0x00616A55, 0x0049573B, 0x004B5B3C, 0x00506342, 0x004D6241, 0x00465B3B, 0x0050613F, 0x00526341, 0x00526341, 0x00516241, 0x00526342, 0x00566647, 0x00556546, 0x00526243, 0x00536548,
        0x00516344, 0x00536443, 0x00556644, 0x00576745, 0x00576647, 0x0058654B, 0x005C6550, 0x00556644, 0x00566745, 0x00576846, 0x00566745, 0x00546543, 0x00536442, 0x00536442, 0x00546543, 0x00546543, 0x00556644, 0x00566745, 0x00566745, 0x00566745,
        0x00566745, 0x00576846, 0x00586947, 0x005F714A, 0x005B6D46, 0x004B5D36, 0x00596B44, 0x0040522B, 0x003B4D26, 0x0061734C, 0x00384A23, 0x004C6036, 0x0061754B, 0x0033461F, 0x00465932, 0x00566843, 0x004B5D38, 0x00748563, 0x006B7C5A, 0x006D7E59,
        0x00697B5C, 0x005F704F, 0x004B5A3A, 0x0045655A, 0x004E879C, 0x005191B0, 0x00548BA0, 0x004D7B8C, 0x0021463E, 0x00324532, 0x00727873, 0x007F8689, 0x00C8D9D6, 0x00CADBD8, 0x00969FA8, 0x007F9198, 0x007C8E95, 0x0083959C, 0x008D9FA6, 0x0090A2A9,
        0x0090A2A9, 0x008B9DA4, 0x00809299, 0x00839399, 0x00809096, 0x00829194, 0x00859294, 0x006F7B7B, 0x00828D8B, 0x009DA8A6, 0x009BA4A1, 0x0069795A, 0x00708160, 0x006E7E5C, 0x00748462, 0x005E6C50, 0xFF9EA695, 0xFFFCFFFA, 0xFFF8FAFB, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFBF9FF, 0xFFFFFFF8, 0x00909A7C, 0x006A784F, 0x00808D67, 0x007B8763, 0x007B895F, 0x007F8F5F, 0x00788B64, 0x00788B64, 0x00798C65, 0x00798C65, 0x007C8F68,
        0x00798C65, 0x00758861, 0x007F926B, 0x00768762, 0x007A8C63, 0x00728659, 0x00728657, 0x006F8453, 0x006E8352, 0x00617546, 0x006A7E4F, 0x00677B46, 0x00617540, 0x00627544, 0x007D8F60, 0x006F8055, 0x00798862, 0x00778561, 0x007A8866, 0x00778660,
        0x00798862, 0x0074835D, 0x00718158, 0x00798960, 0x00798A5F, 0x00728358, 0x0077885D, 0x007D8A64, 0x0074815B, 0x007E8B65, 0x0074835D, 0x0054633D, 0x00576942, 0x0044562F, 0x004B5D36, 0x0056653F, 0x0042512B, 0x005C6B45, 0x0043522C, 0x00495832,
        0x005D6C46, 0x003D4C26, 0x00606F49, 0x0054663D, 0x0063754C, 0x00708259, 0x0073855C, 0x0074865D, 0x00778960, 0x00788A61, 0x0074865D, 0x00768462, 0x00798B62, 0x007D9164, 0x005A6A48, 0x00313D2B, 0x005B625F, 0x00A7AFAE, 0x0086908A, 0x00818E78,
        0x008D968C, 0x00ABB0B3, 0x008B9190, 0x003C4836, 0x00425332, 0x0071835E, 0x00758665, 0x006D8255, 0x0071855B, 0x00738560, 0x00708160, 0x005E6E4F, 0x00495A39, 0x00586A45, 0x0041552B, 0x004F623B, 0x00455732, 0x004A5A38, 0x0049573B, 0x0066735B,
        0x00969F8B, 0x00697061, 0x0021281B, 0x001C1414, 0x00151A18, 0x00182624, 0x002F3C3A, 0x00171D18, 0x0017150D, 0x00171C0D, 0x00293521, 0x002F3824, 0x00181F10, 0x00141910, 0x00171816, 0x0019181A, 0x001F1B20, 0x00191618, 0x001B1919, 0x001E1A20,
        0x001D191E, 0x001C1A1A, 0x00171814, 0x001E2118, 0x0013180F, 0x001A1F16, 0x0013180F, 0x001C2014, 0x001A1D14, 0x001D1E1A, 0x001B1B1B, 0x001A1B19, 0x00191C13, 0x00212617, 0x003E4431, 0x00273121, 0x0014180C, 0x0012140E, 0x00141F1C, 0x003C514E,
        0x00324843, 0x000E1812, 0x00191510, 0x002A2C26, 0x00696F64, 0x006A7261, 0x0048553D, 0x00465539, 0x00485A3B, 0x00465A3D, 0x004B5F42, 0x004C5D3C, 0x004E5F3E, 0x004F603F, 0x004E5E3F, 0x004F5F40, 0x00536246, 0x00526145, 0x004F5E42, 0x00506146,
        0x004D5F42, 0x004F5F40, 0x00536443, 0x00566546, 0x00546147, 0x00535F49, 0x0057604C, 0x00546544, 0x00546544, 0x00536443, 0x00526342, 0x00506140, 0x004F603F, 0x00506140, 0x00526342, 0x00546544, 0x00546544, 0x00546544, 0x00556645, 0x00546544,
        0x00536443, 0x00536443, 0x00546544, 0x0053653E, 0x0054663F, 0x00596B44, 0x003C4E27, 0x00485A33, 0x005A6C45, 0x003C4E27, 0x00475932, 0x0063774D, 0x002A3E14, 0x0052653E, 0x00586B44, 0x00394B26, 0x00546641, 0x00617250, 0x00596A48, 0x00596A45,
        0x00526445, 0x00495A39, 0x00394828, 0x0039594E, 0x00488196, 0x004F8FAE, 0x00548BA0, 0x004E7C8D, 0x00234840, 0x00324532, 0x00727873, 0x0080878A, 0x00C9DAD7, 0x00CADBD8, 0x00969FA8, 0x00778990, 0x00708289, 0x0074868D, 0x0083959C, 0x0090A2A9,
        0x0093A5AC, 0x008799A0, 0x0074868D, 0x0076868C, 0x007F9093, 0x007E8D90, 0x00869395, 0x007A8686, 0x00838E8C, 0x008F9A97, 0x0097A09D, 0x00748465, 0x00758665, 0x0070805E, 0x00778765, 0x005F6D51, 0xFFA1A998, 0xFFFDFFFB, 0xFFFDFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFCFF, 0xFFFFFFF7, 0x008E9979, 0x00637147, 0x007D8B62, 0x00818E68, 0x005C6B3F, 0x005B6C39, 0x005E6A40, 0x00626E44, 0x00636F45, 0x00616D43, 0x005D693F,
        0x005D693F, 0x00606C42, 0x00626E44, 0x006F7F5D, 0x004A593A, 0x0048553D, 0x005C6753, 0x0049553F, 0x00354327, 0x0032431E, 0x0036491E, 0x002B3820, 0x00313E24, 0x0039472B, 0x003A4727, 0x00475531, 0x0053603A, 0x0078865D, 0x007E8C62, 0x00768C5C,
        0x0074895C, 0x00708558, 0x007A8E61, 0x00778A5F, 0x006E7F54, 0x0076865D, 0x0077875E, 0x0075855C, 0x0078885F, 0x00708057, 0x007A8A61, 0x006B7B52, 0x0056663D, 0x005A6A41, 0x0047572E, 0x0051603A, 0x0055643E, 0x00404F29, 0x005E6D47, 0x00475630,
        0x004C5B35, 0x005D6C46, 0x003C4B25, 0x0066754F, 0x004A5933, 0x0064734D, 0x007F8E68, 0x0073825C, 0x007A8963, 0x0072815B, 0x00788761, 0x007A8B60, 0x0074845B, 0x007B8B62, 0x007C8C63, 0x005A6943, 0x0034431D, 0x0042502C, 0x006D7B57, 0x00778464,
        0x00748161, 0x0053613F, 0x00354321, 0x00465430, 0x006E7C58, 0x007C8A66, 0x0075835F, 0x00708057, 0x0073835A, 0x00798960, 0x00607047, 0x00495930, 0x005E6E45, 0x004A5A31, 0x0054643B, 0x0045542E, 0x00495733, 0x00495735, 0x004C583A, 0x005D684E,
        0x00727B66, 0x006D7564, 0x00343C2B, 0x00111614, 0x001A1F1E, 0x0025292A, 0x002E3135, 0x00141819, 0x001A1F1D, 0x00111811, 0x00171F14, 0x00181917, 0x00191A18, 0x001A1B19, 0x001A1B19, 0x00191A18, 0x00191A18, 0x00191A18, 0x00191A18, 0x00181818,
        0x00191919, 0x00191919, 0x001A1A1A, 0x001A1A1A, 0x00191919, 0x00181818, 0x00181818, 0x001A1B17, 0x001B1C18, 0x001C1D1B, 0x001B1C1A, 0x001A1A1A, 0x0019181A, 0x0019181A, 0x0019181A, 0x001A1817, 0x00141414, 0x0015161A, 0x0014171C, 0x0032393C,
        0x002F3939, 0x0015231F, 0x00091912, 0x001F251A, 0x00686F60, 0x007C8570, 0x005A684C, 0x00526141, 0x00576745, 0x00516240, 0x00516241, 0x00576745, 0x00556543, 0x00546442, 0x005B6B49, 0x005F6F4D, 0x005E6E4C, 0x005F6F4D, 0x005E6E4C, 0x005B6C47,
        0x005B6C47, 0x005A6B46, 0x00596A45, 0x00596A45, 0x00586944, 0x00576843, 0x00576843, 0x00576944, 0x00576944, 0x00576944, 0x00576944, 0x00576944, 0x00576944, 0x00576944, 0x00576944, 0x00596A45, 0x00596A45, 0x00596A45, 0x00586944, 0x00586944,
        0x00586944, 0x00586944, 0x00576843, 0x005B6D48, 0x00556742, 0x005A6C47, 0x005F714C, 0x0051633E, 0x003E502B, 0x00475934, 0x0060724D, 0x0031431E, 0x00536540, 0x00566843, 0x003B4D28, 0x00485A35, 0x005C6E49, 0x00546641, 0x00556742, 0x00566343,
        0x004B5D40, 0x00455435, 0x00485436, 0x0057746B, 0x004C8299, 0x00508DAF, 0x00558BA2, 0x00497789, 0x001D423A, 0x002F4130, 0x00717772, 0x0080868B, 0x00CBDBDA, 0x00CCDCDB, 0x00949DA7, 0x0074868D, 0x006F8188, 0x006D7F86, 0x007A8C93, 0x008A9CA3,
        0x008EA0A7, 0x0086989F, 0x007A8C93, 0x00798C93, 0x0075888F, 0x00809398, 0x00809096, 0x0079888B, 0x00879397, 0x00A6B3B5, 0x00C9D5D7, 0x007E8A78, 0x006C7A62, 0x00798868, 0x00778863, 0x005F6E4E, 0xFF9EA792, 0xFFFCFFFA, 0xFFFDFEFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF9F7FD, 0xFFFFFFF7, 0x008E9979, 0x0067754B, 0x00818F66, 0x0078855F, 0x00435226, 0x003C4D1A, 0x0039451B, 0x003C481E, 0x002B370D, 0x00313D13, 0x00414D23,
        0x00354117, 0x00323E14, 0x00414D23, 0x006E7C60, 0x0054604A, 0x00596255, 0x00929992, 0x00A7AEA7, 0x00A7AFA4, 0x00A4AF9B, 0x00AAB79F, 0x00A7B1A0, 0x00B0BBA7, 0x008C9882, 0x00465137, 0x004C583A, 0x00505B3B, 0x007B8763, 0x0078855F, 0x0075895E,
        0x007A8E63, 0x00778B60, 0x00788B60, 0x00798D60, 0x007A8B5F, 0x007B8C60, 0x0078895D, 0x0075855C, 0x0077875E, 0x0073835A, 0x007B8B62, 0x00798960, 0x005F6F46, 0x0056663D, 0x00607047, 0x0041502A, 0x004F5E38, 0x0061704A, 0x003A4923, 0x0063724C,
        0x0045542E, 0x004F5E38, 0x0062714B, 0x00374620, 0x00687751, 0x0054633D, 0x0064734D, 0x0086956F, 0x006D7C56, 0x007E8D67, 0x00778660, 0x0078895E, 0x00728259, 0x00728259, 0x007A8A61, 0x00778660, 0x0061704A, 0x00465430, 0x00364420, 0x00293616,
        0x00384525, 0x00485634, 0x005C6A48, 0x00768460, 0x0083916D, 0x007E8C68, 0x00778660, 0x0078885F, 0x006E7E55, 0x006A7A51, 0x004D5D34, 0x005E6E45, 0x0045552C, 0x00596940, 0x0046562D, 0x0053623C, 0x0053623C, 0x00495735, 0x005F6C4C, 0x00515D41,
        0x006B755E, 0x006F7864, 0x00212A16, 0x00151A18, 0x000E1312, 0x00292D2E, 0x003C3F43, 0x000E1115, 0x00121716, 0x00171D18, 0x00161E14, 0x00171A18, 0x00181B19, 0x00181B19, 0x00181B19, 0x00171A18, 0x00171A18, 0x00181B19, 0x00181B19, 0x00181A1A,
        0x00181A1A, 0x00181A1A, 0x00181A1A, 0x00171919, 0x00171919, 0x00171919, 0x00171919, 0x00161917, 0x00171A18, 0x00181A1A, 0x00181A1A, 0x0017191A, 0x0017191A, 0x0018191D, 0x00191A1E, 0x00171919, 0x00181C1D, 0x0015181C, 0x00212429, 0x0051555A,
        0x00384040, 0x000B1411, 0x00131E16, 0x00252C1F, 0x00697160, 0x0078826B, 0x00526142, 0x00485836, 0x004F5F3D, 0x004C5D3B, 0x004C5D3C, 0x004E5E3C, 0x00465634, 0x004E5E3C, 0x00566644, 0x004D5D3B, 0x004D5D3B, 0x00546442, 0x004D5D3B, 0x00546540,
        0x00546540, 0x0053643F, 0x0053643F, 0x0052633E, 0x0051623D, 0x0051623D, 0x0051623D, 0x0051633E, 0x0051633E, 0x0051633E, 0x0051633E, 0x0051633E, 0x0051633E, 0x0051633E, 0x0051633E, 0x00556641, 0x00556641, 0x00556641, 0x00546540, 0x00546540,
        0x00546540, 0x00546540, 0x00546540, 0x0050623D, 0x00566843, 0x00566843, 0x0052643F, 0x00536540, 0x00556742, 0x004B5D38, 0x003A4C27, 0x004C5E39, 0x00586A45, 0x003C4E29, 0x00485A35, 0x005E704B, 0x004D5F3A, 0x004E603B, 0x00546641, 0x0053613F,
        0x004A5C3F, 0x00475637, 0x00465234, 0x00516E65, 0x004B8198, 0x00528FB1, 0x00558BA2, 0x004D7B8D, 0x001F443C, 0x002F4130, 0x00707671, 0x0080868B, 0x00CADAD9, 0x00CBDBDA, 0x00959EA8, 0x0085979E, 0x0083959C, 0x0082949B, 0x008799A0, 0x008C9EA5,
        0x008EA0A7, 0x008B9DA4, 0x008799A0, 0x0080939A, 0x007A8D94, 0x0082959A, 0x007F8F95, 0x00768588, 0x00849094, 0x00A7B4B6, 0x00CEDADC, 0x0099A593, 0x006F7D65, 0x00707F5F, 0x00748560, 0x00606F4F, 0xFF9FA893, 0xFFF9FDF7, 0xFFFBFCFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFCFF, 0xFFFFFFF7, 0x008C9777, 0x0066744A, 0x0085936A, 0x0077845E, 0x003E4D21, 0x003D4E1B, 0x006B774D, 0x005F6B41, 0x00434F25, 0x004B572D, 0x005A663C,
        0x00424E24, 0x003A461C, 0x004C582E, 0x006B7761, 0x005D6757, 0x00686E69, 0x00BFC2C6, 0x00E9EBF3, 0x00EFF2F7, 0x00E5E9EA, 0x00EAEFED, 0x00E9F0E9, 0x00F1F8F1, 0x00AEB6AB, 0x00454C3D, 0x00545D49, 0x00515942, 0x006E775C, 0x00656F51, 0x00566647,
        0x004C5C3D, 0x00485737, 0x004C5D38, 0x0056653F, 0x00516237, 0x004E5F33, 0x00607041, 0x007B8B62, 0x0077875E, 0x0074845B, 0x00718158, 0x007D8D64, 0x007A8A61, 0x005D6D44, 0x0054643B, 0x005F6E48, 0x00404F29, 0x004A5933, 0x005C6B45, 0x0035441E,
        0x00687751, 0x0042512B, 0x004B5A34, 0x00606F49, 0x00374620, 0x0062714B, 0x0055643E, 0x0061704A, 0x007F8E68, 0x0076855F, 0x006E7D57, 0x00738459, 0x00798960, 0x007B8B62, 0x007A8A61, 0x007D8C66, 0x0082916B, 0x007C8A66, 0x0072805C, 0x00758361,
        0x00788664, 0x007C8A68, 0x0083916D, 0x0084926E, 0x007A8864, 0x0071805A, 0x0073825C, 0x007D8D64, 0x006B7B52, 0x0057673E, 0x00627249, 0x0048582F, 0x00697950, 0x0043532A, 0x0057673E, 0x0048582F, 0x004C5B35, 0x00586642, 0x00435030, 0x005E6A4C,
        0x00636E54, 0x004E5841, 0x00242E17, 0x00151B16, 0x00161B19, 0x001A1E1F, 0x001C1F23, 0x000C0F13, 0x001E2223, 0x00161B1A, 0x000F1510, 0x0014191A, 0x0014191A, 0x0014191A, 0x0014191A, 0x0014191A, 0x0014191A, 0x0014191A, 0x0014191A, 0x00121718,
        0x00111617, 0x00111617, 0x00101516, 0x00101516, 0x00101516, 0x00101516, 0x000F1415, 0x00111617, 0x00121718, 0x00131819, 0x00121718, 0x00111617, 0x00111617, 0x0012171A, 0x0013181B, 0x000A1212, 0x0012191C, 0x0014181D, 0x000C1015, 0x001C1F24,
        0x001C2021, 0x00151914, 0x00191D17, 0x00242C1B, 0x005F6854, 0x006F7A60, 0x00516040, 0x00485934, 0x004D5E39, 0x00485937, 0x00475836, 0x00495A35, 0x00546540, 0x0052633E, 0x004A5B36, 0x00546540, 0x0050613C, 0x00475833, 0x005E6F4A, 0x00576843,
        0x00566742, 0x00566742, 0x00566742, 0x00556641, 0x00546540, 0x00546540, 0x00546540, 0x00546641, 0x00546641, 0x00546641, 0x00546641, 0x00546641, 0x00546641, 0x00546641, 0x00546641, 0x00546540, 0x00546540, 0x00546540, 0x0053643F, 0x0053643F,
        0x0053643F, 0x0053643F, 0x0053643F, 0x0052643F, 0x0052643F, 0x0051633E, 0x0051633E, 0x00546641, 0x00536540, 0x004A5C37, 0x003F512C, 0x00556742, 0x00374924, 0x004C5E39, 0x00536540, 0x0051633E, 0x00697B56, 0x006F815C, 0x00738560, 0x00707E5C,
        0x00627457, 0x00596848, 0x00475434, 0x0047645B, 0x00457B92, 0x00518EAE, 0x005389A0, 0x00507E90, 0x0021463E, 0x002E402F, 0x006F7570, 0x0080868B, 0x00C9D9D8, 0x00CADAD9, 0x00969FA9, 0x008B9DA4, 0x008B9DA4, 0x008A9CA3, 0x0086989F, 0x0085979E,
        0x00889AA1, 0x008C9EA5, 0x0090A2A9, 0x00889BA2, 0x007F9299, 0x0085989D, 0x007F8F95, 0x00738285, 0x00808C90, 0x00A6B3B5, 0x00D1DDDF, 0x00DBE7D5, 0x008C9A82, 0x00778666, 0x00768762, 0x00606F4F, 0xFFA0A994, 0xFFFCFFFA, 0xFFFDFEFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFDFF, 0xFFFFFFF7, 0x008A9575, 0x00647248, 0x0087956C, 0x00798660, 0x00455428, 0x004E5F2C, 0x006E7A50, 0x005C683E, 0x005C683E, 0x00647046, 0x005E6A40,
        0x00445026, 0x00364218, 0x0049552B, 0x006D7B5F, 0x0066715D, 0x00777E77, 0x00CED1D5, 0x00E8E9F3, 0x00E3E3EF, 0x00D3D5DD, 0x00D2D5DA, 0x00E5E8EC, 0x00EBEFF0, 0x00B1B6B4, 0x005B5F59, 0x005E6558, 0x00484E3D, 0x00414833, 0x00434B34, 0x00555D52,
        0x00454E41, 0x003B4535, 0x003A432E, 0x00455036, 0x00424C2E, 0x00374221, 0x004A5632, 0x00738459, 0x00728358, 0x007A8B60, 0x0074855A, 0x00718257, 0x007C8D62, 0x0076875C, 0x0065764B, 0x0053623C, 0x005C6B45, 0x003A4923, 0x0051603A, 0x005C6B45,
        0x0036451F, 0x0066754F, 0x003F4E28, 0x004F5E38, 0x00596842, 0x003B4A24, 0x0062714B, 0x004C5B35, 0x006D7C56, 0x0076855F, 0x007D8C66, 0x0077885D, 0x0078885F, 0x0076865D, 0x00728259, 0x0072815B, 0x00778660, 0x007C8A66, 0x007E8C68, 0x00849270,
        0x00859371, 0x00808E6A, 0x00798763, 0x00768460, 0x00788761, 0x007B8A64, 0x007E8D67, 0x006B7950, 0x005C6A41, 0x005B6940, 0x004E5C33, 0x00647249, 0x0048562D, 0x005E6C43, 0x0055633A, 0x004E5E35, 0x00596842, 0x0041502A, 0x005C6A48, 0x004C5939,
        0x00626E50, 0x00707C60, 0x004C583C, 0x0011190E, 0x00161D16, 0x00111614, 0x00111516, 0x0013161A, 0x00292C30, 0x00262A2B, 0x002D3231, 0x00272F2F, 0x00272F2F, 0x00272F2F, 0x00283030, 0x00293131, 0x00283030, 0x00272F2F, 0x00262E2E, 0x002A3232,
        0x002B3333, 0x002B3333, 0x002B3333, 0x002B3333, 0x00293131, 0x00283030, 0x00283030, 0x002B3235, 0x002B3235, 0x002B3333, 0x002A3232, 0x00283030, 0x00283030, 0x00293131, 0x002A3231, 0x00232F2F, 0x00283134, 0x00252C2F, 0x0015191E, 0x00151718,
        0x00212220, 0x0022231A, 0x0018170D, 0x003A432E, 0x00626D53, 0x00707C5E, 0x0063744F, 0x0064764F, 0x006A7C55, 0x00677954, 0x00687957, 0x00677551, 0x0072805C, 0x00616F4B, 0x00717F5B, 0x005B6945, 0x0043512D, 0x0063714D, 0x004F5D39, 0x005A6B46,
        0x005A6B46, 0x005A6B46, 0x00596A45, 0x00596A45, 0x00596A45, 0x00586944, 0x00586944, 0x00586A45, 0x00586A45, 0x00586A45, 0x00586A45, 0x00586A45, 0x00586A45, 0x00586A45, 0x00586A45, 0x005B6C47, 0x005B6C47, 0x005A6B46, 0x005A6B46, 0x005A6B46,
        0x005A6B46, 0x00596A45, 0x00596A45, 0x005C6E49, 0x00566843, 0x00566843, 0x005C6E49, 0x005A6C47, 0x00536540, 0x00546641, 0x005D6F4A, 0x002C3E19, 0x004B5D38, 0x004E603B, 0x00576944, 0x006D7F5A, 0x0070825D, 0x006E805B, 0x006B7D58, 0x00707E5C,
        0x00687A5B, 0x00667555, 0x00515E3E, 0x004C6A5F, 0x004C8398, 0x005491B1, 0x0052899E, 0x004E7C8E, 0x001F443C, 0x002B3D2C, 0x006D736E, 0x0080868B, 0x00C9D9D8, 0x00C9D9D8, 0x0097A0AA, 0x00889AA1, 0x00889AA1, 0x008B9DA4, 0x00889AA1, 0x00899BA2,
        0x008C9EA5, 0x00889AA1, 0x008799A0, 0x00889BA2, 0x007F9299, 0x0085989D, 0x00809096, 0x00728184, 0x007C888C, 0x00A2AFB1, 0x00D1DDDF, 0x00DCE8D6, 0x0084927A, 0x00748363, 0x00788964, 0x00627151, 0xFFA4AD98, 0xFFFDFFFB, 0xFFFDFEFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFDFBFF, 0xFFFFFFF7, 0x008C9777, 0x0067754B, 0x0087956C, 0x0075825C, 0x00415024, 0x004D5E2B, 0x00525E34, 0x004A562C, 0x00647046, 0x006B774D, 0x0069754B,
        0x0058643A, 0x0038441A, 0x004D592F, 0x00778863, 0x00707E62, 0x008C9686, 0x00D1D6D4, 0x00DBDEE2, 0x00D1D4D9, 0x00CACDD1, 0x00C4C8C9, 0x00CDCED8, 0x00DDDFE7, 0x00BFC2C6, 0x00909391, 0x0083887F, 0x00696E5F, 0x00585F4A, 0x00767E67, 0x008F9296,
        0x00767A7B, 0x00585B59, 0x004F534D, 0x00787C70, 0x00909685, 0x006C735E, 0x0050563F, 0x007D8E63, 0x0078895E, 0x0076875C, 0x007A8B60, 0x00738459, 0x00738459, 0x007F9065, 0x007D8E63, 0x0066754F, 0x0052613B, 0x0064734D, 0x003E4D27, 0x00586741,
        0x005A6943, 0x003D4C26, 0x005F6E48, 0x0041502A, 0x0056653F, 0x00576640, 0x003A4923, 0x00697852, 0x0053623C, 0x0072815B, 0x006F7E58, 0x0077885D, 0x0077875E, 0x0077875E, 0x0078885F, 0x00798862, 0x00778660, 0x00778561, 0x00778561, 0x00768460,
        0x007A8864, 0x007B8965, 0x00788662, 0x0076855F, 0x00788761, 0x0075855C, 0x006E7E55, 0x0058663D, 0x005E6C43, 0x00505E35, 0x005F6D44, 0x0056643B, 0x0057653C, 0x0058663D, 0x0058663D, 0x005D6D44, 0x0043532A, 0x005E6D47, 0x0054633D, 0x00677551,
        0x0072805E, 0x007C8A68, 0x00727F5F, 0x004A5541, 0x00182212, 0x000D150B, 0x001D2220, 0x00141819, 0x001C2021, 0x001D2122, 0x001A1F1E, 0x00151D1C, 0x00161E1D, 0x00171F1E, 0x00192120, 0x001A2221, 0x00192120, 0x00161E1D, 0x00131B1A, 0x00192120,
        0x001A2221, 0x001C2423, 0x001D2524, 0x001D2524, 0x001B2322, 0x00192120, 0x00171F1E, 0x00161E1E, 0x00161E1E, 0x00161E1E, 0x00171F1E, 0x0017201D, 0x0018211E, 0x0018221C, 0x0018221C, 0x00121D1B, 0x001C2725, 0x00131B1B, 0x00161B1A, 0x001E211F,
        0x0015160D, 0x001B1B0D, 0x003E402D, 0x00707B61, 0x007A8668, 0x007A8866, 0x0073855E, 0x0075875E, 0x0074865F, 0x0072845F, 0x00788967, 0x00778660, 0x0075845E, 0x00798862, 0x0071805A, 0x005D6C46, 0x004F5E38, 0x004A5933, 0x004B5A34, 0x0053643F,
        0x0053643F, 0x0053643F, 0x0053643F, 0x0053643F, 0x0052633E, 0x0052633E, 0x0052633E, 0x0052643F, 0x0052643F, 0x0052643F, 0x0052643F, 0x0052643F, 0x0052643F, 0x0052643F, 0x0052643F, 0x00546540, 0x00546540, 0x00546540, 0x00546540, 0x0053643F,
        0x0053643F, 0x0053643F, 0x0053643F, 0x004A5C37, 0x004E603B, 0x004E603B, 0x004B5D38, 0x004E603B, 0x00536540, 0x0050623D, 0x00465833, 0x004D5F3A, 0x005B6D48, 0x00586A45, 0x00657752, 0x00778964, 0x0072845F, 0x006E805B, 0x006F815C, 0x00687652,
        0x00617354, 0x0060704E, 0x00475533, 0x00466459, 0x004C8398, 0x005391AF, 0x00538A9F, 0x00497789, 0x001C4139, 0x00283A29, 0x006C726D, 0x0082888D, 0x00CADAD9, 0x00C7D7D6, 0x0097A0AA, 0x0082949B, 0x0081939A, 0x008B9DA4, 0x008FA1A8, 0x0097A9B0,
        0x009BADB4, 0x0086989F, 0x00798B92, 0x007F9299, 0x00778A91, 0x0082959A, 0x00839399, 0x00768588, 0x007D898D, 0x00A2AFB1, 0x00D2DEE0, 0x00C0CCBA, 0x00717F67, 0x006F7E5E, 0x00758661, 0x005C6B4B, 0xFFA3AC97, 0xFFFDFFFB, 0xFFFDFEFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFBF9FF, 0xFFFFFFF7, 0x008C9777, 0x0069774D, 0x0086946B, 0x0076835D, 0x00435226, 0x004A5B28, 0x006A764C, 0x005D693F, 0x005F6B41, 0x005C683E, 0x007A865C,
        0x00748056, 0x003F4B21, 0x004D592F, 0x006A7C55, 0x00677657, 0x0098A291, 0x00CCD3CC, 0x00DDE2E1, 0x00DEE2E3, 0x00E8EDEB, 0x00E4EAE5, 0x00D9DAE4, 0x00E3E5ED, 0x00BABEBF, 0x00919590, 0x00838A7D, 0x005D6350, 0x00515A40, 0x00697257, 0x00A8ABA9,
        0x00898D88, 0x00626660, 0x0060635A, 0x008A8E82, 0x00A3A899, 0x00868979, 0x00626653, 0x00718256, 0x007C8D61, 0x00738458, 0x0075865A, 0x007B8C60, 0x0075865A, 0x00738458, 0x00708155, 0x007E8D67, 0x006E7D57, 0x004C5B35, 0x00606F49, 0x003E4D27,
        0x005D6C46, 0x004A5933, 0x004B5A34, 0x005A6943, 0x0041502A, 0x00586741, 0x0052613B, 0x0044532D, 0x0066754F, 0x004B5A34, 0x005A6943, 0x0057683D, 0x005D6D44, 0x005D6D44, 0x0057673E, 0x0053623C, 0x0056653F, 0x005A6844, 0x005C6A46, 0x00596743,
        0x0054623E, 0x0055633F, 0x005A6943, 0x005A6943, 0x00596940, 0x00596940, 0x0056663D, 0x005E6941, 0x00556038, 0x00636E46, 0x005A653D, 0x005A653D, 0x00667149, 0x00545F37, 0x005A653D, 0x00495930, 0x005F6F46, 0x004A5A31, 0x006D7D54, 0x00798960,
        0x007A8963, 0x00707F59, 0x006F7E58, 0x00738263, 0x003C492F, 0x00172110, 0x00131B10, 0x001A201B, 0x00282D2B, 0x001F2423, 0x00151A18, 0x001D241F, 0x001C231E, 0x001D241F, 0x001F2621, 0x00212823, 0x00202722, 0x001D241F, 0x0019201B, 0x0019211A,
        0x001B231C, 0x001D251E, 0x001E261F, 0x001E261F, 0x001D251E, 0x001B231C, 0x001A221B, 0x00171D1C, 0x00171E1B, 0x00171E1B, 0x001B221D, 0x001F2720, 0x00222C20, 0x00212B1F, 0x001F291C, 0x00182019, 0x001D231E, 0x00181E19, 0x0020241E, 0x00171D12,
        0x001C2211, 0x00464E37, 0x007D866B, 0x00788565, 0x00758361, 0x0072815B, 0x0073865B, 0x0076895E, 0x0072845B, 0x0070835C, 0x00758664, 0x0077845E, 0x007E8B65, 0x0073805A, 0x00525F39, 0x005E6B45, 0x0056633D, 0x0035421C, 0x005F6C46, 0x0053643F,
        0x0053643F, 0x0053643F, 0x0053643F, 0x0053643F, 0x0053643F, 0x0053643F, 0x0053643F, 0x0052643F, 0x0052643F, 0x0052643F, 0x0052643F, 0x0052643F, 0x0052643F, 0x0052643F, 0x0052643F, 0x0052633E, 0x0052633E, 0x0051623D, 0x0051623D, 0x0051623D,
        0x0051623D, 0x0050613C, 0x0050613C, 0x0050623D, 0x00576944, 0x00576944, 0x0050623D, 0x0052643F, 0x00596B46, 0x00556742, 0x00495B36, 0x00556742, 0x00445631, 0x006D7F5A, 0x00778964, 0x00677954, 0x0072845F, 0x006E805B, 0x00657752, 0x0072805C,
        0x00677A59, 0x005B6B49, 0x003A4826, 0x003D5B4E, 0x00477F92, 0x004D8BA9, 0x00558DA0, 0x00487688, 0x001A3F37, 0x00263827, 0x006B716C, 0x00848A8F, 0x00CADAD9, 0x00C6D6D5, 0x0098A1AB, 0x007A8C93, 0x0074868D, 0x007C8E95, 0x00809299, 0x0090A2A9,
        0x009DAFB6, 0x00899BA2, 0x007C8E95, 0x007A8D94, 0x0072858C, 0x00809398, 0x0086969C, 0x007B8A8D, 0x00808C90, 0x00A4B1B3, 0x00D5E1E3, 0x00BDC9B7, 0x00738169, 0x00758464, 0x00768762, 0x005A6949, 0xFFA0A994, 0xFFFCFFFA, 0xFFFDFEFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFDFF, 0xFFFDFFF5, 0x008A9575, 0x0067754B, 0x0085936A, 0x007A8761, 0x0047562A, 0x00455623, 0x006D794F, 0x00616D43, 0x004A562C, 0x00445026, 0x00647046,
        0x00606C42, 0x003C481E, 0x0048542A, 0x006F7D61, 0x0079856F, 0x00BAC2B7, 0x00CED3D2, 0x00E0E3E7, 0x00D8DBDF, 0x00DFE4E3, 0x00DBE0DE, 0x00DFE2E7, 0x00E5E8EC, 0x00A9AEAC, 0x0082887D, 0x009BA392, 0x00576046, 0x00626D4D, 0x00606B4A, 0x005C674D,
        0x00586349, 0x00505B41, 0x00565F44, 0x005F684D, 0x00646B50, 0x00676F51, 0x00666E50, 0x004B5C30, 0x0067784C, 0x00798A5E, 0x00748559, 0x00748559, 0x0076875B, 0x006F8054, 0x00728357, 0x0072815B, 0x007C8B65, 0x0064734D, 0x004F5E38, 0x0065744E,
        0x0031401A, 0x0061704A, 0x00475630, 0x00475630, 0x005D6C46, 0x003E4D27, 0x00596842, 0x0053623C, 0x003F4E28, 0x00596842, 0x005C6B45, 0x0056673C, 0x0056663D, 0x0055653C, 0x0054643B, 0x00596842, 0x005F6E48, 0x005F6D49, 0x005A6844, 0x00616F4B,
        0x00586642, 0x00596842, 0x005F6E48, 0x005D6D44, 0x005B6B42, 0x005D6E43, 0x005D6E43, 0x0059643C, 0x005A653D, 0x00566139, 0x0057623A, 0x005D6840, 0x00535E36, 0x005B663E, 0x00525D35, 0x005F7045, 0x00516237, 0x00728358, 0x00718257, 0x00738459,
        0x0076875C, 0x007A8B60, 0x00708156, 0x0075875E, 0x0072835E, 0x004D5A40, 0x00182211, 0x000C1409, 0x00171E17, 0x00111712, 0x00111712, 0x00171D12, 0x00151B10, 0x00141A0F, 0x00151B10, 0x00171D12, 0x00181E13, 0x00161C11, 0x0013190E, 0x00141B0E,
        0x00151C0F, 0x00151C0F, 0x00161D10, 0x00171E11, 0x00171E11, 0x00171E11, 0x00171E11, 0x00151914, 0x00131711, 0x0013180F, 0x00181E13, 0x001E2518, 0x00212918, 0x001D2612, 0x0018210D, 0x00202216, 0x001B1C12, 0x0013170C, 0x001C2014, 0x001B2410,
        0x00424F35, 0x006E7E5C, 0x0074865F, 0x00768460, 0x0074835D, 0x0076875C, 0x00778B5E, 0x0075895C, 0x00718459, 0x006E815A, 0x006F815C, 0x007E8C63, 0x0078865D, 0x0056643B, 0x0058663D, 0x0049572E, 0x003E4C23, 0x005F6D44, 0x00546239, 0x00647550,
        0x00647550, 0x00647550, 0x00647550, 0x00647550, 0x00647550, 0x00647550, 0x00647550, 0x00647651, 0x00647651, 0x00647651, 0x00647651, 0x00647651, 0x00647651, 0x00647651, 0x00647651, 0x00677853, 0x00677853, 0x00667752, 0x00667752, 0x00667752,
        0x00667752, 0x00657651, 0x00657651, 0x00637550, 0x0062744F, 0x0062744F, 0x0061734E, 0x005E704B, 0x005C6E49, 0x005E704B, 0x00637550, 0x005D6F4A, 0x00798B66, 0x006C7E59, 0x006C7E59, 0x006E805B, 0x00667853, 0x00748661, 0x00748661, 0x006D7C56,
        0x00667958, 0x005D6D4B, 0x003F4D2B, 0x004B695C, 0x0050889B, 0x004B89A7, 0x00548C9F, 0x004C7A8C, 0x001D423A, 0x00263827, 0x006A706B, 0x00858B90, 0x00CADAD9, 0x00C6D6D5, 0x009AA3AD, 0x00809299, 0x00778990, 0x007B8D94, 0x00788A91, 0x0086989F,
        0x009AACB3, 0x0090A2A9, 0x008B9DA4, 0x0082959C, 0x00788B92, 0x0084979C, 0x008B9BA1, 0x007F8E91, 0x00818D91, 0x00A3B0B2, 0x00D4E0E2, 0x00B4C0AE, 0x006C7A62, 0x00738262, 0x00798A65, 0x00617050, 0xFFA3AC97, 0xFFF7FBF5, 0xFFFCFDFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFDFF, 0xFBFBFFF3, 0x00899474, 0x0068764C, 0x0085936A, 0x007A8761, 0x00404F23, 0x00344512, 0x00323E14, 0x003B471D, 0x00333F15, 0x00364218, 0x0039451B,
        0x002F3B11, 0x0038441A, 0x004C582E, 0x006B7564, 0x00878F84, 0x00D5DAD9, 0x00D5D7DF, 0x00E7E7F3, 0x00D3D4DE, 0x00D2D5D9, 0x00D1D5D6, 0x00D5D8DC, 0x00E5EAE9, 0x00A9B0A9, 0x008B9285, 0x00C6D0B9, 0x005F694B, 0x00838F6B, 0x00748259, 0x0076875B,
        0x007B8C60, 0x0077865A, 0x0079875D, 0x007B875D, 0x00758157, 0x006A754D, 0x00515A32, 0x00596A3E, 0x004F6034, 0x006D7E52, 0x0075865A, 0x00738458, 0x007A8B5F, 0x006F8054, 0x0075865A, 0x00778660, 0x0071805A, 0x0082916B, 0x0065744E, 0x004E5D37,
        0x0064734D, 0x00384721, 0x00586741, 0x004B5A34, 0x004A5933, 0x0053623C, 0x0042512B, 0x0054633D, 0x00606F49, 0x0056653F, 0x00586741, 0x00596A3F, 0x0058683F, 0x005A6A41, 0x005C6C43, 0x00596842, 0x0054633D, 0x00576541, 0x005D6B47, 0x005B6945,
        0x00586741, 0x005A6943, 0x005B6A44, 0x0056663D, 0x00596940, 0x005C6D42, 0x00596A3F, 0x00606B43, 0x00545F37, 0x00616C44, 0x005A653D, 0x00556038, 0x005F6A42, 0x00505B33, 0x00626D45, 0x00516237, 0x006F8055, 0x0078895E, 0x00798A5F, 0x0075865B,
        0x00738458, 0x00718256, 0x007A8B5F, 0x00708455, 0x0075875E, 0x00758464, 0x004E5A44, 0x002F382B, 0x003E463C, 0x004A514A, 0x00404740, 0x004A4E42, 0x00474B3F, 0x0043473B, 0x0044483C, 0x00464A3E, 0x00484C40, 0x00484C40, 0x00464A3E, 0x00444A39,
        0x00434938, 0x00434938, 0x00434938, 0x00444A39, 0x00454B3A, 0x00474D3C, 0x00494F3E, 0x0043453F, 0x003F4239, 0x003E4237, 0x00424738, 0x00494F3E, 0x004A513C, 0x00434B34, 0x003C452B, 0x00444335, 0x00525143, 0x003E3E30, 0x003A402F, 0x0049533C,
        0x00687958, 0x00738861, 0x006F865A, 0x0073825C, 0x0075855C, 0x0078895D, 0x00748859, 0x00708457, 0x0072855A, 0x00768962, 0x00778964, 0x0076845B, 0x004D5B32, 0x005F6D44, 0x004B5930, 0x00414F26, 0x005C6A41, 0x00536138, 0x00637148, 0x00748560,
        0x00748560, 0x00748560, 0x00758661, 0x00758661, 0x00758661, 0x00758661, 0x00758661, 0x00748661, 0x00748661, 0x00748661, 0x00748661, 0x00748661, 0x00748661, 0x00748661, 0x00748661, 0x00758661, 0x00758661, 0x00748560, 0x00748560, 0x00748560,
        0x00748560, 0x0073845F, 0x0073845F, 0x00738560, 0x0072845F, 0x0072845F, 0x00738560, 0x00758762, 0x00758762, 0x00748661, 0x00748661, 0x0072845F, 0x0070825D, 0x0070825D, 0x006A7C57, 0x0070825D, 0x0071835E, 0x00677954, 0x006E805B, 0x00707F59,
        0x00697C5B, 0x005C6D48, 0x003D4B27, 0x004D6B5E, 0x0051899C, 0x004887A3, 0x00538B9E, 0x00517F91, 0x0020453D, 0x00273928, 0x006A706B, 0x00858B90, 0x00CADAD9, 0x00C7D7D6, 0x009CA5AF, 0x0093A5AC, 0x008EA0A7, 0x0095A7AE, 0x008B9DA4, 0x0091A3AA,
        0x00A0B2B9, 0x0096A8AF, 0x0095A7AE, 0x0090A3AA, 0x0081949B, 0x008A9DA2, 0x008E9EA4, 0x00808F92, 0x00808C90, 0x00A0ADAF, 0x00D2DEE0, 0x00C1CDBB, 0x00707E66, 0x006E7D5D, 0x0073845F, 0x00606F4F, 0xFFA4AD98, 0xFFF8FCF6, 0xFFFDFEFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFCFAFF, 0xFBFBFFF3, 0x00899474, 0x006C7A50, 0x00829067, 0x007E8B65, 0x00647347, 0x005E6F3C, 0x0058693E, 0x00596A3F, 0x005B6C41, 0x0054653A, 0x0055663B,
        0x00596A3F, 0x0056673C, 0x005F7045, 0x00728358, 0x00596842, 0x00869373, 0x00ADB99D, 0x0087917A, 0x006E795F, 0x00818C72, 0x008B977B, 0x00737E5D, 0x0075815D, 0x00737D59, 0x006A754F, 0x006C774F, 0x00697349, 0x007A8459, 0x007E895B, 0x00798862,
        0x00798960, 0x0075855C, 0x007A8A61, 0x00798A5F, 0x0078895E, 0x00798A5E, 0x0066774B, 0x0048592D, 0x005A6B3F, 0x004F6034, 0x006C7D51, 0x00798A5E, 0x0075865A, 0x0078895D, 0x0075865A, 0x00728455, 0x00748657, 0x00798B5C, 0x0077885C, 0x00617246,
        0x0057683D, 0x0055663B, 0x003E4F24, 0x0056663D, 0x004E5E35, 0x004F5F36, 0x0053633A, 0x004F5F36, 0x00516138, 0x0055653C, 0x0053633A, 0x0052613B, 0x0053623C, 0x0053623C, 0x0053623C, 0x0053623C, 0x0054633D, 0x0054633D, 0x0054633D, 0x0054633D,
        0x0055643E, 0x0055643E, 0x0056653F, 0x0056653F, 0x0055643E, 0x0055643E, 0x0054633D, 0x00526239, 0x0057673E, 0x005A6A41, 0x00526239, 0x0053633A, 0x0055653C, 0x005A6A41, 0x0057673E, 0x00748559, 0x00738458, 0x00738458, 0x00738458, 0x00738458,
        0x00748559, 0x00748559, 0x0075865A, 0x00728357, 0x00728357, 0x0074855A, 0x00788761, 0x00606C4E, 0x00838C77, 0x00848A7F, 0x00828680, 0x00A3A199, 0x009E9C94, 0x00A3A199, 0x009F9D95, 0x00A5A39B, 0x009D9B93, 0x009C9A92, 0x009A9890, 0x0099948B,
        0x00A5A097, 0x009C978E, 0x00928D84, 0x00B0ABA2, 0x00A09B92, 0x009B968D, 0x00A9A49B, 0x009E9C94, 0x00939189, 0x00A19F97, 0x0095938B, 0x009A9890, 0x00AFADA5, 0x0097958D, 0x008A8880, 0x00A2989E, 0x00A9A39E, 0x007C7D69, 0x0078825E, 0x00768559,
        0x00798D60, 0x006E8258, 0x0070855F, 0x0075885D, 0x00708358, 0x0076895E, 0x0076875C, 0x0078895E, 0x007D8B61, 0x0076845A, 0x007A885E, 0x004E5D37, 0x0055643E, 0x004B5A34, 0x00364821, 0x0052643D, 0x0054663F, 0x00586B44, 0x007F926B, 0x00748560,
        0x0073845F, 0x0072845D, 0x0072845D, 0x0072845B, 0x0072845B, 0x0072845B, 0x0072855A, 0x00758760, 0x0074865F, 0x0073855E, 0x0072845D, 0x0072845D, 0x0072845D, 0x0073855E, 0x0074865F, 0x0074865F, 0x0074865F, 0x0074865F, 0x0073855E, 0x0072845D,
        0x0071835C, 0x0070825B, 0x006F815A, 0x0073865F, 0x0073865F, 0x0072855E, 0x0072855E, 0x0071845D, 0x0070835C, 0x0070835C, 0x006F825B, 0x006F815C, 0x006F815C, 0x006F815C, 0x006F815C, 0x006E805B, 0x006E805B, 0x006E805B, 0x006E805B, 0x00697E5E,
        0x006B7A54, 0x00636D43, 0x00415334, 0x00416359, 0x005C8D95, 0x005C94A5, 0x0051899C, 0x004B7D89, 0x002C4C4B, 0x002E382B, 0x00767668, 0x00898D88, 0x00D4E0E4, 0x00BBCED5, 0x0090A4A9, 0x0091A0A9, 0x0093A2AB, 0x008F9EA7, 0x008C9BA4, 0x008D9CA5,
        0x008C9BA4, 0x008B9AA3, 0x00909FA8, 0x00869CA1, 0x0080999D, 0x007E979B, 0x00768F93, 0x0074888D, 0x007C8C92, 0x009DA7AE, 0x00CFD5DC, 0x00C9D3CD, 0x00849181, 0x006A795D, 0x00758760, 0x0063714D, 0xFFA3AC92, 0xFFFBFFF4, 0xFFFFFEFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFDFF, 0xFFFFFFF7, 0x00879272, 0x006A784E, 0x007F8D64, 0x00828F69, 0x0079885C, 0x007C8D5A, 0x007F9065, 0x007C8D62, 0x007B8C61, 0x007C8D62, 0x007C8D62,
        0x007A8B60, 0x00798A5F, 0x00809166, 0x007A8C5D, 0x006F8054, 0x0072815B, 0x007B8965, 0x00778563, 0x0075835F, 0x00788761, 0x007C8C63, 0x007A8761, 0x00798660, 0x0076835D, 0x00717C54, 0x0077825A, 0x00778157, 0x00828C62, 0x00798358, 0x0075855C,
        0x0077875E, 0x0075865B, 0x0077885D, 0x0075865A, 0x0075865A, 0x007B8C60, 0x00708253, 0x0065764A, 0x0048592D, 0x005B6C40, 0x0056673B, 0x00738458, 0x007B8C60, 0x007C8D61, 0x00718256, 0x00768859, 0x00758758, 0x006F8152, 0x0078895D, 0x0076875B,
        0x00627348, 0x00596A3F, 0x0056673C, 0x0043532A, 0x004D5D34, 0x0048582F, 0x004B5B32, 0x005C6C43, 0x00596940, 0x00526239, 0x005F6F46, 0x00596842, 0x00596842, 0x00596842, 0x005A6943, 0x005A6943, 0x005A6943, 0x005A6943, 0x005A6943, 0x00596842,
        0x00596842, 0x005A6943, 0x005A6943, 0x005A6943, 0x005A6943, 0x00596842, 0x00596842, 0x0055653C, 0x0055653C, 0x004F5F36, 0x00596940, 0x00516138, 0x005B6B42, 0x005E6E45, 0x006D7D54, 0x0076875B, 0x0076875B, 0x0076875B, 0x0076875B, 0x0076875B,
        0x0076875B, 0x0076875B, 0x0076875B, 0x0077885C, 0x00798A5E, 0x00738459, 0x007F8E68, 0x00546141, 0x00727C65, 0x006E7568, 0x007B8077, 0x008A8A7E, 0x0089897D, 0x00838377, 0x007F7F73, 0x008B8B7F, 0x008E8E82, 0x009B9B8F, 0x00959589, 0x0089887A,
        0x00868577, 0x007D7C6E, 0x00888779, 0x007C7B6D, 0x008C8B7D, 0x007A796B, 0x008E8D7F, 0x008B8D81, 0x007F8175, 0x008E9084, 0x0085877B, 0x0086887C, 0x0094968A, 0x0085877B, 0x00828478, 0x00938B8B, 0x00908E84, 0x005F634A, 0x00707B55, 0x00758758,
        0x00708455, 0x00708459, 0x00738861, 0x0074865D, 0x0074865D, 0x00708259, 0x007D8D64, 0x00728259, 0x00748259, 0x007B8960, 0x004A582F, 0x00596842, 0x004C5B35, 0x0036451F, 0x005B6D46, 0x004F613A, 0x005F714A, 0x00748760, 0x0072855E, 0x00748560,
        0x0073845F, 0x0073855E, 0x0072845D, 0x0072845B, 0x0072845B, 0x0072845B, 0x0072855A, 0x0074865F, 0x0073855E, 0x0073855E, 0x0072845D, 0x0072845D, 0x0073855E, 0x0074865F, 0x0074865F, 0x00758760, 0x00758760, 0x0074865F, 0x0073855E, 0x0072845D,
        0x0071835C, 0x0070825B, 0x0070825B, 0x0073865F, 0x0073865F, 0x0072855E, 0x0072855E, 0x0071845D, 0x0070835C, 0x0070835C, 0x0070835C, 0x0070825D, 0x006F815C, 0x006F815C, 0x006F815C, 0x006F815C, 0x006F815C, 0x006E805B, 0x006E805B, 0x00697C5B,
        0x006D7A54, 0x00687248, 0x004A5C3D, 0x0044665F, 0x00548692, 0x00568FA5, 0x00518AA3, 0x004B7F8F, 0x002D5053, 0x002B392E, 0x0066675D, 0x00838886, 0x00D2DEE4, 0x00BCCFD4, 0x007B8E91, 0x006C838B, 0x006F868E, 0x006C838B, 0x006A8189, 0x006C838B,
        0x006A8189, 0x00687F87, 0x006C838B, 0x006F8388, 0x00677D82, 0x00647D81, 0x005D767A, 0x0061757A, 0x0074848A, 0x009CA6AD, 0x00CBD1D8, 0x00E4EEE8, 0x009DAA9C, 0x00728165, 0x00778962, 0x00616F4B, 0xFF9FA88E, 0xFFFEFFF8, 0xFFFFFEFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFDFF, 0xFFFFFFF7, 0x00869171, 0x006F7D53, 0x007E8C63, 0x007E8B65, 0x007A895D, 0x007C8D5A, 0x0078895E, 0x00798A5F, 0x0076875C, 0x00798A5F, 0x0077885D,
        0x00798A5F, 0x007A8B60, 0x007C8D62, 0x007F9261, 0x00829465, 0x0077885D, 0x0076865D, 0x007D8D64, 0x00849569, 0x00809362, 0x007E915E, 0x0083936A, 0x00839168, 0x0086946B, 0x00849269, 0x00828D65, 0x0077825A, 0x00848D65, 0x007E875F, 0x0077885D,
        0x0077885D, 0x00748559, 0x0075865A, 0x00748657, 0x00748657, 0x007A8D5C, 0x00768958, 0x00748559, 0x0065764A, 0x0046572B, 0x0058693D, 0x0055663A, 0x00728357, 0x0077885C, 0x006E7F53, 0x00738556, 0x00788A5B, 0x00728455, 0x00748559, 0x00798A5E,
        0x006F8055, 0x00607146, 0x00536439, 0x0054643B, 0x00495930, 0x0055653C, 0x00617148, 0x00596940, 0x005C6C43, 0x0063734A, 0x00596940, 0x005E6E45, 0x005E6E45, 0x005E6E45, 0x005E6E45, 0x005F6F46, 0x005F6F46, 0x005F6F46, 0x005F6F46, 0x005F6E48,
        0x005E6D47, 0x005E6D47, 0x005E6D47, 0x005E6D47, 0x005E6D47, 0x005E6D47, 0x005F6E48, 0x0064744B, 0x0058683F, 0x005D6D44, 0x00516138, 0x005F6F46, 0x0057673E, 0x006C7C53, 0x0075855C, 0x00748559, 0x00748559, 0x0075865A, 0x0075865A, 0x0075865A,
        0x00738458, 0x00728357, 0x00718256, 0x0074855A, 0x00708156, 0x007B8C61, 0x0073835A, 0x00697755, 0x00818C72, 0x00A5AE9A, 0x00B7BEB1, 0x008F947F, 0x00969B86, 0x008F947F, 0x00808570, 0x00828772, 0x00828772, 0x00959A85, 0x008F947F, 0x008C8F79,
        0x00757862, 0x00747761, 0x00777A64, 0x006D705A, 0x006D705A, 0x00757862, 0x006E715B, 0x00676E59, 0x00646B56, 0x007F8671, 0x00838A75, 0x00868D78, 0x00888F7A, 0x00787F6A, 0x00757C67, 0x0089877C, 0x00898B78, 0x005B6344, 0x00748258, 0x00798B5C,
        0x006C8051, 0x006F8457, 0x0071855A, 0x006E8057, 0x006E8057, 0x0076885F, 0x006F7F56, 0x0078885F, 0x0078865D, 0x0055633A, 0x005B6940, 0x0044532D, 0x00394822, 0x00596842, 0x004B5D36, 0x00657750, 0x0072845D, 0x0073865F, 0x0071845D, 0x00748560,
        0x0073845F, 0x0073855E, 0x0072845D, 0x0072845B, 0x0072845B, 0x0072845B, 0x0073865B, 0x0073855E, 0x0073855E, 0x0072845D, 0x0072845D, 0x0073855E, 0x0074865F, 0x00758760, 0x00758760, 0x00768861, 0x00758760, 0x0073855E, 0x0072845D, 0x0071835C,
        0x0071835C, 0x0071835C, 0x0072845D, 0x0073865F, 0x0073865F, 0x0072855E, 0x0072855E, 0x0071845D, 0x0071845D, 0x0070835C, 0x0070835C, 0x0070825D, 0x0070825D, 0x0070825D, 0x0070825D, 0x0070825D, 0x006F815C, 0x006F815C, 0x006F815C, 0x006C805D,
        0x0075835A, 0x00717B51, 0x004C6043, 0x00466A64, 0x00558999, 0x005B95B2, 0x00518DAB, 0x00477F92, 0x00274C54, 0x00273834, 0x005D645D, 0x008F9495, 0x00D2DEE4, 0x00BECFD2, 0x006F7F7E, 0x00506D72, 0x00547176, 0x00526F74, 0x00516E73, 0x00547176,
        0x00537075, 0x004F6C71, 0x00506D72, 0x00596C6F, 0x0053686A, 0x00556C6E, 0x00506769, 0x00526769, 0x006C7D80, 0x0097A2A6, 0x00C2C8CD, 0x00EAF3F0, 0x00A9B6A8, 0x006F7E62, 0x0073845F, 0x005F6D49, 0xFF99A18A, 0xFFFFFFF9, 0xFFFFFEFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFDFF, 0xFFFFFFF7, 0x007F8A6A, 0x006E7C52, 0x007E8C63, 0x007F8C66, 0x007B8A5E, 0x007F905D, 0x00808E64, 0x0089976D, 0x00829066, 0x00818F65, 0x007A885E,
        0x00808E64, 0x00829066, 0x00808E64, 0x007A8C65, 0x00768762, 0x00778765, 0x007F8E6E, 0x006B7B59, 0x0063754E, 0x0064774C, 0x005F7346, 0x0061704A, 0x005A6943, 0x0066734D, 0x00727F59, 0x007A8761, 0x0075805A, 0x00818C66, 0x007B8660, 0x007A8B5F,
        0x0077885C, 0x00738458, 0x00758758, 0x00758758, 0x00748756, 0x00758857, 0x00748756, 0x00798A5F, 0x007C8D62, 0x005D6E43, 0x004E5F34, 0x00596A3F, 0x0057683D, 0x0075865B, 0x0078895E, 0x00738556, 0x00728455, 0x00728455, 0x0075865A, 0x00738458,
        0x0077885D, 0x0077885D, 0x00607146, 0x0054643B, 0x0056663D, 0x0053633A, 0x0055653C, 0x005A6A41, 0x0055653C, 0x004E5E35, 0x00526239, 0x00516138, 0x00516138, 0x00526239, 0x00526239, 0x00526239, 0x00526239, 0x0053633A, 0x0053633A, 0x0055643E,
        0x0054633D, 0x0053623C, 0x0053623C, 0x0053623C, 0x0053623C, 0x0054633D, 0x0055643E, 0x00506037, 0x0057673E, 0x004A5A31, 0x0056663D, 0x004F5F36, 0x006D7D54, 0x006E7E55, 0x0077875E, 0x0076875C, 0x0076875C, 0x0077885D, 0x0078895E, 0x0077885D,
        0x0075865B, 0x00738459, 0x00728358, 0x006F7F56, 0x007C8C63, 0x006E7F54, 0x00708057, 0x00495733, 0x006E7A5C, 0x00717B64, 0x0077806C, 0x005F694B, 0x00677153, 0x006D7759, 0x005B6547, 0x00576143, 0x00535D3F, 0x00586244, 0x00545E40, 0x00545C3E,
        0x00646C4E, 0x00444C2E, 0x00424A2C, 0x006C7456, 0x005B6345, 0x0061694B, 0x00687052, 0x00656F51, 0x00566042, 0x005A6446, 0x00525C3E, 0x00576143, 0x005B6547, 0x00586244, 0x00545E40, 0x00696F58, 0x00737A5F, 0x005F6B47, 0x00748258, 0x0077895A,
        0x00728657, 0x0074885B, 0x0075885D, 0x00778960, 0x0073855C, 0x0073855C, 0x007C8C63, 0x006D7D54, 0x005B6940, 0x0059673E, 0x004F5D34, 0x0033421C, 0x00586741, 0x0053623C, 0x005C6E47, 0x006E8059, 0x00778962, 0x006E815A, 0x0072855E, 0x00748560,
        0x00748560, 0x0073855E, 0x0072845D, 0x0072845B, 0x0072845B, 0x0073855C, 0x0073865B, 0x0072845D, 0x0072845D, 0x0072845D, 0x0073855E, 0x0074865F, 0x00758760, 0x00758760, 0x00768861, 0x00768861, 0x00758760, 0x0073855E, 0x0071835C, 0x0071835C,
        0x0071835C, 0x0072845D, 0x0073855E, 0x0073865F, 0x0073865F, 0x0072855E, 0x0072855E, 0x0072855E, 0x0071845D, 0x0071845D, 0x0071845D, 0x0071835E, 0x0071835E, 0x0071835E, 0x0071835E, 0x0071835E, 0x0070825D, 0x0070825D, 0x0070825D, 0x00687C59,
        0x0076845A, 0x006C764C, 0x003D5134, 0x003D605C, 0x005A8C9E, 0x0067A0BF, 0x00528DAD, 0x004B8396, 0x00274E56, 0x00394B4A, 0x007A8380, 0x00B2BBBE, 0x00DAE6EC, 0x00C1CED0, 0x00697773, 0x004C6267, 0x0052686D, 0x0051676C, 0x0051676C, 0x00556B70,
        0x00546A6F, 0x004F656A, 0x004E6469, 0x0056676A, 0x004E6164, 0x004F6466, 0x00465B5D, 0x0043585A, 0x00627376, 0x0094A0A4, 0x00C2CBCF, 0x00E2EBE8, 0x00ACB9AB, 0x006A795E, 0x0072835E, 0x0062704E, 0xFF979F88, 0xFFFFFFF9, 0xFFFDF9FE, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFDFF, 0xFFFEFFF6, 0x007C8767, 0x006F7D53, 0x00808E65, 0x007A8761, 0x00617044, 0x0060713E, 0x0057653B, 0x005E6C42, 0x0056643A, 0x005C6A40, 0x0058663C,
        0x005D6B41, 0x005C6A40, 0x0067754B, 0x0077846C, 0x005C6852, 0x00545E4D, 0x00697363, 0x004B5545, 0x003A4531, 0x0037442C, 0x002D3A20, 0x002B371B, 0x00364224, 0x00414D2F, 0x00404B2B, 0x00475231, 0x0054603C, 0x0077825C, 0x0079845E, 0x00798A5F,
        0x0076875C, 0x0077885D, 0x0078895D, 0x0077885C, 0x00738556, 0x00728455, 0x00788A5B, 0x0077885D, 0x0075865B, 0x007C8D62, 0x0057683D, 0x00526338, 0x0056673C, 0x00596A3F, 0x0074855A, 0x007A8C5D, 0x00708253, 0x006D7F50, 0x0076875B, 0x00728357,
        0x006E7F54, 0x0078895E, 0x0077885D, 0x0053633A, 0x0055653C, 0x00516138, 0x0053633A, 0x005B6B42, 0x00596940, 0x0057673E, 0x005D6D44, 0x00596940, 0x00596940, 0x00596940, 0x005A6A41, 0x005A6A41, 0x005A6A41, 0x005A6A41, 0x005B6B42, 0x005D6C46,
        0x005C6B45, 0x005B6A44, 0x005B6A44, 0x005B6A44, 0x005B6A44, 0x005C6B45, 0x005D6C46, 0x0058683F, 0x0053633A, 0x005C6C43, 0x00516138, 0x006C7C53, 0x006C7C53, 0x00798960, 0x006F7F56, 0x0075865B, 0x0076875C, 0x0077885D, 0x0077885D, 0x0077885D,
        0x0075865B, 0x00738459, 0x00728358, 0x00798763, 0x0072815B, 0x00728259, 0x0057683D, 0x0054643B, 0x004C5A36, 0x00546042, 0x003F4A30, 0x0057633F, 0x005A6642, 0x0076825E, 0x006F7B57, 0x0077835F, 0x007B8763, 0x00737F5B, 0x0075815D, 0x0073815F,
        0x00768462, 0x00505E3C, 0x00566442, 0x00465432, 0x005A6846, 0x004D5B39, 0x00505E3C, 0x0052603C, 0x004A5834, 0x0054623E, 0x00586642, 0x006C7A56, 0x006F7D59, 0x0065734F, 0x004C5A36, 0x004F5A3A, 0x004D5B39, 0x0052613B, 0x005F7045, 0x00647549,
        0x006A7B4F, 0x00617548, 0x00697C51, 0x00687A53, 0x006E8059, 0x006B7D56, 0x006A7953, 0x005D6C46, 0x0056633D, 0x00515E38, 0x003B4822, 0x00596842, 0x00586741, 0x005B6A44, 0x00768861, 0x0073855E, 0x0071835C, 0x0073865F, 0x0071845D, 0x00748560,
        0x00748560, 0x0073855E, 0x0073855E, 0x0072845B, 0x0072845B, 0x0073855C, 0x0073865B, 0x0072845D, 0x0072845D, 0x0073855E, 0x0074865F, 0x0074865F, 0x00758760, 0x00758760, 0x00758760, 0x00768861, 0x00758760, 0x0073855E, 0x0072845D, 0x0071835C,
        0x0072845D, 0x0073855E, 0x0074865F, 0x0073865F, 0x0073865F, 0x0072855E, 0x0072855E, 0x0072855E, 0x0072855E, 0x0072855E, 0x0072855E, 0x0072845F, 0x0072845F, 0x0072845F, 0x0072845F, 0x0072845F, 0x0071835E, 0x0071835E, 0x0071835E, 0x006B7F5C,
        0x0078865C, 0x006C764B, 0x003F5132, 0x0044645F, 0x006290A1, 0x007CB1CC, 0x006FA3C1, 0x00588A96, 0x00375C60, 0x00596A67, 0x00949D9A, 0x00C6D1D5, 0x00DEECF2, 0x00C0CECD, 0x0067746C, 0x004E595D, 0x00576266, 0x00596468, 0x00586367, 0x005C676B,
        0x005C676B, 0x00566165, 0x00545F63, 0x00566365, 0x00505F61, 0x00506465, 0x00485D5E, 0x00425758, 0x005A6C6D, 0x008D9A9C, 0x00C0CCCE, 0x00E4ECEB, 0x00B8C4B8, 0x00707F64, 0x00788866, 0x00687654, 0xFF989F8A, 0xFFFFFFFB, 0xFFFBF7FC, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFDFF, 0xFFFEFFF6, 0x007E8969, 0x00707E54, 0x00839168, 0x0073805A, 0x003E4D21, 0x003C4D1A, 0x0039451B, 0x00344016, 0x002A360C, 0x0038441A, 0x003B471D,
        0x003A461C, 0x002B370D, 0x00475329, 0x006A7463, 0x004D5649, 0x004B5349, 0x00929893, 0x00AEB3B1, 0x00B8BDBB, 0x00B7BDB8, 0x00B1B8B1, 0x00A5AEA1, 0x00B1BBAB, 0x00959E8A, 0x00535D46, 0x00434D2F, 0x005B6645, 0x00808D67, 0x007F8A62, 0x007A8963,
        0x00788761, 0x007B8A64, 0x007B8B62, 0x007A8A61, 0x0075855C, 0x0074855A, 0x00839469, 0x0078885F, 0x007B8B62, 0x007C8C63, 0x00798960, 0x0053633A, 0x005B6B42, 0x00506037, 0x0058683F, 0x00708253, 0x007D8F60, 0x00768859, 0x0077885C, 0x007B8C60,
        0x00718257, 0x00708156, 0x00798A5F, 0x00708057, 0x005F6F46, 0x0064744B, 0x0068784F, 0x005B6B42, 0x005D6D44, 0x0065754C, 0x005C6C43, 0x005D6E43, 0x005E6F44, 0x005E6F44, 0x005E6F44, 0x005E6F44, 0x005E6F44, 0x005F7045, 0x005F7045, 0x005E6D47,
        0x005E6D47, 0x005E6D47, 0x005D6C46, 0x005D6C46, 0x005E6D47, 0x005E6D47, 0x005E6D47, 0x00627249, 0x00617148, 0x00596940, 0x00718158, 0x006E7E55, 0x007B8B62, 0x00718158, 0x0075855C, 0x0078885F, 0x0078885F, 0x00798960, 0x00798960, 0x0078885F,
        0x0077875E, 0x0076865D, 0x0075855C, 0x007B8967, 0x006A7854, 0x004F5F36, 0x0056673C, 0x0048592E, 0x0053633A, 0x0053613D, 0x00546240, 0x0053623C, 0x005B6A44, 0x007D8C66, 0x0075845E, 0x0076855F, 0x0075845E, 0x00707F59, 0x00788761, 0x0073845F,
        0x00566742, 0x005A6B46, 0x0050613C, 0x0031421D, 0x00556641, 0x004D5E39, 0x0052633E, 0x0051633C, 0x004A5C35, 0x0053653E, 0x005D6F48, 0x007A8C65, 0x007A8C65, 0x006F815A, 0x004B5D36, 0x0052643D, 0x003D4F28, 0x00465831, 0x004F613A, 0x0053623C,
        0x0056653F, 0x00485731, 0x0055643E, 0x004E6039, 0x00556740, 0x005A6C45, 0x004B5A34, 0x0053623C, 0x0053603A, 0x003B4822, 0x0053603A, 0x005F6E48, 0x0052613B, 0x007C8B65, 0x0072845D, 0x007A8C65, 0x0071835C, 0x0070835C, 0x0072855E, 0x00758661,
        0x00748560, 0x0074865F, 0x0073855E, 0x0073855C, 0x0073855C, 0x0073855C, 0x0073865B, 0x0072845D, 0x0073855E, 0x0074865F, 0x00758760, 0x00758760, 0x00758760, 0x00758760, 0x00758760, 0x00758760, 0x0074865F, 0x0073855E, 0x0072845D, 0x0072845D,
        0x0073855E, 0x0073855E, 0x0074865F, 0x0072855E, 0x0072855E, 0x0072855E, 0x0072855E, 0x0072855E, 0x0072855E, 0x0072855E, 0x0072855E, 0x00748661, 0x00738560, 0x00738560, 0x00738560, 0x00738560, 0x0072845F, 0x0072845F, 0x0072845F, 0x006E8664,
        0x0078885F, 0x00768055, 0x00596848, 0x005D786E, 0x00688F98, 0x0088B3C6, 0x008BB6CB, 0x005A8385, 0x0044605A, 0x00627065, 0x00818883, 0x00ACB5B9, 0x00D9E6EE, 0x00C2D0CF, 0x006D7870, 0x00676C6F, 0x0073787B, 0x00767B7E, 0x00757A7D, 0x00787D80,
        0x00787D80, 0x0074797C, 0x0072777A, 0x00697577, 0x00606D6F, 0x00596B6C, 0x004E6263, 0x00475B5C, 0x00516364, 0x007E8D8F, 0x00BECACC, 0x00E5EDEC, 0x00BECABE, 0x0074826A, 0x00778765, 0x00687555, 0xFF99A08B, 0xFFFFFFFB, 0xFFFFFBFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFDFF, 0xFFFFFFF7, 0x007D8868, 0x006A784E, 0x00839168, 0x007A8761, 0x003F4E22, 0x004D5E2B, 0x006A764C, 0x00616D43, 0x00505C32, 0x00556137, 0x005F6B41,
        0x00616D43, 0x003A461C, 0x00546036, 0x005F6D55, 0x00434F3B, 0x004F594D, 0x00B9C0BB, 0x00E7ECED, 0x00EBF0F3, 0x00E4E9EC, 0x00E2E7EA, 0x00EEF1F5, 0x00EEF2F3, 0x00AEB4AF, 0x00515849, 0x003C462F, 0x00545F3F, 0x006B7852, 0x005C6A40, 0x005F6C4C,
        0x00525F3F, 0x004E5C3A, 0x004E5C3A, 0x0054623E, 0x0053613D, 0x004E5C38, 0x005D6C46, 0x007B8B62, 0x0075855C, 0x00798960, 0x0074845B, 0x0076865D, 0x00596940, 0x0065754C, 0x004D5D34, 0x005A6C3D, 0x00758758, 0x00758758, 0x00728357, 0x007A8B5F,
        0x0077885D, 0x0074855A, 0x0074855A, 0x00718158, 0x00798960, 0x00718158, 0x00718158, 0x007F8F66, 0x007A8A61, 0x00728259, 0x007F8F66, 0x00798A5F, 0x007A8B60, 0x007A8B60, 0x007A8B60, 0x007A8B60, 0x007A8B60, 0x007B8C61, 0x007B8C61, 0x00798862,
        0x007A8963, 0x007A8963, 0x007A8963, 0x007A8963, 0x007A8963, 0x007A8963, 0x00798862, 0x007C8C63, 0x0075855C, 0x007B8B62, 0x0078885F, 0x00819168, 0x0074845B, 0x0078885F, 0x0077875E, 0x00798960, 0x00798960, 0x00798960, 0x00798960, 0x00798960,
        0x00798960, 0x0078885F, 0x0078885F, 0x00707D5D, 0x005A6844, 0x0054643B, 0x004F6034, 0x005B6C40, 0x004A5B30, 0x005B6B42, 0x00576640, 0x00566841, 0x00687A53, 0x007B8D66, 0x0074865F, 0x00758760, 0x0070825B, 0x00778962, 0x0074865F, 0x0052643F,
        0x00546641, 0x00455732, 0x002F411C, 0x0050623D, 0x004D5F3A, 0x00364823, 0x00576944, 0x004E613A, 0x00475A33, 0x004F623B, 0x005C6F48, 0x00778A63, 0x0070835C, 0x006F825B, 0x0051643D, 0x0052663C, 0x0040532C, 0x00495B36, 0x0051613F, 0x0051613F,
        0x00556341, 0x004F5D3B, 0x00566442, 0x0053643F, 0x004E5F3A, 0x00485934, 0x005C6A46, 0x004D5B37, 0x003F4B27, 0x00586440, 0x0057633F, 0x004E5D37, 0x007D8C66, 0x006E7D57, 0x007B8D66, 0x0071835C, 0x0074865F, 0x0071845D, 0x0073865F, 0x00758661,
        0x00748560, 0x0074865F, 0x0073855E, 0x0073855C, 0x0073855C, 0x0073855C, 0x0074875C, 0x0073855E, 0x0074865F, 0x00758760, 0x00758760, 0x00758760, 0x00758760, 0x0074865F, 0x0074865F, 0x0074865F, 0x0074865F, 0x0074865F, 0x0073855E, 0x0073855E,
        0x0073855E, 0x0073855E, 0x0073855E, 0x0072855E, 0x0072855E, 0x0072855E, 0x0073865F, 0x0073865F, 0x0073865F, 0x0073865F, 0x0073865F, 0x00748661, 0x00748661, 0x00748661, 0x00748661, 0x00738560, 0x00738560, 0x00738560, 0x00738560, 0x00688362,
        0x0074865F, 0x007C865B, 0x006C7854, 0x006D8273, 0x00628081, 0x007899A2, 0x007997A2, 0x004F6F64, 0x00435645, 0x005F6756, 0x006D7067, 0x008E979A, 0x00D3E0E8, 0x00BDCACC, 0x0069766E, 0x00778181, 0x00858F8F, 0x008B9595, 0x00889292, 0x008A9494,
        0x008B9595, 0x00889292, 0x00879191, 0x00868D90, 0x006D797B, 0x00576668, 0x00495D5E, 0x0045595A, 0x00465859, 0x00707F81, 0x00BCC9CB, 0x00E1E9E8, 0x00BEC9BF, 0x0075836B, 0x00738361, 0x00667353, 0xFF99A08B, 0xFFFFFFFC, 0xFFFFFDFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFDFF, 0xFFFDFFF5, 0x007E8969, 0x0069774D, 0x00849269, 0x007B8862, 0x0039481C, 0x0051622F, 0x00647046, 0x00636F45, 0x00515D33, 0x004B572D, 0x005F6B41,
        0x00717D53, 0x003D491F, 0x004A562C, 0x006B7C5B, 0x0047563A, 0x005F6B59, 0x00D2DBD1, 0x00E0E6E5, 0x00C6CBCE, 0x00BDC2C5, 0x00C2C6CB, 0x00D0CFDF, 0x00E6E7F1, 0x00BBBFC0, 0x0060655C, 0x00363F2A, 0x00344121, 0x004D5B32, 0x00526135, 0x00616D51,
        0x00465234, 0x00364224, 0x00364224, 0x00465333, 0x004A5737, 0x003F4D2B, 0x00485634, 0x0065754C, 0x005B6B42, 0x005E6E45, 0x00617148, 0x00697950, 0x0073835A, 0x0053633A, 0x005C6C43, 0x00556738, 0x00586A3B, 0x005A6C3D, 0x00627347, 0x005E6F43,
        0x0058693E, 0x00607146, 0x00637449, 0x00617148, 0x005B6B42, 0x00617148, 0x0068784F, 0x0065754C, 0x0065754C, 0x0065754C, 0x00617148, 0x0064754A, 0x0064754A, 0x0064754A, 0x0064754A, 0x0065764B, 0x0065764B, 0x0065764B, 0x0065764B, 0x0065744E,
        0x0066754F, 0x00677650, 0x00677650, 0x00677650, 0x00677650, 0x0066754F, 0x0065744E, 0x005E6E45, 0x0066764D, 0x0067774E, 0x0064744B, 0x005E6E45, 0x0065754C, 0x0067774E, 0x00697950, 0x00697950, 0x00697950, 0x00697950, 0x00697950, 0x00697950,
        0x006A7A51, 0x006A7A51, 0x006A7A51, 0x00576444, 0x00546240, 0x00516138, 0x0055663A, 0x00566839, 0x004F6034, 0x0058693E, 0x0053633A, 0x006F815A, 0x007D8F68, 0x0071835C, 0x006F815A, 0x007A8C65, 0x0073855E, 0x00788A63, 0x00566841, 0x004F643E,
        0x00536842, 0x00293E18, 0x00536842, 0x00536842, 0x00556A44, 0x004B603A, 0x004A5F39, 0x0053663F, 0x00495C35, 0x004F623B, 0x005C6F48, 0x00758861, 0x006D8059, 0x007B8E67, 0x006B7E57, 0x004A6036, 0x004D623B, 0x00576846, 0x005A6949, 0x00546344,
        0x005A6648, 0x005F6C4C, 0x005B6646, 0x00566742, 0x00596A45, 0x00576843, 0x0053613D, 0x00616F4B, 0x0065714D, 0x0055613D, 0x005B6743, 0x00778660, 0x007A8963, 0x007C8B65, 0x00697B54, 0x00758760, 0x0074865F, 0x006F825B, 0x00788B64, 0x00758661,
        0x00758661, 0x0074865F, 0x0073855E, 0x0073855C, 0x0073855C, 0x0073855C, 0x0074875C, 0x0074865F, 0x0074865F, 0x00758760, 0x00768861, 0x00758760, 0x00758760, 0x0074865F, 0x0073855E, 0x0073855E, 0x0074865F, 0x0074865F, 0x0074865F, 0x0074865F,
        0x0074865F, 0x0073855E, 0x0073855E, 0x0072855E, 0x0072855E, 0x0072855E, 0x0073865F, 0x0073865F, 0x0073865F, 0x0073865F, 0x0073865F, 0x00758762, 0x00758762, 0x00748661, 0x00748661, 0x00748661, 0x00748661, 0x00738560, 0x00738560, 0x00678365,
        0x00788B64, 0x00848E63, 0x0075805A, 0x00748774, 0x00637C78, 0x006A8387, 0x00586F71, 0x0048614D, 0x00414F37, 0x00686B55, 0x0075776B, 0x00929A9A, 0x00D7E4EC, 0x00B0BFC1, 0x005C6862, 0x005E706F, 0x006E807F, 0x00748685, 0x00718382, 0x00728483,
        0x00738584, 0x00718382, 0x00718382, 0x00777F7F, 0x00626C6C, 0x0052605F, 0x00516362, 0x00516664, 0x00465857, 0x005E6E6D, 0x00A6B4B3, 0x00E4ECEC, 0x00C3CEC4, 0x007C8A72, 0x00768565, 0x00687555, 0xFF9AA08D, 0xFFFFFFFC, 0xFFFFFDFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFEFF, 0xF7FBFFF1, 0x007D8965, 0x0069784C, 0x00818F65, 0x0077855C, 0x003A4A1B, 0x00576934, 0x00505C32, 0x004D592F, 0x00647145, 0x00344115, 0x00697648,
        0x00546133, 0x00364315, 0x004E5C2C, 0x006C7B5F, 0x00505E46, 0x006F7A6A, 0x00CAD2CB, 0x00DBE2DF, 0x00D3D9D8, 0x00BBC1C0, 0x00C0C6C5, 0x00CCD1D4, 0x00DDE2E5, 0x00C6CBCC, 0x00747B78, 0x007D847F, 0x00616A60, 0x00586256, 0x007C8679, 0x00A2A4A4,
        0x006E716F, 0x005E625D, 0x0060645E, 0x005E6459, 0x009BA293, 0x00727A69, 0x00535B4A, 0x0056663D, 0x005E6E45, 0x0053633A, 0x005B6B42, 0x0054643B, 0x00607047, 0x006E7E55, 0x004A5A31, 0x0057653C, 0x005C6A41, 0x00616F46, 0x00606E45, 0x005C6A41,
        0x0059673E, 0x005A683F, 0x005D6B42, 0x005A6844, 0x00596743, 0x00586642, 0x005A6844, 0x005C6A46, 0x005D6B47, 0x005B6945, 0x00596743, 0x005C673F, 0x005D6840, 0x005F6A42, 0x00606B43, 0x00616C44, 0x00606B43, 0x005F6A42, 0x005E6941, 0x005C6B45,
        0x005C6B45, 0x005C6B45, 0x005C6B45, 0x005C6B45, 0x005C6B45, 0x005C6B45, 0x005C6B45, 0x00546239, 0x0057653C, 0x005B6940, 0x005C6943, 0x005D6A44, 0x005D6945, 0x005E6A46, 0x00606C48, 0x005F6B41, 0x00646F47, 0x00616C44, 0x005F6A42, 0x00636E48,
        0x00616C46, 0x005F6945, 0x00646E4A, 0x00707A56, 0x00525E3A, 0x005D6945, 0x00596541, 0x004E5C38, 0x005D6B47, 0x004F603B, 0x00758661, 0x00768962, 0x00768962, 0x006D8059, 0x0073865F, 0x006F825B, 0x00748760, 0x005B6E47, 0x004D6039, 0x005F714A,
        0x002D3E19, 0x00576646, 0x005C6B4C, 0x00536243, 0x00758464, 0x0051623D, 0x0052643D, 0x00596A3E, 0x004A5B30, 0x005A6943, 0x005A6846, 0x007E8C6A, 0x0072805C, 0x006E7D57, 0x007E8E65, 0x00717F5B, 0x0055633F, 0x0055633F, 0x0053613D, 0x0052603C,
        0x00576541, 0x00505E3A, 0x00566440, 0x0051623D, 0x00586944, 0x004F603B, 0x0051623D, 0x005D6E49, 0x00546540, 0x00576843, 0x00798A65, 0x00758760, 0x0074865F, 0x0074865F, 0x0074865F, 0x0074865F, 0x0073855E, 0x0073855E, 0x0073855E, 0x00748760,
        0x00748760, 0x00748760, 0x00748760, 0x0073865F, 0x0073865F, 0x0073865F, 0x0073865F, 0x0071845D, 0x0071845D, 0x0071845D, 0x0071845D, 0x0071845D, 0x0071845D, 0x0071845D, 0x0071845D, 0x0073865F, 0x0073865F, 0x0073865F, 0x0073865F, 0x0073865F,
        0x0073865F, 0x0073865F, 0x0073865F, 0x0072855A, 0x0076885F, 0x0071835A, 0x0075875E, 0x0074865F, 0x0071835C, 0x00788964, 0x00758661, 0x00768762, 0x00768762, 0x0073845F, 0x0073845F, 0x00778863, 0x0073845F, 0x006F805B, 0x00788964, 0x00758760,
        0x0074865F, 0x00687954, 0x006B7C57, 0x006E7E5C, 0x006E7E5C, 0x00677755, 0x004A5939, 0x00565B3E, 0x00494F38, 0x0060665B, 0x00686E6D, 0x008E999D, 0x00D3E1E7, 0x00ACBFC2, 0x0094A8A9, 0x0097A1AB, 0x009AA4AE, 0x009BA6AE, 0x009CA7AF, 0x00A4AFB7,
        0x00A7B2BA, 0x00A3AEB6, 0x00A6B1B9, 0x00A0AAB4, 0x00B4BFC7, 0x00A6B2B6, 0x00A5B2B4, 0x00ABB8BA, 0x00A4B1B3, 0x00AFBBC1, 0x00B8C4CA, 0x00E4E7EF, 0x00C9D0CB, 0x007B8771, 0x00778863, 0x00667752, 0xFF97A288, 0xFFFDFFF9, 0xFFFAFCFD, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFEFF, 0xFBFDFFF3, 0x007E8968, 0x0069784C, 0x00808E64, 0x0076845B, 0x003A4A1B, 0x004E602B, 0x00636F45, 0x005E6A40, 0x005C683E, 0x003B481C, 0x00637044,
        0x00475426, 0x00384517, 0x00515E30, 0x006B7862, 0x00515C4C, 0x007A8379, 0x00D8DFDC, 0x00D9DEE1, 0x00CDD1D6, 0x00CACED3, 0x00D5D9DE, 0x00D7DADE, 0x00D4D8D9, 0x00BEC3C1, 0x009AA19A, 0x00969E93, 0x004D5747, 0x0057624E, 0x0095A18B, 0x00ACB1A8,
        0x007E8479, 0x00585F52, 0x00636A5B, 0x00848D79, 0x00ABB49F, 0x00646E57, 0x00454F38, 0x0056663D, 0x00495930, 0x00607047, 0x00516138, 0x00506037, 0x0056663D, 0x0056663D, 0x00495930, 0x004F5D34, 0x00536138, 0x0057653C, 0x0058663D, 0x0056643B,
        0x00546239, 0x0056643B, 0x0058663D, 0x00566440, 0x0055633F, 0x0055633F, 0x00566440, 0x00586642, 0x00586642, 0x00576541, 0x00566440, 0x00566139, 0x0057623A, 0x0059643C, 0x005A653D, 0x005A653D, 0x0059643C, 0x0058633B, 0x0057623A, 0x0053623C,
        0x0053623C, 0x0053623C, 0x0052613B, 0x0052613B, 0x0051603A, 0x0051603A, 0x0051603A, 0x00526037, 0x00546239, 0x0058663D, 0x00596640, 0x00596640, 0x00596640, 0x005A6642, 0x005B6743, 0x005E6A40, 0x005F6A42, 0x005E6941, 0x005E6941, 0x005D6842,
        0x005D6842, 0x005D6743, 0x005E6844, 0x004A5731, 0x0066734D, 0x005D6A44, 0x0048552F, 0x005F6E48, 0x0052613B, 0x006E8059, 0x00798B64, 0x006E8057, 0x0072845B, 0x007D8F66, 0x006F8158, 0x007A8C63, 0x005B6D44, 0x005A6C43, 0x00586A41, 0x0036481F,
        0x00566841, 0x00556543, 0x00556444, 0x007D8C6C, 0x0081916F, 0x00495B34, 0x0056683F, 0x004F6336, 0x0056693E, 0x004B5D34, 0x006A7C53, 0x00677952, 0x00778962, 0x0084966F, 0x00697B54, 0x00758760, 0x00788A63, 0x007B8D66, 0x007A8C65, 0x0074865F,
        0x00758760, 0x00788A63, 0x0073855E, 0x0073845F, 0x00798A65, 0x007B8C67, 0x00748560, 0x0071825D, 0x00778863, 0x007A8B66, 0x00778863, 0x0072845D, 0x0072845D, 0x0073855E, 0x0073855E, 0x0074865F, 0x00758760, 0x00768861, 0x00768861, 0x00748760,
        0x00748760, 0x00748760, 0x0073865F, 0x0073865F, 0x0073865F, 0x0073865F, 0x0072855E, 0x0072855E, 0x0072855E, 0x0072855E, 0x0072855E, 0x0072855E, 0x0072855E, 0x0072855E, 0x0072855E, 0x0073865F, 0x0073865F, 0x0073865F, 0x0073865F, 0x0073865F,
        0x0073865F, 0x0073865F, 0x0073865F, 0x0072855A, 0x0075875E, 0x0071835A, 0x0075875E, 0x00768861, 0x0073855E, 0x00788964, 0x00768762, 0x0073845F, 0x00758661, 0x0073845F, 0x00778863, 0x00768762, 0x00748560, 0x00798A65, 0x00768762, 0x0064764F,
        0x00556740, 0x0053643F, 0x00647550, 0x00556543, 0x005B6B49, 0x005A6A48, 0x00617050, 0x00545D3C, 0x004D563B, 0x00676F5E, 0x00737C72, 0x00959F99, 0x00D8E6E2, 0x00DAEAE3, 0x00D9EAE1, 0x00DDE8E6, 0x00E0EBE9, 0x00E0EBE9, 0x00E0EBE9, 0x00E1ECEA,
        0x00DFEAE8, 0x00E1ECEA, 0x00EBF6F4, 0x00E6EFF2, 0x00DDE7E7, 0x00E2EDEB, 0x00E6F1EE, 0x00E2EEE8, 0x00E2EEE8, 0x00E1ECE9, 0x00D9E4E1, 0x00E2E8E7, 0x00CAD4C8, 0x00859377, 0x007C8E67, 0x0064764F, 0xFF949F85, 0xFFFDFFF9, 0xFFF9FAFE, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFDFCFF, 0xFFFDFFF5, 0x00808B6A, 0x006D7B51, 0x0086946B, 0x007B8960, 0x00415024, 0x00495B26, 0x00778359, 0x0069754B, 0x0048542A, 0x00404D21, 0x00616E42,
        0x00455226, 0x003A4719, 0x00485527, 0x00687261, 0x004F584B, 0x006C736C, 0x00D1D6D5, 0x00E6E9ED, 0x00D7DADF, 0x00D0D3D8, 0x00D6D9DD, 0x00DCDCDC, 0x00F1F2EE, 0x00B8BBB2, 0x006C7162, 0x006B725D, 0x00586146, 0x00677252, 0x00545F3E, 0x005D6750,
        0x00646E57, 0x00566147, 0x00576347, 0x00566244, 0x00596646, 0x003B4927, 0x0053613F, 0x0075855C, 0x0077875E, 0x006E7E55, 0x007A8A61, 0x0058683F, 0x0058683F, 0x005A6A41, 0x0056663D, 0x0058663D, 0x005B6940, 0x005D6B42, 0x005E6C43, 0x005E6C43,
        0x005D6B42, 0x005E6C43, 0x005F6D44, 0x005D6C46, 0x005D6C46, 0x005D6C46, 0x005E6D47, 0x005F6E48, 0x005F6E48, 0x005E6D47, 0x005D6C46, 0x00636E46, 0x00636E46, 0x00646F47, 0x00657048, 0x00657048, 0x00646F47, 0x00626D45, 0x00626D45, 0x005E6E45,
        0x005E6E45, 0x005D6D44, 0x005C6C43, 0x005B6B42, 0x005B6B42, 0x005A6A41, 0x005A6A41, 0x005B693F, 0x005D6B41, 0x005F6D44, 0x00616F46, 0x00616E48, 0x00606D47, 0x00616E48, 0x00616D49, 0x00657147, 0x00636E46, 0x00657048, 0x0067724A, 0x0066714B,
        0x0068734D, 0x006A7450, 0x0068724E, 0x006B7950, 0x005B6940, 0x004F5D34, 0x00697950, 0x005E6E45, 0x00708259, 0x0075875E, 0x0075875E, 0x007B895F, 0x0077855B, 0x0079875D, 0x00839167, 0x00647248, 0x005A683E, 0x005D6B41, 0x0039471D, 0x005B6E43,
        0x0052643B, 0x005F704B, 0x007D8D6B, 0x007C8C6A, 0x0070815C, 0x00596B42, 0x0055683D, 0x005D6F46, 0x00516439, 0x00506437, 0x0055693C, 0x007A8E61, 0x0072845B, 0x006D7F58, 0x007A8B66, 0x006F8158, 0x00788A61, 0x006F8158, 0x0072845B, 0x00708259,
        0x00708259, 0x007D8F66, 0x0071835A, 0x0072835E, 0x006F805B, 0x0073845F, 0x00778863, 0x00758661, 0x00798A65, 0x007B8C67, 0x00748560, 0x0072845D, 0x0072845D, 0x0073855E, 0x0074865F, 0x00758760, 0x00758760, 0x00768861, 0x00768861, 0x00748760,
        0x0073865F, 0x0073865F, 0x0073865F, 0x0073865F, 0x0072855E, 0x0072855E, 0x0072855E, 0x0072855E, 0x0072855E, 0x0072855E, 0x0072855E, 0x0072855E, 0x0072855E, 0x0072855E, 0x0072855E, 0x0073865F, 0x0073865F, 0x0073865F, 0x0073865F, 0x0073865F,
        0x0073865F, 0x0073865F, 0x0073865F, 0x0072855A, 0x0075875E, 0x0072845B, 0x0075875E, 0x00758760, 0x0073855E, 0x00768762, 0x0073845F, 0x0072835E, 0x00768762, 0x00748560, 0x00798A65, 0x00748560, 0x0073845F, 0x00788964, 0x00687954, 0x005B6D46,
        0x004E6039, 0x005B6C47, 0x00576843, 0x0051613F, 0x005A6A48, 0x00536341, 0x004F5E3E, 0x005E6D47, 0x005A6846, 0x006D795D, 0x0078846E, 0x008D9884, 0x00AFB9A8, 0x00AEBAA6, 0x00A1AD99, 0x00A6B29E, 0x00A5B19D, 0x00A0AC98, 0x00A1AD99, 0x00A3AF9D,
        0x009CA896, 0x0097A391, 0x0099A593, 0x0099A397, 0x008B9589, 0x00929C90, 0x00899386, 0x008A9585, 0x00A3AF9D, 0x00A1AD9B, 0x009AA692, 0x009EA999, 0x0096A48C, 0x00768762, 0x00788B60, 0x00657750, 0xFF97A288, 0xFFFCFFFA, 0xFFFCFDFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFDFCFF, 0xFFFEFFF6, 0x00808B6A, 0x006B794F, 0x00818F66, 0x00727F59, 0x003B4A1E, 0x00384916, 0x0037451C, 0x003C4A21, 0x002B390F, 0x00334117, 0x003F4E22,
        0x00303F13, 0x00344317, 0x004D5D2E, 0x0068765A, 0x005A674F, 0x005C6655, 0x00B5BDB2, 0x00E9F0E9, 0x00E0E7E0, 0x00D3DBD1, 0x00DAE2D8, 0x00ECEDE4, 0x00EAEBE1, 0x00B3B6A6, 0x00797F68, 0x0071795B, 0x005D6842, 0x007C885E, 0x00788557, 0x00717F5B,
        0x00768460, 0x0071805A, 0x00788761, 0x006C7C53, 0x006D7E53, 0x006E7F54, 0x00809166, 0x0077875E, 0x0077875E, 0x007C8C63, 0x00728259, 0x0068784F, 0x0045552C, 0x00627249, 0x0055653C, 0x005E6C42, 0x005E6C42, 0x005E6C42, 0x005E6C42, 0x005E6C42,
        0x005D6B41, 0x005C6A40, 0x005B693F, 0x005B6B42, 0x005B6B42, 0x005B6B42, 0x005C6C43, 0x005C6C43, 0x005C6C43, 0x005B6B42, 0x005B6B42, 0x0059673D, 0x005A683E, 0x005A683E, 0x005A683E, 0x005A683E, 0x0059673D, 0x0058663C, 0x0057653B, 0x0057673E,
        0x0057673E, 0x0057673E, 0x0056663D, 0x0056663D, 0x0055653C, 0x0055653C, 0x0055653C, 0x0056673C, 0x0057683D, 0x0058693E, 0x005A6A41, 0x005A6A41, 0x00596842, 0x00596842, 0x00586741, 0x005B693F, 0x005D6B42, 0x005B6940, 0x005A683F, 0x005C6943,
        0x005B6842, 0x00596541, 0x00596541, 0x00637148, 0x005C6A41, 0x005A6A41, 0x004F5F36, 0x006D7F56, 0x0082946B, 0x007A8E64, 0x0074885E, 0x007C875F, 0x007D8860, 0x007D8860, 0x006C774F, 0x005E6941, 0x0069744C, 0x003B461E, 0x00515C34, 0x005D7144,
        0x005F7247, 0x00758760, 0x00788964, 0x0072835E, 0x007C8E67, 0x005E7146, 0x00576B3E, 0x00556740, 0x00405328, 0x005D7144, 0x004A5E2F, 0x00677B4E, 0x00778A5F, 0x0081936C, 0x00738361, 0x0074865D, 0x00798B62, 0x0075875E, 0x007C8E65, 0x00798B62,
        0x00708259, 0x007B8D64, 0x007A8C63, 0x007C8D68, 0x00788964, 0x0072835E, 0x00768762, 0x007B8C67, 0x00748560, 0x006F805B, 0x00778863, 0x00758760, 0x00758760, 0x00758760, 0x0074865F, 0x0074865F, 0x0074865F, 0x0074865F, 0x0074865F, 0x0073865F,
        0x0073865F, 0x0073865F, 0x0073865F, 0x0073865F, 0x0072855E, 0x0072855E, 0x0072855E, 0x0072855E, 0x0072855E, 0x0072855E, 0x0072855E, 0x0072855E, 0x0072855E, 0x0072855E, 0x0072855E, 0x0073865F, 0x0073865F, 0x0073865F, 0x0073865F, 0x0073865F,
        0x0073865F, 0x0073865F, 0x0073865F, 0x0074875C, 0x0075875E, 0x0074865D, 0x0075875E, 0x0074865F, 0x0072845D, 0x0073845F, 0x0072835E, 0x00768762, 0x00778863, 0x00788964, 0x00748560, 0x0073845F, 0x0073845F, 0x00667752, 0x00556641, 0x00556740,
        0x00556740, 0x005E6F4A, 0x0040512C, 0x00546442, 0x005F6F4D, 0x00697957, 0x005B6A4A, 0x00506239, 0x00667851, 0x007C8D68, 0x007F8C6C, 0x00818D6F, 0x00818A6F, 0x0080896E, 0x007A8368, 0x0073845F, 0x00788866, 0x0071815F, 0x006C7B5B, 0x00667556,
        0x00556445, 0x00475539, 0x003E4C30, 0x0037422E, 0x00545F4B, 0x005D6854, 0x00495440, 0x005D6953, 0x007B886E, 0x00718061, 0x006D7D5B, 0x00718064, 0x00768765, 0x0074875C, 0x007C9063, 0x006A7C55, 0xFF9BA58E, 0xFFFCFFFA, 0xFFFDFDFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFDFF, 0xFFFFFFF8, 0x007F8A6A, 0x006A784F, 0x00818E68, 0x0076835D, 0x00505E34, 0x004C5D2A, 0x0048562D, 0x004F5D34, 0x004C5A31, 0x004E5C32, 0x0049572D,
        0x0048572B, 0x00455428, 0x005C6B3F, 0x006B7E53, 0x00677952, 0x00566644, 0x007F8D71, 0x0099A68C, 0x008D9A80, 0x008A987C, 0x0096A586, 0x00878A7A, 0x00989C89, 0x008B9178, 0x005B6345, 0x0056613B, 0x005F6C40, 0x007F8D5D, 0x007A8956, 0x007F9064,
        0x0078895D, 0x00708155, 0x007C8D61, 0x007A8C5D, 0x007D8F60, 0x007D8F60, 0x00728455, 0x00798960, 0x0074845B, 0x007A8A61, 0x0074845B, 0x00506037, 0x00617148, 0x00516138, 0x00617148, 0x005B693F, 0x005A683E, 0x005A683E, 0x005A683E, 0x005A683E,
        0x0059673D, 0x0058663C, 0x0057653B, 0x0054653A, 0x0055663B, 0x0056673C, 0x0056673C, 0x0055663B, 0x0055663B, 0x0054653A, 0x0054653A, 0x0059673D, 0x0059673D, 0x0059673D, 0x0059673D, 0x0059673D, 0x0058663C, 0x0057653B, 0x0057653B, 0x0056663D,
        0x0056663D, 0x0056663D, 0x0057673E, 0x0057673E, 0x0057673E, 0x0058683F, 0x0058683F, 0x0056673B, 0x0057683C, 0x0058693E, 0x00596A3F, 0x005A6A41, 0x00596940, 0x00586741, 0x00576640, 0x00556339, 0x005D6B42, 0x0059673E, 0x0058663D, 0x00616E48,
        0x005F6C46, 0x005A6642, 0x00616D49, 0x0053623C, 0x00586741, 0x005E6D47, 0x006D7F58, 0x0074865F, 0x0053663F, 0x00596C45, 0x0063764F, 0x005E6B45, 0x0064714B, 0x0065724C, 0x00525F39, 0x005A6741, 0x003E4B25, 0x00505D37, 0x006D7A54, 0x00566A3D,
        0x0073855C, 0x007A8C65, 0x00748462, 0x007A8A68, 0x00778962, 0x004C5E35, 0x00516538, 0x0051643D, 0x00485C32, 0x00384C22, 0x00586C42, 0x0054683E, 0x0050633C, 0x005B6D48, 0x00596A48, 0x005B6E47, 0x00576A43, 0x005B6E47, 0x006B7E57, 0x00798C65,
        0x00798C65, 0x0070835C, 0x006B7E57, 0x00748560, 0x00788964, 0x00748560, 0x0070815C, 0x00748560, 0x0073845F, 0x0070815C, 0x0072835E, 0x00758760, 0x00758760, 0x00758760, 0x00758760, 0x00758760, 0x0074865F, 0x0074865F, 0x0074865F, 0x00748760,
        0x00748760, 0x0073865F, 0x0073865F, 0x0073865F, 0x0073865F, 0x0072855E, 0x0072855E, 0x0073865F, 0x0073865F, 0x0073865F, 0x0073865F, 0x0073865F, 0x0073865F, 0x0073865F, 0x0073865F, 0x0073865F, 0x0073865F, 0x0073865F, 0x0073865F, 0x0073865F,
        0x0073865F, 0x0073865F, 0x0073865F, 0x0074875C, 0x0075875E, 0x00778960, 0x0076885F, 0x0074865F, 0x0074865F, 0x00748560, 0x00768762, 0x00758661, 0x00758661, 0x007A8B66, 0x006F805B, 0x00788964, 0x00768762, 0x0053643F, 0x004F603B, 0x0053653E,
        0x006C7E57, 0x005E6F4A, 0x0053643F, 0x00536341, 0x00576745, 0x00546442, 0x00526141, 0x0064784E, 0x007A8D66, 0x0081936C, 0x006A7B56, 0x006F7C5C, 0x00626E52, 0x00636D56, 0x0069705B, 0x005A6A41, 0x0068784F, 0x005E6D47, 0x004F5D39, 0x00445230,
        0x00424F2F, 0x004E5A3C, 0x00535F43, 0x003A442D, 0x00636C57, 0x005D6652, 0x0048503F, 0x00606954, 0x00798569, 0x00788662, 0x007C8C63, 0x00758664, 0x00788B64, 0x007C8F64, 0x007C8F64, 0x00667752, 0xFF97A08B, 0xFFFCFFFA, 0xFFFDFEFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFDFF, 0xFFFFFFF8, 0x007E8969, 0x006C7A51, 0x0087946E, 0x0084906C, 0x0077855B, 0x00788858, 0x007F8E68, 0x00788761, 0x0077875E, 0x0075855C, 0x0074855A,
        0x007F9065, 0x0075865B, 0x007B8C60, 0x00748754, 0x00738655, 0x006E7F54, 0x007B8A64, 0x0074835D, 0x006E7D57, 0x00798960, 0x007E8F64, 0x00767F64, 0x00717B5D, 0x00788363, 0x006B7753, 0x00728057, 0x00748357, 0x007E8E5F, 0x007C8C5C, 0x00738556,
        0x007D8F60, 0x007A8C5D, 0x00788A5B, 0x00758758, 0x006F8054, 0x0075865A, 0x0075865A, 0x00819168, 0x006E7E55, 0x00708057, 0x00506037, 0x00526239, 0x0055653C, 0x0067774E, 0x00697950, 0x00748357, 0x00748357, 0x00748357, 0x00748357, 0x00758458,
        0x00768559, 0x00758458, 0x00758458, 0x00718256, 0x00728357, 0x00738458, 0x00738458, 0x00728357, 0x00718256, 0x00718256, 0x00718256, 0x006F8054, 0x006F8054, 0x006F8054, 0x006E7F53, 0x006E7F53, 0x006E7F53, 0x006E7F53, 0x006E7F53, 0x006B7C51,
        0x006C7D52, 0x006C7D52, 0x006D7E53, 0x006E7F54, 0x006F8055, 0x006F8055, 0x00708156, 0x006A7E51, 0x006A7E51, 0x006B7F52, 0x006D8055, 0x006E8156, 0x006E8057, 0x006C7E55, 0x006B7D54, 0x0067784D, 0x006F7F56, 0x006D7D54, 0x006B7B52, 0x00707F59,
        0x006D7C56, 0x00697753, 0x006F7D59, 0x006C7A58, 0x00717F5D, 0x0070805E, 0x006C7C5A, 0x00435432, 0x005E6F4D, 0x005E6F4D, 0x004F6340, 0x00627151, 0x00586747, 0x005A6949, 0x005A6949, 0x00435232, 0x00404F2F, 0x005C6B4B, 0x00475636, 0x007A8C63,
        0x007E9069, 0x0071815F, 0x00819070, 0x00718060, 0x00596947, 0x00556740, 0x0056683F, 0x0043572D, 0x005A6D46, 0x00485938, 0x0037462A, 0x00536246, 0x00607051, 0x005E6F4D, 0x005B6D48, 0x00667755, 0x005B6C4A, 0x0050613F, 0x00516240, 0x00657654,
        0x00778866, 0x00798A68, 0x00798A68, 0x00798A65, 0x0070815C, 0x00748560, 0x007C8D68, 0x00778863, 0x0072835E, 0x0071825D, 0x006F805B, 0x0073855E, 0x0073855E, 0x0074865F, 0x0074865F, 0x00758760, 0x00768861, 0x00778962, 0x00778962, 0x00748760,
        0x00748760, 0x00748760, 0x00748760, 0x0073865F, 0x0073865F, 0x0073865F, 0x0073865F, 0x00748760, 0x00748760, 0x00748760, 0x00748760, 0x00748760, 0x00748760, 0x00748760, 0x00748760, 0x0073865F, 0x0073865F, 0x0073865F, 0x0073865F, 0x0073865F,
        0x0073865F, 0x0073865F, 0x0073865F, 0x0074875C, 0x0074865D, 0x00798B62, 0x0075875E, 0x0071835C, 0x0072845D, 0x0072835E, 0x00788964, 0x0072835E, 0x0073845F, 0x00788964, 0x0070815C, 0x00798A65, 0x006F805B, 0x004B5C37, 0x00546540, 0x0061734C,
        0x0083956E, 0x0053643F, 0x0062734E, 0x004D5D3B, 0x00798967, 0x00748462, 0x00849373, 0x007B8C67, 0x007B8D68, 0x007D8E6C, 0x005D6E4D, 0x006F7E63, 0x00677563, 0x00606B61, 0x00626C66, 0x0052633E, 0x0060704E, 0x00526141, 0x00475539, 0x00435036,
        0x0045513B, 0x0055604C, 0x0058634F, 0x00596352, 0x00636D5D, 0x005D655A, 0x00586056, 0x00646D60, 0x00707D65, 0x00758464, 0x0075875E, 0x00758664, 0x00778964, 0x007A8C65, 0x00788A63, 0x00627151, 0xFF949D89, 0xFFFDFFF9, 0xFFFDFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFCFF, 0xFFFFFFF8, 0x007C8668, 0x006A784F, 0x00828F69, 0x007C8864, 0x007C8A61, 0x00819161, 0x007C8B65, 0x00788761, 0x007F8E68, 0x007C8C63, 0x0073835A,
        0x0078895E, 0x007C8D62, 0x00809166, 0x007C8F5E, 0x007C8D61, 0x00819168, 0x00879670, 0x0082906C, 0x00808F69, 0x0084946B, 0x00829368, 0x007F916A, 0x007D8F68, 0x00859770, 0x007E9069, 0x007F9168, 0x00788A61, 0x007D8F66, 0x00798B62, 0x007E8F63,
        0x00798A5E, 0x00718256, 0x006E7F54, 0x007B8C61, 0x0078885F, 0x007B8B62, 0x0076865D, 0x0077875E, 0x00708057, 0x00506037, 0x0057673E, 0x0055653C, 0x006B7B52, 0x007F8F66, 0x007E8E65, 0x00768559, 0x00768559, 0x00768559, 0x00768559, 0x00768559,
        0x00768559, 0x0077865A, 0x0077865A, 0x00738458, 0x00748559, 0x0076875B, 0x0075865A, 0x00738458, 0x00728357, 0x00728357, 0x00738458, 0x00748559, 0x00748559, 0x00748559, 0x00748559, 0x00748559, 0x0075865A, 0x0075865A, 0x0075865A, 0x00728358,
        0x00738459, 0x00738459, 0x0074855A, 0x0074855A, 0x0075865B, 0x0075865B, 0x0075865B, 0x0075895C, 0x0074885B, 0x0075895C, 0x00778B5E, 0x00798C61, 0x00798C61, 0x00778960, 0x0076885F, 0x00798A5F, 0x0076865D, 0x0078885F, 0x0073835A, 0x0066754F,
        0x005F6E48, 0x005E6C48, 0x005A6844, 0x00596849, 0x004E5D3E, 0x005E6D4E, 0x00485839, 0x00586849, 0x00415132, 0x002F4122, 0x00394B2C, 0x00415336, 0x0035472A, 0x004B5D40, 0x003D4F32, 0x0037492C, 0x005F7154, 0x00293B1E, 0x0046583B, 0x005B6C47,
        0x00667654, 0x004E5D3E, 0x004F5D41, 0x004C5A3E, 0x00485738, 0x004E5E3C, 0x005D6E49, 0x00748B5E, 0x00475B38, 0x0057674F, 0x00414E40, 0x00556254, 0x0041503B, 0x003A4C2D, 0x003A4F28, 0x00304223, 0x00405233, 0x00445637, 0x00536546, 0x00596B4C,
        0x00516344, 0x00566849, 0x00586A4B, 0x005F704B, 0x00546540, 0x00596A45, 0x006D7E59, 0x00778863, 0x0073845F, 0x0071825D, 0x00768762, 0x0073855E, 0x0073855E, 0x0074865F, 0x00758760, 0x00768861, 0x00768861, 0x00778962, 0x00778962, 0x00758861,
        0x00758861, 0x00758861, 0x00748760, 0x00748760, 0x00748760, 0x00748760, 0x00748760, 0x00748760, 0x00748760, 0x00748760, 0x00748760, 0x00748760, 0x00748760, 0x00748760, 0x00748760, 0x0073865F, 0x0073865F, 0x0073865F, 0x0073865F, 0x0073865F,
        0x0073865F, 0x0073865F, 0x0073865F, 0x0074875C, 0x0073855C, 0x00788A61, 0x006F8158, 0x00667851, 0x00667851, 0x00657651, 0x006E7F5A, 0x0071825D, 0x00768762, 0x0073845F, 0x00768762, 0x0070815C, 0x00546540, 0x00455631, 0x0051623D, 0x0054663F,
        0x0061734C, 0x00465732, 0x00556641, 0x00425230, 0x00647452, 0x005F6F4D, 0x006D7C5C, 0x006C785A, 0x005C6B4C, 0x00758566, 0x0055684F, 0x00647665, 0x005E6F6B, 0x0054646B, 0x005D6A78, 0x004D5B43, 0x00606E56, 0x00687460, 0x00838F7D, 0x0097A194,
        0x00959E94, 0x00979E99, 0x008E9590, 0x00818A80, 0x00808782, 0x00979C9D, 0x00A3A8AB, 0x00A3AAA7, 0x009CA699, 0x00839277, 0x00758664, 0x0077866A, 0x007A8A6B, 0x007B8A6A, 0x007B8A6A, 0x0068765A, 0xFF969F8B, 0xFFFDFFF9, 0xFFFAFEF9, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFCFF, 0xFFFDFFF7, 0x007D8769, 0x006D7A54, 0x00838F6B, 0x00798561, 0x007C8A61, 0x00829262, 0x0082916B, 0x00798862, 0x007B8A64, 0x007F8F66, 0x007C8C63,
        0x0078895E, 0x007F9065, 0x0077885D, 0x007A8B60, 0x007D8C66, 0x007B8967, 0x00778464, 0x007A8668, 0x00748161, 0x00697753, 0x006E7D57, 0x006B7F54, 0x00697D52, 0x006C8055, 0x0075895F, 0x007C8F68, 0x0071845D, 0x00798B66, 0x0072845F, 0x007B8C61,
        0x00728358, 0x00798A5F, 0x0078885F, 0x00788761, 0x0071805A, 0x007E8C68, 0x007C8A66, 0x006E7E55, 0x0053633A, 0x00596940, 0x0054643B, 0x0067774E, 0x007C8C63, 0x0073835A, 0x0075855C, 0x007B8A5E, 0x007B8A5E, 0x007B8A5E, 0x0079885C, 0x0077865A,
        0x00768559, 0x00768559, 0x0077865A, 0x00738556, 0x00758758, 0x00768859, 0x00768859, 0x00748657, 0x00728455, 0x00738556, 0x00738556, 0x00738458, 0x00738458, 0x00738458, 0x00738458, 0x00738458, 0x00748559, 0x0075865A, 0x0075865A, 0x0074855A,
        0x0074855A, 0x0074855A, 0x0074855A, 0x0074855A, 0x0074855A, 0x0074855A, 0x0074855A, 0x00718556, 0x00708457, 0x00718558, 0x0073875A, 0x0075885D, 0x0076895E, 0x0074865D, 0x0072845B, 0x00798A5F, 0x006E7E55, 0x0078885F, 0x0077875E, 0x005E6D47,
        0x005B6A44, 0x0062704C, 0x0055633F, 0x0038452B, 0x00455238, 0x003C492F, 0x0057664B, 0x00415035, 0x0037482D, 0x00627358, 0x0067785D, 0x003A4D34, 0x00374A31, 0x00485B42, 0x0055684F, 0x0050634A, 0x002B3E25, 0x0043563D, 0x00667960, 0x005B6A4A,
        0x003B4A2B, 0x0049563C, 0x00606D55, 0x0056634B, 0x00546147, 0x00546344, 0x007A8969, 0x00738A5D, 0x006B7F5C, 0x004D5B49, 0x00656F69, 0x0078817E, 0x00536052, 0x00344627, 0x003D5329, 0x00627358, 0x0055664B, 0x00304126, 0x00425338, 0x004C5D42,
        0x00324328, 0x0035462B, 0x002D3E23, 0x004B5C37, 0x00596A45, 0x0051623D, 0x0052633E, 0x0071825D, 0x007B8C67, 0x0070815C, 0x0072835E, 0x00768861, 0x00768861, 0x00768861, 0x00758760, 0x00758760, 0x00758760, 0x00758760, 0x0074865F, 0x00768962,
        0x00758861, 0x00758861, 0x00758861, 0x00758861, 0x00748760, 0x00748760, 0x00748760, 0x00748760, 0x00748760, 0x00748760, 0x00748760, 0x00748760, 0x00748760, 0x00748760, 0x00748760, 0x0073865F, 0x0073865F, 0x0073865F, 0x0073865F, 0x0073865F,
        0x0073865F, 0x0073865F, 0x0073865F, 0x0074875C, 0x0072845B, 0x0076885F, 0x00687A51, 0x005A6C45, 0x00576942, 0x00556641, 0x005E6F4A, 0x00748560, 0x007B8C67, 0x0070815C, 0x007B8C67, 0x00647550, 0x00384924, 0x003E4F2A, 0x00475833, 0x0042542D,
        0x0024360F, 0x00394A25, 0x003C4D28, 0x003D4D2B, 0x002E3E1C, 0x00495937, 0x006F7E5E, 0x00869276, 0x00556347, 0x00718065, 0x00556853, 0x006B7E75, 0x006E8186, 0x005F7083, 0x005F708B, 0x00515E4E, 0x00616E5E, 0x006B776B, 0x008E9991, 0x00A2ABA8,
        0x0098A0A0, 0x009BA2A5, 0x00999FA4, 0x00959E9B, 0x008F9699, 0x00A9AEB7, 0x00A2A6B1, 0x009FA5AA, 0x009DA8A0, 0x00778671, 0x00728465, 0x0076846C, 0x0078876C, 0x00768468, 0x00778569, 0x0067745A, 0xFF949C8B, 0xFFFDFFF8, 0xFFF7FBF5, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFEFF, 0xFFFFFEFE, 0x00788664, 0x006E8450, 0x00788768, 0x0082906C, 0x0060703A, 0x00667045, 0x00626E44, 0x00677349, 0x00647046, 0x006B774D, 0x00677349,
        0x00667248, 0x00616D43, 0x00748056, 0x00778863, 0x00495838, 0x0049563C, 0x005B6751, 0x003F4C34, 0x00334223, 0x0030421B, 0x00384B20, 0x002B3820, 0x00303D23, 0x00374529, 0x00414E2E, 0x004C5A38, 0x005F6C46, 0x00818F66, 0x0076845A, 0x007F9261,
        0x00718453, 0x007B8D5E, 0x007A8B60, 0x0074845B, 0x007B8A64, 0x007A8864, 0x00768462, 0x00617148, 0x00516138, 0x00526239, 0x006B7C51, 0x007D8E63, 0x00798A5F, 0x00748559, 0x0076875B, 0x00768859, 0x00768859, 0x00768859, 0x00758758, 0x00758758,
        0x00748657, 0x00748657, 0x00748657, 0x0078875B, 0x0078875B, 0x0077865A, 0x0077865A, 0x0077865A, 0x0077865A, 0x00768559, 0x00768559, 0x00738458, 0x00728357, 0x00728357, 0x00728357, 0x00738458, 0x00748559, 0x00738458, 0x00728357, 0x0074855A,
        0x0075865B, 0x0075865B, 0x0076875C, 0x0076875C, 0x0075865B, 0x0075865B, 0x0074855A, 0x00728455, 0x00728455, 0x00748559, 0x0075865A, 0x0076875C, 0x0077885D, 0x0077885D, 0x0077875E, 0x00738955, 0x00768B5A, 0x006F8257, 0x0070825D, 0x00526243,
        0x0058694E, 0x0034432E, 0x00677563, 0x00536A3D, 0x005E6E57, 0x00737B7A, 0x00737F79, 0x002A3D22, 0x00415936, 0x0041553E, 0x004E5C58, 0x006D7A62, 0x006F7969, 0x00727972, 0x006D776B, 0x004D5A44, 0x0027391C, 0x0051614A, 0x00374434, 0x00677B58,
        0x005F7055, 0x005B685A, 0x007A847E, 0x0077827A, 0x003E4D38, 0x00667A57, 0x00748B5E, 0x00798C61, 0x0076885F, 0x00495838, 0x00515A4D, 0x00717576, 0x006B706F, 0x00596450, 0x0072835E, 0x00424F3F, 0x004A5A43, 0x00435439, 0x00293521, 0x00616B5F,
        0x00636B60, 0x0057644C, 0x0051613F, 0x0067706D, 0x0037423A, 0x00596454, 0x00455439, 0x00718060, 0x006B7B59, 0x0073845F, 0x0075835F, 0x0072845F, 0x0072845F, 0x0072845F, 0x00738560, 0x00738560, 0x00738560, 0x00738560, 0x00748661, 0x00778962,
        0x00768861, 0x00758760, 0x00758760, 0x0074865F, 0x00758760, 0x00758760, 0x00758760, 0x00768861, 0x00758760, 0x0074865F, 0x0073855E, 0x0073855E, 0x0074865F, 0x00758760, 0x00768861, 0x00778962, 0x00778962, 0x00768861, 0x00758760, 0x0073855E,
        0x0073855E, 0x0074865F, 0x00768861, 0x00768C62, 0x006D8359, 0x00768B65, 0x00586C49, 0x0057694A, 0x00435538, 0x005D6E53, 0x004C5C44, 0x007F8A69, 0x007C8668, 0x00758163, 0x00798765, 0x0063754C, 0x00485938, 0x00656F63, 0x005C5F67, 0x004F603B,
        0x001F2919, 0x00424647, 0x00626964, 0x0059684D, 0x00364928, 0x003C4939, 0x004D5358, 0x00726E7A, 0x00787965, 0x00788254, 0x00465539, 0x005B7282, 0x006C89BC, 0x006587BC, 0x006B92B9, 0x005E6C66, 0x00536449, 0x006D7C5D, 0x008A8E88, 0x00B0ADB6,
        0x00959798, 0x00A1A6A5, 0x009FA5AA, 0x00ABB7BD, 0x00A8B6B5, 0x009CAAA6, 0x00A1ABAB, 0x00A2A8AD, 0x009BA29F, 0x007B8872, 0x0073855E, 0x00798B62, 0x00778765, 0x00798869, 0x00798765, 0x00687652, 0xFF96A082, 0xFFFFFFF8, 0xFFFDFBFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFEFF, 0xFFFFFEFE, 0x00798765, 0x00738955, 0x007B8A6B, 0x0073815D, 0x003F4F19, 0x00414B20, 0x0039451B, 0x00364218, 0x0039451B, 0x0039451B, 0x002D390F,
        0x0038441A, 0x003C481E, 0x004C582E, 0x00687758, 0x004F5C44, 0x00535D4D, 0x00889086, 0x009CA49A, 0x00A3AC9F, 0x00A1AC98, 0x00A0AD93, 0x0099A392, 0x00A5AF9E, 0x00727E68, 0x00444F35, 0x004A5638, 0x00576242, 0x007C8864, 0x0084906C, 0x007C8D61,
        0x00798A5E, 0x007C8D61, 0x00809166, 0x0078885F, 0x0075855C, 0x006F7E58, 0x005A6943, 0x0054643B, 0x0058683F, 0x0066764D, 0x0076875C, 0x007B8C61, 0x0075865A, 0x00748559, 0x00798A5E, 0x00768859, 0x00768859, 0x00768859, 0x00758758, 0x00758758,
        0x00748657, 0x00748657, 0x00748657, 0x0078875B, 0x0077865A, 0x0077865A, 0x0077865A, 0x0077865A, 0x00768559, 0x00768559, 0x00768559, 0x00748559, 0x00738458, 0x00738458, 0x00738458, 0x00748559, 0x0075865A, 0x00748559, 0x00738458, 0x0074855A,
        0x0074855A, 0x0075865B, 0x0075865B, 0x0075865B, 0x0075865B, 0x0074855A, 0x0074855A, 0x00718354, 0x00728455, 0x00738556, 0x0075865A, 0x0076875B, 0x0076875C, 0x0076875C, 0x0076875C, 0x006D834F, 0x00728756, 0x0082956A, 0x0071845D, 0x004A5B3A,
        0x00637257, 0x0062725B, 0x004E5D48, 0x003E5027, 0x0065715D, 0x006B726F, 0x00717972, 0x00304126, 0x00465B35, 0x005D7055, 0x005B695D, 0x003F4E2F, 0x004F5948, 0x00535A53, 0x00535C52, 0x004E5A46, 0x00344327, 0x0058694E, 0x00596853, 0x00546543,
        0x00425136, 0x00545F4F, 0x00676F68, 0x00687167, 0x0044503C, 0x005D6E4C, 0x007B9063, 0x00718459, 0x007B8D64, 0x00576646, 0x005B6555, 0x00767B7A, 0x006A6F6D, 0x00444F3B, 0x00445530, 0x00677760, 0x0056684B, 0x00415132, 0x0036432D, 0x00656F63,
        0x005E665C, 0x005A6551, 0x003C4B2B, 0x005A6A52, 0x005E6F54, 0x00647554, 0x004B5D38, 0x0074865F, 0x007B8D66, 0x00748560, 0x00717F5D, 0x00738560, 0x00738560, 0x00738560, 0x00738560, 0x00738560, 0x00748661, 0x00748661, 0x00748661, 0x00768861,
        0x00768861, 0x00758760, 0x00758760, 0x0074865F, 0x0074865F, 0x00758760, 0x00758760, 0x00768861, 0x00758760, 0x0074865F, 0x0073855E, 0x0073855E, 0x0074865F, 0x00758760, 0x00768861, 0x00758760, 0x00768861, 0x00768861, 0x00758760, 0x0074865F,
        0x0074865F, 0x00758760, 0x00768861, 0x00758B61, 0x0073895F, 0x00748962, 0x00566A47, 0x00536645, 0x004E6043, 0x0066775C, 0x00536449, 0x005F6F46, 0x00788662, 0x007A8866, 0x00778960, 0x006A7E51, 0x004C5E37, 0x005D6957, 0x00606665, 0x004B5B39,
        0x00404A3A, 0x00888C8D, 0x00A9B0AB, 0x007C8A72, 0x00314122, 0x00596658, 0x00A3A9AE, 0x008D969F, 0x004A5640, 0x00415324, 0x00516947, 0x00708D92, 0x007698BC, 0x0082A8CB, 0x007298B0, 0x0064756C, 0x00405639, 0x00475738, 0x00636B61, 0x009C9CA2,
        0x00909495, 0x00A0A9A6, 0x00A4ADB0, 0x00B3BFC5, 0x00A6B4B3, 0x0099A7A3, 0x00939D9D, 0x008E9499, 0x00939A97, 0x007E8A74, 0x00788A63, 0x00788A61, 0x00778765, 0x00798869, 0x007A8866, 0x00677551, 0xFF949E80, 0xFFFFFFF8, 0xFFFEFCFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFBFC, 0xFFFBF9F9, 0x00707E5C, 0x00708652, 0x00819071, 0x0073815D, 0x003B4B15, 0x00485227, 0x00677349, 0x00576339, 0x00424E24, 0x00475329, 0x005D693F,
        0x00546036, 0x00303C12, 0x00546036, 0x006A775F, 0x00545E4D, 0x00636A63, 0x00C4C8C9, 0x00EAEDF2, 0x00DEE1E5, 0x00D5DAD9, 0x00DDE3DE, 0x00ECF3EC, 0x00EFF7ED, 0x008F978C, 0x00464D3E, 0x0057604C, 0x005D664C, 0x00687156, 0x00656F51, 0x005A6747,
        0x005C6949, 0x00546240, 0x005B6947, 0x0054623E, 0x0056653F, 0x0066754F, 0x0063724C, 0x0055653C, 0x0067774E, 0x0078895E, 0x007C8D62, 0x0076875B, 0x00738458, 0x0075865A, 0x00798B5C, 0x00768859, 0x00768859, 0x00758758, 0x00758758, 0x00758758,
        0x00758758, 0x00748657, 0x00748657, 0x0077865A, 0x0077865A, 0x0077865A, 0x0077865A, 0x0077865A, 0x00768559, 0x00768559, 0x00768559, 0x0075865A, 0x00748559, 0x00738458, 0x00748559, 0x0075865A, 0x0075865A, 0x00748559, 0x00738458, 0x0074855A,
        0x0074855A, 0x0075865B, 0x0075865B, 0x0075865B, 0x0075865B, 0x0074855A, 0x0074855A, 0x00718354, 0x00728455, 0x00738556, 0x00748559, 0x0075865A, 0x0075865A, 0x0075865B, 0x0075865B, 0x00778A59, 0x00758857, 0x006A7E51, 0x0074865F, 0x007B8C6A,
        0x00404F33, 0x002D3B23, 0x0054644C, 0x00535F3B, 0x00434B3A, 0x00494D48, 0x004E5449, 0x003D4C2D, 0x006F8158, 0x00586947, 0x0058654F, 0x00707F59, 0x00424C35, 0x00444B44, 0x00505651, 0x00465141, 0x004A593D, 0x00718261, 0x00506243, 0x00606E4C,
        0x00626E52, 0x00454D3C, 0x004E5449, 0x004E5548, 0x00363F2A, 0x0072805E, 0x0074855A, 0x00788A61, 0x00809269, 0x00586846, 0x0046513D, 0x004E544F, 0x00474E47, 0x0047533D, 0x00667851, 0x00506243, 0x004C5D3B, 0x0070825D, 0x00435237, 0x004B5447,
        0x004C544A, 0x00404837, 0x00535F43, 0x004F653B, 0x00344B1F, 0x00455A2D, 0x006D8353, 0x0073875A, 0x006B7D54, 0x00748560, 0x00778563, 0x0073865F, 0x0073865F, 0x0073865F, 0x00748760, 0x00748760, 0x00748760, 0x00748760, 0x00748760, 0x00768861,
        0x00768861, 0x00758760, 0x0074865F, 0x0074865F, 0x0074865F, 0x00758760, 0x00758760, 0x00768861, 0x00758760, 0x0074865F, 0x0073855E, 0x0073855E, 0x0074865F, 0x00758760, 0x00768861, 0x0073855E, 0x00758760, 0x00768861, 0x00768861, 0x00758760,
        0x0074865F, 0x00758760, 0x00768861, 0x0072865C, 0x0073875D, 0x00798C65, 0x0070825D, 0x005E6F4D, 0x00506140, 0x00627253, 0x00657458, 0x00516236, 0x006A7953, 0x0073845F, 0x007B8D64, 0x00708455, 0x004B5D34, 0x004B5840, 0x00495049, 0x003C482A,
        0x002F3629, 0x005F6463, 0x006E746F, 0x00505C48, 0x001B2911, 0x00636D61, 0x00A6ACB1, 0x00859A9B, 0x003B5138, 0x00607A4A, 0x004D6C47, 0x005E807F, 0x0083ACC3, 0x007FA9C0, 0x0090BAC6, 0x0071847B, 0x00425A3C, 0x00364B2A, 0x005D665C, 0x00A5A9AE,
        0x00A1A6A7, 0x00AAB5B2, 0x00AFBBBD, 0x00B5C1C7, 0x00AEBABA, 0x00B8C6C2, 0x00B4BEBE, 0x00A0A6AB, 0x00A1A8A5, 0x00808C76, 0x006C7E57, 0x00778960, 0x00778765, 0x00798869, 0x007B8967, 0x00677551, 0xFF919B7D, 0xFFFFFFF8, 0xFFFEFCFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFEFF, 0xFFFEFCFC, 0x006C7A58, 0x006C824E, 0x00829172, 0x0072805C, 0x0040501A, 0x005C663B, 0x006C784E, 0x00616D43, 0x00505C32, 0x005D693F, 0x007E8A60,
        0x00677349, 0x002B370D, 0x00546036, 0x00728162, 0x0054604A, 0x00727A70, 0x00D9DDDE, 0x00E3E5ED, 0x00C6C7D1, 0x00BBBEC3, 0x00CCCFD3, 0x00D2D5D9, 0x00E6EAEB, 0x00A5AAA8, 0x005F645B, 0x00565D50, 0x00414734, 0x00464E37, 0x00565F45, 0x00697063,
        0x004F5647, 0x00353D2C, 0x003E4733, 0x0047513A, 0x00535E44, 0x00576347, 0x00586448, 0x006D7E53, 0x0075865B, 0x007A8B60, 0x0078895D, 0x00748559, 0x0075865A, 0x00768859, 0x00768859, 0x00758758, 0x00758758, 0x00758758, 0x00758758, 0x00758758,
        0x00758758, 0x00758758, 0x00758758, 0x00778758, 0x00778758, 0x00778758, 0x00778758, 0x00768657, 0x00768657, 0x00768657, 0x00768657, 0x00748657, 0x00738556, 0x00728455, 0x00738556, 0x00748657, 0x00758758, 0x00748657, 0x00738556, 0x00738458,
        0x00748559, 0x00748559, 0x00748559, 0x00748559, 0x00748559, 0x00748559, 0x00738458, 0x00718453, 0x00728554, 0x00738556, 0x00748657, 0x0075865A, 0x0075865A, 0x0075865A, 0x0075865B, 0x00778A59, 0x006B7D4E, 0x00809165, 0x007D8F66, 0x00586944,
        0x00536443, 0x005E6D51, 0x0048573C, 0x0041492A, 0x00454936, 0x00393A31, 0x00494E3F, 0x004D5838, 0x00738459, 0x0078885F, 0x0073815F, 0x006A7C4D, 0x00465234, 0x00454A41, 0x00464C47, 0x00495343, 0x00516142, 0x006F815C, 0x0070835C, 0x0076825E,
        0x00616B4D, 0x004D543F, 0x00454B3A, 0x00454B3A, 0x00414932, 0x00667151, 0x0075825C, 0x0072835E, 0x006D7F58, 0x004A5A38, 0x00435038, 0x004A5247, 0x00394136, 0x00445139, 0x0072845D, 0x0071835E, 0x00798D63, 0x00667A50, 0x003C4B2C, 0x00505A4A,
        0x004C5148, 0x00474E3F, 0x003F4A30, 0x00506342, 0x00495D3A, 0x004F623B, 0x005F7348, 0x007A8D62, 0x0073855C, 0x0071835C, 0x007A8864, 0x0073865F, 0x00748760, 0x00748760, 0x00748760, 0x00748760, 0x00758861, 0x00758861, 0x00758861, 0x00768861,
        0x00758760, 0x00758760, 0x0074865F, 0x0074865F, 0x0074865F, 0x0074865F, 0x00758760, 0x00758760, 0x00758760, 0x0074865F, 0x0074865F, 0x0074865F, 0x0074865F, 0x00758760, 0x00758760, 0x0072845D, 0x0073855E, 0x00758760, 0x00768861, 0x00758760,
        0x00758760, 0x00758760, 0x00768861, 0x00788C62, 0x0071855B, 0x006E815A, 0x007C8E69, 0x00768863, 0x006A7B59, 0x00627351, 0x00576847, 0x006E8059, 0x00596848, 0x00515F43, 0x005E6D4D, 0x00576942, 0x00485634, 0x004D5642, 0x00484C46, 0x00414D31,
        0x002D3425, 0x0050544F, 0x00596059, 0x004A5443, 0x001E2B15, 0x005F695D, 0x00777C7D, 0x00738A82, 0x00647B5F, 0x00627A50, 0x00284728, 0x00507678, 0x0081ACC7, 0x007BAAC6, 0x0084B4C6, 0x00596E65, 0x00375133, 0x00344C2A, 0x005F6A60, 0x00A3A7AC,
        0x009BA3A2, 0x00A8B6B2, 0x00BCC9CB, 0x00B3BDC4, 0x00ACB8B8, 0x00C4CFCC, 0x00B9C1C1, 0x00999DA2, 0x009FA4A2, 0x00828E78, 0x0072815B, 0x0076885F, 0x00788866, 0x00798869, 0x007C8A68, 0x00667450, 0xFF8D9779, 0xFFFFFFF8, 0xFFFFFDFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFEFF, 0xFFFEFCFC, 0x006E7C5A, 0x006D834F, 0x00819071, 0x006F7D59, 0x003D4D17, 0x005D673C, 0x004C582E, 0x004D592F, 0x00606C42, 0x0068744A, 0x00657147,
        0x00626E44, 0x00414D23, 0x00525E34, 0x007C8E67, 0x00617051, 0x00889281, 0x00DCE2DD, 0x00D2D6D7, 0x00CBCED2, 0x00C6CACB, 0x00CBD0CF, 0x00D1D3DB, 0x00DDE0E5, 0x00ADB2B1, 0x00848883, 0x00888F82, 0x00646A59, 0x00606851, 0x00848D73, 0x008E9090,
        0x006F7270, 0x005D615C, 0x00636761, 0x0072776E, 0x00838A7D, 0x005F6657, 0x00545B4C, 0x007E8F64, 0x00798A5F, 0x0075865A, 0x00748559, 0x0076875B, 0x0077895A, 0x00768859, 0x00768859, 0x00758758, 0x00758758, 0x00758758, 0x00758758, 0x00758758,
        0x00758758, 0x00758758, 0x00758758, 0x00778758, 0x00778758, 0x00778758, 0x00768657, 0x00768657, 0x00768657, 0x00768657, 0x00758556, 0x00738556, 0x00728455, 0x00718354, 0x00718354, 0x00738556, 0x00738556, 0x00728455, 0x00718354, 0x00738458,
        0x00738458, 0x00738458, 0x00748559, 0x00748559, 0x00738458, 0x00738458, 0x00738458, 0x00728554, 0x00728554, 0x00738655, 0x00748657, 0x00748657, 0x0075865A, 0x00748559, 0x00748559, 0x00758555, 0x00788859, 0x00728357, 0x006E7F54, 0x0052643D,
        0x00566644, 0x00475837, 0x005F704F, 0x004C5233, 0x008A8D77, 0x009B9E8E, 0x007D826D, 0x00475231, 0x004D5B31, 0x00556438, 0x0057673E, 0x004F602D, 0x00657050, 0x009EA598, 0x00A4A9A0, 0x0076816D, 0x004D5D3B, 0x004B5F35, 0x00506439, 0x005B6842,
        0x004F5A39, 0x00677056, 0x00939A85, 0x008E9580, 0x00586147, 0x004E5939, 0x00596541, 0x00566545, 0x0051623D, 0x004B5C37, 0x006D7B5F, 0x008C9686, 0x00697363, 0x00475539, 0x004A5C33, 0x00485B34, 0x00506538, 0x00465A2D, 0x005B6A4A, 0x009EA695,
        0x00979D92, 0x00777D6A, 0x003A4328, 0x00596559, 0x00505D4D, 0x005D6B53, 0x00465637, 0x006E7F5A, 0x00768861, 0x007A8C65, 0x0075845E, 0x0073875D, 0x0074885E, 0x0074885E, 0x0074885E, 0x0074885E, 0x0075895F, 0x0075895F, 0x0075895F, 0x00768861,
        0x00758760, 0x0074865F, 0x0074865F, 0x0074865F, 0x0074865F, 0x0074865F, 0x0074865F, 0x00758760, 0x00758760, 0x0074865F, 0x0074865F, 0x0074865F, 0x0074865F, 0x00758760, 0x00758760, 0x0071835C, 0x0073855E, 0x00758760, 0x00768861, 0x00758760,
        0x0074865F, 0x00758760, 0x00758760, 0x0073855C, 0x007A8C63, 0x0073855E, 0x00778962, 0x00788A63, 0x007F916A, 0x0071825D, 0x00546540, 0x005A6C4D, 0x0064715B, 0x00626D5D, 0x00545E4D, 0x004B563C, 0x00626D53, 0x0082867A, 0x00888987, 0x0060694F,
        0x00444A37, 0x006C7366, 0x00868D80, 0x0068735F, 0x0035402C, 0x007D877A, 0x009DA49F, 0x00728376, 0x00606D53, 0x0052603E, 0x00203421, 0x00557580, 0x0083AECF, 0x0079A6CB, 0x007EADCD, 0x00596F63, 0x00395131, 0x00314625, 0x005B6559, 0x009CA1A4,
        0x009BA3A2, 0x00ABB7B1, 0x00BECACA, 0x00B0BAC1, 0x00AFB9B9, 0x00C6D1CE, 0x00B6BEBE, 0x00909499, 0x00969B99, 0x00818A75, 0x0074835D, 0x0076885F, 0x00798967, 0x00788768, 0x007E8C6A, 0x00677551, 0xFF8B9577, 0xFFFFFFF8, 0xFFFFFDFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFBFC, 0xFFFEFCFC, 0x006F7D5B, 0x006D834F, 0x00808F70, 0x00717F5B, 0x003F4F19, 0x005B653A, 0x00647046, 0x005C683E, 0x005B673D, 0x00606C42, 0x00657147,
        0x00616D43, 0x00414D23, 0x00525E34, 0x006D7F56, 0x005B6A4A, 0x007B8672, 0x00D3DBD1, 0x00D2D7D5, 0x00D2D7D6, 0x00CBD0CE, 0x00C8CFC8, 0x00D2D5DA, 0x00E5E8EC, 0x00AEB3B1, 0x00969B92, 0x00949B8C, 0x00505841, 0x00525B40, 0x008A9575, 0x00999D97,
        0x00737771, 0x005B5F59, 0x00656A61, 0x0093998E, 0x00BCC2B7, 0x007A8174, 0x0052594C, 0x007D8E63, 0x0076875B, 0x00738458, 0x0076875B, 0x00798B5C, 0x0077895A, 0x00768958, 0x00788B5A, 0x00748657, 0x00748657, 0x00758758, 0x00758758, 0x00758758,
        0x00758758, 0x00768859, 0x00768859, 0x00778757, 0x00768656, 0x00768656, 0x00768656, 0x00768656, 0x00758555, 0x00758555, 0x00758555, 0x00728554, 0x00718453, 0x00708352, 0x00718453, 0x00728554, 0x00728554, 0x00728554, 0x00708352, 0x00728455,
        0x00728455, 0x00738556, 0x00738556, 0x00738556, 0x00738556, 0x00728455, 0x00728455, 0x00738653, 0x00738653, 0x00748756, 0x00748756, 0x00758758, 0x00758758, 0x00748657, 0x00748559, 0x00758555, 0x007A8A5B, 0x007A8A5B, 0x0074855A, 0x0054643B,
        0x0060724B, 0x004D5E39, 0x005E6F4A, 0x00626C48, 0x007E8667, 0x009FA68B, 0x007C856A, 0x005C6746, 0x0067774E, 0x0056673C, 0x00617247, 0x00637441, 0x005F6A49, 0x00929885, 0x009AA291, 0x006D795D, 0x005A6C45, 0x0065784D, 0x005D6F46, 0x005D6C46,
        0x00677551, 0x00738060, 0x00ABB79B, 0x00A2AD93, 0x00647054, 0x006C785A, 0x006A7757, 0x00617051, 0x00647550, 0x0060724B, 0x00728161, 0x008E9A84, 0x0078836F, 0x00627152, 0x005D6F46, 0x00657750, 0x00586B40, 0x005E7245, 0x005B6947, 0x00616A55,
        0x00616756, 0x00697258, 0x0065714D, 0x006A7370, 0x00404B41, 0x005E6A58, 0x0059684C, 0x00738361, 0x006E8059, 0x007A8C63, 0x00728259, 0x0073875D, 0x0073875D, 0x0073875D, 0x0074885E, 0x0074885E, 0x0074885E, 0x0074885E, 0x0074885E, 0x00758760,
        0x00758760, 0x0074865F, 0x0074865F, 0x0073855E, 0x0073855E, 0x0074865F, 0x0074865F, 0x00758760, 0x00758760, 0x0074865F, 0x0074865F, 0x0074865F, 0x0074865F, 0x00758760, 0x00758760, 0x0072845D, 0x0074865F, 0x00758760, 0x00758760, 0x0074865F,
        0x0074865F, 0x0074865F, 0x00758760, 0x0070825B, 0x007A8C63, 0x0076885F, 0x0074865D, 0x0072845B, 0x0076885F, 0x00798B62, 0x006F8158, 0x004D6242, 0x004E5D48, 0x00576155, 0x006D7669, 0x006D7661, 0x005E664F, 0x006A6D5E, 0x009D9C98, 0x0097A085,
        0x00737C62, 0x00939A85, 0x00BAC3AE, 0x00A3AC97, 0x0066725C, 0x00747E6D, 0x00656E61, 0x0063715F, 0x00434C32, 0x006E755A, 0x00536052, 0x00637D84, 0x0088ABC5, 0x0084AAC8, 0x008CB1CB, 0x0055665B, 0x00536A4A, 0x00617250, 0x0070786D, 0x00828387,
        0x00717674, 0x008D9791, 0x00B0BABA, 0x00A3ABB2, 0x00A2ACAC, 0x00AEB7B4, 0x009DA2A3, 0x007F8287, 0x00888B89, 0x007A836E, 0x0078855F, 0x00778960, 0x007A8A68, 0x00778667, 0x007F8D6B, 0x00687652, 0xFF8A9476, 0xFFFFFFF8, 0xFFFFFDFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFEFF, 0xFFFFFFFF, 0x00717F5D, 0x006C824E, 0x007E8D6E, 0x0073815D, 0x003D4D17, 0x004C562B, 0x00748056, 0x00657147, 0x00445026, 0x004E5A30, 0x0069754B,
        0x0059653B, 0x00344016, 0x00556137, 0x006A795A, 0x007C8971, 0x0080887D, 0x00D8DDDB, 0x00E6E9ED, 0x00D7DBDC, 0x00CED3D1, 0x00CFD5D0, 0x00DFE3E4, 0x00E3E8E7, 0x00939A93, 0x009EA596, 0x00A8B19C, 0x00555F41, 0x005B6743, 0x0068754F, 0x00576347,
        0x005C684C, 0x00596549, 0x00586349, 0x005A654B, 0x00707A63, 0x0057614A, 0x00616A55, 0x0076875B, 0x00748559, 0x0075865A, 0x0077895A, 0x00788A5B, 0x00768958, 0x00768958, 0x00778A59, 0x00748657, 0x00748657, 0x00748657, 0x00758758, 0x00758758,
        0x00768859, 0x00768859, 0x00768859, 0x00768656, 0x00768656, 0x00768656, 0x00768656, 0x00768656, 0x00758555, 0x00758555, 0x00758555, 0x00738655, 0x00728554, 0x00718453, 0x00718453, 0x00738655, 0x00738655, 0x00728554, 0x00718453, 0x00728455,
        0x00728455, 0x00738556, 0x00738556, 0x00738556, 0x00738556, 0x00728455, 0x00728455, 0x00738653, 0x00748754, 0x00758855, 0x00758857, 0x00758857, 0x00758758, 0x00758758, 0x00748657, 0x00798959, 0x00738354, 0x00758556, 0x007A895D, 0x0065764B,
        0x0056663D, 0x004C5E37, 0x0051633C, 0x004E5C32, 0x003B4B22, 0x00202F09, 0x00303E1C, 0x00445432, 0x0052633E, 0x005D7147, 0x0051653A, 0x0059693A, 0x0045512D, 0x00313922, 0x002E371D, 0x00414F2B, 0x004F6034, 0x00506338, 0x005A6C45, 0x005B6F45,
        0x00475A33, 0x0040512F, 0x00314122, 0x002E3E1F, 0x00415034, 0x005A6A4B, 0x00748465, 0x00576549, 0x005B6B49, 0x0044562D, 0x002A3A18, 0x002D3A20, 0x002B3820, 0x00415030, 0x0056693E, 0x004E5E3C, 0x005B6D44, 0x0056673C, 0x0052603C, 0x00394228,
        0x001C240D, 0x00505B3B, 0x005A693D, 0x004B5A45, 0x004E5E46, 0x00536344, 0x00546641, 0x00798B62, 0x0073855C, 0x006D7F56, 0x0073825C, 0x0073875D, 0x0073875D, 0x0073875D, 0x0073875D, 0x0073875D, 0x0074885E, 0x0074885E, 0x0074885E, 0x00758760,
        0x00758760, 0x0074865F, 0x0073855E, 0x0073855E, 0x0073855E, 0x0074865F, 0x0074865F, 0x0074865F, 0x0074865F, 0x00758760, 0x00758760, 0x00758760, 0x00758760, 0x0074865F, 0x0074865F, 0x0074865F, 0x00758760, 0x00758760, 0x0074865F, 0x0073855E,
        0x0072845D, 0x0073855E, 0x00758760, 0x007C8E67, 0x0071835A, 0x006A7C53, 0x0071835A, 0x007C8F64, 0x0074875C, 0x00798D60, 0x00778B5E, 0x0051693F, 0x005A6F4F, 0x0051604B, 0x004A5640, 0x00586446, 0x00677251, 0x004D5439, 0x00464835, 0x007D8868,
        0x004C5737, 0x00364022, 0x00434C31, 0x00455036, 0x00434D36, 0x0045523A, 0x0026321C, 0x004D6350, 0x004D5B43, 0x006E755A, 0x0077806C, 0x0070817D, 0x006D8388, 0x008EA4A9, 0x0077898A, 0x00768478, 0x006D805F, 0x0073815F, 0x00868A7E, 0x009B989A,
        0x008A8B89, 0x00898D87, 0x00858B8A, 0x00899198, 0x0096A0A0, 0x00A4ADAA, 0x00A7ACAD, 0x009DA0A5, 0x009EA19F, 0x00858C77, 0x007B8862, 0x00798B62, 0x007B8B69, 0x00768566, 0x00808E6C, 0x006A7854, 0xFF8A9476, 0xFFFFFFF8, 0xFFFEFCFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFAFB, 0xFFFBF9F9, 0x006E7C5A, 0x006B814D, 0x007F8E6F, 0x00778561, 0x003B4B15, 0x003E481D, 0x0039451B, 0x003A461C, 0x002F3B11, 0x00374319, 0x003E4A20,
        0x003A461C, 0x00344016, 0x00525E34, 0x006C7763, 0x00B0B8AD, 0x00969B99, 0x00D3D6DB, 0x00E8E9F3, 0x00DADCE4, 0x00DBDEE2, 0x00DDE2E1, 0x00E3E8E7, 0x00F2F8F3, 0x00A9B1A6, 0x00C8D1BD, 0x00B7C3A7, 0x00596443, 0x00818F66, 0x00728155, 0x00778A59,
        0x007D8F60, 0x00748559, 0x007F9065, 0x0077875E, 0x0075835F, 0x00657351, 0x007C8A68, 0x0076875B, 0x0076875B, 0x00768859, 0x00748657, 0x00748657, 0x00758857, 0x00758857, 0x00748756, 0x00748657, 0x00748657, 0x00748657, 0x00758758, 0x00758758,
        0x00768859, 0x00768859, 0x00768859, 0x00768656, 0x00768656, 0x00768656, 0x00768656, 0x00758555, 0x00758555, 0x00758555, 0x00758555, 0x00748756, 0x00738655, 0x00728554, 0x00728554, 0x00748756, 0x00748756, 0x00738655, 0x00728554, 0x00718354,
        0x00728455, 0x00728455, 0x00738556, 0x00738556, 0x00728455, 0x00728455, 0x00718354, 0x00748754, 0x00748754, 0x00758855, 0x00768958, 0x00768958, 0x00758758, 0x00758758, 0x00748657, 0x00758353, 0x00768657, 0x00718152, 0x00707F53, 0x00819267,
        0x0066774C, 0x006F8158, 0x006F8158, 0x006C7F4E, 0x0055693A, 0x00576A3F, 0x00556740, 0x00617250, 0x00778866, 0x00738861, 0x00758B61, 0x007B885C, 0x00626D4C, 0x005C654A, 0x005F6A4A, 0x005E6F44, 0x006F8251, 0x007A8D62, 0x00768664, 0x00758B61,
        0x006E835C, 0x00516640, 0x004F6340, 0x004F6142, 0x00586A4B, 0x00748669, 0x006E8063, 0x0079866C, 0x007A8A68, 0x0065774E, 0x004C5D38, 0x00526044, 0x00505D45, 0x00647353, 0x0073865B, 0x00798869, 0x0073845F, 0x0075855C, 0x005E6C48, 0x005F684D,
        0x005C654B, 0x005E6B45, 0x006F7E4B, 0x006F855B, 0x00687F53, 0x005F7545, 0x00788E5D, 0x00748859, 0x00718558, 0x00778960, 0x0075845E, 0x0072865B, 0x0072865B, 0x0072865B, 0x0073875C, 0x0073875C, 0x0073875C, 0x0073875C, 0x0074885D, 0x00758760,
        0x00758760, 0x0074865F, 0x0073855E, 0x0073855E, 0x0073855E, 0x0073855E, 0x0074865F, 0x0074865F, 0x0074865F, 0x00758760, 0x00758760, 0x00758760, 0x00758760, 0x0074865F, 0x0074865F, 0x00758760, 0x00758760, 0x00758760, 0x0074865F, 0x0072845D,
        0x0072845D, 0x0073855E, 0x00758760, 0x0074835D, 0x0075855C, 0x00798960, 0x0074855A, 0x007E8F64, 0x00728357, 0x007B8C60, 0x00768859, 0x006B8A53, 0x0060784E, 0x0067795A, 0x00728362, 0x0068784F, 0x00647143, 0x00535D33, 0x005C6342, 0x005C6544,
        0x00535F3B, 0x004C5834, 0x00515C3B, 0x00465234, 0x004A553B, 0x004F5C42, 0x0049573B, 0x004A6A57, 0x00495F46, 0x00677355, 0x00616A4F, 0x005C6854, 0x004A5A48, 0x0059654F, 0x0063684D, 0x005C685C, 0x00657454, 0x007B8665, 0x00919185, 0x009A9597,
        0x00878584, 0x00888A84, 0x00818383, 0x00959DA4, 0x00A1A9A9, 0x009BA4A1, 0x009CA1A2, 0x009C9FA4, 0x009B9E9C, 0x00818873, 0x0078855F, 0x007A8C63, 0x007C8C6A, 0x00758465, 0x00808E6C, 0x006B7955, 0xFF8A9476, 0xFFFFFFF8, 0xFFFEFCFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFBF8FF, 0xFBFCFFF4, 0x00727E5A, 0x00738354, 0x00808F63, 0x00717E58, 0x00536138, 0x004D5C30, 0x00495B34, 0x0044562F, 0x0043552E, 0x00465831, 0x00495B34,
        0x00485A33, 0x00495B34, 0x0053653E, 0x006F7A52, 0x007B865E, 0x0089946C, 0x00A5B088, 0x009FAA82, 0x0087926A, 0x0095A078, 0x00A0AB83, 0x00808B63, 0x0099A47C, 0x00B8C39B, 0x00B9C49C, 0x00A3AE86, 0x00667149, 0x0077825A, 0x007D8860, 0x007C8B5F,
        0x007C8B5F, 0x007C8B5F, 0x007B8A5E, 0x007B8A5E, 0x007B8A5E, 0x007B8A5E, 0x007A895D, 0x00788859, 0x00788859, 0x00788859, 0x00788858, 0x00788858, 0x00788858, 0x00788956, 0x00788956, 0x00758555, 0x00768656, 0x00778757, 0x00778757, 0x00778757,
        0x00778757, 0x00768656, 0x00758555, 0x00758458, 0x00788859, 0x00748455, 0x00728252, 0x00758555, 0x00758653, 0x00758752, 0x00758752, 0x00718151, 0x00798959, 0x00768656, 0x00708050, 0x00758555, 0x00778757, 0x00728252, 0x00738353, 0x00718152,
        0x00778758, 0x00778758, 0x00748455, 0x00788859, 0x00778758, 0x00708051, 0x00728253, 0x00728252, 0x00738353, 0x00748454, 0x00758556, 0x00768657, 0x00768559, 0x00768559, 0x00768559, 0x00768656, 0x00758555, 0x00758555, 0x00748454, 0x00748454,
        0x00758555, 0x00758555, 0x00768656, 0x00798A5E, 0x00798A5E, 0x0078895D, 0x0077885C, 0x0076875B, 0x0076875B, 0x0075865A, 0x0075865A, 0x00718459, 0x0072855A, 0x00788B60, 0x007C8C63, 0x0078885F, 0x0078865D, 0x0078855F, 0x0075825C, 0x006F8158,
        0x006A7C53, 0x0073855C, 0x007D8F66, 0x00798B62, 0x0075875E, 0x0075875E, 0x00708259, 0x0073835A, 0x00728259, 0x0075855C, 0x00778960, 0x0074865D, 0x0075895F, 0x00778B61, 0x006E8258, 0x006E8156, 0x00708358, 0x0072855A, 0x0074875C, 0x0075885D,
        0x0074875C, 0x0073865B, 0x0072855A, 0x0075885D, 0x0075885D, 0x0074875C, 0x0073865B, 0x0073865B, 0x0072855A, 0x00718459, 0x00718459, 0x0074875C, 0x0073865B, 0x0073865B, 0x0073865B, 0x0073865B, 0x0073865B, 0x0073865B, 0x0073865B, 0x0076895E,
        0x0076895E, 0x0074875C, 0x00718459, 0x0073865B, 0x0073865B, 0x006F8257, 0x0072855A, 0x00728358, 0x0075865B, 0x0078895E, 0x00738459, 0x006E7F54, 0x0078895E, 0x0076875C, 0x007A8B60, 0x0074895C, 0x0074895C, 0x0074885B, 0x0073865B, 0x0073855C,
        0x0074845B, 0x00778660, 0x007D8C66, 0x0073855C, 0x0074865D, 0x0075875E, 0x0076885F, 0x0075875E, 0x0074865D, 0x0072845B, 0x0071835A, 0x0076885F, 0x00778960, 0x00788A61, 0x00798B62, 0x00788A61, 0x0075875E, 0x0073855C, 0x0071835A, 0x00738462,
        0x00748563, 0x00768765, 0x00778A69, 0x00788B6A, 0x00738868, 0x006D8262, 0x00687D5D, 0x005E735D, 0x0060745D, 0x0072846D, 0x00506146, 0x0048563A, 0x003A4628, 0x004C5435, 0x004B5334, 0x00576345, 0x00707C60, 0x00848F75, 0x007D8672, 0x007D8475,
        0x00898E85, 0x008F938E, 0x007F8280, 0x00888D84, 0x0080867B, 0x008A9184, 0x00858D7C, 0x0079826D, 0x008D987E, 0x00818D6F, 0x007D896B, 0x00798D60, 0x00778962, 0x00798967, 0x007B8965, 0x006A7953, 0xFF889274, 0xFFFFFFF8, 0xFFFFFDFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFCFF, 0xFFFDFFF5, 0x006F7B57, 0x00708051, 0x00849367, 0x0083906A, 0x0078865D, 0x007D8C60, 0x00788A63, 0x00788A63, 0x007A8C65, 0x007B8D66, 0x00798B64,
        0x0074865F, 0x0073855E, 0x00778962, 0x00768159, 0x00747F57, 0x00707B53, 0x007D8860, 0x0079845C, 0x006F7A52, 0x007D8860, 0x007D8860, 0x00768159, 0x00737E56, 0x00727D55, 0x00737E56, 0x0079845C, 0x0068734B, 0x00818C64, 0x00818C64, 0x007A895D,
        0x007A895D, 0x007A895D, 0x0079885C, 0x0079885C, 0x0079885C, 0x0079885C, 0x0078875B, 0x0079895A, 0x0079895A, 0x00788859, 0x00778757, 0x00778757, 0x00768656, 0x00768754, 0x00758653, 0x00768656, 0x00768656, 0x00768656, 0x00778757, 0x00778757,
        0x00768656, 0x00768656, 0x00768656, 0x00718152, 0x00768657, 0x00778758, 0x00778757, 0x00768656, 0x00738451, 0x0070814E, 0x006D7E4B, 0x00778757, 0x00748454, 0x00758555, 0x00738353, 0x00738353, 0x00768656, 0x00738353, 0x00748454, 0x0079895A,
        0x00788859, 0x00738354, 0x006F7F50, 0x00738354, 0x00738354, 0x00738354, 0x007A8A5B, 0x00738353, 0x00738353, 0x00748454, 0x00768657, 0x00768657, 0x0077865A, 0x0077865A, 0x0077865A, 0x00768656, 0x00758555, 0x00758555, 0x00748454, 0x00748454,
        0x00758555, 0x00758555, 0x00768656, 0x0075865A, 0x00748559, 0x00748559, 0x00738458, 0x00738458, 0x00728357, 0x00728357, 0x00728357, 0x0076895E, 0x0073865B, 0x0073865B, 0x0076865D, 0x0074845B, 0x0075835A, 0x0073805A, 0x00717E58, 0x00788A61,
        0x0075875E, 0x0072845B, 0x0071835A, 0x0072845B, 0x0073855C, 0x0073855C, 0x0071835A, 0x0075855C, 0x00718158, 0x00728259, 0x0073855C, 0x0071835A, 0x0071855B, 0x0074885E, 0x006F8359, 0x00718459, 0x00718459, 0x0072855A, 0x0072855A, 0x0072855A,
        0x0073865B, 0x0073865B, 0x0073865B, 0x0074875C, 0x0074875C, 0x0073865B, 0x0073865B, 0x0072855A, 0x0072855A, 0x0072855A, 0x0072855A, 0x0073865B, 0x0073865B, 0x0073865B, 0x0073865B, 0x0073865B, 0x0073865B, 0x0073865B, 0x0073865B, 0x00778960,
        0x0074865D, 0x0072845B, 0x0072845B, 0x0074865D, 0x0072845B, 0x0072845B, 0x00778960, 0x0076865D, 0x0074845B, 0x0076865D, 0x0076865D, 0x00798960, 0x00798960, 0x0074845B, 0x00718158, 0x00708558, 0x0074885D, 0x0075885D, 0x0075885D, 0x0076885F,
        0x0076865D, 0x0073825C, 0x0074835D, 0x0074865D, 0x0075875E, 0x0075875E, 0x0076885F, 0x0075875E, 0x0074865D, 0x0073855C, 0x0072845B, 0x0073855C, 0x0074865D, 0x0075875E, 0x0076885F, 0x0076885F, 0x0075875E, 0x0074865D, 0x0074865D, 0x0074865F,
        0x00738560, 0x00748661, 0x00778964, 0x00768A67, 0x00758966, 0x00708564, 0x006D8261, 0x00677C63, 0x00697F63, 0x0076896E, 0x00607255, 0x00627152, 0x00606D4D, 0x00677251, 0x00636C4B, 0x00606E4C, 0x00798666, 0x007D896D, 0x0069735C, 0x005D6652,
        0x005F6659, 0x0080867B, 0x00747970, 0x00737A6D, 0x00575E4F, 0x0058604F, 0x005A634E, 0x00556046, 0x00758163, 0x007A8767, 0x007C8A68, 0x00798D60, 0x00778962, 0x00798967, 0x007B8965, 0x006A7953, 0xFF889274, 0xFFFFFFF8, 0xFFFFFDFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFCFF, 0xFBFCFFF4, 0x006F7B57, 0x006E7E4F, 0x007F8E62, 0x00808D67, 0x0079875E, 0x00808F63, 0x00798B62, 0x00798B62, 0x007A8C63, 0x00798B62, 0x0076885F,
        0x0076885F, 0x00798B62, 0x00788A61, 0x00838E66, 0x00869169, 0x007A855D, 0x007E8961, 0x00848F67, 0x00828D65, 0x0088936B, 0x00848F67, 0x00848F67, 0x00818C64, 0x007C875F, 0x007E8961, 0x00838E66, 0x007E8961, 0x0087926A, 0x007B865E, 0x007A895D,
        0x007A895D, 0x007A895D, 0x007A895D, 0x0079885C, 0x0079885C, 0x0079885C, 0x0079885C, 0x0079895A, 0x0079895A, 0x00788859, 0x00778757, 0x00768656, 0x00758555, 0x00748552, 0x00748552, 0x00778757, 0x00768656, 0x00768656, 0x00768656, 0x00768656,
        0x00768656, 0x00768656, 0x00778757, 0x00768657, 0x00788859, 0x00788859, 0x00768657, 0x00778757, 0x00788858, 0x00778757, 0x00788858, 0x007A8A5B, 0x00708051, 0x00738354, 0x00728253, 0x00718152, 0x00758556, 0x00738354, 0x00758556, 0x00768657,
        0x00748455, 0x00738354, 0x00758556, 0x007A8A5B, 0x00758556, 0x00738354, 0x00728253, 0x00738353, 0x00748454, 0x00758555, 0x00768657, 0x00778758, 0x0078875B, 0x0078875B, 0x0078875B, 0x00768656, 0x00768656, 0x00758555, 0x00758555, 0x00758555,
        0x00758555, 0x00768656, 0x00768656, 0x00728357, 0x00728357, 0x00728357, 0x00728357, 0x00718256, 0x00718256, 0x00718256, 0x00718256, 0x0074875C, 0x006F8257, 0x006B7E53, 0x00728259, 0x00718158, 0x0075835A, 0x0073805A, 0x0074815B, 0x006E8057,
        0x0075875E, 0x0075875E, 0x00708259, 0x00708259, 0x00708259, 0x0071835A, 0x0076885F, 0x0076845B, 0x00728259, 0x0074845B, 0x0075855C, 0x0071835A, 0x0071835A, 0x0072865C, 0x0074885E, 0x0074875C, 0x0072855A, 0x00718459, 0x00708358, 0x00708358,
        0x00718459, 0x0073865B, 0x0074875C, 0x0073865B, 0x0073865B, 0x0072855A, 0x0072855A, 0x0072855A, 0x0072855A, 0x0072855A, 0x0072855A, 0x0073865B, 0x0073865B, 0x0073865B, 0x0073865B, 0x0073865B, 0x0073865B, 0x0073865B, 0x0073865B, 0x0075875E,
        0x0074865D, 0x0073855C, 0x0076885F, 0x00778960, 0x0073855C, 0x0072845B, 0x0075875E, 0x0078885F, 0x0073835A, 0x00728259, 0x00728259, 0x00798960, 0x0073835A, 0x0078885F, 0x0075855C, 0x0073875D, 0x00768A60, 0x0072845B, 0x00708259, 0x00708259,
        0x0075855C, 0x0074845B, 0x0077875E, 0x0075875E, 0x0075875E, 0x0075875E, 0x0075875E, 0x0075875E, 0x0074865D, 0x0074865D, 0x0074865D, 0x0072845B, 0x0073855C, 0x0073855C, 0x0073855C, 0x0074865D, 0x0074865D, 0x0074865D, 0x0074865D, 0x0074875C,
        0x0074875C, 0x0073875D, 0x0074885E, 0x00748962, 0x00758A63, 0x00758A63, 0x00738A64, 0x00748969, 0x00758A69, 0x007C8F6E, 0x00738462, 0x00778765, 0x00818F6B, 0x00818E68, 0x007E8B65, 0x0076855F, 0x0085936F, 0x007F8D6B, 0x00717D5F, 0x006B765C,
        0x00636C57, 0x00868F7B, 0x006B7362, 0x0079826D, 0x00565F4A, 0x004E5841, 0x00556145, 0x00515E3E, 0x006F7D5B, 0x007B8965, 0x007E8D67, 0x00798D60, 0x00778962, 0x00798967, 0x007B8965, 0x006A7953, 0xFF889274, 0xFFFFFFF8, 0xFFFFFDFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFDFAFF, 0xFBFCFFF4, 0x00737F5B, 0x00738354, 0x00819064, 0x00808D67, 0x0078865D, 0x007D8C60, 0x007A8A61, 0x007A8A61, 0x00798960, 0x007A8A61, 0x0078885F,
        0x007D8D64, 0x007F8F66, 0x00708057, 0x00748056, 0x00828E64, 0x007B875D, 0x007B875D, 0x00849066, 0x00818D63, 0x00808C62, 0x00808C62, 0x00808C62, 0x00818D63, 0x00808C62, 0x007E8A60, 0x007A865C, 0x00758157, 0x007B875D, 0x007C885E, 0x007D8C60,
        0x007D8C60, 0x007C8B5F, 0x007C8B5F, 0x007C8B5F, 0x007C8B5F, 0x007B8A5E, 0x007B8A5E, 0x0079895A, 0x0079895A, 0x00788859, 0x00788858, 0x00778757, 0x00768656, 0x00758653, 0x00758653, 0x00778757, 0x00778757, 0x00768656, 0x00758555, 0x00758555,
        0x00768656, 0x00778757, 0x00778757, 0x00758555, 0x00738353, 0x00738354, 0x00748455, 0x0079895A, 0x0079895A, 0x00728253, 0x00758458, 0x00768559, 0x00728155, 0x0077865A, 0x00768559, 0x0078875B, 0x007B8A5E, 0x00758458, 0x00758458, 0x007A895D,
        0x0078875B, 0x0078875B, 0x0077865A, 0x007B8A5E, 0x0077865A, 0x007E8D61, 0x0079885C, 0x00748454, 0x00758555, 0x00768656, 0x00778758, 0x00788859, 0x0078875B, 0x0078875B, 0x0078875B, 0x00778757, 0x00768656, 0x00768656, 0x00758555, 0x00758555,
        0x00768656, 0x00768656, 0x00778757, 0x00738458, 0x00738458, 0x00738458, 0x00748559, 0x00748559, 0x00748559, 0x0075865A, 0x0075865A, 0x0076895E, 0x0075885D, 0x0075885D, 0x007D8D64, 0x0075855C, 0x007A885F, 0x007B8862, 0x007F8C66, 0x00798960,
        0x007D8D64, 0x007F8F66, 0x007E8E65, 0x007C8C63, 0x007A8A61, 0x007A8A61, 0x007A8A61, 0x007C8A61, 0x007B8960, 0x007C8A61, 0x0076865D, 0x0076865D, 0x0074865D, 0x00708259, 0x0075875E, 0x0074875C, 0x0073865B, 0x0072855A, 0x00708358, 0x00708358,
        0x00718459, 0x0072855A, 0x0073865B, 0x0072855A, 0x0072855A, 0x0072855A, 0x0072855A, 0x0072855A, 0x0072855A, 0x0073865B, 0x0073865B, 0x0073865B, 0x0073865B, 0x0073865B, 0x0074875C, 0x0074875C, 0x0074875C, 0x0074875C, 0x0074875C, 0x0074865D,
        0x00798B62, 0x0074865D, 0x0075875E, 0x007A8C63, 0x00788A61, 0x00778960, 0x0076885F, 0x00798B62, 0x00798B62, 0x00788A61, 0x0072845B, 0x0075875E, 0x006E8057, 0x00798B62, 0x00798B62, 0x0072855E, 0x00768962, 0x0074865F, 0x00768861, 0x00708259,
        0x0076865D, 0x0075855C, 0x00798960, 0x0076885F, 0x0076885F, 0x0075875E, 0x0075875E, 0x0075875E, 0x0075875E, 0x0075875E, 0x0075875E, 0x0076885F, 0x0075875E, 0x0074865D, 0x0073855C, 0x0072845B, 0x0072845B, 0x0072845B, 0x0072845B, 0x0074885B,
        0x0074885B, 0x0074885B, 0x0074885D, 0x00768A5F, 0x00758C60, 0x00768C62, 0x00778D63, 0x007B9069, 0x007A8F68, 0x007E916A, 0x007F916A, 0x007B8D66, 0x0083936A, 0x007E8C63, 0x00818F66, 0x0086976C, 0x00829368, 0x007C8B65, 0x0075835F, 0x00778464,
        0x006E7A5C, 0x008A957B, 0x00707B61, 0x00768468, 0x006B7A5B, 0x00687757, 0x006E7E5C, 0x00667752, 0x0074865F, 0x0076885F, 0x0076885F, 0x00798D60, 0x00778962, 0x00798967, 0x007B8965, 0x006A7953, 0xFF889274, 0xFFFFFFF8, 0xFFFFFDFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFCFF, 0xFBFCFFF4, 0x00727E5A, 0x00728253, 0x007E8D61, 0x007F8C66, 0x007C8A61, 0x00829165, 0x0077875E, 0x0077875E, 0x0077875E, 0x007C8C63, 0x007A8A61,
        0x007C8C63, 0x0073835A, 0x004D5D34, 0x003B471D, 0x00404C22, 0x00404C22, 0x00414D23, 0x003F4B21, 0x003F4B21, 0x00445026, 0x00404C22, 0x003F4B21, 0x003D491F, 0x00434F25, 0x00445026, 0x004B572D, 0x00404C22, 0x00404C22, 0x004D592F, 0x007C8B5F,
        0x007C8B5F, 0x007C8B5F, 0x007C8B5F, 0x007C8B5F, 0x007B8A5E, 0x007B8A5E, 0x007B8A5E, 0x0079895A, 0x0079895A, 0x00788859, 0x00788858, 0x00788858, 0x00788858, 0x00788956, 0x00788956, 0x00778757, 0x00778757, 0x00768656, 0x00758555, 0x00758555,
        0x00768656, 0x00778757, 0x00778757, 0x007C8C5C, 0x00798959, 0x00788858, 0x00788859, 0x007A895D, 0x00637246, 0x00404E24, 0x003D4B21, 0x003F4E22, 0x00425125, 0x003D4C20, 0x003A491D, 0x003F4E22, 0x00435226, 0x00425125, 0x00445327, 0x00455428,
        0x00445327, 0x00455428, 0x003E4D21, 0x003E4D21, 0x00445327, 0x006D7C50, 0x007A895D, 0x00748454, 0x00758555, 0x00768656, 0x00778758, 0x00788859, 0x0078875B, 0x0079885C, 0x0078875B, 0x00778757, 0x00778757, 0x00768656, 0x00768656, 0x00768656,
        0x00768656, 0x00778757, 0x00778757, 0x00748559, 0x0075865A, 0x0075865A, 0x0075865A, 0x0076875B, 0x0076875B, 0x0077885C, 0x0077885C, 0x0073865B, 0x0073865B, 0x0072855A, 0x006F7F56, 0x004C5C33, 0x004A582F, 0x00495630, 0x00495630, 0x004E5E35,
        0x0045552C, 0x0044542B, 0x00495930, 0x004B5B32, 0x004C5C33, 0x004B5B32, 0x0047572E, 0x004D5830, 0x004A582F, 0x0049572E, 0x0048562D, 0x005E6E45, 0x0076865D, 0x0072845B, 0x0075875E, 0x0073865B, 0x0073865B, 0x0073865B, 0x0072855A, 0x0072855A,
        0x0072855A, 0x0072855A, 0x0072855A, 0x0072855A, 0x0072855A, 0x0072855A, 0x0072855A, 0x0073865B, 0x0073865B, 0x0073865B, 0x0073865B, 0x0073865B, 0x0073865B, 0x0073865B, 0x0074875C, 0x0074875C, 0x0074875C, 0x0075885D, 0x0075885D, 0x0073855E,
        0x00768861, 0x005A6C45, 0x00495B34, 0x004D5F38, 0x004D5F38, 0x004D5F38, 0x004B5D36, 0x004A5C35, 0x004F613A, 0x0050623B, 0x004D5F38, 0x004A5C35, 0x00495B34, 0x004B5D36, 0x00495B34, 0x00425331, 0x00485A35, 0x005B6C47, 0x00778962, 0x0073855E,
        0x0078885F, 0x0074855A, 0x0077885D, 0x0075875E, 0x0075875E, 0x0075875E, 0x0075875E, 0x0075875E, 0x0075875E, 0x0076885F, 0x0076885F, 0x00778960, 0x0076885F, 0x0075875E, 0x0073855C, 0x0073855C, 0x0073855C, 0x0074865D, 0x0075875E, 0x0077895A,
        0x0077895A, 0x00768A5D, 0x00778B5E, 0x00768A5F, 0x00778B60, 0x00788C61, 0x00768D61, 0x0063764B, 0x0055683D, 0x0056693E, 0x005E7047, 0x005B6B42, 0x005C6C43, 0x0057673E, 0x005D6D44, 0x00627347, 0x005D6E42, 0x00637449, 0x00607047, 0x005D6B47,
        0x00586644, 0x006A7757, 0x00657252, 0x005D6D4B, 0x007D8D6B, 0x0083946F, 0x00859671, 0x007E9069, 0x0081936A, 0x007B8D64, 0x007E9166, 0x00798D60, 0x00778962, 0x00798967, 0x007B8965, 0x006A7953, 0xFF889274, 0xFFFFFFF8, 0xFFFFFDFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFCFF, 0xF7F9FDF1, 0x00707C58, 0x00708051, 0x007A895D, 0x007A8761, 0x0077855C, 0x007B8A5E, 0x007D8B61, 0x007C8A60, 0x0078865C, 0x007D8B61, 0x007B895F,
        0x00808E64, 0x00748258, 0x003F4D23, 0x0039461A, 0x00364317, 0x003E4B1F, 0x00435024, 0x00414E22, 0x004B582C, 0x00515E32, 0x00424F23, 0x00455226, 0x003B481C, 0x003E4B1F, 0x00323F13, 0x00455226, 0x00323F13, 0x00334014, 0x00505D31, 0x0079885C,
        0x0079885C, 0x0079885C, 0x0079885C, 0x0079885C, 0x0078875B, 0x0078875B, 0x0078875B, 0x00788859, 0x00788859, 0x00788859, 0x00788858, 0x00788858, 0x00788858, 0x00788956, 0x00788956, 0x00778757, 0x00768656, 0x00768656, 0x00768656, 0x00768656,
        0x00768656, 0x00768656, 0x00778757, 0x00748552, 0x00738451, 0x00748454, 0x00778758, 0x007E8D61, 0x005B693F, 0x002B3910, 0x0033401A, 0x002D3B11, 0x0036441A, 0x00334117, 0x003B491F, 0x003B491F, 0x00334117, 0x0037451B, 0x002F3D13, 0x00303E14,
        0x00313F15, 0x003D4B21, 0x003A481E, 0x00303E14, 0x002B390F, 0x00637147, 0x007B895F, 0x00748454, 0x00758555, 0x00768656, 0x00778758, 0x00788859, 0x0078875B, 0x0078875B, 0x0078875B, 0x00788858, 0x00778757, 0x00778757, 0x00768656, 0x00768656,
        0x00778757, 0x00778757, 0x00788858, 0x00748559, 0x00748559, 0x0075865A, 0x0075865A, 0x0075865A, 0x0076875B, 0x0076875B, 0x0076875B, 0x007A8D62, 0x00798C61, 0x00798C61, 0x006C7C53, 0x0033431A, 0x00313F16, 0x0035421C, 0x002E3B15, 0x0035431A,
        0x0039471E, 0x003D4B22, 0x003C4A21, 0x0037451C, 0x00334118, 0x00334118, 0x0035431A, 0x0037421A, 0x0037421A, 0x002B3910, 0x00233108, 0x004C5A31, 0x0078885F, 0x0077875E, 0x0074845B, 0x0072855A, 0x0073865B, 0x0074875C, 0x0074875C, 0x0074875C,
        0x0074875C, 0x0073865B, 0x0073865B, 0x0073865B, 0x0073865B, 0x0073865B, 0x0073865B, 0x0073865B, 0x0073865B, 0x0073865B, 0x0073865B, 0x0073865B, 0x0073865B, 0x0073865B, 0x0074875C, 0x0074875C, 0x0075885D, 0x0075885D, 0x0076895E, 0x00778962,
        0x0073855E, 0x003D4F28, 0x001F310A, 0x00293B14, 0x00293B14, 0x00293B14, 0x002D3F18, 0x002C3E17, 0x00293B14, 0x00253710, 0x002A3C15, 0x0024360F, 0x0031431C, 0x00263811, 0x002B3D16, 0x00253615, 0x001F300F, 0x003C4C2A, 0x0071825D, 0x0070825B,
        0x0076865D, 0x0075865B, 0x0077885C, 0x0074865D, 0x0074865D, 0x0074865D, 0x0075875E, 0x0075875E, 0x0075875E, 0x0075875E, 0x0075875E, 0x0074865D, 0x0074865D, 0x0074865D, 0x0074865D, 0x0075875E, 0x0076885F, 0x00778960, 0x00788A61, 0x0077885C,
        0x00798A5E, 0x007A8B5F, 0x00788B60, 0x00788B60, 0x00768A60, 0x00778B61, 0x00788C62, 0x004B5C30, 0x002B3C11, 0x002A3B10, 0x002C3C13, 0x00293910, 0x002C3B15, 0x0032401C, 0x0034421E, 0x00304115, 0x002F4015, 0x00304116, 0x00314118, 0x00293812,
        0x002C3A16, 0x002A3814, 0x00293715, 0x00374823, 0x0072835E, 0x007B8C67, 0x00788A63, 0x0074865F, 0x00758760, 0x0073855E, 0x00798B62, 0x00798D60, 0x00778962, 0x00798967, 0x007B8965, 0x006A7953, 0xFF889274, 0xFFFFFFF8, 0xFFFFFDFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFDFAFF, 0xF4F7FBEF, 0x00727E5A, 0x00758556, 0x00808F63, 0x00818E68, 0x007C8A61, 0x007D8C60, 0x007C8A60, 0x007C8A60, 0x0077855B, 0x007A885E, 0x0077855B,
        0x00808E64, 0x0079875D, 0x003E4C22, 0x0049562A, 0x005F6C40, 0x005A673B, 0x00525F33, 0x00667347, 0x006F7C50, 0x005F6C40, 0x0059663A, 0x00505D31, 0x004C592D, 0x005B683C, 0x00475428, 0x0069764A, 0x00445125, 0x00354216, 0x004D5A2E, 0x0079885C,
        0x0079885C, 0x0078875B, 0x0078875B, 0x0078875B, 0x0078875B, 0x0077865A, 0x0077865A, 0x00778758, 0x00778758, 0x00778758, 0x00778757, 0x00768656, 0x00768656, 0x00758653, 0x00758653, 0x00768656, 0x00768656, 0x00768656, 0x00778757, 0x00778757,
        0x00768656, 0x00768656, 0x00768656, 0x00778954, 0x00778855, 0x00738353, 0x00748455, 0x007F8D63, 0x0059673E, 0x002D3A14, 0x004C5834, 0x004C5A31, 0x004F5D34, 0x00536138, 0x00707E55, 0x00637148, 0x004B5930, 0x0057653C, 0x00435128, 0x00556339,
        0x0049572D, 0x0058663C, 0x00606E44, 0x00505E34, 0x00334117, 0x00606E44, 0x0076845A, 0x00748454, 0x00758555, 0x00768656, 0x00778758, 0x00788859, 0x0078875B, 0x0078875B, 0x0078875B, 0x00788858, 0x00788858, 0x00778757, 0x00778757, 0x00778757,
        0x00778757, 0x00788858, 0x00788858, 0x0075865A, 0x0075865A, 0x0075865A, 0x0076875B, 0x0076875B, 0x0076875B, 0x0076875B, 0x0076875B, 0x0073865B, 0x0072855A, 0x00788B60, 0x006F7F56, 0x0033431A, 0x00435128, 0x0056633D, 0x004D5A34, 0x0049572E,
        0x00637148, 0x00627047, 0x00515F36, 0x004F5D34, 0x004A582F, 0x00435128, 0x004B5930, 0x005D6840, 0x00667149, 0x00566139, 0x00344219, 0x00515F36, 0x007D8D64, 0x0077875E, 0x00708057, 0x0073865B, 0x0073865B, 0x0074875C, 0x0075885D, 0x0075885D,
        0x0075885D, 0x0075885D, 0x0075885D, 0x0075885D, 0x0075885D, 0x0075885D, 0x0074875C, 0x0074875C, 0x0073865B, 0x0073865B, 0x0073865B, 0x0073865B, 0x0073865B, 0x0073865B, 0x0074875C, 0x0075885D, 0x0075885D, 0x0076895E, 0x0076895E, 0x007B8C67,
        0x00788964, 0x003E4F2A, 0x002D3E19, 0x00495A35, 0x00455631, 0x0041522D, 0x004C5D38, 0x0060724D, 0x0050623D, 0x0042542F, 0x004A5C37, 0x0031431E, 0x0040522D, 0x00243611, 0x00384A25, 0x004A5A3B, 0x00273718, 0x00394828, 0x00778863, 0x0070825B,
        0x0075855C, 0x0076875C, 0x0076875B, 0x0072845B, 0x0073855C, 0x0074865D, 0x0075875E, 0x0076885F, 0x0075875E, 0x0075875E, 0x0074865D, 0x0073855C, 0x0073855C, 0x0073855C, 0x0074865D, 0x0075875E, 0x0076885F, 0x00778960, 0x00788A61, 0x007A885E,
        0x00798A5F, 0x007A8A61, 0x007A8A61, 0x00778962, 0x00778962, 0x00788A65, 0x007A8C67, 0x00546036, 0x00344218, 0x0045532A, 0x0047542E, 0x00475531, 0x004D5B39, 0x005F6F4D, 0x00576646, 0x00425229, 0x004D5D34, 0x0037471E, 0x00485731, 0x004C5B35,
        0x0062704C, 0x0055633F, 0x0044522E, 0x00334520, 0x0071835E, 0x00798B66, 0x00788A65, 0x00738560, 0x00748661, 0x00778964, 0x00788A65, 0x00798D60, 0x00778962, 0x00798967, 0x007B8965, 0x006A7953, 0xFF889274, 0xFFFFFFF8, 0xFFFFFDFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFCFF, 0xF7FAFEF2, 0x00727E5A, 0x00738354, 0x007D8C60, 0x007F8C66, 0x007B8960, 0x007C8B5F, 0x0078865C, 0x007D8B61, 0x007C8A60, 0x00808E64, 0x007A885E,
        0x00818F65, 0x0079875D, 0x003A481E, 0x00475428, 0x007D8A5E, 0x005D6A3E, 0x003A471B, 0x00657246, 0x00616E42, 0x00384519, 0x004A572B, 0x006E7B4F, 0x005D6A3E, 0x005E6B3F, 0x003D4A1E, 0x00707D51, 0x004C592D, 0x00374418, 0x0049562A, 0x007A895D,
        0x007A895D, 0x007A895D, 0x007A895D, 0x007A895D, 0x0079885C, 0x0079885C, 0x0079885C, 0x00778758, 0x00778758, 0x00768657, 0x00758555, 0x00748454, 0x00738353, 0x00738451, 0x00728350, 0x00758555, 0x00768656, 0x00778757, 0x00778757, 0x00778757,
        0x00778757, 0x00768656, 0x00758555, 0x00778954, 0x007A8B58, 0x00748454, 0x00738256, 0x00808E64, 0x0058653F, 0x00313D19, 0x00606C48, 0x0067754C, 0x00505E35, 0x00425027, 0x005E6C43, 0x00445229, 0x00324017, 0x005F6D44, 0x00536138, 0x00657349,
        0x00435127, 0x0049572D, 0x005E6C42, 0x0058663C, 0x0036441A, 0x00647248, 0x007B895F, 0x00748454, 0x00748454, 0x00758555, 0x00778758, 0x00778758, 0x0078875B, 0x0078875B, 0x0078875B, 0x00788858, 0x00788858, 0x00778757, 0x00778757, 0x00778757,
        0x00778757, 0x00788858, 0x00788858, 0x0078895D, 0x0078895D, 0x0078895D, 0x0078895D, 0x0078895D, 0x0078895D, 0x0078895D, 0x0078895D, 0x00778A5F, 0x0072855A, 0x00798C61, 0x00708057, 0x0034441B, 0x00505E35, 0x006C7953, 0x00606D47, 0x00414F26,
        0x00606E45, 0x004D5B32, 0x0037451C, 0x00505E35, 0x005C6A41, 0x00515F36, 0x0058663D, 0x00485129, 0x00626D45, 0x005F6A42, 0x0037421A, 0x004B5930, 0x007B8960, 0x00798960, 0x0077875E, 0x0073865B, 0x0074875C, 0x0074875C, 0x0075885D, 0x0075885D,
        0x0076895E, 0x00778A5F, 0x00778A5F, 0x0076895E, 0x0076895E, 0x0075885D, 0x0075885D, 0x0074875C, 0x0073865B, 0x0073865B, 0x0073865B, 0x0073865B, 0x0073865B, 0x0073865B, 0x0074875C, 0x0075885D, 0x0076895E, 0x0076895E, 0x0076895E, 0x0073845F,
        0x00748560, 0x0040512C, 0x0040512C, 0x00677853, 0x00576843, 0x00465732, 0x0053643F, 0x004D5F3A, 0x003F512C, 0x003F512C, 0x005A6C47, 0x0040522D, 0x00556742, 0x00374924, 0x005D6F4A, 0x005F6E52, 0x0029391A, 0x00334222, 0x00778765, 0x0070825B,
        0x0075855C, 0x0075865A, 0x00748559, 0x0071835A, 0x0072845B, 0x0074865D, 0x0075875E, 0x0076885F, 0x0075875E, 0x0074865D, 0x0073855C, 0x0075875E, 0x0074865D, 0x0074865D, 0x0074865D, 0x0074865D, 0x0074865D, 0x0074865D, 0x0074865D, 0x007A885F,
        0x007B8862, 0x00798862, 0x00798862, 0x00768762, 0x00788964, 0x007B8B69, 0x007D8E6C, 0x004F5B31, 0x00404B23, 0x0066744B, 0x0063704A, 0x005B6947, 0x00525F3F, 0x005E6D4E, 0x00455435, 0x0042512B, 0x0064734D, 0x0045542E, 0x00606F49, 0x0062704C,
        0x0073815D, 0x0055633F, 0x002C3A16, 0x00354722, 0x006D7F5A, 0x00768863, 0x007C8D6B, 0x00768765, 0x00778866, 0x007A8B69, 0x00738462, 0x00798D60, 0x00778962, 0x00798967, 0x007B8965, 0x006A7953, 0xFF889274, 0xFFFFFFF8, 0xFFFFFDFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFDFF, 0xF0F7F9ED, 0x006D7753, 0x00738354, 0x007C8B5F, 0x007A8A61, 0x007E8E65, 0x007D8E62, 0x00788D67, 0x00768A60, 0x00798A5E, 0x007F8F60, 0x007E8E5E,
        0x007A8C5D, 0x00768B5E, 0x00364D21, 0x004D582A, 0x007A8557, 0x005D683A, 0x00384315, 0x00697446, 0x00626D3F, 0x003A4517, 0x00384315, 0x005C6638, 0x00737D4F, 0x003C4618, 0x00353F11, 0x00646E40, 0x004D5729, 0x00323C0E, 0x004D5729, 0x00798B62,
        0x00758760, 0x00778660, 0x007A8963, 0x007A885E, 0x00798658, 0x007B8A57, 0x0080905B, 0x00768657, 0x00768657, 0x00768657, 0x00768657, 0x00768657, 0x00758556, 0x00748455, 0x00748455, 0x00738556, 0x00738556, 0x00748657, 0x00758758, 0x00758758,
        0x00768859, 0x00768859, 0x00768859, 0x006F8356, 0x00708358, 0x0075885D, 0x0071855B, 0x007B8F65, 0x00596C45, 0x002A3F19, 0x00566B45, 0x00677E51, 0x003A5124, 0x003A5124, 0x00647B4E, 0x003A5124, 0x00233A0D, 0x00374E21, 0x00667D50, 0x00445A30,
        0x00293E17, 0x004A5F39, 0x00516542, 0x00394E28, 0x002A3F18, 0x005E7548, 0x00758D5D, 0x00738A56, 0x00708656, 0x006F8158, 0x0071835C, 0x0075845E, 0x0076845A, 0x00758555, 0x00788B54, 0x00738655, 0x00738655, 0x00738655, 0x00738556, 0x00748657,
        0x00758758, 0x0075865A, 0x0076875B, 0x0077885C, 0x00798A5E, 0x007A8B5F, 0x00798A5E, 0x0078895D, 0x0076875B, 0x0077885C, 0x007A8B5F, 0x006E8160, 0x00778C66, 0x00798E67, 0x0070875B, 0x002E4518, 0x00485F32, 0x006B8255, 0x00465D31, 0x00364A1D,
        0x00627649, 0x004C6033, 0x00293D10, 0x00304417, 0x00627649, 0x00617548, 0x00384C1F, 0x0033451C, 0x0051633A, 0x00687B50, 0x002F4217, 0x004C5E35, 0x007F906B, 0x006F7E5E, 0x00778667, 0x0078895E, 0x007A8B60, 0x0077885D, 0x0077885D, 0x007B8C61,
        0x00798A5F, 0x0076875C, 0x0078895E, 0x00778960, 0x0076885F, 0x0075875E, 0x0074865D, 0x0074865D, 0x0074865D, 0x0075875E, 0x0075875E, 0x0079895A, 0x00738458, 0x00738459, 0x0074865D, 0x0074865F, 0x00738462, 0x00728564, 0x00738665, 0x0070855E,
        0x007C916B, 0x003A4E2B, 0x00354827, 0x00728663, 0x004C613B, 0x0022380E, 0x00536A3D, 0x00566E46, 0x002A421A, 0x00243C14, 0x00566E46, 0x00627A52, 0x002F471F, 0x00526A42, 0x005D754D, 0x00627250, 0x0023340F, 0x00364821, 0x0076885F, 0x00798B62,
        0x006D7E59, 0x00758464, 0x00748266, 0x00758760, 0x0074865F, 0x0073855E, 0x0072845D, 0x0073855E, 0x0073855E, 0x0073855E, 0x0073855E, 0x00758760, 0x00758760, 0x00768861, 0x00768861, 0x00778962, 0x00768861, 0x00768861, 0x00768861, 0x0078885F,
        0x00778660, 0x00788662, 0x00788866, 0x00788968, 0x00768765, 0x00768B65, 0x007B9069, 0x004F6334, 0x00344819, 0x00738758, 0x00627647, 0x00334718, 0x004D6132, 0x00708455, 0x00384C1D, 0x00354117, 0x00535F35, 0x007D895F, 0x004A562C, 0x004D592F,
        0x00626E44, 0x0068744A, 0x003F4B21, 0x002D4417, 0x006E845A, 0x00788C69, 0x00768869, 0x007D8F70, 0x00758966, 0x00768C62, 0x0072895C, 0x007A8D62, 0x007A8B66, 0x00788767, 0x007B8967, 0x006A7953, 0xFF869171, 0xFFFFFFF7, 0xFFFCFBFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFDFF, 0xECF6F8EC, 0x006C7652, 0x00728253, 0x007B8A5E, 0x00788761, 0x007B8B62, 0x00798A5E, 0x00748661, 0x0073855C, 0x00768657, 0x0073824F, 0x006C7A4A,
        0x00637246, 0x005E7049, 0x002B3C1B, 0x00324322, 0x004C5D3C, 0x004A5B3A, 0x00394A29, 0x00506140, 0x004F603F, 0x003C4D2C, 0x002D3E1D, 0x00344226, 0x0049573B, 0x002C3A1E, 0x00344226, 0x00566448, 0x00404E32, 0x0029371B, 0x00334125, 0x00647549,
        0x0064754A, 0x0067784D, 0x006D7B51, 0x00728155, 0x00768355, 0x00758353, 0x0073824F, 0x00758556, 0x00758556, 0x00768657, 0x00768657, 0x00768657, 0x00768657, 0x00758556, 0x00758556, 0x00738556, 0x00738556, 0x00738556, 0x00738556, 0x00738556,
        0x00738556, 0x00728455, 0x00728455, 0x00768956, 0x006D804F, 0x00697D50, 0x005F7148, 0x0063744F, 0x00475837, 0x00213014, 0x00435236, 0x0049583C, 0x003F4E32, 0x00354428, 0x004D5C40, 0x003E4D31, 0x002A391D, 0x00243317, 0x004A593D, 0x002A3A1B,
        0x00334226, 0x00556448, 0x00455438, 0x002B3B1C, 0x00213210, 0x004E6238, 0x0063784B, 0x00647B44, 0x00667C48, 0x006B7F52, 0x00708057, 0x00718158, 0x00717F55, 0x00718151, 0x00728350, 0x00728554, 0x00728554, 0x00728554, 0x00738556, 0x00738556,
        0x00748559, 0x0075865A, 0x0075865A, 0x00748559, 0x0075865A, 0x0076875B, 0x0076875B, 0x0076875B, 0x0075865A, 0x00748559, 0x00738458, 0x0073875C, 0x0070845A, 0x006B7E57, 0x00637550, 0x002D3E1C, 0x00415230, 0x005D6E4C, 0x00495A38, 0x00374529,
        0x00566448, 0x004B593D, 0x00313F23, 0x00253317, 0x00404E32, 0x00435135, 0x00273519, 0x004F5E3E, 0x00546343, 0x00556444, 0x00253414, 0x00425230, 0x0072835E, 0x006C7E57, 0x00778960, 0x0075855C, 0x0078885F, 0x0076865D, 0x0076865D, 0x007A8A61,
        0x0078885F, 0x0074845B, 0x0077875E, 0x0076885F, 0x0076885F, 0x0075875E, 0x0074865D, 0x0074865D, 0x0074865D, 0x0074865D, 0x0074865D, 0x0077885C, 0x0075865A, 0x0075865B, 0x0075885D, 0x0076885F, 0x0073875D, 0x0070835C, 0x006E815A, 0x0070835C,
        0x006E7F5D, 0x00354526, 0x00324125, 0x00657459, 0x00556448, 0x00384928, 0x0050613F, 0x00495B3E, 0x002E4023, 0x001C2E11, 0x003A4C2F, 0x004C5E41, 0x00283A1D, 0x004A5C3F, 0x0057694C, 0x005F6C54, 0x002B391D, 0x00354424, 0x00697B54, 0x0076885F,
        0x0072845B, 0x00768861, 0x0071825D, 0x0072845D, 0x0072845D, 0x0072845D, 0x0072845D, 0x0073855E, 0x0073855E, 0x0073855E, 0x0073855E, 0x0074865F, 0x00758760, 0x00758760, 0x00768861, 0x00768861, 0x00768861, 0x00758760, 0x00758760, 0x00788761,
        0x00778660, 0x00768460, 0x00768762, 0x00758760, 0x0072865C, 0x0074885D, 0x00788C61, 0x00445333, 0x00303F1F, 0x00627151, 0x005A6949, 0x00425131, 0x004C5B3B, 0x005C6B4B, 0x00364525, 0x002F3B1D, 0x003C482A, 0x005C684A, 0x00354123, 0x003F4B2D,
        0x00546042, 0x005F6B4D, 0x00434F31, 0x0034481E, 0x006D8157, 0x00788A65, 0x00758664, 0x00798A68, 0x00748661, 0x00798D63, 0x00798D63, 0x00788B60, 0x00788964, 0x00778666, 0x007B8967, 0x006B7A54, 0xFF879272, 0xFFFFFFF7, 0xFFFEFDFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFBFF, 0xECF6F8EC, 0x006C7652, 0x00728253, 0x0079875D, 0x0075845E, 0x0076855F, 0x0074855A, 0x006C7D58, 0x006D7D54, 0x006B7949, 0x005C6935, 0x004F5B2B,
        0x00414C24, 0x003B472B, 0x0018230F, 0x00122514, 0x00172A19, 0x001F3221, 0x001A2D1C, 0x001B2E1D, 0x001D301F, 0x001D301F, 0x00102312, 0x0016261B, 0x001D2D22, 0x000F1F14, 0x0018281D, 0x0026362B, 0x001A2A1F, 0x0015251A, 0x0016261B, 0x00415121,
        0x00465626, 0x004C5C2C, 0x00546434, 0x00617142, 0x006C7C4D, 0x00738052, 0x00748153, 0x00748455, 0x00748455, 0x00758556, 0x00768657, 0x00768657, 0x00768657, 0x00768657, 0x00768657, 0x00738556, 0x00738556, 0x00728455, 0x00728455, 0x00718354,
        0x006F8152, 0x006E8051, 0x006D7F50, 0x00677A41, 0x00546730, 0x004E5E2E, 0x00425229, 0x00404D2D, 0x002D3A22, 0x00121C0B, 0x00212A1D, 0x00192019, 0x00282F28, 0x001C231C, 0x00252C25, 0x00282F28, 0x00232A23, 0x000F160F, 0x00222922, 0x00131D0D,
        0x001C2616, 0x002E3828, 0x00242E1D, 0x001F2B15, 0x00132105, 0x002E3E1C, 0x00455730, 0x00455B20, 0x004F652B, 0x005F723F, 0x006A7C4D, 0x006E7F53, 0x00728155, 0x00748357, 0x00758556, 0x00718453, 0x00718453, 0x00718354, 0x00728455, 0x00728357,
        0x00738458, 0x00738458, 0x0074855A, 0x00748559, 0x00738458, 0x00728357, 0x00738458, 0x00728357, 0x00708155, 0x006B7C50, 0x00647549, 0x00536A33, 0x00495D2E, 0x0042532E, 0x00414E34, 0x001C2713, 0x00222C1B, 0x00293420, 0x0024301A, 0x002A322B,
        0x00353D36, 0x00363E37, 0x002F3730, 0x001B231C, 0x00212922, 0x00272F28, 0x001B231C, 0x002E3A26, 0x002A3624, 0x00273222, 0x00111D0B, 0x002A3820, 0x004A5B39, 0x004C6232, 0x00566E38, 0x00697950, 0x006F7F56, 0x00708057, 0x00718158, 0x0076865D,
        0x0076865D, 0x0073835A, 0x0076865D, 0x0075875E, 0x0075875E, 0x0075875E, 0x0075875E, 0x0074865D, 0x0073855C, 0x0072845B, 0x0072845B, 0x0075855C, 0x0074855A, 0x00728358, 0x00708155, 0x006C8053, 0x00637748, 0x00576B3C, 0x00506435, 0x004B5B39,
        0x00435233, 0x00212E16, 0x0018230F, 0x002C3626, 0x002B3525, 0x00242E1E, 0x002A3423, 0x003A4535, 0x00364131, 0x001E2919, 0x001F2A1A, 0x002C3727, 0x000C1707, 0x00192414, 0x001C2717, 0x002D362C, 0x00182313, 0x0025331B, 0x00495A38, 0x00586C42,
        0x005A6F42, 0x00627848, 0x00697F4F, 0x006E8059, 0x006F815A, 0x0071835C, 0x0072845D, 0x0072845D, 0x0072845D, 0x0072845D, 0x0072845D, 0x0074865F, 0x0074865F, 0x00758760, 0x00758760, 0x00758760, 0x00758760, 0x0074865F, 0x0074865F, 0x0075835F,
        0x00717F5B, 0x006C7B55, 0x0066774C, 0x005C6D41, 0x00526637, 0x004F6433, 0x004E6332, 0x00313D2B, 0x001E2A18, 0x00323E2C, 0x002D3927, 0x00333F2D, 0x00394533, 0x00465240, 0x0044503E, 0x0025341F, 0x0022311C, 0x00374631, 0x0022311C, 0x002E3D28,
        0x00394833, 0x003E4D38, 0x002C3B26, 0x00253611, 0x004E6039, 0x005C6E45, 0x00607348, 0x00697C51, 0x006E8057, 0x00768861, 0x00758661, 0x0074875C, 0x00758661, 0x00768565, 0x007C8A68, 0x006C7B55, 0xFF879272, 0xFFFFFFF7, 0xFFFFFEFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFBFF, 0xF0F6F7ED, 0x006D7655, 0x00728155, 0x0079875D, 0x0074835D, 0x0074835D, 0x00708156, 0x00748260, 0x00717F56, 0x006A7646, 0x00515C2A, 0x00444E20,
        0x00363D1C, 0x002F3522, 0x001B2017, 0x00142216, 0x00152317, 0x00142216, 0x00111F13, 0x00132115, 0x00101E12, 0x00101E12, 0x00132115, 0x00111A17, 0x00121B18, 0x000D1613, 0x00151E1B, 0x0017201D, 0x00121B18, 0x00161F1C, 0x00161F1C, 0x00313F0F,
        0x00394815, 0x0041501D, 0x004D5C29, 0x005E6D3A, 0x00687849, 0x006F7E52, 0x00758359, 0x00738256, 0x00738256, 0x00748357, 0x00768559, 0x0077865A, 0x0077865A, 0x0077865A, 0x0077865A, 0x00748559, 0x00748559, 0x00738458, 0x00728357, 0x00708155,
        0x006D7E52, 0x006A7B4F, 0x00697A4E, 0x0066783B, 0x004D5E25, 0x00414F1F, 0x0033401A, 0x002B341A, 0x0022291A, 0x00141812, 0x00151816, 0x00111210, 0x00191A18, 0x00141513, 0x00191A18, 0x00171816, 0x0020211F, 0x00171816, 0x00171816, 0x001B1F1A,
        0x00131712, 0x00151914, 0x0013180F, 0x001E2518, 0x00141D08, 0x001F2B0F, 0x002E3C1A, 0x00374C0E, 0x0043561D, 0x00586B34, 0x00687946, 0x006B7B4C, 0x006B7C50, 0x006E7F54, 0x006D7E53, 0x00708253, 0x00708253, 0x00718354, 0x00728357, 0x00728357,
        0x00728357, 0x00728358, 0x00728358, 0x0077885D, 0x00728358, 0x00718257, 0x00708156, 0x006E7F54, 0x006B7C51, 0x00617247, 0x00536439, 0x00435A1C, 0x00374A17, 0x002B3917, 0x00293120, 0x00161A14, 0x00171B16, 0x0011150F, 0x00151B10, 0x00141B18,
        0x00111815, 0x00131A17, 0x001A211E, 0x00141B18, 0x00111815, 0x00131A17, 0x00121916, 0x000F180E, 0x00101811, 0x00141B16, 0x00101811, 0x001D2917, 0x002F401F, 0x00374D1C, 0x00425D1E, 0x00596940, 0x0063734A, 0x0068784F, 0x006B7B52, 0x00718158,
        0x0074845B, 0x0074845B, 0x0077875E, 0x0074865D, 0x0075875E, 0x0075875E, 0x0075875E, 0x0074865D, 0x0073855C, 0x0071835A, 0x00708259, 0x006E8059, 0x006F8158, 0x006D7E53, 0x00697A4E, 0x00637546, 0x00536633, 0x003F531E, 0x00364813, 0x00323E20,
        0x002B361C, 0x001E2713, 0x0013190E, 0x000F130D, 0x00121611, 0x00161A15, 0x00161A15, 0x00121610, 0x001E221C, 0x00141812, 0x00141812, 0x00232721, 0x00121610, 0x00181C16, 0x00141812, 0x0012171A, 0x00121914, 0x001C2717, 0x002E3D21, 0x003A4E24,
        0x00405626, 0x00526935, 0x0069814B, 0x006A7C55, 0x006C7E57, 0x006F815A, 0x0072845D, 0x0072845D, 0x0072845D, 0x0072845D, 0x0072845D, 0x0073855E, 0x0073855E, 0x0074865F, 0x0074865F, 0x0074865F, 0x0073855E, 0x0073855E, 0x0072845D, 0x00717F5D,
        0x006B7955, 0x0065764B, 0x005A6C3D, 0x004C5D2A, 0x0040511E, 0x003C4D1A, 0x00384916, 0x001F291C, 0x00121C0F, 0x00151F12, 0x000F190C, 0x001C2619, 0x00162013, 0x00151F12, 0x001F291C, 0x00192917, 0x0010200E, 0x001D2D1B, 0x00132311, 0x001B2B19,
        0x001D2D1B, 0x001C2C1A, 0x00122210, 0x00222F0F, 0x00364420, 0x00425328, 0x004D5F30, 0x00607243, 0x006E7F54, 0x0073815D, 0x006E7B5B, 0x0074875C, 0x00748560, 0x00768565, 0x007D8B69, 0x006D7C56, 0xFF869171, 0xFFFFFFF7, 0xFFFFFEFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFBFF, 0xF0F7F8EE, 0x006E7756, 0x00748357, 0x007B8960, 0x0074825E, 0x0074825E, 0x00708057, 0x0075805F, 0x006A724D, 0x005F673E, 0x00484C22, 0x003E411A,
        0x002F3218, 0x00282919, 0x001B1E15, 0x00232616, 0x00232616, 0x00202313, 0x00242717, 0x00272A1A, 0x00222515, 0x001D2010, 0x00242717, 0x0026251B, 0x0027261C, 0x00242319, 0x0025241A, 0x00232218, 0x001E1D13, 0x00222117, 0x00242319, 0x00323A11,
        0x00353E13, 0x00384414, 0x00475722, 0x005F6E3B, 0x00687848, 0x006A784E, 0x006F7E58, 0x00728155, 0x00738256, 0x00748357, 0x00768559, 0x0077865A, 0x0077865A, 0x0078875B, 0x0078875B, 0x0076875B, 0x0076875B, 0x0075865A, 0x00738458, 0x00708155,
        0x006D7E52, 0x006A7B4F, 0x0068794D, 0x00606D37, 0x00495422, 0x00374117, 0x002B3211, 0x00202510, 0x00202216, 0x001E1D19, 0x00191919, 0x00222018, 0x001D1B13, 0x001C1A12, 0x00222018, 0x0018160E, 0x001D1B13, 0x001E1C14, 0x001E1C14, 0x001D1C18,
        0x001D1C18, 0x001F1E1A, 0x00161511, 0x001A1B12, 0x001C1F0F, 0x00252B14, 0x00242B10, 0x00394612, 0x00404D19, 0x0053632E, 0x00677643, 0x00697949, 0x006A7B4F, 0x006D7E53, 0x006A7C53, 0x006F8152, 0x00708253, 0x00718256, 0x00728357, 0x00738458,
        0x00738459, 0x00728358, 0x00728358, 0x0077885D, 0x00718257, 0x006F8055, 0x006F8055, 0x006C7D52, 0x00697A4F, 0x005D6E43, 0x004A5B30, 0x003C4D14, 0x00334012, 0x00242C0E, 0x001D1F13, 0x00181615, 0x001D1B1B, 0x00191716, 0x0021211B, 0x00191E15,
        0x00141910, 0x0013180F, 0x00161B12, 0x001D2219, 0x00181D14, 0x0013180F, 0x00191E15, 0x00171B15, 0x001C201B, 0x00191B1B, 0x00161917, 0x00161D10, 0x00212D0F, 0x002D3F10, 0x00384E14, 0x0052613B, 0x00606F49, 0x00687751, 0x006B7A54, 0x0071805A,
        0x0075845E, 0x0075845E, 0x00778660, 0x0073855C, 0x0074865D, 0x0074865D, 0x0074865D, 0x0074865D, 0x0073855C, 0x0071835A, 0x00708259, 0x006B7D56, 0x006E8059, 0x006B7D54, 0x006A7B50, 0x00657546, 0x00506030, 0x003C4B18, 0x00364611, 0x00293015,
        0x00222811, 0x001E2112, 0x001A1B12, 0x00191716, 0x001C1A1A, 0x001C1A1A, 0x001A1817, 0x00161511, 0x001B1A16, 0x00181713, 0x00161511, 0x001D1C18, 0x00171612, 0x001F1E1A, 0x00191814, 0x0016161C, 0x00141616, 0x00131A0D, 0x001C270D, 0x002B3915,
        0x0037481C, 0x004C5F2E, 0x00697C49, 0x00677952, 0x006B7D56, 0x006F815A, 0x0072845D, 0x0072845D, 0x0071835C, 0x0072845D, 0x0072845D, 0x0073855E, 0x0073855E, 0x0074865F, 0x0074865F, 0x0073855E, 0x0073855E, 0x0072845D, 0x0071835C, 0x00738060,
        0x006D7C56, 0x0067784C, 0x005A6B38, 0x00465621, 0x003B4A17, 0x003B4717, 0x00374214, 0x00222B16, 0x001F2813, 0x00222B16, 0x001E2712, 0x0027301B, 0x001E2712, 0x0018210C, 0x001E2712, 0x001C2D12, 0x0017280D, 0x001D2E13, 0x0017280D, 0x00192A0F,
        0x001C2D12, 0x001F3015, 0x001C2D12, 0x002B3315, 0x002F3817, 0x0038431B, 0x00445125, 0x0059663A, 0x006E7951, 0x00747D5C, 0x00788062, 0x0075885D, 0x00758661, 0x00778666, 0x007E8C6A, 0x006C7B55, 0xFF848F6F, 0xFFFFFFF7, 0xFFFFFEFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFBFF, 0xF4F7F8EF, 0x006E7657, 0x00748258, 0x007C8A61, 0x00768460, 0x00768460, 0x00728259, 0x00797F60, 0x00686D4D, 0x006C6D4D, 0x005F5D3F, 0x00605D41,
        0x005E5B46, 0x00575745, 0x00555547, 0x0064614C, 0x005D5A45, 0x005C5944, 0x00625F4A, 0x005B5843, 0x005C5944, 0x005C5944, 0x005C5944, 0x005B5542, 0x00605A47, 0x005E5845, 0x005D5744, 0x005C5643, 0x0058523F, 0x0058523F, 0x005D5744, 0x0053543A,
        0x004C4F2F, 0x003D451C, 0x00424E1E, 0x005A6936, 0x00687848, 0x0068794E, 0x006C7B55, 0x00728056, 0x00738157, 0x00748258, 0x0076845A, 0x0077855B, 0x0077855B, 0x0077855B, 0x0077855B, 0x0076875C, 0x0076875C, 0x0076875C, 0x0074855A, 0x00718257,
        0x006E7F54, 0x006A7B50, 0x0068794E, 0x00626740, 0x005D613D, 0x0057593B, 0x0055583E, 0x00535440, 0x00525244, 0x0057564C, 0x0054524A, 0x00595745, 0x00565442, 0x0053513F, 0x00585644, 0x00565442, 0x0052503E, 0x00504E3C, 0x005A5846, 0x00515143,
        0x004E4E42, 0x00525147, 0x00504E46, 0x004C4B41, 0x0049493B, 0x004D4F3B, 0x004B4E38, 0x004A4E2A, 0x00424A21, 0x00515B30, 0x00667444, 0x006B7B4B, 0x006C7D51, 0x006F8257, 0x006F8158, 0x00708253, 0x00708155, 0x00728357, 0x00738458, 0x0074855A,
        0x0074855A, 0x0073835A, 0x00728259, 0x0075855C, 0x006E7E55, 0x006E7E55, 0x006E7E55, 0x006C7C53, 0x006B7B52, 0x00607047, 0x00495930, 0x003E481E, 0x00424926, 0x003F432A, 0x00404032, 0x00413E39, 0x0044413C, 0x00403D38, 0x003B3931, 0x00414532,
        0x00404431, 0x003F4330, 0x00383C29, 0x00414532, 0x003D412E, 0x00393D2A, 0x00424633, 0x003A3B31, 0x00414239, 0x003E3E38, 0x003D3E35, 0x003C3F30, 0x0041472E, 0x00404A26, 0x00424F23, 0x0054633D, 0x0064734D, 0x006E7D57, 0x006F7E58, 0x0073825C,
        0x0076855F, 0x0075845E, 0x00778660, 0x0073855C, 0x0073855C, 0x0074865D, 0x0074865D, 0x0073855C, 0x0073855C, 0x0072845B, 0x0072845B, 0x006E815A, 0x006F825B, 0x006D7F56, 0x006C7C53, 0x00657349, 0x004E5A30, 0x003E481D, 0x00444D22, 0x00383C23,
        0x00383A26, 0x003C3C2E, 0x003A3830, 0x003B3833, 0x003B3833, 0x0036332E, 0x0039372F, 0x00424036, 0x003D3B31, 0x003D3B31, 0x003C3A30, 0x003A382E, 0x0038362C, 0x003E3C32, 0x0037352B, 0x00323030, 0x0032312D, 0x00343728, 0x00383E27, 0x003D4526,
        0x00414B27, 0x004F5A34, 0x00626D47, 0x00677952, 0x006B7D56, 0x0070825B, 0x0072845D, 0x0072845D, 0x0071835C, 0x0072845D, 0x0073855E, 0x0073855E, 0x0074865F, 0x0074865F, 0x0074865F, 0x0073855E, 0x0072845D, 0x0071835C, 0x0071835C, 0x0073815F,
        0x006D7D54, 0x0069794A, 0x00596835, 0x00434F1D, 0x003E481A, 0x00474B27, 0x00464929, 0x003F462B, 0x003E452A, 0x003E452A, 0x00394025, 0x003D4429, 0x003C4328, 0x003D4429, 0x003D4429, 0x003A4426, 0x003C4628, 0x003F492B, 0x003F492B, 0x003C4628,
        0x003F492B, 0x00404A2C, 0x00414B2D, 0x00454A2F, 0x00414629, 0x00474D2E, 0x0049502F, 0x00565D3C, 0x00666C4D, 0x006D7255, 0x007E8368, 0x00778A5F, 0x00768762, 0x00778666, 0x007E8C6A, 0x006B7A54, 0xFF828D6D, 0xFFFDFFF5, 0xFFFFFEFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFAFF, 0xF0F6F7EE, 0x006D7556, 0x00748258, 0x007B8960, 0x00778563, 0x00778561, 0x0074845B, 0x006F7455, 0x005F6046, 0x00726D58, 0x006E6655, 0x00736B5A,
        0x0077715E, 0x0072725A, 0x0072755B, 0x006E6A57, 0x006C6855, 0x006A6653, 0x006C6855, 0x005E5A47, 0x00635F4C, 0x00635F4C, 0x00625E4B, 0x0066614C, 0x006C6752, 0x00746F5A, 0x0077725D, 0x0078735E, 0x0075705B, 0x00716C57, 0x00716C57, 0x00797066,
        0x0074705D, 0x005C5F3F, 0x004C552A, 0x005A6936, 0x006B7B4B, 0x006D7E53, 0x006C7E57, 0x00738157, 0x00748258, 0x00758359, 0x0076845A, 0x0077855B, 0x0077855B, 0x0077855B, 0x0077855B, 0x0075865B, 0x0075865B, 0x0075865B, 0x0074855A, 0x00728358,
        0x006E7F54, 0x006B7C51, 0x0068794E, 0x00625F4A, 0x006D6956, 0x006C6855, 0x006F6E5A, 0x0071705C, 0x00686955, 0x006E6E5C, 0x00727260, 0x00615D4A, 0x00615D4A, 0x005E5A47, 0x00605C49, 0x00625E4B, 0x005E5A47, 0x005C5845, 0x00615D4A, 0x0061644A,
        0x0061634D, 0x00656553, 0x006A695B, 0x006D6C5E, 0x006B6A5C, 0x006E6E5C, 0x00747561, 0x006A6752, 0x0054553B, 0x00565C39, 0x006B754B, 0x006D7D4E, 0x006B7D4E, 0x006B7E53, 0x006A7E54, 0x00708155, 0x00718256, 0x00738458, 0x0075865B, 0x0075865B,
        0x0075855C, 0x0074845B, 0x0073835A, 0x0075855C, 0x006E7E55, 0x006F7F56, 0x00708057, 0x006C7C53, 0x006E7E55, 0x0063734A, 0x004B5B32, 0x0060624C, 0x00686A54, 0x00686955, 0x0070705E, 0x006E6E5E, 0x006E6E5E, 0x00747464, 0x00686858, 0x00666551,
        0x0061604C, 0x00666551, 0x005A5945, 0x005E5D49, 0x005F5E4A, 0x00605F4B, 0x00656450, 0x00656351, 0x006E6C5A, 0x006B6957, 0x006F6D5B, 0x00706F5B, 0x0074735E, 0x006A6A52, 0x006F7056, 0x0053613D, 0x00667450, 0x00707E5A, 0x00717F5B, 0x0074825E,
        0x00768460, 0x0075835F, 0x00768460, 0x0073855C, 0x0073855C, 0x0073855C, 0x0073855C, 0x0073855C, 0x0074865D, 0x0074865D, 0x0075875E, 0x006F855B, 0x0071855B, 0x006C7E57, 0x006C7B55, 0x0066704C, 0x004E5534, 0x00464B2B, 0x00595C3C, 0x0062644E,
        0x00656652, 0x006A6A5A, 0x00666459, 0x0069675C, 0x006B6A5C, 0x00616151, 0x00626250, 0x00666452, 0x00605E4C, 0x00646250, 0x00646250, 0x0063614F, 0x00666452, 0x00676553, 0x00646250, 0x0068635A, 0x00686557, 0x006C6A58, 0x006B6B53, 0x0064654B,
        0x0063644A, 0x0063634B, 0x005F5E49, 0x00687A53, 0x006C7E57, 0x0071835C, 0x0072845D, 0x0072845D, 0x0071835C, 0x0073855E, 0x00758760, 0x0074865F, 0x0074865F, 0x0074865F, 0x0074865F, 0x0073855E, 0x0072845D, 0x0071835C, 0x0070825B, 0x006D7E59,
        0x006A7B50, 0x00687848, 0x005A6936, 0x00485223, 0x004F532F, 0x0065644A, 0x006D6655, 0x006D6E54, 0x006D6E54, 0x00696A50, 0x0067684E, 0x0066674D, 0x00616248, 0x00595A40, 0x00525339, 0x0059573F, 0x005C5A42, 0x005B5941, 0x00626048, 0x005E5C44,
        0x005F5D45, 0x005E5C44, 0x00626048, 0x00676A50, 0x0060634A, 0x0063654F, 0x005D5E4A, 0x0061624E, 0x00656751, 0x0060634A, 0x0076795F, 0x00778A5F, 0x00758661, 0x00768565, 0x007E8C6A, 0x006A7953, 0xFF808B6B, 0xFFFDFFF5, 0xFFFFFEFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFF8FF, 0xF0F5F6ED, 0x006C7455, 0x00738157, 0x007B8862, 0x00778563, 0x00788662, 0x0076855F, 0x00757A5B, 0x00636149, 0x00746D5E, 0x00695D53, 0x005E5248,
        0x00534C3B, 0x00454428, 0x003F4522, 0x004F5040, 0x005F6050, 0x005F6050, 0x00606151, 0x00575848, 0x00575848, 0x004D4E3E, 0x00505141, 0x0061624E, 0x005C5D49, 0x005A5B47, 0x00535440, 0x004B4C38, 0x004C4D39, 0x004D4E3A, 0x004D4E3A, 0x00625656,
        0x00736A60, 0x0065664C, 0x00515930, 0x005A6838, 0x006E7E4E, 0x00728357, 0x00708259, 0x00738157, 0x00748258, 0x00758359, 0x0076845A, 0x0076845A, 0x0077855B, 0x0076845A, 0x0076845A, 0x00738459, 0x0074855A, 0x0074855A, 0x0074855A, 0x00728358,
        0x006E7F54, 0x006B7C51, 0x0068794E, 0x00655C53, 0x0072695F, 0x00635D50, 0x005D5849, 0x00565541, 0x00484732, 0x004D5036, 0x00595C42, 0x00686150, 0x00625B4A, 0x00635C4B, 0x00615A49, 0x005B5443, 0x005E5746, 0x005F5847, 0x00554E3D, 0x005B5F3C,
        0x00717355, 0x006D6E54, 0x00555440, 0x004E4B3C, 0x00545142, 0x00555341, 0x00545240, 0x00797368, 0x005B5745, 0x0057593C, 0x006B744C, 0x00707F53, 0x006E8051, 0x006F8257, 0x006F8359, 0x00718256, 0x00728357, 0x0074855A, 0x0076875C, 0x0076875C,
        0x0076865D, 0x0074845B, 0x0074845B, 0x0078885F, 0x00718158, 0x00728259, 0x00718158, 0x006C7C53, 0x006E7E55, 0x0063734A, 0x004A5A31, 0x006F6B60, 0x006A6759, 0x005A5846, 0x00595843, 0x0053523D, 0x005A5944, 0x00797863, 0x00757460, 0x00706958,
        0x00625B4A, 0x006A6352, 0x005E5746, 0x005E5746, 0x00625B4A, 0x00665F4E, 0x00615A49, 0x0069654D, 0x006A664E, 0x005E5A41, 0x005B573E, 0x005D5941, 0x0068624F, 0x00676051, 0x007C7467, 0x004E5C38, 0x0062704C, 0x006E7C58, 0x006F7D59, 0x0072805C,
        0x0074825E, 0x0074825E, 0x0075835F, 0x0073855C, 0x0073855C, 0x0072845B, 0x0072845B, 0x0073855C, 0x0074865D, 0x0076885F, 0x0076885F, 0x006F865A, 0x006F8359, 0x006B7D56, 0x006E7A56, 0x00697152, 0x0054583B, 0x0056573D, 0x0072725A, 0x00686752,
        0x0062614D, 0x00605E4C, 0x005D5A4B, 0x006C695A, 0x00797864, 0x00686850, 0x00595B3E, 0x005C5B41, 0x0059583E, 0x0058573D, 0x00545339, 0x0058573D, 0x00605F45, 0x005E5D43, 0x00605F45, 0x0077705F, 0x006B6552, 0x0068634E, 0x0069654D, 0x006D6853,
        0x00797360, 0x00746D5E, 0x005B5248, 0x00697B54, 0x006D7F58, 0x0071835C, 0x0073855E, 0x0071835C, 0x0071835C, 0x0073855E, 0x00758760, 0x0074865F, 0x0074865F, 0x0074865F, 0x0074865F, 0x0073855E, 0x0072845D, 0x0071835C, 0x0070825B, 0x0072845D,
        0x006E7F54, 0x006A7A4A, 0x005B6735, 0x00465022, 0x00535434, 0x00706958, 0x007B7068, 0x005D5843, 0x005D5843, 0x005B5641, 0x00625D48, 0x006C6752, 0x006B6651, 0x0065604B, 0x005F5A45, 0x0063584A, 0x00615648, 0x00584D3F, 0x00625749, 0x00605547,
        0x00665B4D, 0x006A5F51, 0x00766B5D, 0x00636548, 0x005C5B46, 0x00636051, 0x00625E53, 0x006D695E, 0x006E6B5C, 0x005E5D48, 0x00737558, 0x00778A5F, 0x00758661, 0x00758464, 0x007D8B69, 0x006A7953, 0xFF808B6B, 0xFFFEFFF6, 0xFFFFFEFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFDFF, 0xE8F1F5E9, 0x006A7652, 0x00768657, 0x007B895F, 0x007C8864, 0x00818D69, 0x0075835A, 0x00706F5A, 0x00645F4A, 0x00706551, 0x00675A44, 0x005E533D,
        0x00645E47, 0x00474A30, 0x002C3318, 0x003B391B, 0x00444023, 0x00514A2F, 0x00554B33, 0x00504831, 0x00524B37, 0x004E4A37, 0x003E3F2B, 0x00454723, 0x00353915, 0x002E3411, 0x00353A1A, 0x00303313, 0x004F4D2F, 0x005D563B, 0x0054492E, 0x00524F3A,
        0x006A694D, 0x005C603D, 0x005A6037, 0x0060693E, 0x006E764D, 0x00737A55, 0x007D8463, 0x007A885F, 0x00717F56, 0x0076845B, 0x0079875D, 0x00748258, 0x0077865A, 0x007B8A5E, 0x007A895D, 0x0071835C, 0x0073855C, 0x00708358, 0x0076875B, 0x006B7C50,
        0x007D8E63, 0x006D7A54, 0x00677251, 0x0061634F, 0x00686753, 0x0057523D, 0x00564E37, 0x005D523C, 0x00564C34, 0x0041381D, 0x0050472C, 0x00625B4A, 0x00595340, 0x00504A33, 0x004F482D, 0x00514D30, 0x00515034, 0x00474B32, 0x003F452E, 0x004E543D,
        0x0053573E, 0x004B4C32, 0x003E3C1E, 0x004B472A, 0x005B5439, 0x00514D31, 0x00565138, 0x0063625E, 0x00575844, 0x005B5C35, 0x00717246, 0x007C7D55, 0x007A805D, 0x007A8864, 0x0071855B, 0x00728357, 0x00728357, 0x00738458, 0x00738458, 0x00748559,
        0x00748559, 0x0075865A, 0x0075865A, 0x00748563, 0x00768762, 0x0072845B, 0x006D7E52, 0x007A895D, 0x006F7C50, 0x00646E44, 0x00576137, 0x00656456, 0x00565442, 0x004F4B33, 0x00555135, 0x00453E25, 0x0039321E, 0x00635C4D, 0x008F867C, 0x00898681,
        0x007E7C72, 0x00716C5D, 0x0066614C, 0x00615D45, 0x005F5E44, 0x00585B42, 0x00545741, 0x0054532D, 0x0043411E, 0x003F3A19, 0x00524C2F, 0x00524B30, 0x004B472F, 0x004B4833, 0x00686753, 0x00615942, 0x006D7255, 0x006B7F5C, 0x00687D56, 0x0076845B,
        0x007F895F, 0x00738158, 0x00697F55, 0x0072845B, 0x0072845B, 0x0072845B, 0x0072845B, 0x0072845B, 0x0071835A, 0x0071835A, 0x0071835A, 0x00747F59, 0x00707B5A, 0x00707E5C, 0x006F8257, 0x00627542, 0x00525F31, 0x0057593C, 0x00696358, 0x00525038,
        0x004F4C30, 0x00524F30, 0x004D4B29, 0x0041401E, 0x00454428, 0x0050513D, 0x00545545, 0x004A5339, 0x0050543B, 0x0053543A, 0x00545037, 0x00534F33, 0x00555134, 0x005A5839, 0x005C5D3D, 0x0052512B, 0x004A4825, 0x004C4726, 0x00524B30, 0x00565039,
        0x00595340, 0x00696657, 0x00525143, 0x0065744E, 0x0073835A, 0x00728357, 0x00778B5C, 0x00768A5D, 0x006F8358, 0x00768962, 0x0072845F, 0x00778A5F, 0x0076885F, 0x00708259, 0x0075875E, 0x0074865F, 0x006B7D56, 0x006E7F5A, 0x0071825D, 0x00778458,
        0x00757F54, 0x00707A4F, 0x00596139, 0x004D5030, 0x005D5A45, 0x00635B4E, 0x0061584F, 0x005A4B38, 0x005B5139, 0x00595739, 0x00454B28, 0x0049502D, 0x004E5336, 0x00575A44, 0x0051513F, 0x004E4D39, 0x004E4B36, 0x004E4930, 0x00524A2D, 0x00585033,
        0x005B5439, 0x00575239, 0x004F4B33, 0x0047502F, 0x004D5233, 0x0059553C, 0x00564D39, 0x005A513D, 0x006F6A55, 0x0062654B, 0x006C7456, 0x007F8C6C, 0x0074845B, 0x00778A59, 0x007B8E5B, 0x006F8055, 0xFF7D886E, 0xFFFAFEF9, 0xFFFDFCFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFBF8FF, 0xE8F1F5EA, 0x006C7756, 0x00758359, 0x007B8960, 0x007D8867, 0x00778261, 0x005D6A44, 0x00585742, 0x00605B46, 0x00716854, 0x006B604A, 0x0060553F,
        0x0069644B, 0x005E5F45, 0x00353A1F, 0x00454D2F, 0x004A4E31, 0x00525135, 0x00535034, 0x004D492D, 0x004C492D, 0x004A4C2F, 0x0044482B, 0x003F3F1B, 0x003A3B19, 0x00363A17, 0x003C4121, 0x003D4223, 0x00565539, 0x005F5A41, 0x005D533B, 0x00636051,
        0x0073715F, 0x005D6047, 0x0044492A, 0x00383F1C, 0x00404823, 0x00424D27, 0x0058633D, 0x006D7B52, 0x007F8D64, 0x0077855C, 0x00738157, 0x0077855B, 0x00768559, 0x0079885C, 0x00758458, 0x00708259, 0x007B8E63, 0x006C7F54, 0x00728358, 0x007F8F66,
        0x00636F4B, 0x004C5638, 0x00475036, 0x006A6955, 0x0072715D, 0x00615C47, 0x005C563F, 0x00605B42, 0x005D583F, 0x004A462A, 0x00565235, 0x00515641, 0x004E5138, 0x00494B2E, 0x00444525, 0x003D3E1E, 0x003A3C1E, 0x0042472A, 0x004D5439, 0x00495238,
        0x0051573E, 0x0051543A, 0x00464529, 0x00524F33, 0x00625D44, 0x005E5841, 0x005F5942, 0x0067655A, 0x005E6147, 0x004E532C, 0x0042491E, 0x00474E29, 0x00515B37, 0x00617148, 0x00778C5B, 0x00728357, 0x00738458, 0x00738458, 0x00748559, 0x00748559,
        0x0075865A, 0x0075865A, 0x0075865A, 0x00748760, 0x0064764F, 0x0075875E, 0x00718158, 0x0059673E, 0x00444F29, 0x00484F2C, 0x00484F2E, 0x006B685A, 0x005B5947, 0x00585540, 0x00666249, 0x005C583F, 0x004F4C37, 0x006F6B59, 0x008F8C7E, 0x008F908C,
        0x007E7C74, 0x00656456, 0x00585441, 0x00504D38, 0x00494B35, 0x004B4D39, 0x004C533E, 0x00525333, 0x00494728, 0x00464426, 0x00595539, 0x005D583F, 0x005C5840, 0x0056533E, 0x006C6954, 0x006B624E, 0x004C5037, 0x003B4D2E, 0x004A5E3B, 0x0066724E,
        0x007A825D, 0x007B8862, 0x0071865F, 0x0073855C, 0x0073855C, 0x0073855C, 0x0072845B, 0x0072845B, 0x0072845B, 0x0072845B, 0x0071835A, 0x00768159, 0x007F8A69, 0x00606C4E, 0x00495937, 0x00435429, 0x00455028, 0x00606147, 0x006E685B, 0x0066614C,
        0x00534F37, 0x005D5B3D, 0x005D5B3C, 0x00404022, 0x0044452B, 0x00545642, 0x00454838, 0x004A543D, 0x00464E37, 0x00484B35, 0x004F4E39, 0x0051503B, 0x00484A34, 0x003C422B, 0x00363E27, 0x004C502D, 0x00474828, 0x004D4B2D, 0x00575438, 0x005D5941,
        0x005C5944, 0x006D6C58, 0x005A5846, 0x00475335, 0x00515E3E, 0x005F6D49, 0x00718459, 0x00718459, 0x0072865B, 0x007C9066, 0x00667952, 0x0072855A, 0x0074865D, 0x00708259, 0x0074865D, 0x0073855E, 0x006E8059, 0x0073845F, 0x0072835E, 0x006C7A51,
        0x0058643A, 0x00535F35, 0x004E572F, 0x00484E2B, 0x0057593C, 0x006D6A55, 0x0074705E, 0x006C604E, 0x005F5844, 0x0057563A, 0x004B5030, 0x004D5433, 0x0044492C, 0x00464832, 0x00494834, 0x00474B32, 0x004C4F35, 0x00525135, 0x00504E30, 0x004A4A2C,
        0x0048492F, 0x00464933, 0x00414833, 0x00505839, 0x00595C42, 0x00645F4A, 0x00605946, 0x00665E4D, 0x00797360, 0x005D5F49, 0x0061674E, 0x006A755B, 0x00727F5F, 0x007E8F64, 0x007B8D5E, 0x0068784F, 0xFF7A856B, 0xFFFCFFFB, 0xFFFDFCFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFBFF, 0xF0F4F7EE, 0x00687254, 0x00717F56, 0x00808C68, 0x007A8466, 0x005E674C, 0x003B4626, 0x00464531, 0x0068634E, 0x0068614D, 0x00686049, 0x007E775E,
        0x00777357, 0x005C5B3F, 0x00414326, 0x003F4B2F, 0x00434B2D, 0x004F5133, 0x005C5A3B, 0x00615C3B, 0x0064603D, 0x00696542, 0x00686741, 0x00554F2C, 0x004F4D2B, 0x003F4020, 0x0037391B, 0x00393D20, 0x0056573D, 0x00706E56, 0x00827D68, 0x00707064,
        0x00727266, 0x00545446, 0x00373A2A, 0x00282D18, 0x00293218, 0x00263111, 0x0037431F, 0x00515F36, 0x007F8D64, 0x0075835A, 0x00707E54, 0x007A885E, 0x00758458, 0x0079885C, 0x00768559, 0x0074885B, 0x0073875A, 0x00738459, 0x00798960, 0x006B7655,
        0x00485137, 0x00868C79, 0x009EA094, 0x0065614F, 0x00676350, 0x0063604B, 0x007D7B63, 0x00818268, 0x00616346, 0x003C3E20, 0x00464929, 0x003E472C, 0x003C4426, 0x00474B28, 0x005A5A36, 0x0062613B, 0x005D5B38, 0x00555432, 0x00525234, 0x004F5739,
        0x0052573C, 0x004E5338, 0x0047472F, 0x0054523A, 0x00716C57, 0x007E7763, 0x00827866, 0x00777662, 0x0053573A, 0x002F3915, 0x00192705, 0x00233115, 0x002F3D21, 0x003F4F26, 0x006C804B, 0x00738458, 0x00738458, 0x00738458, 0x00748559, 0x00748559,
        0x0075865A, 0x0075865A, 0x0076875B, 0x006F8257, 0x00788A61, 0x007A8963, 0x00505B3A, 0x003E4628, 0x003C4126, 0x00444731, 0x00565842, 0x006A6556, 0x00625E4C, 0x0065644F, 0x006E6F55, 0x0058593F, 0x003E4128, 0x004F513B, 0x00686955, 0x007E7F75,
        0x00727163, 0x00666452, 0x0066624A, 0x00615D44, 0x0054543C, 0x004F5239, 0x004F553E, 0x0053543A, 0x0047482E, 0x0044452B, 0x00595A40, 0x006D6C52, 0x0078765E, 0x006D6951, 0x0077735B, 0x00594E40, 0x00686A57, 0x00788871, 0x006A7B60, 0x00515A3F,
        0x00616748, 0x007A8564, 0x0070855F, 0x0074865D, 0x0073855C, 0x0073855C, 0x0073855C, 0x0073855C, 0x0072845B, 0x0072845B, 0x0072845B, 0x007C885E, 0x00616B4D, 0x0039422E, 0x00313C28, 0x00283418, 0x00283011, 0x0056563E, 0x00716C5D, 0x00736C59,
        0x00766F5B, 0x00747057, 0x00636246, 0x004A4C2F, 0x00404329, 0x00494C36, 0x00545642, 0x00585F44, 0x0054593E, 0x0055583F, 0x005C5B46, 0x00575945, 0x00494F3C, 0x00404A39, 0x00404E3C, 0x00414629, 0x0043482B, 0x00595D40, 0x0072755B, 0x0078795F,
        0x006B6A50, 0x006F6D55, 0x0059553D, 0x00777C6D, 0x006E7763, 0x004E5A3E, 0x005C6A48, 0x007B8D64, 0x0072855A, 0x006C8055, 0x00778B61, 0x00708358, 0x0074865D, 0x0071835A, 0x0073855C, 0x0073855E, 0x0072845D, 0x0073845F, 0x00697A55, 0x00445236,
        0x00384426, 0x0032401E, 0x00293511, 0x002A3410, 0x00515738, 0x007B7E64, 0x0072755C, 0x00807769, 0x00716D5A, 0x005E5E46, 0x004A4F32, 0x00474C2F, 0x00414326, 0x004B4931, 0x005E5743, 0x0066684A, 0x00696A4A, 0x00686745, 0x00616242, 0x005B5D3F,
        0x0052583F, 0x0046513D, 0x003C4A38, 0x0044492E, 0x00585742, 0x00736F5D, 0x00746D5E, 0x006C6457, 0x007E796A, 0x005E5C4A, 0x0051533F, 0x004B5245, 0x00626B56, 0x00788664, 0x007C8D62, 0x00697852, 0xFF7E896F, 0xFFFDFFF9, 0xFFFDFEFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFAFF, 0xF4F5F8EF, 0x00697355, 0x0076835D, 0x00859070, 0x00697258, 0x0049513A, 0x00495237, 0x00534F3C, 0x00625E4B, 0x00635E49, 0x0058523B, 0x00615C43,
        0x004B472A, 0x003A381A, 0x004A4829, 0x00434528, 0x004C4A2C, 0x005E5534, 0x006F603F, 0x007A6742, 0x007B673E, 0x00736237, 0x006C5C2E, 0x00766844, 0x006E6442, 0x005E5736, 0x00474526, 0x0037391C, 0x0042422A, 0x0055543F, 0x0064604D, 0x00414730,
        0x005E6151, 0x0056574D, 0x0053534D, 0x003B3D37, 0x002C3025, 0x00373F2E, 0x00505944, 0x004B5930, 0x006E7C53, 0x00748259, 0x00748258, 0x0077855B, 0x00748357, 0x0078875B, 0x0079885C, 0x00798B5C, 0x00728455, 0x00748559, 0x007C8963, 0x00576143,
        0x005A604D, 0x009FA097, 0x008D8B8A, 0x006B6352, 0x005C5544, 0x0044432F, 0x005D6047, 0x0063684B, 0x00464C2D, 0x00303613, 0x00424825, 0x004E4F2D, 0x00575532, 0x00676039, 0x0071653B, 0x00716137, 0x006B5930, 0x006D5B36, 0x0073603D, 0x00616240,
        0x00545737, 0x004D4F32, 0x00474933, 0x004C4B37, 0x00585442, 0x0057503F, 0x004B4431, 0x00676351, 0x00585A44, 0x00525C45, 0x00334030, 0x002F3C34, 0x00495346, 0x004B5739, 0x005A6739, 0x00738458, 0x00738458, 0x00748559, 0x00748559, 0x0075865A,
        0x0075865A, 0x0075865A, 0x0076875B, 0x00728756, 0x00738458, 0x005D6B47, 0x004A5338, 0x00565B46, 0x00444535, 0x00414032, 0x00504F41, 0x00655E4D, 0x005A5643, 0x005B5A45, 0x005F634A, 0x004D5237, 0x00393E23, 0x0046492F, 0x005E5F45, 0x0072694E,
        0x006B6044, 0x00665939, 0x00675935, 0x00685B35, 0x00675B37, 0x00685F3D, 0x006B6443, 0x0057553D, 0x00484830, 0x003F4229, 0x00494C33, 0x0054573E, 0x005E5F45, 0x00534F36, 0x00645F46, 0x0065594F, 0x006E6E62, 0x00AFBCAE, 0x00B4C1B1, 0x005B624D,
        0x004E5338, 0x007F8A6A, 0x00728761, 0x0074865D, 0x0074865D, 0x0074865D, 0x0074865D, 0x0073855C, 0x0073855C, 0x0073855C, 0x0073855C, 0x006E7B4F, 0x00555E43, 0x00646A5F, 0x00545B54, 0x00313829, 0x003F452E, 0x005A5944, 0x00605C4A, 0x005F5544,
        0x006E6754, 0x0066634E, 0x0052523A, 0x0046492F, 0x003B3F22, 0x00414326, 0x00595B3E, 0x00756F46, 0x0069623B, 0x00645B36, 0x006B6241, 0x00726C4F, 0x006D6C52, 0x005E6249, 0x00515942, 0x00484E35, 0x0041472E, 0x004C5239, 0x005E654A, 0x0062674C,
        0x00595B3E, 0x006B684C, 0x005B573B, 0x00A1A29E, 0x00BEC2B7, 0x007A806D, 0x00475335, 0x006B7955, 0x007C8E65, 0x0072855A, 0x00708358, 0x0073865B, 0x00778960, 0x0074865D, 0x0074865D, 0x00758760, 0x00758760, 0x006C7D58, 0x00546540, 0x00545C55,
        0x00586055, 0x00505A4A, 0x0039422D, 0x002F381E, 0x004B5138, 0x00747761, 0x00565844, 0x00535041, 0x0052503E, 0x00454632, 0x003D4027, 0x004A4B31, 0x00585539, 0x006A6245, 0x007C7054, 0x00756945, 0x00786B45, 0x00796C46, 0x00766A46, 0x0071694B,
        0x0069654C, 0x00595B48, 0x004B5041, 0x004C4B36, 0x00504F3B, 0x006D6859, 0x006A6459, 0x00575047, 0x007B756A, 0x00676455, 0x00595745, 0x004E514F, 0x005F6659, 0x006F7A60, 0x007E8C68, 0x006C7A56, 0xFF7D886E, 0xFFFDFFF8, 0xFFFDFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFCF9FF, 0xF4F7FBF0, 0x006D7858, 0x0077845E, 0x00828D6D, 0x00616952, 0x00666D58, 0x00ADB69C, 0x00979381, 0x00605C49, 0x0063604B, 0x004E4D33, 0x003B381C,
        0x00393617, 0x00423D1C, 0x004E4825, 0x00695635, 0x00826C49, 0x009F8360, 0x00B7936D, 0x00C59F75, 0x00CDA67A, 0x00C9A373, 0x00C29D6B, 0x0090764E, 0x00826D47, 0x00766844, 0x00615A39, 0x004C4A2C, 0x0048472D, 0x004C4B36, 0x00484732, 0x00424928,
        0x0063684D, 0x005E6151, 0x00898A81, 0x00969493, 0x00868686, 0x008D8E8C, 0x00868783, 0x0068764D, 0x00606E45, 0x00738158, 0x007A885E, 0x00738157, 0x0078875B, 0x0078875B, 0x007A895D, 0x00788B5A, 0x00758758, 0x00707F53, 0x007C8963, 0x004A5338,
        0x005F6252, 0x00787872, 0x00686666, 0x00675C4E, 0x00625B4A, 0x003D3E2A, 0x003B3F26, 0x003A4224, 0x003A3F1F, 0x003E401C, 0x004F5029, 0x007A6742, 0x00856F46, 0x00977C50, 0x00AD8C5E, 0x00C09C6E, 0x00C59E72, 0x00B58F65, 0x00A37C55, 0x00796D43,
        0x00615832, 0x00524D2E, 0x00525038, 0x00535341, 0x00565442, 0x004F4B38, 0x003F3926, 0x005D544B, 0x005C5A4F, 0x008E9188, 0x008E9493, 0x007A8087, 0x0082878A, 0x006A7162, 0x00525B3A, 0x00738458, 0x00738458, 0x00738458, 0x00748559, 0x00748559,
        0x0075865A, 0x0075865A, 0x0075865A, 0x00768956, 0x00718256, 0x005D6847, 0x005A6049, 0x006D6E5E, 0x00717165, 0x007A786D, 0x005D594E, 0x0068624F, 0x004C4835, 0x003F412B, 0x00434932, 0x00474C31, 0x004C4E31, 0x005E5B3C, 0x00716C4D, 0x00785F33,
        0x00886E3F, 0x009B7E4B, 0x00A78853, 0x00A98A55, 0x00A28552, 0x00907745, 0x00816A3A, 0x00665D42, 0x00575035, 0x0048472B, 0x003E4127, 0x00373C21, 0x003B3C22, 0x0038341B, 0x005D583F, 0x0062554D, 0x00828078, 0x007B867C, 0x00707B71, 0x006A6F60,
        0x005A5D47, 0x00606B4B, 0x00768B64, 0x0074865D, 0x0074865D, 0x0074865D, 0x0074865D, 0x0074865D, 0x0073855C, 0x0073855C, 0x0073855C, 0x006A774B, 0x005E674D, 0x00B3B7B1, 0x00ADB2B1, 0x00797E75, 0x00737764, 0x005A5945, 0x0065614F, 0x00493F2E,
        0x00423C29, 0x00474330, 0x00494931, 0x00444629, 0x00524F30, 0x00645E3B, 0x00685F3A, 0x00765E28, 0x008C743E, 0x00A18654, 0x009D8355, 0x008C744A, 0x007D6B42, 0x00796C46, 0x00786F49, 0x0057573F, 0x0042452C, 0x00353B22, 0x00363F24, 0x003A4126,
        0x003F4326, 0x00636044, 0x005F583D, 0x005E5C5C, 0x00878983, 0x006F7465, 0x00535C42, 0x00616F4D, 0x006F7F56, 0x0072855A, 0x00718459, 0x0074875C, 0x00778960, 0x0074865D, 0x0076885F, 0x00788A63, 0x00778962, 0x00687954, 0x00445530, 0x0071737E,
        0x0084868E, 0x00878C8B, 0x00848882, 0x0072766B, 0x0056584C, 0x00656559, 0x0049493D, 0x003F3F2F, 0x00424230, 0x0041422E, 0x004C4C34, 0x00625E42, 0x00726747, 0x00766642, 0x007B6541, 0x0094744B, 0x009E7E55, 0x00A5855C, 0x00A1825B, 0x00967A57,
        0x00887256, 0x007D6B54, 0x00746552, 0x00605D48, 0x00534F3D, 0x00585547, 0x005A554C, 0x00534E45, 0x00757166, 0x00676154, 0x00777263, 0x0077797A, 0x006C7168, 0x00667059, 0x007F8D69, 0x00717F5B, 0xFF7A856B, 0xFFF8FEF3, 0xFFFDFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFEFF, 0xECF6FBEC, 0x006B7655, 0x0076845B, 0x00828D6C, 0x00666F55, 0x00717962, 0x00C2CBB1, 0x00A5A18F, 0x00635F4D, 0x0061604B, 0x0047482E, 0x004A4A2C,
        0x00575533, 0x00544E2B, 0x00584F2A, 0x009A774F, 0x00B79167, 0x00CFA37A, 0x00D5A57B, 0x00D7A479, 0x00D7A577, 0x00D4A474, 0x00D2A370, 0x00CAA377, 0x00AE8C61, 0x00957C54, 0x00756540, 0x005A5332, 0x004F4B2E, 0x00504F35, 0x0046442C, 0x00454926,
        0x005F6445, 0x00545640, 0x008A897B, 0x00B7B5AD, 0x00D5D2CE, 0x00FAF8F7, 0x00F7F5F4, 0x00919F76, 0x006C7A51, 0x0079875E, 0x007C8A60, 0x00717F55, 0x0078875B, 0x00728155, 0x006E7D51, 0x00738556, 0x007A8A5B, 0x0077865A, 0x00798660, 0x0051593B,
        0x00A9AD9A, 0x00C7C5BD, 0x00999692, 0x00605448, 0x00666152, 0x004C4D39, 0x00474E33, 0x00414728, 0x00454422, 0x0058502B, 0x0071643E, 0x00A47E54, 0x00BB9468, 0x00D0A574, 0x00D3A471, 0x00CE9E6A, 0x00D09F6D, 0x00D4A474, 0x00D4A579, 0x00BA9B68,
        0x00988052, 0x0073633F, 0x00625B42, 0x00595844, 0x00575945, 0x005C5E48, 0x0056563E, 0x00665F56, 0x005A564B, 0x00929187, 0x00BFBDBD, 0x00DFDCE5, 0x00F6F4FA, 0x00B0B4A8, 0x00565D42, 0x00728357, 0x00728357, 0x00738458, 0x00738458, 0x00748559,
        0x00748559, 0x0075865A, 0x0075865A, 0x00798D58, 0x007B8A5E, 0x00545F3F, 0x00606550, 0x00BEBEB0, 0x00E9E7DC, 0x00BDBAAB, 0x00555341, 0x0067654D, 0x004A4934, 0x003E402C, 0x00414730, 0x004A4A32, 0x005A5437, 0x00706140, 0x0086734E, 0x00B18B55,
        0x00BF995F, 0x00CFA56A, 0x00D3A76A, 0x00D4A86B, 0x00D3A96E, 0x00C7A069, 0x00BB9460, 0x00907A57, 0x00756541, 0x0058522F, 0x00414424, 0x003B4122, 0x0044472D, 0x00413F27, 0x006B674F, 0x005E5149, 0x008E8C84, 0x00AEB8B2, 0x009DA8A0, 0x00686C60,
        0x005A5D47, 0x0075815D, 0x0072895D, 0x0074865D, 0x0074865D, 0x0074865D, 0x0074865D, 0x0074865D, 0x0073855C, 0x0073855C, 0x0073855C, 0x006B774D, 0x005A6349, 0x00B7BBB5, 0x00D1D6D4, 0x00BAC0B5, 0x00949885, 0x0051503C, 0x006C6758, 0x0058513D,
        0x00524D38, 0x004B4A35, 0x00494A30, 0x00524E31, 0x00685C38, 0x00816E43, 0x0092784A, 0x00C7A367, 0x00CCA66C, 0x00CFA66F, 0x00CDA36E, 0x00CBA36F, 0x00C29F6D, 0x00AC8C5B, 0x00937846, 0x0075684E, 0x00615A3F, 0x004F5134, 0x00474E33, 0x004B5237,
        0x0053563C, 0x00726E56, 0x00635B44, 0x008F8D8C, 0x00CCCDC4, 0x009AA08F, 0x004F583D, 0x00586440, 0x0076865D, 0x007D8E63, 0x00718257, 0x0072855A, 0x0074865D, 0x0073855C, 0x0076885F, 0x00778962, 0x00788A63, 0x006A7B56, 0x00455631, 0x009696A4,
        0x00BEBDC7, 0x00ACADB1, 0x00989995, 0x008A8B82, 0x005D5C52, 0x0068665C, 0x0057554B, 0x004D4C38, 0x004F4E3A, 0x0057543F, 0x006B654E, 0x00766B4D, 0x0086734E, 0x00967D51, 0x00AA8C5D, 0x00C79C71, 0x00CEA175, 0x00D1A478, 0x00CDA074, 0x00C59A6F,
        0x00B8916B, 0x00A98665, 0x009C7C5F, 0x0067624D, 0x005A5643, 0x00545142, 0x005A5A4E, 0x005D5D51, 0x006F6B60, 0x005C5748, 0x00A09988, 0x00D2D5D3, 0x009BA295, 0x00657155, 0x00778660, 0x00707E5A, 0xFF7F8A70, 0xFFF8FEF3, 0xFFFAFCFC, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFDFEFC, 0xD9EEF4E1, 0x006A784F, 0x00768559, 0x0085926C, 0x0070795E, 0x00596248, 0x006C755A, 0x00696253, 0x005D5B49, 0x0062644E, 0x0041462B, 0x004F5133,
        0x004D4B28, 0x00544B26, 0x007D704A, 0x00C09867, 0x00D0A776, 0x00D9AB7B, 0x00D8A777, 0x00D5A474, 0x00D1A171, 0x00CEA070, 0x00CEA574, 0x00DDAC7A, 0x00CDA271, 0x00B59466, 0x008D774D, 0x006E613B, 0x00524B2A, 0x004C482B, 0x0049462A, 0x00504B36,
        0x0077725D, 0x0065634B, 0x00525038, 0x0041402B, 0x0061604C, 0x009F9C8D, 0x00BDBCAE, 0x007A885F, 0x006C7A51, 0x0075835A, 0x0077855B, 0x0076845A, 0x007F8E62, 0x007C8B5F, 0x007B8A5E, 0x00748455, 0x007D8D5E, 0x007B8A5E, 0x00737E56, 0x00717A59,
        0x00EAEED5, 0x00FBFCEC, 0x0089887E, 0x00696053, 0x00676253, 0x00444632, 0x00454A2F, 0x00424525, 0x004E4825, 0x00796641, 0x00A38863, 0x00CCA071, 0x00D0A272, 0x00D3A36F, 0x00D2A169, 0x00D3A26A, 0x00D4A76E, 0x00D0A46F, 0x00C8A06C, 0x00D8A96C,
        0x00C69E6A, 0x009A8058, 0x00726749, 0x00515139, 0x00464933, 0x004A5136, 0x00474C2F, 0x00716D5B, 0x005A5840, 0x00555139, 0x005E5748, 0x00A69D99, 0x00F2EFE7, 0x00C4C9B4, 0x00697453, 0x00718256, 0x00718256, 0x00728357, 0x00728357, 0x00738458,
        0x00738458, 0x00748559, 0x00748559, 0x00738752, 0x007B8A5E, 0x00626A4B, 0x00575C47, 0x00919183, 0x00919181, 0x00666550, 0x00505137, 0x0064654B, 0x004E503A, 0x004B503B, 0x0050523E, 0x005A563E, 0x00716144, 0x008E724F, 0x00AD8963, 0x00C49C68,
        0x00CBA26B, 0x00D1A46B, 0x00CFA167, 0x00CFA068, 0x00D1A36D, 0x00CFA473, 0x00CCA273, 0x00BC996D, 0x009D8256, 0x0071653B, 0x004C4B25, 0x00424727, 0x004C5134, 0x0043422D, 0x0066624F, 0x00665A50, 0x006C6A62, 0x007A847E, 0x0089938D, 0x00717569,
        0x0063674E, 0x0077855C, 0x00708957, 0x0074865D, 0x0074865D, 0x0074865D, 0x0073855C, 0x0073855C, 0x0073855C, 0x0073855C, 0x0073855C, 0x00717C54, 0x00555E44, 0x006A7065, 0x00788076, 0x007A8172, 0x006D725D, 0x00545240, 0x00686255, 0x004F4B32,
        0x0054553B, 0x004D4E34, 0x004C4B2F, 0x00675E3D, 0x00867047, 0x00AA8656, 0x00CFA36E, 0x00C39C68, 0x00C79F6B, 0x00CC9F6C, 0x00CE9F6C, 0x00D1A26F, 0x00D1A471, 0x00C8A06C, 0x00BF9864, 0x008E7456, 0x00786649, 0x005B5538, 0x0044482B, 0x00444A31,
        0x0052553F, 0x006D6956, 0x00544C3B, 0x00898A80, 0x00ADB0A1, 0x007A8069, 0x00555F41, 0x0076825E, 0x0077875E, 0x006B7B52, 0x0078885F, 0x00718459, 0x0073855C, 0x0074865D, 0x0076885F, 0x0073855E, 0x00758760, 0x0070815C, 0x0053643F, 0x00C0C0C0,
        0x00FFFFFB, 0x00C1C2B8, 0x00767767, 0x0070705E, 0x00575642, 0x006E6A58, 0x005F5B49, 0x0055533B, 0x0059573F, 0x0067614A, 0x007B7055, 0x007E6B4A, 0x009A7E55, 0x00BA9765, 0x00D1AB71, 0x00CBA174, 0x00CCA071, 0x00CC9F6C, 0x00CFA06C, 0x00D3A471,
        0x00CFA473, 0x00C2996C, 0x00B58D63, 0x00767158, 0x0068634E, 0x00585846, 0x00565949, 0x00545748, 0x00696959, 0x005B5443, 0x00A29B88, 0x00EBF1E6, 0x00B2BBA7, 0x006E7B5B, 0x0075855C, 0x00687751, 0xFF7E896F, 0xFFFDFFF8, 0xFFFDFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFB, 0xD1EDF5DE, 0x0069774D, 0x006D7D4D, 0x00818F66, 0x00889274, 0x006E775C, 0x005B6547, 0x00665F50, 0x0063614F, 0x00696C56, 0x004A4F34, 0x00484D2D,
        0x0043411E, 0x006C633D, 0x00A79871, 0x00D3AE74, 0x00D4AE74, 0x00D0A770, 0x00D1A570, 0x00D3A875, 0x00CFA675, 0x00C9A373, 0x00CAA978, 0x00D69D69, 0x00DBAB77, 0x00D1AC7A, 0x00A98F61, 0x0086764C, 0x005C532E, 0x00524D2C, 0x00595637, 0x00594D47,
        0x00766D60, 0x006B6450, 0x00494729, 0x003D3C1A, 0x005D5E3C, 0x00676749, 0x00605F43, 0x00627047, 0x0079875E, 0x007D8B62, 0x0077855B, 0x0078865C, 0x00768559, 0x00758458, 0x00768559, 0x0079885C, 0x00738256, 0x00727F53, 0x007C885E, 0x00737D59,
        0x00787D60, 0x008E907C, 0x00808171, 0x00645C4F, 0x00696657, 0x00494B37, 0x00454A2F, 0x004C4D2D, 0x006A5E3A, 0x00957B56, 0x00B18D67, 0x00CFA473, 0x00CFA36E, 0x00CFA269, 0x00CFA368, 0x00CEA567, 0x00C9A468, 0x00C6A469, 0x00C2A46B, 0x00DC9F5F,
        0x00DBAA72, 0x00B8966B, 0x00847555, 0x0057563C, 0x00444A31, 0x004A5436, 0x004A5332, 0x00707254, 0x00595935, 0x004E4B25, 0x00595133, 0x007C735F, 0x0085816E, 0x006C7253, 0x00697A4E, 0x00718256, 0x00718256, 0x00718256, 0x00728357, 0x00728357,
        0x00738458, 0x00738458, 0x00748559, 0x00728350, 0x00758359, 0x007F8768, 0x005D5F4B, 0x00595949, 0x0051523E, 0x00414228, 0x00515232, 0x00696C52, 0x004E5239, 0x00474C37, 0x004C4E3A, 0x00605841, 0x00836D51, 0x00A7835F, 0x00C79B72, 0x00C8A174,
        0x00CAA272, 0x00CDA271, 0x00CEA16E, 0x00CB9D6D, 0x00C89C6D, 0x00C69C72, 0x00C79E77, 0x00CDA36E, 0x00B89765, 0x00917F50, 0x0059572E, 0x003F4522, 0x00474C2F, 0x003F412B, 0x00666452, 0x00675B4F, 0x0085847A, 0x009FA9A3, 0x009DA7A1, 0x00707468,
        0x0062674C, 0x007C8A60, 0x006D8751, 0x0074865D, 0x0074865D, 0x0073855C, 0x0073855C, 0x0073855C, 0x0073855C, 0x0072845B, 0x0072845B, 0x007D8862, 0x005C654B, 0x00636A5D, 0x0099A295, 0x00939C87, 0x0060664D, 0x005D5C48, 0x00686257, 0x00515133,
        0x0046482B, 0x00505437, 0x00646244, 0x00756945, 0x009F8458, 0x00CCA06B, 0x00DAA468, 0x00C19E73, 0x00C29C72, 0x00C69B70, 0x00CB9C70, 0x00CE9D6F, 0x00CD9F6F, 0x00CBA06F, 0x00CCA16E, 0x00B29170, 0x00987F5F, 0x006C6141, 0x0045472A, 0x0042482F,
        0x00585A46, 0x00747162, 0x005B5245, 0x00737365, 0x00808471, 0x00686E55, 0x00636C4B, 0x0077845E, 0x00798660, 0x0075845E, 0x0071805A, 0x0072855A, 0x0075875E, 0x00778960, 0x00778960, 0x006E8059, 0x0070825B, 0x00748560, 0x0060714C, 0x009C9F90,
        0x00F9FBE8, 0x00B9BDA4, 0x00686C4F, 0x00747658, 0x005F5F41, 0x006D6B4D, 0x00575438, 0x00524F33, 0x005B573E, 0x006D664D, 0x0085775B, 0x00927957, 0x00BA996C, 0x00CDA66F, 0x00CB9F60, 0x00C29E6E, 0x00C7A270, 0x00CBA36E, 0x00CEA36A, 0x00CEA36A,
        0x00CDA46D, 0x00CAA26D, 0x00C59E6A, 0x00888166, 0x006C6850, 0x005F604C, 0x005A5E4B, 0x00505343, 0x00737361, 0x0057513E, 0x006F6652, 0x00787F70, 0x00788369, 0x006A7854, 0x00829367, 0x00697950, 0xFF778268, 0xFFF9FEF5, 0xFFFDFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFBFD, 0xD1EBEEDE, 0x0068734B, 0x00738353, 0x007D8B61, 0x007A8864, 0x00778561, 0x0076855F, 0x00716C53, 0x006A5F57, 0x00695F58, 0x004B5138, 0x00424F2F,
        0x0042452B, 0x008C7958, 0x00C6A573, 0x00D2A572, 0x00D4A774, 0x00D5A875, 0x00D4A774, 0x00D3A673, 0x00D2A572, 0x00D3A673, 0x00D4A774, 0x00C6A46F, 0x00CDA771, 0x00D1A974, 0x00C7A06C, 0x00997B4C, 0x00826F49, 0x00524E31, 0x0051553C, 0x00544E3B,
        0x00756C62, 0x00625E4B, 0x00545D32, 0x00566133, 0x005C6445, 0x00606A4C, 0x006A7A51, 0x00728056, 0x0078865C, 0x00758359, 0x00728155, 0x00768559, 0x00788859, 0x00768657, 0x00768657, 0x0073825C, 0x00788761, 0x0072815B, 0x00748259, 0x00748258,
        0x006F7B51, 0x00657246, 0x00576438, 0x005F534D, 0x00767260, 0x00575C41, 0x00464E30, 0x004E4D33, 0x00807255, 0x00A2895D, 0x00C3A56A, 0x00CFA26F, 0x00CEA16E, 0x00CEA16E, 0x00CEA16E, 0x00CDA06D, 0x00CEA16E, 0x00CEA16E, 0x00CFA26F, 0x00C3A56E,
        0x00C9A26E, 0x00D3A576, 0x00B18E63, 0x00705D3A, 0x00514E32, 0x0051533F, 0x0049493B, 0x006F665D, 0x00605D48, 0x00565D3C, 0x0056623E, 0x0052603E, 0x005B6945, 0x00738052, 0x0074864B, 0x006F8251, 0x00708352, 0x00718453, 0x00728554, 0x00738655,
        0x00738655, 0x00738655, 0x00738655, 0x00758256, 0x0077865A, 0x00708156, 0x006D7F56, 0x005E6D47, 0x005A6440, 0x00545835, 0x00565737, 0x00616657, 0x004D5342, 0x00464B36, 0x004C4B31, 0x00756B49, 0x00937A4E, 0x00C7A06C, 0x00CD9F65, 0x00CBA06D,
        0x00CBA06D, 0x00CCA16E, 0x00CCA16E, 0x00CCA16E, 0x00CCA16E, 0x00CBA06D, 0x00CBA06D, 0x00D7A36E, 0x00CBA06D, 0x00A98E62, 0x00716541, 0x004A4B2B, 0x00454C31, 0x003A4329, 0x005B644A, 0x005C5B41, 0x006A6F50, 0x0068754F, 0x00607447, 0x00697E51,
        0x0074865D, 0x00748260, 0x00737D5F, 0x0076885F, 0x0075875E, 0x0074865D, 0x0073855C, 0x0072845B, 0x00708259, 0x006F8158, 0x006F8158, 0x006E8059, 0x00768460, 0x005F6B47, 0x0069764A, 0x006A7644, 0x004B5227, 0x0056543C, 0x006D655E, 0x004D5232,
        0x00494E2E, 0x00504F2D, 0x007F6C4B, 0x009A754F, 0x00C79A6E, 0x00C8A46E, 0x00BEA567, 0x00C99E6B, 0x00CA9F6C, 0x00CBA06D, 0x00CBA06D, 0x00C99E6B, 0x00C99E6B, 0x00CA9F6C, 0x00CBA06D, 0x00C8A26B, 0x00A78C5A, 0x00776C46, 0x004D5036, 0x00414A36,
        0x004C5142, 0x006A6759, 0x005D5244, 0x00556040, 0x005B6646, 0x005F6A49, 0x00707E5A, 0x00798862, 0x006E8156, 0x006F8257, 0x0075895C, 0x006E8057, 0x0071835A, 0x0073855C, 0x0072845B, 0x0071835A, 0x00708259, 0x006F8158, 0x00708259, 0x00626F4F,
        0x007B8862, 0x00657343, 0x00525F2B, 0x005A6435, 0x00585939, 0x006D6558, 0x00625654, 0x00615F54, 0x005E5D48, 0x0076704D, 0x008C7646, 0x00C39B66, 0x00CC9E68, 0x00C7A06C, 0x00BBA06E, 0x00CBA06D, 0x00CCA16E, 0x00CCA16E, 0x00CBA06D, 0x00CA9F6C,
        0x00CA9F6C, 0x00CCA16E, 0x00CDA26F, 0x00B99069, 0x00917C5C, 0x00626450, 0x00475248, 0x004E554E, 0x00747267, 0x0059553D, 0x00666344, 0x00607348, 0x006B7D56, 0x00768762, 0x007C8C63, 0x006C7D52, 0xFF7B8666, 0xFFFFFFF9, 0xFFFDF9FF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFEFF, 0xCEE9ECDC, 0x0066714B, 0x00768656, 0x00808E64, 0x007C8A66, 0x00798763, 0x00778660, 0x00706D51, 0x00675E51, 0x00675E54, 0x004D5134, 0x004B5531,
        0x00555236, 0x00998360, 0x00CCA775, 0x00D3A673, 0x00D4A774, 0x00D4A774, 0x00D4A774, 0x00D3A673, 0x00D2A572, 0x00D3A673, 0x00D3A673, 0x00CBA470, 0x00CFA772, 0x00D5AB76, 0x00CFA773, 0x00A58457, 0x00887550, 0x005A5235, 0x0056563E, 0x00504B36,
        0x007B7366, 0x005F5C47, 0x00535D2F, 0x00616D3B, 0x00727D57, 0x00788460, 0x00728455, 0x00738157, 0x0079875D, 0x0078865C, 0x00768559, 0x0078875B, 0x00778758, 0x00758556, 0x00788859, 0x0078885F, 0x0078885F, 0x00738459, 0x00758359, 0x00707F53,
        0x006F7C50, 0x006F7C50, 0x00637042, 0x0061584E, 0x0073725E, 0x00505637, 0x00414728, 0x004D4A2E, 0x00887657, 0x00AE9164, 0x00D0AB71, 0x00D0A370, 0x00D0A370, 0x00CFA26F, 0x00CFA26F, 0x00CFA26F, 0x00CEA16E, 0x00CEA16E, 0x00CEA16E, 0x00C3A26A,
        0x00CEA46F, 0x00D4A676, 0x00B89268, 0x007D6B46, 0x00555134, 0x00494B35, 0x00474533, 0x00766D63, 0x0054523A, 0x00545D35, 0x00667549, 0x006D7D54, 0x00708057, 0x00717F4F, 0x006F8047, 0x006F8251, 0x00708352, 0x00718453, 0x00728554, 0x00738655,
        0x00738655, 0x00738655, 0x00738655, 0x00758254, 0x00758556, 0x00708155, 0x0072855A, 0x006E7E55, 0x00727D57, 0x00656946, 0x00575836, 0x00676858, 0x00555646, 0x004F503C, 0x00545037, 0x007C704E, 0x009A8155, 0x00CBA470, 0x00D0A169, 0x00CCA16E,
        0x00CBA06D, 0x00CBA06D, 0x00CBA06D, 0x00CBA06D, 0x00CBA06D, 0x00CBA06D, 0x00CCA16E, 0x00D5A16C, 0x00CCA16E, 0x00B79A6E, 0x0080724E, 0x00504C2F, 0x004B4E34, 0x00464C33, 0x00676D54, 0x005F5E42, 0x00626747, 0x0069774E, 0x006D8154, 0x006C8154,
        0x00697C51, 0x006E7D57, 0x00798463, 0x0075875E, 0x0075875E, 0x0074865D, 0x0073855C, 0x0072845B, 0x0071835A, 0x00708259, 0x006F8158, 0x00718459, 0x006F7E58, 0x0066734D, 0x0069764A, 0x0064713D, 0x004F5629, 0x00545339, 0x006E675E, 0x00545535,
        0x004A4D2D, 0x00524F30, 0x00867151, 0x00A67F59, 0x00CFA074, 0x00CBA36E, 0x00BB9F62, 0x00C99E6B, 0x00CA9F6C, 0x00CCA16E, 0x00CBA06D, 0x00CA9F6C, 0x00C99E6B, 0x00C99E6B, 0x00CA9F6C, 0x00D2A671, 0x00B49365, 0x0082724E, 0x0057563C, 0x004D5340,
        0x0054594A, 0x006D6A5B, 0x005B5244, 0x0064704C, 0x006E7A56, 0x0073805A, 0x0073825C, 0x0074845B, 0x0075885D, 0x00788B60, 0x0075885D, 0x0076885F, 0x0073855C, 0x0071835A, 0x0071835A, 0x0072845B, 0x0071835A, 0x0071835A, 0x0071835A, 0x006B7957,
        0x006E7C53, 0x00627040, 0x00525F2B, 0x004C5627, 0x00555634, 0x00766F5E, 0x00655B54, 0x00676358, 0x0064614C, 0x007E7553, 0x00967E50, 0x00CA9F6C, 0x00CF9F6B, 0x00C8A06C, 0x00C0A16E, 0x00CCA16E, 0x00CCA16E, 0x00CDA26F, 0x00CCA16E, 0x00CA9F6C,
        0x00CA9F6C, 0x00CBA06D, 0x00CCA16E, 0x00C59872, 0x009E8563, 0x00706D58, 0x00525B4E, 0x00545950, 0x00787567, 0x005F5B43, 0x006D6B4C, 0x0076885F, 0x00768762, 0x00768762, 0x007A8A61, 0x006B7C51, 0xFF7A8565, 0xFFFFFFF9, 0xFFFFFBFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFEFF, 0xCAE6E9D9, 0x0067724C, 0x007A8A5B, 0x007F8D63, 0x00788662, 0x00778563, 0x0073825C, 0x006C6E50, 0x00665F4E, 0x006B6352, 0x004F502E, 0x00485028,
        0x005B5335, 0x00A38764, 0x00D5AC7B, 0x00D4A774, 0x00D3A673, 0x00D3A673, 0x00D3A673, 0x00D3A673, 0x00D3A673, 0x00D2A572, 0x00D2A572, 0x00D1A570, 0x00D1A570, 0x00D6A976, 0x00D3A97A, 0x00AD8B60, 0x008D7754, 0x00605438, 0x005B573E, 0x004E4A31,
        0x00756E5F, 0x005B5941, 0x00586234, 0x00626F3B, 0x00616D43, 0x0068774B, 0x006F854B, 0x00717F55, 0x0076845A, 0x0077855B, 0x0077865A, 0x0079885C, 0x00768657, 0x00758556, 0x007A8A5B, 0x0077885C, 0x0075865A, 0x00748559, 0x00778758, 0x00708051,
        0x006F7C4E, 0x00717E50, 0x00657244, 0x00615A4B, 0x006E6E56, 0x00464D2C, 0x003B411E, 0x004E482B, 0x00907959, 0x00BB9769, 0x00D6AC71, 0x00D1A471, 0x00D1A471, 0x00D1A471, 0x00D0A370, 0x00CFA26F, 0x00CFA26F, 0x00CEA16E, 0x00CDA06D, 0x00C7A367,
        0x00CFA36D, 0x00D2A272, 0x00BB966A, 0x008C7954, 0x005D5837, 0x0047462A, 0x0048442B, 0x006E6659, 0x0058573B, 0x00616C3E, 0x00667843, 0x00647746, 0x006E7F53, 0x00717F4F, 0x006D7E45, 0x00708352, 0x00708352, 0x00718453, 0x00728554, 0x00738655,
        0x00738655, 0x00738655, 0x00728554, 0x00788656, 0x00758555, 0x00708253, 0x006D8154, 0x00697A4F, 0x00707B53, 0x00676C45, 0x00545632, 0x006A6758, 0x005B5947, 0x0054533F, 0x0058533A, 0x00817252, 0x00A58960, 0x00D0A776, 0x00D3A16C, 0x00CCA16E,
        0x00CBA06D, 0x00CA9F6C, 0x00CA9F6C, 0x00CA9F6C, 0x00CA9F6C, 0x00CBA06D, 0x00CCA16E, 0x00D8A26D, 0x00CEA070, 0x00C0A075, 0x008B7855, 0x004D472A, 0x004A492F, 0x004A4A32, 0x0065644F, 0x00646446, 0x00656A4A, 0x0068754F, 0x006A7D52, 0x006B8053,
        0x0073875A, 0x0076875C, 0x00728057, 0x0074865D, 0x0074865D, 0x0073855C, 0x0073855C, 0x0072845B, 0x0071835A, 0x0071835A, 0x0071835A, 0x00718556, 0x006B7B52, 0x00707E55, 0x006F7C50, 0x0065723E, 0x00565E2F, 0x00535335, 0x006D6859, 0x00595538,
        0x00514F31, 0x00595435, 0x008D7858, 0x00AF8764, 0x00D3A276, 0x00CCA26D, 0x00C2A065, 0x00C99E6B, 0x00CBA06D, 0x00CCA16E, 0x00CCA16E, 0x00CA9F6C, 0x00C99E6B, 0x00C89D6A, 0x00C99E6B, 0x00D9A472, 0x00C3996E, 0x008D7754, 0x005E5A42, 0x00595C4C,
        0x005E6152, 0x00706D5E, 0x005C5443, 0x00627046, 0x006C7A50, 0x00728056, 0x006F8055, 0x00718257, 0x006E8057, 0x006C7E55, 0x0074865D, 0x00788A61, 0x0071835A, 0x006F8158, 0x0073855C, 0x0073855C, 0x0071835A, 0x006F8158, 0x006E8057, 0x0075835F,
        0x00707E54, 0x006C7B48, 0x00596632, 0x00495324, 0x00545632, 0x0076715C, 0x006B6258, 0x0070675A, 0x0068614D, 0x00817656, 0x009D8458, 0x00CDA271, 0x00D19F6B, 0x00CB9E6B, 0x00C4A16F, 0x00CCA16E, 0x00CDA26F, 0x00CDA26F, 0x00CCA16E, 0x00CA9F6C,
        0x00CA9F6C, 0x00CBA06D, 0x00CCA16E, 0x00CD9A72, 0x00A18360, 0x00736C53, 0x00555848, 0x00535647, 0x0073715F, 0x005B5A40, 0x006A6D4D, 0x00788A63, 0x00738361, 0x00728260, 0x00798862, 0x006D7E53, 0xFF7B8666, 0xFFFFFFF8, 0xFFFFFBFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFDFF, 0xCEE7EADB, 0x0068734D, 0x00768657, 0x0079875E, 0x00798765, 0x007D8B69, 0x007B8965, 0x006B7251, 0x0065614E, 0x0069624E, 0x00484922, 0x0046481E,
        0x005D5232, 0x00A58764, 0x00D8AC7D, 0x00D5A875, 0x00D3A673, 0x00D2A572, 0x00D2A572, 0x00D3A673, 0x00D3A673, 0x00D2A572, 0x00D0A370, 0x00D4A56F, 0x00D1A26E, 0x00D3A575, 0x00D1A67B, 0x00AF8B65, 0x008C7353, 0x00625438, 0x005D563B, 0x00464426,
        0x00706A57, 0x005E5C44, 0x00525C2E, 0x00616E3A, 0x00727E54, 0x00708051, 0x00708749, 0x00707E54, 0x00738157, 0x00728056, 0x00748357, 0x0078875B, 0x00768657, 0x00758556, 0x007A8A5B, 0x00748756, 0x00758857, 0x00718453, 0x00768656, 0x00758556,
        0x00727F51, 0x00717E50, 0x00687547, 0x005C5845, 0x00686A4D, 0x003E4621, 0x003B3F1B, 0x0050482A, 0x00927959, 0x00BD9669, 0x00D5A66E, 0x00CFA26F, 0x00CFA26F, 0x00D0A370, 0x00D0A370, 0x00CFA26F, 0x00CFA26F, 0x00CEA16E, 0x00CDA06D, 0x00CCA567,
        0x00CFA068, 0x00D09F6F, 0x00BD976D, 0x008E7C57, 0x005E5A37, 0x004A4829, 0x004C4728, 0x0070695A, 0x00515133, 0x00535F2D, 0x00687B42, 0x006B7E4B, 0x006B7D4E, 0x00728050, 0x0074844E, 0x00708253, 0x00718354, 0x00728455, 0x00728455, 0x00738556,
        0x00738556, 0x00728455, 0x00728455, 0x00798757, 0x00718151, 0x006E8051, 0x006C8053, 0x0068794E, 0x006C784E, 0x00666B44, 0x00555831, 0x006D6655, 0x005A5644, 0x00544E3B, 0x00575037, 0x00837152, 0x00AF9069, 0x00D1A77A, 0x00D19E6C, 0x00CBA06D,
        0x00CBA06D, 0x00CBA06D, 0x00CBA06D, 0x00CBA06D, 0x00CBA06D, 0x00CBA06D, 0x00CBA06D, 0x00D8A16E, 0x00CC9E6E, 0x00C2A279, 0x008D7A59, 0x004C4427, 0x0049452D, 0x004B4833, 0x00625F4A, 0x00565638, 0x00666B4B, 0x00707C58, 0x006B7D54, 0x00667A4F,
        0x006C8053, 0x00738458, 0x00758458, 0x0073855C, 0x0073855C, 0x0073855C, 0x0072845B, 0x0072845B, 0x0072845B, 0x0072845B, 0x0072845B, 0x00718753, 0x00708156, 0x00717E58, 0x006D794F, 0x0064703E, 0x00545C2D, 0x00525333, 0x006D6957, 0x005D5538,
        0x00555134, 0x00615C3D, 0x00927D5E, 0x00B28A67, 0x00CF9D73, 0x00CFA06D, 0x00CAA46A, 0x00C99E6B, 0x00CBA06D, 0x00CCA16E, 0x00CCA16E, 0x00CA9F6C, 0x00C99E6B, 0x00C89D6A, 0x00C89D6A, 0x00D69E6F, 0x00C89C73, 0x00927959, 0x00635D46, 0x005D6050,
        0x005E6152, 0x006F6C5D, 0x005A5342, 0x00667647, 0x00748455, 0x0078875B, 0x00718257, 0x0075865B, 0x0071835A, 0x006B7D54, 0x00788A63, 0x0072845B, 0x006D7F56, 0x00708259, 0x0076885F, 0x0073855C, 0x006F8158, 0x006D7F56, 0x006B7D54, 0x0065744E,
        0x0068764C, 0x00687646, 0x0055612F, 0x004C5628, 0x00555733, 0x00716D54, 0x00756E5D, 0x00716357, 0x00675E4A, 0x007F7456, 0x009F865E, 0x00C99F72, 0x00D29D6B, 0x00CD9C6A, 0x00CAA26E, 0x00CDA26F, 0x00CDA26F, 0x00CDA26F, 0x00CCA16E, 0x00CA9F6C,
        0x00C99E6B, 0x00CA9F6C, 0x00CCA16E, 0x00D39F7A, 0x00A2825F, 0x0072674B, 0x00565743, 0x00545442, 0x0074705D, 0x005B5D40, 0x006A7150, 0x0071815F, 0x00718060, 0x00738262, 0x007A8963, 0x006D7E53, 0xFF7B8665, 0xFFFFFFF8, 0xFFFFFCFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFDFF, 0xD1EAEDDE, 0x0066704C, 0x00728155, 0x007B8960, 0x007F8D6B, 0x00808D6D, 0x00778561, 0x00656C4B, 0x00615E49, 0x00675F48, 0x0046441B, 0x00494B1D,
        0x005F5635, 0x009F8364, 0x00D0A97D, 0x00D6A976, 0x00D4A774, 0x00D3A673, 0x00D3A673, 0x00D3A673, 0x00D3A673, 0x00D2A572, 0x00D0A370, 0x00D4A36B, 0x00D1A16D, 0x00D1A576, 0x00CEA57E, 0x00AC8C69, 0x00866E50, 0x00615336, 0x005B5336, 0x004F4D2E,
        0x006A6451, 0x0064614C, 0x00555D35, 0x00576136, 0x00636D49, 0x00606D47, 0x00758A53, 0x00748258, 0x00758359, 0x00728056, 0x00738256, 0x0079885C, 0x00788859, 0x00758556, 0x00768657, 0x00768956, 0x00798C59, 0x006F8251, 0x00738354, 0x00778758,
        0x00717E52, 0x006A764C, 0x00657147, 0x005E5845, 0x00646648, 0x003B421D, 0x00393F1C, 0x0050482B, 0x008C7456, 0x00BD976D, 0x00D7A973, 0x00CDA06D, 0x00CEA16E, 0x00CEA16E, 0x00CEA16E, 0x00CEA16E, 0x00CEA16E, 0x00CEA16E, 0x00CEA16E, 0x00CCA365,
        0x00CFA06A, 0x00D3A478, 0x00BD9973, 0x00807150, 0x0053512F, 0x004A4826, 0x004E4825, 0x00665F50, 0x005E5E40, 0x00596436, 0x00657545, 0x0066774C, 0x00677650, 0x00768357, 0x006F7E4B, 0x00718354, 0x00728455, 0x00728455, 0x00738556, 0x00738556,
        0x00738556, 0x00728455, 0x00728455, 0x00778456, 0x006D7D4E, 0x006F8054, 0x00718459, 0x00708156, 0x0069744C, 0x00636743, 0x00585A36, 0x006E6756, 0x005A5441, 0x00504A37, 0x00544C35, 0x007F6F52, 0x00AE936E, 0x00D0A67B, 0x00CF9F6F, 0x00CA9F6C,
        0x00CBA06D, 0x00CBA06D, 0x00CCA16E, 0x00CCA16E, 0x00CBA06D, 0x00CBA06D, 0x00CA9F6C, 0x00D3A16D, 0x00CCA071, 0x00C2A47B, 0x008B7A59, 0x004F462B, 0x004F4B33, 0x0055503B, 0x006F6A55, 0x00605F43, 0x00626649, 0x00646E50, 0x006B7B59, 0x0071835E,
        0x006E8057, 0x006D7E52, 0x00768657, 0x0072845B, 0x0072845B, 0x0072845B, 0x0072845B, 0x0072845B, 0x0072845B, 0x0072845B, 0x0072845B, 0x006D834F, 0x0078895E, 0x006F7B57, 0x006C7751, 0x00677146, 0x00535A2F, 0x00555537, 0x006B6754, 0x005E5338,
        0x00575035, 0x00605C3F, 0x008F7D5E, 0x00B38E6C, 0x00CE9E74, 0x00CE9F6C, 0x00CAA16A, 0x00C99E6B, 0x00CBA06D, 0x00CCA16E, 0x00CCA16E, 0x00CA9F6C, 0x00C99E6B, 0x00C99E6B, 0x00C99E6B, 0x00D59E73, 0x00C99D78, 0x0091795D, 0x00655E4A, 0x005C5F4F,
        0x00585B4B, 0x006D6B59, 0x005A5340, 0x00647248, 0x006D7B51, 0x0077855C, 0x0074845B, 0x00718158, 0x0074865D, 0x0076885F, 0x0072845B, 0x0071835A, 0x006D7F56, 0x0073855C, 0x00778960, 0x0071835A, 0x006E8057, 0x006F8158, 0x006F8158, 0x0072805C,
        0x006D7B52, 0x0069764A, 0x00566133, 0x004F572E, 0x00585937, 0x00716D54, 0x006D6853, 0x006B5B4E, 0x00615844, 0x007C7155, 0x00A18965, 0x00CAA076, 0x00D1A070, 0x00CE9D6B, 0x00CAA06B, 0x00CCA16E, 0x00CDA26F, 0x00CDA26F, 0x00CCA16E, 0x00CA9F6C,
        0x00CA9F6C, 0x00CBA06D, 0x00CCA16E, 0x00D1A381, 0x009A7E5C, 0x00696144, 0x0053523D, 0x0053523E, 0x00746F5A, 0x00595A40, 0x00666B4E, 0x00738262, 0x00778569, 0x007A896A, 0x007B8965, 0x00697A4F, 0xFF788362, 0xFFFFFFF7, 0xFFFFFDFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFDFF, 0xD5E9EBDF, 0x00656F4B, 0x00758458, 0x00849269, 0x007B8868, 0x00657252, 0x00505E3A, 0x00505637, 0x00605A47, 0x00726751, 0x004D4B22, 0x00494C1E,
        0x00514E2F, 0x0088755A, 0x00C4A782, 0x00D6A976, 0x00D5A875, 0x00D4A774, 0x00D4A774, 0x00D4A774, 0x00D3A673, 0x00D2A572, 0x00D1A471, 0x00D2A46A, 0x00D2A671, 0x00D1A87B, 0x00C7A37D, 0x00A38768, 0x007A684B, 0x005D5234, 0x00574F31, 0x00575733,
        0x00696350, 0x005D5947, 0x00464A2D, 0x003E4326, 0x004D513E, 0x0049513A, 0x004F5F36, 0x00717F55, 0x0078865C, 0x0078865C, 0x00768559, 0x0079885C, 0x0079895A, 0x00758556, 0x00748455, 0x00748756, 0x00788B5A, 0x00738556, 0x00768559, 0x00717F55,
        0x005F6A42, 0x00515C36, 0x0047512D, 0x00635C49, 0x0067664A, 0x003A401D, 0x003A4120, 0x00454128, 0x0079684D, 0x00B0936C, 0x00D2AD7B, 0x00CFA26F, 0x00CFA26F, 0x00CEA16E, 0x00CDA06D, 0x00CDA06D, 0x00CEA16E, 0x00CEA16E, 0x00CFA26F, 0x00C99E65,
        0x00D2A370, 0x00D6A983, 0x00B29374, 0x006D6345, 0x00444727, 0x00454624, 0x004F4924, 0x0067604F, 0x005C5B41, 0x004A512E, 0x00475231, 0x00485339, 0x004F5A40, 0x006C7652, 0x007B885A, 0x00738458, 0x00738458, 0x00748559, 0x00748559, 0x00748559,
        0x00748559, 0x00738458, 0x00738458, 0x00778359, 0x00738157, 0x0073835A, 0x00667851, 0x00576541, 0x00434D29, 0x00474A2A, 0x00515133, 0x00706A57, 0x00595542, 0x004F4B38, 0x00524C35, 0x0074684C, 0x00A58D69, 0x00C5A277, 0x00CDA376, 0x00CBA06D,
        0x00CBA06D, 0x00CCA16E, 0x00CCA16E, 0x00CCA16E, 0x00CCA16E, 0x00CBA06D, 0x00CBA06D, 0x00CEA26D, 0x00CBA575, 0x00B99F77, 0x007F7050, 0x00494529, 0x004C4934, 0x00514D3A, 0x00746E5B, 0x0056533E, 0x0051533D, 0x004C543D, 0x00505D45, 0x00607051,
        0x0072835E, 0x0077885D, 0x00738354, 0x0072845B, 0x0072845B, 0x0072845B, 0x0072845B, 0x0072845B, 0x0072845B, 0x0072845B, 0x0072845B, 0x006E8352, 0x006F7E58, 0x00596345, 0x004E5637, 0x00474F2A, 0x00404420, 0x00555438, 0x006E6A58, 0x0060553A,
        0x00535034, 0x00575739, 0x00807557, 0x00AE906D, 0x00CDA178, 0x00CD9F6F, 0x00C49B64, 0x00C99E6B, 0x00CA9F6C, 0x00CBA06D, 0x00CA9F6C, 0x00C99E6B, 0x00C99E6B, 0x00CA9F6C, 0x00CBA06D, 0x00D0A279, 0x00BD9B77, 0x00837257, 0x005E5D49, 0x00565C4B,
        0x00545747, 0x006F6B59, 0x005B523E, 0x00505A3C, 0x004A5535, 0x005A6544, 0x0073815F, 0x0071805A, 0x006C7E57, 0x0076885F, 0x006D8055, 0x0076885F, 0x0072845B, 0x0076885F, 0x0076885F, 0x006F8158, 0x00708259, 0x0074865D, 0x00708259, 0x00677454,
        0x00525D3C, 0x004B5531, 0x00424A25, 0x003E4421, 0x00555537, 0x0078745B, 0x00615C47, 0x00645545, 0x005B5440, 0x00766F54, 0x009D8C6B, 0x00C5A179, 0x00D4A677, 0x00CFA06C, 0x00C69F68, 0x00CBA06D, 0x00CCA16E, 0x00CCA16E, 0x00CBA06D, 0x00CA9F6C,
        0x00CA9F6C, 0x00CCA16E, 0x00CDA26F, 0x00C29E80, 0x008A7559, 0x005F5C40, 0x0050523C, 0x00534F3C, 0x00716A59, 0x00575340, 0x0062654F, 0x006A785C, 0x00707D63, 0x00778569, 0x007D8B69, 0x006A7A51, 0xFF768160, 0xFFFCFFF4, 0xFFFEFCFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFBFF, 0xD5E9EBDF, 0x00646D4C, 0x0079875D, 0x0087946E, 0x006D7A5A, 0x004B5838, 0x003E4C2A, 0x004B5035, 0x00635C4D, 0x00776C56, 0x004D4B22, 0x0042491C,
        0x003A3E21, 0x00625A43, 0x00A59374, 0x00D6A976, 0x00D7AA77, 0x00D6A976, 0x00D5A875, 0x00D4A774, 0x00D2A572, 0x00D2A572, 0x00D2A572, 0x00D6AA6F, 0x00D5AB76, 0x00CBA67A, 0x00B59774, 0x008E795A, 0x006A5C3F, 0x00585032, 0x00575233, 0x004F4F2B,
        0x0076705D, 0x00615B50, 0x004F4F3D, 0x00666757, 0x009F9D9C, 0x009FA19B, 0x00666F5A, 0x00606E44, 0x00728056, 0x007B895F, 0x0077865A, 0x0077865A, 0x00788859, 0x00768657, 0x00768657, 0x00738556, 0x00728357, 0x0077885D, 0x0079875E, 0x00606C48,
        0x004C5534, 0x00474F30, 0x00394122, 0x00695C4E, 0x006A664E, 0x003C4122, 0x003B4325, 0x00373923, 0x005E533D, 0x0095815E, 0x00BBA173, 0x00D4A774, 0x00D3A673, 0x00D0A370, 0x00CEA16E, 0x00CDA06D, 0x00CDA06D, 0x00CEA16E, 0x00CFA26F, 0x00CCA26D,
        0x00D4A77B, 0x00C89D7C, 0x00967B61, 0x005C573E, 0x0042472A, 0x00474A2A, 0x00524E2B, 0x00726B5A, 0x004B4833, 0x0050533D, 0x007A7F70, 0x00979B95, 0x0080867B, 0x0062694E, 0x00768258, 0x00748559, 0x00748559, 0x0075865A, 0x0075865A, 0x0075865A,
        0x00748559, 0x00748559, 0x00738458, 0x0079845E, 0x00788460, 0x006D7B57, 0x0050603E, 0x00414E2E, 0x002F3719, 0x003B3C22, 0x004F4E34, 0x006D6956, 0x00575642, 0x004E503A, 0x004E4C34, 0x00645C3F, 0x00927E5B, 0x00B6986F, 0x00CBA67A, 0x00CEA370,
        0x00CDA26F, 0x00CCA16E, 0x00CBA06D, 0x00CBA06D, 0x00CCA16E, 0x00CDA26F, 0x00CEA370, 0x00CDA672, 0x00C6A577, 0x00A08C63, 0x00645B3A, 0x00444329, 0x004B4D37, 0x00474632, 0x00686753, 0x005E5A48, 0x007A7A6A, 0x00929788, 0x007C8675, 0x0057644E,
        0x00606F50, 0x007A8963, 0x007A895D, 0x0073855C, 0x0073855C, 0x0073855C, 0x0072845B, 0x0072845B, 0x0072845B, 0x0072845B, 0x0071835A, 0x00728657, 0x005A6846, 0x00485039, 0x00323821, 0x0024290C, 0x00343618, 0x0056543C, 0x00726C5F, 0x00645B40,
        0x00525135, 0x004C5033, 0x006B6647, 0x009E8662, 0x00C49E74, 0x00CCA372, 0x00C59F68, 0x00C99E6B, 0x00CA9F6C, 0x00CA9F6C, 0x00C99E6B, 0x00C89D6A, 0x00C99E6B, 0x00CCA16E, 0x00CEA370, 0x00C4A179, 0x00A68E6A, 0x006A6245, 0x004F543F, 0x004F5746,
        0x00535646, 0x00746E5B, 0x005F513E, 0x00696F5E, 0x00707663, 0x005B634C, 0x00667256, 0x00798765, 0x006E8059, 0x0073865B, 0x0074885B, 0x0076885F, 0x0072845B, 0x0075875E, 0x0075875E, 0x006F8158, 0x0073855C, 0x0072845B, 0x0064764D, 0x00404C30,
        0x00353E23, 0x00293113, 0x00272C0F, 0x002F3316, 0x004E4D33, 0x007A7560, 0x00635D4A, 0x005E5442, 0x0057523D, 0x006B6A50, 0x008E8363, 0x00B59873, 0x00CFA578, 0x00CDA36E, 0x00C6A167, 0x00CA9F6C, 0x00CBA06D, 0x00CBA06D, 0x00CBA06D, 0x00CBA06D,
        0x00CBA06D, 0x00CDA26F, 0x00CFA471, 0x00A89177, 0x00776E53, 0x00595D44, 0x00545944, 0x00575445, 0x00766D5F, 0x005E594A, 0x006B6C5C, 0x0069765C, 0x0066735B, 0x006E7B61, 0x007E8C6A, 0x006F7F56, 0xFF737E5D, 0xFFF7FBEF, 0xFFFEFDFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFDFF, 0xD9EBEDE1, 0x00636C4B, 0x0076845A, 0x00828F69, 0x00657252, 0x004F5B3D, 0x00586644, 0x005D5F49, 0x00696053, 0x006F614E, 0x003F3F17, 0x003E481D,
        0x0031381D, 0x0044432E, 0x007C7457, 0x00D6A976, 0x00D7AA77, 0x00D8AB78, 0x00D6A976, 0x00D4A774, 0x00D2A572, 0x00D2A572, 0x00D3A673, 0x00D9B072, 0x00D6AE79, 0x00C3A275, 0x00A28864, 0x0079674A, 0x005A4F33, 0x00555031, 0x00585634, 0x00575831,
        0x00756E5D, 0x00665E57, 0x007B796E, 0x00827F7A, 0x008C8790, 0x009A989E, 0x00767C71, 0x004B592F, 0x0068764C, 0x0079875D, 0x00768559, 0x00738256, 0x00758556, 0x00778758, 0x0079895A, 0x00798A5E, 0x006E7F54, 0x0076865D, 0x0077845E, 0x00515C3B,
        0x00485032, 0x00596045, 0x0050573C, 0x006A5A4E, 0x006B6450, 0x003E4225, 0x003C452A, 0x002E331E, 0x0047422D, 0x007C6D4D, 0x00A18E63, 0x00D9AC79, 0x00D7AA77, 0x00D3A673, 0x00CFA26F, 0x00CDA06D, 0x00CDA06D, 0x00CEA16E, 0x00CFA26F, 0x00D2AA76,
        0x00D5AA7F, 0x00B28A6D, 0x0079614B, 0x0053503B, 0x00475036, 0x004A5031, 0x00565431, 0x006F6859, 0x00615D4B, 0x00727264, 0x00727371, 0x00909096, 0x00989B99, 0x005F644F, 0x0057623A, 0x0075865A, 0x0075865A, 0x0075865A, 0x0076875B, 0x0075865A,
        0x0075865A, 0x00748559, 0x00748559, 0x007A8362, 0x00737E5D, 0x005F6C4C, 0x00465536, 0x00505C40, 0x004C5239, 0x00505038, 0x00595641, 0x00676651, 0x00545640, 0x004E513B, 0x00484B32, 0x00565033, 0x00806F4E, 0x00A78D65, 0x00C8A67B, 0x00D1A673,
        0x00CFA471, 0x00CBA06D, 0x00C99E6B, 0x00C99E6B, 0x00CBA06D, 0x00CFA471, 0x00D1A673, 0x00CEA975, 0x00BDA172, 0x008A784F, 0x00514A29, 0x0047482E, 0x00565943, 0x00474834, 0x00636450, 0x00575144, 0x00807E73, 0x00BDC1B6, 0x00B0B8AD, 0x0064705E,
        0x00505D43, 0x00707E5A, 0x0078865C, 0x0074865D, 0x0073855C, 0x0073855C, 0x0073855C, 0x0072845B, 0x0072845B, 0x0071835A, 0x0071835A, 0x006A7E51, 0x00505D3D, 0x00626855, 0x00585C49, 0x0042462D, 0x00535538, 0x005F5B48, 0x006B655A, 0x00665F46,
        0x0054553B, 0x00464E30, 0x005A5839, 0x008B7754, 0x00B8966B, 0x00CDA574, 0x00D1AB75, 0x00C99E6B, 0x00C99E6B, 0x00C99E6B, 0x00C89D6A, 0x00C89D6A, 0x00C99E6B, 0x00CDA26F, 0x00CFA471, 0x00B59C72, 0x008F7F5B, 0x00535034, 0x00424934, 0x00495343,
        0x00535646, 0x0079725F, 0x0061523F, 0x00A2A59C, 0x00D0D4C9, 0x00808675, 0x004A543D, 0x00707D5D, 0x00778962, 0x00718558, 0x00738758, 0x0071835A, 0x006E8057, 0x0073855C, 0x0074865D, 0x0071835A, 0x0075875E, 0x006C7E55, 0x0053653C, 0x0068725B,
        0x006F785E, 0x00535940, 0x0040442B, 0x00464930, 0x00514E39, 0x00726C59, 0x00635D4A, 0x00615745, 0x0052513C, 0x00616248, 0x007E7658, 0x00A58B67, 0x00C7A074, 0x00CCA46F, 0x00C6A469, 0x00C99E6B, 0x00CA9F6C, 0x00CBA06D, 0x00CBA06D, 0x00CBA06D,
        0x00CCA16E, 0x00CEA370, 0x00CFA471, 0x008B7B64, 0x00615D45, 0x004D553E, 0x00505643, 0x00545142, 0x00736A5D, 0x0060574D, 0x00706E63, 0x007D8A72, 0x006C7862, 0x006B7860, 0x007E8C6A, 0x00708057, 0xFF707B5A, 0xFFF6FBEC, 0xFFFFFEFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFBFF, 0xD5EBEEDF, 0x00636E46, 0x00778653, 0x007C8A60, 0x00636C51, 0x0067705C, 0x00CCD3C4, 0x00AA9CA0, 0x00695F58, 0x00625D48, 0x004F4E2C, 0x0044451E,
        0x00474526, 0x00645F4A, 0x00635B4E, 0x007F7147, 0x00AB956B, 0x00D3B388, 0x00DEB588, 0x00E1B082, 0x00E5B683, 0x00E4B581, 0x00DAAE79, 0x00C7A784, 0x00BB9C7B, 0x009A8161, 0x00745F40, 0x005C4E32, 0x005B5035, 0x005A543D, 0x0058543C, 0x004F4E32,
        0x00747359, 0x005E5D49, 0x0089897B, 0x009D9D97, 0x00818181, 0x00919197, 0x0073757D, 0x0056663D, 0x0068784F, 0x0077875E, 0x0077885D, 0x0074855A, 0x0075865A, 0x0077885C, 0x0075865A, 0x00788B5A, 0x00748657, 0x007B8C61, 0x00737E5D, 0x00454D36,
        0x0084857B, 0x00C5C3C3, 0x00979399, 0x00625B4C, 0x0067614E, 0x003D3B1D, 0x0045461F, 0x00404218, 0x003D3F15, 0x00464720, 0x00696945, 0x00AA8E5F, 0x00C9A779, 0x00D9AF82, 0x00DAA77C, 0x00E0A97E, 0x00E1AC81, 0x00DCAB7F, 0x00D9AA7E, 0x00C2A487,
        0x00A58B6D, 0x00796347, 0x00615336, 0x005D5538, 0x004F4C30, 0x003F4228, 0x003B4025, 0x006A6352, 0x00605C49, 0x00909181, 0x00898B85, 0x00919394, 0x00949696, 0x00686B5B, 0x00586140, 0x0077885C, 0x0076875B, 0x0075865B, 0x0074855A, 0x0074855A,
        0x0074845B, 0x0075855C, 0x0076865D, 0x00718558, 0x007A8864, 0x0059604B, 0x00787B72, 0x0093928E, 0x009A9792, 0x00A3A196, 0x00545444, 0x0063684B, 0x00474B2E, 0x004D4F32, 0x00555236, 0x005A5338, 0x00554A2F, 0x0073644A, 0x00A08F75, 0x00C7A675,
        0x00D5AF7F, 0x00D4A879, 0x00D4A375, 0x00D2A173, 0x00D0A475, 0x00D5AF7F, 0x00CCAB7A, 0x00A79C7C, 0x007F7655, 0x005F5739, 0x00464324, 0x004A482A, 0x00434528, 0x003C3F25, 0x00666B50, 0x005D5849, 0x007E7C71, 0x00858781, 0x00919792, 0x00727B71,
        0x004D5943, 0x006B7955, 0x0079885C, 0x0074875C, 0x0074875C, 0x0074875C, 0x0074875C, 0x0074875C, 0x0074875C, 0x0074875C, 0x0074875C, 0x006C7959, 0x004D5342, 0x00888987, 0x00918E90, 0x00989590, 0x00959388, 0x00544F46, 0x006F6964, 0x0058573B,
        0x005A573B, 0x00585136, 0x00584C30, 0x0069563B, 0x008C7458, 0x00AE9176, 0x00BFA186, 0x00D7AE77, 0x00D8A975, 0x00D2A16F, 0x00CC9B6B, 0x00CFA074, 0x00D1AA7E, 0x00C5A57C, 0x00B79E74, 0x007E796A, 0x00565240, 0x00535139, 0x00504F33, 0x00504F35,
        0x00605D48, 0x00726C5F, 0x00564F46, 0x006C6B6F, 0x00787977, 0x007F8377, 0x00515B44, 0x00637050, 0x0072845D, 0x0076885F, 0x0075875E, 0x0074865F, 0x0072845D, 0x0073855E, 0x006F815A, 0x006D7F58, 0x00768861, 0x006B7D56, 0x004A5C35, 0x008A8D8B,
        0x009D9E9C, 0x007C7A79, 0x008D8A86, 0x008E8C82, 0x00494435, 0x00817B68, 0x006D6951, 0x00655941, 0x00695E48, 0x00635A46, 0x00635947, 0x007F6F58, 0x00A58D6F, 0x00C1A17D, 0x00CFAC81, 0x00D6A771, 0x00D6A672, 0x00D5A172, 0x00D29F74, 0x00D4A67D,
        0x00CEA983, 0x00B89D78, 0x009E8B66, 0x00636051, 0x005E5D49, 0x0053543A, 0x005B5D3F, 0x005C5E40, 0x00707157, 0x0051503C, 0x00787566, 0x00929992, 0x00636C5F, 0x00626F55, 0x0078895E, 0x006F824F, 0xFF727F59, 0xFFFEFFF8, 0xFFFBF5FF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFDFF, 0xD5EBEEDF, 0x00616C44, 0x00748454, 0x00808E64, 0x00697559, 0x0057604C, 0x00909985, 0x00888277, 0x00625E4C, 0x00605F43, 0x003E401C, 0x00373A13,
        0x003E401C, 0x004D4D2F, 0x004B4A30, 0x003F3E22, 0x00635D40, 0x008E7E61, 0x00A99173, 0x00B79A7B, 0x00BEA07D, 0x00BDA07B, 0x00B69B76, 0x00A39065, 0x0088774C, 0x006D5D33, 0x0060532D, 0x005B522D, 0x00534D2A, 0x00494423, 0x00423F20, 0x0049472F,
        0x00706D58, 0x00595844, 0x00727264, 0x0083847A, 0x00737470, 0x00878A88, 0x00737877, 0x005C6C43, 0x006A7A51, 0x0076865D, 0x0075865B, 0x00728358, 0x00738458, 0x00748559, 0x00728357, 0x00738458, 0x0078895D, 0x00798A5F, 0x006F7C56, 0x004D5739,
        0x007C806D, 0x00ADAEA5, 0x008F8D8C, 0x00696154, 0x006A6451, 0x003A371B, 0x003F3E1C, 0x0043441D, 0x003E3F18, 0x00343410, 0x0042411F, 0x006C5E34, 0x0088764D, 0x00AE946C, 0x00BE9D76, 0x00BB9771, 0x00BD9973, 0x00BB9C75, 0x00B1946D, 0x008E7C57,
        0x0073633E, 0x005E502C, 0x004A411F, 0x003B3615, 0x00383919, 0x00383B1B, 0x0034391A, 0x0070685B, 0x00595543, 0x00797B68, 0x008B8F84, 0x00B1B4B2, 0x00B1B5AF, 0x00747A63, 0x00535E36, 0x00738458, 0x00738458, 0x00728357, 0x00728358, 0x00738459,
        0x0074845B, 0x0075855C, 0x0075855C, 0x00738758, 0x0072815B, 0x00646D53, 0x00BDC2B3, 0x00F9FAF1, 0x00B7B6AC, 0x007B7B6B, 0x00565743, 0x00656B4C, 0x003B4021, 0x003C3F1F, 0x003F3D1E, 0x00423D1C, 0x004C4321, 0x00605732, 0x00665A36, 0x009B8256,
        0x00B4976B, 0x00C4A176, 0x00CDA77D, 0x00CDA77D, 0x00C7A479, 0x00BB9E72, 0x00A58C60, 0x006E6740, 0x005C5730, 0x0048451F, 0x00363411, 0x003B3A18, 0x00393C1C, 0x003A3F1F, 0x005E6344, 0x0065614F, 0x00787769, 0x0075786F, 0x00838A83, 0x006F796C,
        0x00505D45, 0x006B7955, 0x0079885C, 0x0073865B, 0x0073865B, 0x0073865B, 0x0073865B, 0x0073865B, 0x0073865B, 0x0073865B, 0x0073865B, 0x005D6B49, 0x00636A55, 0x00DDDFD9, 0x00FBFAF6, 0x00B9B9AD, 0x00838371, 0x00555244, 0x006B655E, 0x00555432,
        0x004C4B29, 0x004E4928, 0x005B5230, 0x00625634, 0x006C5B3A, 0x00867350, 0x00A38F6C, 0x00BA9968, 0x00C39F6F, 0x00CDA679, 0x00CDA57B, 0x00C7A37B, 0x00BD9D79, 0x00A78F6B, 0x00917F5A, 0x00504E36, 0x00535236, 0x004F5030, 0x004A4B29, 0x00434422,
        0x004B4B2D, 0x006F6D55, 0x00595542, 0x00646464, 0x006F706C, 0x00797E6F, 0x00545F45, 0x00667452, 0x0073855E, 0x00778960, 0x00778960, 0x0074865F, 0x0071835C, 0x0073855E, 0x0071835C, 0x006F815A, 0x00768861, 0x006C7E57, 0x0051633C, 0x0070746F,
        0x00B9BAB6, 0x00DFDFD9, 0x009C9A92, 0x00757368, 0x00625D4E, 0x00716C57, 0x005A563E, 0x0059502E, 0x00595133, 0x00564F34, 0x005D553E, 0x0070634D, 0x00837258, 0x00998165, 0x00AE9172, 0x00C0A273, 0x00C5A477, 0x00C8A67B, 0x00C5A47D, 0x00B89C79,
        0x00A08B6B, 0x00807555, 0x00686344, 0x005A5749, 0x005E5C4A, 0x0055553D, 0x00525339, 0x0054553B, 0x006F6F57, 0x005B5947, 0x00959284, 0x00C5CDC2, 0x007F8979, 0x0068755B, 0x007A8B60, 0x00708350, 0xFF6D7A54, 0xFFFDFFF7, 0xFFFFFAFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFDFF, 0xD1EAEDDE, 0x00606D47, 0x00728252, 0x007F8D64, 0x00748062, 0x00525C45, 0x005F6952, 0x00636149, 0x00616046, 0x00747357, 0x00505131, 0x004F502E,
        0x00565834, 0x00494B27, 0x003F411D, 0x00454B34, 0x00464930, 0x00504B32, 0x0062573C, 0x00716347, 0x0077674A, 0x00756646, 0x00726343, 0x005C5827, 0x00534F1F, 0x004F4B1B, 0x00535023, 0x0057532A, 0x00504E26, 0x004A4820, 0x0048451F, 0x0054503D,
        0x00777360, 0x005F5D4B, 0x00616252, 0x00727565, 0x00737869, 0x00868D7E, 0x007F887B, 0x0066764D, 0x00708057, 0x0076865D, 0x0074855A, 0x00728358, 0x00738458, 0x00748559, 0x00728357, 0x0077885D, 0x0076875C, 0x00728358, 0x0078865C, 0x005E6A46,
        0x00565E40, 0x00626851, 0x005C604D, 0x00686053, 0x00746D5C, 0x004E4934, 0x004D4A2E, 0x004D4B2C, 0x00444223, 0x00373516, 0x00464426, 0x003C401C, 0x004B4B27, 0x00615D3A, 0x00766C4A, 0x00817553, 0x00817553, 0x00766C4A, 0x00685F3D, 0x00565229,
        0x004D4920, 0x004C4A22, 0x0042411B, 0x0043431F, 0x004B4C2A, 0x00454926, 0x00474A2A, 0x00776E65, 0x00595445, 0x00616350, 0x006E7364, 0x00878C83, 0x00848B7C, 0x00697152, 0x00647242, 0x00728455, 0x00728357, 0x00728357, 0x00738458, 0x00738459,
        0x0075865B, 0x0076865D, 0x0076865D, 0x00728756, 0x007A8B60, 0x00606B4B, 0x00818972, 0x00B2B6A3, 0x00878976, 0x00575943, 0x00585B41, 0x006A6D53, 0x00494D30, 0x004D4D2F, 0x00494826, 0x0043401A, 0x00433F16, 0x00534D22, 0x00544E21, 0x00655635,
        0x00756443, 0x00826D4D, 0x008E7757, 0x00957E5E, 0x008E7959, 0x007A6948, 0x005F502F, 0x004D4920, 0x0047451C, 0x003C3A12, 0x00393812, 0x003F411D, 0x003C401D, 0x00474B28, 0x00656A4A, 0x005E5A47, 0x00676755, 0x00636859, 0x00798275, 0x00768270,
        0x005E6C50, 0x00707F59, 0x0079885C, 0x0072855A, 0x0072855A, 0x0072855A, 0x0072855A, 0x0072855A, 0x0072855A, 0x0072855A, 0x0072855A, 0x00728259, 0x00626B50, 0x00ADB2A3, 0x00BEC1B2, 0x00757763, 0x004F5238, 0x00555440, 0x00716E60, 0x00464422,
        0x0043411E, 0x00474320, 0x00514D2A, 0x005B5530, 0x005C5631, 0x00615A33, 0x00655E37, 0x008C7751, 0x00957E58, 0x00A08864, 0x00A28967, 0x00927D5D, 0x00807151, 0x006A5F41, 0x004F472A, 0x00454626, 0x005E5F3D, 0x00484B24, 0x003E411A, 0x00393C15,
        0x00434422, 0x00737355, 0x005E5D41, 0x005F615B, 0x00696D62, 0x00757B68, 0x005C684A, 0x006D7B57, 0x0074865F, 0x0075875E, 0x0076885F, 0x0075875E, 0x0071835A, 0x0073855C, 0x0074865D, 0x0071835A, 0x0075875E, 0x006F8158, 0x005D6F46, 0x008A9085,
        0x00FAFEF3, 0x00DCDED2, 0x00666757, 0x00525240, 0x0055513E, 0x006B6651, 0x0058533E, 0x00484219, 0x0047411C, 0x00494627, 0x00575239, 0x00605A43, 0x00615640, 0x00685A44, 0x007B6B54, 0x00847A58, 0x00857957, 0x0087795C, 0x00887C60, 0x007F755D,
        0x0066644C, 0x004C4F39, 0x003A412C, 0x004F4C3E, 0x00575445, 0x0053523E, 0x00474631, 0x004B4A35, 0x00696854, 0x00545142, 0x00939082, 0x009AA494, 0x00677160, 0x00637155, 0x007E8F64, 0x00788B5A, 0xFF717E58, 0xFFF6FAEF, 0xFFF9F5FF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFDF9FE, 0xCEE5EADB, 0x00626F49, 0x00738256, 0x00788761, 0x007A8668, 0x00616F53, 0x005E6D4E, 0x0058573B, 0x005B5A40, 0x00787560, 0x005C5845, 0x005E5B46,
        0x00646349, 0x004A4B2B, 0x0041431F, 0x004E4E30, 0x00413F20, 0x00353213, 0x003A3312, 0x00443B19, 0x004B411F, 0x00514521, 0x00534723, 0x00434A1F, 0x00444A21, 0x0043471E, 0x0042451E, 0x0050502C, 0x00605E3B, 0x005E5C3A, 0x00544F2E, 0x005F5A4B,
        0x00716D5B, 0x00565442, 0x004C4E3A, 0x005E644D, 0x00677056, 0x00717D61, 0x00717F63, 0x006F7F56, 0x0074845B, 0x0076865D, 0x0074855A, 0x00738459, 0x0076875B, 0x0076875B, 0x00748559, 0x0075845E, 0x00728259, 0x00718257, 0x00819064, 0x00758458,
        0x0058633B, 0x004D5733, 0x004C5534, 0x00696455, 0x00757061, 0x005A5643, 0x00605D48, 0x0066654B, 0x0055543A, 0x003D3C22, 0x00444327, 0x004B5237, 0x0051563B, 0x00474A30, 0x00494A30, 0x005C5B41, 0x0057563C, 0x004B4A30, 0x00535238, 0x00505431,
        0x004F5330, 0x00454828, 0x00353719, 0x00525135, 0x0066654B, 0x0058573D, 0x0068664E, 0x00786F66, 0x005A5546, 0x00595C46, 0x00646C55, 0x00656E5A, 0x00616B54, 0x006D7850, 0x0080905A, 0x00748657, 0x00748657, 0x00748559, 0x0075865A, 0x0075865A,
        0x0076875C, 0x0077885D, 0x0077885D, 0x00718753, 0x00849667, 0x0078855F, 0x005B6646, 0x005E654A, 0x0064694E, 0x00585D3E, 0x00545939, 0x006C6B5D, 0x00555243, 0x00514D3A, 0x00565239, 0x005C593A, 0x0047441E, 0x0047431A, 0x00545125, 0x005F5C40,
        0x005C583C, 0x00565236, 0x00575035, 0x00575035, 0x00545034, 0x00534F33, 0x004E4B2F, 0x004D4B29, 0x00464422, 0x003C391A, 0x00525032, 0x00616044, 0x00515238, 0x0054553B, 0x0067674F, 0x0064624A, 0x006C6E58, 0x00676E59, 0x0079856F, 0x007D8C71,
        0x006F7E5E, 0x0076855F, 0x0077865A, 0x0072855A, 0x0072855A, 0x0072855A, 0x0072855A, 0x0072855A, 0x0072855A, 0x0072855A, 0x0072855A, 0x0075865A, 0x00636E4D, 0x0069715A, 0x0070765F, 0x005E6445, 0x004E5431, 0x0056573D, 0x00696755, 0x004F482D,
        0x00534C31, 0x00534F33, 0x00565236, 0x005A583A, 0x005C5C3E, 0x00565737, 0x004C4F2F, 0x00585033, 0x0060583B, 0x00696144, 0x006A6348, 0x005D583F, 0x0057533A, 0x0055553D, 0x00484B32, 0x00444426, 0x005F6040, 0x00505131, 0x004F5030, 0x004F4F31,
        0x0059583C, 0x0079785C, 0x005B5A40, 0x00767B6C, 0x007B816E, 0x00858E74, 0x0072805E, 0x00788761, 0x0073855C, 0x006E8057, 0x006E8057, 0x0075875E, 0x00708259, 0x0073855C, 0x0076885F, 0x0074865D, 0x0074865D, 0x0071835A, 0x00697B52, 0x00737B6A,
        0x00CBD1BE, 0x00898F78, 0x0054583F, 0x00676A51, 0x0058563E, 0x006E6954, 0x00534E39, 0x00615A39, 0x005C5738, 0x00575336, 0x00575438, 0x0058573D, 0x00535238, 0x00535238, 0x005D5C42, 0x00605E46, 0x005E5B46, 0x005D5946, 0x005B5947, 0x005B5B4B,
        0x00595C4D, 0x00555C4F, 0x00525B4E, 0x004C493B, 0x00524F40, 0x005B5849, 0x00545240, 0x00595745, 0x00737061, 0x00545142, 0x00807D6F, 0x008E9A84, 0x0076836B, 0x00758465, 0x00798960, 0x006C7E4F, 0xFF717D59, 0xFFFFFFF8, 0xFFFFFBFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFCFBFD, 0xCAE3E8D9, 0x00626E4A, 0x00738459, 0x0073825C, 0x007A8969, 0x00738262, 0x0070815C, 0x0064654B, 0x00575642, 0x00757264, 0x006B655E, 0x006A655C,
        0x00696658, 0x004A4934, 0x00414326, 0x0036381B, 0x0037391C, 0x0037391C, 0x0036381A, 0x0037391B, 0x003B3B1D, 0x003F3D1F, 0x00403C1F, 0x004B5237, 0x0052593E, 0x004C5136, 0x003C3F25, 0x00424127, 0x0059553D, 0x0066624A, 0x00645E47, 0x006D6957,
        0x006C6855, 0x0052513C, 0x004A4F34, 0x005F6748, 0x00677251, 0x0065744E, 0x00667851, 0x00708057, 0x0073835A, 0x0073835A, 0x00728358, 0x00738459, 0x0075865A, 0x0076875B, 0x0075865A, 0x006F7D59, 0x0076865D, 0x0075865A, 0x00758556, 0x00768656,
        0x00768355, 0x006F7B51, 0x005E6941, 0x00605C49, 0x006F6B59, 0x006B6755, 0x00777360, 0x0074705D, 0x00535139, 0x00343319, 0x003B3A20, 0x00524F3A, 0x00565540, 0x0051503B, 0x0052513C, 0x005A5944, 0x0053503B, 0x004C4934, 0x005C5742, 0x005C5F49,
        0x00585B45, 0x00494A36, 0x00353622, 0x00504E3C, 0x00696455, 0x005C5649, 0x006B6558, 0x007A7167, 0x00524F3A, 0x004B5132, 0x00646F4F, 0x00667256, 0x00687555, 0x00758256, 0x0076884D, 0x00748657, 0x00758758, 0x00758758, 0x0075865A, 0x0075865A,
        0x0075865A, 0x0074855A, 0x0074855A, 0x00738857, 0x006D7F50, 0x007A885E, 0x0073805A, 0x0067714D, 0x00686F4C, 0x005B613E, 0x004F5532, 0x006F6865, 0x00655F5A, 0x00696259, 0x006D6657, 0x0066614C, 0x00413C23, 0x003E3A1D, 0x00524D2C, 0x00605F4A,
        0x00595B45, 0x00585A44, 0x00545741, 0x004A4D37, 0x00444630, 0x004B4D37, 0x005F5E49, 0x00615C47, 0x00514C37, 0x003B3724, 0x00534F3C, 0x006D6957, 0x00676253, 0x00646153, 0x00676456, 0x00525135, 0x005F6346, 0x005D6749, 0x00637253, 0x006C7D5C,
        0x006D7E59, 0x0074845B, 0x00768559, 0x0072855A, 0x0072855A, 0x0072855A, 0x0072855A, 0x0072855A, 0x0072855A, 0x0072855A, 0x0072855A, 0x00748657, 0x0076825E, 0x00616B4D, 0x005D6546, 0x005E673F, 0x004D552C, 0x00545638, 0x0072715D, 0x006A5F51,
        0x006A5F51, 0x00685F51, 0x00645D4C, 0x005A5644, 0x0054533F, 0x00585945, 0x00626450, 0x00535139, 0x00504E36, 0x00494931, 0x004C4F39, 0x004C4F39, 0x004A5039, 0x004D503A, 0x003D402A, 0x0045432B, 0x0053503B, 0x005B5744, 0x0064604E, 0x00605C4A,
        0x00676351, 0x006F6B59, 0x0054503E, 0x0059614A, 0x0060694E, 0x006E7959, 0x006B7A54, 0x0076875C, 0x0075885D, 0x0076885F, 0x00798B64, 0x0076885F, 0x0071835A, 0x0073855C, 0x00778960, 0x0075875E, 0x0073855C, 0x0073855C, 0x0071835A, 0x00677258,
        0x00677055, 0x005C6544, 0x00505734, 0x004D5232, 0x00555438, 0x006E6A52, 0x006F6956, 0x00675F4E, 0x0068614E, 0x005E5841, 0x00535034, 0x00545436, 0x00575A3A, 0x00515835, 0x004C5632, 0x0057503F, 0x00514C3D, 0x00494637, 0x00474638, 0x00555348,
        0x00656358, 0x0069675D, 0x00646258, 0x0052503E, 0x00545240, 0x006B6859, 0x006D6A5B, 0x00696657, 0x007B7869, 0x00585644, 0x006E6C5A, 0x006F7E5F, 0x00707E62, 0x007A8969, 0x00798960, 0x00697B4C, 0xFF717D59, 0xFFFDFFF5, 0xFFFCF9FF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFEFF, 0xC6DFE6D7, 0x005C6A48, 0x0076865D, 0x0071825D, 0x00788767, 0x00758762, 0x0072865B, 0x006A6B51, 0x004E4D38, 0x00656253, 0x0069645B, 0x00676259,
        0x00625F51, 0x00484733, 0x00404028, 0x00474D3C, 0x00454F3E, 0x00445240, 0x00465645, 0x004F6150, 0x005B6B5A, 0x005D6858, 0x00576151, 0x00414532, 0x004E503D, 0x00535542, 0x004A4A38, 0x0044432F, 0x004C4B37, 0x00625E4B, 0x00716D5A, 0x0067654D,
        0x00605E46, 0x00545639, 0x00595F40, 0x006E7854, 0x00748259, 0x006F8055, 0x006F8356, 0x006E7E55, 0x006E7E55, 0x006F7F56, 0x00708156, 0x00718257, 0x00738458, 0x00748559, 0x00748559, 0x00768460, 0x0077875E, 0x0077885C, 0x00718152, 0x00748454,
        0x007B885A, 0x007B885C, 0x0069744C, 0x00605F45, 0x006E6C54, 0x00777360, 0x00827E6C, 0x00777360, 0x00595641, 0x0049482E, 0x0059583C, 0x006C614B, 0x00625A43, 0x00716D55, 0x00918F77, 0x00A0A088, 0x009D9B83, 0x0088826B, 0x006E664F, 0x00696A56,
        0x005E5F4B, 0x00575745, 0x004C493A, 0x00535042, 0x006D695E, 0x00777368, 0x00807970, 0x00726C59, 0x0058583A, 0x00586139, 0x00728057, 0x0072805C, 0x00778561, 0x007E8B5D, 0x00788950, 0x00738655, 0x00738655, 0x00748657, 0x00748657, 0x00748559,
        0x00738458, 0x00728357, 0x00728358, 0x00798D60, 0x00718256, 0x0078865C, 0x0078865C, 0x00768159, 0x0079815C, 0x006B724D, 0x00595F3C, 0x006A615D, 0x006F6760, 0x00827B72, 0x007D776A, 0x00655E4D, 0x0049442F, 0x0058543B, 0x005D5940, 0x006C6954,
        0x00656751, 0x0072755F, 0x007B836C, 0x007A826B, 0x0071745E, 0x00676953, 0x00706D58, 0x0063624E, 0x005B5A46, 0x00474533, 0x00524F40, 0x006F695C, 0x00787267, 0x00767065, 0x00696259, 0x005A5B3B, 0x006D7350, 0x006F7B57, 0x006A7C55, 0x006F8359,
        0x0072845B, 0x00738459, 0x00748258, 0x0073865B, 0x0073865B, 0x0073865B, 0x0073865B, 0x0073865B, 0x0073865B, 0x0073865B, 0x0073865B, 0x0076875B, 0x007D8A64, 0x0075805F, 0x007A855F, 0x00778156, 0x005A6338, 0x0056583A, 0x006D6B59, 0x00786C62,
        0x007A7164, 0x00776E61, 0x006A6255, 0x00605B4C, 0x00625D4E, 0x00646250, 0x00656351, 0x0065624D, 0x006F6E59, 0x006A6D57, 0x00696F58, 0x0060694F, 0x005A6047, 0x00676A51, 0x00696951, 0x00595641, 0x00565240, 0x00635D50, 0x00756F64, 0x00756E65,
        0x007C766B, 0x00706A5D, 0x005B5647, 0x006C7757, 0x00717C5B, 0x0078855F, 0x0075865B, 0x0077885C, 0x0072855A, 0x0072845B, 0x0072845D, 0x0076895E, 0x0073865B, 0x0074875C, 0x00778A5F, 0x0076895E, 0x0073865B, 0x0073865B, 0x0074875C, 0x007C8969,
        0x006E7A56, 0x00778359, 0x00677146, 0x004B532A, 0x00565737, 0x0068644C, 0x007F7867, 0x007F786F, 0x007D7568, 0x0068614D, 0x00545034, 0x00595735, 0x00656743, 0x00656D48, 0x00616C46, 0x00776D5C, 0x00857E6D, 0x008B8775, 0x007B7967, 0x006C695A,
        0x006D6657, 0x0073685A, 0x00776A5C, 0x0056563E, 0x00585742, 0x00706E5C, 0x00767364, 0x00696657, 0x00747260, 0x00605F4A, 0x0073735B, 0x007A8B66, 0x00768664, 0x00798967, 0x00798960, 0x006C7D51, 0xFF707C58, 0xFFFAFEF2, 0xFFFFFDFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFDFFFF, 0xC2DDE4D5, 0x005A6846, 0x00758760, 0x0072835E, 0x00748564, 0x0073865F, 0x006E8454, 0x006C724F, 0x004B5030, 0x004A4E31, 0x00474A30, 0x00464930,
        0x004A4D33, 0x00404427, 0x00404526, 0x00353523, 0x00282E1D, 0x001C2816, 0x001B2B19, 0x00273928, 0x00304231, 0x00303D2F, 0x002A3326, 0x002D2C17, 0x002D2C17, 0x0032311C, 0x003B3B23, 0x0042422A, 0x0045462C, 0x0048492F, 0x00494C32, 0x004A4A2C,
        0x004D4E2E, 0x00525633, 0x005F6742, 0x006C774F, 0x006F7D53, 0x006D7E52, 0x006C8051, 0x006D7D54, 0x006E7E55, 0x00708057, 0x00728358, 0x00738459, 0x00738458, 0x00748559, 0x0075865A, 0x00798862, 0x0075855C, 0x007A8B5F, 0x007A8A5B, 0x007F8F60,
        0x007B875D, 0x007C875F, 0x0079835F, 0x00646747, 0x00585A3D, 0x0053533B, 0x005B5A46, 0x00605F4B, 0x005A5A42, 0x00535538, 0x00575A3A, 0x0054492E, 0x003E371C, 0x004A492D, 0x006C7053, 0x007E8366, 0x00818366, 0x006A674B, 0x00423B20, 0x00423F23,
        0x004A472B, 0x005C583F, 0x00626048, 0x00615F47, 0x0064634E, 0x0062614D, 0x00585945, 0x00514E32, 0x005B5E37, 0x00697543, 0x00798959, 0x00728259, 0x0074835D, 0x00768357, 0x007B8B56, 0x00748756, 0x00758857, 0x00768958, 0x00768859, 0x00768859,
        0x0076875B, 0x0075865A, 0x0075865A, 0x006A7C53, 0x00798A5F, 0x0079875D, 0x00717F55, 0x00737F55, 0x007C855D, 0x00747B56, 0x00555B38, 0x005B5843, 0x005B5843, 0x00615F47, 0x00616046, 0x00616046, 0x005D5C40, 0x00676749, 0x0059593B, 0x00494229,
        0x00545037, 0x0075785E, 0x0092977C, 0x009A9F84, 0x0084876D, 0x005D5940, 0x00494229, 0x004F5336, 0x00585C3F, 0x00595A40, 0x005F5F47, 0x006C6C54, 0x0073705B, 0x00696552, 0x005B5744, 0x005D5F3B, 0x00707850, 0x0076845A, 0x00708457, 0x0074895C,
        0x00768A5D, 0x00738458, 0x0079875D, 0x0074875C, 0x0074875C, 0x0074875C, 0x0074875C, 0x0074875C, 0x0074875C, 0x0074875C, 0x0074875C, 0x0074855A, 0x00717D59, 0x00737E5D, 0x007A855D, 0x007C8759, 0x006C754A, 0x00585A3C, 0x00585546, 0x006A6550,
        0x00726D58, 0x00716A56, 0x0067614A, 0x0067614A, 0x006E6950, 0x00666148, 0x00555037, 0x00635B44, 0x00959179, 0x00A9AC92, 0x00A9AE93, 0x00868B70, 0x00585C3F, 0x00585539, 0x0060593E, 0x006E6E50, 0x006D6C52, 0x006F6B58, 0x007B7667, 0x00787265,
        0x00746F60, 0x005F5C47, 0x00535139, 0x00707D57, 0x0075835A, 0x0078875B, 0x00768859, 0x00758758, 0x00728659, 0x0074865D, 0x0074865F, 0x0075885D, 0x0075885D, 0x0075885D, 0x0076895E, 0x0076895E, 0x0074875C, 0x0073865B, 0x0073865B, 0x0074835D,
        0x00839167, 0x00788656, 0x006C7945, 0x00576132, 0x00535531, 0x0058543C, 0x00635C4D, 0x00616252, 0x00676652, 0x0068634A, 0x00696143, 0x006A6244, 0x005F5B3E, 0x004E4D31, 0x0043462D, 0x00767259, 0x00949379, 0x00A4A78D, 0x008C9176, 0x00606349,
        0x004E4A31, 0x005E543C, 0x00756750, 0x00686A4C, 0x0067694C, 0x006E6D58, 0x006C6A58, 0x005C5A48, 0x005E5D48, 0x00595B3E, 0x00747658, 0x00798C61, 0x00748560, 0x00778863, 0x007B8B62, 0x00738458, 0xFF717D59, 0xFFF6FBEC, 0xFFFCFBFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF9FBFB, 0xBEDBE2D3, 0x005A6747, 0x00758760, 0x0071815F, 0x00728361, 0x0073875D, 0x006F8554, 0x00818B5D, 0x00677045, 0x00596237, 0x004E562D, 0x004C542B,
        0x00515931, 0x004A522A, 0x004B522D, 0x00564B2D, 0x00544C2E, 0x004F4F31, 0x004A5233, 0x00485234, 0x00454C31, 0x0043462C, 0x00444329, 0x00464327, 0x00484529, 0x004A4A2C, 0x004E4E30, 0x004D5030, 0x004B512E, 0x004B512E, 0x004B522F, 0x00494A28,
        0x00555733, 0x00656945, 0x00717A52, 0x00717D53, 0x006E7D51, 0x00708155, 0x006C8051, 0x00708057, 0x00728259, 0x0074845B, 0x0076875C, 0x0077885D, 0x0076875B, 0x0076875B, 0x0077885C, 0x0071805A, 0x00798960, 0x00809165, 0x00758458, 0x007B8A5E,
        0x007C875F, 0x007F8965, 0x007E8667, 0x007B7F5B, 0x00696C4C, 0x00606147, 0x005E5D48, 0x005E5D49, 0x00606048, 0x00616345, 0x00606441, 0x006C6446, 0x00636041, 0x005E6343, 0x005A6544, 0x00545F3E, 0x00535C3B, 0x005B5E3E, 0x00605E3F, 0x00615C35,
        0x0069633E, 0x0063603A, 0x005C5C38, 0x005D5E3C, 0x00595C3C, 0x00575C3D, 0x005A5F40, 0x00676546, 0x00797D53, 0x007B8953, 0x007A8C57, 0x0077885D, 0x007C8B65, 0x00768258, 0x00818F5F, 0x00778A59, 0x00788B5A, 0x00798C5B, 0x007A8C5D, 0x007B8D5E,
        0x007B8D5E, 0x007B8C60, 0x007A8B5F, 0x007C8E67, 0x007B8A64, 0x00738157, 0x007B895F, 0x007C885E, 0x007C855D, 0x00838966, 0x00707555, 0x00545632, 0x005A5C38, 0x004F512D, 0x00484A26, 0x00555733, 0x004C4E2A, 0x004F512D, 0x00484C28, 0x00584D31,
        0x00524C2F, 0x00525234, 0x00474C2D, 0x00454A2B, 0x004F4F31, 0x00524C2F, 0x005C5135, 0x00465026, 0x004F572F, 0x00535B33, 0x00535733, 0x00525633, 0x00515232, 0x00515133, 0x00575537, 0x0070734C, 0x007C845B, 0x007D8C60, 0x00728657, 0x00758B5A,
        0x00768A5B, 0x0075865A, 0x00839167, 0x0075885D, 0x0075885D, 0x0075885D, 0x0075885D, 0x0075885D, 0x0075885D, 0x0075885D, 0x0075885D, 0x0073835A, 0x00788460, 0x007D8867, 0x0077825A, 0x007D8959, 0x007D865B, 0x00626447, 0x00585547, 0x00504E2F,
        0x004D4B2C, 0x004F4E2C, 0x00575533, 0x00585332, 0x00514B28, 0x004B4522, 0x004D4422, 0x004B3F27, 0x005A533A, 0x0049482C, 0x00484C2F, 0x004B5031, 0x00424021, 0x00494123, 0x004E4325, 0x00464922, 0x00565735, 0x004F4E32, 0x0053503B, 0x004E4B36,
        0x004D4B33, 0x00545436, 0x00676846, 0x0078865D, 0x007C8B5F, 0x007C8C5D, 0x00798C5B, 0x00758857, 0x0073875A, 0x00778960, 0x00758760, 0x0075885D, 0x0076895E, 0x0075885D, 0x0075885D, 0x0075885D, 0x0074875C, 0x0072855A, 0x0072855A, 0x0076875C,
        0x00778758, 0x007F8F5A, 0x007E8C56, 0x0065703E, 0x00666942, 0x005A563E, 0x00514A3B, 0x004A5037, 0x004A4E31, 0x004F4C2D, 0x005B5231, 0x005E5436, 0x00524830, 0x00494130, 0x004E483D, 0x00494B2D, 0x00454A2B, 0x00404829, 0x003F4A2A, 0x00424B2A,
        0x00464929, 0x004D4829, 0x00524729, 0x004B4F2C, 0x004C4E30, 0x004A4A32, 0x004D4C38, 0x004D4C38, 0x0056563E, 0x00606244, 0x00878B68, 0x00798D60, 0x00798B64, 0x007C8D68, 0x007A8A61, 0x00728358, 0xFF747F5E, 0xFFF9FEEF, 0xFFFFFEFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFEFF, 0xBEDBDFD3, 0x00596444, 0x0077875E, 0x00788662, 0x00778765, 0x0071835C, 0x0073875A, 0x00718459, 0x00708358, 0x00708358, 0x006F8257, 0x006D8055,
        0x006B7E53, 0x006A7D52, 0x00697C51, 0x006B7C50, 0x006C7D51, 0x006D7E52, 0x006E7F53, 0x006E7F53, 0x006E7F53, 0x006E7F53, 0x006D7E52, 0x00697A4E, 0x0068794D, 0x0068794D, 0x0067784C, 0x0066774B, 0x0066774B, 0x0065764A, 0x0065764A, 0x0066764D,
        0x0066764D, 0x0066764D, 0x0067774E, 0x006A7A51, 0x006D7D54, 0x00708057, 0x00728259, 0x00728259, 0x00728259, 0x0073835A, 0x0073835A, 0x0074845B, 0x0074845B, 0x0075855C, 0x0075855C, 0x0077875E, 0x0078885F, 0x0078885F, 0x0078885F, 0x0078885F,
        0x00798960, 0x00798960, 0x00798960, 0x007B8B62, 0x007C8C63, 0x007C8C63, 0x007D8D64, 0x007E8E65, 0x007E8E65, 0x007F8F66, 0x007F8F66, 0x00829066, 0x00819064, 0x007F8E62, 0x007D8C60, 0x007B8B5C, 0x0079895A, 0x00778757, 0x00768656, 0x0083936A,
        0x00829269, 0x007F8F66, 0x007D8D64, 0x007B8B62, 0x007B8B62, 0x007C8C63, 0x007D8D64, 0x0076865D, 0x0076865D, 0x0076865D, 0x0076865D, 0x0076865D, 0x0076865D, 0x0076865D, 0x0076865D, 0x0076865D, 0x0077875E, 0x0077875E, 0x0077875E, 0x0078885F,
        0x0078885F, 0x0078885F, 0x00798960, 0x007A8B5F, 0x00798A5E, 0x0077885C, 0x0076875B, 0x0076875B, 0x0077885C, 0x00798A5E, 0x007A8B5F, 0x00778563, 0x00788664, 0x00788664, 0x00798765, 0x007A8866, 0x007A8866, 0x007B8967, 0x007B8967, 0x007C8B65,
        0x00798862, 0x0075845E, 0x0072815B, 0x0071805A, 0x0072815B, 0x0075845E, 0x00778660, 0x007B8965, 0x007B8965, 0x007A8864, 0x007A8864, 0x007A8864, 0x007A8864, 0x007A8864, 0x007A8864, 0x007C8B65, 0x007A8963, 0x00788761, 0x00778660, 0x00778660,
        0x00788761, 0x007A8963, 0x007C8B65, 0x00758760, 0x00758760, 0x00758760, 0x00758760, 0x00758760, 0x00758760, 0x00758760, 0x00758760, 0x00798F5F, 0x00788E5E, 0x00768C5C, 0x00768C5C, 0x00778D5D, 0x00758B5B, 0x00728858, 0x006F8555, 0x00707D5D,
        0x00717E5E, 0x00738060, 0x00738060, 0x00738060, 0x00717E5E, 0x006F7C5C, 0x006E7B5B, 0x00718047, 0x006D7B45, 0x006A7743, 0x006D7949, 0x00737E50, 0x00788258, 0x00778058, 0x00747D55, 0x00737B5C, 0x00707859, 0x006D7556, 0x006C7455, 0x006E7657,
        0x00737B5C, 0x00798162, 0x007D8566, 0x00778A59, 0x00778A59, 0x00768958, 0x00768958, 0x00768958, 0x00768958, 0x00758857, 0x00758857, 0x00778A59, 0x00778A59, 0x00778A59, 0x00778A59, 0x00778A59, 0x00778A59, 0x00778A59, 0x00778A59, 0x00778660,
        0x00788761, 0x007A8963, 0x007A8963, 0x00788761, 0x0074835D, 0x006F7E58, 0x006B7A54, 0x006C7554, 0x006D7655, 0x006F7857, 0x00717A59, 0x00717A59, 0x00717A59, 0x006F7857, 0x006F7857, 0x00656F41, 0x00677045, 0x006A7249, 0x006D754D, 0x006F7552,
        0x00707555, 0x00707457, 0x00707457, 0x006C785A, 0x00697557, 0x00667254, 0x00677355, 0x006C785A, 0x00737F61, 0x00798567, 0x007C886A, 0x0078895E, 0x007E8C68, 0x00768462, 0x007B8A64, 0x00748559, 0xFF73825C, 0xFFF3FCE7, 0xFFFDFFFC, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFBFAFE, 0xBEDEE3D4, 0x005D6945, 0x00768859, 0x0074855A, 0x006F805B, 0x006D7F58, 0x00718459, 0x0072845D, 0x0072845D, 0x0072845D, 0x0072845D, 0x0072845D,
        0x0071835C, 0x0070825B, 0x0070825B, 0x00728259, 0x00718158, 0x00718158, 0x00708057, 0x006F7F56, 0x006E7E55, 0x006E7E55, 0x006D7D54, 0x006E7E55, 0x006D7D54, 0x006D7D54, 0x006C7C53, 0x006B7B52, 0x006B7B52, 0x006A7A51, 0x006A7A51, 0x006C7D52,
        0x006B7C51, 0x006B7C51, 0x006B7C51, 0x006C7D52, 0x006E7F54, 0x00708156, 0x00718257, 0x00718257, 0x00718257, 0x00728358, 0x00738459, 0x00738459, 0x0074855A, 0x0075865B, 0x0075865B, 0x0078895E, 0x0078895E, 0x0078895E, 0x00798A5F, 0x00798A5F,
        0x00798A5F, 0x00798A5F, 0x00798A5F, 0x007C8D62, 0x007C8D62, 0x007C8D62, 0x007C8D62, 0x007D8E63, 0x007D8E63, 0x007D8E63, 0x007D8E63, 0x007F8E62, 0x007F8E62, 0x007F8F60, 0x007F8F60, 0x007F8F5F, 0x007F8F5F, 0x007F8F5F, 0x007E8F5C, 0x007B8C61,
        0x007B8C61, 0x007D8E63, 0x007E8F64, 0x007F9065, 0x007E8F64, 0x007E8F64, 0x007D8E63, 0x007C8D62, 0x007C8D62, 0x007C8D62, 0x007C8D62, 0x007C8D62, 0x007C8D62, 0x007C8D62, 0x007C8D62, 0x0077885D, 0x0078895E, 0x0078895E, 0x0078895E, 0x0078895E,
        0x0078895E, 0x0078895E, 0x0078895E, 0x007C8B65, 0x007B8A64, 0x007A8963, 0x00798862, 0x00798862, 0x007A8963, 0x007B8A64, 0x007C8B65, 0x007C8B65, 0x007C8B65, 0x007D8C66, 0x007D8C66, 0x007E8D67, 0x007F8E68, 0x007F8E68, 0x007F8E68, 0x0084946B,
        0x0083936A, 0x00819168, 0x007F8F66, 0x007E8E65, 0x007F8F66, 0x00809067, 0x00819168, 0x007F8F66, 0x007F8F66, 0x007F8F66, 0x007E8E65, 0x007E8E65, 0x007E8E65, 0x007D8D64, 0x007D8D64, 0x007C8C63, 0x007B8B62, 0x007A8A61, 0x0078885F, 0x0078885F,
        0x0078885F, 0x0078885F, 0x00798960, 0x00788A61, 0x00788A61, 0x00788A61, 0x00798B62, 0x00798B62, 0x007A8C63, 0x007A8C63, 0x007A8C63, 0x00778B61, 0x00768A60, 0x0075895F, 0x00768A60, 0x00788C62, 0x00798D63, 0x00798D63, 0x00788C62, 0x0082916B,
        0x0082916B, 0x0083926C, 0x0083926C, 0x0082916B, 0x0081906A, 0x007F8E68, 0x007E8D67, 0x00818F5F, 0x007E8C5C, 0x007C895B, 0x007E8A60, 0x00838E66, 0x0086906C, 0x00858E6D, 0x00848D6C, 0x00828F69, 0x00828F69, 0x00818E68, 0x00808D67, 0x007F8C66,
        0x007D8A64, 0x007C8963, 0x007B8862, 0x0078885F, 0x0077875E, 0x0077875E, 0x0077875E, 0x0077875E, 0x0076865D, 0x0076865D, 0x0076865D, 0x0077875E, 0x0077875E, 0x0077875E, 0x0077875E, 0x0077875E, 0x0077875E, 0x0077875E, 0x0077875E, 0x0075855C,
        0x0077875E, 0x00798960, 0x007C8C63, 0x007D8D64, 0x007E8E65, 0x007D8D64, 0x007D8D64, 0x007F8C66, 0x00808D67, 0x00828F69, 0x0083906A, 0x0083906A, 0x00828F69, 0x00818E68, 0x00808D67, 0x007F8B5B, 0x00808B5D, 0x00828C61, 0x00858F65, 0x00868F67,
        0x00878E6B, 0x00868D6C, 0x00868D6C, 0x00818F6B, 0x007F8D69, 0x007D8B67, 0x007B8965, 0x007B8965, 0x007C8A66, 0x007E8C68, 0x007E8C68, 0x007C8C63, 0x00818F6D, 0x00798567, 0x007E8C6A, 0x0072815B, 0xFF727F5F, 0xFFF4FBEE, 0xFFFAFBFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFDFCFE, 0xC6E2E8D7, 0x00616F45, 0x00758954, 0x00798C5B, 0x0073855C, 0x0074865F, 0x0076885F, 0x0070815C, 0x0070815C, 0x0071825D, 0x0071825D, 0x0070815C,
        0x0070815C, 0x006F805B, 0x006F805B, 0x0071805A, 0x006F7E58, 0x006D7C56, 0x006B7A54, 0x006A7953, 0x006A7953, 0x006A7953, 0x006A7953, 0x006C7B55, 0x006C7B55, 0x006C7B55, 0x006C7B55, 0x006C7B55, 0x006C7B55, 0x006C7B55, 0x006C7B55, 0x006E7F53,
        0x006D7E52, 0x006C7D51, 0x006C7D51, 0x006C7D51, 0x006D7E52, 0x006E7F53, 0x006F8054, 0x00708155, 0x00708155, 0x00718256, 0x00728357, 0x00738458, 0x00748559, 0x0075865A, 0x0075865A, 0x0075865A, 0x0075865A, 0x0076875B, 0x0076875B, 0x0076875B,
        0x0076875B, 0x0077885C, 0x0077885C, 0x00798A5E, 0x00798A5E, 0x00798A5E, 0x00798A5E, 0x0078895D, 0x0078895D, 0x0078895D, 0x0078895D, 0x007A8A5B, 0x007B8B5C, 0x007B8B5C, 0x007C8C5C, 0x007D8D5D, 0x007E8F5C, 0x007E8F5C, 0x007E8F5C, 0x0078895D,
        0x00798A5E, 0x007A8B5F, 0x007B8C60, 0x007A8B5F, 0x00798A5E, 0x0077885C, 0x0076875B, 0x0077885C, 0x0077885C, 0x0077885C, 0x0077885C, 0x0077885C, 0x0077885C, 0x0077885C, 0x0077885C, 0x00798A5E, 0x00798A5E, 0x00798A5E, 0x00798A5E, 0x00798A5E,
        0x0078895D, 0x0078895D, 0x0078895D, 0x00798765, 0x00798765, 0x00788664, 0x00778563, 0x00778563, 0x00788664, 0x00798765, 0x00798765, 0x007C8C63, 0x007C8C63, 0x007C8C63, 0x007D8D64, 0x007D8D64, 0x007E8E65, 0x007E8E65, 0x007E8E65, 0x007B8C60,
        0x007B8C60, 0x007B8C60, 0x007B8C60, 0x007B8C60, 0x007B8C60, 0x007A8B5F, 0x007A8B5F, 0x007D8E63, 0x007D8E63, 0x007E8F64, 0x007E8F64, 0x007E8F64, 0x007D8E63, 0x007C8D62, 0x007B8C61, 0x00798A5E, 0x00798A5E, 0x00798A5E, 0x0078895D, 0x0078895D,
        0x0078895D, 0x0078895D, 0x0078895D, 0x0074885B, 0x0075895C, 0x0075895C, 0x00768A5D, 0x00778B5E, 0x00788C5F, 0x00788C5F, 0x00798D60, 0x00758563, 0x00748462, 0x00738361, 0x00748462, 0x00768664, 0x00788866, 0x007A8A68, 0x007A8A68, 0x007E8F63,
        0x007E8F63, 0x007D8E62, 0x007D8E62, 0x007C8D61, 0x007C8D61, 0x007B8C60, 0x007B8C60, 0x007A8B60, 0x00798A5F, 0x0078885F, 0x00798862, 0x007B8965, 0x007D8B69, 0x007D8A6A, 0x007C886A, 0x00778B5E, 0x00788C5F, 0x007B8F62, 0x007C9063, 0x007C9063,
        0x007A8E61, 0x00778B5E, 0x00768A5D, 0x00798763, 0x00798763, 0x00798763, 0x00798763, 0x00798763, 0x00788662, 0x00788662, 0x00788662, 0x00798763, 0x00798763, 0x00798763, 0x00798763, 0x00798763, 0x00798763, 0x00798763, 0x00798763, 0x00798A5E,
        0x00798A5E, 0x007A8B5F, 0x007B8C60, 0x007D8E62, 0x007F9064, 0x00809165, 0x00819266, 0x007D9162, 0x007E9263, 0x007F9364, 0x007F9364, 0x007F9364, 0x007E9263, 0x007D9162, 0x007C9061, 0x007C8D5A, 0x007D8D5D, 0x007E8E5F, 0x007F8E62, 0x00808E64,
        0x007F8D64, 0x007F8C66, 0x007E8B65, 0x007B8C61, 0x007C8D62, 0x007D8E63, 0x007E8F64, 0x007D8E63, 0x007D8E63, 0x007C8D62, 0x007C8D62, 0x007B8C61, 0x007F8D69, 0x00798666, 0x007F8C6C, 0x006E7C5A, 0xFF788369, 0xFFFDFFFB, 0xFFFDFCFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFDFF, 0xBADEE4D1, 0x00617044, 0x006F844D, 0x007E915E, 0x007B8D64, 0x00788866, 0x0071825D, 0x0077885D, 0x0077885D, 0x0077885D, 0x0076875C, 0x0075865B,
        0x0074855A, 0x00728358, 0x00718257, 0x00718256, 0x00708155, 0x006F8054, 0x006F8054, 0x006E7F53, 0x006E7F53, 0x006E7F53, 0x006F8054, 0x006C7D51, 0x006C7D51, 0x006C7D51, 0x006D7E52, 0x006D7E52, 0x006E7F53, 0x006E7F53, 0x006E7F53, 0x006D7E53,
        0x006D7E53, 0x006D7E53, 0x006D7E53, 0x006E7F54, 0x006F8055, 0x00708156, 0x00718257, 0x00738459, 0x00738459, 0x0074855A, 0x0075865B, 0x0076875C, 0x0077885D, 0x0078895E, 0x0078895E, 0x00798A5F, 0x00798A5F, 0x00798A5F, 0x007A8B60, 0x007A8B60,
        0x007A8B60, 0x007A8B60, 0x007A8B60, 0x007C8D62, 0x007C8D62, 0x007C8D62, 0x007C8D62, 0x007C8D62, 0x007C8D62, 0x007C8D62, 0x007C8D62, 0x007E8C62, 0x007E8C62, 0x007E8D61, 0x007E8D61, 0x007E8E5F, 0x007E8E5F, 0x007D8D5E, 0x007D8D5D, 0x007F9065,
        0x007E8F64, 0x007C8D62, 0x007B8C61, 0x007A8B60, 0x007B8C61, 0x007B8C61, 0x007C8D62, 0x007B8C61, 0x007B8C61, 0x007B8C61, 0x007B8C61, 0x007B8C61, 0x007B8C61, 0x007B8C61, 0x007B8C61, 0x007C8D62, 0x007C8D62, 0x007B8C61, 0x007B8C61, 0x007A8B60,
        0x007A8B60, 0x007A8B60, 0x007A8B60, 0x007A8864, 0x007A8864, 0x00798763, 0x00788662, 0x00788662, 0x00798763, 0x007A8864, 0x007A8864, 0x007C8C63, 0x007C8C63, 0x007C8C63, 0x007D8D64, 0x007D8D64, 0x007D8D64, 0x007E8E65, 0x007E8E65, 0x007B8C61,
        0x007C8D62, 0x007D8E63, 0x007E8F64, 0x007E8F64, 0x007E8F64, 0x007E8F64, 0x007D8E63, 0x007D8D64, 0x007E8E65, 0x007F8F66, 0x00809067, 0x007F8F66, 0x007E8E65, 0x007C8C63, 0x007B8B62, 0x007C8D62, 0x007C8D62, 0x007C8D62, 0x007C8D62, 0x007C8D62,
        0x007D8E63, 0x007D8E63, 0x007E8F64, 0x007A8B60, 0x007A8B60, 0x007A8B60, 0x007A8B60, 0x007B8C61, 0x007B8C61, 0x007C8D62, 0x007C8D62, 0x007B8D66, 0x007A8C65, 0x007A8C65, 0x007A8C65, 0x007A8C65, 0x007B8D66, 0x007B8D66, 0x007C8E67, 0x007E9061,
        0x007E9061, 0x007D8F60, 0x007D8F60, 0x007D8F60, 0x007D8F60, 0x007E9061, 0x007E9061, 0x007B8E63, 0x007B8E63, 0x007B8D64, 0x007B8D64, 0x007B8D66, 0x007C8D68, 0x007C8D68, 0x007C8D68, 0x007B9161, 0x007B9161, 0x007B9161, 0x007A9060, 0x00798F5F,
        0x00788E5E, 0x00778D5D, 0x00778D5D, 0x00798862, 0x00798862, 0x00788761, 0x00788761, 0x00788761, 0x00788761, 0x00778660, 0x00778660, 0x00788761, 0x00788761, 0x00788761, 0x00788761, 0x00788761, 0x00788761, 0x00788761, 0x00788761, 0x007B8C60,
        0x007B8C60, 0x007A8B5F, 0x007A8B5F, 0x007A8B5F, 0x007B8C60, 0x007B8C60, 0x007C8D61, 0x007A905F, 0x007A905F, 0x007B9160, 0x007B9160, 0x007A905F, 0x00798F5E, 0x00788E5D, 0x00788E5D, 0x007D9162, 0x007D9162, 0x007E9263, 0x007E9265, 0x007D9065,
        0x007C8F64, 0x007B8D64, 0x007B8D64, 0x007F9162, 0x00819364, 0x00839566, 0x00829465, 0x00809263, 0x007D8F60, 0x007C8E5F, 0x007B8D5E, 0x00778A57, 0x007E8F64, 0x007E8D67, 0x0084936D, 0x006D7D54, 0xFF7B8769, 0xFFFBFFF6, 0xFFF6F5FE, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFEFF, 0xB7DAE0CF, 0x00626F49, 0x005D6F40, 0x0067774E, 0x006A7959, 0x006C7A5E, 0x00697859, 0x006B7C50, 0x006B7C50, 0x006B7C50, 0x006A7B4F, 0x00697A4E,
        0x0068794D, 0x0067784C, 0x0066774B, 0x00667849, 0x00667849, 0x00667849, 0x00667849, 0x00667849, 0x00657748, 0x00647647, 0x00637546, 0x00667849, 0x00667849, 0x00657748, 0x00647647, 0x00637546, 0x00627445, 0x00627445, 0x00617344, 0x00677553,
        0x00677553, 0x00677553, 0x00677553, 0x00677553, 0x00687654, 0x00697755, 0x00697755, 0x006C7A58, 0x006C7A58, 0x006D7B59, 0x006E7C5A, 0x006F7D5B, 0x006F7D5B, 0x00707E5C, 0x00707E5C, 0x00748260, 0x00748260, 0x00748260, 0x00748260, 0x00758361,
        0x00758361, 0x00758361, 0x00758361, 0x00758361, 0x00768462, 0x00768462, 0x00778563, 0x00778563, 0x00788664, 0x00788664, 0x00788664, 0x007A8564, 0x00798463, 0x00798463, 0x00788460, 0x00788460, 0x0077845E, 0x0077845E, 0x0077845E, 0x00758361,
        0x00758361, 0x00758361, 0x00768462, 0x00778563, 0x00788664, 0x00798765, 0x007A8866, 0x007B8967, 0x007B8967, 0x007B8967, 0x007B8967, 0x007B8967, 0x007B8967, 0x007B8967, 0x007B8967, 0x00788664, 0x00788664, 0x00778563, 0x00778563, 0x00768462,
        0x00768462, 0x00768462, 0x00768462, 0x007A8963, 0x007A8963, 0x00798862, 0x00798862, 0x00798862, 0x00798862, 0x007A8963, 0x007A8963, 0x007A8866, 0x007A8866, 0x007A8866, 0x007A8866, 0x007A8866, 0x007A8866, 0x007B8967, 0x007B8967, 0x007D8B67,
        0x007D8B67, 0x007D8B67, 0x007E8C68, 0x007E8C68, 0x007F8D69, 0x007F8D69, 0x00808E6A, 0x007B8967, 0x007C8A68, 0x007D8B69, 0x007E8C6A, 0x007E8C6A, 0x007D8B69, 0x007B8967, 0x007A8866, 0x007C8A66, 0x007B8965, 0x00798763, 0x00778561, 0x00778561,
        0x00788662, 0x00798763, 0x007A8864, 0x007B8965, 0x007A8864, 0x007A8864, 0x007A8864, 0x00798763, 0x00798763, 0x00798763, 0x00788662, 0x00798B62, 0x007A8C63, 0x007A8C63, 0x007A8C63, 0x00798B62, 0x00798B62, 0x00788A61, 0x00788A61, 0x007B8B62,
        0x007A8A61, 0x007A8A61, 0x007A8A61, 0x007B8B62, 0x007C8C63, 0x007E8E65, 0x007F8F66, 0x007A8D62, 0x007B8E63, 0x007B8E63, 0x007B8E63, 0x007A8D62, 0x007A8C63, 0x007A8C63, 0x007B8D64, 0x007E9268, 0x007E9268, 0x007D9167, 0x007D9167, 0x007C9066,
        0x007C9066, 0x007C9066, 0x007C9066, 0x007D8E63, 0x007D8E63, 0x007D8E63, 0x007D8E63, 0x007D8E63, 0x007C8D62, 0x007C8D62, 0x007C8D62, 0x007D8E63, 0x007D8E63, 0x007D8E63, 0x007D8E63, 0x007D8E63, 0x007D8E63, 0x007D8E63, 0x007D8E63, 0x007E8D67,
        0x007F8E68, 0x007F8E68, 0x0081906A, 0x0082916B, 0x0083926C, 0x0083926C, 0x0084936D, 0x0082966B, 0x0082966B, 0x0082966B, 0x0082966B, 0x0081956A, 0x0081956A, 0x00809469, 0x00809469, 0x0080926B, 0x0080926B, 0x0080926B, 0x007F916A, 0x007E9069,
        0x007D8E69, 0x007D8E69, 0x007C8D68, 0x00819168, 0x00829269, 0x0084946B, 0x0083936A, 0x00809067, 0x007E8E65, 0x007D8D64, 0x007E8E65, 0x007D915C, 0x007F9162, 0x007B8C61, 0x00798A5E, 0x00647647, 0xFF7E8D67, 0xFFFAFFF1, 0xFFFDFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFBFAFE, 0xC6DEE2D7, 0x008F987E, 0x00838F71, 0x007E8772, 0x007D8777, 0x007D8874, 0x007D8A72, 0x00848F6E, 0x00848F6E, 0x0085906F, 0x04869170, 0x04869170,
        0x04869170, 0x04869170, 0x0085906F, 0x0084926E, 0x0084926E, 0x0084926E, 0x0084926E, 0x0082906C, 0x00808E6A, 0x007E8C68, 0x007D8B67, 0x007B8965, 0x007A8864, 0x00788662, 0x00768460, 0x0073815D, 0x00707E5A, 0x006E7C58, 0x006D7B57, 0x006C7560,
        0x006B745F, 0x006B745F, 0x006A735E, 0x0069725D, 0x0069725D, 0x0068715C, 0x0068715C, 0x006B745F, 0x006B745F, 0x006C7560, 0x006C7560, 0x006D7661, 0x006D7661, 0x006D7661, 0x006E7762, 0x006D7661, 0x006D7661, 0x006D7661, 0x006E7762, 0x006E7762,
        0x006E7762, 0x006E7762, 0x006E7762, 0x006E7762, 0x006E7762, 0x006F7863, 0x006F7863, 0x00707964, 0x00717A65, 0x00727B66, 0x00727B66, 0x00727865, 0x00727865, 0x00727964, 0x00727964, 0x00737B64, 0x00737B64, 0x00737B64, 0x00737C62, 0x006C7560,
        0x006E7762, 0x00707964, 0x00727B66, 0x00727B66, 0x00717A65, 0x006E7762, 0x006D7661, 0x006C7560, 0x006C7560, 0x006C7560, 0x006C7560, 0x006C7560, 0x006C7560, 0x006C7560, 0x006C7560, 0x006D7661, 0x006D7661, 0x006D7661, 0x006D7661, 0x006D7661,
        0x006C7560, 0x006C7560, 0x006C7560, 0x006F7B5D, 0x006F7B5D, 0x006F7B5D, 0x006F7B5D, 0x006F7B5D, 0x006F7B5D, 0x006F7B5D, 0x006F7B5D, 0x006D7760, 0x006D7760, 0x006D7760, 0x006D7760, 0x006D7760, 0x006D7760, 0x006D7760, 0x006D7760, 0x006D7760,
        0x006C765F, 0x006C765F, 0x006C765F, 0x006C765F, 0x006D7760, 0x006E7861, 0x006F7962, 0x006F7863, 0x00707964, 0x00707964, 0x00717A65, 0x00707964, 0x00707964, 0x006E7762, 0x006E7762, 0x006F7962, 0x006D7760, 0x0069735C, 0x00667059, 0x00646E57,
        0x00646E57, 0x00656F58, 0x00667059, 0x006A725B, 0x006A725B, 0x0069715A, 0x00687059, 0x00687059, 0x00676F58, 0x00666E57, 0x00666E57, 0x00626F4F, 0x00647151, 0x00667353, 0x00667353, 0x00667353, 0x00657252, 0x00647151, 0x00647151, 0x00626E52,
        0x00626E52, 0x00626E52, 0x00626E52, 0x00636F53, 0x00657155, 0x00667256, 0x00677357, 0x00647250, 0x00647250, 0x00657351, 0x00657351, 0x00647250, 0x00647250, 0x0063714F, 0x0063714F, 0x00616F53, 0x00637155, 0x00657357, 0x00677559, 0x00677559,
        0x00667458, 0x00647256, 0x00637155, 0x00677553, 0x00677553, 0x00677553, 0x00667452, 0x00667452, 0x00667452, 0x00667452, 0x00657351, 0x00667452, 0x00667452, 0x00667452, 0x00667452, 0x00667452, 0x00667452, 0x00667452, 0x00667452, 0x00647054,
        0x00657155, 0x00667256, 0x00687458, 0x00687458, 0x00697559, 0x00687458, 0x00687458, 0x00677559, 0x00677559, 0x00677559, 0x00677559, 0x00667458, 0x00667458, 0x00667458, 0x00667458, 0x0069765C, 0x0069765C, 0x0069765C, 0x0068755B, 0x00677559,
        0x00677559, 0x00667458, 0x00667458, 0x00697559, 0x00697559, 0x00687458, 0x00687458, 0x00677357, 0x00667256, 0x00677357, 0x00687458, 0x006A7B50, 0x006B7955, 0x006A7856, 0x006A7953, 0x0067784D, 0xFF8A9874, 0xFFF0F9E5, 0xFFFDFFFE, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFDFF, 0xFFFFFFFE, 0xF4F6FAEF, 0xFFFDFFF9, 0xFFFDFFFF, 0xFFFBFFFF, 0xFFF9FFF7, 0xF4F8FFEF, 0xFFFDFFF6, 0xFFFEFFF7, 0xFFFEFFF7, 0xFFFFFFF8, 0xFFFFFFF8,
        0xFFFFFFF8, 0xFFFFFFF8, 0xFFFFFFF8, 0xFFFDFFF7, 0xFFFDFFF7, 0xFFFDFFF7, 0xFFFDFFF7, 0xFFFCFFF6, 0xFFFBFFF5, 0xFBFAFFF4, 0xFBFAFFF4, 0xFFFDFFF7, 0xFFFDFFF7, 0xFFFDFFF7, 0xFFFBFFF5, 0xFBF9FFF3, 0xF7F7FEF1, 0xF4F6FDF0, 0xF4F5FCEF, 0xFFFAFFF6,
        0xFFFAFFF6, 0xFFFAFFF6, 0xFFFAFFF6, 0xFFF9FEF5, 0xFBF8FDF4, 0xFBF8FDF4, 0xFBF7FCF3, 0xFFF9FEF5, 0xFFF9FEF5, 0xFFF9FEF5, 0xFFF9FEF5, 0xFFF9FEF5, 0xFFF9FEF5, 0xFFF9FEF5, 0xFFF9FEF5, 0xF7F5FAF1, 0xF7F5FAF1, 0xF7F5FAF1, 0xF7F6FBF2, 0xF7F6FBF2,
        0xF7F6FBF2, 0xF7F6FBF2, 0xF7F6FBF2, 0xF7F5FAF1, 0xF7F6FBF2, 0xF7F6FBF2, 0xF7F6FBF2, 0xFBF7FCF3, 0xFBF7FCF3, 0xFBF7FCF3, 0xFBF7FCF3, 0xFFF9FBF5, 0xFFF9FBF5, 0xFFF9FBF5, 0xFBF9FCF3, 0xFBFAFDF4, 0xFBFAFEF3, 0xFBFAFEF3, 0xFBFBFFF4, 0xF7F6FBF2,
        0xFBF7FCF3, 0xFFF9FEF5, 0xFFFAFFF6, 0xFBF8FDF4, 0xF7F5FAF1, 0xF0F1F6ED, 0xECEFF4EB, 0xE8EEF3EA, 0xE8EEF3EA, 0xE8EEF3EA, 0xE8EEF3EA, 0xE8EEF3EA, 0xE8EEF3EA, 0xE8EEF3EA, 0xE8EEF3EA, 0xE8EDF2E9, 0xE8EDF2E9, 0xE8EDF2E9, 0xE8EDF2E9, 0xE8EDF2E9,
        0xE8EDF2E9, 0xE8EEF3EA, 0xE8EEF3EA, 0xE4ECF2E7, 0xE4ECF2E7, 0xE4ECF2E7, 0xE4EDF3E8, 0xE4EDF3E8, 0xE4ECF2E7, 0xE4ECF2E7, 0xE4ECF2E7, 0xE4ECF2E7, 0xE4ECF2E7, 0xE1EBF1E6, 0xE1EBF1E6, 0xE1EBF1E6, 0xE1EBF1E6, 0xE1EBF1E6, 0xE1EBF1E6, 0xE1EBF1E6,
        0xE1EBF1E6, 0xE1EBF1E6, 0xE1EBF1E6, 0xE1EBF1E6, 0xE4ECF2E7, 0xE4ECF2E7, 0xE4ECF2E7, 0xE4ECF1E8, 0xE4ECF1E8, 0xE4ECF1E8, 0xE4ECF1E8, 0xE4ECF1E8, 0xE4ECF1E8, 0xE4EBF0E7, 0xE4EBF0E7, 0xE1EBF1E6, 0xE1EAF0E5, 0xD9E7EDE2, 0xD5E5EBE0, 0xD1E3E9DE,
        0xD1E2E8DD, 0xD1E3E9DE, 0xD1E3E9DE, 0xD1E5E9DE, 0xD1E5E9DE, 0xD1E5E9DE, 0xD1E4E8DD, 0xD1E4E8DD, 0xCEE3E7DC, 0xCEE3E7DC, 0xCEE3E7DC, 0xC6DEE5D8, 0xCAE0E7DA, 0xCEE1E8DB, 0xCEE1E8DB, 0xCAE0E7DA, 0xCADFE6D9, 0xCAE0E7DA, 0xCEE1E8DB, 0xD1E2E8DD,
        0xCEE1E7DC, 0xCEE1E7DC, 0xCEE1E7DC, 0xD1E2E8DD, 0xD1E2E8DD, 0xD1E3E9DE, 0xD1E3E9DE, 0xCEE5E7DB, 0xCEE5E7DB, 0xCEE5E7DB, 0xCEE6E8DC, 0xCAE6E9DA, 0xCAE6E9DA, 0xC6E5E8D8, 0xC6E4E7D7, 0xCAE0E4D9, 0xCEE2E6DB, 0xCEE3E7DC, 0xCEE3E7DC, 0xCAE1E5DA,
        0xC2DDE1D6, 0xBAD9DDD2, 0xB7D6DACF, 0xAFD4DBCC, 0xAFD4DBCC, 0xAFD4DBCC, 0xAFD4DBCC, 0xAFD4DBCC, 0xAFD3DACB, 0xAFD3DACB, 0xAFD3DACB, 0xAFD3DACB, 0xAFD3DACB, 0xAFD3DACB, 0xAFD3DACB, 0xAFD3DACB, 0xAFD3DACB, 0xAFD3DACB, 0xAFD3DACB, 0xABD2D9CA,
        0xABD2D9CA, 0xABD2D9CA, 0xABD2D9CA, 0xABD1D8C9, 0xA7D0D7C8, 0xA7D0D7C8, 0xA7CFD6C7, 0xB3D5D9CD, 0xB3D5D9CD, 0xB3D5D9CD, 0xB3D5D9CD, 0xB3D5D9CD, 0xB3D6DACE, 0xB3D6DACE, 0xB3D6DACE, 0xB3D5D9CD, 0xAFD4D8CC, 0xAFD4D8CC, 0xABD4D9CA, 0xABD3D8C9,
        0xA7D3D9C8, 0xABD4DAC9, 0xABD4DAC9, 0xB3D3DACD, 0xAFD1D8CB, 0xA7CED5C8, 0xA4CBD2C5, 0xA0C9D0C3, 0x9CC7CEC1, 0x98C6CDC0, 0x98C5CCBF, 0x91C5CDBC, 0x9CC8CFC2, 0xABCED4C9, 0x9CCCD5C1, 0x8DCAD6BA, 0xFFD2DCC5, 0xFFFBFFF7, 0xFFFAF9FF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF
};

static GUI_CONST_STORAGE GUI_BITMAP _bmPlatine_250x200 = {
  250,                                  // XSize
  200,                                  // YSize
  1000,                                 // BytesPerLine
  32,                                   // BitsPerPixel
  (unsigned char *)_acPlatine_250x200,  // Pointer to picture data
  NULL,                                 // Pointer to palette
  GUI_DRAW_BMP8888
};

/*********************************************************************
*
*       bmJLink_300x132
*/
static GUI_CONST_STORAGE unsigned long _acJLink_300x132[] = {
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFCFCFC, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFE, 0xFFFEFFFD, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFCFDF9, 0xFFFDFFFE, 0xFFEFF2F0, 0xFBE9ECEA, 0xFFF6F9F7, 0xFFFDFFFE,
        0xFFFDFFFE, 0xFFFAFDFB, 0xFFFBFEFC, 0xFFFBFBFB, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFCFCFC, 0xFFFAFAFA, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFFFD, 0xFFFAFBF9, 0xFFFBFCFA, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFF3F5EF, 0xDEE0E2DC, 0x3F909691, 0x157B817C, 0x04737974, 0x2A868C87, 0x64A1A7A2,
        0x96BAC0BB, 0xD1D6DCD7, 0xFFEFF5F0, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFDFEFC, 0xFFFDFEFC, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF9FAF8, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFC, 0xFBECEDE9, 0xA7C5C7C1, 0x3690928C, 0x00666862, 0x005C625D, 0x005A605B, 0x005B615C, 0x005E645F, 0x005F6560,
        0x00606661, 0x00696F6A, 0x08757B76, 0x3B8E8F8D, 0x64A3A4A2, 0xA7C3C4C2, 0xE6E1E2E0, 0xFFF4F5F3, 0xFFFDFEFC, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFF9F9F9, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFDFDFD, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFE, 0xFFFEFFFD, 0xDEDDDEDC, 0x60A2A39F, 0x006B6C68, 0x00565852, 0x005D5F59, 0x00696B65, 0x00696F6A, 0x006C726D, 0x006D736E, 0x00696F6A, 0x00666C67,
        0x00666C67, 0x00666C67, 0x00666C67, 0x00676866, 0x00696A68, 0x006C6D6B, 0x00727371, 0x197F807E, 0x4B979896, 0x86B3B4B2, 0xB0C7C8C6, 0xF7E8E8E8, 0xFFF1F1F1, 0xFFFBFBFB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFDFDFD, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFEFDFF, 0xFFFEFDFF, 0xFFFFFFFF, 0xFFFDFDFD, 0xFFFEFFFD, 0xFFFFFFFE, 0xFFFFFFFE,
        0xFFFEFFFD, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFCFDFB, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xE2E0E4DE, 0x6DA7ABA5, 0x006B6F69, 0x0051554F, 0x004E524C, 0x004D514B, 0x004A4E48, 0x004B4F49, 0x00535751, 0x005A5E58, 0x00646862, 0x006C706A, 0x006F736D,
        0x006F736D, 0x006E726C, 0x006D716B, 0x006D746D, 0x006B726B, 0x00686F68, 0x00656C65, 0x00636A63, 0x00636A63, 0x00646B64, 0x00656C65, 0x0071756F, 0x1D81857F, 0x549B9F99, 0x8AB6BAB4, 0xC0CFD3CD, 0xEEE5E9E3, 0xFFF6FAF4, 0xFFFDFFFB, 0xFFFFFEFF,
        0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFDFCFE, 0xFFFDFCFE, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFEFDFF, 0xFFFEFDFF, 0xFFFDFCFE, 0xFFFDFCFE, 0xFFFEFDFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFEFEFE, 0xFFFEFEFE, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFEFEFE, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFEFF, 0xFFFBFAFC, 0xFFFFFEFF, 0xFFFEFEFE, 0xFFFCFCFC, 0xFFFCFDFB, 0xFFF9FAF8, 0xFFFFFFFE, 0xFFFFFFFE,
        0xFFFFFFFE, 0xFFFDFEFC, 0xFFFCFDFB, 0xFFFFFFFE, 0xFFFFFFFE, 0xD5D9DAD8, 0x69A4A5A3, 0x006C706A, 0x0061655F, 0x005B5F59, 0x005F635D, 0x00646862, 0x00636761, 0x0060645E, 0x005F635D, 0x004F534D, 0x004C504A, 0x00474B45, 0x00444842, 0x00464A44,
        0x004E524C, 0x005A5E58, 0x00626660, 0x00656C65, 0x00666D66, 0x00686F68, 0x00697069, 0x00697069, 0x00697069, 0x00686F68, 0x00686F68, 0x006A6E68, 0x00676B65, 0x00646862, 0x00646862, 0x006A6E68, 0x0D797D77, 0x368D918B, 0x4F9A9E98, 0xA3C0C1BF,
        0xC9D2D3D1, 0xFBEBECEA, 0xFFFEFFFD, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFEFFFD, 0xFFFCFDFB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFEFEFE, 0xFFFEFEFE, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFDFDFD, 0xFFFCFCFC, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFBFAFC, 0xFFFFFEFF, 0xFFFFFFFF, 0xFFFDFDFD, 0xFFFDFDFD, 0xFFFFFFFE, 0xFFFCFDFB, 0xFFFFFFFE, 0xFFFFFFFE,
        0xFFFAFBF9, 0xFFFFFFFE, 0xFFFFFFFE, 0xF2E7E8E6, 0x7DAFB0AE, 0x08777876, 0x00545553, 0x00585C56, 0x005C605A, 0x0060645E, 0x005E625C, 0x005A5E58, 0x00595D57, 0x005C605A, 0x005F635D, 0x00656963, 0x00656963, 0x00636761, 0x005E625C, 0x00575B55,
        0x004E524C, 0x00474B45, 0x00444842, 0x00464D46, 0x004A514A, 0x00535A53, 0x005B625B, 0x00626962, 0x00676E67, 0x00697069, 0x006A716A, 0x00686C66, 0x00696D67, 0x006A6E68, 0x00686C66, 0x00656963, 0x00636761, 0x00646862, 0x00666A64, 0x00666862,
        0x0071736D, 0x1982847E, 0x3F93958F, 0x69A8AAA4, 0xA7C5C7C1, 0xE6E4E6E0, 0xFFF9FBF5, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFDFDFD, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFEFEFE, 0xFFFDFDFD, 0xFFFEFEFE,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFDFDFD, 0xFFFCFCFC, 0xFFFCFCFC, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFDFF, 0xFFFFFFFF, 0xFFFCFCFC, 0xFFFCFCFC, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFF7F8F4, 0xFFFBFCF8, 0xFFFEFFFB,
        0xFFFDFEFA, 0xFBECEDE9, 0x8EB9BAB6, 0x04777874, 0x00555652, 0x005B5C58, 0x00686965, 0x0061655F, 0x0061655F, 0x0060645E, 0x005D615B, 0x005A5E58, 0x00585C56, 0x005A5E58, 0x005C605A, 0x00535751, 0x00585C56, 0x0060645E, 0x00676B65, 0x006A6E68,
        0x006B6F69, 0x00696D67, 0x00676B65, 0x00596059, 0x00525952, 0x00495049, 0x00424942, 0x00404740, 0x00444B44, 0x004B524B, 0x00505750, 0x00626660, 0x00656963, 0x00686C66, 0x006A6E68, 0x00696D67, 0x00686C66, 0x00696D67, 0x00696D67, 0x0063695E,
        0x00656B60, 0x00656B60, 0x0063695E, 0x0062685D, 0x00676D62, 0x0072786D, 0x087B8176, 0x4F979A98, 0x7DADB0AE, 0xC0CDD0CE, 0xFBEAEDEB, 0xFFFBFEFC, 0xFFFDFFFE, 0xFFFDFFFE, 0xFFFDFFFE, 0xFFFAFDFB, 0xFFFBFEFC, 0xFFFCFFFD, 0xFFFCFFFD, 0xFFFBFEFC,
        0xFFFBFEFC, 0xFFFBFEFC, 0xFFFCFFFD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFCFCFC, 0xFFFAFAFA, 0xFFFFFFFE, 0xFFFBFCFA, 0xFFF9FAF6, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFEFF0EC,
        0x8EB8B9B5, 0x117D7E7A, 0x005D5E5A, 0x005B5C58, 0x00666763, 0x00676864, 0x005C5D59, 0x005F635D, 0x005A5E58, 0x005A5E58, 0x0060645E, 0x0061655F, 0x005C605A, 0x00585C56, 0x00595D57, 0x005D615B, 0x005B5F59, 0x00595D57, 0x00595D57, 0x005A5E58,
        0x005E625C, 0x0061655F, 0x00646862, 0x00676E67, 0x00676E67, 0x00666D66, 0x00626962, 0x005C635C, 0x00535A53, 0x004B524B, 0x00464D46, 0x00424640, 0x00474B45, 0x004E524C, 0x00565A54, 0x005D615B, 0x00636761, 0x00676B65, 0x006A6E68, 0x006A7065,
        0x006A7065, 0x006B7166, 0x006A7065, 0x00696F64, 0x00676D62, 0x00666C61, 0x00656B60, 0x00616560, 0x00636762, 0x00686C67, 0x00727671, 0x26848883, 0x60A0A49F, 0x9BBDC1BC, 0xC4D0D4CF, 0xFFF5F8F6, 0xFFF8FBF9, 0xFFFDFFFE, 0xFFFDFFFE, 0xFFFDFFFE,
        0xFFFCFFFD, 0xFFFBFEFC, 0xFFFBFEFC, 0xFFFEFEFE, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFFFD, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFCFDF9, 0xFFFFFFFC, 0xFFF9FBF5, 0x86B6B8B2, 0x00747571,
        0x005B5C58, 0x00555652, 0x00646561, 0x006A6B67, 0x00636460, 0x005F605C, 0x0060615D, 0x0060645E, 0x005A5E58, 0x00585C56, 0x005D615B, 0x005E625C, 0x005B5F59, 0x005E625C, 0x00646862, 0x005C605A, 0x005C605A, 0x005C605A, 0x005D615B, 0x005D615B,
        0x005D615B, 0x005C605A, 0x005A5E58, 0x00585F58, 0x00575E57, 0x00575E57, 0x00575E57, 0x00585F58, 0x005A615A, 0x005C635C, 0x005D645D, 0x00626660, 0x005B5F59, 0x0050544E, 0x00464A44, 0x0040443E, 0x0041453F, 0x00444842, 0x00474B45, 0x00555D53,
        0x00575F55, 0x005D655B, 0x00636B61, 0x00697167, 0x006A7268, 0x00687066, 0x00666E64, 0x00656C65, 0x00656C65, 0x00646B64, 0x00626962, 0x005F665F, 0x005F665F, 0x00626962, 0x00656C65, 0x00707671, 0x26838984, 0x64A2A8A3, 0xA7C1C7C2, 0xD9DAE0DB,
        0xFFECF2ED, 0xFFF8FEF9, 0xFFFBFFFC, 0xFFFAFAFA, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFEFEFE, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFE, 0xFFFDFEFC, 0xFFFFFFFE, 0xFFFAFBF7, 0xFFFFFFFC, 0xFFF7F9F3, 0x26878983, 0x00252721, 0x001F211B,
        0x0030322C, 0x0041433D, 0x00454741, 0x00484A44, 0x00575953, 0x0062645E, 0x005F615B, 0x005C605A, 0x005E625C, 0x0061655F, 0x0061655F, 0x005E625C, 0x005B5F59, 0x005C605A, 0x005E625C, 0x005E625C, 0x005E625C, 0x005D615B, 0x005E625C, 0x005E625C,
        0x005D615B, 0x005B5F59, 0x00585C56, 0x00555C55, 0x00575E57, 0x005A615A, 0x005D645D, 0x005E655E, 0x005D645D, 0x005C635C, 0x005B625B, 0x005F635D, 0x0060645E, 0x0061655F, 0x00626660, 0x005F635D, 0x005A5E58, 0x00555953, 0x0051554F, 0x00444B44,
        0x00434A43, 0x00424942, 0x00454C45, 0x004B524B, 0x00555C55, 0x005F665F, 0x00666D66, 0x00687066, 0x00676F65, 0x00646C62, 0x00626A60, 0x0061695F, 0x0061695F, 0x00636B61, 0x00656D63, 0x00616762, 0x005D635E, 0x00585E59, 0x00585E59, 0x00626863,
        0x0D787E79, 0x43929893, 0x6DA5ABA6, 0xCDD3D3D3, 0xE6DFDFDF, 0xFFF0F0F0, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFFFD, 0xFFFEFFFD, 0xFFFFFFFE, 0xFFFAFBF7, 0xFFFFFFFC, 0x69A8AAA4, 0x00191B15, 0x0011130D, 0x00171913,
        0x0013150F, 0x00171913, 0x001F211B, 0x0021231D, 0x00292B25, 0x00373933, 0x003F413B, 0x00484C46, 0x00535751, 0x005B5F59, 0x005D615B, 0x005E625C, 0x0061655F, 0x0061655F, 0x005D615B, 0x0060645E, 0x005E625C, 0x005D615B, 0x005D615B, 0x005D615B,
        0x005C605A, 0x005A5E58, 0x00585C56, 0x005B625B, 0x005C635C, 0x005F665F, 0x00616861, 0x00646B64, 0x00656C65, 0x00666D66, 0x00666D66, 0x00646862, 0x00636761, 0x0061655F, 0x0060645E, 0x005F635D, 0x005F635D, 0x005E625C, 0x005E625C, 0x005F6560,
        0x00606661, 0x005E645F, 0x00565C57, 0x004D534E, 0x00454B46, 0x00434944, 0x00434944, 0x004C544A, 0x0050584E, 0x00586056, 0x0060685E, 0x00656D63, 0x00666E64, 0x00646C62, 0x00626A60, 0x00606661, 0x00626863, 0x00636964, 0x00606661, 0x005D635E,
        0x005B615C, 0x005D635E, 0x005F6560, 0x005E5E5E, 0x006C6C6C, 0x21818181, 0x54999999, 0x86B1B1B1, 0xBCCBCBCB, 0xEEE4E4E4, 0xFFF5F5F5, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFDFDFF, 0xFFFCFBFD, 0xFFFFFDFC, 0xFFFFFFFB, 0xFFFDFBF3, 0x003E4138, 0x000F160F, 0x000D140F, 0x0011150F,
        0x0010140E, 0x0010140E, 0x0010140E, 0x0010140E, 0x0010140E, 0x0010140E, 0x0011150F, 0x00191D17, 0x00222620, 0x002E322C, 0x00383C36, 0x0040443E, 0x004A4E48, 0x00565A54, 0x005E625C, 0x005C605B, 0x005F635E, 0x00616560, 0x00616560, 0x005E625D,
        0x005D615C, 0x0060645F, 0x00626661, 0x0061655F, 0x0061655F, 0x00626660, 0x00626660, 0x00636761, 0x00636761, 0x00636761, 0x00626660, 0x00666A64, 0x00666A64, 0x00656963, 0x00656963, 0x00646862, 0x00626660, 0x0060645E, 0x005F635D, 0x005E625C,
        0x005E625C, 0x005E625C, 0x0060645E, 0x00626660, 0x00636761, 0x00626660, 0x0061655F, 0x00505750, 0x004C534C, 0x00464D46, 0x00434A43, 0x00454C45, 0x004C534C, 0x00545B54, 0x00596059, 0x00616861, 0x00616861, 0x00626962, 0x00616861, 0x00616861,
        0x00606760, 0x005F665F, 0x005E655E, 0x00646B64, 0x00646B64, 0x00626962, 0x005F665F, 0x005F665F, 0x00656C65, 0x006F766F, 0x0D777E77, 0x4B9A9C96, 0x79AFB1AB, 0xB8CED0CA, 0xEEE8EAE4, 0xFFF7F9F3, 0xFFFEFFFA, 0xFFFFFFFB, 0xFFFFFFFB, 0xFFFCFDFB,
        0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFEFFFD, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFDFEFC, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE,
        0xFFFEFEFE, 0xFFFDFDFD, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFEFEFE, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFBFBFF, 0xFFFDFCFE, 0xFFFFFFFE, 0xFFFFFFFA, 0xDEE5E3DB, 0x00272A21, 0x000A110A, 0x000E1510, 0x0010140E,
        0x0010140E, 0x000F130D, 0x000F130D, 0x000F130D, 0x000F130D, 0x0010140E, 0x0010140E, 0x000A0E08, 0x000D110B, 0x0011150F, 0x00141812, 0x00171B15, 0x001E221C, 0x00272B25, 0x002F332D, 0x0040443F, 0x00484C47, 0x00535752, 0x005B5F5A, 0x005F635E,
        0x00626661, 0x00646863, 0x00666A65, 0x00656963, 0x00656963, 0x00636761, 0x0061655F, 0x005F635D, 0x005E625C, 0x005E625C, 0x005F635D, 0x005D615B, 0x005F635D, 0x00626660, 0x00656963, 0x00666A64, 0x00666A64, 0x00656963, 0x00646862, 0x006A6E68,
        0x00686C66, 0x00666A64, 0x00646862, 0x00646862, 0x00626660, 0x0060645E, 0x005E625C, 0x00656C65, 0x00646B64, 0x00626962, 0x005E655E, 0x00585F58, 0x00515851, 0x004B524B, 0x00474E47, 0x00414841, 0x00464D46, 0x004D544D, 0x00565D56, 0x005C635C,
        0x00616861, 0x00636A63, 0x00636A63, 0x005E655E, 0x005F665F, 0x005F665F, 0x005D645D, 0x005C635C, 0x005D645D, 0x00616861, 0x00646B64, 0x00656761, 0x00666862, 0x006A6C66, 0x0073756F, 0x21858781, 0x5CA1A39D, 0x9FC1C3BD, 0xC9D6D8D2, 0xFFF4F5F3,
        0xFFFAFBF9, 0xFFFEFFFD, 0xFFFDFEFC, 0xFFFDFEFC, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFDFDFD, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFEFEFE, 0xFFFEFEFE, 0xFFFEFEFE, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFBFBFF, 0xFFFFFEFF, 0xFFFFFEFD, 0xFFFFFEF9, 0xA7CBC9C1, 0x0013160D, 0x00091009, 0x000C130E, 0x000F130D,
        0x000E120C, 0x000E120C, 0x000D110B, 0x000D110B, 0x000E120C, 0x000E120C, 0x000F130D, 0x000E120D, 0x000E120D, 0x000D110C, 0x000B0F0A, 0x000A0E09, 0x000C100B, 0x0010140F, 0x00141813, 0x00131712, 0x001A1E19, 0x00242823, 0x0030342F, 0x003C403B,
        0x00484C47, 0x00555954, 0x005D615C, 0x005F635D, 0x00636761, 0x00686C66, 0x00696D67, 0x00676B65, 0x00646862, 0x00626660, 0x00626660, 0x00656963, 0x00646862, 0x00636761, 0x0061655F, 0x0061655F, 0x00636761, 0x00656963, 0x00666A64, 0x00636761,
        0x00626660, 0x00626660, 0x00636761, 0x00656963, 0x00676B65, 0x00676B65, 0x00676B65, 0x00616861, 0x00626962, 0x00646B64, 0x00656C65, 0x00656C65, 0x00646B64, 0x00636A63, 0x00616861, 0x00606760, 0x00596059, 0x004E554E, 0x00454C45, 0x00424942,
        0x00444B44, 0x004A514A, 0x004E554E, 0x00545B54, 0x00585F58, 0x005E655E, 0x00636A63, 0x00646B64, 0x00616861, 0x005E655E, 0x005B625B, 0x00646660, 0x00656761, 0x00646660, 0x00646660, 0x00646660, 0x00666862, 0x006A6C66, 0x006D6F69, 0x0D797A78,
        0x368D8E8C, 0x75AAABA9, 0xB0C6C7C5, 0xE2DEDFDD, 0xFFF0F1EF, 0xFFFCFDFB, 0xFFFFFFFE, 0xFFFCFCFC, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFEFEFE, 0xFFFDFDFD, 0xFFFCFCFC, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFEFEFE, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFDFDFF, 0xFFFFFEFF, 0xFFFFFCFB, 0xFFFFFFFB, 0x86BBB9B1, 0x000E1108, 0x000E150E, 0x0009100B, 0x000D110B,
        0x000D110B, 0x000C100A, 0x000C100A, 0x000C100A, 0x000C100A, 0x000D110B, 0x000D110B, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000E120D, 0x000D110C, 0x000C100B, 0x00111510, 0x0010140F, 0x000E120D, 0x000D110C, 0x0010140F,
        0x00171B16, 0x0020241F, 0x00272B26, 0x00353933, 0x003E423C, 0x004A4E48, 0x00555953, 0x005C605A, 0x00626660, 0x00686C66, 0x006C706A, 0x00656963, 0x00646862, 0x00636761, 0x0061655F, 0x0061655F, 0x00626660, 0x00656963, 0x00686C66, 0x00626660,
        0x00626660, 0x00626660, 0x00636761, 0x00656963, 0x00676B65, 0x00686C66, 0x00686C66, 0x00656C65, 0x00646B64, 0x00636A63, 0x00626962, 0x00636A63, 0x00656C65, 0x00676E67, 0x00686F68, 0x00626962, 0x00646B64, 0x00666D66, 0x00656C65, 0x005F665F,
        0x00575E57, 0x004E554E, 0x00484F48, 0x00474E47, 0x00474E47, 0x00474E47, 0x004B524B, 0x00535A53, 0x005B625B, 0x00626962, 0x00666D66, 0x005F635D, 0x0060645E, 0x0061655F, 0x00626660, 0x00636761, 0x00626660, 0x0061655F, 0x0060645E, 0x00646863,
        0x00636762, 0x00616560, 0x00616560, 0x006B6F6A, 0x1D80847F, 0x4F999D98, 0x71A9ADA8, 0xCDD3D6D4, 0xE6E0E3E1, 0xFFF1F4F2, 0xFFFCFFFD, 0xFFFDFFFE, 0xFFFBFEFC, 0xFFFCFFFD, 0xFFFDFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE,
        0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFEFEFE, 0xFFFEFEFE, 0xFFFDFDFD, 0xFFFCFCFC, 0xFFFCFCFC, 0xFFFDFDFD, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFDFDFF, 0xFFFFFEFF, 0xFFFFFCFB, 0xFFFFFFFB, 0x69ADABA3, 0x000D1007, 0x00111811, 0x00060D08, 0x000C100A,
        0x000C100A, 0x000B0F09, 0x000B0F09, 0x000B0F09, 0x000B0F09, 0x000C100A, 0x000C100A, 0x000A0E09, 0x000A0E09, 0x000B0F0A, 0x000C100B, 0x000D110C, 0x000D110C, 0x000B0F0A, 0x000A0E09, 0x000E120D, 0x000F130E, 0x000F130E, 0x000E120D, 0x000E120D,
        0x000E120D, 0x000F130E, 0x00111510, 0x00131711, 0x00171B15, 0x001E221C, 0x00252923, 0x002E322C, 0x00393D37, 0x00474B45, 0x0050544E, 0x005D615B, 0x0061655F, 0x00676B65, 0x006A6E68, 0x006A6E68, 0x00686C66, 0x00666A64, 0x00656963, 0x00626660,
        0x00626660, 0x00626660, 0x0061655F, 0x0060645E, 0x0060645E, 0x0060645E, 0x0060645E, 0x005E655E, 0x005F665F, 0x00616861, 0x00626962, 0x00636A63, 0x00626962, 0x00616861, 0x00616861, 0x00656C65, 0x00656C65, 0x00656C65, 0x00656C65, 0x00656C65,
        0x00676E67, 0x00686F68, 0x00686F68, 0x00676E67, 0x00606760, 0x00565D56, 0x004F564F, 0x004A514A, 0x00474E47, 0x00454C45, 0x00434A43, 0x005A5E58, 0x005C605A, 0x005F635D, 0x00636761, 0x00666A64, 0x00666A64, 0x00636761, 0x0061655F, 0x00636762,
        0x00666A65, 0x00696D68, 0x00696D68, 0x00666A65, 0x00626661, 0x00616560, 0x00636762, 0x00606361, 0x006F7270, 0x2E878A88, 0x609FA2A0, 0x92B7BAB8, 0xC9D1D4D2, 0xFFEBEEEC, 0xFFFCFFFD, 0xFFFEFFFD, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFDFEFC,
        0xFFFEFFFD, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF9F9FF, 0xFFFDFCFE, 0xFFFFFFFE, 0xFFFFFFFB, 0x439B9991, 0x00070A01, 0x000E150E, 0x00080F0A, 0x000C100A,
        0x000B0F09, 0x000B0F09, 0x000A0E08, 0x000A0E08, 0x000B0F09, 0x000B0F09, 0x000C100A, 0x000C0F0D, 0x000B0E0C, 0x000A0D0B, 0x00090C0A, 0x000A0D0B, 0x000C0F0D, 0x000D100E, 0x000E110F, 0x000C100B, 0x000E120D, 0x0010140F, 0x00121611, 0x00121611,
        0x00111510, 0x000F130E, 0x000E120D, 0x0011150F, 0x0011150F, 0x0010140E, 0x000F130D, 0x0010140E, 0x00131711, 0x00191D17, 0x001E221C, 0x002B2F29, 0x00343832, 0x0040443E, 0x004C504A, 0x00555953, 0x005E625C, 0x00656963, 0x006A6E68, 0x00646862,
        0x00656963, 0x00666A64, 0x00666A64, 0x00646862, 0x00636761, 0x00626660, 0x00626660, 0x00606760, 0x00616861, 0x00626962, 0x00626962, 0x00616861, 0x005F665F, 0x005D645D, 0x005C635C, 0x00626962, 0x00626962, 0x00626962, 0x00626962, 0x00616861,
        0x00606760, 0x00606760, 0x005F665F, 0x00606760, 0x00626962, 0x00636A63, 0x00656C65, 0x00646B64, 0x005F665F, 0x00575E57, 0x00515851, 0x00454C45, 0x00424942, 0x003F463F, 0x00404740, 0x00454C45, 0x004F564F, 0x00596059, 0x005F665F, 0x00606661,
        0x005E645F, 0x005E645F, 0x005F6560, 0x005F6560, 0x00606661, 0x00636964, 0x00686E69, 0x00676D68, 0x00646A65, 0x00606661, 0x005B615C, 0x005C625D, 0x00676D68, 0x0D777D78, 0x26848A85, 0x75ADAEAA, 0x9BBEBFBB, 0xD1D9DAD6, 0xFFF0F1ED, 0xFFFDFEFA,
        0xFFFFFFFC, 0xFFFFFFFC, 0xFFFEFFFB, 0xFFFEFEFE, 0xFFFEFEFE, 0xFFFEFEFE, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF9F9FF, 0xFFFDFCFE, 0xFFFFFFFE, 0xFFFFFFFB, 0x268D8B83, 0x00040700, 0x00091009, 0x000B120D, 0x000B0F09,
        0x000B0F09, 0x000A0E08, 0x000A0E08, 0x000A0E08, 0x000A0E08, 0x000B0F09, 0x000B0F09, 0x000B0E0C, 0x000A0D0B, 0x000A0D0B, 0x00090C0A, 0x00080B09, 0x00090C0A, 0x000A0D0B, 0x000C0F0D, 0x00090D08, 0x00090D08, 0x000A0E09, 0x000B0F0A, 0x000C100B,
        0x000D110C, 0x000D110C, 0x000D110C, 0x000D110B, 0x000E120C, 0x0010140E, 0x0011150F, 0x0011150F, 0x0010140E, 0x0010140E, 0x0010140E, 0x000C100A, 0x0010140E, 0x00161A14, 0x001B1F19, 0x00232721, 0x002D312B, 0x00383C36, 0x0041453F, 0x00565A54,
        0x00595D57, 0x005E625C, 0x0061655F, 0x00626660, 0x00636761, 0x00646862, 0x00656963, 0x00626962, 0x00616861, 0x00606760, 0x005F665F, 0x005F665F, 0x00606760, 0x00626962, 0x00636A63, 0x00606760, 0x00606760, 0x005F665F, 0x005F665F, 0x00606760,
        0x00616861, 0x00626962, 0x00636A63, 0x00646B64, 0x00646B64, 0x00636A63, 0x00646B64, 0x00646B64, 0x00646B64, 0x00626962, 0x00616861, 0x00646B64, 0x00606760, 0x00596059, 0x00505750, 0x00474E47, 0x00414841, 0x003D443D, 0x003B423B, 0x00424942,
        0x00474E47, 0x00535A53, 0x00616861, 0x00686F68, 0x00666D66, 0x00616861, 0x005F665F, 0x00606661, 0x00626863, 0x00636964, 0x00636964, 0x00636964, 0x00636964, 0x00636964, 0x00646A65, 0x005E5F5B, 0x00636460, 0x006E6F6B, 0x117D7E7A, 0x43949591,
        0x7DB0B1AD, 0xB8CDCECA, 0xDEDFE0DC, 0xFFFCFCFC, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFDFDFF, 0xFFFEFDFF, 0xFFFFFFFE, 0xFFFFFEF9, 0x1987857D, 0x00060900, 0x00080F08, 0x000C130E, 0x000B0F09,
        0x000B0F09, 0x000A0E08, 0x000A0E08, 0x000A0E08, 0x000A0E08, 0x000B0F09, 0x000B0F09, 0x00080B09, 0x000A0D0B, 0x000D100E, 0x000D100E, 0x000C0F0D, 0x000B0E0C, 0x000A0D0B, 0x00090C0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000C100B, 0x000C100B,
        0x000C100B, 0x000B0F0A, 0x000A0E09, 0x000B0F09, 0x000B0F09, 0x000B0F09, 0x000C100A, 0x000E120C, 0x000F130D, 0x0010140E, 0x0011150F, 0x0011150F, 0x00131711, 0x00131711, 0x0011150F, 0x000F130D, 0x0010140E, 0x00161A14, 0x001A1E18, 0x001F231D,
        0x00272B25, 0x00333731, 0x0040443E, 0x004B4F49, 0x00545852, 0x005C605A, 0x0060645E, 0x00646B64, 0x00646B64, 0x00626962, 0x00616861, 0x00616861, 0x00606760, 0x00606760, 0x00606760, 0x005E655E, 0x005E655E, 0x005E655E, 0x005E655E, 0x005E655E,
        0x005D645D, 0x005D645D, 0x005D645D, 0x00616861, 0x00616861, 0x00616861, 0x00626962, 0x00626962, 0x00636A63, 0x00646B64, 0x00646B64, 0x00606760, 0x00616861, 0x00636A63, 0x00626962, 0x005F665F, 0x005C635C, 0x005B625B, 0x005A615A, 0x00505750,
        0x00484F48, 0x00424942, 0x00434A43, 0x00464D46, 0x004A514A, 0x004F564F, 0x00545B54, 0x005D635E, 0x005F6560, 0x00626863, 0x00656B66, 0x00666C67, 0x00646A65, 0x00616762, 0x005E645F, 0x00666763, 0x00676864, 0x00666763, 0x00636460, 0x0062635F,
        0x00656662, 0x006B6C68, 0x0071726E, 0x328A8A8A, 0x589B9B9B, 0x92B8B8B8, 0xD5D7D7D7, 0xFFEEEEEE, 0xFFFAFAFA, 0xFFFEFEFE, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFEFEFE, 0xFFFEFEFE, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFDFFFF,
        0xFFFDFFFF, 0xFFFCFEFE, 0xFFFAFFFE, 0xFFFAFFFE, 0xFFFBFFFF, 0xFFFAFFFF, 0xFFFAFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFEFEFE, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFEFEFE, 0xFFFEFEFE, 0xFFFEFEFE,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFDFF, 0xFFFFFFFF, 0xFFFCFDF9, 0xFFFFFFF9, 0x00696C63, 0x00070903, 0x0010110D, 0x000B0C0A, 0x000A0E08,
        0x000A0E08, 0x000A0E08, 0x000A0E08, 0x000A0E08, 0x000A0E08, 0x000A0E08, 0x000A0E08, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000C0D09, 0x000C0D09, 0x000C0D09, 0x000C0D09, 0x000C0D09,
        0x000C0D09, 0x000C0D09, 0x000C0D09, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000E120D, 0x000E120D, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x0010140F, 0x0010140F, 0x0010140F,
        0x00121611, 0x00141813, 0x00171B16, 0x001C201B, 0x00242823, 0x002E322D, 0x00343833, 0x00454943, 0x004C504A, 0x00555953, 0x005D615B, 0x00636761, 0x00656963, 0x00666A64, 0x00676B65, 0x00636761, 0x00626660, 0x0061655F, 0x00626660, 0x00646862,
        0x00646862, 0x00636761, 0x0061655F, 0x00616861, 0x00626962, 0x00626962, 0x00616861, 0x00616861, 0x00616861, 0x00646B64, 0x00666D66, 0x00676B65, 0x00676B65, 0x00686C66, 0x00696D67, 0x00696D67, 0x00696D67, 0x00686C66, 0x00676B65, 0x00696D67,
        0x00676B65, 0x00646862, 0x00646862, 0x00626660, 0x005B5F59, 0x004E524C, 0x00444842, 0x00434741, 0x00464A44, 0x004D514B, 0x00545852, 0x005A5E58, 0x005E625C, 0x0060645E, 0x0061655F, 0x0061655F, 0x00636761, 0x00656963, 0x00666A64, 0x00676B65,
        0x00676B65, 0x00666A64, 0x00656963, 0x00626A60, 0x00626A60, 0x00636A63, 0x00666D66, 0x00727873, 0x328A908B, 0x71A7ADA8, 0x9BBBC0BE, 0xE6E1E2E0, 0xFFEFF0EE, 0xFFFDFEFC, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFEFFFD, 0xFFFEFDFF,
        0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFEFDFF, 0xFFFEFDFF, 0xFFFEFDFF, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFEFEFE, 0xFFFEFEFE, 0xFFFEFEFE, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE,
        0xFFFEFEFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFDFDFD, 0xFFFCFCFC, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFDFDFD, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFCFCFC, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFCFCFC, 0xFFFCFCFC, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFCFCFC, 0xFFFFFFFF,
        0xFFFDFDFD, 0xFFFBFBFB, 0xFFFDFDFD, 0xFFFDFFFF, 0xFFFDFFFF, 0xFFFBFFFF, 0xFFF9FEFD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFEFEFE, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFDFCFF, 0xFFFFFFFF, 0xFFFDFEFA, 0xFFFFFFF9, 0x0064675E, 0x00060802, 0x000F100C, 0x000C0D0B, 0x000A0E08,
        0x000A0E08, 0x000A0E08, 0x000A0E08, 0x000A0E08, 0x000A0E08, 0x000A0E08, 0x000A0E08, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000C0D09, 0x000C0D09, 0x000C0D09, 0x000C0D09, 0x000C0D09,
        0x000C0D09, 0x000C0D09, 0x000C0D09, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D110C, 0x000D110C, 0x000D110C, 0x000D110C, 0x000D110C, 0x000E120D, 0x000E120D, 0x000E120D, 0x0010140F,
        0x00111510, 0x00111510, 0x00121611, 0x00121611, 0x00141813, 0x00181C17, 0x001B1F1A, 0x00191D17, 0x001E221C, 0x00272B25, 0x00323630, 0x003E423C, 0x00494D47, 0x00535751, 0x00595D57, 0x0060645E, 0x0061655F, 0x00636761, 0x00656963, 0x00656963,
        0x00636761, 0x0060645E, 0x005D615B, 0x00616861, 0x00616861, 0x00606760, 0x005E655E, 0x005E655E, 0x005F665F, 0x00626962, 0x00656C65, 0x0061655F, 0x0061655F, 0x00626660, 0x00646862, 0x00676B65, 0x006A6E68, 0x006D716B, 0x006F736D, 0x006B6F69,
        0x006A6E68, 0x006A6E68, 0x006A6E68, 0x006B6F69, 0x006A6E68, 0x00686C66, 0x00676B65, 0x00636761, 0x005E625C, 0x00565A54, 0x004E524C, 0x004A4E48, 0x00494D47, 0x004A4E48, 0x004C504A, 0x00575B55, 0x005B5F59, 0x0060645E, 0x00656963, 0x00686C66,
        0x00696D67, 0x00686C66, 0x00676B65, 0x00636B61, 0x00656D63, 0x00666D66, 0x00646B64, 0x00606661, 0x005E645F, 0x00606661, 0x00636866, 0x006C6D6B, 0x1D80817F, 0x549B9C9A, 0x8AB4B5B3, 0xB8CBCCCA, 0xEEE4E5E3, 0xFFFAFBF9, 0xFFFFFFFE, 0xFFFEFEFE,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFDFDFD, 0xFFFCFCFC, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFDFDFD, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFEFEFE, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFDFDFD, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFDFDFD, 0xFFFFFDFE,
        0xFFFFFEFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFDFFFF, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFCFCFC, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFDFCFF, 0xFFFFFFFF, 0xFFFEFFFB, 0xFFFCFFF6, 0x005B5E55, 0x00060802, 0x000F100C, 0x000D0E0C, 0x000A0E08,
        0x000A0E08, 0x000A0E08, 0x000A0E08, 0x000A0E08, 0x000A0E08, 0x000A0E08, 0x000A0E08, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000C0D09, 0x000C0D09, 0x000C0D09, 0x000C0D09, 0x000C0D09,
        0x000C0D09, 0x000C0D09, 0x000C0D09, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000C100B, 0x000C100B, 0x000C100B, 0x000C100B, 0x000D110C,
        0x000F130E, 0x0010140F, 0x0010140F, 0x0010140F, 0x000F130E, 0x0010140F, 0x00111510, 0x00141812, 0x00151913, 0x00171B15, 0x00191D17, 0x001C201A, 0x0021251F, 0x00272B25, 0x002B2F29, 0x003E423C, 0x00434741, 0x004C504A, 0x00555953, 0x005C605A,
        0x0061655F, 0x00656963, 0x00676B65, 0x00616861, 0x00616861, 0x00616861, 0x00606760, 0x005E655E, 0x005D645D, 0x005E655E, 0x005F665F, 0x00656963, 0x00656963, 0x00676B65, 0x00676B65, 0x00676B65, 0x00666A64, 0x00666A64, 0x00656963, 0x00686C66,
        0x00696D67, 0x006A6E68, 0x00696D67, 0x00676B65, 0x00686C66, 0x006B6F69, 0x006E726C, 0x00696D67, 0x006A6E68, 0x006B6F69, 0x006A6E68, 0x00686C66, 0x00636761, 0x005E625C, 0x005B5F59, 0x004E524C, 0x004E524C, 0x004E524C, 0x0050544E, 0x00555953,
        0x005C605A, 0x00636761, 0x00676B65, 0x00656D63, 0x00676F65, 0x00697069, 0x006A716A, 0x00696F6A, 0x00696F6A, 0x006A706B, 0x006B706E, 0x00666765, 0x00686967, 0x00676866, 0x00656664, 0x00696A68, 0x0D787977, 0x368C8D8B, 0x4F989997, 0xABC3C3C3,
        0xC9D2D2D2, 0xFBE9E9E9, 0xFFFAFAFA, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFDFDFD, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFDFDFD, 0xFFFAFAFA, 0xFFFCFCFC, 0xFFFEFEFE, 0xFFFEFEFE, 0xFFFCFCFC, 0xFFFCFCFC, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFEFF,
        0xFFFFFEFF, 0xFFFFFDFE, 0xFFFFFDFE, 0xFFFFFDFD, 0xFFFFFEFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFDFDFD, 0xFFFEFEFE, 0xFFFEFEFE, 0xFFFEFEFE, 0xFFFDFDFD, 0xFFFDFDFD, 0xFFFDFDFD, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFDFDFD, 0xFFFEFEFE, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFDFCFF, 0xFFFFFFFF, 0xFFFFFFFC, 0xFFF6F9F0, 0x004F5249, 0x00050701, 0x000E0F0B, 0x000E0F0D, 0x000A0E08,
        0x000A0E08, 0x000A0E08, 0x000A0E08, 0x000A0E08, 0x000A0E08, 0x000A0E08, 0x000A0E08, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000C0D09, 0x000C0D09, 0x000C0D09, 0x000C0D09, 0x000C0D09,
        0x000C0D09, 0x000C0D09, 0x000C0D09, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000A0E09, 0x000A0E09, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000C100B, 0x000C100B, 0x000B0F0A,
        0x000D110C, 0x000F130E, 0x0010140F, 0x00111510, 0x00111510, 0x00111510, 0x00121611, 0x000F130D, 0x0011150F, 0x00131711, 0x00151913, 0x00151913, 0x00171B15, 0x00191D17, 0x001B1F19, 0x00161A14, 0x001B1F19, 0x00232721, 0x002C302A, 0x00353933,
        0x003F433D, 0x00484C46, 0x004E524C, 0x005E625C, 0x0061655F, 0x00656963, 0x00686C66, 0x00686C66, 0x00686C66, 0x00676B65, 0x00676B65, 0x0060645E, 0x00626660, 0x00656963, 0x00676B65, 0x00686C66, 0x00686C66, 0x00686C66, 0x00686C66, 0x00666A64,
        0x00676B65, 0x00686C66, 0x00676B65, 0x00666A64, 0x00666A64, 0x00686C66, 0x00696D67, 0x00656963, 0x00666A64, 0x00676B65, 0x00686C66, 0x00696D67, 0x00696D67, 0x00686C66, 0x00686C66, 0x006D716B, 0x006A6E68, 0x00656963, 0x005F635D, 0x00585C56,
        0x0051554F, 0x004C504A, 0x00494D47, 0x0051594F, 0x00555D53, 0x005C635C, 0x00636A63, 0x00686E69, 0x006B716C, 0x006B716C, 0x006B706E, 0x006B6F6A, 0x006E726D, 0x0070746F, 0x006E726D, 0x006B6F6A, 0x006A6E69, 0x006C706B, 0x006E726D, 0x006B6C6A,
        0x00737472, 0x1D80817F, 0x43929391, 0x71A8A9A7, 0xA7C3C4C2, 0xE2DEDFDD, 0xFFEFF0EE, 0xFFFEFFFD, 0xFFFEFFFD, 0xFFFEFFFD, 0xFFFEFFFD, 0xFFFDFEFC, 0xFFFDFEFC, 0xFFFEFFFD, 0xFFFFFFFE, 0xFFFDFEFC, 0xFFFDFEFC, 0xFFFDFEFC, 0xFFFEFFFD, 0xFFFFFFFE,
        0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFEFEFE, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFCFCFC, 0xFFFCFCFC, 0xFFFDFDFD, 0xFFFDFDFD, 0xFFFEFEFE,
        0xFFFEFEFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFDFDFD, 0xFFFCFCFC, 0xFFFDFDFD, 0xFFFEFEFE, 0xFFFFFEFF,
        0xFFFFFCFD, 0xFFFEF9FA, 0xFFFFFDFD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFCFCFC, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFEFEFE, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFDFF, 0xFFFFFFFF, 0xFFFFFFFC, 0xFBEFF2E9, 0x0044473E, 0x00060802, 0x000D0E0A, 0x000E0F0D, 0x000A0E08,
        0x000A0E08, 0x000A0E08, 0x000A0E08, 0x000A0E08, 0x000A0E08, 0x000A0E08, 0x000A0E08, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000C0D09, 0x000C0D09, 0x000C0D09, 0x000C0D09, 0x000C0D09,
        0x000C0D09, 0x000C0D09, 0x000C0D09, 0x000C0D09, 0x000C0D09, 0x000C0D09, 0x000C0D09, 0x000C0D09, 0x000C0D09, 0x000C0D09, 0x000C0D09, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000C100B, 0x000C100B, 0x000C100B, 0x000C100B, 0x000C100B, 0x000C100B,
        0x000C100B, 0x000B0F0A, 0x000B0F0A, 0x000C100B, 0x000C100B, 0x000C100B, 0x000C100B, 0x000C100A, 0x000F130D, 0x0011150F, 0x00131711, 0x00131711, 0x00131711, 0x00131711, 0x00141812, 0x00151913, 0x00171B15, 0x00181C16, 0x00181C16, 0x00191D17,
        0x001A1E18, 0x001E221C, 0x0021251F, 0x0030342E, 0x00363A34, 0x0040443E, 0x004B4F49, 0x00555953, 0x005E625C, 0x00666A64, 0x006B6F69, 0x00686C66, 0x00696D67, 0x006A6E68, 0x00696D67, 0x00676B65, 0x00676B65, 0x00686C66, 0x006A6E68, 0x00656963,
        0x00646862, 0x00636761, 0x00656963, 0x00676B65, 0x00696D67, 0x00696D67, 0x00686C66, 0x006E726C, 0x006C706A, 0x00696D67, 0x00676B65, 0x00676B65, 0x00696D67, 0x006C706A, 0x006E726C, 0x00676B65, 0x00676B65, 0x00696D67, 0x00696D67, 0x00696D67,
        0x00686C66, 0x00666A64, 0x00656963, 0x00575F55, 0x00525A50, 0x004C534C, 0x00495049, 0x004B514C, 0x00515752, 0x00585E59, 0x005C615F, 0x006E726D, 0x006F736E, 0x0070746F, 0x00717570, 0x006F736E, 0x006E726D, 0x0070746F, 0x00727671, 0x00777874,
        0x00757672, 0x0071726E, 0x006D6E6A, 0x006C6D69, 0x0072736F, 0x0D7B7C78, 0x1D838480, 0x43939492, 0x75ABACAA, 0xBCCDCECC, 0xF7E9EAE8, 0xFFF8F9F7, 0xFFFEFFFD, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE,
        0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFEFEFE, 0xFFFDFDFD, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFCFCFC, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFEFE,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFBFDFD, 0xFFF9FBFB, 0xFFF9FEFD, 0xFFFBFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFDFDFD, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFEFF, 0xFFFFFFFF, 0xFFFFFFFC, 0xEAE8EBE2, 0x00393C33, 0x00070903, 0x000D0E0A, 0x000E0F0D, 0x00090D07,
        0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x000B0C08, 0x000B0C08, 0x000B0C08, 0x000B0C08, 0x000B0C08,
        0x000B0C08, 0x000B0C08, 0x000B0C08, 0x000C0D09, 0x000C0D09, 0x000C0D09, 0x000C0D09, 0x000C0D09, 0x000C0D09, 0x000C0D09, 0x000C0D09, 0x000B0F0A, 0x000B0F0A, 0x000C100B, 0x000C100B, 0x000C100B, 0x000C100B, 0x000D110C, 0x000D110C, 0x000C100B,
        0x000B0F0A, 0x000A0E09, 0x000A0E09, 0x000B0F0A, 0x000C100B, 0x000C100B, 0x000C100B, 0x000A0E08, 0x000B0F09, 0x000C100A, 0x000D110B, 0x000D110B, 0x0010140E, 0x00131711, 0x00161A14, 0x00181C16, 0x00191D17, 0x001B1F19, 0x001B1F19, 0x001A1E18,
        0x00181C16, 0x00161A14, 0x00161A14, 0x0012140E, 0x00151711, 0x001A1C16, 0x0021231D, 0x002A2C26, 0x00353731, 0x0040423C, 0x00474943, 0x00555953, 0x005B5F59, 0x00636761, 0x00696D67, 0x006B6F69, 0x006B6F69, 0x006D716B, 0x006E726C, 0x0070746E,
        0x006C706A, 0x00686C66, 0x00666A64, 0x00676B65, 0x00676B65, 0x00656963, 0x00646862, 0x0061655F, 0x00636761, 0x00666A64, 0x00686C66, 0x00696D67, 0x00686C66, 0x00676B65, 0x00666A64, 0x006D716B, 0x006C706A, 0x006A6E68, 0x00696D67, 0x00696D67,
        0x00696D67, 0x006A6E68, 0x006B6F69, 0x00656D63, 0x00666E64, 0x00666D66, 0x00656C65, 0x00606661, 0x00595F5A, 0x00525853, 0x004D5250, 0x004D534E, 0x00505651, 0x00585E59, 0x00616762, 0x00686E69, 0x006A706B, 0x006D736E, 0x00707671, 0x0072746E,
        0x0072746E, 0x0071736D, 0x0070726C, 0x006E706A, 0x006E706A, 0x006F716B, 0x0070726C, 0x006A6B67, 0x006C6D69, 0x006E6F6B, 0x0072736F, 0x157F807C, 0x4B999A96, 0x92BABBB7, 0xC4D2D3CF, 0xFBECEDE9, 0xFFF2F3EF, 0xFFFCFDF9, 0xFFFFFFFC, 0xFFFFFFFC,
        0xFFFFFFFC, 0xFFFEFFFB, 0xFFFCFDF9, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFCFCFC, 0xFFFCFCFC, 0xFFFDFDFD, 0xFFFEFEFE, 0xFFFEFEFE, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF8F8F8, 0xFFF9F9F9, 0xFFF8F8F8, 0xFFF5F5F5, 0xFFF3F3F3, 0xFFFAFAFA, 0xFFFBFBFB, 0xFFFCFCFC, 0xFFFDFDFD, 0xFFFEFEFE,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFDFDFD, 0xFFFBFBFB, 0xFFFCFCFC, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF9FEFD,
        0xFFFBFFFF, 0xFFF7FCFB, 0xF7E8EEED, 0xD5D7DDDC, 0xCDD3D9D8, 0xE2DDE5E4, 0xFFEBF3F2, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFCFCFC, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFF9F9F9, 0xFFFCFCFC, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFEFEFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFEFF, 0xFFFEFEFE, 0xFFFFFFFC, 0xE2E3E6DD, 0x0032352C, 0x00080A04, 0x000C0D09, 0x000D0E0C, 0x00090D07,
        0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x000B0C08, 0x000B0C08, 0x000B0C08, 0x000B0C08, 0x000B0C08,
        0x000B0C08, 0x000B0C08, 0x000B0C08, 0x000C0D09, 0x000C0D09, 0x000C0D09, 0x000C0D09, 0x000C0D09, 0x000C0D09, 0x000C0D09, 0x000C0D09, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000C100B, 0x000C100B, 0x000C100B, 0x000B0F0A,
        0x000A0E09, 0x000A0E09, 0x000B0F0A, 0x000D110C, 0x000F130E, 0x000F130E, 0x000E120D, 0x000D110B, 0x000D110B, 0x000D110B, 0x000B0F09, 0x000A0E08, 0x000B0F09, 0x000E120C, 0x0010140E, 0x000C100A, 0x000D110B, 0x0010140E, 0x00141812, 0x00181C16,
        0x001A1E18, 0x001B1F19, 0x001B1F19, 0x0020221C, 0x001F211B, 0x001C1E18, 0x00191B15, 0x00161812, 0x00171913, 0x00191B15, 0x001B1D17, 0x0020241E, 0x00292D27, 0x00383C36, 0x00454943, 0x0051554F, 0x005B5F59, 0x00646862, 0x006A6E68, 0x006C706A,
        0x006D716B, 0x006E726C, 0x006C706A, 0x006A6E68, 0x00686C66, 0x00676B65, 0x00666A64, 0x00676B65, 0x00676B65, 0x00676B65, 0x00676B65, 0x00676B65, 0x00676B65, 0x00676B65, 0x00676B65, 0x00676B65, 0x00696D67, 0x006D716B, 0x006F736D, 0x006F736D,
        0x006D716B, 0x00696D67, 0x00676B65, 0x00636B61, 0x00646C62, 0x00666D66, 0x00666D66, 0x00666C67, 0x00666C67, 0x00676D68, 0x00676C6A, 0x00646B64, 0x005C635C, 0x00545B54, 0x00505750, 0x004E554E, 0x004E554E, 0x00525952, 0x00575E57, 0x00696C63,
        0x006C6F66, 0x0072756C, 0x00777A71, 0x007A7D74, 0x00797C73, 0x0075786F, 0x0072756C, 0x006E6F6B, 0x0071726E, 0x00747571, 0x00737470, 0x0071726E, 0x0070716D, 0x0070716D, 0x0072736F, 0x157E7F7B, 0x328D8E8A, 0x69A6A7A3, 0x9BBFC0BC, 0xCDD6D7D3,
        0xF7EBECE8, 0xFFFCFDF9, 0xFFFFFFFC, 0xFFFCFCFC, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFDFDFD, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFEDEDED, 0xFBE9E9E9, 0xEEE4E4E4, 0xDEDCDCDC, 0xD1D6D6D6, 0xD1D5D5D5, 0xD5D7D7D7, 0xDEDBDBDB, 0xEAE1E1E1, 0xF7E7E7E7,
        0xFFEDEDED, 0xFFF1F1F1, 0xFFF4F4F4, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF4F4F4, 0xFBEAEAEA, 0xFBEAEAEA, 0xFFF2F2F2, 0xFFFBFBFB, 0xFFFEFEFE, 0xFFFDFDFD, 0xFFFAFFFF,
        0xFFEDF3F2, 0xCDD3DBDA, 0x9FBDC5C4, 0x00B1B9B8, 0x00B1BCBA, 0x9BBCC7C5, 0xB0C6D1CF, 0xC9D2D2D2, 0xD5D8D8D8, 0xDEDBDBDB, 0xD5D7D7D7, 0xC4CFCFCF, 0xB8CACACA, 0xC0CECECE, 0xCDD4D4D4, 0xFFECECEC, 0xFFF2F2F2, 0xFFFAFAFA, 0xFFFEFEFE, 0xFFFEFEFE,
        0xFFFDFDFD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFEFF, 0xFFFEFEFE, 0xFFFFFFFC, 0xD9E0E3DA, 0x002E3128, 0x00090B05, 0x000C0D09, 0x000C0D0B, 0x00090D07,
        0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x000B0C08, 0x000B0C08, 0x000B0C08, 0x000B0C08, 0x000B0C08,
        0x000B0C08, 0x000B0C08, 0x000B0C08, 0x000C0D09, 0x000C0D09, 0x000C0D09, 0x000C0D09, 0x000C0D09, 0x000C0D09, 0x000C0D09, 0x000C0D09, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A,
        0x000A0E09, 0x00090D08, 0x000A0E09, 0x000C100B, 0x000C100B, 0x000A0E09, 0x00080C07, 0x00080C06, 0x00090D07, 0x000B0F09, 0x000B0F09, 0x000A0E08, 0x000A0E08, 0x000B0F09, 0x000C100A, 0x00121610, 0x0010140E, 0x000E120C, 0x000F130D, 0x00121610,
        0x00161A14, 0x00171B15, 0x00181C16, 0x00191B15, 0x001B1D17, 0x001C1E18, 0x001C1E18, 0x001B1D17, 0x00191B15, 0x00191B15, 0x001A1C16, 0x00161A14, 0x00161A14, 0x00151913, 0x00151913, 0x00191D17, 0x00232721, 0x0031352F, 0x003B3F39, 0x00484C46,
        0x00525650, 0x005E625C, 0x00656963, 0x00676B65, 0x00676B65, 0x00696D67, 0x006C706A, 0x00676B65, 0x00676B65, 0x00676B65, 0x00676B65, 0x00666A64, 0x00676B65, 0x00676B65, 0x00676B65, 0x00666A64, 0x00666A64, 0x00666A64, 0x00666A64, 0x00676B65,
        0x00696D67, 0x006A6E68, 0x006B6F69, 0x00687066, 0x00697167, 0x00697069, 0x00686F68, 0x00666C67, 0x00656B66, 0x00646A65, 0x00656A68, 0x00666D66, 0x00646B64, 0x00656C65, 0x00697069, 0x00686F68, 0x00616861, 0x005B625B, 0x005A615A, 0x0052554C,
        0x0051544B, 0x0052554C, 0x00575A51, 0x0060635A, 0x006A6D64, 0x0071746B, 0x0074776E, 0x00797A76, 0x00787975, 0x00767773, 0x00757672, 0x00767773, 0x00757672, 0x00737470, 0x0071726E, 0x006D6E6A, 0x006D6E6A, 0x006D6E6A, 0x006D6E6A, 0x00737470,
        0x1D82837F, 0x47969793, 0x69A6A7A3, 0xBCCBCBCB, 0xE2DDDDDD, 0xFFF3F3F3, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xF7E8EAEA, 0xEAE1E3E3, 0x00DDDFDF, 0x00D3D5D5, 0x00C7C9C9, 0x00B4B9B8, 0x00AFB4B3, 0x00AFB4B3, 0x00B1B6B5, 0x7DADB2B1,
        0x79ACB1B0, 0x86B1B6B5, 0x8AB4B9B8, 0x9BBBC0BF, 0xB0C6CBCA, 0xC0CED3D2, 0xE6E0E5E4, 0xE2DEE3E2, 0xF2E6EBEA, 0xFFEBF0EF, 0xFFF1F6F5, 0xE6DFE5E4, 0x7DADB3B2, 0x60A0A6A5, 0x82B0B8B7, 0x79ACB4B3, 0xA3BFCAC8, 0xABC4CFCD, 0xD1D6E1DF, 0xC9D2DDDB,
        0x96BAC5C3, 0x7DADB8B6, 0x00AEBBB9, 0x00B3C0BE, 0x00B9C7C5, 0x00BDCBC9, 0x00BCCAC8, 0x00B0B8B7, 0x00A7B2B0, 0x00A0ABA9, 0x0097A5A1, 0x00A4B2AE, 0x00A2B2AB, 0x00A3B5AE, 0x4F98AAA3, 0x64A2ACA6, 0x6DA6B0AA, 0x8EB6BDB8, 0xBCCBD2CF, 0xD9DADFDD,
        0xF2E5E7E7, 0xFFF1F3F3, 0xFFFDFFFF, 0xFFFCFCFC, 0xFFFCFCFC, 0xFFFFFDFD, 0xFFFFFEFE, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFDFE, 0xFFFFFDFF, 0xFFFFFBFC, 0xFFFFFFFC, 0xC0D5D6CD, 0x0021241B, 0x000E100A, 0x000A0E09, 0x000A0D0B, 0x00080C06,
        0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08,
        0x00090D08, 0x00090D08, 0x00090D08, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000D0E0A,
        0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000E0F0B, 0x000E0F0B, 0x000E0F0B, 0x000D0E0A, 0x000D0E0A, 0x000E0F0B, 0x000C100B, 0x000C100B, 0x000A100B, 0x000B110C, 0x000B110C, 0x000D110C, 0x000D110C, 0x000D110C, 0x000D110C, 0x000E120D,
        0x000E120D, 0x000E120D, 0x000E120D, 0x00141813, 0x00141813, 0x00161A15, 0x00181C17, 0x001A1E19, 0x001B1F1A, 0x001D211C, 0x001E221D, 0x00181C16, 0x00171B15, 0x00161A14, 0x00151913, 0x00141812, 0x00131711, 0x00121610, 0x00121610, 0x001C201B,
        0x001F231E, 0x00252924, 0x0030342F, 0x003D413C, 0x004C504B, 0x00585C57, 0x005F635E, 0x00646862, 0x00656963, 0x00676B65, 0x00696D67, 0x006A6E68, 0x00696D67, 0x00696D67, 0x00686C66, 0x00656963, 0x00656963, 0x00656963, 0x00666A64, 0x00676B65,
        0x00676B65, 0x00676B65, 0x00676B65, 0x00676B65, 0x00676B65, 0x00686C66, 0x00696D67, 0x006A6E68, 0x006B6F69, 0x006C706A, 0x006B6F69, 0x006A6E68, 0x006A6E68, 0x00696D67, 0x00676B65, 0x00656963, 0x00646862, 0x00666A64, 0x00676B65, 0x006C706A,
        0x00696D67, 0x00636761, 0x005D615B, 0x00565A54, 0x00525650, 0x004E524C, 0x004D514B, 0x005D6259, 0x0062675E, 0x00696D67, 0x0070746E, 0x00757974, 0x00767A75, 0x00757974, 0x00747775, 0x00757771, 0x00757771, 0x00767872, 0x00757771, 0x0072746E,
        0x006F716B, 0x006C6E68, 0x006A6C66, 0x006F716B, 0x00757771, 0x1D848680, 0x4F9C9E98, 0x86B5B7B1, 0xB8CED0CA, 0xEEE7E9E3, 0xFFF9FBF5, 0xFFFEFFFD, 0xFFFEFFFD, 0xFFFFFFFE, 0xFFFDFEFC, 0xFFFCFDFB, 0xFFFFFFFE, 0xFFFEFFFD, 0xFFFCFDFB, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFEFEFE, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFCFCFC, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xF2E5E7E7, 0x00DCDEDE, 0x00D4D6D6, 0x00C5C7C7, 0x00B6B8B8, 0x009EA4A3, 0x009EA4A3, 0x00959B9A, 0x00929897, 0x00969C9B,
        0x008F9594, 0x00878D8C, 0x008D9392, 0x009AA09F, 0x00B6BCBB, 0x00ADB3B2, 0x009DA3A2, 0x009FA5A4, 0x82B0B6B5, 0x7DAEB4B3, 0x9BBBC1C0, 0x7DADB3B2, 0x00989E9D, 0x00959D9C, 0x00A6AEAD, 0x009EA6A5, 0x009BA6A4, 0x009DA8A6, 0x00A5B0AE, 0x009CA7A5,
        0x00A0ABA9, 0x00A3AEAC, 0x00A3B0AE, 0x00AAB7B5, 0x00B5C3C1, 0x00B8C6C4, 0x00AFBDBB, 0x00B3BEBC, 0x00ADB8B6, 0x00AFBAB8, 0x00ACBAB6, 0x00BDCBC7, 0x00BBCBC4, 0x00B3C3BC, 0x00A9B9B2, 0x00A0ACA6, 0x0099A59F, 0x0098A29C, 0x009EA7A4, 0x00A5ACA9,
        0x71A7ADAC, 0x7DAEB3B2, 0x92B7BCBB, 0xC9D2D7D6, 0xE2DDDFDF, 0xFBE9EBEB, 0xFFF4F6F6, 0xFFFBFBFB, 0xFFFDFDFD, 0xFFFFFDFD, 0xFFFFFEFE, 0xFFFFFDFF, 0xFFFFFFFF, 0xFFFFFFFC, 0xB4D0D1C8, 0x001A1D14, 0x00090B05, 0x000A0E09, 0x000B0E0C, 0x00080C06,
        0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08,
        0x00090D08, 0x00090D08, 0x00090D08, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000C0D09,
        0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000E0F0B, 0x000E0F0B, 0x000D0E0A, 0x000D0E0A, 0x000E0F0B, 0x000C100B, 0x000C100B, 0x000A100B, 0x000B110C, 0x000B110C, 0x000D110C, 0x000D110C, 0x000D110C, 0x000D110C, 0x000E120D,
        0x000E120D, 0x000E120D, 0x000E120D, 0x000F130E, 0x0010140F, 0x00111510, 0x00121611, 0x00141813, 0x00151914, 0x00161A15, 0x00171B16, 0x00181C16, 0x00181C16, 0x00181C16, 0x00171B15, 0x00171B15, 0x00171B15, 0x00171B15, 0x00171B15, 0x00131712,
        0x00131712, 0x00131712, 0x00161A15, 0x001A1E19, 0x001F231E, 0x00242823, 0x00272B26, 0x00383C36, 0x0040443E, 0x004D514B, 0x005B5F59, 0x00656963, 0x006A6E68, 0x006B6F69, 0x006A6E68, 0x006B6F69, 0x006B6F69, 0x00696D67, 0x00686C66, 0x00666A64,
        0x00666A64, 0x00666A64, 0x00676B65, 0x00656963, 0x00666A64, 0x00676B65, 0x00696D67, 0x006A6E68, 0x006B6F69, 0x006B6F69, 0x006B6F69, 0x006C706A, 0x006D716B, 0x006F736D, 0x006E726C, 0x006C706A, 0x00696D67, 0x00686C66, 0x00676B65, 0x00646862,
        0x00646862, 0x00636761, 0x00636761, 0x00636761, 0x00636761, 0x00646862, 0x00646862, 0x00575C53, 0x00555A51, 0x00525650, 0x0051554F, 0x00555954, 0x005D615C, 0x00656964, 0x006A6D6B, 0x00787A74, 0x00797B75, 0x007A7C76, 0x007B7D77, 0x007B7D77,
        0x007A7C76, 0x007A7C76, 0x00797B75, 0x00767872, 0x0071736D, 0x006E706A, 0x006D6F69, 0x006D6F69, 0x0070726C, 0x08797B75, 0x1981837D, 0x69A4A5A3, 0x8AB4B5B3, 0xCDD5D6D4, 0xFFECEDEB, 0xFFFDFEFC, 0xFFFFFFFE, 0xFFFEFFFD, 0xFFFFFFFE, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFBFBFB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xF7E7E9E9, 0xE2DEE0E0, 0x00D4D6D6, 0x00C2C4C4, 0x00B2B4B4, 0x008C9493, 0x008E9695, 0x00798180, 0x006E7675, 0x0078807F,
        0x006E7675, 0x005F6766, 0x0068706F, 0x00707B79, 0x009AA5A3, 0x009EA9A7, 0x00717C7A, 0x006D7876, 0x00B2BDBB, 0x00B5C0BE, 0x008E9997, 0x00969C9B, 0x00919998, 0x00919998, 0x00A2AAA9, 0x00A6B1AF, 0x009BA6A4, 0x00A4B1AF, 0x0099A6A4, 0x009FAAA8,
        0x00ABB6B4, 0x00ADB8B6, 0x009FACAA, 0x009AA7A5, 0x009EACAA, 0x00A1AFAD, 0x00A0AEAC, 0x00AAB7B5, 0x0098A5A3, 0x009EABA9, 0x009CAAA6, 0x00ACBAB6, 0x00AFBDB7, 0x00A9B7B1, 0x00A6B6AF, 0x009EACA6, 0x009BA9A3, 0x009FABA5, 0x00A3AEAB, 0x00A2ADAA,
        0x009FAAA8, 0x00A0ABA9, 0x00A5B0AE, 0x009FA7A6, 0x00A2AAA9, 0x6DA6AEAD, 0x7DADB3B2, 0x92B7BDBC, 0xB4C7CDCC, 0xDEDBE0DF, 0xFBE9EEED, 0xFFF5F4F8, 0xFFFCFCFC, 0xFFFFFFFC, 0xA7C7CAC1, 0x00181B12, 0x00070B05, 0x00090D08, 0x00090C0A, 0x00080C06,
        0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08,
        0x00090D08, 0x00090D08, 0x00090D08, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000C0D09,
        0x000C0D09, 0x000C0D09, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000E0F0B, 0x000D0E0A, 0x000D0E0A, 0x000E0F0B, 0x000C100B, 0x000C100B, 0x000A100B, 0x000B110C, 0x000B110C, 0x000D110C, 0x000D110C, 0x000D110C, 0x000D110C, 0x000E120D,
        0x000E120D, 0x000E120D, 0x000E120D, 0x000D110C, 0x000D110C, 0x000E120D, 0x000F130E, 0x0010140F, 0x00111510, 0x00111510, 0x00111510, 0x00151913, 0x00151913, 0x00161A14, 0x00161A14, 0x00171B15, 0x00181C16, 0x00181C16, 0x00191D17, 0x00181C17,
        0x00161A15, 0x00141813, 0x00121611, 0x00111510, 0x00111510, 0x00111510, 0x00121611, 0x00171B15, 0x00181C16, 0x001C201A, 0x00232721, 0x002E322C, 0x003B3F39, 0x00474B45, 0x004E524C, 0x005B5F59, 0x0061655F, 0x00676B65, 0x006B6F69, 0x006C706A,
        0x006C706A, 0x006C706A, 0x006D716B, 0x00696D67, 0x00696D67, 0x00676B65, 0x00666A64, 0x00656963, 0x00666A64, 0x00686C66, 0x006A6E68, 0x006C706A, 0x006D716B, 0x006C706A, 0x006B6F69, 0x00696D67, 0x00696D67, 0x006A6E68, 0x006C706A, 0x00676B65,
        0x00676B65, 0x00676B65, 0x00666A64, 0x00656963, 0x00646862, 0x00636761, 0x00636761, 0x006D7269, 0x006D7269, 0x006C706A, 0x00696D67, 0x00646863, 0x005E625D, 0x00595D58, 0x00565957, 0x00575953, 0x005B5D57, 0x0062645E, 0x006A6C66, 0x0072746E,
        0x00787A74, 0x007C7E78, 0x007E807A, 0x007A7C76, 0x00797B75, 0x00797B75, 0x00787A74, 0x00747670, 0x006E706A, 0x006A6C66, 0x006A6C66, 0x00646563, 0x00626361, 0x00686967, 0x04747573, 0x2E898A88, 0x60A0A19F, 0x9FBFC0BE, 0xF2E6E7E5, 0xFFFDFDFD,
        0xFFFFFFFF, 0xFFFCFCFC, 0xFFFFFFFF, 0xFFFDFDFD, 0xFFFBFBFB, 0xFFFFFFFF, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFECEEEE, 0xEEE4E6E6, 0x00D8DADA, 0x00C6C8C8, 0x00B6B8B8, 0x0097A2A0, 0x009AA5A3, 0x0085908E, 0x0076817F, 0x00798482,
        0x006A7573, 0x00576260, 0x005D6866, 0x0064716F, 0x00626F6D, 0x00515E5C, 0x005F6C6A, 0x0097A4A2, 0x00AEBBB9, 0x00869391, 0x0093A09E, 0x008B9392, 0x00899190, 0x00858D8C, 0x008E9997, 0x0099A4A2, 0x0093A09E, 0x00B7C4C2, 0x00A4B1AF, 0x0097A2A0,
        0x00A5B0AE, 0x00B2BDBB, 0x00B2BFBD, 0x00A5B2B0, 0x0093A19F, 0x00909E9C, 0x009AA8A6, 0x0094A2A0, 0x00798785, 0x008D9A98, 0x008E9C98, 0x00909E9A, 0x008F9D97, 0x008B9993, 0x008B9791, 0x008F9D97, 0x0097A59F, 0x00A2B0AA, 0x00A6B4B0, 0x009DACA8,
        0x0092A09E, 0x00909E9C, 0x0095A3A1, 0x0098A6A4, 0x0098A6A4, 0x0096A3A1, 0x00929F9D, 0x008E9B99, 0x00909B99, 0x00939E9C, 0x4B96A19F, 0x8EB5B8BC, 0x9FBDC2C1, 0xBCCBD1CC, 0x60A3A89F, 0x000E130A, 0x00080C06, 0x000C100B, 0x000B0E0C, 0x00080C06,
        0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08,
        0x00090D08, 0x00090D08, 0x00090D08, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000C0D09,
        0x000C0D09, 0x000C0D09, 0x000C0D09, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000E0F0B, 0x000C100B, 0x000C100B, 0x000A100B, 0x000B110C, 0x000B110C, 0x000D110C, 0x000D110C, 0x000D110C, 0x000D110C, 0x000E120D,
        0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000F130E, 0x000F130E, 0x000F130E, 0x0010140F, 0x0010140F, 0x0010140F, 0x0010140E, 0x0010140E, 0x0011150F, 0x00121610, 0x00131711, 0x00141812, 0x00141812, 0x00151913, 0x00181C17,
        0x00181C17, 0x00171B16, 0x00161A15, 0x00151914, 0x00151914, 0x00151914, 0x00151914, 0x000F130D, 0x000F130D, 0x000E120C, 0x000E120C, 0x00121610, 0x00171B15, 0x001C201A, 0x001F231D, 0x00292D27, 0x00323630, 0x0041453F, 0x004E524C, 0x00585C56,
        0x0060645E, 0x00686C66, 0x006D716B, 0x006C706A, 0x006D716B, 0x006F736D, 0x006F736D, 0x006E726C, 0x006D716B, 0x006D716B, 0x006D716B, 0x00676B65, 0x00696D67, 0x006C706A, 0x006D716B, 0x006C706A, 0x006B6F69, 0x006A6E68, 0x006A6E68, 0x006A6E68,
        0x006B6F69, 0x006C706A, 0x006C706A, 0x006B6F69, 0x006A6E68, 0x00696D67, 0x00686C66, 0x0063685F, 0x00666B62, 0x006A6E68, 0x006E726C, 0x00717570, 0x00717570, 0x0070746F, 0x006F7270, 0x006C706A, 0x00676B65, 0x005E625C, 0x00585C56, 0x00555953,
        0x00585C56, 0x005C605A, 0x0060645E, 0x0070746E, 0x00747872, 0x007B7F79, 0x0081857F, 0x00828680, 0x007E827C, 0x00787C76, 0x00757973, 0x006C706B, 0x006E726D, 0x006D716C, 0x006B6F6A, 0x00646863, 0x00555954, 0x00545853, 0x00686C67, 0xDEDBDBDB,
        0xFFFFFFFF, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFBFBFB, 0xFFFFFFFF, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFEFF1F1, 0xF7E8EAEA, 0xDEDCDEDE, 0xBCCCCECE, 0x00BEC0C0, 0x00B4BFBD, 0x00ADB8B6, 0x0098A3A1, 0x00848F8D, 0x00798482,
        0x00717C7A, 0x006D7876, 0x00717C7A, 0x00798684, 0x0083908E, 0x00778482, 0x00697674, 0x00818E8C, 0x00A0ADAB, 0x00879492, 0x008A9795, 0x008D9594, 0x008E9695, 0x008E9997, 0x00919C9A, 0x008B9896, 0x00899694, 0x00B9C7C5, 0x00A9B7B5, 0x0098A3A1,
        0x00A6B1AF, 0x00BAC5C3, 0x00C1CECC, 0x00B2BFBD, 0x0097A5A3, 0x008E9C9A, 0x0095A3A1, 0x007B8C89, 0x005F706D, 0x007C8A88, 0x007F8D89, 0x00778581, 0x007E8A84, 0x0086928C, 0x0086908A, 0x00818D87, 0x0089958F, 0x00939F99, 0x0096A4A0, 0x0091A09C,
        0x008C9D9A, 0x008FA09D, 0x0095A6A3, 0x0093A4A1, 0x0092A3A0, 0x0092A3A0, 0x0096A4A2, 0x0098A6A4, 0x0098A6A4, 0x0096A3A1, 0x0093A09E, 0x008C9396, 0x008B9392, 0x009AA19C, 0x007F887E, 0x00070F05, 0x000A0E08, 0x000C100B, 0x000D0E0C, 0x00080C06,
        0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08,
        0x00090D08, 0x00090D08, 0x00090D08, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000C0D09,
        0x000C0D09, 0x000C0D09, 0x000C0D09, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000E0F0B, 0x000C100B, 0x000C100B, 0x000A100B, 0x000B110C, 0x000B110C, 0x000D110C, 0x000D110C, 0x000D110C, 0x000D110C, 0x000E120D,
        0x000E120D, 0x000E120D, 0x000E120D, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000E120C, 0x000F130D, 0x000F130D, 0x000F130D, 0x0010140E, 0x0010140E, 0x0011150F, 0x0011150F, 0x00141813,
        0x00141813, 0x00141813, 0x00131712, 0x00131712, 0x00121611, 0x00121611, 0x00121611, 0x00131711, 0x00141812, 0x00151913, 0x00151913, 0x00151913, 0x00131711, 0x0011150F, 0x000F130D, 0x000E120C, 0x00121610, 0x00171B15, 0x001D211B, 0x00242822,
        0x002E322C, 0x003A3E38, 0x00434741, 0x00565A54, 0x005D615B, 0x00676B65, 0x006E726C, 0x0070746E, 0x006F736D, 0x006E726C, 0x006D716B, 0x006C706A, 0x006B6F69, 0x00696D67, 0x00666A64, 0x00646862, 0x00656963, 0x00676B65, 0x00696D67, 0x00666A64,
        0x00676B65, 0x00696D67, 0x006A6E68, 0x006B6F69, 0x006A6E68, 0x00686C66, 0x00676B65, 0x0061665D, 0x0061665D, 0x0061655F, 0x00626660, 0x00636762, 0x00656964, 0x00676B66, 0x00686B69, 0x00666A64, 0x00696D67, 0x006D716B, 0x006F736D, 0x006D716B,
        0x00676B65, 0x005F635D, 0x005B5F59, 0x00575B55, 0x005A5E58, 0x005E625C, 0x00646862, 0x006A6E68, 0x0071756F, 0x00767A74, 0x00787C76, 0x0070746F, 0x00747873, 0x006E726D, 0x00666A65, 0x005B5F5A, 0x004C504B, 0x004A4E49, 0x00535752, 0x75A9A9A9,
        0xFFFBFBFB, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF7F9F9, 0xFFF3F5F5, 0xFFECEEEE, 0xEAE2E4E4, 0xD9DADCDC, 0xB8C9CFCE, 0xA3BFC5C4, 0x86B2B8B7, 0x60A0A6A5, 0x00909695,
        0x008F9594, 0x00959B9A, 0x00959B9A, 0x00798482, 0x00747F7D, 0x009CA7A5, 0x00ADB8B6, 0x00879290, 0x008A9593, 0x008F9A98, 0x008E9997, 0x00818C8A, 0x00808B89, 0x0086918F, 0x008B9896, 0x0083908E, 0x00818F8D, 0x009CAAA8, 0x008D9B99, 0x0095A09E,
        0x009DA8A6, 0x00A9B4B2, 0x00A8B5B3, 0x00A2AFAD, 0x00A3B1AF, 0x00A8B6B4, 0x00A6B4B2, 0x00829592, 0x00748784, 0x00879895, 0x00798884, 0x006B7975, 0x00717D77, 0x0079837D, 0x006E7570, 0x00676D68, 0x00686F6A, 0x006C7670, 0x00737E7B, 0x007B8985,
        0x00818F8D, 0x00849592, 0x00879895, 0x0095A8A5, 0x0094A5A2, 0x0093A4A1, 0x0097A8A5, 0x009FADAB, 0x00A2B0AE, 0x00A1AEAC, 0x009FACAA, 0x009BA7A9, 0x00919E9C, 0x0097A39D, 0x0079847A, 0x000B140A, 0x00091009, 0x00090D08, 0x000A0B09, 0x00080C06,
        0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08,
        0x00090D08, 0x00090D08, 0x00090D08, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000B0C08,
        0x000C0D09, 0x000C0D09, 0x000C0D09, 0x000C0D09, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000E0F0B, 0x000C100B, 0x000C100B, 0x000A100B, 0x000B110C, 0x000B110C, 0x000D110C, 0x000D110C, 0x000D110C, 0x000D110C, 0x000E120D,
        0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000D110C, 0x000D110C, 0x000D110C, 0x000D110C, 0x000D110C, 0x0010140E, 0x0010140E, 0x0010140E, 0x0011150F, 0x0011150F, 0x0011150F, 0x0011150F, 0x0011150F, 0x00131712,
        0x00131712, 0x00131712, 0x00131712, 0x00131712, 0x00121611, 0x00131712, 0x00131712, 0x00141812, 0x00131711, 0x0010140E, 0x000F130D, 0x000F130D, 0x0010140E, 0x00131711, 0x00141812, 0x00151913, 0x00141812, 0x00121610, 0x000E120C, 0x000C100A,
        0x000E120C, 0x00121610, 0x00161A14, 0x001C201A, 0x00242822, 0x0030342E, 0x003D413B, 0x00494D47, 0x00555953, 0x0060645E, 0x00676B65, 0x006C706A, 0x006C706A, 0x006B6F69, 0x00696D67, 0x00686C66, 0x00686C66, 0x006A6E68, 0x006D716B, 0x00676B65,
        0x00686C66, 0x00686C66, 0x00676B65, 0x00666A64, 0x00636761, 0x0060645E, 0x005F635D, 0x00656A61, 0x00656A61, 0x00666A64, 0x00666A64, 0x00656964, 0x00636762, 0x00616560, 0x00606361, 0x00636A63, 0x00636A63, 0x00636A63, 0x00646B64, 0x00656C65,
        0x00686F68, 0x006B726B, 0x006C736C, 0x006F766F, 0x006D746D, 0x00676E67, 0x00606760, 0x005D645D, 0x005E655E, 0x005E655E, 0x005C635C, 0x006B716C, 0x00676D68, 0x005A605B, 0x00535954, 0x004F5550, 0x00505651, 0x005A605B, 0x005D635E, 0x368C8C8C,
        0xFFFCFCFC, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFDFFFF, 0xFFFDFFFF, 0xFFFCFEFE, 0xFFF9FBFB, 0xFFF8FAFA, 0xFFF6F8F8, 0xFFF2F4F4, 0xFFEEF0F0, 0xEEE3E5E5, 0xC9D2D4D4,
        0xB0C6C8C8, 0x96B9BBBB, 0x79ABADAD, 0x5C9EA4A3, 0x00949A99, 0x008D9392, 0x00999F9E, 0x00919796, 0x00848A89, 0x007A807F, 0x008C9291, 0x00808B89, 0x007C8785, 0x007C8987, 0x00869391, 0x0083918F, 0x00879593, 0x0083918F, 0x0083918F, 0x00838E8C,
        0x00808B89, 0x00848F8D, 0x00818E8C, 0x00869391, 0x00A2B0AE, 0x00B4C2C0, 0x00A9B7B5, 0x00718683, 0x008C9F9C, 0x009BACA9, 0x0083928E, 0x00848F8C, 0x008B958F, 0x00818883, 0x005F6560, 0x0050514D, 0x0050514D, 0x00535752, 0x005C6360, 0x006A7370,
        0x0074817F, 0x007A8886, 0x007C8A88, 0x00758683, 0x007D8E8B, 0x008B9997, 0x0099A7A5, 0x00A3B0AE, 0x00A4B1AF, 0x009FACAA, 0x009CA7A5, 0x009EABAD, 0x009AA8A6, 0x009EACA6, 0x0078867B, 0x000A1309, 0x00070E07, 0x00080C07, 0x000A0B09, 0x00080C06,
        0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08,
        0x00090D08, 0x00090D08, 0x00090D08, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000B0C08,
        0x000B0C08, 0x000C0D09, 0x000C0D09, 0x000C0D09, 0x000C0D09, 0x000C0D09, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000E0F0B, 0x000C100B, 0x000C100B, 0x000A100B, 0x000B110C, 0x000B110C, 0x000D110C, 0x000D110C, 0x000D110C, 0x000D110C, 0x000E120D,
        0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x0010140E, 0x0010140E, 0x0010140E, 0x0011150F, 0x0011150F, 0x00121610, 0x00121610, 0x00121610, 0x0010140F,
        0x0010140F, 0x0010140F, 0x0010140F, 0x0010140F, 0x00111510, 0x00121611, 0x00131712, 0x0011150F, 0x0011150F, 0x00121610, 0x00121610, 0x00131711, 0x00121610, 0x00121610, 0x00121610, 0x00131711, 0x00141812, 0x00151913, 0x00151913, 0x00141812,
        0x00131711, 0x00121610, 0x00121610, 0x0010140E, 0x0011150F, 0x00131711, 0x00141812, 0x00181C16, 0x0021251F, 0x002C302A, 0x00353933, 0x00464A44, 0x004E524C, 0x005A5E58, 0x00636761, 0x00696D67, 0x006A6E68, 0x00696D67, 0x00696D67, 0x006B6F69,
        0x006B6F69, 0x006C706A, 0x006C706A, 0x006B6F69, 0x006A6E68, 0x00686C66, 0x00676B65, 0x00656A61, 0x00656A61, 0x00646862, 0x00646862, 0x00656964, 0x00666A65, 0x00686C67, 0x00696C6A, 0x005D645D, 0x005E655E, 0x005E655E, 0x005F665F, 0x005F665F,
        0x005F665F, 0x005E655E, 0x005D645D, 0x00636A63, 0x00656C65, 0x00656C65, 0x00636A63, 0x00636A63, 0x00636A63, 0x005F665F, 0x005A615A, 0x004C534C, 0x00454C45, 0x00424942, 0x004C534C, 0x00525952, 0x005A615A, 0x00666D66, 0x005D645D, 0x368C8C8C,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFDFDFD, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFDFFFF, 0xFFFDFFFF, 0xFFFDFFFF, 0xFFFDFFFF, 0xFFFDFFFF, 0xFFFFFEFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFEFE, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFEFCFC, 0xFFF5F3F3, 0xF2E6EBEA, 0xEAE2E7E6, 0xC0CED3D2, 0xABC3C8C7, 0x82AFB4B3, 0x6DA6ABAA, 0x4F989D9C, 0x00929796, 0x00838E8C, 0x00838E8C, 0x007E8B89, 0x00818E8C, 0x007C8A88, 0x0082908E, 0x00748280, 0x008B9C99, 0x00818C8A,
        0x006E7977, 0x00697472, 0x00697674, 0x00768381, 0x00A0AEAC, 0x00BFCDCB, 0x00B6C4C2, 0x005A6F6C, 0x0090A5A2, 0x0099AAA7, 0x00788783, 0x008D9895, 0x00A0AAA4, 0x008F9691, 0x00646A65, 0x006A6763, 0x0064635F, 0x005E5F5B, 0x005A5D5B, 0x005A615E,
        0x005D6866, 0x00616E6C, 0x0064716F, 0x006E7C7A, 0x00707E7C, 0x00748280, 0x007A8785, 0x00828F8D, 0x008E9997, 0x0098A3A1, 0x009EA9A7, 0x0093A2A4, 0x009BACA9, 0x00A7B5AF, 0x007A887D, 0x000A1309, 0x00060D06, 0x00090D08, 0x000A0B09, 0x00080C06,
        0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08,
        0x00090D08, 0x00090D08, 0x00090D08, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000B0C08,
        0x000B0C08, 0x000B0C08, 0x000C0D09, 0x000C0D09, 0x000C0D09, 0x000C0D09, 0x000C0D09, 0x000D0E0A, 0x000D0E0A, 0x000E0F0B, 0x000C100B, 0x000C100B, 0x000A100B, 0x000B110C, 0x000B110C, 0x000D110C, 0x000D110C, 0x000D110C, 0x000D110C, 0x000E120D,
        0x000E120D, 0x000E120D, 0x000E120D, 0x0010140F, 0x0010140F, 0x0010140F, 0x0010140F, 0x0010140F, 0x0010140F, 0x0010140F, 0x0010140F, 0x000E120C, 0x000E120C, 0x000F130D, 0x000F130D, 0x0010140E, 0x0011150F, 0x0011150F, 0x00121610, 0x00131712,
        0x00131712, 0x00111510, 0x00111510, 0x0010140F, 0x00111510, 0x00121611, 0x00131712, 0x00121610, 0x00121610, 0x00121610, 0x00121610, 0x00121610, 0x00121610, 0x00121610, 0x00121610, 0x00121610, 0x00121610, 0x0011150F, 0x0011150F, 0x00121610,
        0x00131711, 0x00131711, 0x00131711, 0x00141812, 0x00161A14, 0x00161A14, 0x00141812, 0x0011150F, 0x0010140E, 0x00121610, 0x00151913, 0x00181C16, 0x001C201A, 0x00232721, 0x002E322C, 0x003B3F39, 0x004B4F49, 0x005A5E58, 0x00636761, 0x006D716B,
        0x006C706A, 0x006C706A, 0x006B6F69, 0x006A6E68, 0x00696D67, 0x00676B65, 0x00666A64, 0x00656A61, 0x00666B62, 0x00676B65, 0x00686C66, 0x00676B66, 0x00656964, 0x00636762, 0x00616462, 0x00626962, 0x00626962, 0x00636A63, 0x00636A63, 0x00626962,
        0x00616861, 0x005F665F, 0x005E655E, 0x005B625B, 0x005F665F, 0x00616861, 0x00606760, 0x00606760, 0x00606760, 0x005A615A, 0x00525952, 0x00484F48, 0x003B423B, 0x003A413A, 0x004F564F, 0x00585F58, 0x00606760, 0x006B726B, 0x005C635C, 0x43929292,
        0xFFFFFFFF, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFAFAFA, 0xFFF8F8F8, 0xD1D5D5D5, 0x009F9F9F, 0x00909E9C, 0x0093A09E, 0x0098A3A1, 0x0097A1A1, 0x00909C9C, 0x007F8E90, 0x00778B8C, 0x008CA4A4, 0x00859895,
        0x00738683, 0x006D7E7A, 0x006B7C78, 0x00778682, 0x009EAEA7, 0x00BBCBC4, 0x00B7C5BF, 0x004B5F64, 0x00A5BABC, 0x007F9394, 0x00809291, 0x00768783, 0x007A8A83, 0x0072837A, 0x0055655A, 0x0057615B, 0x005F6661, 0x00696D68, 0x00686965, 0x006B6C68,
        0x0070746F, 0x00676E69, 0x00646E68, 0x00626D6A, 0x00606B68, 0x005F6A67, 0x00646D6A, 0x0067706D, 0x006B726F, 0x006C7370, 0x006E7572, 0x00737F79, 0x007A8680, 0x008B958F, 0x00676E69, 0x000E140F, 0x00080C07, 0x00050904, 0x000B0C08, 0x00080C07,
        0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08,
        0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00040803, 0x00090D08, 0x00121611, 0x000A0E09, 0x00030702, 0x00080C07, 0x000A0E09, 0x000C140A, 0x00060E04, 0x00050D03, 0x00050D03, 0x00081006, 0x00081006, 0x000D150B, 0x00040C02, 0x00050B0A,
        0x00090F0E, 0x00040908, 0x000C110F, 0x000D110C, 0x000C0D09, 0x000C0E08, 0x000A0C06, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000E0F0B, 0x000E0F0B, 0x000E0F0B, 0x000C100B, 0x000C100B, 0x000C100B, 0x000D110C, 0x000D110C,
        0x000D110C, 0x000D110C, 0x000D110C, 0x000E120C, 0x000E120C, 0x000E120C, 0x000E120C, 0x000E120C, 0x000F130D, 0x000F130D, 0x000F130D, 0x000E120D, 0x000F130E, 0x000F130E, 0x000F130E, 0x0010140F, 0x00111510, 0x00111510, 0x00111510, 0x00131410,
        0x00131410, 0x00131410, 0x00131410, 0x00131410, 0x00131410, 0x00131410, 0x00131410, 0x000F160F, 0x000F160F, 0x000F160F, 0x000F160F, 0x000E150E, 0x000E150E, 0x000E150E, 0x000E150E, 0x0011150F, 0x0011150F, 0x0011150F, 0x0011150F, 0x0011150F,
        0x0011150F, 0x0011150F, 0x0011150F, 0x00131712, 0x00131712, 0x00131712, 0x00141813, 0x00141813, 0x00141813, 0x00141813, 0x00151914, 0x00131712, 0x00121611, 0x00111510, 0x00111510, 0x00141813, 0x00191D18, 0x001F231E, 0x00222621, 0x00313530,
        0x003C403B, 0x004C504B, 0x00575B56, 0x005E625D, 0x00636762, 0x006A6E69, 0x006F736E, 0x00666A65, 0x00666A65, 0x00666A65, 0x00646863, 0x00626661, 0x00616560, 0x00636762, 0x00646863, 0x0060645F, 0x006A6E69, 0x00626661, 0x0060645F, 0x00676B66,
        0x00656964, 0x00646863, 0x00616560, 0x005F6560, 0x00606661, 0x00636964, 0x00676D68, 0x00646A65, 0x00575D58, 0x00454B46, 0x00383E39, 0x00494F4A, 0x00505651, 0x00393F3A, 0x00575D58, 0x00595F5A, 0x005F6560, 0x00636964, 0x005B615C, 0x589C9C9C,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFBFBFB, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFFFFFF, 0xFBE9E9E9, 0xA7C1C1C1, 0x00A1AEAC, 0x00ACB7B5, 0x00B3BBBA, 0x00ABB3B3, 0x00A8B2B2, 0x009DAAAC, 0x008A9E9F, 0x0099AEAF, 0x00A0B1AE,
        0x0095A6A3, 0x008D9B99, 0x0084938F, 0x007F8D89, 0x008C9A94, 0x008E9C96, 0x00727E78, 0x00415052, 0x00839392, 0x00798988, 0x008B9C99, 0x007E8F8C, 0x007E8F8B, 0x006A7975, 0x0041514A, 0x0047534D, 0x003E4842, 0x004B514C, 0x00545853, 0x00595D58,
        0x00616762, 0x0066706A, 0x006B7771, 0x0065706D, 0x005D6865, 0x00535E5B, 0x004F5855, 0x00505956, 0x00505956, 0x004E5552, 0x00484F4C, 0x00404C46, 0x0044504A, 0x0057615B, 0x00444B46, 0x00020803, 0x00070B06, 0x00070B06, 0x000D0E0A, 0x00080C07,
        0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08,
        0x00090D08, 0x00090D08, 0x00090D08, 0x000E120D, 0x000A0E09, 0x00080C07, 0x00060A05, 0x00050904, 0x000B0F0A, 0x0010140F, 0x00090D08, 0x00060A04, 0x000D110B, 0x000B0F09, 0x000A0E08, 0x00070B05, 0x000C100A, 0x00020600, 0x000F130D, 0x000F1413,
        0x00000100, 0x00101513, 0x000B0E0C, 0x00010500, 0x000D0E0A, 0x00070903, 0x0010120C, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000E0F0B, 0x000E0F0B, 0x000E0F0B, 0x000C100B, 0x000C100B, 0x000C100B, 0x000C100B, 0x000D110C,
        0x000D110C, 0x000D110C, 0x000D110C, 0x000D110B, 0x000E120C, 0x000E120C, 0x000E120C, 0x000E120C, 0x000E120C, 0x000F130D, 0x000F130D, 0x000F130E, 0x000F130E, 0x000F130E, 0x0010140F, 0x0010140F, 0x00111510, 0x00111510, 0x00111510, 0x00141511,
        0x00141511, 0x00141511, 0x00141511, 0x00141511, 0x00141511, 0x00141511, 0x00141511, 0x000F160F, 0x000F160F, 0x000F160F, 0x000F160F, 0x000E150E, 0x000E150E, 0x000E150E, 0x000E150E, 0x0011150F, 0x0011150F, 0x0011150F, 0x0011150F, 0x0011150F,
        0x0011150F, 0x0011150F, 0x0011150F, 0x00121611, 0x00121611, 0x00121611, 0x00131712, 0x00131712, 0x00131712, 0x00131712, 0x00131712, 0x00171B16, 0x00161A15, 0x00141813, 0x00121611, 0x00121611, 0x00121611, 0x00141813, 0x00141813, 0x00121611,
        0x00161A15, 0x001C201B, 0x00222621, 0x00282C27, 0x00333732, 0x003F433E, 0x00494D48, 0x00595D58, 0x005E625D, 0x00666A65, 0x006B6F6A, 0x006C706B, 0x006A6E69, 0x00676B66, 0x00666A65, 0x00696D68, 0x00686C67, 0x00646863, 0x00656964, 0x00626661,
        0x005C605B, 0x005F635E, 0x00636762, 0x00636964, 0x00666C67, 0x00656B66, 0x005B615C, 0x004D534E, 0x00444A45, 0x00444A45, 0x00484E49, 0x00535954, 0x00585E59, 0x00404641, 0x005B615C, 0x005A605B, 0x00606661, 0x00636964, 0x005B615C, 0x609F9F9F,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFBFBFB, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFCFCFC, 0xF2E6E6E6, 0x86B1BCBA, 0x00B6BEBD, 0x00BAC0BF, 0x00ABB0B1, 0x00ACB4B4, 0x00A8B4B6, 0x009DACAE, 0x00B4C8C9, 0x00CAD8D7,
        0x00BCCAC8, 0x00AAB7B5, 0x00A1AEAC, 0x0096A19E, 0x008B9693, 0x0074807A, 0x00444E48, 0x00353F39, 0x004D5653, 0x005C6764, 0x007C8987, 0x007B8987, 0x0091A1A0, 0x007D8F8E, 0x0057696A, 0x003F514A, 0x0026342E, 0x002B3731, 0x00363D38, 0x00383F3A,
        0x003B4741, 0x00495751, 0x0052645D, 0x005E6C68, 0x005B6965, 0x0057625F, 0x00525D5A, 0x00545D5A, 0x00505956, 0x00434C49, 0x00363D3A, 0x00333F39, 0x002E3A34, 0x003B453F, 0x00323934, 0x00030904, 0x000A0E09, 0x00070B06, 0x00090A06, 0x00080C07,
        0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08,
        0x00090D08, 0x00090D08, 0x00090D08, 0x00080C07, 0x00060A05, 0x00080C07, 0x00090D08, 0x00070B06, 0x00070B06, 0x00070B06, 0x00080C07, 0x000D0E0A, 0x00090A06, 0x000B0C08, 0x0011120E, 0x0012130F, 0x00060703, 0x00050602, 0x000F100C, 0x00080C07,
        0x000E120D, 0x000D110C, 0x00020601, 0x000D110C, 0x000F100C, 0x000E0F0B, 0x000C0D09, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000E0F0B, 0x000E0F0B, 0x000E0F0B, 0x000C100B, 0x000C100B, 0x000C100B, 0x000C100B, 0x000D110C,
        0x000D110C, 0x000D110C, 0x000D110C, 0x000D110B, 0x000D110B, 0x000D110B, 0x000E120C, 0x000E120C, 0x000E120C, 0x000E120C, 0x000F130D, 0x000F130E, 0x000F130E, 0x000F130E, 0x0010140F, 0x0010140F, 0x00111510, 0x00111510, 0x00111510, 0x00141511,
        0x00141511, 0x00141511, 0x00141511, 0x00141511, 0x00141511, 0x00141511, 0x00141511, 0x000F160F, 0x000F160F, 0x000F160F, 0x000F160F, 0x000E150E, 0x000E150E, 0x000E150E, 0x000E150E, 0x0010140E, 0x0010140E, 0x0010140E, 0x0010140E, 0x0010140E,
        0x0010140E, 0x0010140E, 0x0010140E, 0x0010140F, 0x00111510, 0x00111510, 0x00111510, 0x00111510, 0x00121611, 0x00121611, 0x00121611, 0x00131712, 0x00131712, 0x00131712, 0x00131712, 0x00131712, 0x00131712, 0x00121611, 0x00121611, 0x00141813,
        0x00141813, 0x00141813, 0x00141813, 0x00141813, 0x00161A15, 0x001B1F1A, 0x001F231E, 0x00292D28, 0x0030342F, 0x00393D38, 0x00444843, 0x004E524D, 0x00585C57, 0x0060645F, 0x00646863, 0x00646863, 0x005F635E, 0x00656964, 0x00676B66, 0x00636762,
        0x00626661, 0x00636762, 0x00666A65, 0x00646A65, 0x00616762, 0x00575D58, 0x00484E49, 0x003D433E, 0x003F4540, 0x004B514C, 0x00565C57, 0x00575D58, 0x005B615C, 0x00444A45, 0x005D635E, 0x005B615C, 0x00616762, 0x00626863, 0x005C625D, 0x6DA5A5A5,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFCFCFC, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFCFCFC, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF9F9F9, 0xE6E0E8E7, 0xD5D8DEDD, 0xD1D6DBDA, 0xB4C7CBCC, 0xABC4C9CA, 0x9BBBC4C7, 0x00B0BDBF, 0x00D0E2E3, 0x00E3EFEF,
        0x00C8D4D4, 0x00ADBAB8, 0x00ACB9B7, 0x00A5B0AE, 0x008F9A97, 0x00757E7B, 0x0047504D, 0x003E433A, 0x00323630, 0x00434A45, 0x00586360, 0x00657171, 0x0092A1A3, 0x0084979A, 0x00697C81, 0x00415550, 0x002C3D39, 0x002C3A36, 0x0027322F, 0x0027322F,
        0x0025332F, 0x002A3B37, 0x002D413C, 0x003A4844, 0x0045534F, 0x004C5A56, 0x004F5A57, 0x00515C59, 0x00555E5B, 0x004E5754, 0x00434C49, 0x0035413B, 0x002A3630, 0x002F3933, 0x002A312C, 0x00060C07, 0x000A0E09, 0x00070B06, 0x00090A06, 0x00080C07,
        0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08,
        0x00090D08, 0x00090D08, 0x00090D08, 0x00080C07, 0x00080C07, 0x000A0E09, 0x00070B06, 0x000A0E09, 0x000D110C, 0x000B0F0A, 0x000F130E, 0x000C0D0B, 0x000D0E0C, 0x000E0F0D, 0x00030402, 0x000D0E0C, 0x00070806, 0x00151614, 0x00151614, 0x0013150F,
        0x00090B05, 0x000B0D07, 0x000F110B, 0x0011120E, 0x00040803, 0x000C100B, 0x000A0E09, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000E0F0B, 0x000E0F0B, 0x000E0F0B, 0x000B0F0A, 0x000C100B, 0x000C100B, 0x000C100B, 0x000C100B,
        0x000D110C, 0x000D110C, 0x000D110C, 0x000D110B, 0x000D110B, 0x000D110B, 0x000D110B, 0x000E120C, 0x000E120C, 0x000E120C, 0x000E120C, 0x000F130E, 0x000F130E, 0x000F130E, 0x0010140F, 0x0010140F, 0x00111510, 0x00111510, 0x00111510, 0x00121611,
        0x00121611, 0x00121611, 0x00121611, 0x00121611, 0x00121611, 0x00121611, 0x00121611, 0x000F160F, 0x000F160F, 0x000F160F, 0x000F160F, 0x000E150E, 0x000E150E, 0x000E150E, 0x000E150E, 0x000F130D, 0x000F130D, 0x000F130D, 0x000F130D, 0x000F130D,
        0x000F130D, 0x000F130D, 0x000F130D, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x0010140F, 0x0010140F, 0x0010140F, 0x0010140F, 0x0010140F, 0x00111510, 0x00121611, 0x00141813, 0x00151914, 0x00161A15, 0x00161A15, 0x00161A15, 0x00151914,
        0x00161A15, 0x00181C17, 0x00191D18, 0x00191D18, 0x00181C17, 0x00161A15, 0x00151914, 0x00131712, 0x00141813, 0x00171B16, 0x001B1F1A, 0x00212520, 0x002B2F2A, 0x00353934, 0x003C403B, 0x0050544F, 0x00535752, 0x005D615C, 0x005F635E, 0x00646863,
        0x006B6F6A, 0x00676B66, 0x00656964, 0x00595F5A, 0x004E544F, 0x00414742, 0x003C423D, 0x00454B46, 0x00515752, 0x00575D58, 0x00575D58, 0x00515752, 0x00555B56, 0x00434944, 0x005C625D, 0x005A605B, 0x00626863, 0x00616762, 0x005D635E, 0x7DADADAD,
        0xFFFEFEFE, 0xFFFFFFFF, 0xFFFCFCFC, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFCFCFC, 0xFFFCFCFC, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFBFFFF, 0xFFF9FEFD, 0xFFFCFEFE, 0xFFF7F6F8, 0xFFF5F7F8, 0xF7E8EDF0, 0xBCCBD7D9, 0x00D6E3E5, 0x00DAE8E7,
        0x00BDCBCA, 0x00AAB8B7, 0x00B3C0BE, 0x00A9B6B4, 0x008D9A98, 0x007A8582, 0x00626D6A, 0x00585D54, 0x00414841, 0x004D544F, 0x004C5754, 0x005D6B6A, 0x008D9FA0, 0x007B8E91, 0x005F7378, 0x004E645F, 0x004B5C58, 0x0043524E, 0x002C3734, 0x0036413E,
        0x00374642, 0x00384945, 0x00364C47, 0x00283733, 0x00354440, 0x003C4A46, 0x00364440, 0x00343F3C, 0x003B4643, 0x00454E4B, 0x0048514E, 0x003B4741, 0x00303C36, 0x002F3933, 0x00272E29, 0x00080E09, 0x00060A05, 0x00060A05, 0x000A0B07, 0x00080C07,
        0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08,
        0x00090D08, 0x00090D08, 0x00090D08, 0x00080C07, 0x000D110C, 0x000E120D, 0x00030702, 0x00080C07, 0x000F130E, 0x00050904, 0x00060A05, 0x00030200, 0x0012110D, 0x000D0C08, 0x001A1915, 0x000E0D09, 0x00070602, 0x00020100, 0x007A7975, 0x008F8E84,
        0x000B0901, 0x00070800, 0x00181812, 0x00020400, 0x000A0E09, 0x00090C0A, 0x000A0F0D, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000E0F0B, 0x000E0F0B, 0x000E0F0B, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000C100B, 0x000C100B,
        0x000C100B, 0x000C100B, 0x000D110C, 0x000D110B, 0x000D110B, 0x000D110B, 0x000D110B, 0x000E120C, 0x000E120C, 0x000E120C, 0x000E120C, 0x000E120D, 0x000E120D, 0x000F130E, 0x000F130E, 0x0010140F, 0x0010140F, 0x00111510, 0x00111510, 0x00121611,
        0x00121611, 0x00121611, 0x00121611, 0x00121611, 0x00121611, 0x00121611, 0x00121611, 0x000F160F, 0x000F160F, 0x000F160F, 0x000F160F, 0x000E150E, 0x000E150E, 0x000E150E, 0x000E150E, 0x000F130D, 0x000F130D, 0x000F130D, 0x000F130D, 0x000F130D,
        0x000F130D, 0x000F130D, 0x000F130D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x00121611, 0x00121611, 0x00121611, 0x00121611, 0x00121611, 0x00121611, 0x00131712, 0x00131712, 0x00131712,
        0x00131712, 0x00131712, 0x00141813, 0x00161A15, 0x00181C17, 0x001A1E19, 0x001A1E19, 0x001B1F1A, 0x001B1F1A, 0x001B1F1A, 0x001A1E19, 0x00181C17, 0x00181C17, 0x00191D18, 0x001A1E19, 0x001D211C, 0x00292D28, 0x00333732, 0x003B3F3A, 0x00474B46,
        0x0050544F, 0x00545853, 0x005B5F5A, 0x00434944, 0x003F4540, 0x003C423D, 0x00434944, 0x00555B56, 0x00616762, 0x005D635E, 0x00525853, 0x004D534E, 0x00515752, 0x00444A45, 0x005D635E, 0x005C625D, 0x00636964, 0x005F6560, 0x005C625D, 0x8EB5B5B5,
        0xFFFEFEFE, 0xFFFFFFFF, 0xFFFCFCFC, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFBFDFD, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFFFDFF, 0xFFFFFEFF, 0xFFFBFEFF, 0xE2DDE4E7, 0x00BDC9CB, 0x00C1D5D6,
        0x00BACCCD, 0x00BFD1D0, 0x00C5D7D6, 0x00B8C9C6, 0x00A1B2AF, 0x0095A3A1, 0x008E9D99, 0x007A8680, 0x006A7572, 0x006E7C78, 0x005A6866, 0x00677875, 0x00889A99, 0x006D8280, 0x004C6061, 0x00495C59, 0x0051625F, 0x00515E5C, 0x00343F3D, 0x003F4A48,
        0x00384543, 0x002C3D3A, 0x00233633, 0x002A3935, 0x0032413D, 0x0033423E, 0x00283632, 0x001D2B27, 0x00222D2A, 0x002C3734, 0x00343F3C, 0x00404C46, 0x0039453F, 0x00353F39, 0x00272E29, 0x000B110C, 0x00040803, 0x00060A05, 0x000A0B07, 0x00080C07,
        0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08,
        0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00050904, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x00010500, 0x00030702, 0x002A2E29, 0x0053504B, 0x0015120D, 0x000D0A05, 0x000E0B06, 0x009C9994, 0x006E6B66, 0x00040100, 0x002A2722, 0x00CFCBC0,
        0x0057554A, 0x00040300, 0x000C0D04, 0x00070903, 0x0010140F, 0x000E1311, 0x00060B0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000E0F0B, 0x000E0F0B, 0x000E0F0B, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000C100B,
        0x000C100B, 0x000C100B, 0x000C100B, 0x000C100A, 0x000D110B, 0x000D110B, 0x000D110B, 0x000D110B, 0x000E120C, 0x000E120C, 0x000E120C, 0x000D110C, 0x000D110C, 0x000E120D, 0x000E120D, 0x000F130E, 0x000F130E, 0x0010140F, 0x0010140F, 0x000F1510,
        0x000F1510, 0x000F1510, 0x000F1510, 0x000F1510, 0x000F1510, 0x000F1510, 0x000F1510, 0x000F160F, 0x000F160F, 0x000F160F, 0x000F160F, 0x000E150E, 0x000E150E, 0x000E150E, 0x000E150E, 0x000F130D, 0x000F130D, 0x000F130D, 0x000F130D, 0x000F130D,
        0x000F130D, 0x000F130D, 0x000F130D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x0010140F, 0x000F130E, 0x000F130E, 0x000E120D, 0x000E120D, 0x000E120D, 0x000F130E, 0x0010140F, 0x00161A15,
        0x00151914, 0x00141813, 0x00131712, 0x00141813, 0x00151914, 0x00151914, 0x00161A15, 0x00171B16, 0x001A1E19, 0x001C201B, 0x001D211C, 0x001D211C, 0x001D211C, 0x001D211C, 0x001E221D, 0x00171B16, 0x001D211C, 0x001C201B, 0x0020241F, 0x001D211C,
        0x001B1F1A, 0x00292D28, 0x0030342F, 0x00353B36, 0x00404641, 0x004C524D, 0x00555B56, 0x005C625D, 0x00606661, 0x005A605B, 0x00505651, 0x004F5550, 0x00535954, 0x00494F4A, 0x00606661, 0x005E645F, 0x00666C67, 0x005E645F, 0x005C625D, 0x9FBDBDBD,
        0xFFFEFEFE, 0xFFFFFFFF, 0xFFFCFCFC, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFCFD, 0xFFFFFBFD, 0xFFFFFCFE, 0xFFFDFEFF, 0xF2E6EBEE, 0x8EB5BEC1, 0x00B7CFCF,
        0x00C3DBDB, 0x00DCF1F2, 0x00D2E8E6, 0x00C3D9D7, 0x00C3D8D5, 0x00B7CCC9, 0x00B0C5C2, 0x00A7BBBC, 0x009EB3B1, 0x009DB2B0, 0x007D928F, 0x007A8F8C, 0x00839994, 0x00647A75, 0x00394E46, 0x00344542, 0x003E4B49, 0x004E5957, 0x00454B4A, 0x00535958,
        0x00444F4D, 0x00394644, 0x002E3F3C, 0x00263531, 0x00283733, 0x00283733, 0x00253430, 0x0022302C, 0x0022302C, 0x0026312E, 0x00293431, 0x002D3933, 0x002D3933, 0x002A342E, 0x001E2520, 0x000A100B, 0x00040803, 0x00080C07, 0x000C0D09, 0x00080C07,
        0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08,
        0x00090D08, 0x00090D08, 0x00090D08, 0x000E120D, 0x00020601, 0x00060A05, 0x00090D08, 0x000B0F0A, 0x00020601, 0x0010140F, 0x00515550, 0x00FFFFF6, 0x00C7C5BB, 0x003D3B31, 0x0018160C, 0x00747268, 0x00E2E0D6, 0x00706E64, 0x00050300, 0x00A49E91,
        0x00B9B6A8, 0x001B190E, 0x000C0A02, 0x0012140E, 0x00050904, 0x000E1311, 0x00060C0B, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000E0F0B, 0x000E0F0B, 0x000E0F0B, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000C100B,
        0x000C100B, 0x000C100B, 0x000C100B, 0x000C100A, 0x000C100A, 0x000D110B, 0x000D110B, 0x000D110B, 0x000D110B, 0x000D110B, 0x000E120C, 0x000C100B, 0x000C100B, 0x000D110C, 0x000D110C, 0x000E120D, 0x000E120D, 0x000F130E, 0x000F130E, 0x000E140F,
        0x000E140F, 0x000E140F, 0x000E140F, 0x000E140F, 0x000E140F, 0x000E140F, 0x000E140F, 0x000F160F, 0x000F160F, 0x000F160F, 0x000F160F, 0x000E150E, 0x000E150E, 0x000E150E, 0x000E150E, 0x000F130D, 0x000F130D, 0x000F130D, 0x000F130D, 0x000F130D,
        0x000F130D, 0x000F130D, 0x000F130D, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x0010140F, 0x0010140F, 0x0010140F, 0x000C100B, 0x000C100B, 0x000D110C, 0x000D110C, 0x000E120D, 0x000F130E, 0x0010140F, 0x0010140F, 0x000D110C,
        0x000E120D, 0x0010140F, 0x00121611, 0x00121611, 0x00111510, 0x0010140F, 0x0010140F, 0x00121611, 0x00131712, 0x00141813, 0x00141813, 0x00151914, 0x00181C17, 0x001B1F1A, 0x001E221D, 0x001E221D, 0x00232722, 0x001C201B, 0x001E221D, 0x00171B16,
        0x00242823, 0x003F433E, 0x002A2E29, 0x003E443F, 0x004C524D, 0x00595F5A, 0x005C625D, 0x005C625D, 0x005C625D, 0x00565C57, 0x004F5550, 0x00505651, 0x00545A55, 0x004B514C, 0x00616762, 0x005E645F, 0x00666C67, 0x005E645F, 0x005E645F, 0xABC3C3C3,
        0xFFFEFEFE, 0xFFFFFFFF, 0xFFFCFCFC, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFBFBFB, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFFFEFE, 0xFFFFFBFC, 0xFFFFFDFF, 0xFFFFFDFF, 0xFFFEFDFF, 0xFFF6FBFE, 0xC0CED5D8, 0x8AB4D0D0,
        0x00CCE6E6, 0x00E4FEFE, 0x00C8E3E0, 0x00BFD7D5, 0x00D3EBE9, 0x00C7DEDA, 0x00B8CFCB, 0x00CBE6EA, 0x00C9E2E4, 0x00CCE6E6, 0x00ADC5C3, 0x00A0B7B2, 0x0097AEA6, 0x00778C83, 0x0041574B, 0x00455250, 0x00333E3C, 0x00383E3D, 0x00282D2C, 0x00323736,
        0x002D3332, 0x003A4543, 0x0043504E, 0x00374844, 0x0033423E, 0x002D3C38, 0x002E3D39, 0x00303E3A, 0x002E3C38, 0x002A3532, 0x0026312E, 0x0024302A, 0x0028342E, 0x0026302A, 0x001B221D, 0x000B110C, 0x00060A05, 0x00090D08, 0x000B0C08, 0x00080C07,
        0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08, 0x00090D08,
        0x00090D08, 0x00090D08, 0x00090D08, 0x00060A05, 0x000A0E09, 0x000D110C, 0x00020601, 0x000B0F0A, 0x000C100B, 0x00000300, 0x00151914, 0x00717062, 0x00EAE9DB, 0x00F8F7E9, 0x007C7B6D, 0x00151406, 0x005B5A4C, 0x00E4E3D5, 0x00979688, 0x00C6C1B2,
        0x00FAF4E7, 0x003D392E, 0x00090800, 0x000B0D07, 0x000A0E09, 0x00080D0C, 0x00090F0E, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000E0F0B, 0x000E0F0B, 0x000E0F0B, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A,
        0x000C100B, 0x000C100B, 0x000C100B, 0x000C100A, 0x000C100A, 0x000C100A, 0x000D110B, 0x000D110B, 0x000D110B, 0x000D110B, 0x000D110B, 0x000C100B, 0x000C100B, 0x000C100B, 0x000D110C, 0x000D110C, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E140F,
        0x000E140F, 0x000E140F, 0x000E140F, 0x000E140F, 0x000E140F, 0x000E140F, 0x000E140F, 0x000F160F, 0x000F160F, 0x000F160F, 0x000F160F, 0x000E150E, 0x000E150E, 0x000E150E, 0x000E150E, 0x0010140E, 0x0010140E, 0x0010140E, 0x0010140E, 0x0010140E,
        0x0010140E, 0x0010140E, 0x0010140E, 0x000F130E, 0x000F130E, 0x000F130E, 0x0010140F, 0x0010140F, 0x0010140F, 0x0010140F, 0x0010140F, 0x000F130E, 0x000F130E, 0x0010140F, 0x0010140F, 0x0010140F, 0x0010140F, 0x0010140F, 0x000F130E, 0x0010140F,
        0x0010140F, 0x00111510, 0x0010140F, 0x000F130E, 0x000E120D, 0x000E120D, 0x000F130E, 0x000F130E, 0x0010140F, 0x00121611, 0x00121611, 0x00121611, 0x00121611, 0x00141813, 0x00161A15, 0x00131712, 0x001D211C, 0x00191D18, 0x001C201B, 0x001D211C,
        0x00484C47, 0x006D716C, 0x00333732, 0x00505651, 0x00565C57, 0x005A605B, 0x00595F5A, 0x005B615C, 0x005D635E, 0x00575D58, 0x004D534E, 0x004E544F, 0x00515752, 0x00484E49, 0x005E645F, 0x005B615C, 0x00666C67, 0x005E645F, 0x00606661, 0xB0C6C6C6,
        0xFFFEFEFE, 0xFFFFFFFF, 0xFFFCFCFC, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFCFCFC, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xE6E0E5E4,
        0xE2DDE3E2, 0xD1D5DDDC, 0xBCCCD7D5, 0x00C6D4D2, 0x00C4D7D4, 0x00C3D8D5, 0x00C1D6D3, 0x00CCF0F6, 0x00D7F9FF, 0x00D8F7FA, 0x00BED7D9, 0x00A7BCBA, 0x00AEBCBA, 0x00A6B1AE, 0x0087918B, 0x00727D7B, 0x005D6866, 0x0043504E, 0x0033403E, 0x00253331,
        0x0022302E, 0x0033413F, 0x00485956, 0x002B3E3B, 0x0021322F, 0x002D3B39, 0x00313E3C, 0x00434E4C, 0x00565E5D, 0x003F4544, 0x00292F2E, 0x00263234, 0x002D3836, 0x00212B25, 0x001C251B, 0x00070F05, 0x00070903, 0x000E0D09, 0x000B0908, 0x000C110F,
        0x00070C0A, 0x00010604, 0x00070A08, 0x000C0F0D, 0x000C0D0B, 0x00000100, 0x00090A08, 0x000A0B09, 0x000D0E0C, 0x00050806, 0x000C0F0D, 0x00050806, 0x000D1210, 0x00050A08, 0x00040907, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07,
        0x00080C07, 0x00080C07, 0x00080C07, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00060600, 0x00393933, 0x00C3C3BD, 0x00F6F4EC, 0x00B5B3AB, 0x0026241A, 0x00727066, 0x00FFFEF4, 0x00FDF2E4,
        0x00BEB7A8, 0x00201F11, 0x000E1207, 0x000D1209, 0x000B0F09, 0x000D0E0A, 0x00090A08, 0x000B0C08, 0x000C0D09, 0x000C0D09, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A,
        0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000B0F09, 0x000B0F09, 0x000C100A, 0x000C100A, 0x000C100A, 0x000C100A, 0x000D110B, 0x000D110B, 0x000C120D, 0x000C120D, 0x000C120D, 0x000C120D, 0x000C120D, 0x000D130E, 0x000D130E, 0x000D130E, 0x000E140F,
        0x000E140F, 0x000E140F, 0x000E140F, 0x000F1510, 0x000F1510, 0x000F1510, 0x000F1510, 0x000F160F, 0x000F160F, 0x000F160F, 0x000F160F, 0x000F160F, 0x000E150E, 0x000E150E, 0x000D140D, 0x000E150E, 0x000E150E, 0x000E150E, 0x000E150E, 0x000E150E,
        0x000E150E, 0x000E150E, 0x000E150E, 0x000F130D, 0x000F130D, 0x000F130D, 0x000F130D, 0x000F130D, 0x000F130D, 0x000F130D, 0x000F130D, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E,
        0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000E120C, 0x000E120C, 0x000E120C, 0x000E120C, 0x000E120C, 0x000F130D, 0x000F130D, 0x000F130D, 0x00161713, 0x00161713, 0x001D1E1A, 0x00111510, 0x00171B16,
        0x005D635E, 0x00676D68, 0x00383E39, 0x00585F58, 0x00555C55, 0x00545B54, 0x00565D56, 0x00596059, 0x00596059, 0x00565D56, 0x00525952, 0x00535A53, 0x004C534C, 0x004A514A, 0x005B625B, 0x00656C65, 0x005E655E, 0x005E655E, 0x00616861, 0xD1D5D5D5,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFCFCFC, 0xFFFFFFFF, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFCFCFC, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFAFCFC,
        0xFFF7FCFB, 0xFFEEF4F3, 0xE6DFE7E6, 0xC9D1DCDA, 0xB4C7D5D3, 0x00C0D1CE, 0x00BBCCC9, 0x00CDEAF1, 0x00D7F4F9, 0x00DAF3F7, 0x00C3D8DA, 0x00ABBDBC, 0x00AEBCBA, 0x00A9B7B3, 0x00929E98, 0x00859290, 0x00828F8D, 0x007F8D8B, 0x00778583, 0x0061726F,
        0x004D5E5B, 0x004E5F5C, 0x00586B68, 0x00435451, 0x00334441, 0x00354341, 0x00293634, 0x002A3533, 0x00384341, 0x00343C3B, 0x00313938, 0x00283436, 0x002B3836, 0x001F2B25, 0x0020291F, 0x000A1208, 0x00070903, 0x000B0A06, 0x000F0D0C, 0x00030904,
        0x00030904, 0x00080E09, 0x00050904, 0x00010500, 0x000B0C08, 0x0010110D, 0x000A0B07, 0x000B0C08, 0x000C0D09, 0x000A0B07, 0x000E120D, 0x00060A05, 0x00040A05, 0x00040A05, 0x000D130E, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07,
        0x00080C07, 0x00080C07, 0x00080C07, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x000C0B07, 0x00080802, 0x001B1B15, 0x0085827D, 0x00FAF8F0, 0x00DAD7CF, 0x0088867C, 0x00B4B2A8, 0x00F5EADC,
        0x00756E5F, 0x00050400, 0x00080C01, 0x000E130A, 0x00060A05, 0x00070806, 0x000C0D0B, 0x000B0C08, 0x000C0D09, 0x000C0D09, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A,
        0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000B0F09, 0x000B0F09, 0x000B0F09, 0x000C100A, 0x000C100A, 0x000C100A, 0x000C100A, 0x000D110B, 0x000B110C, 0x000C120D, 0x000C120D, 0x000C120D, 0x000C120D, 0x000C120D, 0x000D130E, 0x000D130E, 0x000E140F,
        0x000E140F, 0x000E140F, 0x000E140F, 0x000E140F, 0x000F1510, 0x000F1510, 0x000F1510, 0x000F160F, 0x000F160F, 0x000F160F, 0x000F160F, 0x000F160F, 0x000E150E, 0x000E150E, 0x000D140D, 0x000E150E, 0x000E150E, 0x000E150E, 0x000E150E, 0x000E150E,
        0x000E150E, 0x000E150E, 0x000E150E, 0x000F130D, 0x000F130D, 0x000F130D, 0x000F130D, 0x000F130D, 0x000F130D, 0x000F130D, 0x000F130D, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E,
        0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000E120C, 0x000E120C, 0x000E120C, 0x000E120C, 0x000F130D, 0x000F130D, 0x000F130D, 0x000F130D, 0x000E0F0B, 0x000E0F0B, 0x00131410, 0x0010140F, 0x000E120D,
        0x002E342F, 0x003D433E, 0x00414742, 0x00585F58, 0x005B625B, 0x005B625B, 0x00596059, 0x00596059, 0x00596059, 0x00555C55, 0x00505750, 0x00515851, 0x004A514A, 0x004C534C, 0x005C635C, 0x00646B64, 0x005E655E, 0x005F665F, 0x00656C65, 0xD5D8D8D8,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFCFCFC, 0xFFFFFFFF, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFEFE,
        0xFFFFFFFF, 0xFFFDFFFF, 0xFFFBFFFF, 0xFFF8FEFD, 0xF7E8F0EF, 0xC0CDD8D6, 0x92B7C2C0, 0x00C8DBE0, 0x00D3E6EB, 0x00DBECEF, 0x00CBDDDE, 0x00B5C5C4, 0x00AEBFBC, 0x00A7B8B4, 0x0095A4A0, 0x00818F8D, 0x007D8B89, 0x007F908D, 0x008A9B98, 0x008B9E9B,
        0x00839693, 0x007C8F8C, 0x00798E8B, 0x006F807D, 0x005E6F6C, 0x005A6866, 0x0042504E, 0x002D3A38, 0x00293432, 0x00202B29, 0x00212C2A, 0x00222E30, 0x0024312F, 0x001A2620, 0x001E291F, 0x000C140A, 0x00080C06, 0x00060703, 0x000C0A09, 0x000A100B,
        0x00000601, 0x00060C07, 0x000A0E09, 0x00090D08, 0x00030400, 0x000A0B07, 0x00070804, 0x000B0A06, 0x000A0B07, 0x00090A06, 0x00050602, 0x00060A05, 0x000A0E09, 0x00060C07, 0x00000601, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07,
        0x00080C07, 0x00080C07, 0x00080C07, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x000D0E0A, 0x00080703, 0x00070701, 0x000C0C06, 0x0046443C, 0x00DAD8D0, 0x00FCF9F1, 0x00B8B6AC, 0x00CCC1B3,
        0x00C4BCAF, 0x00464439, 0x00000400, 0x00171B15, 0x000E120D, 0x000E0F0D, 0x000C0D0B, 0x000B0C08, 0x000C0D09, 0x000C0D09, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A,
        0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000B0F09, 0x000B0F09, 0x000B0F09, 0x000C100A, 0x000C100A, 0x000C100A, 0x000C100A, 0x000C100A, 0x000B110C, 0x000B110C, 0x000B110C, 0x000C120D, 0x000C120D, 0x000C120D, 0x000C120D, 0x000D130E, 0x000D130E,
        0x000E140F, 0x000E140F, 0x000E140F, 0x000E140F, 0x000F1510, 0x000F1510, 0x000F1510, 0x000F160F, 0x000F160F, 0x000F160F, 0x000F160F, 0x000F160F, 0x000E150E, 0x000E150E, 0x000D140D, 0x000E150E, 0x000E150E, 0x000E150E, 0x000E150E, 0x000E150E,
        0x000E150E, 0x000E150E, 0x000E150E, 0x000F130D, 0x000F130D, 0x000F130D, 0x000F130D, 0x000F130D, 0x000F130D, 0x000F130D, 0x000F130D, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E,
        0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000E120C, 0x000E120C, 0x000E120C, 0x000E120C, 0x000F130D, 0x000F130D, 0x000F130D, 0x000F130D, 0x000D0E0A, 0x0012130F, 0x0011120E, 0x00111510, 0x000F130E,
        0x00101611, 0x00222823, 0x00515752, 0x005B625B, 0x005A615A, 0x00575E57, 0x00545B54, 0x00565D56, 0x00596059, 0x00585F58, 0x00535A53, 0x00565D56, 0x004C534C, 0x00525952, 0x005F665F, 0x00646B64, 0x005F665F, 0x005F665F, 0x00697069, 0xE2DDDDDD,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFCFCFC, 0xFFFFFFFF, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFEFF,
        0xFFFFFEFE, 0xFFFFFDFD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFDFFFF, 0xFFEDF2F1, 0xE2DDE2E1, 0xB4C7D0D4, 0xB8CAD3D7, 0xB8CAD3D6, 0x00BDC9C9, 0x00AEBCBB, 0x00ADBBB9, 0x00ABBCB9, 0x00A3B4B0, 0x0096A7A4, 0x0091A29F, 0x008E9F9C, 0x008D9E9B, 0x00869996,
        0x00809390, 0x007F9491, 0x00839895, 0x008D9B99, 0x00808E8C, 0x007E8C8A, 0x0072807E, 0x005D6B69, 0x004C5957, 0x00384543, 0x00313E3C, 0x002C393B, 0x002C3937, 0x001F2B25, 0x001C271D, 0x00040D03, 0x000A0E08, 0x00090A06, 0x000B0C0A, 0x00050B06,
        0x00090F0A, 0x00090F0A, 0x00000300, 0x00080C07, 0x000D0E0A, 0x0011120E, 0x00090A06, 0x000B0A06, 0x000D0C08, 0x0010110D, 0x000C0D09, 0x000F100C, 0x00090D08, 0x000A0E09, 0x00070B06, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07,
        0x00080C07, 0x00080C07, 0x00080C07, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00090A06, 0x000A0B07, 0x001C1D19, 0x000B0B05, 0x00020200, 0x00403E36, 0x00C7C5BD, 0x00F2F0E8, 0x00E8DCD0,
        0x00FFF7EA, 0x00B4B2A7, 0x001F2219, 0x00050903, 0x00010500, 0x00141513, 0x000A0A0A, 0x000B0C08, 0x000C0D09, 0x000C0D09, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A,
        0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000B0F09, 0x000B0F09, 0x000B0F09, 0x000B0F09, 0x000C100A, 0x000C100A, 0x000C100A, 0x000C100A, 0x000B110C, 0x000B110C, 0x000B110C, 0x000B110C, 0x000C120D, 0x000C120D, 0x000C120D, 0x000C120D, 0x000D130E,
        0x000D130E, 0x000D130E, 0x000E140F, 0x000E140F, 0x000E140F, 0x000E140F, 0x000F1510, 0x000F160F, 0x000F160F, 0x000F160F, 0x000F160F, 0x000F160F, 0x000E150E, 0x000E150E, 0x000D140D, 0x000E150E, 0x000E150E, 0x000E150E, 0x000E150E, 0x000E150E,
        0x000E150E, 0x000E150E, 0x000E150E, 0x000F130D, 0x000F130D, 0x000F130D, 0x000F130D, 0x000F130D, 0x000F130D, 0x000F130D, 0x000F130D, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E,
        0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000E120C, 0x000E120C, 0x000E120C, 0x000F130D, 0x000F130D, 0x000F130D, 0x000F130D, 0x0010140E, 0x000E0F0B, 0x00181915, 0x00141511, 0x000E120D, 0x00131712,
        0x00121813, 0x00272D28, 0x00575D58, 0x005D645D, 0x00565D56, 0x00505750, 0x00525952, 0x00575E57, 0x00585F58, 0x00545B54, 0x00505750, 0x00525952, 0x00424942, 0x004D544D, 0x005A615A, 0x00606760, 0x00616861, 0x00606760, 0x006E756E, 0xEEE3E3E3,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFEFE,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFEFE, 0xFFFDFBFB, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFBFDFE, 0xFFF2F6F7, 0xF7E7EBEC, 0xD5D7DCDD, 0xA7C2CCCC, 0x8EB6C3C1, 0x79ABB9B7, 0x00A1AFAD, 0x00A6B4B2, 0x009FADAB, 0x0096A4A2, 0x008D9E9B, 0x00899A97,
        0x00869794, 0x00849794, 0x00869996, 0x00919F9D, 0x00879593, 0x008B9997, 0x008C9A98, 0x0083918F, 0x00758683, 0x00677875, 0x0060716E, 0x006C797B, 0x006B7977, 0x0056645E, 0x003B463C, 0x00040D03, 0x00080F08, 0x000A0E09, 0x000E0F0D, 0x00060D06,
        0x00030A03, 0x000A110A, 0x00090D07, 0x00060A04, 0x00090B05, 0x00070903, 0x00090B05, 0x000B0B05, 0x00030300, 0x00020200, 0x00050701, 0x000C0E08, 0x00090B05, 0x00080C06, 0x00090D07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07,
        0x00080C07, 0x00080C07, 0x00080C07, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00111412, 0x000E0F0D, 0x00030400, 0x00080905, 0x001E1E18, 0x00020200, 0x003B3833, 0x00C9C7BF, 0x00ADA195,
        0x00B2A99F, 0x00C8C6BC, 0x002E3128, 0x00000300, 0x00171A18, 0x00060606, 0x00121212, 0x000B0C08, 0x000C0D09, 0x000C0D09, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A,
        0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000A0E08, 0x000B0F09, 0x000B0F09, 0x000B0F09, 0x000B0F09, 0x000C100A, 0x000C100A, 0x000C100A, 0x000B110C, 0x000B110C, 0x000B110C, 0x000B110C, 0x000C120D, 0x000C120D, 0x000C120D, 0x000C120D, 0x000D130E,
        0x000D130E, 0x000D130E, 0x000D130E, 0x000E140F, 0x000E140F, 0x000E140F, 0x000E140F, 0x000F160F, 0x000F160F, 0x000F160F, 0x000F160F, 0x000F160F, 0x000E150E, 0x000E150E, 0x000D140D, 0x000E150E, 0x000E150E, 0x000E150E, 0x000E150E, 0x000E150E,
        0x000E150E, 0x000E150E, 0x000E150E, 0x000F130D, 0x000F130D, 0x000F130D, 0x000F130D, 0x000F130D, 0x000F130D, 0x000F130D, 0x000F130D, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E,
        0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000E120C, 0x000F130D, 0x000F130D, 0x000F130D, 0x000F130D, 0x0010140E, 0x0010140E, 0x0010140E, 0x000D0E0A, 0x00151612, 0x0011120E, 0x000A0E09, 0x0010140F,
        0x00161C17, 0x00323833, 0x00535954, 0x005C635C, 0x00555C55, 0x00535A53, 0x005A615A, 0x005B625B, 0x00545B54, 0x004E554E, 0x004F564F, 0x005D645D, 0x00464D46, 0x00545B54, 0x005F665F, 0x00626962, 0x00656C65, 0x00606760, 0x00707770, 0xFBEAEAEA,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFAFAFA,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFEFE, 0xFFFFFFFF, 0xFFFDFDFD, 0xFFFBFDFD, 0xFFFCFEFE, 0xFFF8FDFC, 0xFFF2F8F7, 0xF7E8EDEE, 0xDEDCE4E4, 0xABC4CCCB, 0x8EB5C0BE, 0x6DA6B1AF, 0x5C9EA9A7, 0x009CA9A7,
        0x0099A6A4, 0x008F9D9B, 0x00859391, 0x008B9896, 0x00859290, 0x00889694, 0x008B9997, 0x00849592, 0x007D908D, 0x007A8D8A, 0x00778A87, 0x008E9D9F, 0x0097A5A3, 0x008C9A94, 0x00627065, 0x000A1309, 0x00060D06, 0x00080C07, 0x00080B09, 0x000C130C,
        0x00000600, 0x00060D06, 0x00060A04, 0x00000200, 0x00191B15, 0x000A0C06, 0x00050701, 0x00302D28, 0x00413E39, 0x0033332D, 0x00181812, 0x00000200, 0x000D0F09, 0x000C0E08, 0x00010500, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07,
        0x00080C07, 0x00080C07, 0x00080C07, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00040705, 0x000B0E0C, 0x00121311, 0x000B0C08, 0x00090A06, 0x0011110B, 0x00060600, 0x00494943, 0x00D8CCC2,
        0x003C3329, 0x00222016, 0x000C0F06, 0x00000200, 0x00111412, 0x000D0D0D, 0x00070608, 0x000B0C08, 0x000C0D09, 0x000C0D09, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A,
        0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000A0E08, 0x000A0E08, 0x000A0E08, 0x000B0F09, 0x000B0F09, 0x000B0F09, 0x000B0F09, 0x000C100A, 0x000A100B, 0x000B110C, 0x000B110C, 0x000B110C, 0x000B110C, 0x000C120D, 0x000C120D, 0x000C120D, 0x000D130E,
        0x000D130E, 0x000D130E, 0x000D130E, 0x000D130E, 0x000E140F, 0x000E140F, 0x000E140F, 0x000F160F, 0x000F160F, 0x000F160F, 0x000F160F, 0x000F160F, 0x000E150E, 0x000E150E, 0x000D140D, 0x000E150E, 0x000E150E, 0x000E150E, 0x000E150E, 0x000E150E,
        0x000E150E, 0x000E150E, 0x000E150E, 0x000F130D, 0x000F130D, 0x000F130D, 0x000F130D, 0x000F130D, 0x000F130D, 0x000F130D, 0x000F130D, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E,
        0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130D, 0x000F130D, 0x000F130D, 0x000F130D, 0x0010140E, 0x0010140E, 0x0010140E, 0x0010140E, 0x0010110D, 0x0010110D, 0x0010110D, 0x000E120D, 0x000F130E,
        0x00121813, 0x00383E39, 0x00555B56, 0x005B625B, 0x00555C55, 0x00555C55, 0x00596059, 0x00565D56, 0x00515851, 0x00525952, 0x005A615A, 0x00596059, 0x00414841, 0x00585F58, 0x00636A63, 0x00636A63, 0x00676E67, 0x00606760, 0x04747B74, 0xFFF0F0F0,
        0xFFFEFEFE, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFBFFFF,
        0xFFFBFFFF, 0xFFFCFEFE, 0xFFFBFDFD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFCFC, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFBFFFF, 0xFFFAFFFE, 0xFFEDF3F2, 0xD5D8DEDD, 0xABC4CAC9,
        0x86B1B9B8, 0x69A4ACAB, 0x549AA2A1, 0x0097A4A2, 0x00909D9B, 0x008C9A98, 0x00889996, 0x00809390, 0x007E918E, 0x007E9390, 0x007B908D, 0x007D8C8E, 0x00859693, 0x008C9C95, 0x006C7A6F, 0x00061107, 0x00040B04, 0x00080C07, 0x00070A08, 0x00010900,
        0x000D150B, 0x00050D03, 0x00020700, 0x00262B22, 0x007A7D74, 0x0035382F, 0x00030600, 0x00605E56, 0x009A9890, 0x00908E86, 0x004E4F46, 0x00020300, 0x000D1007, 0x000F1209, 0x000C0F06, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07,
        0x00080C07, 0x00080C07, 0x00080C07, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x000D0F0F, 0x00050806, 0x000C0F0D, 0x00141513, 0x00070804, 0x000E0D09, 0x00393933, 0x00767670, 0x00F4E8DE,
        0x009B9288, 0x00110F05, 0x00070903, 0x00131712, 0x00060808, 0x000C0B0D, 0x000E0D0F, 0x000B0C08, 0x000C0D09, 0x000C0D09, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A,
        0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000A0E08, 0x000A0E08, 0x000A0E08, 0x000B0F09, 0x000B0F09, 0x000B0F09, 0x000B0F09, 0x000B0F09, 0x000A100B, 0x000A100B, 0x000B110C, 0x000B110C, 0x000B110C, 0x000B110C, 0x000B110C, 0x000C120D, 0x000C120D,
        0x000D130E, 0x000D130E, 0x000D130E, 0x000D130E, 0x000E140F, 0x000E140F, 0x000E140F, 0x000F160F, 0x000F160F, 0x000F160F, 0x000F160F, 0x000F160F, 0x000E150E, 0x000E150E, 0x000D140D, 0x000E150E, 0x000E150E, 0x000E150E, 0x000E150E, 0x000E150E,
        0x000E150E, 0x000E150E, 0x000E150E, 0x000F130D, 0x000F130D, 0x000F130D, 0x000F130D, 0x000F130D, 0x000F130D, 0x000F130D, 0x000F130D, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E,
        0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130D, 0x000F130D, 0x000F130D, 0x000F130D, 0x0010140E, 0x0010140E, 0x0010140E, 0x0010140E, 0x00151612, 0x0011120E, 0x0012130F, 0x0010140F, 0x00121611,
        0x00131914, 0x003E443F, 0x005C625D, 0x005A615A, 0x00575E57, 0x00535A53, 0x00515851, 0x00525952, 0x00535A53, 0x00525952, 0x004F564F, 0x00373E37, 0x00262D26, 0x004F564F, 0x005F665F, 0x005E655E, 0x00656C65, 0x00626962, 0x197E857E, 0xFFF4F4F4,
        0xFFFDFDFD, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF9FFFE,
        0xFFFAFFFF, 0xFFFBFFFF, 0xFFFBFFFF, 0xFFFAFCFC, 0xFFFEFEFE, 0xFFFEFEFE, 0xFFFEFEFE, 0xFFFBFFFA, 0xFFFDFFFC, 0xFFFFFFFE, 0xFFFEFFFD, 0xFFFFFEFE, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFDFF, 0xFFFDFDFD, 0xFFFDFFFF, 0xFFFDFFFF, 0xFFFDFFFF, 0xFFFBFFFF,
        0xFFFBFFFF, 0xFFECF2F1, 0xE2DEE4E3, 0xABC3CECC, 0x86B2BFBD, 0x609FADAB, 0x4391A29F, 0x00869996, 0x00829794, 0x00819894, 0x007A918D, 0x008B9A9C, 0x00869794, 0x008B9B94, 0x006D7B70, 0x00040F05, 0x00030B04, 0x00090F0A, 0x00090C0A, 0x00040C02,
        0x00070F05, 0x00010900, 0x00444940, 0x00A6ABA2, 0x00D5D8CF, 0x0034372E, 0x00000300, 0x00626058, 0x008D8B83, 0x007E7C74, 0x0054554C, 0x000A0B02, 0x0012130A, 0x00070A01, 0x000B0E05, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07,
        0x00080C07, 0x00080C07, 0x00080C07, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00070C0B, 0x00080A0A, 0x000C0F0D, 0x00070A08, 0x000D0E0A, 0x0012130F, 0x00BAB9B5, 0x00F9F9F3, 0x00FFF3E9,
        0x00B0A79E, 0x000C0901, 0x00090B05, 0x000E120D, 0x00080A0A, 0x000E0D0F, 0x000B0A0C, 0x000B0C08, 0x000C0D09, 0x000C0D09, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A,
        0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000A0E08, 0x000A0E08, 0x000A0E08, 0x000A0E08, 0x000B0F09, 0x000B0F09, 0x000B0F09, 0x000B0F09, 0x000A100B, 0x000A100B, 0x000A100B, 0x000B110C, 0x000B110C, 0x000B110C, 0x000B110C, 0x000B110C, 0x000C120D,
        0x000C120D, 0x000D130E, 0x000D130E, 0x000D130E, 0x000D130E, 0x000E140F, 0x000E140F, 0x000F160F, 0x000F160F, 0x000F160F, 0x000F160F, 0x000F160F, 0x000E150E, 0x000E150E, 0x000D140D, 0x000E150E, 0x000E150E, 0x000E150E, 0x000E150E, 0x000E150E,
        0x000E150E, 0x000E150E, 0x000E150E, 0x000F130D, 0x000F130D, 0x000F130D, 0x000F130D, 0x000F130D, 0x000F130D, 0x000F130D, 0x000F130D, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E,
        0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130D, 0x000F130D, 0x000F130D, 0x0010140E, 0x0010140E, 0x0010140E, 0x0010140E, 0x0010140E, 0x00141511, 0x00141511, 0x0011120E, 0x000C100B, 0x00131712,
        0x00171D18, 0x00444A45, 0x005E645F, 0x005B625B, 0x00596059, 0x00545B54, 0x00525952, 0x00575E57, 0x00585F58, 0x00444B44, 0x002B322B, 0x00343B34, 0x00282F28, 0x005A615A, 0x006A716A, 0x00626962, 0x00656C65, 0x00626962, 0x21828982, 0xFFF7F7F7,
        0xFFFDFDFD, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF7F7F7, 0xF7E7E7E7, 0xD1D6D6D6, 0xABC3C3C3, 0x82AFAFAF, 0x609F9F9F, 0x3B8D9C98, 0x00869591, 0x008B9995, 0x00717D77, 0x000A140E, 0x00060D08, 0x00091009, 0x00080C06, 0x00020706,
        0x00040606, 0x003D3E3A, 0x00D7D7D1, 0x00D2D0C6, 0x00CECABF, 0x00463E31, 0x000B0400, 0x00343630, 0x00707168, 0x008F8E84, 0x0059574C, 0x000A0800, 0x00040500, 0x00060A05, 0x00070C0B, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07,
        0x00080C07, 0x00080C07, 0x00080C07, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00090D07, 0x00090D07, 0x00090D07, 0x0009100D, 0x00030A05, 0x000B0F0A, 0x000C0D09, 0x000D0A05, 0x00060200, 0x0098928B, 0x00F9F1EA, 0x00797465,
        0x00211D12, 0x000F1007, 0x000A0E09, 0x00070C0A, 0x00070A08, 0x00090A06, 0x000E0E08, 0x000B0D07, 0x000B0D07, 0x000B0C08, 0x000C0D09, 0x000C0D09, 0x000C0D0B, 0x000C0D0B, 0x000C0D0B, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A,
        0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000E0F0B, 0x000E0F0B, 0x000E0F0B, 0x000D110C, 0x000D110C, 0x000B110C, 0x000B110C, 0x000B110C, 0x000B110C,
        0x000B110C, 0x000B110C, 0x000C120D, 0x000C120D, 0x000D130E, 0x000D130E, 0x000E140F, 0x000D150E, 0x00111912, 0x000E160F, 0x00141B14, 0x000D140D, 0x00080C06, 0x00131711, 0x000D110B, 0x000F160F, 0x000F160F, 0x000F160F, 0x000F160F, 0x000F160F,
        0x000F160F, 0x000F160F, 0x000F160F, 0x000D140D, 0x000D140D, 0x000D140D, 0x000D140D, 0x000D140D, 0x000D140D, 0x000D140D, 0x000D140D, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E,
        0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x0010140F, 0x0010140F, 0x0010140F, 0x0010140F, 0x0010140F, 0x000E120D, 0x0010140F, 0x000C100B, 0x00121813, 0x000D130E,
        0x001A201B, 0x004B524D, 0x005E6560, 0x005B6359, 0x0050584E, 0x00586056, 0x005B625B, 0x00575E57, 0x00343A35, 0x002F3530, 0x00424843, 0x00585E59, 0x00343A35, 0x00555B56, 0x00636964, 0x005D635E, 0x00656B66, 0x00646A65, 0x1D7F8580, 0xFFF8FEF9,
        0xFFFAFFFB, 0xFFFBFFFC, 0xFFFDFFFC, 0xFFFDFFFC, 0xFFFDFFFC, 0xFFFFFFFC, 0xFFFFFFFC, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFCFCFC, 0xFFFBFBFB, 0xFFF8F8F8, 0xFFF2F2F2, 0xFFEBEBEB, 0xB4C7D2CF, 0x8EB6C1BE, 0x7DAEB7B4, 0x2A858C87, 0x000B110C, 0x00060A05, 0x000D110B, 0x000B0D07, 0x00090E0D,
        0x00050806, 0x0020211D, 0x00898983, 0x00DCD9D1, 0x00D2CEC3, 0x00352F22, 0x00130B00, 0x0061635D, 0x005A5B52, 0x0095948A, 0x00454338, 0x00060400, 0x00111209, 0x000B0F0A, 0x00080D0C, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07,
        0x00080C07, 0x00080C07, 0x00080C07, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00090D07, 0x00090D07, 0x00090D07, 0x00010805, 0x00080E09, 0x00050904, 0x000E0F0B, 0x002B2823, 0x00534F4A, 0x004F4942, 0x00D7CFC8, 0x00736E5F,
        0x00070300, 0x00101108, 0x000B0F0A, 0x00060B09, 0x00060907, 0x00090A06, 0x000E0E08, 0x000B0D07, 0x000B0D07, 0x000B0C08, 0x000C0D09, 0x000C0D09, 0x000C0D0B, 0x000C0D0B, 0x000C0D0B, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A,
        0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000E0F0B, 0x000E0F0B, 0x000E0F0B, 0x000C100B, 0x000D110C, 0x000B110C, 0x000B110C, 0x000B110C, 0x000B110C,
        0x000B110C, 0x000B110C, 0x000C120D, 0x000C120D, 0x000D130E, 0x000D130E, 0x000D130E, 0x000B130C, 0x000D150E, 0x00050D06, 0x00141B14, 0x00131A13, 0x00151913, 0x000E120C, 0x000F130D, 0x000C130C, 0x000C130C, 0x000C130C, 0x000E150E, 0x00101710,
        0x00101710, 0x000E150E, 0x000C130C, 0x000D140D, 0x000D140D, 0x000D140D, 0x000D140D, 0x000D140D, 0x000D140D, 0x000D140D, 0x000D140D, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E,
        0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x0010140F, 0x0010140F, 0x0010140F, 0x0010140F, 0x000E120D, 0x000F130E, 0x000D110C, 0x00121813, 0x000E140F,
        0x001C221D, 0x004C534E, 0x005F6661, 0x00596157, 0x005D655B, 0x005F665F, 0x00464D46, 0x00343B34, 0x00373D38, 0x00474D48, 0x003C423D, 0x002E342F, 0x002E342F, 0x00585E59, 0x00626863, 0x00626863, 0x00656B66, 0x00616762, 0x2E878D88, 0xFFF9FEFC,
        0xFFFAFFFD, 0xFFFAFFFD, 0xFFFCFFFD, 0xFFFAFDFB, 0xFFFCFDFB, 0xFFFDFEFC, 0xFFFFFFFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFBFFFE, 0xFFF7FCFA, 0xFFF1F6F4, 0x92B9BDB8, 0x001C1D19, 0x00040501, 0x0010100A, 0x000E0E08, 0x00080A0A,
        0x000B0E0C, 0x00020300, 0x00292923, 0x00A4A29A, 0x00DEDCD2, 0x00444035, 0x000A0600, 0x004B4D47, 0x00909188, 0x005F5E54, 0x0068665B, 0x000D0B01, 0x00101108, 0x00070B06, 0x00030807, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07,
        0x00080C07, 0x00080C07, 0x00080C07, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00090D07, 0x00090D07, 0x00090D07, 0x000C110F, 0x00090F0A, 0x00070B06, 0x00030400, 0x00484842, 0x00FFFCF7, 0x00BEBBB3, 0x00B0AAA3, 0x00CCC7B8,
        0x00403C31, 0x00050600, 0x000B0F0A, 0x00070C0A, 0x000B0E0C, 0x00161713, 0x000B0B05, 0x000B0D07, 0x000B0D07, 0x000B0C08, 0x000C0D09, 0x000C0D09, 0x000C0D0B, 0x000C0D0B, 0x000C0D0B, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A,
        0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000E0F0B, 0x000E0F0B, 0x000E0F0B, 0x000C100B, 0x000D110C, 0x000B110C, 0x000B110C, 0x000B110C, 0x000B110C,
        0x000B110C, 0x000B110C, 0x000C120D, 0x000C120D, 0x000D130E, 0x000D130E, 0x000D130E, 0x000F1710, 0x000B130C, 0x00070E07, 0x00101710, 0x000D110B, 0x00151913, 0x000D110B, 0x00151711, 0x00111811, 0x00101710, 0x000F160F, 0x000E150E, 0x000D140D,
        0x000E150E, 0x00101710, 0x00111811, 0x000D140D, 0x000D140D, 0x000D140D, 0x000D140D, 0x000D140D, 0x000D140D, 0x000D140D, 0x000D140D, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E,
        0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x0010140F, 0x0010140F, 0x0010140F, 0x0010140F, 0x000D110C, 0x000F130E, 0x000E120D, 0x00111712, 0x000E140F,
        0x00212722, 0x00505752, 0x00636A65, 0x00596157, 0x005D645D, 0x00444B44, 0x002B322B, 0x003E443F, 0x00838984, 0x00BFC4C2, 0x00B8BDBB, 0x00A3A9A4, 0x00848A85, 0x00747A75, 0x00646A65, 0x00646A65, 0x005B615C, 0x005A605B, 0x549AA09B, 0xFFFBFFFF,
        0xFFFBFFFF, 0xFFFDFFFF, 0xFFFDFFFF, 0xFFFEFDFF, 0xFFFEFDFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFCFCFC, 0xFFFCFCFC, 0xFFFCFCFC, 0xFFFCFCFC, 0xFFFCFCFC, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xC4D4D3CF, 0x0023221E, 0x00040300, 0x0010100A, 0x000F0C07, 0x00040705,
        0x0010110F, 0x00000100, 0x00050500, 0x00363630, 0x00B4B2AA, 0x00524F47, 0x00050300, 0x0040423C, 0x0065665D, 0x0058574D, 0x00514F44, 0x000B0900, 0x00050600, 0x00131712, 0x00000504, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07,
        0x00080C07, 0x00080C07, 0x00080C07, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00090D07, 0x00090D07, 0x00090D07, 0x00060907, 0x00070B06, 0x00171814, 0x000A0905, 0x00161610, 0x00A9A6A1, 0x00FAF8F0, 0x00E0DDD5, 0x00F2EDDE,
        0x00B6B2A7, 0x00191A11, 0x00070B06, 0x000E1311, 0x00050806, 0x000B0C08, 0x000F0F09, 0x000B0D07, 0x000B0D07, 0x000B0C08, 0x000C0D09, 0x000C0D09, 0x000C0D0B, 0x000C0D0B, 0x000C0D0B, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A,
        0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000D0E0A, 0x000E0F0B, 0x000E0F0B, 0x000C100B, 0x000C100B, 0x000B110C, 0x000B110C, 0x000B110C, 0x000A100B,
        0x000A100B, 0x000B110C, 0x000B110C, 0x000C120D, 0x000C120D, 0x000D130E, 0x000D130E, 0x000D140D, 0x000A110A, 0x00131A13, 0x0010140E, 0x000E120C, 0x00141610, 0x00141610, 0x0010120C, 0x0010140E, 0x00141812, 0x00171B15, 0x00161A14, 0x0011150F,
        0x000D110B, 0x000E120C, 0x0010140E, 0x000D140D, 0x000D140D, 0x000D140D, 0x000D140D, 0x000D140D, 0x000D140D, 0x000D140D, 0x000D140D, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E,
        0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000E120D, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x0010140F, 0x0010140F, 0x0010140F, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F1510, 0x000F1510,
        0x00282E29, 0x00555C57, 0x00676E69, 0x00616861, 0x005D645D, 0x00404740, 0x00585E59, 0x00939994, 0x00D2D7D5, 0x00FBFFFE, 0x00FBFFFE, 0x00F8FDFB, 0x00F1F6F4, 0x00EDF2F0, 0x00D9DEDC, 0x00BDC2C0, 0x00848987, 0x00626765, 0x00909593, 0xFFFDFFFF,
        0xFFFDFFFF, 0xFFFDFFFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFEFEFE, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFDFC, 0xFFFDF9F8, 0xFFFEFAF9, 0xBCD3D0CC, 0x0024231F, 0x00060501, 0x0010100A, 0x00070701, 0x000C0D09,
        0x000A0B07, 0x000B0C08, 0x0013120E, 0x00020200, 0x004A4A44, 0x0032322C, 0x00040400, 0x0031332D, 0x006A6B62, 0x00908F85, 0x003D3B30, 0x00110F05, 0x000B0C03, 0x00050904, 0x00090E0D, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07,
        0x00080C07, 0x00080C07, 0x00080C07, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00090D07, 0x00090D07, 0x00090D07, 0x0010110F, 0x00050602, 0x00070602, 0x0012110D, 0x00020200, 0x002D2D27, 0x00CACBC2, 0x00C7C5BD, 0x00C3BEAF,
        0x00FFFFF7, 0x0095968D, 0x00070B06, 0x00040907, 0x000F1210, 0x00080905, 0x00060600, 0x000B0D07, 0x000B0D07, 0x000B0C08, 0x000C0D09, 0x000C0D09, 0x000C0D0B, 0x000C0D0B, 0x000C0D0B, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A,
        0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000C100B, 0x000C100B, 0x000A100B, 0x000A100B, 0x000B110C, 0x000A100B,
        0x000A100B, 0x000B110C, 0x000B110C, 0x000C120D, 0x000C120D, 0x000D130E, 0x000D130E, 0x000A110A, 0x00131A13, 0x00151913, 0x00010500, 0x000C0E08, 0x00010300, 0x000E100A, 0x0015150F, 0x000D110B, 0x000E120C, 0x0010140E, 0x0011150F, 0x0010140E,
        0x0010140E, 0x0010140E, 0x0010140E, 0x000D140D, 0x000D140D, 0x000D140D, 0x000D140D, 0x000D140D, 0x000D140D, 0x000D140D, 0x000D140D, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E,
        0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000E120D, 0x000E120D, 0x000E120D, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x0010140F, 0x0010140F, 0x000F130E, 0x000F130E, 0x000D130E, 0x00101611,
        0x002E342F, 0x00585F5A, 0x00686F6A, 0x00656C65, 0x005C635C, 0x00646A65, 0x00B9BFBA, 0x00E9EEEC, 0x00F4F9F7, 0x00F1F6F5, 0x00EBF0EF, 0x00F1F6F4, 0x00F3F8F6, 0x00F4F9F7, 0x00F4F9F7, 0x00FBFFFE, 0x00F0F5F3, 0x00CED3D1, 0x00CACFCD, 0xFFF8FAFB,
        0xFFF9FBFC, 0xFFFCFBFD, 0xFFFEFDFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xDEE0DFDB, 0x002C2D29, 0x00060703, 0x000B0F09, 0x00050903, 0x000F0E0A,
        0x00080703, 0x000F100C, 0x000F100C, 0x00070804, 0x00040501, 0x000E0F0B, 0x00090A06, 0x00141610, 0x001E1F16, 0x00313026, 0x006D6B60, 0x000B0900, 0x000D0E05, 0x00090D08, 0x00050A09, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07,
        0x00080C07, 0x00080C07, 0x00080C07, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090706, 0x0023221E, 0x00070602, 0x0012110D, 0x001C1C16, 0x00020200, 0x0054554C, 0x00BFC2B9, 0x005A5546,
        0x00736F64, 0x00A4A59C, 0x001A1E19, 0x00000100, 0x00050806, 0x000E0F0B, 0x00161610, 0x000B0D07, 0x000B0D07, 0x000B0C08, 0x000C0D09, 0x000C0D09, 0x000C0D0B, 0x000C0D0B, 0x000C0D0B, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A,
        0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000B0F0A, 0x000C100B, 0x000A100B, 0x000A100B, 0x000A100B, 0x000A100B,
        0x000A100B, 0x000A100B, 0x000B110C, 0x000B110C, 0x000C120D, 0x000C120D, 0x000C120D, 0x000E120C, 0x000E120C, 0x00040802, 0x004D4F49, 0x008D8F89, 0x00777973, 0x004B4B45, 0x001B1B15, 0x000C0E08, 0x000A0C06, 0x000A0C06, 0x000F110B, 0x00171913,
        0x001A1C16, 0x00151711, 0x0010120C, 0x000D140D, 0x000D140D, 0x000D140D, 0x000D140D, 0x000D140D, 0x000D140D, 0x000D140D, 0x000D140D, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E,
        0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x00111510, 0x000F130E, 0x0010140F, 0x000D130E, 0x00121813,
        0x00323833, 0x00555C57, 0x005F6661, 0x006D736E, 0x005B615C, 0x00878D88, 0x00F4F9F7, 0x00FBFFFE, 0x00F5FAF9, 0x00F4F9F8, 0x00F0F5F4, 0x00EEF3F2, 0x00F1F6F5, 0x00F4F9F8, 0x00F0F5F4, 0x00F0F5F4, 0x00F2F7F6, 0x00F3F8F7, 0x00F7FCFB, 0x00F9FCFA,
        0xFFFBFCFA, 0xFFFCFDFB, 0xFFFEFFFD, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFBF7F6, 0xFFFFFFFE, 0xFFFFFFFE, 0xF2E8E9E5, 0x00313530, 0x00000601, 0x00050D06, 0x0009110A, 0x000B0B05,
        0x000A0A04, 0x000B0A06, 0x00040501, 0x00121311, 0x00020503, 0x00050806, 0x00060808, 0x003B3D37, 0x0072736A, 0x00838278, 0x006B695E, 0x00121006, 0x000D0E05, 0x00070B06, 0x00040908, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07,
        0x00080C07, 0x00080C07, 0x00080C07, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00090D07, 0x00090D07, 0x00090D07, 0x00171312, 0x009D9A96, 0x008C8985, 0x00090804, 0x000F0F09, 0x00090B05, 0x00050800, 0x0074776E, 0x00B7B2A3,
        0x001F1B10, 0x000E0F06, 0x00040803, 0x00101513, 0x000B0E0C, 0x000C0D09, 0x000B0B05, 0x000B0D07, 0x000B0D07, 0x000B0C08, 0x000C0D09, 0x000C0D09, 0x000C0D0B, 0x000C0D0B, 0x000C0D0B, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A,
        0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000B0F0A, 0x000C100B, 0x000A100B, 0x000A100B, 0x000A100B, 0x000A100B,
        0x000A100B, 0x000A100B, 0x000B110C, 0x000B110C, 0x000C120D, 0x000C120D, 0x000C120D, 0x000D110B, 0x00131711, 0x00141812, 0x00A7A9A3, 0x00A7A9A3, 0x00A8A8A2, 0x00BFBFB9, 0x00C9C9C3, 0x00A5A7A1, 0x00848680, 0x0051534D, 0x00242620, 0x000B0D07,
        0x00070903, 0x000D0F09, 0x00141610, 0x000D140D, 0x000D140D, 0x000D140D, 0x000D140D, 0x000D140D, 0x000D140D, 0x000D140D, 0x000D140D, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E,
        0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x00111510, 0x000E120D, 0x00111510, 0x000D130E, 0x00131914,
        0x00323833, 0x004C534E, 0x004F5651, 0x00545A55, 0x00434944, 0x00838886, 0x00F6FBF9, 0x00F0F5F4, 0x00F3F8F7, 0x00F8FDFC, 0x00FBFFFF, 0x00FBFFFF, 0x00F3F8F7, 0x00EDF2F1, 0x00F3F8F7, 0x00F5FAF9, 0x00F3F8F7, 0x00F3F8F7, 0x00F1F6F5, 0x00FBFDF7,
        0x00F9FBF5, 0x00F8FAF4, 0x00FAFAF4, 0xFFFDFDF7, 0xFFFFFEF9, 0xFFFFFFFA, 0xFFFFFFFB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFFFFFF, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFEFFFD, 0xEAE3E7E2, 0x00323833, 0x00000702, 0x00000A02, 0x00000D05, 0x000D0D07,
        0x000E0E08, 0x00090804, 0x000E0F0B, 0x00020503, 0x000E1010, 0x00030807, 0x00060B0A, 0x00060802, 0x0015160D, 0x00222117, 0x00131106, 0x00121006, 0x00020300, 0x000E120D, 0x00050A09, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07,
        0x00080C07, 0x00080C07, 0x00080C07, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090403, 0x0073706C, 0x00F7F4F0, 0x00666561, 0x00030300, 0x000D0F09, 0x000A0F06, 0x00010600, 0x00B5B0A1,
        0x00878378, 0x00070800, 0x000B0F0A, 0x00080D0B, 0x00040705, 0x000C0D09, 0x000A0A04, 0x000B0D07, 0x000B0D07, 0x000B0C08, 0x000C0D09, 0x000C0D09, 0x000C0D0B, 0x000C0D0B, 0x000C0D0B, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A,
        0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000A0E09, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000B0F0A, 0x000B0F0A, 0x000A100B, 0x000A100B, 0x000A100B, 0x00090F0A,
        0x000A100B, 0x000A100B, 0x000B110C, 0x000B110C, 0x000C120D, 0x000C120D, 0x000C120D, 0x0010140E, 0x000C100A, 0x0012140E, 0x00B8BAB4, 0x0031312B, 0x00040400, 0x0025251F, 0x003B3833, 0x00696B65, 0x008A8C86, 0x00B4B6B0, 0x00C9CBC5, 0x00B9BBB5,
        0x008B8D87, 0x00585A54, 0x00373933, 0x000D140D, 0x000D140D, 0x000D140D, 0x000D140D, 0x000D140D, 0x000D140D, 0x000D140D, 0x000D140D, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E,
        0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000F130E, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000F130E, 0x000F130E, 0x000F130E, 0x0010140F, 0x000D110C, 0x00111510, 0x000D130E, 0x00141A15,
        0x00313732, 0x00454C47, 0x00434A45, 0x00474D48, 0x003B413C, 0x00797E7C, 0x00ECF1EF, 0x00EDF2F1, 0x00EFF4F3, 0x00E4E9E8, 0x00EDF1F2, 0x00EDF2F1, 0x00F9FEFD, 0x00F9FEFD, 0x00F1F6F5, 0x00E8EDEC, 0x00E9EEED, 0x00F1F6F5, 0x00EFF4F3, 0x00F5F8EF,
        0x00F1F4EB, 0x00EFF0E7, 0x00EEEFE6, 0x00F0F1E8, 0x00F6F4EC, 0x00F8F6EE, 0xFFF9F7EF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFDFFFE, 0xFFFDFFFE, 0xFFFAFDFB, 0xF7E9EDE8, 0x00353934, 0x00020601, 0x000B0F09, 0x00050903, 0x00080C07,
        0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07,
        0x00080C07, 0x00080C07, 0x00080C07, 0x00060A04, 0x00080C06, 0x00060A04, 0x000A0E08, 0x00030701, 0x000C100A, 0x00070B05, 0x00000200, 0x00090900, 0x00131307, 0x00919086, 0x006A6860, 0x00060200, 0x00221D1A, 0x009B9695, 0x00A09B9A, 0x00CDCBC0,
        0x00DBD9CE, 0x00212016, 0x00070800, 0x0011130D, 0x00090A06, 0x000B0E0C, 0x00060B09, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07,
        0x00090D07, 0x00090D07, 0x00090D07, 0x000C0E08, 0x000C0E08, 0x000C0E08, 0x000C0E08, 0x000C0E08, 0x000C0E08, 0x000C0E08, 0x000C0E08, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000C100B, 0x000C100B, 0x000C100B, 0x000A100B,
        0x000A100B, 0x000A100B, 0x000B110C, 0x000B110C, 0x000B110C, 0x000B110C, 0x000B110C, 0x000D140D, 0x000D110B, 0x001C1C16, 0x00B9B6B1, 0x002F2C27, 0x0013130D, 0x00121610, 0x000B120B, 0x00000F06, 0x002B2F29, 0x00362D29, 0x003E3531, 0x00595651,
        0x00898B85, 0x00AAA7A2, 0x00D7CECA, 0x00BFC3B8, 0x0067685E, 0x00100E06, 0x00343129, 0x00292520, 0x00161610, 0x00131712, 0x000B110C, 0x0010140E, 0x0010140E, 0x000F130D, 0x000F130D, 0x000F130D, 0x000F130D, 0x000E120C, 0x000E120C, 0x000F130E,
        0x000F130E, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000F130E, 0x000F130E, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000D1211, 0x000B100E, 0x00111412, 0x000D110C, 0x001B1E15,
        0x003B3C32, 0x0044453B, 0x003C3E32, 0x004D392E, 0x002F2D22, 0x006D7C74, 0x00E8F7F3, 0x00C8CDCC, 0x00ECE6E7, 0x00F7EFEF, 0x00F3F0EC, 0x00DDE4F5, 0x00F0F7FF, 0x00DBE3E2, 0x00C8D1C7, 0x00DBE3D8, 0x00E3EBE4, 0x00E0E5E6, 0x00E5EBF2, 0x00DAE6E6,
        0x00E1EBE5, 0x00FFFFF7, 0x00FEFBE6, 0x00E5D8B8, 0x00F2D9AF, 0x00ECC898, 0x00F4C996, 0x00FAD494, 0x82FFE3B0, 0xD5FFF5D8, 0xFFFFFEF5, 0xFFFFFEFF, 0xFFFFFDFF, 0xFFFFFDFE, 0xFFFFFEF9, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFDFF, 0xFFFFFBFF,
        0xFFFFF9FF, 0xFFFFF9FF, 0xFFFFF9FF, 0xFFFDFFFF, 0xFFFDFFFF, 0xFFFDFEFF, 0xFFFDFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFE, 0xFFFFFFFE, 0xFFFFFEFD, 0xFFFFFEFD, 0xFFFFFFFE, 0xFFFEFFFD, 0xFFFCFFFD, 0xFFFBFEFC, 0xFFFFFEF7,
        0xFFFFFFFA, 0xFFFFFFFB, 0xFFFFFFFC, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFDFDFD, 0xFFFCFCFC, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFDFFFE, 0xFFFDFFFE, 0xFFF9FCFA, 0xF7E8ECE7, 0x00363A35, 0x00000300, 0x000A0E08, 0x00070B05, 0x00080C07,
        0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07,
        0x00080C07, 0x00080C07, 0x00080C07, 0x000E120C, 0x000E120C, 0x00070B05, 0x00070B05, 0x000D110B, 0x00050903, 0x00070B05, 0x005C605A, 0x00474338, 0x00131106, 0x00050300, 0x0018150D, 0x00060300, 0x00201D19, 0x00D3CFCE, 0x00EDE9E8, 0x00E6E4D9,
        0x00AFADA2, 0x00242319, 0x000B0C03, 0x000A0C06, 0x00010200, 0x000E110F, 0x00070C0A, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07,
        0x00090D07, 0x00090D07, 0x00090D07, 0x000C0E08, 0x000C0E08, 0x000C0E08, 0x000C0E08, 0x000C0E08, 0x000C0E08, 0x000C0E08, 0x000C0E08, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000C100B, 0x000C100B, 0x000C100B, 0x000A100B,
        0x000A100B, 0x000A100B, 0x000B110C, 0x000B110C, 0x000B110C, 0x000B110C, 0x000B110C, 0x000D140D, 0x000D110B, 0x001E1E18, 0x00B8B5B0, 0x002C2924, 0x0013130D, 0x00121610, 0x000B120B, 0x00000B03, 0x009CA09A, 0x00E1D8D4, 0x00998E8A, 0x00090601,
        0x0010120C, 0x000B0803, 0x001D1410, 0x0054584D, 0x00C8C9BF, 0x00312F27, 0x00A9A69E, 0x00B4B0AB, 0x0023231D, 0x000E120D, 0x000D130E, 0x0010140E, 0x0010140E, 0x000F130D, 0x000F130D, 0x000F130D, 0x000F130D, 0x000E120C, 0x000E120C, 0x000F130E,
        0x000F130E, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000F130E, 0x000F130E, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000D1211, 0x000B100E, 0x00111412, 0x000E120D, 0x001C1E18,
        0x00393C33, 0x0041453A, 0x003D3E34, 0x00433529, 0x0029281A, 0x00788271, 0x00DFE4CF, 0x00A3977F, 0x00C6AA8B, 0x00DEBF98, 0x00E9CC9F, 0x00E0DECC, 0x00FFFFF0, 0x00F0DFC5, 0x00937E63, 0x0088775D, 0x00D4CDBC, 0x00F4FCF2, 0x00DAE8E6, 0x00F9FFFE,
        0x00FAFFFE, 0x00F4FBF4, 0x00FFFFF8, 0x00E8E8D8, 0x00D4CFBA, 0x00D3C8B2, 0x00CFC3AB, 0x00D1B597, 0x00D7B38D, 0x26E3B984, 0x36F3C78C, 0x71FFDDA8, 0xC4FFF0CF, 0xFFF9FDF2, 0xFFEDFFFF, 0xFFFFFDFF, 0xFFFFFDFF, 0xFFFCFDFF, 0xFFFCFEFE, 0xFFFBFFFE,
        0xFFFAFFFB, 0xFFFAFFF9, 0xFFFAFFF8, 0xFFFFFFFA, 0xFFFFFFFA, 0xFFFFFFFC, 0xFFFFFFFE, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFEFDFF, 0xFFFEFCFF, 0xFFFAFBFF, 0xFFFBFDFF, 0xFFFDFDFF, 0xFFFFFEFF, 0xFFFFFFFE, 0xFFFFFFFC, 0xFFFFFFF9, 0xFFFFFFF9, 0xFFFFFFFE,
        0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFEFD, 0xFFFFFDFC, 0xFFFDFDFD, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFDFFFE, 0xFFFDFFFE, 0xFFFCFFFD, 0xFFEDF1EC, 0x00414540, 0x00000400, 0x000A0E08, 0x00080C06, 0x00080C07,
        0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07,
        0x00080C07, 0x00080C07, 0x00080C07, 0x00000300, 0x00030701, 0x000A0E08, 0x00050903, 0x000C100A, 0x00050903, 0x001F231D, 0x00BCC0BA, 0x00E9E0D7, 0x00A59E95, 0x0049433C, 0x00050200, 0x00110E09, 0x0013130D, 0x004F504C, 0x00E4E8E3, 0x00838176,
        0x00110F04, 0x000C0B01, 0x000D0E05, 0x00060802, 0x00141511, 0x00050806, 0x00070C0A, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07,
        0x00090D07, 0x00090D07, 0x00090D07, 0x000C0E08, 0x000C0E08, 0x000C0E08, 0x000C0E08, 0x000C0E08, 0x000C0E08, 0x000C0E08, 0x000C0E08, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000C100B, 0x000C100B, 0x000C100B, 0x000A100B,
        0x000A100B, 0x000A100B, 0x000B110C, 0x000B110C, 0x000B110C, 0x000B110C, 0x000B110C, 0x000D140D, 0x000D110B, 0x0023231D, 0x00B7B4AF, 0x00282520, 0x0013130D, 0x0011150F, 0x000B120B, 0x00000D02, 0x00ABAEA5, 0x00EEE4DD, 0x00AFA59E, 0x0036342C,
        0x00ADB0A7, 0x00A4A29A, 0x00726861, 0x001F2318, 0x00ADAEA4, 0x0047453D, 0x00CECBC3, 0x00999590, 0x001D1D17, 0x00060A05, 0x00161C17, 0x0010140E, 0x0010140E, 0x000F130D, 0x000F130D, 0x000F130D, 0x000F130D, 0x000E120C, 0x000E120C, 0x000F130E,
        0x000F130E, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000F130E, 0x000F130E, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000D1210, 0x000B100E, 0x0010140F, 0x000E120D, 0x001D211B,
        0x00383C36, 0x003F443B, 0x00393E35, 0x00363937, 0x00101A14, 0x008F9C8E, 0x00F9FCE6, 0x00988C68, 0x00BA9C6B, 0x00E1BA7C, 0x00E2B974, 0x00D5C89A, 0x00F1DAAC, 0x00FDDBAD, 0x00E8C096, 0x00CCA987, 0x00DFD0B6, 0x00E9EEDF, 0x00DEF1E8, 0x00F7F8F6,
        0x00FDFFFF, 0x00EDF3F2, 0x00F2FCFC, 0x00F3FFFF, 0x00EFFFFF, 0x00E7FCFE, 0x00D2E9EB, 0x00BFE2E6, 0x00BCD5D1, 0x00B7BFAE, 0x00B4AB8A, 0x00BCA377, 0x11D4AD79, 0x3BF1C38D, 0x58FFD49C, 0x96EBE0BA, 0xBCFAF1CC, 0xEEFFFFE4, 0xFFFFFFED, 0xFFFFFFF0,
        0xFFFFFDF0, 0xFFFFFDF4, 0xFFFFFFF9, 0xFFFAFDFF, 0xFFFAFEFF, 0xFFFCFDFF, 0xFFFFFDFF, 0xFFFFFEFD, 0xFFFFFFFC, 0xFFFFFFFB, 0xFFFFFFF9, 0xFFFFFDFA, 0xFFFFFDFC, 0xFFFFFEFD, 0xFFFCFEFF, 0xFFFAFDFF, 0xFFF6FCFF, 0xFFF2FCFF, 0xFFF2FBFF, 0xFFF8FCFF,
        0xFFF8FBFF, 0xFFF8FBFF, 0xFFFAFCFD, 0xFFFDFDFD, 0xFFFEFEFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFBFEFC, 0xFFFDFFFE, 0xFFFDFFFE, 0xFFF5F9F4, 0x00515550, 0x00020601, 0x000A0E08, 0x00080C06, 0x00080C07,
        0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07,
        0x00080C07, 0x00080C07, 0x00080C07, 0x000D110B, 0x00040802, 0x000C100A, 0x00080C06, 0x00080C06, 0x00070B05, 0x00050903, 0x005B5F59, 0x00E3D7D1, 0x00E6DCD5, 0x00C8C0B9, 0x00737068, 0x0024211C, 0x00000200, 0x000C100A, 0x006E756E, 0x00A9A79C,
        0x00201E13, 0x000B0A00, 0x0017180F, 0x00070903, 0x0012130F, 0x00020503, 0x000D1210, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07,
        0x00090D07, 0x00090D07, 0x00090D07, 0x000C0E08, 0x000C0E08, 0x000C0E08, 0x000C0E08, 0x000C0E08, 0x000C0E08, 0x000C0E08, 0x000C0E08, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000C100B, 0x000C100B, 0x000C100B, 0x000A100B,
        0x000A100B, 0x000A100B, 0x000B110C, 0x000B110C, 0x000B110C, 0x000B110C, 0x000B110C, 0x000C130C, 0x000D110B, 0x00282822, 0x00B6B3AE, 0x0023201B, 0x0013130D, 0x0011150F, 0x000C130C, 0x000B1B10, 0x00A9ACA3, 0x00E6DCD5, 0x00B2A8A1, 0x00413E36,
        0x00C9CCC3, 0x00DAD7CF, 0x009C928B, 0x00292D22, 0x00B2B3A9, 0x0039372F, 0x00C0BDB5, 0x008F8B86, 0x0020201A, 0x00131712, 0x000C120D, 0x0010140E, 0x0010140E, 0x000F130D, 0x000F130D, 0x000F130D, 0x000F130D, 0x000E120C, 0x000E120C, 0x000F130E,
        0x000F130E, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000F130E, 0x000F130E, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000D1210, 0x000B110C, 0x000E140F, 0x000D130E, 0x001E241F,
        0x00373E39, 0x003B423D, 0x00373F38, 0x0023373C, 0x00172C2E, 0x008CA2A0, 0x00E0F1E8, 0x009FA594, 0x00ABA78A, 0x00ACA27A, 0x00C9BA8C, 0x00DED2AA, 0x00E6D5AE, 0x00E2CDA7, 0x00CEB895, 0x00B5A489, 0x00E1DAC7, 0x00EDF1E6, 0x00DBE5DF, 0x00EDEBEB,
        0x00FDFDFD, 0x00FBFEFF, 0x00EEF7FB, 0x00E3F5FC, 0x00DDF7FE, 0x00B5D9E1, 0x00A9D0D9, 0x00B4DBCB, 0x00BAE4DD, 0x00BEEBEF, 0x00BEE4F0, 0x00BDD2DA, 0x00BEBCB4, 0x00C8AD92, 0x00D0A67C, 0x00E9B37E, 0x00E8B682, 0x3BE6BC8D, 0x5CE9C69E, 0x86ECD3B1,
        0xB4F2E4C7, 0xDEFBF4DB, 0xF2FFFEE6, 0xFFFFFCF3, 0xFFFFFEF5, 0xFFFFFFF8, 0xFFFFFFFB, 0xFFFFFFFE, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFEFF, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFF, 0xFFFDFFFF, 0xFFFBFFFF, 0xFFFAFFFF, 0xFFFAFFFF, 0xFFF8FFFF, 0xFFF8FEFF,
        0xFFF8FEFF, 0xFFFAFEFF, 0xFFFBFEFF, 0xFFFDFFFF, 0xFFFFFFFF, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFCFFFD, 0xFFFDFFFE, 0xFFFDFFFE, 0xFFF7FBF6, 0x005B5F5A, 0x00010500, 0x00090D07, 0x00090D07, 0x00080C07,
        0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07,
        0x00080C07, 0x00080C07, 0x00080C07, 0x000A0E08, 0x00060A04, 0x00090D07, 0x00090D07, 0x00040802, 0x000E120C, 0x00000300, 0x00040802, 0x00605551, 0x00E5DCD8, 0x00C4BEB9, 0x00B6B2AD, 0x0095938B, 0x00282920, 0x00090C03, 0x000A0D04, 0x00ABA99E,
        0x00918F84, 0x00040300, 0x000E0F06, 0x000D0F09, 0x00000100, 0x000C0F0D, 0x00090E0C, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07,
        0x00090D07, 0x00090D07, 0x00090D07, 0x000C0E08, 0x000C0E08, 0x000C0E08, 0x000C0E08, 0x000C0E08, 0x000C0E08, 0x000C0E08, 0x000C0E08, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000C100B, 0x000C100B, 0x000C100B, 0x000A100B,
        0x000A100B, 0x000A100B, 0x000B110C, 0x000B110C, 0x000B110C, 0x000B110C, 0x000B110C, 0x000B120B, 0x000D110B, 0x002F2F29, 0x00B4B1AC, 0x001D1A15, 0x0013130D, 0x0010140E, 0x000C130C, 0x00000B00, 0x00B9BAB0, 0x00F0E5DD, 0x009B9088, 0x004F4D43,
        0x00DDDED4, 0x00D4D2C8, 0x004A3F37, 0x001C2015, 0x00B8B9AF, 0x0029271F, 0x00B3B0A8, 0x00A29E99, 0x0011110B, 0x00191D18, 0x000F1510, 0x0010140E, 0x0010140E, 0x000F130D, 0x000F130D, 0x000F130D, 0x000F130D, 0x000E120C, 0x000E120C, 0x000F130E,
        0x000F130E, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000F130E, 0x000F130E, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000B110C, 0x000D130E, 0x000D140F, 0x00202724,
        0x00363F3C, 0x0036413E, 0x00343F3C, 0x0024342D, 0x001C2B27, 0x00A6B6B5, 0x00D6EAEB, 0x007E9694, 0x00B6CFCB, 0x00D1E8E0, 0x00C2D5CC, 0x00DCD9D1, 0x00D7DAD1, 0x00D5E3D7, 0x00D7EBDE, 0x00B6CCC0, 0x00D2E0DA, 0x00E2E4E4, 0x00F5F0F2, 0x00E5E7E7,
        0x00E7E9EA, 0x00FCFEFF, 0x00F7FBFC, 0x00F6FFFF, 0x00EDFFFF, 0x00CDECEB, 0x00CEF3F1, 0x00C2E2E8, 0x00B1D1D6, 0x00A1C1C6, 0x00A3C4C7, 0x00B3D3D8, 0x00C0E2E8, 0x00BFE4EC, 0x00BBE0E8, 0x00B0CFC0, 0x00B0C8B6, 0x00B3BFA9, 0x00BEB9A0, 0x00D1B99B,
        0x00E4BC99, 0x00F2BD98, 0x4BFBBE96, 0x6DF8D7A5, 0x7DFADBAE, 0x9FFDE3BE, 0xC4FFEDD0, 0xEEFFF5E3, 0xFFFFFCF3, 0xFFFFFFFF, 0xFFFBFEFF, 0xFFF5FBFF, 0xFFF9FEFF, 0xFFFBFFFF, 0xFFFFFFFC, 0xFFFFFFF9, 0xFFFFFFF6, 0xFFFFFFF5, 0xFFFFFFF4, 0xFFF8FCFF,
        0xFFF9FDFF, 0xFFFAFDFF, 0xFFFDFFFF, 0xFFFDFFFF, 0xFFFFFFFF, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFDFFFE, 0xFFFCFFFD, 0xFFFAFDFB, 0xFFF3F7F2, 0x00616560, 0x00000200, 0x00080C06, 0x000A0E08, 0x00080C07,
        0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07,
        0x00080C07, 0x00080C07, 0x00080C07, 0x00030701, 0x000F130D, 0x000A0E08, 0x00080C06, 0x00020600, 0x000D110B, 0x000C100A, 0x00080C06, 0x000F0C08, 0x00413C39, 0x00B8B4AF, 0x00CFCBC6, 0x00BFBCB4, 0x00A3A098, 0x00333127, 0x00050300, 0x0037352A,
        0x00CCCABF, 0x00403F35, 0x000F1007, 0x0012140E, 0x000E0F0B, 0x000C0F0D, 0x00030806, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07,
        0x00090D07, 0x00090D07, 0x00090D07, 0x000B0D07, 0x000B0D07, 0x000B0D07, 0x000B0D07, 0x000B0D07, 0x000B0D07, 0x000B0D07, 0x000B0D07, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000C100B, 0x000C100B, 0x000C100B, 0x000A100B,
        0x000A100B, 0x000A100B, 0x000B110C, 0x000B110C, 0x000B110C, 0x000B110C, 0x000B110C, 0x000B120B, 0x000D110B, 0x0034342E, 0x00B3B0AB, 0x0017140F, 0x0014140E, 0x000F130D, 0x000C130C, 0x000F1D11, 0x00BBBCB2, 0x00EEE3DB, 0x0091867E, 0x00342F26,
        0x007A7B71, 0x00A8A39A, 0x00A69B93, 0x0033372C, 0x00AFB0A6, 0x00424038, 0x00BCB9B1, 0x00A39F9A, 0x0010100A, 0x000E120D, 0x00141A15, 0x0010140E, 0x0010140E, 0x000F130D, 0x000F130D, 0x000F130D, 0x000F130D, 0x000E120C, 0x000E120C, 0x000F130E,
        0x000F130E, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000F130E, 0x000F130E, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120C, 0x000B110C, 0x000C120D, 0x000E1512, 0x001F2A27,
        0x0033403E, 0x0033403E, 0x00313F3E, 0x003C4229, 0x002F311D, 0x00B0B2A6, 0x00E2EBE8, 0x008BA3A3, 0x008FB0B3, 0x009EC1C4, 0x00BBDCDF, 0x00DAE3F1, 0x00D9ECF9, 0x00C4E9F1, 0x00ABDADE, 0x0089B4B7, 0x00BDD8DC, 0x00C9CDD2, 0x00CDC2CA, 0x00E0E6E5,
        0x00EAEFEE, 0x00FFFFFE, 0x00FFFDFC, 0x00F4F8F3, 0x00DDEBE5, 0x00C8E1D7, 0x00B8D8CD, 0x00A2D0E1, 0x00B4DDE6, 0x00C6E6E5, 0x00C9E2D8, 0x00BAD2C8, 0x00A9C4C0, 0x00A0C3C7, 0x00A0C6D2, 0x00B8E2EE, 0x00C1E8F1, 0x00C9EEF2, 0x00CEEDEC, 0x00CDE4DF,
        0x00C6DACE, 0x00C2D1C3, 0x00C0CDBD, 0x00CCC3A2, 0x00CBC0A0, 0x00CBBF9D, 0x00D0C09B, 0x60DAC59F, 0x69E4CEA4, 0x79F0D7AB, 0x82F8DEB0, 0xC9FFF4D1, 0xD9FFF8D9, 0xEEFFFEE4, 0xFFFFFFEE, 0xFFFFFFF6, 0xFFFFFFFB, 0xFFFDFFFF, 0xFFFBFEFF, 0xFFFFFFFC,
        0xFFFFFFFC, 0xFFFFFDFC, 0xFFFEFCFB, 0xFFFCFCFC, 0xFFFDFDFD, 0xFFFEFEFE, 0xFFFCFEFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFDFFFE, 0xFFFCFFFD, 0xFFFBFEFC, 0xFFF7FBF6, 0x006D716C, 0x00000400, 0x00080C06, 0x00090D07, 0x00080C07,
        0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07,
        0x00080C07, 0x00080C07, 0x00080C07, 0x00050903, 0x000B0F09, 0x00010500, 0x00060A04, 0x000A0E08, 0x0010140E, 0x00060A04, 0x00040802, 0x000B0E0C, 0x00000200, 0x00272824, 0x0093908B, 0x00CCC9C1, 0x00E1DAD1, 0x00D0C7BD, 0x0041372D, 0x0049473C,
        0x00DFDDD2, 0x007B7A70, 0x00040500, 0x00000200, 0x00141511, 0x00030604, 0x00090E0C, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07,
        0x00090D07, 0x00090D07, 0x00090D07, 0x000B0D07, 0x000B0D07, 0x000B0D07, 0x000B0D07, 0x000B0D07, 0x000B0D07, 0x000B0D07, 0x000B0D07, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000C100B, 0x000C100B, 0x000C100B, 0x000A100B,
        0x000A100B, 0x000A100B, 0x000B110C, 0x000B110C, 0x000B110C, 0x000B110C, 0x000B110C, 0x000A110A, 0x000D110B, 0x00393933, 0x00B2AFAA, 0x0013100B, 0x0014140E, 0x000F130D, 0x000C130C, 0x00101C10, 0x00C1C0B6, 0x00ECE1D9, 0x009A8D85, 0x00605B52,
        0x00919086, 0x006F6A61, 0x00736860, 0x0035392E, 0x00B0B1A7, 0x00312F27, 0x00B1AEA6, 0x00A7A39E, 0x001F1F19, 0x000C100B, 0x00070D08, 0x0010140E, 0x0010140E, 0x000F130D, 0x000F130D, 0x000F130D, 0x000F130D, 0x000E120C, 0x000E120C, 0x000F130E,
        0x000F130E, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000F130E, 0x000F130E, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120C, 0x000B120B, 0x000B120D, 0x000C1512, 0x00212C2A,
        0x00334140, 0x0030403F, 0x00303F41, 0x002D3C27, 0x003D4233, 0x00CAC7C2, 0x00DDE3E2, 0x00859B99, 0x00AECECD, 0x00CBEBEA, 0x00BFDAD7, 0x00C9DAE3, 0x00C6E0E7, 0x00C1E3E9, 0x00C2E8ED, 0x00A5C8CC, 0x00CFE4E6, 0x009FA4A7, 0x006A6567, 0x006D7875,
        0x009AA19E, 0x00EFF2F0, 0x00FCFCFC, 0x00E9EEED, 0x00DFEDEB, 0x00D3EEEB, 0x00C9ECE8, 0x00CEEBD2, 0x00BAD8C5, 0x00A6C6BB, 0x00A3C5C4, 0x00B2D5D9, 0x00BCDFE9, 0x00BCDCE9, 0x00B7D4E2, 0x0095C4C2, 0x0095C3C4, 0x009AC5C8, 0x00A5CFD4, 0x00B5DEE7,
        0x00C5EBF7, 0x00CBEFFF, 0x00CDF1FF, 0x00CFEEF7, 0x00CEE9ED, 0x00CCDFDC, 0x00CDD6C9, 0x00D0CFB5, 0x00D4CBA6, 0x00DACA9C, 0x00DFCA97, 0x00DCC18F, 0x00E0C698, 0x71E5CEA8, 0x92E8D6B7, 0xB4EBDEC8, 0xDEF1E8DB, 0xFFF8F2EB, 0xFFFDFAF6, 0xFFFFFFF3,
        0xFFFFFFF5, 0xFFFFFFF7, 0xFFFFFFF9, 0xFFFFFFFC, 0xFFFFFFFF, 0xFFF9FCFF, 0xFFF8FBFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFDFFFE, 0xFFFDFFFE, 0xFFFDFFFE, 0xFFFDFFFC, 0x117B7F7A, 0x00060A05, 0x000A0E08, 0x00070B05, 0x00080C07,
        0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07,
        0x00080C07, 0x00080C07, 0x00080C07, 0x000A0E08, 0x000B0F09, 0x000A0E08, 0x000A0E08, 0x00030701, 0x00080C06, 0x00040802, 0x0011150F, 0x00050E0B, 0x00030A07, 0x00070B06, 0x00090903, 0x004F4942, 0x00A1988F, 0x00DED2C8, 0x00E7D8CF, 0x00D4D2C7,
        0x00EAE8DD, 0x006E6D63, 0x00050600, 0x00080A04, 0x000C0D09, 0x000A0D0B, 0x000A0F0D, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07,
        0x00090D07, 0x00090D07, 0x00090D07, 0x000B0D07, 0x000B0D07, 0x000B0D07, 0x000B0D07, 0x000B0D07, 0x000B0D07, 0x000B0D07, 0x000B0D07, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000B0F0A, 0x000C100B, 0x000C100B, 0x000C100B, 0x000A100B,
        0x000A100B, 0x000A100B, 0x000B110C, 0x000B110C, 0x000B110C, 0x000B110C, 0x000B110C, 0x000A110A, 0x000D110B, 0x003B3B35, 0x00B1AEA9, 0x00100D08, 0x0014140E, 0x000E120C, 0x000D140D, 0x00101D0F, 0x00D1D1C5, 0x00EADED4, 0x0081756B, 0x006E6A5F,
        0x00DDDDD1, 0x00A39F94, 0x00AEA298, 0x0043473C, 0x00A8A99F, 0x0035332B, 0x009B9890, 0x0065615C, 0x0010100A, 0x000F130E, 0x000D130E, 0x0010140E, 0x0010140E, 0x000F130D, 0x000F130D, 0x000F130D, 0x000F130D, 0x000E120C, 0x000E120C, 0x000F130E,
        0x000F130E, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000F130E, 0x000F130E, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120C, 0x000B120B, 0x000B120D, 0x000C1512, 0x00202D2B,
        0x00344241, 0x002D3F40, 0x002E4041, 0x00123132, 0x00182B30, 0x00848B94, 0x00A7B2BA, 0x007A9397, 0x0091B1B0, 0x00A8C7C0, 0x00CCE3DB, 0x00DFF4EB, 0x00DDF2EA, 0x00D5E9E4, 0x00C5D8D5, 0x009BA9A7, 0x00DEE9E7, 0x00DDE4DF, 0x00CACEC9, 0x007E8D85,
        0x007F8983, 0x00EAEFED, 0x00F7F9FA, 0x00E1EAEE, 0x00D7EAF1, 0x00AACBD4, 0x00A7D2DB, 0x00B3CDDD, 0x00BFDCEB, 0x00C8E8F5, 0x00BEE2EA, 0x00AAD0D2, 0x009CC4BF, 0x009EC8BD, 0x00A8D1C2, 0x00D2DCE6, 0x00D5E1EB, 0x00D4E4EB, 0x00CADEE3, 0x00BBD4D6,
        0x00ADCCCB, 0x00A8CBC7, 0x00A8CEC8, 0x00B5D7DD, 0x00BCDEE4, 0x00C7E8F1, 0x00CEF1FB, 0x00CEF1FE, 0x00C6EBF9, 0x00BDE1F1, 0x00B7DBED, 0x00C9D1D0, 0x00CACEC8, 0x00CDCABB, 0x00D4C6AA, 0x00DEC39E, 0x4FEEC997, 0x4FFFD298, 0x5CFFDB9D, 0xB0ECDBC6,
        0xC4F2E3D0, 0xE6FCEFDF, 0xFFFFFAF0, 0xFFFFFFFB, 0xFFFFFFFF, 0xFFFBFEFF, 0xFFF7FDFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFFFFFE, 0xFFFEFFFB, 0x328C8D89, 0x00060703, 0x000D0F09, 0x000A0C06, 0x00080C06,
        0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07,
        0x00080C07, 0x00080C07, 0x00080C07, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x000D0B0A, 0x000D0B0A, 0x00110F0E, 0x000F0D0C, 0x00080605, 0x00060403, 0x0032302F, 0x00A09E9D, 0x00D9D3C8,
        0x006C685D, 0x0023241A, 0x000A0F06, 0x00060D06, 0x00020601, 0x000D0E0C, 0x000D0B0A, 0x000A0C06, 0x000A0C06, 0x000A0C06, 0x000A0C06, 0x000A0C06, 0x000A0C06, 0x000A0C06, 0x000A0C06, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07,
        0x00090D07, 0x00090D07, 0x00090D07, 0x00080D04, 0x00080D04, 0x00090D07, 0x00090D07, 0x00090D08, 0x00090D08, 0x000A0E09, 0x000A0D0B, 0x0012110D, 0x00040A05, 0x00080F0A, 0x000C0D09, 0x00140B08, 0x0019100D, 0x00131410, 0x000F1D17, 0x00151F19,
        0x00161D18, 0x000E1510, 0x00070E09, 0x00080F0A, 0x00070E09, 0x00050F09, 0x000A140E, 0x000A110A, 0x00070B05, 0x004A4A44, 0x00A8A5A0, 0x000C0904, 0x0014140E, 0x000E120C, 0x000A110A, 0x001C251B, 0x00CBCCC3, 0x00EDE5DE, 0x007C766F, 0x002E2F26,
        0x00C2C5BC, 0x00D8D2CB, 0x00B2A29C, 0x00383C31, 0x00A4A59B, 0x00424038, 0x00C4C1B9, 0x00A29E99, 0x0015150F, 0x00131712, 0x00040A05, 0x0010140E, 0x0010140E, 0x000F130D, 0x000F130D, 0x000F130D, 0x000F130D, 0x000E120C, 0x000E120C, 0x0010120C,
        0x0011120E, 0x000D0E0A, 0x00141511, 0x00131412, 0x000B0C0A, 0x00101010, 0x000F0F0F, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000F130E, 0x000F130E, 0x00090F0A, 0x000F1613, 0x00262F2C,
        0x00374240, 0x0033403E, 0x002B3836, 0x00293932, 0x001F2923, 0x009EA3A1, 0x008C9795, 0x00859E9A, 0x00C3E4E0, 0x00C0DCDC, 0x00C4D8D9, 0x00D5DFE6, 0x00C6DCE1, 0x00C5E7E7, 0x00C5E5E4, 0x00ADC2C0, 0x00E4ECEB, 0x00E9EEED, 0x00EFF6F3, 0x00D6DBDC,
        0x009FA5A4, 0x00E7EEEB, 0x00EEF8F2, 0x00E0EFEB, 0x00DFF5F3, 0x00D1EEF2, 0x00CEEEF3, 0x00BDDEE1, 0x00AFD0D3, 0x00A3C4C7, 0x00A6C7CA, 0x00B3D4D7, 0x00BDDEE1, 0x00BDDEE1, 0x00B7D8DB, 0x00A2C3C6, 0x00A0C1C4, 0x00A3C4C7, 0x00B0D1D4, 0x00C2E3E6,
        0x00CEEFF2, 0x00CEEFF2, 0x00CAEBEE, 0x00BFE0E3, 0x00B8D9DC, 0x00AFD0D3, 0x00AACBCE, 0x00ADCED1, 0x00B7D8DB, 0x00C4E5E8, 0x00CCEDF0, 0x00D5F6F9, 0x00D2F3F6, 0x00D0EFF2, 0x00C9E8EB, 0x00C1E0E3, 0x00B9D6DA, 0x00B2CFD3, 0x00ADCACE, 0x00C6C9AF,
        0x00CECDB3, 0x96DED2BA, 0xA7EEDAC1, 0xBCFBE3CB, 0xD1FFF1D6, 0xE6FFFBE0, 0xF7FFFFE7, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFE, 0xFFFEFFFD, 0xFFFFFFFE, 0xFFFFFFFC, 0x47979894, 0x000D0E0A, 0x000C0E08, 0x000A0C06, 0x00080C06,
        0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07,
        0x00080C07, 0x00080C07, 0x00080C07, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00060501, 0x000C0B07, 0x000F0E0A, 0x000A0905, 0x0011100C, 0x000C0B07, 0x0033322E, 0x005D5C58, 0x00BAB4A9,
        0x00504C41, 0x00030400, 0x00020700, 0x00020902, 0x00111510, 0x000A0B09, 0x000B0908, 0x000A0C06, 0x000A0C06, 0x000A0C06, 0x000A0C06, 0x000A0C06, 0x000A0C06, 0x000A0C06, 0x000A0C06, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07,
        0x00090D07, 0x00090D07, 0x00090D07, 0x00080D04, 0x00080D04, 0x00090D07, 0x00090D07, 0x00090D08, 0x00090D08, 0x000A0E09, 0x000A0D0B, 0x000D0E0A, 0x00050B06, 0x00080E09, 0x000D0C08, 0x00130C09, 0x00161511, 0x0014241D, 0x001A3C32, 0x002E594E,
        0x00395E54, 0x00334E45, 0x001C2E27, 0x000D1711, 0x0009100B, 0x000B110C, 0x00101712, 0x000A110A, 0x00060A04, 0x004C4C46, 0x00A6A39E, 0x000C0904, 0x0013130D, 0x000F130D, 0x000A110A, 0x001A2319, 0x00CCCDC4, 0x00DFD7D0, 0x00767069, 0x00313229,
        0x0060635A, 0x009D9790, 0x00685852, 0x0045493E, 0x00A2A399, 0x001B1911, 0x006F6C64, 0x006C6863, 0x00050500, 0x000D110C, 0x001D231E, 0x0010140E, 0x0010140E, 0x000F130D, 0x000F130D, 0x000F130D, 0x000F130D, 0x000E120C, 0x000E120C, 0x0012140E,
        0x00171913, 0x000B0C08, 0x000D0E0A, 0x00181917, 0x00141513, 0x00131412, 0x00141414, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000F130E, 0x000F130E, 0x00090F0A, 0x00101714, 0x0027302D,
        0x00374240, 0x0033403E, 0x002B3836, 0x001D2D26, 0x00434D47, 0x00F4F9F7, 0x00D1DCDA, 0x007C9591, 0x008BACA8, 0x00A6C2C2, 0x00D5E9EA, 0x00E0EAF1, 0x00D1E7EC, 0x00C3E5E5, 0x00B0D0CF, 0x0099AEAC, 0x00DFE7E6, 0x00EEF3F2, 0x00F3FAF7, 0x00E0E5E6,
        0x00ABB1B0, 0x00EFF6F3, 0x00EFF9F3, 0x00D9E8E4, 0x00CDE3E1, 0x00B5D2D6, 0x00AECED3, 0x00B6D7DA, 0x00C1E2E5, 0x00C9EAED, 0x00C2E3E6, 0x00B1D2D5, 0x00A4C5C8, 0x00A1C2C5, 0x00A5C6C9, 0x00BFE0E3, 0x00C2E3E6, 0x00C0E1E4, 0x00B6D7DA, 0x00A9CACD,
        0x00A3C4C7, 0x00A8C9CC, 0x00AFD0D3, 0x00BADBDE, 0x00C6E7EA, 0x00D2F3F6, 0x00D4F5F8, 0x00CCEDF0, 0x00BFE0E3, 0x00B7D8DB, 0x00B4D5D8, 0x00ACCDD0, 0x00B1D2D5, 0x00BCDBDE, 0x00C6E5E8, 0x00CDECEF, 0x00D3F0F4, 0x00D4F1F5, 0x00D4F1F5, 0x00DBECDF,
        0x00DAE6DA, 0x00DBDFD4, 0x00DDD9CE, 0x00E1D8CE, 0x00E8E0D3, 0x00F1EBDE, 0xF2F7F4E6, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFE, 0xFFFCFDFB, 0xFFFEFFFD, 0xFFFFFFFC, 0x6DA8A9A5, 0x00151612, 0x000B0D07, 0x000A0C06, 0x00080C06,
        0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07,
        0x00080C07, 0x00080C07, 0x00080C07, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x000F0E0A, 0x0011100C, 0x00050400, 0x000A0905, 0x000A0905, 0x000B0A06, 0x00878682, 0x00C5C4C0, 0x00645E53,
        0x007A766B, 0x000E0F05, 0x00090E05, 0x000D140D, 0x00070B06, 0x000C0D0B, 0x000C0A09, 0x000A0C06, 0x000A0C06, 0x000A0C06, 0x000A0C06, 0x000A0C06, 0x000A0C06, 0x000A0C06, 0x000A0C06, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07,
        0x00090D07, 0x00090D07, 0x00090D07, 0x00080D04, 0x00080D04, 0x00090D07, 0x00090D07, 0x00090D08, 0x00090D08, 0x000A0E09, 0x000A0D0B, 0x000B0C08, 0x00060C07, 0x000A0E09, 0x000C0B07, 0x00120F0B, 0x000E1A14, 0x00153A30, 0x00316E60, 0x003B9784,
        0x0057A594, 0x00589083, 0x0037564D, 0x0016241E, 0x000C100B, 0x000D0E0A, 0x0010110D, 0x000A110A, 0x00050903, 0x004F4F49, 0x00A3A09B, 0x000B0803, 0x0012120C, 0x000F130D, 0x00091009, 0x0020291F, 0x00D1D2C9, 0x00F1E9E2, 0x00666059, 0x0087887F,
        0x0095988F, 0x00DFD9D2, 0x009E8E88, 0x00474B40, 0x00A7A89E, 0x00413F37, 0x007F7C74, 0x0056524D, 0x0010100A, 0x00171B16, 0x00050B06, 0x0010140E, 0x0010140E, 0x000F130D, 0x000F130D, 0x000F130D, 0x000F130D, 0x000E120C, 0x000E120C, 0x000C0E08,
        0x00161812, 0x0013150F, 0x0010110D, 0x000F100C, 0x000C0D0B, 0x0010110F, 0x00131412, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000F130E, 0x000F130E, 0x00090F0A, 0x00111815, 0x0028312E,
        0x00384341, 0x0033403E, 0x002C3937, 0x0026362F, 0x003F4943, 0x00DDE2E0, 0x00B8C3C1, 0x00869F9B, 0x00B9DAD6, 0x00C7E3E3, 0x00C1D5D6, 0x00DCE6ED, 0x00C6DCE1, 0x00C3E5E5, 0x00C6E6E5, 0x00B3C8C6, 0x00E3EBEA, 0x00E8EDEC, 0x00F4FBF8, 0x00E0E5E6,
        0x00B0B6B5, 0x00F0F7F4, 0x00F0FAF4, 0x00E0EFEB, 0x00DBF1EF, 0x00CDEAEE, 0x00CBEBF0, 0x00BCDDE0, 0x00AFD0D3, 0x00A5C6C9, 0x00AACBCE, 0x00B8D9DC, 0x00C0E1E4, 0x00BBDCDF, 0x00B2D3D6, 0x009DBEC1, 0x009EBFC2, 0x00A5C6C9, 0x00B2D3D6, 0x00C0E1E4,
        0x00C8E9EC, 0x00C7E8EB, 0x00C3E4E7, 0x00B6D7DA, 0x00ADCED1, 0x00A5C6C9, 0x00A7C8CB, 0x00B4D5D8, 0x00C3E4E7, 0x00CFF0F3, 0x00D4F5F8, 0x00D2F3F6, 0x00CBECEF, 0x00C4E3E6, 0x00BBDADD, 0x00B6D5D8, 0x00B8D5D9, 0x00BCD9DD, 0x00C0DDE1, 0x00CDECEF,
        0x00D4EFF3, 0x00DFF4F6, 0x00E7F6F9, 0x00E9F5F7, 0x00E8F1F4, 0xEEE4F0F0, 0xEEE3EFEF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFE, 0xFFFCFDFB, 0xFFFEFFFD, 0xFFFFFFFC, 0x8EB8B9B5, 0x001B1C18, 0x00070903, 0x000B0D07, 0x00080C06,
        0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07,
        0x00080C07, 0x00080C07, 0x00080C07, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00070602, 0x00020100, 0x000C0B07, 0x001A1915, 0x00080703, 0x00020100, 0x005F5E5A, 0x00DEDDD9, 0x003D372C,
        0x00252116, 0x00070800, 0x000E130A, 0x00020902, 0x00060A05, 0x00070806, 0x000F0D0C, 0x000A0C06, 0x000A0C06, 0x000A0C06, 0x000A0C06, 0x000A0C06, 0x000A0C06, 0x000A0C06, 0x000A0C06, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07,
        0x00090D07, 0x00090D07, 0x00090D07, 0x00080D04, 0x00080D04, 0x00090D07, 0x00090D07, 0x00090D08, 0x00090D08, 0x000A0E09, 0x000A0D0B, 0x00090D08, 0x00090D08, 0x000B0C08, 0x000F0C08, 0x0011100C, 0x00051A12, 0x00154A3D, 0x004C9C8B, 0x0046C6AD,
        0x0069D6C0, 0x0070BEAD, 0x004D786D, 0x0026362F, 0x0010140F, 0x000D0A06, 0x000F0C08, 0x000A110A, 0x00040802, 0x0053534D, 0x009F9C97, 0x000B0803, 0x0011110B, 0x000F130D, 0x00080F08, 0x00273026, 0x00CFD0C7, 0x00E8E0D9, 0x00605A53, 0x008C8D84,
        0x00777A71, 0x00726C65, 0x00A79791, 0x0054584D, 0x008C8D83, 0x0044423A, 0x00C1BEB6, 0x00615D58, 0x00070701, 0x00111510, 0x000D130E, 0x0010140E, 0x0010140E, 0x000F130D, 0x000F130D, 0x000F130D, 0x000F130D, 0x000E120C, 0x000E120C, 0x0014170E,
        0x000E100A, 0x0012140E, 0x00161812, 0x0010110D, 0x0011120E, 0x00131412, 0x000A0B09, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x0010140F, 0x000F130E, 0x000A100B, 0x00131A17, 0x002A3330,
        0x00384341, 0x0033403E, 0x002C3937, 0x002B3B34, 0x00454F49, 0x00E1E6E4, 0x00B7C2C0, 0x0077908C, 0x0091B2AE, 0x00B3CFCF, 0x00D6EAEB, 0x00DFE9F0, 0x00D4EAEF, 0x00C5E7E7, 0x00A7C7C6, 0x0097ACAA, 0x00E0E8E7, 0x00F0F5F4, 0x00EEF5F2, 0x00D5DADB,
        0x00B1B7B6, 0x00F3FAF7, 0x00F1FBF5, 0x00DDECE8, 0x00CEE4E2, 0x00B6D3D7, 0x00AFCFD4, 0x00B8D9DC, 0x00C5E6E9, 0x00CEEFF2, 0x00C6E7EA, 0x00B1D2D5, 0x00A1C2C5, 0x009FC0C3, 0x00A4C5C8, 0x00BCDDE0, 0x00BBDCDF, 0x00B6D7DA, 0x00ACCDD0, 0x00A2C3C6,
        0x00A0C1C4, 0x00A7C8CB, 0x00AECFD2, 0x00BEDFE2, 0x00C9EAED, 0x00D1F2F5, 0x00CCEDF0, 0x00BDDEE1, 0x00AECFD2, 0x00A8C9CC, 0x00A8C9CC, 0x00ACCDD0, 0x00B6D7DA, 0x00C6E5E8, 0x00D1F0F3, 0x00D5F4F7, 0x00D2EFF3, 0x00CCE9ED, 0x00C7E4E8, 0x00B3D7DF,
        0x00B9DBE1, 0x00C3E0E7, 0x00CCE6ED, 0x00D7EDF3, 0x00E1F3FA, 0xF7E8FBFF, 0xFFEEFEFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFE, 0xFFFDFEFC, 0xFFFFFFFE, 0xFFFFFFFC, 0xABC6C7C3, 0x0020211D, 0x00030500, 0x000D0F09, 0x00080C06,
        0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07,
        0x00080C07, 0x00080C07, 0x00080C07, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00393933, 0x00565650, 0x00080802, 0x00070701, 0x0013130D, 0x00070701, 0x00575751, 0x00E2E2DC, 0x005D574C,
        0x00070300, 0x000F1006, 0x000C1108, 0x00040B04, 0x000C100B, 0x000D0E0C, 0x000D0B0A, 0x000A0C06, 0x000A0C06, 0x000A0C06, 0x000A0C06, 0x000A0C06, 0x000A0C06, 0x000A0C06, 0x000A0C06, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07,
        0x00090D07, 0x00090D07, 0x00090D07, 0x00080D04, 0x00080D04, 0x00090D07, 0x00090D07, 0x00090D08, 0x00090D08, 0x000A0E09, 0x000A0D0B, 0x000B0F0A, 0x00090D08, 0x000B0C08, 0x00110E0A, 0x00100F0B, 0x0000130B, 0x00154A3D, 0x0059A998, 0x004CD1B7,
        0x0066D5BF, 0x0067B7A6, 0x004A756A, 0x00263831, 0x00131410, 0x00100D09, 0x0015120E, 0x00091009, 0x00030701, 0x00575751, 0x009A9792, 0x000A0702, 0x0010100A, 0x0010140E, 0x00060D06, 0x00273026, 0x00DADBD2, 0x00EDE5DE, 0x005C564F, 0x0026271E,
        0x00BABDB4, 0x00CFC9C2, 0x007F6F69, 0x004D5146, 0x0096978D, 0x0047453D, 0x00D3D0C8, 0x00635F5A, 0x00181812, 0x00161A15, 0x000C120D, 0x0010140E, 0x0010140E, 0x000F130D, 0x000F130D, 0x000F130D, 0x000F130D, 0x000E120C, 0x000E120C, 0x0012150C,
        0x000D1007, 0x0010130A, 0x0013150F, 0x0011130D, 0x0010110D, 0x0010110D, 0x0011120E, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x0010140F, 0x000E120D, 0x000A100B, 0x00151C19, 0x002C3532,
        0x00384341, 0x00323F3D, 0x002C3937, 0x001B2B24, 0x0056605A, 0x00E8EDEB, 0x00ADB8B6, 0x0090A9A5, 0x00BDDEDA, 0x00C5E1E1, 0x00C1D5D6, 0x00D8E2E9, 0x00C3D9DE, 0x00C1E3E3, 0x00C1E1E0, 0x00BACFCD, 0x00E7EFEE, 0x00ECF1F0, 0x00F6FDFA, 0x00D5DADB,
        0x00B7BDBC, 0x00F2F9F6, 0x00EDF7F1, 0x00DFEEEA, 0x00D7EDEB, 0x00CAE7EB, 0x00CAEAEF, 0x00B7D8DB, 0x00ABCCCF, 0x00A3C4C7, 0x00AACBCE, 0x00BCDDE0, 0x00C6E7EA, 0x00C2E3E6, 0x00B9DADD, 0x009CBDC0, 0x009EBFC2, 0x00A7C8CB, 0x00B5D6D9, 0x00C2E3E6,
        0x00C7E8EB, 0x00C3E4E7, 0x00BCDDE0, 0x00ABCCCF, 0x00A5C6C9, 0x00A2C3C6, 0x00AACBCE, 0x00B9DADD, 0x00C7E8EB, 0x00CDEEF1, 0x00CEEFF2, 0x00C5E6E9, 0x00BEDFE2, 0x00B4D3D6, 0x00ABCACD, 0x00A9C8CB, 0x00B1CED2, 0x00BEDBDF, 0x00C8E5E9, 0x00D4F3F6,
        0x00D4F1F5, 0x00D3F0F4, 0x00D4EDEF, 0xD5D7ECEE, 0xD9DAECED, 0xE6E0EDEF, 0xEEE4F0F2, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFE, 0xFFFEFFFD, 0xFFFFFFFE, 0xFFFEFFFB, 0xCDD6D7D3, 0x002B2C28, 0x00030500, 0x000D0F09, 0x00090D07,
        0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07,
        0x00080C07, 0x00080C07, 0x00080C07, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x0044443E, 0x00BEBEB8, 0x00686862, 0x000E0E08, 0x000A0A04, 0x00020200, 0x00383832, 0x00CDCDC7, 0x006A6459,
        0x00100C01, 0x000F1006, 0x00010600, 0x00080F08, 0x00060A05, 0x0010110F, 0x00090706, 0x000A0C06, 0x000A0C06, 0x000A0C06, 0x000A0C06, 0x000A0C06, 0x000A0C06, 0x000A0C06, 0x000A0C06, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07,
        0x00090D07, 0x00090D07, 0x00090D07, 0x00080D04, 0x00080D04, 0x00090D07, 0x00090D07, 0x00090D08, 0x00090D08, 0x000A0E09, 0x000A0D0B, 0x000E0F0B, 0x00070D08, 0x000A0E09, 0x000F0E0A, 0x00120F0B, 0x00010D07, 0x0012372D, 0x004B887A, 0x005DC4AF,
        0x0063BCA9, 0x00569486, 0x00375A50, 0x001A2A23, 0x000C100B, 0x000D0C08, 0x00171410, 0x00091009, 0x00020600, 0x005B5B55, 0x0096938E, 0x00090601, 0x000E0E08, 0x0010140E, 0x00050C05, 0x00262F25, 0x00D2D3CA, 0x00D9D1CA, 0x00635D56, 0x00393A31,
        0x00676A61, 0x00A29C95, 0x003F2F29, 0x0061655A, 0x0087887E, 0x0044423A, 0x00E8E5DD, 0x00716D68, 0x000A0A04, 0x000B0F0A, 0x00101611, 0x0010140E, 0x0010140E, 0x000F130D, 0x000F130D, 0x000F130D, 0x000F130D, 0x000E120C, 0x000E120C, 0x0013170C,
        0x0015180F, 0x0012150C, 0x000C0F06, 0x0011130D, 0x0011130D, 0x000C0D09, 0x00151612, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x0010140F, 0x000E120D, 0x000A100B, 0x00171E1B, 0x002E3734,
        0x00394442, 0x00323F3D, 0x002C3937, 0x001C2C25, 0x005E6862, 0x00EBF0EE, 0x00AAB5B3, 0x00839C98, 0x0096B7B3, 0x00ADC9C9, 0x00D7EBEC, 0x00DCE6ED, 0x00D2E8ED, 0x00C3E5E5, 0x00A2C2C1, 0x009EB3B1, 0x00E4ECEB, 0x00F3F8F7, 0x00EFF6F3, 0x00CDD2D3,
        0x00B9BFBE, 0x00F5FCF9, 0x00EDF7F1, 0x00DBEAE6, 0x00C7DDDB, 0x00B0CDD1, 0x00AACACF, 0x00BEDFE2, 0x00C9EAED, 0x00CFF0F3, 0x00C5E6E9, 0x00B0D1D4, 0x00A1C2C5, 0x00A1C2C5, 0x00A7C8CB, 0x00BEDFE2, 0x00BCDDE0, 0x00B6D7DA, 0x00ABCCCF, 0x00A2C3C6,
        0x00A1C2C5, 0x00A8C9CC, 0x00B0D1D4, 0x00C5E6E9, 0x00CBECEF, 0x00CCEDF0, 0x00C3E4E7, 0x00B3D4D7, 0x00A7C8CB, 0x00A5C6C9, 0x00A7C8CB, 0x00B7D8DB, 0x00BFE0E3, 0x00CBEAED, 0x00D0EFF2, 0x00CDECEF, 0x00C6E3E7, 0x00BEDBDF, 0x00B9D6DA, 0x00BDD5D5,
        0x00C3DBDB, 0x00CCE4E4, 0x00D5EDEB, 0xE6DFF4F2, 0xFFEBF9F7, 0xFFF4FCFB, 0xFFFAFFFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFE, 0xFFFDFEFC, 0xFFFFFFFE, 0xFFFDFEFA, 0xEEE6E7E3, 0x003A3B37, 0x00070903, 0x000C0E08, 0x00090D07,
        0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07,
        0x00080C07, 0x00080C07, 0x00080C07, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00070800, 0x00717269, 0x0096978E, 0x000C0D04, 0x00111209, 0x0015160D, 0x00020300, 0x00686960, 0x00A29C91,
        0x00120E03, 0x000E0F05, 0x000E130A, 0x00070E07, 0x0010140F, 0x00050604, 0x000C0A09, 0x000A0C06, 0x000A0C06, 0x000A0C06, 0x000A0C06, 0x000A0C06, 0x000A0C06, 0x000A0C06, 0x000A0C06, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07,
        0x00090D07, 0x00090D07, 0x00090D07, 0x00080D04, 0x00080D04, 0x00090D07, 0x00090D07, 0x00090D08, 0x00090D08, 0x000A0E09, 0x000A0D0B, 0x000C0D09, 0x00080E09, 0x00090F0A, 0x000D0C08, 0x00140D0A, 0x000D0C08, 0x000E1E17, 0x00294B41, 0x00559082,
        0x0054867A, 0x0041665C, 0x00223A32, 0x00101C16, 0x00080E09, 0x00090A06, 0x000C0D09, 0x00091009, 0x00010500, 0x005E5E58, 0x0093908B, 0x00090601, 0x000D0D07, 0x0010140E, 0x00040B04, 0x002B342A, 0x00D4D5CC, 0x00E9E1DA, 0x00565049, 0x00919289,
        0x009C9F96, 0x00E9E3DC, 0x0084746E, 0x005B5F54, 0x007D7E74, 0x004E4C44, 0x00C7C4BC, 0x00797570, 0x0012120C, 0x00121611, 0x000D130E, 0x0010140E, 0x0010140E, 0x000F130D, 0x000F130D, 0x000F130D, 0x000F130D, 0x000E120C, 0x000E120C, 0x001A1E13,
        0x001C2015, 0x0025281F, 0x00181B12, 0x000C0E08, 0x00141610, 0x0013150F, 0x000D0E0A, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x0010140F, 0x000E120D, 0x000A100B, 0x00181F1C, 0x00303936,
        0x00394442, 0x00323F3D, 0x002C3937, 0x001B2B24, 0x00656F69, 0x00E6EBE9, 0x009EA9A7, 0x0094ADA9, 0x00BDDEDA, 0x00C2DEDE, 0x00C5D9DA, 0x00D7E1E8, 0x00C7DDE2, 0x00C3E5E5, 0x00B7D7D6, 0x00B8CDCB, 0x00E8F0EF, 0x00EDF2F1, 0x00F1F8F5, 0x00C9CECF,
        0x00BAC0BF, 0x00F4FBF8, 0x00EDF7F1, 0x00E2F1ED, 0x00D7EDEB, 0x00CAE7EB, 0x00CAEAEF, 0x00B0D1D4, 0x00AACBCE, 0x00AACBCE, 0x00B4D5D8, 0x00C3E4E7, 0x00C8E9EC, 0x00C0E1E4, 0x00B5D6D9, 0x009EBFC2, 0x009FC0C3, 0x00A5C6C9, 0x00B4D5D8, 0x00C2E3E6,
        0x00C6E7EA, 0x00BFE0E3, 0x00B5D6D9, 0x00A3C4C7, 0x00A2C3C6, 0x00A6C7CA, 0x00AECFD2, 0x00BBDCDF, 0x00C6E7EA, 0x00CBECEF, 0x00CDEEF1, 0x00B1D2D5, 0x00AFD0D3, 0x00AECDD0, 0x00ABCACD, 0x00AECDD0, 0x00B9D6DA, 0x00C8E5E9, 0x00D3F0F4, 0x00D9EDF2,
        0x00D5EBF0, 0x00D0E9EB, 0x00CDE6E8, 0xC9D2E7E8, 0xE2DDEAEC, 0xFFEBF0F3, 0xFFF3F5F6, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFE, 0xFFFDFEFC, 0xFFFFFFFE, 0xFFFCFDF9, 0xFFF2F3EF, 0x00464743, 0x000B0D07, 0x000A0C06, 0x00090D07,
        0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07,
        0x00080C07, 0x00080C07, 0x00080C07, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x000B0C03, 0x000D0E05, 0x001C1D14, 0x00070800, 0x008C8D84, 0x0096978E, 0x0053544B, 0x001A1B12, 0x00A7A196,
        0x005D594E, 0x00070800, 0x00000500, 0x00080F08, 0x00090D08, 0x00080907, 0x00100E0D, 0x000A0C06, 0x000A0C06, 0x000A0C06, 0x000A0C06, 0x000A0C06, 0x000A0C06, 0x000A0C06, 0x000A0C06, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07,
        0x00090D07, 0x00090D07, 0x00090D07, 0x00080D04, 0x00080D04, 0x00090D07, 0x00090D07, 0x00090D08, 0x00090D08, 0x000A0E09, 0x000A0D0B, 0x000B0A06, 0x00090F0A, 0x0009100B, 0x00090A06, 0x00160D0A, 0x00170E0B, 0x000A0B07, 0x000C1A14, 0x00132E25,
        0x001A322A, 0x0012271F, 0x0004120C, 0x00030D07, 0x0009100B, 0x000A100B, 0x000C100B, 0x00091009, 0x00010500, 0x0060605A, 0x00918E89, 0x00090601, 0x000D0D07, 0x0011150F, 0x00040B04, 0x0030392F, 0x00D5D6CD, 0x00E3DBD4, 0x0048423B, 0x008B8C83,
        0x006E7168, 0x00746E67, 0x00968680, 0x005D6156, 0x0083847A, 0x005F5D55, 0x00D0CDC5, 0x00D3CFCA, 0x00393933, 0x00030702, 0x00101611, 0x0010140E, 0x0010140E, 0x000F130D, 0x000F130D, 0x000F130D, 0x000F130D, 0x000E120C, 0x000E120C, 0x0075796E,
        0x00868A7F, 0x00AEB2A7, 0x007E8178, 0x001A1D14, 0x00080A04, 0x001C1E18, 0x0011130D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x000E120D, 0x0010140F, 0x000D110C, 0x000B110C, 0x0019201D, 0x00303936,
        0x00394442, 0x00313E3C, 0x002C3937, 0x001A2A23, 0x006A746E, 0x00F0F5F3, 0x009CA7A5, 0x0079928E, 0x0097B8B4, 0x00B7D3D3, 0x00D9EDEE, 0x00E3EDF4, 0x00D2E8ED, 0x00C1E3E3, 0x00A3C3C2, 0x00A4B9B7, 0x00E3EBEA, 0x00F2F7F6, 0x00F4FBF8, 0x00C9CECF,
        0x00BEC4C3, 0x00F6FDFA, 0x00EBF5EF, 0x00DBEAE6, 0x00C8DEDC, 0x00B5D2D6, 0x00B1D1D6, 0x00C0E1E4, 0x00C9EAED, 0x00CDEEF1, 0x00C2E3E6, 0x00B0D1D4, 0x00A3C4C7, 0x00A5C6C9, 0x00ABCCCF, 0x00BFE0E3, 0x00BDDEE1, 0x00B5D6D9, 0x00A7C8CB, 0x009CBDC0,
        0x009EBFC2, 0x00AECFD2, 0x00BCDDE0, 0x00CBECEF, 0x00C9EAED, 0x00C4E5E8, 0x00BADBDE, 0x00B0D1D4, 0x00A8C9CC, 0x00A6C7CA, 0x00A7C8CB, 0x00BFE0E3, 0x00C5E6E9, 0x00CDECEF, 0x00CCEBEE, 0x00C4E3E6, 0x00B9D6DA, 0x00B0CDD1, 0x00ABC8CC, 0x00BACED9,
        0x00C1D8E0, 0x00CBE7EE, 0x00D6F2F9, 0x00DFF7FD, 0xF7E7F7FE, 0xFFECF4FB, 0xFFEFF1F9, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFFFFFE, 0xFFF8F9F7, 0x00636460, 0x00060703, 0x00070804, 0x000B0D07,
        0x000B0D07, 0x000C0E08, 0x000C0E08, 0x000C0E08, 0x000B0D07, 0x000A0C06, 0x000A0C06, 0x000B0D07, 0x000B0D07, 0x000B0D07, 0x000A0C06, 0x000A0C06, 0x000A0C06, 0x000A0C06, 0x000A0C06, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07,
        0x00080C07, 0x00080C07, 0x00080C07, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080F0C, 0x00040A05, 0x000A0E09, 0x00050602, 0x00595651, 0x00D5CFCA, 0x00DDD5CE, 0x00B6AEA7, 0x00979289,
        0x00BBB9AF, 0x002A291F, 0x00040800, 0x000A1005, 0x00050F03, 0x00061206, 0x00000A00, 0x000A0C06, 0x000A0C06, 0x000A0C06, 0x000A0C06, 0x000A0C06, 0x000A0C06, 0x000B0D07, 0x000C0E08, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06,
        0x00080C06, 0x00080C06, 0x00080C06, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x000B0C08, 0x000B0C08, 0x000B0C08, 0x000C0D09, 0x000C0D09, 0x000C0D09, 0x000C0D09, 0x000C0D09, 0x000E0F0B,
        0x000E0F0B, 0x000E0F0B, 0x000E0F0B, 0x000E0F0B, 0x000E0F0B, 0x000E0F0B, 0x000E0F0B, 0x00091009, 0x00030701, 0x0061615B, 0x008F8C87, 0x00090601, 0x0010100A, 0x000E120C, 0x00020902, 0x003D3C32, 0x00D2D1C7, 0x00E1DFD5, 0x004D4B41, 0x003D382F,
        0x00BEB9B0, 0x00DBD4CB, 0x00575047, 0x006C6D63, 0x0078776D, 0x0047443C, 0x00C1BBB4, 0x009F9994, 0x00312E29, 0x000C0D09, 0x000F1510, 0x000E120D, 0x0010140F, 0x000F130E, 0x000D110C, 0x000F130E, 0x00111510, 0x000E120D, 0x00090D08, 0x008D8984,
        0x0046423D, 0x0063605B, 0x008D8A85, 0x0025221D, 0x0012120C, 0x001A1A14, 0x00191913, 0x0011160D, 0x00081006, 0x000C140D, 0x00121D15, 0x0009100B, 0x000B0F0A, 0x001A1915, 0x00140F0E, 0x000D100E, 0x00131614, 0x000A0F0D, 0x001A211E, 0x00343D3A,
        0x00384340, 0x002F3D39, 0x00293733, 0x0013231C, 0x007B8481, 0x00E9EFEE, 0x009BACA9, 0x009DBAB7, 0x00B4D4D3, 0x00BDD4D6, 0x00CDD9DD, 0x00CADAE0, 0x00C4DFE3, 0x00C6E8E8, 0x00B7D3D3, 0x00BBC9C8, 0x00EDF2F1, 0x00EFF4F3, 0x00EEF7F4, 0x00BFC8C5,
        0x00C7CDCC, 0x00F6FEFD, 0x00E4EEEE, 0x00E0EFF1, 0x00D6EDEF, 0x00C7E6E9, 0x00BFE2E5, 0x00AFD0D3, 0x00A9CACD, 0x00A8C9CC, 0x00B3D4D7, 0x00C2E3E6, 0x00C8E9EC, 0x00BFE0E3, 0x00B4D5D8, 0x009ABBBE, 0x009EBFC2, 0x00A9CACD, 0x00B8D9DC, 0x00C4E5E8,
        0x00C3E4E7, 0x00B5D6D9, 0x00A7C8CB, 0x009BBCBF, 0x00A1C2C5, 0x00AECFD2, 0x00BBDCDF, 0x00C5E6E9, 0x00C8E9EC, 0x00C6E7EA, 0x00C2E3E6, 0x00AECFD2, 0x00A8C9CC, 0x00A4C5C8, 0x00A6C7CA, 0x00B1D2D5, 0x00BFE0E3, 0x00CBECEF, 0x00D0F1F4, 0x00CBE6EA,
        0x00C7E2E6, 0x00C5DCDE, 0x00C6DBDD, 0x00CDDFE0, 0xD9DAE7E9, 0xF2E6F2F4, 0xFFEFF9F9, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFCFCFC, 0xFFFFFFFF, 0xFFFEFFFD, 0xFFFDFEFC, 0x0072736F, 0x00080905, 0x00080905, 0x000B0D07,
        0x000B0D07, 0x000C0E08, 0x000C0E08, 0x000C0E08, 0x000B0D07, 0x000B0D07, 0x000A0C06, 0x000B0D07, 0x000B0D07, 0x000B0D07, 0x000B0D07, 0x000A0C06, 0x000A0C06, 0x000A0C06, 0x000A0C06, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07,
        0x00080C07, 0x00080C07, 0x00080C07, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00070E0B, 0x00020803, 0x00080C07, 0x00060703, 0x00080500, 0x006B6762, 0x00D0CAC3, 0x00AFA7A0, 0x00C9C2B9,
        0x00DDD8CF, 0x00A7A59B, 0x001A190F, 0x00050900, 0x00080E03, 0x000B1308, 0x00061004, 0x000C0E08, 0x000C0E08, 0x000C0E08, 0x000C0E08, 0x000A0C06, 0x00090B05, 0x00080A04, 0x00080A04, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06,
        0x00080C06, 0x00080C06, 0x00080C06, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x000B0C08, 0x000B0C08, 0x000B0C08, 0x000C0D09, 0x000C0D09, 0x000C0D09, 0x000C0D09, 0x000C0D09, 0x000D0E0A,
        0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x00050C05, 0x00010500, 0x0062625C, 0x00928F8A, 0x000B0803, 0x000F0F09, 0x000E120C, 0x00060D06, 0x0039382E, 0x00E0DFD5, 0x00D0CEC4, 0x004D4B41, 0x00746F66,
        0x006D685F, 0x00615A51, 0x003C352C, 0x00727369, 0x00747369, 0x00646159, 0x00DAD4CD, 0x00A7A19C, 0x00201D18, 0x000D0E0A, 0x000D130E, 0x000E120D, 0x0010140F, 0x000F130E, 0x000E120D, 0x000F130E, 0x0010140F, 0x000E120D, 0x000A0E09, 0x00635F5A,
        0x00918D88, 0x00585550, 0x00989590, 0x002F2C27, 0x000E0E08, 0x0015150F, 0x000D0D07, 0x000C0F06, 0x00171C13, 0x000D150E, 0x000A120B, 0x000A110C, 0x000D110C, 0x00171612, 0x00120E0D, 0x000D100E, 0x00121513, 0x000A0F0D, 0x001A211E, 0x00343D3A,
        0x0037423F, 0x002E3C38, 0x00273531, 0x0021312A, 0x00919A97, 0x00EFF5F4, 0x008E9F9C, 0x00809D9A, 0x00A0C0BF, 0x00C5DCDE, 0x00DDE9ED, 0x00DCECF2, 0x00C6E1E5, 0x00B8DADA, 0x00A3BFBF, 0x00B3C1C0, 0x00ECF1F0, 0x00F2F7F6, 0x00EFF8F5, 0x00BEC7C4,
        0x00C6CCCB, 0x00F4FCFB, 0x00E5EFEF, 0x00D7E6E8, 0x00BED5D7, 0x00B1D0D3, 0x00B4D7DA, 0x00C3E4E7, 0x00CAEBEE, 0x00CDEEF1, 0x00C2E3E6, 0x00B0D1D4, 0x00A6C7CA, 0x00A8C9CC, 0x00AFD0D3, 0x00C7E8EB, 0x00BFE0E3, 0x00B1D2D5, 0x00A1C2C5, 0x009ABBBE,
        0x00A2C3C6, 0x00B5D6D9, 0x00C5E6E9, 0x00D0F1F4, 0x00C7E8EB, 0x00BADBDE, 0x00AECFD2, 0x00A8C9CC, 0x00A8C9CC, 0x00ABCCCF, 0x00ADCED1, 0x00C5E6E9, 0x00C9EAED, 0x00CBECEF, 0x00C7E8EB, 0x00BCDDE0, 0x00B0D1D4, 0x00A8C9CC, 0x00A4C5C8, 0x00BBD6DA,
        0x00C6E1E5, 0x00D9F0F2, 0x00E2F7F9, 0x00E4F6F7, 0x00E6F3F5, 0xF7E8F4F6, 0xFFECF6F6, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFCFCFC, 0xFFFFFFFF, 0xFFFDFEFC, 0xFFFFFFFE, 0x26878884, 0x000A0B07, 0x000A0B07, 0x000B0D07,
        0x000B0D07, 0x000C0E08, 0x000C0E08, 0x000C0E08, 0x000C0E08, 0x000B0D07, 0x000B0D07, 0x000B0D07, 0x000B0D07, 0x000B0D07, 0x000B0D07, 0x000A0C06, 0x000A0C06, 0x000A0C06, 0x000A0C06, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07, 0x00080C07,
        0x00080C07, 0x00080C07, 0x00080C07, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00030806, 0x000C120D, 0x000C100B, 0x00161713, 0x00020200, 0x00110E09, 0x00706D65, 0x0098928B, 0x002D251E,
        0x007C746D, 0x00C3BDB6, 0x00AAA79F, 0x004A4840, 0x00080900, 0x00020500, 0x0010130A, 0x000C0E08, 0x000C0E08, 0x000C0E08, 0x000C0E08, 0x000C0E08, 0x000A0C06, 0x00080A04, 0x00070903, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06, 0x00080C06,
        0x00080C06, 0x00080C06, 0x00080C06, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x00090D07, 0x000B0C08, 0x000B0C08, 0x000B0C08, 0x000C0D09, 0x000C0D09, 0x000C0D09, 0x000C0D09, 0x000C0D09, 0x000D0E0A,
        0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x000D0E0A, 0x00091009, 0x00010500, 0x005C5C56, 0x008B8883, 0x00080500, 0x000F0F0