var NAVTREE =
[
  [ "Energy Micro IEC60355 Library Project", "index.html", [
    [ "Modules", "modules.html", [
      [ "IEC60335 Class-B Library", "group__IEC60335__LIB.html", [
        [ "Library Requirements", "group__IEC60335__MODULES.html", null ],
        [ "Library Configuration", "group__IEC60335__CONFIG.html", [
          [ "Defines", "group__IEC60335__CONFIG.html", [
            [ "CPU_CLK", "group__IEC60335__CONFIG.html#ga830fd4b906cd391487712d11740c065f", null ],
            [ "dynamic_CRC_table", "group__IEC60335__CONFIG.html#gab58427a8e90bbbaf099e8bb7d87df8f2", null ],
            [ "ENTRY_FLASH_CRC", "group__IEC60335__CONFIG.html#gade11389393902208065be40a987b10ae", null ],
            [ "FLASH_SIZE", "group__IEC60335__CONFIG.html#gae69620948dea1b76e0ab7843ab719db7", null ],
            [ "IEC60335_RAM_buffersize", "group__IEC60335__CONFIG.html#ga7f1d7aab80611ce8313e91ca460cd766", null ],
            [ "IEC60335_RAM_SIZE", "group__IEC60335__CONFIG.html#ga34411cfaa21c2925f1a8438a36ceb8dd", null ],
            [ "IEC60335_RAM_SP_Offset", "group__IEC60335__CONFIG.html#ga03d7fa3c23f25c2ba501b9f9d480d1d0", null ],
            [ "IEC60335_RAM_START", "group__IEC60335__CONFIG.html#gae351447525dbe263b116b55404c561cd", null ],
            [ "LoopForever", "group__IEC60335__CONFIG.html#ga485ab5cabcd5996eaa09da059f9bcad5", null ],
            [ "SRAM_SIZE", "group__IEC60335__CONFIG.html#ga10a9c742edabf5e945a1c509b7e1451e", null ],
            [ "TEST_POST_CPUREG", "group__IEC60335__CONFIG.html#ga13ac927ecfd69ddb0a035fdb89044b22", null ],
            [ "TEST_POST_FLASH", "group__IEC60335__CONFIG.html#gacddef49cea4e692fdd98aa0682354269", null ],
            [ "TEST_POST_PC", "group__IEC60335__CONFIG.html#ga34fef8f1d094e40323d222652a9d52d1", null ],
            [ "TEST_POST_RAM", "group__IEC60335__CONFIG.html#ga2683f341e13b31d576199485ca308acd", null ],
            [ "TEST_POST_WDOG", "group__IEC60335__CONFIG.html#gad5781c960f6790b65a86d6374601325e", null ],
            [ "USE_SYSTICK", "group__IEC60335__CONFIG.html#ga052dbd718131eb3c6e618d2050737aa6", null ],
            [ "USE_TIMER0", "group__IEC60335__CONFIG.html#ga287cfbaa0a33a26ea46fd4862e39cda4", null ],
            [ "USE_TIMER1", "group__IEC60335__CONFIG.html#gaca1816aef5c6846755ed9d741018bcd1", null ]
          ] ]
        ] ],
        [ "POST Library Function", "group__IEC60335__POST.html", [
          [ "Functions", "group__IEC60335__POST.html", [
            [ "IEC60335_ClassB_POST", "group__IEC60335__POST.html#ga2bd67b6af677f14c218df0c818fb2639", null ]
          ] ]
        ] ],
        [ "Program Counter Test", "group__IEC60335__PC__TEST.html", [
          [ "Functions", "group__IEC60335__PC__TEST.html", [
            [ "IEC60335_B_PCTest_A", "group__IEC60335__PC__TEST.html#ga9e1e95977d273e0995bbcd94b175f863", null ],
            [ "IEC60335_B_PCTest_B", "group__IEC60335__PC__TEST.html#gae5468f2ae62f7ab0cce704995e5b2cb4", null ],
            [ "IEC60335_B_PCTest_C", "group__IEC60335__PC__TEST.html#gac6e335af7db66e231ddc63d97fbc3bc0", null ],
            [ "IEC60335_B_PCTest_D", "group__IEC60335__PC__TEST.html#gaa6e63678c7fa88ef666e6f4e83d64be4", null ],
            [ "IEC60335_B_PCTest_E", "group__IEC60335__PC__TEST.html#ga1e0a299ae97b91420d48ced6c7321696", null ],
            [ "IEC60335_B_PCTest_F", "group__IEC60335__PC__TEST.html#gae5fa6fdc23b316f3d89a021eaebae8db", null ],
            [ "IEC60335_ClassB_PCTest_BIST", "group__IEC60335__PC__TEST.html#ga30ad1b1f9cf5f7e3cf63fa7a3fd9f166", null ],
            [ "IEC60335_ClassB_PCTest_POST", "group__IEC60335__PC__TEST.html#gac05836d244dd4c05e762fb24eb3064c3", null ]
          ] ],
          [ "Variables", "group__IEC60335__PC__TEST.html", [
            [ "PCTest_funcTable", "group__IEC60335__PC__TEST.html#ga2d6e66a74769207d294aa41a4e6670a8", null ],
            [ "PCTest_funcTable", "group__IEC60335__PC__TEST.html#ga2d6e66a74769207d294aa41a4e6670a8", null ],
            [ "PCTest_resultTable", "group__IEC60335__PC__TEST.html#gacdde8abcb8bdd94dd88eabe7bb65a7a4", null ],
            [ "PCTest_resultTable", "group__IEC60335__PC__TEST.html#gacdde8abcb8bdd94dd88eabe7bb65a7a4", null ]
          ] ]
        ] ],
        [ "CPU Register Test", "group__IEC60335__CPUREG__TEST.html", [
          [ "Defines", "group__IEC60335__CPUREG__TEST.html", [
            [ "TestClear", "group__IEC60335__CPUREG__TEST.html#ga0b491bf859eeced71896bda39a44ff7f", null ],
            [ "TestState_r0", "group__IEC60335__CPUREG__TEST.html#gaaa37e49e52162f7a6ae4d678c3fede58", null ],
            [ "TestState_r1r7", "group__IEC60335__CPUREG__TEST.html#ga2443920b881c8a5715efe85df95483ca", null ],
            [ "TestState_r8r12", "group__IEC60335__CPUREG__TEST.html#gafa324fbf060bdcacbe8c6cb17b7ffce7", null ],
            [ "TestStateAPSR", "group__IEC60335__CPUREG__TEST.html#ga806c0b026e29a57cf238aaf90daa45ec", null ],
            [ "TestStateBASEPRI", "group__IEC60335__CPUREG__TEST.html#gaca7029b24c1f21e8ef4f3a726794392c", null ],
            [ "TestStateFAULTMASK", "group__IEC60335__CPUREG__TEST.html#gaff71d16f969ebc30afdbd5dac0de1a60", null ],
            [ "TestStateLR", "group__IEC60335__CPUREG__TEST.html#ga760eb478deb28b0bf669eb88379a6ded", null ],
            [ "TestStateMSP", "group__IEC60335__CPUREG__TEST.html#ga70f8bd6da5bcaf09ddcf0d3e4be8d680", null ],
            [ "TestStatePRIMASK", "group__IEC60335__CPUREG__TEST.html#gaf9e721ff402845da9d4155e952062b2d", null ],
            [ "TestStatePSP", "group__IEC60335__CPUREG__TEST.html#ga550b68f1edb473b75a8dbdd29b317bf6", null ]
          ] ],
          [ "Functions", "group__IEC60335__CPUREG__TEST.html", [
            [ "ASMCPUregTestHIGH", "group__IEC60335__CPUREG__TEST.html#gaa77f3ba4734078b338344b1c4d0a8b8b", null ],
            [ "ASMCPUregTestLOW", "group__IEC60335__CPUREG__TEST.html#gabeeaf34b3496039af2adf64cf75316d3", null ],
            [ "ASMCPUregTestPOST", "group__IEC60335__CPUREG__TEST.html#gaa7e0652a6b389d2343302f795512f043", null ],
            [ "ASMCPUregTestSP", "group__IEC60335__CPUREG__TEST.html#ga73df5bcd9900185e5cc08f581b85cce9", null ],
            [ "ASMCPUregTestSPEC", "group__IEC60335__CPUREG__TEST.html#ga6c2c99bab9f8356e833c7f518807d901", null ],
            [ "IEC60335_ClassB_CPUregTest_BIST", "group__IEC60335__CPUREG__TEST.html#ga98db03d57411c0372e17918f799e3701", null ],
            [ "IEC60335_ClassB_CPUregTest_POST", "group__IEC60335__CPUREG__TEST.html#gadbf6446ebe90dd31e398901653caea54", null ]
          ] ],
          [ "Variables", "group__IEC60335__CPUREG__TEST.html", [
            [ "IEC60335_CPUregTestBIST", "group__IEC60335__CPUREG__TEST.html#gae525eb1df12667e879c41abd1f87bdcf", null ],
            [ "IEC60335_CPUregTestPOST", "group__IEC60335__CPUREG__TEST.html#gad0191b7ac9a7fbfb9e85a484f57fc16e", null ]
          ] ]
        ] ],
        [ "Critical Data", "group__IEC60335__CRITICAL__DATA.html", [
          [ "Defines", "group__IEC60335__CRITICAL__DATA.html", [
            [ "IEC60335_ClassB_CriticalDataInit", "group__IEC60335__CRITICAL__DATA.html#gadeeb3c40e1354c9d5020d8d0b67040e1", null ],
            [ "IEC60335_ClassB_CriticalDataPop", "group__IEC60335__CRITICAL__DATA.html#ga8cfcf08fcdfba6de45c6ed2fdf9c5f6f", null ],
            [ "IEC60335_ClassB_CriticalDataPush", "group__IEC60335__CRITICAL__DATA.html#ga39c7c9f75604bb5ae6be7c01506fac5c", null ],
            [ "IEC60335_ClassB_CriticalDataValidate", "group__IEC60335__CRITICAL__DATA.html#ga7ebc93c76b12fe40d22e0cb3d330dfd9", null ]
          ] ],
          [ "Typedefs", "group__IEC60335__CRITICAL__DATA.html", [
            [ "critical_double", "group__IEC60335__CRITICAL__DATA.html#ga42fff48df52b3f19231078f99d642e08", null ],
            [ "critical_float", "group__IEC60335__CRITICAL__DATA.html#ga7b13991e0032fae092b5f5cd68915914", null ],
            [ "critical_int16_t", "group__IEC60335__CRITICAL__DATA.html#gad34d6d6793167e2120cf7a89a9db77bd", null ],
            [ "critical_int32_t", "group__IEC60335__CRITICAL__DATA.html#ga9916cdb6de94edb1983133b6f4b9dbb8", null ],
            [ "critical_int64_t", "group__IEC60335__CRITICAL__DATA.html#ga32eab8f2d32c25dda30c58b768866e46", null ],
            [ "critical_int8_t", "group__IEC60335__CRITICAL__DATA.html#ga6cbe2086343b73fe2d1d02ce028732bc", null ],
            [ "critical_uint16_t", "group__IEC60335__CRITICAL__DATA.html#gada173409e923e49f3ae2d3740c3bb0af", null ],
            [ "critical_uint32_t", "group__IEC60335__CRITICAL__DATA.html#ga21f26529e7952e1b520c3a7432e6168f", null ],
            [ "critical_uint64_t", "group__IEC60335__CRITICAL__DATA.html#ga80df704a3138357e10f2060da2354d1d", null ],
            [ "critical_uint8_t", "group__IEC60335__CRITICAL__DATA.html#ga93faa86f2fa889779475598e525b2cba", null ]
          ] ],
          [ "Data Structures", "group__IEC60335__CRITICAL__DATA.html", [
            [ "critical_double_struct", "structcritical__double__struct.html", null ],
            [ "critical_float_struct", "structcritical__float__struct.html", null ],
            [ "critical_uint64_t_struct", "structcritical__uint64__t__struct.html", null ],
            [ "critical_int64_t_struct", "structcritical__int64__t__struct.html", null ],
            [ "critical_uint32_t_struct", "structcritical__uint32__t__struct.html", null ],
            [ "critical_int32_t_struct", "structcritical__int32__t__struct.html", null ],
            [ "critical_uint16_t_struct", "structcritical__uint16__t__struct.html", null ],
            [ "critical_int16_t_struct", "structcritical__int16__t__struct.html", null ],
            [ "critical_uint8_t_struct", "structcritical__uint8__t__struct.html", null ],
            [ "critical_int8_t_struct", "structcritical__int8__t__struct.html", null ]
          ] ]
        ] ],
        [ "FLASH Test", "group__IEC60335__FLASH__TEST.html", [
          [ "Library Configuration", "group__IEC60335__CONFIG.html", [
            [ "Defines", "group__IEC60335__CONFIG.html", [
              [ "CPU_CLK", "group__IEC60335__CONFIG.html#ga830fd4b906cd391487712d11740c065f", null ],
              [ "dynamic_CRC_table", "group__IEC60335__CONFIG.html#gab58427a8e90bbbaf099e8bb7d87df8f2", null ],
              [ "ENTRY_FLASH_CRC", "group__IEC60335__CONFIG.html#gade11389393902208065be40a987b10ae", null ],
              [ "FLASH_SIZE", "group__IEC60335__CONFIG.html#gae69620948dea1b76e0ab7843ab719db7", null ],
              [ "IEC60335_RAM_buffersize", "group__IEC60335__CONFIG.html#ga7f1d7aab80611ce8313e91ca460cd766", null ],
              [ "IEC60335_RAM_SIZE", "group__IEC60335__CONFIG.html#ga34411cfaa21c2925f1a8438a36ceb8dd", null ],
              [ "IEC60335_RAM_SP_Offset", "group__IEC60335__CONFIG.html#ga03d7fa3c23f25c2ba501b9f9d480d1d0", null ],
              [ "IEC60335_RAM_START", "group__IEC60335__CONFIG.html#gae351447525dbe263b116b55404c561cd", null ],
              [ "LoopForever", "group__IEC60335__CONFIG.html#ga485ab5cabcd5996eaa09da059f9bcad5", null ],
              [ "SRAM_SIZE", "group__IEC60335__CONFIG.html#ga10a9c742edabf5e945a1c509b7e1451e", null ],
              [ "TEST_POST_CPUREG", "group__IEC60335__CONFIG.html#ga13ac927ecfd69ddb0a035fdb89044b22", null ],
              [ "TEST_POST_FLASH", "group__IEC60335__CONFIG.html#gacddef49cea4e692fdd98aa0682354269", null ],
              [ "TEST_POST_PC", "group__IEC60335__CONFIG.html#ga34fef8f1d094e40323d222652a9d52d1", null ],
              [ "TEST_POST_RAM", "group__IEC60335__CONFIG.html#ga2683f341e13b31d576199485ca308acd", null ],
              [ "TEST_POST_WDOG", "group__IEC60335__CONFIG.html#gad5781c960f6790b65a86d6374601325e", null ],
              [ "USE_SYSTICK", "group__IEC60335__CONFIG.html#ga052dbd718131eb3c6e618d2050737aa6", null ],
              [ "USE_TIMER0", "group__IEC60335__CONFIG.html#ga287cfbaa0a33a26ea46fd4862e39cda4", null ],
              [ "USE_TIMER1", "group__IEC60335__CONFIG.html#gaca1816aef5c6846755ed9d741018bcd1", null ]
            ] ]
          ] ],
          [ "Defines", "group__IEC60335__FLASH__TEST.html", [
            [ "CRC_block_size", "group__IEC60335__FLASH__TEST.html#ga72f9f8de14aefe157465f367ef5289a3", null ],
            [ "DO1", "group__IEC60335__FLASH__TEST.html#ga305d9efdd351ef54839cb4cc60ff22a6", null ],
            [ "DO2", "group__IEC60335__FLASH__TEST.html#ga3886e6773c8b1dec67ea4da0d39ce313", null ],
            [ "DO4", "group__IEC60335__FLASH__TEST.html#ga5437542bdb231e622f42b908a5142f3f", null ],
            [ "DO8", "group__IEC60335__FLASH__TEST.html#gad725b56dfa1598dfdb18d83a77f13dd9", null ],
            [ "FLASH_CRC_Done", "group__IEC60335__FLASH__TEST.html#gadbcf472e04033b7250d7f461fc3bdbf1", null ],
            [ "FLASH_CRC_InProg", "group__IEC60335__FLASH__TEST.html#ga01fe32e0a4507d090da3e3f4a069d02f", null ],
            [ "FLASH_CRC_Missing", "group__IEC60335__FLASH__TEST.html#gae3ae9d94b4e890dd91e4ca8c00a9e3a7", null ],
            [ "FLASH_CRC_Restart", "group__IEC60335__FLASH__TEST.html#ga93059191fcab9979b3897695a1ecbd18", null ],
            [ "FLASH_CRC_Valid", "group__IEC60335__FLASH__TEST.html#gaf224711604916953db5115f056b35dac", null ],
            [ "FLASH_SIGN1", "group__IEC60335__FLASH__TEST.html#gae16d9703e0cd4da0008d4880fd904a7b", null ],
            [ "FLASH_SIGN2", "group__IEC60335__FLASH__TEST.html#ga5ba7d94e4bb38b17c087890ce1376245", null ],
            [ "FLASHSIZE", "group__IEC60335__FLASH__TEST.html#gad0f323414be00c7d1608a1bf9a620abf", null ],
            [ "SIZE128K", "group__IEC60335__FLASH__TEST.html#ga6c31ead245c9ef161c302941bd5b55a2", null ],
            [ "SIZE32K", "group__IEC60335__FLASH__TEST.html#ga4ba61604653c73564042bdad35e3d8fb", null ],
            [ "SIZE64K", "group__IEC60335__FLASH__TEST.html#ga9dc9587ddf46ce7adda4e798e85558d7", null ]
          ] ],
          [ "Functions", "group__IEC60335__FLASH__TEST.html", [
            [ "crc32", "group__IEC60335__FLASH__TEST.html#ga61ee7e3be8b3eb2a7cc3591ee31edfde", null ],
            [ "IEC60335_ClassB_FLASHtest_BIST", "group__IEC60335__FLASH__TEST.html#gad249e4d3652811c09a48dbac2ada7859", null ],
            [ "IEC60335_ClassB_FLASHtest_POST", "group__IEC60335__FLASH__TEST.html#ga068471cb4379f34d75889e074ab9da07", null ]
          ] ]
        ] ],
        [ "RAM Test", "group__IEC60335__RAM__TEST.html", [
          [ "Library Configuration", "group__IEC60335__CONFIG.html", [
            [ "Defines", "group__IEC60335__CONFIG.html", [
              [ "CPU_CLK", "group__IEC60335__CONFIG.html#ga830fd4b906cd391487712d11740c065f", null ],
              [ "dynamic_CRC_table", "group__IEC60335__CONFIG.html#gab58427a8e90bbbaf099e8bb7d87df8f2", null ],
              [ "ENTRY_FLASH_CRC", "group__IEC60335__CONFIG.html#gade11389393902208065be40a987b10ae", null ],
              [ "FLASH_SIZE", "group__IEC60335__CONFIG.html#gae69620948dea1b76e0ab7843ab719db7", null ],
              [ "IEC60335_RAM_buffersize", "group__IEC60335__CONFIG.html#ga7f1d7aab80611ce8313e91ca460cd766", null ],
              [ "IEC60335_RAM_SIZE", "group__IEC60335__CONFIG.html#ga34411cfaa21c2925f1a8438a36ceb8dd", null ],
              [ "IEC60335_RAM_SP_Offset", "group__IEC60335__CONFIG.html#ga03d7fa3c23f25c2ba501b9f9d480d1d0", null ],
              [ "IEC60335_RAM_START", "group__IEC60335__CONFIG.html#gae351447525dbe263b116b55404c561cd", null ],
              [ "LoopForever", "group__IEC60335__CONFIG.html#ga485ab5cabcd5996eaa09da059f9bcad5", null ],
              [ "SRAM_SIZE", "group__IEC60335__CONFIG.html#ga10a9c742edabf5e945a1c509b7e1451e", null ],
              [ "TEST_POST_CPUREG", "group__IEC60335__CONFIG.html#ga13ac927ecfd69ddb0a035fdb89044b22", null ],
              [ "TEST_POST_FLASH", "group__IEC60335__CONFIG.html#gacddef49cea4e692fdd98aa0682354269", null ],
              [ "TEST_POST_PC", "group__IEC60335__CONFIG.html#ga34fef8f1d094e40323d222652a9d52d1", null ],
              [ "TEST_POST_RAM", "group__IEC60335__CONFIG.html#ga2683f341e13b31d576199485ca308acd", null ],
              [ "TEST_POST_WDOG", "group__IEC60335__CONFIG.html#gad5781c960f6790b65a86d6374601325e", null ],
              [ "USE_SYSTICK", "group__IEC60335__CONFIG.html#ga052dbd718131eb3c6e618d2050737aa6", null ],
              [ "USE_TIMER0", "group__IEC60335__CONFIG.html#ga287cfbaa0a33a26ea46fd4862e39cda4", null ],
              [ "USE_TIMER1", "group__IEC60335__CONFIG.html#gaca1816aef5c6846755ed9d741018bcd1", null ]
            ] ]
          ] ],
          [ "Defines", "group__IEC60335__RAM__TEST.html", [
            [ "__st", "group__IEC60335__RAM__TEST.html#ga535ff9cdf7400bdb7fac9250ebc43f2a", null ],
            [ "BLOCK_SEL_CORE", "group__IEC60335__RAM__TEST.html#gaa3365b38c9dbd34ac287c49c3eaf95fc", null ],
            [ "BLOCK_SEL_PLINK", "group__IEC60335__RAM__TEST.html#ga1c94f7c9e70214dbf01535ddc6537e0d", null ],
            [ "CORE_RAM_BASE_ADDR", "group__IEC60335__RAM__TEST.html#ga299cfa6f13e3990e075cfac376fd47f9", null ],
            [ "CORE_RAM_BASE_PTR", "group__IEC60335__RAM__TEST.html#ga5b06ada54c25de9be0711a1e753a00d1", null ],
            [ "CORE_RAM_MAX_BC", "group__IEC60335__RAM__TEST.html#ga33a9d0ffd3e9a52bcd83f14cf47c3c08", null ],
            [ "CORE_RAM_R0_EXP", "group__IEC60335__RAM__TEST.html#gad19a4e33a8c15b719e6d1d1164865d8c", null ],
            [ "CORE_RAM_R1_EXP", "group__IEC60335__RAM__TEST.html#ga79fc43f3390981204c674daeff0456a3", null ],
            [ "get_initial_sp", "group__IEC60335__RAM__TEST.html#ga4c6507361ae0ef226daa22ceb57e8c7c", null ],
            [ "initial_sp", "group__IEC60335__RAM__TEST.html#gaad750ac50ad73f8ec851d16ad4c2dedf", null ],
            [ "MOP_DEL", "group__IEC60335__RAM__TEST.html#gafa8f8163ca9bfa8b5d0249914c2d5cca", null ],
            [ "MOP_R0", "group__IEC60335__RAM__TEST.html#ga315185aa5df0436ec4748aa1602e3aa0", null ],
            [ "MOP_R1", "group__IEC60335__RAM__TEST.html#gab1d8c895c174d74f0594e43d9440477a", null ],
            [ "MOP_W0", "group__IEC60335__RAM__TEST.html#gaa82d2f21c4d070eae2401400103b597e", null ],
            [ "MOP_W1", "group__IEC60335__RAM__TEST.html#gae6527d6b76739145f10445af1a1b3cfa", null ],
            [ "PLINK_RAM_BASE_ADDR", "group__IEC60335__RAM__TEST.html#gab0487655edd9ae4a18a5245838c262b0", null ],
            [ "PLINK_RAM_BASE_PTR", "group__IEC60335__RAM__TEST.html#ga22318842387993b6d1fd51d1883898cd", null ],
            [ "PLINK_RAM_MAX_BC", "group__IEC60335__RAM__TEST.html#gabb316cf4ddd2295c3fc5607ffdd86d42", null ],
            [ "PLINK_RAM_R0_EXP", "group__IEC60335__RAM__TEST.html#ga72bb6d08b9ff6dcc0047bfa8bfa9211b", null ],
            [ "PLINK_RAM_R1_EXP", "group__IEC60335__RAM__TEST.html#ga8865dce34e027722bf31265937d73b2b", null ],
            [ "TS_STA_RAM_BIST_OK", "group__IEC60335__RAM__TEST.html#gad00455f2408c2b6b68826ceb5e889192", null ],
            [ "TS_STA_RAM_BIST_R0_FAULT", "group__IEC60335__RAM__TEST.html#gae3862c5ee7e9f86fc3a6cdf53db832de", null ],
            [ "TS_STA_RAM_BIST_R1_FAULT", "group__IEC60335__RAM__TEST.html#gae64a8cbf12d9f6ef8433c126656ad470", null ],
            [ "WA", "group__IEC60335__RAM__TEST.html#ga59787c3bbd519290b22a9f9890aa5588", null ]
          ] ],
          [ "Functions", "group__IEC60335__RAM__TEST.html", [
            [ "IEC60335_ClassB_RAMtest", "group__IEC60335__RAM__TEST.html#ga1285ac1727a7d9e106ae18505747ea17", null ],
            [ "IEC60335_ClassB_RAMtest_BIST", "group__IEC60335__RAM__TEST.html#ga3dbc9e0983117252336f15471b3a6b8b", null ],
            [ "IEC60335_ClassB_RAMtest_POST", "group__IEC60335__RAM__TEST.html#ga44f47aafa113b3794be7154059695163", null ]
          ] ]
        ] ],
        [ "Interrupt Test", "group__IEC60335__IRQ__TEST.html", [
          [ "Defines", "group__IEC60335__IRQ__TEST.html", [
            [ "CallIRQHandler", "group__IEC60335__IRQ__TEST.html#gafe1716f6c926fec52812e7edafdc3b05", null ],
            [ "IgnoreIRQHandler", "group__IEC60335__IRQ__TEST.html#gad3005aad89eefc6c709a94396005c69f", null ]
          ] ],
          [ "Functions", "group__IEC60335__IRQ__TEST.html", [
            [ "IEC60335_ClassB_InitInterruptTest", "group__IEC60335__IRQ__TEST.html#ga8e6feb4af9a0c6e699fcbfb461c0504a", null ],
            [ "IEC60335_ClassB_InterruptCheck", "group__IEC60335__IRQ__TEST.html#ga131fe32b30db671333e46a2e26beda98", null ],
            [ "IEC60335_IRQReplacementHandler", "group__IEC60335__IRQ__TEST.html#gacc8a60dbec48647cd60f37db27490b97", null ]
          ] ]
        ] ],
        [ "Timer/RTC Test", "group__IEC60335__TIMER__RTC__TEST.html", [
          [ "Defines", "group__IEC60335__TIMER__RTC__TEST.html", [
            [ "GetIRQRTC", "group__IEC60335__TIMER__RTC__TEST.html#gab5d975d68e3a7e3372d605bb27dce028", null ],
            [ "SyncCMU", "group__IEC60335__TIMER__RTC__TEST.html#gab2d4d149219d3b6638867c6a2fd87b03", null ],
            [ "SyncRTC", "group__IEC60335__TIMER__RTC__TEST.html#gaeafd6361152cea21d82d41316b398971", null ]
          ] ],
          [ "Functions", "group__IEC60335__TIMER__RTC__TEST.html", [
            [ "IEC60335_ClassB_Clocktest_PollHandler", "group__IEC60335__TIMER__RTC__TEST.html#gad61f8dcb924682e0df72a85672d54f69", null ],
            [ "IEC60335_ClassB_Clocktest_RTCHandler", "group__IEC60335__TIMER__RTC__TEST.html#ga2844aaed5eabc5913ac918739876b4c3", null ],
            [ "IEC60335_ClassB_Clocktest_TimerHandler", "group__IEC60335__TIMER__RTC__TEST.html#gacd0268bc71620cd8646598c4c57734e7", null ],
            [ "IEC60335_ClassB_initClockTest", "group__IEC60335__TIMER__RTC__TEST.html#ga70e63dd615d367e66ec79e96cd9d698b", null ],
            [ "IEC60335_resetClockTest", "group__IEC60335__TIMER__RTC__TEST.html#ga400e1b9bba9a5d9a481b0924fb13e3e1", null ]
          ] ],
          [ "Variables", "group__IEC60335__TIMER__RTC__TEST.html", [
            [ "ClockTest", "group__IEC60335__TIMER__RTC__TEST.html#ga10db19a7f3f7c0f2eaa44f2b9613f461", null ],
            [ "ClockTest", "group__IEC60335__TIMER__RTC__TEST.html#ga10db19a7f3f7c0f2eaa44f2b9613f461", null ]
          ] ]
        ] ],
        [ "Watchdog Timer Test", "group__IEC60335__WDOG__TEST.html", [
          [ "Defines", "group__IEC60335__WDOG__TEST.html", [
            [ "SyncWDOGCMD", "group__IEC60335__WDOG__TEST.html#gac99d0674e63bdb26d27fdcc7edf1c4d0", null ],
            [ "SyncWDOGCTRL", "group__IEC60335__WDOG__TEST.html#gaaa2a15c4bf43e5b2d3ed1b7b2130a002", null ]
          ] ],
          [ "Functions", "group__IEC60335__WDOG__TEST.html", [
            [ "IEC60335_ClassB_Force_WDT_Reset", "group__IEC60335__WDOG__TEST.html#ga3a6ca5db46636c030dc108330f86a9a7", null ],
            [ "IEC60335_ClassB_initWDT", "group__IEC60335__WDOG__TEST.html#ga1aa6b7e573bfec1e5afbc809bc33ecd4", null ],
            [ "IEC60335_ClassB_Refresh_WDT", "group__IEC60335__WDOG__TEST.html#ga96a507d2f059c528f62eaed3dc077bf1", null ]
          ] ]
        ] ],
        [ "Tools to test the library", "group__IEC60335__TOOLS.html", [
          [ "Functions", "group__IEC60335__TOOLS.html", [
            [ "util_memcpy", "group__IEC60335__TOOLS.html#gaf5fe7b6806de40302e15102a9c89810c", null ]
          ] ]
        ] ]
      ] ]
    ] ],
    [ "Data Structures", "annotated.html", [
      [ "_Data", "struct__Data.html", null ],
      [ "ClkTest_struct", "structClkTest__struct.html", null ],
      [ "critical_double_struct", "structcritical__double__struct.html", null ],
      [ "critical_float_struct", "structcritical__float__struct.html", null ],
      [ "critical_int16_t_struct", "structcritical__int16__t__struct.html", null ],
      [ "critical_int32_t_struct", "structcritical__int32__t__struct.html", null ],
      [ "critical_int64_t_struct", "structcritical__int64__t__struct.html", null ],
      [ "critical_int8_t_struct", "structcritical__int8__t__struct.html", null ],
      [ "critical_uint16_t_struct", "structcritical__uint16__t__struct.html", null ],
      [ "critical_uint32_t_struct", "structcritical__uint32__t__struct.html", null ],
      [ "critical_uint64_t_struct", "structcritical__uint64__t__struct.html", null ],
      [ "critical_uint8_t_struct", "structcritical__uint8__t__struct.html", null ],
      [ "IEC60335_CPUreg_struct", "structIEC60335__CPUreg__struct.html", null ],
      [ "IEC60335_FlashSign", "structIEC60335__FlashSign.html", null ],
      [ "IEC60335_IRQ_Test_t", "structIEC60335__IRQ__Test__t.html", null ],
      [ "IRQTestData_t", "structIRQTestData__t.html", null ]
    ] ],
    [ "Data Structure Index", "classes.html", null ],
    [ "Data Fields", "functions.html", null ],
    [ "File List", "files.html", [
      [ "iec60335_class_b.h", "iec60335__class__b_8h.html", null ],
      [ "iec60335_class_b_cpureg_test.c", "iec60335__class__b__cpureg__test_8c.html", null ],
      [ "iec60335_class_b_cpureg_test.h", "iec60335__class__b__cpureg__test_8h.html", null ],
      [ "iec60335_class_b_cpureg_test_bist_arm.s", "iec60335__class__b__cpureg__test__bist__arm_8s.html", null ],
      [ "iec60335_class_b_cpureg_test_bist_gcc.asm", "iec60335__class__b__cpureg__test__bist__gcc_8asm.html", null ],
      [ "iec60335_class_b_cpureg_test_bist_iar.s", "iec60335__class__b__cpureg__test__bist__iar_8s.html", null ],
      [ "iec60335_class_b_cpureg_test_post_arm.s", "iec60335__class__b__cpureg__test__post__arm_8s.html", null ],
      [ "iec60335_class_b_cpureg_test_post_gcc.asm", "iec60335__class__b__cpureg__test__post__gcc_8asm.html", null ],
      [ "iec60335_class_b_cpureg_test_post_iar.s", "iec60335__class__b__cpureg__test__post__iar_8s.html", null ],
      [ "iec60335_class_b_critical_data.c", "iec60335__class__b__critical__data_8c.html", null ],
      [ "iec60335_class_b_critical_data.h", "iec60335__class__b__critical__data_8h.html", null ],
      [ "iec60335_class_b_def.h", "iec60335__class__b__def_8h.html", null ],
      [ "iec60335_class_b_flash_test.c", "iec60335__class__b__flash__test_8c.html", null ],
      [ "iec60335_class_b_flash_test.h", "iec60335__class__b__flash__test_8h.html", null ],
      [ "iec60335_class_b_interrupt_test.c", "iec60335__class__b__interrupt__test_8c.html", null ],
      [ "iec60335_class_b_interrupt_test.h", "iec60335__class__b__interrupt__test_8h.html", null ],
      [ "iec60335_class_b_post.c", "iec60335__class__b__post_8c.html", null ],
      [ "iec60335_class_b_post.h", "iec60335__class__b__post_8h.html", null ],
      [ "iec60335_class_b_programcounter_test.c", "iec60335__class__b__programcounter__test_8c.html", null ],
      [ "iec60335_class_b_programcounter_test.h", "iec60335__class__b__programcounter__test_8h.html", null ],
      [ "iec60335_class_b_ram_test.c", "iec60335__class__b__ram__test_8c.html", null ],
      [ "iec60335_class_b_ram_test.h", "iec60335__class__b__ram__test_8h.html", null ],
      [ "iec60335_class_b_tessy.h", "iec60335__class__b__tessy_8h.html", null ],
      [ "iec60335_class_b_timer_rtc_test.c", "iec60335__class__b__timer__rtc__test_8c.html", null ],
      [ "iec60335_class_b_timer_rtc_test.h", "iec60335__class__b__timer__rtc__test_8h.html", null ],
      [ "iec60335_class_b_typedef.h", "iec60335__class__b__typedef_8h.html", null ],
      [ "iec60335_class_b_wdt_test.c", "iec60335__class__b__wdt__test_8c.html", null ],
      [ "iec60335_class_b_wdt_test.h", "iec60335__class__b__wdt__test_8h.html", null ]
    ] ],
    [ "Directories", "dirs.html", [
      [ "iec60335_classb", "dir_fae7aade9cf33bbb54d5389645650dfa.html", [
        [ "inc", "dir_92ed64d87a2a2aa8c6e1b3d528d4be12.html", [
          [ "iec60335_class_b.h", "iec60335__class__b_8h.html", null ],
          [ "iec60335_class_b_cpureg_test.h", "iec60335__class__b__cpureg__test_8h.html", null ],
          [ "iec60335_class_b_critical_data.h", "iec60335__class__b__critical__data_8h.html", null ],
          [ "iec60335_class_b_def.h", "iec60335__class__b__def_8h.html", null ],
          [ "iec60335_class_b_flash_test.h", "iec60335__class__b__flash__test_8h.html", null ],
          [ "iec60335_class_b_interrupt_test.h", "iec60335__class__b__interrupt__test_8h.html", null ],
          [ "iec60335_class_b_post.h", "iec60335__class__b__post_8h.html", null ],
          [ "iec60335_class_b_programcounter_test.h", "iec60335__class__b__programcounter__test_8h.html", null ],
          [ "iec60335_class_b_ram_test.h", "iec60335__class__b__ram__test_8h.html", null ],
          [ "iec60335_class_b_tessy.h", "iec60335__class__b__tessy_8h.html", null ],
          [ "iec60335_class_b_timer_rtc_test.h", "iec60335__class__b__timer__rtc__test_8h.html", null ],
          [ "iec60335_class_b_typedef.h", "iec60335__class__b__typedef_8h.html", null ],
          [ "iec60335_class_b_wdt_test.h", "iec60335__class__b__wdt__test_8h.html", null ]
        ] ],
        [ "src", "dir_5cc9c4df666043008486419a05ae18d1.html", [
          [ "iec60335_class_b_cpureg_test.c", "iec60335__class__b__cpureg__test_8c.html", null ],
          [ "iec60335_class_b_cpureg_test_bist_arm.s", "iec60335__class__b__cpureg__test__bist__arm_8s.html", null ],
          [ "iec60335_class_b_cpureg_test_bist_gcc.asm", "iec60335__class__b__cpureg__test__bist__gcc_8asm.html", null ],
          [ "iec60335_class_b_cpureg_test_bist_iar.s", "iec60335__class__b__cpureg__test__bist__iar_8s.html", null ],
          [ "iec60335_class_b_cpureg_test_post_arm.s", "iec60335__class__b__cpureg__test__post__arm_8s.html", null ],
          [ "iec60335_class_b_cpureg_test_post_gcc.asm", "iec60335__class__b__cpureg__test__post__gcc_8asm.html", null ],
          [ "iec60335_class_b_cpureg_test_post_iar.s", "iec60335__class__b__cpureg__test__post__iar_8s.html", null ],
          [ "iec60335_class_b_critical_data.c", "iec60335__class__b__critical__data_8c.html", null ],
          [ "iec60335_class_b_flash_test.c", "iec60335__class__b__flash__test_8c.html", null ],
          [ "iec60335_class_b_interrupt_test.c", "iec60335__class__b__interrupt__test_8c.html", null ],
          [ "iec60335_class_b_post.c", "iec60335__class__b__post_8c.html", null ],
          [ "iec60335_class_b_programcounter_test.c", "iec60335__class__b__programcounter__test_8c.html", null ],
          [ "iec60335_class_b_ram_test.c", "iec60335__class__b__ram__test_8c.html", null ],
          [ "iec60335_class_b_timer_rtc_test.c", "iec60335__class__b__timer__rtc__test_8c.html", null ],
          [ "iec60335_class_b_wdt_test.c", "iec60335__class__b__wdt__test_8c.html", null ]
        ] ]
      ] ]
    ] ],
    [ "Globals", "globals.html", null ]
  ] ]
];

function createIndent(o,domNode,node,level)
{
  if (node.parentNode && node.parentNode.parentNode)
  {
    createIndent(o,domNode,node.parentNode,level+1);
  }
  var imgNode = document.createElement("img");
  if (level==0 && node.childrenData)
  {
    node.plus_img = imgNode;
    node.expandToggle = document.createElement("a");
    node.expandToggle.href = "javascript:void(0)";
    node.expandToggle.onclick = function() 
    {
      if (node.expanded) 
      {
        $(node.getChildrenUL()).slideUp("fast");
        if (node.isLast)
        {
          node.plus_img.src = node.relpath+"ftv2plastnode.png";
        }
        else
        {
          node.plus_img.src = node.relpath+"ftv2pnode.png";
        }
        node.expanded = false;
      } 
      else 
      {
        expandNode(o, node, false);
      }
    }
    node.expandToggle.appendChild(imgNode);
    domNode.appendChild(node.expandToggle);
  }
  else
  {
    domNode.appendChild(imgNode);
  }
  if (level==0)
  {
    if (node.isLast)
    {
      if (node.childrenData)
      {
        imgNode.src = node.relpath+"ftv2plastnode.png";
      }
      else
      {
        imgNode.src = node.relpath+"ftv2lastnode.png";
        domNode.appendChild(imgNode);
      }
    }
    else
    {
      if (node.childrenData)
      {
        imgNode.src = node.relpath+"ftv2pnode.png";
      }
      else
      {
        imgNode.src = node.relpath+"ftv2node.png";
        domNode.appendChild(imgNode);
      }
    }
  }
  else
  {
    if (node.isLast)
    {
      imgNode.src = node.relpath+"ftv2blank.png";
    }
    else
    {
      imgNode.src = node.relpath+"ftv2vertline.png";
    }
  }
  imgNode.border = "0";
}

function newNode(o, po, text, link, childrenData, lastNode)
{
  var node = new Object();
  node.children = Array();
  node.childrenData = childrenData;
  node.depth = po.depth + 1;
  node.relpath = po.relpath;
  node.isLast = lastNode;

  node.li = document.createElement("li");
  po.getChildrenUL().appendChild(node.li);
  node.parentNode = po;

  node.itemDiv = document.createElement("div");
  node.itemDiv.className = "item";

  node.labelSpan = document.createElement("span");
  node.labelSpan.className = "label";

  createIndent(o,node.itemDiv,node,0);
  node.itemDiv.appendChild(node.labelSpan);
  node.li.appendChild(node.itemDiv);

  var a = document.createElement("a");
  node.labelSpan.appendChild(a);
  node.label = document.createTextNode(text);
  a.appendChild(node.label);
  if (link) 
  {
    a.href = node.relpath+link;
  } 
  else 
  {
    if (childrenData != null) 
    {
      a.className = "nolink";
      a.href = "javascript:void(0)";
      a.onclick = node.expandToggle.onclick;
      node.expanded = false;
    }
  }

  node.childrenUL = null;
  node.getChildrenUL = function() 
  {
    if (!node.childrenUL) 
    {
      node.childrenUL = document.createElement("ul");
      node.childrenUL.className = "children_ul";
      node.childrenUL.style.display = "none";
      node.li.appendChild(node.childrenUL);
    }
    return node.childrenUL;
  };

  return node;
}

function showRoot()
{
  var headerHeight = $("#top").height();
  var footerHeight = $("#nav-path").height();
  var windowHeight = $(window).height() - headerHeight - footerHeight;
  navtree.scrollTo('#selected',0,{offset:-windowHeight/2});
}

function expandNode(o, node, imm)
{
  if (node.childrenData && !node.expanded) 
  {
    if (!node.childrenVisited) 
    {
      getNode(o, node);
    }
    if (imm)
    {
      $(node.getChildrenUL()).show();
    } 
    else 
    {
      $(node.getChildrenUL()).slideDown("fast",showRoot);
    }
    if (node.isLast)
    {
      node.plus_img.src = node.relpath+"ftv2mlastnode.png";
    }
    else
    {
      node.plus_img.src = node.relpath+"ftv2mnode.png";
    }
    node.expanded = true;
  }
}

function getNode(o, po)
{
  po.childrenVisited = true;
  var l = po.childrenData.length-1;
  for (var i in po.childrenData) 
  {
    var nodeData = po.childrenData[i];
    po.children[i] = newNode(o, po, nodeData[0], nodeData[1], nodeData[2],
        i==l);
  }
}

function findNavTreePage(url, data)
{
  var nodes = data;
  var result = null;
  for (var i in nodes) 
  {
    var d = nodes[i];
    if (d[1] == url) 
    {
      return new Array(i);
    }
    else if (d[2] != null) // array of children
    {
      result = findNavTreePage(url, d[2]);
      if (result != null) 
      {
        return (new Array(i).concat(result));
      }
    }
  }
  return null;
}

function initNavTree(toroot,relpath)
{
  var o = new Object();
  o.toroot = toroot;
  o.node = new Object();
  o.node.li = document.getElementById("nav-tree-contents");
  o.node.childrenData = NAVTREE;
  o.node.children = new Array();
  o.node.childrenUL = document.createElement("ul");
  o.node.getChildrenUL = function() { return o.node.childrenUL; };
  o.node.li.appendChild(o.node.childrenUL);
  o.node.depth = 0;
  o.node.relpath = relpath;

  getNode(o, o.node);

  o.breadcrumbs = findNavTreePage(toroot, NAVTREE);
  if (o.breadcrumbs == null)
  {
    o.breadcrumbs = findNavTreePage("index.html",NAVTREE);
  }
  if (o.breadcrumbs != null && o.breadcrumbs.length>0)
  {
    var p = o.node;
    for (var i in o.breadcrumbs) 
    {
      var j = o.breadcrumbs[i];
      p = p.children[j];
      expandNode(o,p,true);
    }
    p.itemDiv.className = p.itemDiv.className + " selected";
    p.itemDiv.id = "selected";
    $(window).load(showRoot);
  }
}

