#include "stdafx.h"
#include "PartList.h"

/////////////////////////////////////////////////////////////////////////////
// Constants
/////////////////////////////////////////////////////////////////////////////

const MCU_Device PartList[PARTLISTSIZE] = {
// F00x
MCU_Device("C8051F000", 0x07DFE, 0x07DFF),//32k
MCU_Device("C8051F001", 0x07DFE, 0x07DFF),
MCU_Device("C8051F002", 0x07DFE, 0x07DFF),
MCU_Device("C8051F005", 0x07DFE, 0x07DFF),
MCU_Device("C8051F006", 0x07DFE, 0x07DFF),
MCU_Device("C8051F007", 0x07DFE, 0x07DFF),
MCU_Device("C8051F010", 0x07DFE, 0x07DFF),
MCU_Device("C8051F011", 0x07DFE, 0x07DFF),
MCU_Device("C8051F012", 0x07DFE, 0x07DFF),
MCU_Device("C8051F015", 0x07DFE, 0x07DFF),
MCU_Device("C8051F016", 0x07DFE, 0x07DFF),
MCU_Device("C8051F017", 0x07DFE, 0x07DFF),

MCU_Device("C8051F018", 0x03DFE, 0x03DFF),//16k
MCU_Device("C8051F019", 0x03DFE, 0x03DFF),

// F02x
MCU_Device("C8051F020", 0x0FDFE, 0x0FDFF),//64k
MCU_Device("C8051F021", 0x0FDFE, 0x0FDFF),
MCU_Device("C8051F022", 0x0FDFE, 0x0FDFF),
MCU_Device("C8051F023", 0x0FDFE, 0x0FDFF),

// F04x
MCU_Device("C8051F040", 0x0FDFE, 0x0FDFF),//64k
MCU_Device("C8051F041", 0x0FDFE, 0x0FDFF),
MCU_Device("C8051F042", 0x0FDFE, 0x0FDFF),
MCU_Device("C8051F043", 0x0FDFE, 0x0FDFF),
MCU_Device("C8051F044", 0x0FDFE, 0x0FDFF),
MCU_Device("C8051F045", 0x0FDFE, 0x0FDFF),

MCU_Device("C8051F046", 0x07FFE, 0x07FFF),//32k
MCU_Device("C8051F047", 0x07FFE, 0x07FFF),

// F06x
MCU_Device("C8051F060", 0x0FBFE, 0x0FBFF),//64k
MCU_Device("C8051F061", 0x0FBFE, 0x0FBFF),
MCU_Device("C8051F062", 0x0FBFE, 0x0FBFF),
MCU_Device("C8051F063", 0x0FBFE, 0x0FBFF),
MCU_Device("C8051F064", 0x0FBFE, 0x0FBFF),
MCU_Device("C8051F065", 0x0FBFE, 0x0FBFF),

MCU_Device("C8051F066", 0x07FFE, 0x07FFF),//32k
MCU_Device("C8051F067", 0x07FFE, 0x07FFF),

// F12x/F13x
MCU_Device("C8051F120", 0x1FBFE, 0x1FBFF, 3),//128k
MCU_Device("C8051F121", 0x1FBFE, 0x1FBFF, 3),
MCU_Device("C8051F122", 0x1FBFE, 0x1FBFF, 3),
MCU_Device("C8051F123", 0x1FBFE, 0x1FBFF, 3),
MCU_Device("C8051F124", 0x1FBFE, 0x1FBFF, 3),
MCU_Device("C8051F125", 0x1FBFE, 0x1FBFF, 3),
MCU_Device("C8051F126", 0x1FBFE, 0x1FBFF, 3),
MCU_Device("C8051F127", 0x1FBFE, 0x1FBFF, 3),
MCU_Device("C8051F130", 0x1FBFE, 0x1FBFF, 3),
MCU_Device("C8051F131", 0x1FBFE, 0x1FBFF, 3),

MCU_Device("C8051F132", 0x0FFFE, 0x0FFFF, 3),//64k
MCU_Device("C8051F133", 0x0FFFE, 0x0FFFF, 3),

// F2xx
MCU_Device("C8051F206", 0x01DFE, 0x01DFF),//8k
MCU_Device("C8051F220", 0x01DFE, 0x01DFF),
MCU_Device("C8051F221", 0x01DFE, 0x01DFF),
MCU_Device("C8051F226", 0x01DFE, 0x01DFF),
MCU_Device("C8051F230", 0x01DFE, 0x01DFF),
MCU_Device("C8051F231", 0x01DFE, 0x01DFF),
MCU_Device("C8051F236", 0x01DFE, 0x01DFF),

// F25x
MCU_Device("C8051F250", 0x07DFF, 0x07DFF),// 32k
MCU_Device("C8051F251", 0x03FFF, 0x03FFF),// 16k
MCU_Device("C8051F252", 0x03FFF, 0x03FFF),

// F30x
MCU_Device("C8051F300", 0x01DFF, 0x01DFF),//8k
MCU_Device("C8051F301", 0x01DFF, 0x01DFF),
MCU_Device("C8051F302", 0x01DFF, 0x01DFF),
MCU_Device("C8051F303", 0x01DFF, 0x01DFF),

MCU_Device("C8051F304", 0x00FFF, 0x00FFF),//4k

MCU_Device("C8051F305", 0x007FF, 0x007FF),//2k

// F31x
MCU_Device("C8051F310", 0x03DFF, 0x03DFF),//16k
MCU_Device("C8051F311", 0x03DFF, 0x03DFF),

MCU_Device("C8051F312", 0x01FFF, 0x01FFF),//8k
MCU_Device("C8051F313", 0x01FFF, 0x01FFF),
MCU_Device("C8051F314", 0x01FFF, 0x01FFF),
MCU_Device("C8051F315", 0x01FFF, 0x01FFF),

MCU_Device("C8051F316", 0x03DFF, 0x03DFF),//16k
MCU_Device("C8051F317", 0x03DFF, 0x03DFF),

// F320-1
MCU_Device("C8051F320", 0x03DFF, 0x03DFF),//16k
MCU_Device("C8051F321", 0x03DFF, 0x03DFF),

// F326-7
MCU_Device("C8051F326", 0x03DFF, 0x03DFF),//16k
MCU_Device("C8051F327", 0x03DFF, 0x03DFF),

// F33x
MCU_Device("C8051F330", 0x01DFF, 0x01DFF),//8k
MCU_Device("C8051F331", 0x01DFF, 0x01DFF),

MCU_Device("C8051F332", 0x00FFF, 0x00FFF),//4k
MCU_Device("C8051F333", 0x00FFF, 0x00FFF),

MCU_Device("C8051F334", 0x007FF, 0x007FF),//2k
MCU_Device("C8051F335", 0x007FF, 0x007FF),

MCU_Device("C8051F336", 0x03DFF, 0x03DFF),//16k
MCU_Device("C8051F337", 0x03DFF, 0x03DFF),
MCU_Device("C8051F338", 0x03DFF, 0x03DFF),
MCU_Device("C8051F339", 0x03DFF, 0x03DFF),

// F34x
MCU_Device("C8051F340", 0x0FBFF, 0x0FBFF),//64k
MCU_Device("C8051F341", 0x07FFF, 0x07FFF),//32k
MCU_Device("C8051F342", 0x0FBFF, 0x0FBFF),//...
MCU_Device("C8051F343", 0x07FFF, 0x07FFF),
MCU_Device("C8051F344", 0x0FBFF, 0x0FBFF),
MCU_Device("C8051F345", 0x07FFF, 0x07FFF),
MCU_Device("C8051F346", 0x0FBFF, 0x0FBFF),
MCU_Device("C8051F347", 0x07FFF, 0x07FFF),
MCU_Device("C8051F348", 0x0FBFF, 0x0FBFF),
MCU_Device("C8051F349", 0x0FBFF, 0x0FBFF),
MCU_Device("C8051F34A", 0x0FBFF, 0x0FBFF),
MCU_Device("C8051F34B", 0x07FFF, 0x07FFF),
MCU_Device("C8051F34C", 0x0FBFF, 0x0FBFF),
MCU_Device("C8051F34D", 0x0FBFF, 0x0FBFF),

// F35x
MCU_Device("C8051F350", 0x01DFF, 0x01DFF),//8k
MCU_Device("C8051F351", 0x01DFF, 0x01DFF),
MCU_Device("C8051F352", 0x01DFF, 0x01DFF),
MCU_Device("C8051F353", 0x01DFF, 0x01DFF),

// F36x
MCU_Device("C8051F360", 0x07BFF, 0x07BFF),//32k
MCU_Device("C8051F361", 0x07BFF, 0x07BFF),
MCU_Device("C8051F362", 0x07BFF, 0x07BFF),
MCU_Device("C8051F363", 0x07BFF, 0x07BFF),
MCU_Device("C8051F364", 0x07BFF, 0x07BFF),
MCU_Device("C8051F365", 0x07BFF, 0x07BFF),
MCU_Device("C8051F366", 0x07BFF, 0x07BFF),
MCU_Device("C8051F367", 0x07BFF, 0x07BFF),
MCU_Device("C8051F368", 0x03FFF, 0x03FFF),//16k
MCU_Device("C8051F369", 0x03FFF, 0x03FFF),

// F37x
MCU_Device("C8051F370", 0x03FFF, 0x03FFF),
MCU_Device("C8051F371", 0x03FFF, 0x03FFF),
MCU_Device("C8051F374", 0x01FFF, 0x01FFF),
MCU_Device("C8051F375", 0x01FFF, 0x01FFF),

// F38x
MCU_Device("C8051F380", 0x0FBFF, 0x0FBFF),
MCU_Device("C8051F381", 0x0FBFF, 0x0FBFF),
MCU_Device("C8051F382", 0x07FFF, 0x07FFF),
MCU_Device("C8051F383", 0x07FFF, 0x07FFF),
MCU_Device("C8051F384", 0x0FBFF, 0x0FBFF),
MCU_Device("C8051F385", 0x0FBFF, 0x0FBFF),
MCU_Device("C8051F386", 0x07FFF, 0x07FFF),
MCU_Device("C8051F387", 0x07FFF, 0x07FFF),
MCU_Device("C8051F388", 0x0FBFF, 0x0FBFF),
MCU_Device("C8051F389", 0x0FBFF, 0x0FBFF),
MCU_Device("C8051F38A", 0x07FFF, 0x07FFF),
MCU_Device("C8051F38B", 0x07FFF, 0x07FFF),
MCU_Device("C8051F38C", 0x03FFF, 0x03FFF),

// 39x
MCU_Device("C8051F390", 0x03FFF, 0x03FFF),
MCU_Device("C8051F391", 0x03FFF, 0x03FFF),
MCU_Device("C8051F392", 0x03FFF, 0x03FFF),
MCU_Device("C8051F393", 0x03FFF, 0x03FFF),
MCU_Device("C8051F394", 0x01FFF, 0x01FFF),
MCU_Device("C8051F395", 0x01FFF, 0x01FFF),
MCU_Device("C8051F396", 0x01FFF, 0x01FFF),
MCU_Device("C8051F397", 0x01FFF, 0x01FFF),
MCU_Device("C8051F398", 0x0FFF, 0x0FFF),
MCU_Device("C8051F399", 0x0FFF, 0x0FFF),

// F41x
MCU_Device("C8051F410", 0x07DFF, 0x07DFF),//32k
MCU_Device("C8051F411", 0x07DFF, 0x07DFF),
MCU_Device("C8051F420", 0x07DFF, 0x07DFF),
MCU_Device("C8051F421", 0x07DFF, 0x07DFF),
MCU_Device("C8051F414", 0x07DFF, 0x07DFF),
MCU_Device("C8051F415", 0x07DFF, 0x07DFF),

MCU_Device("C8051F412", 0x03FFF, 0x03FFF),//16k
MCU_Device("C8051F413", 0x03FFF, 0x03FFF),
MCU_Device("C8051F422", 0x03FFF, 0x03FFF),
MCU_Device("C8051F423", 0x03FFF, 0x03FFF),
MCU_Device("C8051F416", 0x03FFF, 0x03FFF),
MCU_Device("C8051F417", 0x03FFF, 0x03FFF),

// F50x
MCU_Device("C8051F500", 0x0FBFF, 0x0FBFF),//64k
MCU_Device("C8051F501", 0x0FBFF, 0x0FBFF),
MCU_Device("C8051F502", 0x0FBFF, 0x0FBFF),
MCU_Device("C8051F503", 0x0FBFF, 0x0FBFF),
MCU_Device("C8051F504", 0x07FFF, 0x07FFF),//32k
MCU_Device("C8051F505", 0x07FFF, 0x07FFF),
MCU_Device("C8051F506", 0x07FFF, 0x07FFF),
MCU_Device("C8051F507", 0x07FFF, 0x07FFF),
MCU_Device("C8051F508", 0x0FBFF, 0x0FBFF),//64k
MCU_Device("C8051F509", 0x0FBFF, 0x0FBFF),
MCU_Device("C8051F510", 0x07FFF, 0x07FFF),//32k
MCU_Device("C8051F511", 0x07FFF, 0x07FFF),

// F53x/52x
// F53xA/52xA
MCU_Device("C8051F520", 0x01DFF, 0x01DFF),//8k
MCU_Device("C8051F520A", 0x01DFF, 0x01DFF),//8k

MCU_Device("C8051F521", 0x01DFF, 0x01DFF),
MCU_Device("C8051F521A", 0x01DFF, 0x01DFF),

MCU_Device("C8051F523", 0x00FFF, 0x00FFF),//4k
MCU_Device("C8051F523A", 0x00FFF, 0x00FFF),//4k

MCU_Device("C8051F524", 0x00FFF, 0x00FFF),
MCU_Device("C8051F524A", 0x00FFF, 0x00FFF),

MCU_Device("C8051F526", 0x007FF, 0x007FF),//2k
MCU_Device("C8051F526A", 0x007FF, 0x007FF),//2k

MCU_Device("C8051F527", 0x007FF, 0x007FF),
MCU_Device("C8051F527A", 0x007FF, 0x007FF),

MCU_Device("C8051F530", 0x01DFF, 0x01DFF),//8k
MCU_Device("C8051F530A", 0x01DFF, 0x01DFF),//8k

MCU_Device("C8051F531", 0x01DFF, 0x01DFF),
MCU_Device("C8051F531A", 0x01DFF, 0x01DFF),

MCU_Device("C8051F533", 0x00FFF, 0x00FFF),//4k
MCU_Device("C8051F533A", 0x00FFF, 0x00FFF),//4k

MCU_Device("C8051F534", 0x00FFF, 0x00FFF),
MCU_Device("C8051F534A", 0x00FFF, 0x00FFF),

MCU_Device("C8051F536", 0x007FF, 0x007FF),//2k
MCU_Device("C8051F536A", 0x007FF, 0x007FF),//2k

MCU_Device("C8051F537", 0x007FF, 0x007FF),
MCU_Device("C8051F537A", 0x007FF, 0x007FF),

//F54x
MCU_Device("C8051F540", 0x03BFF, 0x03BFF),
MCU_Device("C8051F541", 0x03BFF, 0x03BFF),
MCU_Device("C8051F542", 0x03BFF, 0x03BFF),
MCU_Device("C8051F543", 0x03BFF, 0x03BFF),
MCU_Device("C8051F544", 0x01FFF, 0x01FFF),
MCU_Device("C8051F545", 0x01FFF, 0x01FFF),
MCU_Device("C8051F546", 0x01FFF, 0x01FFF),
MCU_Device("C8051F547", 0x01FFF, 0x01FFF),

//F55x/56x/57x
MCU_Device("C8051F550", 0x07BFF, 0x07BFF),
MCU_Device("C8051F551", 0x07BFF, 0x07BFF),
MCU_Device("C8051F552", 0x07BFF, 0x07BFF),
MCU_Device("C8051F553", 0x07BFF, 0x07BFF),
MCU_Device("C8051F554", 0x03FFF, 0x03FFF),
MCU_Device("C8051F555", 0x03FFF, 0x03FFF),
MCU_Device("C8051F556", 0x03FFF, 0x03FFF),
MCU_Device("C8051F557", 0x03FFF, 0x03FFF),
MCU_Device("C8051F560", 0x07BFF, 0x07BFF),
MCU_Device("C8051F561", 0x07BFF, 0x07BFF),
MCU_Device("C8051F562", 0x07BFF, 0x07BFF),
MCU_Device("C8051F563", 0x07BFF, 0x07BFF),
MCU_Device("C8051F564", 0x03FFF, 0x03FFF),
MCU_Device("C8051F565", 0x03FFF, 0x03FFF),
MCU_Device("C8051F566", 0x03FFF, 0x03FFF),
MCU_Device("C8051F567", 0x03FFF, 0x03FFF),
MCU_Device("C8051F568", 0x07BFF, 0x07BFF),
MCU_Device("C8051F569", 0x07BFF, 0x07BFF),
MCU_Device("C8051F570", 0x07BFF, 0x07BFF),
MCU_Device("C8051F571", 0x07BFF, 0x07BFF),
MCU_Device("C8051F572", 0x03FFF, 0x03FFF),
MCU_Device("C8051F573", 0x03FFF, 0x03FFF),
MCU_Device("C8051F574", 0x03FFF, 0x03FFF),
MCU_Device("C8051F575", 0x03FFF, 0x03FFF),

// F58x/59x
MCU_Device("C8051F580", 0x1FBFF, 0x1FBFF, 3), //128k
MCU_Device("C8051F581", 0x1FBFF, 0x1FBFF, 3),
MCU_Device("C8051F582", 0x1FBFF, 0x1FBFF, 3),
MCU_Device("C8051F583", 0x1FBFF, 0x1FBFF, 3),

MCU_Device("C8051F584", 0x17FFF, 0x17FFF, 2),	//96K
MCU_Device("C8051F585", 0x17FFF, 0x17FFF, 2),
MCU_Device("C8051F586", 0x17FFF, 0x17FFF, 2),
MCU_Device("C8051F587", 0x17FFF, 0x17FFF, 2),

MCU_Device("C8051F588", 0x1FBFF, 0x1FBFF, 3),	//128k
MCU_Device("C8051F589", 0x1FBFF, 0x1FBFF, 3),

MCU_Device("C8051F590", 0x17FFF, 0x17FFF, 2),	//96k
MCU_Device("C8051F591", 0x17FFF, 0x17FFF, 2),

// F7xx
MCU_Device("C8051F700", 0x03BFF, 0x03BFF),
MCU_Device("C8051F701", 0x03BFF, 0x03BFF),
MCU_Device("C8051F702", 0x03FFF, 0x03FFF),
MCU_Device("C8051F703", 0x03FFF, 0x03FFF),
MCU_Device("C8051F704", 0x03BFF, 0x03BFF),
MCU_Device("C8051F705", 0x03BFF, 0x03BFF),
MCU_Device("C8051F706", 0x03FFF, 0x03FFF),
MCU_Device("C8051F707", 0x03FFF, 0x03FFF),
MCU_Device("C8051F708", 0x01FFF, 0x01FFF),
MCU_Device("C8051F709", 0x01FFF, 0x01FFF),
MCU_Device("C8051F710", 0x01FFF, 0x01FFF),
MCU_Device("C8051F711", 0x01FFF, 0x01FFF),
MCU_Device("C8051F712", 0x01FFF, 0x01FFF),
MCU_Device("C8051F713", 0x01FFF, 0x01FFF),
MCU_Device("C8051F714", 0x01FFF, 0x01FFF),
MCU_Device("C8051F715", 0x01FFF, 0x01FFF),
MCU_Device("C8051F716", 0x03BFF, 0x03BFF),
MCU_Device("C8051F717", 0x03BFF, 0x03BFF),

// F75x
MCU_Device("C8051F750", 0x03FFF, 0x03FFF),
MCU_Device("C8051F750B", 0x03FFF, 0x03FFF),

MCU_Device("C8051F751", 0x03FFF, 0x03FFF),
MCU_Device("C8051F751B", 0x03FFF, 0x03FFF),

MCU_Device("C8051F752", 0x03FFF, 0x03FFF),
MCU_Device("C8051F752B", 0x03FFF, 0x03FFF),

MCU_Device("C8051F755B", 0x03FFF, 0x03FFF),
MCU_Device("C8051F756B", 0x03FFF, 0x03FFF),
MCU_Device("C8051F757B", 0x03FFF, 0x03FFF),

// F76x
MCU_Device("C8051F760", 0x07FFF, 0x07FFF),
MCU_Device("C8051F761", 0x07FFF, 0x07FFF),
MCU_Device("C8051F762", 0x07FFF, 0x07FFF),
MCU_Device("C8051F765", 0x07FFF, 0x07FFF),
MCU_Device("C8051F766", 0x07FFF, 0x07FFF),
MCU_Device("C8051F767", 0x07FFF, 0x07FFF),

// F77x/F78x
MCU_Device("C8051F770", 0x07FFF, 0x07FFF),
MCU_Device("C8051F775", 0x07FFF, 0x07FFF),
MCU_Device("C8051F780", 0x09FFF, 0x09FFF),
MCU_Device("C8051F785", 0x09FFF, 0x09FFF),

// F80x/81x/82x/83x
MCU_Device("C8051F800", 0x03FFF, 0x03FFF),
MCU_Device("C8051F801", 0x03FFF, 0x03FFF),
MCU_Device("C8051F802", 0x03FFF, 0x03FFF),
MCU_Device("C8051F803", 0x03FFF, 0x03FFF),
MCU_Device("C8051F804", 0x03FFF, 0x03FFF),
MCU_Device("C8051F805", 0x03FFF, 0x03FFF),
MCU_Device("C8051F806", 0x03FFF, 0x03FFF),
MCU_Device("C8051F807", 0x03FFF, 0x03FFF),
MCU_Device("C8051F808", 0x03FFF, 0x03FFF),
MCU_Device("C8051F809", 0x03FFF, 0x03FFF),
MCU_Device("C8051F810", 0x03FFF, 0x03FFF),
MCU_Device("C8051F811", 0x03FFF, 0x03FFF),

MCU_Device("C8051F812", 0x01FFF, 0x01FFF),
MCU_Device("C8051F813", 0x01FFF, 0x01FFF),
MCU_Device("C8051F814", 0x01FFF, 0x01FFF),
MCU_Device("C8051F815", 0x01FFF, 0x01FFF),
MCU_Device("C8051F816", 0x01FFF, 0x01FFF),
MCU_Device("C8051F817", 0x01FFF, 0x01FFF),
MCU_Device("C8051F818", 0x01FFF, 0x01FFF),
MCU_Device("C8051F819", 0x01FFF, 0x01FFF),
MCU_Device("C8051F820", 0x01FFF, 0x01FFF),
MCU_Device("C8051F821", 0x01FFF, 0x01FFF),
MCU_Device("C8051F822", 0x01FFF, 0x01FFF),
MCU_Device("C8051F823", 0x01FFF, 0x01FFF),
MCU_Device("C8051F824", 0x01FFF, 0x01FFF),
MCU_Device("C8051F825", 0x01FFF, 0x01FFF),
MCU_Device("C8051F826", 0x01FFF, 0x01FFF),
MCU_Device("C8051F827", 0x01FFF, 0x01FFF),
MCU_Device("C8051F828", 0x01FFF, 0x01FFF),
MCU_Device("C8051F829", 0x01FFF, 0x01FFF),

MCU_Device("C8051F830", 0x00FFF, 0x00FFF),
MCU_Device("C8051F831", 0x00FFF, 0x00FFF),
MCU_Device("C8051F832", 0x00FFF, 0x00FFF),
MCU_Device("C8051F833", 0x00FFF, 0x00FFF),
MCU_Device("C8051F834", 0x00FFF, 0x00FFF),
MCU_Device("C8051F835", 0x00FFF, 0x00FFF),

// 85x/86x
MCU_Device("C8051F850-GU/IU", 0x01FFF, 0x01FFF),
MCU_Device("C8051F850-GM/IM", 0x01FFF, 0x01FFF),
MCU_Device("C8051F851-GU/IU", 0x00FFF, 0x00FFF),
MCU_Device("C8051F851-GM/IM", 0x00FFF, 0x00FFF),
MCU_Device("C8051F852-GU/IU", 0x007FF, 0x007FF),
MCU_Device("C8051F852-GM/IM", 0x007FF, 0x007FF),
MCU_Device("C8051F853-GU/IU", 0x01FFF, 0x01FFF),
MCU_Device("C8051F853-GM/IM", 0x01FFF, 0x01FFF),
MCU_Device("C8051F854-GU/IU", 0x00FFF, 0x00FFF),
MCU_Device("C8051F854-GM/IM", 0x00FFF, 0x00FFF),
MCU_Device("C8051F855-GU/IU", 0x007FF, 0x007FF),
MCU_Device("C8051F855-GM/IM", 0x007FF, 0x007FF),

MCU_Device("C8051F860-GS/IS", 0x01FFF, 0x01FFF),
MCU_Device("C8051F861-GS/IS", 0x00FFF, 0x00FFF),
MCU_Device("C8051F862-GS/IS", 0x007FF, 0x007FF),
MCU_Device("C8051F863-GS/IS", 0x01FFF, 0x01FFF),
MCU_Device("C8051F864-GS/IS", 0x00FFF, 0x00FFF),
MCU_Device("C8051F865-GS/IS", 0x007FF, 0x007FF),

// F90x/91x
MCU_Device("C8051F901", 0x01FFF, 0x01FFF),
MCU_Device("C8051F902", 0x01FFF, 0x01FFF),

MCU_Device("C8051F911", 0x03BFF, 0x03BFF),
MCU_Device("C8051F912", 0x03BFF, 0x03BFF),

// F93x/92x
MCU_Device("C8051F920", 0x07FFF, 0x07FFF),//32k
MCU_Device("C8051F921", 0x07FFF, 0x07FFF),

MCU_Device("C8051F930", 0x0FBFF, 0x0FBFF),//64k
MCU_Device("C8051F931", 0x0FBFF, 0x0FBFF),

// F96x -- Metron Devices including MCM's
MCU_Device("C8051F960", 0x01FFFF, 0x01FFFF, 3),
MCU_Device("C8051F961", 0x01FFFF, 0x01FFFF, 3),
MCU_Device("C8051F962", 0x01FFFF, 0x01FFFF, 3),
MCU_Device("C8051F963", 0x01FFFF, 0x01FFFF, 3),
MCU_Device("C8051F964", 0x0FFFF, 0x0FFFF, 3),
MCU_Device("C8051F965", 0x0FFFF, 0x0FFFF, 3),
MCU_Device("C8051F966", 0x07FFF, 0x07FFF, 3),
MCU_Device("C8051F967", 0x07FFF, 0x07FFF, 3),
MCU_Device("C8051F968", 0x03FFF, 0x03FFF, 3),
MCU_Device("C8051F969", 0x03FFF, 0x03FFF, 3),

// F97x
MCU_Device("C8051F970", 0x07FFF, 0x07FFF),
MCU_Device("C8051F971", 0x07FFF, 0x07FFF),
MCU_Device("C8051F972", 0x07FFF, 0x07FFF),
MCU_Device("C8051F973", 0x03FFF, 0x03FFF),
MCU_Device("C8051F974", 0x03FFF, 0x03FFF),
MCU_Device("C8051F975", 0x03FFF, 0x03FFF),

// F99x_98x
MCU_Device("C8051F980", 0x01FFF, 0x01FFF),
MCU_Device("C8051F981", 0x01FFF, 0x01FFF),
MCU_Device("C8051F982", 0x00FFF, 0x00FFF),
MCU_Device("C8051F983", 0x00FFF, 0x00FFF),
MCU_Device("C8051F985", 0x007FF, 0x007FF),
MCU_Device("C8051F986", 0x01FFF, 0x01FFF),
MCU_Device("C8051F987", 0x01FFF, 0x01FFF),
MCU_Device("C8051F988", 0x00FFF, 0x00FFF),
MCU_Device("C8051F989", 0x00FFF, 0x00FFF),
MCU_Device("C8051F990", 0x01FFF, 0x01FFF),
MCU_Device("C8051F991", 0x01FFF, 0x01FFF),
MCU_Device("C8051F996", 0x01FFF, 0x01FFF),
MCU_Device("C8051F997", 0x01FFF, 0x01FFF),

// T32x
MCU_Device("C8051T320", 0x03FF8, 0x03FF8),
MCU_Device("C8051T321", 0x03FF8, 0x03FF8),
MCU_Device("C8051T322", 0x03FF8, 0x03FF8),
MCU_Device("C8051T323", 0x03FF8, 0x03FF8),
MCU_Device("C8051T326", 0x03FF8, 0x03FF8),
MCU_Device("C8051T327", 0x03FF8, 0x03FF8),

// T60x
MCU_Device("C8051T600", 0x01FFF, 0x01FFF),//8k
MCU_Device("C8051T601", 0x01FFF, 0x01FFF),
MCU_Device("C8051T602", 0x01FFF, 0x01FFF),//4k
MCU_Device("C8051T603", 0x01FFF, 0x01FFF),
MCU_Device("C8051T604", 0x01FFF, 0x01FFF),//2k
MCU_Device("C8051T605", 0x01FFF, 0x01FFF),
MCU_Device("C8051T606", 0x007FF, 0x007FF),//2k

// T61x
MCU_Device("C8051T610", 0x03FFF, 0x03FFF),//16k
MCU_Device("C8051T611", 0x03FFF, 0x03FFF),
MCU_Device("C8051T612", 0x03FFF, 0x03FFF),
MCU_Device("C8051T613", 0x03FFF, 0x03FFF),//8k
MCU_Device("C8051T614", 0x03FFF, 0x03FFF),
MCU_Device("C8051T615", 0x03FFF, 0x03FFF),
MCU_Device("C8051T616", 0x03FFF, 0x03FFF),//16k
MCU_Device("C8051T617", 0x03FFF, 0x03FFF),

// T62x
MCU_Device("C8051T620", 0x03FF8, 0x03FF8),
MCU_Device("C8051T621", 0x03FF8, 0x03FF8),
MCU_Device("C8051T622", 0x03FF8, 0x03FF8),
MCU_Device("C8051T623", 0x03FF8, 0x03FF8),
MCU_Device("C8051T626", 0x0FFF8, 0x0FFF8),
MCU_Device("C8051T627", 0x0FFF8, 0x0FFF8),

// T63x
MCU_Device("C8051T630", 0x01FFF, 0x01FFF),//8k
MCU_Device("C8051T631", 0x01FFF, 0x01FFF),
MCU_Device("C8051T632", 0x01FFF, 0x01FFF),//4k
MCU_Device("C8051T633", 0x01FFF, 0x01FFF),
MCU_Device("C8051T634", 0x01FFF, 0x01FFF),//2k
MCU_Device("C8051T635", 0x01FFF, 0x01FFF),

// T67x
MCU_Device("C8051T670", 0x0FFF8, 0x0FFF8),
MCU_Device("C8051T671", 0x0FFF8, 0x0FFF8),

MCU_Device("Si1000", 0x0FBFF, 0x0FBFF),
MCU_Device("Si1001", 0x07FFF, 0x07FFF),
MCU_Device("Si1002", 0x0FBFF, 0x0FBFF),
MCU_Device("Si1003", 0x07FFF, 0x07FFF),
MCU_Device("Si1004", 0x0FBFF, 0x0FBFF),
MCU_Device("Si1005", 0x07FFF, 0x07FFF),

MCU_Device("Si1010", 0x03BFF, 0x03BFF),
MCU_Device("Si1011", 0x01FFF, 0x01FFF),
MCU_Device("Si1012", 0x03BFF, 0x03BFF),
MCU_Device("Si1013", 0x01FFF, 0x01FFF),
MCU_Device("Si1014", 0x03BFF, 0x03BFF),
MCU_Device("Si1015", 0x01FFF, 0x01FFF),

MCU_Device("Si1020", 0x01FFFF, 0x01FFFF, 3),
MCU_Device("Si1021", 0x0FFFF, 0x0FFFF, 3),
MCU_Device("Si1022", 0x07FFF, 0x07FFF, 3),
MCU_Device("Si1023", 0x03FFF, 0x03FFF, 3),
MCU_Device("Si1024", 0x01FFFF, 0x01FFFF, 3),
MCU_Device("Si1025", 0x0FFFF, 0x0FFFF, 3),
MCU_Device("Si1026", 0x07FFF, 0x07FFF, 3),
MCU_Device("Si1027", 0x03FFF, 0x03FFF, 3),

MCU_Device("Si1030", 0x01FFFF, 0x01FFFF, 3),
MCU_Device("Si1031", 0x0FFFF, 0x0FFFF, 3),
MCU_Device("Si1032", 0x07FFF, 0x07FFF, 3),
MCU_Device("Si1033", 0x03FFF, 0x03FFF, 3),
MCU_Device("Si1034", 0x01FFFF, 0x01FFFF, 3),
MCU_Device("Si1035", 0x0FFFF, 0x0FFFF, 3),
MCU_Device("Si1036", 0x07FFF, 0x07FFF, 3),
MCU_Device("Si1037", 0x03FFF, 0x03FFF, 3),

MCU_Device("Si1060", 0x0FBFF, 0x0FBFF),
MCU_Device("Si1061", 0x07FFF, 0x07FFF),
MCU_Device("Si1062", 0x0FBFF, 0x0FBFF),
MCU_Device("Si1063", 0x07FFF, 0x07FFF),
MCU_Device("Si1064", 0x0FBFF, 0x0FBFF),
MCU_Device("Si1065", 0x07FFF, 0x07FFF),

MCU_Device("Si1080", 0x03BFF, 0x03BFF),
MCU_Device("Si1081", 0x01FFF, 0x01FFF),
MCU_Device("Si1082", 0x03BFF, 0x03BFF),
MCU_Device("Si1083", 0x01FFF, 0x01FFF),
MCU_Device("Si1084", 0x03BFF, 0x03BFF),
MCU_Device("Si1085", 0x01FFF, 0x01FFF),

MCU_Device("Si2501", 0x0FBFF, 0x0FBFF),

// EFM8 Variants
// BB1
MCU_Device("EFM8BB10F8G-QSOP24", 0x01FFF, 0x01FFF), // F850
MCU_Device("EFM8BB10F8G-QFN20", 0x01FFF, 0x01FFF), 
MCU_Device("EFM8BB10F8G-SOIC16", 0x01FFF, 0x01FFF), 
MCU_Device("EFM8BB10F4G-QFN20", 0x00FFF, 0x00FFF), // F851
MCU_Device("EFM8BB10F2G-QFN20", 0x007FF, 0x007FF), // F852

MCU_Device("EFM8BB10F8I-QSOP24", 0x01FFF, 0x01FFF), // F850
MCU_Device("EFM8BB10F8I-QFN20", 0x01FFF, 0x01FFF), 
MCU_Device("EFM8BB10F8I-SOIC16", 0x01FFF, 0x01FFF), 
MCU_Device("EFM8BB10F4I-QFN20", 0x00FFF, 0x00FFF), // F851
MCU_Device("EFM8BB10F2I-QFN20", 0x007FF, 0x007FF), // F852

MCU_Device("EFM8BB10F8A-QSOP24", 0x01FFF, 0x01FFF),	// Automotive variants
MCU_Device("EFM8BB10F8A-QFN20", 0x01FFF, 0x01FFF),
MCU_Device("EFM8BB10F8A-SOIC16", 0x01FFF, 0x01FFF),
MCU_Device("EFM8BB10F4A-QSOP24", 0x00FFF, 0x00FFF),
MCU_Device("EFM8BB10F4A-QFN20", 0x00FFF, 0x00FFF),
MCU_Device("EFM8BB10F4A-SOIC16", 0x00FFF, 0x00FFF),
MCU_Device("EFM8BB10F2A-QSOP24", 0x007FF, 0x007FF),
MCU_Device("EFM8BB10F2A-QFN20", 0x007FF, 0x007FF),
MCU_Device("EFM8BB10F2A-SOIC16", 0x007FF, 0x007FF),

// Shanghai - Various flash sizes but all lock bytes at 64k location
MCU_Device("EFM8BB22F16G-QFN28", 0x0FBFF, 0x0FBBF), // User space lock,  Data Space Lock
MCU_Device("EFM8BB22F16I-QFN28", 0x0FBFF, 0x0FBBF),

MCU_Device("EFM8BB21F16G-QSOP24", 0x0FBFF, 0x0FBBF), 
MCU_Device("EFM8BB21F16I-QSOP24", 0x0FBFF, 0x0FBBF),

MCU_Device("EFM8BB21F16G-QFN20", 0x0FBFF, 0x0FBBF), 
MCU_Device("EFM8BB21F16I-QFN20", 0x0FBFF, 0x0FBBF),

MCU_Device("EFM8BB22F16A-QFN28", 0x0FBFF, 0x0FBBF),
MCU_Device("EFM8BB21F16A-QSOP24", 0x0FBFF, 0x0FBBF),
MCU_Device("EFM8BB21F16A-QFN20", 0x0FBFF, 0x0FBBF),

// BB3 - Note: Lock byte at same location for all devices
MCU_Device("EFM8BB31F64G-QFN32",  0x0FBFF, 0x0FBFF),
MCU_Device("EFM8BB31F64G-QFP32",  0x0FBFF, 0x0FBFF),
MCU_Device("EFM8BB31F64G-QSOP24", 0x0FBFF, 0x0FBFF),
MCU_Device("EFM8BB31F64G-QFN24",  0x0FBFF, 0x0FBFF),

MCU_Device("EFM8BB31F32G-QFN32",  0x0FBFF, 0x0FBFF),
MCU_Device("EFM8BB31F32G-QFP32",  0x0FBFF, 0x0FBFF),
MCU_Device("EFM8BB31F32G-QSOP24", 0x0FBFF, 0x0FBFF),
MCU_Device("EFM8BB31F32G-QFN24",  0x0FBFF, 0x0FBFF),

MCU_Device("EFM8BB31F16G-QFN32",  0x0FBFF, 0x0FBFF),
MCU_Device("EFM8BB31F16G-QFP32",  0x0FBFF, 0x0FBFF),
MCU_Device("EFM8BB31F16G-QSOP24", 0x0FBFF, 0x0FBFF),
MCU_Device("EFM8BB31F16G-QFN24",  0x0FBFF, 0x0FBFF),

MCU_Device("EFM8BB31F64I-QFN32",  0x0FBFF, 0x0FBFF),
MCU_Device("EFM8BB31F64I-QFP32",  0x0FBFF, 0x0FBFF),
MCU_Device("EFM8BB31F64I-QSOP24", 0x0FBFF, 0x0FBFF),
MCU_Device("EFM8BB31F64I-QFN24",  0x0FBFF, 0x0FBFF),

MCU_Device("EFM8BB31F32I-QFN32",  0x0FBFF, 0x0FBFF),
MCU_Device("EFM8BB31F32I-QFP32",  0x0FBFF, 0x0FBFF),
MCU_Device("EFM8BB31F32I-QSOP24", 0x0FBFF, 0x0FBFF),
MCU_Device("EFM8BB31F32I-QFN24",  0x0FBFF, 0x0FBFF),

MCU_Device("EFM8BB31F16I-QFN32",  0x0FBFF, 0x0FBFF),
MCU_Device("EFM8BB31F16I-QFP32",  0x0FBFF, 0x0FBFF),
MCU_Device("EFM8BB31F16I-QSOP24", 0x0FBFF, 0x0FBFF),
MCU_Device("EFM8BB31F16I-QFN24",  0x0FBFF, 0x0FBFF),

MCU_Device("EFM8BB31F64A-5QFN32",  0x0FBFF, 0x0FBFF),
MCU_Device("EFM8BB31F64A-4QFN24",  0x0FBFF, 0x0FBFF),

MCU_Device("EFM8BB31F32A-5QFN32",  0x0FBFF, 0x0FBFF),
MCU_Device("EFM8BB31F32A-4QFN24",  0x0FBFF, 0x0FBFF),

MCU_Device("EFM8BB31F16A-5QFN32",  0x0FBFF, 0x0FBFF),
MCU_Device("EFM8BB31F16A-4QFN24",  0x0FBFF, 0x0FBFF),

MCU_Device("EFM8BB31F64I-5QFN32",  0x0FBFF, 0x0FBFF),
MCU_Device("EFM8BB31F64I-4QFN24",  0x0FBFF, 0x0FBFF),

MCU_Device("EFM8BB31F32I-5QFN32",  0x0FBFF, 0x0FBFF),
MCU_Device("EFM8BB31F32I-4QFN24",  0x0FBFF, 0x0FBFF),

MCU_Device("EFM8BB31F16I-5QFN32",  0x0FBFF, 0x0FBFF),
MCU_Device("EFM8BB31F16I-4QFN24",  0x0FBFF, 0x0FBFF),

// EFM8BB50/1/2
MCU_Device("EFM8BB50F4G-QFN12",  0x0F7FF, 0x0F7FF),
MCU_Device("EFM8BB50F4G-QFN16",  0x0F7FF, 0x0F7FF),
MCU_Device("EFM8BB50F4G-SOIC16",  0x0F7FF, 0x0F7FF),
MCU_Device("EFM8BB50F8G-QFN12",  0x0F7FF, 0x0F7FF),
MCU_Device("EFM8BB50F8G-QFN16",  0x0F7FF, 0x0F7FF),
MCU_Device("EFM8BB50F8G-SOIC16",  0x0F7FF, 0x0F7FF),
MCU_Device("EFM8BB50F16G-QFN12",  0x0F7FF, 0x0F7FF),
MCU_Device("EFM8BB50F16G-QFN16",  0x0F7FF, 0x0F7FF),
MCU_Device("EFM8BB50F16G-SOIC16",  0x0F7FF, 0x0F7FF),

MCU_Device("EFM8BB50F4I-QFN12",  0x0F7FF, 0x0F7FF),
MCU_Device("EFM8BB50F4I-QFN16",  0x0F7FF, 0x0F7FF),
MCU_Device("EFM8BB50F4I-SOIC16",  0x0F7FF, 0x0F7FF),
MCU_Device("EFM8BB50F8I-QFN12",  0x0F7FF, 0x0F7FF),
MCU_Device("EFM8BB50F8I-QFN16",  0x0F7FF, 0x0F7FF),
MCU_Device("EFM8BB50F8I-SOIC16",  0x0F7FF, 0x0F7FF),
MCU_Device("EFM8BB50F16I-QFN12",  0x0F7FF, 0x0F7FF),
MCU_Device("EFM8BB50F16I-QFN16",  0x0F7FF, 0x0F7FF),
MCU_Device("EFM8BB50F16I-SOIC16",  0x0F7FF, 0x0F7FF),

MCU_Device("EFM8BB51F8G-TSSOP20",  0x0F7FF, 0x0F7FF),
MCU_Device("EFM8BB51F8G-QFN20",  0x0F7FF, 0x0F7FF),
MCU_Device("EFM8BB51F16G-QFN20",  0x0F7FF, 0x0F7FF),
MCU_Device("EFM8BB51F16G-TSSOP20",  0x0F7FF, 0x0F7FF),
MCU_Device("EFM8BB51F8I-TSSOP20",  0x0F7FF, 0x0F7FF),
MCU_Device("EFM8BB51F8I-QFN20",  0x0F7FF, 0x0F7FF),
MCU_Device("EFM8BB51F16I-QFN20",  0x0F7FF, 0x0F7FF),
MCU_Device("EFM8BB51F16I-TSSOP20",  0x0F7FF, 0x0F7FF),

MCU_Device("EFM8BB52F16G-TSSOP20",  0x0F7FF, 0x0F7FF),
MCU_Device("EFM8BB52F16G-QFN20",  0x0F7FF, 0x0F7FF),
MCU_Device("EFM8BB52F16G-TSSOP28",  0x0F7FF, 0x0F7FF),
MCU_Device("EFM8BB52F16G-QFN32",  0x0F7FF, 0x0F7FF),
MCU_Device("EFM8BB52F32G-TSSOP20",  0x0F7FF, 0x0F7FF),
MCU_Device("EFM8BB52F32G-QFN20",  0x0F7FF, 0x0F7FF),
MCU_Device("EFM8BB52F32G-TSSOP28",  0x0F7FF, 0x0F7FF),
MCU_Device("EFM8BB52F32G-QFN32",  0x0F7FF, 0x0F7FF),

MCU_Device("EFM8BB52F16I-TSSOP20",  0x0F7FF, 0x0F7FF),
MCU_Device("EFM8BB52F16I-QFN20",  0x0F7FF, 0x0F7FF),
MCU_Device("EFM8BB52F16I-TSSOP28",  0x0F7FF, 0x0F7FF),
MCU_Device("EFM8BB52F16I-QFN32",  0x0F7FF, 0x0F7FF),
MCU_Device("EFM8BB52F32I-TSSOP20",  0x0F7FF, 0x0F7FF),
MCU_Device("EFM8BB52F32I-QFN20",  0x0F7FF, 0x0F7FF),
MCU_Device("EFM8BB52F32I-TSSOP28",  0x0F7FF, 0x0F7FF),
MCU_Device("EFM8BB52F32I-QFN32",  0x0F7FF, 0x0F7FF),

// All LB1 are 64k but need all listed
MCU_Device("EFM8LB12F64E-QFN32",  0x0FBFF, 0x0FBFF),
MCU_Device("EFM8LB12F64ES0-QFN32",  0x0FBFF, 0x0FBFF),
MCU_Device("EFM8LB12F64ES1-QFN32",  0x0FBFF, 0x0FBFF),
MCU_Device("EFM8LB12F64E-QFP32",  0x0FBFF, 0x0FBFF),
MCU_Device("EFM8LB12F64E-QSOP24", 0x0FBFF, 0x0FBFF),
MCU_Device("EFM8LB12F64E-QFN24",  0x0FBFF, 0x0FBFF),
MCU_Device("EFM8LB12F64ES0-QFN24",  0x0FBFF, 0x0FBFF),
MCU_Device("EFM8LB12F64ES1-QFN24",  0x0FBFF, 0x0FBFF),

MCU_Device("EFM8LB12F32E-QFN32",  0x0FBFF, 0x0FBFF),
MCU_Device("EFM8LB12F32ES0-QFN32",  0x0FBFF, 0x0FBFF),
MCU_Device("EFM8LB12F32ES1-QFN32",  0x0FBFF, 0x0FBFF),
MCU_Device("EFM8LB12F32E-QFP32",  0x0FBFF, 0x0FBFF),
MCU_Device("EFM8LB12F32E-QSOP24", 0x0FBFF, 0x0FBFF),
MCU_Device("EFM8LB12F32E-QFN24",  0x0FBFF, 0x0FBFF),
MCU_Device("EFM8LB12F32ES0-QFN24",  0x0FBFF, 0x0FBFF),
MCU_Device("EFM8LB12F32ES1-QFN32",  0x0FBFF, 0x0FBFF),

MCU_Device("EFM8LB11F32E-QFN32",  0x0FBFF, 0x0FBFF),
MCU_Device("EFM8LB11F32ES0-QFN32",  0x0FBFF, 0x0FBFF),
MCU_Device("EFM8LB11F32ES1-QFN32",  0x0FBFF, 0x0FBFF),
MCU_Device("EFM8LB11F32E-QFP32",  0x0FBFF, 0x0FBFF),
MCU_Device("EFM8LB11F32E-QSOP24", 0x0FBFF, 0x0FBFF),
MCU_Device("EFM8LB11F32E-QFN24",  0x0FBFF, 0x0FBFF),
MCU_Device("EFM8LB11F32ES0-QFN24",  0x0FBFF, 0x0FBFF),
MCU_Device("EFM8LB11F32ES1-QFN24",  0x0FBFF, 0x0FBFF),

MCU_Device("EFM8LB11F16E-QFN32",  0x0FBFF, 0x0FBFF),
MCU_Device("EFM8LB11F16ES0-QFN32",  0x0FBFF, 0x0FBFF),
MCU_Device("EFM8LB11F16ES1-QFN32",  0x0FBFF, 0x0FBFF),
MCU_Device("EFM8LB11F16E-QFP32",  0x0FBFF, 0x0FBFF),
MCU_Device("EFM8LB11F16E-QSOP24", 0x0FBFF, 0x0FBFF),
MCU_Device("EFM8LB11F16E-QFN24",  0x0FBFF, 0x0FBFF),
MCU_Device("EFM8LB11F16ES0-QFN24",  0x0FBFF, 0x0FBFF),
MCU_Device("EFM8LB11F16ES1-QFN24",  0x0FBFF, 0x0FBFF),

MCU_Device("EFM8LB10F16E-QFN32",  0x0FBFF, 0x0FBFF),
MCU_Device("EFM8LB10F16ES0-QFN32",  0x0FBFF, 0x0FBFF),
MCU_Device("EFM8LB10F16ES1-QFN32",  0x0FBFF, 0x0FBFF),
MCU_Device("EFM8LB10F16E-QFP32",  0x0FBFF, 0x0FBFF),
MCU_Device("EFM8LB10F16E-QSOP24", 0x0FBFF, 0x0FBFF),
MCU_Device("EFM8LB10F16E-QFN24",  0x0FBFF, 0x0FBFF),
MCU_Device("EFM8LB10F16ES0-QFN24",  0x0FBFF, 0x0FBFF),
MCU_Device("EFM8LB10F16ES1-QFN24",  0x0FBFF, 0x0FBFF),

// SB1
MCU_Device("EFM8SB10F2G-QFN20", 0x007FF, 0x007FF), // F990
MCU_Device("EFM8SB10F4G-QFN20", 0x00FFF, 0x00FFF), // F986
MCU_Device("EFM8SB10F8A-QFN20", 0x01FFF, 0x01FFF), 
MCU_Device("EFM8SB10F8A-QFN24", 0x01FFF, 0x01FFF), 
MCU_Device("EFM8SB10F8G-CSP16", 0x01FFF, 0x01FFF), 
MCU_Device("EFM8SB10F8G-QFN20", 0x01FFF, 0x01FFF), 
MCU_Device("EFM8SB10F8G-QFN24", 0x01FFF, 0x01FFF), // F996
MCU_Device("EFM8SB10F8G-QSOP24", 0x01FFF, 0x01FFF), 

// SB2
MCU_Device("EFM8SB20F16G-QFN24", 0x03FFF, 0x03FFF), //16k F930

MCU_Device("EFM8SB20F32G-QFN24", 0x07FFF, 0x07FFF), 
MCU_Device("EFM8SB20F32G-QFN32", 0x07FFF, 0x07FFF), // F920
MCU_Device("EFM8SB20F32G-LQFP32", 0x07FFF, 0x07FFF), 

MCU_Device("EFM8SB20F64G-QFN24", 0x0FBFF, 0x0FBFF), 
MCU_Device("EFM8SB20F64G-QFN32", 0x0FBFF, 0x0FBFF), // F930
MCU_Device("EFM8SB20F64G-LQFP32", 0x0FBFF, 0x0FBFF), 

// UB1
MCU_Device("EFM8UB10F16G-QFN28", 0x0FBFF, 0x0FBBF),
MCU_Device("EFM8UB10F16G-QFN20", 0x0FBFF, 0x0FBBF),
MCU_Device("EFM8UB11F16G-QSOP24", 0x0FBFF, 0x0FBBF),
MCU_Device("EFM8UB10F8G-QFN20", 0x0FBFF, 0x0FBBF),
MCU_Device("EFM8UB11F16G-QFN24", 0x0FBFF, 0x0FBBF),
// UB2
MCU_Device("EFM8UB20F64G-QFP48", 0x0FBFF, 0x0FBFF),  // F380
MCU_Device("EFM8UB20F64G-QFP32", 0x0FBFF, 0x0FBFF),  
MCU_Device("EFM8UB20F64G-QFN32", 0x0FBFF, 0x0FBFF),  
MCU_Device("EFM8UB20F32G-QFP48", 0x07FFF, 0x07FFF),  // F382
MCU_Device("EFM8UB20F32G-QFP32", 0x07FFF, 0x07FFF), 
MCU_Device("EFM8UB20F32G-QFN32", 0x07FFF, 0x07FFF),
// UB3
MCU_Device("EFM8UB30F40G-QFN20", 0x0FBFF, 0x0FBFF),  
MCU_Device("EFM8UB31F40G-QFN24", 0x0FBFF, 0x0FBFF),  
MCU_Device("EFM8UB31F40G-QSOP24", 0x0FBFF, 0x0FBFF),  
// UB4
MCU_Device("EFM8UB40F40G-QFN20", 0x0FBFF, 0x0FBFF),  
MCU_Device("EFM8UB41F40G-QFN20", 0x0FBFF, 0x0FBFF),  
MCU_Device("EFM8UB42F40G-QFN24", 0x0FBFF, 0x0FBFF),  
MCU_Device("EFM8UB42F40G-QSOP24", 0x0FBFF, 0x0FBFF),  
MCU_Device("EFM8UB42F40G-QFN32", 0x0FBFF, 0x0FBFF),  

};