//-----------------------------------------------------------------------------
// SPI_MODE0.c
//-----------------------------------------------------------------------------
// Copyright 2001 Cygnal Integrated Products, Inc.
//
// AUTH: BD
// DATE: 14 DEC 01
//
// This file contains a 'C' Implementation of a Mode 0 Master SPI device.
// 
// Target: C8051F30x
// Tool chain: KEIL C51 6.03 / KEIL EVAL C51
//
//

#include <c8051f300.h>                 // SFR declarations
#include "SPI_defs.h"                  // SPI port definitions

//-----------------------------------------------------------------------------
// SPI_Transfer
//-----------------------------------------------------------------------------
//
// Simultaneously transmits and receives one byte <SPI_byte> using
// the SPI protocol.  SCK is idle-low, and bits are latched on SCK rising.
//
// Timing for this routine is as follows:
//
// Parameter                           Clock Cycles
// MOSI valid to SCK rising edge       6
// SCK rising to MISO latched          2
// SCK falling to MOSI valid           7
// SCK high time                       8
// SCK low time                        13

char SPI_Transfer (char SPI_byte)
{
   unsigned char SPI_count;            // counter for SPI transaction

   for (SPI_count = 8; SPI_count > 0; SPI_count--) // single byte SPI loop
   {
      MOSI = SPI_byte & 0x80;          // put current outgoing bit on MOSI
      SPI_byte = SPI_byte << 1;        // shift next bit into MSB
      
      SCK = 0x01;                      // set SCK high

      SPI_byte |= MISO;                // capture current bit on MISO

      SCK = 0x00;                      // set SCK low
   }

   return (SPI_byte);

} // END SPI_Transfer