//-----------------------------------------------------------------------------
// SPI_MODE2.c
//-----------------------------------------------------------------------------
// Copyright 2001 Cygnal Integrated Products, Inc.
//
// AUTH: BD
// DATE: 14 DEC 01
//
// This file contains a 'C' Implementation of a Mode 2 Master SPI device.
// 
// Target: C8051F30x
// Tool chain: KEIL C51 6.03 / KEIL EVAL C51
//
//

#include <c8051f300.h>                 // SFR declarations
#include "SPI_defs.h"                  // SPI port definitions

//-----------------------------------------------------------------------------
// SPI_Transfer
//-----------------------------------------------------------------------------
//
// Simultaneously transmits and receives one byte <SPI_byte> using
// the SPI protocol.  SCK is idle-high, and bits are latched on SCK falling.
//
// Timing for this routine is as follows:
//
// Parameter                           Clock Cycles
// MOSI valid to SCK falling edge      6
// SCK falling to MISO latched         2
// SCK rising to MOSI valid            7
// SCK low time                        8
// SCK high time                       13

char SPI_Transfer (char SPI_byte)
{
   unsigned char SPI_count;            // counter for SPI transaction

   for (SPI_count = 8; SPI_count > 0; SPI_count--) // single byte SPI loop
   {
      MOSI = SPI_byte & 0x80;          // put current outgoing bit on MOSI
      SPI_byte = SPI_byte << 1;        // shift next bit into MSB

      SCK = 0x00;                      // set SCK low
      
      SPI_byte |= MISO;                // capture current bit on MISO

      SCK = 0x01;                      // set SCK high

   }

   return (SPI_byte);

} // END SPI_Transfer