;-----------------------------------------------------------------------------
;  Copyright (C) 2001 CYGNAL INTEGRATED PRODUCTS, INC.
;  All rights reserved.
;
;  FILE NAME   :  SPI_MODE3.ASM 
;  DATE        :  14 DEC 01
;  TARGET MCU  :  C8051F30x 
;  DESCRIPTION :  This is a function which implements a master SPI device on
;                 the C8051F30x series of devices.  The function can
;                 be called from a C program with the following function
;                 prototype:
;
;                 extern char SPI_Transfer (char);
;
;  NOTES :  Timing is as follows (Mode 3 SPI):
;           Parameter                     SYSCLKs
;           SCK falling to MOSI valid     2
;           MOSI valid to SCK rising      2
;           SCK rising to MISO Latch      3
;           SCK low time                  5
;           SCK high time                 7
;
;-----------------------------------------------------------------------------

NAME  SPI_MODE3

?PR?_SPI_Transfer?SPI_MODE3   SEGMENT CODE 
   PUBLIC   _SPI_Transfer

$include (c8051f300.inc)            ; Include regsiter definition file.
$include (SPI_defs.h)               ; Include sbit definitions for SPI

   RSEG  ?PR?_SPI_Transfer?SPI_MODE3
_SPI_Transfer:
   USING 0

            MOV   A, R7             ; Store passed variable in A

            MOV   R7, #08H          ; Load R7 to count bits
SPI_Loop:   CLR   SCK               ; Clock Low
            RLC   A                 ; Rotate MSB into Carry Bit
            MOV   MOSI, C           ; Move bit out to MOSI
            SETB  SCK               ; Clock High
            MOV   C, MISO           ; Move MISO into Carry Bit
            DJNZ  R7, SPI_Loop      ; Loop for another bit until finished

            RLC   A                 ; Rotate Carry Bit into A
            MOV   R7, A             ; Store return value in R7

?C0001:
            RET                     ; Return from routine


END                                 ; END OF FILE
