// CP210xPortReadWriteDlg.cpp : implementation file
//

#include "stdafx.h"
#include "CP210xPortReadWrite.h"
#include "CP210xPortReadWriteDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCP210xPortReadWriteDlg dialog

CCP210xPortReadWriteDlg::CCP210xPortReadWriteDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CCP210xPortReadWriteDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CCP210xPortReadWriteDlg)
	m_Mask0 = FALSE;
	m_Mask1 = FALSE;
	m_Mask2 = FALSE;
	m_Mask3 = FALSE;
    m_Mask4 = FALSE;
	m_Mask5 = FALSE;
	m_Mask6 = FALSE;
	m_Mask7 = FALSE;
    m_Mask8 = FALSE;
	m_Mask9 = FALSE;
	m_Mask10 = FALSE;
	m_Mask11 = FALSE;
    m_Mask12 = FALSE;
	m_Mask13 = FALSE;
	m_Mask14 = FALSE;
	m_Mask15 = FALSE;
	m_ReadState0 = FALSE;
	m_WriteState0 = FALSE;
	m_ReadState1 = FALSE;
	m_WriteState1 = FALSE;
	m_ReadState2 = FALSE;
	m_WriteState2 = FALSE;
	m_ReadState3 = FALSE;
	m_WriteState3 = FALSE;
	m_ReadState4 = FALSE;
	m_WriteState4 = FALSE;
	m_ReadState5 = FALSE;
	m_WriteState5 = FALSE;
	m_ReadState6 = FALSE;
	m_WriteState6 = FALSE;
	m_ReadState7 = FALSE;
	m_WriteState7 = FALSE;
    m_ReadState8 = FALSE;
	m_WriteState8 = FALSE;
	m_ReadState9 = FALSE;
	m_WriteState9 = FALSE;
	m_ReadState10 = FALSE;
	m_WriteState10 = FALSE;
	m_ReadState11 = FALSE;
	m_WriteState11 = FALSE;
	m_ReadState12 = FALSE;
	m_WriteState12 = FALSE;
	m_ReadState13 = FALSE;
	m_WriteState13 = FALSE;
	m_ReadState14 = FALSE;
	m_WriteState14 = FALSE;
	m_ReadState15 = FALSE;
	m_WriteState15 = FALSE;
	m_PartNum = _T("");
	m_ProductString = _T("");
	m_SerialNumber = _T("");
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CCP210xPortReadWriteDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CCP210xPortReadWriteDlg)
	DDX_Control(pDX, IDC_COMBO_COMPORT, m_COMPort);
	DDX_Check(pDX, IDC_CHECK_GPIO0, m_Mask0);
	DDX_Check(pDX, IDC_CHECK_GPIO1, m_Mask1);
	DDX_Check(pDX, IDC_CHECK_GPIO2, m_Mask2);
	DDX_Check(pDX, IDC_CHECK_GPIO3, m_Mask3);
	DDX_Check(pDX, IDC_CHECK_GPIO4, m_Mask4);
	DDX_Check(pDX, IDC_CHECK_GPIO5, m_Mask5);
	DDX_Check(pDX, IDC_CHECK_GPIO6, m_Mask6);
	DDX_Check(pDX, IDC_CHECK_GPIO7, m_Mask7);
	DDX_Check(pDX, IDC_CHECK_GPIO8, m_Mask8);
	DDX_Check(pDX, IDC_CHECK_GPIO9, m_Mask9);
	DDX_Check(pDX, IDC_CHECK_GPIO10, m_Mask10);
	DDX_Check(pDX, IDC_CHECK_GPIO11, m_Mask11);
    DDX_Check(pDX, IDC_CHECK_GPIO12, m_Mask12);
	DDX_Check(pDX, IDC_CHECK_GPIO13, m_Mask13);
	DDX_Check(pDX, IDC_CHECK_GPIO14, m_Mask14);
	DDX_Check(pDX, IDC_CHECK_GPIO15, m_Mask15);
	DDX_Check(pDX, IDC_CHECK_GPIO0READSTATE, m_ReadState0);
	DDX_Check(pDX, IDC_CHECK_GPIO0VALUE, m_WriteState0);
	DDX_Check(pDX, IDC_CHECK_GPIO1READSTATE, m_ReadState1);
	DDX_Check(pDX, IDC_CHECK_GPIO1VALUE, m_WriteState1);
	DDX_Check(pDX, IDC_CHECK_GPIO2READSTATE, m_ReadState2);
	DDX_Check(pDX, IDC_CHECK_GPIO2VALUE, m_WriteState2);
	DDX_Check(pDX, IDC_CHECK_GPIO3READSTATE, m_ReadState3);
	DDX_Check(pDX, IDC_CHECK_GPIO3VALUE, m_WriteState3);
	DDX_Check(pDX, IDC_CHECK_GPIO4READSTATE, m_ReadState4);
	DDX_Check(pDX, IDC_CHECK_GPIO4VALUE, m_WriteState4);
	DDX_Check(pDX, IDC_CHECK_GPIO5READSTATE, m_ReadState5);
	DDX_Check(pDX, IDC_CHECK_GPIO5VALUE, m_WriteState5);
	DDX_Check(pDX, IDC_CHECK_GPIO6READSTATE, m_ReadState6);
	DDX_Check(pDX, IDC_CHECK_GPIO6VALUE, m_WriteState6);
	DDX_Check(pDX, IDC_CHECK_GPIO7READSTATE, m_ReadState7);
	DDX_Check(pDX, IDC_CHECK_GPIO7VALUE, m_WriteState7);
	DDX_Check(pDX, IDC_CHECK_GPIO8READSTATE, m_ReadState8);
	DDX_Check(pDX, IDC_CHECK_GPIO8VALUE, m_WriteState8);
	DDX_Check(pDX, IDC_CHECK_GPIO9READSTATE, m_ReadState9);
	DDX_Check(pDX, IDC_CHECK_GPIO9VALUE, m_WriteState9);
	DDX_Check(pDX, IDC_CHECK_GPIO10READSTATE, m_ReadState10);
	DDX_Check(pDX, IDC_CHECK_GPIO10VALUE, m_WriteState10);
	DDX_Check(pDX, IDC_CHECK_GPIO11READSTATE, m_ReadState11);
	DDX_Check(pDX, IDC_CHECK_GPIO11VALUE, m_WriteState11);
	DDX_Check(pDX, IDC_CHECK_GPIO12READSTATE, m_ReadState12);
	DDX_Check(pDX, IDC_CHECK_GPIO12VALUE, m_WriteState12);
	DDX_Check(pDX, IDC_CHECK_GPIO13READSTATE, m_ReadState13);
	DDX_Check(pDX, IDC_CHECK_GPIO13VALUE, m_WriteState13);
	DDX_Check(pDX, IDC_CHECK_GPIO14READSTATE, m_ReadState14);
	DDX_Check(pDX, IDC_CHECK_GPIO14VALUE, m_WriteState14);
	DDX_Check(pDX, IDC_CHECK_GPIO15READSTATE, m_ReadState15);
	DDX_Check(pDX, IDC_CHECK_GPIO15VALUE, m_WriteState15);
	DDX_Text(pDX, IDC_EDIT_PARTNUM, m_PartNum);
	DDX_Text(pDX, IDC_EDIT_PRODUCTSTRING, m_ProductString);
	DDX_Text(pDX, IDC_EDIT_SERIALNUMBER, m_SerialNumber);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CCP210xPortReadWriteDlg, CDialog)
	//{{AFX_MSG_MAP(CCP210xPortReadWriteDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BUTTON_WRITE, OnButtonWrite)
	ON_BN_CLICKED(IDC_BUTTON_READ, OnButtonRead)
	ON_BN_CLICKED(IDC_CHECK_GPIO0VALUE, UpdateCheckBoxes)
	ON_BN_CLICKED(IDC_CHECK_GPIO1VALUE, UpdateCheckBoxes)
	ON_BN_CLICKED(IDC_CHECK_GPIO2VALUE, UpdateCheckBoxes)
	ON_BN_CLICKED(IDC_CHECK_GPIO3VALUE, UpdateCheckBoxes)
	ON_BN_CLICKED(IDC_CHECK_GPIO4VALUE, UpdateCheckBoxes)
	ON_BN_CLICKED(IDC_CHECK_GPIO5VALUE, UpdateCheckBoxes)
	ON_BN_CLICKED(IDC_CHECK_GPIO6VALUE, UpdateCheckBoxes)
	ON_BN_CLICKED(IDC_CHECK_GPIO7VALUE, UpdateCheckBoxes)
    ON_BN_CLICKED(IDC_CHECK_GPIO8VALUE, UpdateCheckBoxes)
	ON_BN_CLICKED(IDC_CHECK_GPIO9VALUE, UpdateCheckBoxes)
	ON_BN_CLICKED(IDC_CHECK_GPIO10VALUE, UpdateCheckBoxes)
	ON_BN_CLICKED(IDC_CHECK_GPIO11VALUE, UpdateCheckBoxes)
    ON_BN_CLICKED(IDC_CHECK_GPIO12VALUE, UpdateCheckBoxes)
	ON_BN_CLICKED(IDC_CHECK_GPIO13VALUE, UpdateCheckBoxes)
	ON_BN_CLICKED(IDC_CHECK_GPIO14VALUE, UpdateCheckBoxes)
	ON_BN_CLICKED(IDC_CHECK_GPIO15VALUE, UpdateCheckBoxes)
	ON_CBN_SELCHANGE(IDC_COMBO_COMPORT, OnSelchangeComboComport)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCP210xPortReadWriteDlg message handlers

BOOL CCP210xPortReadWriteDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
//	SetIcon(m_hIcon, FALSE);		// Set small icon

	CString comString;

	//Fill the COM port list with available COM Ports
	for (int i = 1; i < 256; i++)
	{
		comString.Format(_T("COM%d"), i);
		m_COMPort.AddString(comString);
	}

	//Set the current selection to 2 (COM3)
	m_COMPort.SetCurSel(2);

	OnSelchangeComboComport();
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CCP210xPortReadWriteDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CCP210xPortReadWriteDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CCP210xPortReadWriteDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CCP210xPortReadWriteDlg::OnButtonWrite() 
{
	//Obtain the values of the current check boxes
	UpdateData(TRUE);

	//Format our string for the COM port desired
	CString comString;
	comString.Format(_T("\\\\.\\COM%d"), m_COMPort.GetCurSel() + 1);

	//Open a handle the the device specified
	HANDLE hDevice = CreateFile(comString,
								GENERIC_READ | GENERIC_WRITE,
								0,
								0,
								OPEN_EXISTING,
								FILE_ATTRIBUTE_NORMAL | FILE_FLAG_OVERLAPPED,
								0);

	//If the handle is valid, then it opened
	if (hDevice != INVALID_HANDLE_VALUE)
	{
		//Create the mask value
		WORD mask = m_Mask0 | (m_Mask1 << 1) | (m_Mask2 << 2) | (m_Mask3 << 3) |
                    (m_Mask4 << 4) | (m_Mask5 << 5) | (m_Mask6 << 6) | (m_Mask7 << 7) |
                    (m_Mask8 << 8) | (m_Mask9 << 9) | (m_Mask10 << 10) | (m_Mask11 << 11) |
                    (m_Mask12 << 12) | (m_Mask13 << 13) | (m_Mask14 << 14) | (m_Mask15 << 15);

		//Create the latch value
		WORD latch = m_WriteState0 | (m_WriteState1 << 1) | (m_WriteState2 << 2) | (m_WriteState3 << 3) |
                    (m_WriteState4 << 4) | (m_WriteState5 << 5) | (m_WriteState6 << 6) | (m_WriteState7 << 7) |
                    (m_WriteState8 << 8) | (m_WriteState9 << 9) | (m_WriteState10 << 10) | (m_WriteState11 << 11) |
                    (m_WriteState12 << 12) | (m_WriteState13 << 13) | (m_WriteState14 << 14) | (m_WriteState15 << 15);

		//Write the latch
		if (CP210xRT_WriteLatch(hDevice, mask, latch) != CP210x_SUCCESS)
			MessageBox(_T("Error Writing Latch"), _T("Error"), MB_OK | MB_ICONEXCLAMATION);

		//Close the handle to the device
		CloseHandle(hDevice);

		//Call the read and onselcomport functions to update the latch values and partnumber
		OnButtonRead();
		OnSelchangeComboComport();
	}

	//Show all the new data in the GUI's check box values
	UpdateData(FALSE);
}

void CCP210xPortReadWriteDlg::OnButtonRead() 
{
	UpdateData(TRUE);

	//Format our string for the COM port desired
	CString comString;
	comString.Format(_T("\\\\.\\COM%d"), m_COMPort.GetCurSel() + 1);

	//Open a handle the the device specified
	HANDLE hDevice = CreateFile(comString,
								GENERIC_READ | GENERIC_WRITE,
								0,
								0,
								OPEN_EXISTING,
								FILE_ATTRIBUTE_NORMAL | FILE_FLAG_OVERLAPPED,
								0);

	//If the handle is valid, then it opened
	if (hDevice != INVALID_HANDLE_VALUE)
	{
		WORD latch = 0;

		//Read the latch
		if (CP210xRT_ReadLatch(hDevice, &latch) != CP210x_SUCCESS)
			MessageBox(_T("Error Reading Latch"), _T("Error"), MB_OK | MB_ICONEXCLAMATION);
		else
		{
			//Set the values for the check boxes based on the latch value
			m_ReadState0 = latch & CP210x_GPIO_0 ? true : false;
			m_ReadState1 = latch & CP210x_GPIO_1 ? true : false;
			m_ReadState2 = latch & CP210x_GPIO_2 ? true : false;
			m_ReadState3 = latch & CP210x_GPIO_3 ? true : false;
			m_ReadState4 = latch & CP210x_GPIO_4 ? true : false;
			m_ReadState5 = latch & CP210x_GPIO_5 ? true : false;
			m_ReadState6 = latch & CP210x_GPIO_6 ? true : false;
			m_ReadState7 = latch & CP210x_GPIO_7 ? true : false;
        	m_ReadState8 = latch & CP210x_GPIO_8 ? true : false;
			m_ReadState9 = latch & CP210x_GPIO_9 ? true : false;
			m_ReadState10 = latch & CP210x_GPIO_10 ? true : false;
			m_ReadState11 = latch & CP210x_GPIO_11 ? true : false;
            m_ReadState12 = latch & CP210x_GPIO_12 ? true : false;
			m_ReadState13 = latch & CP210x_GPIO_13 ? true : false;
			m_ReadState14 = latch & CP210x_GPIO_14 ? true : false;
			m_ReadState15 = latch & CP210x_GPIO_15 ? true : false;
		}

		//Close the handle to the device
		CloseHandle(hDevice);
	}

	//Show all the new data in the GUI's check box values
	UpdateData(FALSE);

	//Update the Check boxes to show a 0 or 1 since the read boxes may have changed
	UpdateCheckBoxes();
}

void CCP210xPortReadWriteDlg::UpdateCheckBoxes()
{
	UpdateData(TRUE);

	//Update the Check boxes to show a 0 or 1
	GetDlgItem(IDC_CHECK_GPIO0VALUE)->SetWindowText(m_WriteState0 ? _T("1") : _T("0"));
	GetDlgItem(IDC_CHECK_GPIO1VALUE)->SetWindowText(m_WriteState1 ? _T("1") : _T("0"));
	GetDlgItem(IDC_CHECK_GPIO2VALUE)->SetWindowText(m_WriteState2 ? _T("1") : _T("0"));
	GetDlgItem(IDC_CHECK_GPIO3VALUE)->SetWindowText(m_WriteState3 ? _T("1") : _T("0"));
	GetDlgItem(IDC_CHECK_GPIO4VALUE)->SetWindowText(m_WriteState4 ? _T("1") : _T("0"));
	GetDlgItem(IDC_CHECK_GPIO5VALUE)->SetWindowText(m_WriteState5 ? _T("1") : _T("0"));
	GetDlgItem(IDC_CHECK_GPIO6VALUE)->SetWindowText(m_WriteState6 ? _T("1") : _T("0"));
	GetDlgItem(IDC_CHECK_GPIO7VALUE)->SetWindowText(m_WriteState7 ? _T("1") : _T("0"));
	GetDlgItem(IDC_CHECK_GPIO8VALUE)->SetWindowText(m_WriteState8 ? _T("1") : _T("0"));
	GetDlgItem(IDC_CHECK_GPIO9VALUE)->SetWindowText(m_WriteState9 ? _T("1") : _T("0"));
	GetDlgItem(IDC_CHECK_GPIO10VALUE)->SetWindowText(m_WriteState10 ? _T("1") : _T("0"));
	GetDlgItem(IDC_CHECK_GPIO11VALUE)->SetWindowText(m_WriteState11 ? _T("1") : _T("0"));
	GetDlgItem(IDC_CHECK_GPIO12VALUE)->SetWindowText(m_WriteState12 ? _T("1") : _T("0"));
	GetDlgItem(IDC_CHECK_GPIO13VALUE)->SetWindowText(m_WriteState13 ? _T("1") : _T("0"));
	GetDlgItem(IDC_CHECK_GPIO14VALUE)->SetWindowText(m_WriteState14 ? _T("1") : _T("0"));
	GetDlgItem(IDC_CHECK_GPIO15VALUE)->SetWindowText(m_WriteState15 ? _T("1") : _T("0"));

	GetDlgItem(IDC_CHECK_GPIO0READSTATE)->SetWindowText(m_ReadState0 ? _T("1") : _T("0"));
	GetDlgItem(IDC_CHECK_GPIO1READSTATE)->SetWindowText(m_ReadState1 ? _T("1") : _T("0"));
	GetDlgItem(IDC_CHECK_GPIO2READSTATE)->SetWindowText(m_ReadState2 ? _T("1") : _T("0"));
	GetDlgItem(IDC_CHECK_GPIO3READSTATE)->SetWindowText(m_ReadState3 ? _T("1") : _T("0"));
    GetDlgItem(IDC_CHECK_GPIO4READSTATE)->SetWindowText(m_ReadState4 ? _T("1") : _T("0"));
	GetDlgItem(IDC_CHECK_GPIO5READSTATE)->SetWindowText(m_ReadState5 ? _T("1") : _T("0"));
	GetDlgItem(IDC_CHECK_GPIO6READSTATE)->SetWindowText(m_ReadState6 ? _T("1") : _T("0"));
	GetDlgItem(IDC_CHECK_GPIO7READSTATE)->SetWindowText(m_ReadState7 ? _T("1") : _T("0"));
    GetDlgItem(IDC_CHECK_GPIO8READSTATE)->SetWindowText(m_ReadState8 ? _T("1") : _T("0"));
	GetDlgItem(IDC_CHECK_GPIO9READSTATE)->SetWindowText(m_ReadState9 ? _T("1") : _T("0"));
	GetDlgItem(IDC_CHECK_GPIO10READSTATE)->SetWindowText(m_ReadState10 ? _T("1") : _T("0"));
	GetDlgItem(IDC_CHECK_GPIO11READSTATE)->SetWindowText(m_ReadState11 ? _T("1") : _T("0"));
    GetDlgItem(IDC_CHECK_GPIO12READSTATE)->SetWindowText(m_ReadState12 ? _T("1") : _T("0"));
	GetDlgItem(IDC_CHECK_GPIO13READSTATE)->SetWindowText(m_ReadState13 ? _T("1") : _T("0"));
	GetDlgItem(IDC_CHECK_GPIO14READSTATE)->SetWindowText(m_ReadState14 ? _T("1") : _T("0"));
	GetDlgItem(IDC_CHECK_GPIO15READSTATE)->SetWindowText(m_ReadState15 ? _T("1") : _T("0"));

    UpdateData(FALSE);
}

void CCP210xPortReadWriteDlg::OnSelchangeComboComport() 
{
    UpdateData(TRUE);

	//Format our string for the COM port desired
	CString comString;
	comString.Format(_T("\\\\.\\COM%d"), m_COMPort.GetCurSel() + 1);

	//Open a handle the the device specified
	HANDLE hDevice = CreateFile(comString,
								GENERIC_READ | GENERIC_WRITE,
								0,
								0,
								OPEN_EXISTING,
								FILE_ATTRIBUTE_NORMAL | FILE_FLAG_OVERLAPPED,
								0);

	//If the handle is valid then it opened
	if (hDevice != INVALID_HANDLE_VALUE)
	{
		BYTE bPartNum;

		//Get the current part number
		if (CP210xRT_GetPartNumber(hDevice, &bPartNum) == CP210x_SUCCESS)
		{
			//Update the text for the partnumber once it has been returned
			if (bPartNum != 0x00)
			{
				m_PartNum.Format(_T("CP21%02d"), bPartNum);
			}

			CP210x_PRODUCT_STRING productString;
			BYTE productStringLength;

			CP210x_SERIAL_STRING serialString;
			BYTE serialStringLength;

			if (CP210xRT_GetDeviceProductString(hDevice, productString, &productStringLength) == CP210x_SUCCESS)
			{
				m_ProductString = productString;
			}

			if (CP210xRT_GetDeviceSerialNumber(hDevice, serialString, &serialStringLength) == CP210x_SUCCESS)
			{
				m_SerialNumber = serialString;
			}		
		}
		else
		{
			//Otherwise make the part number blank
			m_PartNum = _T("");
			m_ProductString = _T("");
			m_SerialNumber = _T("");
		}

		//Close the handle to the device
		CloseHandle(hDevice);
	}	
	else
	{
		//Otherwise make the part number blank
		m_PartNum = _T("");
		m_ProductString = _T("");
		m_SerialNumber = _T("");
	}

	UpdateData(FALSE);

	// Read the latch if we are using a part that supports it
	if ((m_PartNum == _T("CP2103")) ||
		(m_PartNum == _T("CP2104")) ||
		(m_PartNum == _T("CP2105")) ||
        (m_PartNum == _T("CP2108")))
	{
		OnButtonRead();			
	}
}
