/*******************************************************************************
* @file  Flash_Intf.h
* @brief 
*******************************************************************************
* # License
* <b>Copyright 2020 Silicon Laboratories Inc. www.silabs.com</b>
*******************************************************************************
*
* The licensor of this software is Silicon Laboratories Inc. Your use of this
* software is governed by the terms of Silicon Labs Master Software License
* Agreement (MSLA) available at
* www.silabs.com/about-us/legal/master-software-license-agreement. This
* software is distributed to you in Source Code format and is governed by the
* sections of the MSLA applicable to Source Code.
*
******************************************************************************/

/**
 * Includes
 */
#ifndef __FLASH_INTF_H__
#define __FLASH_INTF_H__

#ifdef __cplusplus
extern "C" {
#endif

#define SECONDARY_FLASH
//#include "FlashOS.h"
//#include "rsi_qspi.h"
//#include "rsi_rom_egpio.h"
#define M4SS_CLK_PWR_CTRL_BASE_ADDR   0x46000000
#define M4SS_CLK_ENABLE_SET_REG1     *(volatile uint32_t *)(M4SS_CLK_PWR_CTRL_BASE_ADDR + 0x00)
#define M4SS_CLK_ENABLE_CLEAR_REG1   *(volatile uint32_t *)(M4SS_CLK_PWR_CTRL_BASE_ADDR + 0x04)
#define M4SS_STATIC_CLK_SWITCH        BIT(19)

#define  CLK_ENABLE_SET_2_REG_QSPI      (*((volatile uint32_t *) (M4SS_CLK_PWR_CTRL_BASE_ADDR + 0x08)))
/*Disable the flash based retention sleep */
#define FLASH_BASED_RET_SLEEP   1       /*<! Enable flash based execution       >*/
#define INTERMEDIATE_SP         0x1F800 /*<! Stack pointer on retention wake up >*/
#define QSPI_PINS_PORT 0
#define TA_RESET_ADDR      0x22000004
#define INIT_FLASH_OFFSET    0x11000
#define FLASH_SECTOR_OFFSET  0x007EEFFF
#define SIZE_1K              1024
#define CRC_LEN_VAL          236
#define FLASH_VERIFY_ADDR    0x00FFFFFF
#define FLASH_PAGE_SIZE      256
#define DWORD_ADDR_COMP      0xffffffff
#define VAL_12               12
#define VAL_11               11
#define VAL_15               15
#define VAL_6                6

#ifdef SECONDARY_FLASH
#define    PadSelectionEnable_CLK  	16
#define    PadSelectionEnable_D0  	17
#define    PadSelectionEnable_D1  	18
#define    PadSelectionEnable_CSN0	19
#define    PadSelectionEnable_D2  	20
#define    PadSelectionEnable_D3  	21

#define    QSPI_MODE								9

/*M4 QSPI  pin set */
#define    M4SS_QSPI_CLK    52
#define    M4SS_QSPI_D0     53
#define    M4SS_QSPI_D1     54
#define    M4SS_QSPI_CSN0   55
#define    M4SS_QSPI_D2     56
#define    M4SS_QSPI_D3     57
#endif

#ifdef PRIMARY_FLASH
#define    PadSelectionEnable 0
#define    QSPI_MODE					1
/*M4 QSPI  pin set */
#define    M4SS_QSPI_CLK    0
#define    M4SS_QSPI_CSN0   1
#define    M4SS_QSPI_D0     2
#define    M4SS_QSPI_D1     3
#define    M4SS_QSPI_D2     4
#define    M4SS_QSPI_D3     5
#endif
#ifdef EXTERNAL_FLASH
#define    PadSelectionEnable_1 11
#define    PadSelectionEnable_2 12
#define    QSPI_MODE					10
/*M4 QSPI  pin set */
#define    M4SS_QSPI_CLK    46
#define    M4SS_QSPI_CSN0   49
#define    M4SS_QSPI_D0     47
#define    M4SS_QSPI_D1     48
#define    M4SS_QSPI_D2     50
#define    M4SS_QSPI_D3     51
#endif

/******************************************
 *              FLASH CMDS
 ******************************************/
//! Write enable cmd
#define WREN                         0x06
#define WREN2                        0xF9
//! Write disable cmd
#define WRDI                         0x04
#define WRDI2                        0xFB
//! Read status reg cmd
#define RDSR                         0x05
#define RDSR2                        0xFA
//! chip erase cmd
#define CHIP_ERASE                   0xC7
//! block erase cmd
#define BLOCK_ERASE                  0xD8
//! sector erase cmd
#define SECTOR_ERASE                 0x20
//! high speed rd cmd
#define HISPEED_READ                 0x0B
//! rd cmd
#define READ                         0x03
//!write config2
#define WCFG2                        0x72

#define _1BYTE 0
#define _2BYTE 1
#define _4BYTE 3

/* GPIO register bit position related defines */
#define  GPIO_0_TO_5      0
#define  GPIO_6_TO_11     1
#define  GPIO_46_TO_51    2
#define  GPIO_52_TO_57    3
#define  GPIO_58_TO_63    4
//! TA OCTA/DUAL combinations
#define  GPIO_0_AND_58    5
#define  GPIO_6_AND_58    6
#define  GPIO_46_AND_58   7
//! M4 OCTA/DUAL combinations
#define  GPIO_0_AND_52    8
#define  GPIO_6_AND_52    9
#define  GPIO_46_AND_52   10
#define  NOT_USING        11 //! Not applicable
#define  GPIO_58_AND_52   12
#define  GPIO_DDR_PADS    13


typedef enum errnoCode {
  RSI_FAIL = -1,
  RSI_OK   = 0,
  //INVALID_PARAMETERS,
  /*USART error codes*/
  ERROR_USART_BASE         = 0x100,
  ERROR_USART_CALLBACK_ERR = ERROR_USART_BASE + 1,
  ERROR_USART_NOT_SUPPORTED,

  /* GPDMA error codes */
  ERROR_GPDMA_BASE           = 0x200,
  ERROR_GPDMA_INVALIDCHNLNUM = ERROR_GPDMA_BASE + 1,
  ERROR_GPDMA_FLW_CTRL,
  ERROR_GPDMA_BURST,
  ERROR_GPDMA_SRC_ADDR,
  ERROR_GPDMA_DST_ADDR,
  NOERR_GPDMA_FLAG_SET,
  ERROR_GPDMA_INVALID_EVENT,
  ERROR_GPDMA_INVALID_XFERMODE,
  ERROR_GPDMA_INVALID_TRANS_LEN,
  ERROR_GPDMA_INVALID_ARG,
  ERROR_GPDMA_CHNL_BUSY,
  ERROR_GPDMA_NOT_ALIGNMENT,
  ERROR_GPDMA_QUEUE_EMPTY,
  ERROR_GPDMA_GENERAL,

  /* UDMA error codes */
  ERROR_UDMA_BASE           = 0x300,
  ERROR_UDMA_INVALIDCHNLNUM = ERROR_UDMA_BASE + 1,
  ERROR_UDMA_CTRL_BASE_INVALID,
  ERROR_UDMA_INVALID_XFERMODE,
  ERROR_UDMA_INVALID_TRANS_LEN,
  ERROR_UDMA_INVALID_ARG,
  ERROR_UDMA_SRC_ADDR,
  ERROR_UDMA_DST_ADDR,
  ERROR_UDMA_CHNL_BUSY,

  /* I2C error codes */
  ERROR_I2C_BASE        = 0x400,
  ERROR_I2C_INVALID_ARG = ERROR_I2C_BASE + 1,
  ERROR_I2CS_UNKNOWN,
  ERROR_I2C_SPIKE_LOGIC,
  ERROR_I2C_IGNORE_GC_OR_START,
  ERROR_I2C_STATUS_FLAG_NOT_SET,
  ERROR_I2C_BUSY_FLAG,
  ERROR_I2C_MST_BUSY_FLAG,
  ERROR_I2C_SLV_BUSY_FLAG,
  ERROR_I2C_SLV_DIS_WHILE_BUSY,
  ERROR_I2C_MST_XFER_ABORT,
  ERROR_I2C_MST_TX_CMD_BLOCK,
  ERROR_I2C_SLV_RX_DATA_LOST,
  ERROR_I2C_NO_TX_DATA,
  ERROR_I2C_NO_INTR_FLAG,
  ERROR_I2C_ERROR_FLAG_NONE,
  ERROR_I2C_INVALID_CB,
  ERROR_I2C_INVALID_POINTER,
  ERROR_I2C_GENERAL_FAILURE,
  ERROR_I2C_TXABORT,
  ERROR_I2C_SCL_STUCK_ATLOW,
  ERROR_I2C_MST_ON_HOLD,
  ERROR_I2C_BUFFER_OVERFLOW,
  ERROR_I2C_BUFFER_UNDERFLOW,

  /* I2S error codes */
  ERROR_I2S_BASE        = 0x500,
  ERROR_I2S_INVALID_ARG = ERROR_I2S_BASE + 1,
  ERROR_I2S_INVALID_RES,
  ERROR_I2S_INVALID_LENGTH,
  ERROR_I2S_BUSY,
  ERROR_I2S_TXOVERRUN,
  ERROR_I2S_RXOVERRUN,
  ERROR_I2S_TXCOMPLETE,
  ERROR_I2S_RXCOMPLETE,

  /* UART error codes */
  ERROR_UART_BASE        = 0x600,
  ERROR_UART_INVALID_ARG = ERROR_UART_BASE + 1,
  ERROR_UART_INVALID_RES,

  /* PWM error codes */
  ERROR_PWM_BASE            = 0x700,
  ERROR_PWM_INVALID_CHNLNUM = ERROR_PWM_BASE + 1,
  ERROR_PWM_INVALID_PWMOUT,
  ERROR_PWM_NO_INTR,
  ERROR_PWM_INVALID_ARG,

  /* Timers error codes */
  ERROR_TIMER_BASE      = 0x800,
  ERROR_INVAL_TIMER_NUM = ERROR_TIMER_BASE + 1,
  ERROR_INVAL_TIMER_MODE,
  ERROR_INVAL_TIMERTYPE,
  ERROR_INVAL_COUNTER_DIR,

  /* SCT error codes */
  ERROR_CT_BASE                = 0x900,
  ERROR_CT_INVALID_COUNTER_NUM = ERROR_CT_BASE + 1,
  ERROR_CT_INVALID_ARG,

  /* EFUSE ERROR CODES */
  ERROR_EFUSE_BASE                  = 0xA00,
  ERROR_EFUSE_INVALID_WRITE_ADDRESS = ERROR_EFUSE_BASE + 1,
  ERROR_EFUSE_INVALID_WRITE_BIT_POSITION,
  ERROR_EFUSE_INVALID_PARAMETERS,

  /* CCI ERROR CODES */
  ERROR_CCI_BASE_ADDRESS = 0xB00,
  ERROR_CCI_INIT_FAIL    = ERROR_CCI_BASE_ADDRESS + 1,
  ERROR_CCI_ADDRESS_ERR,

  /* QEI ERROR CODES */
  ERROR_QEI_BASE              = 0xC00,
  ERROR_INVALID_WRITE_ADDRESS = ERROR_QEI_BASE + 1,
  ERROR_INVALID_WRITE_BIT_POSITION,
  ERROR_INVALID_PARAMETERS,

  /* SDIO ERROR CODES */
  ERROR_SSDIO_BASE_ADDRESS = 0xD00, /*!< SDIO Error base address */
  ERROR_SSDIO_INIT_FAIL    = ERROR_SSDIO_BASE_ADDRESS + 1,
  ERROR_SSDIO_ADDRESS_ERR,
  ERROR_SSDIO_INVALID_FN,
  ERROR_SSDIO_INVALID_PARAM,

	
  /* SPI ERROR CODES*/
  ERROR_SSPI_BASE_ADDRESS = 0xE00,
  ERROR_SSPI_INIT_FAIL    = ERROR_SSPI_BASE_ADDRESS + 1,
  ERROR_SSPI_ADDRESS_ERR,
  ERROR_SSPI_CB_ERROR,

  /* ETHERNET ERROR CODES */
  ERROR_ETH_BASE_ADDRESS = 0xF00,
  ERROR_ETH_INIT_FAIL    = ERROR_ETH_BASE_ADDRESS + 1,
  ERROR_ETH_PARAM,
  ERROR_ETH_NULL,
  ERR_DMA_NOT_ALIGNMENT,
  ERROR_ETH_CALLBACK_ERR,

  /*CAN ERROR CODES*/
  ERROR_CAN_BASE               = 0x1000,
  ERROR_CAN_INVALID_PARAMETERS = ERROR_CAN_BASE + 1,
  ERROR_CAN_INVALID_TIMING_PARAMETERS,
  ERROR_CAN_OPERATION_IN_PROGRESS,

  /*GSPI ERROR CODES*/
  ERROR_GSPI_BASE           = 0x1100,
  ERROR_GSPI_INVALID_ARG    = ERROR_GSPI_BASE + 1,
  ERROR_GSPI_INVALID_LENGTH = ERROR_GSPI_BASE + 2,
  ERROR_GSPI_BUSY           = ERROR_GSPI_BASE + 3,
  ERROR_GSPI_READ_DONE      = ERROR_GSPI_BASE + 4,
  ERROR_GSPI_IDLE           = ERROR_GSPI_BASE + 5,
  ERROR_GSPI_TX_DONE        = ERROR_GSPI_BASE + 6,

  /*SSI ERROR CODES*/
  ERROR_SSI_BASE        = 0x1200,
  ERROR_SSI_INVALID_ARG = ERROR_SSI_BASE + 1,
  ERROR_SSI_BUSY        = ERROR_SSI_BASE + 2,
  ERROR_SSI_IDLE        = ERROR_SSI_BASE + 3,
  TRANSFER_COMPLETE     = ERROR_SSI_BASE + 4,
  READ_COMPLETED        = ERROR_SSI_BASE + 5,

  /*SSI ERROR CODES*/
  ERROR_CRC_BASE        = 0x1300,
  ERROR_CRC_INVALID_ARG = ERROR_CRC_BASE + 1,

  /*SSI ERROR CODES*/
  ERROR_RNG_BASE        = 0x1400,
  ERROR_RNG_INVALID_ARG = ERROR_RNG_BASE + 1,

  /*NPSS ERROR CODES*/
  ERROR_BOD_BASE = 0x1500,
  ERROR_PS_BASE  = ERROR_BOD_BASE + 1,
  ERROR_BOD_INVALID_PARAMETERS,
  ERROR_PS_INVALID_PARAMETERS,
  ERROR_PS_INVALID_STATE,

  /*TIME PERIOD*/
  ERROR_TIMEPERIOD_BASE        = 0x1600,
  ERROR_TIME_PERIOD_PARAMETERS = ERROR_TIMEPERIOD_BASE + 1,
  ERROR_TIME_PERIOD_RC_CALIB_NOT_DONE,
  ERROR_CAL_INVALID_PARAMETERS,

  /*M4SS CLOCKS */
  ERROR_M4SS_CLK_BASE     = 0x1700,
  ERROR_CLOCK_NOT_ENABLED = ERROR_M4SS_CLK_BASE + 1,
  ERROR_INVALID_INPUT_FREQUENCY,

  /*ULPSS CLOCKS */
  ERROR_ULPCLK_BASE               = 1800,
  ERROR_ULPCLK_INVALID_PARAMETERS = ERROR_ULPCLK_BASE + 1,

  ERROR_SIO_BASE       = 0x1900,
  ERROR_SIO_I2C_NO_ACK = ERROR_SIO_BASE + 1,

  /* ULPSS FIM */
  ERROR_FIM_BASE               = 0x2000,
  ERROR_FIM_MATRIX_INVALID_ARG = ERROR_FIM_BASE + 1,

  /* AUX ADC */
  ERROR_NO_MULTI_CHNL_ENABLE = 0x2100,
  NO_MODE_SET                = ERROR_NO_MULTI_CHNL_ENABLE + 1,
  ERROR_PING_PONG_ADDR_MATCH = ERROR_NO_MULTI_CHNL_ENABLE + 2,
  ERROR_ADC_INVALID_ARG      = ERROR_NO_MULTI_CHNL_ENABLE + 3,
  INVALID_SAMPLING_RATE      = ERROR_NO_MULTI_CHNL_ENABLE + 4,
  INVALID_AUX_REF_VOLTAGE    = ERROR_NO_MULTI_CHNL_ENABLE + 5,
  INVALID_SAMPLE_LENGTH      = ERROR_NO_MULTI_CHNL_ENABLE + 6,
  INVALID_ADC_CHANNEL_ENABLE = ERROR_NO_MULTI_CHNL_ENABLE + 6,

  /* AUX DAC */
  ERROR_NO_PAD_SEL = 0x2200,
  ERROR_FREQ_VAL   = ERROR_NO_PAD_SEL + 1,

  /*SDMEM*/
  ERROR_ACCESS_RIGHTS   = 0x2300,
  ERROR_ADDR_ALIGHMENGT = ERROR_ACCESS_RIGHTS + 1,
  ERROR_SMIH,
  ERROR_INAVLID_MODE,
  ERROR_OPERATION_INPROGRESS,
  ERROR_NOT_READY,
  ERROR_UNINITIALIZED,
  ERROR_BUFFER_FULL,
  ERROR_TIMEOUT,
  CARD_NOT_READY_OP,
  CARD_TYPE_MEMCARD,
} error_t;


#define TA_EFUSE_BASE_ADDR 0x40010000
#define M4_EFUSE_BASE_ADDR 0x4600C000

#define TA_EFUSE_IO_BASE_ADDR (TA_EFUSE_BASE_ADDR + 0x2000)
#define M4_EFUSE_IO_BASE_ADDR (M4_EFUSE_BASE_ADDR + 0x2000)

#define EFUSE_DA_ADDR_REG_OFFSET           0x00
#define EFUSE_DA_CTRL_SET_REG_OFFSET       0x04
#define EFUSE_DA_CTRL_CLEAR_REG_OFFSET     0x08
#define EFUSE_CTRL_REG_OFFSET              0x0C
#define EFUSE_READ_ADDR_REG_OFFSET         0x10
#define EFUSE_READ_DATA_REG_OFFSET         0x14
#define EFUSE_STATUS_REG_OFFSET            0x18
#define EFUSE_RD_TMNG_PARAM_REG_OFFSET     0x1C
#define EFUSE_DA_ADDR_REG_DEFAULT_OFFSET   0x2C
#define EFUSE_MEM_MAP_LENGTH_OFFSET        0x24
#define EFUSE_DA_CLR_STROBE_REG_OFFSET     0x34
#define EFUSE_CLK_ENABLE_SET_REG2_OFFSET   0x38
#define EFUSE_CLK_ENABLE_CLEAR_REG2_OFFSET 0x3C

#define TA_EFUSE_DA_ADDR_REG         (*((uint16_t volatile *)(TA_EFUSE_BASE_ADDR + EFUSE_DA_ADDR_REG_OFFSET)))
#define TA_EFUSE_DA_CTRL_SET_REG     (*((uint16_t volatile *)(TA_EFUSE_BASE_ADDR + EFUSE_DA_CTRL_SET_REG_OFFSET)))
#define TA_EFUSE_DA_CTRL_CLEAR_REG   (*((uint16_t volatile *)(TA_EFUSE_BASE_ADDR + EFUSE_DA_CTRL_CLEAR_REG_OFFSET)))
#define TA_EFUSE_CTRL_REG            (*((uint16_t volatile *)(TA_EFUSE_BASE_ADDR + EFUSE_CTRL_REG_OFFSET)))
#define TA_EFUSE_READ_ADDR_REG       (*((uint16_t volatile *)(TA_EFUSE_BASE_ADDR + EFUSE_READ_ADDR_REG_OFFSET)))
#define TA_EFUSE_READ_DATA_REG       (*((uint16_t volatile *)(TA_EFUSE_BASE_ADDR + EFUSE_READ_DATA_REG_OFFSET)))
#define TA_EFUSE_STATUS_REG          (*((uint16_t volatile *)(TA_EFUSE_BASE_ADDR + EFUSE_STATUS_REG_OFFSET)))
#define TA_EFUSE_RD_TMNG_PARAM_REG   (*((uint16_t volatile *)(TA_EFUSE_BASE_ADDR + EFUSE_RD_TMNG_PARAM_REG_OFFSET)))
#define TA_EFUSE_DA_ADDR_REG_DEFAULT (*((uint16_t volatile *)(TA_EFUSE_BASE_ADDR + EFUSE_DA_ADDR_REG_DEFAULT_OFFSET)))
#define TA_EFUSE_MEM_MAP_LENGTH      (*((uint16_t volatile *)(TA_EFUSE_BASE_ADDR + EFUSE_MEM_MAP_LENGTH_OFFSET)))
#define TA_EFUSE_DA_CLR_STROBE_REG   (*((uint16_t volatile *)(TA_EFUSE_BASE_ADDR + EFUSE_DA_CLR_STROBE_REG_OFFSET)))

#define M4_EFUSE_DA_ADDR_REG         (*((uint16_t volatile *)(M4_EFUSE_BASE_ADDR + EFUSE_DA_ADDR_REG_OFFSET)))
#define M4_EFUSE_DA_CTRL_SET_REG     (*((uint16_t volatile *)(M4_EFUSE_BASE_ADDR + EFUSE_DA_CTRL_SET_REG_OFFSET)))
#define M4_EFUSE_DA_CTRL_CLEAR_REG   (*((uint16_t volatile *)(M4_EFUSE_BASE_ADDR + EFUSE_DA_CTRL_CLEAR_REG_OFFSET)))
#define M4_EFUSE_CTRL_REG            (*((uint16_t volatile *)(M4_EFUSE_BASE_ADDR + EFUSE_CTRL_REG_OFFSET)))
#define M4_EFUSE_READ_ADDR_REG       (*((uint16_t volatile *)(M4_EFUSE_BASE_ADDR + EFUSE_READ_ADDR_REG_OFFSET)))
#define M4_EFUSE_READ_DATA_REG       (*((uint16_t volatile *)(M4_EFUSE_BASE_ADDR + EFUSE_READ_DATA_REG_OFFSET)))
#define M4_EFUSE_STATUS_REG          (*((uint16_t volatile *)(M4_EFUSE_BASE_ADDR + EFUSE_STATUS_REG_OFFSET)))
#define M4_EFUSE_RD_TMNG_PARAM_REG   (*((uint16_t volatile *)(M4_EFUSE_BASE_ADDR + EFUSE_RD_TMNG_PARAM_REG_OFFSET)))
#define M4_EFUSE_DA_ADDR_REG_DEFAULT (*((uint16_t volatile *)(M4_EFUSE_BASE_ADDR + EFUSE_DA_ADDR_REG_DEFAULT_OFFSET)))
#define M4_EFUSE_MEM_MAP_LENGTH      (*((uint16_t volatile *)(M4_EFUSE_BASE_ADDR + EFUSE_MEM_MAP_LENGTH_OFFSET)))
#define M4_EFUSE_DA_CLR_STROBE_REG   (*((uint16_t volatile *)(M4_EFUSE_BASE_ADDR + EFUSE_DA_CLR_STROBE_REG_OFFSET)))

#define EFUSE_CLK_BIT             BIT(5)
#define EFUSE_PCLK_BIT            BIT(19)
#define M4SS_CLK_ENABLE_SET_3_REG (*((volatile uint32_t *)(M4SS_CLK_PWR_CTRL_BASE_ADDR + 0x10)))

/*EFUSE_DA_CTRL_SET_REG*/
#define SET_LOAD_ENABLE    BIT(3)
#define SET_CHIP_ENABLE    BIT(1)
#define SET_PROGRAM_ENABLE BIT(0)

#define READ_FSM_DONE BIT(15)

/*Address range for 32x8 eFUSE for M4SS*/
#define ADDRESS_MIN 0x00 /*!< Start address   */
#define ADDRESS_MAX 0x31 /*!< End address     */

/*Bit Positions range*/
#define BIT_POS_MIN 0x00 /*!< Min Bit position*/
#define BIT_POS_MAX 0x07 /*!< Max bit position*/


#define PAD_CONFIG_REG(x)            \
  (*(volatile uint32_t *)(0x46004000 \
                          + 4 * x)) /*!< REN enable bit(this should be enable)                              */
#define PADSELECTION                 \
  (*(volatile uint32_t *)(0x41300000 \
                          + 0x610)) /*!< PAD selection (0 t0 21) A value of 1 on this gives control to M4SS */

#ifdef CHIP_9117
#define PADSELECTION_1               \
  (*(volatile uint32_t *)(0x41300000 \
                          + 0x618)) /*!< PAD selection (22 to 33) A value of 1 on this gives control to M4SS */
#endif

/* Example defines */
#define TIMER_0 0
#define TIMER_1 1
#define TIMER_2 2
#define TIMER_3 3
	
#ifdef __cplusplus
}
#endif

#endif /* __RSI_EGPIO_H__*/
