/*******************************************************************************
* @file  rsi_common_apis_flm.h
* @brief 
*******************************************************************************
* # License
* <b>Copyright 2020 Silicon Laboratories Inc. www.silabs.com</b>
*******************************************************************************
*
* The licensor of this software is Silicon Laboratories Inc. Your use of this
* software is governed by the terms of Silicon Labs Master Software License
* Agreement (MSLA) available at
* www.silabs.com/about-us/legal/master-software-license-agreement. This
* software is distributed to you in Source Code format and is governed by the
* sections of the MSLA applicable to Source Code.
*
******************************************************************************/

#ifndef RSI_COMMON_APIS_FLM_H
#define RSI_COMMON_APIS_FLM_H

// To select antenna type , internal antenna for 301 modules RFOUT2 for 03 modules
#define RSI_INTERNAL_OR_RFOUT2 0

// To select antenna type , ufl connector for 301 modules RFOUT1 for 03 modules
#define RSI_UFL_OR_RFOUT1 1

// success return value
#define RSI_SUCCESS 0

// failure return value
#define RSI_FAILURE -1

// Upgrade images
#define BURN_NWP_FW 'B'

// Upgrade images
#define RSI_JUMP_TO_PC 'J'

//! Upgrade images
#define RSI_UPGRADE_IMAGE_I_FW '4'

//! Erase command
#define ERASE_COMMON_FLASH 'M'

#define RSI_ACTIVE_LOW_INTR  0x2
#define RSI_ACTIVE_HIGH_INTR 0x0
#define RSI_RX_BUFFER_CHECK  0x15
// TX buffer full macro
#define RSI_TX_BUFFER_FULL -2
#define RSI_SOFT_RESET     0
#define RSI_HARD_RESET     1

#ifdef CONFIGURE_GPIO_FROM_HOST
typedef struct rsi_gpio_pin_config_val_s {

  uint8_t drive_strength;
  uint8_t input_mode;
  uint8_t default_gpio_state;

} rsi_gpio_pin_config_val_t;

typedef struct rsi_gpio_pin_config_s {

  uint8_t config_mode;
  uint8_t pin_num;
  uint8_t config_values;
  uint8_t output_value;

} rsi_gpio_pin_config_t;
#endif
/******************************************************
 * *                    Constants
 * ******************************************************/
/******************************************************
 * *                   Enumerations
 * ******************************************************/

// enumerations for power save profile modes
typedef enum rsi_power_save_profile_mode_e {
  RSI_ACTIVE        = 0,
  RSI_SLEEP_MODE_1  = 1,
  RSI_SLEEP_MODE_2  = 2,
  RSI_SLEEP_MODE_8  = 8,
  RSI_SLEEP_MODE_10 = 10,
} rsi_power_save_profile_mode_t;

// enumerations for power save profile types
typedef enum rsi_power_save_profile_type_e {
  RSI_MAX_PSP  = 0,
  RSI_FAST_PSP = 1,
  RSI_UAPSD    = 2
} rsi_power_save_profile_type_t;

// enumerations for differnt power mode exists for Redpine module
typedef enum rsi_power_save_mode_e {
  RSI_POWER_MODE_DISABLE      = 0,
  RSI_CONNECTED_SLEEP_PS      = 1,
  RSI_CONNECTED_GPIO_BASED_PS = 2,
  RSI_CONNECTED_MSG_BASED_PS  = 3,
#ifdef RSI_M4_INTERFACE
  RSI_CONNECTED_M4_BASED_PS = 4,
#endif
  RSI_GPIO_BASED_DEEP_SLEEP = 8,
  RSI_MSG_BASED_DEEP_SLEEP  = 9,
#ifdef RSI_M4_INTERFACE
  RSI_M4_BASED_DEEP_SLEEP = 10
#endif
} rsi_power_save_mode_t;

#ifdef CONFIGURE_GPIO_FROM_HOST
typedef enum rsi_gpio_config_mode_e { RSI_CONFIG_GPIO = 0, RSI_SET_GPIO = 1, RSI_GET_GPIO = 2 } rsi_gpio_config_mode_t;
#endif

#ifdef RSI_M4_INTERFACE
#define NO_OF_HOURS_IN_A_DAY      24
#define NO_OF_MINUTES_IN_AN_HOUR  60
#define NO_OF_SECONDS_IN_A_MINUTE 60
#define BASE_YEAR                 2000
#define SOC_OPER_FREQUENCY        36000
#endif

/******************************************************
 * *                 Type Definitions
 * ******************************************************/
/******************************************************
 * *                    Structures
 * ******************************************************/
/******************************************************
 * *                 Global Variables
 * ******************************************************/

#endif
