/*******************************************************************************
* @file  rsi_hal_flm.h
* @brief 
*******************************************************************************
* # License
* <b>Copyright 2020 Silicon Laboratories Inc. www.silabs.com</b>
*******************************************************************************
*
* The licensor of this software is Silicon Laboratories Inc. Your use of this
* software is governed by the terms of Silicon Labs Master Software License
* Agreement (MSLA) available at
* www.silabs.com/about-us/legal/master-software-license-agreement. This
* software is distributed to you in Source Code format and is governed by the
* sections of the MSLA applicable to Source Code.
*
******************************************************************************/

#ifndef _RSIHAL_FLM_H_
#define _RSIHAL_FLM_H_

#ifndef RSI_SAMPLE_HAL
#include "rsi_hal.h"
#else

/******************************************************
 * *                      Macros
 * ******************************************************/

//! User can configure this pin based on platform

//! GPIO to reset WiSeConnect Module
#define RSI_HAL_RESET_PIN              1

//! GPIO to receive packet pending interrupt
#define RSI_HAL_MODULE_INTERRUPT_PIN   2

//! GPIO to receive module wakeup from power save indication
#define RSI_HAL_WAKEUP_INDICATION_PIN  3

//! ULP GPIO to give sleep confirmation to module to goto sleep in power save
#define RSI_HAL_SLEEP_CONFIRM_PIN      4

//! GPIO to receive SPI interface busy and ready indication from module
#define RSI_HAL_INTERFACE_READY_PIN    5

//! LP GPIO to give sleep confirmation to module to goto sleep in power save
#define RSI_HAL_LP_SLEEP_CONFIRM_PIN   6

//! GPIO to power on/off WiSeConnect Module
#define RSI_HAL_MODULE_POWER_CONTROL   7

//! GPIO Pins related Macros
//! Macro to configure GPIO in output mode
#define RSI_HAL_GPIO_OUTPUT_MODE       1

//! Macro to configure GPIO in input mode
#define RSI_HAL_GPIO_INPUT_MODE        0

//! Macro to drive low value on GPIO
#define RSI_HAL_GPIO_LOW               0

//! Macro to drive high value on GPIO
#define RSI_HAL_GPIO_HIGH              1

//! Timer related macros
//! Macro to configure timer type in single shot
#define RSI_HAL_TIMER_TYPE_SINGLE_SHOT 0

//! Macro to configure timer type in periodic
#define RSI_HAL_TIMER_TYPE_PERIODIC    1

//! Macro to configure timer in micro seconds mode
#define RSI_HAL_TIMER_MODE_MICRO       0

//! Macro to configure timer in milli seconds mode
#define RSI_HAL_TIMER_MODE_MILLI       1

/******************************************************
 * *                    Constants
 * ******************************************************/
/******************************************************
 * *                   Enumerations
 * ******************************************************/

/******************************************************
 * *                 Type Definitions
 * ******************************************************/

/******************************************************
 * *                    Structures
 * ******************************************************/

/******************************************************
 * *                 Global Variables
 * ******************************************************/
/******************************************************
 * *               Function Declarations
 * ******************************************************/

void rsi_hal_config_gpio(uint8_t gpio_number, uint8_t mode, uint8_t value);
void rsi_hal_set_gpio(uint8_t gpio_number);
uint8_t rsi_hal_get_gpio(uint8_t gpio_number);
void rsi_hal_clear_gpio(uint8_t gpio_number);

#endif
#endif
