/*******************************************************************************
* @file  rsi_device_init_apis_flm.c
* @brief
*******************************************************************************
* # License
* <b>Copyright 2020 Silicon Laboratories Inc. www.silabs.com</b>
*******************************************************************************
*
* The licensor of this software is Silicon Laboratories Inc. Your use of this
* software is governed by the terms of Silicon Labs Master Software License
* Agreement (MSLA) available at
* www.silabs.com/about-us/legal/master-software-license-agreement. This
* software is distributed to you in Source Code format and is governed by the
* sections of the MSLA applicable to Source Code.
*
******************************************************************************/

#include "rsi_api_flm.h"
#include "rsi_hal_flm.h"
#include "rsi_error_flm.h"

int32_t rsi_device_init(uint8_t select_option)
{
  int32_t status = RSI_SUCCESS;
  uint8_t skip_bootload_sequence = 0;
  int32_t retval                 = 0;

#ifdef DEBUG_UART
  DEBUGOUT("\n Waiting for TA wakeup \n");
  DEBUGOUT("\n TA wokeup \n");
#endif

  if (!skip_bootload_sequence) {
    do {
      retval = rsi_waitfor_boardready();

      if (retval == RSI_ERROR_IN_OS_OPERATION) {
#ifdef DEBUG_UART
        DEBUGOUT("\n Waiting for TA wakeup \n");
#endif
      }
      if ((retval < 0) && (retval != RSI_ERROR_WAITING_FOR_BOARD_READY) && (retval != RSI_ERROR_IN_OS_OPERATION)) {
        return retval;
      }

    } while ((retval == RSI_ERROR_WAITING_FOR_BOARD_READY) && (retval == RSI_ERROR_IN_OS_OPERATION));

    retval = rsi_select_option(select_option);

    if (retval < 0) {
      return retval;
    }
  }
  return status;
}
