
//------------------------------------------------------------------------------------
// Blinky.c
//------------------------------------------------------------------------------------
// Copyright 2002 Cygnal Integrated Products, Inc.
//
// AUTH: HF
// DATE: 10 DEC 02
//
// This program flashes the green LED on the C8051F020 target board about five times
// a second using the interrupt handler for Timer3.
//
// Target: C8051F02x
//
// Tool chain: Tasking 'c' compiler
//

//------------------------------------------------------------------------------------
// Includes
//------------------------------------------------------------------------------------
#include <regc51f02x.sfr>               // SFR declarations


//------------------------------------------------------------------------------------
// Global CONSTANTS
//------------------------------------------------------------------------------------

#define SYSCLK 2000000                  // approximate SYSCLK frequency in Hz

_sfrbit  LED _atbit(P1, 6);             // green LED: '1' = ON; '0' = OFF;

//------------------------------------------------------------------------------------
// Function PROTOTYPES
//------------------------------------------------------------------------------------
void PORT_Init (void);
void Timer3_Init (int counts);
_interrupt(14) void Timer3_ISR (void);

//------------------------------------------------------------------------------------
// MAIN Routine
//------------------------------------------------------------------------------------
void main (void) {

   // disable watchdog timer
   WDTCN = 0xde;
   WDTCN = 0xad;
	
   PORT_Init ();
   Timer3_Init (SYSCLK / 12 / 10);      // Init Timer3 to generate interrupts
                                        // at a 10Hz rate.

   EA = 1;							    // enable global interrupts

   while (1) {                          // spin forever
   }
}

//------------------------------------------------------------------------------------
// PORT_Init
//------------------------------------------------------------------------------------
//
// Configure the Crossbar and GPIO ports
//
void PORT_Init (void)
{
   XBR2    = 0x40;                      // Enable crossbar and weak pull-ups
   P1MDOUT |= 0x40;                     // enable P1.6 (LED) as push-pull output
}

//------------------------------------------------------------------------------------
// Timer3_Init
//------------------------------------------------------------------------------------
//
// Configure Timer3 to auto-reload and generate an interrupt at interval
// specified by <counts> using SYSCLK/12 as its time base.
//
void Timer3_Init (int counts)
{
   TMR3CN = 0x00;						// Stop Timer3; Clear TF3;
                                        // use SYSCLK/12 as timebase

   TMR3RLH  = (-counts) >> 8;           // Init reload values
   TMR3RLL  = (-counts);                // Init reload values

   TMR3H    = 0xff;                     // set to reload immediately
   TMR3L    = 0xff;                     // set to reload immediately

   EIE2   |= 0x01;                      // enable Timer3 interrupts
   TMR3CN |= 0x04;                      // start Timer3

}

//------------------------------------------------------------------------------------
// Interrupt Service Routines
//------------------------------------------------------------------------------------

//------------------------------------------------------------------------------------
// Timer3_ISR
//------------------------------------------------------------------------------------
// This routine changes the state of the LED whenever Timer3 overflows.
//
_interrupt(14) void Timer3_ISR (void)
{

   TMR3CN &= ~(0x80);                   // clear TF3
   LED = ~LED;                          // change state of LED
}