//------------------------------------------------------------------------------------
// C8051F020.H
//------------------------------------------------------------------------------------
//
// Description: Register/bit definitions for the C8051F02x product family. 
// Target: C8051F02x
// DATE: 7 JUN 04
// Tool chain: SDCC 'c'
// Revision: 1.0
//

/*  BYTE Registers  */
sfr at 0x80 P0      ; /* PORT 0                                                  */ 
sfr at 0x81 SP      ; /* STACK POINTER                                           */
sfr at 0x82 DPL     ; /* DATA POINTER - LOW BYTE                                 */
sfr at 0x83 DPH     ; /* DATA POINTER - HIGH BYTE                                */
sfr at 0x84 P4      ; /* PORT 4                                                  */
sfr at 0x85 P5      ; /* PORT 5                                                  */
sfr at 0x86 P6      ; /* PORT 6                                                  */             
sfr at 0x87 PCON    ; /* POWER CONTROL                                           */
sfr at 0x88 TCON    ; /* TIMER CONTROL                                           */
sfr at 0x89 TMOD    ; /* TIMER MODE                                              */
sfr at 0x8A TL0     ; /* TIMER 0 - LOW BYTE                                      */
sfr at 0x8B TL1     ; /* TIMER 1 - LOW BYTE                                      */
sfr at 0x8C TH0     ; /* TIMER 0 - HIGH BYTE                                     */ 
sfr at 0x8D TH1     ; /* TIMER 1 - HIGH BYTE                                     */
sfr at 0x8E CKCON   ; /* CLOCK CONTROL                                           */
sfr at 0x8F PSCTL   ; /* PROGRAM STORE R/W CONTROL                               */
sfr at 0x90 P1      ; /* PORT 1                                                  */
sfr at 0x91 TMR3CN  ; /* TIMER 3 CONTROL                                         */
sfr at 0x92 TMR3RLL ; /* TIMER 3 RELOAD REGISTER - LOW BYTE                      */
sfr at 0x93 TMR3RLH ; /* TIMER 3 RELOAD REGISTER - HIGH BYTE                     */
sfr at 0x94 TMR3L   ; /* TIMER 3 - LOW BYTE                                      */
sfr at 0x95 TMR3H   ; /* TIMER 3 - HIGH BYTE                                     */
sfr at 0x96 P7      ; /* PORT 7                                                  */
sfr at 0x98 SCON0   ; /* SERIAL PORT 0 CONTROL                                   */
sfr at 0x99 SBUF0   ; /* SERIAL PORT 0 BUFFER                                    */
sfr at 0x9A SPI0CFG ; /* SERIAL PERIPHERAL INTERFACE 0 CONFIGURATION             */
sfr at 0x9B SPI0DAT ; /* SERIAL PERIPHERAL INTERFACE 0 DATA                      */
sfr at 0x9C ADC1    ; /* ADC 1 DATA                                              */
sfr at 0x9D SPI0CKR ; /* SERIAL PERIPHERAL INTERFACE 0 CLOCK RATE CONTROL        */
sfr at 0x9E CPT0CN  ; /* COMPARATOR 0 CONTROL                                    */
sfr at 0x9F CPT1CN  ; /* COMPARATOR 1 CONTROL                                    */
sfr at 0xA0 P2      ; /* PORT 2                                                  */
sfr at 0xA1 EMI0TC  ; /* EMIF TIMING CONTROL                                     */
sfr at 0xA3 EMI0CF  ; /* EXTERNAL MEMORY INTERFACE (EMIF) CONFIGURATION          */
sfr at 0xA4 P0MDOUT ; /* PORT 0 OUTPUT MODE CONFIGURATION                        */
sfr at 0xA5 P1MDOUT ; /* PORT 1 OUTPUT MODE CONFIGURATION                        */
sfr at 0xA6 P2MDOUT ; /* PORT 2 OUTPUT MODE CONFIGURATION                        */
sfr at 0xA7 P3MDOUT ; /* PORT 3 OUTPUT MODE CONFIGURATION                        */
sfr at 0xA8 IE      ; /* INTERRUPT ENABLE                                        */
sfr at 0xA9 SADDR0  ; /* SERIAL PORT 0 SLAVE ADDRESS                             */
sfr at 0xAA ADC1CN  ; /* ADC 1 CONTROL                                           */
sfr at 0xAB ADC1CF  ; /* ADC 1 ANALOG MUX CONFIGURATION                          */
sfr at 0xAC AMX1SL  ; /* ADC 1 ANALOG MUX CHANNEL SELECT                         */
sfr at 0xAD P3IF    ; /* PORT 3 EXTERNAL INTERRUPT FLAGS                         */
sfr at 0xAE SADEN1  ; /* SERIAL PORT 1 SLAVE ADDRESS MASK                        */
sfr at 0xAF EMI0CN  ; /* EXTERNAL MEMORY INTERFACE CONTROL                       */
sfr at 0xB0 P3      ; /* PORT 3                                                  */
sfr at 0xB1 OSCXCN  ; /* EXTERNAL OSCILLATOR CONTROL                             */
sfr at 0xB2 OSCICN  ; /* INTERNAL OSCILLATOR CONTROL                             */
sfr at 0xB5 P74OUT  ; /* PORTS 4 - 7 OUTPUT MODE                                 */
sfr at 0xB6 FLSCL   ; /* FLASH MEMORY TIMING PRESCALER                           */
sfr at 0xB7 FLACL   ; /* FLASH ACESS LIMIT                                       */
sfr at 0xB8 IP      ; /* INTERRUPT PRIORITY                                      */
sfr at 0xB9 SADEN0  ; /* SERIAL PORT 0 SLAVE ADDRESS MASK                        */
sfr at 0xBA AMX0CF  ; /* ADC 0 MUX CONFIGURATION                                 */
sfr at 0xBB AMX0SL  ; /* ADC 0 MUX CHANNEL SELECTION                             */
sfr at 0xBC ADC0CF  ; /* ADC 0 CONFIGURATION                                     */
sfr at 0xBD P1MDIN  ; /* PORT 1 INPUT MODE                                       */
sfr at 0xBE ADC0L   ; /* ADC 0 DATA - LOW BYTE                                   */
sfr at 0xBF ADC0H   ; /* ADC 0 DATA - HIGH BYTE                                  */
sfr at 0xC0 SMB0CN  ; /* SMBUS 0 CONTROL                                         */
sfr at 0xC1 SMB0STA ; /* SMBUS 0 STATUS                                          */
sfr at 0xC2 SMB0DAT ; /* SMBUS 0 DATA                                            */
sfr at 0xC3 SMB0ADR ; /* SMBUS 0 SLAVE ADDRESS                                   */
sfr at 0xC4 ADC0GTL ; /* ADC 0 GREATER-THAN REGISTER - LOW BYTE                  */
sfr at 0xC5 ADC0GTH ; /* ADC 0 GREATER-THAN REGISTER - HIGH BYTE                 */
sfr at 0xC6 ADC0LTL ; /* ADC 0 LESS-THAN REGISTER - LOW BYTE                     */
sfr at 0xC7 ADC0LTH ; /* ADC 0 LESS-THAN REGISTER - HIGH BYTE                    */
sfr at 0xC8 T2CON   ; /* TIMER 2 CONTROL                                         */
sfr at 0xC9 T4CON   ; /* TIMER 4 CONTROL                                         */
sfr at 0xCA RCAP2L  ; /* TIMER 2 CAPTURE REGISTER - LOW BYTE                     */
sfr at 0xCB RCAP2H  ; /* TIMER 2 CAPTURE REGISTER - HIGH BYTE                    */
sfr at 0xCC TL2     ; /* TIMER 2 - LOW BYTE                                      */
sfr at 0xCD TH2     ; /* TIMER 2 - HIGH BYTE                                     */
sfr at 0xCF SMB0CR  ; /* SMBUS 0 CLOCK RATE                                      */
sfr at 0xD0 PSW     ; /* PROGRAM STATUS WORD                                     */
sfr at 0xD1 REF0CN  ; /* VOLTAGE REFERENCE 0 CONTROL                             */
sfr at 0xD2 DAC0L   ; /* DAC 0 REGISTER - LOW BYTE                               */
sfr at 0xD3 DAC0H   ; /* DAC 0 REGISTER - HIGH BYTE                              */
sfr at 0xD4 DAC0CN  ; /* DAC 0 CONTROL                                           */
sfr at 0xD5 DAC1L   ; /* DAC 1 REGISTER - LOW BYTE                               */
sfr at 0xD6 DAC1H   ; /* DAC 1 REGISTER - HIGH BYTE                              */
sfr at 0xD7 DAC1CN  ; /* DAC 1 CONTROL                                           */
sfr at 0xD8 PCA0CN  ; /* PCA 0 COUNTER CONTROL                                   */
sfr at 0xD9 PCA0MD  ; /* PCA 0 COUNTER MODE                                      */
sfr at 0xDA PCA0CPM0; /* CONTROL REGISTER FOR PCA 0 MODULE 0                     */
sfr at 0xDB PCA0CPM1; /* CONTROL REGISTER FOR PCA 0 MODULE 1                     */
sfr at 0xDC PCA0CPM2; /* CONTROL REGISTER FOR PCA 0 MODULE 2                     */
sfr at 0xDD PCA0CPM3; /* CONTROL REGISTER FOR PCA 0 MODULE 3                     */
sfr at 0xDE PCA0CPM4; /* CONTROL REGISTER FOR PCA 0 MODULE 4                     */
sfr at 0xE0 ACC     ; /* ACCUMULATOR                                             */
sfr at 0xE1 XBR0    ; /* DIGITAL CROSSBAR CONFIGURATION REGISTER 0               */
sfr at 0xE2 XBR1    ; /* DIGITAL CROSSBAR CONFIGURATION REGISTER 1               */
sfr at 0xE3 XBR2    ; /* DIGITAL CROSSBAR CONFIGURATION REGISTER 2               */
sfr at 0xE4 RCAP4L  ; /* TIMER 4 CAPTURE REGISTER - LOW BYTE                     */
sfr at 0xE5 RCAP4H  ; /* TIMER 4 CAPTURE REGISTER - HIGH BYTE                    */
sfr at 0xE6 EIE1    ; /* EXTERNAL INTERRUPT ENABLE 1                             */
sfr at 0xE7 EIE2    ; /* EXTERNAL INTERRUPT ENABLE 2                             */
sfr at 0xE8 ADC0CN  ; /* ADC 0 CONTROL                                           */ 
sfr at 0xE9 PCA0L   ; /* PCA 0 TIMER - LOW BYTE                                  */ 
sfr at 0xEA PCA0CPL0; /* CAPTURE/COMPARE REGISTER FOR PCA 0 MODULE 0 - LOW BYTE  */
sfr at 0xEB PCA0CPL1; /* CAPTURE/COMPARE REGISTER FOR PCA 0 MODULE 1 - LOW BYTE  */
sfr at 0xEC PCA0CPL2; /* CAPTURE/COMPARE REGISTER FOR PCA 0 MODULE 2 - LOW BYTE  */
sfr at 0xED PCA0CPL3; /* CAPTURE/COMPARE REGISTER FOR PCA 0 MODULE 3 - LOW BYTE  */
sfr at 0xEE PCA0CPL4; /* CAPTURE/COMPARE REGISTER FOR PCA 0 MODULE 4 - LOW BYTE  */
sfr at 0xEF RSTSRC  ; /* RESET SOURCE                                            */
sfr at 0xF0 B       ; /* B REGISTER                                              */
sfr at 0xF1 SCON1   ; /* SERIAL PORT 1 CONTROL                                   */
sfr at 0xF2 SBUF1   ; /* SERAIL PORT 1 DATA                                      */
sfr at 0xF3 SADDR1  ; /* SERAIL PORT 1                                           */ 
sfr at 0xF4 TL4     ; /* TIMER 4 DATA - LOW BYTE                                 */
sfr at 0xF5 TH4     ; /* TIMER 4 DATA - HIGH BYTE                                */
sfr at 0xF6 EIP1    ; /* EXTERNAL INTERRUPT PRIORITY REGISTER 1                  */
sfr at 0xF7 EIP2    ; /* EXTERNAL INTERRUPT PRIORITY REGISTER 2                  */
sfr at 0xF8 SPI0CN  ; /* SERIAL PERIPHERAL INTERFACE 0 CONTROL                   */ 
sfr at 0xF9 PCA0H   ; /* PCA 0 TIMER - HIGH BYTE                                 */
sfr at 0xFA PCA0CPH0; /* CAPTURE/COMPARE REGISTER FOR PCA 0 MODULE 0 - HIGH BYTE */
sfr at 0xFB PCA0CPH1; /* CAPTURE/COMPARE REGISTER FOR PCA 0 MODULE 1 - HIGH BYTE */
sfr at 0xFC PCA0CPH2; /* CAPTURE/COMPARE REGISTER FOR PCA 0 MODULE 2 - HIGH BYTE */
sfr at 0xFD PCA0CPH3; /* CAPTURE/COMPARE REGISTER FOR PCA 0 MODULE 3 - HIGH BYTE */
sfr at 0xFE PCA0CPH4; /* CAPTURE/COMPARE REGISTER FOR PCA 0 MODULE 4 - HIGH BYTE */ 
sfr at 0xFF WDTCN   ; /* WATCHDOG TIMER CONTROL                                  */
    
   
/*  BIT Registers  */

/*  TCON  0x88 */
sbit at 0x88 IT0;              /* EXT. INTERRUPT 0 TYPE      */
sbit at 0x89 IE0;              /* EXT. INTERRUPT 0 EDGE FLAG */
sbit at 0x8A IT1;              /* EXT. INTERRUPT 1 TYPE      */
sbit at 0x8B IE1;              /* EXT. INTERRUPT 1 EDGE FLAG */
sbit at 0x8C TR0;              /* TIMER 0 ON/OFF CONTROL     */
sbit at 0x8D TF0;              /* TIMER 0 OVERFLOW FLAG      */
sbit at 0x8E TR1;              /* TIMER 1 ON/OFF CONTROL     */
sbit at 0x8F TF1;              /* TIMER 1 OVERFLOW FLAG      */

/*  SCON0  0x98 */
sbit at 0x98 RI0 ;             /* RECEIVE INTERRUPT FLAG              */ 
sbit at 0x99 TI0 ;             /* TRANSMIT INTERRUPT FLAG             */
sbit at 0x9A RB80;             /* RECEIVE BIT 8                       */
sbit at 0x9B TB80;             /* TRANSMIT BIT 8                      */
sbit at 0x9C REN0;             /* RECEIVE ENABLE                      */
sbit at 0x9D SM20;             /* MULTIPROCESSOR COMMUNICATION ENABLE */
sbit at 0x9E SM10;             /* SERIAL MODE CONTROL BIT 1           */
sbit at 0x9F SM00;             /* SERIAL MODE CONTROL BIT 0           */

/*  IE  0xA8 */
sbit at 0xA8 EX0;              /* EXTERNAL INTERRUPT 0 ENABLE  */  
sbit at 0xA9 ET0;              /* TIMER 0 INTERRUPT ENABLE     */         
sbit at 0xAA EX1;              /* EXTERNAL INTERRUPT 1 ENABLE  */  
sbit at 0xAB ET1;              /* TIMER 1 INTERRUPT ENABLE     */ 
sbit at 0xAC ES0;              /* UART0 INTERRUPT ENABLE       */
sbit at 0xAD ET2;              /* TIMER 2 INTERRUPT ENABLE     */
sbit at 0xAF EA;               /* GLOBAL INTERRUPT ENABLE      */ 

/*  IP  0xB8 */
sbit at 0xB8 PX0;              /* EXTERNAL INTERRUPT 0 PRIORITY */  
sbit at 0xB9 PT0;              /* TIMER 0 PRIORITY              */
sbit at 0xBA PX1;              /* EXTERNAL INTERRUPT 1 PRIORITY */
sbit at 0xBB PT1;              /* TIMER 1 PRIORITY              */
sbit at 0xBC PS0;              /* SERIAL PORT PRIORITY          */
sbit at 0xBD PT2;              /* TIMER 2 PRIORITY              */ 

/* SMB0CN 0xC0 */
sbit at 0xC0 SMBTOE ;          /* SMBUS 0 TIMEOUT ENABLE          */
sbit at 0xC1 SMBFTE ;          /* SMBUS 0 FREE TIMER ENABLE       */
sbit at 0xC2 AA     ;          /* SMBUS 0 ASSERT/ACKNOWLEDGE FLAG */
sbit at 0xC3 SI     ;          /* SMBUS 0 INTERRUPT PENDING FLAG  */
sbit at 0xC4 STO    ;          /* SMBUS 0 STOP FLAG               */
sbit at 0xC5 STA    ;          /* SMBUS 0 START FLAG              */
sbit at 0xC6 ENSMB  ;          /* SMBUS 0 ENABLE                  */
sbit at 0xC7 BUSY   ;          /* SMBUS 0 BUSY                    */


/*  T2CON  0xC8 */
sbit at 0xC8 CPRL2 ;           /* CAPTURE OR RELOAD SELECT     */
sbit at 0xC9 CT2   ;           /* TIMER OR COUNTER SELECT      */
sbit at 0xCA TR2   ;           /* TIMER 2 ON/OFF CONTROL       */
sbit at 0xCB EXEN2 ;           /* TIMER 2 EXTERNAL ENABLE FLAG */ 
sbit at 0xCC TCLK0 ;           /* UART0 TX CLOCK SOURCE        */
sbit at 0xCD RCLK0 ;           /* UART0 RX CLOCK SOURCE        */
sbit at 0xCE EXF2  ;           /* EXTERNAL FLAG                */
sbit at 0xCF TF2   ;           /* TIMER 2 OVERFLOW FLAG        */

/*  PSW 0xD0 */
sbit at 0xD0 P     ;           /* ACCUMULATOR PARITY FLAG */
sbit at 0xD1 F1    ;           /* USER FLAG 1             */
sbit at 0xD2 OV    ;           /* OVERFLOW FLAG           */
sbit at 0xD3 RS0   ;           /* REGISTER BANK SELECT 0  */
sbit at 0xD4 RS1   ;           /* REGISTER BANK SELECT 1  */
sbit at 0xD5 F0    ;           /* USER FLAG 0             */
sbit at 0xD6 AC    ;           /* AUXILIARY CARRY FLAG    */
sbit at 0xD7 CY    ;           /* CARRY FLAG              */ 

/* PCA0CN D8H */
sbit at 0xD8 CCF0  ;           /* PCA 0 MODULE 0 INTERRUPT FLAG */
sbit at 0xD9 CCF1  ;           /* PCA 0 MODULE 1 INTERRUPT FLAG */
sbit at 0xDA CCF2  ;           /* PCA 0 MODULE 2 INTERRUPT FLAG */
sbit at 0xDB CCF3  ;           /* PCA 0 MODULE 3 INTERRUPT FLAG */
sbit at 0xDC CCF4  ;           /* PCA 0 MODULE 4 INTERRUPT FLAG */
sbit at 0xDE CR    ;           /* PCA 0 COUNTER RUN CONTROL BIT */
sbit at 0xDF CF    ;           /* PCA 0 COUNTER OVERFLOW FLAG   */

/* ADC0CN E8H */
sbit at 0xE8 AD0LJST   ;       /* ADC 0 RIGHT JUSTIFY DATA BIT              */
sbit at 0xE9 AD0WINT   ;       /* ADC 0 WINDOW COMPARE INTERRUPT FLAG       */
sbit at 0xEA AD0CM0    ;       /* ADC 0 START OF CONVERSION MODE BIT 0      */
sbit at 0xEB AD0CM1    ;       /* ADC 0 START OF CONVERSION MODE BIT 1      */
sbit at 0xEC AD0BUSY   ;       /* ADC 0 BUSY FLAG                           */
sbit at 0xED AD0INT    ;       /* ADC 0 CONVERISION COMPLETE INTERRUPT FLAG */
sbit at 0xEE AD0TM     ;       /* ADC 0 TRACK MODE                          */
sbit at 0xEF AD0EN     ;       /* ADC 0 ENABLE                              */

/* SPI0CN F8H */
sbit at 0xF8 SPIEN    ;        /* SPI 0 SPI ENABLE           */   
sbit at 0xF9 MSTEN    ;        /* SPI 0 MASTER ENABLE        */
sbit at 0xFA SLVSEL   ;        /* SPI 0 SLAVE SELECT         */
sbit at 0xFB TXBSY    ;        /* SPI 0 TX BUSY FLAG         */
sbit at 0xFC RXOVRN   ;        /* SPI 0 RX OVERRUN FLAG      */
sbit at 0xFD MODF     ;        /* SPI 0 MODE FAULT FLAG      */
sbit at 0xFE WCOL     ;        /* SPI 0 WRITE COLLISION FLAG */
sbit at 0xFF SPIF     ;        /* SPI 0 INTERRUPT FLAG       */
