//-----------------------------------------------------------------------------
// F990_FlashPrimitives.h
//-----------------------------------------------------------------------------
// Copyright 2012 Silicon Laboratories, Inc.
// http://www.silabs.com
//
// Program Description:
//
// This program contains several useful utilities for writing and updating
// FLASH memory.
//
// Target:         C8051F99x/98x
// Tool chain:     Raisonance / Keil / SDCC
// Command Line:   None
//
// Release 1.0 / 15 JUN 2012 (ST)
//    -Initial Revision
//

#include <si_toolchain.h>

//-----------------------------------------------------------------------------
// Open Header #define
//-----------------------------------------------------------------------------

#ifndef _F990_FLASHPRIMITIVES_H_
#define _F990_FLASHPRIMITIVES_H_

//-----------------------------------------------------------------------------
// Structures, Unions, Enumerations, and Type Definitions
//-----------------------------------------------------------------------------

typedef uint16_t FLADDR;

//-----------------------------------------------------------------------------
// Global Constants
//-----------------------------------------------------------------------------

#define FLASH_SIZE  8                 // 8K or 4K or 2K

#ifndef FLASH_PAGESIZE
#define FLASH_PAGESIZE 512
#endif

//---------------------

#if (FLASH_SIZE == 8)

#ifndef FLASH_TEMP                     // Address of temp page
#define FLASH_TEMP 0x01C00L            // For 8K devices
#endif

#ifndef FLASH_LAST                     // Last page of FLASH
#define FLASH_LAST 0x01E00L            // For 8K devices
#endif

#endif

//---------------------

#if (FLASH_SIZE == 4)

#ifndef FLASH_TEMP                     // Address of temp page
#define FLASH_TEMP 0x00C00L            // For 4K devices
#endif

#ifndef FLASH_LAST                     // Last page of FLASH
#define FLASH_LAST 0x00E00L            // For 4K devices
#endif

#endif

//---------------------

#if (FLASH_SIZE == 2)

#ifndef FLASH_TEMP                     // Address of temp page
#define FLASH_TEMP 0x00400L            // For 2K devices
#endif

#ifndef FLASH_LAST                     // Last page of FLASH
#define FLASH_LAST 0x00600L            // For 2K devices
#endif

#endif


//-----------------------------------------------------------------------------
// Exported Function Prototypes
//-----------------------------------------------------------------------------

uint8_t   FLASH_ByteWrite (FLADDR addr, uint8_t byte);
uint8_t   FLASH_ByteRead  (FLADDR addr);
uint8_t   FLASH_PageErase (FLADDR addr);

//-----------------------------------------------------------------------------
// Close Header #define
//-----------------------------------------------------------------------------

#endif    // _F990_FLASHPRIMITIVES_H_

//-----------------------------------------------------------------------------
// End Of File
//-----------------------------------------------------------------------------