//-----------------------------------------------------------------------------
// F320_TimeCritical.c
//-----------------------------------------------------------------------------
// Copyright 2005 Silicon Laboratories, Inc.
// http://www.silabs.com
//
// Program Description:
//
// This module contains mixed C and assembly for time critical code portions.
// When it is compiled, it updates F320_TimeCritical.asm, which is included in
// the normal project build.  The code in this module is hand optimized to meet
// timing requirements for this specific application.  Modifications to this
// module should be kept to a minimum, or avoided entirely.
//
// FID:            32X000057
// Target:         C8051F320
// Tool chain:     KEIL C51 7.0.0.1 / KEIL A51 7.0.0.1
//                 Silicon Laboratories IDE version 2.3
// Command Line:   See Readme.txt
// Project Name:   F320_DEFAULT
//
// Release 1.0
//    -Initial Revision (PD)
//    -05 JUL 2006
//
//
//-----------------------------------------------------------------------------
// Preprocessor Directives
//-----------------------------------------------------------------------------

#pragma SRC(F320_TimeCritical.asm)

//-----------------------------------------------------------------------------
// Includes
//-----------------------------------------------------------------------------

#include "c8051f320.h"                 // SFR declarations
#include "F320_DEFAULT.h"              // Main project header
#include "F320_USB_Register.h"         // USB core register header
#include "F320_USB_Common.h"           // USB protocol header
#include "F320_USB_Descriptor.h"       // USB descriptor definitions

//-----------------------------------------------------------------------------
// Turn_On_Stream
//-----------------------------------------------------------------------------
//
// Return Value : None
// Parameters   : None
//
// This function purges the USB FIFO, and puts then puts the device's Vendor
// and product ID on the USB FIFO.  This ensures that a transmit complete
// interrupt will be generated while the F320 buffers the first millisecond of
// samples.  By putting this identification in the data stream, the host can
// be sure it is communicating with the correct USB audio device.
//
//-----------------------------------------------------------------------------
void Turn_On_Stream (void) using USB_REGISTER_BANK
{
    FIFO_Purge (3);                    // Index is set to 3 in this call

   #pragma asm

   USING 0;                            // Really using register bank 0

   PUSH  PSW;
   MOV   PSW,#00H;
   
   MOV   R1,#00H;                      // Reset read and write pointers
   MOV   R2,#00H;

   POLL10:
      MOV   A,USB0ADR;
      JB ACC.7,POLL10;                 // Wait for access to USB SIE
	MOV   USB0ADR,#023H;                // Configure to write endpoint 3 FIFO

   POLL11:
      MOV   A,USB0ADR;
      JB ACC.7,POLL11;                 // Wait for access to USB SIE
   MOV   A, #VID_LSB;
   MOV   USB0DAT, A;                   // Write vendor ID low byte

   POLL12:
      MOV   A,USB0ADR;
      JB ACC.7,POLL12;                 // Wait for access to USB SIE
   MOV   A, #VID_MSB;
   MOV   USB0DAT, A;                   // Write vendor ID high byte

   POLL13:
      MOV   A,USB0ADR;
      JB ACC.7,POLL13;                 // Wait for access to USB SIE
   MOV   A, #PID_LSB;
   MOV   USB0DAT, A;                   // Write product ID low byte

   POLL14:
      MOV   A,USB0ADR;
      JB ACC.7,POLL14;                 // Wait for access to USB SIE
   MOV   A, #PID_MSB;
   MOV   USB0DAT, A;                   // Write product ID high byte

   POP   PSW;

   #pragma endasm

   // Set rbInINPRDY to send data to host
   POLL_WRITE_BYTE (EINCSR1, rbInINPRDY);
               
   AMX0P = 0x09;                       // Positive input starts as P2.1, left
   ADC0L = 0x00;                       // Write zero values to ADC
   ADC0H = 0x80;

   // Enable Reset, and Suspend interrupts; Disable SOF interrupts
   POLL_WRITE_BYTE (CMIE, rbRSTINTE | rbSUSINTE);

   POLL_WRITE_BYTE (IN1IE,  0x09);     // Enable Endpoint 0 and 3 in interrupts


}

//-----------------------------------------------------------------------------
// Turn_Off_Stream
//-----------------------------------------------------------------------------
//
// Return Value : None
// Parameters   : None
//
// This routine stops is called when the device should stop sampling audio and
// be able to accept control commands from the host.
//
//-----------------------------------------------------------------------------
void Turn_Off_Stream (void) using USB_REGISTER_BANK
{
   TR2 = OFF;

   POLL_WRITE_BYTE (IN1IE,  0x01);     // Enable Endpoint 0 interrupts only

   FIFO_Purge (3);                     // Index is set to 3 in this call


   // Enable SOF, Reset, and Suspend interrupt
   POLL_WRITE_BYTE (CMIE, rbSOFE | rbRSTINTE | rbSUSINTE);
   
}

//-----------------------------------------------------------------------------
// End Of File
//-----------------------------------------------------------------------------