//-----------------------------------------------------------------------------
// F320_USB_Common.h
//-----------------------------------------------------------------------------
// Copyright 2005 Silicon Laboratories, Inc.
// http://www.silabs.com
//
// Program Description:
//
// This is the header file for USB protocol and associated software.
//
// FID:            32X000076
// Target:         C8051F320
// Tool chain:     KEIL C51 7.0.0.1
//                 Silicon Laboratories IDE version 2.3
// Command Line:   See Readme.txt
// Project Name:   F320_TONE_GENERATOR
//
// Release 1.0
//    -Initial Revision (PD)
//    -05 JUL 2006
//

#ifndef F320_USB_COMMON_H_
#define F320_USB_COMMON_H_

//-----------------------------------------------------------------------------
// Constants
//-----------------------------------------------------------------------------

// Standard Descriptor Types
#define DSC_DEVICE      0x01           // Device Descriptor
#define DSC_CONFIG      0x02           // Configuration Descriptor
#define DSC_STRING      0x03           // String Descriptor
#define DSC_INTERFACE   0x04           // Interface Descriptor
#define DSC_ENDPOINT    0x05           // Endpoint Descriptor
#define DSC_HID_CLASS   0x21           // HID Class Descriptor
#define DSC_HID_REPORT  0x22           // HID Report Descriptor

// Standard Request Codes
#define GET_STATUS        0x00         // Code for Get Status
#define CLEAR_FEATURE     0x01         // Code for Clear Feature
#define SET_FEATURE       0x03         // Code for Set Feature
#define SET_ADDRESS       0x05         // Code for Set Address
#define GET_DESCRIPTOR    0x06         // Code for Get Descriptor
#define SET_DESCRIPTOR    0x07         // Code for Set Descriptor(not used)
#define GET_CONFIGURATION 0x08         // Code for Get Configuration
#define SET_CONFIGURATION 0x09         // Code for Set Configuration
#define GET_INTERFACE     0x0A         // Code for Get Interface
#define SET_INTERFACE     0x0B         // Code for Set Interface
#define SYNCH_FRAME       0x0C         // Code for Synch Frame(not used)

// HID Request Codes
#define GET_REPORT     0x01            // Code for Get Report
#define GET_IDLE       0x02            // Code for Get Idle
#define GET_PROTOCOL   0x03            // Code for Get Protocol
#define SET_REPORT     0x09            // Code for Set Report
#define SET_IDLE       0x0A            // Code for Set Idle
#define SET_PROTOCOL   0x0B            // Code for Set Protocol

// Audio Request Codes
#define GET_CUR  0x81                  // Code for Get Current Value
#define SET_CUR  0x01                  // Code for Get Current Value

// Define device states
#define DEV_ATTACHED    0x00           // Device is in Attached State
#define DEV_POWERED     0x01           // Device is in Powered State
#define DEV_DEFAULT     0x02           // Device is in Default State
#define DEV_ADDRESS     0x03           // Device is in Addressed State
#define DEV_CONFIGURED  0x04           // Device is in Configured State
#define DEV_SUSPENDED   0x05           // Device is in Suspended State

// Define bmRequestType bitmaps
#define IN_DEVICE       0x00           // In request made to device
#define OUT_DEVICE      0x80           // Out request made to device
#define IN_INTERFACE    0x01           // In request made to interface
#define OUT_INTERFACE   0x81           // Out request made to interface
#define IN_ENDPOINT     0x02           // In request made to endpoint
#define OUT_ENDPOINT    0x82           // Out request made to endpoint

#define TYPE_MASK    0x60              // Mask for type bitfield
#define CLASS_TYPE   0x20              // Type for class-specific requests

// Define wIndex bitmaps
#define IN_EP1    0x81                 // Index values used by Set and Clear
#define OUT_EP1   0x01                 // feature commands for Endpoint_Halt
#define IN_EP2    0x82
#define OUT_EP2   0x02
#define IN_EP3    0x83
#define OUT_EP3   0x03

// Define wValue bitmaps for Standard Feature Selectors
#define DEVICE_REMOTE_WAKEUP  0x0001   // Remote wakeup feature(not used)
#define ENDPOINT_HALT         0x0000   // Endpoint_Halt feature selector

// Define Endpoint States
#define EP_IDLE      0x00              // This signifies Endpoint Idle State
#define EP_TX        0x01              // Endpoint Transmit State
#define EP_RX        0x02              // Endpoint Receive State
#define EP_HALT      0x03              // Endpoint Halt State
#define EP_STALL     0x04              // Endpoint Stall State
#define EP_ADDRESS   0x05              // Endpoint Address

//-----------------------------------------------------------------------------
// Type Definitions
//-----------------------------------------------------------------------------

// BYTE type definition
#ifndef BYTE_DEF_
#define BYTE_DEF_
typedef unsigned char BYTE;
#endif // BYTE_DEF_

// UINT type definition
#ifndef UINT_DEF_
#define UINT_DEF_
typedef unsigned int UINT;
#endif // UINT_DEF_

//-----------------------------------------------------------------------------
// External Variable Declaration
//-----------------------------------------------------------------------------

extern idata BYTE USB_State;           // Holds the USB State
extern idata unsigned int DataSize;    // Size of data to return
extern idata unsigned int DataSent;    // Amount of data sent
extern idata BYTE* DataPtr;            // Pointer to data to return
extern idata BYTE Ep_Status[];         // Endpoint status array

extern idata BYTE ReturnBuffer[];      // Buffer for HID commands

extern code const BYTE Host_Data[];    // Storage of Si470x data registers

//-----------------------------------------------------------------------------
// Function Prototypes
//-----------------------------------------------------------------------------

// USB Routines
void Usb_Reset (void);                 // Called after USB bus reset
void Handle_Setup (void);              // Handle setup packet on Endpoint 0
void Handle_Out2 (void);               // Handle out packet on Endpoint 2
void Handle_In3 (void);                // Handle in packet on Endpoint 3
void Usb_Suspend (void);               // This routine called for USB suspend

// Standard Requests
void Get_Status (void);                // These are called for each specific
void Clear_Feature (void);             // USB standard request
void Set_Feature (void);
void Set_Address (void);
void Get_Descriptor (void);
void Get_Configuration (void);
void Set_Configuration (void);
void Get_Interface (void);
void Set_Interface (void);

// HID Requests
void Set_Idle (void);
void Get_Report (void);
void Set_Report (void);
void Handle_Set_Report (void);

// Audio Requests
void Get_Cur (void);
void Set_Cur (void);

// Other Routines
void Write_Custom_Data (void);
void Timer2_ISR (void);                // Called when Timer 2 overflows
void Usb_ISR (void);                   // Called to determine type of interrupt
void FIFO_Read (BYTE, UINT, BYTE *);   // Used for multiple byte FIFO reads
void FIFO_Write (BYTE, UINT, BYTE *);  // Used for multiple byte FIFO writes
void FIFO_Purge (BYTE);                // Purges data from the selected FIFO
void Force_Stall (void);               // Forces a procedural stall on EP0
void Turn_On_Stream (void);            // Starts audio stream
void Turn_Off_Stream (void);           // Stops audio stream
void Delay_USB (void);                 // Approximately 500 uS (24 Mhz sysclk)

#endif // F320_USB_COMMON_H_
//-----------------------------------------------------------------------------
// End Of File
//-----------------------------------------------------------------------------