//-----------------------------------------------------------------------------
// F320_USB_Descriptor.h
//-----------------------------------------------------------------------------
// Copyright 2005 Silicon Laboratories, Inc.
// http://www.silabs.com
//
// Program Description:
//
// This is the header file containing structures used for USB enumeration.
//
// FID:            32X000077
// Target:         C8051F320
// Tool chain:     KEIL C51 7.0.0.1
//                 Silicon Laboratories IDE version 2.3
// Command Line:   See Readme.txt
// Project Name:   F320_TONE_GENERATOR
//
// Release 1.0
//    -Initial Revision (PD)
//    -05 JUL 2006
//

#ifndef F320_USB_DESCRIPTOR_H_
#define F320_USB_DESCRIPTOR_H_

//-----------------------------------------------------------------------------
// Constants
//-----------------------------------------------------------------------------

#define VID       0x10C4
#define PID       0x8170
#define VID_LSB   0xC4
#define VID_MSB   0x10
#define PID_LSB   0xD5
#define PID_MSB   0x81

// Changes to these constants only changes USB descriptors
#define HID_REPORT_SIZE 0x0008
#define EP0_PACKET_SIZE 0x40

//-----------------------------------------------------------------------------
// Macros
//-----------------------------------------------------------------------------

#define HIGH_BYTE(data16) ((data16 & 0xFF00) >> 8)
#define LOW_BYTE(data16) (data16 & 0xFF)
#define LE(data16) (HIGH_BYTE(data16) | (LOW_BYTE(data16) << 8))

//-----------------------------------------------------------------------------
// Type Definitions
//-----------------------------------------------------------------------------

// BYTE type definition
#ifndef BYTE_DEF_
#define BYTE_DEF_
typedef unsigned char BYTE;
#endif // BYTE_DEF_

// WORD type definition, for KEIL Compiler
#ifndef WORD_DEF_
#define WORD_DEF_
typedef union {unsigned int i; unsigned char c[2];} WORD;
#define LSB 1
#define MSB 0
#endif // WORD_DEF_

// BYTE3 type definition
#ifndef BYTE3_DEF_
#define BYTE3_DEF_
typedef unsigned char BYTE3[3];
#endif // BYTE3_DEF_

// Standard Device Descriptor Type Definition
typedef struct
{
   BYTE bLength;                       // Size of this descriptor (=0x12)
   BYTE bDescriptorType;               // Descriptor type (=0x01)
   WORD bcdUSB;                        // USB spec release number in BCD
   BYTE bDeviceClass;                  // Device class code
   BYTE bDeviceSubClass;               // Device subclass code
   BYTE bDeviceProtocol;               // Device protocol code
   BYTE bMaxPacketSize0;               // Maximum packet size for EP0
   WORD idVendor;                      // Vendor ID
   WORD idProduct;                     // Product ID
   WORD bcdDevice;                     // Device release number in BCD
   BYTE iManufacturer;                 // Index of manufacturer string
   BYTE iProduct;                      // Index of product string
   BYTE iSerialNumber;                 // Index of serial number string
   BYTE bNumConfigurations;            // Number of possible configurations
} device_descriptor;                   // End of device_descriptor

// Standard Configuration Descriptor Type Definition
typedef struct
{
   BYTE bLength;                       // Size of this descriptor (=0x09)
   BYTE bDescriptorType;               // Descriptor type (=0x02)
   WORD wTotalLength;                  // Total length of configuration data
   BYTE bNumInterfaces;                // Number of interfaces supported
   BYTE bConfigurationValue;           // Designator value for *this* config
   BYTE iConfiguration;                // Index of configuration string
   BYTE bmAttributes;                  // Configuration characteristics
   BYTE bMaxPower;                     // Maximum power consumption (*2mA)
} configuration_descriptor;            // End of configuration_descriptor

// Standard Interface Descriptor Type Definition
typedef struct
{
   BYTE bLength;                       // Size of this descriptor (=0x09)
   BYTE bDescriptorType;               // Descriptor type (=0x04)
   BYTE bInterfaceNumber;              // Number of *this* interface (0..)
   BYTE bAlternateSetting;             // Alternative for this interface
   BYTE bNumEndpoints;                 // No of EPs used by this interface
   BYTE bInterfaceClass;               // Interface class code
   BYTE bInterfaceSubClass;            // Interface subclass code
   BYTE bInterfaceProtocol;            // Interface protocol code
   BYTE iInterface;                    // Index of interface string
} interface_descriptor;                // End of interface_descriptor

// Standard Endpoint Descriptor Type Definition
typedef struct
{
   BYTE bLength;                       // Size of this descriptor (=0x07)
   BYTE bDescriptorType;               // Descriptor type (=0x05)
   BYTE bEndpointAddress;              // Endpoint address (number + direction)
   BYTE bmAttributes;                  // Endpoint attributes (transfer type)
   WORD wMaxPacketSize;	               // Maximum endpoint packet size
   BYTE bInterval;                     // Polling interval milliseconds
} endpoint_descriptor;                 // End of endpoint_descriptor

// Audio Class-Specific Header Descriptor Type Definition
typedef struct
{
   BYTE bLength;                       // Size of this descriptor (=0x09)
   BYTE bDescriptorType;               // Descriptor type (=0x24, CS_INTERFACE)
   BYTE bDescriptorSubtype;            // Descriptor subtype (=0x01)
   WORD bcdADC;                        // Revision of class specification
   WORD wTotalLength;                  // Total size of audio descriptors
   BYTE bInCollection;                 // Number of streaming interfaces
   BYTE baInterfaceNr;                 // Interface number of stream interface
} audio_header_descriptor;             // End of audio_header_descriptor

// Audio Class-Specific Input Terminal Descriptor Type Definition
typedef struct
{
   BYTE bLength;                       // Size of this descriptor (=0x0C)
   BYTE bDescriptorType;               // Descriptor type (=0x24, CS_INTERFACE)
   BYTE bDescriptorSubtype;            // Descriptor subtype (=0x02)
   BYTE bTerminalID;                   // Unique terminal identification
   WORD wTerminalType;                 // Audio terminal type
   BYTE bAssocTerminal;                // TerminalID of associated terminal
   BYTE bNrChannels;                   // Number of logical channels
   WORD wChannelConfig;                // Channel configuration
   BYTE iChannelNames;                 // Index of channel string
   BYTE iTerminal;                     // Index of terminal string
} input_terminal_descriptor;           // End of input_terminal_descriptor

// Audio Class-Specific Feature Unit Descriptor Type Definition
typedef struct
{
   BYTE bLength;                       // Size of this descriptor (=0x0D)
   BYTE bDescriptorType;               // Descriptor type (=0x24, CS_INTERFACE)
   BYTE bDescriptorSubtype;            // Descriptor subtype (=0x06)
   BYTE bUnitID;                       // Unique unit identification
   BYTE bSourceID;                     // ID of connected terminal or unit
   BYTE bControlSize;                  // Size of bmaControl element
   WORD bmaControlMaster;              // Master control bitmask
   WORD bmaControlLogical1;            // Logical channel 1 control bitmask
   WORD bmaControlLogical2;            // Logical channel 2 control bitmask
   BYTE iFeature;                      // Index of feature unit string
} feature_unit_descriptor;             // End of feature_unit_descriptor

// Audio Class-Specific Output Terminal Descriptor Type Definition
typedef struct
{
   BYTE bLength;                       // Size of this descriptor (=0x09)
   BYTE bDescriptorType;               // Descriptor type (=0x24, CS_INTERFACE)
   BYTE bDescriptorSubtype;            // Descriptor subtype (=0x03)
   BYTE bTerminalID;                   // Unique terminal identification
   WORD wTerminalType;                 // Audio terminal type
   BYTE bAssocTerminal;                // TerminalID of associated terminal
   BYTE bSourceID;                     // Terminal ID of source
   BYTE iTerminal;                     // Index of terminal string
} output_terminal_descriptor;          // End of output_terminal_descriptor

// Audio Class-Specific Stream Interface Descriptor Type Definition
typedef struct
{
   BYTE bLength;                       // Size of this descriptor (=0x07)
   BYTE bDescriptorType;               // Descriptor Type (=0x24, CS_INTERFACE)
   BYTE bDescriptorSubtype;            // Descriptor subtype (=0x01)
   BYTE bTerminalLink;                 // ID of associated terminal
   BYTE bDelay;                        // Interface delay
   WORD wFormatTag;                    // Stream format
} stream_interface_descriptor;         // End of stream_interface_descriptor

// Audio Class-Specific Type I Format Descriptor Type Definition
typedef struct
{
   BYTE bLength;                       // Size of this descriptor (=0x0B)
   BYTE bDescriptorType;               // Descriptor Type (=0x24, CS_INTERFACE)
   BYTE bDescriptorSubtype;            // Descriptor subtype (=0x02)
   BYTE bFormatType;                   // Stream format type (=0x01, TYPE_I)
   BYTE bNrChannels;                   // Number of logical channels
   BYTE bSubFrameSize;                 // Number of bytes/audio subframe
   BYTE bBitResolution;                // Number of bits/audio subframe
   BYTE bSamFreqType;                  // Number of sampling frequencies
   BYTE3 bSamFreq;                     // Sampling frequency
} typeI_format_descriptor;             // End of typeI_format_descriptor

// Streaming Endpoint Descriptor Type Definition
typedef struct
{
   BYTE bLength;                       // Size of this descriptor (=0x09)
   BYTE bDescriptorType;               // Descriptor Type (=0x05)
   BYTE bEndpointAddress;              // Endpoint address (number + direction)
   BYTE bmAttributes;                  // Endpoint attributes (transfer type)
   WORD wMaxPacketSize;	               // Maximum endpoint packet size
   BYTE bInterval;                     // Polling interval milliseconds
   BYTE bRefresh;                      // Reset to 0
   BYTE bSynchAddress;                 // Synchronization endpoint number
} stream_endpoint_descriptor;          // End of stream_endpoint_descriptor

// Audio Class-Specific Endpoint Descriptor Type Definition
typedef struct
{
   BYTE bLength;                       // Size of this descriptor (=0x07)
   BYTE bDescriptorType;               // Descriptor type (=0x25, CS_ENDPOINT)
   BYTE bDescriptorSubtype;            // Descriptor subtype (=0x01)
   BYTE bmAttributes;                  // Endpoint attributes
   BYTE bLockDelayUnits;               // Units used for wLockDelay
   WORD wLockDelay;                    // Time for clock recovery lock
} audio_endpoint_descriptor;           // End of audio_endpoint_descriptor

// HID Class-Specific Descriptor Type Definition
typedef struct
{
   BYTE bLength;                       // Size of this descriptor (=0x09)
   BYTE bDescriptorType;               // Descriptor type (=0x21)
   WORD bcdHID;                        // HID spec release number in BCD
   BYTE bCountryCode;                  // Country code of localized hardware
   BYTE bNumDescriptors;               // Number of class descriptors
   BYTE bClassDescriptorType;          // Type of class descriptor
   WORD wDescriptorLength;             // Total size of report descriptor
} hid_descriptor;                      // End of hid_descriptor

// HID Report Descriptor Type Definition
// Note: this descriptor is implemented as a byte array versus a structure
// due to the variable content and format of the report descriptor
typedef struct
{
   BYTE Array[HID_REPORT_SIZE];        // Array for report descriptor elements
} hid_report_descriptor;               // End of hid_report_descriptor

// Complete Configuration Descriptor Definition
typedef struct
{
   configuration_descriptor cd;        // Configuration descriptor
   interface_descriptor id0;           // Audio control interface
   audio_header_descriptor ahd;        // Audio control header
   input_terminal_descriptor itd;      // Audio input terminal
   feature_unit_descriptor fud;        // Audio feature unit
   output_terminal_descriptor otd;     // Audio output terminal
   interface_descriptor id1_0;         // Audio zero-bandwidth interface
   interface_descriptor id1_1;         // Audio streaming interface
   stream_interface_descriptor sid;    // Audio stream descriptor
   typeI_format_descriptor tfd;        // Audio format descriptor
   stream_endpoint_descriptor sed;     // Streaming endpoint descriptor
   audio_endpoint_descriptor aed;      // Audio endpoint descriptor
   interface_descriptor id2;           // HID interface descriptor
   hid_descriptor hd;                  // HID descriptor
   endpoint_descriptor ed1;            // GET_REPORT input endpoint
   endpoint_descriptor ed2;            // SET_REPORT output endpoint
} complete_configuration;              // End of complete_configuration

// Setup Buffer Type Definition
typedef struct
{
   BYTE bmRequestType;                 // Recipient, type, and direction
   BYTE bRequest;                      // Specific standard request number
   WORD wValue;                        // Varies according to request
   WORD wIndex;                        // Varies according to request
   WORD wLength;                       // Number of bytes to transfer
} setup_buffer;                        // End of setup_buffer

//-----------------------------------------------------------------------------
// External Variable Declaration
//-----------------------------------------------------------------------------

extern code const BYTE ONES_PACKET[2]; // These are response packets used
extern code const BYTE ZERO_PACKET[2]; // for communication with host

extern idata setup_buffer Setup;       // Buffer for device request
extern code const device_descriptor DeviceDesc;
extern code const complete_configuration ConfigDesc;
extern code const hid_report_descriptor HidReportDesc;
extern code const BYTE* StringDescTable[];

#endif // F320_USB_DESCRIPTOR_H_
//-----------------------------------------------------------------------------
// End Of File
//-----------------------------------------------------------------------------