// USBAudioDevice.h: interface for the CUSBAudioDevice class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_USBAudioDEVICE_H__6F0D8129_C34F_4CBC_93A0_EC3F2F68A8D1__INCLUDED_)
#define AFX_USBAudioDEVICE_H__6F0D8129_C34F_4CBC_93A0_EC3F2F68A8D1__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

///////////////////////////
//
// DDK Includes:
// These files are found in the DDK, if you are not using
// the 6001.18002 version then go to Project->USBAudio properties
// and adjust the include directories
//
#include "initguid.h"

#define MAX_LOADSTRING 256

extern "C" {
#include "hidsdi.h"
}
#include "setupapi.h"
#include <dbt.h>
//
///////////////////////////

#include "mmsystem.h"
#include <windows.h>

//#include "USBAudioBootloader.h"
//#include "RDSData.h"

#define MAX_USB_DEVICES	64

//Device data
#define USBAudio_VID	0x10C4
#define USBAudio_PID	0x819A

#define USBAudio_SW_VERSION		6
#define USBAudio_HW_VERSION		1

//Audio data
#define SAMPLES_PER_SECOND	24000
//#define SAMPLES_PER_SECOND	96000
//#define SAMPLES_PER_SECOND	24000
#define BITS_PER_SAMPLE		16
#define CHANNELS			2

//Our stream data should be in 20 blocks at 32KB each
#define BLOCK_SIZE		32768
#define BLOCK_COUNT		20
#define BUFFER_PADDING	19

//Return Codes
#define STATUS_OK					0x00
#define STATUS_ERROR				0x01
#define STATUS_OUTPUTAUDIO_ERROR	0x02
#define STATUS_USBAudioAUDIO_ERROR	0x03
#define STATUS_USBAudioDATA_ERROR	0x04
#define STATUS_BOOTLOAD_ERROR		0x05

//Register definitions
#define USBAudio_REGISTER_NUM	16
#define RDS_REGISTER_NUM		6

#define USBAudio_REGISTER	WORD
#define USBAudio_REGISTER_SIZE	sizeof(USBAudio_REGISTER)

#define DEVICEID		0
#define CHIPID			1
#define POWERCFG		2
#define CHANNEL			3
#define SYSCONFIG1		4
#define SYSCONFIG2		5
#define SYSCONFIG3		6
#define TEST1			7
#define TEST2			8
#define BOOTCONFIG		9
#define STATUSRSSI		10
#define READCHAN		11
#define RDSA			12
#define RDSB			13
#define RDSC			14
#define RDSD			15

//Bit definitions
#define DEVICEID_PN		0xF000
#define DEVICEID_MFGID	0x0FFF

#define CHIPID_REV		0xFC00
#define CHIPID_DEV		0x0200
#define CHIPID_FIRMWARE	0x01FF

#define POWERCFG_DMUTE		0x4000
#define POWERCFG_MONO		0x2000
#define POWERCFG_SEEKUP		0x0200
#define POWERCFG_SEEK		0x0100
#define POWERCFG_DISABLE	0x0040
#define POWERCFG_ENABLE		0x0001

#define CHANNEL_TUNE	0x8000
#define CHANNEL_CHAN	0x03FF

#define SYSCONFIG1_DE		0x0800
#define SYSCONFIG1_RDS		0x1000

#define SYSCONFIG2_SEEKTH	0xFF00
#define SYSCONFIG2_BAND		0x0080
#define SYSCONFIG2_SPACE	0x0030
#define SYSCONFIG2_VOLUME	0x000F

#define SYSCONFIG2_SPACE_200KHZ	0x0000
#define SYSCONFIG2_SPACE_100KHZ	0x0010
#define SYSCONFIG2_SPACE_50KHZ	0x0020

#define STATUSRSSI_RDSR		0x8000
#define STATUSRSSI_STC		0x4000
#define STATUSRSSI_SF		0x2000
#define STATUSRSSI_ST		0x0100
#define STATUSRSSI_RSSI		0x00FF

#define READCHAN_READCHAN	0x03FF

//Scratch page
#define SCRATCH_PAGE_SIZE		63
#define SCRATCH_PAGE_USED_SIZE	22
typedef BYTE	SCRATCH_PAGE[SCRATCH_PAGE_SIZE];

#define SCRATCH_PAGE_SW_VERSION	1
#define SCRATCH_PAGE_HW_VERSION	2

//Report definitions
#define DEVICEID_REPORT		DEVICEID + 1
#define CHIPID_REPORT		CHIPID + 1
#define POWERCFG_REPORT		POWERCFG + 1
#define CHANNEL_REPORT		CHANNEL + 1
#define SYSCONFIG1_REPORT	SYSCONFIG1 + 1
#define SYSCONFIG2_REPORT	SYSCONFIG2 + 1
#define SYSCONFIG3_REPORT	SYSCONFIG3 + 1
#define TEST1_REPORT		TEST1 + 1
#define TEST2_REPORT		TEST2 + 1
#define BOOTCONFIG_REPORT	BOOTCONFIG + 1
#define STATUSRSSI_REPORT	STATUSRSSI + 1
#define READCHAN_REPORT		READCHAN + 1
#define RDSA_REPORT			RDSA + 1
#define RDSB_REPORT			RDSB + 1
#define RDSC_REPORT			RDSC + 1
#define RDSD_REPORT			RDSD + 1
#define LED_REPORT			19
#define SCRATCH_REPORT		20

#define ENTIRE_REPORT		USBAudio_REGISTER_NUM + 1
#define RDS_REPORT			USBAudio_REGISTER_NUM + 2

#define REGISTER_REPORT_SIZE	(USBAudio_REGISTER_SIZE + 1)
#define ENTIRE_REPORT_SIZE		((USBAudio_REGISTER_NUM * USBAudio_REGISTER_SIZE) + 1)
#define RDS_REPORT_SIZE			((RDS_REGISTER_NUM * USBAudio_REGISTER_SIZE) + 1)
#define LED_REPORT_SIZE			3
#define SCRATCH_REPORT_SIZE		(SCRATCH_PAGE_SIZE + 1)

//LED State definitions
#define LED_COMMAND			0x35

#define NO_CHANGE_LED		0x00
#define ALL_COLOR_LED		0x01
#define BLINK_GREEN_LED		0x02
#define BLINK_RED_LED		0x04
#define BLINK_ORANGE_LED	0x10
#define SOLID_GREEN_LED		0x20
#define SOLID_RED_LED		0x40
#define SOLID_ORANGE_LED	0x80

#define CONNECT_STATE		BLINK_GREEN_LED
#define DISCONNECT_STATE	BLINK_ORANGE_LED
#define BOOTLOAD_STATE		SOLID_RED_LED
#define STREAMING_STATE		ALL_COLOR_LED
#define TUNING_STATE		SOLID_GREEN_LED
#define SEEKING_STATE		SOLID_GREEN_LED

//Function definitions
#define SEEK_UP		true
#define SEEK_DOWN	false

#define TUNE_UP		true
#define TUNE_DOWN	false

//Volume Definitions
#define VOLUME_MIN	0		//0% - 100%
#define VOLUME_MAX	100

#define	POLL_TIMEOUT_SECONDS		3
#define DISCONNECT_TIMEOUT_SECONDS	15

#define MAX_SEEK_THRESHOLD			63
#define PREFERRED_SEEK_THRESHOLD	31

//Global variables for the critical section and 
//free block count, used by callback functions
static CRITICAL_SECTION gWaveCriticalSection;
static volatile BYTE gWaveFreeBlockCount;

//Global callback function for when wave out terminates
static void CALLBACK waveOutProc(HWAVEOUT hwo, UINT uMsg, DWORD dwInstance, DWORD dwParam1, DWORD dwParam2);

#define PRESET_NUM	12

//Structure that contains all useful data about the device - filled from the scratch page
typedef struct AudioData
{
	BYTE monoStereo;

} AudioData;

//Structure that contains the RDS data
typedef struct RDSData
{
	double currentStation;
	BYTE recievedSignalStrength;
	BYTE monoStereo;
} RDSData;

//Values used within the AudioData structure to assign values to the band, spacing, deemphasis, and gui options

#define DATA_MONOSTEREO			0x10
#define DATA_MONOSTEREO_STEREO	0x00
#define DATA_MONOSTEREO_MONO	0x10

class CUSBAudioDevice  
{
public:
	CUSBAudioDevice();
	virtual ~CUSBAudioDevice();

//////////////////////
//Global Functionality

	BYTE	OpenUSBAudio(AudioData* audioData);
	bool	CloseUSBAudio();

//////////////////////
//////////////////////

///////////////////////
//USB HID Functionality

//	bool BootloadDevice(AudioData* AudioData);
	
	bool	StopStream(bool stop);
private:
	bool	OpenUSBAudioData();
	bool	CloseUSBAudioData();

	HANDLE	m_USBAudioDataHandle;

	BYTE*	m_pEndpoint0ReportBuffer;
	DWORD	m_Endpoint0ReportBufferSize;

	BYTE*	m_pEndpoint1ReportBuffer;
	DWORD	m_Endpoint1ReportBufferSize;

	BYTE*	m_pEndpoint2ReportBuffer;
	DWORD	m_Endpoint2ReportBufferSize;

	USBAudio_REGISTER	m_Register[USBAudio_REGISTER_NUM];
	SCRATCH_PAGE		m_ScratchPage;


////////////////////////
////////////////////////

//////////////////////////
//USB Audio  Functionality

public:
	void	StreamAudio();
	bool	IsStreaming();
	bool	IsTuning();
	BYTE	GetWaveOutVolume();
	bool	SetWaveOutVolume(BYTE level);
	UINT    GetCurrentBlock(void);
	UINT    GetFreeBlock(void);
	long    GetOut_Count(void);
	long    GetIn_Count(void);

private:
	bool	OpenUSBAudioAudio();
	bool	OpenSoundCard();
	void	InitializeStream();
	bool	CloseUSBAudioAudio();	
	bool	CloseSoundCard();

	long    In_Count;
	long    Out_Count;

	HWAVEIN		m_USBAudioAudioHandle;
	HWAVEOUT	m_SoundCardHandle;

	WAVEHDR		m_InputHeader;
	WAVEHDR*	m_OutputHeader;
	char*		m_WaveformBuffer;

	bool		m_Streaming;
	bool		m_Tuning;
	int			m_CurrentBlock;
	int			m_FreeBlock;

	//void	(*pStreamAudio)();

	bool	StreamAudioIn();
	bool	StreamAudioOut();
	bool	ChangeLED(BYTE ledState);

	WAVEHDR*	AllocateBlocks(int size, int count);
	void		FreeBlocks(WAVEHDR*);

////////////////////////////
////////////////////////////
};

#endif // !defined(AFX_USBAudioDEVICE_H__6F0D8129_C34F_4CBC_93A0_EC3F2F68A8D1__INCLUDED_)

