// USBAudioDlg.cpp : implementation file
//

#include "stdafx.h"
#include "USBAudio.h"
#include "USBAudioDlg.h"
#include ".\USBAudiodlg.h"
//#include "USBAudioDevice.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

#define Audio_Stream 2
#define Audio_Stream_Time 2
#define Screen_Refresh 3
#define Screen_Refresh_Time 1

// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	enum { IDD = IDD_ABOUTBOX };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support


// Implementation
protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
END_MESSAGE_MAP()


// CUSBAudioDlg dialog



CUSBAudioDlg::CUSBAudioDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CUSBAudioDlg::IDD, pParent)
	, m_DEBUG_InBuffer(0)
	, m_DEBUG_Out_Buffer(0)
	, m_DEBUG_3(0)
	, m_In_Count(0)
	, m_Out_Count(0)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CUSBAudioDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CUSBAudioDlg, CDialog)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_TIMER()
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_BUTTON1, OnBnClickedButton1)
	ON_BN_CLICKED(IDCANCEL, OnBnClickedCancel)
END_MESSAGE_MAP()


// CUSBAudioDlg message handlers

BOOL CUSBAudioDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	Connected = false;
	m_AudioData.monoStereo = DATA_MONOSTEREO_STEREO;
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CUSBAudioDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CUSBAudioDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

void CUSBAudioDlg::OnTimer(UINT nIDEvent) 
{
	switch (nIDEvent)
	{
	case Audio_Stream:
		IsoDevice.StreamAudio();
		break;
	case Screen_Refresh:
		UpdateData(false);
	}
	
	CDialog::OnTimer(nIDEvent);
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CUSBAudioDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

void CUSBAudioDlg::OnBnClickedButton1()
{
	UINT_PTR temp;

	if(Connected == false)
	{
		if(IsoDevice.OpenUSBAudio(&m_AudioData) == STATUS_OK)
		{
			Connected = true;
			temp = SetTimer(Audio_Stream,Audio_Stream_Time,0);

			SetTimer(Screen_Refresh,Screen_Refresh_Time,0);
		}
	}


	


}

void CUSBAudioDlg::OnBnClickedCancel()
{
	OnCancel();
	KillTimer(Audio_Stream);
	KillTimer(Screen_Refresh);
	IsoDevice.CloseUSBAudio();
}
