
//------------------------------------------------------------------------------
// Copyright (c) 2012 by Silicon Laboratories. 
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Silicon Laboratories End User 
// License Agreement which accompanies this distribution, and is available at
// http://developer.silabs.com/legal/version/v10/License_Agreement_v10.htm
// Original content and implementation provided by Silicon Laboratories.
//------------------------------------------------------------------------------

#ifndef __myApplication__guard__
# define __myApplication__guard__

// for profiling with a scope:
#include <SI32_PBSTD_A_Type.h>
// GPIOs for profiling with a scope:
// P2.13 r0 chan1
// P2.12 t0 chan2
// P2.11 r1 chan3
// P2.10 t1 chan4
#define SCOPE_MASK 0x00003C00
#define SCOPE_1    0x00002000
#define SCOPE_2    0x00001000
#define SCOPE_3    0x00000800
#define SCOPE_4    0x00000400
#define scope() SI32_PBSTD_A_write_pins_masked(SI32_PBSTD_2, _scope, SCOPE_MASK);  
#define probeHi(probe); {_scope |= SCOPE_##probe; scope();}
#define probeLo(probe); {_scope &= ~SCOPE_##probe; scope();}
extern uint32 _scope;

//--------------------------------------------------------------------------------
void myApplication_enter_default_mode(void);

void myApplication_enter_active_mode(void);

int myApplication_main(void);

void myApplication_initialize(void);

#endif // __myApplication__guard__

//---eof------------------------------------------------------------------------
